/***************************************************************************
                         cbase64.h  -  description
                             -------------------
    begin                : Tue Jul 09 2002
    copyright            : (C) 2002-2003 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CBASE64_H
#define CBASE64_H

/**
  *@author Mathias Küster
  *
  * Base64 encoder and decoder.
  */

#include <dclib/dcos.h>
#include <dclib/core/cstring.h>

class CByteArray;

class CBase64 {

public:
	/** */
	static void Encode( CByteArray * dst, CByteArray * src );
	/** */
	static CString Encode( CString string );
	/** */
	static unsigned long Decode( CByteArray * dst, CByteArray * src );
	/** */
	static unsigned long Decode( CByteArray * dst, CString * string );

protected:
	/** */
	CBase64();
	/** */
	~CBase64();

private:
	/** */
	static const signed char Index_64[128];
	/** */
	static const char B64Chars[64];
};

#endif
