AC_DEFUN([BB_ENABLE_DOXYGEN],
[
AC_ARG_ENABLE(doxygen,    [ --enable-doxygen    enable documentation generation with doxygen (auto)])
AC_ARG_ENABLE(dot,	      [ --enable-dot        use 'dot' to generate graphs in doxygen (auto)])
AC_ARG_ENABLE(html-docs,  [ --enable-html-docs  enable HTML generation with doxygen (yes)],               [], [enable_html_docs=yes])dnl
AC_ARG_ENABLE(latex-docs, [ --enable-latex-docs enable LaTeX documentation generation with doxygen (no)], [], [enable_latex_docs=no])dnl      

if test "x$enable_doxygen" = xno; then
	enable_doc=no
else 
	AC_PATH_PROG(DOXYGEN, doxygen, , $PATH)
	if test x$DOXYGEN = x; then
		if test "x$enable_doxygen" = xyes; then
			AC_MSG_ERROR([could not find doxygen])
		fi
		enable_doc=no
	else
		enable_doc=yes
		AC_PATH_PROG(DOT, dot, , $PATH)
	fi
fi

AM_CONDITIONAL(DOC, test x$enable_doc = xyes)
AC_PATH_PROG(DOT, dot, , $PATH)

if test "x$DOT" = x; then
	if test "x$enable_dot" = xyes; then
		AC_MSG_ERROR([could not find dot])
	fi
	enable_dot=no
else
	enable_dot=yes
fi

AC_SUBST(enable_dot)dnl
AC_SUBST(enable_html_docs)dnl
AC_SUBST(enable_latex_docs)dnl
])
