; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -instcombine < %s | FileCheck %s

define i32 @or_and_shifts1(i32 %x) {
; CHECK-LABEL: @or_and_shifts1(
; CHECK-NEXT:    [[TMP1:%.*]] = shl i32 [[X:%.*]], 3
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[TMP1]], 8
; CHECK-NEXT:    [[TMP3:%.*]] = shl i32 [[X]], 5
; CHECK-NEXT:    [[TMP4:%.*]] = and i32 [[TMP3]], 32
; CHECK-NEXT:    [[TMP5:%.*]] = or i32 [[TMP2]], [[TMP4]]
; CHECK-NEXT:    ret i32 [[TMP5]]
;
  %1 = shl i32 %x, 3
  %2 = and i32 %1, 15
  %3 = shl i32 %x, 5
  %4 = and i32 %3, 60
  %5 = or i32 %2, %4
  ret i32 %5
}

define i32 @or_and_shifts2(i32 %x) {
; CHECK-LABEL: @or_and_shifts2(
; CHECK-NEXT:    [[TMP1:%.*]] = shl i32 [[X:%.*]], 3
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[TMP1]], 896
; CHECK-NEXT:    [[TMP3:%.*]] = lshr i32 [[X]], 4
; CHECK-NEXT:    [[TMP4:%.*]] = and i32 [[TMP3]], 7
; CHECK-NEXT:    [[TMP5:%.*]] = or i32 [[TMP2]], [[TMP4]]
; CHECK-NEXT:    ret i32 [[TMP5]]
;
  %1 = shl i32 %x, 3
  %2 = and i32 %1, 896
  %3 = lshr i32 %x, 4
  %4 = and i32 %3, 7
  %5 = or i32 %2, %4
  ret i32 %5
}

define i32 @or_and_shift_shift_and(i32 %x) {
; CHECK-LABEL: @or_and_shift_shift_and(
; CHECK-NEXT:    [[TMP1:%.*]] = shl i32 [[X:%.*]], 3
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[TMP1]], 56
; CHECK-NEXT:    [[TMP3:%.*]] = shl i32 [[X]], 2
; CHECK-NEXT:    [[TMP4:%.*]] = and i32 [[TMP3]], 28
; CHECK-NEXT:    [[TMP5:%.*]] = or i32 [[TMP2]], [[TMP4]]
; CHECK-NEXT:    ret i32 [[TMP5]]
;
  %1 = and i32 %x, 7
  %2 = shl i32 %1, 3
  %3 = shl i32 %x, 2
  %4 = and i32 %3, 28
  %5 = or i32 %2, %4
  ret i32 %5
}

define i32 @multiuse1(i32 %x) {
; CHECK-LABEL: @multiuse1(
; CHECK-NEXT:    [[TMP1:%.*]] = shl i32 [[X:%.*]], 6
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[TMP1]], 384
; CHECK-NEXT:    [[TMP3:%.*]] = lshr i32 [[X]], 1
; CHECK-NEXT:    [[TMP4:%.*]] = and i32 [[TMP3]], 3
; CHECK-NEXT:    [[TMP5:%.*]] = or i32 [[TMP4]], [[TMP2]]
; CHECK-NEXT:    ret i32 [[TMP5]]
;
  %1 = and i32 %x, 2
  %2 = and i32 %x, 4
  %3 = shl nuw nsw i32 %1, 6
  %4 = lshr exact i32 %1, 1
  %5 = shl nuw nsw i32 %2, 6
  %6 = lshr exact i32 %2, 1
  %7 = or i32 %3, %5
  %8 = or i32 %4, %6
  %9 = or i32 %8, %7
  ret i32 %9
}

define i32 @multiuse2(i32 %x) {
; CHECK-LABEL: @multiuse2(
; CHECK-NEXT:    [[TMP1:%.*]] = shl i32 [[X:%.*]], 1
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[TMP1]], 12
; CHECK-NEXT:    [[TMP3:%.*]] = shl i32 [[X]], 8
; CHECK-NEXT:    [[TMP4:%.*]] = and i32 [[TMP3]], 24576
; CHECK-NEXT:    [[TMP5:%.*]] = shl i32 [[X]], 8
; CHECK-NEXT:    [[TMP6:%.*]] = and i32 [[TMP5]], 7680
; CHECK-NEXT:    [[TMP7:%.*]] = or i32 [[TMP4]], [[TMP6]]
; CHECK-NEXT:    [[TMP8:%.*]] = shl i32 [[X]], 1
; CHECK-NEXT:    [[TMP9:%.*]] = and i32 [[TMP8]], 240
; CHECK-NEXT:    [[TMP10:%.*]] = or i32 [[TMP2]], [[TMP9]]
; CHECK-NEXT:    [[TMP11:%.*]] = or i32 [[TMP7]], [[TMP10]]
; CHECK-NEXT:    ret i32 [[TMP11]]
;
  %1 = and i32 %x, 6
  %2 = shl nuw nsw i32 %1, 8
  %3 = shl nuw nsw i32 %1, 1
  %4 = and i32 %x, 24
  %5 = shl nuw nsw i32 %4, 8
  %6 = shl nuw nsw i32 %4, 1
  %7 = and i32 %x, 96
  %8 = shl nuw nsw i32 %7, 8
  %9 = shl nuw nsw i32 %7, 1
  %10 = or i32 %2, %5
  %11 = or i32 %8, %10
  %12 = or i32 %9, %6
  %13 = or i32 %3, %12
  %14 = or i32 %11, %13
  ret i32 %14
}

define i32 @multiuse3(i32 %x) {
; CHECK-LABEL: @multiuse3(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], 96
; CHECK-NEXT:    [[TMP2:%.*]] = shl nuw nsw i32 [[TMP1]], 6
; CHECK-NEXT:    [[TMP3:%.*]] = lshr exact i32 [[TMP1]], 1
; CHECK-NEXT:    [[TMP4:%.*]] = shl i32 [[X]], 6
; CHECK-NEXT:    [[TMP5:%.*]] = and i32 [[TMP4]], 1920
; CHECK-NEXT:    [[TMP6:%.*]] = or i32 [[TMP2]], [[TMP5]]
; CHECK-NEXT:    [[TMP7:%.*]] = lshr i32 [[X]], 1
; CHECK-NEXT:    [[TMP8:%.*]] = and i32 [[TMP7]], 15
; CHECK-NEXT:    [[TMP9:%.*]] = or i32 [[TMP3]], [[TMP8]]
; CHECK-NEXT:    [[TMP10:%.*]] = or i32 [[TMP9]], [[TMP6]]
; CHECK-NEXT:    ret i32 [[TMP10]]
;
  %1 = and i32 %x, 96
  %2 = shl nuw nsw i32 %1, 6
  %3 = lshr exact i32 %1, 1
  %4 = shl i32 %x, 6
  %5 = and i32 %4, 1920
  %6 = or i32 %2, %5
  %7 = lshr i32 %x, 1
  %8 = and i32 %7, 15
  %9 = or i32 %3, %8
  %10 = or i32 %9, %6
  ret i32 %10
}

define i32 @multiuse4(i32 %x) local_unnamed_addr #0 {
; CHECK-LABEL: @multiuse4(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], 100663296
; CHECK-NEXT:    [[TMP2:%.*]] = icmp sgt i32 [[X]], -1
; CHECK-NEXT:    br i1 [[TMP2]], label [[IF:%.*]], label [[ELSE:%.*]]
; CHECK:       if:
; CHECK-NEXT:    [[TMP3:%.*]] = lshr exact i32 [[TMP1]], 22
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[X]], 22
; CHECK-NEXT:    [[TMP5:%.*]] = and i32 [[TMP4]], 480
; CHECK-NEXT:    [[TMP6:%.*]] = or i32 [[TMP5]], [[TMP3]]
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[TMP7:%.*]] = lshr exact i32 [[TMP1]], 17
; CHECK-NEXT:    [[TMP8:%.*]] = lshr i32 [[X]], 17
; CHECK-NEXT:    [[TMP9:%.*]] = and i32 [[TMP8]], 15360
; CHECK-NEXT:    [[TMP10:%.*]] = or i32 [[TMP9]], [[TMP7]]
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[TMP11:%.*]] = phi i32 [ [[TMP6]], [[IF]] ], [ [[TMP10]], [[ELSE]] ]
; CHECK-NEXT:    ret i32 [[TMP11]]
;
  %1 = and i32 %x, 100663296
  %2 = icmp sgt i32 %x, -1
  br i1 %2, label %if, label %else

if:
  %3 = lshr exact i32 %1, 22
  %4 = lshr i32 %x, 22
  %5 = and i32 %4, 480
  %6 = or i32 %5, %3
  br label %end

else:
  %7 = lshr exact i32 %1, 17
  %8 = lshr i32 %x, 17
  %9 = and i32 %8, 15360
  %10 = or i32 %9, %7
  br label %end

end:
  %11 = phi i32 [ %6, %if ], [ %10, %else ]
  ret i32 %11
}

define i32 @multiuse5(i32 %x) local_unnamed_addr #0 {
; CHECK-LABEL: @multiuse5(
; CHECK-NEXT:    [[TMP1:%.*]] = shl i32 [[X:%.*]], 5
; CHECK-NEXT:    [[TMP2:%.*]] = icmp sgt i32 [[X]], -1
; CHECK-NEXT:    br i1 [[TMP2]], label [[IF:%.*]], label [[ELSE:%.*]]
; CHECK:       if:
; CHECK-NEXT:    [[TMP3:%.*]] = and i32 [[TMP1]], 21760
; CHECK-NEXT:    [[TMP4:%.*]] = shl i32 [[X]], 5
; CHECK-NEXT:    [[TMP5:%.*]] = and i32 [[TMP4]], 43520
; CHECK-NEXT:    [[TMP6:%.*]] = or i32 [[TMP5]], [[TMP3]]
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[TMP7:%.*]] = and i32 [[TMP1]], 5570560
; CHECK-NEXT:    [[TMP8:%.*]] = shl i32 [[X]], 5
; CHECK-NEXT:    [[TMP9:%.*]] = and i32 [[TMP8]], 11141120
; CHECK-NEXT:    [[TMP10:%.*]] = or i32 [[TMP9]], [[TMP7]]
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[TMP11:%.*]] = phi i32 [ [[TMP6]], [[IF]] ], [ [[TMP10]], [[ELSE]] ]
; CHECK-NEXT:    ret i32 [[TMP11]]
;
  %1 = shl i32 %x, 5
  %2 = icmp sgt i32 %x, -1
  br i1 %2, label %if, label %else

if:
  %3 = and i32 %1, 21760
  %4 = and i32 %x, 1360
  %5 = shl nuw nsw i32 %4, 5
  %6 = or i32 %5, %3
  br label %end

else:
  %7 = and i32 %1, 5570560
  %8 = and i32 %x, 348160
  %9 = shl nuw nsw i32 %8, 5
  %10 = or i32 %9, %7
  br label %end

end:
  %11 = phi i32 [ %6, %if ], [ %10, %else ]
  ret i32 %11
}

define i32 @shl_mask(i32 %x) {
; CHECK-LABEL: @shl_mask(
; CHECK-NEXT:    [[Z:%.*]] = and i32 [[X:%.*]], 255
; CHECK-NEXT:    [[S:%.*]] = shl nuw nsw i32 [[Z]], 8
; CHECK-NEXT:    [[R:%.*]] = or i32 [[Z]], [[S]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %z = and i32 %x, 255
  %s = shl i32 %z, 8
  %r = or i32 %z, %s
  ret i32 %r
}

define i32 @shl_mask_wrong_shl_const(i32 %x) {
; CHECK-LABEL: @shl_mask_wrong_shl_const(
; CHECK-NEXT:    [[Z:%.*]] = and i32 [[X:%.*]], 255
; CHECK-NEXT:    [[S:%.*]] = shl nuw nsw i32 [[Z]], 7
; CHECK-NEXT:    [[R:%.*]] = or i32 [[Z]], [[S]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %z = and i32 %x, 255
  %s = shl i32 %z, 7
  %r = or i32 %z, %s
  ret i32 %r
}

define i37 @shl_mask_weird_type(i37 %x) {
; CHECK-LABEL: @shl_mask_weird_type(
; CHECK-NEXT:    [[Z:%.*]] = and i37 [[X:%.*]], 255
; CHECK-NEXT:    [[S:%.*]] = shl nuw nsw i37 [[Z]], 8
; CHECK-NEXT:    [[R:%.*]] = or i37 [[Z]], [[S]]
; CHECK-NEXT:    ret i37 [[R]]
;
  %z = and i37 %x, 255
  %s = shl i37 %z, 8
  %r = or i37 %z, %s
  ret i37 %r
}

define i32 @shl_mask_extra_use(i32 %x, i32* %p) {
; CHECK-LABEL: @shl_mask_extra_use(
; CHECK-NEXT:    [[Z:%.*]] = and i32 [[X:%.*]], 255
; CHECK-NEXT:    [[S:%.*]] = shl nuw nsw i32 [[Z]], 8
; CHECK-NEXT:    store i32 [[S]], i32* [[P:%.*]], align 4
; CHECK-NEXT:    [[R:%.*]] = or i32 [[Z]], [[S]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %z = and i32 %x, 255
  %s = shl i32 %z, 8
  store i32 %s, i32* %p
  %r = or i32 %z, %s
  ret i32 %r
}

; This could be "Z * 65793".

define i32 @shl_mul_mask(i32 %x) {
; CHECK-LABEL: @shl_mul_mask(
; CHECK-NEXT:    [[Z:%.*]] = and i32 [[X:%.*]], 255
; CHECK-NEXT:    [[M:%.*]] = mul nuw nsw i32 [[Z]], 65537
; CHECK-NEXT:    [[S:%.*]] = shl nuw nsw i32 [[Z]], 8
; CHECK-NEXT:    [[R:%.*]] = or i32 [[M]], [[S]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %z = and i32 %x, 255
  %m = mul i32 %z, 65537
  %s = shl i32 %z, 8
  %r = or i32 %m, %s
  ret i32 %r
}

define i32 @shl_mul_mask_wrong_mul_const(i32 %x) {
; CHECK-LABEL: @shl_mul_mask_wrong_mul_const(
; CHECK-NEXT:    [[Z:%.*]] = and i32 [[X:%.*]], 255
; CHECK-NEXT:    [[M:%.*]] = mul nuw nsw i32 [[Z]], 65535
; CHECK-NEXT:    [[S:%.*]] = shl nuw nsw i32 [[Z]], 8
; CHECK-NEXT:    [[R:%.*]] = or i32 [[M]], [[S]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %z = and i32 %x, 255
  %m = mul i32 %z, 65535
  %s = shl i32 %z, 8
  %r = or i32 %m, %s
  ret i32 %r
}
