; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -verify -iroutliner -ir-outlining-no-cost < %s | FileCheck %s

; This test looks at instances of constants in the different regions. If there
; is a register in the same place as a constant in a similar region of code, we
; do not outline those regions.

; The first function tests that we do not outline with the register is
; seen first, and the second function checks that we do not outline when the
; constant is seen first.

define void @function_registers_first(i32 %0, i32 %1, i32 %2) {
; CHECK-LABEL: @function_registers_first(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[B:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[C:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @outlined_ir_func_1(i32 [[TMP0:%.*]], i32* [[A]], i32 [[TMP1:%.*]], i32* [[B]], i32 [[TMP2:%.*]], i32* [[C]])
; CHECK-NEXT:    ret void
; CHECK:       next:
; CHECK-NEXT:    call void @outlined_ir_func_1(i32 2, i32* [[A]], i32 3, i32* [[B]], i32 4, i32* [[C]])
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i32, align 4
  %b = alloca i32, align 4
  %c = alloca i32, align 4
  store i32 %0, i32* %a, align 4
  store i32 %1, i32* %b, align 4
  store i32 %2, i32* %c, align 4
  ret void
next:
  store i32 2, i32* %a, align 4
  store i32 3, i32* %b, align 4
  store i32 4, i32* %c, align 4
  ret void
}

define void @function_with_constants_first(i32 %0, i32 %1, i32 %2) {
; CHECK-LABEL: @function_with_constants_first(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[B:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[C:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[AL:%.*]] = load i32, i32* [[A]], align 4
; CHECK-NEXT:    [[BL:%.*]] = load i32, i32* [[B]], align 4
; CHECK-NEXT:    [[CL:%.*]] = load i32, i32* [[C]], align 4
; CHECK-NEXT:    call void @outlined_ir_func_0(i32 2, i32 [[AL]], i32 3, i32 [[BL]], i32 4, i32 [[CL]])
; CHECK-NEXT:    ret void
; CHECK:       next:
; CHECK-NEXT:    call void @outlined_ir_func_0(i32 [[TMP0:%.*]], i32 [[AL]], i32 [[TMP1:%.*]], i32 [[BL]], i32 [[TMP2:%.*]], i32 [[CL]])
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i32, align 4
  %b = alloca i32, align 4
  %c = alloca i32, align 4
  %al = load i32, i32* %a
  %bl = load i32, i32* %b
  %cl = load i32, i32* %c
  %3 = add i32 2, %al
  %4 = add i32 3, %bl
  %5 = add i32 4, %cl
  ret void
next:
  %6 = add i32 %0, %al
  %7 = add i32 %1, %bl
  %8 = add i32 %2, %cl
  ret void
}

; CHECK: define internal void @outlined_ir_func_0(i32 [[ARG0:%.*]], i32 [[ARG1:%.*]], i32 [[ARG2:%.*]], i32 [[ARG3:%.*]], i32 [[ARG4:%.*]], i32 [[ARG5:%.*]])
; CHECK: entry_to_outline:
; CHECK-NEXT: add i32 [[ARG0]], [[ARG1]]
; CHECK-NEXT: add i32 [[ARG2]], [[ARG3]]
; CHECK-NEXT: add i32 [[ARG4]], [[ARG5]]

; CHECK: define internal void @outlined_ir_func_1(i32 [[ARG0:%.*]], i32* [[ARG1:%.*]], i32 [[ARG2:%.*]], i32* [[ARG3:%.*]], i32 [[ARG4:%.*]], i32* [[ARG5:%.*]])
; CHECK: entry_to_outline:
; CHECK-NEXT: store i32 [[ARG0]], i32* [[ARG1]]
; CHECK-NEXT: store i32 [[ARG2]], i32* [[ARG3]]
; CHECK-NEXT: store i32 [[ARG4]], i32* [[ARG5]]
