; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=amdgcn -mcpu=gfx900 --amdhsa-code-object-version=2 -verify-machineinstrs < %s | FileCheck --check-prefix=NOHSA-TRAP-GFX900-V2 %s
; RUN: llc -march=amdgcn -mcpu=gfx900 --amdhsa-code-object-version=3 -verify-machineinstrs < %s | FileCheck --check-prefix=NOHSA-TRAP-GFX900-V3 %s
; RUN: llc -march=amdgcn -mcpu=gfx900 --amdhsa-code-object-version=4 -verify-machineinstrs < %s | FileCheck --check-prefix=NOHSA-TRAP-GFX900-V4 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx803 --amdhsa-code-object-version=2 -verify-machineinstrs < %s | FileCheck --check-prefix=HSA-TRAP-GFX803-V2 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx803 --amdhsa-code-object-version=3 -verify-machineinstrs < %s | FileCheck --check-prefix=HSA-TRAP-GFX803-V3 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx803 --amdhsa-code-object-version=4 -verify-machineinstrs < %s | FileCheck --check-prefix=HSA-TRAP-GFX803-V4 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 --amdhsa-code-object-version=2 -verify-machineinstrs < %s | FileCheck --check-prefix=HSA-TRAP-GFX900-V2 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 --amdhsa-code-object-version=3 -verify-machineinstrs < %s | FileCheck --check-prefix=HSA-TRAP-GFX900-V3 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 --amdhsa-code-object-version=4 -verify-machineinstrs < %s | FileCheck --check-prefix=HSA-TRAP-GFX900-V4 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -mattr=-trap-handler --amdhsa-code-object-version=2 -verify-machineinstrs < %s | FileCheck --check-prefix=HSA-NOTRAP-GFX900-V2 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -mattr=-trap-handler --amdhsa-code-object-version=3 -verify-machineinstrs < %s | FileCheck --check-prefix=HSA-NOTRAP-GFX900-V3 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -mattr=-trap-handler --amdhsa-code-object-version=4 -verify-machineinstrs < %s | FileCheck --check-prefix=HSA-NOTRAP-GFX900-V4 %s

declare void @llvm.trap() #0
declare void @llvm.debugtrap() #1

define amdgpu_kernel void @trap(i32 addrspace(1)* nocapture readonly %arg0) {
; NOHSA-TRAP-GFX900-V2-LABEL: trap:
; NOHSA-TRAP-GFX900-V2:       ; %bb.0:
; NOHSA-TRAP-GFX900-V2-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; NOHSA-TRAP-GFX900-V2-NEXT:    v_mov_b32_e32 v0, 0
; NOHSA-TRAP-GFX900-V2-NEXT:    v_mov_b32_e32 v1, 1
; NOHSA-TRAP-GFX900-V2-NEXT:    s_waitcnt lgkmcnt(0)
; NOHSA-TRAP-GFX900-V2-NEXT:    global_store_dword v0, v1, s[0:1]
; NOHSA-TRAP-GFX900-V2-NEXT:    s_waitcnt vmcnt(0)
; NOHSA-TRAP-GFX900-V2-NEXT:    s_endpgm
;
; NOHSA-TRAP-GFX900-V3-LABEL: trap:
; NOHSA-TRAP-GFX900-V3:       ; %bb.0:
; NOHSA-TRAP-GFX900-V3-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; NOHSA-TRAP-GFX900-V3-NEXT:    v_mov_b32_e32 v0, 0
; NOHSA-TRAP-GFX900-V3-NEXT:    v_mov_b32_e32 v1, 1
; NOHSA-TRAP-GFX900-V3-NEXT:    s_waitcnt lgkmcnt(0)
; NOHSA-TRAP-GFX900-V3-NEXT:    global_store_dword v0, v1, s[0:1]
; NOHSA-TRAP-GFX900-V3-NEXT:    s_waitcnt vmcnt(0)
; NOHSA-TRAP-GFX900-V3-NEXT:    s_endpgm
;
; NOHSA-TRAP-GFX900-V4-LABEL: trap:
; NOHSA-TRAP-GFX900-V4:       ; %bb.0:
; NOHSA-TRAP-GFX900-V4-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; NOHSA-TRAP-GFX900-V4-NEXT:    v_mov_b32_e32 v0, 0
; NOHSA-TRAP-GFX900-V4-NEXT:    v_mov_b32_e32 v1, 1
; NOHSA-TRAP-GFX900-V4-NEXT:    s_waitcnt lgkmcnt(0)
; NOHSA-TRAP-GFX900-V4-NEXT:    global_store_dword v0, v1, s[0:1]
; NOHSA-TRAP-GFX900-V4-NEXT:    s_waitcnt vmcnt(0)
; NOHSA-TRAP-GFX900-V4-NEXT:    s_endpgm
;
; HSA-TRAP-GFX803-V2-LABEL: trap:
; HSA-TRAP-GFX803-V2:         .amd_kernel_code_t
; HSA-TRAP-GFX803-V2-NEXT:     amd_code_version_major = 1
; HSA-TRAP-GFX803-V2-NEXT:     amd_code_version_minor = 2
; HSA-TRAP-GFX803-V2-NEXT:     amd_machine_kind = 1
; HSA-TRAP-GFX803-V2-NEXT:     amd_machine_version_major = 8
; HSA-TRAP-GFX803-V2-NEXT:     amd_machine_version_minor = 0
; HSA-TRAP-GFX803-V2-NEXT:     amd_machine_version_stepping = 3
; HSA-TRAP-GFX803-V2-NEXT:     kernel_code_entry_byte_offset = 256
; HSA-TRAP-GFX803-V2-NEXT:     kernel_code_prefetch_byte_size = 0
; HSA-TRAP-GFX803-V2-NEXT:     granulated_workitem_vgpr_count = 0
; HSA-TRAP-GFX803-V2-NEXT:     granulated_wavefront_sgpr_count = 0
; HSA-TRAP-GFX803-V2-NEXT:     priority = 0
; HSA-TRAP-GFX803-V2-NEXT:     float_mode = 240
; HSA-TRAP-GFX803-V2-NEXT:     priv = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_dx10_clamp = 1
; HSA-TRAP-GFX803-V2-NEXT:     debug_mode = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_ieee_mode = 1
; HSA-TRAP-GFX803-V2-NEXT:     enable_wgp_mode = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_mem_ordered = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_fwd_progress = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_private_segment_wave_byte_offset = 0
; HSA-TRAP-GFX803-V2-NEXT:     user_sgpr_count = 8
; HSA-TRAP-GFX803-V2-NEXT:     enable_trap_handler = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_workgroup_id_x = 1
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_workgroup_id_y = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_workgroup_id_z = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_workgroup_info = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_vgpr_workitem_id = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_exception_msb = 0
; HSA-TRAP-GFX803-V2-NEXT:     granulated_lds_size = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_exception = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_private_segment_buffer = 1
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_dispatch_ptr = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_queue_ptr = 1
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_kernarg_segment_ptr = 1
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_dispatch_id = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_flat_scratch_init = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_private_segment_size = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_grid_workgroup_count_x = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_grid_workgroup_count_y = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_grid_workgroup_count_z = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_wavefront_size32 = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_ordered_append_gds = 0
; HSA-TRAP-GFX803-V2-NEXT:     private_element_size = 1
; HSA-TRAP-GFX803-V2-NEXT:     is_ptr64 = 1
; HSA-TRAP-GFX803-V2-NEXT:     is_dynamic_callstack = 0
; HSA-TRAP-GFX803-V2-NEXT:     is_debug_enabled = 0
; HSA-TRAP-GFX803-V2-NEXT:     is_xnack_enabled = 0
; HSA-TRAP-GFX803-V2-NEXT:     workitem_private_segment_byte_size = 0
; HSA-TRAP-GFX803-V2-NEXT:     workgroup_group_segment_byte_size = 0
; HSA-TRAP-GFX803-V2-NEXT:     gds_segment_byte_size = 0
; HSA-TRAP-GFX803-V2-NEXT:     kernarg_segment_byte_size = 8
; HSA-TRAP-GFX803-V2-NEXT:     workgroup_fbarrier_count = 0
; HSA-TRAP-GFX803-V2-NEXT:     wavefront_sgpr_count = 8
; HSA-TRAP-GFX803-V2-NEXT:     workitem_vgpr_count = 3
; HSA-TRAP-GFX803-V2-NEXT:     reserved_vgpr_first = 0
; HSA-TRAP-GFX803-V2-NEXT:     reserved_vgpr_count = 0
; HSA-TRAP-GFX803-V2-NEXT:     reserved_sgpr_first = 0
; HSA-TRAP-GFX803-V2-NEXT:     reserved_sgpr_count = 0
; HSA-TRAP-GFX803-V2-NEXT:     debug_wavefront_private_segment_offset_sgpr = 0
; HSA-TRAP-GFX803-V2-NEXT:     debug_private_segment_buffer_sgpr = 0
; HSA-TRAP-GFX803-V2-NEXT:     kernarg_segment_alignment = 4
; HSA-TRAP-GFX803-V2-NEXT:     group_segment_alignment = 4
; HSA-TRAP-GFX803-V2-NEXT:     private_segment_alignment = 4
; HSA-TRAP-GFX803-V2-NEXT:     wavefront_size = 6
; HSA-TRAP-GFX803-V2-NEXT:     call_convention = -1
; HSA-TRAP-GFX803-V2-NEXT:     runtime_loader_kernel_symbol = 0
; HSA-TRAP-GFX803-V2-NEXT:    .end_amd_kernel_code_t
; HSA-TRAP-GFX803-V2-NEXT:  ; %bb.0:
; HSA-TRAP-GFX803-V2-NEXT:    s_load_dwordx2 s[2:3], s[6:7], 0x0
; HSA-TRAP-GFX803-V2-NEXT:    v_mov_b32_e32 v2, 1
; HSA-TRAP-GFX803-V2-NEXT:    s_mov_b64 s[0:1], s[4:5]
; HSA-TRAP-GFX803-V2-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-TRAP-GFX803-V2-NEXT:    v_mov_b32_e32 v0, s2
; HSA-TRAP-GFX803-V2-NEXT:    v_mov_b32_e32 v1, s3
; HSA-TRAP-GFX803-V2-NEXT:    flat_store_dword v[0:1], v2
; HSA-TRAP-GFX803-V2-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX803-V2-NEXT:    s_trap 2
;
; HSA-TRAP-GFX803-V3-LABEL: trap:
; HSA-TRAP-GFX803-V3:       ; %bb.0:
; HSA-TRAP-GFX803-V3-NEXT:    s_load_dwordx2 s[2:3], s[6:7], 0x0
; HSA-TRAP-GFX803-V3-NEXT:    v_mov_b32_e32 v2, 1
; HSA-TRAP-GFX803-V3-NEXT:    s_mov_b64 s[0:1], s[4:5]
; HSA-TRAP-GFX803-V3-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-TRAP-GFX803-V3-NEXT:    v_mov_b32_e32 v0, s2
; HSA-TRAP-GFX803-V3-NEXT:    v_mov_b32_e32 v1, s3
; HSA-TRAP-GFX803-V3-NEXT:    flat_store_dword v[0:1], v2
; HSA-TRAP-GFX803-V3-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX803-V3-NEXT:    s_trap 2
;
; HSA-TRAP-GFX803-V4-LABEL: trap:
; HSA-TRAP-GFX803-V4:       ; %bb.0:
; HSA-TRAP-GFX803-V4-NEXT:    s_load_dwordx2 s[2:3], s[6:7], 0x0
; HSA-TRAP-GFX803-V4-NEXT:    v_mov_b32_e32 v2, 1
; HSA-TRAP-GFX803-V4-NEXT:    s_mov_b64 s[0:1], s[4:5]
; HSA-TRAP-GFX803-V4-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-TRAP-GFX803-V4-NEXT:    v_mov_b32_e32 v0, s2
; HSA-TRAP-GFX803-V4-NEXT:    v_mov_b32_e32 v1, s3
; HSA-TRAP-GFX803-V4-NEXT:    flat_store_dword v[0:1], v2
; HSA-TRAP-GFX803-V4-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX803-V4-NEXT:    s_trap 2
;
; HSA-TRAP-GFX900-V2-LABEL: trap:
; HSA-TRAP-GFX900-V2:         .amd_kernel_code_t
; HSA-TRAP-GFX900-V2-NEXT:     amd_code_version_major = 1
; HSA-TRAP-GFX900-V2-NEXT:     amd_code_version_minor = 2
; HSA-TRAP-GFX900-V2-NEXT:     amd_machine_kind = 1
; HSA-TRAP-GFX900-V2-NEXT:     amd_machine_version_major = 9
; HSA-TRAP-GFX900-V2-NEXT:     amd_machine_version_minor = 0
; HSA-TRAP-GFX900-V2-NEXT:     amd_machine_version_stepping = 0
; HSA-TRAP-GFX900-V2-NEXT:     kernel_code_entry_byte_offset = 256
; HSA-TRAP-GFX900-V2-NEXT:     kernel_code_prefetch_byte_size = 0
; HSA-TRAP-GFX900-V2-NEXT:     granulated_workitem_vgpr_count = 0
; HSA-TRAP-GFX900-V2-NEXT:     granulated_wavefront_sgpr_count = 0
; HSA-TRAP-GFX900-V2-NEXT:     priority = 0
; HSA-TRAP-GFX900-V2-NEXT:     float_mode = 240
; HSA-TRAP-GFX900-V2-NEXT:     priv = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_dx10_clamp = 1
; HSA-TRAP-GFX900-V2-NEXT:     debug_mode = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_ieee_mode = 1
; HSA-TRAP-GFX900-V2-NEXT:     enable_wgp_mode = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_mem_ordered = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_fwd_progress = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_private_segment_wave_byte_offset = 0
; HSA-TRAP-GFX900-V2-NEXT:     user_sgpr_count = 8
; HSA-TRAP-GFX900-V2-NEXT:     enable_trap_handler = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_id_x = 1
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_id_y = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_id_z = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_info = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_vgpr_workitem_id = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_exception_msb = 0
; HSA-TRAP-GFX900-V2-NEXT:     granulated_lds_size = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_exception = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_private_segment_buffer = 1
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_dispatch_ptr = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_queue_ptr = 1
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_kernarg_segment_ptr = 1
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_dispatch_id = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_flat_scratch_init = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_private_segment_size = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_grid_workgroup_count_x = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_grid_workgroup_count_y = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_grid_workgroup_count_z = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_wavefront_size32 = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_ordered_append_gds = 0
; HSA-TRAP-GFX900-V2-NEXT:     private_element_size = 1
; HSA-TRAP-GFX900-V2-NEXT:     is_ptr64 = 1
; HSA-TRAP-GFX900-V2-NEXT:     is_dynamic_callstack = 0
; HSA-TRAP-GFX900-V2-NEXT:     is_debug_enabled = 0
; HSA-TRAP-GFX900-V2-NEXT:     is_xnack_enabled = 1
; HSA-TRAP-GFX900-V2-NEXT:     workitem_private_segment_byte_size = 0
; HSA-TRAP-GFX900-V2-NEXT:     workgroup_group_segment_byte_size = 0
; HSA-TRAP-GFX900-V2-NEXT:     gds_segment_byte_size = 0
; HSA-TRAP-GFX900-V2-NEXT:     kernarg_segment_byte_size = 8
; HSA-TRAP-GFX900-V2-NEXT:     workgroup_fbarrier_count = 0
; HSA-TRAP-GFX900-V2-NEXT:     wavefront_sgpr_count = 8
; HSA-TRAP-GFX900-V2-NEXT:     workitem_vgpr_count = 2
; HSA-TRAP-GFX900-V2-NEXT:     reserved_vgpr_first = 0
; HSA-TRAP-GFX900-V2-NEXT:     reserved_vgpr_count = 0
; HSA-TRAP-GFX900-V2-NEXT:     reserved_sgpr_first = 0
; HSA-TRAP-GFX900-V2-NEXT:     reserved_sgpr_count = 0
; HSA-TRAP-GFX900-V2-NEXT:     debug_wavefront_private_segment_offset_sgpr = 0
; HSA-TRAP-GFX900-V2-NEXT:     debug_private_segment_buffer_sgpr = 0
; HSA-TRAP-GFX900-V2-NEXT:     kernarg_segment_alignment = 4
; HSA-TRAP-GFX900-V2-NEXT:     group_segment_alignment = 4
; HSA-TRAP-GFX900-V2-NEXT:     private_segment_alignment = 4
; HSA-TRAP-GFX900-V2-NEXT:     wavefront_size = 6
; HSA-TRAP-GFX900-V2-NEXT:     call_convention = -1
; HSA-TRAP-GFX900-V2-NEXT:     runtime_loader_kernel_symbol = 0
; HSA-TRAP-GFX900-V2-NEXT:    .end_amd_kernel_code_t
; HSA-TRAP-GFX900-V2-NEXT:  ; %bb.0:
; HSA-TRAP-GFX900-V2-NEXT:    s_load_dwordx2 s[2:3], s[6:7], 0x0
; HSA-TRAP-GFX900-V2-NEXT:    v_mov_b32_e32 v0, 0
; HSA-TRAP-GFX900-V2-NEXT:    v_mov_b32_e32 v1, 1
; HSA-TRAP-GFX900-V2-NEXT:    s_mov_b64 s[0:1], s[4:5]
; HSA-TRAP-GFX900-V2-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-TRAP-GFX900-V2-NEXT:    global_store_dword v0, v1, s[2:3]
; HSA-TRAP-GFX900-V2-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX900-V2-NEXT:    s_trap 2
;
; HSA-TRAP-GFX900-V3-LABEL: trap:
; HSA-TRAP-GFX900-V3:       ; %bb.0:
; HSA-TRAP-GFX900-V3-NEXT:    s_load_dwordx2 s[2:3], s[6:7], 0x0
; HSA-TRAP-GFX900-V3-NEXT:    v_mov_b32_e32 v0, 0
; HSA-TRAP-GFX900-V3-NEXT:    v_mov_b32_e32 v1, 1
; HSA-TRAP-GFX900-V3-NEXT:    s_mov_b64 s[0:1], s[4:5]
; HSA-TRAP-GFX900-V3-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-TRAP-GFX900-V3-NEXT:    global_store_dword v0, v1, s[2:3]
; HSA-TRAP-GFX900-V3-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX900-V3-NEXT:    s_trap 2
;
; HSA-TRAP-GFX900-V4-LABEL: trap:
; HSA-TRAP-GFX900-V4:       ; %bb.0:
; HSA-TRAP-GFX900-V4-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-TRAP-GFX900-V4-NEXT:    v_mov_b32_e32 v0, 0
; HSA-TRAP-GFX900-V4-NEXT:    v_mov_b32_e32 v1, 1
; HSA-TRAP-GFX900-V4-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-TRAP-GFX900-V4-NEXT:    global_store_dword v0, v1, s[0:1]
; HSA-TRAP-GFX900-V4-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX900-V4-NEXT:    s_trap 2
;
; HSA-NOTRAP-GFX900-V2-LABEL: trap:
; HSA-NOTRAP-GFX900-V2:         .amd_kernel_code_t
; HSA-NOTRAP-GFX900-V2-NEXT:     amd_code_version_major = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     amd_code_version_minor = 2
; HSA-NOTRAP-GFX900-V2-NEXT:     amd_machine_kind = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     amd_machine_version_major = 9
; HSA-NOTRAP-GFX900-V2-NEXT:     amd_machine_version_minor = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     amd_machine_version_stepping = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     kernel_code_entry_byte_offset = 256
; HSA-NOTRAP-GFX900-V2-NEXT:     kernel_code_prefetch_byte_size = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     granulated_workitem_vgpr_count = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     granulated_wavefront_sgpr_count = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     priority = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     float_mode = 240
; HSA-NOTRAP-GFX900-V2-NEXT:     priv = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_dx10_clamp = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     debug_mode = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_ieee_mode = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_wgp_mode = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_mem_ordered = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_fwd_progress = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_private_segment_wave_byte_offset = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     user_sgpr_count = 8
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_trap_handler = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_id_x = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_id_y = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_id_z = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_info = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_vgpr_workitem_id = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_exception_msb = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     granulated_lds_size = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_exception = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_private_segment_buffer = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_dispatch_ptr = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_queue_ptr = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_kernarg_segment_ptr = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_dispatch_id = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_flat_scratch_init = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_private_segment_size = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_grid_workgroup_count_x = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_grid_workgroup_count_y = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_grid_workgroup_count_z = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_wavefront_size32 = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_ordered_append_gds = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     private_element_size = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     is_ptr64 = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     is_dynamic_callstack = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     is_debug_enabled = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     is_xnack_enabled = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     workitem_private_segment_byte_size = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     workgroup_group_segment_byte_size = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     gds_segment_byte_size = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     kernarg_segment_byte_size = 8
; HSA-NOTRAP-GFX900-V2-NEXT:     workgroup_fbarrier_count = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     wavefront_sgpr_count = 8
; HSA-NOTRAP-GFX900-V2-NEXT:     workitem_vgpr_count = 2
; HSA-NOTRAP-GFX900-V2-NEXT:     reserved_vgpr_first = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     reserved_vgpr_count = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     reserved_sgpr_first = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     reserved_sgpr_count = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     debug_wavefront_private_segment_offset_sgpr = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     debug_private_segment_buffer_sgpr = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     kernarg_segment_alignment = 4
; HSA-NOTRAP-GFX900-V2-NEXT:     group_segment_alignment = 4
; HSA-NOTRAP-GFX900-V2-NEXT:     private_segment_alignment = 4
; HSA-NOTRAP-GFX900-V2-NEXT:     wavefront_size = 6
; HSA-NOTRAP-GFX900-V2-NEXT:     call_convention = -1
; HSA-NOTRAP-GFX900-V2-NEXT:     runtime_loader_kernel_symbol = 0
; HSA-NOTRAP-GFX900-V2-NEXT:    .end_amd_kernel_code_t
; HSA-NOTRAP-GFX900-V2-NEXT:  ; %bb.0:
; HSA-NOTRAP-GFX900-V2-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-NOTRAP-GFX900-V2-NEXT:    v_mov_b32_e32 v0, 0
; HSA-NOTRAP-GFX900-V2-NEXT:    v_mov_b32_e32 v1, 1
; HSA-NOTRAP-GFX900-V2-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-NOTRAP-GFX900-V2-NEXT:    global_store_dword v0, v1, s[0:1]
; HSA-NOTRAP-GFX900-V2-NEXT:    s_waitcnt vmcnt(0)
; HSA-NOTRAP-GFX900-V2-NEXT:    s_endpgm
;
; HSA-NOTRAP-GFX900-V3-LABEL: trap:
; HSA-NOTRAP-GFX900-V3:       ; %bb.0:
; HSA-NOTRAP-GFX900-V3-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-NOTRAP-GFX900-V3-NEXT:    v_mov_b32_e32 v0, 0
; HSA-NOTRAP-GFX900-V3-NEXT:    v_mov_b32_e32 v1, 1
; HSA-NOTRAP-GFX900-V3-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-NOTRAP-GFX900-V3-NEXT:    global_store_dword v0, v1, s[0:1]
; HSA-NOTRAP-GFX900-V3-NEXT:    s_waitcnt vmcnt(0)
; HSA-NOTRAP-GFX900-V3-NEXT:    s_endpgm
;
; HSA-NOTRAP-GFX900-V4-LABEL: trap:
; HSA-NOTRAP-GFX900-V4:       ; %bb.0:
; HSA-NOTRAP-GFX900-V4-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-NOTRAP-GFX900-V4-NEXT:    v_mov_b32_e32 v0, 0
; HSA-NOTRAP-GFX900-V4-NEXT:    v_mov_b32_e32 v1, 1
; HSA-NOTRAP-GFX900-V4-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-NOTRAP-GFX900-V4-NEXT:    global_store_dword v0, v1, s[0:1]
; HSA-NOTRAP-GFX900-V4-NEXT:    s_waitcnt vmcnt(0)
; HSA-NOTRAP-GFX900-V4-NEXT:    s_endpgm
  store volatile i32 1, i32 addrspace(1)* %arg0
  call void @llvm.trap()
  unreachable
  store volatile i32 2, i32 addrspace(1)* %arg0
  ret void
}

define amdgpu_kernel void @non_entry_trap(i32 addrspace(1)* nocapture readonly %arg0) local_unnamed_addr {
; NOHSA-TRAP-GFX900-V2-LABEL: non_entry_trap:
; NOHSA-TRAP-GFX900-V2:       ; %bb.0: ; %entry
; NOHSA-TRAP-GFX900-V2-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; NOHSA-TRAP-GFX900-V2-NEXT:    v_mov_b32_e32 v0, 0
; NOHSA-TRAP-GFX900-V2-NEXT:    s_waitcnt lgkmcnt(0)
; NOHSA-TRAP-GFX900-V2-NEXT:    global_load_dword v1, v0, s[0:1] glc
; NOHSA-TRAP-GFX900-V2-NEXT:    s_waitcnt vmcnt(0)
; NOHSA-TRAP-GFX900-V2-NEXT:    v_cmp_eq_u32_e32 vcc, -1, v1
; NOHSA-TRAP-GFX900-V2-NEXT:    s_and_b64 vcc, exec, vcc
; NOHSA-TRAP-GFX900-V2-NEXT:    s_cbranch_vccz .LBB1_2
; NOHSA-TRAP-GFX900-V2-NEXT:  ; %bb.1: ; %ret
; NOHSA-TRAP-GFX900-V2-NEXT:    v_mov_b32_e32 v1, 3
; NOHSA-TRAP-GFX900-V2-NEXT:    global_store_dword v0, v1, s[0:1]
; NOHSA-TRAP-GFX900-V2-NEXT:    s_waitcnt vmcnt(0)
; NOHSA-TRAP-GFX900-V2-NEXT:    s_endpgm
; NOHSA-TRAP-GFX900-V2-NEXT:  .LBB1_2: ; %trap
; NOHSA-TRAP-GFX900-V2-NEXT:    s_endpgm
;
; NOHSA-TRAP-GFX900-V3-LABEL: non_entry_trap:
; NOHSA-TRAP-GFX900-V3:       ; %bb.0: ; %entry
; NOHSA-TRAP-GFX900-V3-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; NOHSA-TRAP-GFX900-V3-NEXT:    v_mov_b32_e32 v0, 0
; NOHSA-TRAP-GFX900-V3-NEXT:    s_waitcnt lgkmcnt(0)
; NOHSA-TRAP-GFX900-V3-NEXT:    global_load_dword v1, v0, s[0:1] glc
; NOHSA-TRAP-GFX900-V3-NEXT:    s_waitcnt vmcnt(0)
; NOHSA-TRAP-GFX900-V3-NEXT:    v_cmp_eq_u32_e32 vcc, -1, v1
; NOHSA-TRAP-GFX900-V3-NEXT:    s_and_b64 vcc, exec, vcc
; NOHSA-TRAP-GFX900-V3-NEXT:    s_cbranch_vccz .LBB1_2
; NOHSA-TRAP-GFX900-V3-NEXT:  ; %bb.1: ; %ret
; NOHSA-TRAP-GFX900-V3-NEXT:    v_mov_b32_e32 v1, 3
; NOHSA-TRAP-GFX900-V3-NEXT:    global_store_dword v0, v1, s[0:1]
; NOHSA-TRAP-GFX900-V3-NEXT:    s_waitcnt vmcnt(0)
; NOHSA-TRAP-GFX900-V3-NEXT:    s_endpgm
; NOHSA-TRAP-GFX900-V3-NEXT:  .LBB1_2: ; %trap
; NOHSA-TRAP-GFX900-V3-NEXT:    s_endpgm
;
; NOHSA-TRAP-GFX900-V4-LABEL: non_entry_trap:
; NOHSA-TRAP-GFX900-V4:       ; %bb.0: ; %entry
; NOHSA-TRAP-GFX900-V4-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; NOHSA-TRAP-GFX900-V4-NEXT:    v_mov_b32_e32 v0, 0
; NOHSA-TRAP-GFX900-V4-NEXT:    s_waitcnt lgkmcnt(0)
; NOHSA-TRAP-GFX900-V4-NEXT:    global_load_dword v1, v0, s[0:1] glc
; NOHSA-TRAP-GFX900-V4-NEXT:    s_waitcnt vmcnt(0)
; NOHSA-TRAP-GFX900-V4-NEXT:    v_cmp_eq_u32_e32 vcc, -1, v1
; NOHSA-TRAP-GFX900-V4-NEXT:    s_and_b64 vcc, exec, vcc
; NOHSA-TRAP-GFX900-V4-NEXT:    s_cbranch_vccz .LBB1_2
; NOHSA-TRAP-GFX900-V4-NEXT:  ; %bb.1: ; %ret
; NOHSA-TRAP-GFX900-V4-NEXT:    v_mov_b32_e32 v1, 3
; NOHSA-TRAP-GFX900-V4-NEXT:    global_store_dword v0, v1, s[0:1]
; NOHSA-TRAP-GFX900-V4-NEXT:    s_waitcnt vmcnt(0)
; NOHSA-TRAP-GFX900-V4-NEXT:    s_endpgm
; NOHSA-TRAP-GFX900-V4-NEXT:  .LBB1_2: ; %trap
; NOHSA-TRAP-GFX900-V4-NEXT:    s_endpgm
;
; HSA-TRAP-GFX803-V2-LABEL: non_entry_trap:
; HSA-TRAP-GFX803-V2:         .amd_kernel_code_t
; HSA-TRAP-GFX803-V2-NEXT:     amd_code_version_major = 1
; HSA-TRAP-GFX803-V2-NEXT:     amd_code_version_minor = 2
; HSA-TRAP-GFX803-V2-NEXT:     amd_machine_kind = 1
; HSA-TRAP-GFX803-V2-NEXT:     amd_machine_version_major = 8
; HSA-TRAP-GFX803-V2-NEXT:     amd_machine_version_minor = 0
; HSA-TRAP-GFX803-V2-NEXT:     amd_machine_version_stepping = 3
; HSA-TRAP-GFX803-V2-NEXT:     kernel_code_entry_byte_offset = 256
; HSA-TRAP-GFX803-V2-NEXT:     kernel_code_prefetch_byte_size = 0
; HSA-TRAP-GFX803-V2-NEXT:     granulated_workitem_vgpr_count = 0
; HSA-TRAP-GFX803-V2-NEXT:     granulated_wavefront_sgpr_count = 1
; HSA-TRAP-GFX803-V2-NEXT:     priority = 0
; HSA-TRAP-GFX803-V2-NEXT:     float_mode = 240
; HSA-TRAP-GFX803-V2-NEXT:     priv = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_dx10_clamp = 1
; HSA-TRAP-GFX803-V2-NEXT:     debug_mode = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_ieee_mode = 1
; HSA-TRAP-GFX803-V2-NEXT:     enable_wgp_mode = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_mem_ordered = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_fwd_progress = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_private_segment_wave_byte_offset = 0
; HSA-TRAP-GFX803-V2-NEXT:     user_sgpr_count = 8
; HSA-TRAP-GFX803-V2-NEXT:     enable_trap_handler = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_workgroup_id_x = 1
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_workgroup_id_y = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_workgroup_id_z = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_workgroup_info = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_vgpr_workitem_id = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_exception_msb = 0
; HSA-TRAP-GFX803-V2-NEXT:     granulated_lds_size = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_exception = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_private_segment_buffer = 1
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_dispatch_ptr = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_queue_ptr = 1
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_kernarg_segment_ptr = 1
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_dispatch_id = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_flat_scratch_init = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_private_segment_size = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_grid_workgroup_count_x = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_grid_workgroup_count_y = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_grid_workgroup_count_z = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_wavefront_size32 = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_ordered_append_gds = 0
; HSA-TRAP-GFX803-V2-NEXT:     private_element_size = 1
; HSA-TRAP-GFX803-V2-NEXT:     is_ptr64 = 1
; HSA-TRAP-GFX803-V2-NEXT:     is_dynamic_callstack = 0
; HSA-TRAP-GFX803-V2-NEXT:     is_debug_enabled = 0
; HSA-TRAP-GFX803-V2-NEXT:     is_xnack_enabled = 0
; HSA-TRAP-GFX803-V2-NEXT:     workitem_private_segment_byte_size = 0
; HSA-TRAP-GFX803-V2-NEXT:     workgroup_group_segment_byte_size = 0
; HSA-TRAP-GFX803-V2-NEXT:     gds_segment_byte_size = 0
; HSA-TRAP-GFX803-V2-NEXT:     kernarg_segment_byte_size = 8
; HSA-TRAP-GFX803-V2-NEXT:     workgroup_fbarrier_count = 0
; HSA-TRAP-GFX803-V2-NEXT:     wavefront_sgpr_count = 10
; HSA-TRAP-GFX803-V2-NEXT:     workitem_vgpr_count = 3
; HSA-TRAP-GFX803-V2-NEXT:     reserved_vgpr_first = 0
; HSA-TRAP-GFX803-V2-NEXT:     reserved_vgpr_count = 0
; HSA-TRAP-GFX803-V2-NEXT:     reserved_sgpr_first = 0
; HSA-TRAP-GFX803-V2-NEXT:     reserved_sgpr_count = 0
; HSA-TRAP-GFX803-V2-NEXT:     debug_wavefront_private_segment_offset_sgpr = 0
; HSA-TRAP-GFX803-V2-NEXT:     debug_private_segment_buffer_sgpr = 0
; HSA-TRAP-GFX803-V2-NEXT:     kernarg_segment_alignment = 4
; HSA-TRAP-GFX803-V2-NEXT:     group_segment_alignment = 4
; HSA-TRAP-GFX803-V2-NEXT:     private_segment_alignment = 4
; HSA-TRAP-GFX803-V2-NEXT:     wavefront_size = 6
; HSA-TRAP-GFX803-V2-NEXT:     call_convention = -1
; HSA-TRAP-GFX803-V2-NEXT:     runtime_loader_kernel_symbol = 0
; HSA-TRAP-GFX803-V2-NEXT:    .end_amd_kernel_code_t
; HSA-TRAP-GFX803-V2-NEXT:  ; %bb.0: ; %entry
; HSA-TRAP-GFX803-V2-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-TRAP-GFX803-V2-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-TRAP-GFX803-V2-NEXT:    v_mov_b32_e32 v0, s0
; HSA-TRAP-GFX803-V2-NEXT:    v_mov_b32_e32 v1, s1
; HSA-TRAP-GFX803-V2-NEXT:    flat_load_dword v0, v[0:1] glc
; HSA-TRAP-GFX803-V2-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX803-V2-NEXT:    v_cmp_eq_u32_e32 vcc, -1, v0
; HSA-TRAP-GFX803-V2-NEXT:    s_and_b64 vcc, exec, vcc
; HSA-TRAP-GFX803-V2-NEXT:    s_cbranch_vccz .LBB1_2
; HSA-TRAP-GFX803-V2-NEXT:  ; %bb.1: ; %ret
; HSA-TRAP-GFX803-V2-NEXT:    v_mov_b32_e32 v0, s0
; HSA-TRAP-GFX803-V2-NEXT:    v_mov_b32_e32 v2, 3
; HSA-TRAP-GFX803-V2-NEXT:    v_mov_b32_e32 v1, s1
; HSA-TRAP-GFX803-V2-NEXT:    flat_store_dword v[0:1], v2
; HSA-TRAP-GFX803-V2-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX803-V2-NEXT:    s_endpgm
; HSA-TRAP-GFX803-V2-NEXT:  .LBB1_2: ; %trap
; HSA-TRAP-GFX803-V2-NEXT:    s_mov_b64 s[0:1], s[4:5]
; HSA-TRAP-GFX803-V2-NEXT:    s_trap 2
;
; HSA-TRAP-GFX803-V3-LABEL: non_entry_trap:
; HSA-TRAP-GFX803-V3:       ; %bb.0: ; %entry
; HSA-TRAP-GFX803-V3-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-TRAP-GFX803-V3-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-TRAP-GFX803-V3-NEXT:    v_mov_b32_e32 v0, s0
; HSA-TRAP-GFX803-V3-NEXT:    v_mov_b32_e32 v1, s1
; HSA-TRAP-GFX803-V3-NEXT:    flat_load_dword v0, v[0:1] glc
; HSA-TRAP-GFX803-V3-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX803-V3-NEXT:    v_cmp_eq_u32_e32 vcc, -1, v0
; HSA-TRAP-GFX803-V3-NEXT:    s_and_b64 vcc, exec, vcc
; HSA-TRAP-GFX803-V3-NEXT:    s_cbranch_vccz .LBB1_2
; HSA-TRAP-GFX803-V3-NEXT:  ; %bb.1: ; %ret
; HSA-TRAP-GFX803-V3-NEXT:    v_mov_b32_e32 v0, s0
; HSA-TRAP-GFX803-V3-NEXT:    v_mov_b32_e32 v2, 3
; HSA-TRAP-GFX803-V3-NEXT:    v_mov_b32_e32 v1, s1
; HSA-TRAP-GFX803-V3-NEXT:    flat_store_dword v[0:1], v2
; HSA-TRAP-GFX803-V3-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX803-V3-NEXT:    s_endpgm
; HSA-TRAP-GFX803-V3-NEXT:  .LBB1_2: ; %trap
; HSA-TRAP-GFX803-V3-NEXT:    s_mov_b64 s[0:1], s[4:5]
; HSA-TRAP-GFX803-V3-NEXT:    s_trap 2
;
; HSA-TRAP-GFX803-V4-LABEL: non_entry_trap:
; HSA-TRAP-GFX803-V4:       ; %bb.0: ; %entry
; HSA-TRAP-GFX803-V4-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-TRAP-GFX803-V4-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-TRAP-GFX803-V4-NEXT:    v_mov_b32_e32 v0, s0
; HSA-TRAP-GFX803-V4-NEXT:    v_mov_b32_e32 v1, s1
; HSA-TRAP-GFX803-V4-NEXT:    flat_load_dword v0, v[0:1] glc
; HSA-TRAP-GFX803-V4-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX803-V4-NEXT:    v_cmp_eq_u32_e32 vcc, -1, v0
; HSA-TRAP-GFX803-V4-NEXT:    s_and_b64 vcc, exec, vcc
; HSA-TRAP-GFX803-V4-NEXT:    s_cbranch_vccz .LBB1_2
; HSA-TRAP-GFX803-V4-NEXT:  ; %bb.1: ; %ret
; HSA-TRAP-GFX803-V4-NEXT:    v_mov_b32_e32 v0, s0
; HSA-TRAP-GFX803-V4-NEXT:    v_mov_b32_e32 v2, 3
; HSA-TRAP-GFX803-V4-NEXT:    v_mov_b32_e32 v1, s1
; HSA-TRAP-GFX803-V4-NEXT:    flat_store_dword v[0:1], v2
; HSA-TRAP-GFX803-V4-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX803-V4-NEXT:    s_endpgm
; HSA-TRAP-GFX803-V4-NEXT:  .LBB1_2: ; %trap
; HSA-TRAP-GFX803-V4-NEXT:    s_mov_b64 s[0:1], s[4:5]
; HSA-TRAP-GFX803-V4-NEXT:    s_trap 2
;
; HSA-TRAP-GFX900-V2-LABEL: non_entry_trap:
; HSA-TRAP-GFX900-V2:         .amd_kernel_code_t
; HSA-TRAP-GFX900-V2-NEXT:     amd_code_version_major = 1
; HSA-TRAP-GFX900-V2-NEXT:     amd_code_version_minor = 2
; HSA-TRAP-GFX900-V2-NEXT:     amd_machine_kind = 1
; HSA-TRAP-GFX900-V2-NEXT:     amd_machine_version_major = 9
; HSA-TRAP-GFX900-V2-NEXT:     amd_machine_version_minor = 0
; HSA-TRAP-GFX900-V2-NEXT:     amd_machine_version_stepping = 0
; HSA-TRAP-GFX900-V2-NEXT:     kernel_code_entry_byte_offset = 256
; HSA-TRAP-GFX900-V2-NEXT:     kernel_code_prefetch_byte_size = 0
; HSA-TRAP-GFX900-V2-NEXT:     granulated_workitem_vgpr_count = 0
; HSA-TRAP-GFX900-V2-NEXT:     granulated_wavefront_sgpr_count = 1
; HSA-TRAP-GFX900-V2-NEXT:     priority = 0
; HSA-TRAP-GFX900-V2-NEXT:     float_mode = 240
; HSA-TRAP-GFX900-V2-NEXT:     priv = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_dx10_clamp = 1
; HSA-TRAP-GFX900-V2-NEXT:     debug_mode = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_ieee_mode = 1
; HSA-TRAP-GFX900-V2-NEXT:     enable_wgp_mode = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_mem_ordered = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_fwd_progress = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_private_segment_wave_byte_offset = 0
; HSA-TRAP-GFX900-V2-NEXT:     user_sgpr_count = 8
; HSA-TRAP-GFX900-V2-NEXT:     enable_trap_handler = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_id_x = 1
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_id_y = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_id_z = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_info = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_vgpr_workitem_id = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_exception_msb = 0
; HSA-TRAP-GFX900-V2-NEXT:     granulated_lds_size = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_exception = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_private_segment_buffer = 1
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_dispatch_ptr = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_queue_ptr = 1
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_kernarg_segment_ptr = 1
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_dispatch_id = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_flat_scratch_init = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_private_segment_size = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_grid_workgroup_count_x = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_grid_workgroup_count_y = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_grid_workgroup_count_z = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_wavefront_size32 = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_ordered_append_gds = 0
; HSA-TRAP-GFX900-V2-NEXT:     private_element_size = 1
; HSA-TRAP-GFX900-V2-NEXT:     is_ptr64 = 1
; HSA-TRAP-GFX900-V2-NEXT:     is_dynamic_callstack = 0
; HSA-TRAP-GFX900-V2-NEXT:     is_debug_enabled = 0
; HSA-TRAP-GFX900-V2-NEXT:     is_xnack_enabled = 1
; HSA-TRAP-GFX900-V2-NEXT:     workitem_private_segment_byte_size = 0
; HSA-TRAP-GFX900-V2-NEXT:     workgroup_group_segment_byte_size = 0
; HSA-TRAP-GFX900-V2-NEXT:     gds_segment_byte_size = 0
; HSA-TRAP-GFX900-V2-NEXT:     kernarg_segment_byte_size = 8
; HSA-TRAP-GFX900-V2-NEXT:     workgroup_fbarrier_count = 0
; HSA-TRAP-GFX900-V2-NEXT:     wavefront_sgpr_count = 10
; HSA-TRAP-GFX900-V2-NEXT:     workitem_vgpr_count = 2
; HSA-TRAP-GFX900-V2-NEXT:     reserved_vgpr_first = 0
; HSA-TRAP-GFX900-V2-NEXT:     reserved_vgpr_count = 0
; HSA-TRAP-GFX900-V2-NEXT:     reserved_sgpr_first = 0
; HSA-TRAP-GFX900-V2-NEXT:     reserved_sgpr_count = 0
; HSA-TRAP-GFX900-V2-NEXT:     debug_wavefront_private_segment_offset_sgpr = 0
; HSA-TRAP-GFX900-V2-NEXT:     debug_private_segment_buffer_sgpr = 0
; HSA-TRAP-GFX900-V2-NEXT:     kernarg_segment_alignment = 4
; HSA-TRAP-GFX900-V2-NEXT:     group_segment_alignment = 4
; HSA-TRAP-GFX900-V2-NEXT:     private_segment_alignment = 4
; HSA-TRAP-GFX900-V2-NEXT:     wavefront_size = 6
; HSA-TRAP-GFX900-V2-NEXT:     call_convention = -1
; HSA-TRAP-GFX900-V2-NEXT:     runtime_loader_kernel_symbol = 0
; HSA-TRAP-GFX900-V2-NEXT:    .end_amd_kernel_code_t
; HSA-TRAP-GFX900-V2-NEXT:  ; %bb.0: ; %entry
; HSA-TRAP-GFX900-V2-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-TRAP-GFX900-V2-NEXT:    v_mov_b32_e32 v0, 0
; HSA-TRAP-GFX900-V2-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-TRAP-GFX900-V2-NEXT:    global_load_dword v1, v0, s[0:1] glc
; HSA-TRAP-GFX900-V2-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX900-V2-NEXT:    v_cmp_eq_u32_e32 vcc, -1, v1
; HSA-TRAP-GFX900-V2-NEXT:    s_and_b64 vcc, exec, vcc
; HSA-TRAP-GFX900-V2-NEXT:    s_cbranch_vccz .LBB1_2
; HSA-TRAP-GFX900-V2-NEXT:  ; %bb.1: ; %ret
; HSA-TRAP-GFX900-V2-NEXT:    v_mov_b32_e32 v1, 3
; HSA-TRAP-GFX900-V2-NEXT:    global_store_dword v0, v1, s[0:1]
; HSA-TRAP-GFX900-V2-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX900-V2-NEXT:    s_endpgm
; HSA-TRAP-GFX900-V2-NEXT:  .LBB1_2: ; %trap
; HSA-TRAP-GFX900-V2-NEXT:    s_mov_b64 s[0:1], s[4:5]
; HSA-TRAP-GFX900-V2-NEXT:    s_trap 2
;
; HSA-TRAP-GFX900-V3-LABEL: non_entry_trap:
; HSA-TRAP-GFX900-V3:       ; %bb.0: ; %entry
; HSA-TRAP-GFX900-V3-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-TRAP-GFX900-V3-NEXT:    v_mov_b32_e32 v0, 0
; HSA-TRAP-GFX900-V3-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-TRAP-GFX900-V3-NEXT:    global_load_dword v1, v0, s[0:1] glc
; HSA-TRAP-GFX900-V3-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX900-V3-NEXT:    v_cmp_eq_u32_e32 vcc, -1, v1
; HSA-TRAP-GFX900-V3-NEXT:    s_and_b64 vcc, exec, vcc
; HSA-TRAP-GFX900-V3-NEXT:    s_cbranch_vccz .LBB1_2
; HSA-TRAP-GFX900-V3-NEXT:  ; %bb.1: ; %ret
; HSA-TRAP-GFX900-V3-NEXT:    v_mov_b32_e32 v1, 3
; HSA-TRAP-GFX900-V3-NEXT:    global_store_dword v0, v1, s[0:1]
; HSA-TRAP-GFX900-V3-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX900-V3-NEXT:    s_endpgm
; HSA-TRAP-GFX900-V3-NEXT:  .LBB1_2: ; %trap
; HSA-TRAP-GFX900-V3-NEXT:    s_mov_b64 s[0:1], s[4:5]
; HSA-TRAP-GFX900-V3-NEXT:    s_trap 2
;
; HSA-TRAP-GFX900-V4-LABEL: non_entry_trap:
; HSA-TRAP-GFX900-V4:       ; %bb.0: ; %entry
; HSA-TRAP-GFX900-V4-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-TRAP-GFX900-V4-NEXT:    v_mov_b32_e32 v0, 0
; HSA-TRAP-GFX900-V4-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-TRAP-GFX900-V4-NEXT:    global_load_dword v1, v0, s[0:1] glc
; HSA-TRAP-GFX900-V4-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX900-V4-NEXT:    v_cmp_eq_u32_e32 vcc, -1, v1
; HSA-TRAP-GFX900-V4-NEXT:    s_and_b64 vcc, exec, vcc
; HSA-TRAP-GFX900-V4-NEXT:    s_cbranch_vccz .LBB1_2
; HSA-TRAP-GFX900-V4-NEXT:  ; %bb.1: ; %ret
; HSA-TRAP-GFX900-V4-NEXT:    v_mov_b32_e32 v1, 3
; HSA-TRAP-GFX900-V4-NEXT:    global_store_dword v0, v1, s[0:1]
; HSA-TRAP-GFX900-V4-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX900-V4-NEXT:    s_endpgm
; HSA-TRAP-GFX900-V4-NEXT:  .LBB1_2: ; %trap
; HSA-TRAP-GFX900-V4-NEXT:    s_trap 2
;
; HSA-NOTRAP-GFX900-V2-LABEL: non_entry_trap:
; HSA-NOTRAP-GFX900-V2:         .amd_kernel_code_t
; HSA-NOTRAP-GFX900-V2-NEXT:     amd_code_version_major = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     amd_code_version_minor = 2
; HSA-NOTRAP-GFX900-V2-NEXT:     amd_machine_kind = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     amd_machine_version_major = 9
; HSA-NOTRAP-GFX900-V2-NEXT:     amd_machine_version_minor = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     amd_machine_version_stepping = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     kernel_code_entry_byte_offset = 256
; HSA-NOTRAP-GFX900-V2-NEXT:     kernel_code_prefetch_byte_size = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     granulated_workitem_vgpr_count = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     granulated_wavefront_sgpr_count = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     priority = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     float_mode = 240
; HSA-NOTRAP-GFX900-V2-NEXT:     priv = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_dx10_clamp = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     debug_mode = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_ieee_mode = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_wgp_mode = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_mem_ordered = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_fwd_progress = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_private_segment_wave_byte_offset = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     user_sgpr_count = 8
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_trap_handler = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_id_x = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_id_y = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_id_z = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_info = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_vgpr_workitem_id = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_exception_msb = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     granulated_lds_size = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_exception = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_private_segment_buffer = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_dispatch_ptr = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_queue_ptr = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_kernarg_segment_ptr = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_dispatch_id = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_flat_scratch_init = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_private_segment_size = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_grid_workgroup_count_x = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_grid_workgroup_count_y = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_grid_workgroup_count_z = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_wavefront_size32 = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_ordered_append_gds = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     private_element_size = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     is_ptr64 = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     is_dynamic_callstack = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     is_debug_enabled = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     is_xnack_enabled = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     workitem_private_segment_byte_size = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     workgroup_group_segment_byte_size = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     gds_segment_byte_size = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     kernarg_segment_byte_size = 8
; HSA-NOTRAP-GFX900-V2-NEXT:     workgroup_fbarrier_count = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     wavefront_sgpr_count = 10
; HSA-NOTRAP-GFX900-V2-NEXT:     workitem_vgpr_count = 2
; HSA-NOTRAP-GFX900-V2-NEXT:     reserved_vgpr_first = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     reserved_vgpr_count = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     reserved_sgpr_first = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     reserved_sgpr_count = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     debug_wavefront_private_segment_offset_sgpr = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     debug_private_segment_buffer_sgpr = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     kernarg_segment_alignment = 4
; HSA-NOTRAP-GFX900-V2-NEXT:     group_segment_alignment = 4
; HSA-NOTRAP-GFX900-V2-NEXT:     private_segment_alignment = 4
; HSA-NOTRAP-GFX900-V2-NEXT:     wavefront_size = 6
; HSA-NOTRAP-GFX900-V2-NEXT:     call_convention = -1
; HSA-NOTRAP-GFX900-V2-NEXT:     runtime_loader_kernel_symbol = 0
; HSA-NOTRAP-GFX900-V2-NEXT:    .end_amd_kernel_code_t
; HSA-NOTRAP-GFX900-V2-NEXT:  ; %bb.0: ; %entry
; HSA-NOTRAP-GFX900-V2-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-NOTRAP-GFX900-V2-NEXT:    v_mov_b32_e32 v0, 0
; HSA-NOTRAP-GFX900-V2-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-NOTRAP-GFX900-V2-NEXT:    global_load_dword v1, v0, s[0:1] glc
; HSA-NOTRAP-GFX900-V2-NEXT:    s_waitcnt vmcnt(0)
; HSA-NOTRAP-GFX900-V2-NEXT:    v_cmp_eq_u32_e32 vcc, -1, v1
; HSA-NOTRAP-GFX900-V2-NEXT:    s_and_b64 vcc, exec, vcc
; HSA-NOTRAP-GFX900-V2-NEXT:    s_cbranch_vccz .LBB1_2
; HSA-NOTRAP-GFX900-V2-NEXT:  ; %bb.1: ; %ret
; HSA-NOTRAP-GFX900-V2-NEXT:    v_mov_b32_e32 v1, 3
; HSA-NOTRAP-GFX900-V2-NEXT:    global_store_dword v0, v1, s[0:1]
; HSA-NOTRAP-GFX900-V2-NEXT:    s_waitcnt vmcnt(0)
; HSA-NOTRAP-GFX900-V2-NEXT:    s_endpgm
; HSA-NOTRAP-GFX900-V2-NEXT:  .LBB1_2: ; %trap
; HSA-NOTRAP-GFX900-V2-NEXT:    s_endpgm
;
; HSA-NOTRAP-GFX900-V3-LABEL: non_entry_trap:
; HSA-NOTRAP-GFX900-V3:       ; %bb.0: ; %entry
; HSA-NOTRAP-GFX900-V3-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-NOTRAP-GFX900-V3-NEXT:    v_mov_b32_e32 v0, 0
; HSA-NOTRAP-GFX900-V3-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-NOTRAP-GFX900-V3-NEXT:    global_load_dword v1, v0, s[0:1] glc
; HSA-NOTRAP-GFX900-V3-NEXT:    s_waitcnt vmcnt(0)
; HSA-NOTRAP-GFX900-V3-NEXT:    v_cmp_eq_u32_e32 vcc, -1, v1
; HSA-NOTRAP-GFX900-V3-NEXT:    s_and_b64 vcc, exec, vcc
; HSA-NOTRAP-GFX900-V3-NEXT:    s_cbranch_vccz .LBB1_2
; HSA-NOTRAP-GFX900-V3-NEXT:  ; %bb.1: ; %ret
; HSA-NOTRAP-GFX900-V3-NEXT:    v_mov_b32_e32 v1, 3
; HSA-NOTRAP-GFX900-V3-NEXT:    global_store_dword v0, v1, s[0:1]
; HSA-NOTRAP-GFX900-V3-NEXT:    s_waitcnt vmcnt(0)
; HSA-NOTRAP-GFX900-V3-NEXT:    s_endpgm
; HSA-NOTRAP-GFX900-V3-NEXT:  .LBB1_2: ; %trap
; HSA-NOTRAP-GFX900-V3-NEXT:    s_endpgm
;
; HSA-NOTRAP-GFX900-V4-LABEL: non_entry_trap:
; HSA-NOTRAP-GFX900-V4:       ; %bb.0: ; %entry
; HSA-NOTRAP-GFX900-V4-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-NOTRAP-GFX900-V4-NEXT:    v_mov_b32_e32 v0, 0
; HSA-NOTRAP-GFX900-V4-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-NOTRAP-GFX900-V4-NEXT:    global_load_dword v1, v0, s[0:1] glc
; HSA-NOTRAP-GFX900-V4-NEXT:    s_waitcnt vmcnt(0)
; HSA-NOTRAP-GFX900-V4-NEXT:    v_cmp_eq_u32_e32 vcc, -1, v1
; HSA-NOTRAP-GFX900-V4-NEXT:    s_and_b64 vcc, exec, vcc
; HSA-NOTRAP-GFX900-V4-NEXT:    s_cbranch_vccz .LBB1_2
; HSA-NOTRAP-GFX900-V4-NEXT:  ; %bb.1: ; %ret
; HSA-NOTRAP-GFX900-V4-NEXT:    v_mov_b32_e32 v1, 3
; HSA-NOTRAP-GFX900-V4-NEXT:    global_store_dword v0, v1, s[0:1]
; HSA-NOTRAP-GFX900-V4-NEXT:    s_waitcnt vmcnt(0)
; HSA-NOTRAP-GFX900-V4-NEXT:    s_endpgm
; HSA-NOTRAP-GFX900-V4-NEXT:  .LBB1_2: ; %trap
; HSA-NOTRAP-GFX900-V4-NEXT:    s_endpgm
entry:
  %tmp29 = load volatile i32, i32 addrspace(1)* %arg0
  %cmp = icmp eq i32 %tmp29, -1
  br i1 %cmp, label %ret, label %trap

trap:
  call void @llvm.trap()
  unreachable

ret:
  store volatile i32 3, i32 addrspace(1)* %arg0
  ret void
}

define amdgpu_kernel void @debugtrap(i32 addrspace(1)* nocapture readonly %arg0) {
; NOHSA-TRAP-GFX900-V2-LABEL: debugtrap:
; NOHSA-TRAP-GFX900-V2:       ; %bb.0:
; NOHSA-TRAP-GFX900-V2-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; NOHSA-TRAP-GFX900-V2-NEXT:    v_mov_b32_e32 v0, 0
; NOHSA-TRAP-GFX900-V2-NEXT:    v_mov_b32_e32 v1, 1
; NOHSA-TRAP-GFX900-V2-NEXT:    v_mov_b32_e32 v2, 2
; NOHSA-TRAP-GFX900-V2-NEXT:    s_waitcnt lgkmcnt(0)
; NOHSA-TRAP-GFX900-V2-NEXT:    global_store_dword v0, v1, s[0:1]
; NOHSA-TRAP-GFX900-V2-NEXT:    s_waitcnt vmcnt(0)
; NOHSA-TRAP-GFX900-V2-NEXT:    global_store_dword v0, v2, s[0:1]
; NOHSA-TRAP-GFX900-V2-NEXT:    s_waitcnt vmcnt(0)
; NOHSA-TRAP-GFX900-V2-NEXT:    s_endpgm
;
; NOHSA-TRAP-GFX900-V3-LABEL: debugtrap:
; NOHSA-TRAP-GFX900-V3:       ; %bb.0:
; NOHSA-TRAP-GFX900-V3-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; NOHSA-TRAP-GFX900-V3-NEXT:    v_mov_b32_e32 v0, 0
; NOHSA-TRAP-GFX900-V3-NEXT:    v_mov_b32_e32 v1, 1
; NOHSA-TRAP-GFX900-V3-NEXT:    v_mov_b32_e32 v2, 2
; NOHSA-TRAP-GFX900-V3-NEXT:    s_waitcnt lgkmcnt(0)
; NOHSA-TRAP-GFX900-V3-NEXT:    global_store_dword v0, v1, s[0:1]
; NOHSA-TRAP-GFX900-V3-NEXT:    s_waitcnt vmcnt(0)
; NOHSA-TRAP-GFX900-V3-NEXT:    global_store_dword v0, v2, s[0:1]
; NOHSA-TRAP-GFX900-V3-NEXT:    s_waitcnt vmcnt(0)
; NOHSA-TRAP-GFX900-V3-NEXT:    s_endpgm
;
; NOHSA-TRAP-GFX900-V4-LABEL: debugtrap:
; NOHSA-TRAP-GFX900-V4:       ; %bb.0:
; NOHSA-TRAP-GFX900-V4-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x24
; NOHSA-TRAP-GFX900-V4-NEXT:    v_mov_b32_e32 v0, 0
; NOHSA-TRAP-GFX900-V4-NEXT:    v_mov_b32_e32 v1, 1
; NOHSA-TRAP-GFX900-V4-NEXT:    v_mov_b32_e32 v2, 2
; NOHSA-TRAP-GFX900-V4-NEXT:    s_waitcnt lgkmcnt(0)
; NOHSA-TRAP-GFX900-V4-NEXT:    global_store_dword v0, v1, s[0:1]
; NOHSA-TRAP-GFX900-V4-NEXT:    s_waitcnt vmcnt(0)
; NOHSA-TRAP-GFX900-V4-NEXT:    global_store_dword v0, v2, s[0:1]
; NOHSA-TRAP-GFX900-V4-NEXT:    s_waitcnt vmcnt(0)
; NOHSA-TRAP-GFX900-V4-NEXT:    s_endpgm
;
; HSA-TRAP-GFX803-V2-LABEL: debugtrap:
; HSA-TRAP-GFX803-V2:         .amd_kernel_code_t
; HSA-TRAP-GFX803-V2-NEXT:     amd_code_version_major = 1
; HSA-TRAP-GFX803-V2-NEXT:     amd_code_version_minor = 2
; HSA-TRAP-GFX803-V2-NEXT:     amd_machine_kind = 1
; HSA-TRAP-GFX803-V2-NEXT:     amd_machine_version_major = 8
; HSA-TRAP-GFX803-V2-NEXT:     amd_machine_version_minor = 0
; HSA-TRAP-GFX803-V2-NEXT:     amd_machine_version_stepping = 3
; HSA-TRAP-GFX803-V2-NEXT:     kernel_code_entry_byte_offset = 256
; HSA-TRAP-GFX803-V2-NEXT:     kernel_code_prefetch_byte_size = 0
; HSA-TRAP-GFX803-V2-NEXT:     granulated_workitem_vgpr_count = 0
; HSA-TRAP-GFX803-V2-NEXT:     granulated_wavefront_sgpr_count = 0
; HSA-TRAP-GFX803-V2-NEXT:     priority = 0
; HSA-TRAP-GFX803-V2-NEXT:     float_mode = 240
; HSA-TRAP-GFX803-V2-NEXT:     priv = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_dx10_clamp = 1
; HSA-TRAP-GFX803-V2-NEXT:     debug_mode = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_ieee_mode = 1
; HSA-TRAP-GFX803-V2-NEXT:     enable_wgp_mode = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_mem_ordered = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_fwd_progress = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_private_segment_wave_byte_offset = 0
; HSA-TRAP-GFX803-V2-NEXT:     user_sgpr_count = 8
; HSA-TRAP-GFX803-V2-NEXT:     enable_trap_handler = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_workgroup_id_x = 1
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_workgroup_id_y = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_workgroup_id_z = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_workgroup_info = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_vgpr_workitem_id = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_exception_msb = 0
; HSA-TRAP-GFX803-V2-NEXT:     granulated_lds_size = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_exception = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_private_segment_buffer = 1
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_dispatch_ptr = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_queue_ptr = 1
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_kernarg_segment_ptr = 1
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_dispatch_id = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_flat_scratch_init = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_private_segment_size = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_grid_workgroup_count_x = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_grid_workgroup_count_y = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_sgpr_grid_workgroup_count_z = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_wavefront_size32 = 0
; HSA-TRAP-GFX803-V2-NEXT:     enable_ordered_append_gds = 0
; HSA-TRAP-GFX803-V2-NEXT:     private_element_size = 1
; HSA-TRAP-GFX803-V2-NEXT:     is_ptr64 = 1
; HSA-TRAP-GFX803-V2-NEXT:     is_dynamic_callstack = 0
; HSA-TRAP-GFX803-V2-NEXT:     is_debug_enabled = 0
; HSA-TRAP-GFX803-V2-NEXT:     is_xnack_enabled = 0
; HSA-TRAP-GFX803-V2-NEXT:     workitem_private_segment_byte_size = 0
; HSA-TRAP-GFX803-V2-NEXT:     workgroup_group_segment_byte_size = 0
; HSA-TRAP-GFX803-V2-NEXT:     gds_segment_byte_size = 0
; HSA-TRAP-GFX803-V2-NEXT:     kernarg_segment_byte_size = 8
; HSA-TRAP-GFX803-V2-NEXT:     workgroup_fbarrier_count = 0
; HSA-TRAP-GFX803-V2-NEXT:     wavefront_sgpr_count = 8
; HSA-TRAP-GFX803-V2-NEXT:     workitem_vgpr_count = 4
; HSA-TRAP-GFX803-V2-NEXT:     reserved_vgpr_first = 0
; HSA-TRAP-GFX803-V2-NEXT:     reserved_vgpr_count = 0
; HSA-TRAP-GFX803-V2-NEXT:     reserved_sgpr_first = 0
; HSA-TRAP-GFX803-V2-NEXT:     reserved_sgpr_count = 0
; HSA-TRAP-GFX803-V2-NEXT:     debug_wavefront_private_segment_offset_sgpr = 0
; HSA-TRAP-GFX803-V2-NEXT:     debug_private_segment_buffer_sgpr = 0
; HSA-TRAP-GFX803-V2-NEXT:     kernarg_segment_alignment = 4
; HSA-TRAP-GFX803-V2-NEXT:     group_segment_alignment = 4
; HSA-TRAP-GFX803-V2-NEXT:     private_segment_alignment = 4
; HSA-TRAP-GFX803-V2-NEXT:     wavefront_size = 6
; HSA-TRAP-GFX803-V2-NEXT:     call_convention = -1
; HSA-TRAP-GFX803-V2-NEXT:     runtime_loader_kernel_symbol = 0
; HSA-TRAP-GFX803-V2-NEXT:    .end_amd_kernel_code_t
; HSA-TRAP-GFX803-V2-NEXT:  ; %bb.0:
; HSA-TRAP-GFX803-V2-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-TRAP-GFX803-V2-NEXT:    v_mov_b32_e32 v2, 1
; HSA-TRAP-GFX803-V2-NEXT:    v_mov_b32_e32 v3, 2
; HSA-TRAP-GFX803-V2-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-TRAP-GFX803-V2-NEXT:    v_mov_b32_e32 v0, s0
; HSA-TRAP-GFX803-V2-NEXT:    v_mov_b32_e32 v1, s1
; HSA-TRAP-GFX803-V2-NEXT:    flat_store_dword v[0:1], v2
; HSA-TRAP-GFX803-V2-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX803-V2-NEXT:    s_trap 3
; HSA-TRAP-GFX803-V2-NEXT:    flat_store_dword v[0:1], v3
; HSA-TRAP-GFX803-V2-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX803-V2-NEXT:    s_endpgm
;
; HSA-TRAP-GFX803-V3-LABEL: debugtrap:
; HSA-TRAP-GFX803-V3:       ; %bb.0:
; HSA-TRAP-GFX803-V3-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-TRAP-GFX803-V3-NEXT:    v_mov_b32_e32 v2, 1
; HSA-TRAP-GFX803-V3-NEXT:    v_mov_b32_e32 v3, 2
; HSA-TRAP-GFX803-V3-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-TRAP-GFX803-V3-NEXT:    v_mov_b32_e32 v0, s0
; HSA-TRAP-GFX803-V3-NEXT:    v_mov_b32_e32 v1, s1
; HSA-TRAP-GFX803-V3-NEXT:    flat_store_dword v[0:1], v2
; HSA-TRAP-GFX803-V3-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX803-V3-NEXT:    s_trap 3
; HSA-TRAP-GFX803-V3-NEXT:    flat_store_dword v[0:1], v3
; HSA-TRAP-GFX803-V3-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX803-V3-NEXT:    s_endpgm
;
; HSA-TRAP-GFX803-V4-LABEL: debugtrap:
; HSA-TRAP-GFX803-V4:       ; %bb.0:
; HSA-TRAP-GFX803-V4-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-TRAP-GFX803-V4-NEXT:    v_mov_b32_e32 v2, 1
; HSA-TRAP-GFX803-V4-NEXT:    v_mov_b32_e32 v3, 2
; HSA-TRAP-GFX803-V4-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-TRAP-GFX803-V4-NEXT:    v_mov_b32_e32 v0, s0
; HSA-TRAP-GFX803-V4-NEXT:    v_mov_b32_e32 v1, s1
; HSA-TRAP-GFX803-V4-NEXT:    flat_store_dword v[0:1], v2
; HSA-TRAP-GFX803-V4-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX803-V4-NEXT:    s_trap 3
; HSA-TRAP-GFX803-V4-NEXT:    flat_store_dword v[0:1], v3
; HSA-TRAP-GFX803-V4-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX803-V4-NEXT:    s_endpgm
;
; HSA-TRAP-GFX900-V2-LABEL: debugtrap:
; HSA-TRAP-GFX900-V2:         .amd_kernel_code_t
; HSA-TRAP-GFX900-V2-NEXT:     amd_code_version_major = 1
; HSA-TRAP-GFX900-V2-NEXT:     amd_code_version_minor = 2
; HSA-TRAP-GFX900-V2-NEXT:     amd_machine_kind = 1
; HSA-TRAP-GFX900-V2-NEXT:     amd_machine_version_major = 9
; HSA-TRAP-GFX900-V2-NEXT:     amd_machine_version_minor = 0
; HSA-TRAP-GFX900-V2-NEXT:     amd_machine_version_stepping = 0
; HSA-TRAP-GFX900-V2-NEXT:     kernel_code_entry_byte_offset = 256
; HSA-TRAP-GFX900-V2-NEXT:     kernel_code_prefetch_byte_size = 0
; HSA-TRAP-GFX900-V2-NEXT:     granulated_workitem_vgpr_count = 0
; HSA-TRAP-GFX900-V2-NEXT:     granulated_wavefront_sgpr_count = 0
; HSA-TRAP-GFX900-V2-NEXT:     priority = 0
; HSA-TRAP-GFX900-V2-NEXT:     float_mode = 240
; HSA-TRAP-GFX900-V2-NEXT:     priv = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_dx10_clamp = 1
; HSA-TRAP-GFX900-V2-NEXT:     debug_mode = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_ieee_mode = 1
; HSA-TRAP-GFX900-V2-NEXT:     enable_wgp_mode = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_mem_ordered = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_fwd_progress = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_private_segment_wave_byte_offset = 0
; HSA-TRAP-GFX900-V2-NEXT:     user_sgpr_count = 8
; HSA-TRAP-GFX900-V2-NEXT:     enable_trap_handler = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_id_x = 1
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_id_y = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_id_z = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_info = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_vgpr_workitem_id = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_exception_msb = 0
; HSA-TRAP-GFX900-V2-NEXT:     granulated_lds_size = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_exception = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_private_segment_buffer = 1
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_dispatch_ptr = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_queue_ptr = 1
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_kernarg_segment_ptr = 1
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_dispatch_id = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_flat_scratch_init = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_private_segment_size = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_grid_workgroup_count_x = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_grid_workgroup_count_y = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_sgpr_grid_workgroup_count_z = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_wavefront_size32 = 0
; HSA-TRAP-GFX900-V2-NEXT:     enable_ordered_append_gds = 0
; HSA-TRAP-GFX900-V2-NEXT:     private_element_size = 1
; HSA-TRAP-GFX900-V2-NEXT:     is_ptr64 = 1
; HSA-TRAP-GFX900-V2-NEXT:     is_dynamic_callstack = 0
; HSA-TRAP-GFX900-V2-NEXT:     is_debug_enabled = 0
; HSA-TRAP-GFX900-V2-NEXT:     is_xnack_enabled = 1
; HSA-TRAP-GFX900-V2-NEXT:     workitem_private_segment_byte_size = 0
; HSA-TRAP-GFX900-V2-NEXT:     workgroup_group_segment_byte_size = 0
; HSA-TRAP-GFX900-V2-NEXT:     gds_segment_byte_size = 0
; HSA-TRAP-GFX900-V2-NEXT:     kernarg_segment_byte_size = 8
; HSA-TRAP-GFX900-V2-NEXT:     workgroup_fbarrier_count = 0
; HSA-TRAP-GFX900-V2-NEXT:     wavefront_sgpr_count = 8
; HSA-TRAP-GFX900-V2-NEXT:     workitem_vgpr_count = 3
; HSA-TRAP-GFX900-V2-NEXT:     reserved_vgpr_first = 0
; HSA-TRAP-GFX900-V2-NEXT:     reserved_vgpr_count = 0
; HSA-TRAP-GFX900-V2-NEXT:     reserved_sgpr_first = 0
; HSA-TRAP-GFX900-V2-NEXT:     reserved_sgpr_count = 0
; HSA-TRAP-GFX900-V2-NEXT:     debug_wavefront_private_segment_offset_sgpr = 0
; HSA-TRAP-GFX900-V2-NEXT:     debug_private_segment_buffer_sgpr = 0
; HSA-TRAP-GFX900-V2-NEXT:     kernarg_segment_alignment = 4
; HSA-TRAP-GFX900-V2-NEXT:     group_segment_alignment = 4
; HSA-TRAP-GFX900-V2-NEXT:     private_segment_alignment = 4
; HSA-TRAP-GFX900-V2-NEXT:     wavefront_size = 6
; HSA-TRAP-GFX900-V2-NEXT:     call_convention = -1
; HSA-TRAP-GFX900-V2-NEXT:     runtime_loader_kernel_symbol = 0
; HSA-TRAP-GFX900-V2-NEXT:    .end_amd_kernel_code_t
; HSA-TRAP-GFX900-V2-NEXT:  ; %bb.0:
; HSA-TRAP-GFX900-V2-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-TRAP-GFX900-V2-NEXT:    v_mov_b32_e32 v0, 0
; HSA-TRAP-GFX900-V2-NEXT:    v_mov_b32_e32 v1, 1
; HSA-TRAP-GFX900-V2-NEXT:    v_mov_b32_e32 v2, 2
; HSA-TRAP-GFX900-V2-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-TRAP-GFX900-V2-NEXT:    global_store_dword v0, v1, s[0:1]
; HSA-TRAP-GFX900-V2-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX900-V2-NEXT:    s_trap 3
; HSA-TRAP-GFX900-V2-NEXT:    global_store_dword v0, v2, s[0:1]
; HSA-TRAP-GFX900-V2-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX900-V2-NEXT:    s_endpgm
;
; HSA-TRAP-GFX900-V3-LABEL: debugtrap:
; HSA-TRAP-GFX900-V3:       ; %bb.0:
; HSA-TRAP-GFX900-V3-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-TRAP-GFX900-V3-NEXT:    v_mov_b32_e32 v0, 0
; HSA-TRAP-GFX900-V3-NEXT:    v_mov_b32_e32 v1, 1
; HSA-TRAP-GFX900-V3-NEXT:    v_mov_b32_e32 v2, 2
; HSA-TRAP-GFX900-V3-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-TRAP-GFX900-V3-NEXT:    global_store_dword v0, v1, s[0:1]
; HSA-TRAP-GFX900-V3-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX900-V3-NEXT:    s_trap 3
; HSA-TRAP-GFX900-V3-NEXT:    global_store_dword v0, v2, s[0:1]
; HSA-TRAP-GFX900-V3-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX900-V3-NEXT:    s_endpgm
;
; HSA-TRAP-GFX900-V4-LABEL: debugtrap:
; HSA-TRAP-GFX900-V4:       ; %bb.0:
; HSA-TRAP-GFX900-V4-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-TRAP-GFX900-V4-NEXT:    v_mov_b32_e32 v0, 0
; HSA-TRAP-GFX900-V4-NEXT:    v_mov_b32_e32 v1, 1
; HSA-TRAP-GFX900-V4-NEXT:    v_mov_b32_e32 v2, 2
; HSA-TRAP-GFX900-V4-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-TRAP-GFX900-V4-NEXT:    global_store_dword v0, v1, s[0:1]
; HSA-TRAP-GFX900-V4-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX900-V4-NEXT:    s_trap 3
; HSA-TRAP-GFX900-V4-NEXT:    global_store_dword v0, v2, s[0:1]
; HSA-TRAP-GFX900-V4-NEXT:    s_waitcnt vmcnt(0)
; HSA-TRAP-GFX900-V4-NEXT:    s_endpgm
;
; HSA-NOTRAP-GFX900-V2-LABEL: debugtrap:
; HSA-NOTRAP-GFX900-V2:         .amd_kernel_code_t
; HSA-NOTRAP-GFX900-V2-NEXT:     amd_code_version_major = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     amd_code_version_minor = 2
; HSA-NOTRAP-GFX900-V2-NEXT:     amd_machine_kind = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     amd_machine_version_major = 9
; HSA-NOTRAP-GFX900-V2-NEXT:     amd_machine_version_minor = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     amd_machine_version_stepping = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     kernel_code_entry_byte_offset = 256
; HSA-NOTRAP-GFX900-V2-NEXT:     kernel_code_prefetch_byte_size = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     granulated_workitem_vgpr_count = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     granulated_wavefront_sgpr_count = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     priority = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     float_mode = 240
; HSA-NOTRAP-GFX900-V2-NEXT:     priv = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_dx10_clamp = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     debug_mode = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_ieee_mode = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_wgp_mode = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_mem_ordered = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_fwd_progress = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_private_segment_wave_byte_offset = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     user_sgpr_count = 8
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_trap_handler = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_id_x = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_id_y = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_id_z = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_workgroup_info = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_vgpr_workitem_id = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_exception_msb = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     granulated_lds_size = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_exception = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_private_segment_buffer = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_dispatch_ptr = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_queue_ptr = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_kernarg_segment_ptr = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_dispatch_id = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_flat_scratch_init = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_private_segment_size = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_grid_workgroup_count_x = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_grid_workgroup_count_y = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_sgpr_grid_workgroup_count_z = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_wavefront_size32 = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     enable_ordered_append_gds = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     private_element_size = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     is_ptr64 = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     is_dynamic_callstack = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     is_debug_enabled = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     is_xnack_enabled = 1
; HSA-NOTRAP-GFX900-V2-NEXT:     workitem_private_segment_byte_size = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     workgroup_group_segment_byte_size = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     gds_segment_byte_size = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     kernarg_segment_byte_size = 8
; HSA-NOTRAP-GFX900-V2-NEXT:     workgroup_fbarrier_count = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     wavefront_sgpr_count = 8
; HSA-NOTRAP-GFX900-V2-NEXT:     workitem_vgpr_count = 3
; HSA-NOTRAP-GFX900-V2-NEXT:     reserved_vgpr_first = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     reserved_vgpr_count = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     reserved_sgpr_first = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     reserved_sgpr_count = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     debug_wavefront_private_segment_offset_sgpr = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     debug_private_segment_buffer_sgpr = 0
; HSA-NOTRAP-GFX900-V2-NEXT:     kernarg_segment_alignment = 4
; HSA-NOTRAP-GFX900-V2-NEXT:     group_segment_alignment = 4
; HSA-NOTRAP-GFX900-V2-NEXT:     private_segment_alignment = 4
; HSA-NOTRAP-GFX900-V2-NEXT:     wavefront_size = 6
; HSA-NOTRAP-GFX900-V2-NEXT:     call_convention = -1
; HSA-NOTRAP-GFX900-V2-NEXT:     runtime_loader_kernel_symbol = 0
; HSA-NOTRAP-GFX900-V2-NEXT:    .end_amd_kernel_code_t
; HSA-NOTRAP-GFX900-V2-NEXT:  ; %bb.0:
; HSA-NOTRAP-GFX900-V2-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-NOTRAP-GFX900-V2-NEXT:    v_mov_b32_e32 v0, 0
; HSA-NOTRAP-GFX900-V2-NEXT:    v_mov_b32_e32 v1, 1
; HSA-NOTRAP-GFX900-V2-NEXT:    v_mov_b32_e32 v2, 2
; HSA-NOTRAP-GFX900-V2-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-NOTRAP-GFX900-V2-NEXT:    global_store_dword v0, v1, s[0:1]
; HSA-NOTRAP-GFX900-V2-NEXT:    s_waitcnt vmcnt(0)
; HSA-NOTRAP-GFX900-V2-NEXT:    global_store_dword v0, v2, s[0:1]
; HSA-NOTRAP-GFX900-V2-NEXT:    s_waitcnt vmcnt(0)
; HSA-NOTRAP-GFX900-V2-NEXT:    s_endpgm
;
; HSA-NOTRAP-GFX900-V3-LABEL: debugtrap:
; HSA-NOTRAP-GFX900-V3:       ; %bb.0:
; HSA-NOTRAP-GFX900-V3-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-NOTRAP-GFX900-V3-NEXT:    v_mov_b32_e32 v0, 0
; HSA-NOTRAP-GFX900-V3-NEXT:    v_mov_b32_e32 v1, 1
; HSA-NOTRAP-GFX900-V3-NEXT:    v_mov_b32_e32 v2, 2
; HSA-NOTRAP-GFX900-V3-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-NOTRAP-GFX900-V3-NEXT:    global_store_dword v0, v1, s[0:1]
; HSA-NOTRAP-GFX900-V3-NEXT:    s_waitcnt vmcnt(0)
; HSA-NOTRAP-GFX900-V3-NEXT:    global_store_dword v0, v2, s[0:1]
; HSA-NOTRAP-GFX900-V3-NEXT:    s_waitcnt vmcnt(0)
; HSA-NOTRAP-GFX900-V3-NEXT:    s_endpgm
;
; HSA-NOTRAP-GFX900-V4-LABEL: debugtrap:
; HSA-NOTRAP-GFX900-V4:       ; %bb.0:
; HSA-NOTRAP-GFX900-V4-NEXT:    s_load_dwordx2 s[0:1], s[6:7], 0x0
; HSA-NOTRAP-GFX900-V4-NEXT:    v_mov_b32_e32 v0, 0
; HSA-NOTRAP-GFX900-V4-NEXT:    v_mov_b32_e32 v1, 1
; HSA-NOTRAP-GFX900-V4-NEXT:    v_mov_b32_e32 v2, 2
; HSA-NOTRAP-GFX900-V4-NEXT:    s_waitcnt lgkmcnt(0)
; HSA-NOTRAP-GFX900-V4-NEXT:    global_store_dword v0, v1, s[0:1]
; HSA-NOTRAP-GFX900-V4-NEXT:    s_waitcnt vmcnt(0)
; HSA-NOTRAP-GFX900-V4-NEXT:    global_store_dword v0, v2, s[0:1]
; HSA-NOTRAP-GFX900-V4-NEXT:    s_waitcnt vmcnt(0)
; HSA-NOTRAP-GFX900-V4-NEXT:    s_endpgm
  store volatile i32 1, i32 addrspace(1)* %arg0
  call void @llvm.debugtrap()
  store volatile i32 2, i32 addrspace(1)* %arg0
  ret void
}

attributes #0 = { nounwind noreturn }
attributes #1 = { nounwind }
