; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=amdgcn-amd-amdhsa -mcpu=kaveri -mattr=-flat-for-global,+max-private-element-size-16 < %s | FileCheck -enable-var-scope -check-prefixes=GCN,SI %s
; RUN: llc -verify-machineinstrs -mtriple=amdgcn-amd-amdhsa -mcpu=tonga -mattr=-flat-for-global -mattr=+max-private-element-size-16 < %s | FileCheck -enable-var-scope -check-prefixes=GCN,VI %s

; FIXME: Broken on evergreen
; FIXME: For some reason the 8 and 16 vectors are being stored as
; individual elements instead of 128-bit stores.

define amdgpu_kernel void @insertelement_v2f32_0(<2 x float> addrspace(1)* %out, <2 x float> %a) nounwind {
; SI-LABEL: insertelement_v2f32_0:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x2
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, 0x40a00000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v2f32_0:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x8
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_mov_b32_e32 v0, 0x40a00000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <2 x float> %a, float 5.000000e+00, i32 0
  store <2 x float> %vecins, <2 x float> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @insertelement_v2f32_1(<2 x float> addrspace(1)* %out, <2 x float> %a) nounwind {
; SI-LABEL: insertelement_v2f32_1:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x2
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v1, 0x40a00000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v2f32_1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x8
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_mov_b32_e32 v1, 0x40a00000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <2 x float> %a, float 5.000000e+00, i32 1
  store <2 x float> %vecins, <2 x float> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @insertelement_v2i32_0(<2 x i32> addrspace(1)* %out, <2 x i32> %a) nounwind {
; SI-LABEL: insertelement_v2i32_0:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x2
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, 0x3e7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v2i32_0:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x8
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_mov_b32_e32 v0, 0x3e7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <2 x i32> %a, i32 999, i32 0
  store <2 x i32> %vecins, <2 x i32> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @insertelement_v2i32_1(<2 x i32> addrspace(1)* %out, <2 x i32> %a) nounwind {
; SI-LABEL: insertelement_v2i32_1:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x2
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v1, 0x3e7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v2i32_1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x8
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_mov_b32_e32 v1, 0x3e7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <2 x i32> %a, i32 999, i32 1
  store <2 x i32> %vecins, <2 x i32> addrspace(1)* %out, align 16
  ret void
}

; FIXME: Why is the constant moved into the intermediate register and
; not just directly into the vector component?
define amdgpu_kernel void @insertelement_v4f32_0(<4 x float> addrspace(1)* %out, <4 x float> %a) nounwind {
; SI-LABEL: insertelement_v4f32_0:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4
; SI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s0, 0x40a00000
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    v_mov_b32_e32 v3, s3
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v4f32_0:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, 0x40a00000
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <4 x float> %a, float 5.000000e+00, i32 0
  store <4 x float> %vecins, <4 x float> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @insertelement_v4f32_1(<4 x float> addrspace(1)* %out, <4 x float> %a) nounwind {
; SI-LABEL: insertelement_v4f32_1:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4
; SI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s1, 0x40a00000
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    v_mov_b32_e32 v3, s3
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v4f32_1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s1, 0x40a00000
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <4 x float> %a, float 5.000000e+00, i32 1
  store <4 x float> %vecins, <4 x float> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @insertelement_v4f32_2(<4 x float> addrspace(1)* %out, <4 x float> %a) nounwind {
; SI-LABEL: insertelement_v4f32_2:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4
; SI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s2, 0x40a00000
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    v_mov_b32_e32 v3, s3
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v4f32_2:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s2, 0x40a00000
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <4 x float> %a, float 5.000000e+00, i32 2
  store <4 x float> %vecins, <4 x float> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @insertelement_v4f32_3(<4 x float> addrspace(1)* %out, <4 x float> %a) nounwind {
; SI-LABEL: insertelement_v4f32_3:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4
; SI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s3, 0x40a00000
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    v_mov_b32_e32 v3, s3
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v4f32_3:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s3, 0x40a00000
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <4 x float> %a, float 5.000000e+00, i32 3
  store <4 x float> %vecins, <4 x float> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @insertelement_v4i32_0(<4 x i32> addrspace(1)* %out, <4 x i32> %a) nounwind {
; SI-LABEL: insertelement_v4i32_0:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4
; SI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_movk_i32 s0, 0x3e7
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    v_mov_b32_e32 v3, s3
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v4i32_0:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_movk_i32 s0, 0x3e7
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <4 x i32> %a, i32 999, i32 0
  store <4 x i32> %vecins, <4 x i32> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @insertelement_v3f32_1(<3 x float> addrspace(1)* %out, <3 x float> %a) nounwind {
; SI-LABEL: insertelement_v3f32_1:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4
; SI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v1, 0x40a00000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    buffer_store_dwordx3 v[0:2], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v3f32_1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    v_mov_b32_e32 v1, 0x40a00000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    buffer_store_dwordx3 v[0:2], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <3 x float> %a, float 5.000000e+00, i32 1
  store <3 x float> %vecins, <3 x float> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @insertelement_v3f32_2(<3 x float> addrspace(1)* %out, <3 x float> %a) nounwind {
; SI-LABEL: insertelement_v3f32_2:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4
; SI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v2, 0x40a00000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    buffer_store_dwordx3 v[0:2], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v3f32_2:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    v_mov_b32_e32 v2, 0x40a00000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    buffer_store_dwordx3 v[0:2], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <3 x float> %a, float 5.000000e+00, i32 2
  store <3 x float> %vecins, <3 x float> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @insertelement_v3f32_3(<3 x float> addrspace(1)* %out, <3 x float> %a) nounwind {
; GCN-LABEL: insertelement_v3f32_3:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_endpgm
  %vecins = insertelement <3 x float> %a, float 5.000000e+00, i32 3
  store <3 x float> %vecins, <3 x float> addrspace(1)* %out, align 16
  ret void
}

define <4 x float> @insertelement_to_sgpr() nounwind {
; GCN-LABEL: insertelement_to_sgpr:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_load_dwordx4 s[12:15], s[4:5], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s12, 0
; GCN-NEXT:    s_mov_b32 s4, s12
; GCN-NEXT:    s_mov_b32 s5, s12
; GCN-NEXT:    s_mov_b32 s6, s12
; GCN-NEXT:    s_mov_b32 s7, s12
; GCN-NEXT:    s_mov_b32 s8, s12
; GCN-NEXT:    s_mov_b32 s9, s12
; GCN-NEXT:    s_mov_b32 s10, s12
; GCN-NEXT:    s_mov_b32 s11, s12
; GCN-NEXT:    image_gather4_lz v[0:3], v[0:1], s[4:11], s[12:15] dmask:0x1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %tmp = load <4 x i32>, <4 x i32> addrspace(4)* undef
  %tmp1 = insertelement <4 x i32> %tmp, i32 0, i32 0
  %tmp2 = call <4 x float> @llvm.amdgcn.image.gather4.lz.2d.v4f32.f32(i32 1, float undef, float undef, <8 x i32> undef, <4 x i32> %tmp1, i1 0, i32 0, i32 0)
  ret <4 x float> %tmp2
}

define amdgpu_kernel void @dynamic_insertelement_v2f32(<2 x float> addrspace(1)* %out, <2 x float> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v2f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s6, s[4:5], 0x4
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x2
; SI-NEXT:    v_mov_b32_e32 v0, 0x40a00000
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s6, 1
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    s_cmp_lg_u32 s6, 0
; SI-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; SI-NEXT:    v_mov_b32_e32 v2, s4
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v2f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s6, s[4:5], 0x10
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x8
; VI-NEXT:    v_mov_b32_e32 v0, 0x40a00000
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s6, 1
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_cmp_lg_u32 s6, 0
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v2, s4
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <2 x float> %a, float 5.000000e+00, i32 %b
  store <2 x float> %vecins, <2 x float> addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v3f32(<3 x float> addrspace(1)* %out, <3 x float> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v3f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s8, s[4:5], 0x8
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x4
; SI-NEXT:    v_mov_b32_e32 v0, 0x40a00000
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s8, 2
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_mov_b32_e32 v1, s6
; SI-NEXT:    s_cmp_lg_u32 s8, 1
; SI-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s8, 0
; SI-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; SI-NEXT:    v_mov_b32_e32 v3, s4
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; SI-NEXT:    buffer_store_dwordx3 v[0:2], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v3f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s8, s[4:5], 0x20
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; VI-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x10
; VI-NEXT:    v_mov_b32_e32 v0, 0x40a00000
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s8, 2
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_mov_b32_e32 v1, s6
; VI-NEXT:    s_cmp_lg_u32 s8, 1
; VI-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_lg_u32 s8, 0
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v3, s4
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; VI-NEXT:    buffer_store_dwordx3 v[0:2], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <3 x float> %a, float 5.000000e+00, i32 %b
  store <3 x float> %vecins, <3 x float> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v4f32(<4 x float> addrspace(1)* %out, <4 x float> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v4f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s8, s[4:5], 0x8
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x4
; SI-NEXT:    v_mov_b32_e32 v0, 0x40a00000
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s8, 3
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    s_cmp_lg_u32 s8, 2
; SI-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; SI-NEXT:    v_mov_b32_e32 v1, s6
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s8, 1
; SI-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s8, 0
; SI-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; SI-NEXT:    v_mov_b32_e32 v4, s4
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v4f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s8, s[4:5], 0x20
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; VI-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x10
; VI-NEXT:    v_mov_b32_e32 v0, 0x40a00000
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s8, 3
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    s_cmp_lg_u32 s8, 2
; VI-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v1, s6
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_lg_u32 s8, 1
; VI-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_lg_u32 s8, 0
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <4 x float> %a, float 5.000000e+00, i32 %b
  store <4 x float> %vecins, <4 x float> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v8f32(<8 x float> addrspace(1)* %out, <8 x float> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v8f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s6, s[4:5], 0x10
; SI-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x8
; SI-NEXT:    v_mov_b32_e32 v4, 0x40a00000
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s6, 3
; SI-NEXT:    v_mov_b32_e32 v0, s11
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s6, 2
; SI-NEXT:    v_cndmask_b32_e32 v3, v4, v0, vcc
; SI-NEXT:    v_mov_b32_e32 v0, s10
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s6, 1
; SI-NEXT:    v_cndmask_b32_e32 v2, v4, v0, vcc
; SI-NEXT:    v_mov_b32_e32 v0, s9
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s6, 0
; SI-NEXT:    v_cndmask_b32_e32 v1, v4, v0, vcc
; SI-NEXT:    v_mov_b32_e32 v0, s8
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s6, 7
; SI-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; SI-NEXT:    v_mov_b32_e32 v5, s15
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s6, 6
; SI-NEXT:    v_cndmask_b32_e32 v7, v4, v5, vcc
; SI-NEXT:    v_mov_b32_e32 v5, s14
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s6, 5
; SI-NEXT:    v_cndmask_b32_e32 v6, v4, v5, vcc
; SI-NEXT:    v_mov_b32_e32 v5, s13
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s6, 4
; SI-NEXT:    v_cndmask_b32_e32 v5, v4, v5, vcc
; SI-NEXT:    v_mov_b32_e32 v8, s12
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_cndmask_b32_e32 v4, v4, v8, vcc
; SI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v8f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s6, s[4:5], 0x40
; VI-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x20
; VI-NEXT:    v_mov_b32_e32 v4, 0x40a00000
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s6, 3
; VI-NEXT:    v_mov_b32_e32 v0, s11
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_lg_u32 s6, 2
; VI-NEXT:    v_cndmask_b32_e32 v3, v4, v0, vcc
; VI-NEXT:    v_mov_b32_e32 v0, s10
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_lg_u32 s6, 1
; VI-NEXT:    v_cndmask_b32_e32 v2, v4, v0, vcc
; VI-NEXT:    v_mov_b32_e32 v0, s9
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_lg_u32 s6, 0
; VI-NEXT:    v_cndmask_b32_e32 v1, v4, v0, vcc
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_lg_u32 s6, 7
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; VI-NEXT:    v_mov_b32_e32 v5, s15
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_lg_u32 s6, 6
; VI-NEXT:    v_cndmask_b32_e32 v7, v4, v5, vcc
; VI-NEXT:    v_mov_b32_e32 v5, s14
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_lg_u32 s6, 5
; VI-NEXT:    v_cndmask_b32_e32 v6, v4, v5, vcc
; VI-NEXT:    v_mov_b32_e32 v5, s13
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_lg_u32 s6, 4
; VI-NEXT:    v_cndmask_b32_e32 v5, v4, v5, vcc
; VI-NEXT:    v_mov_b32_e32 v8, s12
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_cndmask_b32_e32 v4, v4, v8, vcc
; VI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <8 x float> %a, float 5.000000e+00, i32 %b
  store <8 x float> %vecins, <8 x float> addrspace(1)* %out, align 32
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v16f32(<16 x float> addrspace(1)* %out, <16 x float> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v16f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x10
; SI-NEXT:    s_load_dword s4, s[4:5], 0x20
; SI-NEXT:    v_mov_b32_e32 v16, 0x40a00000
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s8
; SI-NEXT:    v_mov_b32_e32 v1, s9
; SI-NEXT:    v_mov_b32_e32 v2, s10
; SI-NEXT:    v_mov_b32_e32 v3, s11
; SI-NEXT:    v_mov_b32_e32 v4, s12
; SI-NEXT:    v_mov_b32_e32 v5, s13
; SI-NEXT:    v_mov_b32_e32 v6, s14
; SI-NEXT:    v_mov_b32_e32 v7, s15
; SI-NEXT:    v_mov_b32_e32 v8, s16
; SI-NEXT:    v_mov_b32_e32 v9, s17
; SI-NEXT:    v_mov_b32_e32 v10, s18
; SI-NEXT:    v_mov_b32_e32 v11, s19
; SI-NEXT:    v_mov_b32_e32 v12, s20
; SI-NEXT:    v_mov_b32_e32 v13, s21
; SI-NEXT:    v_mov_b32_e32 v14, s22
; SI-NEXT:    v_mov_b32_e32 v15, s23
; SI-NEXT:    s_mov_b32 m0, s4
; SI-NEXT:    v_movreld_b32_e32 v0, v16
; SI-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0 offset:48
; SI-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:32
; SI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v16f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; VI-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x40
; VI-NEXT:    s_load_dword s4, s[4:5], 0x80
; VI-NEXT:    v_mov_b32_e32 v16, 0x40a00000
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    v_mov_b32_e32 v2, s10
; VI-NEXT:    v_mov_b32_e32 v3, s11
; VI-NEXT:    v_mov_b32_e32 v4, s12
; VI-NEXT:    v_mov_b32_e32 v5, s13
; VI-NEXT:    v_mov_b32_e32 v6, s14
; VI-NEXT:    v_mov_b32_e32 v7, s15
; VI-NEXT:    v_mov_b32_e32 v8, s16
; VI-NEXT:    v_mov_b32_e32 v9, s17
; VI-NEXT:    v_mov_b32_e32 v10, s18
; VI-NEXT:    v_mov_b32_e32 v11, s19
; VI-NEXT:    v_mov_b32_e32 v12, s20
; VI-NEXT:    v_mov_b32_e32 v13, s21
; VI-NEXT:    v_mov_b32_e32 v14, s22
; VI-NEXT:    v_mov_b32_e32 v15, s23
; VI-NEXT:    s_mov_b32 m0, s4
; VI-NEXT:    v_movreld_b32_e32 v0, v16
; VI-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0 offset:48
; VI-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:32
; VI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <16 x float> %a, float 5.000000e+00, i32 %b
  store <16 x float> %vecins, <16 x float> addrspace(1)* %out, align 64
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v2i32(<2 x i32> addrspace(1)* %out, <2 x i32> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v2i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s8, s[4:5], 0x4
; SI-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x2
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s8, 1
; SI-NEXT:    v_mov_b32_e32 v0, s7
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s8, 0
; SI-NEXT:    v_cndmask_b32_e32 v1, 5, v0, vcc
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_cndmask_b32_e32 v0, 5, v0, vcc
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v2i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s8, s[4:5], 0x10
; VI-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x8
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s8, 1
; VI-NEXT:    s_cselect_b32 s4, s7, 5
; VI-NEXT:    s_cmp_lg_u32 s8, 0
; VI-NEXT:    s_cselect_b32 s5, s6, 5
; VI-NEXT:    v_mov_b32_e32 v0, s5
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <2 x i32> %a, i32 5, i32 %b
  store <2 x i32> %vecins, <2 x i32> addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v3i32(<3 x i32> addrspace(1)* %out, <3 x i32> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v3i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s8, s[4:5], 0x8
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4
; SI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s8, 2
; SI-NEXT:    v_mov_b32_e32 v0, s2
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s8, 1
; SI-NEXT:    v_cndmask_b32_e32 v2, 5, v0, vcc
; SI-NEXT:    v_mov_b32_e32 v0, s1
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s8, 0
; SI-NEXT:    v_cndmask_b32_e32 v1, 5, v0, vcc
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_cndmask_b32_e32 v0, 5, v0, vcc
; SI-NEXT:    buffer_store_dwordx3 v[0:2], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v3i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s8, s[4:5], 0x20
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s8, 2
; VI-NEXT:    s_cselect_b32 s2, s2, 5
; VI-NEXT:    s_cmp_lg_u32 s8, 1
; VI-NEXT:    s_cselect_b32 s1, s1, 5
; VI-NEXT:    s_cmp_lg_u32 s8, 0
; VI-NEXT:    s_cselect_b32 s0, s0, 5
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    buffer_store_dwordx3 v[0:2], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <3 x i32> %a, i32 5, i32 %b
  store <3 x i32> %vecins, <3 x i32> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v4i32(<4 x i32> addrspace(1)* %out, <4 x i32> %a, i32 %b, [8 x i32], i32 %val) nounwind {
; SI-LABEL: dynamic_insertelement_v4i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s6, s[4:5], 0x8
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x4
; SI-NEXT:    s_load_dword s4, s[4:5], 0x11
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_eq_u32 s6, 3
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_mov_b32_e32 v0, s11
; SI-NEXT:    v_mov_b32_e32 v4, s4
; SI-NEXT:    s_cmp_eq_u32 s6, 2
; SI-NEXT:    v_cndmask_b32_e32 v3, v0, v4, vcc
; SI-NEXT:    v_mov_b32_e32 v0, s10
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s6, 1
; SI-NEXT:    v_cndmask_b32_e32 v2, v0, v4, vcc
; SI-NEXT:    v_mov_b32_e32 v0, s9
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s6, 0
; SI-NEXT:    v_cndmask_b32_e32 v1, v0, v4, vcc
; SI-NEXT:    v_mov_b32_e32 v0, s8
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v4i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; VI-NEXT:    s_load_dword s8, s[4:5], 0x20
; VI-NEXT:    s_load_dword s9, s[4:5], 0x44
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_eq_u32 s8, 3
; VI-NEXT:    s_cselect_b32 s3, s9, s3
; VI-NEXT:    s_cmp_eq_u32 s8, 2
; VI-NEXT:    s_cselect_b32 s2, s9, s2
; VI-NEXT:    s_cmp_eq_u32 s8, 1
; VI-NEXT:    s_cselect_b32 s1, s9, s1
; VI-NEXT:    s_cmp_eq_u32 s8, 0
; VI-NEXT:    s_cselect_b32 s0, s9, s0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <4 x i32> %a, i32 %val, i32 %b
  store <4 x i32> %vecins, <4 x i32> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v8i32(<8 x i32> addrspace(1)* %out, <8 x i32> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v8i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s6, s[4:5], 0x10
; SI-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x8
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s6, 3
; SI-NEXT:    v_mov_b32_e32 v0, s11
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s6, 2
; SI-NEXT:    v_cndmask_b32_e32 v3, 5, v0, vcc
; SI-NEXT:    v_mov_b32_e32 v0, s10
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s6, 1
; SI-NEXT:    v_cndmask_b32_e32 v2, 5, v0, vcc
; SI-NEXT:    v_mov_b32_e32 v0, s9
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s6, 0
; SI-NEXT:    v_cndmask_b32_e32 v1, 5, v0, vcc
; SI-NEXT:    v_mov_b32_e32 v0, s8
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s6, 7
; SI-NEXT:    v_cndmask_b32_e32 v0, 5, v0, vcc
; SI-NEXT:    v_mov_b32_e32 v4, s15
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s6, 6
; SI-NEXT:    v_cndmask_b32_e32 v7, 5, v4, vcc
; SI-NEXT:    v_mov_b32_e32 v4, s14
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s6, 5
; SI-NEXT:    v_cndmask_b32_e32 v6, 5, v4, vcc
; SI-NEXT:    v_mov_b32_e32 v4, s13
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s6, 4
; SI-NEXT:    v_cndmask_b32_e32 v5, 5, v4, vcc
; SI-NEXT:    v_mov_b32_e32 v4, s12
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_cndmask_b32_e32 v4, 5, v4, vcc
; SI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v8i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s6, s[4:5], 0x40
; VI-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x20
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s6, 3
; VI-NEXT:    s_cselect_b32 s4, s11, 5
; VI-NEXT:    s_cmp_lg_u32 s6, 2
; VI-NEXT:    s_cselect_b32 s5, s10, 5
; VI-NEXT:    s_cmp_lg_u32 s6, 1
; VI-NEXT:    s_cselect_b32 s7, s9, 5
; VI-NEXT:    s_cmp_lg_u32 s6, 0
; VI-NEXT:    s_cselect_b32 s8, s8, 5
; VI-NEXT:    s_cmp_lg_u32 s6, 7
; VI-NEXT:    s_cselect_b32 s9, s15, 5
; VI-NEXT:    s_cmp_lg_u32 s6, 6
; VI-NEXT:    s_cselect_b32 s10, s14, 5
; VI-NEXT:    s_cmp_lg_u32 s6, 5
; VI-NEXT:    s_cselect_b32 s11, s13, 5
; VI-NEXT:    s_cmp_lg_u32 s6, 4
; VI-NEXT:    s_cselect_b32 s6, s12, 5
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    v_mov_b32_e32 v1, s11
; VI-NEXT:    v_mov_b32_e32 v2, s10
; VI-NEXT:    v_mov_b32_e32 v3, s9
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0 offset:16
; VI-NEXT:    s_nop 0
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s5
; VI-NEXT:    v_mov_b32_e32 v3, s4
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <8 x i32> %a, i32 5, i32 %b
  store <8 x i32> %vecins, <8 x i32> addrspace(1)* %out, align 32
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v16i32(<16 x i32> addrspace(1)* %out, <16 x i32> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v16i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x10
; SI-NEXT:    s_load_dword s6, s[4:5], 0x20
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s8
; SI-NEXT:    v_mov_b32_e32 v1, s9
; SI-NEXT:    v_mov_b32_e32 v2, s10
; SI-NEXT:    v_mov_b32_e32 v3, s11
; SI-NEXT:    v_mov_b32_e32 v4, s12
; SI-NEXT:    v_mov_b32_e32 v5, s13
; SI-NEXT:    v_mov_b32_e32 v6, s14
; SI-NEXT:    v_mov_b32_e32 v7, s15
; SI-NEXT:    v_mov_b32_e32 v8, s16
; SI-NEXT:    v_mov_b32_e32 v9, s17
; SI-NEXT:    v_mov_b32_e32 v10, s18
; SI-NEXT:    v_mov_b32_e32 v11, s19
; SI-NEXT:    v_mov_b32_e32 v12, s20
; SI-NEXT:    v_mov_b32_e32 v13, s21
; SI-NEXT:    v_mov_b32_e32 v14, s22
; SI-NEXT:    v_mov_b32_e32 v15, s23
; SI-NEXT:    s_mov_b32 m0, s6
; SI-NEXT:    v_movreld_b32_e32 v0, 5
; SI-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0 offset:48
; SI-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:32
; SI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v16i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x40
; VI-NEXT:    s_load_dword s6, s[4:5], 0x80
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    v_mov_b32_e32 v2, s10
; VI-NEXT:    v_mov_b32_e32 v3, s11
; VI-NEXT:    v_mov_b32_e32 v4, s12
; VI-NEXT:    v_mov_b32_e32 v5, s13
; VI-NEXT:    v_mov_b32_e32 v6, s14
; VI-NEXT:    v_mov_b32_e32 v7, s15
; VI-NEXT:    v_mov_b32_e32 v8, s16
; VI-NEXT:    v_mov_b32_e32 v9, s17
; VI-NEXT:    v_mov_b32_e32 v10, s18
; VI-NEXT:    v_mov_b32_e32 v11, s19
; VI-NEXT:    v_mov_b32_e32 v12, s20
; VI-NEXT:    v_mov_b32_e32 v13, s21
; VI-NEXT:    v_mov_b32_e32 v14, s22
; VI-NEXT:    v_mov_b32_e32 v15, s23
; VI-NEXT:    s_mov_b32 m0, s6
; VI-NEXT:    v_movreld_b32_e32 v0, 5
; VI-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0 offset:48
; VI-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:32
; VI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <16 x i32> %a, i32 5, i32 %b
  store <16 x i32> %vecins, <16 x i32> addrspace(1)* %out, align 64
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v2i16(<2 x i16> addrspace(1)* %out, <2 x i16> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v2i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s6, s[4:5], 0x3
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    s_load_dword s4, s[4:5], 0x2
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b32 s5, s6, 4
; SI-NEXT:    s_lshl_b32 s5, 0xffff, s5
; SI-NEXT:    s_andn2_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s5, 0x50005
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v2i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s6, s[4:5], 0xc
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; VI-NEXT:    s_load_dword s4, s[4:5], 0x8
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b32 s5, s6, 4
; VI-NEXT:    s_lshl_b32 s5, 0xffff, s5
; VI-NEXT:    s_andn2_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s5, 0x50005
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <2 x i16> %a, i16 5, i32 %b
  store <2 x i16> %vecins, <2 x i16> addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v3i16(<3 x i16> addrspace(1)* %out, <3 x i16> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v3i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s6, s[4:5], 0x4
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x2
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b32 s8, s6, 4
; SI-NEXT:    s_mov_b64 s[6:7], 0xffff
; SI-NEXT:    s_lshl_b64 s[6:7], s[6:7], s8
; SI-NEXT:    s_mov_b32 s8, 0x50005
; SI-NEXT:    s_and_b32 s9, s7, s8
; SI-NEXT:    s_and_b32 s8, s6, s8
; SI-NEXT:    s_andn2_b64 s[4:5], s[4:5], s[6:7]
; SI-NEXT:    s_or_b64 s[4:5], s[8:9], s[4:5]
; SI-NEXT:    v_mov_b32_e32 v0, s5
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0 offset:4
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v3i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s6, s[4:5], 0x10
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x8
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b32 s8, s6, 4
; VI-NEXT:    s_mov_b64 s[6:7], 0xffff
; VI-NEXT:    s_lshl_b64 s[6:7], s[6:7], s8
; VI-NEXT:    s_mov_b32 s8, 0x50005
; VI-NEXT:    s_mov_b32 s9, s8
; VI-NEXT:    s_andn2_b64 s[4:5], s[4:5], s[6:7]
; VI-NEXT:    s_and_b64 s[6:7], s[6:7], s[8:9]
; VI-NEXT:    s_or_b64 s[4:5], s[6:7], s[4:5]
; VI-NEXT:    v_mov_b32_e32 v0, s5
; VI-NEXT:    buffer_store_short v0, off, s[0:3], 0 offset:4
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <3 x i16> %a, i16 5, i32 %b
  store <3 x i16> %vecins, <3 x i16> addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v2i8(<2 x i8> addrspace(1)* %out, [8 x i32], <2 x i8> %a, [8 x i32], i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v2i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s6, s[4:5], 0x13
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    s_load_dword s4, s[4:5], 0xa
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b32 s5, s6, 3
; SI-NEXT:    s_lshl_b32 s5, -1, s5
; SI-NEXT:    s_andn2_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s5, 0x505
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v2i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s6, s[4:5], 0x4c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; VI-NEXT:    s_load_dword s4, s[4:5], 0x28
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b32 s5, s6, 3
; VI-NEXT:    v_lshlrev_b16_e64 v0, s5, -1
; VI-NEXT:    v_not_b32_e32 v1, v0
; VI-NEXT:    v_and_b32_e32 v1, s4, v1
; VI-NEXT:    v_and_b32_e32 v0, 0x505, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <2 x i8> %a, i8 5, i32 %b
  store <2 x i8> %vecins, <2 x i8> addrspace(1)* %out, align 8
  ret void
}

; FIXME: post legalize i16 and i32 shifts aren't merged because of
; isTypeDesirableForOp in SimplifyDemandedBits
define amdgpu_kernel void @dynamic_insertelement_v3i8(<3 x i8> addrspace(1)* %out, [8 x i32], <3 x i8> %a, [8 x i32], i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v3i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s6, s[4:5], 0x13
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    s_load_dword s4, s[4:5], 0xa
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b32 s5, s6, 3
; SI-NEXT:    s_lshl_b32 s5, 0xffff, s5
; SI-NEXT:    s_andn2_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s5, 0x5050505
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_lshr_b32 s5, s4, 16
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    v_mov_b32_e32 v0, s5
; SI-NEXT:    buffer_store_byte v0, off, s[0:3], 0 offset:2
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v3i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s6, s[4:5], 0x4c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; VI-NEXT:    s_load_dword s4, s[4:5], 0x28
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b32 s5, s6, 3
; VI-NEXT:    s_lshl_b32 s5, 0xffff, s5
; VI-NEXT:    s_andn2_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s5, 0x5050505
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_lshr_b32 s5, s4, 16
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-NEXT:    v_mov_b32_e32 v0, s5
; VI-NEXT:    buffer_store_byte v0, off, s[0:3], 0 offset:2
; VI-NEXT:    s_endpgm
  %vecins = insertelement <3 x i8> %a, i8 5, i32 %b
  store <3 x i8> %vecins, <3 x i8> addrspace(1)* %out, align 4
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v4i8(<4 x i8> addrspace(1)* %out, [8 x i32], <4 x i8> %a, [8 x i32], i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v4i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s6, s[4:5], 0x13
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    s_load_dword s4, s[4:5], 0xa
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b32 s5, s6, 3
; SI-NEXT:    s_lshl_b32 s5, 0xffff, s5
; SI-NEXT:    s_andn2_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s5, 0x5050505
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v4i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s6, s[4:5], 0x4c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; VI-NEXT:    s_load_dword s4, s[4:5], 0x28
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b32 s5, s6, 3
; VI-NEXT:    s_lshl_b32 s5, 0xffff, s5
; VI-NEXT:    s_andn2_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s5, 0x5050505
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <4 x i8> %a, i8 5, i32 %b
  store <4 x i8> %vecins, <4 x i8> addrspace(1)* %out, align 4
  ret void
}

define amdgpu_kernel void @s_dynamic_insertelement_v8i8(<8 x i8> addrspace(1)* %out, <8 x i8> addrspace(4)* %a.ptr, i32 %b) nounwind {
; SI-LABEL: s_dynamic_insertelement_v8i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; SI-NEXT:    s_load_dword s8, s[4:5], 0x4
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; SI-NEXT:    s_lshl_b32 s8, s8, 3
; SI-NEXT:    s_mov_b64 s[2:3], 0xffff
; SI-NEXT:    s_lshl_b64 s[2:3], s[2:3], s8
; SI-NEXT:    s_mov_b32 s8, 0x5050505
; SI-NEXT:    s_and_b32 s9, s3, s8
; SI-NEXT:    s_and_b32 s8, s2, s8
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; SI-NEXT:    s_or_b64 s[0:1], s[8:9], s[0:1]
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_dynamic_insertelement_v8i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    s_load_dword s8, s[4:5], 0x10
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; VI-NEXT:    s_lshl_b32 s8, s8, 3
; VI-NEXT:    s_mov_b64 s[2:3], 0xffff
; VI-NEXT:    s_lshl_b64 s[2:3], s[2:3], s8
; VI-NEXT:    s_mov_b32 s8, 0x5050505
; VI-NEXT:    s_and_b32 s9, s3, s8
; VI-NEXT:    s_and_b32 s8, s2, s8
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; VI-NEXT:    s_or_b64 s[0:1], s[8:9], s[0:1]
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %a = load <8 x i8>, <8 x i8> addrspace(4)* %a.ptr, align 4
  %vecins = insertelement <8 x i8> %a, i8 5, i32 %b
  store <8 x i8> %vecins, <8 x i8> addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v16i8(<16 x i8> addrspace(1)* %out, <16 x i8> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v16i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x4
; SI-NEXT:    s_load_dword s6, s[4:5], 0x8
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshr_b32 s4, s11, 24
; SI-NEXT:    s_cmp_lg_u32 s6, 15
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_lshr_b32 s4, s11, 16
; SI-NEXT:    s_cmp_lg_u32 s6, 14
; SI-NEXT:    v_cndmask_b32_e32 v0, 5, v0, vcc
; SI-NEXT:    v_mov_b32_e32 v1, s4
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_cndmask_b32_e32 v1, 5, v1, vcc
; SI-NEXT:    s_movk_i32 s4, 0xff
; SI-NEXT:    s_lshr_b32 s5, s11, 8
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; SI-NEXT:    v_and_b32_e32 v1, s4, v1
; SI-NEXT:    s_cmp_lg_u32 s6, 13
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s6, 12
; SI-NEXT:    v_cndmask_b32_e32 v1, 5, v1, vcc
; SI-NEXT:    v_mov_b32_e32 v2, s11
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_cndmask_b32_e32 v2, 5, v2, vcc
; SI-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; SI-NEXT:    v_and_b32_e32 v2, s4, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    s_mov_b32 s5, 0xffff
; SI-NEXT:    s_lshr_b32 s7, s10, 24
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_and_b32_e32 v1, s5, v1
; SI-NEXT:    s_cmp_lg_u32 s6, 11
; SI-NEXT:    v_or_b32_e32 v3, v1, v0
; SI-NEXT:    v_mov_b32_e32 v0, s7
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_lshr_b32 s7, s10, 16
; SI-NEXT:    s_cmp_lg_u32 s6, 10
; SI-NEXT:    v_cndmask_b32_e32 v0, 5, v0, vcc
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_cndmask_b32_e32 v1, 5, v1, vcc
; SI-NEXT:    s_lshr_b32 s7, s10, 8
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; SI-NEXT:    v_and_b32_e32 v1, s4, v1
; SI-NEXT:    s_cmp_lg_u32 s6, 9
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s6, 8
; SI-NEXT:    v_cndmask_b32_e32 v1, 5, v1, vcc
; SI-NEXT:    v_mov_b32_e32 v2, s10
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_cndmask_b32_e32 v2, 5, v2, vcc
; SI-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; SI-NEXT:    v_and_b32_e32 v2, s4, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    s_lshr_b32 s7, s9, 24
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_and_b32_e32 v1, s5, v1
; SI-NEXT:    s_cmp_lg_u32 s6, 7
; SI-NEXT:    v_or_b32_e32 v2, v1, v0
; SI-NEXT:    v_mov_b32_e32 v0, s7
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_lshr_b32 s7, s9, 16
; SI-NEXT:    s_cmp_lg_u32 s6, 6
; SI-NEXT:    v_cndmask_b32_e32 v0, 5, v0, vcc
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_cndmask_b32_e32 v1, 5, v1, vcc
; SI-NEXT:    s_lshr_b32 s7, s9, 8
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; SI-NEXT:    v_and_b32_e32 v1, s4, v1
; SI-NEXT:    s_cmp_lg_u32 s6, 5
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s6, 4
; SI-NEXT:    v_cndmask_b32_e32 v1, 5, v1, vcc
; SI-NEXT:    v_mov_b32_e32 v4, s9
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_cndmask_b32_e32 v4, 5, v4, vcc
; SI-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; SI-NEXT:    v_and_b32_e32 v4, s4, v4
; SI-NEXT:    v_or_b32_e32 v1, v4, v1
; SI-NEXT:    s_lshr_b32 s7, s8, 24
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_and_b32_e32 v1, s5, v1
; SI-NEXT:    s_cmp_lg_u32 s6, 3
; SI-NEXT:    v_or_b32_e32 v1, v1, v0
; SI-NEXT:    v_mov_b32_e32 v0, s7
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_lshr_b32 s7, s8, 16
; SI-NEXT:    s_cmp_lg_u32 s6, 2
; SI-NEXT:    v_cndmask_b32_e32 v0, 5, v0, vcc
; SI-NEXT:    v_mov_b32_e32 v4, s7
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_cndmask_b32_e32 v4, 5, v4, vcc
; SI-NEXT:    s_lshr_b32 s7, s8, 8
; SI-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; SI-NEXT:    v_and_b32_e32 v4, s4, v4
; SI-NEXT:    s_cmp_lg_u32 s6, 1
; SI-NEXT:    v_or_b32_e32 v0, v4, v0
; SI-NEXT:    v_mov_b32_e32 v4, s7
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s6, 0
; SI-NEXT:    v_cndmask_b32_e32 v4, 5, v4, vcc
; SI-NEXT:    v_mov_b32_e32 v5, s8
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_cndmask_b32_e32 v5, 5, v5, vcc
; SI-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; SI-NEXT:    v_and_b32_e32 v5, s4, v5
; SI-NEXT:    v_or_b32_e32 v4, v5, v4
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_and_b32_e32 v4, s5, v4
; SI-NEXT:    v_or_b32_e32 v0, v4, v0
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v16i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x10
; VI-NEXT:    s_load_dword s6, s[4:5], 0x20
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s4, s11, 24
; VI-NEXT:    s_cmp_lg_u32 s6, 15
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_lshr_b32 s4, s11, 16
; VI-NEXT:    s_cmp_lg_u32 s6, 14
; VI-NEXT:    v_cndmask_b32_e32 v0, 5, v0, vcc
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_lshr_b32 s4, s11, 8
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; VI-NEXT:    v_cndmask_b32_e32 v1, 5, v1, vcc
; VI-NEXT:    s_cmp_lg_u32 s6, 13
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_lg_u32 s6, 12
; VI-NEXT:    v_cndmask_b32_e32 v1, 5, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v2, s11
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    v_cndmask_b32_e32 v2, 5, v2, vcc
; VI-NEXT:    s_lshr_b32 s4, s10, 24
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_cmp_lg_u32 s6, 11
; VI-NEXT:    v_or_b32_sdwa v3, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_lshr_b32 s4, s10, 16
; VI-NEXT:    s_cmp_lg_u32 s6, 10
; VI-NEXT:    v_cndmask_b32_e32 v0, 5, v0, vcc
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_lshr_b32 s4, s10, 8
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; VI-NEXT:    v_cndmask_b32_e32 v1, 5, v1, vcc
; VI-NEXT:    s_cmp_lg_u32 s6, 9
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_lg_u32 s6, 8
; VI-NEXT:    v_cndmask_b32_e32 v1, 5, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v2, s10
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    v_cndmask_b32_e32 v2, 5, v2, vcc
; VI-NEXT:    s_lshr_b32 s4, s9, 24
; VI-NEXT:    v_or_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_cmp_lg_u32 s6, 7
; VI-NEXT:    v_or_b32_sdwa v2, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_lshr_b32 s4, s9, 16
; VI-NEXT:    s_cmp_lg_u32 s6, 6
; VI-NEXT:    v_cndmask_b32_e32 v0, 5, v0, vcc
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_lshr_b32 s4, s9, 8
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; VI-NEXT:    v_cndmask_b32_e32 v1, 5, v1, vcc
; VI-NEXT:    s_cmp_lg_u32 s6, 5
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_lg_u32 s6, 4
; VI-NEXT:    v_cndmask_b32_e32 v1, 5, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v4, s9
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; VI-NEXT:    v_cndmask_b32_e32 v4, 5, v4, vcc
; VI-NEXT:    s_lshr_b32 s4, s8, 24
; VI-NEXT:    v_or_b32_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_cmp_lg_u32 s6, 3
; VI-NEXT:    v_or_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_lshr_b32 s4, s8, 16
; VI-NEXT:    s_cmp_lg_u32 s6, 2
; VI-NEXT:    v_cndmask_b32_e32 v0, 5, v0, vcc
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_lshr_b32 s4, s8, 8
; VI-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; VI-NEXT:    v_cndmask_b32_e32 v4, 5, v4, vcc
; VI-NEXT:    s_cmp_lg_u32 s6, 1
; VI-NEXT:    v_or_b32_sdwa v0, v4, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_lg_u32 s6, 0
; VI-NEXT:    v_cndmask_b32_e32 v4, 5, v4, vcc
; VI-NEXT:    v_mov_b32_e32 v5, s8
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_lshlrev_b16_e32 v4, 8, v4
; VI-NEXT:    v_cndmask_b32_e32 v5, 5, v5, vcc
; VI-NEXT:    v_or_b32_sdwa v4, v5, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <16 x i8> %a, i8 5, i32 %b
  store <16 x i8> %vecins, <16 x i8> addrspace(1)* %out, align 16
  ret void
}

; This test requires handling INSERT_SUBREG in SIFixSGPRCopies.  Check that
; the compiler doesn't crash.
define amdgpu_kernel void @insert_split_bb(<2 x i32> addrspace(1)* %out, i32 addrspace(1)* %in, i32 %a, i32 %b) {
; SI-LABEL: insert_split_bb:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dword s6, s[4:5], 0x4
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s6, 0
; SI-NEXT:    s_cbranch_scc0 .LBB30_4
; SI-NEXT:  ; %bb.1: ; %else
; SI-NEXT:    s_load_dword s7, s[2:3], 0x1
; SI-NEXT:    s_mov_b64 s[4:5], 0
; SI-NEXT:    s_andn2_b64 vcc, exec, s[4:5]
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 vcc, vcc
; SI-NEXT:    s_cbranch_vccnz .LBB30_3
; SI-NEXT:  .LBB30_2: ; %if
; SI-NEXT:    s_load_dword s7, s[2:3], 0x0
; SI-NEXT:  .LBB30_3: ; %endif
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
; SI-NEXT:  .LBB30_4:
; SI-NEXT:    s_branch .LBB30_2
;
; VI-LABEL: insert_split_bb:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dword s6, s[4:5], 0x10
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s6, 0
; VI-NEXT:    s_cbranch_scc0 .LBB30_4
; VI-NEXT:  ; %bb.1: ; %else
; VI-NEXT:    s_load_dword s7, s[2:3], 0x4
; VI-NEXT:    s_cbranch_execnz .LBB30_3
; VI-NEXT:  .LBB30_2: ; %if
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s7, s[2:3], 0x0
; VI-NEXT:  .LBB30_3: ; %endif
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
; VI-NEXT:  .LBB30_4:
; VI-NEXT:    s_branch .LBB30_2
entry:
  %0 = insertelement <2 x i32> undef, i32 %a, i32 0
  %1 = icmp eq i32 %a, 0
  br i1 %1, label %if, label %else

if:
  %2 = load i32, i32 addrspace(1)* %in
  %3 = insertelement <2 x i32> %0, i32 %2, i32 1
  br label %endif

else:
  %4 = getelementptr i32, i32 addrspace(1)* %in, i32 1
  %5 = load i32, i32 addrspace(1)* %4
  %6 = insertelement <2 x i32> %0, i32 %5, i32 1
  br label %endif

endif:
  %7 = phi <2 x i32> [%3, %if], [%6, %else]
  store <2 x i32> %7, <2 x i32> addrspace(1)* %out
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v2f64(<2 x double> addrspace(1)* %out, [8 x i32], <2 x double> %a, [8 x i32], i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v2f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s8, s[4:5], 0x18
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0xc
; SI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; SI-NEXT:    v_mov_b32_e32 v1, 0x40200000
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_eq_u32 s8, 1
; SI-NEXT:    v_mov_b32_e32 v0, s3
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; SI-NEXT:    v_mov_b32_e32 v0, s2
; SI-NEXT:    s_cmp_eq_u32 s8, 0
; SI-NEXT:    v_cndmask_b32_e64 v2, v0, 0, vcc
; SI-NEXT:    v_mov_b32_e32 v0, s1
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v2f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s8, s[4:5], 0x60
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x30
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; VI-NEXT:    v_mov_b32_e32 v1, 0x40200000
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_eq_u32 s8, 1
; VI-NEXT:    v_mov_b32_e32 v0, s3
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    s_cmp_eq_u32 s8, 0
; VI-NEXT:    v_cndmask_b32_e64 v2, v0, 0, vcc
; VI-NEXT:    v_mov_b32_e32 v0, s1
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <2 x double> %a, double 8.0, i32 %b
  store <2 x double> %vecins, <2 x double> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v2i64(<2 x i64> addrspace(1)* %out, <2 x i64> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v2i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s10, s[4:5], 0x8
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4
; SI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_eq_u32 s10, 1
; SI-NEXT:    v_mov_b32_e32 v0, s3
; SI-NEXT:    s_cselect_b64 s[8:9], -1, 0
; SI-NEXT:    v_cndmask_b32_e64 v3, v0, 0, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v0, s2
; SI-NEXT:    s_cmp_eq_u32 s10, 0
; SI-NEXT:    v_cndmask_b32_e64 v2, v0, 5, s[8:9]
; SI-NEXT:    v_mov_b32_e32 v0, s1
; SI-NEXT:    s_cselect_b64 s[2:3], -1, 0
; SI-NEXT:    v_cndmask_b32_e64 v1, v0, 0, s[2:3]
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_cndmask_b32_e64 v0, v0, 5, s[2:3]
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v2i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s10, s[4:5], 0x20
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_eq_u32 s10, 1
; VI-NEXT:    v_mov_b32_e32 v0, s3
; VI-NEXT:    s_cselect_b64 s[8:9], -1, 0
; VI-NEXT:    v_cndmask_b32_e64 v3, v0, 0, s[8:9]
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    s_cmp_eq_u32 s10, 0
; VI-NEXT:    v_cndmask_b32_e64 v2, v0, 5, s[8:9]
; VI-NEXT:    v_mov_b32_e32 v0, s1
; VI-NEXT:    s_cselect_b64 s[2:3], -1, 0
; VI-NEXT:    v_cndmask_b32_e64 v1, v0, 0, s[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_cndmask_b32_e64 v0, v0, 5, s[2:3]
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <2 x i64> %a, i64 5, i32 %b
  store <2 x i64> %vecins, <2 x i64> addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v3i64(<3 x i64> addrspace(1)* %out, <3 x i64> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v3i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s12, s[4:5], 0x10
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x8
; SI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xc
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_eq_u32 s12, 1
; SI-NEXT:    s_cselect_b64 s[6:7], -1, 0
; SI-NEXT:    v_mov_b32_e32 v0, s11
; SI-NEXT:    v_cndmask_b32_e64 v3, v0, 0, s[6:7]
; SI-NEXT:    v_mov_b32_e32 v0, s10
; SI-NEXT:    s_cmp_eq_u32 s12, 0
; SI-NEXT:    v_cndmask_b32_e64 v2, v0, 5, s[6:7]
; SI-NEXT:    v_mov_b32_e32 v0, s9
; SI-NEXT:    s_cselect_b64 s[6:7], -1, 0
; SI-NEXT:    v_cndmask_b32_e64 v1, v0, 0, s[6:7]
; SI-NEXT:    v_mov_b32_e32 v0, s8
; SI-NEXT:    s_cmp_eq_u32 s12, 2
; SI-NEXT:    v_cndmask_b32_e64 v0, v0, 5, s[6:7]
; SI-NEXT:    v_mov_b32_e32 v4, s5
; SI-NEXT:    s_cselect_b64 s[6:7], -1, 0
; SI-NEXT:    v_cndmask_b32_e64 v5, v4, 0, s[6:7]
; SI-NEXT:    v_mov_b32_e32 v4, s4
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_cndmask_b32_e64 v4, v4, 5, s[6:7]
; SI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[0:3], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v3i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s12, s[4:5], 0x40
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; VI-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x20
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x30
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_eq_u32 s12, 1
; VI-NEXT:    s_cselect_b64 s[6:7], -1, 0
; VI-NEXT:    v_mov_b32_e32 v0, s11
; VI-NEXT:    v_cndmask_b32_e64 v3, v0, 0, s[6:7]
; VI-NEXT:    v_mov_b32_e32 v0, s10
; VI-NEXT:    s_cmp_eq_u32 s12, 0
; VI-NEXT:    v_cndmask_b32_e64 v2, v0, 5, s[6:7]
; VI-NEXT:    v_mov_b32_e32 v0, s9
; VI-NEXT:    s_cselect_b64 s[6:7], -1, 0
; VI-NEXT:    v_cndmask_b32_e64 v1, v0, 0, s[6:7]
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    s_cmp_eq_u32 s12, 2
; VI-NEXT:    v_cndmask_b32_e64 v0, v0, 5, s[6:7]
; VI-NEXT:    v_mov_b32_e32 v4, s5
; VI-NEXT:    s_cselect_b64 s[6:7], -1, 0
; VI-NEXT:    v_cndmask_b32_e64 v5, v4, 0, s[6:7]
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_cndmask_b32_e64 v4, v4, 5, s[6:7]
; VI-NEXT:    buffer_store_dwordx2 v[4:5], off, s[0:3], 0 offset:16
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <3 x i64> %a, i64 5, i32 %b
  store <3 x i64> %vecins, <3 x i64> addrspace(1)* %out, align 32
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v4f64(<4 x double> addrspace(1)* %out, <4 x double> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v4f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s6, s[4:5], 0x10
; SI-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x8
; SI-NEXT:    v_mov_b32_e32 v4, 0x40200000
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_eq_u32 s6, 1
; SI-NEXT:    v_mov_b32_e32 v0, s11
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_cndmask_b32_e32 v3, v0, v4, vcc
; SI-NEXT:    v_mov_b32_e32 v0, s10
; SI-NEXT:    s_cmp_eq_u32 s6, 0
; SI-NEXT:    v_cndmask_b32_e64 v2, v0, 0, vcc
; SI-NEXT:    v_mov_b32_e32 v0, s9
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_cndmask_b32_e32 v1, v0, v4, vcc
; SI-NEXT:    v_mov_b32_e32 v0, s8
; SI-NEXT:    s_cmp_eq_u32 s6, 3
; SI-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; SI-NEXT:    v_mov_b32_e32 v5, s15
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_cndmask_b32_e32 v7, v5, v4, vcc
; SI-NEXT:    v_mov_b32_e32 v5, s14
; SI-NEXT:    s_cmp_eq_u32 s6, 2
; SI-NEXT:    v_cndmask_b32_e64 v6, v5, 0, vcc
; SI-NEXT:    v_mov_b32_e32 v5, s13
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_cndmask_b32_e32 v5, v5, v4, vcc
; SI-NEXT:    v_mov_b32_e32 v4, s12
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_cndmask_b32_e64 v4, v4, 0, vcc
; SI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v4f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s6, s[4:5], 0x40
; VI-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x20
; VI-NEXT:    v_mov_b32_e32 v4, 0x40200000
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_eq_u32 s6, 1
; VI-NEXT:    v_mov_b32_e32 v0, s11
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_cndmask_b32_e32 v3, v0, v4, vcc
; VI-NEXT:    v_mov_b32_e32 v0, s10
; VI-NEXT:    s_cmp_eq_u32 s6, 0
; VI-NEXT:    v_cndmask_b32_e64 v2, v0, 0, vcc
; VI-NEXT:    v_mov_b32_e32 v0, s9
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v4, vcc
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    s_cmp_eq_u32 s6, 3
; VI-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; VI-NEXT:    v_mov_b32_e32 v5, s15
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_cndmask_b32_e32 v7, v5, v4, vcc
; VI-NEXT:    v_mov_b32_e32 v5, s14
; VI-NEXT:    s_cmp_eq_u32 s6, 2
; VI-NEXT:    v_cndmask_b32_e64 v6, v5, 0, vcc
; VI-NEXT:    v_mov_b32_e32 v5, s13
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_cndmask_b32_e32 v5, v5, v4, vcc
; VI-NEXT:    v_mov_b32_e32 v4, s12
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_cndmask_b32_e64 v4, v4, 0, vcc
; VI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <4 x double> %a, double 8.0, i32 %b
  store <4 x double> %vecins, <4 x double> addrspace(1)* %out, align 16
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v8f64(<8 x double> addrspace(1)* %out, <8 x double> %a, i32 %b) #0 {
; SI-LABEL: dynamic_insertelement_v8f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s6, s[4:5], 0x20
; SI-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x10
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SI-NEXT:    v_mov_b32_e32 v16, 0x40200000
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b32 s4, s6, 1
; SI-NEXT:    v_mov_b32_e32 v0, s8
; SI-NEXT:    v_mov_b32_e32 v1, s9
; SI-NEXT:    v_mov_b32_e32 v2, s10
; SI-NEXT:    v_mov_b32_e32 v3, s11
; SI-NEXT:    v_mov_b32_e32 v4, s12
; SI-NEXT:    v_mov_b32_e32 v5, s13
; SI-NEXT:    v_mov_b32_e32 v6, s14
; SI-NEXT:    v_mov_b32_e32 v7, s15
; SI-NEXT:    v_mov_b32_e32 v8, s16
; SI-NEXT:    v_mov_b32_e32 v9, s17
; SI-NEXT:    v_mov_b32_e32 v10, s18
; SI-NEXT:    v_mov_b32_e32 v11, s19
; SI-NEXT:    v_mov_b32_e32 v12, s20
; SI-NEXT:    v_mov_b32_e32 v13, s21
; SI-NEXT:    v_mov_b32_e32 v14, s22
; SI-NEXT:    v_mov_b32_e32 v15, s23
; SI-NEXT:    s_mov_b32 m0, s4
; SI-NEXT:    v_movreld_b32_e32 v0, 0
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_movreld_b32_e32 v1, v16
; SI-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0 offset:48
; SI-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:32
; SI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v8f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s6, s[4:5], 0x80
; VI-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x40
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; VI-NEXT:    v_mov_b32_e32 v16, 0x40200000
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b32 s4, s6, 1
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    v_mov_b32_e32 v2, s10
; VI-NEXT:    v_mov_b32_e32 v3, s11
; VI-NEXT:    v_mov_b32_e32 v4, s12
; VI-NEXT:    v_mov_b32_e32 v5, s13
; VI-NEXT:    v_mov_b32_e32 v6, s14
; VI-NEXT:    v_mov_b32_e32 v7, s15
; VI-NEXT:    v_mov_b32_e32 v8, s16
; VI-NEXT:    v_mov_b32_e32 v9, s17
; VI-NEXT:    v_mov_b32_e32 v10, s18
; VI-NEXT:    v_mov_b32_e32 v11, s19
; VI-NEXT:    v_mov_b32_e32 v12, s20
; VI-NEXT:    v_mov_b32_e32 v13, s21
; VI-NEXT:    v_mov_b32_e32 v14, s22
; VI-NEXT:    v_mov_b32_e32 v15, s23
; VI-NEXT:    s_mov_b32 m0, s4
; VI-NEXT:    v_movreld_b32_e32 v0, 0
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_movreld_b32_e32 v1, v16
; VI-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0 offset:48
; VI-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:32
; VI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <8 x double> %a, double 8.0, i32 %b
  store <8 x double> %vecins, <8 x double> addrspace(1)* %out, align 16
  ret void
}

declare <4 x float> @llvm.amdgcn.image.gather4.lz.2d.v4f32.f32(i32, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone }
