/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#include "change_dir.h"
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <dirent.h>
#include <string.h>


ChangeDir::ChangeDir( QString document, QString path)
    : documentText(document), pathText(path)
{
#ifdef WIN32
    slash = QString("\\");
#elif defined (linux)
    slash = QString("/");
#elif defined __APPLE__
    slash = QString("/");
#else
    slash = QString("/");
#endif
}

QString ChangeDir::cd_Handling(QString pathToHandle)
{

#ifdef WIN32
    if (pathToHandle.size() <= 3 && pathToHandle.contains(":")) {
        if (QString::compare(documentText, QString(".."), Qt::CaseInsensitive) == 0) {
            return QString(CONTENT_DRIVE);
        }
    } else if (QString::compare(pathToHandle, QString(CONTENT_DRIVE), Qt::CaseInsensitive) == 0) {
        return documentText;
    }
#endif
    if (QString::compare(documentText, QString(".."), Qt::CaseInsensitive) == 0) {
        if (QString::compare(pathToHandle, QString("/"), Qt::CaseInsensitive) != 0) {
            QString pathShortened = cd_DotDot_Handling(pathToHandle);
            if (pathShortened.contains(directory))
                return pathShortened;
            else
                return directory;
        } else return pathToHandle;
    } else if (QString::compare(documentText, QString("."), Qt::CaseInsensitive) == 0) {
        if (pathText.contains(directory))
            return pathText;
        else
            return directory;
    } else {
        QString finalPath = pathText + slash + documentText;
        finalPath = finalPath.replace("//", "/");
        if (!finalPath.contains(directory))
            return directory;
        if (isDirectory(finalPath) == 1)
            return finalPath;
        else
            return pathText;
    }
}

int ChangeDir::isDirectory(QString pathToHandle)
{
    QDir target(pathToHandle);
    if( target.exists() )
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

QString ChangeDir::cd_DotDot_Handling(QString qStringPathToReduce)
{
    QString result = "";
    QStringList list = qStringPathToReduce.split(slash, QString::SkipEmptyParts);
    list.removeLast();
#ifdef WIN32
#elif defined (linux)
    result.append(slash);
#elif defined __APPLE__
    result.append(slash);
#else
    result.append(slash);
#endif
    for (int i = 0; i < list.size(); ++i) {
        result.append(list.at(i));
        if (i != (list.size() - 1))
            result.append(slash);
    }
#ifdef WIN32
    if (result.size() == 2 && result.contains(":")) {
        result = result + "\\";
    }
#endif
    return result;
}


