/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AsciiFilteredInputStream;
import com.microsoft.sqlserver.jdbc.AsciiFilteredUnicodeInputStream;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.PLPInputStream;
import com.microsoft.sqlserver.jdbc.PLPXMLInputStream;
import com.microsoft.sqlserver.jdbc.SQLServerBlob;
import com.microsoft.sqlserver.jdbc.SQLServerClob;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.ServerDTVImpl;
import com.microsoft.sqlserver.jdbc.SimpleInputStream;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

final class DDC {
    static final int STREAM_NONE = 0;
    static final int STREAM_BINARY = 1;
    static final int STREAM_CHARACTER = 2;
    static final int STREAM_ASCII = 3;
    static final Double zeroDouble = new Double(0.0);
    static final Float zeroFloat = new Float(0.0f);
    static final BigDecimal zeroBigDecimal = new BigDecimal(0.0);
    private static final BigInteger maxRPCDecimalValue = new BigInteger("99999999999999999999999999999999999999");

    DDC() {
    }

    static final Object convertIntegerToObject(int n, int n2, int n3, int n4) {
        switch (n3) {
            case 4: {
                return new Integer(n);
            }
            case -6: 
            case 5: {
                return new Short((short)n);
            }
            case -7: 
            case 16: {
                return new Boolean(0 != n);
            }
            case -5: {
                return new Long(n);
            }
            case 2: 
            case 3: {
                return new BigDecimal(Integer.toString(n));
            }
            case 8: {
                return new Double(n);
            }
            case 6: 
            case 7: {
                return new Float(n);
            }
            case -2: {
                return DDC.convertIntToBytes(n, n2);
            }
        }
        if (2 == n4) {
            return new StringReader(Integer.toString(n));
        }
        return Integer.toString(n);
    }

    static final Object convertLongToObject(long l, int n, int n2) {
        switch (n) {
            case -5: {
                return new Long(l);
            }
            case 4: {
                return new Integer((int)l);
            }
            case -6: 
            case 5: {
                return new Short((short)l);
            }
            case -7: 
            case 16: {
                return new Boolean(0L != l);
            }
            case 2: 
            case 3: {
                return new BigDecimal(Long.toString(l));
            }
            case 8: {
                return new Double(l);
            }
            case 6: 
            case 7: {
                return new Float(l);
            }
            case -2: {
                return DDC.convertLongToBytes(l);
            }
        }
        if (2 == n2) {
            return new StringReader(Long.toString(l));
        }
        return Long.toString(l);
    }

    static final byte[] convertIntToBytes(int n, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = n2;
        while (n3-- > 0) {
            byArray[n3] = (byte)(n & 0xFF);
            n >>= 8;
        }
        return byArray;
    }

    static final Object convertFloatToObject(float f, int n, int n2) {
        switch (n) {
            case 6: 
            case 7: {
                return new Float(f);
            }
            case 4: {
                return new Integer((int)f);
            }
            case -6: 
            case 5: {
                return new Short((short)f);
            }
            case -7: 
            case 16: {
                return new Boolean(0.0f != f);
            }
            case -5: {
                return new Long((long)f);
            }
            case 2: 
            case 3: {
                return new BigDecimal(Float.toString(f));
            }
            case 8: {
                return new Double(new Float(f).doubleValue());
            }
            case -2: {
                return DDC.convertIntToBytes(Float.floatToRawIntBits(f), 4);
            }
        }
        String string = Float.toString(f);
        if (2 == n2) {
            return new StringReader(string);
        }
        return string;
    }

    static final byte[] convertLongToBytes(long l) {
        byte[] byArray = new byte[8];
        int n = 8;
        while (n-- > 0) {
            byArray[n] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return byArray;
    }

    static final Object convertDoubleToObject(double d, int n, int n2) {
        switch (n) {
            case 8: {
                return new Double(d);
            }
            case 6: 
            case 7: {
                return new Float(new Double(d).floatValue());
            }
            case 4: {
                return new Integer((int)d);
            }
            case -6: 
            case 5: {
                return new Short((short)d);
            }
            case -7: 
            case 16: {
                return new Boolean(0.0 != d);
            }
            case -5: {
                return new Long((long)d);
            }
            case 2: 
            case 3: {
                return new BigDecimal(Double.toString(d));
            }
            case -2: {
                return DDC.convertLongToBytes(Double.doubleToRawLongBits(d));
            }
        }
        String string = Double.toString(d);
        if (2 == n2) {
            return new StringReader(string);
        }
        return string;
    }

    static final byte[] convertBigDecimalToBytes(BigDecimal bigDecimal, int n) {
        byte[] byArray;
        if (bigDecimal == null) {
            byArray = new byte[]{(byte)n, 0};
        } else {
            boolean bl;
            boolean bl2 = bl = bigDecimal.signum() < 0;
            if (bigDecimal.scale() < 0) {
                bigDecimal = bigDecimal.setScale(0);
            }
            BigInteger bigInteger = bigDecimal.unscaledValue();
            if (bl) {
                bigInteger = bigInteger.negate();
            }
            byte[] byArray2 = bigInteger.toByteArray();
            byArray = new byte[byArray2.length + 3];
            int n2 = 0;
            byArray[n2++] = (byte)bigDecimal.scale();
            byArray[n2++] = (byte)(byArray2.length + 1);
            byArray[n2++] = (byte)(!bl ? 1 : 0);
            for (int i = byArray2.length - 1; i >= 0; --i) {
                byArray[n2++] = byArray2[i];
            }
        }
        return byArray;
    }

    static final Object convertBigDecimalToObject(BigDecimal bigDecimal, int n, int n2) {
        switch (n) {
            case 2: 
            case 3: {
                return bigDecimal;
            }
            case 8: {
                return new Double(bigDecimal.doubleValue());
            }
            case 6: 
            case 7: {
                return new Float(bigDecimal.floatValue());
            }
            case 4: {
                return new Integer(bigDecimal.intValue());
            }
            case -6: 
            case 5: {
                return new Short(bigDecimal.shortValue());
            }
            case -7: 
            case 16: {
                return new Boolean(0 != bigDecimal.compareTo(zeroBigDecimal));
            }
            case -5: {
                return new Long(bigDecimal.longValue());
            }
            case -2: {
                return DDC.convertBigDecimalToBytes(bigDecimal, bigDecimal.scale());
            }
        }
        if (2 == n2) {
            return new StringReader(bigDecimal.toString());
        }
        return bigDecimal.toString();
    }

    static final Object convertStringToObject(String string, String string2, int n, int n2) throws SQLServerException {
        switch (n) {
            case 2: 
            case 3: {
                return new BigDecimal(string.trim());
            }
            case 8: {
                return Double.valueOf(string.trim());
            }
            case 6: 
            case 7: {
                return Float.valueOf(string.trim());
            }
            case 4: {
                return Integer.valueOf(string.trim());
            }
            case -6: 
            case 5: {
                return Short.valueOf(string.trim());
            }
            case -7: 
            case 16: {
                String string3 = string.trim();
                return 1 == string3.length() ? Boolean.valueOf('1' == string3.charAt(0)) : Boolean.valueOf(string3);
            }
            case -5: {
                return Long.valueOf(string.trim());
            }
            case 93: {
                return Timestamp.valueOf(string.trim());
            }
            case 91: {
                return Date.valueOf(DDC.getDatePart(string.trim()));
            }
            case 92: {
                Timestamp timestamp = Timestamp.valueOf("1970-01-01 " + DDC.getTimePart(string.trim()));
                return new Time(timestamp.getTime());
            }
            case 2005: {
                return new SQLServerClob(null, string);
            }
            case -2: {
                try {
                    return string.getBytes(string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLServerException(null, unsupportedEncodingException.getMessage(), null, 0, true);
                }
            }
        }
        switch (n2) {
            case 2: {
                return new StringReader(string);
            }
            case 3: {
                try {
                    return new ByteArrayInputStream(string.getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLServerException(null, unsupportedEncodingException.getMessage(), null, 0, true);
                }
            }
            case 1: {
                return new ByteArrayInputStream(string.getBytes());
            }
        }
        return string;
    }

    static final Object binaryPLPToObject(TDSReader tDSReader, int n, InputStreamGetterArgs inputStreamGetterArgs, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        PLPInputStream pLPInputStream = PLPInputStream.makeStream(tDSReader, inputStreamGetterArgs, serverDTVImpl);
        if (null == pLPInputStream) {
            return null;
        }
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                if (3 == inputStreamGetterArgs.streamType) {
                    return pLPInputStream;
                }
                byte[] byArray = pLPInputStream.getBytes();
                String string = Util.bytesToHexString(byArray, byArray.length);
                if (2 == inputStreamGetterArgs.streamType) {
                    return new StringReader(string);
                }
                return string;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                if (1 == inputStreamGetterArgs.streamType) {
                    return pLPInputStream;
                }
                byte[] byArray = pLPInputStream.getBytes();
                if (2004 == n) {
                    return new SQLServerBlob(null, byArray);
                }
                return byArray;
            }
        }
        return null;
    }

    static final Object xmlPLPToObject(TDSReader tDSReader, int n, InputStreamGetterArgs inputStreamGetterArgs, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        switch (n) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                Reader reader;
                PLPInputStream pLPInputStream = PLPInputStream.makeStream(tDSReader, inputStreamGetterArgs, serverDTVImpl);
                if (null == pLPInputStream) {
                    return null;
                }
                try {
                    reader = inputStreamGetterArgs.isAdaptive ? new BufferedReader(new InputStreamReader((InputStream)pLPInputStream, "UTF-16LE")) : new StringReader(new String(pLPInputStream.getBytes(), "UTF-16LE"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLServerException(null, unsupportedEncodingException.getMessage(), null, 0, true);
                }
                if (2 == inputStreamGetterArgs.streamType) {
                    return reader;
                }
                return DDC.convertStringToObject(DDC.convertReaderToString(reader, pLPInputStream.getLength()), "UTF-16LE", n, inputStreamGetterArgs.streamType);
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                PLPXMLInputStream pLPXMLInputStream = PLPXMLInputStream.makeXMLStream(tDSReader, inputStreamGetterArgs, serverDTVImpl);
                if (null == pLPXMLInputStream) {
                    return null;
                }
                if (1 == inputStreamGetterArgs.streamType) {
                    return pLPXMLInputStream;
                }
                byte[] byArray = pLPXMLInputStream.getBytes();
                if (2004 == n) {
                    return new SQLServerBlob(null, byArray);
                }
                return byArray;
            }
        }
        return null;
    }

    static final Object convertNonUnicodeNonPLPToObject(TDSReader tDSReader, int n, TypeInfo typeInfo, int n2, InputStreamGetterArgs inputStreamGetterArgs, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        InputStreamReader inputStreamReader;
        SimpleInputStream simpleInputStream = new SimpleInputStream(tDSReader, n, inputStreamGetterArgs, serverDTVImpl);
        if (3 == inputStreamGetterArgs.streamType && typeInfo.getSQLCollation().supportsFastAsciiConversion()) {
            return new AsciiFilteredInputStream(simpleInputStream);
        }
        try {
            inputStreamReader = new InputStreamReader((InputStream)simpleInputStream, typeInfo.getSQLCollation().getCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLServerException(null, unsupportedEncodingException.getMessage(), null, 0, true);
        }
        if (3 == inputStreamGetterArgs.streamType && inputStreamGetterArgs.isAdaptive) {
            return AsciiFilteredUnicodeInputStream.MakeAsciiFilteredUnicodeInputStream(simpleInputStream, new BufferedReader(inputStreamReader));
        }
        return DDC.convertStringToObject(DDC.convertReaderToString(inputStreamReader, n), typeInfo.getSQLCollation().getCharset(), n2, inputStreamGetterArgs.streamType);
    }

    static final Object characterPLPToObject(TDSReader tDSReader, TypeInfo typeInfo, int n, InputStreamGetterArgs inputStreamGetterArgs, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        PLPInputStream pLPInputStream = PLPInputStream.makeStream(tDSReader, inputStreamGetterArgs, serverDTVImpl);
        if (null == pLPInputStream) {
            return null;
        }
        switch (n) {
            default: {
                Reader reader;
                if (231 == typeInfo.getNativeType()) {
                    try {
                        if (inputStreamGetterArgs.isAdaptive) {
                            reader = new BufferedReader(new InputStreamReader((InputStream)pLPInputStream, "UTF-16LE"));
                        }
                        reader = new StringReader(new String(pLPInputStream.getBytes(), "UTF-16LE"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new SQLServerException(null, unsupportedEncodingException.getMessage(), null, 0, true);
                    }
                } else {
                    if (3 == inputStreamGetterArgs.streamType && typeInfo.getSQLCollation().supportsFastAsciiConversion()) {
                        return new AsciiFilteredInputStream(pLPInputStream);
                    }
                    try {
                        reader = inputStreamGetterArgs.isAdaptive ? new BufferedReader(new InputStreamReader((InputStream)pLPInputStream, typeInfo.getCharset())) : new StringReader(new String(pLPInputStream.getBytes(), typeInfo.getCharset()));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new SQLServerException(null, unsupportedEncodingException.getMessage(), null, 0, true);
                    }
                }
                if (2 == inputStreamGetterArgs.streamType) {
                    return reader;
                }
                if (3 == inputStreamGetterArgs.streamType && inputStreamGetterArgs.isAdaptive) {
                    return AsciiFilteredUnicodeInputStream.MakeAsciiFilteredUnicodeInputStream(pLPInputStream, reader);
                }
                return DDC.convertStringToObject(DDC.convertReaderToString(reader, pLPInputStream.getLength()), typeInfo.getCharset(), n, inputStreamGetterArgs.streamType);
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: 
        }
        byte[] byArray = pLPInputStream.getBytes();
        if (2004 == n) {
            return new SQLServerBlob(null, byArray);
        }
        return byArray;
    }

    private static final String getDatePart(String string) {
        int n = string.indexOf(32);
        if (-1 == n) {
            return string;
        }
        return string.substring(0, n);
    }

    private static final String getTimePart(String string) {
        int n = string.indexOf(32);
        if (-1 == n) {
            return string;
        }
        return string.substring(n + 1);
    }

    static final boolean exceedsMaxRPCDecimalPrecisionOrScale(BigDecimal bigDecimal) {
        BigInteger bigInteger;
        if (null == bigDecimal) {
            return false;
        }
        if (bigDecimal.scale() > 38) {
            return true;
        }
        BigInteger bigInteger2 = bigInteger = bigDecimal.scale() < 0 ? bigDecimal.setScale(0).unscaledValue() : bigDecimal.unscaledValue();
        if (bigDecimal.signum() < 0) {
            bigInteger = bigInteger.negate();
        }
        return bigInteger.compareTo(maxRPCDecimalValue) > 0;
    }

    static String convertReaderToString(Reader reader, int n) throws SQLServerException {
        if (null == reader) {
            return null;
        }
        try {
            int n2;
            char[] cArray = new char[-1 != n ? n : 4000];
            StringBuffer stringBuffer = new StringBuffer(-1 != n ? n : 4000);
            while ((n2 = reader.read(cArray, 0, cArray.length)) > 0) {
                stringBuffer.append(cArray, 0, n2);
            }
            reader.close();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_unexpectedIOExceptionProcessingReader"), "", true);
            return null;
        }
    }
}

