/*
    io.h - I/O routines
    Copyright (c) 1999,2006  Joey Schulze <joey@infodrom.org>

    This file is part of the Gerstensaft package.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111, USA.
*/

#ifndef __IO_H__
#define __IO_H__

#include <sys/types.h>

struct s_file {
  char *name;
  off_t size;
  int type;
  struct s_file *next;
};

typedef enum
{
  FILE_REGULAR,
  FILE_DIRECTORY,
  FILE_LINK,
  FILE_LINKDIR,
  FILE_UPDIR
} io_filetype;

struct s_file *get_dir (const char *dir);

void free_dir (struct s_file *files);

char *check_and_adjust_dir (const char *dir);

int list_contains_file (char **list, int length, const char *dir, const char *file);

int exists (const char *dir, const char *file);

int is_dir (const char *dir, const char *file);

unsigned long int get_filesize (const char *name);

char *escape_quotes (char *text);

#endif /* __IO_H__ */
