static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2003,2004,2007, 2015 Øyvind Kolås <pippin@gimp.org>            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"                                                                              \n"
"#include <stdlib.h>                                                           \n"
"                                                                              \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_string (path, _(\"File\"), \"/tmp/fnord.ogv\")                       \n"
"    description (_(\"Target path and filename, use '-' for stdout.\"))        \n"
"                                                                              \n"
"property_double (frame_rate, _(\"Frames/second\"), 25.0)                      \n"
"    value_range (0.0, 100.0)                                                  \n"
"#if 0                                                                         \n"
"property_string (audio_codec, _(\"Audio codec\"), \"auto\")                   \n"
"property_int (audio_bit_rate, _(\"Audio bitrate\"), 810000)                   \n"
"property_string (video_codec,   _(\"Video codec\"),   \"auto\")               \n"
"property_int (video_bit_rate, _(\"video bitrate\"), 810000)                   \n"
"    value_range (0.0, 500000000.0)                                            \n"
"property_double (video_bit_rate_tolerance, _(\"video bitrate\"), 1000.0)      \n"
"property_int    (video_global_quality, _(\"global quality\"), 255)            \n"
"property_int    (compression_level,    _(\"compression level\"), 255)         \n"
"property_int    (noise_reduction,      _(\"noise reduction strength\"), 0)    \n"
"property_int    (gop_size,             _(\"the number of frames in a group of pictures, 0 for keyframe only\"), 16)\n"
"property_int    (key_int_min,          _(\"the minimum number of frames in a group of pictures, 0 for keyframe only\"), 1)\n"
"property_int    (max_b_frames,         _(\"maximum number of consequetive b frames\"), 3)\n"
"#endif                                                                        \n"
"                                                                              \n"
"                                                                              \n"
"property_audio_fragment (audio, _(\"audio\"), 0)                              \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SINK                                                          \n"
"#define GEGL_OP_C_SOURCE ff-save.c                                            \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#include <libavformat/avformat.h>                                             \n"
"#include <libavcodec/avcodec.h>                                               \n"
"#include <libavutil/avutil.h>                                                 \n"
"#include <libavutil/opt.h>                                                    \n"
"#include <libswscale/swscale.h>                                               \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gdouble    frame;                                                           \n"
"  gdouble    frames;                                                          \n"
"  gdouble    width;                                                           \n"
"  gdouble    height;                                                          \n"
"  GeglBuffer *input;                                                          \n"
"                                                                              \n"
"  AVOutputFormat *fmt;                                                        \n"
"  AVFormatContext *oc;                                                        \n"
"  AVStream *video_st;                                                         \n"
"                                                                              \n"
"  AVFrame  *picture, *tmp_picture;                                            \n"
"  uint8_t  *video_outbuf;                                                     \n"
"  int       frame_count, video_outbuf_size;                                   \n"
"  int       audio_sample_rate;                                                \n"
"                                                                              \n"
"    /** the rest is for audio handling within oxide, note that the interface  \n"
"     * used passes all used functions in the oxide api through the reg_sym api\n"
"     * of gggl, this means that the ops should be usable by other applications\n"
"     * using gggl directly,. without needing to link with the oxide library   \n"
"     */                                                                       \n"
"  AVStream *audio_st;                                                         \n"
"                                                                              \n"
"  uint32_t  sample_rate;                                                      \n"
"  uint32_t  bits;                                                             \n"
"  uint32_t  channels;                                                         \n"
"  uint32_t  fragment_samples;                                                 \n"
"  uint32_t  fragment_size;                                                    \n"
"                                                                              \n"
"  int       buffer_size;                                                      \n"
"  int       buffer_read_pos;                                                  \n"
"  int       buffer_write_pos;                                                 \n"
"  uint8_t  *buffer;                                                           \n"
"                                                                              \n"
"  int       audio_outbuf_size;                                                \n"
"  int16_t  *samples;                                                          \n"
"                                                                              \n"
"  GList    *audio_track;                                                      \n"
"  long      audio_pos;                                                        \n"
"  long      audio_read_pos;                                                   \n"
"                                                                              \n"
"  int       next_apts;                                                        \n"
"} Priv;                                                                       \n"
"                                                                              \n"
"static void                                                                   \n"
"clear_audio_track (GeglProperties *o)                                         \n"
"{                                                                             \n"
"  Priv *p = (Priv*)o->user_data;                                              \n"
"  while (p->audio_track)                                                      \n"
"    {                                                                         \n"
"      g_object_unref (p->audio_track->data);                                  \n"
"      p->audio_track = g_list_remove (p->audio_track, p->audio_track->data);  \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void get_sample_data (Priv *p, long sample_no, float *left, float *right)\n"
"{                                                                             \n"
"  int to_remove = 0;                                                          \n"
"  GList *l;                                                                   \n"
"  if (sample_no < 0)                                                          \n"
"    return;                                                                   \n"
"  for (l = p->audio_track; l; l = l->next)                                    \n"
"  {                                                                           \n"
"    GeglAudioFragment *af = l->data;                                          \n"
"    int channels = gegl_audio_fragment_get_channels (af);                     \n"
"    int pos = gegl_audio_fragment_get_pos (af);                               \n"
"    int sample_count = gegl_audio_fragment_get_sample_count (af);             \n"
"    if (sample_no > pos + sample_count)                                       \n"
"    {                                                                         \n"
"      to_remove ++;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"    if (pos <= sample_no &&                                                   \n"
"        sample_no < pos + sample_count)                                       \n"
"      {                                                                       \n"
"        int i = sample_no - pos;                                              \n"
"        *left  = af->data[0][i];                                              \n"
"        if (channels == 1)                                                    \n"
"          *right = af->data[0][i];                                            \n"
"        else                                                                  \n"
"          *right = af->data[1][i];                                            \n"
"                                                                              \n"
"	if (to_remove)  /* consuming audiotrack */                                   \n"
"        {                                                                     \n"
"          again:                                                              \n"
"          for (l = p->audio_track; l; l = l->next)                            \n"
"          {                                                                   \n"
"            GeglAudioFragment *af = l->data;                                  \n"
"            int pos = gegl_audio_fragment_get_pos (af);                       \n"
"            int sample_count = gegl_audio_fragment_get_sample_count (af);     \n"
"            if (sample_no > pos + sample_count)                               \n"
"            {                                                                 \n"
"              p->audio_track = g_list_remove (p->audio_track, af);            \n"
"              g_object_unref (af);                                            \n"
"              goto again;                                                     \n"
"            }                                                                 \n"
"          }                                                                   \n"
"        }                                                                     \n"
"        return;                                                               \n"
"      }                                                                       \n"
"  }                                                                           \n"
"  *left  = 0;                                                                 \n"
"  *right = 0;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"init (GeglProperties *o)                                                      \n"
"{                                                                             \n"
"  static gint inited = 0; /*< this is actually meant to be static, only to be done once */\n"
"  Priv       *p = (Priv*)o->user_data;                                        \n"
"                                                                              \n"
"  if (p == NULL)                                                              \n"
"    {                                                                         \n"
"      p = g_new0 (Priv, 1);                                                   \n"
"      o->user_data = (void*) p;                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (!inited)                                                                \n"
"    {                                                                         \n"
"      av_register_all ();                                                     \n"
"      avcodec_register_all ();                                                \n"
"      inited = 1;                                                             \n"
"    }                                                                         \n"
"                                                                              \n"
"  clear_audio_track (o);                                                      \n"
"  p->audio_pos = 0;                                                           \n"
"  p->audio_read_pos = 0;                                                      \n"
"                                                                              \n"
"  p->audio_sample_rate = -1; /* only do this if it hasn't been manually set? */\n"
"}                                                                             \n"
"                                                                              \n"
"static void close_video       (Priv            *p,                            \n"
"                               AVFormatContext *oc,                           \n"
"                               AVStream        *st);                          \n"
"void        close_audio       (Priv            *p,                            \n"
"                               AVFormatContext *oc,                           \n"
"                               AVStream        *st);                          \n"
"static int  tfile             (GeglProperties  *o);                           \n"
"static void write_video_frame (GeglProperties  *o,                            \n"
"                               AVFormatContext *oc,                           \n"
"                               AVStream        *st);                          \n"
"static void write_audio_frame (GeglProperties      *o,                        \n"
"                               AVFormatContext *oc,                           \n"
"                               AVStream        *st);                          \n"
"                                                                              \n"
"#define STREAM_FRAME_RATE 25    /* 25 images/s */                             \n"
"                                                                              \n"
"#ifndef DISABLE_AUDIO                                                         \n"
"/* add an audio output stream */                                              \n"
"static AVStream *                                                             \n"
"add_audio_stream (GeglProperties *o, AVFormatContext * oc, int codec_id)      \n"
"{                                                                             \n"
"  AVCodecContext *c;                                                          \n"
"  AVStream *st;                                                               \n"
"                                                                              \n"
"  st = avformat_new_stream (oc, NULL);                                        \n"
"  if (!st)                                                                    \n"
"    {                                                                         \n"
"      fprintf (stderr, \"Could not alloc stream\\n\");                        \n"
"      exit (1);                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  c = st->codec;                                                              \n"
"  c->codec_id = codec_id;                                                     \n"
"  c->codec_type = AVMEDIA_TYPE_AUDIO;                                         \n"
"                                                                              \n"
"  if (oc->oformat->flags & AVFMT_GLOBALHEADER)                                \n"
"    c->flags |= CODEC_FLAG_GLOBAL_HEADER;                                     \n"
"                                                                              \n"
"  return st;                                                                  \n"
"}                                                                             \n"
"#endif                                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"open_audio (GeglProperties *o, AVFormatContext * oc, AVStream * st)           \n"
"{                                                                             \n"
"  Priv *p = (Priv*)o->user_data;                                              \n"
"  AVCodecContext *c;                                                          \n"
"  AVCodec  *codec;                                                            \n"
"  int i;                                                                      \n"
"                                                                              \n"
"  c = st->codec;                                                              \n"
"                                                                              \n"
"  /* find the audio encoder */                                                \n"
"  codec = avcodec_find_encoder (c->codec_id);                                 \n"
"  if (!codec)                                                                 \n"
"    {                                                                         \n"
"      fprintf (stderr, \"codec not found\\n\");                               \n"
"      exit (1);                                                               \n"
"    }                                                                         \n"
"  c->bit_rate = 64000;                                                        \n"
"  c->sample_fmt = codec->sample_fmts ? codec->sample_fmts[0] : AV_SAMPLE_FMT_FLTP;\n"
"                                                                              \n"
"  if (p->audio_sample_rate == -1)                                             \n"
"  {                                                                           \n"
"    if (o->audio)                                                             \n"
"    {                                                                         \n"
"      if (gegl_audio_fragment_get_sample_rate (o->audio) == 0)                \n"
"      {                                                                       \n"
"        gegl_audio_fragment_set_sample_rate (o->audio, 48000); // XXX: should skip adding audiostream instead\n"
"      }                                                                       \n"
"      p->audio_sample_rate = gegl_audio_fragment_get_sample_rate (o->audio);  \n"
"    }                                                                         \n"
"  }                                                                           \n"
"  c->sample_rate = p->audio_sample_rate;                                      \n"
"  c->channel_layout = AV_CH_LAYOUT_STEREO;                                    \n"
"  c->channels = 2;                                                            \n"
"                                                                              \n"
"                                                                              \n"
"  if (codec->supported_samplerates)                                           \n"
"  {                                                                           \n"
"    c->sample_rate = codec->supported_samplerates[0];                         \n"
"    for (i = 0; codec->supported_samplerates[i]; i++)                         \n"
"    {                                                                         \n"
"      if (codec->supported_samplerates[i] == p->audio_sample_rate)            \n"
"         c->sample_rate = p->audio_sample_rate;                               \n"
"    }                                                                         \n"
"  }                                                                           \n"
"  //st->time_base = (AVRational){1, c->sample_rate};                          \n"
"  st->time_base = (AVRational){1, p->audio_sample_rate};                      \n"
"                                                                              \n"
"  c->strict_std_compliance = FF_COMPLIANCE_EXPERIMENTAL; // ffmpeg AAC is not quite stable yet\n"
"                                                                              \n"
"  /* open it */                                                               \n"
"  if (avcodec_open2 (c, codec, NULL) < 0)                                     \n"
"    {                                                                         \n"
"      fprintf (stderr, \"could not open codec\\n\");                          \n"
"      exit (1);                                                               \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static AVFrame *alloc_audio_frame(enum AVSampleFormat sample_fmt,             \n"
"                                  uint64_t channel_layout,                    \n"
"                                  int sample_rate, int nb_samples)            \n"
"{                                                                             \n"
"  AVFrame *frame = av_frame_alloc();                                          \n"
"  int ret;                                                                    \n"
"                                                                              \n"
"  if (!frame) {                                                               \n"
"      fprintf(stderr, \"Error allocating an audio frame\\n\");                \n"
"      exit(1);                                                                \n"
"  }                                                                           \n"
"                                                                              \n"
"  frame->format         = sample_fmt;                                         \n"
"  frame->channel_layout = channel_layout;                                     \n"
"  frame->sample_rate    = sample_rate;                                        \n"
"  frame->nb_samples     = nb_samples;                                         \n"
"                                                                              \n"
"  if (nb_samples) {                                                           \n"
"      ret = av_frame_get_buffer(frame, 0);                                    \n"
"      if (ret < 0) {                                                          \n"
"          fprintf(stderr, \"Error allocating an audio buffer\\n\");           \n"
"          exit(1);                                                            \n"
"      }                                                                       \n"
"  }                                                                           \n"
"  return frame;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"void                                                                          \n"
"write_audio_frame (GeglProperties *o, AVFormatContext * oc, AVStream * st)    \n"
"{                                                                             \n"
"  Priv *p = (Priv*)o->user_data;                                              \n"
"  AVCodecContext *c = st->codec;                                              \n"
"  int sample_count = 100000;                                                  \n"
"  static AVPacket  pkt = { 0 };                                               \n"
"                                                                              \n"
"  if (pkt.size == 0)                                                          \n"
"  {                                                                           \n"
"    av_init_packet (&pkt);                                                    \n"
"  }                                                                           \n"
"                                                                              \n"
"  /* first we add incoming frames audio samples */                            \n"
"  {                                                                           \n"
"    int i;                                                                    \n"
"    int sample_count = gegl_audio_fragment_get_sample_count (o->audio);       \n"
"    GeglAudioFragment *af = gegl_audio_fragment_new (gegl_audio_fragment_get_sample_rate (o->audio),\n"
"                                                     gegl_audio_fragment_get_channels (o->audio),\n"
"                                                     gegl_audio_fragment_get_channel_layout (o->audio),\n"
"                                                     sample_count);           \n"
"    gegl_audio_fragment_set_sample_count (af, sample_count);                  \n"
"    for (i = 0; i < sample_count; i++)                                        \n"
"      {                                                                       \n"
"        af->data[0][i] = o->audio->data[0][i];                                \n"
"        af->data[1][i] = o->audio->data[1][i];                                \n"
"      }                                                                       \n"
"    gegl_audio_fragment_set_pos (af, p->audio_pos);                           \n"
"    p->audio_pos += sample_count;                                             \n"
"    p->audio_track = g_list_append (p->audio_track, af);                      \n"
"  }                                                                           \n"
"                                                                              \n"
"  if (!(c->codec->capabilities & AV_CODEC_CAP_VARIABLE_FRAME_SIZE))           \n"
"    sample_count = c->frame_size;                                             \n"
"                                                                              \n"
"  /* then we encode as much as we can in a loop using the codec frame size */ \n"
"                                                                              \n"
"                                                                              \n"
"  while (p->audio_pos - p->audio_read_pos > sample_count)                     \n"
"  {                                                                           \n"
"    long i;                                                                   \n"
"    int ret;                                                                  \n"
"    int got_packet = 0;                                                       \n"
"    AVFrame *frame = alloc_audio_frame (c->sample_fmt, c->channel_layout,     \n"
"                                        c->sample_rate, sample_count);        \n"
"                                                                              \n"
"    switch (c->sample_fmt) {                                                  \n"
"      case AV_SAMPLE_FMT_FLT:                                                 \n"
"        for (i = 0; i < sample_count; i++)                                    \n"
"        {                                                                     \n"
"          float left = 0, right = 0;                                          \n"
"          get_sample_data (p, i + p->audio_read_pos, &left, &right);          \n"
"          ((float*)frame->data[0])[c->channels*i+0] = left;                   \n"
"          ((float*)frame->data[0])[c->channels*i+1] = right;                  \n"
"        }                                                                     \n"
"        break;                                                                \n"
"      case AV_SAMPLE_FMT_FLTP:                                                \n"
"        for (i = 0; i < sample_count; i++)                                    \n"
"        {                                                                     \n"
"          float left = 0, right = 0;                                          \n"
"          get_sample_data (p, i + p->audio_read_pos, &left, &right);          \n"
"          ((float*)frame->data[0])[i] = left;                                 \n"
"          ((float*)frame->data[1])[i] = right;                                \n"
"        }                                                                     \n"
"        break;                                                                \n"
"      case AV_SAMPLE_FMT_S16:                                                 \n"
"        for (i = 0; i < sample_count; i++)                                    \n"
"        {                                                                     \n"
"          float left = 0, right = 0;                                          \n"
"          get_sample_data (p, i + p->audio_read_pos, &left, &right);          \n"
"          ((int16_t*)frame->data[0])[c->channels*i+0] = left * (1<<15);       \n"
"          ((int16_t*)frame->data[0])[c->channels*i+1] = right * (1<<15);      \n"
"        }                                                                     \n"
"        break;                                                                \n"
"      case AV_SAMPLE_FMT_S32:                                                 \n"
"        for (i = 0; i < sample_count; i++)                                    \n"
"        {                                                                     \n"
"          float left = 0, right = 0;                                          \n"
"          get_sample_data (p, i + p->audio_read_pos, &left, &right);          \n"
"          ((int32_t*)frame->data[0])[c->channels*i+0] = left * (1<<31);       \n"
"          ((int32_t*)frame->data[0])[c->channels*i+1] = right * (1<<31);      \n"
"        }                                                                     \n"
"        break;                                                                \n"
"      case AV_SAMPLE_FMT_S32P:                                                \n"
"        for (i = 0; i < sample_count; i++)                                    \n"
"        {                                                                     \n"
"          float left = 0, right = 0;                                          \n"
"          get_sample_data (p, i + p->audio_read_pos, &left, &right);          \n"
"          ((int32_t*)frame->data[0])[i] = left * (1<<31);                     \n"
"          ((int32_t*)frame->data[1])[i] = right * (1<<31);                    \n"
"        }                                                                     \n"
"        break;                                                                \n"
"      case AV_SAMPLE_FMT_S16P:                                                \n"
"        for (i = 0; i < sample_count; i++)                                    \n"
"        {                                                                     \n"
"          float left = 0, right = 0;                                          \n"
"          get_sample_data (p, i + p->audio_read_pos, &left, &right);          \n"
"          ((int16_t*)frame->data[0])[i] = left * (1<<15);                     \n"
"          ((int16_t*)frame->data[1])[i] = right * (1<<15);                    \n"
"        }                                                                     \n"
"        break;                                                                \n"
"      default:                                                                \n"
"        fprintf (stderr, \"eeeek unhandled audio format\\n\");                \n"
"        break;                                                                \n"
"    }                                                                         \n"
"    frame->pts = p->next_apts;                                                \n"
"    p->next_apts += sample_count;                                             \n"
"                                                                              \n"
"    av_frame_make_writable (frame);                                           \n"
"    ret = avcodec_encode_audio2 (c, &pkt, frame, &got_packet);                \n"
"                                                                              \n"
"    av_packet_rescale_ts (&pkt, st->codec->time_base, st->time_base);         \n"
"    if (ret < 0) {                                                            \n"
"      fprintf (stderr, \"Error encoding audio frame: %s\\n\", av_err2str (ret));\n"
"    }                                                                         \n"
"                                                                              \n"
"    if (got_packet)                                                           \n"
"    {                                                                         \n"
"      pkt.stream_index = st->index;                                           \n"
"      av_interleaved_write_frame (oc, &pkt);                                  \n"
"      av_free_packet (&pkt);                                                  \n"
"    }                                                                         \n"
"                                                                              \n"
"    av_frame_free (&frame);                                                   \n"
"    p->audio_read_pos += sample_count;                                        \n"
"  }                                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"void                                                                          \n"
"close_audio (Priv * p, AVFormatContext * oc, AVStream * st)                   \n"
"{                                                                             \n"
"  avcodec_close (st->codec);                                                  \n"
"                                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"/* add a video output stream */                                               \n"
"static AVStream *                                                             \n"
"add_video_stream (GeglProperties *o, AVFormatContext * oc, int codec_id)      \n"
"{                                                                             \n"
"  Priv *p = (Priv*)o->user_data;                                              \n"
"                                                                              \n"
"  AVCodecContext *c;                                                          \n"
"  AVStream *st;                                                               \n"
"                                                                              \n"
"  st = avformat_new_stream (oc, NULL);                                        \n"
"  if (!st)                                                                    \n"
"    {                                                                         \n"
"      fprintf (stderr, \"Could not alloc stream %p %p %i\\n\", o, oc, codec_id);\n"
"      exit (1);                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  c = st->codec;                                                              \n"
"  c->codec_id = codec_id;                                                     \n"
"  c->codec_type = AVMEDIA_TYPE_VIDEO;                                         \n"
"  /* put sample propeters */                                                  \n"
"  c->bit_rate = 810000;                                                       \n"
"  /* resolution must be a multiple of two */                                  \n"
"  c->width = p->width;                                                        \n"
"  c->height = p->height;                                                      \n"
"  /* frames per second */                                                     \n"
"  st->time_base =(AVRational){1, o->frame_rate};                              \n"
"  c->time_base = st->time_base;                                               \n"
"  c->pix_fmt = AV_PIX_FMT_YUV420P;                                            \n"
"  c->gop_size = 12;             /* emit one intra frame every twelve frames at most */\n"
"                                                                              \n"
"  if (c->codec_id == AV_CODEC_ID_MPEG2VIDEO)                                  \n"
"    {                                                                         \n"
"      c->max_b_frames = 2;                                                    \n"
"    }                                                                         \n"
"  if (c->codec_id == AV_CODEC_ID_H264)                                        \n"
"   {                                                                          \n"
"#if 1                                                                         \n"
"     c->qcompress = 0.6;  // qcomp=0.6                                        \n"
"     c->me_range = 16;    // me_range=16                                      \n"
"     c->gop_size = 250;   // g=250                                            \n"
"                                                                              \n"
"     c->max_b_frames = 3; // bf=3                                             \n"
"#if 0                                                                         \n"
"     c->coder_type = 1;  // coder = 1                                         \n"
"     c->flags|=CODEC_FLAG_LOOP_FILTER;   // flags=+loop                       \n"
"     c->me_cmp|= 1;  // cmp=+chroma, where CHROMA = 1                         \n"
"     //c->partitions|=X264_PART_I8X8+X264_PART_I4X4+X264_PART_P8X8+X264_PART_B8X8; // partitions=+parti8x8+parti4x4+partp8x8+partb8x8\n"
"     c->me_subpel_quality = 7;   // subq=7                                    \n"
"     c->keyint_min = 25; // keyint_min=25                                     \n"
"     c->scenechange_threshold = 40;  // sc_threshold=40                       \n"
"     c->i_quant_factor = 0.71; // i_qfactor=0.71                              \n"
"     c->b_frame_strategy = 1;  // b_strategy=1                                \n"
"     c->qmin = 10;   // qmin=10                                               \n"
"     c->qmax = 51;   // qmax=51                                               \n"
"     c->max_qdiff = 4;   // qdiff=4                                           \n"
"     c->refs = 3;    // refs=3                                                \n"
"     //c->directpred = 1;  // directpred=1                                    \n"
"     c->trellis = 1; // trellis=1                                             \n"
"     //c->flags2|=AV_CODEC_FLAG2_BPYRAMID|AV_CODEC_FLAG2_MIXED_REFS|AV_CODEC_FLAG2_WPRED+CODEC_FLAG2_8X8DCT+CODEC_FLAG2_FASTPSKIP;  // flags2=+bpyramid+mixed_refs+wpred+dct8x8+fastpskip\n"
"     //c->weighted_p_pred = 2; // wpredp=2                                    \n"
"                                                                              \n"
"// libx264-main.ffpreset preset                                               \n"
"     //c->flags2|=CODEC_FLAG2_8X8DCT;c->flags2^=CODEC_FLAG2_8X8DCT;           \n"
"#endif                                                                        \n"
"#endif                                                                        \n"
"   }                                                                          \n"
"                                                                              \n"
"   if (oc->oformat->flags & AVFMT_GLOBALHEADER)                               \n"
"     c->flags |= CODEC_FLAG_GLOBAL_HEADER;                                    \n"
"                                                                              \n"
"  return st;                                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static AVFrame *                                                              \n"
"alloc_picture (int pix_fmt, int width, int height)                            \n"
"{                                                                             \n"
"  AVFrame  *picture;                                                          \n"
"  uint8_t  *picture_buf;                                                      \n"
"  int       size;                                                             \n"
"                                                                              \n"
"  picture = av_frame_alloc ();                                                \n"
"  if (!picture)                                                               \n"
"    return NULL;                                                              \n"
"  size = avpicture_get_size (pix_fmt, width, height + 1);                     \n"
"  picture_buf = malloc (size);                                                \n"
"  if (!picture_buf)                                                           \n"
"    {                                                                         \n"
"      av_free (picture);                                                      \n"
"      return NULL;                                                            \n"
"    }                                                                         \n"
"  avpicture_fill ((AVPicture *) picture, picture_buf, pix_fmt, width, height);\n"
"  return picture;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"open_video (Priv * p, AVFormatContext * oc, AVStream * st)                    \n"
"{                                                                             \n"
"  AVCodec  *codec;                                                            \n"
"  AVCodecContext *c;                                                          \n"
"                                                                              \n"
"  c = st->codec;                                                              \n"
"                                                                              \n"
"  /* find the video encoder */                                                \n"
"  codec = avcodec_find_encoder (c->codec_id);                                 \n"
"  if (!codec)                                                                 \n"
"    {                                                                         \n"
"      fprintf (stderr, \"codec not found\\n\");                               \n"
"      exit (1);                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* open the codec */                                                        \n"
"  if (avcodec_open2 (c, codec, NULL) < 0)                                     \n"
"    {                                                                         \n"
"      fprintf (stderr, \"could not open codec\\n\");                          \n"
"      exit (1);                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  p->video_outbuf = NULL;                                                     \n"
"  if (!(oc->oformat->flags & AVFMT_RAWPICTURE))                               \n"
"    {                                                                         \n"
"      /* allocate output buffer */                                            \n"
"      /* XXX: API change will be done */                                      \n"
"      p->video_outbuf_size = 200000;                                          \n"
"      p->video_outbuf = malloc (p->video_outbuf_size);                        \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* allocate the encoded raw picture */                                      \n"
"  p->picture = alloc_picture (c->pix_fmt, c->width, c->height);               \n"
"  if (!p->picture)                                                            \n"
"    {                                                                         \n"
"      fprintf (stderr, \"Could not allocate picture\\n\");                    \n"
"      exit (1);                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* if the output format is not YUV420P, then a temporary YUV420P            \n"
"     picture is needed too. It is then converted to the required              \n"
"     output format */                                                         \n"
"  p->tmp_picture = NULL;                                                      \n"
"  if (c->pix_fmt != AV_PIX_FMT_RGB24)                                         \n"
"    {                                                                         \n"
"      p->tmp_picture = alloc_picture (AV_PIX_FMT_RGB24, c->width, c->height); \n"
"      if (!p->tmp_picture)                                                    \n"
"        {                                                                     \n"
"          fprintf (stderr, \"Could not allocate temporary picture\\n\");      \n"
"          exit (1);                                                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"close_video (Priv * p, AVFormatContext * oc, AVStream * st)                   \n"
"{                                                                             \n"
"  avcodec_close (st->codec);                                                  \n"
"  av_free (p->picture->data[0]);                                              \n"
"  av_free (p->picture);                                                       \n"
"  if (p->tmp_picture)                                                         \n"
"    {                                                                         \n"
"      av_free (p->tmp_picture->data[0]);                                      \n"
"      av_free (p->tmp_picture);                                               \n"
"    }                                                                         \n"
"  av_free (p->video_outbuf);                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"string.h\"                                                         \n"
"                                                                              \n"
"/* prepare a dummy image */                                                   \n"
"static void                                                                   \n"
"fill_rgb_image (GeglProperties *o,                                            \n"
"                AVFrame *pict, int frame_index, int width, int height)        \n"
"{                                                                             \n"
"  Priv     *p = (Priv*)o->user_data;                                          \n"
"  GeglRectangle rect={0,0,width,height};                                      \n"
"  gegl_buffer_get (p->input, &rect, 1.0, babl_format (\"R'G'B' u8\"), pict->data[0], GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);\n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"write_video_frame (GeglProperties *o,                                         \n"
"                   AVFormatContext *oc, AVStream *st)                         \n"
"{                                                                             \n"
"  Priv           *p = (Priv*)o->user_data;                                    \n"
"  int             out_size, ret;                                              \n"
"  AVCodecContext *c;                                                          \n"
"  AVFrame        *picture_ptr;                                                \n"
"                                                                              \n"
"  c = st->codec;                                                              \n"
"                                                                              \n"
"  if (c->pix_fmt != AV_PIX_FMT_RGB24)                                         \n"
"    {                                                                         \n"
"      struct SwsContext *img_convert_ctx;                                     \n"
"      fill_rgb_image (o, p->tmp_picture, p->frame_count, c->width,            \n"
"                      c->height);                                             \n"
"                                                                              \n"
"      img_convert_ctx = sws_getContext(c->width, c->height, AV_PIX_FMT_RGB24, \n"
"                                       c->width, c->height, c->pix_fmt,       \n"
"                                       SWS_BICUBIC, NULL, NULL, NULL);        \n"
"                                                                              \n"
"      if (img_convert_ctx == NULL)                                            \n"
"        {                                                                     \n"
"          fprintf(stderr, \"ff_save: Cannot initialize conversion context.\");\n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          sws_scale(img_convert_ctx,                                          \n"
"                    (void*)p->tmp_picture->data,                              \n"
"                    p->tmp_picture->linesize,                                 \n"
"                    0,                                                        \n"
"                    c->height,                                                \n"
"                    p->picture->data,                                         \n"
"                    p->picture->linesize);                                    \n"
"         p->picture->format = c->pix_fmt;                                     \n"
"         p->picture->width = c->width;                                        \n"
"         p->picture->height = c->height;                                      \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      fill_rgb_image (o, p->picture, p->frame_count, c->width, c->height);    \n"
"    }                                                                         \n"
"                                                                              \n"
"  picture_ptr      = p->picture;                                              \n"
"  picture_ptr->pts = p->frame_count;                                          \n"
"                                                                              \n"
"  if (oc->oformat->flags & AVFMT_RAWPICTURE)                                  \n"
"    {                                                                         \n"
"      /* raw video case. The API will change slightly in the near             \n"
"         future for that */                                                   \n"
"      AVPacket  pkt;                                                          \n"
"      av_init_packet (&pkt);                                                  \n"
"                                                                              \n"
"      pkt.flags |= AV_PKT_FLAG_KEY;                                           \n"
"      pkt.stream_index = st->index;                                           \n"
"      pkt.data = (uint8_t *) picture_ptr;                                     \n"
"      pkt.size = sizeof (AVPicture);                                          \n"
"      pkt.pts = picture_ptr->pts;                                             \n"
"      av_packet_rescale_ts (&pkt, c->time_base, st->time_base);               \n"
"                                                                              \n"
"      ret = av_write_frame (oc, &pkt);                                        \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      /* encode the image */                                                  \n"
"      out_size =                                                              \n"
"        avcodec_encode_video (c,                                              \n"
"                              p->video_outbuf,                                \n"
"                              p->video_outbuf_size, picture_ptr);             \n"
"                                                                              \n"
"      /* if zero size, it means the image was buffered */                     \n"
"      if (out_size != 0)                                                      \n"
"        {                                                                     \n"
"          AVPacket  pkt;                                                      \n"
"          av_init_packet (&pkt);                                              \n"
"          if (c->coded_frame->key_frame)                                      \n"
"            pkt.flags |= AV_PKT_FLAG_KEY;                                     \n"
"          pkt.stream_index = st->index;                                       \n"
"          pkt.data = p->video_outbuf;                                         \n"
"          pkt.size = out_size;                                                \n"
"          pkt.pts = picture_ptr->pts;                                         \n"
"          av_packet_rescale_ts (&pkt, c->time_base, st->time_base);           \n"
"          /* write the compressed frame in the media file */                  \n"
"          ret = av_write_frame (oc, &pkt);                                    \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          ret = 0;                                                            \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  if (ret != 0)                                                               \n"
"    {                                                                         \n"
"      fprintf (stderr, \"Error while writing video frame\\n\");               \n"
"      exit (1);                                                               \n"
"    }                                                                         \n"
"  p->frame_count++;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static int                                                                    \n"
"tfile (GeglProperties *o)                                                     \n"
"{                                                                             \n"
"  Priv *p = (Priv*)o->user_data;                                              \n"
"                                                                              \n"
"  p->fmt = av_guess_format (NULL, o->path, NULL);                             \n"
"  if (!p->fmt)                                                                \n"
"    {                                                                         \n"
"      fprintf (stderr,                                                        \n"
"               \"ff_save couldn't deduce outputformat from file extension: using MPEG.\\n%s\",\n"
"               \"\");                                                         \n"
"      p->fmt = av_guess_format (\"mpeg\", NULL, NULL);                        \n"
"    }                                                                         \n"
"  p->oc = avformat_alloc_context ();                                          \n"
"  if (!p->oc)                                                                 \n"
"    {                                                                         \n"
"      fprintf (stderr, \"memory error\\n%s\", \"\");                          \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  p->oc->oformat = p->fmt;                                                    \n"
"                                                                              \n"
"  snprintf (p->oc->filename, sizeof (p->oc->filename), \"%s\", o->path);      \n"
"                                                                              \n"
"  p->video_st = NULL;                                                         \n"
"  p->audio_st = NULL;                                                         \n"
"                                                                              \n"
"  if (p->fmt->video_codec != AV_CODEC_ID_NONE)                                \n"
"    {                                                                         \n"
"      p->video_st = add_video_stream (o, p->oc, p->fmt->video_codec);         \n"
"    }                                                                         \n"
"  if (p->fmt->audio_codec != AV_CODEC_ID_NONE)                                \n"
"    {                                                                         \n"
"     p->audio_st = add_audio_stream (o, p->oc, p->fmt->audio_codec);          \n"
"    }                                                                         \n"
"                                                                              \n"
"                                                                              \n"
"  if (p->video_st)                                                            \n"
"    open_video (p, p->oc, p->video_st);                                       \n"
"                                                                              \n"
"  if (p->audio_st)                                                            \n"
"    open_audio (o, p->oc, p->audio_st);                                       \n"
"                                                                              \n"
"  av_dump_format (p->oc, 0, o->path, 1);                                      \n"
"                                                                              \n"
"  if (avio_open (&p->oc->pb, o->path, AVIO_FLAG_WRITE) < 0)                   \n"
"    {                                                                         \n"
"      fprintf (stderr, \"couldn't open '%s'\\n\", o->path);                   \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  avformat_write_header (p->oc, NULL);                                        \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv           *p = (Priv*)o->user_data;                                    \n"
"  static gint     inited = 0;                                                 \n"
"                                                                              \n"
"  g_assert (input);                                                           \n"
"                                                                              \n"
"  if (p == NULL)                                                              \n"
"    init (o);                                                                 \n"
"  p = (Priv*)o->user_data;                                                    \n"
"                                                                              \n"
"  p->width = result->width;                                                   \n"
"  p->height = result->height;                                                 \n"
"  p->input = input;                                                           \n"
"                                                                              \n"
"  if (!inited)                                                                \n"
"    {                                                                         \n"
"      tfile (o);                                                              \n"
"      inited = 1;                                                             \n"
"    }                                                                         \n"
"                                                                              \n"
"  write_video_frame (o, p->oc, p->video_st);                                  \n"
"  if (p->audio_st)                                                            \n"
"    write_audio_frame (o, p->oc, p->audio_st);                                \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void flush_audio (GeglProperties *o)                                   \n"
"{                                                                             \n"
"  Priv *p = (Priv*)o->user_data;                                              \n"
"                                                                              \n"
"  int got_packet;                                                             \n"
"  do                                                                          \n"
"  {                                                                           \n"
"    AVPacket  pkt = { 0 };                                                    \n"
"    int ret;                                                                  \n"
"    got_packet = 0;                                                           \n"
"    av_init_packet (&pkt);                                                    \n"
"    ret = avcodec_encode_audio2 (p->audio_st->codec, &pkt, NULL, &got_packet);\n"
"    if (ret < 0)                                                              \n"
"      break;                                                                  \n"
"    if (got_packet)                                                           \n"
"      {                                                                       \n"
"        pkt.stream_index = p->audio_st->index;                                \n"
"        av_packet_rescale_ts (&pkt, p->audio_st->codec->time_base, p->audio_st->time_base);\n"
"        av_interleaved_write_frame (p->oc, &pkt);                             \n"
"        av_free_packet (&pkt);                                                \n"
"      }                                                                       \n"
"  } while (got_packet);                                                       \n"
"}                                                                             \n"
"                                                                              \n"
"static void flush_video (GeglProperties *o)                                   \n"
"{                                                                             \n"
"  Priv *p = (Priv*)o->user_data;                                              \n"
"  int got_packet = 0;                                                         \n"
"  do {                                                                        \n"
"    AVPacket  pkt = { 0 };                                                    \n"
"    int ret;                                                                  \n"
"    got_packet = 0;                                                           \n"
"    av_init_packet (&pkt);                                                    \n"
"    ret = avcodec_encode_video2 (p->video_st->codec, &pkt, NULL, &got_packet);\n"
"    if (ret < 0)                                                              \n"
"      return;                                                                 \n"
"                                                                              \n"
"     if (got_packet)                                                          \n"
"     {                                                                        \n"
"       pkt.stream_index = p->video_st->index;                                 \n"
"       av_packet_rescale_ts (&pkt, p->video_st->codec->time_base, p->video_st->time_base);\n"
"       av_interleaved_write_frame (p->oc, &pkt);                              \n"
"       av_free_packet (&pkt);                                                 \n"
"     }                                                                        \n"
"  } while (got_packet);                                                       \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (object);                               \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      Priv *p = (Priv*)o->user_data;                                          \n"
"      flush_audio (o);                                                        \n"
"      flush_video (o);                                                        \n"
"                                                                              \n"
"      av_write_trailer (p->oc);                                               \n"
"                                                                              \n"
"      if (p->video_st)                                                        \n"
"        close_video (p, p->oc, p->video_st);                                  \n"
"      if (p->audio_st)                                                        \n"
"        close_audio (p, p->oc, p->audio_st);                                  \n"
"                                                                              \n"
"      avio_closep (&p->oc->pb);                                               \n"
"      avformat_free_context (p->oc);                                          \n"
"                                                                              \n"
"      g_free (o->user_data);                                                  \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (g_type_class_peek_parent (G_OBJECT_GET_CLASS (object)))->finalize (object);\n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass     *operation_class;                                    \n"
"  GeglOperationSinkClass *sink_class;                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (klass)->finalize = finalize;                                \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  sink_class      = GEGL_OPERATION_SINK_CLASS (klass);                        \n"
"                                                                              \n"
"  sink_class->process = process;                                              \n"
"  sink_class->needs_full = TRUE;                                              \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"        , \"gegl:ff-save\",                                       \n"
"    \"categories\"  , \"output:video\",                                       \n"
"    \"description\" , _(\"FFmpeg video output sink\"),                        \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
