static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"/*                                                                            \n"
" * Copyright 1997 Thorsten Schnier <thorsten@arch.usyd.edu.au>                \n"
" * Copyright 2011 Victor Oliveira <victormatheus@gmail.com>                   \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_C_SOURCE edge-laplace.c                                       \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#define LAPLACE_RADIUS 2                                                      \n"
"#define CHUNK_SIZE     1024                                                   \n"
"#define SQR(x)         ((x)*(x))                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"edge_laplace (GeglBuffer          *src,                                       \n"
"              const GeglRectangle *src_rect,                                  \n"
"              GeglBuffer          *dst,                                       \n"
"              const GeglRectangle *dst_rect,                                  \n"
"              gfloat              *src_buf,                                   \n"
"              gfloat              *temp_buf,                                  \n"
"              gfloat              *dst_buf);                                  \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *area = GEGL_OPERATION_AREA_FILTER (operation);     \n"
"                                                                              \n"
"  area->left = area->right = area->top = area->bottom = LAPLACE_RADIUS;       \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"R'G'B'A float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"R'G'B'A float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            GeglBuffer          *input,                                       \n"
"            GeglBuffer          *output,                                      \n"
"            const GeglRectangle *result);                                     \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  gint    i, j;                                                               \n"
"  gfloat *buf1, *buf2, *buf3;                                                 \n"
"                                                                              \n"
"  if (gegl_operation_use_opencl (operation))                                  \n"
"    if (cl_process (operation, input, output, result))                        \n"
"      return TRUE;                                                            \n"
"                                                                              \n"
"  buf1 = g_new (gfloat, SQR (CHUNK_SIZE + LAPLACE_RADIUS * 2) * 4);           \n"
"  buf2 = g_new (gfloat, SQR (CHUNK_SIZE + LAPLACE_RADIUS * 2) * 4);           \n"
"  buf3 = g_new (gfloat, SQR (CHUNK_SIZE) * 4);                                \n"
"                                                                              \n"
"  for (j = 0; (j-1) * CHUNK_SIZE < result->height; j++)                       \n"
"    for (i = 0; (i-1) * CHUNK_SIZE < result->width; i++)                      \n"
"      {                                                                       \n"
"        GeglRectangle chunked_result;                                         \n"
"        GeglRectangle compute;                                                \n"
"                                                                              \n"
"        chunked_result = *GEGL_RECTANGLE (result->x + i * CHUNK_SIZE,         \n"
"                                          result->y + j * CHUNK_SIZE,         \n"
"                                          CHUNK_SIZE, CHUNK_SIZE);            \n"
"                                                                              \n"
"        gegl_rectangle_intersect (&chunked_result, &chunked_result, result);  \n"
"                                                                              \n"
"        if (chunked_result.width < 1  || chunked_result.height < 1)           \n"
"          continue;                                                           \n"
"                                                                              \n"
"        compute = gegl_operation_get_required_for_output (operation,          \n"
"                                                          \"input\",          \n"
"                                                          &chunked_result);   \n"
"                                                                              \n"
"        edge_laplace (input, &compute, output, &chunked_result,               \n"
"                      buf1, buf2, buf3);                                      \n"
"      }                                                                       \n"
"                                                                              \n"
"  g_free (buf1);                                                              \n"
"  g_free (buf2);                                                              \n"
"  g_free (buf3);                                                              \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"minmax  (gfloat  x1,                                                          \n"
"         gfloat  x2,                                                          \n"
"         gfloat  x3,                                                          \n"
"         gfloat  x4,                                                          \n"
"         gfloat  x5,                                                          \n"
"         gfloat *min_result,                                                  \n"
"         gfloat *max_result)                                                  \n"
"{                                                                             \n"
"  gfloat min1, min2, max1, max2;                                              \n"
"                                                                              \n"
"  if (x1 > x2)                                                                \n"
"    {                                                                         \n"
"      max1 = x1;                                                              \n"
"      min1 = x2;                                                              \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      max1 = x2;                                                              \n"
"      min1 = x1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (x3 > x4)                                                                \n"
"    {                                                                         \n"
"      max2 = x3;                                                              \n"
"      min2 = x4;                                                              \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      max2 = x4;                                                              \n"
"      min2 = x3;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (min1 < min2)                                                            \n"
"    *min_result = fminf (min1, x5);                                           \n"
"  else                                                                        \n"
"    *min_result = fminf (min2, x5);                                           \n"
"                                                                              \n"
"  if (max1 > max2)                                                            \n"
"    *max_result = fmaxf (max1, x5);                                           \n"
"  else                                                                        \n"
"    *max_result = fmaxf (max2, x5);                                           \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"edge_laplace (GeglBuffer          *src,                                       \n"
"              const GeglRectangle *src_rect,                                  \n"
"              GeglBuffer          *dst,                                       \n"
"              const GeglRectangle *dst_rect,                                  \n"
"              gfloat              *src_buf,                                   \n"
"              gfloat              *temp_buf,                                  \n"
"              gfloat              *dst_buf)                                   \n"
"{                                                                             \n"
"                                                                              \n"
"  gint    x, y;                                                               \n"
"  gint    offset;                                                             \n"
"  gint    src_width = src_rect->width;                                        \n"
"                                                                              \n"
"  gegl_buffer_get (src, src_rect, 1.0,                                        \n"
"                   babl_format (\"R'G'B'A float\"), src_buf, GEGL_AUTO_ROWSTRIDE,\n"
"                   GEGL_ABYSS_CLAMP);                                         \n"
"                                                                              \n"
"  for (y = 0; y < dst_rect->height + LAPLACE_RADIUS; y++)                     \n"
"    for (x = 0; x < dst_rect->width + LAPLACE_RADIUS; x++)                    \n"
"      {                                                                       \n"
"        gfloat *src_pix;                                                      \n"
"        gfloat  gradient[4] = {0.0f, 0.0f, 0.0f, 0.0f};                       \n"
"        gint    c;                                                            \n"
"        gfloat  minval, maxval;                                               \n"
"        gint    i = x + LAPLACE_RADIUS - 1;                                   \n"
"        gint    j = y + LAPLACE_RADIUS - 1;                                   \n"
"                                                                              \n"
"        offset = i + j * src_width;                                           \n"
"        src_pix = src_buf + offset * 4;                                       \n"
"                                                                              \n"
"        for (c = 0; c < 3; c++)                                               \n"
"          {                                                                   \n"
"            gfloat s1 = src_pix[c - src_width * 4];                           \n"
"            gfloat s2 = src_pix[c + src_width * 4];                           \n"
"            gfloat s3 = src_pix[c - 4];                                       \n"
"            gfloat s4 = src_pix[c + 4];                                       \n"
"            gfloat s  = src_pix[c];                                           \n"
"            gfloat temp_value;                                                \n"
"                                                                              \n"
"            /* four-neighbourhood */                                          \n"
"            minmax (s1, s2, s3, s4, s,                                        \n"
"                    &minval, &maxval);                                        \n"
"                                                                              \n"
"            gradient[c] = 0.5f * fmaxf ((maxval - s), (s - minval));          \n"
"                                                                              \n"
"            /* nine-neighbourhood */                                          \n"
"            temp_value = (src_pix[c - 4 - src_width * 4] +                    \n"
"                          s1 +                                                \n"
"                          src_pix[c + 4 - src_width * 4] +                    \n"
"                                                                              \n"
"                          s3 - 8.0f * s + s4 +                                \n"
"                                                                              \n"
"                          src_pix[c - 4 + src_width * 4] +                    \n"
"                          s2 +                                                \n"
"                          src_pix[c + 4 + src_width * 4]);                    \n"
"                                                                              \n"
"                                                                              \n"
"            if (temp_value < GEGL_FLOAT_EPSILON)                              \n"
"              gradient[c] *= -1.0f;                                           \n"
"          }                                                                   \n"
"                                                                              \n"
"        /* alpha */                                                           \n"
"        gradient[3] = src_pix[3];                                             \n"
"                                                                              \n"
"        for (c = 0; c < 4; c++)                                               \n"
"          temp_buf[offset * 4 + c] = gradient[c];                             \n"
"      }                                                                       \n"
"                                                                              \n"
"  /* 1-pixel edges */                                                         \n"
"  offset = 0;                                                                 \n"
"                                                                              \n"
"  for (y = 0; y < dst_rect->height; y++)                                      \n"
"    for (x = 0; x < dst_rect->width; x++)                                     \n"
"      {                                                                       \n"
"        gfloat  value[4] = {0.0f, 0.0f, 0.0f, 0.0f};                          \n"
"        gint    c;                                                            \n"
"        gint    i = x + LAPLACE_RADIUS;                                       \n"
"        gint    j = y + LAPLACE_RADIUS;                                       \n"
"        gfloat *src_pix = temp_buf + (i + j * src_width) * 4;                 \n"
"                                                                              \n"
"        for (c = 0; c < 3; c++)                                               \n"
"          {                                                                   \n"
"            gfloat current = src_pix[c];                                      \n"
"                                                                              \n"
"            current = ((current > 0.0f) &&                                    \n"
"                       (src_pix[c - 4 - src_width * 4] < 0.0f ||              \n"
"                        src_pix[c + 4 - src_width * 4] < 0.0f ||              \n"
"                        src_pix[c     - src_width * 4] < 0.0f ||              \n"
"                        src_pix[c - 4 + src_width * 4] < 0.0f ||              \n"
"                        src_pix[c + 4 + src_width * 4] < 0.0f ||              \n"
"                        src_pix[c     + src_width * 4] < 0.0f ||              \n"
"                        src_pix[c - 4                ] < 0.0f ||              \n"
"                        src_pix[c + 4                ] < 0.0f)) ?             \n"
"              current : 0.0f;                                                 \n"
"                                                                              \n"
"            value[c] = current;                                               \n"
"          }                                                                   \n"
"                                                                              \n"
"        /* alpha */                                                           \n"
"        value[3] = src_pix[3];                                                \n"
"                                                                              \n"
"        for (c = 0; c < 4; c++)                                               \n"
"          dst_buf[offset * 4 + c] = value[c];                                 \n"
"                                                                              \n"
"        offset++;                                                             \n"
"      }                                                                       \n"
"                                                                              \n"
"  gegl_buffer_set (dst, dst_rect, 0, babl_format (\"R'G'B'A float\"), dst_buf,\n"
"                   GEGL_AUTO_ROWSTRIDE);                                      \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"buffer/gegl-buffer-cl-iterator.h\"                                 \n"
"                                                                              \n"
"#include \"opencl/edge-laplace.cl.h\"                                         \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_edge_laplace (cl_mem                in_tex,                                \n"
"                 cl_mem                aux_tex,                               \n"
"                 cl_mem                out_tex,                               \n"
"                 const GeglRectangle  *src_rect,                              \n"
"                 const GeglRectangle  *roi,                                   \n"
"                 gint                  radius)                                \n"
"{                                                                             \n"
"  cl_int cl_err = 0;                                                          \n"
"  size_t global_ws_in[2];                                                     \n"
"  size_t global_ws_aux[2];                                                    \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"pre_edgelaplace\", \"knl_edgelaplace\", NULL};\n"
"      cl_data = gegl_cl_compile_and_build (edge_laplace_cl_source, kernel_name);\n"
"    }                                                                         \n"
"  if (!cl_data) return TRUE;                                                  \n"
"                                                                              \n"
"  global_ws_in[0] = roi->width  + LAPLACE_RADIUS;                             \n"
"  global_ws_in[1] = roi->height + LAPLACE_RADIUS;                             \n"
"                                                                              \n"
"  global_ws_aux[0] = roi->width;                                              \n"
"  global_ws_aux[1] = roi->height;                                             \n"
"                                                                              \n"
"  cl_err = gegl_cl_set_kernel_args (cl_data->kernel[0],                       \n"
"                                    sizeof (cl_mem), &in_tex,                 \n"
"                                    sizeof (cl_mem), &aux_tex,                \n"
"                                    NULL);                                    \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel (gegl_cl_get_command_queue (),         \n"
"                                        cl_data->kernel[0], 2,                \n"
"                                        NULL, global_ws_in, NULL,             \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"                                                                              \n"
"  cl_err = gegl_cl_set_kernel_args (cl_data->kernel[1],                       \n"
"                                    sizeof (cl_mem), &aux_tex,                \n"
"                                    sizeof (cl_mem), &out_tex,                \n"
"                                    NULL);                                    \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel (gegl_cl_get_command_queue (),         \n"
"                                        cl_data->kernel[1], 2,                \n"
"                                        NULL, global_ws_aux, NULL,            \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
" error:                                                                       \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            GeglBuffer          *input,                                       \n"
"            GeglBuffer          *output,                                      \n"
"            const GeglRectangle *result)                                      \n"
"{                                                                             \n"
"  const Babl *in_format  = gegl_operation_get_format (operation, \"input\");  \n"
"  const Babl *out_format = gegl_operation_get_format (operation, \"output\"); \n"
"  gint err = 0;                                                               \n"
"                                                                              \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"                                                                              \n"
"  GeglBufferClIterator *i = gegl_buffer_cl_iterator_new (output,              \n"
"                                                         result,              \n"
"                                                         out_format,          \n"
"                                                         GEGL_CL_BUFFER_WRITE);\n"
"                                                                              \n"
"  gint read = gegl_buffer_cl_iterator_add_2 (i,                               \n"
"                                             input,                           \n"
"                                             result,                          \n"
"                                             in_format,                       \n"
"                                             GEGL_CL_BUFFER_READ,             \n"
"                                             op_area->left,                   \n"
"                                             op_area->right,                  \n"
"                                             op_area->top,                    \n"
"                                             op_area->bottom,                 \n"
"                                             GEGL_ABYSS_CLAMP);               \n"
"                                                                              \n"
"  gint aux = gegl_buffer_cl_iterator_add_aux (i,                              \n"
"                                              result,                         \n"
"                                              in_format,                      \n"
"                                              op_area->left   - 1,            \n"
"                                              op_area->right  - 1,            \n"
"                                              op_area->top    - 1,            \n"
"                                              op_area->bottom - 1);           \n"
"                                                                              \n"
"  while (gegl_buffer_cl_iterator_next (i, &err) && !err)                      \n"
"    {                                                                         \n"
"      err = cl_edge_laplace (i->tex[read],                                    \n"
"                             i->tex[aux],                                     \n"
"                             i->tex[0],                                       \n"
"                             &i->roi[read],                                   \n"
"                             &i->roi[0],                                      \n"
"                             LAPLACE_RADIUS);                                 \n"
"                                                                              \n"
"      if (err)                                                                \n"
"        {                                                                     \n"
"          gegl_buffer_cl_iterator_stop (i);                                   \n"
"          break;                                                              \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return !err;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process    = process;                                         \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:edge-laplace\",                                   \n"
"    \"title\",       _(\"Laplacian Edge Detection\"),                         \n"
"    \"categories\",  \"edge-detect\",                                         \n"
"    \"license\",     \"GPL3+\",                                               \n"
"    \"description\", _(\"High-resolution edge detection\"),                   \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
