/* GCompris - Data.qml
 *
 * SPDX-FileCopyrightText: 2021 Harsh Kumar <hadron43@yahoo.com>
 *
 * Authors:
 *   Harsh Kumar <hadron43@yahoo.com>
 *
 *   SPDX-License-Identifier: GPL-3.0-or-later
 */
import core 1.0

Data {
    objective: qsTr("%1x%2 grids.").arg(10).arg(10)
    difficulty: 4
    data: [
        /*
            Symbols used:
            * -> path
            . -> empty
            S -> starting point
            E -> ending point
            I -> invisible tile
            R -> rock
            T -> tree
            B -> bush
            G -> grass
            W -> water

            Note: Make sure you have a unique path.
        */
        {
            path: [
                ['W', '.', '*', '*', '*', '.', '*', '*', '*', '.'],
                ['.', 'T', '*', 'T', '*', 'R', '*', 'B', '*', '*'],
                ['.', '*', '*', 'G', '*', '*', '*', 'G', '.', '*'],
                ['*', '*', 'R', '.', '.', '.', 'B', '*', '*', '*'],
                ['*', 'W', '.', '.', 'T', '.', '.', '*', '.', 'T'],
                ['*', '*', 'T', 'B', '.', 'G', 'G', '*', '*', 'E'],
                ['.', '*', '.', '.', '.', 'B', '.', '.', 'W', 'W'],
                ['B', '*', 'B', 'G', 'R', '*', '*', '*', '*', '*'],
                ['.', '*', '*', '*', '*', '*', '.', '.', 'T', 'S'],
                ['B', '.', '.', '.', 'B', '.', 'W', 'G', '.', '.'],
            ]
        },
        {
            path: [
                ['G', '.', 'W', '*', '*', '*', '.', '.', 'W', 'W'],
                ['.', '*', '*', '*', 'R', '*', 'W', '*', '*', '*'],
                ['G', '*', 'R', 'W', '.', '*', '.', '*', 'B', '*'],
                ['*', '*', '.', '.', 'G', '*', '*', '*', '.', '*'],
                ['*', 'G', 'W', '.', '.', '.', 'B', '.', 'T', '*'],
                ['*', '*', '.', 'B', '*', '*', '*', '.', '*', '*'],
                ['B', '*', '.', '*', '*', '.', '*', '*', '*', '.'],
                ['.', '*', 'T', '*', '.', 'T', '.', '.', 'R', '.'],
                ['S', '*', '.', '*', '*', '*', '*', '.', '.', '.'],
                ['.', '.', 'G', '.', 'W', '.', 'E', '.', 'B', '.'],
            ]
        }
    ]
}
