/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import protocol.MusicPlayer;

public class NavigationWidget
extends CustomItem {
    public static final int CONTROL_KEYS = 0;
    public static final int NUMERIC_KEYS = 1;
    public static final int MORE_KEYS = 2;
    Controller controller;
    Image clickIcon;
    Image[][] icons;
    boolean[][] keyPressed;
    final int rows;
    final int columns;
    int[] xOffset;
    int[] yOffset;
    int[] xSize;
    int[] ySize;
    int currentPlaylistPos;
    int currentTrackPos;
    int currentVolume;
    int maxPlaylistPos;
    int maxTrackPos;
    int controlType = 0;
    int formWidth = -1;
    int formHeight = -1;
    String[][] imageName;
    String[][] imagesControlActions = new String[][]{{"previous", "play", "next"}, {"rewind", "pause", "forward"}, {"vol_down", "stop", "vol_up"}, {"vol_mute", "select", "main"}};
    String[][] imagesNumericActions = new String[][]{{"number_1", "number_2", "number_3"}, {"number_4", "number_5", "number_6"}, {"number_7", "number_8", "number_9"}, {"play", "number_0", "stop"}};
    String[][] imagesMoreActions = new String[][]{{"previous", "play", "next"}, {"rewind", "guide", "forward"}, {"chanplus", "stop", "chanminus"}, {"eject", "display", "record"}};

    public NavigationWidget(Controller controller, int n, int n2, int n3) {
        super(null);
        int n4;
        int n5;
        int n6;
        this.rows = 4;
        this.columns = 3;
        this.controller = controller;
        this.controlType = n;
        this.formWidth = n2;
        this.formHeight = n3;
        this.clickIcon = this.loadImage("click_icon");
        this.icons = new Image[4][];
        this.keyPressed = new boolean[4][];
        for (n6 = 0; n6 < 4; ++n6) {
            this.icons[n6] = new Image[3];
            this.keyPressed[n6] = new boolean[3];
        }
        switch (n) {
            case 1: {
                this.imageName = this.imagesNumericActions;
                break;
            }
            case 2: {
                this.imageName = this.imagesMoreActions;
                break;
            }
            default: {
                this.imageName = this.imagesControlActions;
            }
        }
        for (n6 = 0; n6 < this.imageName.length; ++n6) {
            for (n5 = 0; n5 < this.imageName[n6].length; ++n5) {
                this.icons[n6][n5] = this.loadImage(this.imageName[n6][n5]);
            }
        }
        this.xSize = new int[3];
        this.ySize = new int[4];
        for (n6 = 0; n6 < 3; ++n6) {
            n5 = 0;
            for (n4 = 0; n4 < 4; ++n4) {
                if (this.icons[n4][n6] != null && this.icons[n4][n6].getWidth() > n5) {
                    n5 = this.icons[n4][n6].getWidth();
                }
                this.keyPressed[n4][n6] = false;
            }
            this.xSize[n6] = n5;
        }
        for (n6 = 0; n6 < 4; ++n6) {
            n5 = 0;
            for (n4 = 0; n4 < 3; ++n4) {
                if (this.icons[n6][n4] == null || this.icons[n6][n4].getHeight() <= n5) continue;
                n5 = this.icons[n6][n4].getHeight();
            }
            this.ySize[n6] = n5;
        }
        this.xOffset = new int[3];
        this.yOffset = new int[4];
        this.xOffset[0] = 0;
        for (n6 = 1; n6 < 3; ++n6) {
            this.xOffset[n6] = this.xOffset[n6 - 1] + this.xSize[n6 - 1];
        }
        this.yOffset[0] = 0;
        for (n6 = 1; n6 < 4; ++n6) {
            this.yOffset[n6] = this.yOffset[n6 - 1] + this.ySize[n6 - 1];
        }
    }

    public void setVolume(int n) {
        this.currentVolume = n;
        this.repaint();
    }

    public void setTrackPos(int n, int n2) {
        this.currentTrackPos = n;
        this.maxTrackPos = n2;
        this.repaint();
    }

    public void setPlaylistPos(int n, int n2) {
        this.currentPlaylistPos = n;
        this.maxPlaylistPos = n2;
        this.repaint();
    }

    private Image loadImage(String string) {
        Image image;
        try {
            image = Image.createImage((String)("/" + string + ".png"));
        }
        catch (IOException iOException) {
            image = null;
        }
        return image;
    }

    protected int getMinContentWidth() {
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            n += this.xSize[i];
        }
        return n;
    }

    protected int getMinContentHeight() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n += this.ySize[i];
        }
        return n;
    }

    protected int getPrefContentWidth(int n) {
        int n2 = this.formWidth == -1 ? this.getMinContentWidth() : this.formWidth;
        return n2;
    }

    protected int getPrefContentHeight(int n) {
        int n2 = this.formHeight == -1 ? this.getMinContentHeight() : this.formHeight;
        return n2;
    }

    public int getWidth() {
        return this.getPrefContentWidth(this.formHeight);
    }

    public int getHeight() {
        return this.getPrefContentHeight(this.formWidth);
    }

    void drawBar(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            n4 = 1;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > n4) {
            n3 = n4;
        }
        graphics.setColor(188, 200, 235);
        graphics.fillRect(0, this.yOffset[n2], n * n3 / n4, this.ySize[n2]);
        graphics.setColor(245, 250, 255);
        graphics.fillRect(n * n3 / n4, this.yOffset[n2], n - n * n3 / n4, this.ySize[n2]);
    }

    protected void paint(Graphics graphics, int n, int n2) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 3; ++j) {
                Image image = this.icons[i][j];
                if (image == null) continue;
                graphics.drawImage(image, this.xOffset[j], this.yOffset[i], 20);
                if (!this.keyPressed[i][j]) continue;
                graphics.drawImage(this.clickIcon, this.xOffset[j] + this.xSize[j] / 2, this.yOffset[i] + this.ySize[i] / 2, 3);
            }
        }
    }

    private int getRowForKey(int n) {
        switch (n) {
            case 49: 
            case 50: 
            case 51: {
                return 0;
            }
            case 52: 
            case 53: 
            case 54: {
                return 1;
            }
            case 55: 
            case 56: 
            case 57: {
                return 2;
            }
            case 35: 
            case 42: 
            case 48: {
                return 3;
            }
        }
        return 0;
    }

    private int getColForKey(int n) {
        switch (n) {
            case 42: 
            case 49: 
            case 52: 
            case 55: {
                return 0;
            }
            case 48: 
            case 50: 
            case 53: 
            case 56: {
                return 1;
            }
            case 35: 
            case 51: 
            case 54: 
            case 57: {
                return 2;
            }
        }
        return 0;
    }

    protected void keyPressed(int n) {
        this.keyPressed[this.getRowForKey((int)n)][this.getColForKey((int)n)] = true;
        this.repaint();
    }

    protected void keyReleased(int n) {
        MusicPlayer musicPlayer = this.controller.getPlayer();
        switch (this.controlType) {
            case 1: {
                this.keyReleasedNumericActions(musicPlayer, n);
                break;
            }
            case 2: {
                this.keyReleasedMoreActions(musicPlayer, n);
                break;
            }
            default: {
                this.keyReleasedControlActions(musicPlayer, n);
            }
        }
        this.keyPressed[this.getRowForKey((int)n)][this.getColForKey((int)n)] = false;
        this.repaint();
    }

    private void keyReleasedControlActions(MusicPlayer musicPlayer, int n) {
        switch (n) {
            case 49: {
                musicPlayer.previous();
                break;
            }
            case 50: {
                musicPlayer.play();
                break;
            }
            case 51: {
                musicPlayer.next();
                break;
            }
            case 52: {
                musicPlayer.rewind();
                break;
            }
            case 53: {
                musicPlayer.pause();
                break;
            }
            case 54: {
                musicPlayer.forward();
                break;
            }
            case 55: {
                musicPlayer.volumeQuieter();
                break;
            }
            case 56: {
                musicPlayer.stop();
                break;
            }
            case 57: {
                musicPlayer.volumeLouder();
                break;
            }
            case 48: {
                musicPlayer.submenu();
                break;
            }
            case 42: {
                musicPlayer.volumeMute();
                break;
            }
            case 35: {
                musicPlayer.mainMenu();
            }
        }
    }

    private void keyReleasedNumericActions(MusicPlayer musicPlayer, int n) {
        switch (n) {
            case 49: {
                musicPlayer.sendAction("NUM1");
                break;
            }
            case 50: {
                musicPlayer.sendAction("NUM2");
                break;
            }
            case 51: {
                musicPlayer.sendAction("NUM3");
                break;
            }
            case 52: {
                musicPlayer.sendAction("NUM4");
                break;
            }
            case 53: {
                musicPlayer.sendAction("NUM5");
                break;
            }
            case 54: {
                musicPlayer.sendAction("NUM6");
                break;
            }
            case 55: {
                musicPlayer.sendAction("NUM7");
                break;
            }
            case 56: {
                musicPlayer.sendAction("NUM8");
                break;
            }
            case 57: {
                musicPlayer.sendAction("NUM9");
                break;
            }
            case 48: {
                musicPlayer.sendAction("NUM0");
                break;
            }
            case 42: {
                musicPlayer.play();
                break;
            }
            case 35: {
                musicPlayer.stop();
            }
        }
    }

    private void keyReleasedMoreActions(MusicPlayer musicPlayer, int n) {
        switch (n) {
            case 49: {
                musicPlayer.previous();
                break;
            }
            case 50: {
                musicPlayer.play();
                break;
            }
            case 51: {
                musicPlayer.next();
                break;
            }
            case 52: {
                musicPlayer.rewind();
                break;
            }
            case 53: {
                musicPlayer.sendAction("GUID");
                break;
            }
            case 54: {
                musicPlayer.forward();
                break;
            }
            case 55: {
                musicPlayer.sendAction("CHA+");
                break;
            }
            case 56: {
                musicPlayer.stop();
                break;
            }
            case 57: {
                musicPlayer.sendAction("CHA-");
                break;
            }
            case 48: {
                musicPlayer.sendAction("DISP");
                break;
            }
            case 42: {
                musicPlayer.sendAction("EJEC");
                break;
            }
            case 35: {
                musicPlayer.sendAction("RECO");
            }
        }
    }
}

