/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.Language;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleReference;
import net.sourceforge.pmd.RuleSetReference;
import net.sourceforge.pmd.util.Benchmark;
import net.sourceforge.pmd.util.filter.Filter;
import net.sourceforge.pmd.util.filter.Filters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleSet {
    private List<Rule> rules = new ArrayList<Rule>();
    private String fileName;
    private String name = "";
    private String description = "";
    private Language language;
    private List<String> excludePatterns = new ArrayList<String>(0);
    private List<String> includePatterns = new ArrayList<String>(0);
    private Filter<File> filter;

    public int size() {
        return this.rules.size();
    }

    public void addRule(Rule rule) {
        if (rule == null) {
            throw new RuntimeException("Null Rule reference added to a RuleSet; that's a bug somewhere in PMD");
        }
        this.rules.add(rule);
    }

    public void addRuleByReference(String ruleSetFileName, Rule rule) {
        if (ruleSetFileName == null) {
            throw new RuntimeException("Adding a rule by reference is not allowed with a null rule set file name.");
        }
        if (rule == null) {
            throw new RuntimeException("Null Rule reference added to a RuleSet; that's a bug somewhere in PMD");
        }
        if (!(rule instanceof RuleReference)) {
            RuleSetReference ruleSetReference = new RuleSetReference();
            ruleSetReference.setRuleSetFileName(ruleSetFileName);
            RuleReference ruleReference = new RuleReference();
            ruleReference.setRule(rule);
            ruleReference.setRuleSetReference(ruleSetReference);
            rule = ruleReference;
        }
        this.rules.add(rule);
    }

    public Collection<Rule> getRules() {
        return this.rules;
    }

    public boolean usesDFA() {
        for (Rule r : this.rules) {
            if (!r.usesDFA()) continue;
            return true;
        }
        return false;
    }

    public Rule getRuleByName(String ruleName) {
        Rule rule = null;
        Iterator<Rule> i = this.rules.iterator();
        while (i.hasNext() && rule == null) {
            Rule r = i.next();
            if (!r.getName().equals(ruleName)) continue;
            rule = r;
        }
        return rule;
    }

    public void addRuleSet(RuleSet ruleSet) {
        this.rules.addAll(this.rules.size(), ruleSet.getRules());
    }

    public void addRuleSetByReference(RuleSet ruleSet, boolean allRules) {
        if (ruleSet.getFileName() == null) {
            throw new RuntimeException("Adding a rule by reference is not allowed with a null rule set file name.");
        }
        RuleSetReference ruleSetReference = new RuleSetReference();
        ruleSetReference.setRuleSetFileName(ruleSet.getFileName());
        ruleSetReference.setAllRules(allRules);
        for (Rule rule : ruleSet.getRules()) {
            RuleReference ruleReference = new RuleReference();
            ruleReference.setRule(rule);
            ruleReference.setRuleSetReference(ruleSetReference);
            this.rules.add(ruleReference);
        }
    }

    public boolean applies(File file) {
        if (this.filter == null) {
            Filter<String> regexFilter = Filters.buildRegexFilterIncludeOverExclude(this.includePatterns, this.excludePatterns);
            this.filter = Filters.toNormalizedFileFilter(regexFilter);
        }
        return file != null ? this.filter.filter(file) : true;
    }

    public void start(RuleContext ctx) {
        for (Rule rule : this.rules) {
            rule.start(ctx);
        }
    }

    public void apply(List acuList, RuleContext ctx) {
        long start = System.nanoTime();
        for (Rule rule : this.rules) {
            if (rule.usesRuleChain()) continue;
            rule.apply(acuList, ctx);
            long end = System.nanoTime();
            Benchmark.mark(0, rule.getName(), end - start, 1L);
            start = end;
        }
    }

    public void end(RuleContext ctx) {
        for (Rule rule : this.rules) {
            rule.end(ctx);
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RuleSet)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        RuleSet ruleSet = (RuleSet)o;
        return this.getName().equals(ruleSet.getName()) && ((Object)this.getRules()).equals(ruleSet.getRules());
    }

    public int hashCode() {
        return this.getName().hashCode() + 13 * ((Object)this.getRules()).hashCode();
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getExcludePatterns() {
        return this.excludePatterns;
    }

    public void addExcludePattern(String excludePattern) {
        this.excludePatterns.add(excludePattern);
    }

    public void addExcludePatterns(List<String> excludePatterns) {
        this.excludePatterns.addAll(excludePatterns);
    }

    public void setExcludePatterns(List<String> excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    public List<String> getIncludePatterns() {
        return this.includePatterns;
    }

    public void addIncludePattern(String includePattern) {
        this.includePatterns.add(includePattern);
    }

    public void addIncludePatterns(List<String> includePatterns) {
        this.includePatterns.addAll(includePatterns);
    }

    public void setIncludePatterns(List<String> includePatterns) {
        this.includePatterns = includePatterns;
    }

    public boolean usesTypeResolution() {
        for (Rule r : this.rules) {
            if (!r.usesTypeResolution()) continue;
            return true;
        }
        return false;
    }
}

