/*
 * Decompiled with CFR 0.152.
 */
package friendless.games.filler;

import friendless.games.filler.AbstractFillerPlayer;
import friendless.games.filler.DumbRobotPlayer;
import friendless.games.filler.Evaluator;
import friendless.games.filler.FillerModel;
import friendless.games.filler.FillerPlayerSpace;
import java.util.BitSet;
import java.util.Random;

public abstract class RobotPlayer
extends DumbRobotPlayer {
    protected final BitSet NO_COLOURS = new BitSet(9);
    protected final BitSet ALL_COLOURS = AbstractFillerPlayer.allColours();
    protected FillerPlayerSpace space = new FillerPlayerSpace();
    protected FillerModel model;
    protected int score = 0;
    protected int turn;
    protected int realScore;
    protected Random rng;

    protected RobotPlayer() {
    }

    public int takeTurn(FillerModel fillerModel, int n) {
        ++this.turn;
        this.model = fillerModel;
        this.otherPlayerColour = n;
        this.calculate(fillerModel);
        this.setScores();
        this.colour = this.turn();
        if (this.colour < 0) {
            this.colour = this.random_turn();
            System.out.println(this.getName() + " chooses randomly");
        }
        return this.colour;
    }

    protected void calculate(FillerModel fillerModel) {
        FillerModel.allocateTypes(fillerModel, this.origins, this.space);
    }

    protected void setScores() {
        int[] nArray = this.space.counted;
        this.score = 0;
        this.realScore = 0;
        int n = 0;
        while (n < nArray.length) {
            switch (nArray[n]) {
                case 7: {
                    ++this.score;
                    ++this.realScore;
                    break;
                }
                case 4: {
                    ++this.realScore;
                    break;
                }
            }
            ++n;
        }
    }

    int[] countSet(BitSet bitSet) {
        int[] nArray = this.space.counted;
        int[] nArray2 = new int[9];
        int n = 0;
        while (n < nArray.length) {
            if (bitSet.get(nArray[n])) {
                int n2 = this.model.pieces[n];
                nArray2[n2] = nArray2[n2] + 1;
            }
            ++n;
        }
        nArray2[this.otherPlayerColour] = -1;
        return nArray2;
    }

    int mostInSetTurn(BitSet bitSet) {
        int[] nArray = this.countSet(bitSet);
        BitSet bitSet2 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < 9) {
            if (nArray[n2] > 0) {
                if (nArray[n2] > n) {
                    bitSet2 = (BitSet)this.NO_COLOURS.clone();
                    bitSet2.set(n2);
                    n = nArray[n2];
                } else if (nArray[n2] == n) {
                    bitSet2.set(n2);
                }
            }
            ++n2;
        }
        return this.chooseRandom(bitSet2);
    }

    public int mostTurn() {
        BitSet bitSet = (BitSet)this.NO_COLOURS.clone();
        bitSet.set(6);
        bitSet.set(2);
        bitSet.set(9);
        return this.mostInSetTurn(bitSet);
    }

    public int mostFreeTurn() {
        BitSet bitSet = (BitSet)this.NO_COLOURS.clone();
        bitSet.set(6);
        bitSet.set(2);
        return this.mostInSetTurn(bitSet);
    }

    public int opponentMostTurn() {
        BitSet bitSet = (BitSet)this.NO_COLOURS.clone();
        bitSet.set(1);
        bitSet.set(2);
        return this.mostInSetTurn(bitSet);
    }

    public int targetTurn(int n) {
        if (n < 0) {
            return -1;
        }
        int[] nArray = this.space.counted;
        int n2 = 1000;
        int n3 = -1;
        int n4 = 0;
        while (n4 < nArray.length) {
            switch (nArray[n4]) {
                case 2: 
                case 6: {
                    int n5 = AbstractFillerPlayer.diagDistance(n, n4);
                    if (n5 >= n2 || this.model.pieces[n4] == this.otherPlayerColour) break;
                    n3 = this.model.pieces[n4];
                    n2 = n5;
                    break;
                }
            }
            ++n4;
        }
        return n3;
    }

    public int expandTurn() {
        int[] nArray = this.space.counted;
        int n = -1;
        int n2 = -1;
        int n3 = this.origins[0];
        int n4 = 0;
        while (n4 < nArray.length) {
            switch (nArray[n4]) {
                case 2: 
                case 6: {
                    int n5 = AbstractFillerPlayer.sideDistance(n4, n3);
                    if (n5 <= n || this.model.pieces[n4] == this.otherPlayerColour) break;
                    n2 = this.model.pieces[n4];
                    n = n5;
                }
            }
            ++n4;
        }
        return n2;
    }

    public int furthest_border_turn() {
        int[] nArray = this.space.counted;
        int n = -1;
        int n2 = -1;
        int n3 = this.origins[0];
        int n4 = 0;
        while (n4 < nArray.length) {
            switch (nArray[n4]) {
                case 2: 
                case 6: {
                    int n5;
                    if (!FillerModel.isPerimeter(n4) || this.model.pieces[n4] == this.otherPlayerColour || (n5 = AbstractFillerPlayer.sideDistance(n4, n3)) <= n) break;
                    n2 = this.model.pieces[n4];
                    n = n5;
                }
            }
            ++n4;
        }
        return n2;
    }

    public int borderTurn() {
        int[] nArray = this.space.counted;
        int n = 0;
        while (n < nArray.length) {
            switch (nArray[n]) {
                case 2: 
                case 6: {
                    if (!FillerModel.isPerimeter(n) || this.model.pieces[n] == this.otherPlayerColour) break;
                    return this.model.pieces[n];
                }
            }
            ++n;
        }
        return -1;
    }

    protected int dontExpandTurn() {
        int[] nArray = this.space.counted;
        int n = Integer.MAX_VALUE;
        int n2 = -1;
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4;
            if ((nArray[n3] == 6 || nArray[n3] == 2 || nArray[n3] == 4) && (n4 = AbstractFillerPlayer.diagDistance(n3, this.origins[0])) < n && this.model.pieces[n3] != this.otherPlayerColour) {
                n2 = this.model.pieces[n3];
                n = n4;
            }
            ++n3;
        }
        return n2;
    }

    public int goalTurn(int n) {
        if (n < 0) {
            return -1;
        }
        int[] nArray = this.space.counted;
        if (nArray[n] == 7 || nArray[n] == 5 || nArray[n] == 3) {
            return -1;
        }
        int n2 = -1;
        int n3 = 1000;
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5;
            if ((nArray[n4] == 6 || nArray[n4] == 2) && (n5 = AbstractFillerPlayer.diagDistance(n, n4)) < n3 && this.model.pieces[n4] != this.otherPlayerColour) {
                n2 = this.model.pieces[n4];
                n3 = n5;
            }
            ++n4;
        }
        return n2;
    }

    public int smartMostTurn() {
        int n = this.mostIfWinTurn();
        if (n < 0) {
            n = this.mostFreeTurn();
        }
        if (n < 0) {
            n = this.mostTurn();
        }
        return n;
    }

    public int mostIfWinTurn() {
        BitSet bitSet = (BitSet)this.NO_COLOURS.clone();
        bitSet.set(6);
        bitSet.set(2);
        bitSet.set(9);
        int[] nArray = this.countSet(bitSet);
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        while (n3 < 9) {
            if (nArray[n3] > n2) {
                n = n3;
                n2 = nArray[n3];
            }
            ++n3;
        }
        if (n2 + this.score >= 689) {
            return n;
        }
        return -1;
    }

    protected BitSet maximise(Evaluator evaluator, BitSet bitSet, FillerModel fillerModel, int[] nArray) {
        int n = Integer.MIN_VALUE;
        BitSet bitSet2 = (BitSet)this.NO_COLOURS.clone();
        int n2 = 0;
        while (n2 < 9) {
            if (bitSet.get(n2)) {
                int n3 = evaluator.eval(fillerModel, nArray);
                if (n3 == n) {
                    bitSet2.set(n2);
                } else if (n3 > n) {
                    bitSet2.and(this.NO_COLOURS);
                    bitSet2.set(n2);
                    n = n3;
                }
            }
            ++n2;
        }
        return bitSet2;
    }

    public String getIcon() {
        return "redAlien.gif";
    }
}

