/*
 * Decompiled with CFR 0.152.
 */
package visad.ss;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.JComponent;

public class SSLayout
implements LayoutManager {
    private int NumCols;
    private int NumRows;
    private int ColSpace;
    private int RowSpace;

    public SSLayout(int ncol, int nrow, int wspace, int hspace) {
        this.NumCols = ncol;
        this.NumRows = nrow;
        this.ColSpace = wspace;
        this.RowSpace = hspace;
    }

    private Component[] fillOut(Component[] c) {
        System.err.println("Warning: spreadsheet cell layout is corrupted");
        Component[] nc = new Component[this.NumCols * this.NumRows];
        System.arraycopy(c, 0, nc, 0, c.length);
        for (int i = c.length; i < nc.length; ++i) {
            nc[i] = new JComponent(){

                public void paint(Graphics g) {
                }
            };
        }
        return nc;
    }

    public void layoutContainer(Container parent) {
        Component[] c = parent.getComponents();
        if (c.length < this.NumCols * this.NumRows) {
            c = this.fillOut(c);
        }
        int[] pw = new int[this.NumCols];
        for (int i = 0; i < this.NumCols; ++i) {
            pw[i] = c[i].getPreferredSize().width;
        }
        int[] ph = new int[this.NumRows];
        for (int j = 0; j < this.NumRows; ++j) {
            ph[j] = c[this.NumCols * j].getPreferredSize().height;
        }
        int sy = 0;
        for (int j = 0; j < this.NumRows; ++j) {
            int sx = 0;
            for (int i = 0; i < this.NumCols; ++i) {
                c[this.NumCols * j + i].setBounds(sx, sy, pw[i], ph[j]);
                sx += pw[i] + this.ColSpace;
            }
            sy += ph[j] + this.RowSpace;
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public Dimension preferredLayoutSize(Container parent) {
        Component[] c = parent.getComponents();
        if (c.length < this.NumCols * this.NumRows) {
            c = this.fillOut(c);
        }
        int pwt = -this.ColSpace;
        for (int i = 0; i < this.NumCols; ++i) {
            pwt += c[i].getPreferredSize().width + this.ColSpace;
        }
        int pht = -this.RowSpace;
        for (int j = 0; j < this.NumRows; ++j) {
            pht += c[this.NumCols * j].getPreferredSize().height + this.RowSpace;
        }
        return new Dimension(pwt, pht);
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }
}

