/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grid;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import thredds.datamodel.gis.AbstractGisFeature;
import thredds.datamodel.gis.GisPart;
import ucar.nc2.ui.grid.ContourLine;

public class ContourFeature
extends AbstractGisFeature {
    private int numparts;
    private int npts;
    private ArrayList lines;
    private double contourValue;

    public ContourFeature(ArrayList conLines) {
        this.numparts = conLines.size();
        this.lines = new ArrayList(conLines);
        this.contourValue = conLines.size() > 0 ? ((ContourLine)this.lines.get(0)).getContourLevel() : 0.0;
        int count = 0;
        for (int i = 0; i < this.numparts; ++i) {
            GisPart cl = (GisPart)conLines.get(i);
            int np = cl.getNumPoints();
            count += np;
            if (((ContourLine)this.lines.get(i)).getContourLevel() == this.contourValue) continue;
            System.out.println("  Mismatch: all contour levels in one ContourFeature should be the same.");
        }
        this.npts = count;
    }

    public double getContourValue() {
        return this.contourValue;
    }

    public Rectangle2D getBounds2D() {
        double x0 = ((ContourLine)this.lines.get(0)).getX()[0];
        double y0 = ((ContourLine)this.lines.get(0)).getY()[0];
        double xMaxInd = x0;
        double xmin = x0;
        double yMaxInd = y0;
        double ymin = y0;
        for (int i = 0; i < this.lines.size(); ++i) {
            ContourLine cline = (ContourLine)this.lines.get(i);
            double[] xpts = cline.getX();
            double[] ypts = cline.getY();
            for (int j = 0; j < cline.getNumPoints(); ++j) {
                if (xpts[j] < xmin) {
                    xmin = xpts[j];
                } else if (xpts[j] > xMaxInd) {
                    xMaxInd = xpts[j];
                }
                if (ypts[j] < ymin) {
                    ymin = ypts[j];
                    continue;
                }
                if (!(ypts[j] > yMaxInd)) continue;
                yMaxInd = ypts[j];
            }
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(xmin, ymin, xMaxInd - xmin, yMaxInd - ymin);
        return rect;
    }

    public Iterator getGisParts() {
        return this.lines.iterator();
    }

    public int getNumParts() {
        return this.numparts;
    }

    public int getNumPoints() {
        return this.npts;
    }
}

