/* $Id: LibUnit.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __LIB_UNIT_HPP_INCLUDED
#define __LIB_UNIT_HPP_INCLUDED

#include <list>
#include <string>
#include "frontend/ast/AttributableDeclaration.hpp"
#include "frontend/ast/SimpleName.hpp"

namespace ast {

//! VHDL library unit
/** a VHDL library unit */
class LibUnit : public AttributableDeclaration {
public:
	//! c'tor
	/** 
	 * @param declName name of the declared symbol.
	 * @param libs library clauses
         * @param useCs use clauses
         * @param decls local declarations.
         * @param loc location of the declaration.
         */
	LibUnit(
		std::string *declName,
		std::list<SimpleName*> *libs,
		std::list<Name*>* useCs,
		std::list<SymbolDeclaration*>* decls,
		Location loc
		) : 	AttributableDeclaration(declName, loc),
			libClauses(libs),
			useClauses(useCs),
			declarations(decls) {}
	
	/** library clauses */
	std::list<SimpleName*> *libClauses;
	/** use clauses */
	std::list<Name*> *useClauses;
	/** declarations */
	std::list<SymbolDeclaration*> *declarations;

protected:
	/** Destructor */
	virtual ~LibUnit() {
		util::MiscUtil::lterminate(libClauses);
		util::MiscUtil::lterminate(useClauses);
		util::MiscUtil::lterminate(declarations);
	}
};

}; /* namespace ast */

#endif /* __LIB_UNIT_HPP_INCLUDED */
