/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.BinaryNode;
import java.awt.Color;

public class SequenceNode
extends BinaryNode {
    public float dist;
    public int count;
    public float height;
    public float ycount;
    public Color color = Color.black;
    public boolean dummy = false;
    private boolean placeholder = false;

    public SequenceNode() {
    }

    public SequenceNode(Object val, SequenceNode parent, float dist, String name) {
        super(val, parent, name);
        this.dist = dist;
    }

    public SequenceNode(Object val, SequenceNode parent, String name, float dist, int bootstrap, boolean dummy) {
        super(val, parent, name);
        this.dist = dist;
        this.bootstrap = bootstrap;
        this.dummy = dummy;
    }

    public boolean isDummy() {
        return this.dummy;
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }

    public boolean setDummy(boolean newstate) {
        boolean oldstate = this.dummy;
        this.dummy = newstate;
        return oldstate;
    }

    public void setPlaceholder(boolean Placeholder) {
        this.placeholder = Placeholder;
    }

    public SequenceNode AscendTree() {
        SequenceNode c = this;
        while ((c = (SequenceNode)c.parent()) != null && c.dummy) {
        }
        return c;
    }

    public boolean isSequenceLabel() {
        if (this.name != null && this.name.length() > 0) {
            int s = this.name.length();
            for (int c = 0; c < s; ++c) {
                char q = this.name.charAt(c);
                if ('0' <= q && q <= '9') continue;
                return true;
            }
        }
        return false;
    }
}

