/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.emboss.jemboss.editor.GraphicSequenceCollection;

public class PatternJFrame
extends JFrame {
    private GraphicSequenceCollection gsc = null;
    private int viewResiduePosition = -1;
    private JCheckBox wrapAround;

    public PatternJFrame() {
        super("Find Pattern");
        JPanel mainPane = (JPanel)this.getContentPane();
        mainPane.setLayout(new BorderLayout());
        Box YBox = Box.createVerticalBox();
        YBox.add(Box.createVerticalStrut(5));
        mainPane.add((Component)YBox, "North");
        Box XBox = Box.createHorizontalBox();
        JLabel label = new JLabel("Pattern: ");
        XBox.add(label);
        final JTextField patternField = new JTextField();
        patternField.setPreferredSize(new Dimension(150, (int)label.getPreferredSize().getHeight()));
        patternField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PatternJFrame.this.gsc != null) {
                    String pattern = patternField.getText();
                    if (!pattern.equals("")) {
                        PatternJFrame.this.viewResiduePosition = PatternJFrame.this.gsc.findPattern(pattern, PatternJFrame.this.viewResiduePosition, PatternJFrame.this.wrapAround.isSelected());
                    }
                    PatternJFrame.this.gsc.repaint();
                } else {
                    JOptionPane.showMessageDialog(null, "No sequences loaded to search", "No Sequences", 2);
                }
            }
        });
        XBox.add(patternField);
        mainPane.add((Component)XBox, "Center");
        Box southBox = Box.createVerticalBox();
        mainPane.add((Component)southBox, "South");
        XBox = Box.createHorizontalBox();
        this.wrapAround = new JCheckBox("Wrap around", true);
        XBox.add(this.wrapAround);
        XBox.add(Box.createHorizontalGlue());
        southBox.add(XBox);
        XBox = Box.createHorizontalBox();
        JButton findButton = new JButton("Find");
        XBox.add(findButton);
        findButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PatternJFrame.this.gsc != null) {
                    String pattern = patternField.getText();
                    if (!pattern.equals("")) {
                        PatternJFrame.this.viewResiduePosition = PatternJFrame.this.gsc.findPattern(pattern, PatternJFrame.this.viewResiduePosition, PatternJFrame.this.wrapAround.isSelected());
                    }
                    PatternJFrame.this.gsc.repaint();
                } else {
                    JOptionPane.showMessageDialog(null, "No sequences loaded to search", "No Sequences", 2);
                }
            }
        });
        JButton cancelButt = new JButton("Cancel");
        cancelButt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PatternJFrame.this.setVisible(false);
                PatternJFrame.this.viewResiduePosition = -1;
            }
        });
        XBox.add(cancelButt);
        southBox.add(XBox);
        this.pack();
    }

    protected void setGraphic(GraphicSequenceCollection gsc) {
        this.gsc = gsc;
    }
}

