/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha2

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1alpha2 "k8s.io/api/resource/v1alpha2"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	resourcev1alpha2 "k8s.io/client-go/applyconfigurations/resource/v1alpha2"
	scheme "k8s.io/client-go/kubernetes/scheme"
	rest "k8s.io/client-go/rest"
)

// PodSchedulingContextsGetter has a method to return a PodSchedulingContextInterface.
// A group's client should implement this interface.
type PodSchedulingContextsGetter interface {
	PodSchedulingContexts(namespace string) PodSchedulingContextInterface
}

// PodSchedulingContextInterface has methods to work with PodSchedulingContext resources.
type PodSchedulingContextInterface interface {
	Create(ctx context.Context, podSchedulingContext *v1alpha2.PodSchedulingContext, opts v1.CreateOptions) (*v1alpha2.PodSchedulingContext, error)
	Update(ctx context.Context, podSchedulingContext *v1alpha2.PodSchedulingContext, opts v1.UpdateOptions) (*v1alpha2.PodSchedulingContext, error)
	UpdateStatus(ctx context.Context, podSchedulingContext *v1alpha2.PodSchedulingContext, opts v1.UpdateOptions) (*v1alpha2.PodSchedulingContext, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha2.PodSchedulingContext, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha2.PodSchedulingContextList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha2.PodSchedulingContext, err error)
	Apply(ctx context.Context, podSchedulingContext *resourcev1alpha2.PodSchedulingContextApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha2.PodSchedulingContext, err error)
	ApplyStatus(ctx context.Context, podSchedulingContext *resourcev1alpha2.PodSchedulingContextApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha2.PodSchedulingContext, err error)
	PodSchedulingContextExpansion
}

// podSchedulingContexts implements PodSchedulingContextInterface
type podSchedulingContexts struct {
	client rest.Interface
	ns     string
}

// newPodSchedulingContexts returns a PodSchedulingContexts
func newPodSchedulingContexts(c *ResourceV1alpha2Client, namespace string) *podSchedulingContexts {
	return &podSchedulingContexts{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the podSchedulingContext, and returns the corresponding podSchedulingContext object, and an error if there is any.
func (c *podSchedulingContexts) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha2.PodSchedulingContext, err error) {
	result = &v1alpha2.PodSchedulingContext{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("podschedulingcontexts").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of PodSchedulingContexts that match those selectors.
func (c *podSchedulingContexts) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha2.PodSchedulingContextList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha2.PodSchedulingContextList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("podschedulingcontexts").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested podSchedulingContexts.
func (c *podSchedulingContexts) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("podschedulingcontexts").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a podSchedulingContext and creates it.  Returns the server's representation of the podSchedulingContext, and an error, if there is any.
func (c *podSchedulingContexts) Create(ctx context.Context, podSchedulingContext *v1alpha2.PodSchedulingContext, opts v1.CreateOptions) (result *v1alpha2.PodSchedulingContext, err error) {
	result = &v1alpha2.PodSchedulingContext{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("podschedulingcontexts").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(podSchedulingContext).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a podSchedulingContext and updates it. Returns the server's representation of the podSchedulingContext, and an error, if there is any.
func (c *podSchedulingContexts) Update(ctx context.Context, podSchedulingContext *v1alpha2.PodSchedulingContext, opts v1.UpdateOptions) (result *v1alpha2.PodSchedulingContext, err error) {
	result = &v1alpha2.PodSchedulingContext{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("podschedulingcontexts").
		Name(podSchedulingContext.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(podSchedulingContext).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *podSchedulingContexts) UpdateStatus(ctx context.Context, podSchedulingContext *v1alpha2.PodSchedulingContext, opts v1.UpdateOptions) (result *v1alpha2.PodSchedulingContext, err error) {
	result = &v1alpha2.PodSchedulingContext{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("podschedulingcontexts").
		Name(podSchedulingContext.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(podSchedulingContext).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the podSchedulingContext and deletes it. Returns an error if one occurs.
func (c *podSchedulingContexts) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("podschedulingcontexts").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *podSchedulingContexts) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("podschedulingcontexts").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched podSchedulingContext.
func (c *podSchedulingContexts) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha2.PodSchedulingContext, err error) {
	result = &v1alpha2.PodSchedulingContext{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("podschedulingcontexts").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied podSchedulingContext.
func (c *podSchedulingContexts) Apply(ctx context.Context, podSchedulingContext *resourcev1alpha2.PodSchedulingContextApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha2.PodSchedulingContext, err error) {
	if podSchedulingContext == nil {
		return nil, fmt.Errorf("podSchedulingContext provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(podSchedulingContext)
	if err != nil {
		return nil, err
	}
	name := podSchedulingContext.Name
	if name == nil {
		return nil, fmt.Errorf("podSchedulingContext.Name must be provided to Apply")
	}
	result = &v1alpha2.PodSchedulingContext{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("podschedulingcontexts").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *podSchedulingContexts) ApplyStatus(ctx context.Context, podSchedulingContext *resourcev1alpha2.PodSchedulingContextApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha2.PodSchedulingContext, err error) {
	if podSchedulingContext == nil {
		return nil, fmt.Errorf("podSchedulingContext provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(podSchedulingContext)
	if err != nil {
		return nil, err
	}

	name := podSchedulingContext.Name
	if name == nil {
		return nil, fmt.Errorf("podSchedulingContext.Name must be provided to Apply")
	}

	result = &v1alpha2.PodSchedulingContext{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("podschedulingcontexts").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
