#ifndef dataoutputstream_H__
#define dataoutputstream_H__

#include "outputbuffer.h"
#include "types.h"
#include <string>

namespace rpc {

  /**
   * Provides easy writing of primitive data type values.
   * 
   */
class DataOutputStream
{
 public:
  DataOutputStream(OutputBuffer* aBuffer) : out(aBuffer) {}

  /*! Writes a 32 bit signed integer */
  void writeInt(int32 i);

  /*! Writes a 8 bit signed byte */
  void writeByte(int8 b);

  /*! Writes a 16 bit signed short */
  void writeShort(int16 s);

  /*! Writes a 8 bit boolean value */
  void writeBool(bool b);

  /*! Writes a 64 bit signed integer */
  void writeLong(int64 l);

  /*! Writes a string. The string must be encoded using UTF-8, this method does not perform any conversion. */
  void writeUTF(const std::string& str);

 private:
  OutputBuffer* out;
};

}

#endif
