#include "cursor.h"
#include "repinfo.h"
#include "levtr.h"
#include <cstring>

using namespace wreport;

namespace dballe {
namespace db {
namespace v7 {
namespace cursor {


/*
 * Stations
 */

void StationRows::enq(impl::Enq& enq) const
{
    if (enq.search_b_values(values())) return;

    const auto key = enq.key;
    const auto len = enq.len;

    switch (len) {
        case 3:
            if (key[0] == 'l') {
            switch (key[1]) {
                case 'a':
                    if (key[2] == 't') {
                        enq.set_lat(cur->station.coords.lat);
                    } else {
                        enq.search_alias_values(values());
                    }
                    break;
                case 'o':
                    if (key[2] == 'n') {
                        enq.set_lon(cur->station.coords.lon);
                    } else {
                        enq.search_alias_values(values());
                    }
                    break;
                default: enq.search_alias_values(values());
            }
            } else {
                enq.search_alias_values(values());
            }
            break;
        case 5:
            if (memcmp(key + 0, "ident", 5) == 0) {
                enq.set_ident(cur->station.ident);
            } else {
                enq.search_alias_values(values());
            }
            break;
        case 6:
            switch (key[0]) {
                case 'r':
                    if (memcmp(key + 1, "eport", 5) == 0) {
                        enq.set_string(cur->station.report);
                    } else {
                        enq.search_alias_values(values());
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_id", 5) == 0) {
                        enq.set_dballe_int(cur->station.id);
                    } else {
                        enq.search_alias_values(values());
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "obile", 5) == 0) {
                        enq.set_bool(!cur->station.ident.is_missing());
                    } else {
                        enq.search_alias_values(values());
                    }
                    break;
                case 'c':
                    if (memcmp(key + 1, "oords", 5) == 0) {
                        enq.set_coords(cur->station.coords);
                    } else {
                        enq.search_alias_values(values());
                    }
                    break;
                default: enq.search_alias_values(values());
            }
            break;
        case 7:
            if (memcmp(key + 0, "station", 7) == 0) {
                enq.set_station(cur->station);
            } else {
                enq.search_alias_values(values());
            }
            break;
        case 8:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riority", 7) == 0) {
                        enq.set_int(get_priority());
                    } else {
                        enq.search_alias_values(values());
                    }
                    break;
                case 'r':
                    if (memcmp(key + 1, "ep_memo", 7) == 0) {
                        enq.set_string(cur->station.report);
                    } else {
                        enq.search_alias_values(values());
                    }
                    break;
                default: enq.search_alias_values(values());
            }
            break;
        default: enq.search_alias_values(values());
    }
}


/*
 * StationData
 */

void StationDataRows::enq(impl::Enq& enq) const
{
    if (enq.search_b_value(cur->value)) return;

    const auto key = enq.key;
    const auto len = enq.len;

    switch (len) {
        case 3:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (key[2] == 't') {
                                enq.set_lat(cur->station.coords.lat);
                            } else {
                                enq.search_alias_value(cur->value);
                            }
                            break;
                        case 'o':
                            if (key[2] == 'n') {
                                enq.set_lon(cur->station.coords.lon);
                            } else {
                                enq.search_alias_value(cur->value);
                            }
                            break;
                        default: enq.search_alias_value(cur->value);
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "ar", 2) == 0) {
                        enq.set_varcode(cur->value.code());
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                default: enq.search_alias_value(cur->value);
            }
            break;
        case 5:
            switch (key[0]) {
                case 'i':
                    if (memcmp(key + 1, "dent", 4) == 0) {
                        enq.set_ident(cur->station.ident);
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "ttrs", 4) == 0) {
                        enq.set_attrs(cur->value.get());
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                default: enq.search_alias_value(cur->value);
            }
            break;
        case 6:
            switch (key[0]) {
                case 'r':
                    if (memcmp(key + 1, "eport", 5) == 0) {
                        enq.set_string(cur->station.report);
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_id", 5) == 0) {
                        enq.set_dballe_int(cur->station.id);
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "obile", 5) == 0) {
                        enq.set_bool(!cur->station.ident.is_missing());
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 'c':
                    if (memcmp(key + 1, "oords", 5) == 0) {
                        enq.set_coords(cur->station.coords);
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                default: enq.search_alias_value(cur->value);
            }
            break;
        case 7:
            if (memcmp(key + 0, "station", 7) == 0) {
                enq.set_station(cur->station);
            } else {
                enq.search_alias_value(cur->value);
            }
            break;
        case 8:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riority", 7) == 0) {
                        enq.set_int(get_priority());
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 'r':
                    if (memcmp(key + 1, "ep_memo", 7) == 0) {
                        enq.set_string(cur->station.report);
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "ariable", 7) == 0) {
                        enq.set_var(cur->value.get());
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                default: enq.search_alias_value(cur->value);
            }
            break;
        case 10:
            if (memcmp(key + 0, "context_id", 10) == 0) {
                enq.set_dballe_int(cur->value.data_id);
            } else {
                enq.search_alias_value(cur->value);
            }
            break;
        default: enq.search_alias_value(cur->value);
    }
}

/*
 * Data
 */

void BaseDataRows::enq(impl::Enq& enq) const
{
    if (enq.search_b_value(cur->value)) return;

    const auto key = enq.key;
    const auto len = enq.len;

    switch (len) {
        case 2:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case '1':
                            enq.set_dballe_int(get_levtr().level.l1);
                            break;
                        case '2':
                            enq.set_dballe_int(get_levtr().level.l2);
                            break;
                        default: enq.search_alias_value(cur->value);
                    }
                    break;
                case 'p':
                    switch (key[1]) {
                        case '1':
                            enq.set_dballe_int(get_levtr().trange.p1);
                            break;
                        case '2':
                            enq.set_dballe_int(get_levtr().trange.p2);
                            break;
                        default: enq.search_alias_value(cur->value);
                    }
                    break;
                default: enq.search_alias_value(cur->value);
            }
            break;
        case 3:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (key[2] == 't') {
                                enq.set_lat(cur->station.coords.lat);
                            } else {
                                enq.search_alias_value(cur->value);
                            }
                            break;
                        case 'o':
                            if (key[2] == 'n') {
                                enq.set_lon(cur->station.coords.lon);
                            } else {
                                enq.search_alias_value(cur->value);
                            }
                            break;
                        default: enq.search_alias_value(cur->value);
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "ay", 2) == 0) {
                        enq.set_int(cur->datetime.day);
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "in", 2) == 0) {
                        enq.set_int(cur->datetime.minute);
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ec", 2) == 0) {
                        enq.set_int(cur->datetime.second);
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "ar", 2) == 0) {
                        enq.set_varcode(cur->value.code());
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                default: enq.search_alias_value(cur->value);
            }
            break;
        case 4:
            switch (key[0]) {
                case 'y':
                    if (memcmp(key + 1, "ear", 3) == 0) {
                        enq.set_int(cur->datetime.year);
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "our", 3) == 0) {
                        enq.set_int(cur->datetime.hour);
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                default: enq.search_alias_value(cur->value);
            }
            break;
        case 5:
            switch (key[0]) {
                case 'i':
                    if (memcmp(key + 1, "dent", 4) == 0) {
                        enq.set_ident(cur->station.ident);
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onth", 4) == 0) {
                        enq.set_int(cur->datetime.month);
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 'l':
                    if (memcmp(key + 1, "evel", 4) == 0) {
                        enq.set_level(get_levtr().level);
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "ttrs", 4) == 0) {
                        enq.set_attrs(cur->value.get());
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                default: enq.search_alias_value(cur->value);
            }
            break;
        case 6:
            switch (key[0]) {
                case 'r':
                    if (memcmp(key + 1, "eport", 5) == 0) {
                        enq.set_string(cur->station.report);
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_id", 5) == 0) {
                        enq.set_dballe_int(cur->station.id);
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "obile", 5) == 0) {
                        enq.set_bool(!cur->station.ident.is_missing());
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 'c':
                    if (memcmp(key + 1, "oords", 5) == 0) {
                        enq.set_coords(cur->station.coords);
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 't':
                    if (memcmp(key + 1, "range", 5) == 0) {
                        enq.set_trange(get_levtr().trange);
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                default: enq.search_alias_value(cur->value);
            }
            break;
        case 7:
            if (memcmp(key + 0, "station", 7) == 0) {
                enq.set_station(cur->station);
            } else {
                enq.search_alias_value(cur->value);
            }
            break;
        case 8:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riority", 7) == 0) {
                        enq.set_int(get_priority());
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 'r':
                    if (memcmp(key + 1, "ep_memo", 7) == 0) {
                        enq.set_string(cur->station.report);
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "atetime", 7) == 0) {
                        enq.set_datetime(cur->datetime);
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "ariable", 7) == 0) {
                        enq.set_var(cur->value.get());
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                default: enq.search_alias_value(cur->value);
            }
            break;
        case 10:
            switch (key[0]) {
                case 'l':
                    if (memcmp(key + 1, "eveltype", 8) == 0) {
                        switch (key[9]) {
                            case '1':
                                enq.set_dballe_int(get_levtr().level.ltype1);
                                break;
                            case '2':
                                enq.set_dballe_int(get_levtr().level.ltype2);
                                break;
                            default: enq.search_alias_value(cur->value);
                        }
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 'p':
                    if (memcmp(key + 1, "indicator", 9) == 0) {
                        enq.set_dballe_int(get_levtr().trange.pind);
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                case 'c':
                    if (memcmp(key + 1, "ontext_id", 9) == 0) {
                        enq.set_dballe_int(cur->value.data_id);
                    } else {
                        enq.search_alias_value(cur->value);
                    }
                    break;
                default: enq.search_alias_value(cur->value);
            }
            break;
        default: enq.search_alias_value(cur->value);
    }
}

/*
 * Summary
 */

void SummaryRows::enq(impl::Enq& enq) const
{
    const auto key = enq.key;
    const auto len = enq.len;

    switch (len) {
        case 2:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case '1':
                            enq.set_dballe_int(get_levtr().level.l1);
                            break;
                        case '2':
                            enq.set_dballe_int(get_levtr().level.l2);
                            break;
                        default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'p':
                    switch (key[1]) {
                        case '1':
                            enq.set_dballe_int(get_levtr().trange.p1);
                            break;
                        case '2':
                            enq.set_dballe_int(get_levtr().trange.p2);
                            break;
                        default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s not found on this query result", key);
            }
            break;
        case 3:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (key[2] == 't') {
                                enq.set_lat(cur->station.coords.lat);
                            } else {
                                wreport::error_notfound::throwf("key %s not found on this query result", key);
                            }
                            break;
                        case 'o':
                            if (key[2] == 'n') {
                                enq.set_lon(cur->station.coords.lon);
                            } else {
                                wreport::error_notfound::throwf("key %s not found on this query result", key);
                            }
                            break;
                        default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "ar", 2) == 0) {
                        enq.set_varcode(cur->code);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s not found on this query result", key);
            }
            break;
        case 5:
            switch (key[0]) {
                case 'i':
                    if (memcmp(key + 1, "dent", 4) == 0) {
                        enq.set_ident(cur->station.ident);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'l':
                    if (memcmp(key + 1, "evel", 4) == 0) {
                        enq.set_level(get_levtr().level);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'c':
                    if (memcmp(key + 1, "ount", 4) == 0) {
                        enq.set_int(cur->count);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s not found on this query result", key);
            }
            break;
        case 6:
            switch (key[0]) {
                case 'r':
                    if (memcmp(key + 1, "eport", 5) == 0) {
                        enq.set_string(cur->station.report);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_id", 5) == 0) {
                        enq.set_dballe_int(cur->station.id);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "obile", 5) == 0) {
                        enq.set_bool(!cur->station.ident.is_missing());
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'c':
                    if (memcmp(key + 1, "oords", 5) == 0) {
                        enq.set_coords(cur->station.coords);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "aym", 3) == 0) {
                        switch (key[4]) {
                            case 'a':
                                if (key[5] == 'x') {
                                    if (cur->dtrange.is_missing()) return; else enq.set_int(cur->dtrange.max.day);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            case 'i':
                                if (key[5] == 'n') {
                                    if (cur->dtrange.is_missing()) return; else enq.set_int(cur->dtrange.min.day);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ecm", 3) == 0) {
                        switch (key[4]) {
                            case 'a':
                                if (key[5] == 'x') {
                                    if (cur->dtrange.is_missing()) return; else enq.set_int(cur->dtrange.max.second);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            case 'i':
                                if (key[5] == 'n') {
                                    if (cur->dtrange.is_missing()) return; else enq.set_int(cur->dtrange.min.second);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 't':
                    if (memcmp(key + 1, "range", 5) == 0) {
                        enq.set_trange(get_levtr().trange);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s not found on this query result", key);
            }
            break;
        case 7:
            switch (key[0]) {
                case 's':
                    if (memcmp(key + 1, "tation", 6) == 0) {
                        enq.set_station(cur->station);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'y':
                    if (memcmp(key + 1, "earm", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    if (cur->dtrange.is_missing()) return; else enq.set_int(cur->dtrange.max.year);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    if (cur->dtrange.is_missing()) return; else enq.set_int(cur->dtrange.min.year);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "ourm", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    if (cur->dtrange.is_missing()) return; else enq.set_int(cur->dtrange.max.hour);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    if (cur->dtrange.is_missing()) return; else enq.set_int(cur->dtrange.min.hour);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "inum", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    if (cur->dtrange.is_missing()) return; else enq.set_int(cur->dtrange.max.minute);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    if (cur->dtrange.is_missing()) return; else enq.set_int(cur->dtrange.min.minute);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s not found on this query result", key);
            }
            break;
        case 8:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riority", 7) == 0) {
                        enq.set_int(get_priority());
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'r':
                    if (memcmp(key + 1, "ep_memo", 7) == 0) {
                        enq.set_string(cur->station.report);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onthm", 5) == 0) {
                        switch (key[6]) {
                            case 'a':
                                if (key[7] == 'x') {
                                    if (cur->dtrange.is_missing()) return; else enq.set_int(cur->dtrange.max.month);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            case 'i':
                                if (key[7] == 'n') {
                                    if (cur->dtrange.is_missing()) return; else enq.set_int(cur->dtrange.min.month);
                                } else {
                                    wreport::error_notfound::throwf("key %s not found on this query result", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s not found on this query result", key);
            }
            break;
        case 10:
            switch (key[0]) {
                case 'l':
                    if (memcmp(key + 1, "eveltype", 8) == 0) {
                        switch (key[9]) {
                            case '1':
                                enq.set_dballe_int(get_levtr().level.ltype1);
                                break;
                            case '2':
                                enq.set_dballe_int(get_levtr().level.ltype2);
                                break;
                            default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'p':
                    if (memcmp(key + 1, "indicator", 9) == 0) {
                        enq.set_dballe_int(get_levtr().trange.pind);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                case 'c':
                    if (memcmp(key + 1, "ontext_id", 9) == 0) {
                        enq.set_int(cur->count);
                    } else {
                        wreport::error_notfound::throwf("key %s not found on this query result", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s not found on this query result", key);
            }
            break;
        case 11:
            if (memcmp(key + 0, "datetimem", 9) == 0) {
                switch (key[9]) {
                    case 'a':
                        if (key[10] == 'x') {
                            if (cur->dtrange.is_missing()) return; else enq.set_datetime(cur->dtrange.max);
                        } else {
                            wreport::error_notfound::throwf("key %s not found on this query result", key);
                        }
                        break;
                    case 'i':
                        if (key[10] == 'n') {
                            if (cur->dtrange.is_missing()) return; else enq.set_datetime(cur->dtrange.min);
                        } else {
                            wreport::error_notfound::throwf("key %s not found on this query result", key);
                        }
                        break;
                    default: wreport::error_notfound::throwf("key %s not found on this query result", key);
                }
            } else {
                wreport::error_notfound::throwf("key %s not found on this query result", key);
            }
            break;
        default: wreport::error_notfound::throwf("key %s not found on this query result", key);
    }
}

}
}
}
}
