Darcs
=====

[Darcs](http://darcs.net) is a distributed version control system
written in Haskell.

Getting started
===============

Compiling
---------

The easiest way to build darcs is by using cabal-install version 3.2 or
later. A plain

```
> cabal build
```

or

```
> cabal install
```

should work out of the box with any ghc version from 8.0 up to 8.10.

Run the test suite
------------------

It is currently not possible to run the full test suite from the source
distribution that you get from hackage. Instead you need to be in a clone of
the darcs source code repository. This is because the tests depend on an old
version of shelly that was patched to work with newer ghc versions and
bundled with Darcs. It is not part of the source distribution to avoid
'cabal install' also trying to install our patched version of shelly.

```
> cabal build --enable-tests
> cabal test --test-show-details=direct
```

Using
-----

To clone a repository via HTTP and send patches by mail:

```
> darcs clone --lazy http://darcs.net
> # edit files...
> darcs add my_new_file
> darcs record -m "my changes"
> darcs send
```

To clone via SSH and push patches:

```
> darcs clone user@hub.darcs.net:user/repo
> # edit files...
> darcs add my_new_file
> darcs record -m "my changes"
> darcs push
```

To create a project and start working:

```
> darcs init my_project
> cd my_project
> # create and edit files...
> darcs add my_new_file
> darcs record -m "initial version"
```

Pull new patches from upstream:

```
> darcs pull
```

Concise and up-to-date documentation is available from darcs itself:

```
> darcs help # list all commands
> darcs help command # help for specific command
> darcs command --help # dito
```

Reporting bugs
==============

Please send bug reports to <bugs@darcs.net>. This will automatically add
your report to the bug tracker. If you are unsure or just have a question or
a comment, you can subscribe to darcs-users@darcs.net and post your question
or comments there. See http://darcs.net/MailingLists for details.


Hacking
=======

Please consult <http://darcs.net/Development/GettingStarted> for information
about how to contribute to Darcs. Or send an email to darcs-devel@darcs.net
or to darcs-users@darcs.net.

The wiki can be downloaded with the command:

```
> darcs clone --lazy http://darcs.net/darcs-wiki
```
