/* SPDX-License-Identifier: GPL-2.0-only */

#include <stdint.h>
#include <soc/modphy_table.h>

struct modphy_entry reva0_modphy_table[] = { /* SOC stepping A0/A1 */
	{ 0xa6, 0x0000804c, 0x0000ffff, 0xebeb0000, 0x00, 0x01 },
	{ 0xa6, 0x0000806c, 0x0000ffff, 0xebeb0000, 0x00, 0x01 },
	{ 0xa6, 0x000080ec, 0x0000ffff, 0xebeb0000, 0x00, 0x01 },
	{ 0xa3, 0x00002208, 0xfffffff3, 0x00000008, 0x00, 0x01 },
	{ 0xa3, 0x00002408, 0xfffffff3, 0x00000008, 0x00, 0x01 },
	{ 0xa3, 0x00002238, 0xfffffff8, 0x00000006, 0x00, 0x01 },
	{ 0xa3, 0x00002438, 0xfffffff8, 0x00000006, 0x00, 0x01 },
	{ 0xa3, 0x0000800c, 0xffffff00, 0x0000001e, 0x00, 0x01 },
	{ 0xa3, 0x0000802c, 0xffffff00, 0x0000001e, 0x00, 0x01 },
	{ 0xa3, 0x0000808c, 0xffffff00, 0x0000001e, 0x00, 0x01 },
	{ 0xa3, 0x0000804c, 0x0000ffff, 0x22220000, 0x00, 0x01 },
	{ 0xa3, 0x0000806c, 0x0000ffff, 0x22220000, 0x00, 0x01 },
	{ 0xa3, 0x000080ec, 0x0000ffff, 0x22220000, 0x00, 0x01 },
	{ 0xa3, 0x0000810c, 0x3fffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x000080e0, 0xffff00ff, 0x00005000, 0x00, 0x01 },
	{ 0xa6, 0x00000254, 0xffff00ff, 0x00008000, 0x00, 0x01 },
	{ 0xa6, 0x00000454, 0xffff00ff, 0x00008000, 0x00, 0x01 },
	{ 0xa6, 0x00000654, 0xffff00ff, 0x00008000, 0x00, 0x01 },
	{ 0xa6, 0x00000854, 0xffff00ff, 0x00008000, 0x00, 0x01 },
	{ 0xa6, 0x00002254, 0xffff00ff, 0x00008000, 0x00, 0x01 },
	{ 0xa6, 0x000080c0, 0xffffdfff, 0x00002000, 0x00, 0x01 },
	{ 0xa6, 0x00000288, 0xffff00ff, 0x00009800, 0x00, 0x01 },
	{ 0xa6, 0x00000488, 0xffff00ff, 0x00009800, 0x00, 0x01 },
	{ 0xa6, 0x00000688, 0xffff00ff, 0x00009800, 0x00, 0x01 },
	{ 0xa6, 0x00000888, 0xffff00ff, 0x00009800, 0x00, 0x01 },
	{ 0xa6, 0x0000028c, 0xcfffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000048c, 0xcfffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000068c, 0xcfffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000088c, 0xcfffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000028c, 0xf3ffffff, 0x0c000000, 0x00, 0x01 },
	{ 0xa6, 0x0000048c, 0xf3ffffff, 0x0c000000, 0x00, 0x01 },
	{ 0xa6, 0x0000068c, 0xf3ffffff, 0x0c000000, 0x00, 0x01 },
	{ 0xa6, 0x0000088c, 0xf3ffffff, 0x0c000000, 0x00, 0x01 },
	{ 0xa6, 0x00000288, 0xff00ffff, 0x00800000, 0x00, 0x01 },
	{ 0xa6, 0x00000488, 0xff00ffff, 0x00800000, 0x00, 0x01 },
	{ 0xa6, 0x00000688, 0xff00ffff, 0x00800000, 0x00, 0x01 },
	{ 0xa6, 0x00000888, 0xff00ffff, 0x00800000, 0x00, 0x01 },
	{ 0xa6, 0x0000028c, 0xf3ffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000048c, 0xf3ffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000068c, 0xf3ffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000088c, 0xf3ffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000028c, 0xcfffffff, 0x30000000, 0x00, 0x01 },
	{ 0xa6, 0x0000048c, 0xcfffffff, 0x30000000, 0x00, 0x01 },
	{ 0xa6, 0x0000068c, 0xcfffffff, 0x30000000, 0x00, 0x01 },
	{ 0xa6, 0x0000088c, 0xcfffffff, 0x30000000, 0x00, 0x01 },
	{ 0xa6, 0x00000294, 0x7fffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000294, 0x7fffffff, 0x80000000, 0x00, 0x01 },
	{ 0xa6, 0x00000494, 0x7fffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000494, 0x7fffffff, 0x80000000, 0x00, 0x01 },
	{ 0xa6, 0x00000694, 0x7fffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000694, 0x7fffffff, 0x80000000, 0x00, 0x01 },
	{ 0xa6, 0x00000894, 0x7fffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000894, 0x7fffffff, 0x80000000, 0x00, 0x01 },
	{ 0xa6, 0x0000028c, 0xcfffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000048c, 0xcfffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000068c, 0xcfffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000088c, 0xcfffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000028c, 0xf3ffffff, 0x0c000000, 0x00, 0x01 },
	{ 0xa6, 0x0000048c, 0xf3ffffff, 0x0c000000, 0x00, 0x01 },
	{ 0xa6, 0x0000068c, 0xf3ffffff, 0x0c000000, 0x00, 0x01 },
	{ 0xa6, 0x0000088c, 0xf3ffffff, 0x0c000000, 0x00, 0x01 },
	{ 0xa6, 0x00000288, 0x00ffffff, 0x55000000, 0x00, 0x01 },
	{ 0xa6, 0x00000488, 0x00ffffff, 0x55000000, 0x00, 0x01 },
	{ 0xa6, 0x00000688, 0x00ffffff, 0x55000000, 0x00, 0x01 },
	{ 0xa6, 0x00000888, 0x00ffffff, 0x55000000, 0x00, 0x01 },
	{ 0xa6, 0x0000028c, 0xffffff00, 0x00000046, 0x00, 0x01 },
	{ 0xa6, 0x0000048c, 0xffffff00, 0x00000046, 0x00, 0x01 },
	{ 0xa6, 0x0000068c, 0xffffff00, 0x00000046, 0x00, 0x01 },
	{ 0xa6, 0x0000088c, 0xffffff00, 0x00000046, 0x00, 0x01 },
	{ 0xa6, 0x0000028c, 0xffff00ff, 0x00002000, 0x00, 0x01 },
	{ 0xa6, 0x0000048c, 0xffff00ff, 0x00002000, 0x00, 0x01 },
	{ 0xa6, 0x0000068c, 0xffff00ff, 0x00002000, 0x00, 0x01 },
	{ 0xa6, 0x0000088c, 0xffff00ff, 0x00002000, 0x00, 0x01 },
	{ 0xa6, 0x0000028c, 0xff00ffff, 0x00780000, 0x00, 0x01 },
	{ 0xa6, 0x0000048c, 0xff00ffff, 0x00780000, 0x00, 0x01 },
	{ 0xa6, 0x0000068c, 0xff00ffff, 0x00780000, 0x00, 0x01 },
	{ 0xa6, 0x0000088c, 0xff00ffff, 0x00780000, 0x00, 0x01 },
	{ 0xa6, 0x00000290, 0x00ffffff, 0xc0000000, 0x00, 0x01 },
	{ 0xa6, 0x00000490, 0x00ffffff, 0xc0000000, 0x00, 0x01 },
	{ 0xa6, 0x00000690, 0x00ffffff, 0xc0000000, 0x00, 0x01 },
	{ 0xa6, 0x00000890, 0x00ffffff, 0xc0000000, 0x00, 0x01 },
	{ 0xa6, 0x00000294, 0x7fffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000294, 0x7fffffff, 0x80000000, 0x00, 0x01 },
	{ 0xa6, 0x00000494, 0x7fffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000494, 0x7fffffff, 0x80000000, 0x00, 0x01 },
	{ 0xa6, 0x00000694, 0x7fffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000694, 0x7fffffff, 0x80000000, 0x00, 0x01 },
	{ 0xa6, 0x00000894, 0x7fffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000894, 0x7fffffff, 0x80000000, 0x00, 0x01 },
	{ 0xa6, 0x000080a4, 0xffff0000, 0x0000f487, 0x00, 0x01 },
	{ 0xa6, 0x00000314, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa6, 0x00000514, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa6, 0x00000714, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa6, 0x00000914, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa6, 0x00002314, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa3, 0x00002314, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa3, 0x00002514, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa6, 0x00008094, 0xf8ffffff, 0x05000000, 0x00, 0x01 },
	{ 0xa6, 0x00008034, 0xf8ffffff, 0x05000000, 0x00, 0x01 },
	{ 0xa6, 0x00008014, 0xf8ffffff, 0x05000000, 0x00, 0x01 },
	{ 0xa3, 0x00008094, 0xf8ffffff, 0x05000000, 0x00, 0x01 },
	{ 0xa3, 0x00008034, 0xf8ffffff, 0x05000000, 0x00, 0x01 },
	{ 0xa3, 0x00008014, 0xf8ffffff, 0x05000000, 0x00, 0x01 },
	{ 0xa6, 0x000080e8, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa6, 0x00008068, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa6, 0x00008048, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa3, 0x000080e8, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa3, 0x00008068, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa3, 0x00008048, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa6, 0x000080e8, 0xffe0ffff, 0x00100000, 0x00, 0x01 },
	{ 0xa6, 0x00008068, 0xffe0ffff, 0x00100000, 0x00, 0x01 },
	{ 0xa6, 0x00008048, 0xffe0ffff, 0x00100000, 0x00, 0x01 },
	{ 0xa3, 0x000080e8, 0xffe0ffff, 0x00100000, 0x00, 0x01 },
	{ 0xa3, 0x00008068, 0xffe0ffff, 0x00100000, 0x00, 0x01 },
	{ 0xa3, 0x00008048, 0xffe0ffff, 0x00100000, 0x00, 0x01 },
	{ 0xa6, 0x000080e8, 0xffffff0f, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00008068, 0xffffff0f, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00008048, 0xffffff0f, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x000080e8, 0xffffff0f, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x00008068, 0xffffff0f, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x00008048, 0xffffff0f, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000801c, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa6, 0x0000803c, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa6, 0x0000809c, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa3, 0x0000801c, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa3, 0x0000803c, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa3, 0x0000809c, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa6, 0x00008040, 0xefffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00008060, 0xefffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x000080e0, 0xefffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x00008040, 0xefffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x00008060, 0xefffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x000080e0, 0xefffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x00008100, 0xfffffffc, 0x00000003, 0x00, 0x01 },
	{ 0xa6, 0x0000804c, 0x00ffffff, 0x43000000, 0x00, 0x01 },
	{ 0xa6, 0x0000806c, 0x00ffffff, 0x43000000, 0x00, 0x01 },
	{ 0xa6, 0x000080ec, 0x00ffffff, 0x43000000, 0x00, 0x01 },
	{ 0xa3, 0x0000804c, 0x00ffffff, 0x43000000, 0x00, 0x01 },
	{ 0xa3, 0x0000806c, 0x00ffffff, 0x43000000, 0x00, 0x01 },
	{ 0xa3, 0x000080ec, 0x00ffffff, 0x43000000, 0x00, 0x01 },
	{ 0xa6, 0x0000804c, 0xff00ffff, 0x00220000, 0x00, 0x01 },
	{ 0xa6, 0x0000806c, 0xff00ffff, 0x00220000, 0x00, 0x01 },
	{ 0xa6, 0x000080ec, 0xff00ffff, 0x00220000, 0x00, 0x01 },
	{ 0xa3, 0x0000804c, 0xff00ffff, 0x00220000, 0x00, 0x01 },
	{ 0xa3, 0x0000806c, 0xff00ffff, 0x00220000, 0x00, 0x01 },
	{ 0xa3, 0x000080ec, 0xff00ffff, 0x00220000, 0x00, 0x01 },
	{ 0xa3, 0x00002300, 0xfffffff0, 0x00000009, 0x00, 0x01 },
	{ 0xa3, 0x00002500, 0xfffffff0, 0x00000009, 0x00, 0x01 },
	{ 0xa6, 0x00000314, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa6, 0x00000514, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa6, 0x00000714, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa6, 0x00000914, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa6, 0x00002314, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa3, 0x00002314, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa3, 0x00002514, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa6, 0x000080c0, 0xfffff3ff, 0x00000c00, 0x00, 0x01 },
	{ 0xa3, 0x000080c0, 0xfffff3ff, 0x00000c00, 0x00, 0x01 },
	{ 0xa6, 0x00000254, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa6, 0x00000454, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa6, 0x00000654, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa6, 0x00000854, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa6, 0x00002254, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa3, 0x00000254, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa3, 0x00000454, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa3, 0x00000654, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa3, 0x00000854, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa3, 0x00002254, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa3, 0x00002454, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa6, 0x00000254, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa6, 0x00000454, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa6, 0x00000654, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa6, 0x00000854, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa6, 0x00002254, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa3, 0x00000254, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa3, 0x00000454, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa3, 0x00000654, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa3, 0x00000854, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa3, 0x00002254, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa3, 0x00002454, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa6, 0x000080c0, 0xffffdfff, 0x00002000, 0x00, 0x01 },
	{ 0xa3, 0x000080c0, 0xffffdfff, 0x00002000, 0x00, 0x01 },
	{ 0xa6, 0x000080c0, 0xfffff3ff, 0x00000400, 0x00, 0x01 },
	{ 0xa3, 0x000080c0, 0xfffff3ff, 0x00000400, 0x00, 0x01 },
	{ 0xa6, 0x000080c0, 0xffffdfff, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x000080c0, 0xffffdfff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000244, 0xfffff7ff, 0x00000800, 0x00, 0x01 },
	{ 0xa6, 0x00000444, 0xfffff7ff, 0x00000800, 0x00, 0x01 },
	{ 0xa6, 0x00000644, 0xfffff7ff, 0x00000800, 0x00, 0x01 },
	{ 0xa6, 0x00000844, 0xfffff7ff, 0x00000800, 0x00, 0x01 },
	{ 0xa6, 0x00002244, 0xfffff7ff, 0x00000800, 0x00, 0x01 },
	{ 0xa6, 0x00002244, 0xfffff7ff, 0x00000800, 0x00, 0x01 },
	{ 0xa6, 0x00002444, 0xfffff7ff, 0x00000800, 0x00, 0x01 },
	{ 0xa6, 0x00000244, 0xfffff7ff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000444, 0xfffff7ff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000644, 0xfffff7ff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000844, 0xfffff7ff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00002244, 0xfffff7ff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00002244, 0xfffff7ff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00002444, 0xfffff7ff, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x00002318, 0x0000ffff, 0x45140000, 0x00, 0x01 },
	{ 0xa3, 0x00002300, 0x80ffffff, 0x02000000, 0x00, 0x01 },
	{ 0xa3, 0x00002304, 0xff80ffff, 0x00020000, 0x00, 0x01 },
	{ 0xa3, 0x0000231c, 0xffffff00, 0x0000000d, 0x00, 0x01 },
	{ 0xa3, 0x00002518, 0x0000ffff, 0x47140000, 0x00, 0x01 },
	{ 0xa3, 0x00002500, 0x80ffffff, 0x04000000, 0x00, 0x01 },
	{ 0xa3, 0x00002504, 0xff80ffff, 0x00040000, 0x00, 0x01 },
	{ 0xa3, 0x0000251c, 0xffffff00, 0x0000000d, 0x00, 0x01 },
	/* Workaround for #4376904, #4682850, #4753319 */
	{ 0x43, 0x00007f04, 0xffff0000, 0x00004700, 0x06, 0x07 },
	{ 0x43, 0x00004100, 0xfff00000, 0x0004fa01, 0x06, 0x07 },
	{ 0x43, 0x00004200, 0xfff00000, 0x0004ea01, 0x06, 0x07 },
	{ 0x43, 0x00004300, 0xfff00000, 0x00049209, 0x06, 0x07 },
	{ 0x43, 0x00004400, 0xfff00000, 0x00049209, 0x06, 0x07 },
	{ 0x43, 0x00004122, 0x00000000, 0x00004011, 0x06, 0x07 },
	{ 0x43, 0x00004222, 0x00000000, 0x06004015, 0x06, 0x07 },
	{ 0x43, 0x00004500, 0xffff7fff, 0x00000000, 0x06, 0x07 },
	{ 0x43, 0x00004600, 0xffff7fff, 0x00000000, 0x06, 0x07 },
	{ 0x43, 0x00004700, 0xffff7fff, 0x00000000, 0x06, 0x07 },
	{ 0x43, 0x00004800, 0xffff7fff, 0x00000000, 0x06, 0x07 },
	MODPHY_ENTRY_END
};

struct modphy_entry revb0_modphy_table[] = { /* SOC stepping B0 or later */
	{ 0xa6, 0x00008014, 0xf8ffffff, 0x05000000, 0x00, 0x01 },
	{ 0xa6, 0x00008048, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa6, 0x00008048, 0xffe0ffff, 0x00100000, 0x00, 0x01 },
	{ 0xa6, 0x00008048, 0xffffff0f, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000801c, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa6, 0x00008040, 0xefffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000804c, 0x0000ffff, 0xebeb0000, 0x00, 0x01 },
	{ 0xa6, 0x0000806c, 0x0000ffff, 0xebeb0000, 0x00, 0x01 },
	{ 0xa6, 0x000080ec, 0x0000ffff, 0xebeb0000, 0x00, 0x01 },
	{ 0xa3, 0x00002208, 0xfffffff3, 0x00000008, 0x00, 0x01 },
	{ 0xa3, 0x00002408, 0xfffffff3, 0x00000008, 0x00, 0x01 },
	{ 0xa3, 0x00002238, 0xfffffff8, 0x00000006, 0x00, 0x01 },
	{ 0xa3, 0x00002438, 0xfffffff8, 0x00000006, 0x00, 0x01 },
	{ 0xa3, 0x0000800c, 0xffffff00, 0x0000001e, 0x00, 0x01 },
	{ 0xa3, 0x0000802c, 0xffffff00, 0x0000001e, 0x00, 0x01 },
	{ 0xa3, 0x0000808c, 0xffffff00, 0x0000001e, 0x00, 0x01 },
	{ 0xa3, 0x0000804c, 0x0000ffff, 0x22220000, 0x00, 0x01 },
	{ 0xa3, 0x0000806c, 0x0000ffff, 0x22220000, 0x00, 0x01 },
	{ 0xa3, 0x000080ec, 0x0000ffff, 0x22220000, 0x00, 0x01 },
	{ 0xa3, 0x0000810c, 0x3fffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x000080e0, 0xffff00ff, 0x00005000, 0x00, 0x01 },
	{ 0xa6, 0x00000254, 0xffff00ff, 0x00008000, 0x00, 0x01 },
	{ 0xa6, 0x00000454, 0xffff00ff, 0x00008000, 0x00, 0x01 },
	{ 0xa6, 0x00000654, 0xffff00ff, 0x00008000, 0x00, 0x01 },
	{ 0xa6, 0x00000854, 0xffff00ff, 0x00008000, 0x00, 0x01 },
	{ 0xa6, 0x00002254, 0xffff00ff, 0x00008000, 0x00, 0x01 },
	{ 0xa6, 0x000080c0, 0xffffdfff, 0x00002000, 0x00, 0x01 },
	{ 0xa6, 0x00000288, 0xffff00ff, 0x00009800, 0x00, 0x01 },
	{ 0xa6, 0x00000488, 0xffff00ff, 0x00009800, 0x00, 0x01 },
	{ 0xa6, 0x00000688, 0xffff00ff, 0x00009800, 0x00, 0x01 },
	{ 0xa6, 0x00000888, 0xffff00ff, 0x00009800, 0x00, 0x01 },
	{ 0xa6, 0x0000028c, 0xcfffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000048c, 0xcfffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000068c, 0xcfffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000088c, 0xcfffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000028c, 0xf3ffffff, 0x0c000000, 0x00, 0x01 },
	{ 0xa6, 0x0000048c, 0xf3ffffff, 0x0c000000, 0x00, 0x01 },
	{ 0xa6, 0x0000068c, 0xf3ffffff, 0x0c000000, 0x00, 0x01 },
	{ 0xa6, 0x0000088c, 0xf3ffffff, 0x0c000000, 0x00, 0x01 },
	{ 0xa6, 0x00000288, 0xff00ffff, 0x00800000, 0x00, 0x01 },
	{ 0xa6, 0x00000488, 0xff00ffff, 0x00800000, 0x00, 0x01 },
	{ 0xa6, 0x00000688, 0xff00ffff, 0x00800000, 0x00, 0x01 },
	{ 0xa6, 0x00000888, 0xff00ffff, 0x00800000, 0x00, 0x01 },
	{ 0xa6, 0x0000028c, 0xf3ffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000048c, 0xf3ffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000068c, 0xf3ffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000088c, 0xf3ffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000028c, 0xcfffffff, 0x30000000, 0x00, 0x01 },
	{ 0xa6, 0x0000048c, 0xcfffffff, 0x30000000, 0x00, 0x01 },
	{ 0xa6, 0x0000068c, 0xcfffffff, 0x30000000, 0x00, 0x01 },
	{ 0xa6, 0x0000088c, 0xcfffffff, 0x30000000, 0x00, 0x01 },
	{ 0xa6, 0x00000294, 0x7fffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000294, 0x7fffffff, 0x80000000, 0x00, 0x01 },
	{ 0xa6, 0x00000494, 0x7fffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000494, 0x7fffffff, 0x80000000, 0x00, 0x01 },
	{ 0xa6, 0x00000694, 0x7fffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000694, 0x7fffffff, 0x80000000, 0x00, 0x01 },
	{ 0xa6, 0x00000894, 0x7fffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000894, 0x7fffffff, 0x80000000, 0x00, 0x01 },
	{ 0xa6, 0x0000028c, 0xcfffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000048c, 0xcfffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000068c, 0xcfffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000088c, 0xcfffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000028c, 0xf3ffffff, 0x0c000000, 0x00, 0x01 },
	{ 0xa6, 0x0000048c, 0xf3ffffff, 0x0c000000, 0x00, 0x01 },
	{ 0xa6, 0x0000068c, 0xf3ffffff, 0x0c000000, 0x00, 0x01 },
	{ 0xa6, 0x0000088c, 0xf3ffffff, 0x0c000000, 0x00, 0x01 },
	{ 0xa6, 0x00000288, 0x00ffffff, 0x55000000, 0x00, 0x01 },
	{ 0xa6, 0x00000488, 0x00ffffff, 0x55000000, 0x00, 0x01 },
	{ 0xa6, 0x00000688, 0x00ffffff, 0x55000000, 0x00, 0x01 },
	{ 0xa6, 0x00000888, 0x00ffffff, 0x55000000, 0x00, 0x01 },
	{ 0xa6, 0x0000028c, 0xffffff00, 0x00000046, 0x00, 0x01 },
	{ 0xa6, 0x0000048c, 0xffffff00, 0x00000046, 0x00, 0x01 },
	{ 0xa6, 0x0000068c, 0xffffff00, 0x00000046, 0x00, 0x01 },
	{ 0xa6, 0x0000088c, 0xffffff00, 0x00000046, 0x00, 0x01 },
	{ 0xa6, 0x0000028c, 0xffff00ff, 0x00002000, 0x00, 0x01 },
	{ 0xa6, 0x0000048c, 0xffff00ff, 0x00002000, 0x00, 0x01 },
	{ 0xa6, 0x0000068c, 0xffff00ff, 0x00002000, 0x00, 0x01 },
	{ 0xa6, 0x0000088c, 0xffff00ff, 0x00002000, 0x00, 0x01 },
	{ 0xa6, 0x0000028c, 0xff00ffff, 0x00780000, 0x00, 0x01 },
	{ 0xa6, 0x0000048c, 0xff00ffff, 0x00780000, 0x00, 0x01 },
	{ 0xa6, 0x0000068c, 0xff00ffff, 0x00780000, 0x00, 0x01 },
	{ 0xa6, 0x0000088c, 0xff00ffff, 0x00780000, 0x00, 0x01 },
	{ 0xa6, 0x00000290, 0x00ffffff, 0xc0000000, 0x00, 0x01 },
	{ 0xa6, 0x00000490, 0x00ffffff, 0xc0000000, 0x00, 0x01 },
	{ 0xa6, 0x00000690, 0x00ffffff, 0xc0000000, 0x00, 0x01 },
	{ 0xa6, 0x00000890, 0x00ffffff, 0xc0000000, 0x00, 0x01 },
	{ 0xa6, 0x00000294, 0x7fffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000294, 0x7fffffff, 0x80000000, 0x00, 0x01 },
	{ 0xa6, 0x00000494, 0x7fffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000494, 0x7fffffff, 0x80000000, 0x00, 0x01 },
	{ 0xa6, 0x00000694, 0x7fffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000694, 0x7fffffff, 0x80000000, 0x00, 0x01 },
	{ 0xa6, 0x00000894, 0x7fffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000894, 0x7fffffff, 0x80000000, 0x00, 0x01 },
	{ 0xa6, 0x000080a4, 0xffff0000, 0x0000f487, 0x00, 0x01 },
	{ 0xa6, 0x00000314, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa6, 0x00000514, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa6, 0x00000714, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa6, 0x00000914, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa6, 0x00002314, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa3, 0x00002314, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa3, 0x00002514, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa6, 0x00008094, 0xf8ffffff, 0x05000000, 0x00, 0x01 },
	{ 0xa6, 0x00008034, 0xf8ffffff, 0x05000000, 0x00, 0x01 },
	{ 0xa3, 0x00008094, 0xf8ffffff, 0x05000000, 0x00, 0x01 },
	{ 0xa3, 0x00008034, 0xf8ffffff, 0x05000000, 0x00, 0x01 },
	{ 0xa3, 0x00008014, 0xf8ffffff, 0x05000000, 0x00, 0x01 },
	{ 0xa6, 0x000080e8, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa6, 0x00008068, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa3, 0x000080e8, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa3, 0x00008068, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa3, 0x00008048, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa6, 0x000080e8, 0xffe0ffff, 0x00100000, 0x00, 0x01 },
	{ 0xa6, 0x00008068, 0xffe0ffff, 0x00100000, 0x00, 0x01 },
	{ 0xa3, 0x000080e8, 0xffe0ffff, 0x00100000, 0x00, 0x01 },
	{ 0xa3, 0x00008068, 0xffe0ffff, 0x00100000, 0x00, 0x01 },
	{ 0xa3, 0x00008048, 0xffe0ffff, 0x00100000, 0x00, 0x01 },
	{ 0xa6, 0x000080e8, 0xffffff0f, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00008068, 0xffffff0f, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x000080e8, 0xffffff0f, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x00008068, 0xffffff0f, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x00008048, 0xffffff0f, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x0000803c, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa6, 0x0000809c, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa3, 0x0000801c, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa3, 0x0000803c, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa3, 0x0000809c, 0xff3fffff, 0x00c00000, 0x00, 0x01 },
	{ 0xa6, 0x00008060, 0xefffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x000080e0, 0xefffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x00008040, 0xefffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x00008060, 0xefffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x000080e0, 0xefffffff, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x00008100, 0xfffffffc, 0x00000003, 0x00, 0x01 },
	{ 0xa6, 0x0000804c, 0x00ffffff, 0x43000000, 0x00, 0x01 },
	{ 0xa6, 0x0000806c, 0x00ffffff, 0x43000000, 0x00, 0x01 },
	{ 0xa6, 0x000080ec, 0x00ffffff, 0x43000000, 0x00, 0x01 },
	{ 0xa3, 0x0000804c, 0x00ffffff, 0x43000000, 0x00, 0x01 },
	{ 0xa3, 0x0000806c, 0x00ffffff, 0x43000000, 0x00, 0x01 },
	{ 0xa3, 0x000080ec, 0x00ffffff, 0x43000000, 0x00, 0x01 },
	{ 0xa6, 0x0000804c, 0xff00ffff, 0x00220000, 0x00, 0x01 },
	{ 0xa6, 0x0000806c, 0xff00ffff, 0x00220000, 0x00, 0x01 },
	{ 0xa6, 0x000080ec, 0xff00ffff, 0x00220000, 0x00, 0x01 },
	{ 0xa3, 0x0000804c, 0xff00ffff, 0x00220000, 0x00, 0x01 },
	{ 0xa3, 0x0000806c, 0xff00ffff, 0x00220000, 0x00, 0x01 },
	{ 0xa3, 0x000080ec, 0xff00ffff, 0x00220000, 0x00, 0x01 },
	{ 0xa3, 0x00002300, 0xfffffff0, 0x00000009, 0x00, 0x01 },
	{ 0xa3, 0x00002500, 0xfffffff0, 0x00000009, 0x00, 0x01 },
	{ 0xa6, 0x00000314, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa6, 0x00000514, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa6, 0x00000714, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa6, 0x00000914, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa6, 0x00002314, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa3, 0x00002314, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa3, 0x00002514, 0xfffffff8, 0x00000007, 0x00, 0x01 },
	{ 0xa6, 0x00000254, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa6, 0x00000454, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa6, 0x00000654, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa6, 0x00000854, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa6, 0x00002254, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa3, 0x00000254, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa3, 0x00000454, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa3, 0x00000654, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa3, 0x00000854, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa3, 0x00002254, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa3, 0x00002454, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa6, 0x00000254, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa6, 0x00000454, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa6, 0x00000654, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa6, 0x00000854, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa6, 0x00002254, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa3, 0x00000254, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa3, 0x00000454, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa3, 0x00000654, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa3, 0x00000854, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa3, 0x00002254, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa3, 0x00002454, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa6, 0x000080c0, 0xffffdfff, 0x00002000, 0x00, 0x01 },
	{ 0xa3, 0x000080c0, 0xffffdfff, 0x00002000, 0x00, 0x01 },
	{ 0xa6, 0x000080c0, 0xffffdfff, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x000080c0, 0xffffdfff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000244, 0xfffff7ff, 0x00000800, 0x00, 0x01 },
	{ 0xa6, 0x00000444, 0xfffff7ff, 0x00000800, 0x00, 0x01 },
	{ 0xa6, 0x00000644, 0xfffff7ff, 0x00000800, 0x00, 0x01 },
	{ 0xa6, 0x00000844, 0xfffff7ff, 0x00000800, 0x00, 0x01 },
	{ 0xa6, 0x00002244, 0xfffff7ff, 0x00000800, 0x00, 0x01 },
	{ 0xa6, 0x00002244, 0xfffff7ff, 0x00000800, 0x00, 0x01 },
	{ 0xa6, 0x00002444, 0xfffff7ff, 0x00000800, 0x00, 0x01 },
	{ 0xa6, 0x00000244, 0xfffff7ff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000444, 0xfffff7ff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000644, 0xfffff7ff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000844, 0xfffff7ff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00002244, 0xfffff7ff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00002244, 0xfffff7ff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00002444, 0xfffff7ff, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x00002318, 0x0000ffff, 0x45140000, 0x00, 0x01 },
	{ 0xa3, 0x00002300, 0x80ffffff, 0x02000000, 0x00, 0x01 },
	{ 0xa3, 0x00002304, 0xff80ffff, 0x00020000, 0x00, 0x01 },
	{ 0xa3, 0x0000231c, 0xffffff00, 0x0000000d, 0x00, 0x01 },
	{ 0xa3, 0x00002518, 0x0000ffff, 0x47140000, 0x00, 0x01 },
	{ 0xa3, 0x00002500, 0x80ffffff, 0x04000000, 0x00, 0x01 },
	{ 0xa3, 0x00002504, 0xff80ffff, 0x00040000, 0x00, 0x01 },
	{ 0xa3, 0x0000251c, 0xffffff00, 0x0000000d, 0x00, 0x01 },
	/* Workaround for #4376904, #4682850, #4753319 */
	{ 0x43, 0x00007f04, 0xffff0000, 0x00004700, 0x06, 0x07 },
	{ 0x43, 0x00004100, 0xfff00000, 0x00049209, 0x06, 0x07 },
	{ 0x43, 0x00004200, 0xfff00000, 0x00049209, 0x06, 0x07 },
	{ 0x43, 0x00004300, 0xfff00000, 0x00049209, 0x06, 0x07 },
	{ 0x43, 0x00004400, 0xfff00000, 0x00049209, 0x06, 0x07 },
	{ 0x43, 0x00004500, 0xffff7fff, 0x00000000, 0x06, 0x07 },
	{ 0x43, 0x00004600, 0xffff7fff, 0x00000000, 0x06, 0x07 },
	{ 0x43, 0x00004700, 0xffff7fff, 0x00000000, 0x06, 0x07 },
	{ 0x43, 0x00004800, 0xffff7fff, 0x00000000, 0x06, 0x07 },
	{ 0xa3, 0x00008100, 0xfffffcff, 0x00000300, 0x00, 0x01 },
	{ 0xa3, 0x0000804c, 0x0000ffff, 0x85850000, 0x00, 0x01 },
	{ 0xa3, 0x00002290, 0x00ffffff, 0x00600000, 0x00, 0x01 },
	{ 0xa3, 0x00002490, 0x00ffffff, 0x00600000, 0x00, 0x01 },
	{ 0xa3, 0x0000230c, 0xff00ffff, 0x00020000, 0x00, 0x01 },
	{ 0xa3, 0x0000250c, 0xff00ffff, 0x00020000, 0x00, 0x01 },
	{ 0xa3, 0x000080d0, 0xffffff0f, 0x00000050, 0x00, 0x01 },
	{ 0xa6, 0x00000288, 0xffff00ff, 0x0000a000, 0x00, 0x01 },
	{ 0xa6, 0x00000488, 0xffff00ff, 0x0000a000, 0x00, 0x01 },
	{ 0xa6, 0x00000688, 0xffff00ff, 0x0000a000, 0x00, 0x01 },
	{ 0xa6, 0x00000888, 0xffff00ff, 0x0000a000, 0x00, 0x01 },
	{ 0xa6, 0x00000290, 0xffff00ff, 0x00005500, 0x00, 0x01 },
	{ 0xa6, 0x00000290, 0xff00ffff, 0x003b0000, 0x00, 0x01 },
	{ 0xa6, 0x00000490, 0xffff00ff, 0x00005500, 0x00, 0x01 },
	{ 0xa6, 0x00000490, 0xff00ffff, 0x003b0000, 0x00, 0x01 },
	{ 0xa6, 0x00000690, 0xffff00ff, 0x00005500, 0x00, 0x01 },
	{ 0xa6, 0x00000690, 0xff00ffff, 0x003b0000, 0x00, 0x01 },
	{ 0xa6, 0x00000890, 0xffff00ff, 0x00005500, 0x00, 0x01 },
	{ 0xa6, 0x00000890, 0xff00ffff, 0x003b0000, 0x00, 0x01 },
	{ 0xa6, 0x0000030c, 0xffffff00, 0x0000009c, 0x00, 0x01 },
	{ 0xa6, 0x0000030c, 0xffff00ff, 0x00004b00, 0x00, 0x01 },
	{ 0xa6, 0x00000318, 0xff00ffff, 0x009c0000, 0x00, 0x01 },
	{ 0xa6, 0x00000318, 0x00ffffff, 0x4b000000, 0x00, 0x01 },
	{ 0xa6, 0x0000050c, 0xffffff00, 0x0000009c, 0x00, 0x01 },
	{ 0xa6, 0x0000050c, 0xffff00ff, 0x00004b00, 0x00, 0x01 },
	{ 0xa6, 0x00000518, 0xff00ffff, 0x009c0000, 0x00, 0x01 },
	{ 0xa6, 0x00000518, 0x00ffffff, 0x4b000000, 0x00, 0x01 },
	{ 0xa6, 0x0000070c, 0xffffff00, 0x0000009c, 0x00, 0x01 },
	{ 0xa6, 0x0000070c, 0xffff00ff, 0x00004b00, 0x00, 0x01 },
	{ 0xa6, 0x00000718, 0xff00ffff, 0x009c0000, 0x00, 0x01 },
	{ 0xa6, 0x00000718, 0x00ffffff, 0x4b000000, 0x00, 0x01 },
	{ 0xa6, 0x0000090c, 0xffffff00, 0x0000009c, 0x00, 0x01 },
	{ 0xa6, 0x0000090c, 0xffff00ff, 0x00004b00, 0x00, 0x01 },
	{ 0xa6, 0x00000918, 0xff00ffff, 0x009c0000, 0x00, 0x01 },
	{ 0xa6, 0x00000918, 0x00ffffff, 0x4b000000, 0x00, 0x01 },
	{ 0xa6, 0x00000244, 0xfffffff7, 0x00000008, 0x00, 0x01 },
	{ 0xa6, 0x00000444, 0xfffffff7, 0x00000008, 0x00, 0x01 },
	{ 0xa6, 0x00000644, 0xfffffff7, 0x00000008, 0x00, 0x01 },
	{ 0xa6, 0x00000844, 0xfffffff7, 0x00000008, 0x00, 0x01 },
	{ 0xa6, 0x00000244, 0xfffffffb, 0x00000004, 0x00, 0x01 },
	{ 0xa6, 0x00000444, 0xfffffffb, 0x00000004, 0x00, 0x01 },
	{ 0xa6, 0x00000644, 0xfffffffb, 0x00000004, 0x00, 0x01 },
	{ 0xa6, 0x00000844, 0xfffffffb, 0x00000004, 0x00, 0x01 },
	{ 0xa6, 0x00000244, 0xfffffffd, 0x00000002, 0x00, 0x01 },
	{ 0xa6, 0x00000444, 0xfffffffd, 0x00000002, 0x00, 0x01 },
	{ 0xa6, 0x00000644, 0xfffffffd, 0x00000002, 0x00, 0x01 },
	{ 0xa6, 0x00000844, 0xfffffffd, 0x00000002, 0x00, 0x01 },
	{ 0xa6, 0x00000244, 0xfffff9ff, 0x00000200, 0x00, 0x01 },
	{ 0xa6, 0x00000254, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa6, 0x00000244, 0xfffffeff, 0x00000100, 0x00, 0x01 },
	{ 0xa6, 0x00000244, 0xfffffeff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000444, 0xfffff9ff, 0x00000200, 0x00, 0x01 },
	{ 0xa6, 0x00000454, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa6, 0x00000444, 0xfffffeff, 0x00000100, 0x00, 0x01 },
	{ 0xa6, 0x00000444, 0xfffffeff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000644, 0xfffff9ff, 0x00000200, 0x00, 0x01 },
	{ 0xa6, 0x00000654, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa6, 0x00000644, 0xfffffeff, 0x00000100, 0x00, 0x01 },
	{ 0xa6, 0x00000644, 0xfffffeff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000844, 0xfffff9ff, 0x00000200, 0x00, 0x01 },
	{ 0xa6, 0x00000854, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa6, 0x00000844, 0xfffffeff, 0x00000100, 0x00, 0x01 },
	{ 0xa6, 0x00000844, 0xfffffeff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000244, 0xfffff9ff, 0x00000400, 0x00, 0x01 },
	{ 0xa6, 0x00000254, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa6, 0x00000244, 0xfffffeff, 0x00000100, 0x00, 0x01 },
	{ 0xa6, 0x00000244, 0xfffffeff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000444, 0xfffff9ff, 0x00000400, 0x00, 0x01 },
	{ 0xa6, 0x00000454, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa6, 0x00000444, 0xfffffeff, 0x00000100, 0x00, 0x01 },
	{ 0xa6, 0x00000444, 0xfffffeff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000644, 0xfffff9ff, 0x00000400, 0x00, 0x01 },
	{ 0xa6, 0x00000654, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa6, 0x00000644, 0xfffffeff, 0x00000100, 0x00, 0x01 },
	{ 0xa6, 0x00000644, 0xfffffeff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000844, 0xfffff9ff, 0x00000400, 0x00, 0x01 },
	{ 0xa6, 0x00000854, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa6, 0x00000844, 0xfffffeff, 0x00000100, 0x00, 0x01 },
	{ 0xa6, 0x00000844, 0xfffffeff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000244, 0xfffff9ff, 0x00000600, 0x00, 0x01 },
	{ 0xa6, 0x00000254, 0x00ffffff, 0x95000000, 0x00, 0x01 },
	{ 0xa6, 0x00000244, 0xfffffeff, 0x00000100, 0x00, 0x01 },
	{ 0xa6, 0x00000244, 0xfffffeff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000444, 0xfffff9ff, 0x00000600, 0x00, 0x01 },
	{ 0xa6, 0x00000454, 0x00ffffff, 0x95000000, 0x00, 0x01 },
	{ 0xa6, 0x00000444, 0xfffffeff, 0x00000100, 0x00, 0x01 },
	{ 0xa6, 0x00000444, 0xfffffeff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000644, 0xfffff9ff, 0x00000600, 0x00, 0x01 },
	{ 0xa6, 0x00000654, 0x00ffffff, 0x95000000, 0x00, 0x01 },
	{ 0xa6, 0x00000644, 0xfffffeff, 0x00000100, 0x00, 0x01 },
	{ 0xa6, 0x00000644, 0xfffffeff, 0x00000000, 0x00, 0x01 },
	{ 0xa6, 0x00000844, 0xfffff9ff, 0x00000600, 0x00, 0x01 },
	{ 0xa6, 0x00000854, 0x00ffffff, 0x95000000, 0x00, 0x01 },
	{ 0xa6, 0x00000844, 0xfffffeff, 0x00000100, 0x00, 0x01 },
	{ 0xa6, 0x00000844, 0xfffffeff, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x00002244, 0xfffffff7, 0x00000008, 0x00, 0x01 },
	{ 0xa3, 0x00002444, 0xfffffff7, 0x00000008, 0x00, 0x01 },
	{ 0xa3, 0x00002244, 0xfffffffb, 0x00000004, 0x00, 0x01 },
	{ 0xa3, 0x00002444, 0xfffffffb, 0x00000004, 0x00, 0x01 },
	{ 0xa3, 0x00002244, 0xfffffffd, 0x00000002, 0x00, 0x01 },
	{ 0xa3, 0x00002444, 0xfffffffd, 0x00000002, 0x00, 0x01 },
	{ 0xa3, 0x00002244, 0xfffff9ff, 0x00000200, 0x00, 0x01 },
	{ 0xa3, 0x00002254, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa3, 0x00002244, 0xfffffeff, 0x00000100, 0x00, 0x01 },
	{ 0xa3, 0x00002244, 0xfffffeff, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x00002444, 0xfffff9ff, 0x00000200, 0x00, 0x01 },
	{ 0xa3, 0x00002454, 0xffff00ff, 0x00009500, 0x00, 0x01 },
	{ 0xa3, 0x00002444, 0xfffffeff, 0x00000100, 0x00, 0x01 },
	{ 0xa3, 0x00002444, 0xfffffeff, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x00002244, 0xfffff9ff, 0x00000400, 0x00, 0x01 },
	{ 0xa3, 0x00002254, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa3, 0x00002244, 0xfffffeff, 0x00000100, 0x00, 0x01 },
	{ 0xa3, 0x00002244, 0xfffffeff, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x00002444, 0xfffff9ff, 0x00000400, 0x00, 0x01 },
	{ 0xa3, 0x00002454, 0xff00ffff, 0x00950000, 0x00, 0x01 },
	{ 0xa3, 0x00002444, 0xfffffeff, 0x00000100, 0x00, 0x01 },
	{ 0xa3, 0x00002444, 0xfffffeff, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x00002244, 0xfffff9ff, 0x00000600, 0x00, 0x01 },
	{ 0xa3, 0x00002254, 0x00ffffff, 0x95000000, 0x00, 0x01 },
	{ 0xa3, 0x00002244, 0xfffffeff, 0x00000100, 0x00, 0x01 },
	{ 0xa3, 0x00002244, 0xfffffeff, 0x00000000, 0x00, 0x01 },
	{ 0xa3, 0x00002444, 0xfffff9ff, 0x00000600, 0x00, 0x01 },
	{ 0xa3, 0x00002454, 0x00ffffff, 0x95000000, 0x00, 0x01 },
	{ 0xa3, 0x00002444, 0xfffffeff, 0x00000100, 0x00, 0x01 },
	{ 0xa3, 0x00002444, 0xfffffeff, 0x00000000, 0x00, 0x01 },
	MODPHY_ENTRY_END
};
