{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetUniformMissing: TUniformMissing;
    procedure SetUniformMissing(const Value: TUniformMissing);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdParts: TMFNode;
    { Internal wrapper for property @code(Parts). This wrapper API may change, we advise to access simpler @code(Parts) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdParts: TMFNode read FFdParts;
    {  }
    procedure SetParts(const Value: array of TShaderPartNode);

    strict private FFdUniformMissing: TSFStringEnum;
    { Internal wrapper for property @code(UniformMissing). This wrapper API may change, we advise to access simpler @code(UniformMissing) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdUniformMissing: TSFStringEnum read FFdUniformMissing;
    { Should we report a missing uniform value. Setting this to umWarning (default) is useful to spot simple mistakes in naming uniforms. On the other hand, OpenGL aggressively removes unused uniforms from code, and it may cause spurious messages that some uniform is missing -- even though the shader is correct, is just doesn't use some uniform value e.g. because no lights are present on the current scene. }
    property UniformMissing: TUniformMissing read GetUniformMissing write SetUniformMissing;

{$endif read_interface}

{$ifdef read_implementation}

{ TComposedShaderNode ----------------------------------------------- }

procedure TComposedShaderNode.SetParts(const Value: array of TShaderPartNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TShaderPartNode));
  FdParts.Send(A);
end;

function TComposedShaderNode.GetUniformMissing: TUniformMissing;
begin
  Result := TUniformMissing(FdUniformMissing.EnumValue);
end;

procedure TComposedShaderNode.SetUniformMissing(const Value: TUniformMissing);
begin
  FdUniformMissing.SendEnumValue(Ord(Value));
end;

class function TComposedShaderNode.ClassX3DType: String;
begin
  Result := 'ComposedShader';
end;

procedure TComposedShaderNode.CreateNode;
begin
  inherited;

  FFdParts := TMFNode.Create(Self, True, 'parts', [TShaderPartNode]);
   FdParts.ChangeAlways := chEverything;
  AddField(FFdParts);

  FFdUniformMissing := TSFStringEnum.Create(Self, False, 'uniformMissing', @UniformMissingNames, Ord(High(UniformMissingNames)) + 1, Ord(umWarning));
   FdUniformMissing.ChangeAlways := chEverything;
  AddField(FFdUniformMissing);
end;

{$endif read_implementation}
