{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetInitialDestination: TCastleColorRGB;
    procedure SetInitialDestination(const Value: TCastleColorRGB);
    function GetInitialValue: TCastleColorRGB;
    procedure SetInitialValue(const Value: TCastleColorRGB);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FEventSet_destination: TSFColorEvent;
    {  }
    public property EventSet_destination: TSFColorEvent read FEventSet_destination;

    strict private FEventSet_value: TSFColorEvent;
    {  }
    public property EventSet_value: TSFColorEvent read FEventSet_value;

    strict private FEventValue_changed: TSFColorEvent;
    {  }
    public property EventValue_changed: TSFColorEvent read FEventValue_changed;

    strict private FFdInitialDestination: TSFColor;
    { Internal wrapper for property @code(InitialDestination). This wrapper API may change, we advise to access simpler @code(InitialDestination) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdInitialDestination: TSFColor read FFdInitialDestination;
    {  }
    property InitialDestination: TCastleColorRGB read GetInitialDestination write SetInitialDestination;

    strict private FFdInitialValue: TSFColor;
    { Internal wrapper for property @code(InitialValue). This wrapper API may change, we advise to access simpler @code(InitialValue) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdInitialValue: TSFColor read FFdInitialValue;
    {  }
    property InitialValue: TCastleColorRGB read GetInitialValue write SetInitialValue;

{$endif read_interface}

{$ifdef read_implementation}

{ TColorDamperNode ----------------------------------------------- }

function TColorDamperNode.GetInitialDestination: TCastleColorRGB;
begin
  Result := FdInitialDestination.Value;
end;

procedure TColorDamperNode.SetInitialDestination(const Value: TCastleColorRGB);
begin
  FdInitialDestination.Send(Value);
end;

function TColorDamperNode.GetInitialValue: TCastleColorRGB;
begin
  Result := FdInitialValue.Value;
end;

procedure TColorDamperNode.SetInitialValue(const Value: TCastleColorRGB);
begin
  FdInitialValue.Send(Value);
end;

class function TColorDamperNode.ClassX3DType: String;
begin
  Result := 'ColorDamper';
end;

procedure TColorDamperNode.CreateNode;
begin
  inherited;

  FEventSet_destination := TSFColorEvent.Create(Self, 'set_destination', true);
  AddEvent(FEventSet_destination);

  FEventSet_value := TSFColorEvent.Create(Self, 'set_value', true);
  AddEvent(FEventSet_value);

  FEventValue_changed := TSFColorEvent.Create(Self, 'value_changed', false);
  AddEvent(FEventValue_changed);

  FFdInitialDestination := TSFColor.Create(Self, False, 'initialDestination', Vector3(0.8, 0.8, 0.8));
   FdInitialDestination.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdInitialDestination);

  FFdInitialValue := TSFColor.Create(Self, False, 'initialValue', Vector3(0.8, 0.8, 0.8));
   FdInitialValue.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdInitialValue);
end;

{$endif read_implementation}
