{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdColor: TMFColor;
    { Internal wrapper for property @code(Color). This wrapper API may change, we advise to access simpler @code(Color) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdColor: TMFColor read FFdColor;
    {  }
    procedure SetColor(const Value: array of TCastleColorRGB); overload;
    {  }
    procedure SetColor(const Value: TVector3List); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TColorNode ----------------------------------------------- }

procedure TColorNode.SetColor(const Value: array of TCastleColorRGB);
begin
  FdColor.Send(Value);
end;

procedure TColorNode.SetColor(const Value: TVector3List);
begin
  FdColor.Send(Value);
end;

class function TColorNode.ClassX3DType: String;
begin
  Result := 'Color';
end;

procedure TColorNode.CreateNode;
begin
  inherited;

  FFdColor := TMFColor.Create(Self, True, 'color', []);
   FdColor.ChangeAlways := chColorNode;
  AddField(FFdColor);
end;

{$endif read_implementation}
