{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetRadius: Single;
    procedure SetRadius(const Value: Single);
    function GetSlices: Integer;
    procedure SetSlices(const Value: Integer);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdRadius: TSFFloat;
    { Internal wrapper for property @code(Radius). This wrapper API may change, we advise to access simpler @code(Radius) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRadius: TSFFloat read FFdRadius;
    {  }
    property Radius: Single read GetRadius write SetRadius;

    strict private FFdSlices: TSFInt32;
    { Internal wrapper for property @code(Slices). This wrapper API may change, we advise to access simpler @code(Slices) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSlices: TSFInt32 read FFdSlices;
    { How much to subdivide the circle. Larger values result in a shape that looks smoother (like a correct circle), but also mean that we need to render more triangles. The default value, 0 means to use the global @link(DefaultTriangulationSlices) parameter. }
    property Slices: Integer read GetSlices write SetSlices;

{$endif read_interface}

{$ifdef read_implementation}

{ TCircle2DNode ----------------------------------------------- }

function TCircle2DNode.GetRadius: Single;
begin
  Result := FdRadius.Value;
end;

procedure TCircle2DNode.SetRadius(const Value: Single);
begin
  FdRadius.Send(Value);
end;

function TCircle2DNode.GetSlices: Integer;
begin
  Result := FdSlices.Value;
end;

procedure TCircle2DNode.SetSlices(const Value: Integer);
begin
  FdSlices.Send(Value);
end;

class function TCircle2DNode.ClassX3DType: String;
begin
  Result := 'Circle2D';
end;

procedure TCircle2DNode.CreateNode;
begin
  inherited;

  FFdRadius := TSFFloat.Create(Self, False, 'radius', 1);
   FdRadius.ChangeAlways := chGeometry;
   FdRadius.MustBeNonnegative := true;
  AddField(FFdRadius);

  FFdSlices := TSFInt32.Create(Self, True, 'slices', 0);
   FdSlices.ChangeAlways := chGeometry;
  AddField(FFdSlices);
end;

{$endif read_implementation}
