{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetAnchorPoint: TVector3;
    procedure SetAnchorPoint(const Value: TVector3);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdAnchorPoint: TSFVec3f;
    { Internal wrapper for property @code(AnchorPoint). This wrapper API may change, we advise to access simpler @code(AnchorPoint) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAnchorPoint: TSFVec3f read FFdAnchorPoint;
    {  }
    property AnchorPoint: TVector3 read GetAnchorPoint write SetAnchorPoint;

    strict private FEventBody1AnchorPoint: TSFVec3fEvent;
    {  }
    public property EventBody1AnchorPoint: TSFVec3fEvent read FEventBody1AnchorPoint;

    strict private FEventBody2AnchorPoint: TSFVec3fEvent;
    {  }
    public property EventBody2AnchorPoint: TSFVec3fEvent read FEventBody2AnchorPoint;

{$endif read_interface}

{$ifdef read_implementation}

{ TBallJointNode ----------------------------------------------- }

function TBallJointNode.GetAnchorPoint: TVector3;
begin
  Result := FdAnchorPoint.Value;
end;

procedure TBallJointNode.SetAnchorPoint(const Value: TVector3);
begin
  FdAnchorPoint.Send(Value);
end;

class function TBallJointNode.ClassX3DType: String;
begin
  Result := 'BallJoint';
end;

procedure TBallJointNode.CreateNode;
begin
  inherited;

  FFdAnchorPoint := TSFVec3f.Create(Self, True, 'anchorPoint', Vector3(0, 0, 0));
   FdAnchorPoint.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAnchorPoint);

  FEventBody1AnchorPoint := TSFVec3fEvent.Create(Self, 'body1AnchorPoint', false);
  AddEvent(FEventBody1AnchorPoint);

  FEventBody2AnchorPoint := TSFVec3fEvent.Create(Self, 'body2AnchorPoint', false);
  AddEvent(FEventBody2AnchorPoint);
end;

{$endif read_implementation}
