// MetadataType.cs
// 
// Copyright (C) 2011 Patrick Ulbrich <zulu99@gmx.net>
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

using System;

namespace VolumeDB.Metadata
{	
	// keep in sync with libextractor 0.5.x KeywordType enum
	// (enum is casted directly)
	public enum MetadataType : int {
	  UNKNOWN = 0,
	  FILENAME = 1,
	  MIMETYPE = 2,
	  TITLE = 3,
	  AUTHOR = 4,
	  ARTIST = 5,
	  DESCRIPTION = 6,
	  COMMENT = 7,
	  DATE = 8,
	  PUBLISHER = 9,
	  LANGUAGE = 10,
	  ALBUM = 11,
	  GENRE = 12,
	  LOCATION = 13,
	  VERSIONNUMBER = 14,
	  ORGANIZATION = 15,
	  COPYRIGHT = 16,
	  SUBJECT = 17,
	  KEYWORDS = 18,
	  CONTRIBUTOR = 19,
	  RESOURCE_TYPE = 20,
	  FORMAT = 21,
	  RESOURCE_IDENTIFIER = 22,
	  SOURCE = 23,
	  RELATION = 24,
	  COVERAGE = 25,
	  SOFTWARE = 26,
	  DISCLAIMER = 27,
	  WARNING = 28,
	  TRANSLATED = 29,
	  CREATION_DATE = 30,
	  MODIFICATION_DATE = 31,
	  CREATOR = 32,
	  PRODUCER = 33,
	  PAGE_COUNT = 34,
	  PAGE_ORIENTATION = 35,
	  PAPER_SIZE = 36,
	  USED_FONTS = 37,
	  PAGE_ORDER = 38,
	  CREATED_FOR = 39,
	  MAGNIFICATION = 40,
	  RELEASE = 41,
	  GROUP = 42,
	  SIZE = 43,
	  SUMMARY = 44,
	  PACKAGER = 45,
	  VENDOR = 46,
	  LICENSE = 47,
	  DISTRIBUTION = 48,
	  BUILDHOST = 49,
	  OS = 50,
	  DEPENDENCY = 51,
	  HASH_MD4 = 52,
	  HASH_MD5 = 53,
	  HASH_SHA0 = 54,
	  HASH_SHA1 = 55,
	  HASH_RMD160 = 56,
	  RESOLUTION = 57,
	  CATEGORY = 58,
	  BOOKTITLE = 59,
	  PRIORITY = 60,
	  CONFLICTS = 61,
	  REPLACES = 62,
	  PROVIDES = 63,
	  CONDUCTOR = 64,
	  INTERPRET = 65,
	  OWNER = 66,
	  LYRICS = 67,
	  MEDIA_TYPE = 68,
	  CONTACT = 69,
	  THUMBNAIL_DATA = 70,
	  PUBLICATION_DATE = 71,
	  CAMERA_MAKE = 72,
	  CAMERA_MODEL = 73,
	  EXPOSURE = 74,
	  APERTURE = 75,
	  EXPOSURE_BIAS = 76,
	  FLASH = 77,
	  FLASH_BIAS = 78,
	  FOCAL_LENGTH = 79,
	  FOCAL_LENGTH_35MM = 80,
	  ISO_SPEED = 81,
	  EXPOSURE_MODE = 82,
	  METERING_MODE = 83,
	  MACRO_MODE = 84,
	  IMAGE_QUALITY = 85,
	  WHITE_BALANCE = 86,
	  ORIENTATION = 87,
	  TEMPLATE = 88,
	  SPLIT = 89,
	  PRODUCTVERSION = 90,
	  LAST_SAVED_BY = 91,
	  LAST_PRINTED = 92,
	  WORD_COUNT = 93,
	  CHARACTER_COUNT = 94,
	  TOTAL_EDITING_TIME = 95,
	  THUMBNAILS = 96,
	  SECURITY = 97,
	  CREATED_BY_SOFTWARE = 98,
	  MODIFIED_BY_SOFTWARE = 99,
	  REVISION_HISTORY = 100,
	  LOWERCASE = 101,
	  COMPANY = 102,
	  GENERATOR = 103,
	  CHARACTER_SET = 104,
	  LINE_COUNT = 105,
	  PARAGRAPH_COUNT = 106,
	  EDITING_CYCLES = 107,
	  SCALE = 108,
	  MANAGER = 109,
	  MOVIE_DIRECTOR = 110,
	  DURATION = 111,
	  INFORMATION = 112,
	  FULL_NAME = 113,
	  CHAPTER = 114,
	  YEAR = 115,
	  LINK = 116,
	  MUSIC_CD_IDENTIFIER = 117,
	  PLAY_COUNTER = 118,
	  POPULARITY_METER = 119,
	  CONTENT_TYPE = 120,
	  ENCODED_BY = 121,
	  TIME = 122,
	  MUSICIAN_CREDITS_LIST = 123,
	  MOOD = 124, 
	  FORMAT_VERSION = 125,
	  TELEVISION_SYSTEM = 126,
	  SONG_COUNT = 127,
	  STARTING_SONG = 128,
	  HARDWARE_DEPENDENCY = 129,
	  RIPPER = 130,
	  FILE_SIZE = 131,
	  TRACK_NUMBER = 132,
	  ISRC = 133,
	  DISC_NUMBER = 134,
	  GNUNET_DISPLAY_TYPE = 135,
	  GNUNET_ECBC_URI = 136
	}
}
