//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_49.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot49(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[49] = {1.252498275336912e-02,1.127439634746335e-01,3.132840103182815e-01,6.143498671308711e-01,1.016250090077344e+00,
    1.519398798105510e+00,2.124318044139960e+00,2.831640840132535e+00,3.642114878943241e+00,4.556607007007854e+00,5.576108514194526e+00,6.701741321551700e+00,
    7.934765164280741e+00,9.276585886813690e+00,1.072876499007044e+01,1.229303059872703e+01,1.397129004981336e+01,1.576564434466372e+01,1.767840475609137e+01,
    1.971211194415016e+01,2.186955801026534e+01,2.415381201520954e+01,2.656824960717427e+01,2.911658755986999e+01,3.180292421786316e+01,3.463178710191168e+01,
    3.760818926140915e+01,4.073769640309921e+01,4.402650741638126e+01,4.748155171586636e+01,5.111060791998376e+01,5.492244991337505e+01,5.892702850392867e+01,
    6.313570000018330e+01,6.756151760892536e+01,7.221960841783434e+01,7.712766928685110e+01,8.230663166776230e+01,8.778157261780036e+01,9.358299538268564e+01,
    9.974868433207851e+01,1.063264901285885e+02,1.133786988279350e+02,1.209892705139735e+02,1.292767044240934e+02,1.384191562500957e+02,1.487104626593072e+02,
    1.607138582999204e+02,1.758823498831879e+02};
  constexpr double aw[49] = {2.210488382772323e-01,2.000203503447396e-01,1.637578107296366e-01,1.212783844396225e-01,8.122414932703971e-02,
    4.917321790564288e-02,2.689605026021618e-02,1.328286216996388e-02,5.918552360985582e-03,2.377310922221486e-03,8.599544844304291e-04,2.798336444627272e-04,
    8.181180069055645e-05,2.145937790443935e-05,5.042314887726511e-06,1.059520014394322e-06,1.987157227190031e-07,3.319657223217434e-08,4.928284075350579e-09,
    6.485515200581754e-10,7.544596901897571e-11,7.734776903096704e-12,6.965065881420261e-13,5.488670354937545e-14,3.769713169605182e-15,2.246461695281105e-16,
    1.155795521526934e-17,5.105739653797258e-19,1.924706787056291e-20,6.149189410110338e-22,1.652241262465510e-23,3.701345629364837e-25,6.845425642114638e-27,
    1.033518299989048e-28,1.257502779892585e-30,1.214736916927656e-32,9.154814171674804e-35,5.272805188722617e-37,2.264237394060745e-39,7.034647443887613e-42,
    1.523554920090092e-44,2.194572489761186e-47,1.977790194675830e-50,1.027180426413359e-53,2.738329786124213e-57,3.150504845494649e-61,1.176773685663440e-65,
    8.302078221246393e-71,2.790452511867978e-77};
  constexpr double x[18816] = {  5.034647466839481e-04, -2.542117918356894e-06,  9.624384939967254e-09, -3.237838395174360e-11,  1.020765062622235e-13,
 -3.087811827279703e-16,  9.075809084351108e-19, -2.611400748515524e-21,  7.390795592695413e-24, -2.064170888109112e-26,  5.701987830197023e-29, -1.560455189526798e-31,
  4.528201846620745e-03, -2.281844920084828e-05,  8.604501908346864e-08, -2.875421744139239e-10,  8.974083201950995e-13, -2.676295784838829e-15,  7.716854322235320e-18,
 -2.165547016860057e-20,  5.936812856696620e-23, -1.593275618904194e-25,  4.189357795404431e-28, -1.079105588986780e-30,  1.256178994767941e-02, -6.304889065815446e-05,
  2.358453623879327e-07, -7.775495718670850e-10,  2.377149029527395e-12, -6.882279131837724e-15,  1.904725297803658e-17, -5.056395665183460e-20,  1.286570320605766e-22,
 -3.122418644728758e-25,  7.150419398202505e-28, -1.511423206451069e-30,  2.457251391406200e-02, -1.225939916692115e-04,  4.530521024502057e-07, -1.463104600884551e-09,
  4.331524678162245e-12, -1.195626713828627e-14,  3.086821451175135e-17, -7.400148327844637e-20,  1.611930432339873e-22, -3.018631672164291e-25,  4.027519823724501e-28,
  7.878095222633827e-32,  4.051294357599609e-02, -2.005069826375111e-04,  7.289728748111986e-07, -2.288539846060997e-09,  6.474837089634163e-12, -1.664851545499343e-14,
  3.838326107740673e-17, -7.566317527465644e-20,  1.083418206828592e-22, -6.254147090919284e-27, -7.372502416241946e-28,  3.707668063885247e-30,  6.032010443167084e-02,
 -2.955484600691240e-04,  1.052507039316442e-06, -3.185517034415825e-09,  8.476929991608991e-12, -1.964228707097602e-14,  3.723016539732590e-17, -4.412865872156609e-20,
 -4.815791952726069e-23,  5.484528229672207e-25, -2.311521138444822e-27,  7.189320199251558e-30,  8.391570468239634e-02, -4.062056318238663e-04,  1.410543165379632e-06,
 -4.077590783957461e-09,  1.000000549600662e-11, -1.978417331188190e-14,  2.464685494438147e-17,  2.234444331477376e-20, -2.810454056384809e-22,  1.160831990549980e-24,
 -3.382034129255382e-27,  7.133710682304340e-30,  1.112064181090714e-01, -5.307158408789540e-04,  1.788429472347525e-06, -4.885347334870378e-09,  1.073703981961541e-11,
 -1.629719356276697e-14,  3.460942493109026e-19,  1.135821261256171e-19, -5.190334186603917e-22,  1.514459063000651e-24, -2.912805639589907e-27,  1.249111122147399e-30,
  1.420842221682323e-01, -6.670940221825037e-04,  2.170500904214914e-06, -5.531792592040116e-09,  1.044785242279547e-11, -8.943383074345869e-15, -3.310476260206675e-17,
  2.086565769483576e-19, -6.661644179024537e-22,  1.309258542210338e-24, -3.978402563399168e-28, -9.431302984460266e-30,  1.764267905517547e-01, -8.131636877813918e-04,
  2.540644493156764e-06, -5.947646329045328e-09,  8.989076795296701e-12,  1.890585505122066e-15, -7.050684574084713e-17,  2.803928244665028e-19, -6.338615670493023e-22,
  4.129271804965034e-25,  3.659820098551848e-27, -1.999631149863822e-29,  2.140979393149773e-01, -9.665909811900357e-04,  2.882883254569098e-06, -6.076203125371201e-09,
  6.334847971432001e-12,  1.520041227048287e-14, -1.048433672813764e-16,  3.022364905191151e-19, -3.755222418579440e-22, -1.033741107478857e-24,  7.718171708854773e-27,
 -2.357508663370994e-29,  2.549481255330046e-01, -1.124921293689911e-03,  3.181958109431087e-06, -5.877445453779262e-09,  2.585909497373874e-12,  2.946622320528474e-14,
 -1.285500908275367e-16,  2.557928313891728e-19,  8.833090969106748e-23, -2.611826747815698e-24,  9.722228351501532e-27, -1.508288360631893e-29,  2.988149972937012e-01,
 -1.285617893632826e-03,  3.423887278874914e-06, -5.331138950060083e-09, -2.034032472774020e-12,  4.283821301547912e-14, -1.350104240369307e-16,  1.370527410836556e-19,
  6.642144921378944e-22, -3.737526029096804e-24,  8.018448080595640e-27,  5.127075058598309e-30,  3.455239936780463e-01, -1.446101985526270e-03,  3.596483249774216e-06,
 -4.438701717301823e-09, -7.194625326837329e-12,  5.338191629732050e-14, -1.199870258085429e-16, -4.046764127865795e-20,  1.203453583104699e-21, -3.864243783061986e-24,
  2.265539104247136e-27,  2.993822180134302e-29,  3.948889932138193e-01, -1.603793589302808e-03,  3.689808754960482e-06, -3.223714900172085e-09, -1.248651001385519e-11,
  5.934980065042203e-14, -8.270083634974740e-17, -2.467637689233887e-19,  1.540418903823534e-21, -2.704056728813281e-24, -6.108057654655295e-27,  4.773424019413411e-29,
  4.467130091169597e-01, -1.756152612237602e-03,  3.696555210447157e-06, -1.731026196615863e-09, -1.745778963017476e-11,  5.944108344363384e-14, -2.632412897277850e-17,
 -4.406451283959995e-19,  1.541137605882718e-21, -3.831404201852978e-25, -1.419434195500422e-26,  4.765971807102117e-29,  5.007889294564714e-01, -1.900719476912504e-03,
  3.612329645591896e-06, -2.448632360678712e-11, -2.165591137047829e-11,  5.301220709482348e-14,  4.224257281516660e-17, -5.783149824302177e-19,  1.147970548269913e-21,
  2.537720298729422e-24, -1.862252829429396e-26,  2.549969012169080e-29,  5.569003001936979e-01, -2.035154668768470e-03,  3.435839270319407e-06,  1.816554727707952e-09,
 -2.467094936838571e-11,  4.020630013454323e-14,  1.133076089486681e-16, -6.233543584297125e-19,  4.060944780411958e-22,  5.201388498061826e-24, -1.694009697824025e-26,
 -1.290083723431956e-29,  6.148221488556631e-01, -2.157276576369021e-03,  3.168966347320193e-06,  3.701784962898573e-09, -2.617606488060147e-11,  2.198048062774414e-14,
  1.759005704702582e-16, -5.557759550670640e-19, -5.379331971717857e-22,  6.717102648795613e-24, -8.786375331688389e-27, -5.285595053035040e-29,  6.743218464056376e-01,
 -2.265097016626849e-03,  2.816729861315857e-06,  5.535226713760029e-09, -2.596112223257976e-11,  2.363249957917581e-17,  2.196062907632411e-16, -3.779090070852671e-19,
 -1.467389498600688e-21,  6.463576784103153e-24,  3.681781436756115e-27, -7.669221757587636e-29,  7.351600046730621e-01, -2.356853865905682e-03,  2.387134473999662e-06,
  7.220966276325019e-09, -2.395604071323812e-11, -2.342757556682202e-14,  2.363962561983567e-16, -1.155271751823834e-19, -2.149335266260741e-21,  4.326499822255208e-24,
  1.637467095725747e-26, -7.181560340963561e-29,  7.970914065005917e-01, -2.431040255945495e-03,  1.890911285180840e-06,  8.668959806011012e-09, -2.024141139233609e-11,
 -4.585226629281859e-14,  2.221218918690986e-16,  1.863010202687457e-19, -2.397001391612451e-21,  7.805563706877595e-25,  2.470927166391510e-26, -3.718694485367070e-29,
  8.598659655596779e-01, -2.486429840671218e-03,  1.341158846528543e-06,  9.800549388514956e-09, -1.504511566313039e-11, -6.475476614145473e-14,  1.773857842148216e-16,
  4.719230441346801e-19, -2.123026361448775e-21, -3.223652182218197e-24,  2.536745120296878e-26,  1.513536444860995e-29,  9.232297125793996e-01, -2.522097695682749e-03,
  7.528965528985621e-07,  1.055333737265562e-08, -8.725033961150426e-12, -7.797899050888750e-14,  1.076133382358939e-16,  6.865494968810819e-19, -1.367811722109801e-21,
 -6.539871926707711e-24,  1.766470231084017e-26,  6.451890239028376e-29,  9.869258045280260e-01, -2.537436475981794e-03,  1.425458314811808e-07,  1.088510388759871e-08,
 -1.739296925116663e-12, -8.398541932247243e-14,  2.228981161793262e-17,  7.879062897245844e-19, -2.938924868646807e-22, -8.185052929119452e-24,  3.945396464987669e-27,
  9.055359983479893e-29,  1.050695553085104e+00, -2.532167528507634e-03, -4.726426649453543e-07,  1.077650998472578e-08,  5.393228104316409e-12, -8.205266831732333e-14,
 -6.652002781441444e-17,  7.554401321871604e-19,  8.532124985485789e-22, -7.656959031214122e-24, -1.119903929673084e-26,  8.213987125819300e-29,  1.114279468545972e+00,
 -2.506346733413615e-03, -1.075195488364263e-06,  1.023240368862901e-08,  1.213853053009580e-11, -7.237544283366422e-14, -1.461188321969267e-16,  5.949352601112179e-19,
  1.807496320118989e-21, -5.101344930848440e-24, -2.261073018066861e-26,  4.258506756733209e-29,  1.177418315112978e+00, -2.460364930654462e-03, -1.648034622438290e-06,
  9.281633869728092e-09,  1.799480523455745e-11, -5.604454418710509e-14, -2.052502575734216e-16,  3.374295603919187e-19,  2.351198361338451e-21, -1.269412487410560e-24,
 -2.648805514297518e-26, -1.176929983065337e-29,  1.239854173350928e+00, -2.394942875166638e-03, -2.175085003051243e-06,  7.975371796314080e-09,  2.253701355078839e-11,
 -3.491068094084742e-14, -2.359321634641716e-16,  3.262944442083053e-20,  2.370650142709303e-21,  2.721811349103555e-24, -2.178436320063568e-26, -5.880239754496376e-29,
  1.301331505421135e+00, -2.311120753377603e-03, -2.641848972999653e-06,  6.384036428514974e-09,  2.545434497516052e-11, -1.134986699641561e-14, -2.347233967088852e-16,
 -2.616980943110034e-19,  1.883683741257894e-21,  5.745259054327775e-24, -1.052783992386243e-26, -8.035154956365532e-29,  1.361598218561794e+00, -2.210242384532657e-03,
 -3.035926285258745e-06,  4.593010713757515e-09,  2.657693304038839e-11,  1.203811748330886e-14, -2.032003436584959e-16, -4.919410032680229e-19,  1.031219558653252e-21,
  7.014973910723683e-24,  3.048015327498339e-27, -6.987870514974664e-29,  1.420406722155018e+00, -2.093934320847855e-03, -3.347460053636236e-06,  2.697416265466494e-09,
  2.588921609191190e-11,  3.275735130069958e-14, -1.475640820388800e-16, -6.196855462036337e-19,  3.598332795004799e-23,  6.314876935048765e-24,  1.418620912117402e-26,
 -3.458905221900262e-29,  1.477514973615810e+00, -1.964080149188101e-03, -3.569491593274366e-06,  7.962773951303534e-10,  2.352864343880202e-11,  4.872496683657944e-14,
 -7.745884277459150e-17, -6.291069302738813e-19, -8.592964528230152e-22,  4.032151117681085e-24,  1.940126322915153e-26,  8.726975745903954e-30,  1.532687508258164e+00,
 -1.822790382198884e-03, -3.698210314733829e-06, -1.013551947005259e-09,  1.976987987078269e-11,  5.852002364609445e-14, -4.227154845765708e-18, -5.291173488630748e-19,
 -1.456214822798493e-21,  9.921085866771233e-25,  1.766743211922894e-26,  4.183954682057776e-29,  1.585696448241299e+00, -1.672368406952445e-03, -3.733088624433825e-06,
 -2.643306339632436e-09,  1.499611039861465e-11,  6.153876490756838e-14,  6.107128842599534e-17, -3.499450585659685e-19, -1.649327927512713e-21, -1.839394779348468e-24,
  1.056268375623609e-26,  5.315007899871668e-29,  1.636322485677192e+00, -1.515273032599653e-03, -3.676896006354983e-06, -4.017687505820152e-09,  9.660343862191046e-12,
  5.803632384430755e-14,  1.095109580590648e-16, -1.351422036558872e-19, -1.446094804129923e-21, -3.676628052494313e-24,  1.386235717308304e-27,  4.193174487262451e-29,
  1.684355834991681e+00, -1.354078243709758e-03, -3.535590960227906e-06, -5.079351672883235e-09,  4.240623790592706e-12,  4.905116860370422e-14,  1.356870056201477e-16,
  6.892310616600852e-20, -9.540631410785472e-22, -4.146122042066768e-24, -6.307940808189918e-27,  1.712173645019196e-29,  1.729597149677610e+00, -1.191430821497970e-03,
 -3.318094080400877e-06, -5.792210710674273e-09, -8.063295376063470e-13,  3.622530295611242e-14,  1.383969297463768e-16,  2.235024994011938e-19, -3.411053692627273e-22,
 -3.356943114985284e-24, -1.010853198517290e-26, -8.168387542770949e-30,  1.771858398662191e+00, -1.030006539692770e-03, -3.035950099510382e-06, -6.143329092800288e-09,
 -5.088368015064949e-12,  2.154802937061602e-14,  1.205173817776040e-16,  3.053607910977275e-19,  2.177669806707719e-22, -1.798817661247130e-24, -9.506558274088736e-27,
 -2.328212543245668e-29,  1.810963697634677e+00, -8.724656742622498e-04, -2.702891013146666e-06, -6.143291056915242e-09, -8.313705697944574e-12,  7.061750577274797e-15,
  8.813339762286416e-17,  3.103845686719437e-19,  5.902397249134713e-22, -1.209588658847188e-25, -5.773899368003612e-27, -2.443052679209611e-29,  1.846750090848962e+00,
 -7.214085856845012e-04, -2.334316273300257e-06, -5.825013909553818e-09, -1.031567938120208e-11, -5.426747347593588e-15,  4.912069815683984e-17,  2.523042417529193e-19,
  7.185143162827568e-22,  1.116165555876220e-24, -1.122861360961526e-27, -1.504682212518345e-29,  1.879068279138730e+00, -5.793321382060015e-04, -1.946709330359214e-06,
 -5.241087414939910e-09, -1.106406199612761e-11, -1.458756436132545e-14,  1.148273145821163e-17,  1.571824273900432e-19,  6.250276416618364e-22,  1.622031390576557e-24,
  2.393384703635812e-27, -2.544357574353227e-30,  1.907783290187400e+00, -4.485877120556636e-04, -1.557012376904792e-06, -4.459818546204719e-09, -1.066191858221786e-11,
 -1.972724238797153e-14, -1.821696006275638e-17,  5.536437544229025e-20,  3.927904338875779e-22,  1.430421730881593e-24,  3.717746306410550e-27,  6.265598032737199e-30,
  1.932775087567818e+00, -3.313415413231939e-04, -1.181982888349463e-06, -3.560248705594841e-09, -9.328510149535927e-12, -2.084510633149121e-14, -3.601684377630722e-17,
 -2.684827943116651e-20,  1.291370793783781e-22,  8.220691209219474e-25,  3.025722515246625e-27,  8.465558865741257e-30,  1.953939116025814e+00, -2.295380707342633e-04,
 -8.375563800470286e-07, -2.626480681004780e-09, -7.370214751144570e-12, -1.858078876091804e-14, -4.109648628379136e-17, -7.358716413539548e-20, -7.357596457896485e-23,
  1.632024530486506e-25,  1.346980325681446e-27,  5.506705529030148e-30,  1.971186783326465e+00, -1.448669622111622e-04, -5.382396374034176e-07, -1.741700030734381e-09,
 -5.142691859685352e-12, -1.406396123046601e-14, -3.561053472869394e-17, -8.229059482838296e-20, -1.668043378911858e-22, -2.632498469724601e-25, -1.460244540298173e-28,
  1.150308588976622e-30,  1.984445891592694e+00, -7.873425746042014e-05, -2.965573662152147e-07, -9.822963048847663e-10, -3.008429600571268e-12, -8.692111418200489e-15,
 -2.388520976803440e-17, -6.251695528368996e-20, -1.552444261234695e-22, -3.618089660873239e-25, -7.730030104238288e-28, -1.431739609372525e-30,  1.993661118277858e+00,
 -3.223768603025302e-05, -1.225715226795947e-07, -4.124775491548006e-10, -1.294272007780536e-12, -3.872913210690667e-15, -1.117767286674678e-17, -3.130308536628558e-20,
 -8.532651510574439e-23, -2.266392010121861e-25, -5.863466345416088e-28, -1.474591545647706e-30,  1.998795881448990e+00, -6.139726175182370e-06, -2.346563030355220e-08,
 -7.965581507437123e-11, -2.532453094284469e-13, -7.719974654916386e-16, -2.284786018831190e-18, -6.613297541973134e-21, -1.880848642009322e-23, -5.272276316382880e-26,
 -1.459744522450356e-28, -3.997940844864928e-31,  4.934478430004980e-04, -2.466649698237012e-06,  9.245443648399478e-09, -3.079340574364088e-11,  9.611291463054181e-14,
 -2.878506176740740e-16,  8.376641132863466e-19, -2.386357800659350e-21,  6.687146641705108e-24, -1.849245538471547e-26,  5.058096513660372e-29, -1.370687191302758e-31,
  4.438283256240055e-03, -2.214365098108978e-05,  8.267892987586452e-08, -2.736019882029196e-10,  8.456864223246898e-13, -2.498158030429182e-15,  7.136258329751289e-18,
 -1.984431916825608e-20,  5.392286817505489e-23, -1.434825285298766e-25,  3.742083473083364e-28, -9.565379399096344e-31,  1.231330971631108e-02, -6.119881385601686e-05,
  2.267385106883245e-07, -7.405919875679155e-10,  2.243962469527996e-12, -6.441679518205533e-15,  1.768744930320194e-17, -4.662139055402406e-20,  1.179154833472747e-22,
 -2.849313504557697e-25,  6.514286859522187e-28, -1.381682614873190e-30,  2.408927722474502e-02, -1.190386436112059e-04,  4.359029109597606e-07, -1.395673650759405e-09,
  4.099642841686304e-12, -1.123972154423602e-14,  2.886677597365487e-17, -6.901406567413547e-20,  1.506163905122369e-22, -2.857266775661668e-25,  4.030759596708285e-28,
 -5.815962888954630e-32,  3.972240773579384e-02, -1.947833133800521e-04,  7.021211531785729e-07, -2.187556876596948e-09,  6.150909182204270e-12, -1.575234865582856e-14,
  3.631315667465360e-17, -7.220522266997805e-20,  1.076235329922996e-22, -3.265961784253033e-26, -5.872714927026725e-28,  3.124196705003708e-30,  5.915451182090153e-02,
 -2.872790323902468e-04,  1.015081812378479e-06, -3.052980795356055e-09,  8.092918581254077e-12, -1.876374684902314e-14,  3.597583271703144e-17, -4.537104422435402e-20,
 -3.000390773951651e-23,  4.620747403566277e-25, -2.013278436934694e-27,  6.379833349563163e-30,  8.231314474946623e-02, -3.951143207191160e-04,  1.362559123591959e-06,
 -3.920723829331529e-09,  9.610282860483944e-12, -1.918611962491750e-14,  2.515269081592502e-17,  1.399412786524508e-20, -2.416158426201520e-22,  1.031721057479420e-24,
 -3.076253569962481e-27,  6.757717547422016e-30,  1.091118024210894e-01, -5.166400060609853e-04,  1.730825308340519e-06, -4.716160749246782e-09,  1.041142712640186e-11,
 -1.625255095529488e-14,  3.301903438254850e-18,  9.782302090314149e-20, -4.665945882051996e-22,  1.399292945686685e-24, -2.839813683903118e-27,  2.030557360975310e-30,
  1.394501576714441e-01, -6.499927130420612e-04,  2.105116349800137e-06, -5.366099119548585e-09,  1.026150058646709e-11, -9.670154195479285e-15, -2.755376080513852e-17,
  1.880896045701003e-19, -6.194116453071180e-22,  1.285690775980730e-24, -7.651756437389243e-28, -7.320168828785886e-30,  1.732143375462564e-01, -7.931215715416020e-04,
  2.470136645740799e-06, -5.803607919277925e-09,  9.010591009573541e-12,  2.903558569512477e-16, -6.293739017358060e-17,  2.603736806708854e-19, -6.165659569940196e-22,
  5.425115166399274e-25,  2.838560275840239e-27, -1.736551059281969e-29,  2.102772421927944e-01, -9.438178275942746e-04,  2.810586559685662e-06, -5.972547355174387e-09,
  6.614372124974035e-12,  1.278433272226393e-14, -9.655416093558468e-17,  2.896819249243806e-19, -4.074259004814812e-22, -7.453259928002277e-25,  6.713695093500769e-27,
 -2.205097864669033e-29,  2.504989060528238e-01, -1.099746999117169e-03,  3.111695922674357e-06, -5.831521495619213e-09,  3.144963369543457e-12,  2.646720259234464e-14,
 -1.213619270364570e-16,  2.571887412297794e-19,  1.141529368996910e-24, -2.236605745076390e-24,  9.030209162125172e-27, -1.626723728435622e-29,  2.937269020524182e-01,
 -1.258483179351339e-03,  3.359746050958971e-06, -5.357004062752083e-09, -1.209347985259385e-12,  3.964629225670538e-14, -1.308951631949990e-16,  1.562170522091995e-19,
  5.354789056340803e-22, -3.413615395574361e-24,  8.145427006297416e-27,  7.797800574737944e-31,  3.397967894695659e-01, -1.417545054026213e-03,  3.542562869507024e-06,
 -4.545431387604909e-09, -6.155853720539124e-12,  5.049285438545834e-14, -1.206017467713011e-16, -4.162974901889335e-21,  1.066272700448727e-21, -3.749110458094338e-24,
  3.446615556601815e-27,  2.382810130666025e-29,  3.885326061175758e-01, -1.574433164409261e-03,  3.649964286557061e-06, -3.414113184325573e-09, -1.131989346196061e-11,
  5.728754657297108e-14, -8.893506137488758e-17, -1.990710314704269e-19,  1.439168306889613e-21, -2.907797348660700e-24, -4.114796717718340e-27,  4.281904293045368e-29,
  4.397474054084083e-01, -1.726667918223233e-03,  3.674146056984082e-06, -2.000878678894109e-09, -1.627625640265081e-11,  5.866680377771202e-14, -3.797459398939738e-17,
 -3.916548956598338e-19,  1.517629414874268e-21, -9.090557041506127e-25, -1.210558875241878e-26,  4.709125700472082e-29,  4.932438387529746e-01, -1.871827824589788e-03,
  3.609991993845270e-06, -3.624492979295290e-10, -2.058681883653701e-11,  5.383594540080406e-14,  2.657676648824203e-17, -5.402596668969395e-19,  1.226206105504518e-21,
  1.816933324170186e-24, -1.737819482310275e-26,  3.080428816458520e-29,  5.488147836132107e-01, -2.007587408433042e-03,  3.455296514535613e-06,  1.428394393212458e-09,
 -2.384103500103836e-11,  4.271787244172627e-14,  9.606282922257406e-17, -6.074950439505582e-19,  5.810379742857894e-22,  4.515401911805357e-24, -1.728767655664978e-26,
 -3.078804314415068e-30,  6.062440173416863e-01, -2.131754244927728e-03,  3.210890100232768e-06,  3.286708852907213e-09, -2.569550874492134e-11,  2.601362933496468e-14,
  1.601336935505801e-16, -5.691929660099621e-19, -3.029767693910200e-22,  6.322146982555686e-24, -1.088657561336195e-26, -4.258711981495847e-29,  6.653069367274393e-01,
 -2.242304546401122e-03,  2.880661247307125e-06,  5.120135215447779e-09, -2.590882767745615e-11,  5.162115829938872e-15,  2.084025938075570e-16, -4.211205368575456e-19,
 -1.232849114229759e-21,  6.544916624672527e-24,  4.265340786908839e-28, -7.102412219495700e-29,  7.257713229109074e-01, -2.337416733388682e-03,  2.471471822407417e-06,
  6.834228235780979e-09, -2.436815867882263e-11, -1.780050626310593e-14,  2.322228732977457e-16, -1.816936635401494e-19, -1.982561287240313e-21,  4.917415808580994e-24,
  1.315362552775137e-26, -7.422066912001283e-29,  7.873981510361084e-01, -2.415502429062713e-03,  1.992966307577959e-06,  8.338052126118994e-09, -2.110476959383970e-11,
 -4.046737860062565e-14,  2.262700286946668e-16,  1.102339384868467e-19, -2.351534200500208e-21,  1.733023629184076e-24,  2.283875377993936e-26, -4.752725240852952e-29,
  8.499424436751176e-01, -2.475234332702495e-03,  1.457279131159283e-06,  9.549702439672321e-09, -1.629660818084863e-11, -6.034671824314848e-14,  1.896324697633753e-16,
  4.023262638893625e-19, -2.220691142853647e-21, -2.199843465895017e-24,  2.571951025487761e-26,  9.357436137916148e-31,  9.131541666896599e-01, -2.515570453859198e-03,
  8.786480041734978e-07,  1.040140696281865e-08, -1.025725594251140e-11, -7.517074830033309e-14,  1.261895541598504e-16,  6.391542805158674e-19, -1.589874806401758e-21,
 -5.779870735316948e-24,  2.024956641093581e-26,  5.274689606676388e-29,  9.767791657893844e-01, -2.535774224863951e-03,  2.729447898443730e-07,  1.084387401389339e-08,
 -3.411875428359987e-12, -8.318706103215034e-14,  4.417548842574650e-17,  7.738253381986313e-19, -5.847618029595542e-22, -7.948500642581789e-24,  7.854099112109243e-27,
  8.669535388087175e-29,  1.040560141609093e+00, -2.535430055637580e-03, -3.428612111953662e-07,  1.084959370935364e-08,  3.737938122836905e-12, -8.339249349890355e-14,
 -4.502747923721607e-17,  7.782532554565979e-19,  5.703875851936306e-22, -8.030704133700233e-24, -7.444654691262775e-27,  8.811706851350182e-29,  1.104237660661815e+00,
 -2.514453951483173e-03, -9.512897144143834e-07,  1.041485534643843e-08,  1.065733550284782e-11, -7.567603648904271e-14, -1.286797171412237e-16,  6.496661149665594e-19,
  1.608055738519528e-21, -5.964360146717602e-24, -2.044432140940251e-26,  5.571819946278035e-29,  1.167551199036097e+00, -2.473098881531218e-03, -1.534965361931178e-06,
  9.560319344751459e-09,  1.682546331255712e-11, -6.084872166048731e-14, -1.947572256347756e-16,  4.117314725107385e-19,  2.286340939550495e-21, -2.335146196145375e-24,
 -2.669446994970942e-26,  2.524801008108884e-30,  1.230240215200206e+00, -2.411954662338019e-03, -2.077241024599048e-06,  8.330071114591812e-09,  2.178229488093636e-11,
 -4.055343269667715e-14, -2.339429849138986e-16,  1.098849241045727e-19,  2.452349742764837e-21,  1.801212043357610e-24, -2.417926572301588e-26, -4.969682487364980e-29,
  1.292045247760029e+00, -2.331942207083435e-03, -2.562805407630714e-06,  6.789181523685474e-09,  2.517045649086896e-11, -1.706415964358516e-14, -2.411765792409141e-16,
 -1.981991437301470e-19,  2.082079939378990e-21,  5.253354771419042e-24, -1.406524869155908e-26, -8.005641826809252e-29,  1.352709033499384e+00, -2.234302084821223e-03,
 -2.978251696910826e-06,  5.019898154757037e-09,  2.676783184959415e-11,  6.999979984099782e-15, -2.164746081330104e-16, -4.548839806147364e-19,  1.285190263654793e-21,
  7.073009649648777e-24, -2.031771352822294e-28, -7.769126486150780e-29,  1.411977640519899e+00, -2.120577434917684e-03, -3.312584713272317e-06,  3.116686581244719e-09,
  2.650754386926864e-11,  2.900794300009796e-14, -1.648642181118221e-16, -6.147903717613032e-19,  2.731354538588836e-22,  6.848507120867735e-24,  1.241111559772116e-26,
 -4.614201919531443e-29,  1.469601610802428e+00, -1.992591387452551e-03, -3.557645699965764e-06,  1.180424635284091e-09,  2.448311036893344e-11,  4.665160696143384e-14,
 -9.543590823233189e-17, -6.541315315657105e-19, -7.001024325174695e-22,  4.813129156273398e-24,  1.957689910122203e-26, -9.839542678833064e-31,  1.525337106043217e+00,
 -1.852419248913654e-03, -3.708436438260628e-06, -6.878813089607394e-10,  2.093803873273729e-11,  5.823556079372007e-14, -1.968846257888048e-17, -5.750048343098756e-19,
 -1.407343828397726e-21,  1.734598011273513e-24,  1.942860596866420e-26,  3.793314806345152e-29,  1.578947050186678e+00, -1.702355821670849e-03, -3.763327809723905e-06,
 -2.393446173438973e-09,  1.624071805929878e-11,  6.288087216429236e-14,  5.052458118416824e-17, -4.036968749213722e-19, -1.707369804583636e-21, -1.369294798268944e-24,
  1.296080620335056e-26,  5.568453222798877e-29,  1.630202261693478e+00, -1.544878332901028e-03, -3.724142100611228e-06, -3.853694772113385e-09,  1.084701892458313e-11,
  6.061382815320502e-14,  1.050593257346472e-16, -1.835205504585571e-19, -1.576993313356232e-21, -3.582370825050892e-24,  3.373882832165931e-27,  4.841692295410138e-29,
  1.678882568258901e+00, -1.382605551111893e-03, -3.596103131865892e-06, -5.003475977104430e-09,  5.254349940621197e-12,  5.232722539083230e-14,  1.371666553855779e-16,
  3.595780716547221e-20, -1.107666657822257e-21, -4.381490471568318e-24, -5.412493604608992e-27,  2.370982069036195e-29,  1.724777896442773e+00, -1.218253763331496e-03,
 -3.387653517518845e-06, -5.799133361111344e-09, -4.810817032016266e-14,  3.962057820109278e-14,  1.444834565919525e-16,  2.105748466778887e-19, -4.693109999379542e-22,
 -3.767462089418781e-24, -1.039074315270657e-26, -4.504424914449280e-30,  1.767689328499369e+00, -1.054590370532893e-03, -3.110143793213203e-06, -6.221135221266862e-09,
 -4.627786891752500e-12,  2.454377269501698e-14,  1.291547734616667e-16,  3.112178159707065e-19,  1.459171990535123e-22, -2.199642059710128e-24, -1.053551977498420e-26,
 -2.339775763456498e-29,  1.807430118613945e+00, -8.943859301707521e-04, -2.777403580379784e-06, -6.275062548847355e-09, -8.150603711416094e-12,  9.283369972001107e-15,
  9.708760811018799e-17,  3.291558437831079e-19,  5.814618330876771e-22, -3.741940868873295e-25, -6.907189543450563e-27, -2.708304255892312e-29,  1.843826660773237e+00,
 -7.403655302237425e-04, -2.405210112926424e-06, -5.990866556686037e-09, -1.041183955066177e-11, -4.160441433631949e-15,  5.651308247238807e-17,  2.759295962566762e-19,
  7.577203960490714e-22,  1.057141285102040e-24, -1.850481382299650e-27, -1.808531105035569e-29,  1.876719400636275e+00, -5.951604165378748e-04, -2.010674104391507e-06,
 -5.420429905958011e-09, -1.135268902619599e-11, -1.425685080088277e-14,  1.617276056368545e-17,  1.781358308504338e-19,  6.851125707312643e-22,  1.715033091107795e-24,
  2.243806988866674e-27, -4.315457549247797e-30,  1.905963684061036e+00, -4.612608125399940e-04, -1.611566839068554e-06, -4.633588803976434e-09, -1.106070238782856e-11,
 -2.014437804810832e-14, -1.648283825014047e-17,  6.878683150155293e-20,  4.470286710916359e-22,  1.584625218877786e-24,  3.991645896049185e-27,  6.157521472960384e-30,
  1.931430535473103e+00, -3.409708657135488e-04, -1.225615320373656e-06, -3.712887297800672e-09, -9.754114678115695e-12, -2.171803644558120e-14, -3.670612232044120e-17,
 -2.221827871277627e-20,  1.610021740475430e-22,  9.508028795855531e-25,  3.417363049794884e-27,  9.343814555016857e-30,  1.953007360360423e+00, -2.363666261402057e-04,
 -8.697941276728488e-07, -2.747431338306045e-09, -7.751861929317323e-12, -1.959208995701075e-14, -4.318892870335870e-17, -7.583670268698935e-20, -6.667015277994863e-23,
  2.221823314952656e-25,  1.608530941997823e-27,  6.401751109284709e-30,  1.970598569270857e+00, -1.492579014068980e-04, -5.596431709909822e-07, -1.826280564794113e-09,
 -5.432707402235956e-12, -1.494687566278748e-14, -3.799083186962233e-17, -8.778098781276785e-20, -1.763733461048440e-22, -2.679758512985007e-25, -8.760556961640325e-29,
  1.517131613741015e-30,  1.984126133817559e+00, -8.115469832298889e-05, -3.086395704509930e-07, -1.031853668051601e-09, -3.188149020800470e-12, -9.286935765102758e-15,
 -2.570723539669661e-17, -6.769927129905952e-20, -1.688415381070041e-22, -3.940158878015557e-25, -8.380048355000957e-28, -1.522559603200821e-30,  1.993530174536197e+00,
 -3.323841515906304e-05, -1.276481075472411e-07, -4.338204467329549e-10, -1.374485536053062e-12, -4.152011440816408e-15, -1.209364512989842e-17, -3.416873463666629e-20,
 -9.392380618822771e-23, -2.514430409420491e-25, -6.551800069980420e-28, -1.657882222093094e-30,  1.998770940941545e+00, -6.331344772568996e-06, -2.444633097843364e-08,
 -8.383430318573342e-11, -2.692489654262814e-13, -8.291242043339204e-16, -2.478678125843051e-18, -7.246699689384470e-21, -2.081599050782129e-23, -5.892943832782478e-26,
 -1.647660967414731e-28, -4.556650670471660e-31,  4.837268673463986e-04, -2.394138520360028e-06,  8.884963115122271e-09, -2.930058518520659e-11,  9.055165181375197e-14,
 -2.685249159127021e-16,  7.737445725450778e-19, -2.182641769858038e-21,  6.056429146885339e-24, -1.658480938287732e-26,  4.492159679649268e-29, -1.205514348199163e-31,
  4.351011041254915e-03, -2.149512614847544e-05,  7.947527276535070e-08, -2.604615905197691e-10,  7.973919446262077e-13, -2.333365208184353e-15,  6.604018439914172e-18,
 -1.819862477757546e-20,  4.901708415172389e-23, -1.293231843532524e-25,  3.345447222654770e-28, -8.486104832259792e-31,  1.207208684102554e-02, -5.941985347179938e-05,
  2.180626492433776e-07, -7.056966286286560e-10,  2.119270293713108e-12, -6.032428440828141e-15,  1.643336963234908e-17, -4.300730325696834e-20,  1.081126615703137e-22,
 -2.600540247222351e-25,  5.933129086931573e-28, -1.261498098957739e-30,  2.361999257772068e-02, -1.156173143989512e-04,  4.195410948086225e-07, -1.331840725799667e-09,
  3.881622687926046e-12, -1.056957241138818e-14,  2.700033407131447e-17, -6.435581501508468e-20,  1.406195245340309e-22, -2.696877325236906e-25,  3.981101576792298e-28,
 -1.627593523837215e-31,  3.895434449716669e-02, -1.892696974767118e-04,  6.764507129161811e-07, -2.091616033517924e-09,  5.844415611333705e-12, -1.490470592575415e-14,
  3.433941821705506e-17, -6.878435567423011e-20,  1.060566774248377e-22, -5.355413502134357e-26, -4.610985233890980e-28,  2.623681905291061e-30,  5.802140804425764e-02,
 -2.793027479138016e-04,  9.792107297225326e-07, -2.926449818758751e-09,  7.726174445128327e-12, -1.791566520068298e-14,  3.469439478013534e-17, -4.608002101571529e-20,
 -1.475315180553580e-23,  3.869363967492329e-25, -1.748986142213838e-27,  5.645576609228489e-30,  8.075419408972501e-02, -3.843994574264593e-04,  1.316420468527720e-06,
 -3.769996165658121e-09,  9.232624479733929e-12, -1.857859321689088e-14,  2.544170018972309e-17,  6.833518044133895e-21, -2.066182116864199e-22,  9.144982998412924e-25,
 -2.787890486768615e-27,  6.345245427389529e-30,  1.070725811390207e-01, -5.030169720734481e-04,  1.675220166090088e-06, -4.552173116186295e-09,  1.008738190169145e-11,
 -1.614207817697940e-14,  5.839331385521211e-18,  8.367624937698159e-20, -4.182414942944323e-22,  1.287669196577525e-24, -2.737221969989668e-27,  2.601195312513936e-30,
  1.368834647780934e-01, -6.334065787965806e-04,  2.041701770529773e-06, -5.203496514078375e-09,  1.006189979228797e-11, -1.027044359913252e-14, -2.255783573536013e-17,
  1.690024860311980e-19, -5.737502738599364e-22,  1.249192675086819e-24, -1.046643225753922e-27, -5.522927567020430e-30,  1.700809358322119e-01, -7.736366007547668e-04,
  2.401358299910513e-06, -5.659471637659783e-09,  9.001872237509293e-12, -1.134866659632849e-15, -5.592006479657559e-17,  2.409765198066652e-19, -5.951692487248549e-22,
  6.415023374898312e-25,  2.128671974594218e-27, -1.493669049954152e-29,  2.065464889182981e-01, -9.216179996528580e-04,  2.739559008433131e-06, -5.864795083598358e-09,
  6.847535066816800e-12,  1.056286974857841e-14, -8.862926887393302e-17,  2.762649491205390e-19, -4.296532045032064e-22, -4.956980866023441e-25,  5.779914358281729e-27,
 -2.037515143121774e-29,  2.461492632549101e-01, -1.075132450123404e-03,  3.042036543619475e-06, -5.777123137662119e-09,  3.645763577554013e-12,  2.364086394732495e-14,
 -1.141717465414943e-16,  2.560052847776897e-19, -7.304905907539324e-23, -1.889928291826943e-24,  8.299289512707306e-27, -1.686948701192995e-29,  2.887463177531933e-01,
 -1.231862616920391e-03,  3.295371522595331e-06, -5.370179390457636e-09, -4.474731456506762e-13,  3.655912225940562e-14, -1.262992172878963e-16,  1.714490174779499e-19,
  4.184515917487129e-22, -3.088214418032969e-24,  8.098718950044176e-27, -2.777738177050965e-30,  3.341829425426406e-01, -1.389424330441494e-03,  3.487459546815943e-06,
 -4.636003426961127e-09, -5.174931092764712e-12,  4.760074563524478e-14, -1.202607090051654e-16,  2.782682095644408e-20,  9.340235581012686e-22, -3.591960917544540e-24,
  4.370186302018981e-27,  1.824419094831637e-29,  3.822930091829267e-01, -1.545400320246094e-03,  3.607945647736270e-06, -3.586183246364146e-09, -1.019591195745329e-11,
  5.509132349490761e-14, -9.388024542733207e-17, -1.547207074289108e-19,  1.331965381727619e-21, -3.036206206931360e-24, -2.342930126051505e-27,  3.770277881369834e-29,
  4.328993618727060e-01, -1.697375130251980e-03,  3.648611541957543e-06, -2.251965241845627e-09, -1.511289428166398e-11,  5.762927174485799e-14, -4.826659582887210e-17,
 -3.437037958428499e-19,  1.476683146455932e-21, -1.352247568611338e-24, -1.006584544444716e-26,  4.546901444673101e-29,  4.858142519831720e-01, -1.842970803789462e-03,
  3.603701897786428e-06, -6.831950547190044e-10, -1.950492365893049e-11,  5.429675021872282e-14,  1.200772862560714e-17, -5.001059511699451e-19,  1.279441382442772e-21,
  1.150136691712900e-24, -1.593399517535046e-26,  3.460139366567646e-29,  5.408398182133245e-01, -1.979882892430945e-03,  3.470177091752203e-06,  1.053892215039698e-09,
 -2.296498879352643e-11,  4.482150846680612e-14,  7.933675809735711e-17, -5.864345235897317e-19,  7.311368351924780e-22,  3.823822581921189e-24, -1.722821458508059e-26,
  5.579891816350769e-30,  5.977686145801839e-01, -2.105916310408909e-03,  3.247881668180746e-06,  2.879946272254000e-09, -2.513809978226352e-11,  2.966470078730974e-14,
  1.440941528340749e-16, -5.753341943533946e-19, -8.364185350874127e-23,  5.852231081503748e-24, -1.253471250343170e-26, -3.236221135988911e-29,  6.563841883156226e-01,
 -2.219020527541669e-03,  2.939619898583290e-06,  4.706687581639958e-09, -2.575654595540379e-11,  1.001804127715741e-14,  1.960943121044976e-16, -4.568045397200646e-19,
 -9.976603117434753e-22,  6.501453099180123e-24, -2.548670679372052e-27, -6.402214107614603e-29,  7.164617095372791e-01, -2.317323569091748e-03,  2.551132445546846e-06,
  6.441790577972524e-09, -2.466888373899327e-11, -1.229520827158166e-14,  2.262745632127906e-16, -2.422080508049821e-19, -1.796852973993959e-21,  5.378032024056049e-24,
  9.875705961165607e-27, -7.442683091132704e-29,  7.777686542898327e-01, -2.399164272186229e-03,  2.090971125005973e-06,  7.994196985403897e-09, -2.185960602661489e-11,
 -3.500829860955802e-14,  2.283137033421017e-16,  3.615513128947522e-20, -2.273229473749426e-21,  2.602137429089598e-24,  2.055595260015811e-26, -5.589823414737268e-29,
  8.400655422110055e-01, -2.463122236715561e-03,  1.570272068339129e-06,  9.279552199409706e-09, -1.745716006195253e-11, -5.566845344264886e-14,  1.998922448368577e-16,
  3.301954289813603e-19, -2.281394539399987e-21, -1.174292206375384e-24,  2.545923450708315e-26, -1.262538825709395e-29,  9.031067296611736e-01, -2.508044905425890e-03,
  1.002431127859072e-06,  1.022543407810040e-08, -1.172896632035021e-11, -7.193337871380806e-14,  1.433434691794131e-16,  5.851097251775586e-19, -1.782845032021616e-21,
 -4.927207465744858e-24,  2.228939514779883e-26,  3.982053575940325e-29,  9.666412586646400e-01, -2.533071214656316e-03,  4.026890411367753e-07,  1.077603900752303e-08,
 -5.063271537435907e-12, -8.186922054313295e-14,  6.553808235215273e-17,  7.506026215552609e-19, -8.643485996351072e-22, -7.559730442631257e-24,  1.153845381134521e-26,
  8.038943644208433e-29,  1.030413761444100e+00, -2.537651275211066e-03, -2.123624535393648e-07,  1.089600664716465e-08,  2.061056255172193e-12, -8.420986638417092e-14,
 -2.302468206851538e-17,  7.918301595421397e-19,  2.768678213443708e-22, -8.249737880128900e-24, -3.481737395175988e-27,  9.158793876602342e-29,  1.094165419688884e+00,
 -2.521561573433231e-03, -8.253388186307625e-07,  1.057310303713444e-08,  9.114434272985889e-12, -7.854045107475766e-14, -1.098020324783044e-16,  6.975356097977134e-19,
  1.379242663684328e-21, -6.729500625079912e-24, -1.772622480790996e-26,  6.758442036822312e-29,  1.157634976985435e+00, -2.484915226692078e-03, -1.418667257061271e-06,
  9.819541066221246e-09,  1.556272332289229e-11, -6.537637092613316e-14, -1.822185682020427e-16,  4.833437345306059e-19,  2.183122049487364e-21, -3.396345775940092e-24,
 -2.625694413796570e-26,  1.742285232272067e-29,  1.220559802060508e+00, -2.428166885954442e-03, -1.975216821112200e-06,  8.671795428148519e-09,  2.091537518875894e-11,
 -4.612222216409418e-14, -2.297591608849468e-16,  1.892068587217846e-19,  2.499285746693799e-21,  7.934587866108008e-25, -2.612683222599944e-26, -3.850195442890720e-29,
  1.282676999651644e+00, -2.352111951256759e-03, -2.478931151423281e-06,  7.188862318531484e-09,  2.477088104008759e-11, -2.291129296113956e-14, -2.457657661940006e-16,
 -1.286620935418364e-19,  2.260230111757129e-21,  4.620911962901988e-24, -1.753717479211325e-26, -7.734725869472364e-29,  1.343724564935747e+00, -2.257879853649971e-03,
 -2.915439513222734e-06,  5.449016934384061e-09,  2.685487088174539e-11,  1.656630672115621e-15, -2.285973657315434e-16, -4.096922145577583e-19,  1.538830213434290e-21,
  6.994530461303241e-24, -3.766911531347117e-27, -8.401847772832607e-29,  1.403442576528230e+00, -2.146921258949662e-03, -3.272621317172726e-06,  3.545227739007668e-09,
  2.704674705557166e-11,  2.484585099048822e-14, -1.819182606202377e-16, -6.020136600094072e-19,  5.280971606514418e-22,  7.300913874123786e-24,  1.012439321128085e-26,
 -5.778254915567643e-29,  1.461574422127638e+00, -2.020989163192948e-03, -3.541099855927948e-06,  1.579487939101880e-09,  2.539174193542246e-11,  4.413899090061331e-14,
 -1.140381122503226e-16, -6.736115860284710e-19, -5.127735610518834e-22,  5.592166912590051e-24,  1.929408871096782e-26, -1.208869284280153e-29,  1.517868049942238e+00,
 -1.882113975252328e-03, -3.714642625119463e-06, -3.435862380751170e-10,  2.209669457082132e-11,  5.756481025353802e-14, -3.640861250782277e-17, -6.188875444072218e-19,
 -1.330521236265993e-21,  2.543584747082143e-24,  2.097937088654778e-26,  3.225258781327030e-29,  1.572077238116094e+00, -1.732572816102216e-03, -3.790448350849572e-06,
 -2.123471815706195e-09,  1.750951373035766e-11,  6.395160426184771e-14,  3.844949766716708e-17, -4.590165412347546e-19, -1.746737489229574e-21, -8.013653562518342e-25,
  1.544559622323062e-26,  5.704344508172938e-29,  1.623962873495297e+00, -1.574853403651846e-03, -3.769304680186673e-06, -3.670309110679417e-09,  1.208406352842088e-11,
  6.306776853057280e-14,  9.919507991827514e-17, -2.360174551583777e-19, -1.702998787916313e-21, -3.402914845100461e-24,  5.645428741850180e-27,  5.479915674860288e-29,
  1.673294230264169e+00, -1.411613033129678e-03, -3.655605309878373e-06, -4.910854888296139e-09,  6.333874674217704e-12,  5.562715443369772e-14,  1.376532412263486e-16,
 -2.050883043018249e-21, -1.269026776501873e-21, -4.575015769783122e-24, -4.210236554449558e-27,  3.105896690068132e-29,  1.719850238261511e+00, -1.245633301501237e-03,
 -3.457220970956383e-06, -5.793373420389015e-09,  7.794476942805273e-13,  4.315710908221394e-14,  1.501483376862758e-16,  1.933063083824027e-19, -6.124570775409469e-22,
 -4.185760907314292e-24, -1.049030481343333e-26,  1.505908578435808e-31,  1.763420730183781e+00, -1.079771355711775e-03, -3.185224930854126e-06, -6.291081418758699e-09,
 -4.105206044557497e-12,  2.774850795429765e-14,  1.379217472363849e-16,  3.145368296100678e-19,  5.889721906524664e-23, -2.641553495008596e-24, -1.155636557437892e-26,
 -2.288916245396828e-29,  1.803807656421049e+00, -9.169085638313858e-04, -2.853480243147333e-06, -6.403857095580890e-09, -7.940877954168477e-12,  1.172615708394047e-14,
  1.065620475984282e-16,  3.474913857884942e-19,  5.627234152644785e-22, -6.750897719098072e-25, -8.156639378148341e-27, -2.969632188152459e-29,  1.840826255978812e+00,
 -7.598976105740815e-04, -2.478102548086488e-06, -6.158045290477433e-09, -1.048084512370348e-11, -2.708640578602489e-15,  6.458418000479444e-17,  3.007696623304277e-19,
  7.942445408895488e-22,  9.662334098941991e-25, -2.719648541275371e-27, -2.148157013793923e-29,  1.874306171843960e+00, -6.115090994647026e-04, -2.076818457874736e-06,
 -5.604331196065112e-09, -1.163352751991912e-11, -1.380631588281523e-14,  2.147689719121399e-17,  2.010642071880165e-19,  7.484180659190392e-22,  1.800380495661737e-24,
  2.007784523841001e-27, -6.482779576974141e-30,  1.904092499300851e+00, -4.743787987819084e-04, -1.668245095197737e-06, -4.813803951671963e-09, -1.146738123963128e-11,
 -2.051518350930269e-14, -1.434773938145710e-17,  8.403583455662547e-20,  5.070138342889562e-22,  1.749638282373771e-24,  4.256872692017103e-27,  5.863625770382786e-30,
  1.930046756196192e+00, -3.509566933094207e-04, -1.271120852458902e-06, -3.872476083894716e-09, -1.019733212092004e-11, -2.260583394812505e-14, -3.725076657743649e-17,
 -1.649134449410610e-20,  1.977930952699838e-22,  1.095987834952217e-24,  3.848578195896643e-27,  1.026261770225435e-29,  1.952047765328595e+00, -2.434589945217469e-04,
 -9.035205976700320e-07, -2.874652908134857e-09, -8.154242281895716e-12, -2.065433860866720e-14, -4.534093034710454e-17, -7.782918449251863e-20, -5.744292863245451e-23,
  2.924482269602768e-25,  1.912205678435428e-27,  7.423743762348871e-30,  1.969992442460646e+00, -1.538242089836546e-04, -5.820901054015675e-07, -1.915645770644210e-09,
 -5.740965136389518e-12, -1.588879674034337e-14, -4.052916910220283e-17, -9.357982734721072e-20, -1.860663360456960e-22, -2.700198029422071e-25, -1.134031972533380e-29,
  1.963831285235184e-30,  1.983796497127123e+00, -8.367422537637597e-05, -3.213341165263827e-07, -1.084384139993148e-09, -3.380214226326310e-12, -9.927280241895853e-15,
 -2.768063530658197e-17, -7.333575567186314e-20, -1.836458568180010e-22, -4.289020158599600e-25, -9.069387933189211e-28, -1.609998044045011e-30,  1.993395144999232e+00,
 -3.428080367610486e-05, -1.329886958343494e-07, -4.564926387591633e-10, -1.460507525801662e-12, -4.454087795688671e-15, -1.309384527933432e-17, -3.732433180419785e-20,
 -1.034656005984556e-22, -2.791683011076448e-25, -7.325909038416591e-28, -1.864966886108108e-30,  1.998745217944671e+00, -6.531013984284225e-06, -2.547874840107143e-08,
 -8.827824906986782e-11, -2.864431652743411e-13, -8.911246477679527e-16, -2.691239508177458e-18, -7.948067034403823e-21, -2.306107903546679e-23, -6.593934586769918e-26,
 -1.861977170296578e-28, -5.200032756622200e-31,  4.742902800721702e-04, -2.324441015182939e-06,  8.541875037484915e-09, -2.789373417149798e-11,  8.536201284721915e-14,
 -2.506670532888558e-16,  7.152565399573942e-19, -1.998052202757328e-21,  5.490481378235512e-24, -1.488965008808219e-26,  3.994118378782740e-29, -1.061556598434728e-31,
  4.266282647536267e-03, -2.087161272370190e-05,  7.642477071430949e-08, -2.480682163152653e-10,  7.522692285141825e-13, -2.180810469020805e-15,  6.115734701696413e-18,
 -1.670205684353620e-20,  4.459358747272259e-23, -1.166593050954397e-25,  2.993417865426884e-28, -7.534988629014295e-31,  1.183784359846620e-02, -5.770865830657888e-05,
  2.097938265577993e-07, -6.727324658711242e-10,  2.002470177333601e-12, -5.652095577490946e-15,  1.527622423814967e-17, -3.969301539240956e-20,  9.916482952197176e-23,
 -2.373983166666901e-25,  5.402804122143462e-28, -1.150564626476440e-30,  2.316413622739283e-02, -1.123238740339577e-04,  4.039247783564371e-07, -1.271391289576069e-09,
  3.676567951115556e-12, -9.942688328707276e-15,  2.525993107122472e-17, -6.000827247831511e-20,  1.311954508406922e-22, -2.539313307640666e-25,  3.891400654584021e-28,
 -2.410812449149285e-31,  3.820793217059706e-02, -1.839569220293975e-04,  6.519026905837840e-07, -2.000446006034814e-09,  5.554408924253833e-12, -1.410328983435369e-14,
  3.246065570453245e-17, -6.542473099060902e-20,  1.038233576059352e-22, -6.982022716497330e-26, -3.553254293033371e-28,  2.195243890233439e-30,  5.691964494540737e-02,
 -2.716074570879341e-04,  9.448233656536573e-07, -2.805652732059406e-09,  7.376083063565754e-12, -1.709852356029281e-14,  3.339954536997494e-17, -4.634227487674514e-20,
 -2.024677015433678e-24,  3.217449397466675e-25, -1.515413329400393e-27,  4.982812120291337e-30,  7.923737597617517e-02, -3.740465702439806e-04,  1.272054692230326e-06,
 -3.625213520924568e-09,  8.867170386907123e-12, -1.796641381795387e-14,  2.554527268140001e-17,  7.275023430791775e-22, -1.756374158424243e-22,  8.084403536559530e-25,
 -2.518151642744603e-27,  5.913673890047691e-30,  1.050869746495004e-01, -4.898309957690689e-04,  1.621551850364422e-06, -4.393349353849472e-09,  9.766123918349996e-12,
 -1.597528928195548e-14,  8.001713723433103e-18,  7.101331944145719e-20, -3.738274303617017e-22,  1.180597738106341e-24, -2.613460449274367e-27,  2.998575330523752e-30,
  1.343821140684568e-01, -6.173200114226211e-04,  1.980218885271213e-06, -5.044177231688428e-09,  9.851449790364606e-12, -1.075708024944661e-14, -1.807610583943843e-17,
  1.513534850725900e-19, -5.295872132190619e-22,  1.202932181426626e-24, -1.255347603849622e-27, -4.007479978151893e-30,  1.670243844960085e-01, -7.546949426723606e-04,
  2.334307840950728e-06, -5.515693924633731e-09,  8.966289593580732e-12, -2.398110340718998e-15, -4.943577633994386e-17,  2.223157972977303e-19, -5.706948016565518e-22,
  7.141726687257568e-25,  1.520979972737514e-27, -1.272134957791247e-29,  2.029034067890866e-01, -8.999811599022295e-04,  2.669845435038854e-06, -5.753657434041178e-09,
  7.038139912505113e-12,  8.527023756067270e-15, -8.108870953193494e-17,  2.622734224592898e-19, -4.435481941525726e-22, -2.819189395830154e-25,  4.921822497073583e-27,
 -1.862146093859733e-29,  2.418969684239017e-01, -1.051072433058435e-03,  2.973076186625780e-06, -5.715154830512047e-09,  4.091758633627252e-12,  2.098643504867105e-14,
 -1.070461044782270e-16,  2.526417301379234e-19, -1.352905530473629e-22, -1.572870302726343e-24,  7.552696110120060e-27, -1.699649439420450e-29,  2.838711849963365e-01,
 -1.205757480554998e-03,  3.230910012543092e-06, -5.371652537282140e-09,  2.537937259821653e-13,  3.358696053734855e-14, -1.213274477991583e-16,  1.831228860621395e-19,
  3.130693551470302e-22, -2.767594162797796e-24,  7.911665758537927e-27, -5.611136811283276e-30,  3.286806903443000e-01, -1.361748518476876e-03,  3.431361621685181e-06,
 -4.711342700951130e-09, -4.251698686472496e-12,  4.472709762054695e-14, -1.190823059788134e-16,  5.568182172285001e-20,  8.080390731613970e-22, -3.402615469718593e-24,
  5.060608608973631e-27,  1.323617944557579e-29,  3.761688586765418e-01, -1.516711582211589e-03,  3.563968601136501e-06, -3.740627033352192e-09, -9.116943191932966e-12,
  5.279092626941323e-14, -9.763224729961404e-17, -1.138616033700657e-19,  1.221361035900973e-21, -3.098261556797493e-24, -7.972944551618351e-28,  3.256221163345646e-29,
  4.261680622986143e-01, -1.668298355783451e-03,  3.620174943935133e-06, -2.484616983109643e-09, -1.397264495440602e-11,  5.636068099258624e-14, -5.723659797591960e-17,
 -2.973026638485031e-19,  1.421230980017498e-21, -1.715538201163808e-24, -8.116594535805597e-27,  4.301352481853853e-29,  4.784999686945743e-01, -1.814179204699540e-03,
  3.593666958226931e-06, -9.865753724747145e-10, -1.841721698321044e-11,  5.442156050109607e-14, -1.416683238641041e-18, -4.586213306443225e-19,  1.309748243247291e-21,
  5.440311890089607e-25, -1.435375216883695e-26,  3.701029845130308e-29,  5.329758808449568e-01, -1.952077066574242e-03,  3.480649061586183e-06,  6.937217571210711e-10,
 -2.205083364977780e-11,  4.653131490697042e-14,  6.326389048654174e-17, -5.609680069259180e-19,  8.564701466729769e-22,  3.141875355891977e-24, -1.681525906368446e-26,
  1.297804214604105e-29,  5.893971247290782e-01, -2.079801810921631e-03,  3.280047938251597e-06,  2.482665446474674e-09, -2.451152877762393e-11,  3.292953686031868e-14,
  1.279782909430733e-16, -5.747392251044143e-19,  1.176971419309893e-22,  5.325305087681440e-24, -1.373963493501778e-26, -2.248720862027327e-29,  6.475554879637181e-01,
 -2.195284636262694e-03,  2.993634949328255e-06,  4.296437029019467e-09, -2.551017625720264e-11,  1.456742632957986e-14,  1.828918475103786e-16, -4.850098826354650e-19,
 -7.661012007130790e-22,  6.345455855810718e-24, -5.193059785744018e-27, -5.604631240133280e-29,  7.072337134610341e-01, -2.296612030299640e-03,  2.626058554013203e-06,
  6.045413846455445e-09, -2.486106414814283e-11, -6.952316617511472e-15,  2.187173601246548e-16, -2.965397437592101e-19, -1.596919210497703e-21,  5.707957089146283e-24,
  6.633702407378532e-27, -7.262457209451426e-29,  7.682060518362512e-01, -2.382058778820949e-03,  2.184780826159257e-06,  7.639139879742575e-09, -2.250493680469889e-11,
 -2.952474949331510e-14,  2.283228259103466e-16, -3.493562231209161e-20, -2.165363478465725e-21,  3.373184133848002e-24,  1.795069505223281e-26, -6.217050027212376e-29,
  8.302388760502464e-01, -2.450119472918373e-03,  1.679914918762474e-06,  8.991594339965489e-09, -1.852184888377861e-11, -5.076837549090048e-14,  2.081106906885590e-16,
  2.567096427509631e-19, -2.305506779440389e-21, -1.708043456683458e-25,  2.462400215253076e-26, -2.513559339009259e-29,  8.930913614239910e-01, -2.499537933943261e-03,
  1.123963500418594e-06,  1.002645364848627e-08, -1.313193842381350e-11, -6.830314301956758e-14,  1.589024063572381e-16,  5.253958768710517e-19, -1.943789982240231e-21,
 -4.004561963620848e-24,  2.374370525377353e-26,  2.621153777508684e-29,  9.565162337020177e-01, -2.529333953515458e-03,  5.314616976891080e-07,  1.068202013561459e-08,
 -6.683241649693263e-12, -8.004747768375426e-14,  8.612748879650136e-17,  7.186849191729635e-19, -1.127359922506642e-21, -7.029803539040833e-24,  1.489590893293339e-26,
  7.188455924902627e-29,  1.020260587262993e+00, -2.538826734069591e-03, -8.146816750820318e-08,  1.091548749715328e-08,  3.731328813306968e-13, -8.449567785067627e-14,
 -7.741942270988106e-19,  7.959191141695597e-19, -2.165406068022680e-23, -8.307971736859968e-24,  5.760896495879977e-28,  9.241745770394004e-29,  1.084066774871301e+00,
 -2.527654416188778e-03, -6.976388786424916e-07,  1.070623105883327e-08,  7.518879582492354e-12, -8.093656914301452e-14, -8.969049577443013e-17,  7.376643425277292e-19,
  1.124963132812478e-21, -7.375948671124836e-24, -1.452218930661827e-26,  7.773676141290305e-29,  1.147673369530830e+00, -2.495789094609069e-03, -1.299382648012330e-06,
  1.005785154896628e-08,  1.421259996410172e-11, -6.957943907999963e-14, -1.677267211750123e-16,  5.510464058674525e-19,  2.042173671057041e-21, -4.426864439777690e-24,
 -2.515961621917636e-26,  3.243136961149667e-29,  1.210816198040639e+00, -2.443546757403430e-03, -1.869178805811970e-06,  8.998764233786033e-09,  1.993826446015847e-11,
 -5.156381199915410e-14, -2.233388507632246e-16,  2.694362419389870e-19,  2.508664258426462e-21, -2.817826566877632e-25, -2.754026183309492e-26, -2.546696497336716e-29,
  1.273229444765205e+00, -2.371591634309983e-03, -2.390302961577596e-06,  7.581209053838075e-09,  2.425342246464453e-11, -2.884458011494958e-14, -2.483317167721774e-16,
 -5.381505075994099e-20,  2.413148023120570e-21,  3.852717643814677e-24, -2.083431407858455e-26, -7.209816398425265e-29,  1.334646822927351e+00, -2.280934511855567e-03,
 -2.847473125033949e-06,  5.878658041242900e-09,  2.683224068608023e-11, -3.961566833847830e-15, -2.393417470630146e-16, -3.564571997760880e-19,  1.787016665946668e-21,
  6.768459578526907e-24, -7.569061130891881e-27, -8.846508355440916e-29,  1.394802809422431e+00, -2.172924665644193e-03, -3.227466482318413e-06,  3.981708112965913e-09,
  2.749864923526863e-11,  2.027969127030841e-14, -1.984980155786845e-16, -5.808362395400957e-19,  7.975761465588180e-22,  7.651670293410121e-24,  7.330901887883468e-27,
 -6.910615588850603e-29,  1.453433937755882e+00, -2.049235173972318e-03, -3.519679760992902e-06,  1.992662899207383e-09,  2.624561608137329e-11,  4.117407983803005e-14,
 -1.330976395195001e-16, -6.866515525152116e-19, -2.977241365101140e-22,  6.349746485760305e-24,  1.849512145133981e-26, -2.440977496280619e-29,  1.510280142246739e+00,
 -1.911841510931329e-03, -3.716606554617170e-06,  1.911779064101460e-11,  2.323782458750428e-11,  5.647833664041140e-14, -5.431860120027505e-17, -6.598345049297895e-19,
 -1.223523797535130e-21,  3.409053776716569e-24,  2.223895629850513e-26,  2.468310218810774e-29,  1.565086145146409e+00, -1.762993469458407e-03, -3.814206741064591e-06,
 -1.833041684965409e-09,  1.879669990528949e-11,  6.471382417344799e-14,  2.481103772732326e-17, -5.152495706242368e-19, -1.763859938880636e-21, -1.332570557890689e-25,
  1.795912696402506e-26,  5.694394213834860e-29,  1.617602876830027e+00, -1.605180632373593e-03, -3.812146282097970e-06, -3.466746259985445e-09,  1.336865813069811e-11,
  6.536287902247907e-14,  9.180556971842229e-17, -2.924250874240357e-19, -1.820841384398787e-21, -3.127064265327608e-24,  8.191067850158957e-27,  6.083126230819895e-29,
  1.667588917766874e+00, -1.441091788110398e-03, -3.713890221456347e-06, -4.800433153014742e-09,  7.479425524008406e-12,  5.892540104894492e-14,  1.370023169470753e-16,
 -4.532464106041101e-20, -1.436408334957548e-21, -4.713774415963092e-24, -2.669150997778819e-27,  3.909522840337640e-29,  1.714811949610999e+00, -1.273568872303463e-03,
 -3.526637502175409e-06, -5.773799527774528e-09,  1.679051848695014e-12,  4.682326333300590e-14,  1.552633033642592e-16,  1.712158061218478e-19, -7.706813944000349e-22,
 -4.603632507112162e-24, -1.036146993388935e-26,  5.891683190414982e-30,  1.759050201520552e+00, -1.105556200321670e-03, -3.261093102874361e-06, -6.352142107175301e-09,
 -3.516420580577834e-12,  3.116443612832118e-14,  1.467402209460042e-16,  3.148088385320820e-19, -4.475923000228983e-23, -3.123633861991386e-24, -1.253830062564880e-26,
 -2.160242971774023e-29,  1.800093876764053e+00, -9.400459320928320e-04, -2.931080654069740e-06, -6.528892656387757e-09, -7.679981398126207e-12,  1.440241336820331e-14,
  1.165397889404308e-16,  3.650441136397738e-19,  5.322257191435457e-22, -1.028230728893116e-24, -9.518458268514024e-27, -3.217260058553594e-29,  1.837746543854938e+00,
 -7.800208714781396e-04, -2.553006759654410e-06, -6.326085061777106e-09, -1.051882061013329e-11, -1.054658320497608e-15,  7.336662064774552e-17,  3.267191295156694e-19,
  8.268332267010259e-22,  8.374646444027296e-25, -3.746125610655332e-27, -2.523454613629586e-29,  1.871826475926903e+00, -6.283958401385413e-04, -2.145196266970524e-06,
 -5.792646677458505e-09, -1.190402912608490e-11, -1.322054606947412e-14,  2.745183700967109e-17,  2.260655032055789e-19,  8.146019807394775e-22,  1.874250608485738e-24,
  1.666641921172161e-27, -9.103299752894740e-30,  1.902167921890365e+00, -4.879589725613922e-04, -1.727125209575780e-06, -5.000582356557289e-09, -1.188092804763078e-11,
 -2.082940046476974e-14, -1.175788759072125e-17,  1.013014287529429e-19,  5.731267224691072e-22,  1.924935986940745e-24,  4.504150488290447e-27,  5.332395477331167e-30,
  1.928622293219656e+00, -3.613143473326374e-04, -1.318584586943847e-06, -4.039299049913230e-09, -1.065842253122788e-11, -2.350464067654833e-14, -3.761776440771631e-17,
 -9.500065636177706e-21,  2.401309781125726e-22,  1.259239101973499e-24,  4.320877591830065e-27,  1.120864593919467e-29,  1.951059251374216e+00, -2.508273923790145e-04,
 -9.388130652434900e-07, -3.008485347936699e-09, -8.578388424181256e-12, -2.176886898465418e-14, -4.754419017047042e-17, -7.948348723856706e-20, -4.545628211549184e-23,
  3.758009902753315e-25,  2.263903428187211e-27,  8.587040350313640e-30,  1.969367684357137e+00, -1.585744668651818e-04, -6.056396475670393e-07, -2.010097173441119e-09,
 -6.068683826149380e-12, -1.689362141737562e-14, -4.323422293504915e-17, -9.968939108053281e-20, -1.957730183281287e-22, -2.685932278746863e-25,  8.661377956301315e-29,
  2.505724267303459e-30,  1.983456575148362e+00, -8.629788349306788e-05, -3.346778976367648e-07, -1.140092738290368e-09, -3.585573002570323e-12, -1.061693488735499e-14,
 -2.981868175465545e-17, -7.946661225188221e-20, -1.997566207678904e-22, -4.666207473043444e-25, -9.795862745667660e-28, -1.690729436985700e-30,  1.993255858702051e+00,
 -3.536702903042347e-05, -1.386098122156316e-07, -4.805908497731841e-10, -1.552818429887849e-12, -4.781264681993028e-15, -1.418683128862057e-17, -4.080185203297879e-20,
 -1.140635057275334e-22, -3.101799198033612e-25, -8.196941091469279e-28, -2.098992868736055e-30,  1.998718679407804e+00, -6.739160617680601e-06, -2.656618565425840e-08,
 -9.300750622868219e-11, -3.049300223916787e-13, -9.584705812790516e-16, -2.924484125928334e-18, -8.725486073410956e-21, -2.557466247225110e-23, -7.386592722914221e-26,
 -2.106715083858651e-28, -5.941925489758693e-31,  4.651270983724371e-04, -2.257422070703072e-06,  8.215182510521618e-09, -2.656713467044533e-11,  8.051590231242109e-14,
 -2.341528727765049e-16,  6.616923777375151e-19, -1.830633796161332e-21,  4.982120975970671e-24, -1.338159787544926e-26,  3.555290048125096e-29, -9.359242580081045e-32,
  4.184000424353807e-03, -2.027192047893760e-05,  7.351875603484045e-08, -2.363730195674297e-10,  7.100837323908627e-13, -2.039487276378793e-15,  5.667439784858370e-18,
 -1.534001019610934e-20,  4.060162163123769e-23, -1.053232574153360e-25,  2.680713996210573e-28, -6.696138815381848e-31,  1.161031529657992e-02, -5.606206264420536e-05,
  2.019096072308774e-07, -6.415777296557048e-10,  1.893006356059456e-12, -5.298452219037181e-15,  1.420799002370223e-17, -3.665240848741067e-20,  9.099557185004736e-23,
 -2.167689227329085e-25,  4.919327644115183e-28, -1.048477508184782e-30,  2.272120829411579e-02, -1.091525174642092e-04,  3.890145763878604e-07, -1.214124656391524e-09,
  3.483642885562626e-12, -9.356146699700962e-15,  2.363712202002010e-17, -5.595330020117274e-20,  1.223313792197255e-22, -2.385960668039974e-25,  3.772079841863845e-28,
 -2.981467873470785e-31,  3.748238499660507e-02, -1.788362322788483e-04,  6.284213890249782e-07, -1.913790277044987e-09,  5.279987231698854e-12, -1.334584379781721e-14,
  3.067487973764877e-17, -6.214516096241075e-20,  1.010762465200893e-22, -8.221337758098634e-26, -2.669965749537594e-28,  1.829276757831117e-30,  5.584812185980267e-02,
 -2.641815609082357e-04,  9.118524916916953e-07, -2.690328054981973e-09,  7.042023385058666e-12, -1.631250250232961e-14,  3.210271492366906e-17, -4.623302047337485e-20,
  8.518233242419749e-24,  2.653332453991621e-25, -1.309509303036482e-27,  4.387141219363921e-30,  7.776127042330867e-02, -3.640417581773374e-04,  1.229391628398642e-06,
 -3.486180114072125e-09,  8.513971455280015e-12, -1.735369172831878e-14,  2.549119677482674e-17, -4.446172195563063e-21, -1.482850951169426e-22,  7.127896438982753e-25,
 -2.267569952550121e-27,  5.476381699336166e-30,  1.031532653197455e-01, -4.770668295608223e-04,  1.569758697912440e-06, -4.239636330983301e-09,  9.448692780168263e-12,
 -1.576070088069322e-14,  9.828859049870238e-18,  5.971095337546104e-20, -3.331750181836709e-22,  1.078782788947699e-24, -2.475421923488245e-27,  3.255090848090175e-30,
  1.319441379286763e-01, -6.017177177501167e-04,  1.920627325499572e-06, -4.888297332183186e-09,  9.632303461265502e-12, -1.114192734622216e-14, -1.406902403526107e-17,
  1.350895706502517e-19, -4.872244229856347e-22,  1.149581185647085e-24, -1.402991268737810e-27, -2.742343643088384e-30,  1.640425378957705e-01, -7.362827984759575e-04,
  2.268978491780738e-06, -5.372679373415884e-09,  8.906956449781861e-12, -3.511910347779842e-15, -4.346266263126056e-17,  2.044756106703874e-19, -5.440188497343466e-22,
  7.644210811972244e-25,  1.005998760444735e-27, -1.072246649645189e-29,  1.993457651173568e-01, -8.788966453183254e-04,  2.601482499331488e-06, -5.639786143436915e-09,
  7.189805609458981e-12,  6.667406668582220e-15, -7.394502727103673e-17,  2.479539200165528e-19, -4.503462719846147e-22, -1.009108205096107e-25,  4.141500062429409e-27,
 -1.684873693777760e-29,  2.377398151710511e-01, -1.027561007034556e-03,  2.904900542921958e-06, -5.646466055188518e-09,  4.486366518115314e-12,  1.850167668034894e-14,
 -1.000408513366006e-16,  2.474633056583778e-19, -1.866557663216616e-22, -1.285669736023371e-24,  6.809174563770243e-27, -1.674490489581630e-29,  2.790994415522053e-01,
 -1.180167920711521e-03,  3.166496206010108e-06, -5.362374372433120e-09,  8.968351398525115e-13,  3.073767324836450e-14, -1.160742976844090e-16,  1.916075243371344e-19,
  2.190665280297086e-22, -2.456752365722559e-24,  7.614537203660430e-27, -7.793626668736992e-30,  3.232882384500076e-01, -1.334524859435920e-03,  3.374446364652441e-06,
 -4.772368246419254e-09, -3.385595575616789e-12,  4.189064147731154e-14, -1.171793436868096e-16,  7.961929146626312e-20,  6.893166168514099e-22, -3.189884996057963e-24,
  5.543793691655479e-27,  8.825900767521456e-30,  3.701587481614978e-01, -1.488381783898642e-03,  3.518240277029198e-06, -3.878179894497574e-09, -8.084792257138924e-12,
  5.041380806410092e-14, -1.002899983329634e-16, -7.656609101047564e-20,  1.109581262508866e-21, -3.102989371626477e-24,  5.243197027602296e-28,  2.754101504941219e-29,
  4.195525975905163e-01, -1.639459933236939e-03,  3.589055114991761e-06, -2.699238968558936e-09, -1.285981609057030e-11,  5.489218890215117e-14, -6.493407112399054e-17,
 -2.528704318619252e-19,  1.354075939809408e-21, -2.003218137804868e-24, -6.289859954016673e-27,  3.993313343843191e-29,  4.713006686041878e-01, -1.785482151447183e-03,
  3.580095901448595e-06, -1.272549522555445e-09, -1.733014139114803e-11,  5.423821360021011e-14, -1.366914043234596e-17, -4.165036233169911e-19,  1.319395173701725e-21,
  2.878377558081983e-27, -1.269540846327121e-26,  3.817719657791018e-29,  5.252233073128705e-01, -1.924204502026676e-03,  3.486887806080829e-06,  3.484306418191383e-10,
 -2.110627986096003e-11,  4.786435992435975e-14,  4.795657027229627e-17, -5.318798239731902e-19,  9.576256644760846e-22,  2.482575168067006e-24, -1.610533590304102e-26,
  1.907631869786409e-29,  5.811305775898741e-01, -2.053448875500012e-03,  3.307509075994461e-06,  2.095911133992203e-09, -2.382352382188723e-11,  3.580850236005901e-14,
  1.119663748957522e-16, -5.680133787974510e-19,  2.993025367763805e-22,  4.758711269215404e-24, -1.452249991532378e-26, -1.321490966616574e-29,  6.388225643422798e-01,
 -2.171136242789786e-03,  3.042753591062153e-06,  3.890838823640713e-09, -2.517604711641932e-11,  1.879130665254379e-14,  1.690023860320265e-16, -5.059149037397623e-19,
 -5.419754381699039e-22,  6.090909557752722e-24, -7.471605217055903e-27, -4.744980430051972e-29,  6.980897321698876e-01, -2.275320152941330e-03,  2.696213185387267e-06,
  5.646806732364770e-09, -2.494831989754341e-11, -1.808320241646776e-15,  2.097300481333919e-16, -3.443083600242456e-19, -1.387418341825266e-21,  5.910326207084675e-24,
  3.510751974438728e-27, -6.905953913285656e-29,  7.587133450901875e-01, -2.364220017785745e-03,  2.274271507639241e-06,  7.274634191940997e-09, -2.304075352289308e-11,
 -2.406445296885090e-14,  2.263937579135325e-16, -1.021511559020152e-19, -2.031676367312467e-21,  4.035130509106238e-24,  1.511652430243323e-26, -6.630384030024073e-29,
  8.204659529465481e-01, -2.436253670376145e-03,  1.786003331597396e-06,  8.687395487969410e-09, -1.948673069521394e-11, -4.569580012949721e-14,  2.142661110228979e-16,
  1.830227719956842e-19, -2.294223983180534e-21,  7.886540696829301e-25,  2.326795559330676e-26, -3.624746924719740e-29,  8.831119499368836e-01, -2.490068630502279e-03,
  1.242975882599707e-06,  9.805626213232372e-09, -1.445870997561147e-11, -6.432010759987221e-14,  1.727223190317867e-16,  4.610732836803520e-19, -2.070617821767061e-21,
 -3.035814343222157e-24,  2.459302400677445e-26,  1.239951517355585e-29,  9.464082103828294e-01, -2.524571461717999e-03,  6.589518990967807e-07,  1.056239974862126e-08,
 -8.261912673604017e-12, -7.774324593125619e-14,  1.057084188481586e-16,  6.786812449585160e-19, -1.368971987760055e-21, -6.373638976387808e-24,  1.783672547238400e-26,
  6.151190103069305e-29,  1.010104806387076e+00, -2.538954562920039e-03,  4.949775348900503e-08,  1.090794487745435e-08, -1.315162913924773e-12, -8.424718399155925e-14,
  2.145695490367981e-17,  7.904531765379255e-19, -3.193491022856829e-22, -8.203950153351231e-24,  4.611569897329456e-27,  9.057618668509398e-29,  1.073945811382186e+00,
 -2.532719706740140e-03, -5.684960711274928e-07,  1.081347341725375e-08,  5.880315471471080e-12, -8.283746714907998e-14, -6.857258912122890e-17,  7.693093501125233e-19,
  8.498206799422305e-22, -7.885894340410928e-24, -1.091643047590972e-26,  8.578629449495797e-29,  1.137670192743186e+00, -2.505697620246777e-03, -1.177370636086257e-06,
  1.027390709935869e-08,  1.278204405687758e-11, -7.341249842137456e-14, -1.514078535325493e-16,  6.136549091885928e-19,  1.865075161158493e-21, -5.400365299477773e-24,
 -2.340905277794870e-26,  4.702805830233384e-29,  1.201012795606807e+00, -2.458062904214495e-03, -1.759314529716548e-06,  9.309237749408926e-09,  1.885404479168627e-11,
 -5.682435953447329e-14, -2.146738067013602e-16,  3.493366371850296e-19,  2.478458945419781e-21, -1.401622053682998e-24, -2.834582092975539e-26, -1.093553619851549e-29,
  1.263705418805324e+00, -2.390343608986637e-03, -2.297020211769434e-06,  7.964324502149398e-09,  2.361685481709843e-11, -3.481377497632276e-14, -2.487377790308290e-16,
  2.545792847587430e-20,  2.536099563059592e-21,  2.958015047171703e-24, -2.384384563021209e-26, -6.427733390571056e-29,  1.325477982381006e+00, -2.303424830966043e-03,
 -2.774356968032875e-06,  6.307024665533565e-09,  2.669479322813650e-11, -9.818853662819680e-15, -2.484857952483806e-16, -2.954401330688114e-19,  2.024285610508630e-21,
  6.387025407045103e-24, -1.151872350115144e-26, -9.066734785349448e-29,  1.386059784503924e+00, -2.198545766764501e-03, -3.177033583472269e-06,  4.424666935525545e-09,
  2.785530219241108e-11,  1.532371835301602e-14, -2.143623372304862e-16, -5.508559853006519e-19,  1.077552660457994e-21,  7.880914009876391e-24,  4.054336647181445e-27,
 -7.966334505080439e-29,  1.445180843785567e+00, -2.077289764009050e-03, -3.493221632272140e-06,  2.419000496424656e-09,  2.703559226977568e-11,  3.774816126396939e-14,
 -1.524218938961211e-16, -6.923808185721807e-19, -5.611055650559472e-23,  7.064221359428788e-24,  1.713186934100098e-26, -3.768848548598786e-29,  1.502573320986981e+00,
 -1.941567039670648e-03, -3.714109281060603e-06,  3.998823267384505e-10,  2.435283598987866e-11,  5.494868114252619e-14, -7.332242062965640e-17, -6.968499988320217e-19,
 -1.084548032669166e-21,  4.317674188492434e-24,  2.312275856892277e-26,  1.516766255831707e-29,  1.557973011997404e+00, -1.793589898135035e-03, -3.834355955846420e-06,
 -1.521912940952556e-09,  2.009572948840463e-11,  6.512978775080293e-14,  9.594136062047620e-18, -5.716263211946942e-19, -1.755126247913185e-21,  6.348127560768168e-25,
  2.043099201147515e-26,  5.510373638262262e-29,  1.611120901752818e+00, -1.635840470060799e-03, -3.852420326644947e-06, -3.242272858440149e-09,  1.469725136715083e-11,
  6.746127207751142e-14,  8.278548830784510e-17, -3.524246308833182e-19, -1.926858009147268e-21, -2.744246045412139e-24,  1.098914477403626e-26,  6.622207482326581e-29,
  1.661764766529615e+00, -1.471031205544886e-03, -3.770737926388073e-06, -4.671156156393663e-09,  8.690683793385518e-12,  6.219287607409081e-14,  1.350640784238448e-16,
 -9.402193432512959e-20, -1.607588776471741e-21, -4.783640667189285e-24, -7.614910235905110e-28,  4.769708427299627e-29,  1.709660809853242e+00, -1.302058585501464e-03,
 -3.595730344016601e-06, -5.739238934866626e-09,  2.653153562917811e-12,  5.060416836026339e-14,  1.596865990154490e-16,  1.438229404933208e-19, -9.437923846003290e-22,
 -5.010960994058068e-24, -9.954674172712527e-27,  1.279596357761955e-29,  1.754575315180551e+00, -1.131950755804218e-03, -3.337635187998838e-06, -6.403224184732621e-09,
 -2.857201508668785e-12,  3.479170794073973e-14,  1.555172104697447e-16,  3.114787086728380e-19, -1.664615216831489e-22, -3.643593354288728e-24, -1.344342889085564e-26,
 -1.936911513302672e-29,  1.796286296630389e+00, -9.638100302314509e-04, -3.010154636725852e-06, -6.649312495354015e-09, -7.363125870064444e-12,  1.732391075360119e-14,
  1.269933563251535e-16,  3.814067834732582e-19,  4.880087709678195e-22, -1.437956849171482e-24, -1.098400575843705e-26, -3.438868559056722e-29,  1.834585127437868e+00,
 -8.007514397234031e-04, -2.629929964719330e-06, -6.494456102294444e-09, -1.052154922247216e-11,  8.189347999088361e-16,  8.288949080826491e-17,  3.536290102937360e-19,
  8.540064437280260e-22,  6.642319813039982e-25, -4.945333199060602e-27, -2.932907511840676e-29,  1.869278124587595e+00, -6.458387150625011e-04, -2.215859417490236e-06,
 -5.985188427710395e-09, -1.216132340057722e-11, -1.248273558667883e-14,  3.415684317016849e-17,  2.532243658413517e-19,  8.831704823125214e-22,  1.932022408224799e-24,
  1.199134053679982e-27, -1.223662598125936e-29,  1.900188067348369e+00, -5.020192655589015e-04, -1.788286561290040e-06, -5.194024239171912e-09, -1.230009721143557e-11,
 -2.107541477527346e-14, -8.654018555922021e-18,  1.207854652308325e-19,  6.457219867077802e-22,  2.109574239521711e-24,  4.721726791547349e-27,  4.502598761528972e-30,
  1.927155627349867e+00, -3.720598455196477e-04, -1.368095056274402e-06, -4.213643680756240e-09, -1.113756048462749e-11, -2.440974762664794e-14, -3.776912907431308e-17,
 -1.056213958381580e-21,  2.886960329552578e-22,  1.442218846681216e-24,  4.835061862004286e-27,  1.216276615398753e-29,  1.950040688812531e+00, -2.584846710145582e-04,
 -9.757529850619222e-07, -3.149285338858755e-09, -9.025357472168924e-12, -2.293678722616506e-14, -4.978792939753714e-17, -8.070338821391393e-20, -3.020297133259552e-23,
  4.742902562328469e-25,  2.670168812033804e-27,  9.906588321379654e-30,  1.968723541123234e+00, -1.635177454413928e-04, -6.303547423311655e-07, -2.109956433406351e-09,
 -6.417162259955142e-12, -1.796545522349467e-14, -4.611467975472932e-17, -1.061079422128451e-19, -2.053517825960715e-22, -2.627397108880144e-25,  2.108308867235012e-28,
  3.160816765218310e-30,  1.983105940722520e+00, -8.903102279563092e-05, -3.487103607344416e-07, -1.199200269193457e-09, -3.805252214129534e-12, -1.136002214679741e-14,
 -3.213581798094121e-17, -8.613530688718066e-20, -2.172783955078842e-22, -5.073135204999920e-25, -1.055560411597566e-27, -1.760391797670693e-30,  1.993112135698012e+00,
 -3.649940564522278e-05, -1.445291896215385e-07, -5.062198426170496e-10, -1.651943277878547e-12, -5.135881057461928e-15, -1.538210847403573e-17, -4.463706101198087e-20,
 -1.258431038165744e-22, -3.448903125547773e-25, -9.177516549060590e-28, -2.363513202483662e-30,  1.998691290518747e+00, -6.956238886250518e-06, -2.771219418579917e-08,
 -9.804364016971453e-11, -3.248215881917313e-13, -1.031684958117376e-15, -3.180666845769975e-18, -9.588101008160164e-21, -2.839204005225742e-23, -8.283999788760722e-26,
 -2.386557437491942e-28, -6.798594155640986e-31,  4.562268643633800e-04, -2.192954283149386e-06,  7.903954628340382e-09, -2.531549895535291e-11,  7.598759040218842e-14,
 -2.188697688251524e-16,  6.125961116078452e-19, -1.678647109919248e-21,  4.525019679746474e-24, -1.203850458383711e-26,  3.168169678800848e-29, -8.261432070146027e-32,
  4.104071346829758e-03, -1.969492624554347e-05,  7.074912532324179e-08, -2.253307509115874e-10,  6.706201254295649e-13, -1.908479580389024e-15,  5.255553443942571e-18,
 -1.409941126091471e-20,  3.699610094141919e-23, -9.516719728145977e-26,  2.402707503630029e-28, -5.955704590187803e-31,  1.138924955625723e-02, -5.447707455463886e-05,
  1.943889651819252e-07, -6.121191961969574e-10,  1.790365772036348e-12, -4.969453704759228e-15,  1.322134201053111e-17, -3.386169990522145e-20,  8.353522174585892e-23,
 -1.979860995376173e-25,  4.478908502333104e-28, -9.547685520087870e-31,  2.229073150322549e-02, -1.060977453094501e-04,  3.747734335780388e-07, -1.159853055705013e-09,
  3.302068211595183e-12, -8.807221563018142e-15,  2.212396339934606e-17, -5.217324180759372e-20,  1.140102297244286e-22, -2.237829941862169e-25,  3.631550038018758e-28,
 -3.381062247445556e-31,  3.677695136274686e-02, -1.738993069721352e-04,  6.059541041876985e-07, -1.831406401384311e-09,  5.020293258706327e-12, -1.263016477113781e-14,
  2.897963863816978e-17, -5.895998554395537e-20,  9.794284914550620e-23, -9.137894795486180e-26, -1.935530758739490e-28,  1.517333284855859e-30,  5.480578346289128e-02,
 -2.570139858161926e-04,  8.802339574260539e-07, -2.580224258755783e-09,  6.723373325458716e-12, -1.555753236333071e-14,  3.081337256593579e-17, -4.581734663849019e-20,
  1.717242779027856e-23,  2.166522204301214e-25, -1.128425880891444e-27,  3.853799397567466e-30,  7.632451194182502e-02, -3.543716721572862e-04,  1.188363462389532e-06,
 -3.352699972620380e-09,  8.173002751241559e-12, -1.674391002258885e-14,  2.530400773336463e-17, -8.797770397845056e-21, -1.242004133834922e-22,  6.267780390714932e-25,
 -2.036164178462920e-27,  5.043470846501940e-30,  1.012697955251295e-01, -4.647097163472333e-04,  1.519779777404069e-06, -4.090965594583168e-09,  9.135967036604773e-12,
 -1.550591493563815e-14,  1.135720709954368e-17,  4.965190468104542e-20, -2.960861599375759e-22,  9.826799457721554e-25, -2.328678880469637e-27,  3.398441383662218e-30,
  1.295676292606202e-01, -5.865847344801880e-04,  1.862885048984757e-06, -4.735980276343958e-09,  9.406385787311045e-12, -1.143591778389131e-14, -1.049864955608965e-17,
  1.201495003675506e-19, -4.468757698504826e-22,  1.091370822514336e-24, -1.499919618743282e-27, -1.697418108381972e-30,  1.611333054468840e-01, -7.183864421562789e-04,
  2.205358910906147e-06, -5.230784739642775e-09,  8.826740896697502e-12, -4.488251934782977e-15, -3.797687874405818e-17,  1.875141901814759e-19, -5.158841207365968e-22,
  7.957661377275640e-25,  5.742602819049382e-28, -8.936583963413803e-30,  1.958713764057978e-01, -8.583535299118366e-04,  2.534499381472537e-06, -5.523776561742614e-09,
  7.305960869509906e-12,  4.974407830141178e-15, -6.720439906783722e-17,  2.335152680011815e-19, -4.511711312874944e-22,  5.043946634268707e-26,  3.438735676134289e-27,
 -1.510263503719927e-29,  2.336756221789681e-01, -1.004591585483489e-03,  2.837585436386113e-06, -5.571852032721893e-09,  4.832947831205829e-12,  1.618312804905224e-14,
 -9.320209213670286e-17,  2.408009091710011e-19, -2.282135781527527e-22, -1.027896580707638e-24,  6.083457579004453e-27, -1.620040971629796e-29,  2.744290266729584e-01,
 -1.155093055347167e-03,  3.102253611297006e-06, -5.343256506030776e-09,  1.484169093969590e-12,  2.801698273974864e-14, -1.106240260785325e-16,  1.972606459139466e-19,
  1.360185300590592e-22, -2.159541655323129e-24,  7.234294641605199e-27, -9.401760795199959e-30,  3.180037662367460e-01, -1.307759220391553e-03,  3.316880083554052e-06,
 -4.819987273380811e-09, -2.575712774695424e-12,  3.910747731894230e-14, -1.146581441570441e-16,  9.988353655340711e-20,  5.785551916937879e-22, -2.961531733396511e-24,
  5.846098216798747e-27,  5.012618406780581e-30,  3.642612151240584e-01, -1.460424137604837e-03,  3.470958825906162e-06, -3.999601797523633e-09, -7.100739048790669e-12,
  4.798503112735387e-14, -1.019535076898993e-16, -4.284048039324530e-20,  9.985301478350430e-22, -3.059210239794759e-24,  1.629742633812679e-27,  2.275135961770883e-29,
  4.130519727683742e-01, -1.610880470783063e-03,  3.555465653220016e-06, -2.896300269917958e-09, -1.177810498358321e-11,  5.325363478156542e-14, -7.141898519336382e-17,
 -2.107390362185360e-19,  1.277845699263956e-21, -2.220680382037251e-24, -4.608869588674157e-27,  3.641858002619650e-29,  4.642159182728082e-01, -1.756907098104193e-03,
  3.563197342459376e-06, -1.541175374509356e-09, -1.624957769830085e-11,  5.377497661856269e-14, -2.474081695662283e-17, -3.743760353674636e-19,  1.310763959464402e-21,
 -4.712436520600549e-25, -1.101007451799747e-26,  3.826483667442951e-29,  5.175822979819800e-01, -1.896298342680111e-03,  3.489074550279044e-06,  1.844599681694977e-11,
 -2.013867115856257e-11,  4.884014694198742e-14,  3.350551072159079e-17, -4.999284387941826e-19,  1.035618707101825e-21,  1.856656655808119e-24, -1.515556907941652e-26,
  2.388548894249823e-29,  5.729698524470255e-01, -2.026894623805362e-03,  3.330397043149045e-06,  1.720604731344194e-09, -2.308176384864814e-11,  3.830607940039643e-14,
  9.622103682526218e-17, -5.558077766998849e-19,  4.600432071690186e-22,  4.168739465106075e-24, -1.491436600499042e-26, -4.742430875488093e-30,  6.301869895041582e-01,
 -2.146614271712042e-03,  3.087039859312019e-06,  3.491244208958857e-09, -2.476081710221886e-11,  2.267561717401950e-14,  1.546264936084068e-16, -5.198113627161807e-19,
 -3.285617128176269e-22,  5.752894353750487e-24, -9.364410588518257e-27, -3.856521756052275e-29,  6.890320105448394e-01, -2.253486187666535e-03,  2.761579510705926e-06,
  5.247614405198859e-09, -2.493495707292165e-11,  3.104693824263572e-15,  1.994999965243428e-16, -3.852801584884490e-19, -1.172838708956074e-21,  5.991371268169602e-24,
  5.782689904266151e-28, -6.401622406147515e-29,  7.492933973419004e-01, -2.345682965033696e-03,  2.359340276381109e-06,  6.902425937667071e-09, -2.346797714284024e-11,
 -1.867253385438966e-14,  2.226459713864126e-16, -1.647296189866128e-19, -1.876237940694729e-21,  4.580695412094694e-24,  1.214689641756561e-26, -6.834110210633818e-29,
  8.107501669882237e-01, -2.421554016765000e-03,  1.888352101540610e-06,  8.368577465356178e-09, -2.034885047551552e-11, -4.050018115207170e-14,  2.183684662193915e-16,
  1.102382018152204e-19, -2.249490578641467e-21,  1.684566687445526e-24,  2.145888348631053e-26, -4.568955623949908e-29,  8.731723025774154e-01, -2.479658182434379e-03,
  1.359213650975372e-06,  9.564225119795740e-09, -1.570265215627012e-11, -6.002743284732955e-14,  1.846896629576315e-16,  3.932555682969623e-19, -2.162105354622154e-21,
 -2.045204139580739e-24,  2.483875116029322e-26, -1.149884348824396e-30,  9.363212671815188e-01, -2.518795215820004e-03,  7.848567058672548e-07,  1.041791443959256e-08,
 -9.789894787326887e-12, -7.498336414556752e-14,  1.240647115312321e-16,  6.313457175078482e-19, -1.584959007380251e-21, -5.609433304993064e-24,  2.028724426817274e-26,
  4.966810226114959e-29,  9.999506084296825e-01, -2.538035485098995e-03,  1.802113443751199e-07,  1.087345820211990e-08, -2.993171297553407e-12, -8.346805100440092e-14,
  4.340247433374942e-17,  7.755518630552829e-19, -6.104203942944183e-22, -7.940902163695789e-24,  8.508510582033636e-27,  8.614167904810457e-29,  1.063806660533415e+00,
 -2.536747155596646e-03, -4.382248220771464e-07,  1.089422242712066e-08,  4.208868258636000e-12, -8.422191353924332e-14, -4.669444362780983e-17,  7.918845587730780e-19,
  5.589954316771903e-22, -8.245217001468677e-24, -7.008631644441228e-27,  9.142184619002725e-29,  1.127629349908568e+00, -2.514620073918951e-03, -1.052905750210894e-06,
  1.046648232964620e-08,  1.127888204197240e-11, -7.683354073892757e-14, -1.334204529546741e-16,  6.700502807510274e-19,  1.654343704743569e-21, -6.291237094247060e-24,
 -2.103500773845548e-26,  6.068527317767986e-29,  1.191153109583349e+00, -2.471685536914652e-03, -1.645832089809459e-06,  9.601534120155808e-09,  1.766687427392119e-11,
 -6.185024614322722e-14, -2.037911811117458e-16,  4.276204881008858e-19,  2.407516730085879e-21, -2.540548160231685e-24, -2.848681225099221e-26,  4.663656546989972e-30,
  1.254107906331105e+00, -2.408331114342546e-03, -2.199205126379060e-06,  8.336300029705314e-09,  2.286098777695635e-11, -4.076566559266103e-14, -2.468741192376454e-16,
  1.081274925103674e-19,  2.624764671330619e-21,  1.950557945234297e-24, -2.645382936757324e-26, -5.395805895320524e-29,  1.316220382907983e+00, -2.325309705585851e-03,
 -2.696117509306085e-06,  6.732243636910679e-09,  2.643814822501344e-11, -1.587425173138327e-14, -2.558173516750005e-16, -2.270808037571835e-19,  2.244962440290945e-21,
  5.846398437588899e-24, -1.551008516694165e-26, -9.031485357031503e-29,  1.377215115899043e+00, -2.223742053326943e-03, -3.121254277200656e-06,  4.872518866372032e-09,
  2.810910151042300e-11,  9.998094175634200e-15, -2.292607271298095e-16, -5.118106227657124e-19,  1.363313826074818e-21,  7.970136018043297e-24,  3.388877504292433e-28,
 -8.897487914133948e-29,  1.436815987483100e+00, -2.105112015309143e-03, -3.461573957513128e-06,  2.857404328333056e-09,  2.775240388633583e-11,  3.385743258766208e-14,
 -1.717945398176312e-16, -6.899785926825913e-19,  2.100998204897388e-22,  7.712272004621669e-24,  1.516941460716309e-26, -5.158313021920114e-29,  1.494747666931641e+00,
 -1.971254012728468e-03, -3.706936882761234e-06,  7.982171764566867e-10,  2.543261214074966e-11,  5.295102975612517e-14, -9.329545155935190e-17, -7.288889331844653e-19,
 -9.123317117515234e-22,  5.252700993304133e-24,  2.354520450489399e-26,  3.721587907441549e-30,  1.550737194891536e+00, -1.824332232513472e-03, -3.850646710064725e-06,
 -1.189953548081881e-09,  2.139929869830007e-11,  6.516166090781053e-14, -7.193110163819702e-18, -6.272622949246605e-19, -1.716986994003521e-21,  1.499565260317804e-24,
  2.277863049810831e-26,  5.125517989759871e-29,  1.604515660514410e+00, -1.666811360893470e-03, -3.889871800161029e-06, -2.996218562330882e-09,  1.606550964184835e-11,
  6.932265349354163e-14,  7.204015266425313e-17, -4.155741530794895e-19, -2.017023731498841e-21, -2.245021944453576e-24,  1.400427677354605e-26,  7.063954383263921e-29,
  1.655819958356038e+00, -1.501418864912947e-03, -3.825915879513666e-06, -4.521979233680555e-09,  9.966712733653794e-12,  6.539685031664498e-14,  1.316853580604167e-16,
 -1.482217692195964e-19, -1.779818470710786e-21, -4.769501531958608e-24,  1.533959952433714e-27,  5.668811730999063e-29,  1.704394608765507e+00, -1.331099111786959e-03,
 -3.664312431637044e-06, -5.688482273963558e-09,  3.703869549485201e-12,  5.448138908896517e-14,  1.632631621792752e-16,  1.106596578117498e-19, -1.131197870697192e-21,
 -5.395587282870782e-24, -9.217518949101287e-27,  2.091352692046984e-29,  1.749993622323523e+00, -1.158959915012276e-03, -3.414724542055870e-06, -6.443166988299285e-09,
 -2.123340424421516e-12,  3.862805096195738e-14,  1.641435710969806e-16,  3.039478322189318e-19, -3.075074918883192e-22, -4.197474494371325e-24, -1.422618092388266e-26,
 -1.600955414057727e-29,  1.792382385896181e+00, -9.882124096688859e-04, -3.090641266556411e-06, -6.764181422120264e-09, -6.985295313236887e-12,  2.050161768657149e-14,
  1.378829700969880e-16,  3.961070102782754e-19,  4.279639622031452e-22, -1.908145845845947e-24, -1.253860665958846e-26, -3.619300663386287e-29,  1.831339545183146e+00,
 -8.221054732314952e-04, -2.708872606717112e-06, -6.662558350014521e-09, -1.048445896982838e-11,  2.930210680229136e-15,  9.317700562327643e-17,  3.812990360584047e-19,
  8.740355777591630e-22,  4.393340337615144e-25, -6.331635077627427e-27, -3.373150173923453e-29,  1.866658856407760e+00, -6.638562059990947e-04, -2.288857253269211e-06,
 -6.181719830312427e-09, -1.240218937856364e-11, -1.157462984865558e-14,  4.165330149280334e-17,  2.826068085023600e-19,  9.534474482693356e-22,  1.968172184659536e-24,
  5.813644475310614e-28, -1.594333744551465e-29,  1.898150978189753e+00, -5.165782489412083e-04, -1.851809604575743e-06, -5.394207952961856e-09, -1.272339616015157e-11,
 -2.124012088823012e-14, -4.971063027154651e-18,  1.427005039836180e-19,  7.251111514386991e-22,  2.302081850991508e-24,  4.894920269918957e-27,  3.302155209870342e-30,
  1.925645173883825e+00, -3.832099277057389e-04, -1.419744256201130e-06, -4.395799449720909e-09, -1.163481681995763e-11, -2.531546835275584e-14, -3.766128968736571e-17,
  9.051167274140380e-21,  3.442286633756685e-22,  1.646602385789848e-24,  5.390934577884476e-27,  1.309851715765880e-29,  1.948990895222788e+00, -2.664443507780928e-04,
 -1.014426194132869e-06, -3.297426637881265e-09, -9.496225849762898e-12, -2.415890654873609e-14, -5.205843631177833e-17, -8.137520055953944e-20, -1.109709593978198e-23,
  5.902406985298004e-25,  3.138210894667809e-27,  1.139757142587720e-29,  1.968059221608210e+00, -1.686636344602255e-04, -6.563023218903347e-07, -2.215566659562069e-09,
 -6.787783414846184e-12, -1.910861103284475e-14, -4.917910843886266e-17, -1.128286246032937e-19, -2.146230952339431e-22, -2.513031424276165e-25,  3.667441828309255e-28,
  3.950221765923331e-30,  1.982744144642015e+00, -9.187931986664758e-05, -3.634737038086882e-07, -1.261944647632055e-09, -4.040364741439122e-12, -1.216102609052322e-14,
 -3.464775185646893e-17, -9.338872960864912e-20, -2.363205103099639e-22, -5.511020983566627e-25, -1.134254816022147e-27, -1.813320085601009e-30,  1.992963786490884e+00,
 -3.768039498221222e-05, -1.507658701242766e-07, -5.334931675828709e-10, -1.758456243294211e-12, -5.520516492870018e-15, -1.669024215525738e-17, -4.886999066959089e-20,
 -1.389457715774317e-22, -3.837656322558193e-25, -1.028191663844844e-27, -2.662532167219693e-30,  1.998663014589944e+00, -7.182732481505590e-06, -2.892059534144171e-08,
 -1.034100959253903e-10, -3.462409357386105e-13, -1.111348052911337e-15, -3.462315120664024e-18, -1.054626472545779e-20, -3.155357550432151e-23, -9.301261681047326e-26,
 -2.706964224448025e-28, -7.789185568266251e-31,  4.475796152739773e-04, -2.130917449018227e-06,  7.607321540145972e-09, -2.413393353798512e-11,  7.175349381637538e-14,
 -2.047155169815254e-16,  5.675577524095688e-19, -1.540543009618663e-21,  4.113595051402159e-24, -1.084101713441202e-26,  2.826261190461973e-29, -7.300920374631370e-32,
  4.026406756464509e-03, -1.913956956734784e-05,  6.810829808623147e-08, -2.148994642553626e-10,  6.336805673708005e-13, -1.786953022588996e-15,  4.876842070520030e-18,
 -1.296854750432057e-20,  3.373694307108754e-23, -8.606062822124545e-26,  2.155339816473478e-28, -5.301607319448421e-31,  1.117440563810351e-02, -5.295086501824800e-05,
  1.872121850812709e-07, -5.842515328192157e-10,  1.694074555291353e-12, -4.663223428506760e-15,  1.230959087540128e-17, -3.129923570047901e-20,  7.672031528028553e-23,
 -1.808848439107341e-25,  4.077970369969607e-28, -8.689333567348131e-31,  2.187224999867037e-02, -1.031543458269248e-04,  3.611664748038001e-07, -1.108400759487865e-09,
  3.131117302035797e-12, -8.293371734104851e-15,  2.071299791495173e-17, -4.865103953703985e-20,  1.062118481109079e-22, -2.095629513138511e-25,  3.476560880393279e-28,
 -3.643822068340883e-31,  3.609091211642648e-02, -1.691382350812296e-04,  5.844509605067528e-07, -1.753065301126327e-09,  4.774513172582386e-12, -1.195411292753152e-14,
  2.737213297539719e-17, -5.587981721195202e-20,  9.452919315120356e-23, -9.786706245152559e-26, -1.327843302127333e-28,  1.252011212961975e-30,  5.379161771682593e-02,
 -2.500941595522189e-04,  8.499065711556383e-07, -2.475099745063421e-09,  6.419514324257536e-12, -1.483333705140384e-14,  2.953929239912256e-17, -4.515142574614406e-20,
  2.419898771978983e-23,  1.747624494618485e-25, -9.695284032595719e-28,  3.377876632758390e-30,  7.492578736854395e-02, -3.450234962369228e-04,  1.148904726637994e-06,
 -3.224578049351228e-09,  7.844175324706152e-12, -1.613999869878045e-14,  2.500531090645790e-17, -1.242645210309349e-20, -1.030501012175051e-22,  5.496447226029236e-25,
 -1.823569176963901e-27,  4.622382988948443e-30,  9.943496570005532e-02, -4.527453829640093e-04,  1.471555058419647e-06, -3.947255804752815e-09,  8.828681681251354e-12,
 -1.521769752042981e-14,  1.262000562545433e-17,  4.072548770161600e-20, -2.623500864568063e-22,  8.925450063966550e-25, -2.177679455286503e-27,  3.452113991481713e-30,
  1.272507401380115e-01, -5.719064400706176e-04,  1.806948709708529e-06, -4.587320425619299e-09,  9.175412056127242e-12, -1.164909515784703e-14, -7.328840714225175e-18,
  1.064663959205290e-19, -4.086819338969247e-22,  1.030144372333201e-24, -1.555193766706960e-27, -8.444928390468802e-31,  1.582946512612725e-01, -7.009922547981642e-04,
  2.143433743293475e-06, -5.090322775540924e-09,  8.728277161288779e-12, -5.338531083360832e-15, -3.295326352320427e-17,  1.714679527871407e-19, -4.869134406804775e-22,
  8.113522181032696e-25,  2.165575852995094e-28, -7.355551744233287e-30,  1.924780972839891e-01, -8.383406819110014e-04,  2.468918440216492e-06, -5.406170723369501e-09,
  7.389841161952560e-12,  3.438334543060541e-15, -6.086764136442168e-17,  2.191321222865153e-19, -4.470349948157800e-22,  1.751999526930658e-25,  2.811565076676415e-27,
 -1.341747392747133e-29,  2.297022356305639e-01, -9.821570125080946e-04,  2.771197468391172e-06, -5.492054825306576e-09,  5.134783622591470e-12,  1.402632917578787e-14,
 -8.656714252087747e-17,  2.329515886154639e-19, -2.610076587095968e-22, -7.986036522155947e-25,  5.386752032230101e-27, -1.543759889817171e-29,  2.698578850467538e-01,
 -1.130531057417124e-03,  3.038295042540857e-06, -5.315169451149262e-09,  2.018408613938824e-12,  2.542870767517393e-14, -1.050510857520192e-16,  2.004243602546174e-19,
  6.338068429496774e-23, -1.878803791556142e-24,  6.794520069328649e-27, -1.051211534710108e-29,  3.128254322055639e-01, -1.281456181229266e-03,  3.258818297152197e-06,
 -4.855090008340828e-09, -1.820844247144270e-12,  3.639123789376969e-14, -1.116179162465992e-16,  1.167369634556923e-19,  4.761932777058203e-22, -2.724269829682023e-24,
  5.993441727800757e-27,  1.777981815484213e-30,  3.584747473135049e-01, -1.432850307213158e-03,  3.422313171895298e-06, -4.105669308877364e-09, -6.165586199803122e-12,
  4.552726196163881e-14, -1.027221554362179e-16, -1.263516188247747e-20,  8.898009843298437e-22, -2.975341565441996e-24,  2.531092131485582e-27,  1.827643703387811e-29,
  4.066651138000271e-01, -1.582578891283978e-03,  3.519614192344027e-06, -3.076324422508918e-09, -1.073062723800069e-11,  5.147331644640931e-14, -7.675945749607946e-17,
 -1.711595973342844e-19,  1.194959027668864e-21, -2.374085234217663e-24, -3.088914824561604e-27,  3.263942656344278e-29,  4.572451777761843e-01, -1.728479834156617e-03,
  3.543178655952094e-06, -1.792600362465247e-09, -1.518084062861450e-11,  5.306012775325436e-14, -3.463926103010451e-17, -3.327847392399188e-19,  1.286276150373681e-21,
 -8.781552026776713e-25, -9.341505463027286e-27,  3.744341568702559e-29,  5.100529235709148e-01, -1.868390264091057e-03,  3.487394952993576e-06, -2.959193182185999e-10,
 -1.915494113419478e-11,  4.948010567008844e-14,  1.998069793130484e-17, -4.658340813979247e-19,  1.091810142966937e-21,  1.272591813230385e-24, -1.402166498460176e-26,
  2.745775227753354e-29,  5.649156822848171e-01, -2.000175077658549e-03,  3.348854124663937e-06,  1.357545695075849e-09, -2.229380061312666e-11,  4.043043093239344e-14,
  8.088625708349661e-17, -5.388006088496077e-19,  5.993501604149268e-22,  3.570280092549000e-24, -1.495374303245947e-26,  2.788363637204066e-30,  6.216501809285272e-01,
 -2.121757072305480e-03,  3.126573356859864e-06,  3.098895899464505e-09, -2.427137867021825e-11,  2.621099702393851e-14,  1.399551806003161e-16, -5.270871256469323e-19,
 -1.285849528070302e-22,  5.347002122149947e-24, -1.086555656146619e-26, -2.969372579242487e-29,  6.800626403183442e-01, -2.231148442006974e-03,  2.822160009275209e-06,
  4.849408249424981e-09, -2.482587808481449e-11,  7.759197944884465e-15,  1.882191460706012e-16, -4.193609090382992e-19, -9.573959764050446e-22,  5.959922576615067e-24,
 -2.105404548723641e-27, -5.780170211110524e-29,  7.399489304638021e-01, -2.326483336171691e-03,  2.439905073837182e-06,  6.524239340008240e-09, -2.378840079837301e-11,
 -1.339100859047574e-14,  2.172184126172136e-16, -2.220428721868292e-19, -1.703313491646145e-21,  5.006275817973808e-24,  9.131725886430181e-27, -6.839859459820113e-29,
  8.010947926738908e-01, -2.406051102827306e-03,  1.986795736264985e-06,  8.036801485143357e-09, -2.110623742586689e-11, -3.523037022673592e-14,  2.204576385735104e-16,
  3.938639946083345e-20, -2.173902113201593e-21,  2.500343679985456e-24,  1.927472392432073e-26, -5.327262978443542e-29,  8.632761379990822e-01, -2.468329751201207e-03,
  1.472438069718371e-06,  9.303622733691429e-09, -1.685802405964815e-11, -5.547062642107047e-14,  1.947224924389270e-16,  3.230815841031589e-19, -2.217896138688880e-21,
 -1.056513762540422e-24,  2.450209539458526e-26, -1.400499304423035e-29,  9.262594318788037e-01, -2.512019078025572e-03,  9.088829004410325e-07,  1.024944647008218e-08,
 -1.125838503818070e-11, -7.179959101049880e-14,  1.410031120119002e-16,  5.775566658300253e-19, -1.771798959260656e-21, -4.757965477566045e-24,  2.219233613865631e-26,
  3.679532972211958e-29,  9.898021749374798e-01, -2.536072808960134e-03,  3.103506128451072e-07,  1.081227651020878e-08, -4.650369291479744e-12, -8.216827509068867e-14,
  6.480199272474510e-17,  7.515174428141647e-19, -8.892698285309216e-22, -7.526605531240786e-24,  1.215641683214200e-26,  7.929421555364333e-29,  1.053653489721752e+00,
 -2.539729015059936e-03, -3.071458646207919e-07,  1.094803549511517e-08,  2.515028591790907e-12, -8.507476165430344e-14, -2.431620898551053e-17,  8.049769974997773e-19,
  2.581010258121109e-22, -8.444030610148933e-24, -2.910155647892865e-27,  9.442596976520550e-29,  1.117554822749278e+00, -2.522537978798123e-03, -9.262764456015215e-07,
  1.063448357929652e-08,  9.711740000135148e-12, -7.980472755272596e-14, -1.139530736989471e-16,  7.192085839049098e-19,  1.413391506702652e-21, -7.075519120374377e-24,
 -1.809011265421305e-26,  7.289491681421732e-29,  1.181240770496830e+00, -2.484386610323608e-03, -1.528959330915913e-06,  9.874046551866563e-09,  1.638197391532815e-11,
 -6.658894078163736e-14, -1.907545535963806e-16,  5.029784337977899e-19,  2.295639014585453e-21, -3.671180958376964e-24, -2.792700527129399e-26,  2.083187005276868e-29,
  1.244440036844812e+00, -2.425518458813000e-03, -2.097002816106241e-06,  8.695232604679090e-09,  2.198671920962360e-11, -4.664476499707496e-14, -2.426615803431078e-16,
  1.930348258642772e-19,  2.675397947843514e-21,  8.484807194056501e-25, -2.855798648199600e-26, -4.132496763185445e-29,  1.306876527973702e+00, -2.346548333095689e-03,
 -2.612804086562091e-06,  7.152378529093329e-09,  2.605879476962433e-11, -2.208185953554860e-14, -2.611391288075353e-16, -1.520019519814323e-19,  2.443313979330569e-21,
  5.147234338563187e-24, -1.942524694102179e-26, -8.717215518735786e-29,  1.368270588740189e+00, -2.248470547732363e-03, -3.060079959806650e-06,  5.323560449268015e-09,
  2.825290663529533e-11,  4.329063117906382e-15, -2.429375520107716e-16, -4.635989679407750e-19,  1.649517386163988e-21,  7.903021235496190e-24, -3.749863139451753e-27,
 -9.655117461802392e-29,  1.428340382124173e+00, -2.132659852932321e-03, -3.424599272462240e-06,  3.306629408046217e-09,  2.838676200694436e-11,  2.950355115923798e-14,
 -1.909772688853457e-16, -6.787007095650525e-19,  4.980788345196616e-22,  8.269506866648801e-24,  1.258965916623308e-26, -6.567171728315888e-29,  1.486803410426307e+00,
 -2.000864196035103e-03, -3.694882211376315e-06,  1.213482482127021e-09,  2.646757242287392e-11,  5.046391447401242e-14, -1.140833419908575e-16, -7.548761266801647e-19,
 -7.062766544858618e-22,  6.194004129190685e-24,  2.342324016181167e-26, -9.553816830902519e-30,  1.543378173525453e+00, -1.855188604400366e-03, -3.862828860237890e-06,
 -8.371543655154429e-10,  2.269935108699578e-11,  6.477211378395489e-14, -2.551627011999299e-17, -6.811619608331097e-19, -1.646073004415657e-21,  2.454191592569200e-24,
  2.490832864113899e-26,  4.516191153827016e-29,  1.597785955718246e+00, -1.698069678006548e-03, -3.924238087862276e-06, -2.727988931545931e-09,  1.746827182970712e-11,
  7.090462002282919e-14,  5.948910600662643e-17, -4.812977897346557e-19, -2.087002939710020e-21, -1.621671998448549e-24,  1.718568017815491e-26,  7.371700034999260e-29,
  1.649752728531561e+00, -1.532240435495042e-03, -3.879179111873943e-06, -4.351878145070308e-09,  1.130588412639704e-11,  6.850090246650535e-14,  1.267120907824319e-16,
 -2.079063113099155e-19, -1.949790474110496e-21, -4.655568223511275e-24,  4.229328532392248e-27,  6.583062139573547e-29,  1.699011152528015e+00, -1.360685566736888e-03,
 -3.732181997411202e-06, -5.620289466188470e-09,  4.832909555732673e-12,  5.843261423932988e-14,  1.658251588985219e-16,  7.128426593411143e-20, -1.331829781830209e-21,
 -5.743222503172857e-24, -8.096186906344939e-27,  3.025692181098868e-29,  1.745302656653927e+00, -1.186587500793217e-03, -3.492220190885975e-06, -6.470743031968186e-09,
 -1.310701948040473e-12,  4.266836760872784e-14,  1.724928396841011e-16,  2.915787175157737e-19, -4.690177710219117e-22, -4.779336680188132e-24, -1.483292501625392e-26,
 -1.133794699962908e-29,  1.788379569279678e+00, -1.013264088160489e-03, -3.172467908117872e-06, -6.872482290976297e-09, -6.541264960392253e-12,  2.394538143111994e-14,
  1.491546590631030e-16,  4.086028268765844e-19,  3.498553410133035e-22, -2.441946116362699e-24, -1.416024548191592e-26, -3.740312789798950e-29,  1.828007270954935e+00,
 -8.440991033973035e-04, -2.789827477404065e-06, -6.829715670010104e-09, -1.040261109926939e-11,  5.297748597008386e-15,  1.042469585437319e-16,  4.094693669425951e-19,
  8.849228385612893e-22,  1.550310291973804e-25, -7.917415053343962e-27, -3.838458385944287e-29,  1.863966335271829e+00, -6.824671771995531e-04, -2.364235957223139e-06,
 -6.381949731956051e-09, -1.262302613462052e-11, -1.047648146476723e-14,  5.000411203050974e-17,  3.142538373374604e-19,  1.024540056445861e-21,  1.976167273912184e-24,
 -2.132079142428487e-28, -2.028259971749863e-29,  1.896054621352117e+00, -5.316551408434709e-04, -1.917775581692566e-06, -5.601185786456953e-09, -1.314905410752814e-11,
 -2.130877909557531e-14, -6.378693188221943e-19,  1.672681066341371e-19,  8.115414122651793e-22,  2.500333515696382e-24,  5.005619671563154e-27,  1.647075240666294e-30,
  1.924089279665242e+00, -3.947820835971667e-04, -1.473627659011989e-06, -4.586055994820888e-09, -1.215013769760751e-11, -2.621499709347069e-14, -3.724442782555504e-17,
  2.105768874949827e-20,  4.075291393712150e-22,  1.874031344362696e-24,  5.986941027131136e-27,  1.398029398889348e-29,  1.947908632700619e+00, -2.747206569496303e-04,
 -1.054923118360082e-06, -3.453300335879920e-09, -9.992082685239529e-12, -2.543567068995657e-14, -5.433854049577781e-17, -8.136509263415766e-20,  1.253628391216892e-23,
  7.262786758124720e-25,  3.675902810762011e-27,  1.307488876990960e-29,  1.967373895204819e+00, -1.740222759792200e-04, -6.835535713974819e-07, -2.327293789719287e-09,
 -7.182018562801747e-12, -2.032760437977353e-14, -5.243579889533864e-17, -1.198381272948627e-19, -2.233616577218675e-22, -2.328904904120932e-25,  5.607926190596673e-28,
  4.898623600159621e-30,  1.982370714299249e+00, -9.484880060218570e-05, -3.790130896915305e-07, -1.328582333010632e-09, -4.292117024635595e-12, -1.302482393199270e-14,
 -3.737155377529787e-17, -1.012773339237424e-19, -2.569961771480339e-22, -5.980785487035348e-25, -1.214779236056560e-27, -1.842216059701220e-30,  1.992810611425061e+00,
 -3.891261645028047e-05, -1.573403152684241e-07, -5.625339886380912e-10, -1.872985720249236e-12, -5.938018104519311e-15, -1.812298448618599e-17, -5.354547687128829e-20,
 -1.535307392352217e-22, -4.273328238638415e-25, -1.152629252100742e-27, -3.000553245595684e-30,  1.998633812936104e+00, -7.419156825464773e-06, -3.019550401627025e-08,
 -1.091323839381511e-10, -3.693233744342564e-13, -1.198104428865342e-15, -3.772265215918482e-18, -1.161171314699712e-20, -3.510548497465762e-23, -1.045584644172026e-25,
 -3.074311122952140e-28, -8.936273281812793e-31,  4.391758555926590e-04, -2.071198094987542e-06,  7.324469918780951e-09, -2.301790642722932e-11,  6.779197875828378e-14,
 -1.915972315828231e-16,  5.262082870815454e-19, -1.414940335290933e-21,  3.742916757165047e-24, -9.772203374918680e-27,  2.523934203039516e-29, -6.459491645194672e-32,
  3.950922118408806e-03, -1.860484867128407e-05,  6.558917872828749e-08, -2.050402495608523e-10,  5.990831548912961e-13, -1.674147056413579e-15,  4.528382734715271e-18,
 -1.193691689345706e-20,  3.078848372241911e-23, -7.788827200748410e-26,  1.935049177095578e-28, -4.723307469509053e-31,  1.096555381118445e-02, -5.148075780816620e-05,
  1.803607713106906e-07, -5.578766970301870e-10,  1.603694810485045e-12, -4.378038276255978e-15,  1.146662604727403e-17, -2.894530044885875e-20,  7.049307654790515e-23,
 -1.653140081765229e-25,  3.713162974504127e-28, -7.904516762127487e-31,  2.146532822644921e-02, -1.003173780337599e-04,  3.481608655682296e-07, -1.059603268719985e-09,
  2.970112601948512e-12, -7.812229347116506e-15,  1.939723651290240e-17, -4.537031644021428e-20,  9.891398134695235e-23, -1.959826033294376e-25,  3.312493526480142e-28,
 -3.797906987991584e-31,  3.542357896825273e-02, -1.645454938050179e-04,  5.638647546243289e-07, -1.678550581040213e-09,  4.541875243142348e-12, -1.131561882665189e-14,
  2.584931081047448e-17, -5.291217598334453e-20,  9.092301746805362e-23, -1.021456519958918e-25, -8.278446303299460e-29,  1.026844056437251e-30,  5.280465391185506e-02,
 -2.434119879613835e-04,  8.208119811909913e-07, -2.374722758761643e-09,  6.129835085919309e-12, -1.413947185658086e-14,  2.828678772187762e-17, -4.428359676223833e-20,
  2.982701999098562e-23,  1.388255773385906e-25, -8.303983990082590e-28,  2.954478609120682e-30,  7.356383377137560e-02, -3.359849288760661e-04,  1.110952283761369e-06,
 -3.101621161796879e-09,  7.527346592138376e-12, -1.554440136431901e-14,  2.461408037881979e-17, -1.542114734049166e-20, -8.452794289083213e-23,  4.806493677098166e-25,
 -1.629141178764415e-27,  4.218419762365833e-30,  9.764723241754728e-02, -4.411600323959897e-04,  1.425025552849637e-06, -3.808414901955150e-09,  8.527444118623344e-12,
 -1.490205318354509e-14,  1.364749875772769e-17,  3.282787634673553e-20, -2.317497838356228e-22,  8.084753783441911e-25, -2.025922228846806e-27,  3.435860678876558e-30,
  1.249916804206732e-01, -5.576685638250889e-04,  1.752773987505008e-06, -4.442386257347319e-09,  8.940905203379541e-12, -1.179065858391349e-14, -4.525381948168343e-18,
  9.396987141077228e-20, -3.727234676796179e-22,  9.674068660603044e-25, -1.576681084250022e-27, -1.575540022377179e-31,  1.555245936580597e-01, -6.840867546394250e-04,
  2.083184126354092e-06, -4.951565875944904e-09,  8.613977660950334e-12, -6.073529821392226e-15, -2.836589864983289e-17,  1.563551258624450e-19, -4.576229707245001e-22,
  8.139636500439988e-25, -7.588126409785067e-29, -5.967958891941499e-30,  1.891638292263659e-01, -8.188468158263581e-04,  2.404755834113720e-06, -5.287460445518183e-09,
  7.444488283815814e-12,  2.049529640665662e-15, -5.493111723436723e-17,  2.049484968649228e-19, -4.388413873384648e-22,  2.763328434028650e-25,  2.256730966832227e-27,
 -1.181798886528766e-29,  2.258175313428143e-01, -9.602496341338709e-04,  2.705794647450855e-06, -5.407764757837691e-09,  5.395057440975974e-12,  1.202602057478783e-14,
 -8.016546264663567e-17,  2.241796203548919e-19, -2.860402721945725e-22, -5.964579155566897e-25,  4.727222324119803e-27, -1.452025424385999e-29,  2.653839704098062e-01,
 -1.106479238432179e-03,  2.974723120786938e-06, -5.278941395332968e-09,  2.502225995321567e-12,  2.297499274286691e-14, -9.942060854536494e-17,  2.014218857992468e-19,
  5.221824169718682e-25, -1.616504065585825e-24,  6.315473149158284e-27, -1.119877613535009e-29,  3.077513789591002e-01, -1.255619120067390e-03,  3.200405965855950e-06,
 -4.878545326824070e-09, -1.119534509147920e-12,  3.375326447544307e-14, -1.081503599130788e-16,  1.304523409197523e-19,  3.824460745288650e-22, -2.483796970423703e-24,
  6.010632280745205e-27, -9.094835373037036e-31,  3.527977887870900e-01, -1.405670482673459e-03,  3.372482857816031e-06, -4.197168339511226e-09, -5.279706723143001e-12,
  4.306080410154309e-14, -1.026932636217888e-16,  1.414571132611873e-20,  7.846935729734153e-22, -2.859250681997888e-24,  3.243565635602231e-27,  1.417359021940425e-29,
  4.003908742430755e-01, -1.554572482466757e-03,  3.481701802948692e-06, -3.239880374737378e-09, -9.719949375444951e-12,  4.957782105780139e-14, -8.102958720580689e-17,
 -1.343094871972299e-19,  1.107603650760152e-21, -2.470062152940530e-24, -1.738330863948778e-27,  2.874209744657455e-29,  4.503878073369267e-01, -1.700224498572509e-03,
  3.520244955814421e-06, -2.027052446508456e-09, -1.412868234714767e-11,  5.212158928078559e-14, -4.338623019626346e-17, -2.921986373835803e-19,  1.248330071365145e-21,
 -1.219276569496344e-24, -7.725947609378412e-27,  3.588290442087753e-29,  5.026351310877778e-01, -1.840510443381061e-03,  3.482037776149098e-06, -5.944598678354560e-10,
 -1.816157959550757e-11,  4.980710867539997e-14,  7.432604040569347e-18, -4.302689790728133e-19,  1.127826371306604e-21,  7.366805233530082e-25, -1.275628621977987e-26,
  2.987779147156724e-29,  5.569686583346859e-01, -1.973325084267420e-03,  3.363031479975772e-06,  1.007414140984250e-09, -2.146698960294319e-11,  4.219294599062867e-14,
  6.608685019385154e-17, -5.176800047309042e-19,  7.171613708695741e-22,  2.976574037353773e-24, -1.468421582993922e-26,  9.288016136330804e-30,  6.132134040628840e-01,
 -2.096602299260948e-03,  3.161447932003998e-06,  2.714925077833584e-09, -2.371476657934818e-11,  2.939252992419985e-14,  1.251674609125604e-16, -5.282082549614413e-19,
  5.579238977304524e-23,  4.888807579305812e-24, -1.198153401211230e-26, -2.109720478462092e-29,  6.711835601498881e-01, -2.208345129607131e-03,  2.877975529027658e-06,
  4.453677057437660e-09, -2.462648969444548e-11,  1.213228779008593e-14,  1.760802382173465e-16, -4.465857728096752e-19, -7.449491987634868e-22,  5.826870691908856e-24,
 -4.495650447370138e-27, -5.073029271502903e-29,  7.306825222832098e-01, -2.306657421062686e-03,  2.515904332867713e-06,  6.141763396167209e-09, -2.400462326053451e-11,
 -8.258363370507503e-15,  2.102656903311449e-16, -2.736006578676754e-19, -1.517234691566778e-21,  5.311743940284375e-24,  6.154413608997810e-27, -6.665390929893078e-29,
  7.915029796182322e-01, -2.389776763043634e-03,  2.081188835149035e-06,  7.693752538503519e-09, -2.175788592273098e-11, -2.993392552496999e-14,  2.206011152511514e-16,
 -2.859416458556880e-20, -2.070593471250793e-21,  3.222654527867773e-24,  1.679989238196747e-26, -5.889140271118791e-29,  8.534270784961722e-01, -2.456108340785767e-03,
  1.582427392163122e-06,  9.025275897705115e-09, -1.792001201350600e-11, -5.069677951763422e-14,  2.027707820287457e-16,  2.516880920324578e-19, -2.238470175592001e-21,
 -9.231132198006094e-26,  2.362219040767807e-26, -2.578524470821528e-29,  9.162266721854714e-01, -2.504259211586187e-03,  1.030748675727057e-06,  1.005801362407481e-08,
 -1.265925997343629e-11, -6.822801617714787e-14,  1.563564212676381e-16,  5.182927679698143e-19, -1.926752786374998e-21, -3.841821867586826e-24,  2.351693356493511e-26,
  2.335968159787543e-29,  9.796636690947871e-01, -2.533072403996832e-03,  4.395975575799643e-07,  1.072481527275075e-08, -6.276495541823146e-12, -8.036397984765752e-14,
  8.540606214874176e-17,  7.188260085801058e-19, -1.150656682040845e-21, -6.973070897421069e-24,  1.545481816279195e-26,  7.030716586394986e-29,  1.043490492173444e+00,
 -2.541660121666903e-03, -1.755842270173375e-07,  1.097463995895121e-08,  8.095267855692417e-13, -8.538722658931428e-14, -1.707035889923029e-18,  8.083581494155787e-19,
 -4.697521512043009e-23, -8.477064742145736e-24,  1.260344079997500e-27,  9.468612615789439e-29,  1.107450662199913e+00, -2.529435215792090e-03, -7.977834491451910e-07,
  1.077696100383552e-08,  8.089953273496447e-12, -8.229307660776906e-14, -9.322128505301009e-17,  7.602284245197842e-19,  1.146450174403519e-21, -7.731791761670590e-24,
 -1.464846670932301e-26,  8.319330210656354e-29,  1.171279517289006e+00, -2.496139977646429e-03, -1.408942843806368e-06,  1.012526009610943e-08,  1.500559711669901e-11,
 -7.098987806007445e-14, -1.756641049128092e-16,  5.741107649124265e-19,  2.143633527171312e-21, -4.765146479221951e-24, -2.665329934831840e-26,  3.702012139761945e-29,
  1.234705080149027e+00, -2.441871202735240e-03, -1.990581104912539e-06,  9.039242530958398e-09,  2.099607302201282e-11, -5.239408872672864e-14, -2.360550261792834e-16,
  2.789125082579917e-19,  2.684981091505939e-21, -3.260266810883077e-25, -3.006063345811798e-26, -2.667463444671477e-29,  1.297449083316233e+00, -2.367100399409940e-03,
 -2.524489580560616e-06,  7.565444336489939e-09,  2.555418581466708e-11, -2.839127058750460e-14, -2.642738341500497e-16, -7.100847296808905e-20,  2.613717800016941e-21,
  4.295085329577731e-24, -2.313797326416984e-26, -8.109888179979228e-29,  1.359228160715670e+00, -2.272687967218102e-03, -2.993483136158493e-06,  5.775978512167493e-09,
  2.828016338001321e-11, -1.650981085384623e-15, -2.551368232308181e-16, -4.062996382075257e-19,  1.930286136261828e-21,  7.666306737365291e-24, -8.124981368882928e-27,
 -1.019152616715690e-28,  1.419755211385484e+00, -2.159890164505663e-03, -3.382175942325842e-06,  3.765282708712226e-09,  2.892946967996613e-11,  2.469413272787169e-14,
 -2.097123358746402e-16, -6.579076566556201e-19,  8.041118762316134e-22,  8.711203912137722e-24,  9.394705922659267e-27, -7.945974600559514e-29,  1.478740938014870e+00,
 -2.030357731684492e-03, -3.677746730083239e-06,  1.644881872864555e-09,  2.744774635010965e-11,  4.746993446861170e-14, -1.355014803208551e-16, -7.737294819572026e-19,
 -4.665678341471860e-22,  7.118248489869286e-24,  2.268037801217417e-26, -2.445971450970712e-29,  1.535895559068398e+00, -1.886125146263504e-03, -3.870652951079105e-06,
 -4.636410737693780e-10,  2.398709419247119e-11,  6.392498928713970e-14, -4.531157084098308e-17, -7.322266393596666e-19, -1.539330087035222e-21,  3.487939661011831e-24,
  2.671700363690561e-26,  3.663767918943888e-29,  1.590930688720171e+00, -1.729589666552510e-03, -3.955249965461748e-06, -2.437078987642767e-09,  1.889951081918159e-11,
  7.216304686484795e-14,  4.506999690783846e-17, -5.488769144043009e-19, -2.132222631101217e-21, -8.688383770022337e-25,  2.046585178666196e-26,  7.506310004480432e-29,
  1.643561373661127e+00, -1.563479578155986e-03, -3.930270544628868e-06, -4.159860730171267e-09,  1.270580445586701e-11,  7.146493213008060e-14,  1.199922783826671e-16,
 -2.729427376089150e-19, -2.113623410246370e-21, -4.425795237453972e-24,  7.324842726416380e-27,  7.482085141011766e-29,  1.693508270181819e+00, -1.390811391833702e-03,
 -3.799122244076956e-06, -5.533396869496577e-09,  6.041495843523785e-12,  6.243136046035828e-14,  1.671929466275405e-16,  2.529789712566132e-20, -1.544066888733838e-21,
 -6.037427671747617e-24, -6.537348796725006e-27,  4.078938672025903e-29,  1.740499938935285e+00, -1.214836148165841e-03, -3.569966037417659e-06, -6.484659650415890e-09,
 -4.152844684291666e-13,  4.690430714577023e-14,  1.804202364739434e-16,  2.737018645784508e-19, -6.518585391020820e-22, -5.380930247872447e-24, -1.520184717649369e-26,
 -5.169547195101484e-30,  1.784275228669609e+00, -1.038975452119449e-03, -3.255549212383743e-06, -6.973112860058348e-09, -6.025627323473454e-12,  2.766356365819796e-14,
  1.607382595095799e-16,  4.182790883813736e-19,  2.513514852342192e-22, -3.041455400335667e-24, -1.581816757661878e-26, -3.780405889352353e-29,  1.824585714260467e+00,
 -8.667483701235702e-04, -2.872778768466686e-06, -6.995169914027108e-09, -1.027069162965957e-11,  7.940460078666703e-15,  1.161089299559217e-16,  4.378116854889531e-19,
  8.843835686727272e-22, -1.968535796531325e-25, -9.711914143008111e-27, -4.320169941819250e-29,  1.861198148891851e+00, -7.016908473930711e-04, -2.442037859439275e-06,
 -6.585526122592328e-09, -1.281982262413110e-11, -9.167023118238234e-15,  5.927288617926840e-17,  3.481739154445891e-19,  1.095300581492396e-21,  1.948362415320985e-24,
 -1.213637780185286e-27, -2.530888276922572e-29,  1.893896885597379e+00, -5.472698113441030e-04, -1.986266182332511e-06, -5.814979242347544e-09, -1.357498788994625e-11,
 -2.126486678610381e-14,  4.423016181793104e-18,  1.947163736201251e-19,  9.051694893698060e-22,  2.701401855421645e-24,  5.031739335047047e-27, -5.594341323463921e-31,
  1.922486220029469e+00, -4.067945805556924e-04, -1.529844202774004e-06, -4.784700936455237e-09, -1.268332065676681e-11, -2.710025033221333e-14, -3.646176066708951e-17,
  3.522550011931802e-20,  4.794553040480861e-22,  2.126050670461071e-24,  6.619719854814056e-27,  1.476119742694359e-29,  1.946792604963584e+00, -2.833285572855404e-04,
 -1.097338981510884e-06, -3.617314997071492e-09, -1.051402154420459e-11, -2.676706379981608e-14, -5.660700721855699e-17, -8.051605988901531e-20,  4.147248156073251e-23,
  8.853583443638107e-25,  4.291753887233714e-27,  1.495241621526293e-29,  1.966666689570234e+00, -1.796043995092736e-04, -7.121842115162703e-07, -2.445528035194232e-09,
 -7.601431241463007e-12, -2.162714442108817e-14, -5.589255948538180e-17, -1.271150754894124e-19, -2.312871140665113e-22, -2.058282795884801e-25,  8.005891283971899e-28,
  6.034788581994264e-30,  1.981985152240468e+00, -9.794586484673290e-05, -3.953768778384978e-07, -1.399389890877510e-09, -4.561817261575547e-12, -1.395671993867719e-14,
 -4.032575799413060e-17, -1.098552416198862e-19, -2.794211989483285e-22, -6.482923386124436e-25, -1.295879028683691e-27, -1.837740111530709e-30,  1.992652400030309e+00,
 -4.019885923789582e-05, -1.642745268219334e-07, -5.934759953568263e-10, -1.996219970440467e-12, -6.391530719016573e-15, -1.969341730310928e-17, -5.871376723571514e-20,
 -1.697774191030296e-22, -4.761875579034565e-25, -1.292889577182387e-27, -3.382628469636001e-30,  1.998603644742415e+00, -7.666061521617425e-06, -3.154135465808568e-08,
 -1.152382865442812e-10, -3.942178131544429e-13, -1.292670835929946e-15, -4.113703689102883e-18, -1.279776685015712e-20, -3.910075712826620e-23, -1.176798252794607e-25,
 -3.496054243569318e-28, -1.026651250355149e-30,  4.310065310242152e-04, -2.013689042563235e-06,  7.054638803917748e-09, -2.196321737937212e-11,  6.408318362400411e-14,
 -1.794304364899798e-16,  4.882152548785404e-19, -1.300606364189884e-21,  3.408625341953822e-24, -8.817230816654558e-27,  2.256302196331820e-29, -5.721482508525067e-32,
  3.877536794264945e-03, -1.808981672971379e-05,  6.318512160150554e-08, -1.957169892696689e-10,  5.666605172639477e-13, -1.569367882155203e-15,  4.207531190762824e-18,
 -1.099509491415972e-20,  2.811896297004391e-23, -7.054821069086887e-26,  1.738707468098085e-28, -4.211602698379418e-31,  1.076247476082972e-02, -5.006422007297228e-05,
  1.738173638358640e-07, -5.329033847489550e-10,  1.518821681677294e-12, -4.112315367286695e-15,  1.068686390321722e-17, -2.678194303549441e-20,  6.480093526922766e-23,
 -1.511353867444657e-25,  3.381365605084709e-28, -7.188023848032028e-31,  2.106954988338680e-02, -9.758215590785861e-05,  3.357256818510725e-07, -1.013306555360996e-09,
  2.818422273062311e-12, -7.361588852724529e-15,  1.817013850019426e-17, -4.231543062263520e-20,  9.209305546572481e-23, -1.830694133510542e-25,  3.143604599233561e-28,
 -3.866425794517699e-31,  3.477429298093892e-02, -1.601139277890693e-04,  5.441508071920436e-07, -1.607657866513452e-09,  4.321648381063215e-12, -1.071268849919949e-14,
  2.440794652042068e-17, -5.006202958543174e-20,  8.719652148403269e-23, -1.046118506265163e-25, -4.191343865915527e-29,  8.361983513806623e-31,  5.184396079859943e-02,
 -2.369578327435692e-04,  7.928945585389567e-07, -2.278871246495273e-09,  5.853734618832094e-12, -1.347535599039777e-14,  2.706091657522532e-17, -4.325533187141085e-20,
  3.425714045141830e-23,  1.080957121857498e-25, -7.088302204545323e-28,  2.578841528337373e-30,  7.223743642881510e-02, -3.272441644031784e-04,  1.074445299343692e-06,
 -2.983638775888102e-09,  7.222329455560067e-12, -1.495913504624840e-14,  2.414693341026016e-17, -1.786140827030123e-20, -6.835385959115238e-23,  4.190815331972811e-25,
 -1.452042078805721e-27,  3.835178421736420e-30,  9.590510650209866e-02, -4.299403349576939e-04,  1.380133431771863e-06, -3.674342030444516e-09,  8.232748689446124e-12,
 -1.456429471286649e-14,  1.446712106234317e-17,  2.586221970828159e-20, -2.040670501601751e-22,  7.304449107887788e-25, -1.876110401834997e-27,  3.366156439394933e-30,
  1.227887163374535e-01, -5.438571924949819e-04,  1.700315880753350e-06, -4.301223309811614e-09,  8.704212233215791e-12, -1.186900989743219e-14, -2.056056864145753e-18,
  8.258777161785650e-20, -3.390321375173808e-22,  9.043708471389000e-25, -1.571155700745216e-27,  3.870627481376927e-31,  1.528212045618193e-01, -6.676566232535248e-04,
  2.024588153347165e-06, -4.814749528196838e-09,  8.486045424993719e-12, -6.703403788922049e-15, -2.418857208689923e-17,  1.421789567039608e-19, -4.284348245569428e-22,
  8.060446203058733e-25, -3.112760756284262e-28, -4.760289375822258e-30,  1.859265190716286e-01, -7.998605396945403e-04,  2.342022105565935e-06, -5.168090415727436e-09,
  7.472752071810748e-12,  7.984684616577181e-16, -4.938754629798403e-17,  1.910811720401819e-19, -4.273897792358906e-22,  3.566507398650218e-25,  1.770068420558161e-27,
 -1.032095606297254e-29,  2.220194166254759e-01, -9.388613645961077e-04,  2.641427000211837e-06, -5.319622095913575e-09,  5.616841155754335e-12,  1.017632093563753e-14,
 -7.401955431481885e-17,  2.147180338497901e-19, -3.042604636133613e-22, -4.198528321312137e-25,  4.110453581460948e-27, -1.350195293568050e-29,  2.610052488323113e-01,
 -1.082934127958173e-03,  2.911630786519052e-06, -5.235357508143890e-09,  2.938321516815306e-12,  2.065652572733688e-14, -9.378896834253835e-17,  2.005552732094032e-19,
 -5.324472270536540e-23, -1.373861421657780e-24,  5.814242948930635e-27, -1.153152942392751e-29,  3.027797378414332e-01, -1.230250296634641e-03,  3.141777770399561e-06,
 -4.891197118978826e-09, -4.701226375261913e-13,  3.120278978433896e-14, -1.043394706667756e-16,  1.413062308403284e-19,  2.973411656563961e-22, -2.244849185235965e-24,
  5.920877817705195e-27, -3.090432619776815e-30,  3.472287456551190e-01, -1.378893455388179e-03,  3.321637972739044e-06, -4.274887645933853e-09, -4.443090677800887e-12,
  4.060366199967388e-14, -1.019609299901250e-16,  3.763516992875330e-20,  6.842359781569273e-22, -2.718153411498356e-24,  3.784378162527715e-27,  1.047776809509110e-29,
  3.942280416771685e-01, -1.526876951461639e-03,  3.441922499082219e-06, -3.387573983583500e-09, -8.748124320456096e-12,  4.759190548800186e-14, -8.430749607721485e-17,
 -1.002999413037473e-19,  1.017724121520753e-21, -2.515452137171428e-24, -5.595326124117133e-28,  2.484926908740347e-29,  4.436430738845020e-01, -1.672163601601260e-03,
  3.494598182530135e-06, -2.244831186481482e-09, -1.309730281412609e-11,  5.098661236084533e-14, -5.101554641487509e-17, -2.530109692139480e-19,  1.199248608970924e-21,
 -1.497329811845615e-24, -6.192289608597488e-27,  3.374687776962130e-29,  4.953287498655437e-01, -1.812687539445438e-03,  3.473193639166035e-06, -8.770703343688854e-10,
 -1.716460827888411e-11,  4.984502006390221e-14, -4.106361307760287e-18, -3.938500843989501e-19,  1.145483638416574e-21,  2.531982927274667e-25, -1.140781615508558e-26,
  3.125403141499745e-29,  5.491292349066769e-01, -1.946378250901126e-03,  3.373087731810018e-06,  6.707744755187161e-10, -2.060843012955313e-11,  4.360777815069133e-14,
  5.192840448713752e-17, -4.931287952013150e-19,  8.138592871789650e-22,  2.399054502022774e-24, -1.415223616319412e-26,  1.471476917605763e-29,  6.048777753207959e-01,
 -2.071186804105569e-03,  3.191770329396952e-06,  2.340349812857784e-09, -2.309807204601552e-11,  3.221943202975657e-14,  1.104284137296711e-16, -5.237011124090662e-19,
  2.229612179010690e-22,  4.393408111972120e-24, -1.272939611146963e-26, -1.299330405161285e-29,  6.623965562889745e-01, -2.185114227369816e-03,  2.929064250051248e-06,
  4.061819699512833e-09, -2.434261064197744e-11,  1.620565942984856e-14,  1.632733622804825e-16, -4.671068102820068e-19, -5.389365712073101e-22,  5.604615277603932e-24,
 -6.561584273288587e-27, -4.310983792842789e-29,  7.214966046102057e-01, -2.286241921798921e-03,  2.587296480081618e-06,  5.756639571214445e-09, -2.411997488712318e-11,
 -3.309224696863672e-15,  2.019542036841497e-16, -3.190507778315042e-19, -1.322279785210496e-21,  5.500136736966113e-24,  3.289450050172988e-27, -6.333211266861523e-29,
  7.819777478999491e-01, -2.372763914018093e-03,  2.171406282925783e-06,  7.341124194006511e-09, -2.230372324101036e-11, -2.465648195586220e-14,  2.188911887102650e-16,
 -9.287235523091681e-20, -1.943117761765911e-21,  3.841613713441717e-24,  1.412163044406321e-26, -6.252195112743122e-29,  8.436286429115688e-01, -2.443020657978566e-03,
  1.688977784607979e-06,  8.730710884334911e-09, -1.888475360958237e-11, -4.575380446741154e-14,  2.088160007453468e-16,  1.801838275303802e-19, -2.225087870908563e-21,
  8.267171599796493e-25,  2.225353633572193e-26, -3.617461303958424e-29,  9.062268867307869e-01, -2.495533983203079e-03,  1.150185193393995e-06,  9.844757677912619e-09,
 -1.398515579354279e-11, -6.430840409289549e-14,  1.699859464243188e-16,  4.546071115987800e-19, -2.047914824723595e-21, -2.884579217223508e-24,  2.424660013874889e-26,
  9.829263419965500e-30,  9.695392255554106e-01, -2.529042661005917e-03,  5.676401363209694e-07,  1.061165124224999e-08, -7.861669858227767e-12, -7.807709713183184e-14,
  1.049808427312156e-16,  6.781136874986993e-19, -1.389841831080758e-21, -6.296062800424973e-24,  1.831706408871496e-26,  5.953263132744805e-29,  1.033321876551551e+00,
 -2.542537922338591e-03, -4.386717470679267e-08,  1.097393589419857e-08, -8.967961510935555e-13, -8.515703840677454e-14,  2.086018595752783e-17,  8.019900039685582e-19,
 -3.502425632563564e-22, -8.343861815738191e-24,  5.381684774093693e-27,  9.220033589940486e-29,  1.097320978791270e+00, -2.535298114628801e-03, -6.677379688348388e-07,
  1.089311911202456e-08,  6.423463150322172e-12, -8.427106618781377e-14, -7.146388796145711e-17,  7.923555467125480e-19,  8.584643169649472e-22, -8.241989093431448e-24,
 -1.080316188564826e-26,  9.118443771859964e-29,  1.161273189430731e+00, -2.506921535754998e-03, -1.286046765389646e-06,  1.035376780638338e-08,  1.354498161460496e-11,
 -7.500532976242488e-14, -1.586558918142130e-16,  6.397600160705918e-19,  1.953332979244977e-21, -5.794039449811188e-24, -2.467742267919858e-26,  5.265300601877676e-29,
  1.224906440977832e+00, -2.457356338626175e-03, -1.880130141050822e-06,  9.366491659060635e-09,  1.989222071528479e-11, -5.795600505427812e-14, -2.270460353438232e-16,
  3.644100264187572e-19,  2.651360095001479e-21, -1.547239872478296e-24, -3.088150720095050e-26, -1.040995408842581e-29,  1.287940874612161e+00, -2.386926269384050e-03,
 -2.431270902649672e-06,  7.969423588953896e-09,  2.492282306313204e-11, -3.474811393523657e-14, -2.650691940631770e-16,  1.491900318341631e-20,  2.750843444310915e-21,
  3.300644679001226e-24, -2.651826444222709e-26, -7.206678951277578e-29,  1.350089962944514e+00, -2.296350897824039e-03, -2.921458675932747e-06,  6.227860531702789e-09,
  2.818502657961268e-11, -7.903549055622451e-15, -2.656074531805040e-16, -3.401862492711546e-19,  2.199332975843994e-21,  7.250617395393417e-24, -1.267928986102334e-26,
 -1.046283756064640e-28,  1.411061833229997e+00, -2.186758933930969e-03, -3.334199925408741e-06,  4.231825612708634e-09,  2.937154550511519e-11,  1.944317955162444e-14,
 -2.277258867818986e-16, -6.270929688548373e-19,  1.123601271936028e-21,  9.013178958164510e-24,  5.609775973142918e-27, -9.239356524669866e-29,  1.470560798785047e+00,
 -2.059693214438604e-03, -3.655342426353336e-06,  2.091456916886630e-09,  2.836286217391902e-11,  4.395648170980379e-14, -1.573351694793122e-16, -7.843868333646685e-19,
 -1.942829720145474e-22,  7.999245114573605e-24,  2.125118365038350e-26, -4.069151162700009e-29,  1.528289102138028e+00, -1.917106003406963e-03, -3.873871903109366e-06,
 -6.968572407368120e-11,  2.525303026363491e-11,  6.258604069024566e-14, -6.648317200690970e-17, -7.792669207085040e-19, -1.394167147357666e-21,  4.585789378248279e-24,
  2.809485123479887e-26,  2.556663576760197e-29,  1.583948868238986e+00, -1.761343395357510e-03, -3.982632756900225e-06, -2.123087320097017e-09,  2.035230375436397e-11,
  7.305257093803599e-14,  2.874266927113761e-17, -6.174440335320492e-19, -2.147969714365255e-21,  1.578793830178024e-26,  2.375977596533383e-26,  7.427582481698755e-29,
  1.637244259893882e+00, -1.595117850219447e-03, -3.978921449895439e-06, -3.944979737588575e-09,  1.416324209491460e-11,  7.424525015351812e-14,  1.113794672477030e-16,
 -3.430648044524780e-19, -2.266861503631125e-21, -4.064415289658395e-24,  1.080586555235218e-26,  8.328674650077883e-29,  1.687883820567249e+00, -1.421468233236279e-03,
 -3.864901111578437e-06, -5.426525760927918e-09,  7.330277021530426e-12,  6.644670538421040e-14,  1.671765327145380e-16, -2.763656063698681e-20, -1.765658307354277e-21,
 -6.259680283512088e-24, -4.490608972516740e-27,  5.241220507721389e-29,  1.735582981988357e+00, -1.243707180249955e-03, -3.647790094581463e-06, -6.483561683878171e-09,
  5.667103302763048e-13,  5.132381633139931e-14,  1.877618958020325e-16,  2.496253004456693e-19, -8.565525431862566e-22, -5.991372748464662e-24, -1.526319942735850e-26,
  2.669737926939666e-30,  1.780066705860492e+00, -1.065356150776211e-03, -3.339786079100349e-06, -7.064883127328529e-09, -5.432825959277623e-12,  3.166262692969663e-14,
  1.725453296383406e-16,  4.244450926101673e-19,  1.300699658407015e-22, -3.707342323164394e-24, -1.747143118981188e-26, -3.714778968387324e-29,  1.821072220759995e+00,
 -8.900691489812002e-04, -2.957701051157065e-06, -7.158074875053626e-09, -1.008300683848468e-11,  1.087736773256831e-14,  1.287622391167666e-16,  4.659197922169629e-19,
  8.698331106136156e-22, -6.247797014195059e-25, -1.171979873556403e-26, -4.806042979338349e-29,  1.858351807456013e+00, -7.215467559291904e-04, -2.522300666518850e-06,
 -6.792029329735942e-09, -1.298812719277120e-11, -7.623462387808438e-15,  6.952291511900800e-17,  3.843341461814415e-19,  1.164284592077640e-21,  1.875904534880981e-24,
 -2.451195187354855e-27, -3.106759049527518e-29,  1.891675578899312e+00, -5.634427844787812e-04, -2.057363142998117e-06, -6.035573745908359e-09, -1.399876478287123e-11,
 -2.108992535714060e-14,  1.029548700234545e-17,  2.252765551899865e-19,  1.006029753669053e-21,  2.901386973230358e-24,  4.946641324109548e-27, -3.427567436031016e-30,
  1.920834195637640e+00, -4.192664911855427e-04, -1.588496251980828e-06, -4.992017285690478e-09, -1.323398732761524e-11, -2.796169053007872e-14, -3.524877273446408e-17,
  5.184506169077910e-20,  5.609176662541064e-22,  2.404025716985924e-24,  7.283552103258564e-27,  1.538051586235234e-29,  1.945641454303164e+00, -2.922838012406517e-04,
 -1.141774015001134e-06, -3.789896650949957e-09, -1.106313020792718e-11, -2.815250473705457e-14, -5.883784181837525e-17, -7.864451929766356e-20,  7.659942926884113e-23,
  1.070785928039918e-24,  4.994843337419090e-27,  1.704198662591713e-29,  1.965936688201787e+00, -1.854213594892414e-04, -7.422747986861963e-07, -2.570685387330125e-09,
 -8.047680991652571e-12, -2.301211946073528e-14, -5.955646498579636e-17, -1.346280977493051e-19, -2.380530648452417e-22, -1.681118803777562e-25,  1.095112241813487e-27,
  7.392117089102182e-30,  1.981586934617260e+00, -1.011773129596193e-04, -4.126168756592245e-07, -1.474665691320973e-09, -4.850884308604601e-12, -1.496248180515139e-14,
 -4.353046625322934e-17, -1.191802981398497e-19, -3.037121506861573e-22, -7.017338216827076e-25, -1.375834639962296e-27, -1.788007532956281e-30,  1.992488930317182e+00,
 -4.154209515687032e-05, -1.715921790329477e-07, -6.264644102216009e-10, -2.128913409138001e-12, -6.884530679323365e-15, -2.141611307914737e-17, -6.443120821701954e-20,
 -1.878880368814932e-22, -5.310031293906228e-25, -1.451033059526494e-27, -3.814407548970072e-30,  1.998572466922529e+00, -7.924033024207764e-06, -3.296292988484633e-08,
 -1.217580875876875e-10, -4.210882917784154e-13, -1.395845175698800e-15, -4.490214950046133e-18, -1.411956455912269e-20, -4.360022921747548e-23, -1.326112911739076e-25,
 -3.980926526802812e-28, -1.181142808241114e-30,  4.230630041238043e-04, -1.958289004598845e-06,  6.797115785820710e-09, -2.096597084225110e-11,  6.060885925822072e-14,
 -1.681382357105350e-16,  4.532788359163127e-19, -1.196439696780698e-21,  3.106861737206966e-24, -7.963090398496334e-27,  2.019118709406225e-29, -5.073405786080487e-32,
  3.806173829297433e-03, -1.759357839103132e-05,  6.088989884807097e-08, -1.868961361075035e-10,  5.362585459321665e-13, -1.471982106906021e-15,  3.911893385658202e-18,
 -1.013461700298650e-20,  2.570007414405406e-23, -6.395026438059597e-26,  1.563565315099432e-28, -3.758452938110867e-31,  1.056495903280094e-02, -4.869885356668507e-05,
  1.675656604268460e-07, -5.092465234422419e-10,  1.439080670222764e-12, -3.864599981836390e-15,  9.965200631081216e-18, -2.479281735250342e-20,  5.959607738157318e-23,
 -1.382228005293041e-25,  3.079684995272874e-28, -6.534742553987534e-31,  2.068451692707980e-02, -9.494423359450266e-05,  3.238317887405218e-07, -9.693663562766670e-10,
  2.675457053358228e-12, -6.939396508600174e-15,  1.702559046941669e-17, -3.947150728043744e-20,  8.572479098769881e-23, -1.708357223176533e-25,  2.973229128634280e-28,
 -3.868288737564031e-31,  3.414242313900223e-02, -1.558367294996116e-04,  5.252668224745656e-07, -1.540194165576579e-09,  4.113140592286476e-12, -1.014340681167915e-14,
  2.304470566945288e-17, -4.733225192454195e-20,  8.340873089985668e-23, -1.056019246015685e-25, -8.762530961282944e-30,  6.751784449129566e-31,  5.090864480746284e-02,
 -2.307224901345893e-04,  7.661012815550832e-07, -2.187332671635165e-09,  5.590624670670166e-12, -1.284030050484578e-14,  2.586566173719335e-17, -4.210209656397761e-20,
  3.766465090167628e-23,  8.191105281065356e-26, -6.028234539871588e-28,  2.246410837422935e-30,  7.094542688309796e-02, -3.187898747302338e-04,  1.039325206153351e-06,
 -2.870443652918151e-09,  6.928900289304937e-12, -1.438584369753153e-14,  2.361838147829796e-17, -1.981822699071087e-20, -5.427271066784398e-23,  3.642670485566003e-25,
 -1.291306217876132e-27,  3.474913789979399e-30,  9.420715117952640e-02, -4.190734186273298e-04,  1.336822120596762e-06, -3.544929240202883e-09,  7.944989847396857e-12,
 -1.420910822116184e-14,  1.510369275195100e-17,  1.973861477313913e-20, -1.790864045099995e-22,  6.583329545609336e-25, -1.730286431308943e-27,  3.256628029607104e-30,
  1.206401690472088e-01, -5.304587746765974e-04,  1.649528965274693e-06, -4.163856872201378e-09,  8.466519680934340e-12, -1.189180206080116e-14,  1.093225551596632e-19,
  7.224757292247183e-20, -3.076006910030912e-22,  8.419980153404550e-25, -1.544403067350549e-27,  8.106344756062596e-31,  1.501826088032523e-01, -6.516887281872367e-04,
  1.967621296582583e-06, -4.680075561887301e-09,  8.346486660631727e-12, -7.237679893313581e-15, -2.039515719760122e-17,  1.289305305537949e-19, -3.996888962467586e-22,
  7.897228266956777e-25, -4.972228402757680e-28, -3.717836637815962e-30,  1.827641593622887e-01, -7.813703977972245e-04,  2.280722728056101e-06, -5.048461237539924e-09,
  7.477293867023537e-12, -3.241624864770392e-16, -4.422672150500423e-17,  1.776229316476014e-19, -4.133815453847070e-22,  4.187868946548487e-25,  1.346822175207749e-27,
 -8.936661325934530e-30,  2.183058318842983e-01, -9.179837478232409e-04,  2.578137161062274e-06, -5.228218923416861e-09,  5.803084120688144e-12,  8.470883825724572e-15,
 -6.814581069741165e-17,  2.047704531633817e-19, -3.165559635487425e-22, -2.670027766773653e-25,  3.539883466593380e-27, -1.242687500366246e-29,  2.567197016946141e-01,
 -1.059891548990157e-03,  2.849101817636577e-06, -5.185159715320583e-09,  3.329396355118486e-12,  1.847274040602933e-14, -8.820439541038158e-17,  1.981039891395835e-19,
 -9.864008207779743e-23, -1.151471100913483e-24,  5.304965752890938e-27, -1.157465027682205e-29,  2.979086332491380e-01, -1.205350933255483e-03,  3.083058430030115e-06,
 -4.893861329844673e-09,  1.292174134985431e-13,  2.874712352190281e-14, -1.002615123024145e-16,  1.495735253769602e-19,  2.207518980909932e-22, -2.011271898708791e-24,
  5.745458350809365e-27, -4.811336991844571e-30,  3.417659915238062e-01, -1.352526693878227e-03,  3.269939153100337e-06, -4.339613066258462e-09, -3.655390297248603e-12,
  3.817162994338116e-14, -1.006151049412291e-16,  5.799512192414429e-20,  5.892092067926488e-22, -2.558552023327356e-24,  4.171855100453543e-27,  7.205076849327124e-30,
  3.881753439108737e-01, -1.499506482889040e-03,  3.400462843435252e-06, -3.520040094526671e-09, -7.816728826259725e-12,  4.553842111556388e-14, -8.667358639642721e-17,
 -6.918391837031079e-20,  9.270182160147757e-22, -2.517091744009375e-24,  4.499472784015061e-28,  2.106033786217937e-29,  4.370101575141015e-01, -1.644318053448532e-03,
  3.466436296501757e-06, -2.446299029102476e-09, -1.209036593272111e-11,  4.968151259902741e-14, -5.757101793729780e-17, -2.155424187980849e-19,  1.141237563795562e-21,
 -1.716051560058695e-24, -4.762452245057988e-27,  3.118782718893424e-29,  4.881334976572569e-01, -1.784948682770281e-03,  3.461053863061545e-06, -1.143737893170693e-09,
 -1.616956522502447e-11,  4.961828117358690e-14, -1.462022893307807e-17, -3.571341312518201e-19,  1.146718470485029e-21, -1.754141389692629e-25, -1.001949631233197e-26,
  3.171048780447973e-29,  5.413977344599202e-01, -1.919366890664145e-03,  3.379187604005309e-06,  3.480799119336336e-10, -1.972491463164691e-11,  4.469138742729462e-14,
  3.849761966992193e-17, -4.658113486670921e-19,  8.902041820378481e-22,  1.847272612494767e-24, -1.340515233899892e-26,  1.906855868761744e-29,  5.966442654922862e-01,
 -2.045546537470573e-03,  3.217658829926006e-06,  1.976074798605070e-09, -2.242836356627054e-11,  3.469469921699169e-14,  9.588773989567569e-17, -5.141350043197785e-19,
  3.718414778196484e-22,  3.875041039270709e-24, -1.313475468591417e-26, -5.553251388406791e-30,  6.537032637924224e-01, -2.161493341220281e-03,  2.975480568996068e-06,
  3.675139263665567e-09, -2.398038053208470e-11,  1.996550797323516e-14,  1.499828782257031e-16, -4.811787497826862e-19, -3.423308884676613e-22,  5.306525033008597e-24,
 -8.285506689337676e-27, -3.523009754626000e-29,  7.123934619047332e-01, -2.265273795226506e-03,  2.654059297812185e-06,  5.370450724315853e-09, -2.413843791085199e-11,
  1.425877497370327e-15,  1.924583171485438e-16, -3.581756333932783e-19, -1.122566540191454e-21,  5.577261963284640e-24,  6.006444684458809e-28, -5.869124560401524e-29,
  7.725219840581311e-01, -2.355046392034399e-03,  2.257343264424557e-06,  6.980604010264928e-09, -2.274456538629316e-11, -1.944119330088763e-14,  2.154417827051361e-16,
 -1.527357567303444e-19, -1.795321112044223e-21,  4.350823772365208e-24,  1.132655213664897e-26, -6.421541366502179e-29,  8.338842401170377e-01, -2.429094966001000e-03,
  1.791904067740681e-06,  8.421508084938354e-09, -1.974934664546492e-11, -4.068969103927884e-14,  2.128699887360660e-16,  1.096257245969914e-19, -2.179711927777639e-21,
  1.682322572500034e-24,  2.046294060026689e-26, -4.493086984961623e-29,  8.962638964653181e-01, -2.485863853537475e-03,  1.266937996548674e-06,  9.610931695702774e-09,
 -1.522953485351017e-11, -6.008348789301035e-14,  1.817832066404888e-16,  3.876001140531276e-19, -2.134233638294549e-21, -1.909983908038723e-24,  2.438715198538233e-26,
 -3.346775619997615e-30,  9.594329404648737e-01, -2.523994436786038e-03,  6.941741608922336e-07,  1.047351544658943e-08, -9.396505280046903e-12, -7.533494062886771e-14,
  1.233123393795792e-16,  6.301585408423293e-19, -1.602712152108374e-21, -5.514482688795152e-24,  2.067340135144270e-26,  4.738332753656501e-29,  1.023151856491774e+00,
 -2.542362483966048e-03,  8.767786885995046e-08,  1.094599683993958e-08, -2.593119278350700e-12, -8.438846764928504e-14,  4.311418222122686e-17,  7.860255837238224e-19,
 -6.457807924299846e-22, -8.048780612219162e-24,  9.335035203097224e-27,  8.707693582385236e-29,  1.087169932699320e+00, -2.540115530139924e-03, -5.364597870577836e-07,
  1.098232555846402e-08,  4.722702425182771e-12, -8.571714077512406e-14, -4.893849489006074e-17,  8.150035767562508e-19,  5.549579124997071e-22, -8.592092800707887e-24,
 -6.662845868656249e-27,  9.656024654530351e-29,  1.151225718475125e+00, -2.516709360109899e-03, -1.160551390216348e-06,  1.055828598722932e-08,  1.200828424263075e-11,
 -7.859124797552615e-14, -1.399002062333619e-16,  6.987435898821279e-19,  1.727578104870051e-21, -6.730432032219719e-24, -2.203651801274245e-26,  6.715524945954458e-29,
  1.215047652914504e+00, -2.471942467469652e-03, -1.765861788066566e-06,  9.675201802593807e-09,  1.867948534677449e-11, -6.327314082311499e-14, -2.156648223726852e-16,
  4.481233392955336e-19,  2.573360281578934e-21, -2.786607329339541e-24, -3.096020094546262e-26,  6.971922593287211e-30,  1.278354884374277e+00, -2.405987180326468e-03,
 -2.333269281153839e-06,  8.362283731826117e-09,  2.416432986067881e-11, -4.109471243443198e-14, -2.634027155647897e-16,  1.046364349299970e-19,  2.849838985040536e-21,
  2.179794534380285e-24, -2.943758478366145e-26, -6.017228775880686e-29,  1.340858300136162e+00, -2.319415977877857e-03, -2.844024933766753e-06,  6.677206944568094e-09,
  2.796248037846200e-11, -1.438424026195202e-14, -2.741088767364434e-16, -2.657381399505684e-19,  2.450114966762087e-21,  6.651234072142681e-24, -1.728764066834825e-26,
 -1.043168994481352e-28,  1.402261783229385e+00, -2.213221389049441e-03, -3.280586495230959e-06,  4.704578401987543e-09,  2.970435491158466e-11,  1.377141913542355e-14,
 -2.447320755550653e-16, -5.859109935248266e-19,  1.451102871932168e-21,  9.152757251779420e-24,  1.285412312323571e-27, -1.038794382895286e-28,  1.462263710376900e+00,
 -2.088827783775113e-03, -3.627493782314172e-06,  2.552083107144516e-09,  2.920244989754959e-11,  3.991645299924337e-14, -1.793405997520073e-16, -7.858360641935750e-19,
  1.085138173630147e-22,  8.808487824027554e-24,  1.908602796918295e-26, -5.783522253562494e-29,  1.520558700699667e+00, -1.948093360192018e-03, -3.872242835415216e-06,
  3.442823253086787e-10,  2.648700236030248e-11,  6.072372991476503e-14, -8.890085639608444e-17, -8.210199878014398e-19, -1.208613873490360e-21,  5.728251878976512e-24,
  2.892890094102494e-26,  1.192410933032518e-29,  1.576839619140761e+00, -1.793300718523790e-03, -4.006107663872312e-06, -1.785730585969536e-09,  2.181881293604332e-11,
  7.352717398736800e-14,  1.049337590106087e-17, -6.859801955468822e-19, -2.129513443396187e-21,  1.030762325379687e-24,  2.696484100687154e-26,  7.096073150461931e-29,
  1.630799831519987e+00, -1.627134614664598e-03, -4.024852072455946e-06, -3.706346800370703e-09,  1.567405717376490e-11,  7.679475858582648e-14,  1.007367391096914e-16,
 -4.178547476238407e-19, -2.404496022882670e-21, -3.556593983908712e-24,  1.463989965628234e-26,  9.078904639455099e-29,  1.682135699750329e+00, -1.452645819116552e-03,
 -3.929271154137519e-06, -5.298392238167902e-09,  8.699236932990181e-12,  7.044306231876910e-14,  1.655775967293903e-16, -8.777314281192268e-20, -1.993651295981649e-21,
 -6.389549994660702e-24, -1.911516953037916e-27,  6.495172760622217e-29,  1.730549296197644e+00, -1.273200478207740e-03, -3.725503757417811e-06, -6.466035348353243e-09,
  1.638798793790302e-12,  5.591067513642401e-14,  1.943344053902380e-16,  2.186471456519000e-19, -1.083178748304616e-21, -6.596844373406462e-24, -1.494002834895657e-26,
  1.233108431697819e-29,  1.775751305728116e+00, -1.092414981918700e-03, -3.425064590697644e-06, -7.146513275706555e-09, -4.757198010482486e-12,  3.594667050315466e-14,
  1.844670194232681e-16,  4.263338525102306e-19, -1.636352192940824e-23, -4.438410084198943e-24, -1.906747528918342e-26, -3.515456474343494e-29,  1.817464073084886e+00,
 -9.140770699155965e-04, -3.044558183104720e-06, -7.317490207826814e-09, -9.833483685222030e-12,  1.412733171667219e-14,  1.421936277938256e-16,  4.932998809222895e-19,
  8.383802973555369e-22, -1.137274119867783e-24, -1.393943534573077e-26, -5.279567267161058e-29,  1.855424742425449e+00, -7.420547224199541e-04, -2.605056606325204e-06,
 -7.000964725524290e-09, -1.312301725079277e-11, -5.821504443447054e-15,  8.081587216295138e-17,  4.226500666436451e-19,  1.229705984820572e-21,  1.748653677826619e-24,
 -3.958847032892131e-27, -3.758939758958458e-29,  1.889388425829837e+00, -5.801952367851362e-04, -2.131147779210601e-06, -6.262912733845983e-09, -1.441756223072843e-11,
 -2.076340507429595e-14,  1.706990444711632e-17,  2.591785397530786e-19,  1.113995795604019e-21,  3.095222490201674e-24,  4.718540848549512e-27, -7.081049758191331e-30,
  1.919131329201293e+00, -4.322177204734505e-04, -1.649689524360417e-06, -5.208280386716620e-09, -1.380155242987369e-11, -2.878813084593435e-14, -3.353240071070902e-17,
  7.123670684511164e-20,  6.528710837280596e-22,  2.709034955048243e-24,  7.969690888220543e-27,  1.576081465560514e-29,  1.944453758376524e+00, -3.016029608652995e-04,
 -1.188333666529347e-06, -3.971488602823040e-09, -1.164047816269653e-11, -2.959072348136182e-14, -6.099949311644541e-17, -7.553649855774433e-20,  1.189307379302948e-22,
  1.286240339019730e-24,  5.794701491284055e-27,  1.935201062520507e-29,  1.965182927857893e+00, -1.914851752359627e-04, -7.739110438140859e-07, -2.703209181155417e-09,
 -8.522526740302247e-12, -2.448757573468849e-14, -6.343354522587449e-17, -1.423335109113958e-19, -2.432341117357609e-22, -1.173466369666889e-25,  1.454922742471343e-27,
  9.009227480605999e-30,  1.981175509527623e+00, -1.045503744760851e-04, -4.307886111077247e-07, -1.554731755732898e-09, -5.160857333746380e-12, -1.604837952453838e-14,
 -4.700745203781421e-17, -1.293140594195985e-19, -3.299838880143201e-22, -7.583132285548090e-25, -1.452336435946762e-27, -1.677967980178430e-30,  1.992319968018863e+00,
 -4.294549259429148e-05, -1.793187636007053e-07, -6.616571021265070e-10, -2.271893607534818e-12, -7.420863754390277e-15, -2.330731634539925e-17, -7.076102171347408e-20,
 -2.080906019952989e-22, -5.925404082824649e-25, -1.629382718074278e-27, -4.302184351560958e-30,  1.998540233965396e+00, -8.193697547910942e-06, -3.446539201062498e-08,
 -1.287248280368514e-10, -4.501157039812181e-13, -1.508516690251672e-15, -4.905835867238900e-18, -1.559433393782440e-20, -4.867384747746076e-23, -1.496253235998763e-25,
 -4.539172254926596e-28, -1.360836420035521e-30,  4.153370314858204e-04, -1.904902211088669e-06,  6.551233498974195e-09, -2.002255132755554e-11,  5.735222489634532e-14,
 -1.576505723921045e-16,  4.211283887681998e-19, -1.101455247066783e-21,  2.834206004102017e-24, -7.198358638590244e-27,  1.808688779508695e-29, -4.503632372778988e-32,
  3.736759753023134e-03, -1.711528655719896e-05,  5.869767079118209e-08, -1.785465102371541e-10,  5.077352443058923e-13, -1.381411050368355e-15,  3.639300066097784e-18,
 -9.347874521498484e-21,  2.350656733926219e-23, -5.801457393348976e-26,  1.407204359571269e-28, -3.356828843828794e-31,  1.037280651133250e-02, -4.738238647737628e-05,
  1.615903447111956e-07, -4.868268063027466e-10,  1.364125183153399e-12, -3.633554568119081e-15,  9.296969356247203e-18, -2.296303685273013e-20,  5.483502833343174e-23,
 -1.264611983119383e-25,  2.805449204938371e-28, -5.939735067533269e-31,  2.030984864312697e-02, -9.239939155084632e-05,  3.124517272432577e-07, -9.276475157581534e-10,
  2.540667321726995e-12, -6.543740384375419e-15,  1.595788458111685e-17, -3.682445324307023e-20,  7.978468521509172e-23, -1.592820878299009e-25,  2.803949119674501e-28,
 -3.818921492887032e-31,  3.352736499476863e-02, -1.517074206904805e-04,  5.071727554586050e-07, -1.475977256115470e-09,  3.915697379697906e-12, -9.605939420057046e-15,
  2.175619805120670e-17, -4.472401130797677e-20,  7.960753000991830e-23, -1.053999017536079e-25,  1.787619315193653e-29,  5.395393322854657e-31,  4.999784835148785e-02,
 -2.246971705005794e-04,  7.403816230328794e-07, -2.099903794490663e-09,  5.339931646683576e-12, -1.223353216922854e-14,  2.470408801347291e-17, -4.085411281456227e-20,
  4.020242096618702e-23,  5.968588024641876e-26, -5.105725042282770e-28,  1.952892204171741e-30,  6.968668106587723e-02, -3.106111913828063e-04,  1.005535661329629e-06,
 -2.761852376959980e-09,  6.646805915065855e-12, -1.382584594858190e-14,  2.304105899027877e-17, -2.135481179231416e-20, -4.205290943684909e-23,  3.155720269188840e-25,
 -1.145892670441367e-27,  3.138836729890481e-30,  9.255198026688768e-02, -4.085468586978464e-04,  1.295036375012247e-06, -3.420062988207788e-09,  7.664474080856264e-12,
 -1.384061356887760e-14,  1.557961253148523e-17,  1.437396978332379e-20, -1.565980422813982e-22,  5.919484040119450e-25, -1.589948556421506e-27,  3.118447747027565e-30,
  1.185444131861421e-01, -5.174601232621906e-04,  1.600367622401970e-06, -4.030294434939400e-09,  8.228868103491771e-12, -1.186598783527648e-14,  1.998921811491742e-18,
  6.287749484722704e-20, -2.783912007763638e-22,  7.810366813657667e-25, -1.501324249295480e-27,  1.132096429258204e-30,  1.476069833358422e-01, -6.361701423652469e-04,
  1.912256792833360e-06, -4.547715197633606e-09,  8.197123281044912e-12, -7.685262158351700e-15, -1.695991812649197e-17,  1.165912242345343e-19, -3.716537941213417e-22,
  7.668352561693783e-25, -6.406576175718274e-28, -2.825411911853788e-30,  1.796747885218640e-01, -7.633649091473750e-04,  2.220858617211928e-06, -4.928932409050962e-09,
  7.460591388075448e-12, -1.327403001588882e-15, -3.943613808892374e-17,  1.646455947825224e-19, -3.974267815534269e-22,  4.651769144575376e-25,  9.819029788094065e-28,
 -7.670200574203468e-30,  2.146747519875885e-01, -8.976080142961795e-04,  2.515960938268963e-06, -5.134101169494394e-09,  5.956605272010151e-12,  6.903034644214987e-15,
 -6.255531136417713e-17,  1.945131463915787e-19, -3.237481899810142e-22, -1.360209326935214e-25,  3.017195587150949e-27, -1.133072877005934e-29,  2.525253283701749e-01,
 -1.037346689178958e-03,  2.787211347672714e-06, -5.129046874648837e-09,  3.678129407518232e-12,  1.642200431104358e-14, -8.270762000716175e-17,  1.943242194602602e-19,
 -1.363958625529212e-22, -9.494176589249122e-25,  4.799084978639286e-27, -1.138618338770035e-29,  2.931361866237029e-01, -1.180921293158601e-03,  3.024363052464011e-06,
 -4.887323615017355e-09,  6.804402009888739e-13,  2.639183684215399e-14, -9.598512803848572e-17,  1.555230090429104e-19,  1.524280022538548e-22, -1.786101304749666e-24,
  5.503533399641253e-27, -6.121697887558600e-30,  3.364078726359057e-01, -1.326576419175406e-03,  3.217537648712748e-06, -4.392122462953710e-09, -2.915963136403497e-12,
  3.577840042441874e-14, -9.874088973510029e-17,  7.540886479288981e-20,  5.001735052870187e-22, -2.386206368447901e-24,  4.424680051825943e-27,  4.356251260589129e-30,
  3.822314549504718e-01, -1.472473799735264e-03,  3.357501643925548e-06, -3.637935230118517e-09, -6.926902004403251e-12,  4.343827778267741e-14, -8.820901950600141e-17,
 -4.096395893038776e-20,  8.369403645421645e-22, -2.481637957673280e-24,  1.296459835336873e-27,  1.745270438237962e-29,  4.304881578185600e-01, -1.616707198991179e-03,
  3.435952574211739e-06, -2.631872893080458e-09, -1.111102049461044e-11,  4.823145429919652e-14, -6.310446532440980e-17, -1.800453932249275e-19,  1.076354015401534e-21,
 -1.879925121802214e-24, -3.451953504503172e-27,  2.834386073383865e-29,  4.810489867540506e-01, -1.757319474127055e-03,  3.445809407281217e-06, -1.394534401979194e-09,
 -1.518149704144628e-11,  4.915153661219840e-14, -2.410773974754531e-17, -3.206148017684518e-19,  1.133525469152575e-21, -5.483336199983218e-25, -8.628904217388424e-27,
  3.137947887231580e-29,  5.337743528685797e-01, -1.892321978937827e-03,  3.381500618097895e-06,  3.967772485172651e-11, -1.882288703097009e-11,  4.546209445412309e-14,
  2.586298282340790e-17, -4.363625682389858e-19,  9.472661763039884e-22,  1.328896290241306e-24, -1.248952195758259e-26,  2.238423346771088e-29,  5.885137035233978e-01,
 -2.019716462231614e-03,  3.239241894826286e-06,  1.622892302272659e-09, -2.171261509982130e-11,  3.682472545631502e-14,  8.167879137465728e-17, -5.001058096870720e-19,
  5.018455278296573e-22,  3.346782217755472e-24, -1.322973421362585e-26,  1.097939451756454e-30,  6.451051682603467e-01, -2.137519581051759e-03,  3.017293921826768e-06,
  3.294838633246309e-09, -2.354617145224509e-11,  2.340235727911345e-14,  1.363847549967466e-16, -4.891436365647563e-19, -1.576139344722516e-22,  4.946429087482830e-24,
 -9.661896625187609e-27, -2.735356234388612e-29,  7.033752305625774e-01, -2.243790101083729e-03,  2.716189161000132e-06,  4.984711343302205e-09, -2.406456289817910e-11,
  5.920656459998553e-15,  1.819566780129021e-16, -3.908855791742195e-19, -9.219604995839614e-22,  5.551246163914310e-24, -1.860008585662510e-27, -5.300798991824845e-29,
  7.631384377375456e-01, -2.336658791181373e-03,  2.338915108859145e-06,  6.613859740282987e-09, -2.308206255502993e-11, -1.432825389635524e-14,  2.103850156785392e-16,
 -2.075980513110133e-19, -1.631218322744024e-21,  4.747286683928531e-24,  8.497536420521566e-27, -6.408868763228870e-29,  8.241971630897180e-01, -2.414360932933573e-03,
  1.891040273960621e-06,  8.099286673114846e-09, -2.051184351454341e-11, -3.555179739399508e-14,  2.149732060361508e-16,  4.099793447549191e-20, -2.104911555955294e-21,
  2.459118309345747e-24,  1.832614742720722e-26, -5.189047133621689e-29,  8.863414365233349e-01, -2.475271257046253e-03,  1.380768264047800e-06,  9.357886375645917e-09,
 -1.638673769440301e-11, -5.559823149808585e-14,  1.916708758292934e-16,  3.183922436971350e-19, -2.185503797819944e-21, -9.411642774075363e-25,  2.396339949997514e-26,
 -1.575708914330551e-29,  9.493488617336003e-01, -2.517940984041955e-03,  8.189050976906028e-07,  1.031128446344950e-08, -1.087221064039546e-11, -7.216968425209630e-14,
  1.402100794721900e-16,  5.758588604536977e-19, -1.785880695677890e-21, -4.649645639519473e-24,  2.247319267820978e-26,  3.431188916685225e-29,  1.012984640133204e+00,
 -2.541136486363534e-03,  2.187253975516948e-07,  1.089106843510531e-08, -4.268771716089480e-12, -8.309222279790478e-14,  6.479058539179054e-17,  7.608039416575945e-19,
 -9.279107161716731e-22, -7.600806516889613e-24,  1.300865605058790e-26,  7.952847596048149e-29,  1.077001723520175e+00, -2.543878902900527e-03, -4.042752596737494e-07,
  1.104411803020633e-08,  2.998471951215650e-12, -8.661610416231663e-14, -2.591659228459980e-17,  8.277701192478927e-19,  2.418783726045073e-22, -8.772672024240581e-24,
 -2.347487514013959e-27,  9.911639649526177e-29,  1.141141119094409e+00, -2.525483827861388e-03, -1.032751605804544e-06,  1.073766826706898e-08,  1.040449929734759e-11,
 -8.170805797234318e-14, -1.195990340711503e-16,  7.499852549605840e-19,  1.470164250036893e-21, -7.548882152197881e-24, -1.879252759772575e-26,  7.997946708160413e-29,
  1.205132371615202e+00, -2.485599969248077e-03, -1.648008795026470e-06,  9.963673070958009e-09,  1.736332698323041e-11, -6.828932306559406e-14, -2.019812836158176e-16,
  5.286276839551641e-19,  2.450872830331525e-21, -4.013622640319966e-24, -3.025993130399584e-26,  2.489784899714029e-29,  1.268694248071981e+00, -2.424245436948658e-03,
 -2.230630332658603e-06,  8.741995560852192e-09,  2.327950981118018e-11, -4.737085048820147e-14, -2.591860195298635e-16,  1.968546488827009e-19,  2.906515426721137e-21,
  9.534352382817409e-25, -3.177451753212028e-26, -4.564311300586755e-29,  1.331535649999265e+00, -2.341840089818187e-03, -2.761224710272659e-06,  7.121945346558719e-09,
  2.760845345722341e-11, -2.104306544933063e-14, -2.804168999712270e-16, -1.836457444795905e-19,  2.676013124733762e-21,  5.868747188121953e-24, -2.181037311345547e-26,
 -1.006990750106239e-28,  1.393356777268647e+00, -2.239232162831566e-03, -3.221271895952203e-06,  5.181726897439114e-09,  2.991974716077284e-11,  7.706535003657426e-15,
 -2.604379364830529e-16, -5.342029097568046e-19,  1.780398985254815e-21,  9.109814785056154e-24, -3.501276772106324e-27, -1.133080477584165e-28,  1.453850564591373e+00,
 -2.117717231861576e-03, -3.594039782929869e-06,  3.025467607546377e-09,  2.995595822744916e-11,  3.534892821809246e-14, -2.012467036714207e-16, -7.771478745496968e-19,
  4.387011452989666e-22,  9.515881521132566e-24,  1.615587601551548e-26, -7.536962530653273e-29,  1.512704407830692e+00, -1.979047481351297e-03, -3.865529014680562e-06,
  7.776663409240677e-10,  2.767825693087821e-11,  5.831007484721959e-14, -1.123982769037920e-16, -8.561720715743282e-19, -9.814828704053237e-22,  6.891329085208068e-24,
  2.910747223465290e-26, -4.203449047096184e-30,  1.569602191354364e+00, -1.825429248368555e-03, -4.025393270779342e-06, -1.424858216348416e-09,  2.329027939966191e-11,
  7.354086722202415e-14, -9.660994040401805e-18, -7.533167228246290e-19, -2.072253080318506e-21,  2.170195648977905e-24,  2.996165093767690e-26,  6.475336533114699e-29,
  1.624226619919597e+00, -1.659506954986027e-03, -4.067772425768085e-06, -3.443147499386915e-09,  1.723313604638954e-11,  7.906323240146022e-14,  8.794119528107822e-17,
 -4.967262687049125e-19, -2.521012425855273e-21, -2.889202100760554e-24,  1.877373334311164e-26,  9.682676129374158e-29,  1.676261848941022e+00, -1.484331836513095e-03,
 -3.991969545030393e-06, -5.147718612108223e-09,  1.014759957235076e-11,  7.438001089426094e-14,  1.621921409992387e-16, -1.552593025032059e-19, -2.224327682434439e-21,
 -6.405006123599244e-24,  1.234856424860992e-27,  7.814683405254452e-29,  1.725396395549438e+00, -1.303314345569866e-03, -3.802901129488128e-06, -6.430613439363100e-09,
  2.804127256987398e-12,  6.064402600119374e-14,  1.999347440599387e-16,  1.800715605758664e-19, -1.331261685754493e-21, -7.180324133446731e-24, -1.414950467003525e-26,
  2.392768125540541e-29,  1.771326299879248e+00, -1.120159769017491e-03, -3.511254925940905e-06, -7.216632375909730e-09, -3.993026542295185e-12,  4.051691499727175e-14,
  1.963719490243096e-16,  4.231035230047494e-19, -1.902393083341372e-22, -5.231104621091511e-24, -2.054079257274627e-26, -3.151649567320912e-29,  1.813758491998838e+00,
 -9.387874269162288e-04, -3.133302142405728e-06, -7.472375402991674e-09, -9.515676283348912e-12,  1.770871733519723e-14,  1.563746699674572e-16,  5.193607442843861e-19,
  7.868300523214984e-22, -1.742638851536502e-24, -1.636085648243641e-26, -5.719254129517706e-29,  1.852414305506731e+00, -7.632347991817842e-04, -2.690331482326102e-06,
 -7.211754953988690e-09, -1.321906973665719e-11, -3.735409480145387e-15,  9.321020878312028e-17,  4.629739612008218e-19,  1.289389608972587e-21,  1.555130088409556e-24,
 -5.770457220986949e-27, -4.488308707545377e-29,  1.887033064959105e+00, -5.975489918101832e-04, -2.207700442815859e-06, -6.496891074011095e-09, -1.482812447826575e-11,
 -2.026251092403769e-14,  2.484298083286501e-17,  2.966449961180044e-19,  1.228734583451480e-21,  3.276457871545972e-24,  4.309920363016052e-27, -1.165657130611498e-29,
  1.917375662099859e+00, -4.456690321876591e-04, -1.713532977883686e-06, -5.433754330957934e-09, -1.438518866674096e-11, -2.956651980096980e-14, -3.123017885288558e-17,
  9.375187108728437e-20,  7.563020693540788e-22,  3.041733194491060e-24,  8.665554141492295e-27,  1.580462235845834e-29,  1.943228026831366e+00, -3.113034733587542e-04,
 -1.237128805151200e-06, -4.162551023328562e-09, -1.224710141735226e-11, -3.107961709920389e-14, -6.305394417321280e-17, -7.094339654768045e-20,  1.696193978447822e-22,
  1.535787707646446e-24,  6.701120707111263e-27,  2.188564220567076e-29,  1.964404395813941e+00, -1.978085735197600e-04, -8.071841500388723e-07, -2.843571709345530e-09,
 -9.027829678850190e-12, -2.605868789638646e-14, -6.752840276701320e-17, -1.501725547925439e-19, -2.463106204173542e-22, -5.067980942138646e-26,  1.892406421835499e-27,
  1.093055515417070e-29,  1.980750295237888e+00, -1.080727390404011e-04, -4.499516283866312e-07, -1.639935764378506e-09, -5.493406272263608e-12, -1.722122674806225e-14,
 -5.078026323387330e-17, -1.403216858787318e-19, -3.583462024883533e-22, -8.178340646934163e-25, -1.522329198550300e-27, -1.488642519626017e-30,  1.992145265774797e+00,
 -4.441243167963326e-05, -1.874817487065131e-07, -6.992258182276612e-10, -2.426069098648460e-12, -8.004787674918554e-15, -2.538514824322051e-17, -7.777418267326681e-20,
 -2.306422563070261e-22, -6.616589227313195e-25, -1.830553429900108e-27, -4.852937180855780e-30,  1.998506897769924e+00, -8.475724242470941e-06, -3.605431781131982e-08,
 -1.361745908705408e-10, -4.814997375469413e-13, -1.631677557286853e-15, -5.365118552539536e-18, -1.724170610908628e-20, -5.440214571402182e-23, -1.690388434304890e-25,
 -5.182827539463440e-28, -1.570163088552421e-30,  4.078207423753027e-04, -1.853438061867817e-06,  6.316366397888324e-09, -1.912960097386788e-11,  5.429783812873427e-14,
 -1.479035660841130e-16,  3.915193821295453e-19, -1.014771062705216e-21,  2.587624034032715e-24, -6.512992560776898e-27,  1.621793274506211e-29, -4.002121878808757e-32,
  3.669224392232512e-03, -1.665413938872278e-05,  5.660295865337107e-08, -1.706391139358933e-10,  4.809596855757820e-13, -1.297125626533804e-15,  3.387784127926165e-18,
 -8.628022637451666e-21,  2.151590066634840e-23, -5.267036183177516e-26,  1.267495744457652e-28, -3.000580462768418e-31,  1.018582592874144e-02, -4.611266580964947e-05,
  1.558770195886860e-07, -4.655702639490361e-10,  1.293634291453166e-12, -3.417948730909414e-15,  8.677901159012794e-18, -2.127904192577886e-20,  5.047826821646538e-23,
 -1.157457884366841e-25,  2.556198750384441e-28, -5.398288741340144e-31,  1.994518076601908e-02, -8.994362356515496e-05,  3.015596087089672e-07, -8.880233734359510e-10,
  2.413540357290813e-12, -6.172840891076032e-15,  1.496169663786008e-17, -3.436095788153848e-20,  7.424838574070698e-23, -1.484000079666162e-25,  2.637733346418177e-28,
 -3.730862392489659e-31,  3.292853938642970e-02, -1.477198349042203e-04,  4.898306861608419e-07, -1.414835098903737e-09,  3.728700117620658e-12, -9.098533573777092e-15,
  2.053902072613892e-17, -4.223709837524379e-20,  7.583140439592133e-23, -1.042450544870558e-25,  3.903673441081250e-29,  4.256076340744885e-31,  4.911074820904473e-02,
 -2.188734788246401e-04,  7.156874400995607e-07, -2.016390425451703e-09,  5.101098086522162e-12, -1.165421381831405e-14,  2.357847940741021e-17, -3.953703456933922e-20,
  4.200348963830909e-23,  4.090300414935218e-26, -4.304544205588730e-28,  1.694281414124720e-30,  6.846011749505776e-02, -3.026976878961564e-04,  9.730224978792831e-07,
 -2.657685778031997e-09,  6.375769675068247e-12, -1.328017762540091e-14,  2.242593089947042e-17, -2.252731718586164e-20, -3.148492915364713e-23,  2.724050325622500e-25,
 -1.014725623633317e-27,  2.827358436205578e-30,  9.093825640489789e-02, -3.983486668893357e-04,  1.254722340018757e-06, -3.299625458369903e-09,  7.391430672125642e-12,
 -1.346242021446642e-14,  1.591504541776912e-17,  9.691786007527482e-21, -1.364000048263846e-22,  5.310494133895904e-25, -1.456150821947117e-27,  2.960689509664188e-30,
  1.164998754088055e-01, -5.048484161801950e-04,  1.552786239004796e-06, -3.900527915931727e-09,  7.992165600351461e-12, -1.179786796758877e-14,  3.638917334028976e-18,
  5.440736537050606e-20, -2.513421343657614e-22,  7.220551084503952e-25, -1.446036862376103e-27,  1.368145401672700e-30,  1.450925563808312e-01, -6.210881605544034e-04,
  1.858465993360295e-06, -4.417811896720425e-09,  8.039605248538754e-12, -8.054444116742352e-15, -1.385775123602939e-17,  1.051348249693568e-19, -3.445368276525453e-22,
  7.389548374737737e-25, -7.478476586405295e-28, -2.067879102147807e-30,  1.766564908860822e-01, -7.458326020285344e-04,  2.162426606633302e-06, -4.809825214274312e-09,
  7.424944710597592e-12, -2.219970762418317e-15, -3.500154077223918e-17,  1.522028207351257e-19, -3.800516082562708e-22,  4.980496226020928e-25,  6.700904616047522e-28,
 -6.522610436442374e-30,  2.111241874142409e-01, -8.777251334777778e-04,  2.454927855119237e-06, -5.037770741071742e-09,  6.080087779532852e-12,  5.465889199587503e-15,
 -5.725455808645253e-17,  1.840971931231699e-19, -3.265897810855107e-22, -2.498228515486758e-26,  2.542670851474549e-27, -1.024172737621204e-29,  2.484201486318992e-01,
 -1.015294167926466e-03,  2.726026379798453e-06, -5.067675293473706e-09,  3.987157714031404e-12,  1.450179088016515e-14, -7.733252696406345e-17,  1.894487618607076e-19,
 -1.672394337970504e-22, -7.673770764723616e-25,  4.305633730540076e-27, -1.101761776756236e-29,  2.884605201364762e-01, -1.156960755882880e-03,  2.965797508581937e-06,
 -4.872337552764419e-09,  1.185595835231920e-12,  2.414094277267597e-14, -9.157156265002548e-17,  1.594138525029701e-19,  9.202317182637425e-23, -1.571651155063371e-24,
  5.212059852680736e-27, -7.071807434704830e-30,  3.311527127111971e-01, -1.301047679455570e-03,  3.164575445396643e-06, -4.433181337761260e-09, -2.223912899255930e-12,
  3.343568693166338e-14, -9.641803245663547e-17,  9.007445029571271e-20,  4.174951904645797e-22, -2.206132098750338e-24,  4.561291210751428e-27,  1.919917403931313e-30,
  3.763950007209325e-01, -1.445790226315093e-03,  3.313209734303359e-06, -3.741930898887450e-09, -6.079384227826813e-12,  4.131044164538491e-14, -8.899441193991828e-17,
 -1.559984084593599e-20,  7.487106838772707e-22, -2.415431685356227e-24,  1.989311185287847e-27,  1.408363345573394e-29,  4.240761000707832e-01, -1.589348857724966e-03,
  3.403335003217325e-06, -2.802016121347723e-09, -1.016192497699319e-11,  4.666028054824742e-14, -6.767388001423923e-17, -1.467091636160223e-19,  1.006483892983057e-21,
 -1.993937717539858e-24, -2.270590906979731e-27,  2.533664590084364e-29,  4.740747300919738e-01, -1.729823991396055e-03,  3.427649900761690e-06, -1.629608524043738e-09,
 -1.420495822364781e-11,  4.846930255816365e-14, -3.258056172868619e-17, -2.847217553393948e-19,  1.107903226845351e-21, -8.661226402173845e-25, -7.267729635975017e-27,
  3.039537113832645e-29,  5.262591648415936e-01, -1.865273119986401e-03,  3.380199856667576e-06, -2.541848992151853e-10, -1.790840981862103e-11,  4.593965433922159e-14,
  1.407572211209684e-17, -4.053790523319394e-19,  9.863583642639572e-22,  8.497705261414331e-25, -1.144973127965223e-26,  2.472447025502000e-29,  5.804867806215991e-01,
 -1.993730477431736e-03,  3.256656827806871e-06,  1.281484198923146e-09, -2.095764208311903e-11,  3.861890325085707e-14,  6.791804119538700e-17, -4.822209383132886e-19,
  6.128321220994026e-22,  2.820325685265946e-24, -1.305098042243244e-26,  6.879266204357180e-30,  6.366036080532208e-01, -2.113229445277503e-03,  3.054587561867575e-06,
  2.922017448074961e-09, -2.304650360039497e-11,  2.651083102065217e-14,  1.226443474501182e-16, -4.914149467910460e-19,  1.323163378073434e-23,  4.538156009013416e-24,
 -1.069605586205782e-26, -1.970880069221108e-29,  6.944438987958724e-01, -2.221827856690133e-03,  2.773700164992853e-06,  4.600859134622201e-09, -2.390338314298344e-11,
  1.015312940087385e-14,  1.706287585769904e-16, -4.172096088642914e-19, -7.240001728263696e-22,  5.432049721106161e-24, -4.052849559778478e-27, -4.656423795979933e-29,
  7.538297189779091e-01, -2.317636303370781e-03,  2.416056974104948e-06,  6.242526480429839e-09, -2.331863586757172e-11, -9.354504827813996e-15,  2.038676126132268e-16,
 -2.570024929424066e-19, -1.454873845114945e-21,  5.031199850912504e-24,  5.711080021108371e-27, -6.231294997738624e-29,  8.145705836026564e-01, -2.398849476419108e-03,
  1.986240021660323e-06,  7.765689468819349e-09, -2.117123188106738e-11, -3.038618975750953e-14,  2.151924388809601e-16, -2.480587157133064e-20, -2.003753826445834e-21,
  3.144868016961558e-24,  1.592434720857251e-26, -5.696917255607538e-29,  8.764631485848762e-01, -2.463780472451499e-03,  1.491453896460886e-06,  9.087055682895591e-09,
 -1.745202015213425e-11, -5.089907819622957e-14,  1.996029694462280e-16,  2.480974467855062e-19, -2.202330401167110e-21,  9.099148427239789e-29,  2.301712429174175e-26,
 -2.704391430857694e-29,  9.392909796185868e-01, -2.510897867330801e-03,  9.415497539816468e-07,  1.012597014174126e-08, -1.228068186651947e-11, -6.861775990652780e-14,
  1.555101419959288e-16,  5.162086915527831e-19, -1.936759448585071e-21, -3.724487007685605e-24,  2.368619221802856e-26,  2.078890839353512e-29,  1.002824419710322e+00,
 -2.538865198719713e-03,  3.489538691343211e-07,  1.080956499820956e-08, -5.913359328294937e-12, -8.128522302542579e-14,  8.563701105405678e-17,  7.268398465080079e-19,
 -1.191354561045100e-21, -7.013179157251907e-24,  1.630225010425690e-26,  6.986018927449422e-29,  1.066820579834995e+00, -2.546582303564966e-03, -2.715152445427188e-07,
  1.107820910188880e-08,  1.261810548680683e-12, -8.695938923552545e-14, -2.678224877226626e-18,  8.304475863511724e-19, -7.457562472058791e-23, -8.779241428326275e-24,
  2.016437917532443e-27,  9.876269934620401e-29,  1.131023479650411e+00, -2.533227727780863e-03, -9.029551674400145e-07,  1.089091824164780e-08,  8.743361726811168e-12,
 -8.432137974918015e-14, -9.798266137796776e-17,  7.925443611407972e-19,  1.185752399372405e-21, -8.226892813355913e-24, -1.503036101728023e-26,  9.063344181942128e-29,
  1.195164367365183e+00, -2.498301165961273e-03, -1.526823748776155e-06,  1.023030181759356e-08,  1.595030914657316e-11, -7.295053441663437e-14, -1.861050907028066e-16,
  6.045126204600242e-19,  2.284907397057767e-21, -5.196829694417807e-24, -2.877037773246353e-26,  4.274242985155573e-29,  1.258962249472174e+00, -2.441664605985781e-03,
 -2.123523906973095e-06,  9.106552466645346e-09,  2.227038904237812e-11, -5.351463898210876e-14, -2.523685806877817e-16,  2.901633778026649e-19,  2.917520837219153e-21,
 -3.529154587042142e-25, -3.342056475996120e-26, -2.883810045135130e-29,  1.322124661868947e+00, -2.363580558993509e-03, -2.673126031838818e-06,  7.559946475987358e-09,
  2.711992639882772e-11, -2.782491056985503e-14, -2.843296154076097e-16, -9.480986399642621e-20,  2.870532970115891e-21,  4.909548920051345e-24, -2.609790929459345e-26,
 -9.360968070817524e-29,  1.384348713580047e+00, -2.264745467454141e-03, -3.156214904840655e-06,  5.661331320626189e-09,  3.001019573758715e-11,  1.283272091610584e-15,
 -2.745489467584919e-16, -4.720198065276055e-19,  2.104609423783143e-21,  8.867846325412548e-24, -8.646559708146419e-27, -1.200837127020912e-28,  1.445322432534673e+00,
 -2.146316127670406e-03, -3.554835939560463e-06,  3.510148976187481e-09,  3.061288456892703e-11,  3.025979281660347e-14, -2.227579559591884e-16, -7.575103612433585e-19,
  7.920590944972498e-22,  1.009065820857895e-23,  1.245683431773560e-26, -9.267523138484646e-29,  1.504726439287749e+00, -2.009926769360131e-03, -3.853501918462922e-06,
  1.229693284845593e-09,  2.881552370312123e-11,  5.532153059579766e-14, -1.367719049092916e-16, -8.833860817736496e-19, -7.125298349150167e-22,  8.046668493799164e-24,
  2.852546212785501e-26, -2.260090131892055e-29,  1.562235968870029e+00, -1.857694341109056e-03, -4.040207226306451e-06, -1.040467110515458e-09,  2.475703119383018e-11,
  7.304847627341021e-14, -3.166880590840916e-17, -8.181420585436827e-19, -1.971889597273378e-21,  3.423116727799028e-24,  3.261590794659989e-26,  5.534540760623282e-29,
  1.617523252838507e+00, -1.692209597162134e-03, -4.107383274821515e-06, -3.154657424161146e-09,  1.883433250514107e-11,  8.099771436418323e-14,  7.288889181692029e-17,
 -5.789094963840994e-19, -2.610467290568045e-21, -2.051695740924278e-24,  2.313094032687520e-26,  1.008479268933300e-28,  1.670260262903092e+00, -1.516511808795863e-03,
 -4.052718227302850e-06, -4.973246344153925e-09,  1.167373130542748e-11,  7.821219943931355e-14,  1.568138259196086e-16, -2.301105761303723e-19, -2.453154066054092e-21,
 -6.282878885743707e-24,  4.969819021677709e-27,  9.163784838386958e-29,  1.720121804222924e+00, -1.334045367447332e-03, -3.879758420493511e-06, -6.375782019606889e-09,
  4.065374611674188e-12,  6.549790736422608e-14,  2.043407168617710e-16,  1.332283729933888e-19, -1.599652428504855e-21, -7.721393312101532e-24, -1.280497775467797e-26,
  3.751687089863205e-29,  1.766788930810296e+00, -1.148597229612968e-03, -3.598210263389873e-06, -7.273778011880665e-09, -3.134603690247147e-12,  4.537113690977322e-14,
  2.081041638669930e-16,  4.138415482284569e-19, -3.936692831978730e-22, -6.078973709329127e-24, -2.181182515036368e-26, -2.590418583484406e-29,  1.809952637939532e+00,
 -9.642150780719584e-04, -3.223871790253658e-06, -7.621583921467359e-09, -9.122779664231085e-12,  2.163899719590272e-14,  1.712589101486591e-16,  5.434042469742319e-19,
  7.116980282723743e-22, -2.448571907695471e-24, -1.896341625330819e-26, -6.097943883493331e-29,  1.849317767830324e+00, -7.851072157310735e-04, -2.778143631872800e-06,
 -7.423731697139060e-09, -1.327033314169516e-11, -1.338092746582291e-15,  1.067592019520383e-16,  5.050816353604983e-19,  1.340722642209364e-21,  1.282500071825860e-24,
 -7.919635076377082e-27, -5.292669521543760e-29,  1.884607046286735e+00, -6.155265099483173e-04, -2.287099896062536e-06, -6.737347766760025e-09, -1.522671616116448e-11,
 -1.956205340997539e-14,  3.371747696033297e-17,  3.378839189576860e-19,  1.349652371902369e-21,  3.437018080044393e-24,  3.676988975318591e-27, -1.730224039489434e-29,
  1.915565150894642e+00, -4.596420741909885e-04, -1.780138651226540e-06, -5.668687773907841e-09, -1.498378710449055e-11, -3.028170507089001e-14, -2.824935646535669e-17,
  1.197738295866014e-19,  8.722105559227244e-22,  3.402179481061286e-24,  9.353762850159287e-27,  1.539072608918516e-29,  1.941962697757323e+00, -3.214036852391860e-04,
 -1.288275919871705e-06, -4.363560270758868e-09, -1.288398421203956e-11, -3.261608241334469e-14, -6.495567813220621e-17, -6.457729861635100e-20,  2.299718455411003e-22,
  1.823886575619475e-24,  7.723873473761311e-27,  2.463837370056566e-29,  1.963600026942374e+00, -2.044050339202614e-04, -8.421911701190723e-07, -2.992275876990741e-09,
 -9.565555453023591e-12, -2.773071933991335e-14, -7.184374594587614e-17, -1.580680981810079e-19, -2.466508522569944e-22,  3.527772057022125e-26,  2.422043059910963e-27,
  1.320694009999235e-29,  1.980310678276024e+00, -1.117525898038935e-04, -4.701698087737324e-07, -1.730653238005238e-09, -5.850343133740802e-12, -1.848842455969667e-14,
 -5.487432016432162e-17, -1.522717127862356e-19, -3.888993986207782e-22, -8.799595680578740e-25, -1.581819363469601e-27, -1.196187500787248e-30,  1.991964562251010e+00,
 -4.594652078543323e-05, -1.961107536052547e-07, -7.393575477691247e-10, -2.592438085085072e-12, -8.641019885737716e-15, -2.766983721129918e-17, -8.555041047227493e-20,
 -2.558330432965567e-22, -7.393291452745579e-25, -2.057482735318635e-27, -5.474357754119230e-30,  1.998472407466376e+00, -8.770828659684612e-06, -3.773573690319051e-08,
 -1.441468189487204e-10, -5.154610623948652e-13, -1.766436103338704e-15, -5.873202652089549e-18, -1.908408151102105e-20, -6.087798259024755e-23, -1.912210501260204e-25,
 -5.926056361518524e-28, -1.814389050282172e-30,  4.005066186986154e-04, -1.803810804063241e-06,  6.091927790089572e-09, -1.828399908811860e-11,  5.143147741219474e-14,
 -1.388389193972532e-16,  3.642306727102228e-19, -9.355967382018786e-22,  2.364421114337021e-24, -5.898152643408479e-27,  1.455624150383508e-29, -3.560194221031398e-32,
  3.603500695568159e-03, -1.620937751926209e-05,  5.460061940193142e-08, -1.631469621575595e-10,  4.558110676602605e-13, -1.218641739244663e-15,  3.155560395154666e-18,
 -7.968898683168734e-21,  1.970793325674579e-23, -4.785484809458413e-26,  1.142563984330617e-28, -2.684323395365859e-31,  1.000383440447360e-02, -4.488765027983772e-05,
  1.504121455768578e-07, -4.454078704408086e-10,  1.227310679499008e-12, -3.216650112510883e-15,  8.104089637675955e-18, -1.972847909692802e-20,  4.648987746947624e-23,
 -1.059812098574392e-25,  2.329675936830194e-28, -4.905947960805432e-31,  1.959016465030826e-02, -8.757312459199825e-05,  2.911310163429483e-07, -8.503751945579803e-10,
  2.293597782878778e-12, -5.825041835818613e-15,  1.403206428619070e-17, -3.206848353031519e-20,  6.909197535895140e-23, -1.381741354639230e-25,  2.476053092279577e-28,
 -3.614261345997491e-31,  3.234539122412804e-02, -1.438681009509898e-04,  4.732047008230613e-07, -1.356605276718768e-09,  3.551564419844810e-12, -8.619517991004679e-15,
  1.938979261852418e-17, -3.987020237259444e-20,  7.211093275586662e-23, -1.023383755278195e-25,  5.560272081129492e-29,  3.302105217465403e-31,  4.824655398283141e-02,
 -2.132433960620914e-04,  6.919728672029997e-07, -1.936607157584835e-09,  4.873583765532888e-12, -1.110146162621124e-14,  2.249045850165075e-17, -3.817254423846184e-20,
  4.318340393163164e-23,  2.510671745866007e-26, -3.610157722130435e-28,  1.466878496691899e-30,  6.726469554124018e-02, -2.950393626180662e-04,  9.417336716509415e-07,
 -2.557769264632078e-09,  6.115496703081101e-12, -1.274962952475437e-14,  2.178248055933141e-17, -2.338552516421812e-20, -2.237975756750095e-23,  2.342178341670929e-25,
 -8.967250447964495e-28,  2.540288862126664e-30,  8.936468933474706e-02, -3.884672800496682e-04,  1.215827594121880e-06, -3.183495718016488e-09,  7.126021384181210e-12,
 -1.307767863758539e-14,  1.612810357809968e-17,  5.621880698639604e-21, -1.182997076458027e-22,  4.753594143529649e-25, -1.329588276312136e-27,  2.790646719592562e-30,
  1.145050329291778e-01, -4.926111956385024e-04,  1.506739382065723e-06, -3.774535678142211e-09,  7.757200380461132e-12, -1.169313830766512e-14,  5.053551158835642e-18,
  4.676927844057508e-20, -2.263742951957781e-22,  6.654709199142621e-25, -1.381970563443556e-27,  1.533381027486593e-30,  1.426376065117286e-01, -6.064303131612148e-04,
  1.806218680916744e-06, -4.290484015528015e-09,  7.875422616528675e-12, -8.352926320390293e-15, -1.106437154580826e-17,  9.452934499889950e-20, -3.184930337209493e-22,
  7.074170224745433e-25, -8.244028040893264e-28, -1.430546165832678e-30,  1.737073966033230e-01, -7.287620448645865e-04,  2.105419889627063e-06, -4.691425511775811e-09,
  7.372483090089365e-12, -3.010225121278430e-15, -3.090739574447170e-17,  1.403326764105417e-19, -3.617056690302893e-22,  5.194250904963040e-25,  4.061899066825356e-28,
 -5.491834557521391e-30,  2.076521852005422e-01, -8.583258620168135e-04,  2.395061665034409e-06, -4.939687722916296e-09,  6.176075897668224e-12,  4.152455363064290e-15,
 -5.224614916881922e-17,  1.736506971948402e-19, -3.257641531835626e-22,  6.802657827652057e-26,  2.115495684545449e-27, -9.181566079561648e-30,  2.444022047982635e-01,
 -9.937280993987973e-04,  2.665606292847762e-06, -5.001659532766674e-09,  4.259060165517632e-12,  1.270883591824981e-14, -7.210680641290199e-17,  1.836873902565392e-19,
 -1.918805252402371e-22, -6.047073777011289e-25,  3.831524659444778e-27, -1.051386613097788e-29,  2.838797600781071e-01, -1.133467889608695e-03,  2.907458825532548e-06,
 -4.849623354923761e-09,  1.646800569337858e-12,  2.199707022315965e-14, -8.707497089243718e-17,  1.614929384854597e-19,  3.911948242052251e-23, -1.369601014567119e-24,
  4.885797102318543e-27, -7.711011787125856e-30,  3.259988174907184e-01, -1.275944423491164e-03,  3.111185436395158e-06, -4.463539079612702e-09, -1.578127704221529e-12,
  3.115335670816843e-14, -9.372059776790981e-17,  1.021989045029623e-19,  3.413731438485101e-22, -2.022620242027540e-24,  4.599415049939496e-27, -1.244398633608587e-31,
  3.706645645320248e-01, -1.419465752678956e-03,  3.267749831319165e-06, -3.832707525408302e-09, -5.274555781177834e-12,  3.917196178125451e-14, -8.910874117783484e-17,
  6.984125838121272e-21,  6.633282759350011e-22, -2.324396637987705e-24,  2.539924537567359e-27,  1.099247833301465e-29,  4.177729412373073e-01, -1.562259368173024e-03,
  3.368765771233613e-06, -2.957230854880004e-09, -9.245275308011367e-12,  4.499038569463989e-14, -7.134173561087441e-17, -1.156655894671201e-19,  9.333277754763102e-22,
 -2.063366491951431e-24, -1.223190192450644e-27,  2.227042035032954e-29,  4.672101473166186e-01, -1.702484803763601e-03,  3.406762767369571e-06, -1.849177891128801e-09,
 -1.324401668110154e-11,  4.759567799263255e-14, -4.006150266910226e-17, -2.498212535003693e-19,  1.071808689919936e-21, -1.130493612810063e-24, -5.961801610305446e-27,
  2.888944037414018e-29,  5.188521294566633e-01, -1.838248523167067e-03,  3.375460799772600e-06, -5.333545515858635e-10, -1.698713941654292e-11,  4.614485613998249e-14,
  3.170978434436100e-18, -3.734123504902682e-19,  1.008973027644338e-21,  4.140266455994182e-25, -1.032692563089526e-26,  2.617277896442213e-29,  5.725640546442712e-01,
 -1.967621352792871e-03,  3.270048467470915e-06,  9.524249655303919e-10, -2.017004552765718e-11,  4.008921623471733e-14,  5.470495286842692e-17, -4.610858732440057e-19,
  7.050538675988099e-22,  2.305840534008482e-24, -1.263780150556535e-26,  1.174998754010679e-29,  6.281997769509776e-01, -2.088658715281744e-03,  3.087457309320580e-06,
  2.557670376155478e-09, -2.248796598871247e-11,  2.928937574835288e-14,  1.089146193170962e-16, -4.884616963413329e-19,  1.687148463584568e-22,  4.095132144400503e-24,
 -1.140251598530272e-26, -1.248629063951928e-29,  6.856013070802904e-01, -2.199423898993522e-03,  2.826623160667059e-06,  4.220247988306058e-09, -2.366032865203638e-11,
  1.410559866958214e-14,  1.586516900132073e-16, -4.372839293098616e-19, -5.318399206625858e-22,  5.230972509546273e-24, -5.950514107615017e-27, -3.963514682417410e-29,
  7.445982961370819e-01, -2.298014561480041e-03,  2.488723383082141e-06,  5.868194889988804e-09, -2.345740709193765e-11, -4.553126984315988e-15,  1.960472716960552e-16,
 -3.006217093137593e-19, -1.270291882996369e-21,  5.205656742775193e-24,  3.035187314793513e-27, -5.910086662348070e-29,  8.050075475413737e-01, -2.382592606091989e-03,
  2.077376710157149e-06,  7.422368214175159e-09, -2.172740273722504e-11, -2.523704268757391e-14,  2.136180605342432e-16, -8.699658401898436e-20, -1.879687176123834e-21,
  3.730634362132939e-24,  1.334074665406506e-26, -6.015872746472504e-29,  8.666325737722117e-01, -2.451417485220933e-03,  1.598790426561095e-06,  8.799942008897021e-09,
 -1.842157545257888e-11, -4.603320351921394e-14,  2.055643069103473e-16,  1.777981084072903e-19, -2.186069230094540e-21,  8.939607346170391e-25,  2.160444235087643e-26,
 -3.691510036134917e-29,  9.292632176674550e-01, -2.502882866035244e-03,  1.061837832497634e-06,  9.918707962303866e-09, -1.361458056521361e-11, -6.471919101430330e-14,
  1.690774730777638e-16,  4.522714920748855e-19, -2.053602850819106e-21, -2.762737459712745e-24,  2.430285145665758e-26,  7.281044887243436e-30,  9.926753612716189e-01,
 -2.535556439874455e-03,  4.780476988144111e-07,  1.070206412300349e-08, -7.516885670508563e-12, -7.899025315128760e-14,  1.054177757461216e-16,  6.848085831636212e-19,
 -1.431379938251806e-21, -6.302857612958066e-24,  1.913069968691681e-26,  5.845382646172723e-29,  1.056630748631002e+00, -2.548222460433691e-03, -1.385129844353216e-07,
  1.108448897326137e-08, -4.761391850834813e-13, -8.674519717541135e-14,  2.049354442692147e-17,  8.230283494057292e-19, -3.881356316842582e-22, -8.612419290793280e-24,
  6.301088311399119e-27,  9.552739574091552e-29,  1.120876952353866e+00, -2.539926355811241e-03, -7.714808310102287e-07,  1.101720045774526e-08,  7.035236767295809e-12,
 -8.640265864800697e-14, -7.530550744651837e-17,  8.256416714490442e-19,  8.797472713779749e-22, -8.745774646920835e-24, -1.085490524270843e-26,  9.870519163622568e-29,
  1.185147517001071e+00, -2.510020475412477e-03, -1.402577814670150e-06,  1.047359789870982e-08,  1.444804620927077e-11, -7.720585883930823e-14, -1.681847847619042e-16,
  6.744181618329491e-19,  2.077606768476547e-21, -6.304919176324253e-24, -2.650937695213332e-26,  5.985609594898757e-29,  1.249162315205617e+00, -2.458209708643180e-03,
 -2.012143697687770e-06,  9.453990212373280e-09,  2.114024033294974e-11, -5.946346128763895e-14, -2.429407190322995e-16,  3.830605953319604e-19,  2.880495897475760e-21,
 -1.709752787832430e-24, -3.428577253525847e-26, -1.023940073658053e-29,  1.312628154527648e+00, -2.384595357903812e-03, -2.579822728654180e-06,  7.989041833033608e-09,
  2.649502836162620e-11, -3.467014169516518e-14, -2.856732046288358e-16, -3.342744449870047e-22,  3.027519236407544e-21,  3.786120882303635e-24, -2.999635574865612e-26,
 -8.302077330330913e-29,  1.375239674056464e+00, -2.289715280413381e-03, -3.085398274877891e-06,  6.141337411176813e-09,  2.996893946444621e-11, -5.456598681853079e-15,
 -2.867751797126403e-16, -3.996415943958923e-19,  2.416340716873332e-21,  8.415008920504262e-24, -1.402139142958870e-26, -1.236571030200331e-28,  1.436680569233848e+00,
 -2.174577957259330e-03, -3.509756303964814e-06,  4.004499064126731e-09,  3.116291672055631e-11,  2.466228136876808e-14, -2.435581549848081e-16, -7.262643559922309e-19,
  1.163264100432645e-21,  1.050246482970307e-23,  8.014139862346131e-27, -1.090507802435257e-28,  1.496625180810817e+00, -2.040687838719648e-03, -3.835943397366199e-06,
  1.699406305741774e-09,  2.988711338680348e-11,  5.173988612968728e-14, -1.617808229263236e-16, -9.013342319256713e-19, -4.026041746723133e-22,  9.161943835356063e-24,
  2.709032099791112e-26, -4.291100331571594e-29,  1.554740478767175e+00, -1.890059096702127e-03, -4.050268099999686e-06, -6.327160667814415e-10,  2.620850832536681e-11,
  7.200652183013939e-14, -5.543984241763450e-17, -8.790144583772392e-19, -1.824618688203197e-21,  4.772934035454994e-24,  3.478151273499011e-26,  4.251371129315650e-29,
  1.610688463958944e+00, -1.725214840272638e-03, -4.143377317085988e-06, -2.840259104520290e-09,  2.047041810964704e-11,  8.254303307970369e-14,  5.550015640044265e-17,
 -6.634389347895492e-19, -2.666598601667974e-21, -1.037085272648424e-24,  2.760998420025607e-26,  1.022664545196583e-28,  1.664128998850659e+00, -1.549168974984353e-03,
 -4.111224229169777e-06, -4.773750559034334e-09,  1.327504199587610e-11,  8.188933608038740e-14,  1.492380342090913e-16, -3.121839537989382e-19, -2.674751687495038e-21,
 -5.999493683620940e-24,  9.296524335518153e-27,  1.049581651507580e-28,  1.714723063753523e+00, -1.365388265272470e-03, -3.955833433804253e-06, -6.299988739403262e-09,
  5.424645696129970e-12,  7.044080466513110e-14,  2.073119940413723e-16,  7.749661018338412e-20, -1.886404166660553e-21, -8.196137592227748e-24, -1.081887335460705e-26,
  5.307974108897043e-29,  1.762136416609981e+00, -1.177732834930228e-03, -3.685765686806932e-06, -7.316397009677553e-09, -2.176305597163847e-12,  5.050305581052513e-14,
  2.194812511498081e-16,  3.975721511253237e-19, -6.284722421268524e-22, -6.972088763959230e-24, -2.278623114775511e-26, -1.797708630508936e-29,  1.806043612980298e+00,
 -9.903743354502379e-04, -3.316191564779140e-06, -7.763857616511736e-09, -8.647652205946836e-12,  2.593428155217207e-14,  1.867787436870253e-16,  5.646165043331502e-19,
  6.092406587204987e-22, -3.261688353409604e-24, -2.171315487651692e-26, -6.382185814301565e-29,  1.846132319368360e+00, -8.076923145433418e-04, -2.868502783061117e-06,
 -7.636127012123097e-09, -1.327030203488422e-11,  1.398723942471425e-15,  1.215086093604166e-16,  5.486576351979915e-19,  1.380606385344922e-21,  9.166162468373434e-25,
 -1.043815392054864e-26, -6.165680730815159e-29,  1.882107828724292e+00, -6.341508729087532e-04, -2.369422593544138e-06, -6.984057880362576e-09, -1.560907300313480e-11,
 -1.863430931828727e-14,  4.380166529617912e-17,  3.830793008904616e-19,  1.475831588623160e-21,  3.566943332900917e-24,  2.769237955616118e-27, -2.417469694143521e-29,
  1.913697663744434e+00, -4.741594022656646e-04, -1.849621450070728e-06, -5.913309079087542e-09, -1.559591261479828e-11, -3.091617592159028e-14, -2.448600387754230e-17,
  1.497177443083622e-19,  1.001584732464748e-21,  3.789623156980464e-24,  1.001100847665274e-26,  1.437012298731360e-29,  1.940656133957558e+00, -3.319228980646002e-04,
 -1.341897308234375e-06, -4.575007892558427e-09, -1.355203712126914e-11, -3.419582222760203e-14, -6.665050657872902e-17, -5.610584113801197e-20,  3.014619873047026e-22,
  2.155379499164051e-24,  8.872309651477664e-27,  2.759492248077347e-29,  1.962768700605483e+00, -2.112888371212824e-04, -8.790353838594471e-07, -3.149856884410811e-09,
 -1.013777543919931e-11, -2.950897014213645e-14, -7.637982124148686e-17, -1.659207258178502e-19, -2.434900776073357e-22,  1.445410084356584e-25,  3.060700293376824e-27,
  1.589616258821898e-29,  1.979856011386045e+00, -1.155986394974416e-04, -4.915117187425955e-07, -1.827289907494250e-09, -6.233634207580211e-12, -1.985800750935986e-14,
 -5.931700502129687e-17, -1.652356581994277e-19, -4.217285141648470e-22, -9.441705736025027e-25, -1.625636595749702e-27, -7.707485258407937e-31,  1.991777581191523e+00,
 -4.755161449260858e-05, -2.052377404512709e-07, -7.822560331839331e-10, -2.772098159536548e-12, -9.334791181822523e-15, -3.018397918810329e-17, -9.417928822245618e-20,
 -2.839901419872924e-22, -8.266460318952069e-25, -2.313462542010512e-27, -6.174861695889952e-30,  1.998436709223248e+00, -9.079776543287659e-06, -3.951617415493145e-08,
 -1.526846701038620e-10, -5.522438010831436e-13, -1.914031881456629e-15, -6.435898703751188e-18, -2.114705612230437e-20, -6.820858614395914e-23, -2.166027153226940e-25,
 -6.785553852470489e-28, -2.099783734319783e-30,  3.933874762183612e-04, -1.755939232329898e-06,  5.877367103715419e-09, -1.748284347536475e-11,  4.874003582043142e-14,
 -1.304033862625467e-16,  3.390620876788162e-19, -8.632232168297664e-22,  2.162201424971847e-24, -5.346049760872887e-27,  1.307728979488567e-29, -3.170335655696392e-32,
  3.539524568854932e-03, -1.578028146359283e-05,  5.268582253983085e-08, -1.560449275043964e-10,  4.321778555678841e-13, -1.145516136702325e-15,  2.941007553085385e-18,
 -7.364949740259950e-21,  1.806465480984834e-23, -4.351230115233700e-26,  1.030755503638635e-28, -2.403340086155752e-31,  9.826657011611822e-03, -4.370540368606983e-05,
  1.451829836934066e-07, -4.262751806891390e-10,  1.164878768645042e-12, -3.028616084874743e-15,  7.571958699750832e-18, -1.830009109452214e-20,  4.283721162698992e-23,
 -9.708074821060178e-26,  2.123813115799167e-28, -4.458531819851635e-31,  1.924446648890306e-02, -8.528427934867808e-05,  2.811429133157646e-07, -8.145916397691347e-10,
  2.180393182203596e-12, -5.498801995482671e-15,  1.316436560304935e-17, -2.993524798225716e-20,  6.429218509394489e-23, -1.285840703005397e-25,  2.319977808411428e-28,
 -3.477296105911676e-31,  3.177738834026810e-02, -1.401466273114282e-04,  4.572607796814457e-07, -1.301134459506755e-09,  3.383738517855695e-12, -8.167301991185320e-15,
  1.830518201231907e-17, -3.762114324316680e-20,  6.847006183594669e-23, -9.984817157291445e-26,  6.832800814277451e-29,  2.506122141389037e-31,  4.740450663176099e-02,
 -2.077992613387225e-04,  6.691942124023364e-07, -1.860377084222156e-09,  4.656866477921123e-12, -1.057435970728263e-14,  2.144109014831032e-17, -3.677887830745064e-20,
  4.384231346475213e-23,  1.189628480396391e-26, -3.009591700415389e-28,  1.267290269624011e-30,  6.609941376208180e-02, -2.876266219504644e-04,  9.116192048009678e-07,
 -2.461933077740839e-09,  5.865678483493318e-12, -1.223478090414523e-14,  2.111887919728813e-17, -2.397347679657550e-20, -1.456734444375068e-23,  2.005050941436437e-25,
 -7.908294908771600e-28,  2.276996611321449e-30,  8.783003422073672e-02, -3.788915485545406e-04,  1.178301180543916e-06, -3.071550727381391e-09,  6.868349161711058e-12,
 -1.268912752027055e-14,  1.623501880916491e-17,  2.100069744140310e-21, -1.021149500248282e-22,  4.245799942181682e-25, -1.210669008245737e-27,  2.614112903135956e-30,
  1.125584120674137e-01, -4.807363660646288e-04,  1.462181950221179e-06, -3.652284353557051e-09,  7.524652401383330e-12, -1.155693541364995e-14,  6.265201511107449e-18,
  3.989807759166400e-20, -2.033957721057234e-22,  6.115768190494539e-25, -1.311955779245277e-27,  1.640469625822595e-30,  1.402404616885035e-01, -5.921843776174751e-04,
  1.755483356043990e-06, -4.165827270316730e-09,  7.705917180524703e-12, -8.587837747265847e-15, -8.556452263239773e-18,  8.473856254904262e-20, -2.936332579760904e-22,
  6.733456033554498e-25, -8.753014421551036e-28, -8.994396809419067e-31,  1.708256814184390e-01, -7.121418736875865e-04,  2.049828428155155e-06, -4.573986408939596e-09,
  7.305172401331155e-12, -3.706141388694638e-15, -2.713729411414911e-17,  1.290599638000819e-19, -3.427695965311351e-22,  5.311181356659945e-25,  1.851499292700736e-28,
 -4.573536216876229e-30,  2.042568297022355e-01, -8.394007879373697e-04,  2.336380840044455e-06, -4.840272612677747e-09,  6.246973692696536e-12,  2.955719281592161e-15,
 -4.752939187863906e-17,  1.632809872020270e-19, -3.218866399138940e-22,  1.448691428960526e-25,  1.734027914534392e-27, -8.166364069859974e-30,  2.404695636354180e-01,
 -9.726421515340511e-04,  2.606003336230492e-06, -4.931573447673457e-09,  4.496344185903109e-12,  1.103927860781282e-14, -6.705258894162240e-17,  1.772275866138644e-19,
 -2.110012370272379e-22, -4.605277077236222e-25,  3.381835481493149e-27, -9.913470904122012e-30,  2.793920399650395e-01, -1.110440520290228e-03,  2.849435592595423e-06,
 -4.819867020953304e-09,  2.066210789366659e-12,  1.996162977864848e-14, -8.254279033674320e-17,  1.619929184374992e-19, -6.751346071333988e-24, -1.181082918374156e-24,
  4.537378587218143e-27, -8.086419612642081e-30,  3.209444789902021e-01, -1.251269572562540e-03,  3.057491635229827e-06, -4.483925803173666e-09, -9.773156277099542e-13,
  2.893956958712245e-14, -9.071678676034860e-17,  1.119932810154782e-19,  2.718642960649341e-22, -1.839272917378309e-24,  4.555723086569652e-27, -1.803855748915977e-30,
  3.650386922849590e-01, -1.393509099881840e-03,  3.221276461042131e-06, -3.910948993161411e-09, -4.512474732635885e-12,  3.703802065910510e-14, -8.862844919519726e-17,
  2.689228156756578e-20,  5.815875875701110e-22, -2.213969707815426e-24,  2.961104712328896e-27,  8.203091101947565e-30,  4.115775758066172e-01, -1.535453636023317e-03,
  3.332420843988100e-06, -3.098050869020059e-09, -8.362834790528737e-12,  4.324262638818395e-14, -7.417346470000217e-17, -8.699517997722582e-20,  8.583938482223419e-22,
 -2.093595070617474e-24, -3.103774916308903e-28,  1.923188229406422e-29,  4.604545707775601e-01, -1.675322992541453e-03,  3.383332444670748e-06, -2.053521398815094e-09,
 -1.230226461190372e-11,  4.655409845836174e-14, -4.658275959670907e-17, -2.162181100606755e-19,  1.027119936729530e-21, -1.344078427917952e-24, -4.731316839925213e-27,
  2.698585443273471e-29,  5.115530957712708e-01, -1.811274988139620e-03,  3.367460239213987e-06, -7.977649594092664e-10, -1.606430925419968e-11,  4.609915249705603e-14,
 -6.830862019008219e-18, -3.409641897669923e-19,  1.016722479964453e-21,  2.422830065143776e-26, -9.158239710383495e-27,  2.682690991870943e-29,  5.647459547284753e-01,
 -1.941420673529676e-03,  3.279567920761787e-06,  6.361855042226933e-10, -1.935616426812381e-11,  4.124983296471284e-14,  4.212220240150344e-17, -4.372924630164887e-19,
  7.791008237269722e-22,  1.811898479364500e-24, -1.203050010766219e-26,  1.570477534969631e-29,  6.198947272141996e-01, -2.063842359936334e-03,  3.116010287467176e-06,
  2.202686607653400e-09, -2.187714307678210e-11,  3.173994660379506e-14,  9.533480570184731e-17, -4.807930064361021e-19,  3.078157056072094e-22,  3.630046653785208e-24,
 -1.180331351363786e-26, -5.836556908469044e-30,  6.768491491381033e-01, -2.176614754650334e-03,  2.875004713362906e-06,  3.844142312133617e-09, -2.334114123988136e-11,
  1.776456097502791e-14,  1.461974390737139e-16, -4.513389903584707e-19, -3.482104860031984e-22,  4.960171121070452e-24, -7.537408219052340e-27, -3.247908880621070e-29,
  7.354464944334085e-01, -2.277829486749771e-03,  2.556887625707192e-06,  5.492400579508666e-09, -2.350212309820966e-11,  4.657914067357296e-17,  1.870890840312286e-16,
 -3.382541746812051e-19, -1.081318653398575e-21,  5.276274588520730e-24,  5.278363768340786e-28, -5.469332682075472e-29,  7.955109708527290e-01, -2.365623265145131e-03,
  2.164343541385201e-06,  7.070969452632455e-09, -2.218110715269819e-11, -2.014610938668911e-14,  2.103609506354343e-16, -1.448999494286202e-19, -1.736421981732965e-21,
  4.210794542605421e-24,  1.065736020912733e-26, -6.152023818334738e-29,  8.568531461098134e-01, -2.438209843481641e-03,  1.702591750097198e-06,  8.498101095808698e-09,
 -1.929254154881371e-11, -4.104778919711435e-14,  2.095693029889054e-16,  1.085222687438014e-19, -2.138746319030634e-21,  1.723104315867500e-24,  1.979272831219233e-26,
 -4.515198956942203e-29,  9.192694240745727e-01, -2.493915865478902e-03,  1.179513339268636e-06,  9.690744250637494e-09, -1.486739878345740e-11, -6.051687944772893e-14,
  1.808074489529098e-16,  3.851528751414019e-19, -2.135521622944478e-21, -1.788104727122412e-24,  2.433368703071036e-26, -5.769527275553058e-30,  9.825415945885589e-01,
 -2.531220522939044e-03,  6.056991765670110e-07,  1.056929940017636e-08, -9.069864941183240e-12, -7.623551097676053e-14,  1.239181278215662e-16,  6.355264813920079e-19,
 -1.643922053716255e-21, -5.489851485787172e-24,  2.142701034168376e-26,  4.574794034821131e-29,  1.046436484646269e+00, -2.548798769988610e-03, -5.601970043498470e-09,
  1.106302604466302e-08, -2.204266511821166e-12, -8.597850262463439e-14,  4.331823702657151e-17,  8.057040315191649e-19, -6.926468896782517e-22, -8.277878112988075e-24,
  1.038244264628187e-26,  8.955506263646048e-29,  1.110705743072184e+00, -2.545567595183737e-03, -6.386563650266168e-07,  1.111584953584472e-08,  5.290998023830062e-12,
 -8.792968776209317e-14, -5.184129371415347e-17,  8.486808214731821e-19,  5.581467713820624e-22, -9.091367822762953e-24, -6.387010651579799e-27,  1.038841950926175e-28,
  1.175085795239401e+00, -2.520734554107483e-03, -1.275559275866576e-06,  1.069220094054954e-08,  1.286513217465011e-11, -8.100839345590928e-14, -1.484058584481569e-16,
  7.370707307697064e-19,  1.832221129121435e-21, -7.307867190967341e-24, -2.352331470691340e-26,  7.559595880859775e-29,  1.239298008571255e+00, -2.473847408972910e-03,
 -1.896706613719871e-06,  9.782406942505852e-09,  1.989358767090896e-11, -6.515498066307140e-14, -2.309357038894966e-16,  4.739864225909273e-19,  2.794202810347795e-21,
 -3.084431232098664e-24, -3.430384350419929e-26,  9.563017805332984e-30,  1.303049113201117e+00, -2.404843314195394e-03, -2.481434792443404e-06,  8.407042741595792e-09,
  2.573312028248046e-11, -4.151534592338404e-14, -2.843074364820667e-16,  9.848865696219152e-20,  3.141376696252603e-21,  2.517081064479174e-24, -3.335389675736224e-26,
 -6.905663559175149e-29,  1.366031924798111e+00, -2.314095541606960e-03, -3.008830030457988e-06,  6.619589788138701e-09,  2.979012139000181e-11, -1.246446929973549e-14,
 -2.968379151707932e-16, -3.175905542411053e-19,  2.707871595872844e-21,  7.745083552311586e-24, -1.947420936750379e-26, -1.235597653476458e-28,  1.427926417659218e+00,
 -2.202455280033382e-03, -3.458695445573671e-06,  4.506727262975067e-09,  3.159608445203387e-11,  1.857741851706143e-14, -2.633151898891121e-16, -6.829382715853667e-19,
  1.545925671296885e-21,  1.072259386084509e-23,  2.885251853796887e-27, -1.237375290231558e-28,  1.488401195095020e+00, -2.071285607869735e-03, -3.812647917349407e-06,
  2.185658936600206e-09,  3.088103328216985e-11,  4.755315440250773e-14, -1.871474958348027e-16, -9.087352176607693e-19, -5.378149316462508e-23,  1.020148494426552e-23,
  2.472849360108232e-26, -6.462698633260663e-29,  1.547115400212071e+00, -1.922484374220859e-03, -4.055297409021361e-06, -2.019396684290936e-10,  2.763330620549200e-11,
  7.037418738547064e-14, -8.084191104926936e-17, -9.343811421527725e-19, -1.627340613824712e-21,  6.197047542464064e-24,  3.630498276448427e-26,  2.615091407439532e-29,
  1.603721102727698e+00, -1.758492497389072e-03, -4.175440571043006e-06, -2.499459647051391e-09,  2.213304417794283e-11,  8.364245227141038e-14,  3.572518792762054e-17,
 -7.491455121712403e-19, -2.682972087570843e-21,  1.570366598680659e-25,  3.208320953525443e-26,  1.004856512133303e-28,  1.657866185821309e+00, -1.582284172312457e-03,
 -4.167180163048255e-06, -4.548056135459524e-09,  1.494788698994047e-11,  8.535628641745944e-14,  1.392666906058493e-16, -4.011506865063281e-19, -2.882892475562505e-21,
 -5.531492968800186e-24,  1.419515646947827e-26,  1.175300661151575e-28,  1.709197740784792e+00, -1.397335747869244e-03, -4.030865164360585e-06, -6.201652933152651e-09,
  6.883356009764511e-12,  7.543523464183178e-14,  2.085918650061167e-16,  1.233204482786146e-20, -2.188646568183175e-21, -8.577183691966920e-24, -8.106535966383747e-27,
  7.049871387216383e-29,  1.757365956240970e+00, -1.207570660793566e-03, -3.773737106918135e-06, -7.342847465782142e-09, -1.112680039099162e-12,  5.590167928133161e-14,
  2.302927205892683e-16,  3.732678297057119e-19, -8.960380107321721e-22, -7.896447678183921e-24, -2.335470238772639e-26, -7.398305134105878e-30,  1.802028463253582e+00,
 -1.017278844266124e-03, -3.410170110430751e-06, -7.897821593942288e-09, -8.082848223370318e-12,  3.060877093386122e-14,  2.028420662848181e-16,  5.820603194253605e-19,
  4.755044112444215e-22, -4.186930861589351e-24, -2.455991957043611e-26, -6.531764747813025e-29,  1.842855068628340e+00, -8.310104772447870e-04, -2.961408805303086e-06,
 -7.848064288225295e-09, -1.321189521503802e-11,  4.504299280190028e-15,  1.374938894932985e-16,  5.932789605663306e-19,  1.405410763425800e-21,  4.421310418170978e-25,
 -1.335385620835502e-26, -7.095591713481627e-29,  1.879532777652025e+00, -6.534457620377818e-04, -2.454741862543590e-06, -7.236723676078871e-09, -1.597034987952850e-11,
 -1.744889873795227e-14,  5.520850226704307e-17,  4.323796318766273e-19,  1.605958067024799e-21,  3.654114107312719e-24,  1.529160586719936e-27, -3.243445023255150e-29,
  1.911770976729642e+00, -4.892445019829440e-04, -1.922098870680895e-06, -6.167820706707057e-09, -1.621975395161276e-11, -3.144978427089075e-14, -1.982412959753121e-17,
  1.840297735820837e-19,  1.145367319617301e-21,  4.202240973808147e-24,  1.060673634718504e-26,  1.256172479184932e-29,  1.939306619034543e+00, -3.428814156082967e-04,
 -1.398121250693289e-06, -4.797399243888718e-09, -1.425207098837061e-11, -3.581312165639107e-14, -6.807424789278107e-17, -4.514663554248996e-20,  3.857445952243621e-22,
  2.535465558668383e-24,  1.015479822219244e-26,  3.072524783928635e-29,  1.961909237348866e+00, -2.184751163061598e-04, -9.178266958171094e-07, -3.316883921283297e-09,
 -1.074666683409731e-11, -3.139870998829237e-14, -8.113372621943299e-17, -1.736041031048399e-19, -2.359062479674846e-22,  2.818528039818798e-25,  3.827948868865258e-27,
  1.906336794407399e-29,  1.979385611332369e+00, -1.196201694060742e-04, -5.140509877214823e-07, -1.930284286277648e-09, -6.645413209622014e-12, -2.133869163838270e-14,
 -6.413773748968099e-17, -1.792874197384705e-19, -4.568958390598631e-22, -1.009712761096818e-24, -1.647139534881595e-27, -1.750609324138246e-31,  1.991584030394727e+00,
 -4.923183316563980e-05, -2.148972252271499e-07, -8.281434456550833e-10, -2.966257163066253e-12, -1.009190598102530e-14, -3.295283112678359e-17, -1.037615256096006e-19,
 -3.154826111495104e-22, -9.248438309349003e-25, -2.602170706386872e-27, -6.963570532981055e-30,  1.998399746038287e+00, -9.403387975877228e-06, -4.140269660832405e-08,
 -1.618354142856348e-10, -5.921183218780906e-13, -2.075852900387858e-15, -7.059784397399694e-18, -2.345991879149304e-20, -7.651796378203445e-23, -2.456872473796950e-25,
 -7.781031102398980e-28, -2.433823581027572e-30,  3.864564469250117e-04, -1.709746410078098e-06,  5.672167369292685e-09, -1.672343338654088e-11,  4.621142487149190e-14,
 -1.225482949267094e-16,  3.158322753063589e-19, -7.970138046129147e-22,  1.978832665647596e-24, -4.849812695912642e-27,  1.175963357115538e-29, -2.826033822696554e-32,
  3.477234720438358e-03, -1.536616920402938e-05,  5.085402867729039e-08, -1.493095982807017e-10,  4.099570024928001e-13, -1.077342676196399e-15,  2.742651992868519e-18,
 -6.811168355600119e-21,  1.656994714450802e-23, -3.959320628073341e-26,  9.306112233751426e-29, -2.153494200735697e-31,  9.654126369016771e-03, -4.256408871837117e-05,
  1.401775425148619e-07, -4.081119966010918e-10,  1.106082999477630e-12, -2.852886178942741e-15,  7.078233289761165e-18, -1.698361688306417e-20,  3.949060342808803e-23,
 -8.896560007970477e-26,  1.936720408696484e-28, -4.052141236082617e-31,  1.890776657554694e-02, -8.307365162196392e-05,  2.715735570122645e-07, -7.805682716955304e-10,
  2.073509880469023e-12, -5.192687197713742e-15,  1.235429825857401e-17, -2.795020112875501e-20,  5.982654916012322e-23, -1.196058041495339e-25,  2.170254027260216e-28,
 -3.326519139782785e-31,  3.122402040045989e-02, -1.365500874121338e-04,  4.419666909988828e-07, -1.248277895323551e-09,  3.224701662506754e-12, -7.740374041255206e-15,
  1.728192809050184e-17, -3.548706598755148e-20,  6.492719416943229e-23, -9.691488667991537e-26,  7.785464404142285e-29,  1.844575538896793e-31,  4.658387707241856e-02,
 -2.025337549649690e-04,  6.473098571134923e-07, -1.787531506225473e-09,  4.450442551625451e-12, -1.007197239773715e-14,  2.043097134590262e-17, -3.537128956843807e-20,
  4.406684033548063e-23,  9.199696269745629e-28, -2.491298694208479e-28,  1.092424581613252e-30,  6.496330830276888e-02, -2.804502640543251e-04,  8.826311266275448e-07,
 -2.370012477023018e-09,  5.625996779860808e-12, -1.173602911103383e-14,  2.044213839652413e-17, -2.433005448525453e-20, -7.895075088456095e-24,  1.708032763943506e-25,
 -6.960126113262631e-28,  2.036536683261372e-30,  8.633309001974240e-02, -3.696107245039894e-04,  1.142093627126443e-06, -2.963666217205622e-09,  6.618465929186668e-12,
 -1.229913689848858e-14,  1.625030574372417e-17, -9.321751065766437e-22, -8.767451003836878e-23,  3.784011291609235e-25, -1.099574618986569e-27,  2.435627115088666e-30,
  1.106585868071234e-01, -4.692121909180070e-04,  1.419069304502402e-06, -3.533730488123743e-09,  7.295104114273078e-12, -1.139388031752310e-14,  7.294464845678342e-18,
  3.373169531946408e-20, -1.823060250627848e-22,  5.605629079775598e-25, -1.238304950031115e-27,  1.700318948252487e-30,  1.378994982506334e-01, -5.783383875907005e-04,
  1.706227494893007e-06, -4.043917019188679e-09,  7.532293670838935e-12, -8.765760067613929e-15, -6.311724649416758e-18,  7.572331884361758e-20, -2.700313281110661e-22,
  6.376772789747779e-25, -9.049264119053305e-28, -4.614858888516342e-31,  1.680095663530488e-01, -6.959608164603131e-04,  1.995639330421083e-06, -4.457730813593695e-09,
  7.224823000415576e-12, -4.315294045711918e-15, -2.367429351138854e-17,  1.183983113933737e-19, -3.235622762004386e-22,  5.347458541505264e-25,  2.147535757058536e-30,
 -3.761770855522710e-30,  2.009362431874714e-01, -8.209403710279214e-04,  2.278899032374394e-06, -4.739908563275939e-09,  6.295045352276011e-12,  1.868717626563870e-15,
 -4.310085396487756e-17,  1.530767604539937e-19, -3.155068294842251e-22,  2.073304655206469e-25,  1.396022471295452e-27, -7.207546150071671e-30,  2.366203180310929e-01,
 -9.520296011441228e-04,  2.547263111170593e-06, -4.857951419405196e-09,  4.701435084014421e-12,  9.488787555347357e-15, -6.218705619599933e-17,  1.702355490576167e-19,
 -2.252486948507540e-22, -3.337862223291662e-25,  2.960081688622759e-27, -9.248970411297064e-30,  2.749955033760230e-01, -1.087875797507108e-03,  2.791808374806299e-06,
 -4.783719882115068e-09,  2.446000226816968e-12,  1.803496996579819e-14, -7.801615955739747e-17,  1.611309003173876e-19, -4.608974265074775e-23, -1.006764148113024e-24,
  4.177431485643790e-27, -8.241994675810054e-30,  3.159879794694986e-01, -1.227025090524149e-03,  3.003609423173764e-06, -4.495049733681800e-09, -4.200374384874483e-13,
  2.680091958011214e-14, -8.746888411061021e-17,  1.196685066837093e-19,  2.089076051795768e-22, -1.659050581103731e-24,  4.445595903628560e-27, -3.149633102304213e-30,
  3.595158974171746e-01, -1.367927785589949e-03,  3.173935947065489e-06, -3.977337784160591e-09, -3.792913596341944e-12,  3.492200389418221e-14, -8.762672923177585e-17,
  4.425135809973859e-20,  5.040967730187669e-22, -2.089058621967560e-24,  3.266410117307356e-27,  5.726275373679701e-30,  4.054888414186951e-01, -1.508945185307682e-03,
  3.294469626114236e-06, -3.225034900887216e-09, -7.515965453403303e-12,  4.143626712006590e-14, -7.623610758676871e-17, -6.073328105843138e-20,  7.829969084636352e-22,
 -2.089960883014993e-24,  4.706595655281190e-28,  1.629077252557729e-29,  4.538072514275983e-01, -1.648358177869574e-03,  3.357539693956945e-06, -2.242971712931770e-09,
 -1.138283388719331e-11,  4.536713105026925e-14, -5.218423824129647e-17, -1.841587016859388e-19,  9.756070476534504e-22, -1.510210356198097e-24, -3.591220996445289e-27,
  2.479872644595289e-29,  5.043618084759985e-01, -1.784377898439082e-03,  3.356375273889800e-06, -1.047430130370236e-09, -1.514471992301733e-11,  4.582432264474144e-14,
 -1.592272721849419e-17, -3.084835046078126e-19,  1.011285652410745e-21, -3.184573802050634e-25, -7.976304797243621e-27,  2.679289122909232e-29,  5.570327861215093e-01,
 -1.915158795099914e-03,  3.285371346605440e-06,  3.331376649594743e-10, -1.852203525594480e-11,  4.211670976839712e-14,  3.023620256188020e-17, -4.114090479947401e-19,
  8.358426418614705e-22,  1.345463656273975e-24, -1.126893483747286e-26,  1.876819662763347e-29,  6.116893730070097e-01, -2.038814450232588e-03,  3.140363659627753e-06,
  1.857850470858296e-09, -2.122054797691244e-11,  3.386766603371883e-14,  8.202949674470123e-17, -4.689435116347206e-19,  4.299536685941894e-22,  3.154586560275688e-24,
 -1.192622877839362e-26,  1.296661031152732e-31,  6.681889734238676e-01, -2.153436518683565e-03,  2.918906001907514e-06,  3.473712706203777e-09, -2.295179208682567e-11,
  2.112055333078994e-14,  1.334303630650219e-16, -4.596855248895053e-19, -1.753964258217035e-22,  4.632205310520511e-24, -8.808787620078158e-27, -2.532973941820865e-29,
  7.263764950881196e-01, -2.257117141454226e-03,  2.620541040887287e-06,  5.116614738487597e-09, -2.345707675844219e-11,  4.419329247253732e-15,  1.771620938083369e-16,
 -3.698177802037344e-19, -8.915590141135251e-22,  5.250772353466828e-24, -1.763974943834687e-27, -4.934646011069727e-29,  7.860836361268072e-01, -2.347975172388678e-03,
  2.247053376625488e-06,  6.713121180776494e-09, -2.253390319094969e-11, -1.515226897812765e-14,  2.055491797189786e-16, -1.979630583752117e-19, -1.577812807479507e-21,
  4.582934139705834e-24,  7.952154988154588e-27, -6.117486235581289e-29,  8.471281865712181e-01, -2.424186508812168e-03,  1.802690675427727e-06,  8.183126957907854e-09,
 -2.006299427761895e-11, -3.598933346801352e-14,  2.116601598739604e-16,  4.122368427067743e-20, -2.062961342230095e-21,  2.473045923954362e-24,  1.765728657775750e-26,
 -5.161304963114364e-29,  9.093133634942426e-01, -2.484018737409411e-03,  1.294335832265930e-06,  9.443422469334934e-09, -1.603350919456356e-11, -5.605586413260333e-14,
  1.906266739109917e-16,  3.159733737520389e-19, -2.182467803993150e-21, -8.234980889345679e-25,  2.380779429287955e-26, -1.796323100767004e-29,  9.724272033161367e-01,
 -2.525870184957111e-03,  7.316102865965791e-07,  1.041215140958506e-08, -1.056342491068238e-11, -7.305406004067348e-14,  1.409478821381720e-16,  5.799279401301495e-19,
 -1.825679933433082e-21, -4.596452336295986e-24,  2.314433231743872e-26,  3.221590701829135e-29,  1.036242039706542e+00, -2.548313290341751e-03,  1.268861909136868e-07,
  1.101406532877982e-08, -3.911626952297141e-12, -8.467092529389024e-14,  6.552345965537264e-17,  7.788589976800359e-19, -9.822463139935719e-22, -7.786091406432662e-24,
  1.414525898859697e-26,  8.109831815093423e-29,  1.100514100849201e+00, -2.550141980226846e-03, -5.048164652029281e-07,  1.118637726500081e-08,  3.521896307841729e-12,
 -8.888700775218974e-14, -2.787768292380543e-17,  8.612645781361214e-19,  2.273685577835499e-22, -9.254586174887948e-24, -1.758653973586561e-27,  1.059773720010967e-28,
  1.164983265458158e+00, -2.530422427708060e-03, -1.146071884844539e-06,  1.088489532408632e-08,  1.121105176180809e-11, -8.431610239720849e-14, -1.269878488802960e-16,
  7.913176367031543e-19,  1.553041386923441e-21, -8.178061988029033e-24, -1.988613211418149e-26,  8.935760888572807e-29,  1.229373022598602e+00, -2.488546196262504e-03,
 -1.777451910989169e-06,  1.008998310090011e-08,  1.853619023819924e-11, -7.052818632275816e-14, -2.164308557028767e-16,  5.613606344042463e-19,  2.658620247140119e-21,
 -4.442199459096996e-24, -3.343640408810074e-26,  2.989418520784237e-29,  1.293390685718199e+00, -2.424284320581118e-03, -2.378108497984050e-06,  8.811760616828744e-09,
  2.483486197889354e-11, -4.829419861179711e-14, -2.801306637174344e-16,  2.001993982288110e-19,  3.207287934265426e-21,  1.126963964607401e-24, -3.602768699879730e-26,
 -5.200128004558547e-29,  1.356727915851262e+00, -2.337840360102863e-03, -2.926544589569975e-06,  7.093847494595162e-09,  2.946892228653716e-11, -1.968524603140073e-14,
 -3.044765410419944e-16, -2.266384211496080e-19,  2.971370717934353e-21,  6.858294487965842e-24, -2.483525060694566e-26, -1.194383675756506e-28,  1.419061612090504e+00,
 -2.229899900579362e-03, -3.401570362970221e-06,  5.014887241735644e-09,  3.190291867865735e-11,  1.203433397242464e-14, -2.816867601324352e-16, -6.272810425452735e-19,
  1.932669357205520e-21,  1.072531394776183e-23, -2.838292593510552e-27, -1.359510491199910e-28,  1.480055228358506e+00, -2.101673409286188e-03, -3.783424859981059e-06,
  2.687111283238378e-09,  3.178512041907052e-11,  4.275643101794102e-14, -2.125596386924264e-16, -9.043952215169001e-19,  3.305312972541645e-22,  1.112716962499421e-23,
  2.139202096284047e-26, -8.709294889126275e-29,  1.539360573360531e+00, -1.954928824098537e-03, -4.055021806713357e-06,  2.513386845504243e-10,  2.901923921778395e-11,
  6.811436120159501e-14, -1.076980835572699e-16, -9.826043473784104e-19, -1.377880513521590e-21,  7.666664310902221e-24,  3.703122014166801e-26,  6.295838129759707e-30,
  1.596620144397117e+00, -1.792009848429383e-03, -4.203253979551471e-06, -2.131908868449005e-09,  2.381271812217243e-11,  8.423845655420487e-14,  1.354980756283150e-17,
 -8.346539101477959e-19, -2.653165024476159e-21,  1.527449494687025e-24,  3.639701927859953e-26,  9.492861943908059e-29,  1.651470034509689e+00, -1.615835723584391e-03,
 -4.220264927002475e-06, -4.295055342849062e-09,  1.668747227306709e-11,  8.855329599482173e-14,  1.267138400188056e-16, -4.964694776780923e-19, -3.070528177962959e-21,
 -4.856852791974440e-24,  1.961805326246816e-26,  1.286663741885649e-28,  1.703543435421669e+00, -1.429878359823347e-03, -4.104573529064572e-06, -6.079177624319900e-09,
  8.442108599485102e-12,  8.043738143039285e-14,  2.079098194423921e-16, -6.270129135074966e-20, -2.502464466444358e-21, -8.833909818465557e-24, -4.591085358816263e-27,
  8.953404316135899e-29,  1.752474735434915e+00, -1.238113230037253e-03, -3.861920216364850e-06, -7.351402284225249e-09,  6.145248760215709e-14,  6.155061336756409e-14,
  2.402987711665857e-16,  3.398655453397589e-19, -1.197170110031049e-21, -8.833384862206829e-24, -2.339354397884534e-26,  6.145470341663562e-30,  1.797904181880034e+00,
 -1.044941450849357e-03, -3.505698849182805e-06, -8.021979685814993e-09, -7.420662325900732e-12,  3.567412602384590e-14,  2.193287371647258e-16,  5.946695583150372e-19,
  3.063983783643682e-22, -5.226861572128827e-24, -2.743432652668192e-26, -6.499469752629050e-29,  1.839483042662751e+00, -8.550820403687492e-04, -3.056850349437912e-06,
 -8.058548892152124e-09, -1.308743882646698e-11,  8.008587191052985e-15,  1.547369460285835e-16,  6.383974050093243e-19,  1.410934560216939e-21, -1.572943217782731e-25,
 -1.668796008209632e-26, -8.063787537738884e-29,  1.876879162576106e+00, -6.734354296434836e-04, -2.543126971815455e-06, -7.494964883770911e-09, -1.630506664748816e-11,
 -1.597268608246778e-14,  6.805444443580874e-17,  4.858839099425262e-19,  1.738238232673052e-21,  3.683969677690059e-24, -1.077744020743982e-28, -4.223892225811577e-29,
  1.909782770093794e+00, -5.049218080780031e-04, -1.997690651165155e-06, -6.432392757785634e-09, -1.685306804006565e-11, -3.185944499220832e-14, -1.413483900378430e-17,
  2.231849405219556e-19,  1.304411387169033e-21,  4.636817722414925e-24,  1.110163752736921e-26,  9.747982724542813e-30,  1.937912353284463e+00, -3.543005923555565e-04,
 -1.457082165752283e-06, -5.031251651579742e-09, -1.498476605644934e-11, -3.746059081384917e-14, -6.915124365497222e-17, -3.126128417629615e-20,  4.846672667346761e-22,
  2.969646736729987e-24,  1.157797127186078e-26,  3.397951196370753e-29,  1.961020395382812e+00, -2.259799118159683e-04, -9.586820532984853e-07, -3.493961850533378e-09,
 -1.139451122711037e-11, -3.340509295933361e-14, -8.609858122076016e-17, -1.809595012418838e-19, -2.227917738415277e-22,  4.527982422901503e-25,  4.746392654126374e-27,
  2.278129622704887e-29,  1.978898756542039e+00, -1.238270714927627e-04, -5.378667180153480e-07, -2.040110460878082e-09, -7.087995405907834e-12, -2.293992408836709e-14,
 -6.936802982638245e-17, -1.945023991847263e-19, -4.944313078205706e-22, -1.075530815465655e-24, -1.637853456761335e-27,  6.372545190507360e-31,  1.991383600607934e+00,
 -5.099158429865921e-05, -2.251265098626976e-07, -8.772622444478117e-10, -3.176245322247876e-12, -1.091881008313577e-14, -3.600464207680856e-17, -1.144103823171272e-19,
 -3.507266890713237e-22, -1.035312128117378e-24, -2.927700950097540e-27, -7.850251367922112e-30,  1.998361457512136e+00, -9.742541921049381e-06, -4.340296544455100e-08,
 -1.716508782817932e-10, -6.353844006841868e-13, -2.253455340206319e-15, -7.752315902768783e-18, -2.605623245187778e-20, -8.594974777670635e-23, -2.790638868095006e-25,
 -8.935798992083117e-28, -2.825439810050661e-30,  3.797069624845962e-04, -1.665159410053576e-06,  5.475842897216269e-09, -1.600325393136939e-11,  4.383448739919686e-14,
 -1.152291196363929e-16,  2.943767920631071e-19, -7.363962434659058e-22,  1.812415126649604e-24, -4.403373312758976e-27,  1.058450012675923e-29, -2.521637264243084e-32,
  3.416572515844984e-03, -1.496639394166658e-05,  4.910096973434358e-08, -1.429191484317760e-10,  3.890532418797723e-13, -1.013748955800334e-15,  2.559153353541123e-18,
 -6.303035429122716e-21,  1.520937380077903e-23, -3.605353649836146e-26,  8.408426601878301e-29, -1.931156321833820e-31,  9.486082257405043e-03, -4.146196117672587e-05,
  1.353845290815030e-07, -3.908620595341840e-10,  1.050686258679530e-12, -2.688575183986965e-15,  6.619912786565836e-18, -1.576970081456509e-20,  3.642309052253789e-23,
 -8.156418674608320e-26,  1.766673296473073e-28, -3.683158331702151e-31,  1.857975860873454e-02, -8.093797423774403e-05,  2.624024189936672e-07, -7.482070957989394e-10,
  1.972558878412005e-12, -4.905362893655966e-15,  1.159785939499955e-17, -2.610299741510396e-20,  5.567351325294196e-23, -1.112128779131356e-25,  2.027370331022035e-28,
 -3.167146322638577e-31,  3.068479787170343e-02, -1.330734057248823e-04,  4.272918910535867e-07, -1.197898926589850e-09,  3.073962559516468e-12, -7.337299846435125e-15,
  1.631685749448027e-17, -3.346460286104081e-20,  6.149611452728509e-23, -9.365525478436481e-26,  8.472849508599398e-29,  1.297221117078660e-31,  4.578396484687975e-02,
 -1.974398822379529e-04,  6.262801594092058e-07, -1.717909632864598e-09,  4.253827138116877e-12, -9.593354528920031e-15,  1.946030897990445e-17, -3.396245285300094e-20,
  4.393174353906850e-23, -8.130409737013010e-27, -2.045027612134880e-28,  9.394787981341195e-31,  6.385545136070987e-02, -2.735014630358080e-04,  8.547234125285597e-07,
 -2.281847868719372e-09,  5.396127006172603e-12, -1.125361574265446e-14,  1.975824695168167e-17, -2.448951612133095e-20, -2.226293796513402e-24,  1.446889981644028e-25,
 -6.112946347010656e-28,  1.817751581816975e-30,  8.487269789814475e-02, -3.606144497997531e-04,  1.107156956422484e-06, -2.859717448263504e-09,  6.376379564285856e-12,
 -1.190974751372707e-14,  1.618691524526448e-17, -3.528082607045107e-21, -7.481841218856826e-23,  3.365092046766828e-25, -9.963106249802485e-28,  2.258686700966232e-30,
  1.088041773673727e-01, -4.580272885324511e-04,  1.377357380340090e-06, -3.418822021662907e-09,  7.069050353929348e-12, -1.120812022176903e-14,  8.160245676047316e-18,
  2.821137395739166e-20, -1.629992240265399e-22,  5.125359117568327e-25, -1.162886006820817e-27,  1.722255249548235e-30,  1.356131398772666e-01, -5.648806402385187e-04,
  1.658417780720788e-06, -3.924810368966989e-09,  7.355630438812013e-12, -8.892753896279221e-15, -4.309044651356319e-18,  6.744259943119828e-20, -2.477303703066244e-22,
  6.011846487665811e-25, -9.171071874100415e-28, -1.046181784949658e-31,  1.652573172943907e-01, -6.802077144984452e-04,  1.942837198601314e-06, -4.342853857583096e-09,
  7.133097845156653e-12, -4.844847477942336e-15, -2.050120433993917e-17,  1.083520380928653e-19, -3.043477843087676e-22,  5.317380013443502e-25, -1.473536027115464e-28,
 -3.049533623230426e-30,  1.976885862754180e-01, -8.029349796451754e-04,  2.222625509197150e-06, -4.638943609475710e-09,  6.322416812377407e-12,  8.845973171174358e-16,
 -3.895485633553423e-17,  1.431101373877987e-19, -3.071117746279780e-22,  2.570969464890174e-25,  1.098819910294701e-27, -6.312648933720940e-30,  2.328525884557000e-01,
 -9.318833852284523e-04,  2.489425036220054e-06, -4.781289738119068e-09,  4.876667782208685e-12,  8.052672546302851e-15, -5.752302031627149e-17,  1.628573979924154e-19,
 -2.352299566670402e-22, -2.233174260850756e-25,  2.568470653882275e-27, -8.547370213184946e-30,  2.706883065318633e-01, -1.065770256991134e-03,  2.734650129965818e-06,
 -4.741798485813476e-09,  2.788340193427699e-12,  1.621652310484452e-14, -7.353036534622837e-17,  1.591076723223420e-19, -7.941296344571254e-23, -8.469245212996172e-25,
  3.814729021714417e-27, -8.217970813369928e-30,  3.111275951258812e-01, -1.203212051774089e-03,  2.949645825057859e-06, -4.497595092849550e-09,  9.526350342778611e-14,
  2.474257642287938e-14, -8.403331108163135e-17,  1.254319657855231e-19,  1.523461871670988e-22, -1.484326838816441e-24,  4.282978129103810e-27, -4.195458909096564e-30,
  3.540946655848687e-01, -1.342728189558269e-03,  3.125866453565666e-06, -4.032550693147458e-09, -3.115394442395871e-12,  3.283558508544396e-14, -8.617297939501011e-17,
  5.920482667617098e-20,  4.312971545360964e-22, -1.954022571779186e-24,  3.469631480336974e-27,  3.562170454808618e-30,  3.995055242849204e-01, -1.482746211982027e-03,
  3.255074699075932e-06, -3.338760485417719e-09, -6.705660181686295e-12,  3.958895611560417e-14, -7.759713393071708e-17, -3.687621204353374e-20,  7.082623268988469e-22,
 -2.057632254022154e-24,  1.125448273714064e-27,  1.350097034509307e-29,  4.472673646047134e-01, -1.621608550583470e-03,  3.329560998589893e-06, -2.417908052779902e-09,
 -1.048841513977383e-11,  4.405630862904560e-14, -5.691196868966328e-17, -1.538347881958955e-19,  9.189105235074292e-22, -1.632723502742650e-24, -2.551697809151123e-27,
  2.243014486042114e-29,  4.972779135580067e-01, -1.757581222754281e-03,  3.342382388141857e-06, -1.282437391881238e-09, -1.423273571912351e-11,  4.534217080513754e-14,
 -2.410935856384869e-17, -2.763650741005490e-19,  9.943611346856010e-22, -6.140739564887414e-25, -6.809001575657498e-27,  2.617984541681473e-29,  5.494247351733574e-01,
 -1.888864807458404e-03,  3.287618797377067e-06,  4.355934074083706e-11, -1.767336164873159e-11,  4.270720928274960e-14,  1.909787770103366e-17, -3.839724334931815e-19,
  8.763713137187804e-22,  9.119349883951489e-25, -1.039133221047812e-26,  2.098890689239438e-29,  6.035844941412980e-01, -2.013608083970254e-03,  3.160643379696488e-06,
  1.523843061197233e-09, -2.052456267262289e-11,  3.568046529264325e-14,  6.910811440439185e-17, -4.534599154567995e-19,  5.349478528167569e-22,  2.679241579139295e-24,
 -1.180307033072347e-26,  5.339587859959318e-30,  6.596221850775644e-01, -2.129924742133958e-03,  2.958401673536126e-06,  3.110032928873179e-09, -2.249840293281137e-11,
  2.416794507720629e-14,  1.205051634120204e-16, -4.627001201637744e-19, -1.522913020632333e-23,  4.259627575652684e-24, -9.769537856917562e-27, -1.839038563243889e-29,
  7.173903350448849e-01, -2.235913587743968e-03,  2.679692193715860e-06,  4.742236045967106e-09, -2.332702594009187e-11,  8.543910918665732e-15,  1.664360735217330e-16,
 -3.953409857079224e-19, -7.043088353304100e-22,  5.138521754445348e-24, -3.804629911055670e-27, -4.331957547771060e-29,  7.767281898072860e-01, -2.329682666080468e-03,
  2.325438438438474e-06,  6.350420417533495e-09, -2.278809457927840e-11, -1.029115511194188e-14,  1.993245640979526e-16, -2.457571476436975e-19, -1.407746425437195e-21,
  4.847635549802844e-24,  5.296648279267682e-27, -5.929266777087879e-29,  8.374608977303732e-01, -2.409377703358405e-03,  1.898939293316024e-06,  7.856637020301488e-09,
 -2.073192719944011e-11, -3.090301111609346e-14,  2.119045461503342e-16, -2.323482401216258e-20, -1.961779590402696e-21,  3.132423738330606e-24,  1.527795334634025e-26,
 -5.623343140211836e-29,  8.993987093508773e-01, -2.473215211162824e-03,  1.406081501228686e-06,  9.178168826940749e-09, -1.710820032626795e-11, -5.138256957244868e-14,
  1.984930264631379e-16,  2.458421179826582e-19, -2.195193124718984e-21,  1.096726721367873e-25,  2.277063424501775e-26, -2.895788099208447e-29,  9.623362154631825e-01,
 -2.519520502469394e-03,  8.554944091994255e-07,  1.023163715769364e-08, -1.198939808686513e-11, -6.948320318432583e-14,  1.563443725774647e-16,  5.190398289469911e-19,
 -1.974183761585332e-21, -3.646403962318060e-24,  2.425699060477123e-26,  1.834306998791614e-29,  1.026051652122194e+00, -2.546770717749342e-03,  2.586238727307176e-07,
  1.093802473964688e-08, -5.587572816157301e-12, -8.284047236434433e-14,  8.685014503760021e-17,  7.430583326694454e-19, -1.251527896697459e-21, -7.151891166233007e-24,
  1.748754128613687e-26,  7.050392029142914e-29,  1.090306307203553e+00, -2.553642743187632e-03, -3.703005967276029e-07,  1.122847754227244e-08,  1.739421798642567e-12,
 -8.926617318349450e-14, -3.710543408715896e-18,  8.632052737842435e-19, -1.059393442851908e-22, -9.231755574090547e-24,  2.892466333799448e-27,  1.049187602434477e-28,
  1.154844069983978e+00, -2.539065607603699e-03, -1.014433044191361e-06,  1.105062361457911e-08,  9.496075188023170e-12, -8.709258957613389e-14, -1.041805011172910e-16,
  8.361587806935028e-19,  1.245292988112162e-21, -8.891363120046527e-24, -1.569694863410108e-26,  1.006058646247665e-28,  1.219391172395974e+00, -2.502276559527047e-03,
 -1.654640087308246e-06,  1.037500092419383e-08,  1.707500529616050e-11, -7.552445303937941e-14, -1.995475609320524e-16,  6.436225768344161e-19,  2.474998224094593e-21,
 -5.747383905394087e-24, -3.167612355451365e-26,  5.002329531108269e-29,  1.283656177830542e+00, -2.442879544743063e-03, -2.270016275564416e-06,  9.201028161260882e-09,
  2.380226075992101e-11, -5.493844255133325e-14, -2.730841236956022e-16,  3.031994674372122e-19,  3.221418184901650e-21, -3.542790969360665e-25, -3.789088628852711e-26,
 -3.229723251599676e-29,  1.347330280103182e+00, -2.360904229103837e-03, -2.838603686890358e-06,  7.561801612965270e-09,  2.900168545140730e-11, -2.705786802213000e-14,
 -3.094555515374948e-16, -1.278060654356030e-19,  3.199140420168650e-21,  5.761926414015036e-24, -2.992232615373733e-26, -1.110862769965876e-28,  1.410087980765605e+00,
 -2.256863055425024e-03, -3.338322299064906e-06,  5.526886273069723e-09,  3.207461549014075e-11,  5.070429521749972e-15, -2.983269729240310e-16, -5.592916328622386e-19,
  2.315268602648890e-21,  1.048924476306340e-23, -9.030571052984803e-27, -1.449195962152799e-28,  1.471588216432909e+00, -2.131803118125359e-03, -3.748100855092316e-06,
  3.202228477594679e-09,  3.258719132630034e-11,  3.735269394166753e-14, -2.376732745822346e-16, -8.872517168695254e-19,  7.455276946720120e-22,  1.189957658660609e-23,
  1.706492339239042e-26, -1.095136477786917e-28,  1.531476008095652e+00, -1.987348938487702e-03, -4.049175420740117e-06,  7.263949308598874e-10,  3.035342572471308e-11,
  6.519473497066158e-14, -1.357847643385937e-16, -1.021994491852336e-18, -1.075210885260315e-21,  9.146871009928379e-24,  3.681057192459873e-26, -1.683856724257218e-29,
  1.589384700227646e+00, -1.825731606715051e-03, -4.226495232542319e-06, -1.737417674255132e-09,  2.549879688249434e-11,  8.427367543174085e-14, -1.099880340211164e-17,
 -9.183863728664721e-19, -2.570987215313853e-21,  3.064294937720646e-24,  4.037353677159784e-26,  8.507524341255513e-29,  1.644938847539086e+00, -1.649799331014163e-03,
 -4.270144626763270e-06, -4.013726952432805e-09,  1.848776547480094e-11,  9.141635551466083e-14,  1.114119574966780e-16, -5.973612298047791e-19, -3.229859562764724e-21,
 -3.956090872153136e-24,  2.548506227521725e-26,  1.375796679414927e-28,  1.697757790193592e+00, -1.463004328305697e-03, -4.176659253279166e-06, -5.930963554785476e-09,
  1.010056436123359e-11,  8.539680563052097e-14,  2.049850637446797e-16, -1.478958726947649e-19, -2.822787870569116e-21, -8.932871102489879e-24, -2.093072629294144e-28,
  1.098005710304843e-28,  1.747459933234259e+00, -1.269361346754261e-03, -3.950089497265155e-06, -7.340254442876586e-09,  1.350883632031679e-12,  6.742734945931937e-14,
  2.492295847830263e-16,  2.962882792898791e-19, -1.531907826546581e-21, -9.759023622317149e-24, -2.276625271278616e-26,  2.291842963357944e-29,  1.793667712448925e+00,
 -1.073374058976887e-03, -3.602650502116593e-06, -8.134710739307156e-09, -6.653187237797577e-12,  4.113875104757467e-14,  2.360869212666408e-16,  6.012462797369974e-19,
  9.779456474795108e-23, -6.380831362073051e-24, -3.024469572629457e-26, -6.231223452478872e-29,  1.836013187438131e+00, -8.799271997799071e-04, -3.154803374167955e-06,
 -8.266458593227962e-09, -1.288865600228011e-11,  1.194186734991497e-14,  1.732423612248432e-16,  6.833207656303024e-19,  1.392375274507224e-21, -8.986597760823403e-25,
 -2.045168678757682e-26, -9.043162042915602e-29,  1.874144154916252e+00, -6.941446623890523e-04, -2.634642078415249e-06, -7.758308096642381e-09, -1.660705231396326e-11,
 -1.416971453254203e-14,  8.245783435661493e-17,  5.436248401881892e-19,  1.870306218935143e-21,  3.639232517788917e-24, -2.212781953699016e-27, -5.373259707337532e-29,
  1.907730624413652e+00, -5.212167207094115e-04, -2.076518339715544e-06, -6.707155577869553e-09, -1.749311807524805e-11, -3.211881691385283e-14, -7.275574328416878e-18,
  2.676833916337816e-19,  1.479423542284082e-21,  5.088362718816138e-24,  1.144595105738355e-26,  5.670695303764078e-30,  1.936471449395302e+00, -3.662028831445103e-04,
 -1.518920739931890e-06, -5.277092041014760e-09, -1.575063558327610e-11, -3.912886984478990e-14, -6.979270247309994e-17, -1.394905063579698e-20,  6.002798527834825e-22,
  3.463639264644881e-24,  1.314571921662264e-26,  3.728177556599327e-29,  1.960100866838229e+00, -2.338202292320151e-04, -1.001725884366011e-06, -3.681732854612795e-09,
 -1.208369125662495e-11, -3.553305049429706e-14, -9.126253447223222e-17, -1.877893506312589e-19, -2.028209344127024e-22,  6.639328550020735e-25,  5.842002373731434e-27,
  2.713019917423172e-29,  1.978394684571671e+00, -1.282298939394538e-04, -5.630439296031455e-07, -2.157281115428805e-09, -7.563892739665840e-12, -2.467193370077718e-14,
 -7.504151274701650e-17, -2.109562787619417e-19, -5.343202418160741e-22, -1.140186491138974e-24, -1.587025157714669e-27,  1.723760564872148e-30,  1.991175964332701e+00,
 -5.283558581114631e-05, -2.359659378772184e-07, -9.298772417231738e-10, -3.403528824274728e-12, -1.182266687287622e-14, -3.937102658421044e-17, -1.262532705092922e-19,
 -3.901916917035777e-22, -1.159613018694531e-24, -3.294588854252605e-27, -8.845195291369328e-30,  1.998321779602950e+00, -1.009818120350469e-05, -4.552529360420466e-08,
 -1.821879443353414e-10, -6.823748053786413e-13, -2.448586145842891e-15, -8.521956820849250e-18, -2.897451446571529e-20, -9.667056059652556e-23, -3.174234701530308e-25,
 -1.027747251055601e-27, -3.285320145787154e-30,  3.731327386880622e-04, -1.622109072772614e-06,  5.287937134183432e-09, -1.531996181921855e-11,  4.159891854920438e-14,
 -1.084050956768091e-16,  2.745463984107530e-19, -6.808557109663742e-22,  1.661254613342040e-24, -4.001366912953504e-27,  9.535436345606007e-30, -2.252235620866022e-32,
  3.357481841130631e-03, -1.458034199994597e-05,  4.742263063832995e-08, -1.368532182892251e-10,  3.693784435110821e-13, -9.543932746055953e-16,  2.389291572767174e-18,
 -5.836469432225279e-21,  1.396999424453874e-23, -3.285411282767460e-26,  7.603110742896704e-29, -1.733139437583360e-31,  9.322371257792287e-03, -4.039736456755534e-05,
  1.307933033462440e-07, -3.744727668507607e-10,  9.984684377236502e-13, -2.534866855850866e-15,  6.194246826104725e-18, -1.464981010758238e-20,  3.361016699064972e-23,
 -7.481151734919463e-26,  1.612100365457246e-28, -3.348240270235531e-31,  1.826014903450273e-02, -7.887413964949183e-05,  2.536101102758813e-07, -7.174161331241530e-10,
  1.877176930125431e-12, -4.635587203981284e-15,  1.089132631940007e-17, -2.438396544955009e-20,  5.181250555367357e-23, -1.033773032914619e-25,  1.891610720885641e-28,
 -3.003296911662860e-31,  3.015925104461223e-02, -1.297117446431386e-04,  4.132074297837924e-07, -1.149868531052837e-09,  2.931057846772552e-12, -6.956720094880707e-15,
  1.540689673538868e-17, -3.155000819985332e-20,  5.818677761696621e-23, -9.016586924775315e-26,  8.941281152244431e-29,  8.466824249293442e-32,  4.500409685379666e-02,
 -1.925109580026999e-04,  6.060673609298860e-07, -1.651358279604975e-09,  4.066554314500101e-12, -9.137559965314211e-15,  1.852898691970839e-17, -3.256282053994470e-20,
  4.350139663823372e-23, -1.552441499184481e-26, -1.661699591512547e-28,  8.059244858964872e-31,  6.277494971249906e-02, -2.667717536259943e-04,  8.278519217317261e-07,
 -2.197284883610427e-09,  5.175741106581907e-12, -1.078764969548983e-14,  1.907229342019726e-17, -2.448198302032159e-20,  2.561106106433113e-24,  1.217770046337618e-25,
 -5.357499045995747e-28,  1.619350497825160e-30,  8.344773969655757e-02, -3.518927441765151e-04,  1.073444687318482e-06, -2.759579865413689e-09,  6.142060120286481e-12,
 -1.152270660356619e-14,  1.605637774527545e-17, -5.735942694521424e-21, -6.339794042159576e-23,  2.985931981960363e-25, -9.007481639490325e-28,  2.085930331112941e-30,
  1.069938487929976e-01, -4.471706271309920e-04,  1.337002782732421e-06, -3.307499616091738e-09,  6.846907416913267e-12, -1.100336797738886e-14,  8.879851192214089e-18,
  2.328179023023091e-20, -1.453669467777113e-22,  4.675356184719780e-25, -1.087188122999366e-27,  1.714196545364495e-30,  1.333798565219148e-01, -5.517997017093525e-04,
  1.612020311112408e-06, -3.808548115372809e-09,  7.176889604338973e-12, -8.974386302966604e-15, -2.528431964786356e-18,  5.985442629634418e-20, -2.267483292429331e-22,
  5.644974425033815e-25, -9.151654877581278e-28,  1.821721437970270e-31,  1.625672445038693e-01, -6.648715412249976e-04,  1.891404448278313e-06, -4.229525189289695e-09,
  7.031520736216795e-12, -5.301552978114012e-15, -1.760082688873673e-17,  9.891780149508562e-20, -2.853419158319444e-22,  5.233492552785737e-25, -2.675665047234357e-28,
 -2.429197477473631e-30,  1.945120582344433e-01, -7.853749241462344e-04,  2.167565560861075e-06, -4.537692859498154e-09,  6.331078465038758e-12, -3.335902769501517e-18,
 -3.508390974903479e-17,  1.334386029997831e-19, -2.971298033608990e-22,  2.957429573847763e-25,  8.395012841394297e-28, -5.486043469955428e-30,  2.291645242255190e-01,
 -9.121961486321228e-04,  2.432522795455573e-06, -4.702048101003820e-09,  5.024280643861280e-12,  6.725982815419826e-15, -5.306946761716971e-17,  1.552205141016073e-19,
 -2.415088058198006e-22, -1.278897817757204e-25,  2.208133517457887e-27, -7.830675252203693e-30,  2.664686206317383e-01, -1.044119879816530e-03,  2.678026625233117e-06,
 -4.694684773430110e-09,  3.095382624202642e-12,  1.450494022048465e-14, -6.911530520749322e-17,  1.561073736153049e-19, -1.072424372473686e-22, -7.015271552879258e-25,
  3.456362513026307e-27, -8.050530214841064e-30,  3.063615995200346e-01, -1.179830706923657e-03,  2.895699807668965e-06, -4.492220440602137e-09,  5.702341587237080e-13,
  2.276842477950128e-14, -8.046076455596075e-17,  1.294847598434590e-19,  1.019473877393474e-22, -1.316947506351254e-24,  4.080308445811123e-27, -4.975873594525531e-30,
  3.487734590846149e-01, -1.317915618567362e-03,  3.077198076478701e-06, -4.077255089311790e-09, -2.479222191425417e-12,  3.078882193822785e-14, -8.433240571883337e-17,
  7.190787627189745e-20,  3.634830300013107e-22, -1.812671633730555e-24,  3.584372447492354e-27,  1.702486456805243e-30,  3.936263643899133e-01, -1.456867639316037e-03,
  3.214391629964010e-06, -3.439818307866953e-09, -5.932575059985815e-12,  3.771672746404916e-14, -7.832343380782484e-17, -1.538721031319985e-20,  6.351339256563392e-22,
 -2.001513359090106e-24,  1.661563815989597e-27,  1.090194282107555e-29,  4.408340156774664e-01, -1.595090908553802e-03,  3.299568047011483e-06, -2.578749304271429e-09,
 -9.621279797260210e-12,  4.264200070391453e-14, -6.081663662011008e-17, -1.253879118879678e-19,  8.585265529781090e-22, -1.715773296606816e-24, -1.618725522907923e-27,
  1.996905957437528e-29,  4.903009639451803e-01, -1.730907523245028e-03,  3.325656613771356e-06, -1.502940421247913e-09, -1.333228685578903e-11,  4.467426089416254e-14,
 -3.140579201706072e-17, -2.449495533992454e-19,  9.676270311961455e-22, -8.636842656146051e-25, -5.679422324950512e-27,  2.509566390538306e-29,  5.419218744539881e-01,
 -1.862566508326560e-03,  3.286473124325388e-06, -2.323599865647769e-10, -1.681548832585494e-11,  4.303974008039089e-14,  8.743637974923288e-18, -3.554816618771808e-19,
  9.019462386939387e-22,  5.152309587931678e-25, -9.433354366248141e-27,  2.243387874863991e-29,  5.955807401023480e-01, -1.988255320348287e-03,  3.176982967724856e-06,
  1.201244768835918e-09, -1.979538550292805e-11,  3.718871775565037e-14,  5.666474689217551e-17, -4.348889187790355e-19,  6.229714275996104e-22,  2.213175532752586e-24,
 -1.146807078624501e-26,  9.755205458970067e-30,  6.511500483086129e-01, -2.106114328996351e-03,  2.993578669824381e-06,  2.754078087785581e-09, -2.198717188919111e-11,
  2.690468564896153e-14,  1.075652442002774e-16, -4.608107923158755e-19,  1.309063162704964e-22,  3.854625897026163e-24, -1.043275199440933e-26, -1.183039914922522e-29,
  7.084899072402453e-01, -2.214254753437163e-03,  2.734365963395242e-06,  4.370583882024778e-09, -2.311711213833509e-11,  1.240316511866691e-14,  1.550785747919458e-16,
 -4.149520680389632e-19, -5.225036989133714e-22,  4.950092466314287e-24, -5.569792802932634e-27, -3.686451957449972e-29,  7.674471400207916e-01, -2.310780550720502e-03,
  2.399449869545284e-06,  5.984421809566767e-09, -2.294666278211722e-11, -5.594867798061518e-15,  1.918391911814782e-16, -2.879769585065902e-19, -1.230039060596320e-21,
  5.008180489702513e-24,  2.754021350704690e-27, -5.608044089764520e-29,  8.278543590293160e-01, -2.393814754698034e-03,  1.991209170737342e-06,  7.520257679413848e-09,
 -2.129921923187529e-11, -2.583209441152586e-14,  2.103928590704961e-16, -8.409444820996503e-20, -1.838617409000164e-21,  3.693104680922110e-24,  1.273580059189093e-26,
 -5.902086149507505e-29,  8.895290366806887e-01, -2.461530736888623e-03,  1.514544071910565e-06,  8.896477443209770e-09, -1.808769680704969e-11, -4.654406193599234e-14,
  2.043949907845869e-16,  1.758322297483100e-19, -2.175183883442651e-21,  9.920978904168127e-25,  2.128125400580661e-26, -3.847956271709419e-29,  9.522725942268007e-01,
 -2.512188793994423e-03,  9.770778875487724e-07,  1.002889816019547e-08, -1.334039970256301e-11, -6.556379407269790e-14,  1.699746621734882e-16,  4.539542185917074e-19,
 -2.087831849145431e-21, -2.664051539138279e-24,  2.476051548205067e-26,  4.604385937077410e-30,  1.015869536212369e+00, -2.544178346546744e-03,  3.892894738852641e-07,
  1.083548934109698e-08, -7.221877352370957e-12, -8.051115973592560e-14,  1.070573844583374e-16,  6.990308141750321e-19, -1.495689123184664e-21, -6.393860352819885e-24,
  2.032428832452774e-26,  5.819422497447998e-29,  1.080086665274607e+00, -2.556065843591956e-03, -2.354507906467593e-07,  1.124202907169185e-08, -4.483772517166354e-14,
 -8.906587839416376e-14,  2.036199240266666e-17,  8.545290274472450e-19, -4.350961350139894e-22, -9.024729610520237e-24,  7.428609428404886e-27,  1.007722616242099e-28,
  1.144672419943147e+00, -2.546648192314796e-03, -8.809718368290821e-07,  1.118849818929868e-08,  7.731138486234152e-12, -8.930776915052095e-14, -8.025909705511076e-17,
  8.707743732749917e-19,  9.149936333331551e-22, -9.428039214707315e-24, -1.107639200424534e-26,  1.089024767663471e-28,  1.209356386819898e+00, -2.515011152236381e-03,
 -1.528551547613392e-06,  1.063586317219372e-08,  1.551812996676377e-11, -8.008858753321013e-14, -1.804501512380505e-16,  7.192721375443271e-19,  2.245868447722458e-21,
 -6.964669906814310e-24, -2.904843692380202e-26,  6.919771306273636e-29,  1.273849047696377e+00, -2.460591637185731e-03, -2.157356325084969e-06,  9.572721176691517e-09,
  2.263869948916430e-11, -6.137896015569701e-14, -2.631553604018934e-16,  4.057858605639629e-19,  3.181097154514783e-21, -1.892057229327840e-24, -3.883943408172290e-26,
 -1.053484608342014e-29,  1.337841831303814e+00, -2.383242247417948e-03, -2.745097073882874e-06,  8.021094785046222e-09,  2.838602946247583e-11, -3.451599283245883e-14,
 -3.115714242491876e-16, -2.235506527809670e-20,  3.383878210198831e-21,  4.470684153311640e-24, -3.454787979173693e-26, -9.846995717602414e-29,  1.401007547754075e+00,
 -2.283295613827203e-03, -3.268918428526672e-06,  6.040497201870017e-09,  3.210320187193143e-11, -2.268621695025818e-15, -3.128937003601146e-16, -4.792435335597347e-19,
  2.684825893468814e-21,  9.998708795384572e-24, -1.553277275111886e-26, -1.499274328939460e-28,  1.463001290301839e+00, -2.161625299562325e-03, -3.706522117099048e-06,
  3.729281650874367e-09,  3.327520696083928e-11,  3.135351490002556e-14, -2.621170429747230e-16, -8.564187445000194e-19,  1.184979296918441e-21,  1.247938203670122e-23,
  1.176892336325864e-26, -1.309748617683496e-28,  1.523461892525841e+00, -2.019699120868090e-03, -4.037502324473792e-06,  1.222294041377401e-09,  3.162239543163491e-11,
  6.158893689221265e-14, -1.648307862328765e-16, -1.050850357023748e-18, -7.196660866468299e-22,  1.059701213995709e-23,  3.550701833283887e-26, -4.284235526761295e-29,
  1.582014027793573e+00, -1.859619900992278e-03, -4.244840810254454e-06, -1.315976387385992e-09,  2.717950020510899e-11,  8.369194289029169e-14, -3.784657669864995e-17,
 -9.985741530217922e-19, -2.430736717005206e-21,  4.750167934025702e-24,  4.381402431745940e-26,  7.050483426581989e-29,  1.638271030141407e+00, -1.684147978382127e-03,
 -4.316473735356051e-06, -3.703156705375616e-09,  2.034141574815155e-11,  9.387772568334696e-14,  9.321892750059301e-17, -7.027867362788001e-19, -3.352452332864382e-21,
 -2.813649717749787e-24,  3.167949942622500e-26,  1.434007212307163e-28,  1.691838499631016e+00, -1.496699409697025e-03, -4.246803938306729e-06, -5.755425330993798e-09,
  1.185730744867852e-11,  9.025624998618347e-14,  1.995310706589134e-16, -2.433622175492217e-19, -3.143301775217175e-21, -8.838480649576774e-24,  5.081471662724015e-27,
  1.307465750565068e-28,  1.742318729212488e+00, -1.301313922890664e-03, -4.037997303496645e-06, -7.307524216686016e-09,  2.759887674835830e-12,  7.350254212441986e-14,
  2.567853060743815e-16,  2.414725839433227e-19, -1.899329991013247e-21, -1.064381587460063e-23, -2.132634815364350e-26,  4.310423136534970e-29,  1.789315953097140e+00,
 -1.102587474216771e-03, -3.700877572507426e-06, -8.234265950173502e-09, -5.772386833113011e-12,  4.700698880202785e-14,  2.529294006674690e-16,  6.004615759305143e-19,
 -1.543397383480596e-22, -7.644029013648804e-24, -3.287414754494838e-26, -5.666713195042979e-29,  1.832442368610748e+00, -9.055659028481477e-04, -3.255229556863078e-06,
 -8.470533887093162e-09, -1.260666484442156e-11,  1.633427889184466e-14,  1.929930916612004e-16,  7.271933059357403e-19,  1.344313463003511e-21, -1.799146713430706e-24,
 -2.464214184037708e-26, -9.996362161889838e-29,  1.871324825957433e+00, -7.155987357364324e-04, -2.729345041869753e-06, -8.026175264448497e-09, -1.686938831985397e-11,
 -1.200118520832065e-14,  9.853677292231382e-17,  6.055489062894752e-19,  1.999121419994746e-21,  3.499656004944803e-24, -4.862910511181795e-27, -6.703360670236312e-29,
  1.905612016711769e+00, -5.381556178921801e-04, -2.158704767936928e-06, -6.992191318338653e-09, -1.813660506817196e-11, -3.219796705369623e-14,  9.105129777603202e-19,
  3.180446030808692e-19,  1.670892045545591e-21,  5.549654825427485e-24,  1.157759263661583e-26,  2.738837558887701e-32,  1.934981927944486e+00, -3.786118937224742e-04,
 -1.583784025564075e-06, -5.535453931437756e-09, -1.654998314479579e-11, -4.080629204987465e-14, -6.989486289259715e-17,  7.359712212147781e-21,  7.348399003663148e-22,
  4.023238807490316e-24,  1.485787662736846e-26,  4.052219966089004e-29,  1.959149273783124e+00, -2.420141010403276e-04, -1.047090555204162e-06, -3.880878009793036e-09,
 -1.281668487156780e-11, -3.778715818706593e-14, -9.660757138035512e-17, -1.938496750949297e-19, -1.744124405280076e-22,  9.229237317877650e-25,  7.144435933597300e-27,
  3.219728270540251e-29,  1.977872589384884e+00, -1.328398903958491e-04, -5.896740427150337e-07, -2.282350806342705e-09, -8.075829973483962e-12, -2.654578177946456e-14,
 -8.119392108799793e-17, -2.287233543538503e-19, -5.764877983389458e-22, -1.201756928839491e-24, -1.481077536341959e-27,  3.155705825592359e-30,  1.990960774532705e+00,
 -5.476889149168404e-05, -2.474591761546828e-07, -9.862778972484159e-10, -3.649725009492107e-12, -1.281144304484286e-14, -4.308738569802933e-17, -1.394335561350365e-19,
 -4.344065462184408e-22, -1.299499188889226e-24, -3.707830697052300e-27, -9.959008741132059e-30,  1.998280644360123e+00, -1.047131797505792e-05, -4.777870975027227e-08,
 -1.935091099008706e-10, -7.334593645731036e-13, -2.663208956758398e-15, -9.378327781940786e-18, -3.225903430983538e-20, -1.088740018142828e-22, -3.615772951825568e-25,
 -1.183882193117442e-27, -3.826276902476616e-30,  3.667277608336527e-04, -1.580529781442159e-06,  5.108020683400451e-09, -1.467137230458695e-11,  3.949519408067633e-14,
 -1.020388730539510e-16,  2.562055389916821e-19, -6.299286317640048e-22,  1.523838716813202e-24, -3.639045660566002e-27,  8.598005709362829e-30, -2.013557322137696e-32,
  3.299908974330355e-03, -1.420743086908849e-05,  4.581523239258211e-08, -1.310928051489235e-10,  3.508510273927133e-13, -8.989618873265900e-16,  2.231955279576594e-18,
 -5.407781218695503e-21,  1.284019966740314e-23, -2.996004254561310e-26,  6.880092650329795e-29, -1.556642903027884e-31,  9.162846410842604e-03, -3.936872505138276e-05,
  1.263938358905542e-07, -3.588949105573448e-10,  9.492251117820595e-13, -2.391008178594993e-15,  5.798713326791858e-18, -1.361615992020287e-20,  3.102955691474910e-23,
 -6.864860039696074e-26,  1.471571414554501e-28, -3.044309236845040e-31,  1.794865642570412e-02, -7.687919110450992e-05,  2.451783115548346e-07, -6.881090227134305e-10,
  1.787024755396697e-12, -4.382204417853932e-15,  1.023123807448282e-17, -2.278407583179494e-20,  4.822397815734847e-23, -9.607029073945990e-26,  1.763098350309957e-28,
 -2.838192773704515e-31,  2.964692910665543e-02, -1.264604920917878e-04,  3.996858617962681e-07, -1.104064886735160e-09,  2.795550619430302e-12, -6.597347947029948e-15,
  1.454908116454668e-17, -2.973926999602017e-20,  5.500597659299936e-23, -8.652624686306808e-26,  9.229997882718911e-29,  4.780651930408628e-32,  4.424362613977256e-02,
 -1.877405919435495e-04,  5.866354974254553e-07, -1.587731565543555e-09,  3.888177030178681e-12, -8.703648646483116e-15,  1.763662379732107e-17, -3.118093352570923e-20,
  4.283109654305016e-23, -2.149744056196117e-26, -1.333291167165869e-28,  6.894897808929778e-31,  6.172094330115990e-02, -2.602530163617761e-04,  8.019743343508873e-07,
 -2.116174412437185e-09,  4.964510002479379e-12, -1.033812743243089e-14,  1.838857563176077e-17, -2.433388395754655e-20,  6.576014670199189e-24,  1.017179062075870e-25,
 -4.685113393258531e-28,  1.439970561376034e-30,  8.205713644240942e-02, -3.434359932499263e-04,  1.040911829381987e-06, -2.663129657634892e-09,  5.915445366232231e-12,
 -1.113950037319692e-14,  1.586893650688422e-17, -7.599464332836100e-21, -5.327545673171086e-23,  2.643493464481554e-25, -8.126582458888115e-28,  1.919294333761156e-30,
  1.052263095662843e-01, -4.366315191407142e-04,  1.297962866320240e-06, -3.199697844589650e-09,  6.629021373048725e-12, -1.078293925846051e-14,  9.469088242830063e-18,
  1.889110245393575e-20, -1.293003304263692e-22,  4.255488396156571e-25, -1.012380006716262e-27,  1.682817850546136e-30,  1.311981633283158e-01, -5.390844110757369e-04,
  1.567000782876837e-06, -3.695156525286343e-09,  6.996926645737917e-12, -9.015758979525965e-15, -9.510864784186416e-19,  5.291658520315782e-20, -2.070827570928737e-22,
  5.281218944796024e-25, -9.019621351580828e-28,  4.088278039358972e-31,  1.599377020555248e-01, -6.499414184770908e-04,  1.841321601155503e-06, -4.117891134108540e-09,
  6.921484564894075e-12, -5.691750908662557e-15, -1.495614514789505e-17,  9.008604459045684e-20, -2.667182488456834e-22,  5.106725890197538e-25, -3.623613817649554e-28,
 -1.892857014024372e-30,  1.914048971529355e-01, -7.682504871593319e-04,  2.113720883108362e-06, -4.436440636086695e-09,  6.322888737186274e-12, -8.015787296410316e-16,
 -3.147909891696025e-17,  1.241068197653455e-19, -2.859347070643649e-22,  3.247230530393669e-25,  6.150131131269517e-28, -4.729571695576969e-30,  2.255543045823073e-01,
 -8.929602881918295e-04,  2.376584768168232e-06, -4.620651194098277e-09,  5.146411138865100e-12,  5.503592728386969e-15, -4.883206361245917e-17,  1.474349532870330e-19,
 -2.446040968830012e-22, -4.624452258501015e-26,  1.879332974401307e-27, -7.116448091762800e-30,  2.623346339593993e-01, -1.022920148270402e-03,  2.621996850044611e-06,
 -4.642926508489768e-09,  3.369245707133756e-12,  1.289821478569416e-14, -6.479595377674686e-17,  1.522975305864585e-19, -1.300935318639311e-22, -5.702821314424095e-25,
  3.107922791373146e-27, -7.771690572023566e-30,  3.016882667442558e-01, -1.156880546007276e-03,  2.841862595537983e-06, -4.479557428157664e-09,  1.006587465620135e-12,
  2.088119925966778e-14, -7.679642412478673e-17,  1.320195753069027e-19,  5.742069292242714e-23, -1.158291221352982e-24,  3.848509675827158e-27, -5.525065878162257e-30,
  3.435507210169661e-01, -1.293494370460218e-03,  3.028052976404707e-06, -4.112105694874264e-09, -1.883515902455496e-12,  2.879026029773007e-14, -8.216575697656174e-17,
  8.252302297292441e-20,  3.008212225906814e-22, -1.668281056234279e-24,  3.623724210759929e-27,  1.325363180905003e-31,  3.878500604691762e-01, -1.431319174550212e-03,
  3.172568844963153e-06, -3.528807072205096e-09, -5.197061444411803e-12,  3.583402549696677e-14, -7.848047121435641e-17,  3.797925897565793e-21,  5.643848136590614e-22,
 -1.926174513167074e-24,  2.088031169218789e-27,  8.520408168731794e-30,  4.345062455372835e-01, -1.568820696837520e-03,  3.267727296201938e-06, -2.725947504384710e-09,
 -8.783304355294779e-12,  4.114331804013587e-14, -6.395224337778684e-17, -9.891416928312606e-20,  7.957983320150952e-22, -1.763679996576062e-24, -7.946660003560519e-28,
  1.749088909805621e-29,  4.834304251041286e-01, -1.704377970229618e-03,  3.306370775311427e-06, -1.709152351702965e-09, -1.244687661801517e-11,  4.384168753104156e-14,
 -3.783585706326457e-17, -2.145246795629106e-19,  9.327076917166652e-22, -1.069181048295982e-24, -4.606004112108340e-27,  2.364355858406152e-29,  5.345241679604893e-01,
 -1.836290384946219e-03,  3.282098951663800e-06, -4.945133649757738e-10, -1.595338436457048e-11,  4.313342157408695e-14, -8.034961571514257e-19, -3.263934869764291e-19,
  9.139429535944890e-22,  1.579066629881643e-25, -8.427415087472152e-27,  2.318292398038152e-29,  5.876786343167189e-01, -1.962787124215913e-03,  3.189522320635443e-06,
  8.905385877573533e-10, -1.903898599359269e-11,  3.840487214488450e-14,  4.477830006890846e-17, -4.137666696784611e-19,  6.945024951592704e-22,  1.764158852698054e-24,
 -1.095644341746397e-26,  1.336921420098059e-29,  6.427736891732438e-01, -2.082039442615621e-03,  3.024535037861982e-06,  2.406723975551907e-09, -2.142430465656227e-11,
  2.933201775836450e-14,  9.474146970503081e-17, -4.544829749449141e-19,  2.620524677522613e-22,  3.428725869956477e-24, -1.081819788099298e-26, -5.783708358639816e-30,
  6.996769613958018e-01, -2.192176305411271e-03,  2.784602557484147e-06,  4.002892834449282e-09, -2.283278016096146e-11,  1.598390069159749e-14,  1.432523007653147e-16,
 -4.288669880904696e-19, -3.486837898355973e-22,  4.696810198062787e-24, -7.045878386063376e-27, -3.021679755973838e-29,  7.582428550111796e-01, -2.291303947902424e-03,
  2.469057161670178e-06,  5.616627365088445e-09, -2.301319414158497e-11, -1.091768054982930e-15,  1.832520070868496e-16, -3.244369917030806e-19, -1.048345573172419e-21,
  5.070187917999268e-24,  3.777784561239213e-28, -5.176921755445305e-29,  8.183115226684116e-01, -2.377529939837944e-03,  2.079391374889267e-06,  7.175610470300761e-09,
 -2.176559138652044e-11, -2.081744373267660e-14,  2.072351724214260e-16, -1.407097641246535e-19, -1.697125826266261e-21,  4.150171893907399e-24,  1.011009078149632e-26,
 -6.004846207993509e-29,  8.797078155338114e-01, -2.448992342257198e-03,  1.619535530853303e-06,  8.599895308348897e-09, -1.896916494916032e-11, -4.158732920270655e-14,
  2.083503314787915e-16,  1.069586251758125e-19, -2.124576305002560e-21,  1.807049112993662e-24,  1.940912085277701e-26, -4.632929282467266e-29,  9.422402292410200e-01,
 -2.503894510567104e-03,  1.096101444447502e-06,  9.805187389612732e-09, -1.460989146546787e-11, -6.133950494052094e-14,  1.817369777305059e-16,  3.858004169782424e-19,
 -2.165897182771227e-21, -1.673508774732498e-24,  2.467072414152199e-26, -8.556158029152382e-30,  1.005699872021591e+00, -2.540546013055268e-03,  5.185693785406877e-07,
  1.070720367553267e-08, -8.804850206085971e-12, -7.771252352320957e-14,  1.259267214708884e-16,  6.476475777845313e-19, -1.710653025592815e-21, -5.533592828360235e-24,
  2.259034733338361e-26,  4.464525513216269e-29,  1.069859488886359e+00, -2.557409979884919e-03, -1.006094215272348e-07,  1.122709578257214e-08, -1.819339739861955e-12,
 -8.829194006636803e-14,  4.404549884309542e-17,  8.354736204748376e-19, -7.535858973220338e-22, -8.640777775062666e-24,  1.171763621009362e-26,  9.372731241044109e-29,
  1.134472584739339e+00, -2.553156952613054e-03, -7.460269286198287e-07,  1.129781084940514e-08,  5.927711594405439e-12, -9.093841511081052e-14, -5.551907682673928e-17,
  8.945475897026389e-19,  5.687801584627820e-22, -9.773535877136363e-24, -6.161810404011270e-27,  1.139289498206866e-28,  1.199272699508373e+00, -2.526724945482520e-03,
 -1.399485050704673e-06,  1.087111076119292e-08,  1.387472244798784e-11, -8.416983420140116e-14, -1.593436378747957e-16,  7.869102989683614e-19,  1.975007668972981e-21,
 -8.060420815160748e-24, -2.561170035452835e-26,  8.667986408817144e-29,  1.263972899540715e+00, -2.477384934949124e-03, -2.040351966444140e-06,  9.924780649422727e-09,
  2.134894246406186e-11, -6.754691558132381e-14, -2.503806055984966e-16,  5.061907986944994e-19,  3.084968123841364e-21, -3.448175965342112e-24, -3.879814226540846e-26,
  1.256795887680670e-29,  1.328265561191903e+00, -2.404810345563414e-03, -2.646142974314480e-06,  8.469342417586045e-09,  2.762094559630955e-11, -4.198884324028972e-14,
 -3.106591425684125e-16,  8.822923889140595e-20,  3.518945862810480e-21,  3.006748872386922e-24, -3.852704912764436e-26, -8.174773925040920e-29,  1.391822534001415e+00,
 -2.309148291439884e-03, -3.193353385714247e-06,  6.553373055444862e-09,  3.198169959436944e-11, -9.929060010836376e-15, -3.250565341283051e-16, -3.877027002727097e-19,
  3.032001021871311e-21,  9.244984164818901e-24, -2.215666974921528e-26, -1.503608137678480e-28,  1.454295781012787e+00, -2.191089374727042e-03, -3.658556753362795e-06,
  4.266351653337179e-09,  3.383745072815769e-11,  2.477965213236660e-14, -2.854977779668181e-16, -8.112320564350119e-19,  1.641267643137048e-21,  1.282896401012283e-23,
  5.568028215609936e-27, -1.504748851703900e-28,  1.515318601164129e+00, -2.051931775889440e-03, -4.019759121000099e-06,  1.737881612536832e-09,  3.281221953425701e-11,
  5.727767218906937e-14, -1.945177250442594e-16, -1.067505852472040e-18, -3.131371008111050e-22,  1.197141379165463e-23,  3.300720363517499e-26, -7.109362618191769e-29,
  1.574507541326619e+00, -1.893634274673567e-03, -4.257968244415953e-06, -8.677726875943096e-10,  2.884194640774419e-11,  8.243948483722742e-14, -6.686746999634467e-17,
 -1.073277634603714e-18, -2.227485366894305e-21,  6.559383231351191e-24,  4.650427336001561e-26,  5.094276222525748e-29,  1.631465101208391e+00, -1.718851843471963e-03,
 -4.358896505661383e-06, -3.362558969551604e-09,  2.223968586914003e-11,  9.586663658958106e-14,  7.202558817777476e-17, -8.114289086039545e-19, -3.429405519513329e-21,
 -1.419422131406246e-24,  3.804514879837097e-26,  1.452075940746803e-28,  1.685783320453084e+00, -1.530946737564160e-03, -4.314670335650137e-06, -5.551009748349135e-09,
  1.370970797624824e-11,  9.495156748245248e-14,  1.912612421943087e-16, -3.489879872302295e-19, -3.456385652646572e-21, -8.513983088474449e-24,  1.129566608063508e-26,
  1.516370370464774e-28,  1.737048311402079e+00, -1.333967797881346e-03, -4.125373042567434e-06, -7.251268588444707e-09,  4.292077632364995e-12,  7.973929643817211e-14,
  2.626368838861776e-16,  1.744026535893872e-19, -2.297344573789032e-21, -1.145222444762178e-23, -1.892171257739555e-26,  6.676889557908373e-29,  1.784845761235240e+00,
 -1.132591236029889e-03, -3.800210804471342e-06, -8.318767498349418e-09, -4.770186150786380e-12,  5.327822795235238e-14,  2.696299741500716e-16,  5.908612188983338e-19,
 -4.537733416086497e-22, -9.006421629838354e-24, -3.517811680771775e-26, -4.740685369762627e-29,  1.828767372759746e+00, -9.320177274446068e-04, -3.358074588381901e-06,
 -8.669368367488677e-09, -1.223198680706372e-11,  2.121524421575107e-14,  2.139456127540725e-16,  7.689760272780025e-19,  1.260717506086888e-21, -2.875457863855902e-24,
 -2.923740842338341e-26, -1.087397824220794e-28,  1.868418145003689e+00, -7.378233583355510e-04, -2.827286094816908e-06, -8.297871278890656e-09, -1.708435196538315e-11,
 -9.425494479825723e-15,  1.164063865061443e-16,  6.714930261633400e-19,  2.120857726479621e-21,  3.241819142197275e-24, -8.139510135157793e-27, -8.221603870004905e-29,
  1.903424316528421e+00, -5.557658632932486e-04, -2.244373416115911e-06, -7.287524347967387e-09, -1.877959254034226e-11, -3.206302201288803e-14,  1.059499288456431e-17,
  3.747990098536399e-19,  1.878997164544394e-21,  6.010709718846634e-24,  1.142014643951833e-26, -7.531179247257795e-30,  1.933441712692974e+00, -3.915524319282763e-04,
 -1.651825498201537e-06, -5.806873691758622e-09, -1.738285274525155e-11, -4.247850069763416e-14, -6.933697065928307e-17,  3.331021987153024e-20,  8.908122083712182e-22,
  4.654125727199163e-24,  1.670852768526488e-26,  4.354751476053160e-29,  1.958164163984976e+00, -2.505806520288626e-04, -1.094916845732968e-06, -4.092118745703533e-09,
 -1.359605662523909e-11, -4.017147132393042e-14, -1.021080944304367e-16, -1.988412443842393e-19, -1.356866928102601e-22,  1.238702818231212e-24,  8.687319874362433e-27,
  3.807545585966226e-29,  1.977331618424760e+00, -1.376690732504543e-04, -6.178554012886574e-07, -2.415919503342490e-09, -8.626761839206737e-12, -2.857341188927423e-14,
 -8.786302525029102e-17, -2.478743080879204e-19, -6.207793385362784e-22, -1.257708808962323e-24, -1.302943117012620e-27,  5.021038670488921e-30,  1.990737663235163e+00,
 -5.679691881032869e-05, -2.596535257723078e-07, -1.046780870470426e-09, -3.916619383680064e-12, -1.389400506207137e-14, -4.719338143907926e-17, -1.541125798461660e-19,
 -4.839669865550334e-22, -1.456932534234333e-24, -4.172890573783787e-27, -1.120228285848279e-29,  1.998237979635087e+00, -1.086303972036731e-05, -5.017302935656505e-08,
 -2.056831168527689e-10, -7.890495927587774e-13, -2.899533910060704e-15, -1.033238027200890e-17, -3.596075039878865e-20, -1.227853795558336e-22, -4.124797375535324e-25,
 -1.365880331009872e-27, -4.463696823096922e-30,  3.604862699788903e-04, -1.540359252110674e-06,  4.935689474782739e-09, -1.405544722627491e-11,  3.751450524314985e-14,
 -9.609620465591030e-17,  2.392309859203895e-19, -5.831972007156063e-22,  1.398815993490854e-24, -3.312203272185209e-27,  7.759526971709301e-30, -1.801882100582230e-32,
  3.243802464467878e-03, -1.384710738088072e-05,  4.427521640367438e-08, -1.256201628022521e-10,  3.333954298621930e-13, -8.471665228718732e-16,  2.086131381779423e-18,
 -5.013633780057442e-21,  1.180956775627478e-23, -2.734022554411690e-26,  6.230456669908149e-29, -1.399203735746526e-31,  9.007366895770091e-03, -3.837454671657586e-05,
  1.221766686535772e-07, -3.440824361912631e-10,  9.027663282939479e-13, -2.256304129157325e-15,  5.430998514545042e-18, -1.266164533885830e-20,  2.866100829139759e-23,
 -6.302190188188497e-26,  1.343786063799426e-28, -2.768539854502703e-31,  1.764501089552869e-02, -7.495031434976396e-05,  2.370897080354299e-07, -6.602046516070866e-10,
  1.701785377717608e-12, -4.144138923259504e-15,  9.614377925035017e-18, -2.129490804299826e-20,  4.488942524139364e-23, -8.926281897599393e-26,  1.641831263496442e-28,
 -2.674323569761617e-31,  2.914739926356955e-02, -1.233152498283127e-04,  3.867011624555418e-07, -1.060372960069953e-09,  2.667029007135913e-12, -6.257966344830294e-15,
  1.374056110335933e-17, -2.802820175730994e-20,  5.195790932886003e-23, -8.280145427696358e-26,  9.372168043825893e-29,  1.786199053036873e-32,  4.350193074816248e-02,
 -1.831226745767306e-04,  5.679503129184305e-07, -1.526890612752277e-09,  3.718266925866789e-12, -8.290692342223051e-15,  1.678262264175973e-17, -2.982369278991321e-20,
  4.196822021518960e-23, -2.625471488944378e-26, -1.052725497774868e-28,  5.881405522726683e-31,  6.069260388165613e-02, -2.539374632713592e-04,  7.770500882392661e-07,
 -2.038372605272760e-09,  4.762105659523003e-12, -9.904950766163788e-15,  1.771069834924036e-17, -2.406835789924474e-20,  9.915353665798447e-24,  8.419578681056800e-26,
 -4.087725280489868e-28,  1.278223528881600e-30,  8.069984691020220e-02, -3.352349366352690e-04,  1.009514870999889e-06, -2.570244234444028e-09,  5.696445708843739e-12,
 -1.076138338804526e-14,  1.563367097360619e-17, -9.158125113571830e-21, -4.432407480906755e-23,  2.334845731661786e-25, -7.317396576113905e-28,  1.760145323069049e-30,
  1.035003102425837e-01, -4.263996149218654e-04,  1.260195801966031e-06, -3.095346253601054e-09,  6.415675656776224e-12, -1.054978740059930e-14,  9.942360747494743e-18,
  1.499093649237624e-20, -1.146917605918042e-22,  3.865211811794891e-25, -9.393611512829663e-28,  1.633705688781351e-30,  1.290666195333880e-01, -5.267238828714525e-04,
  1.523324656457597e-06, -3.584648970091570e-09,  6.816499423889166e-12, -9.021536574197570e-15,  4.406136042017226e-19,  4.658721058875972e-20, -1.887149387759321e-22,
  4.924582462398744e-25, -8.799435421631645e-28,  5.842487710661896e-31,  1.573670872137980e-01, -6.354066305724641e-04,  1.792567552636094e-06, -4.008076723544837e-09,
  6.804259474311546e-12, -6.021377051294530e-15, -1.255048276067141e-17,  8.184225622739269e-20, -2.486137168969360e-22,  4.946531449062996e-25, -4.352594609680104e-28,
 -1.432592341624864e-30,  1.883653799949936e-01, -7.515519508985606e-04,  2.061089933968208e-06, -4.335442554598368e-09,  6.299578355995828e-12, -1.516400190618783e-15,
 -2.813041775686348e-17,  1.151483029656712e-19, -2.738501254772850e-22,  3.453686474419764e-25,  4.222662278207483e-28, -4.043098110292181e-30,  2.220201396030783e-01,
 -8.741679935213112e-04,  2.321634439209686e-06, -4.537490330397779e-09,  5.245093104791766e-12,  4.380275823075513e-15, -4.481361787899948e-17,  1.395948937419542e-19,
 -2.449893550721698e-22,  2.287335439043281e-26,  1.581646422649686e-27, -6.418366955994980e-30,  2.582845537724593e-01, -1.002166098444123e-03,  2.566613422594945e-06,
 -4.587037915559164e-09,  3.612001876124967e-12,  1.139379531861254e-14, -6.059282397423853e-17,  1.478293853280435e-19, -1.484674810309464e-22, -4.527028536634347e-25,
  2.773682897653740e-27, -7.409352521835783e-30,  2.971058743429543e-01, -1.134360359112677e-03,  2.788217999442236e-06, -4.460209919284434e-09,  1.406080642828684e-12,
  1.908261381211202e-14, -7.308021118592670e-17,  1.332190894822816e-19,  1.843346244713969e-23, -1.009329479370271e-24,  3.597025347748439e-27, -5.875959064165837e-30,
  3.384248791962685e-01, -1.269467796969595e-03,  2.978545547235388e-06, -4.137741847324478e-09, -1.327237926057886e-12,  2.684704314185718e-14, -7.972917376719564e-17,
  9.121633437305081e-20,  2.433699027944880e-22, -1.523616840609435e-24,  3.600024458966593e-27, -1.166966951471337e-30,  3.821752747584599e-01, -1.406109366327527e-03,
  3.129747561338746e-06, -3.606328877712514e-09, -4.499197356380403e-12,  3.395374762788467e-14, -7.813159036985497e-17,  2.076557710641179e-20,  4.966303189447132e-22,
 -1.835804883139797e-24,  2.414802734515495e-27,  6.372097222909463e-30,  4.282830359236366e-01, -1.542812051015327e-03,  3.234199610936873e-06, -2.859981727552996e-09,
 -7.975996247994494e-12,  3.957804779504671e-14, -6.637490273345568e-17, -7.446917508115569e-20,  7.319125903654341e-22, -1.780795925347579e-24, -7.885780082020963e-29,
  1.505770988528295e-29,  4.766656805678787e-01, -1.678012362581523e-03,  3.284694817195607e-06, -1.901339027608126e-09, -1.157959274001193e-11,  4.286488255352236e-14,
 -4.343072332395071e-17, -1.853274342431076e-19,  8.911471293822993e-22, -1.233105682997529e-24, -3.602794864339290e-27,  2.191946235265330e-29,  5.272314763812280e-01,
 -1.810061603754166e-03,  3.274661722702448e-06, -7.428702628797358e-10, -1.509163193885127e-11,  4.300777724850066e-14, -9.532665017903850e-18, -2.971194169077800e-19,
  9.138065118352896e-22, -1.587064681422860e-25, -7.402226745136274e-27,  2.332370109547384e-29,  5.798785786243650e-01, -1.937233319667411e-03,  3.198406566739748e-06,
  5.921140891512750e-10, -1.826106696451973e-11,  3.934309275496421e-14,  3.351292195327796e-17, -3.906098131813969e-19,  7.502735358173854e-22,  1.338555024942117e-24,
 -1.030313260260809e-26,  1.620034154851662e-29,  6.344940987072426e-01, -2.057733421606855e-03,  3.051378739863420e-06,  2.068747458566145e-09, -2.081595174573999e-11,
  3.145416539017374e-14,  8.215130434981571e-17, -4.442062646830132e-19,  3.776512419111669e-22,  2.992554955094348e-24, -1.095075770975098e-26, -3.490210533229852e-31,
  6.909531053006800e-01, -2.169713531122741e-03,  2.830456467868293e-06,  3.640308473468305e-09, -2.247970012577820e-11,  1.927674998913371e-14,  1.311128316071966e-16,
 -4.373763840821902e-19, -1.849742258789239e-22,  4.390343237266660e-24, -8.229173276718802e-27, -2.358864863255238e-29,  7.491175621605186e-01, -2.271288152206925e-03,
  2.534247468304489e-06,  5.248477381870259e-09, -2.299180371984664e-11,  3.193647118568623e-15,  1.737255477713912e-16, -3.550650740921385e-19, -8.660825096242991e-22,
  5.041209216049148e-24, -1.789052164123723e-27, -4.660222010312698e-29,  8.088352101199514e-01, -2.360556329671024e-03,  2.163396335686261e-06,  6.824299003613226e-09,
 -2.213255406985322e-11, -1.589707416846411e-14,  2.025579739179712e-16, -1.925544080025034e-19, -1.541076741636525e-21,  4.501797473645561e-24,  7.475602149229968e-27,
 -5.944521220864644e-29,  8.699384049600483e-01, -2.435628484091537e-03,  1.720886669604164e-06,  8.290007266173424e-09, -1.975070430131821e-11, -3.655860025123386e-14,
  2.104041871536306e-16,  4.015877766177607e-20, -2.046056918949535e-21,  2.540728949718135e-24,  1.723075673402855e-26, -5.238544938126042e-29,  9.322429282849428e-01,
 -2.494659115586013e-03,  1.212321436820725e-06,  9.561855321662853e-09, -1.579223038206129e-11, -5.685606929970502e-14,  1.915613629611300e-16,  3.157172665070512e-19,
 -2.208504863914299e-21, -6.978791447303044e-25,  2.402195584405734e-26, -2.074327997225826e-29,  9.955467952914885e-01, -2.535886024195807e-03,  6.461598152499288e-07,
  1.055406232893770e-08, -1.032744212547332e-11, -7.447903608687314e-14,  1.432657976952214e-16,  5.898973226460953e-19, -1.893161778298862e-21, -4.594859131367673e-24,
  2.424225422560682e-26,  3.036281511190070e-29,  1.059629091600309e+00, -2.557676583311302e-03,  3.388300622270347e-08,  1.118392497269015e-08, -3.572728057592833e-12,
 -8.695713792004334e-14,  6.705508074330075e-17,  8.064801546222840e-19, -1.055247229407242e-21, -8.092253707272427e-24,  1.563831281280373e-26,  8.408782617895181e-29,
  1.124248881225113e+00, -2.558581399438021e-03, -6.099443686315268e-07,  1.137804024053904e-08,  4.097656792045674e-12, -9.196857481935875e-14, -3.027010729418185e-17,
  9.070812818943918e-19,  2.137114440668148e-22, -9.919033785442410e-24, -1.101616702605645e-27,  1.155029518701723e-28,  1.189144239327612e+00, -2.537395367897520e-03,
 -1.267755952602668e-06,  1.107943897915522e-08,  1.215490374945994e-11, -8.772281302314454e-14, -1.364703341382372e-16,  8.452777610052246e-19,  1.667353831996786e-21,
 -9.003970516813057e-24, -2.145570142987264e-26,  1.017847290368302e-28,  1.254031476512773e+00, -2.493225659064956e-03, -1.919250725099731e-06,  1.025523474410330e-08,
  1.993911797408547e-11, -7.337494013686623e-14, -2.348459861879927e-16,  6.026256046552155e-19,  2.933095607483844e-21, -4.982096431548955e-24, -3.772569582973664e-26,
  3.619491465841265e-29,  1.318604635711073e+00, -2.425565514474525e-03, -2.541888276538263e-06,  8.904155302732674e-09,  2.670687678841158e-11, -4.940220391466903e-14,
 -3.065981232203708e-16,  2.022632697836085e-19,  3.598634561717919e-21,  1.399498064361961e-24, -4.168634450680035e-26, -6.127881718557423e-29,  1.382535357495420e+00,
 -2.334371875460207e-03, -3.111650601707875e-06,  7.063064235828478e-09,  3.170428345995613e-11, -1.784942013131000e-14, -3.345051336353477e-16, -2.855374954930091e-19,
  3.347281464034025e-21,  8.227377960351249e-24, -2.869011819307643e-26, -1.457537621767406e-28,  1.445473223888697e+00, -2.220143804879541e-03, -3.604097010457833e-06,
  4.811335709549189e-09,  3.426271691723101e-11,  1.766149426704477e-14, -3.074073273651306e-16, -7.512922842894745e-19,  2.105476747095591e-21,  1.291415903903526e-23,
 -1.428514876789150e-27, -1.669669077548041e-28,  1.507046702706177e+00, -2.083997420252738e-03, -3.995717614759288e-06,  2.271777723682576e-09,  3.390866349134812e-11,
  5.224983968415156e-14, -2.244816063030995e-16, -1.070382525177279e-18,  1.407663871909835e-22,  1.322047883239392e-23,  2.922989811170824e-26, -1.007543490995755e-28,
  1.566864822025030e+00, -1.927731704018266e-03, -4.265558590460728e-06, -3.932087822705650e-10,  3.047221306373839e-11,  8.046622081301891e-14, -9.787907481975558e-17,
 -1.140415969282663e-18, -1.957386331190893e-21,  8.457499238324786e-24,  4.822209009635957e-26,  2.630859422110865e-29,  1.624519704668807e+00, -1.753878222865007e-03,
 -4.397048648881399e-06, -2.991299360829791e-09,  2.417240017147811e-11,  9.731017345635022e-14,  4.776368942738992e-17, -9.216812913457779e-19, -3.451576615091126e-21,
  2.296322475187628e-25,  4.438479565038010e-26,  1.420663417197876e-28,  1.679590082357547e+00, -1.565726673747384e-03, -4.379902854369603e-06, -5.316216316090156e-09,
  1.565378473694883e-11,  9.941179927922825e-14,  1.798957391702001e-16, -4.643957704142069e-19, -3.753093709735196e-21, -7.922749646138684e-24,  1.841112591586823e-26,
  1.715441284340858e-28,  1.731645884956228e+00, -1.367317552232606e-03, -4.211922484696186e-06, -7.169493074471697e-09,  5.950247390616626e-12,  8.609248772642377e-14,
  2.664279624534513e-16,  9.415127434574060e-20, -2.722470375540491e-21, -1.214261317586104e-23, -1.540067684828628e-26,  9.381872681593293e-29,  1.780253958969848e+00,
 -1.163393437501209e-03, -3.900457634484701e-06, -8.386208771258041e-09, -3.638580111800799e-12,  5.994592646089543e-14,  2.859200962695707e-16,  5.708773304934721e-19,
 -8.038027695736017e-22, -1.045160933946057e-23, -3.698261425411573e-26, -3.385077917832197e-29,  1.824984909132318e+00, -9.593017468373210e-04, -3.463266353560586e-06,
 -8.861399330885153e-09, -1.175456781380081e-11,  2.661276966820051e-14,  2.360245168610217e-16,  8.074275124662348e-19,  1.134975862056934e-21, -4.142945064896853e-24,
 -3.419085303335470e-26, -1.161279597092952e-28,  1.865420977776615e+00, -7.608446051674617e-04, -2.928506359276067e-06, -8.572570663579892e-09, -1.724336129260524e-11,
 -6.398345116581435e-15,  1.361753898221755e-16,  7.411575583659120e-19,  2.230786674484159e-21,  2.838999544395699e-24, -1.212581480124570e-26, -9.928724894758432e-29,
  1.901164781973257e+00, -5.740758084678619e-04, -2.333647655967483e-06, -7.593110403346228e-09, -1.941742416358728e-11, -3.167581218926736e-14,  2.196430988213682e-17,
  4.384764437107505e-19,  2.103500881137189e-21,  6.458165127260295e-24,  1.088078549151193e-26, -1.740162363764779e-29,  1.931848625674009e+00, -4.050505591399668e-04,
 -1.723205064045616e-06, -6.091885934109361e-09, -1.824897076303043e-11, -4.412801506240099e-14, -6.797907091923621e-17,  6.462977354162268e-20,  1.070860046666673e-21,
  5.361593614408885e-24,  1.868384984297914e-26,  4.614952412818996e-29,  1.957144006403813e+00, -2.595401685570503e-04, -1.145354441785405e-06, -4.316218137318319e-09,
 -1.442444531818585e-11, -4.268932320624033e-14, -1.077292353631117e-16, -2.023992685999454e-19, -8.441733404905207e-23,  1.621630104666729e-24,  1.050845528965999e-26,
  4.486109298768246e-29,  1.976770869464565e+00, -1.427302712639874e-04, -6.476938405966986e-07, -2.558636412745066e-09, -9.219891161913634e-12, -3.076769718552239e-14,
 -9.508849076102153e-17, -2.684732747906421e-19, -6.669357515087349e-22, -1.304743024227959e-24, -1.031252135682611e-27,  7.428019041264576e-30,  1.990506240015825e+00,
 -5.892547934488616e-05, -2.726002651529176e-07, -1.111732860857505e-09, -4.206184678100533e-12, -1.508022770752098e-14, -5.173347117900441e-17, -1.704719189209917e-19,
 -5.395434204344644e-22, -1.634102725868044e-24, -4.695689444441776e-27, -1.258509368256114e-29,  1.998193708766901e+00, -1.127451586287818e-05, -5.271893381108933e-08,
 -2.187856597001577e-10, -8.496039554486386e-13, -3.160051948117626e-15, -1.139659893808460e-17, -4.013841217746499e-20, -1.386673353681508e-22, -4.712554134705276e-25,
 -1.578380833781523e-27, -5.216091811037661e-30,  3.544027500035680e-04, -1.501538337900513e-06,  4.770563072633297e-09, -1.347028404035006e-11,  3.564869957661526e-14,
 -9.054566520782762e-17,  2.235106264931999e-19, -5.402845308384048e-22,  1.284977676686918e-24, -3.017109428581710e-27,  7.008848484837216e-30, -1.613966082951529e-32,
  3.189113017622542e-03, -1.349884600416220e-05,  4.279922996463774e-08, -1.204187092257855e-10,  3.169416169146167e-13, -7.987421398043744e-16,  1.950895717753467e-18,
 -4.651006375826223e-21,  1.086873413870166e-23, -2.496692021389873e-26,  5.646304460084047e-29, -1.258654261945227e-31,  8.855797727534968e-03, -3.741340715600495e-05,
  1.181328784416868e-07, -3.299922202779431e-10,  8.589154955968683e-13, -2.130112899288644e-15,  5.088978762671938e-18, -1.177977965850729e-20,  2.648610564508487e-23,
 -5.788284780278913e-26,  1.227562954492605e-28, -2.518345017599429e-31,  1.734895354318680e-02, -7.308482984176782e-05,  2.293279285448736e-07, -6.336268104872958e-10,
  1.621162579559797e-12, -3.920389546486619e-15,  9.037756776696722e-18, -1.990861705619996e-20,  4.179138313797702e-23, -8.292607520145141e-26,  1.527711509484340e-28,
 -2.513583527876450e-31,  2.866024590625383e-02, -1.202718223958717e-04,  3.742286487807209e-07, -1.018684116362598e-09,  2.545104806338322e-12, -5.937425202750052e-15,
  1.297860564115796e-17, -2.641251768364109e-20,  4.904465710894673e-23, -7.904435629419366e-26,  9.395767221744463e-29, -6.255263968272789e-33,  4.277841262255304e-02,
 -1.786513639152600e-04,  5.499791774539122e-07, -1.468703249375970e-09,  3.556414048815322e-12, -7.897779303683627e-15,  1.596621340675126e-17, -2.849659616876857e-20,
  4.095324495584471e-23, -2.997488337652709e-26, -8.137719900570820e-29,  5.000611809124483e-31,  5.968913372265120e-02, -2.478176240643737e-04,  7.530403160373541e-07,
 -1.963740840543264e-09,  4.568202821548433e-12, -9.487942429578410e-15,  1.704166019935780e-17, -2.370561817663459e-20,  1.266523778207701e-23,  6.892576577389019e-26,
 -3.557880405370979e-28,  1.132730720090206e-30,  7.937486622907095e-02, -3.272806561825889e-04,  9.792117622532501e-07, -2.480802628109053e-09,  5.484948555394573e-12,
 -1.038940512220571e-14,  1.535861049254775e-17, -1.044750864400463e-20, -3.642722903305395e-23,  2.057189109882818e-25, -6.576415001568064e-28,  1.609391990402855e-30,
  1.018146421119970e-01, -4.164648960132977e-04,  1.223660631295053e-06, -2.994370308823847e-09,  6.207097985054679e-12, -1.030653591197237e-14,  1.031276602004877e-17,
  1.153632405791198e-20, -1.014361721170461e-22,  3.503668971596283e-25, -8.688065537087672e-28,  1.571500305115981e-30,  1.269838273625478e-01, -5.147075083893628e-04,
  1.480957301590930e-06, -3.477027419160456e-09,  6.636276641392129e-12, -8.995974798605131e-15,  1.663128263930245e-18,  4.082524817376238e-20, -1.716134202729548e-22,
  4.578164173266120e-25, -8.511866633433592e-28,  7.163374858276684e-31,  1.548538397591588e-01, -6.212566363305460e-04,  1.745119815831400e-06, -3.900187594939595e-09,
  6.681000858943373e-12, -6.295972295569138e-15, -1.036762610355728e-17,  7.416806127830147e-20, -2.311336800642282e-22,  4.761021442430889e-25, -4.894369028814048e-28,
 -1.040666128885904e-30,  1.853918225524142e-01, -7.352696217220014e-04,  2.009668266140867e-06, -4.234927528453234e-09,  6.262755139709957e-12, -2.153819032556121e-15,
 -2.502705971323143e-17,  1.065869544970801e-19, -2.611539858184781e-22,  3.588881819785805e-25,  2.582121302183993e-28, -3.424980845728518e-30,  2.185602709531788e-01,
 -8.558112845932769e-04,  2.267690789465099e-06, -4.452925120527848e-09,  5.322255380595420e-12,  3.350768180719593e-15, -4.101450838123257e-17,  1.317800793566783e-19,
 -2.430933654340753e-22,  8.069093399297210e-26,  1.314124924730030e-27, -5.746764438522384e-30,  2.543166079877665e-01, -9.818523696066260e-04,  2.511922987570846e-06,
 -4.527500493841060e-09,  3.825667946064934e-12,  9.988687049482455e-15, -5.652241563926146e-17,  1.428384513895536e-19, -1.628452095387990e-22, -3.481551784756204e-25,
  2.456775949102256e-27, -6.987465232128265e-30,  2.926127059959451e-01, -1.112268294346592e-03,  2.734842753454102e-06, -4.434753438360011e-09,  1.770496014868042e-12,
  1.737348441898834e-14, -6.934708594968239e-17,  1.332548457072087e-19, -1.537546285325050e-23, -8.706844807077304e-25,  3.333890742136430e-27, -6.059551240238536e-30,
  3.333943498120620e-01, -1.245838365072686e-03,  2.928782614908472e-06, -4.154785210508450e-09, -8.092208496397737e-13,  2.496502199455046e-14, -7.707413503718385e-17,
  9.815423983003248e-20,  1.910963343610858e-22, -1.380969455094359e-24,  3.524689964142162e-27, -2.218361422886973e-30,  3.766006375126555e-01, -1.381245662455753e-03,
  3.086061771921817e-06, -3.672985090166311e-09, -3.838817864820857e-12,  3.208730212137036e-14, -7.733746328940914e-17,  3.561947938198555e-20,  4.323422659901018e-22,
 -1.734184537429900e-24,  2.652313885383712e-27,  4.463520251764336e-30,  4.221633145705585e-01, -1.517077843128758e-03,  3.199139973886261e-06, -2.981352394836690e-09,
 -7.200520738204359e-12,  3.796261585569644e-14, -6.814177750309105e-17, -5.207306534734553e-20,  6.679004739715059e-22, -1.771396119006988e-24,  5.318093934757510e-28,
  1.271889337942288e-29,  4.700060373717253e-01, -1.651829153188358e-03,  3.260795210650037e-06, -2.079812470780373e-09, -1.073312230893560e-11,  4.176345559754147e-14,
 -4.822751866902890e-17, -1.575469548503150e-19,  8.443887472712488e-22, -1.358479613996995e-24, -2.679816251247064e-27,  2.001021542847126e-29,  5.200435623865169e-01,
 -1.783904007391793e-03,  3.264326820163020e-06, -9.774703293523060e-10, -1.423442105279015e-11,  4.268245821568798e-14, -1.744387810389536e-17, -2.680241652053220e-19,
  9.030101674826834e-22, -4.343470431815136e-25, -6.382553760103751e-27,  2.294733696641826e-29,  5.721808579183632e-01, -1.911622552600267e-03,  3.203784971338915e-06,
  3.062719441569380e-10, -1.746703371139430e-11,  4.001891269095401e-14,  2.291865518157779e-17, -3.659081573344494e-19,  7.912212145133289e-22,  9.413528136359290e-25,
 -9.541776311492567e-27,  1.828842413147980e-29,  6.263121363760198e-01, -2.033228705263385e-03,  3.074226473262062e-06,  1.740827819367603e-09, -2.016815211574271e-11,
  3.327800549926349e-14,  6.989830993165337e-17, -4.304821953614301e-19,  4.775082747987658e-22,  2.555668500615251e-24, -1.085891044615531e-26,  4.408502077485101e-30,
  6.823198065509186e-01, -2.146901228660770e-03,  2.871995383411465e-06,  3.283884348577274e-09, -2.206369286155167e-11,  2.227597433676791e-14,  1.188067208097076e-16,
 -4.408321661948510e-19, -3.307957106992530e-23,  4.042329642222352e-24, -9.124696830946876e-27, -1.716412906766263e-29,  7.400733475748456e-01, -2.250768493007628e-03,
  2.595024815986726e-06,  4.881342609584541e-09, -2.288705740946419e-11,  7.240793745332433e-15,  1.634228825422601e-16, -3.798937012582767e-19, -6.863661767311539e-22,
  4.930301774247473e-24, -3.714206131053967e-27, -4.082376893273281e-29,  7.994281092607542e-01, -2.342927635145050e-03,  2.243153556828999e-06,  6.467896810789380e-09,
 -2.240234650995814e-11, -1.110580192407236e-14,  1.965007938038014e-16, -2.392232044113990e-19, -1.374255515505193e-21,  4.749017132939960e-24,  4.900411381291255e-27,
 -5.738482439067206e-29,  8.602240475956613e-01, -2.421468896362664e-03,  1.818447449983075e-06,  7.968421238703615e-09, -2.043132608243478e-11, -3.150271579465887e-14,
  2.106266717011094e-16, -2.372315577661732e-20, -1.942752781120799e-21,  3.182485362078526e-24,  1.482635469017934e-26, -5.660222536350707e-29,  9.222844094904982e-01,
 -2.484505955306651e-03,  1.325510938579511e-06,  9.300335322198528e-09, -1.688270234123936e-11, -5.216051817259056e-14,  1.994095701657324e-16,  2.448265968136117e-19,
 -2.216582961867530e-21,  2.414377004476643e-25,  2.286460487789071e-26, -3.162447453201873e-29,  9.854143877470548e-01, -2.530213071713289e-03,  7.717685927878344e-07,
  1.037709891852617e-08, -1.178133717207239e-11, -7.084944320711986e-14,  1.589112670482432e-16,  5.268590147209144e-19, -2.040839192011115e-21, -3.602719903264637e-24,
  2.525900746625955e-26,  1.585815200247710e-29,  1.049399775828033e+00, -2.556869794213795e-03,  1.676900363365566e-07,  1.111294322716413e-08, -5.293969346068580e-12,
 -8.508091911308091e-14,  8.912088072107100e-17,  7.681788728648841e-19, -1.334447249612056e-21, -7.396062849604207e-24,  1.908499362506776e-26,  7.225521529067916e-29,
  1.114005662637446e+00, -2.562913833898648e-03, -4.730753141940928e-07,  1.142885695011123e-08,  2.253080323648611e-12, -9.238983530799251e-14, -4.829773604216442e-18,
  9.082081069604594e-19, -1.429445398530768e-22, -9.861768261833469e-24,  3.950927299182233e-27,  1.135872210034285e-28,  1.178975220288422e+00, -2.547002430767996e-03,
 -1.133694265360143e-06,  1.125971198337073e-08,  1.036964156645393e-11, -9.070836377210267e-14, -1.121054408399399e-16,  8.932901506899403e-19,  1.328877159473632e-21,
 -9.768823726261523e-24, -1.669855087346000e-26,  1.139155186986810e-28,  1.244028652769859e+00, -2.508082103648223e-03, -1.794323156164909e-06,  1.056222032768806e-08,
  1.841667696232122e-11, -7.879833158076006e-14, -2.166874618743258e-16,  6.933272635202378e-19,  2.727024414356819e-21, -6.452366468202400e-24, -3.561819411890767e-26,
  5.946824408756991e-29,  1.308862390309733e+00, -2.445466034640150e-03, -2.432508447432921e-06,  9.323163334909569e-09,  2.564577530016898e-11, -5.667955082683025e-14,
 -2.993173123006539e-16,  3.178989943106123e-19,  3.618413646022326e-21, -3.151262793344558e-25, -4.387247748863973e-26, -3.762083560062786e-29,  1.373148632511924e+00,
 -2.358917459603095e-03, -3.023863420128451e-06,  7.567038172140967e-09,  3.126642991172496e-11, -2.596111471847997e-14, -3.409577259050444e-16, -1.739194068563581e-19,
  3.621286958219008e-21,  6.954040024783684e-24, -3.490450923617901e-26, -1.358303492119574e-28,  1.436535361967479e+00, -2.248736293183961e-03, -3.543061422222410e-06,
  5.361957150318788e-09,  3.454050628056838e-11,  1.003932642860128e-14, -3.274305293801662e-16, -6.765041157171318e-19,  2.567550521513031e-21,  1.270609675227470e-23,
 -9.065348170966570e-27, -1.794110937739585e-28,  1.498646967321615e+00, -2.115844815216191e-03, -3.965167541504339e-06,  2.822373414704414e-09,  3.489736159740515e-11,
  4.650358922487982e-14, -2.543161484485489e-16, -1.058046551224202e-18,  6.366001636258768e-22,  1.429216048094035e-23,  2.413535788419559e-26, -1.307795781785910e-28,
  1.559085628249115e+00, -1.961866636896529e-03, -4.267299099092246e-06,  1.070826073999659e-10,  3.205542470144186e-11,  7.772716002964651e-14, -1.306391942067247e-16,
 -1.197806766681223e-18, -1.617992896339450e-21,  1.040118340782229e-23,  4.874687320415491e-26, -3.237553955259200e-30,  1.617433621137881e+00, -1.789191471260887e-03,
 -4.430559288841447e-06, -2.588918045213292e-09,  2.612791212783372e-11,  9.813435637727295e-14,  2.041406288015324e-17, -1.031644720070810e-18, -3.409865494033646e-21,
  2.127851050991287e-24,  5.046081253291591e-26,  1.330835985128513e-28,  1.673256699396614e+00, -1.601016664529006e-03, -4.442128327835698e-06, -5.049619956901682e-09,
  1.768407121387042e-11,  1.035594307645333e-13,  1.651694941747792e-16, -5.889010464926346e-19, -4.023187823736136e-21, -7.029911021861922e-24,  2.636062802804362e-26,
  1.893480745908168e-28,  1.726108681566340e+00, -1.401355316188988e-03, -4.297327229395402e-06, -7.060166182128304e-09,  7.736200784885933e-12,  9.250814124740208e-14,
  2.677780172195516e-16, -7.222738744189708e-23, -3.169619600142896e-21, -1.266741862134709e-23, -1.062004155091068e-26,  1.239547369295877e-28,  1.775537339271826e+00,
 -1.195000532725020e-03, -4.001400656678720e-06, -8.434456487100720e-09, -2.369762543857781e-12,  6.699655906703828e-14,  3.014859428225167e-16,  5.388473920319091e-19,
 -1.207001642165394e-21, -1.195563209041003e-23, -3.808364349256201e-26, -1.532168806341131e-29,  1.821091611959107e+00, -9.874363795866683e-04, -3.570713001469285e-06,
 -9.044898838101678e-09, -1.116381470033628e-11,  3.255261029243291e-14,  2.591165944981116e-16,  8.410863493533453e-19,  9.599650023713723e-22, -5.614494404610383e-24,
 -3.942470500287304e-26, -1.213427590884475e-28,  1.862330085106050e+00, -7.846888381639768e-04, -3.033036197995126e-06, -8.849303404651047e-09, -1.733692307924177e-11,
 -2.872949424479970e-15,  1.579418400731091e-16,  8.140755168124960e-19,  2.323158018067142e-21,  2.261164715216104e-24, -1.690340443896091e-26, -1.181595315972286e-28,
  1.898830555780991e+00, -5.931147884941983e-04, -2.426649855045005e-06, -7.908824364532378e-09, -2.004463427578637e-11, -3.099351662107651e-14,  3.521955949020082e-17,
  5.095906715868142e-19,  2.343612970353369e-21,  6.874583118959388e-24,  9.848224956979719e-27, -3.002564054692924e-29,  1.930200382076334e+00, -4.191336415443724e-04,
 -1.798089006227772e-06, -6.391017906159542e-09, -1.914767867281908e-11, -4.573374132662022e-14, -6.565962346121562e-17,  1.021338224130062e-19,  1.277824922190795e-21,
  6.150180824277164e-24,  2.075940455845705e-26,  4.805143830656572e-29,  1.956087186400240e+00, -2.689141718210908e-04, -1.198562441461841e-06, -4.553981964658032e-09,
 -1.530454717814920e-11, -4.534307932195293e-14, -1.134248561968094e-16, -2.040814469166241e-19, -1.797680560122040e-23,  2.083662709778157e-24,  1.264989665019232e-26,
  5.265042164213183e-29,  1.976189387218565e+00, -1.480371919323255e-04, -6.793033025243031e-07, -2.711204098089552e-09, -9.858687889644540e-12, -3.314248329265505e-14,
 -1.029116437538562e-16, -2.905740227549769e-19, -7.145625619703797e-22, -1.338603500891988e-24, -6.393468496198534e-28,  1.050952125563568e-29,  1.990266090356547e+00,
 -6.116081209409739e-05, -2.863550292051322e-07, -1.181513771289007e-09, -4.520602214104778e-12, -1.638111624972286e-14, -5.675750897723072e-17, -1.887159114953832e-19,
 -6.018894510093598e-22, -1.833444835705537e-24, -5.282567338520632e-27, -1.411626977472577e-29,  1.998147750240093e+00, -1.170700503907379e-05, -5.542805854697769e-08,
 -2.329001838079979e-10, -9.156338716338325e-13, -3.447574373081318e-15, -1.258523742636636e-17, -4.485985886951613e-20, -1.568265430861819e-22, -5.392318612022108e-25,
 -1.826918298950262e-27, -6.105774386942162e-30,  3.484719154295428e-04, -1.464010846268129e-06,  4.612283109422889e-09, -1.291410575688031e-11,  3.389022705221701e-14,
 -8.535839775553067e-17,  2.089423789049757e-19, -5.008503503947384e-22,  1.181241594480509e-24, -2.750452586832701e-27,  6.336153071850042e-30, -1.446977568224858e-32,
  3.135793389588884e-03, -1.316214725214519e-05,  4.138411280062061e-08, -1.154729417104937e-10,  3.014246402549076e-13, -7.534448945572737e-16,  1.825404657267302e-18,
 -4.317162537839790e-21,  1.000927849871113e-23, -2.281536138452969e-26,  5.120633349426500e-29, -1.133085263630147e-31,  8.708009471165718e-03, -3.648395332523762e-05,
  1.142540430049407e-07, -3.165838648287247e-10,  8.175083628973902e-13, -2.011841533254109e-15,  4.770704078595618e-18, -1.096463838084542e-20,  2.448809978884736e-23,
 -5.318736860986082e-26,  1.121829593535737e-28, -2.291360881264602e-31,  1.706023592980414e-02, -7.128018542744485e-05,  2.218774886336533e-07, -6.083038731531110e-10,
  1.544879466956698e-12, -3.710024278352767e-15,  8.498597527445519e-18, -1.861790017664930e-20,  3.891341651639113e-23, -7.703179016628773e-26,  1.420568775015947e-28,
 -2.357384529248228e-31,  2.818506982061664e-02, -1.173262066908711e-04,  3.622449048873400e-07, -9.788957516818068e-10,  2.429412169530443e-12, -5.634638531242374e-15,
  1.226060453085626e-17, -2.488789375510011e-20,  4.626658839756877e-23, -7.529753795823741e-26,  9.324334693531108e-29, -2.547576508478814e-32,  4.207249656228892e-02,
 -1.743210727776723e-04,  5.326910083821638e-07, -1.413043717977555e-09,  3.402226484703823e-12, -7.524017969806342e-15,  1.518648930701661e-17, -2.720394446721982e-20,
  3.982064673110815e-23, -3.281320671568115e-26, -6.109543532813892e-29,  4.236355423668106e-31,  5.870976436250298e-02, -2.418863328236661e-04,  7.299077827490878e-07,
 -1.892145668687440e-09,  4.382480453129945e-12, -9.086859678085328e-15,  1.638393091351086e-17, -2.326328090559786e-20,  1.490204817082999e-23,  5.565157515268018e-26,
 -3.088724143859219e-28,  1.002148545462486e-30,  7.808122453710008e-02, -3.195645643669859e-04,  9.499618933673718e-07, -2.394685830158422e-09,  5.280822172155319e-12,
 -1.002443388924716e-14,  1.505083879575853e-17, -1.149962691251918e-20, -2.947817136939665e-23,  1.807871147071575e-25, -5.899812161786038e-28,  1.467578738538112e-30,
  1.001681358888831e-01, -4.068176679851547e-04,  1.188317310527672e-06, -2.896692235588295e-09,  6.003466647997611e-12, -1.005550869767265e-14,  1.059218883249857e-17,
  8.485604731505526e-21, -8.943202578106682e-23,  3.169770756656573e-25, -8.012054608564763e-28,  1.500024864352126e-30,  1.249484309220543e-01, -5.030249558834154e-04,
  1.439864125835756e-06, -3.372283802462087e-09,  6.456845744527572e-12, -8.942947995579530e-15,  2.731783620025204e-18,  3.559081335018473e-20, -1.557370046350826e-22,
  4.244299225548960e-25, -8.174416105687891e-28,  8.120587611367662e-31,  1.523964412694135e-01, -6.074810792304857e-04,  1.698954743533518e-06, -3.794311764903444e-09,
  6.552757143209784e-12, -6.520694932982079e-15, -8.391919038585639e-18,  6.704215649747231e-20, -2.143565000229359e-22,  4.557104838941690e-25, -5.277361380065608e-28,
 -7.096656004676964e-31,  1.824825793036130e-01, -7.193938521257072e-04,  1.959448835789954e-06, -4.135099694677247e-09,  6.213909174390579e-12, -2.719587579561670e-15,
 -2.215766711562716e-17,  9.843845527568161e-20, -2.480828856624144e-22,  3.663699560227575e-25,  1.199002939106691e-28, -2.872468095420356e-30,  2.151729724951588e-01,
 -8.378820462780209e-04,  2.214768666186893e-06, -4.367285155678823e-09,  5.379721609161614e-12,  2.409822095401950e-15, -3.743306576650902e-17,  1.240572315386555e-19,
 -2.393015227671858e-22,  1.283891220531978e-25,  1.075429143369317e-27, -5.109133687284066e-30,  2.504290466755824e-01, -9.619732504374281e-04,  2.457966603240045e-06,
 -4.464763972919872e-09,  4.012197174935449e-12,  8.679543027841259e-15, -5.259764609320708e-17,  1.374452401871612e-19, -1.736828009818421e-22, -2.558996027942289e-25,
  2.159363787996531e-27, -6.526274489052104e-30,  2.882070539753072e-01, -1.090601913082604e-03,  2.681806856851860e-06, -4.403734905991277e-09,  2.101624217680498e-12,
  1.575384433146929e-14, -6.562737015255284e-17,  1.322865312428069e-19, -4.438417859058245e-23, -7.426836210595651e-25,  3.065828086707239e-27, -6.104471096874105e-30,
  3.284575408484061e-01, -1.222607716653045e-03,  2.878863661116026e-06, -4.163837898974102e-09, -3.281922085386531e-13,  2.314886861383904e-14, -7.424748615575622e-17,
  1.035008880091513e-19,  1.438933017535580e-22, -1.242192955841445e-24,  3.408111838524015e-27, -3.045735410930344e-30,  3.711247512936902e-01, -1.356734467603874e-03,
  3.041638276263398e-06, -3.729372689223757e-09, -3.215544191086871e-12,  3.024467755221691e-14, -7.615566588164284e-17,  4.847637083618362e-20,  3.718639578532139e-22,
 -1.624672733688914e-24,  2.811115036162042e-27,  2.793668392673764e-30,  4.161459601651907e-01, -1.491629729670669e-03,  3.162697261401380e-06, -3.090576018026525e-09,
 -6.457728317102760e-12,  3.631207302321179e-14, -6.931015530085521e-17, -3.171541384990608e-20,  6.046419581166570e-22, -1.739591289155844e-24,  1.042355925812984e-27,
  1.051206659039697e-29,  4.634507313782460e-01, -1.625845478846379e-03,  3.234834437459520e-06, -2.244924609012177e-09, -9.909769532337833e-12,  4.055606679624357e-14,
 -5.226803703254310e-17, -1.313280003169108e-19,  7.937608550167944e-22, -1.448651678206034e-24, -1.843490649519083e-27,  1.799245044386152e-29,  5.129600959176440e-01,
 -1.757840118451702e-03,  3.251258761698342e-06, -1.198417112745250e-09, -1.338554949014352e-11,  4.217699814538089e-14, -2.454669677569636e-17, -2.394253340346724e-19,
  8.830197226846212e-22, -6.696638779799688e-25, -5.389143789940342e-27,  2.214473433318318e-29,  5.645856449172520e-01, -1.885982261803575e-03,  3.205809899330012e-06,
  3.322888513504047e-11, -1.666196995027710e-11,  4.044890504941884e-14,  1.303227255985314e-17, -3.401189193214493e-19,  8.184380420238247e-22,  5.762356396446540e-25,
 -8.703885769759623e-27,  1.968949947056934e-29,  6.182285338042928e-01, -2.008556768324804e-03,  3.093202512104848e-06,  1.423548947725404e-09, -1.948678347145136e-11,
  3.481273161530941e-14,  5.807196834158019e-17, -4.138132414827653e-19,  5.617520841238216e-22,  2.126434639269184e-24, -1.057331386008671e-26,  8.454447719547455e-30,
  6.737783947110462e-01, -2.123773605624031e-03,  2.909299073593935e-06,  2.934580145473049e-09, -2.159065962605094e-11,  2.497922832363959e-14,  1.064699673550104e-16,
 -4.396341411900172e-19,  1.057090968082265e-22,  3.664053745759411e-24, -9.744888816676764e-27, -1.109613599466234e-29,  7.311121562095115e-01, -2.229780202941693e-03,
  2.651409229027837e-06,  4.516517662320496e-09, -2.270389377653935e-11,  1.103297963400920e-14,  1.525048253979232e-16, -3.990496453925972e-19, -5.119661597090534e-22,
  4.747600434952845e-24, -5.376012502990912e-27, -3.466959983960410e-29,  7.900927721145667e-01, -2.324678056309478e-03,  2.318611187050145e-06,  6.107936210584243e-09,
 -2.257786992335444e-11, -6.474971974895836e-15,  1.892128206556525e-16, -2.804310029268663e-19, -1.200363146892122e-21,  4.895426252987721e-24,  2.444186313380788e-27,
 -5.407381051705613e-29,  8.505678648629097e-01, -2.406544435965365e-03,  1.912087194519942e-06,  7.636753893200197e-09, -2.101091964366212e-11, -2.646256181545584e-14,
  2.091100812702067e-16, -8.394859773403116e-20, -1.818116390762271e-21,  3.724893041749302e-24,  1.227654245080654e-26, -5.900457885126754e-29,  9.123682940844274e-01,
 -2.473460121381190e-03,  1.435460645406808e-06,  9.022128618622015e-09, -1.787754050779486e-11, -4.730042764469293e-14,  2.052742342179250e-16,  1.742086295437976e-19,
 -2.191790312040632e-21,  1.125329668237061e-24,  2.126212509864474e-26, -4.093990034641646e-29,  9.753066677529140e-01, -2.523544133067109e-03,  8.951166954321390e-07,
  1.017747371461501e-08, -1.315903103814059e-11, -6.686604068361155e-14,  1.727309224964338e-16,  4.596731047803460e-19, -2.152220990544709e-21, -2.582629585229599e-24,
  2.564178799807480e-26,  1.624617982719541e-30,  1.039175822073053e+00, -2.554996421139882e-03,  3.004813768114034e-07,  1.101475020734866e-08, -6.972482449754335e-12,
 -8.268897584102407e-14,  1.099931146288550e-16,  7.213697532886309e-19, -1.586233258837523e-21, -6.572959211373562e-24,  2.197144831192311e-26,  5.870668404149475e-29,
  1.103747307369987e+00, -2.566149378871342e-03, -3.357737091811750e-07,  1.145012619626883e-08,  4.061802291624616e-13, -9.220143554866173e-14,  2.048291606706969e-17,
  8.979937057034629e-19, -4.939306452569158e-22, -9.605094728398967e-24,  8.844142056144012e-27,  1.082904048019060e-28,  1.168769930994233e+00, -2.555528836957082e-03,
 -9.976425535875803e-07,  1.141097531110444e-08,  8.530618406406532e-12, -9.309427295490311e-14, -8.655170997105324e-17,  9.300684422328635e-19,  9.664106342085681e-22,
 -1.033370162252137e-23, -1.148208856985934e-26,  1.225951527050248e-28,  1.233968424825333e+00, -2.521924814561439e-03, -1.665861414975240e-06,  1.084400364062267e-08,
  1.679032782255816e-11, -8.375623611326256e-14, -1.960894405917206e-16,  7.766060246711865e-19,  2.469785045570373e-21, -7.818159165475031e-24, -3.251093951224025e-26,
  8.149110314899774e-29,  1.299042324327643e+00, -2.464471703401410e-03, -2.318207156969736e-06,  9.724039963348973e-09,  2.444113665569666e-11, -6.374329073965564e-14,
 -2.887992279068246e-16,  4.331652328642586e-19,  3.575150312510527e-21, -2.095596926191296e-24, -4.496081400979575e-26, -1.151516098244166e-29,  1.363665167904326e+00,
 -2.382736687019665e-03, -2.930075963282981e-06,  8.062701246238291e-09,  3.066505193413261e-11, -3.418922108711019e-14, -3.441694851636965e-16, -5.431361124660909e-20,
  3.845097582087171e-21,  5.442443296759307e-24, -4.056393946266273e-26, -1.205399996166857e-28,  1.427484148600872e+00, -2.276814003146309e-03, -3.475396822110132e-06,
  5.915778305726713e-09,  3.466122493632749e-11,  1.963392371399413e-15, -3.451542057849603e-16, -5.871093744604390e-19,  3.016516300462413e-21,  1.218302107431972e-23,
 -1.714259879265070e-26, -1.868341528055372e-28,  1.490120373371471e+00, -2.147421121060894e-03, -3.927919323085853e-06,  3.387830121244382e-09,  3.576401179423985e-11,
  4.004728175472982e-14, -2.835776451849610e-16, -1.029268513980852e-18,  1.167029309308591e-21,  1.513379773971927e-23,  1.773394528386958e-26, -1.599421258154237e-28,
  1.551169905517807e+00, -1.995991053667109e-03, -4.262886070327249e-06,  6.322238909008426e-10,  3.357586914976393e-11,  7.418386505479209e-14, -1.648436746914558e-16,
 -1.243215985657065e-18, -1.208574731253098e-21,  1.233850012532413e-23,  4.787111920291810e-26, -3.725446273962116e-29,  1.610205779776381e+00, -1.824752957558178e-03,
 -4.459053198282419e-06, -2.155153376254115e-09,  2.809309548866242e-11,  9.826541617459066e-14, -9.985250534916010e-18, -1.139133997775460e-18, -3.295556215401110e-21,
  4.259306383481374e-24,  5.599830924397189e-26,  1.174703205177859e-28,  1.666781181914080e+00, -1.636791104061509e-03, -4.500957065536682e-06, -4.749895798527574e-09,
  1.979348873035413e-11,  1.073108538673749e-13,  1.468413774907878e-16, -7.214722087938587e-19, -4.255235344199527e-21, -5.804326037497445e-24,  3.502369573642767e-26,
  2.037517481934970e-28,  1.720433969652228e+00, -1.436070574874150e-03, -4.381244362348122e-06, -6.921236696749404e-09,  9.650569138427621e-12,  9.892290402207662e-14,
  2.662869292252564e-16, -1.088672435994343e-19, -3.631892873319556e-21, -1.297368328628073e-23, -4.455138738362767e-27,  1.566259407600251e-28,  1.770692672939246e+00,
 -1.227417132051153e-03, -4.102796126706384e-06, -8.461255054574314e-09, -9.562769127764434e-13,  7.440850167153747e-14,  3.159661273353417e-16,  4.930419625758140e-19,
 -1.664927045260717e-21, -1.348578419004281e-23, -3.824825735825234e-26,  8.810959273642823e-30,  1.817084043401569e+00, -1.016439223585048e-03, -3.680300912483212e-06,
 -9.217965500528179e-09, -1.044864982112737e-11,  3.905728690546159e-14,  2.830644602469388e-16,  8.682564213176523e-19,  7.281622555755955e-22, -7.299142313480475e-24,
 -4.482305734606784e-26, -1.234348612043217e-28,  1.859142121965764e+00, -8.093826129441449e-04, -3.140893390925270e-06, -9.126939987617676e-09, -1.735458598630906e-11,
  1.199654941944540e-15,  1.817879757688825e-16,  8.895779886500036e-19,  2.391082851576960e-21,  1.475131548091305e-24, -2.254728709415895e-26, -1.386156699990612e-28,
  1.896418661399837e+00, -6.129131098316292e-04, -2.523500325634474e-06, -8.234446542574757e-09, -2.065485138477977e-11, -2.996831889757359e-14,  5.057576795888392e-17,
  5.886192311062663e-19,  2.597830522556100e-21,  7.237673678473017e-24,  8.190863966156346e-27, -4.588348480269214e-29,  1.928494584923643e+00, -4.338304006886702e-04,
 -1.876649857007147e-06, -6.704782725564687e-09, -2.007785540014739e-11, -4.727042429824670e-14, -6.219295942984006e-17,  1.467311441114054e-19,  1.514690978649821e-21,
  7.023180944673339e-24,  2.289677639620615e-26,  4.889190720001570e-29,  1.954992000642227e+00, -2.787254952159847e-04, -1.254709872415159e-06, -4.806259461314459e-09,
 -1.623909361554099e-11, -4.813383932358544e-14, -1.191351903062985e-16, -2.033541764519782e-19,  6.672419707597051e-23,  2.638523426308552e-24,  1.515783240482593e-26,
  6.153402982140730e-29,  1.975586159693215e+00, -1.536044889747007e-04, -7.128065021481054e-07, -2.874382911757216e-09, -1.054690891514638e-11, -3.571262415282607e-14,
 -1.113751145799802e-16, -3.142150278407844e-19, -7.630913981152005e-22, -1.353842581255458e-24, -9.408956292974193e-29,  1.442812344824624e-29,  1.990016773863301e+00,
 -6.350961998179014e-05, -3.009782285584700e-07, -1.256540233633947e-09, -4.862285861261336e-12, -1.780894392004537e-14, -6.232142150700351e-17, -2.090744632788520e-19,
 -6.718509972658903e-22, -2.057654718875657e-24, -5.940206703844333e-27, -1.580234228005811e-29,  1.998100017311937e+00, -1.216186311778316e-05, -5.831309135544609e-08,
 -2.481187863065688e-10, -9.877105670072259e-13, -3.765278523260209e-15, -1.391459377195037e-17, -5.020355264713465e-20, -1.776217011277031e-22, -6.179789346731630e-25,
 -2.118107615349575e-27, -7.159687593211116e-30,  3.426886999471737e-04, -1.427723368325287e-06,  4.460511835321779e-09, -1.238525169922688e-11,  3.223209103252015e-14,
 -8.050788478249564e-17,  1.954332215417370e-19, -4.645871831170782e-22,  1.086638012427365e-24, -2.509290060226833e-27,  5.732789103382166e-30, -1.298441898474933e-32,
  3.083798284697936e-03, -1.283653619341303e-05,  4.002688459168658e-08, -1.107683587796774e-10,  2.867842320404476e-13, -7.110503008790055e-16,  1.708887549164438e-18,
 -4.009621507899906e-21,  9.223623608720796e-24, -2.086342382380787e-26,  4.647229835685569e-29, -1.020813893398638e-31,  8.563877972120890e-03, -3.558489766252873e-05,
  1.105322094844502e-07, -3.038195074821859e-10,  7.783920836484292e-13, -1.900941943637532e-15,  4.474383084773304e-18, -1.021080840548603e-20,  2.265175326969154e-23,
 -4.889548293928357e-26,  1.025612866443034e-28, -2.085431554816967e-31,  1.677861958270660e-02, -6.953394946517854e-05,  2.147237373884306e-07, -5.841684981384575e-10,
  1.472677135880249e-12, -3.512175364913331e-15,  7.994320339672875e-18, -1.741596449998905e-20,  3.624009409019396e-23, -7.155248805266455e-26,  1.320179488726879e-28,
 -2.206749467602378e-31,  2.772148743798611e-02, -1.144745821096859e-04,  3.507277117225885e-07, -9.409109452606642e-10,  2.319606352344807e-12, -5.348581533840938e-15,
  1.158406854503194e-17, -2.345001695021696e-20,  4.362269859701175e-23, -7.159494558756981e-26,  9.177624650296579e-29, -4.059290232014960e-32,  4.138362922752713e-02,
 -1.701264567125968e-04,  5.160561951034119e-07, -1.359792390320523e-09,  3.255329923673222e-12, -7.168539867801589e-15,  1.444243776905234e-17, -2.594902059755511e-20,
  3.859968977726716e-23, -3.490440801609350e-26, -4.394668978994819e-29,  3.574286062552710e-31,  5.775375541749742e-02, -2.361367151934047e-04,  7.076168241239351e-07,
 -1.823458734814022e-09,  4.204622927907703e-12, -8.701406144700422e-15,  1.573951984074869e-17, -2.275666043851127e-20,  1.669341975380257e-23,  4.414319769023061e-26,
 -2.673981898586685e-28,  8.851865579395612e-31,  7.681798568170962e-02, -3.120783928664435e-04,  9.217260694787940e-07, -2.311777069851166e-09,  5.083919088575537e-12,
 -9.667178371912983e-15,  1.471658968852604e-17, -1.234322575690274e-20, -2.337942222103746e-23,  1.584396310307611e-25, -5.283588513181683e-28,  1.334963615526916e-30,
  9.855966043059446e-02, -3.974485529795716e-04,  1.154126744811497e-06, -2.802231763299970e-09,  5.804916217357862e-12, -9.798758062749885e-15,  1.079139234017098e-17,
  5.800301155011418e-21, -7.858201687351435e-23,  2.862263850088103e-25, -7.368947198643270e-28,  1.422401538138291e-30,  1.229591150925032e-01, -4.916661698057006e-04,
  1.400010687492851e-06, -3.270401251111576e-09,  6.278720281331108e-12, -8.865975926050424e-15,  3.660808649804943e-18,  3.084546138978301e-20, -1.410372769906431e-22,
  3.924681403855135e-25, -7.801714179170764e-28,  8.775086151058979e-31,  1.499934143637995e-01, -5.940697958764299e-04,  1.654047729645055e-06, -3.690521280374946e-09,
  6.420477293488743e-12, -6.700334926751093e-15, -6.608333438352499e-18,  6.044110770961446e-20, -1.983376351738200e-22,  4.340617683133429e-25, -5.526824330966240e-28,
 -4.325998514601168e-31,  1.796360431893662e-01, -7.039150603583419e-04,  1.910422288734851e-06, -4.036140254346481e-09,  6.154418256751799e-12, -3.219181123009609e-15,
 -1.951054349474835e-17,  9.071151942989939e-20, -2.348363366742887e-22,  3.687869211125102e-25,  4.519535894544854e-30, -2.382026908113746e-30,  2.118565507652838e-01,
 -8.203720600001236e-04,  2.162879133148165e-06, -4.280871685600365e-09,  5.419211024189385e-12,  1.552250989371062e-15, -3.406591882581150e-17,  1.164814083233541e-19,
 -2.339577463257961e-22,  1.670893879959274e-25,  8.639438821570796e-28, -4.510593674292172e-30,  2.466201433749466e-01, -9.425227222108283e-04,  2.404780116367540e-06,
 -4.399247381490649e-09,  4.173473046454939e-12,  7.462745155303973e-15, -4.882825855187367e-17,  1.317561094245447e-19, -1.814083656341898e-22, -1.751269416220357e-25,
  1.882793450257094e-27, -6.042623897350136e-30,  2.838872213867352e-01, -1.069358242465402e-03,  2.629173917665522e-06, -4.367672625333892e-09,  2.401249630080240e-12,
  1.422305135768222e-14, -6.194708509048238e-17,  1.304615951876886e-19, -6.897802328851808e-23, -6.254098386199420e-25,  2.798357237449885e-27, -6.036712257212442e-30,
  3.236128552682696e-01, -1.199776726289365e-03,  2.828881067221884e-06, -4.165480979884869e-09,  1.172030242140471e-13,  2.140218517629373e-14, -7.129153383639626e-17,
  1.074160068707809e-19,  1.015940669823046e-22, -1.108747223800053e-24,  3.259602753942805e-27, -3.673863944134083e-30,  3.657461950284021e-01, -1.332581200581764e-03,
  2.996596752873730e-06, -3.776081069858518e-09, -2.628811332540261e-12,  2.843452102996525e-14, -7.464036918894701e-17,  5.946212159543569e-20,  3.154253328118235e-22,
 -1.510209457623643e-24,  2.901576168954403e-27,  1.355598918858025e-30,  4.102298071111735e-01, -1.466478201124612e-03,  3.125014079736819e-06, -3.188180383192189e-09,
 -5.748182169356228e-12,  3.464010174590767e-14, -6.993665953054118e-17, -1.335996111582290e-20,  5.428730168004632e-22, -1.689261423515725e-24,  1.459220645395456e-27,
  8.464286109603562e-30,  4.569989324749473e-01, -1.600077193988841e-03,  3.206970547207015e-06, -2.397061307587953e-09, -9.111475749620004e-12,  3.926032927951422e-14,
 -5.559754895604140e-17, -1.067747957698058e-19,  7.404673641021475e-22, -1.507163308061704e-24, -1.097103624919962e-27,  1.593207565734772e-29,  5.059806594485200e-01,
 -1.731891149358995e-03,  3.235620470637579e-06, -1.405871815959839e-09, -1.254842734904026e-11,  4.151059979355487e-14, -3.085892318337897e-17, -2.115941460002526e-19,
  8.552636413473563e-22, -8.660564518367668e-25, -4.438805791226576e-27,  2.100358847348386e-29,  5.570930050368051e-01, -1.860338658101388e-03,  3.204635839443547e-06,
 -2.268769996436494e-10, -1.585062012588715e-11,  4.065037591376557e-14,  3.878252487193203e-18, -3.136624725457765e-19,  8.331270728750204e-22,  2.456795077684905e-25,
 -7.818236658892967e-27,  2.047113039100783e-29,  6.102438987483432e-01, -1.983748064895647e-03,  3.108437579288938e-06,  1.117402273007994e-09, -1.877751930755977e-11,
  3.606951673649088e-14,  4.674779334673628e-17, -3.946931840777723e-19,  6.307900776734576e-22,  1.711973181456930e-24, -1.012552852322705e-26,  1.178154934735819e-29,
  6.653300638621746e-01, -2.100364186998020e-03,  2.942458256619491e-06,  2.593260927919740e-09, -2.106651687481666e-11,  2.738729188246422e-14,  9.422685754579208e-17,
 -4.342170391692867e-19,  2.304964443538660e-22,  3.266177233232496e-24, -1.010820599648756e-26, -5.505210018396440e-30,  7.222357925061709e-01, -2.208358293677625e-03,
  2.703435782664202e-06,  4.155215674677870e-09, -2.244754697346676e-11,  1.455731986159540e-14,  1.411274558675643e-16, -4.127423204819922e-19, -3.452740473660450e-22,
  4.503903790441058e-24, -6.762833805909410e-27, -2.835887590565256e-29,  7.808316131905985e-01, -2.305842135308098e-03,  2.389735464339970e-06,  5.745898284109920e-09,
 -2.266261604268791e-11, -2.032266207139897e-15,  1.808495918518082e-16, -3.160085717253099e-19, -1.022930495170599e-21,  4.946818220768009e-24,  1.570081305794014e-28,
 -4.973946045900597e-29,  8.409728527884585e-01, -2.390886927648430e-03,  2.001694608477864e-06,  7.296616932706148e-09, -2.149020829512011e-11, -2.147857373556887e-14,
  2.059658096914182e-16, -1.398931086192249e-19, -1.675809946456611e-21,  4.163710670921121e-24,  9.659433812663797e-27, -5.968031725114303e-29,  9.024980996934386e-01,
 -2.461548306885170e-03,  1.541979597927068e-06,  8.728789096088907e-09, -1.877392891955111e-11, -4.232319422613876e-14,  2.091773932198627e-16,  1.048800059155090e-19,
 -2.136425549718310e-21,  1.937428725848505e-24,  1.928769589591137e-26, -4.850787270699775e-29,  9.652275813905765e-01, -2.515898360173644e-03,  1.015939722674124e-06,
  9.956460127660671e-09, -1.445389445129841e-11, -6.257390964388223e-14,  1.846250081723135e-16,  3.895122896797528e-19, -2.226753264592156e-21, -1.559571264686677e-24,
  2.541269863595849e-26, -1.188336421840239e-29,  1.028961478369611e+00, -2.552065883352380e-03,  4.319349293811363e-07,  1.089011044454598e-08, -8.598258101328078e-12,
 -7.981270913048570e-14,  1.294464996909451e-16,  6.669986824577171e-19, -1.806456571138797e-21, -5.646709225235828e-24,  2.423365646670610e-26,  4.397027032229631e-29,
  1.093478207656217e+00, -2.568285991936700e-03, -1.983939446791934e-07,  1.144190807267113e-08, -1.430906508996124e-12, -9.141022256558711e-14,  4.535401624688071e-17,
  8.767328558289055e-19, -8.322181963217513e-22, -9.158298568625625e-24,  1.343422005221913e-26,  9.985984221752768e-29,  1.158532723687998e+00, -2.562960072435006e-03,
 -8.599536939672632e-07,  1.153246617119556e-08,  6.650086523066232e-12, -9.485586310286291e-14, -6.013333794036037e-17,  9.549633882577455e-19,  5.874464638768326e-22,
 -1.068337774560427e-23, -5.966036700428077e-27,  1.274914081697502e-28,  1.223854902206315e+00, -2.534726755670726e-03, -1.534177586634014e-06,  1.109899973792143e-08,
  1.506994799667691e-11, -8.819278117655352e-14, -1.732820670611779e-16,  8.508922803059487e-19,  2.165842877560746e-21, -9.040844500185230e-24, -2.847828154111832e-26,
  1.013930695090177e-28,  1.289148094481162e+00, -2.482544058064851e-03, -2.199215606925231e-06,  1.010452698443189e-08,  2.309800791630913e-11, -7.051608308080643e-14,
 -2.750827534401543e-16,  5.460153712447597e-19,  3.467288168000539e-21, -3.896102160883295e-24, -4.486290623038367e-26,  1.614019444420206e-29,  1.354087964409319e+00,
 -2.405781999056947e-03, -2.830403722806066e-06,  8.547422740089477e-09,  2.989861623651313e-11, -4.245346464090817e-14, -3.439404991637598e-16,  7.154116258047862e-20,
  4.010592170405360e-21,  3.719469077265217e-24, -4.543571883143066e-26, -1.000824507613440e-28,  1.418321749148413e+00, -2.304323792478057e-03, -3.401080181728176e-06,
  6.470216578504623e-09,  3.461638228415087e-11, -6.506269469176126e-15, -3.601769714387335e-16, -4.837119162129325e-19,  3.440772130191236e-21,  1.133199365947206e-23,
 -2.542020280626106e-26, -1.883931894891381e-28,  1.481468113463697e+00, -2.178672073567471e-03, -3.883806809701093e-06,  3.966082373561953e-09,  3.649458837587201e-11,
  3.290031198300461e-14, -3.117915364003842e-16, -9.830838585882328e-19,  1.722843999383304e-21,  1.569426908118955e-23,  1.009329986368978e-26, -1.868738747188643e-28,
  1.543117796214996e+00, -2.030054551542696e-03, -4.252027867662883e-06,  1.181080350898028e-09,  3.501714355871681e-11,  6.980594963419735e-14, -2.001257747182274e-16,
 -1.274417687997081e-18, -7.304150956505402e-22,  1.420969179941711e-23,  4.541350194537740e-26, -7.498958999770149e-29,  1.602835270287818e+00, -1.860521039960391e-03,
 -4.482153318776575e-06, -1.689965459597494e-09,  3.005336286706796e-11,  9.763126178854670e-14, -4.333122134314197e-17, -1.241696379188625e-18, -3.100712115584965e-21,
  6.596427016168360e-24,  6.069129987633551e-26,  9.461475290747415e-29,  1.660161649009979e+00, -1.673021207433891e-03, -4.555984214217905e-06, -4.415845908685167e-09,
  2.197323113479197e-11,  1.105770623636633e-13,  1.247044274598010e-16, -8.606949130248691e-19, -4.436783458427719e-21, -4.220859889458901e-24,  4.421942303677590e-26,
  2.133122574536654e-28,  1.714619065335840e+00, -1.471449971566900e-03, -4.463306337571901e-06, -6.750653965964046e-09,  1.169261946347658e-11,  1.052636455635466e-13,
  2.615411806239803e-16, -2.325809727461325e-19, -4.100401193601953e-21, -1.300403200747509e-23,  3.188087250158488e-27,  1.909849386223739e-28,  1.765716716402934e+00,
 -1.260645785614113e-03, -4.204372533141357e-06, -8.464233525483637e-09,  6.088101542697206e-13,  8.215087133074115e-14,  3.289503315456202e-16,  4.317024640791568e-19,
 -2.177784478422124e-21, -1.499951295613426e-23, -3.721780223067252e-26,  3.907468853066436e-29,  1.812958697196312e+00, -1.046326873455274e-03, -3.791892572706654e-06,
 -9.378517305765706e-09, -9.597586875320033e-12,  4.614494571057425e-14,  3.076598252289466e-16,  8.869966607206278e-19,  4.318136070780120e-22, -9.200404255126514e-24,
 -5.022455004835968e-26, -1.212878002901065e-28,  1.855853636912529e+00, -8.349525702320789e-04, -3.252081127871288e-06, -9.404175742185848e-09, -1.728490134126374e-11,
  5.870153263402469e-15,  2.077740360361138e-16,  9.667559449575878e-19,  2.426426396999799e-21,  4.449547065620893e-25, -2.911932701231948e-26, -1.602682096457370e-28,
  1.893925999146418e+00, -6.335020290851744e-04, -2.624316099611962e-06, -8.569647369189254e-09, -2.124069501220581e-11, -2.854708773870477e-14,  6.826053116928458e-17,
  6.759776698957357e-19,  2.863748259962151e-21,  7.519451296267830e-24,  5.755337397839394e-27, -6.548154901740212e-29,  1.926728719554408e+00, -4.491709626628211e-04,
 -1.959066180954795e-06, -7.033671280998888e-09, -2.103782808888003e-11, -4.870803649460657e-14, -5.736661177776647e-17,  1.994275766000790e-19,  1.784529177655351e-21,
  7.982004091404423e-24,  2.503945842503573e-26,  4.820674150279798e-29,  1.953856651694130e+00, -2.889983658652513e-04, -1.313976215775683e-06, -5.073943656167853e-09,
 -1.723082241990498e-11, -5.106107753374283e-14, -1.247840693229901e-16, -1.995767280658538e-19,  1.733031861073099e-22,  3.301858964331509e-24,  1.808217081983926e-26,
  7.158883886213593e-29,  1.974960114257393e+00, -1.594478353726882e-04, -7.483356494195971e-07, -3.048995748960900e-09, -1.128861851713152e-11, -3.849400751855973e-14,
 -1.205223248935250e-16, -3.394131697522726e-19, -8.117320987794552e-22, -1.343533996340642e-24,  6.455722874928721e-28,  1.938207505278868e-29,  1.989757822331175e+00,
 -6.597910989087074e-05, -3.165355134990383e-07, -1.337269540564738e-09, -5.233908913789663e-12, -1.937740658870844e-14, -6.848796673388950e-17, -2.318061542948121e-19,
 -7.503759008171241e-22, -2.309700288646348e-24, -6.675500546122142e-27, -1.764606381195299e-29,  1.998050417605999e+00, -1.264055205117215e-05, -6.138788219892520e-08,
 -2.645432343349854e-10, -1.066472910440273e-12, -4.116760604252876e-15, -1.540333252166466e-17, -5.626039174668431e-20, -2.014730853401603e-22, -7.093563752895502e-25,
 -2.459869406178534e-27, -8.410426469545149e-30,  3.370482456019530e-04, -1.392625119333464e-06,  4.314930774059181e-09, -1.188216901258217e-11,  3.066780358487354e-14,
 -7.596974138991883e-17,  1.828983231456523e-19, -4.312169539704511e-22,  1.000297157396311e-24, -2.291004393671799e-27,  5.191124081814608e-30, -1.166194077124667e-32,
  3.033084260400693e-03, -1.252156105909571e-05,  3.872473339487584e-08, -1.062913883061151e-10,  2.729644346851906e-13, -6.713515612910847e-16,  1.600639925323911e-18,
 -3.726132720520982e-21,  8.504945741533773e-24, -1.909132563997223e-26,  4.220576271493123e-29, -9.203557234354209e-32,  8.423284101680199e-03, -3.471501445236699e-05,
  1.069598650507046e-07, -2.916636460130690e-10,  7.414243551183161e-13, -1.796907271077117e-15,  4.198369355222974e-18, -9.513341934310850e-21,  2.096320013273742e-23,
 -4.497091794945489e-26,  9.380302227576899e-29, -1.898593900269916e-31,  1.650387552639219e-02, -6.784380435739313e-05,  2.078528077006675e-07, -5.611573509015105e-10,
  1.404313433342037e-12, -3.326034740802389e-15,  7.522528811296444e-18, -1.629649527776734e-20,  3.375695660975354e-23, -6.646166764983257e-26,  1.226282189545316e-28,
 -2.062389197893887e-31,  2.726913012383566e-02, -1.117133012411505e-04,  3.396559808533626e-07, -9.046381314796736e-10,  2.215362518687250e-12, -5.078287711071288e-15,
  1.094662859757458e-17, -2.209462448880698e-20,  4.111089518920970e-23, -6.796328601962593e-26,  8.972166089520561e-29, -5.228224361626821e-32,  4.071127819141031e-02,
 -1.660624025118062e-04,  5.000465271918090e-07, -1.308835489520266e-09,  3.115367175385305e-12, -6.830501828234678e-15,  1.373296670481722e-17, -2.473424502754460e-20,
  3.731511954313725e-23, -3.636520107073992e-26, -2.950987421166136e-29,  3.001689277266531e-31,  5.682039344035019e-02, -2.305621760561111e-04,  6.861332860736300e-07,
 -1.757556684156084e-09,  4.034320995604491e-12, -8.331242146597747e-15,  1.511003661774296e-17, -2.219903456617410e-20,  1.809914508581867e-23,  3.419459743677400e-26,
 -2.307932851608948e-28,  7.806196178672812e-31,  7.558424596530644e-02, -3.048141813539954e-04,  8.944664823736436e-07, -2.231962041502905e-09,  4.894079093154508e-12,
 -9.318206955925208e-15,  1.436133443507797e-17, -1.300407230492514e-20, -1.804219584719928e-23,  1.384430623489733e-25, -4.723681906985380e-28,  1.211582766860079e-30,
  9.698812148654574e-02, -3.883484820109407e-04,  1.121050814150117e-06, -2.710906782910078e-09,  5.611542716478328e-12, -9.538090577320037e-15,  1.092010522954147e-17,
  3.444975187118309e-21, -6.879356372620569e-23,  2.579785841345032e-25, -6.760873035636271e-28,  1.341154820270572e-30,  1.210146044270872e-01, -4.806213691977425e-04,
  1.361362794326290e-06, -3.171355224425403e-09,  6.102346733308928e-12, -8.768249592609223e-15,  4.463378407177938e-18,  2.655238361778496e-20, -1.274607157762520e-22,
  3.620470528866897e-25, -7.405886644809198e-28,  9.179876317324175e-31,  1.476433219163195e-01, -5.810128229285935e-04,  1.610373391507611e-06, -3.588873751854512e-09,
  6.285018029539205e-12, -6.839329620725928e-15, -5.002519154804537e-18,  5.434002332514306e-20, -1.831132794758280e-22,  4.116446043998650e-25, -5.665039237335699e-28,
 -2.029614609304099e-31,  1.768506453145356e-01, -6.888237478331286e-04,  1.862577225086418e-06, -3.938209224513623e-09,  6.085553501002581e-12, -3.657792000901818e-15,
 -1.707383265422381e-17,  8.340901574711548e-20, -2.215808092863231e-22,  3.670028589205855e-25, -9.057372728301313e-29, -1.949611805431928e-30,  2.086093453288964e-01,
 -8.032730326741896e-04,  2.112029800763929e-06, -4.193959277257086e-09,  5.442340055514006e-12,  7.729664866282460e-16, -3.090830282283382e-17,  1.090972954233414e-19,
 -2.273667941352770e-22,  1.978446928092623e-25,  6.778731449307436e-28, -3.954308942092895e-30,  2.428881962422197e-01, -9.234944990336521e-04,  2.352394523762028e-06,
 -4.331340203124816e-09,  4.311304577336552e-12,  6.334475711701811e-15, -4.522120556342929e-17,  1.258641923727104e-19, -1.864200833549125e-22, -1.049880222701823e-25,
  1.627739656407991e-27, -5.550285578102116e-30,  2.796515242063660e-01, -1.048533825169825e-03,  2.577001495057609e-06, -4.327056484786328e-09,  2.671137869139988e-12,
  1.277988694287499e-14, -5.832829627408198e-17,  1.279151484596613e-19, -8.954161524957088e-23, -5.187473449224703e-25,  2.535914763279489e-27, -5.879511519782578e-30,
  3.188586939707745e-01, -1.177345557026960e-03,  2.778920374069370e-06, -4.160273317283227e-09,  5.283821244572123e-13,  1.972761151698789e-14, -6.824419450898146e-17,
  1.100532176282330e-19,  6.398577858125740e-23, -9.817414429973301e-25,  3.087386053383785e-27, -4.127364729374387e-30,  3.604635278386858e-01, -1.308790350895799e-03,
  2.951049867245202e-06, -3.813689272891549e-09, -2.077894056036290e-12,  2.666422258800831e-14, -7.284213222215424e-17,  6.870834575095969e-20,  2.631578692937852e-22,
 -1.393327427857270e-24,  2.933657913278352e-27,  1.378708551520004e-31,  4.044136500916116e-01, -1.441632632590700e-03,  3.086226656440893e-06, -3.274700171611786e-09,
 -5.072185324832580e-12,  3.295904022764058e-14, -7.007658924580097e-17,  3.050920488462099e-21,  4.831948414358919e-22, -1.624007972763221e-24,  1.789823983779250e-27,
  6.593331624087083e-30,  4.506497496303596e-01, -1.574538907675528e-03,  3.177356784154405e-06, -2.536636735069960e-09, -8.339841116902399e-12,  3.789273889937096e-14,
 -5.826372324743258e-17, -8.395510091606419e-20,  6.855829987870961e-22, -1.537632535897601e-24, -4.412779400388299e-28,  1.388425030483533e-29,  4.991047531966061e-01,
 -1.706077017788400e-03,  3.217572621097450e-06, -1.600047156730200e-09, -1.172608553365737e-11,  4.070195264810771e-14, -3.640532221395774e-17, -1.847570412646765e-19,
  8.211088204320747e-22, -1.025520905137661e-24, -3.544603976278219e-27,  1.960609728844668e-29,  5.497029013300275e-01, -1.834716711043674e-03,  3.200418493517252e-06,
 -4.739807360534016e-10, -1.503737761706271e-11,  4.064108202832718e-14, -4.530146273426907e-18, -2.869194826697129e-19,  8.365605183416754e-22, -4.892872205413103e-26,
 -6.910457828031188e-27,  2.070812526691137e-29,  6.023587192747942e-01, -1.958831981234256e-03,  3.120067757888798e-06,  8.227903301470353e-10, -1.804579264680253e-11,
  3.706118198227380e-14,  3.598769215791022e-17, -3.735989099598097e-19,  6.852632408703618e-22,  1.318142213226170e-24, -9.546912158005609e-27,  1.440559288860862e-29,
  6.569758755004412e-01, -2.076705732106598e-03,  2.971573464505659e-06,  2.260697379058990e-09, -2.049713663723675e-11,  2.950377885969179e-14,  8.218916076042512e-17,
 -4.250382520634395e-19,  3.407564783000971e-22,  2.858526936686092e-24, -1.023770101721126e-26, -4.798860445046875e-31,  7.134459215111713e-01, -2.186537439493538e-03,
  2.751153599418189e-06,  3.798564174613541e-09, -2.212347191012456e-11,  1.780459676465934e-14,  1.294399774320149e-16, -4.212513800171928e-19, -1.882865675180391e-22,
  4.210289372721743e-24, -7.872194857670801e-27, -2.208804373634873e-29,  7.716469084004594e-01, -2.286454614279391e-03,  2.456510046846555e-06,  5.383204019859118e-09,
 -2.266059259065802e-11,  2.198410690419496e-15,  1.715698354324544e-16, -3.458959626544555e-19, -8.452462431904883e-22,  4.910786114991596e-24, -1.921287387496453e-27,
 -4.461836562304236e-29,  8.314418784413937e-01, -2.374529009414032e-03,  2.087177641917498e-06,  6.949604168597396e-09, -2.187069597357917e-11, -1.658831707554627e-14,
  2.013210757355360e-16, -1.910512877052766e-19, -1.519593173441827e-21,  4.497727885451639e-24,  7.048077898207020e-27, -5.877005458595977e-29,  8.926772342356694e-01,
 -2.448798657288516e-03,  1.644895722556440e-06,  8.421908149967800e-09, -1.956999199483980e-11, -3.727535275692581e-14,  2.111684369668733e-16,  3.777496201079828e-20,
 -2.053322156781501e-21,  2.664430491478300e-24,  1.702074211301026e-26, -5.422604618620054e-29,  9.551809940027128e-01, -2.507296957295794e-03,  1.133989161196352e-06,
  9.715430304605127e-09, -1.566022103659848e-11, -5.802013015119096e-14,  1.945267181018924e-16,  3.175528099518279e-19, -2.264760902370076e-21, -5.572595329048228e-25,
  2.461264868180658e-26, -2.426796789419559e-29,  1.018760949983209e+00, -2.548090137529804e-03,  5.617387093938974e-07,  1.073994330966694e-08, -1.016196690248031e-11,
 -7.648859478226214e-14,  1.472839646852389e-16,  6.061301672103123e-19, -1.991864501310532e-21, -4.643166377582140e-24,  2.583146250396796e-26,  2.859827317044479e-29,
  1.083202758238249e+00, -2.569324459631311e-03, -6.128853133672694e-08,  1.140445536304652e-08, -3.246254397354071e-12, -9.003045396132713e-14,  6.948092605184013e-17,
  8.449388176666174e-19, -1.151213363311872e-21, -8.536162012113765e-24,  1.759103031969411e-26,  8.866686434796783e-29,  1.148268002969539e+00, -2.569284479432079e-03,
 -7.209885255570238e-07,  1.162362132849873e-08,  4.740712581925029e-12, -9.597642805465388e-14, -3.318927011163230e-17,  9.675730036043419e-19,  1.999069095341838e-22,
 -1.080926014762016e-23, -3.212179620777431e-28,  1.284340285358648e-28,  1.213692297474549e+00, -2.546463460830821e-03, -1.399601791486263e-06,  1.132579033853333e-08,
  1.326647367193211e-11, -9.205812766490581e-14, -1.485372299890245e-16,  9.147809176827782e-19,  1.820991363620102e-21, -1.008551445051048e-23, -2.363144573461441e-26,
  1.183757575293044e-28,  1.279183507468661e+00, -2.499646592455078e-03, -2.075791562174377e-06,  1.046245925174267e-08,  2.162296895849372e-11, -7.692221222352718e-14,
 -2.582645224216385e-16,  6.543799814209149e-19,  3.294973850246596e-21, -5.668120530021674e-24, -4.353257677566521e-26,  4.432906162647283e-29,  1.344420210949981e+00,
 -2.428006887562939e-03, -2.724993852365393e-06,  9.018560490564917e-09,  2.896723890788742e-11, -5.066938551074208e-14, -3.401230201780980e-16,  2.016635668030630e-19,
  4.110782005490684e-21,  1.821053735644383e-24, -4.930169381044845e-26, -7.491941282025264e-29,  1.409050541707835e+00, -2.331212460843018e-03, -3.320120237645291e-06,
  7.022563644826012e-09,  3.439878323688107e-11, -1.530023262492089e-14, -3.721196032393928e-16, -3.672923889028489e-19,  3.828431589186421e-21,  1.015036779865883e-23,
 -3.362505891930396e-26, -1.834397357620957e-28,  1.472691599759203e+00, -2.209542182242120e-03, -3.832689968823333e-06,  4.554844021162625e-09,  3.707556943329292e-11,
  2.509375317051269e-14, -3.384606527040731e-16, -9.188515488252638e-19,  2.293057515815918e-21,  1.592639167860151e-23,  1.343323319753091e-27, -2.101237193125519e-28,
  1.534929648909314e+00, -2.064004453614936e-03, -4.234448064326068e-06,  1.752250461969500e-09,  3.636233038703527e-11,  6.457257054979869e-14, -2.360573343468211e-16,
 -1.289262749534380e-18, -1.870702281598018e-22,  1.594850562657660e-23,  4.123296688567272e-26, -1.153639459206594e-28,  1.595321354973111e+00, -1.896451062365045e-03,
 -4.499483560632940e-06, -1.193559175444251e-09,  3.199271548897610e-11,  9.616312668534964e-14, -7.944875391909579e-17, -1.336643437641111e-18, -2.818615269075587e-21,
  9.098933498720473e-24,  6.421222466380498e-26,  6.416127915697201e-29,  1.653396341489124e+00, -1.709674895940610e-03, -4.606791450407433e-06, -4.046427750106505e-09,
  2.421266592410322e-11,  1.132646039815997e-13,  9.859698826694790e-17, -1.004743370024677e-18, -4.554620354491917e-21, -2.262915984300967e-24,  5.370111556815230e-26,
  2.164923408982597e-28,  1.708661344202160e+00, -1.507477111060925e-03, -4.543121121643075e-06, -6.546391308013058e-09,  1.386005630510535e-11,  1.114472283731185e-13,
  2.531218295259140e-16, -3.712424696564957e-19, -4.564132188385185e-21, -1.269816903132860e-23,  1.235917610439466e-26,  2.258503160612768e-28,  1.760606220420148e+00,
 -1.294686755816108e-03, -4.305829269736834e-06, -8.440915510730467e-09,  2.331711908825864e-12,  9.018234732532909e-14,  3.399791497235020e-16,  3.530902924496436e-19,
 -2.744056123702852e-21, -1.644350071232780e-23, -3.471394026289182e-26,  7.582405827239630e-29,  1.808712003064348e+00, -1.077114720622400e-03, -3.905324370365251e-06,
 -9.524285847802268e-09, -8.598831174899959e-12,  5.382805367076073e-14,  3.326365672994585e-16,  8.951171912212930e-19,  6.316694168118904e-23, -1.131431088634563e-23,
 -5.541514080501458e-26, -1.136258145216412e-28,  1.852461071992834e+00, -8.614253104546101e-04, -3.366585809840095e-06, -9.679514640302852e-09, -1.711539452739136e-11,
  1.119034049869808e-14,  2.359309650803631e-16,  1.044418898697841e-18,  2.419719953037195e-21, -8.673844871268677e-25, -3.665974789942605e-26, -1.825128057776679e-28,
  1.891349342466417e+00, -6.549137212053873e-04, -2.729209509469792e-06, -8.913970386860942e-09, -2.179366653768612e-11, -2.667109961107563e-14,  8.851184261915325e-17,
  7.719872192369841e-19,  3.137837598964415e-21,  7.685346741391389e-24,  2.365781209037588e-27, -8.933197723365805e-29,  1.924900147909107e+00, -4.651869051335037e-04,
 -2.045522251969428e-06, -7.378142604208008e-09, -2.202527000236724e-11, -5.001110212745394e-14, -5.093856992389354e-17,  2.613275626077807e-19,  2.090415324237491e-21,
  9.025356888839199e-24,  2.710788566252286e-26,  4.540852086952524e-29,  1.952679242271194e+00, -2.997584903500415e-04, -1.376551931162167e-06, -5.357971192957345e-09,
 -1.828244106379153e-11, -5.412221133386443e-14, -1.302756763534278e-16, -1.919832081795125e-19,  3.059776480275999e-22,  4.091373640282914e-24,  2.147570192396437e-26,
  8.286670856146538e-29,  1.974310113408557e+00, -1.655840024164468e-04, -7.860332298732191e-07, -3.235933132141311e-09, -1.208820917305609e-11, -4.150356583427562e-14,
 -1.303967751413474e-16, -3.661557188093552e-19, -8.594133886978720e-22, -1.298922914522995e-24,  1.630324371141393e-27,  2.561221814411573e-29,  1.989488737641513e+00,
 -6.857703660508060e-05, -3.330982877724999e-07, -1.424204033161554e-09, -5.638434249823996e-12, -2.110179672802016e-14, -7.532758393982827e-17, -2.572016583778670e-19,
 -8.385238265221356e-22, -2.592826054559951e-24, -7.495343211825952e-27, -1.964434466232349e-29,  1.997998852668450e+00, -1.314464965532982e-05, -6.466756603169348e-08,
 -2.822861175592776e-10, -1.152636388689661e-12, -4.506096896426794e-15, -1.707286217421173e-17, -6.313585850903375e-20, -2.288739881814027e-22, -8.155713667060499e-25,
 -2.861705465125718e-27, -9.897497532312757e-30,  3.315458925982797e-04, -1.358667789555632e-06,  4.175239476523280e-09, -1.140340485550536e-11,  2.919134472988199e-14,
 -7.172152825606677e-17,  1.712602626576288e-19, -4.004879701151071e-22,  9.214382113105700e-25, -2.093265198991551e-27,  4.704417581343193e-30, -1.048337997318413e-32,
  2.983609637242941e-03, -1.221679193931681e-05,  3.747500489439508e-08, -1.020293212940018e-10,  2.599132624598097e-13, -6.341580533914175e-16,  1.500017380523675e-18,
 -3.464652988624666e-21,  7.847095116628887e-24, -1.748136665923149e-26,  3.835769040909536e-29, -8.304003816570279e-32,  8.286113516424658e-03, -3.387313641572002e-05,
  1.035299095675330e-07, -2.800829760430490e-10,  7.064726275878934e-13, -1.699268556931126e-15,  3.941148981909467e-18, -8.867714651356247e-21,  1.940981873464199e-23,
 -4.138076358759094e-26,  8.582815225768324e-29, -1.729062722842126e-31,  1.623578383859749e-02, -6.620754046798055e-05,  2.012515697530040e-07, -5.392108451235227e-10,
  1.339561806579816e-12, -3.150849783958986e-15,  7.080997017399065e-18, -1.525362540031754e-20,  3.145047936126345e-23, -6.173392840756783e-26,  1.138589818528618e-28,
 -1.924765849084021e-31,  2.682764350270460e-02, -1.090388810733205e-04,  3.290096920777206e-07, -8.699907905057827e-10,  2.116374603497705e-12, -4.822845997642181e-15,
  1.034603388700346e-17, -2.081753471463436e-20,  3.872823633831913e-23, -6.442321810238578e-26,  8.721743571921351e-29, -6.111825333705175e-32,  4.005493103705877e-02,
 -1.621240172850733e-04,  4.846351258056702e-07, -1.260064820276042e-09,  2.981997645746181e-12, -6.509087619350348e-15,  1.305692673003460e-17, -2.356131045368229e-20,
  3.598776988899433e-23, -3.729653055360062e-26, -1.741654928081845e-29,  2.507322029403555e-31,  5.590899082703836e-02, -2.251563876895710e-04,  6.654244653097366e-07,
 -1.694321053625515e-09,  3.871272556887268e-12, -7.975993621497340e-15,  1.449674480590377e-17, -2.160188208205698e-20,  1.917199852575313e-23,  2.562156462630344e-26,
 -1.985379416616874e-28,  6.872954684516231e-31,  7.437913293529848e-02, -2.977642665261096e-04,  8.681466797732761e-07, -2.155129086860082e-09,  4.711131862967330e-12,
 -8.977965061021686e-15,  1.398986135528844e-17, -1.350522384183936e-20, -1.338581645398329e-23,  1.205802382371656e-25, -4.216053193380051e-28,  1.097303384696124e-30,
  9.545246047844766e-02, -3.795086870889381e-04,  1.089052391921795e-06, -2.622633925692758e-09,  5.423408293521375e-12, -9.275090900049319e-15,  1.098710464786947e-17,
  1.387071388749981e-21, -5.997911734490309e-23,  2.320909793294398e-25, -6.188965597594216e-28,  1.258302703858942e-30,  1.191136620577871e-01, -4.698810453442970e-04,
  1.323886589399214e-06, -3.075114531742986e-09,  5.928110841461657e-12, -8.652655967199884e-15,  5.151661844351600e-18,  2.267654193707052e-20, -1.149504429142557e-22,
  3.332385859074414e-25, -6.996888321900380e-28,  9.380755424612996e-31,  1.453447662441547e-01, -5.683004026473595e-04,  1.567905734513198e-06, -3.489413773827951e-09,
  6.147150711214923e-12, -6.941780434002767e-15, -3.560836694386732e-18,  4.871311833523267e-20, -1.687035736601530e-22,  3.888640495965450e-25, -5.711537155759817e-28,
 -1.476006948793868e-32,  1.741248545842483e-01, -6.741105145052708e-04,  1.815900443401036e-06, -3.841447099700773e-09,  6.008485023593684e-12, -4.040327612559866e-15,
 -1.483566811905756e-17,  7.652896344517378e-20, -2.084535373240959e-22,  3.617794691303534e-25, -1.678378567512393e-28, -1.570880721614265e-30,  2.054297290251908e-01,
 -7.865766230787409e-04,  2.062225136485802e-06, -4.106797442257150e-09,  5.450624604786178e-12,  6.700851176436575e-17, -2.795433275456991e-17,  1.019404186923459e-19,
 -2.197968397825767e-22,  2.216338638728741e-25,  5.153177636296953e-28, -3.441862114829444e-30,  2.392315290443696e-01, -9.048820652472724e-04,  2.300836319548248e-06,
 -4.261403596166654e-09,  4.427422965184024e-12,  5.290779997075332e-15, -4.178100570278995e-17,  1.198503737442576e-19, -1.890852164408918e-22, -4.461797438274718e-26,
  1.394332450508949e-27, -5.060301911072584e-30,  2.754982931240275e-01, -1.028124766433841e-03,  2.525341438135107e-06, -4.282348345354789e-09,  2.913025184379338e-12,
  1.142264697155689e-14, -5.478945755777017e-17,  1.247700931843820e-19, -1.064524490255973e-22, -4.224225204498919e-25,  2.281975802770861e-27, -5.653339761824456e-30,
  3.141934585295906e-01, -1.155313714020675e-03,  2.729060553777872e-06, -4.148750724419469e-09,  9.068064090746980e-13,  1.812692828905614e-14, -6.513918412938337e-17,
  1.115587527343259e-19,  3.082131592917849e-23, -8.619773313810601e-25,  2.898617574364876e-27, -4.430051375425373e-30,  3.552752926473443e-01, -1.285365534314305e-03,
  2.905103410670041e-06, -3.842763617676624e-09, -1.561931161314712e-12,  2.494000345971500e-14, -7.080778306006619e-17,  7.634948170538195e-20,  2.151089085914375e-22,
 -1.276172042957115e-24,  2.916742128365307e-27, -8.741880613308018e-31,  3.986962484281220e-01, -1.417101335077497e-03,  3.046464781706938e-06, -3.350673010452444e-09,
 -4.429807179661631e-12,  3.127992091405701e-14, -6.978337966728944e-17,  1.759208095448404e-20,  4.260844801203860e-22, -1.547122358516047e-24,  2.042189127552749e-27,
  4.909041797720201e-30,  4.444022357966237e-01, -1.549244023302797e-03,  3.146141279610145e-06, -2.664088085918884e-09, -7.596147447884381e-12,  3.646862845497486e-14,
 -6.031566409844142e-17, -6.290436851943501e-20,  6.300523424498633e-22, -1.543656858821606e-24,  1.255602498564917e-28,  1.189374747644083e-29,  4.923318002621572e-01,
 -1.680416367028383e-03,  3.197273055839843e-06, -1.781201391300315e-09, -1.092118759030282e-11,  3.976908062862119e-14, -4.121639819093074e-17, -1.590979629639754e-19,
  7.818417431867104e-22, -1.150505615520510e-24, -2.716138059816653e-27,  1.802731952842641e-29,  5.424151994662403e-01, -1.809140142614853e-03,  3.193313933079754e-06,
 -7.080847892020272e-10, -1.422627832505639e-11,  4.043897508362120e-14, -1.218974751415357e-17, -2.602292970983815e-19,  8.300428692424738e-22, -3.071602354388525e-25,
 -6.002797481543639e-27,  2.047876488698609e-29,  5.945733681110974e-01, -1.933836797070489e-03,  3.128233448539026e-06,  5.400308533207016e-10, -1.729676630059939e-11,
  3.780187651526562e-14,  2.584053630424049e-17, -3.509836605191057e-19,  7.260010937201533e-22,  9.495652342209877e-25, -8.867699881002786e-27,  1.636110341219131e-29,
  6.487167617495256e-01, -2.052830160615467e-03,  2.996753916598126e-06,  1.937566949140470e-09, -1.988829288695063e-11,  3.133483030151128e-14,  7.045565563079448e-17,
 -4.125665283713619e-19,  4.362995176949379e-22,  2.449938768690668e-24, -1.015964582457230e-26,  3.921680971846956e-30,  7.047440704432893e-01, -2.164351869062522e-03,
  2.794624803015301e-06,  3.447602128474047e-09, -2.173727271082827e-11,  2.076907274832452e-14,  1.175829287324498e-16, -4.249139894636246e-19, -4.260188820565357e-23,
  3.877768544763630e-24, -8.709682495508588e-27, -1.602655832253662e-29,  7.625407945321457e-01, -2.266550299014290e-03,  2.518935244732937e-06,  5.021206665352603e-09,
 -2.257624721339640e-11,  6.196972015739007e-15,  1.615325278242927e-16, -3.701338046665279e-19, -6.702995547915713e-22,  4.796307862440587e-24, -3.761285316478259e-27,
 -3.894600087641823e-29,  8.219776769864720e-01, -2.357503979625978e-03,  2.168463202014769e-06,  6.597279509238030e-09, -2.215460631782706e-11, -1.182614790637349e-14,
  1.953155624329000e-16, -2.370381916024038e-19, -1.353218386067909e-21,  4.728519499393856e-24,  4.508382783116573e-27, -5.645582060117193e-29,  8.829089904157740e-01,
 -2.435240617822959e-03,  1.744056192030811e-06,  8.103099812468016e-09, -2.026477093114388e-11, -3.220194948495327e-14,  2.113215768771863e-16, -2.626998023813993e-20,
 -1.945734510362901e-21,  3.296274781514679e-24,  1.454349082928062e-26, -5.806863232936197e-29,  9.451706822451084e-01, -2.497763049459882e-03,  1.249033479932177e-06,
  9.455840085631099e-09, -1.677325939545403e-11, -5.325299234687393e-14,  2.024019095970404e-16,  2.449471989912693e-19, -2.267389022961979e-21,  4.025576679243124e-25,
  2.329854999682353e-26, -3.520149309227585e-29,  1.008578389434260e+00, -2.543083589617545e-03,  6.895926353927144e-07,  1.056531136122096e-08, -1.165505379660902e-11,
 -7.275746974036722e-14,  1.633395599307393e-16,  5.399176463448216e-19, -2.140158130575711e-21, -3.589303130735132e-24,  2.674905657147461e-26,  1.314073296692455e-29,
  1.072925345095637e+00, -2.569268373223803e-03,  7.519418777592466e-08,  1.133820898851955e-08, -5.028294433616321e-12, -8.808345398768791e-14,  9.257828295440685e-17,
  8.033263688285586e-19, -1.444943939069863e-21, -7.758313749998732e-24,  2.120313077645619e-26,  7.518570253706678e-29,  1.137980214258421e+00, -2.574493310458527e-03,
 -5.811134206513984e-07,  1.168408244220925e-08,  2.815415262203133e-12, -9.644750251945013e-14, -6.066121232908609e-18,  9.677524339953596e-19, -1.881008029351278e-22,
 -1.070968985779930e-23,  5.277780015405645e-27,  1.254226522425175e-28,  1.203484915670937e+00, -2.557113169888681e-03, -1.262480087665915e-06,  1.152313974713226e-08,
  1.139176949068607e-11, -9.530941184148578e-14, -1.221633833601858e-16,  9.670713960003493e-19,  1.442192372795553e-21, -1.092238176326212e-23, -1.811440871133938e-26,
  1.317555094424201e-28,  1.269152511727099e+00, -2.515744964538822e-03, -1.948218088170614e-06,  1.079578886570904e-08,  2.002408609539387e-11, -8.288897491857406e-14,
 -2.384987820378786e-16,  7.562225436292625e-19,  3.060123012836453e-21, -7.362202117173381e-24, -4.097009162516670e-26,  7.196511577820957e-29,  1.334665279926950e+00,
 -2.449366148277700e-03, -2.614025144126656e-06,  9.473487878900240e-09,  2.787275607510004e-11, -5.874966763156968e-14, -3.326277029221313e-16,  3.338709537806117e-19,
  4.140123552911981e-21, -2.086233351667187e-25, -5.196974871753185e-26, -4.577072185415017e-29,  1.399673116829977e+00, -2.357427009645473e-03, -3.232558869648574e-06,
  7.570007652102262e-09,  3.400270980393148e-11, -2.434034176354032e-14, -3.806356603332133e-16, -2.392111704498397e-19,  4.167715847533900e-21,  8.646920812311968e-24,
 -4.146091729660662e-26, -1.715792229005014e-28,  1.463792468442521e+00, -2.239974949692538e-03, -3.774457477211738e-06,  5.151618188406564e-09,  3.749417508539460e-11,
  1.667078477310746e-14, -3.630750452178735e-16, -8.363081723996887e-19,  2.865093564559073e-21,  1.578946442007462e-23, -8.321726977352668e-27, -2.282306824054182e-28,
  1.526606027186805e+00, -2.097785943464036e-03, -4.209888687825447e-06,  2.344059261638386e-09,  3.759420278574704e-11,  5.847386742809918e-14, -2.721519771129267e-16,
 -1.285754997679852e-18,  4.154292881310709e-22,  1.748409196671485e-23,  3.524307414556559e-26, -1.569766185676571e-28,  1.587663480753171e+00, -1.932495374240960e-03,
 -4.510671873180628e-06, -6.664061326882936e-10,  3.389382748946607e-11,  9.379737279867525e-14, -1.180847032318007e-16, -1.421097527710705e-18, -2.444236586226013e-21,
  1.171322423994098e-23,  6.622498429730371e-26,  2.609030663435179e-29,  1.646483635239285e+00, -1.746716697281926e-03, -4.652949023218168e-06, -3.640784050488192e-09,
  2.649925714225190e-11,  1.152768084295853e-13,  6.841452055770734e-17, -1.151361490645537e-18, -4.595130786744501e-21,  7.486938400117935e-26,  6.315366580826658e-26,
  2.117334665889598e-28,  1.702558253842511e+00, -1.544132365356075e-03, -4.620272637959877e-06, -6.306472616250507e-09,  1.614882106081435e-11,  1.173804924217789e-13,
  2.406143824767948e-16, -5.244933883360730e-19, -5.009880645509799e-21, -1.199496110561152e-23,  2.304784488373419e-26,  2.596814837855641e-28,  1.755357939698739e+00,
 -1.329537779719468e-03, -4.406835446361820e-06, -8.388732436001323e-09,  4.217701023694591e-12,  9.845000636698465e-14,  3.485454792391944e-16,  2.555483000302364e-19,
 -3.360101180091240e-21, -1.775305317368360e-23, -3.044804235643869e-26,  1.191575912139962e-28,  1.804340331955730e+00, -1.108816735509051e-03, -4.020404333476531e-06,
 -9.652812379276492e-09, -7.440407672634474e-12,  6.211192718131969e-14,  3.576638087402609e-16,  8.901841199132723e-19, -3.852189313804034e-22, -1.362716614302963e-23,
 -6.012154234306201e-26, -9.903705052378934e-29,  1.848960763187638e+00, -8.888272499652510e-04, -3.484374653655874e-06, -9.951252744469617e-09, -1.683255048457038e-11,
  1.721231875071414e-14,  2.662519238438563e-16,  1.121051211541690e-18,  2.360104270631175e-21, -2.500906710789531e-24, -4.517647185570619e-26, -2.044767585341859e-28,
  1.888685334346467e+00, -6.771812354898847e-04, -2.838286554571964e-06, -9.266813451226625e-09, -2.230403509418452e-11, -2.427582516253160e-14,  1.115749124542399e-16,
  8.768348823467230e-19,  3.415193449353306e-21,  7.693310265202078e-24, -2.175785409926461e-27, -1.179218472888353e-28,  1.923006102635250e+00, -4.819113013032112e-04,
 -2.136207604498506e-06, -7.738612496729986e-09, -2.303708424356483e-11, -5.113795500600844e-14, -4.263453261378034e-17,  3.336325584130624e-19,  2.435314774672980e-21,
  1.014820532183056e-23,  2.899353348980740e-26,  3.976460220483413e-29,  1.951457769142765e+00, -3.110331446190137e-04, -1.442638975705741e-06, -5.659321489245307e-09,
 -1.939658055290985e-11, -5.731208530568665e-14, -1.354907613058075e-16, -1.796621545731964e-19,  4.696408882600086e-22,  5.026918300652150e-24,  2.539266516328763e-26,
  9.537862646423379e-29,  1.973634950209837e+00, -1.720309452463469e-04, -8.260528483491885e-07, -3.436158629099392e-09, -1.295042239919253e-11, -4.475926709847497e-14,
 -1.410410791128786e-16, -3.943902088773080e-19, -9.047096423312485e-22, -1.209000878032853e-24,  2.922530094298275e-27,  3.340990505676745e-29,  1.989208989474716e+00,
 -7.131175108025647e-05, -3.507442780520780e-07, -1.517896000040664e-09, -6.079148181888550e-12, -2.299919896103097e-14, -8.291934394054035e-17, -2.855874802995847e-19,
 -9.374761520353196e-22, -2.910547261552557e-24, -8.406313950362797e-27, -2.178540479171092e-29,  1.997945217483198e+00, -1.367586043127827e-05, -6.816870035434815e-08,
 -3.014721545923735e-10, -1.247003400933096e-12, -4.937914786059426e-15, -1.894777821749137e-17, -7.095256886483278e-20, -2.604044422846258e-22, -9.392482978724056e-25,
 -3.335035889542672e-27, -1.166887441186054e-29,  3.261771696804639e-04, -1.325805404715238e-06,  4.041154364270876e-09, -1.094759921454526e-11,  2.779712525010056e-14,
 -6.774258234357095e-17,  1.604483288618952e-19, -3.721722330334553e-22,  8.493595915002473e-25, -1.913995731098432e-27,  4.266710852997254e-30, -9.432113179337105e-33,
  2.935334413887217e-03, -1.192181956255017e-05,  3.627519241491170e-08, -9.797025084086363e-11,  2.475823919472375e-13, -5.992939556544690e-16,  1.406430056836530e-18,
 -3.223326090371420e-21,  7.244525200696711e-24, -1.601769748352679e-26,  3.488446754932922e-29, -7.497903024976221e-32,  8.152256430930389e-03, -3.305815151138797e-05,
  1.002356301297653e-07, -2.690462408877961e-10,  6.734133772027519e-13, -1.607591700747357e-15,  3.701329256941148e-18, -8.269787779695492e-21,  1.798011643193332e-23,
 -3.809515818320926e-26,  7.856415222719038e-29, -1.575216552963355e-31,  1.597413322996952e-02, -6.462305039972525e-05,  1.949075875023187e-07, -5.182729017580331e-10,
  1.278210234107990e-12, -2.985919371239787e-15,  6.667657388929073e-18, -1.428190614331074e-20,  2.930803094891122e-23, -5.734505254527773e-26,  1.056799481562468e-28,
 -1.794144821400607e-31,  2.639668681731657e-02, -1.064479946847990e-04,  3.187698346413757e-07, -8.368871566718888e-10,  2.022354232255811e-12, -4.581397953749438e-15,
  9.780149275772920e-18, -1.961467099337509e-20,  3.647112989008131e-23, -6.099036590611623e-26,  8.437809512373176e-29, -6.758874619043150e-32,  3.941409449718591e-02,
 -1.583066180709406e-04,  4.697963782837034e-07, -1.213377507709130e-09,  2.854896785981260e-12, -6.203509091285240e-15,  1.241312987191312e-17, -2.243129828306851e-20,
  3.463509438605575e-23, -3.778555307548823e-26, -7.344790949615128e-30,  2.081259826244854e-31,  5.501888477006320e-02, -2.199132783932414e-04,  6.454590513512686e-07,
 -1.633638152331807e-09,  3.715183271850188e-12, -7.635259853674447e-15,  1.390060923443325e-17, -2.097509519026354e-20,  1.995848509260858e-23,  1.825968830104741e-26,
 -1.701614170240086e-28,  6.041387746743371e-31,  7.320180421749112e-02, -2.909212713848524e-04,  8.427315326727497e-07, -2.081169338073476e-09,  4.534899265074611e-12,
 -8.646790649900271e-15,  1.360634815462702e-17, -1.386727801330592e-20, -9.337137340308569e-24,  1.046499881477716e-25, -3.756750733718671e-28,  9.918669004354344e-31,
  9.395165331230312e-02, -3.709206932199466e-04,  1.058095356886095e-06, -2.537329070955830e-09,  5.240545437771521e-12, -9.011143664893781e-15,  1.100029463453940e-17,
 -4.032470122490257e-22, -5.205632712330324e-23,  2.084179877978237e-25, -5.653567009512036e-28,  1.175436538805759e-30,  1.172550886122468e-01, -4.594359587878283e-04,
  1.287548625238926e-06, -2.981642256924764e-09,  5.756343449505287e-12, -8.521801531915572e-15,  5.736872664888792e-18,  1.918475247550136e-20, -1.034476609722754e-22,
  3.060786803667156e-25, -6.582804009970045e-28,  9.417046111800280e-31,  1.430963882764299e-01, -5.559229871868194e-04,  1.526618300320542e-06, -3.392174237711187e-09,
  6.007567884664639e-12, -7.011470161476974e-15, -2.270375479226433e-18,  4.353418196902839e-20, -1.551154205191820e-22,  3.660521531718907e-25, -5.683329668363678e-28,
  1.374656265985641e-31,  1.714571772823495e-01, -6.597660723743449e-04,  1.770377165443166e-06, -3.745976422304294e-09,  5.924287633991477e-12, -4.371411699017774e-15,
 -1.278429636771746e-17,  7.006541039676151e-20, -1.955660569434139e-22,  3.537839860819152e-25, -2.295368446788176e-28, -1.241365503502038e-30,  2.023161081113356e-01,
 -7.702744658244062e-04,  2.013466755904753e-06, -4.019612223399163e-09,  5.445482860246398e-12, -5.704307715538062e-16, -2.519724384366364e-17,  9.503827145998584e-20,
 -2.114821996445636e-22,  2.393587609570285e-25,  3.743376700371775e-28, -2.973579605972301e-30,  2.356484920081141e-01, -8.866787101108243e-04,  2.250127827518637e-06,
 -4.189771657696498e-09,  4.523479405849194e-12,  4.327620743692306e-15, -3.851007262387916e-17,  1.137842841212399e-19, -1.897399086461265e-22,  6.844284846456023e-27,
  1.182269823293486e-27, -4.581324360780946e-30,  2.714258752037431e-01, -1.008126778402371e-03,  2.474240219153351e-06, -4.233982583629873e-09,  3.128609585812388e-12,
  1.014922437584321e-14, -5.134574899187400e-17,  1.211374343809535e-19, -1.200758765455429e-22, -3.360399549042885e-25,  2.039174354382344e-27, -5.375978033462059e-30,
  3.096155537211646e-01, -1.133680095967529e-03,  2.679374290030774e-06, -4.131425391159115e-09,  1.253965043114519e-12,  1.660115517846452e-14, -6.200623881164523e-17,
  1.120705282062210e-19,  1.829599349103628e-24, -7.499909822312635e-25,  2.699432038749468e-27, -4.604459382276000e-30,  3.501800195640699e-01, -1.262309547215284e-03,
  2.858856465195163e-06, -3.863855708747787e-09, -1.079947956689314e-12,  2.326700627824520e-14, -6.858037539936108e-17,  8.252031815478191e-20,  1.712551504676746e-22,
 -1.160527041855775e-24,  2.859514368227097e-27, -1.697390428696517e-30,  3.930763302340660e-01, -1.392891607080679e-03,  3.005851794597975e-06, -3.416635940965365e-09,
 -3.820909127294846e-12,  2.961252057285809e-14, -6.910817386563653e-17,  3.035180261567288e-20,  3.719063520225768e-22, -1.461568460374282e-24,  2.224621757263835e-27,
  3.414631772189986e-30,  4.382553926487072e-01, -1.524204780527634e-03,  3.113466805406506e-06, -2.779870674676187e-09, -6.881381748548530e-12,  3.500214362922989e-14,
 -6.180306456640121e-17, -4.362988100627651e-20,  5.746920498299660e-22, -1.528734340130848e-24,  6.067378710809705e-28,  9.995606202201618e-30,  4.856611516771437e-01,
 -1.654926590718969e-03,  3.174876274613622e-06, -1.949632550274107e-09, -1.013604430142657e-11,  3.872921831400778e-14, -4.532724324336781e-17, -1.347611648254011e-19,
  7.386546140669592e-22, -1.243779251964771e-24, -1.959882665547032e-27,  1.633411537939635e-29,  5.352296727222702e-01, -1.783631427415911e-03,  3.183477824484775e-06,
 -9.292533253507197e-10, -1.342099910024342e-11,  4.006197370375498e-14, -1.910629120725443e-17, -2.338894375309466e-19,  8.148788681382692e-22, -5.294069674286261e-25,
 -5.114042993083099e-27,  1.986159948778702e-29,  5.868881071343894e-01, -1.908789655060274e-03,  3.133078378587688e-06,  2.693612950599384e-10, -1.653530937977785e-11,
  3.830677327074009e-14,  1.634290155772858e-17, -3.272716995349207e-19,  7.539782410814425e-22,  6.096912789997169e-25, -8.116274681359845e-27,  1.769704614762649e-29,
  6.405535288512363e-01, -2.028768487478327e-03,  3.018116411802223e-06,  1.624455811739214e-09, -1.924561413524818e-11,  3.288880004244700e-14,  5.911195720120512e-17,
 -3.972718042150033e-19,  5.172345187347841e-22,  2.048154978251149e-24, -9.902249303640942e-27,  7.669107352760994e-30,  6.961316306773881e-01, -2.141835265729346e-03,
  2.833923443579078e-06,  3.103278098554976e-09, -2.129463531552733e-11,  2.344826444291889e-14,  1.056867510017565e-16, -4.241121703239951e-19,  9.057248981692388e-23,
  3.516988629760099e-24, -9.287696969631582e-27, -1.031439464946724e-29,  7.535152692565530e-01, -2.246163929105495e-03,  2.577027167571153e-06,  4.661185298628624e-09,
 -2.241439128344584e-11,  9.947122347132761e-15,  1.508942187887453e-16, -3.888530017231508e-19, -5.007376861417216e-22,  4.613333143876526e-24, -5.343739146926567e-27,
 -3.294774425495955e-29,  8.125828493434448e-01, -2.339845646978921e-03,  2.245496727301088e-06,  6.241165973368250e-09, -2.234481576092832e-11, -7.222954063520684e-15,
  1.880980622487612e-16, -2.775875513307308e-19, -1.180335770213160e-21,  4.860126924879312e-24,  2.097555900728942e-27, -5.294908334452554e-29,  8.731965408351888e-01,
 -2.420904778671804e-03,  1.839327610121808e-06,  7.773986353759090e-09, -2.085818820508726e-11, -2.714598059245670e-14,  2.097329391087800e-16, -8.652759790324652e-20,
 -1.817219871776263e-21,  3.826191927481913e-24,  1.193772792461964e-26, -6.008020643488874e-29,  9.352003266813170e-01, -2.487321542841690e-03,  1.360859042045480e-06,
  9.179213573242531e-09, -1.778922953681488e-11, -4.832122339335437e-14,  2.082480834806078e-16,  1.727992857766556e-19, -2.236521426429895e-21,  1.300674459681940e-24,
  2.154001739769133e-26, -4.443532166270728e-29,  9.984178869020462e-01, -2.537062992946290e-03,  8.152101702851457e-07,  1.036740729943240e-08, -1.306981763877399e-11,
 -6.866375877324167e-14,  1.774805153758239e-16,  4.695725128671419e-19, -2.250015153265519e-21, -2.512246576792721e-24,  2.699431889519715e-26, -1.879466169583130e-30,
  1.062650334307279e+00, -2.568124086451185e-03,  2.107122560063086e-07,  1.124379119744305e-08, -6.765950857685705e-12, -8.559713451900669e-14,  1.143833016286152e-16,
  7.527892734247895e-19, -1.708219330851743e-21, -6.848398177757773e-24,  2.418173886529594e-26,  5.996750569116703e-29,  1.127673832079952e+00, -2.578580762679483e-03,
 -4.406978073208805e-07,  1.171369877199946e-08,  8.871991844349140e-13, -9.626895930863602e-14,  2.088906944880426e-17,  9.556158670978487e-19, -5.685349761645338e-22,
 -1.038994177821154e-23,  1.066007714338556e-26,  1.186250855786148e-28,  1.193237143250792e+00, -2.566656947180047e-03, -1.123172195688098e-06,  1.169000854767989e-08,
  9.458480752413615e-12, -9.791155012299588e-14, -9.449932442922712e-17,  1.006801943864123e-18,  1.037369582328130e-21, -1.152797767609495e-23, -1.209801350409050e-26,
  1.410002339414013e-28,  1.259059188380126e+00, -2.530807192802478e-03, -1.816802003516215e-06,  1.110260839990852e-08,  1.831083810975841e-11, -8.834804555031692e-14,
 -2.159956767522848e-16,  8.495962260285697e-19,  2.766419709236558e-21, -8.929872281339523e-24, -3.722406123209857e-26,  9.794661668043043e-29,  1.324826721498487e+00,
 -2.469816132723517e-03, -2.497707675464149e-06,  9.909621730317130e-09,  2.661876658174637e-11, -6.660560254555227e-14, -3.214285504559416e-16,  4.658301469367804e-19,
  4.094793767607693e-21, -2.318403566272974e-24, -5.328477285676268e-26, -1.359380812458001e-29,  1.390192276174250e+00, -2.382914911730551e-03, -3.138472195674619e-06,
  8.109658202794879e-09,  3.342408694324556e-11, -3.354062627699702e-14, -3.854220053838508e-16, -1.011981896838353e-19,  4.447378763569420e-21,  6.842541014185690e-24,
 -4.862069224115269e-26, -1.527208503669386e-28,  1.454772583274347e+00, -2.269913111196691e-03, -3.709029170344427e-06,  5.753711096915213e-09,  3.773861178477026e-11,
  7.686866753203122e-15, -3.851232325572524e-16, -7.356145776794020e-19,  3.425065837757916e-21,  1.525182647565160e-23, -1.864464236489723e-26, -2.398091570409396e-28,
  1.518147717892824e+00, -2.131342225984950e-03, -4.178113523399360e-06,  2.954555233000253e-09,  3.869545783330340e-11,  5.151229946063178e-14, -3.078705228919361e-16,
 -1.262132589242486e-18,  1.068455720360175e-21,  1.874346578652584e-23,  2.742563755694514e-26, -1.981327959993998e-28,  1.579861291061227e+00, -1.968603376095899e-03,
 -4.515353569194761e-06, -1.092649783531434e-10,  3.573816760967767e-11,  9.047742074130682e-14, -1.589034057133484e-16, -1.492053537166242e-18, -1.974717788949463e-21,
  1.437235221457366e-23,  6.640139874067492e-26, -1.920710909666808e-29,  1.639422054973590e+00, -1.784107663559427e-03, -4.694018162130300e-06, -3.198273694024259e-09,
  2.881851570960660e-11,  1.165153038383314e-13,  3.412176601498251e-17, -1.297856974444775e-18, -4.544749704770908e-21,  2.783898242180057e-24,  7.219463379900648e-26,
  1.975510942399901e-28,  1.696307327165874e+00, -1.581392684235303e-03, -4.694321549491622e-06, -6.029002163478038e-09,  1.855289351721051e-11,  1.229605000192099e-13,
  2.236206251327547e-16, -6.915178216797376e-19, -5.422265278286866e-21, -1.083514989015443e-23,  3.516796696338446e-26,  2.905725063218876e-28,  1.749968643489679e+00,
 -1.365193822624562e-03, -4.507028880930818e-06, -8.305040508716684e-09,  6.270866320331918e-12,  1.068882132995621e-13,  3.540978144407122e-16,  1.375753397938412e-19,
 -4.019741855608826e-21, -1.885194012621730e-23, -2.413449097121747e-26,  1.688236039146515e-28,  1.799840002201841e+00, -1.141445231479747e-03, -4.136909833438414e-06,
 -9.761446156560736e-09, -6.110320060949606e-12,  7.099309741101073e-14,  3.823392790565275e-16,  8.695355579457368e-19, -9.200801155287414e-22, -1.611306881128786e-23,
 -6.400610617736001e-26, -7.601693016238009e-29,  1.845348941471811e+00, -9.171844573079487e-04, -3.605393097129710e-06, -1.021746156395876e-08, -1.642181739791052e-11,
  2.398747616521151e-14,  2.986825592973893e-16,  1.194767292597395e-18,  2.235319727703471e-21, -4.494090592427031e-24, -5.463212564734383e-26, -2.249649120235622e-28,
  1.885930483929656e+00, -7.003384375813000e-04, -2.951645030757690e-06, -9.627408078157442e-09, -2.276072005086767e-11, -2.129080635555402e-14,  1.376977507215214e-16,
  9.905249094960618e-19,  3.689249364021143e-21,  7.492960899584180e-24, -8.087440842719968e-27, -1.516690821763670e-28,  1.921043681024659e+00, -4.993787597004204e-04,
 -2.231316436615783e-06, -8.115440173842362e-09, -2.406927197981738e-11, -5.203993149636357e-14, -3.214526293391893e-17,  4.176351084108721e-19,  2.821925322000422e-21,
  1.134048189793956e-23,  3.055203014217080e-26,  3.037450539980924e-29,  1.950190116667648e+00, -3.228512679966610e-04, -1.512451308194049e-06, -5.979015069312356e-09,
 -2.057573800308286e-11, -6.062235740794935e-14, -1.402822505264174e-16, -1.615336664513213e-19,  6.699398637091996e-22,  6.130506460086840e-24,  2.988650088614553e-26,
  1.090731836307139e-28,  1.972933343371034e+00, -1.788078954100970e-04, -8.685601397241766e-07, -3.650714601747503e-09, -1.388036915183880e-11, -4.828007887288489e-14,
 -1.524956797051838e-16, -4.240117054188288e-19, -9.457507866513315e-22, -1.059991694732422e-24,  4.598645341476058e-27,  4.312589414637423e-29,  1.988918012820465e+00,
 -7.419225351600571e-05, -3.695581655789208e-07, -1.618953150653450e-09, -6.559698455057454e-12, -2.508870970655182e-14, -9.135200832233743e-17, -3.173300032791697e-19,
 -1.048545385748222e-21, -3.266628577794520e-24, -9.414213137691738e-27, -2.404487406930095e-29,  1.997889399941432e+00, -1.423602755203832e-05, -7.190941948241168e-08,
 -3.222396760945535e-10, -1.350475086305781e-12, -5.417475338043610e-15, -2.105638409658671e-17, -7.985330389997611e-20, -2.967477156504711e-22, -1.083513483133833e-24,
 -3.893612485964171e-27, -1.378292257164243e-29,  3.209377850539220e-04, -1.293994195372076e-06,  3.912407655800052e-09, -1.051347828772547e-11,  2.647995272241661e-14,
 -6.401386354619155e-17,  1.503978911116134e-19, -3.460630432565101e-22,  7.834303584173127e-25, -1.751343585643043e-27,  3.872730793934444e-30, -8.493551717727626e-33,
  2.888220186862070e-03, -1.163625415202262e-05,  3.512292763847279e-08, -9.410301583931324e-11,  2.359268787034670e-13, -5.665969989952648e-16,  1.319337669132781e-18,
 -3.000464490717637e-21,  6.692229826881024e-24, -1.468611548258342e-26,  3.174727187483092e-29, -6.775021842214446e-32,  8.021607402860759e-03, -3.226899993404175e-05,
  9.707067733488262e-08, -2.585240925660041e-10,  6.421314370437469e-13, -1.521474677017714e-15,  3.477628367175163e-18, -7.715773652876033e-21,  1.666362506184225e-23,
 -3.508700286809445e-26,  7.194529702444267e-29, -1.435584152756173e-31,  1.571872064594941e-02, -6.308832360858382e-05,  1.888090779541327e-07, -4.982907245676974e-10,
  1.220060232812298e-12, -2.830590215265279e-15,  6.280589391638409e-18, -1.337627927346698e-20,  2.731782977154918e-23, -5.327205239719149e-26,  9.806001368696346e-29,
 -1.670637407835247e-31,  2.597593232001389e-02, -1.039374633926221e-04,  3.089183518517493e-07, -8.052499436984966e-10,  1.933029695980862e-12, -4.353135026619195e-15,
  9.246952084322782e-18, -1.848207979558904e-20,  3.433549871629088e-23, -5.767617913770123e-26,  8.129837312072433e-29, -7.210736896573717e-32,  3.878829363424383e-02,
 -1.546057219583361e-04,  4.555058758216145e-07, -1.168675745175534e-09,  2.733755523061304e-12, -5.913006908576059e-15,  1.180036524300557e-17, -2.134477920874048e-20,
  3.327163055523709e-23, -3.790738599730726e-26,  9.862967957961496e-31,  1.714755801181360e-31,  5.414943625628874e-02, -2.148270215727083e-04,  6.262070700195920e-07,
 -1.575398933541510e-09,  3.565767024871733e-12, -7.308620132463196e-15,  1.332233772065548e-17, -2.032716909204100e-20,  2.049951875203988e-23,  1.196246391850828e-26,
 -1.452385625010801e-28,  5.301524746401113e-31,  7.205144639182233e-02, -2.842780947876044e-04,  8.181872011746182e-07, -2.009976826238617e-09,  4.365197364555819e-12,
 -8.324928083221271e-15,  1.321442750708397e-17, -1.410860461815629e-20, -5.829972437007701e-24,  9.046669153649950e-26, -3.341957770145321e-28,  8.949239476132555e-31,
  9.248470922255260e-02, -3.625763103356810e-04,  1.028144599488626e-06, -2.454907789691879e-09,  5.062960776652215e-12, -8.747453541088742e-15,  1.096677990337013e-17,
 -1.953265558151951e-21, -4.494809220269109e-23,  1.868139487936716e-25, -5.154400125502134e-28,  1.093790490412035e-30,  1.154377211437082e-01, -4.492771357924867e-04,
  1.252315927453634e-06, -2.890896593058257e-09,  5.587325888644874e-12, -8.378034576152891e-15,  6.229321917103836e-18,  1.604572766714572e-20, -9.289282065335295e-23,
  2.805742235623966e-25, -6.170117739062779e-28,  9.322301161874991e-31,  1.408968667080790e-01, -5.438712417638528e-04,  1.486484299933019e-06, -3.297177542843390e-09,
  5.866889479148051e-12, -7.051880565367251e-15, -1.118960219390432e-18,  3.877696115447419e-20, -1.423449374085083e-22,  3.434775687776550e-25, -5.595141239938563e-28,
  2.586521034442159e-31,  1.688461565993248e-01, -6.457812572624277e-04,  1.725991242648030e-06, -3.651903262304706e-09,  5.833946472194942e-12, -4.655388298442769e-15,
 -1.090817701774149e-17,  6.400920255165579e-20, -1.830074664815619e-22,  3.435970230956227e-25, -2.777377955541284e-28, -9.566037533366249e-31,  1.992669223152622e-01,
 -7.543581930686428e-04,  1.965753695100320e-06, -3.932607732655551e-09,  5.428238535056379e-12, -1.143988425068575e-15, -2.262960169925304e-17,  8.841135341631447e-20,
 -2.026261206363915e-22,  2.518436598515450e-25,  2.530008323058727e-28, -2.548812476527524e-30,  2.321374625355493e-01, -8.688775598867923e-04,  2.200287518142439e-06,
 -4.116752714129913e-09,  4.601043922313804e-12,  3.440924965048066e-15, -3.540901627729132e-17,  1.077252904313951e-19, -1.886896081448878e-22,  5.024077544027679e-26,
  9.909156837061002e-28, -4.119939238518231e-30,  2.674326353721478e-01, -9.885352218338384e-04,  2.423739259405595e-06, -4.182366763934422e-09,  3.319543543873498e-12,
  8.957183757058115e-15, -4.800940388755175e-17,  1.171167324131172e-19, -1.307613000732645e-22, -2.591137625501869e-25,  1.809418784094779e-27, -5.062655290997900e-30,
  3.051233898517413e-01, -1.112443044273832e-03,  2.629928263743851e-06, -4.108785555057943e-09,  1.571360756334570e-12,  1.515064354781276e-14, -5.887135703980941e-17,
  1.117175221689694e-19, -2.327556807148506e-23, -6.460924781316435e-25,  2.495006959327179e-27, -4.671519823128983e-30,  3.451762290568179e-01, -1.239624419524806e-03,
  2.812401590399260e-06, -3.877500787611879e-09, -6.308769256757299e-13,  2.164938553581340e-14, -6.619920847578740e-17,  8.735393633315045e-20,  1.315151514589041e-22,
 -1.047843957327507e-24,  2.769890493057247e-27, -2.349772599868051e-30,  3.875525963615040e-01, -1.369009786109267e-03,  2.964504609227230e-06, -3.473122288241791e-09,
 -3.245169093542026e-12,  2.796541942236047e-14, -6.809949532861921e-17,  4.142838631918383e-20,  3.209241754779159e-22, -1.369976769997886e-24,  2.345446489530020e-27,
  2.107946744304213e-30,  4.322081751523437e-01, -1.499432298934851e-03,  3.079470583974864e-06, -2.884453409487214e-09, -6.196260039298201e-12,  3.350623786242265e-14,
 -6.277547448699500e-17, -2.611477419800790e-20,  5.201955877998752e-22, -1.496201812835395e-24,  1.006924811163899e-27,  8.215984090636465e-30,  4.790920913474689e-01,
 -1.629623861410300e-03,  3.150532990188313e-06, -2.105672926299144e-09, -9.372630485295700e-12,  3.759871382009689e-14, -4.877646980492431e-17, -1.118543891689581e-19,
  6.926359895190210e-22, -1.308313183095023e-24, -1.279561957876022e-27,  1.458459118281776e-29,  5.281460069609489e-01, -1.758211798769913e-03,  3.171064722907778e-06,
 -1.137606483619485e-09, -1.262486044858013e-11,  3.952776348610373e-14, -2.529326652409231e-17, -2.081560379651165e-19,  7.923464495449286e-22, -7.167437433818213e-25,
 -4.259568617632161e-27,  1.893283903704170e-29,  5.793030919670279e-01, -1.883716537944077e-03,  3.134748667536334e-06,  1.094367351270721e-11, -1.576597970183285e-11,
  3.859178408104323e-14,  7.519938056931559e-18, -3.028543314846774e-19,  7.702735673815039e-22,  3.008804834529553e-25, -7.318623214012159e-27,  1.847272904348672e-29,
  6.324868608987549e-01, -2.004550766638855e-03,  3.035784248632064e-06,  1.321861528041675e-09, -1.857454233183280e-11,  3.417593942323107e-14,  4.823061145243706e-17,
 -3.796162895187939e-19,  5.839285943658708e-22,  1.659770180945790e-24, -9.494505969865960e-27,  1.075647932544668e-29,  6.876098601096573e-01, -2.119020676456064e-03,
  2.869134407032212e-06,  2.766449441158041e-09, -2.080126491316974e-11,  2.584268669327357e-14,  9.387070478405868e-17, -4.192605585103552e-19,  2.104020381291344e-22,
  3.137986682781247e-24, -9.624130249863491e-27, -5.061181200654763e-30,  7.445721916392904e-01, -2.225330055205523e-03,  2.630816801880410e-06,  4.304339611224021e-09,
 -2.218012485477997e-11,  1.343627023678258e-14,  1.398066616015099e-16, -4.022633095120871e-19, -3.388381958369518e-22,  4.372387818762481e-24, -6.658959534204265e-27,
 -2.683157653745410e-29,  8.032598604388869e-01, -2.321588184382425e-03,  2.318241636644061e-06,  5.882735811070207e-09, -2.244478224615538e-11, -2.805975946221342e-15,
  1.798232128100697e-16, -3.125471529399439e-19, -1.004411130261776e-21,  4.898687763381322e-24, -1.369286085168853e-28, -4.847888203310130e-29,  8.635429337235143e-01,
 -2.405822719362638e-03,  1.930596027332246e-06,  7.436184537033001e-09, -2.135100156467088e-11, -2.214790395276213e-14,  2.065173862447616e-16, -1.423877733363339e-19,
 -1.671520969782877e-21,  4.250625657639904e-24,  9.281889490824931e-27, -6.036680491618462e-29,  9.252735049491864e-01, -2.475998978600648e-03,  1.469270830667244e-06,
  8.887127560573167e-09, -1.870532414704160e-11, -4.327324697773849e-14,  2.120927038505878e-16,  1.021421124668468e-19, -2.174680787076995e-21,  2.120863960682501e-24,
  1.941577828905737e-26, -5.180418699570913e-29,  9.882834610614486e-01, -2.530047333867737e-03,  9.383197988418806e-07,  1.014753977335656e-08, -1.439947487588327e-11,
 -6.425466222013772e-14,  1.896084262448885e-16,  3.963329534485128e-19, -2.321078736108263e-21, -1.438361439098024e-24,  2.659712982021623e-26, -1.598851007971018e-29,
  1.052382061117303e+00, -2.565900655867761e-03,  3.449322274473717e-07,  1.112199665059541e-08, -8.448767094794187e-12, -8.260539601333783e-14,  1.346604149588453e-16,
  6.943731384085692e-19, -1.936758071366142e-21, -5.833109727576162e-24,  2.646348379617373e-26,  4.361125118100838e-29,  1.117353348253463e+00, -2.581543992385661e-03,
 -3.001116754540503e-07,  1.171252722088880e-08, -1.031011368146403e-12, -9.544893295190849e-14,  4.733602476627893e-17,  9.315304846512697e-19, -9.336646307290474e-22,
 -9.861931016229495e-24,  1.566568779449181e-26,  1.083661444203644e-28,  1.182953436582482e+00, -2.575078781206810e-03, -9.820490734113219e-07,  1.182556481188009e-08,
  7.479871086832137e-12, -9.983788383098712e-14, -6.590711288299701e-17,  1.033276503888189e-18,  6.151633589952485e-22, -1.188608414190397e-23, -5.772640664000930e-27,
  1.457578351544402e-28,  1.248907741427155e+00, -2.544803839157519e-03, -1.681872061810140e-06,  1.138117272823911e-08,  1.649401552219660e-11, -9.323678118750600e-14,
 -1.910179527418905e-16,  9.326995382039126e-19,  2.419246465624288e-21, -1.032556203411126e-23, -3.239084740152906e-26,  1.212144286186735e-28,  1.314908256860764e+00,
 -2.489314995920229e-03, -2.376282117764369e-06,  1.032445065634970e-08,  2.521064432412510e-11, -7.414865389731392e-14, -3.065663225963996e-16,  5.951162108590027e-19,
  3.972912267925392e-21, -4.451828736964160e-24, -5.313835602790819e-26,  2.045345169928989e-29,  1.380611030069737e+00, -2.407624388601211e-03, -3.037971351660204e-06,
  8.638573832090016e-09,  3.266062764749927e-11, -4.280846140364295e-14, -3.862288473673696e-16,  4.467115240279063e-20,  4.657147352452795e-21,  4.770382213110843e-24,
 -5.480066684165089e-26, -1.271129416271895e-28,  1.445634038147759e+00, -2.299298893136957e-03, -3.636358302462927e-06,  6.358249809669788e-09,  3.779831731028108e-11,
 -1.790370610763161e-15, -4.041046146705661e-16, -6.173921090388000e-19,  3.958147745070189e-21,  1.429328208737976e-23, -2.931060193348515e-26, -2.436416188476566e-28,
  1.509555738677636e+00, -2.164614714725358e-03, -4.138911431624500e-06,  3.581511125147766e-09,  3.964897501953285e-11,  4.370382451425383e-14, -3.426287203026292e-16,
 -1.216951797795135e-18,  1.760759447099648e-21,  1.965448146375535e-23,  1.784256358618080e-26, -2.368978569948420e-28,  1.571914637498589e+00, -2.004721592478398e-03,
 -4.513174880061595e-06,  4.768005541644695e-10,  3.750616042149598e-11,  8.615576478837509e-14, -2.014841542908999e-16, -1.546455942245821e-18, -1.409841611264570e-21,
  1.699672251057343e-23,  6.444069748103313e-26, -7.086741552931943e-29,  1.632210288260052e+00, -1.821805310027706e-03, -4.729553859188207e-06, -2.718503149150305e-09,
  3.115398300518692e-11,  1.168818254084342e-13, -4.235140432356845e-18, -1.441111469367373e-18, -4.390512273248004e-21,  5.839015468222304e-24,  8.037998311754184e-26,
  1.726505714980775e-28,  1.689906196453046e+00, -1.619231413587705e-03, -4.764806418018976e-06, -5.712197526420484e-09,  2.106410128183935e-11,  1.280750880375806e-13,
  2.017723943500816e-16, -8.709743638090239e-19, -5.783854673652006e-21, -9.164703481212950e-24,  4.854182757310310e-26,  3.162720412115032e-28,  1.744435127180009e+00,
 -1.401646824465375e-03, -4.606015319007288e-06, -8.187141749797864e-09,  8.493848277608928e-12,  1.154176173986463e-13,  3.560458133269691e-16, -2.085961396699549e-21,
 -4.713854223485017e-21, -1.965285354875167e-23, -1.550830153954479e-26,  2.241189204476517e-28,  1.795207286648716e+00, -1.175010610380309e-03, -4.254585285138654e-06,
 -9.847345600447331e-09, -4.596744112857262e-12,  8.045752324230899e-14,  4.061833166073206e-16,  8.303117172824258e-19, -1.546961080244965e-21, -1.873127466700812e-23,
 -6.666415096916749e-26, -4.303673528865850e-29,  1.841621734571296e+00, -9.465224679259332e-04, -3.729562005574143e-06, -1.047597164654235e-08, -1.586763324534664e-11,
  3.156521725894226e-14,  3.331100239935125e-16,  1.263267477079499e-18,  2.031762019715260e-21, -6.882761266920154e-24, -6.492867150231862e-26, -2.424065071869077e-28,
  1.883081163394570e+00, -7.244199354786153e-04, -3.069372400767141e-06, -9.994796897148885e-09, -2.315117221414830e-11, -1.763965696459877e-14,  1.671252598432792e-16,
  1.112820687569261e-18,  3.951464026133986e-21,  7.024859912451457e-24, -1.560305301032611e-26, -1.908619709874345e-28,  1.919009838802212e+00, -5.176254585161984e-04,
 -2.331046839632161e-06, -8.508912667597996e-09, -2.511678390859759e-11, -5.266050260526326e-14, -1.912418701260204e-17,  5.147070922297248e-19,  3.252468341709117e-21,
  1.258549756089570e-23,  3.159528904440493e-26,  1.614831066521970e-29,  1.948874049945508e+00, -3.352435611281800e-04, -1.586215367273238e-06, -6.318110874124081e-09,
 -2.182220583372538e-11, -6.404077181876771e-14, -1.444701812566308e-16, -1.363240538988070e-19,  9.133517309611764e-22,  7.426219536001846e-24,  3.500650061372144e-26,
  1.238077591602818e-28,  1.972203931944381e+00, -1.859354609871388e-04, -9.137337505559939e-07, -3.880728273719462e-09, -1.488354916985936e-11, -5.208589684845101e-14,
 -1.647971649101531e-16, -4.548468748853269e-19, -9.801118606424420e-22, -8.347326459685806e-25,  6.752044205273549e-27,  5.518010461935666e-29,  1.988615205265117e+00,
 -7.722825175390144e-05, -3.896322872794250e-07, -1.728044733119575e-09, -7.084136901584121e-12, -2.739168363902892e-14, -1.007252060855481e-16, -3.528398216539999e-19,
 -1.173183438768805e-21, -3.665040415004261e-24, -1.052339744853973e-26, -2.638048643631447e-29,  1.997831280260629e+00, -1.482714615838006e-05, -7.590960780436750e-08,
 -3.447423110354330e-10, -1.464064935119541e-12, -5.950769453013685e-15, -2.343130493768470e-17, -9.000462143066881e-20, -3.387101759791409e-22, -1.252098240514586e-24,
 -4.554026625944148e-27, -1.631078465480231e-29,  3.158236178121801e-04, -1.263192474579400e-06,  3.788746369058743e-09, -1.009984838777323e-11,  2.523500047174673e-14,
 -6.051781566347521e-17,  1.410498334262512e-19, -3.219728638813570e-22,  7.230826121891872e-25, -1.603654983975494e-27,  3.517806311123290e-30, -7.654880143449817e-33,
  2.842230074741362e-03, -1.135972435375420e-05,  3.401597197060603e-08, -9.041714901880009e-11,  2.249048977334999e-13, -5.359173318005326e-16,  1.238245015279002e-18,
 -2.794532962361742e-21,  6.185687223251241e-24, -1.347388445148561e-26,  2.891151840403005e-29, -6.126308003163088e-32,  7.894065129697026e-03, -3.150467129559435e-05,
  9.402904316013688e-08, -2.484889630790870e-10,  6.125193814653004e-13, -1.440544988062895e-15,  3.268866007506078e-18, -7.202204471691400e-21,  1.545080622100692e-23,
 -3.233170244911712e-26,  6.591202788580570e-29, -1.308831830027731e-31,  1.546935088956417e-02, -6.160144133325974e-05,  1.829448730376232e-07, -4.792145909759972e-10,
  1.164925935652960e-12, -2.684253463757737e-15,  5.918008966346393e-18, -1.253205056870124e-20,  2.546889930543928e-23, -4.949319051917243e-26,  9.096785831369263e-29,
 -1.554235661315105e-31,  2.556506469473466e-02, -1.015042493303179e-04,  2.994380888927577e-07, -7.750060858815644e-10,  1.848144980193423e-12, -4.137295894499612e-15,
  8.744528448411719e-18, -1.741594395804858e-20,  3.231691749932891e-23, -5.448866276400884e-26,  7.805623428758522e-29, -7.502436887955362e-32,  3.817707105910416e-02,
 -1.510170366948273e-04,  4.417403541198600e-07, -1.125866551289571e-09,  2.618279679020372e-12, -5.636850938666430e-15,  1.121741209776784e-17, -2.030189989550941e-20,
  3.190940495320934e-23, -3.772664880350395e-26,  7.821475358068322e-30,  1.400111683681691e-31,  5.330002910754834e-02, -2.098920252699219e-04,  6.076398285102192e-07,
 -1.519498860212690e-09,  3.422746265897087e-12, -6.995639470782738e-15,  1.276241777574356e-17, -1.966537093063959e-20,  2.083103504954358e-23,  6.599538420623458e-27,
 -1.233863871422540e-28,  4.644171229754663e-31,  7.092727390934477e-02, -2.778279012747901e-04,  7.944810992041353e-07, -1.941448559941113e-09,  4.201838170667335e-12,
 -8.012540476462712e-15,  1.281724639988997e-17, -1.424555950322372e-20, -2.804547100728929e-24,  7.785966715533117e-26, -2.968025975312801e-28,  8.060624193660029e-31,
  9.105066964857363e-02, -3.544676251916687e-04,  9.991660231935468e-07, -2.375285730592051e-09,  4.890638488870239e-12, -8.485063578718446e-15,  1.089293492797887e-17,
 -3.287886149726425e-21, -3.858252331026194e-23,  1.671353047002681e-25, -4.690712160344586e-28,  1.014301561383847e-30,  1.136604320760474e-01, -4.393958643377862e-04,
  1.218156048835172e-06, -2.802831594506383e-09,  5.421294929102138e-12, -8.223466221383680e-15,  6.638471278762341e-18,  1.323008476439127e-20, -8.322655740771910e-23,
  2.567089643783147e-25, -5.763951865886145e-28,  9.124967827063567e-31,  1.387449171430731e-01, -5.321360468190494e-04,  1.447476732827926e-06, -3.204436711150518e-09,
  5.725668651317131e-12, -7.066209999386034e-15, -9.514759621222782e-20,  3.441547085712547e-20, -1.303795793469020e-22,  3.213542450679181e-25, -5.459636969800400e-28,
  3.532270620583212e-31,  1.662903721163028e-01, -6.321470390100205e-04,  1.682725345365953e-06, -3.559318607532690e-09,  5.738362544784959e-12, -4.896327859010987e-15,
 -9.196062885405250e-18,  5.834865357076387e-20, -1.708474034058444e-22,  3.317204115028878e-25, -3.143134732812932e-28, -7.122382230919493e-31,  1.962806448058362e-01,
 -7.388194541245810e-04,  1.919082664856279e-06, -3.845967634641307e-09,  5.400124428206231e-12, -1.658116905299444e-15, -2.024348463873721e-17,  8.207412028776424e-20,
 -1.934035577782973e-22,  2.598363588678592e-25,  1.494207671637700e-28, -2.166175416060313e-30,  2.286968457964109e-01, -8.514716074527216e-04,  2.151330310004867e-06,
 -4.042630623442317e-09,  4.661605060495512e-12,  2.626623906430763e-15, -3.247691666154626e-17,  1.017234648196429e-19, -1.862099732689515e-22,  8.638281708456385e-26,
  8.193839176870672e-28, -3.680973414605204e-30,  2.635169577452381e-01, -9.693451452337345e-04,  2.373875246393882e-06, -4.127882415755065e-09,  3.487428104372505e-12,
  7.843828322559186e-15, -4.479002167072107e-17,  1.127966601071800e-19, -1.388394109393303e-22, -1.910944121009660e-25,  1.594000285696999e-27, -4.726228051771975e-30,
  3.007153848923063e-01, -1.091600389924905e-03,  2.580783441369657e-06, -4.081295386470478e-09,  1.860497353243805e-12,  1.377516308891598e-14, -5.575705553011213e-17,
  1.106194140387898e-19, -4.478803563967069e-23, -5.504026995325779e-25,  2.289638105939476e-27, -4.650356307492684e-30,  3.402624349145325e-01, -1.217311466087553e-03,
  2.765825028023938e-06, -3.884216400778406e-09, -2.135765936527216e-13,  2.009039691763360e-14, -6.369989916627215e-17,  9.098003474667783e-20,  9.576071927885155e-23,
 -9.392737480953650e-25,  2.654979915695306e-27, -2.849844245621016e-30,  3.821237241426942e-01, -1.345461299858739e-03,  2.922533776186533e-06, -3.520658913673735e-09,
 -2.702104817971977e-12,  2.634606701465520e-14, -6.680301075398596e-17,  5.092712073572304e-20,  2.733129298325542e-22, -1.274648010685779e-24,  2.412796459807879e-27,
  9.826196124454411e-31,  4.262594959546001e-01, -1.474936623012890e-03,  3.044284150451414e-06, -2.978314646682053e-09, -5.541251112950266e-12,  3.199268346306912e-14,
 -6.328167861533219e-17, -1.032187683425748e-20,  4.671399149520799e-22, -1.449188696141739e-24,  1.331764289641011e-27,  6.573133520020903e-30,  4.726238408742593e-01,
 -1.604523162413043e-03,  3.124389748863141e-06, -2.249683844723509e-09, -8.632603489284217e-12,  3.639295619936419e-14, -5.160523567875851e-17, -9.045227992312684e-20,
  6.447653676336952e-22, -1.347179229541924e-24, -6.765391519660096e-28,  1.282796444396551e-29,  5.211638055743286e-01, -1.732901260201621e-03,  3.156227434695268e-06,
 -1.333314721473687e-09, -1.184083295867294e-11,  3.885362480808274e-14, -3.077076849879215e-17, -1.832450697905209e-19,  7.636745826295072e-22, -8.707944514905102e-25,
 -3.451485108326434e-27,  1.776432700521218e-29,  5.718183766489162e-01, -1.858642252944826e-03,  3.133391952151847e-06, -2.351303432180877e-10, -1.499301167858804e-11,
  3.867329687625213e-14, -6.136658717464133e-19, -2.780871724819660e-19,  7.760328609242266e-22,  2.450790573912581e-26, -6.497964785744572e-27,  1.875404715074065e-29,
  6.245173237780111e-01, -1.980206043233715e-03,  3.049886180969191e-06,  1.030196318479905e-09, -1.788029802908762e-11,  3.520808712443535e-14,  3.787142104715134e-17,
 -3.600468720533857e-19,  6.369653835726828e-22,  1.290220393572667e-24, -8.965200112178327e-27,  1.319863109536223e-29,  6.791798858695839e-01, -2.095940429514287e-03,
  2.900352320707529e-06,  2.437882463455313e-09, -2.026282872786812e-11,  2.795557459066792e-14,  8.224212023294420e-17, -4.107948605301616e-19,  3.163995983382871e-22,
  2.749996463347319e-24, -9.741037862945037e-27, -3.467319989303565e-31,  7.357132831283359e-01, -2.204082923894624e-03,  2.680349033198024e-06,  3.951785874926144e-09,
 -2.187876390633738e-11,  1.665538795429428e-14,  1.284147734301962e-16, -4.106412454226109e-19, -1.864948829540065e-22,  4.084208701020150e-24, -7.705921057511249e-27,
 -2.078257219115577e-29,  7.940110380329464e-01, -2.302765987707764e-03,  2.386678666627676e-06,  5.523401789743625e-09, -2.245847113037005e-11,  1.401296177649465e-15,
  1.706483967686478e-16, -3.418718063477032e-19, -8.286575899286659e-22,  4.852034365446189e-24, -2.157853980249740e-27, -4.328066598915239e-29,  8.539510892915521e-01,
 -2.390026853680992e-03,  2.017766796377701e-06,  7.091292683598317e-09, -2.174474903496348e-11, -1.724522936826902e-14,  2.018051724328982e-16, -1.933616091791242e-19,
 -1.512453354105812e-21,  4.569048094462347e-24,  6.648590240910248e-27, -5.908509709380710e-29,  9.153936855224737e-01, -2.463823381654801e-03,  1.574092988131007e-06,
  8.581196055461974e-09, -1.951969550126778e-11, -3.815649018632223e-14,  2.139909464157291e-16,  3.391926948182234e-20, -2.084915735201300e-21,  2.850169190994578e-24,
  1.700999440256916e-26, -5.722595500473073e-29,  9.781790503996628e-01, -2.522057706267654e-03,  1.058666329307722e-06,  9.907118300323678e-09, -1.563820676758856e-11,
 -5.957932568165059e-14,  1.996595760400297e-16,  3.214336577108924e-19, -2.353914804580957e-21, -3.924188296645750e-25,  2.560680152527544e-26, -2.877951621181269e-29,
  1.042124819272826e+00, -2.562609764660663e-03,  4.775311726110857e-07,  1.097378159291973e-08, -1.006701866782157e-11, -7.914742663795728e-14,  1.532051032643257e-16,
  6.292447645044858e-19, -2.127278897340330e-21, -4.741143199912233e-24,  2.801184568401575e-26,  2.673346637739682e-29,  1.107023260062552e+00, -2.583383109555363e-03,
 -1.597230981674343e-07,  1.168082973917525e-08, -2.926535494017277e-12, -9.400357374245377e-14,  7.294813900409772e-17,  8.961027920521405e-19, -1.276299090079157e-21,
 -9.143644157712232e-24,  2.015202462517159e-26,  9.510796240305770e-29,  1.172638310086958e+00, -2.582365664421162e-03, -8.394903724765477e-07,  1.192919261671698e-08,
  5.469648987811844e-12, -1.010706458649672e-13, -3.676434999607156e-17,  1.046083355391379e-18,  1.846576321414894e-22, -1.198835081464188e-23,  6.601491323047980e-28,
  1.458742684933830e-28,  1.238702487231535e+00, -2.557708176282327e-03, -1.543776882086075e-06,  1.162991903639561e-08,  1.458559467399688e-11, -9.749942915772605e-14,
 -1.638761457489895e-16,  1.003928644688743e-18,  2.025545903969461e-21, -1.150846352194113e-23, -2.661141604012211e-26,  1.408094383569494e-28,  1.304913770550506e+00,
 -2.507822937209596e-03, -2.250018704982851e-06,  1.071556334035552e-08,  2.365551861646258e-11, -8.129208323941637e-14, -2.881502088358651e-16,  7.192772921883837e-19,
  3.774696502259595e-21, -6.549171008242079e-24, -5.147650770014085e-26,  5.506507163809266e-29,  1.370932593957092e+00, -2.431504692517475e-03, -2.931202928540677e-06,
  9.153791608334804e-09,  3.171195246043939e-11, -5.204596069308959e-14, -3.828689127941829e-16,  1.960141329966168e-19,  4.788157261877213e-21,  2.475424170485854e-24,
 -5.971585344479372e-26, -9.535949473660514e-29,  1.436379158575976e+00, -2.328074288596539e-03, -3.556433570294204e-06,  6.962203860852816e-09,  3.766420050155487e-11,
 -1.168154560615362e-14, -4.195427228458258e-16, -4.827456633827987e-19,  4.449024601247046e-21,  1.290722932042179e-23, -3.995664558990607e-26, -2.387727157928507e-28,
  1.500831344739737e+00, -2.197543245653102e-03, -4.092099630621625e-06,  4.222429087115229e-09,  4.043809626596299e-11,  3.507886452384032e-14, -3.758073195181155e-16,
 -1.149169792926479e-18,  2.478559190947327e-21,  2.014922563878787e-23,  6.644719253245884e-27, -2.711782698616566e-28,  1.563823591140218e+00, -2.040793774240306e-03,
 -4.503796710706518e-06,  1.090406501372033e-09,  3.917738827446309e-11,  8.079602089772019e-14, -2.453210367391916e-16, -1.581290352099963e-18, -7.524622490623998e-22,
  1.949561833030135e-23,  6.009129863564589e-26, -1.275137696598770e-28,  1.624847199749186e+00, -1.859763577613763e-03, -4.759108028661883e-06, -2.201357853927363e-09,
  3.348725349511087e-11,  1.162803092639299e-13, -4.651710295254860e-17, -1.577609772475674e-18, -4.120691921170801e-21,  9.196250024741919e-24,  8.721530138370817e-26,
  1.360596437745629e-28,  1.683352608116373e+00, -1.657618124636733e-03, -4.831245276338095e-06, -5.354425452340440e-09,  2.367194371603457e-11,  1.326037729213415e-13,
  1.747471771123450e-16, -1.060934252513969e-18, -6.075424936178818e-21, -6.938770887876617e-24,  6.288596279355026e-26,  3.342365111161102e-28,  1.738754224911003e+00,
 -1.438885441044866e-03, -4.703367931816049e-06, -8.032309409764842e-09,  1.088755600919890e-11,  1.239443132222262e-13,  3.537685016685673e-16, -1.643487456147684e-19,
 -5.429989340093092e-21, -2.005866048994447e-23, -4.347244410312459e-27,  2.837868611125397e-28,  1.790438420844837e+00, -1.209521089789211e-03, -4.373139880757165e-06,
 -9.907482843721783e-09, -2.888258125959442e-12,  9.047867221098308e-14,  4.286339453047164e-16,  7.695021105786037e-19, -2.269632032127060e-21, -2.142352062043179e-23,
 -6.762495345549328e-26,  1.357747576878794e-30,  1.837775169507372e+00, -9.768660757443317e-04, -3.856774684852530e-06, -1.072435681286261e-08, -1.515348047269014e-11,
  3.999141516823816e-14,  3.693507974710019e-16,  1.323797026415610e-18,  1.734625479568839e-21, -9.697318800267849e-24, -7.588981556976908e-26, -2.548083680607364e-28,
  1.880133605166128e+00, -7.494609873974005e-04, -3.191543382730023e-06, -1.036780921228437e-08, -2.346125659423261e-11, -1.324022553567156e-14,  2.000915558818791e-16,
  1.243176217512500e-18,  4.190985373825437e-21,  6.220015344680683e-24, -2.496489056970733e-26, -2.355790915458050e-28,  1.916901383790800e+00, -5.366891729873021e-04,
 -2.435599825701050e-06, -8.919226711440894e-09, -2.617335381940031e-11, -5.293435319192792e-14, -3.185424406552945e-18,  6.262803112207839e-19,  3.728416879646252e-21,
  1.385802071062239e-23,  3.188275749523643e-26, -4.211397723769254e-30,  1.947507207569078e+00, -3.482425876004258e-04, -1.664170510070134e-06, -6.677702315196478e-09,
 -2.313798514353098e-11, -6.755030141453202e-14, -1.478358926934187e-16, -1.025381208697549e-19,  1.207254242583576e-21,  8.939950184523289e-24,  4.079299510280305e-26,
  1.393105375190866e-28,  1.971445269603626e+00, -1.934357348625823e-04, -9.617663953417861e-07, -4.127418093676751e-09, -1.596586844609801e-11, -5.619742722160077e-14,
 -1.779760847579498e-16, -4.866341409214878e-19, -1.004678158473157e-21, -5.119338830124159e-25,  9.496288080141964e-27,  7.007195146272162e-29,  1.988299924033808e+00,
 -8.043022559025901e-05, -4.110674145591494e-07, -1.845908375543899e-09, -7.656967317096754e-12, -2.993200987190130e-14, -1.111507350327872e-16, -3.925763074748846e-19,
 -1.312987784886339e-21, -4.109883473360001e-24, -1.173584228021292e-26, -2.872489979021756e-29,  1.997770730347473e+00, -1.545137812543200e-05, -8.019109464766966e-08,
 -3.691509069566077e-10, -1.588914479095578e-12, -6.544630042738583e-15, -2.611021188236629e-17, -1.016011667455653e-19, -3.872452582136263e-22, -1.449464543513260e-24,
 -5.336334255111203e-27, -1.933934148975373e-29,  3.108307098377394e-04, -1.233360523236549e-06,  3.669931394223521e-09, -9.705590320563205e-12,  2.405777917413086e-14,
 -5.723824026587908e-17,  1.323500451388161e-19, -2.997314132108656e-22,  6.678047573691143e-25, -1.469452184282003e-27,  3.197795390176209e-30, -6.904830262464661e-33,
  2.797328646477107e-03, -1.109187623124447e-05,  3.295220850573577e-08, -8.690282896385255e-11,  2.144775056252478e-13, -5.071164874082561e-16,  1.162697920821351e-18,
 -2.604133898045968e-21,  5.720810151064751e-24, -1.236957508004458e-26,  2.634637170242692e-29, -5.543748607212616e-32,  7.769532256399082e-03, -3.076420197754021e-05,
  9.110504032685267e-08, -2.389149451458743e-10,  5.844769591923224e-13, -1.364457332034484e-15,  3.073954827897965e-18, -6.725903947554864e-21,  1.433296543036098e-23,
 -2.980693050185015e-26,  6.041037358868575e-29, -1.193751605975763e-31,  1.522583626390558e-02, -6.016057181998465e-05,  1.773043839040771e-07, -4.609976571451159e-10,
  1.112633234905953e-12, -2.546341543577820e-15,  5.578258690528539e-18, -1.174486477646852e-20,  2.375102305913812e-23, -4.598797871397241e-26,  8.437240587436350e-29,
 -1.444840863440699e-31,  2.516378050786200e-02, -9.914544843128435e-05,  2.903127436538626e-07, -7.460864943968718e-10,  1.767458846095251e-12, -3.933163902061233e-15,
  8.271069362625131e-18, -1.641259196580471e-20,  3.041072531512226e-23, -5.143299483068920e-26,  7.471545410354357e-29, -7.663587726044437e-32,  3.757998618637457e-02,
 -1.475364517581883e-04,  4.284776368911695e-07, -1.084861536284293e-09,  2.508189385447958e-12, -5.374340354767940e-15,  1.066305063531419e-17, -1.930245755418749e-20,
  3.055828615858093e-23, -3.729881975033772e-26,  1.337372276903966e-29,  1.130560304993914e-31,  5.247006906226182e-02, -2.051029221263187e-04,  5.897298621073271e-07,
 -1.465837765937545e-09,  3.285852245787390e-12, -6.695873497333560e-15,  1.222114884514132e-17, -1.899589011631104e-20,  2.098454302862939e-23,  2.055091689762046e-27,
 -1.042606849265326e-28,  4.060887658781160e-31,  6.982852804932700e-02, -2.715641111831994e-04,  7.715818584416363e-07, -1.875484577765165e-09,  4.044631149631192e-12,
 -7.709720702406246e-15,  1.241751973174853e-17, -1.429268125893959e-20, -2.069730276391900e-25,  6.667245106336630e-26, -2.631497963483955e-28,  7.248297602169136e-31,
  8.964860714357968e-02, -3.465869932726968e-04,  9.711265414997549e-07, -2.298378954296332e-09,  4.723543366850132e-12, -8.224871952339989e-15,  1.078446836280937e-17,
 -4.429792263008221e-21, -3.289283580704879e-23,  1.492422578389220e-25, -4.261393810642262e-28,  9.376611370151122e-31,  1.119221281656455e-01, -4.297836897142443e-04,
  1.185037114898828e-06, -2.717397853025791e-09,  5.258447323938567e-12, -8.059990167430444e-15,  6.972986191247947e-18,  1.071032760669522e-20, -7.439043161991141e-23,
  2.344485292049345e-25, -5.368277968033613e-28,  8.849004534665760e-31,  1.366392912308291e-01, -5.207084992765407e-04,  1.409568493259235e-06, -3.113956411113079e-09,
  5.584397278475422e-12, -7.057390856430186e-15,  8.117848385075763e-19,  3.042424131128043e-20, -1.191999654572202e-22,  2.998492221017104e-25, -5.287641347125658e-28,
  4.251337444280167e-31,  1.637884392511985e-01, -6.188545302232565e-04,  1.640561135950619e-06, -3.468299666434592e-09,  5.638358120965964e-12, -5.098035058722936e-15,
 -7.637062587071528e-18,  5.307012368537769e-20, -1.591387418687124e-22,  3.185848586182457e-25, -3.409486113731607e-28, -5.040893359541962e-31,  1.933557820885489e-01,
 -7.236499331063612e-04,  1.873448287424921e-06, -3.759856571124202e-09,  5.362286220379196e-12, -2.117074299539541e-15, -1.803064065502927e-17,  7.603584553802076e-20,
 -1.839638873481035e-22,  2.640105870691534e-25,  6.178439297834104e-29, -1.823747440292154e-30,  2.253250752066120e-01, -8.344537395639488e-04,  2.103267855615602e-06,
 -3.967666076216419e-09,  4.706570320543813e-12,  1.880686747357626e-15, -2.971157091021824e-17,  9.582051845579479e-20, -1.825481398533256e-22,  1.160424918569506e-25,
  6.666095219912891e-28, -3.267775557339187e-30,  2.596772468036018e-01, -9.505513214896431e-04,  2.324680441148637e-06, -4.070885895027053e-09,  3.633808268412973e-12,
  6.806259510381079e-15, -4.169486403896317e-17,  1.082556335978231e-19, -1.446203180430565e-22, -1.313913849388027e-25,  1.393692816260641e-27, -4.377385853485391e-30,
  2.963899664306670e-01, -1.071149498046128e-03,  2.531995363437678e-06, -4.049395059970016e-09,  2.122868894104166e-12,  1.247398223924895e-14, -5.268263204676013e-17,
  1.088864419777031e-19, -6.300310912222253e-23, -4.628869671423030e-25,  2.086821616961828e-27, -4.558182341586699e-30,  3.354371470077574e-01, -1.195371336341371e-03,
  2.719206920835908e-06, -3.884501355471786e-09,  1.731513712598760e-13,  1.859248438266559e-14, -6.111449606663182e-17,  9.352360008693372e-20,  6.382714953921955e-23,
 -8.356992868855264e-25,  2.521078440240995e-27, -3.215991314902531e-30,  3.767883709280802e-01, -1.322250716767069e-03,  2.880043574754583e-06, -3.559763829094577e-09,
 -2.191095767371056e-12,  2.476085283650486e-14, -6.526137237330326e-17,  5.895763083675221e-20,  2.291705474583134e-22, -1.177564188027320e-24,  2.434451337633343e-27,
  2.911229455107795e-32,  4.204082295926397e-01, -1.450726768040232e-03,  3.008033262256987e-06, -3.061938422931731e-09, -4.916599929841825e-12,  3.047209637888554e-14,
 -6.336917905112419e-17,  3.802687484337417e-21,  4.159935682160024e-22, -1.390584716419375e-24,  1.587547691921710e-27,  5.078436905781327e-30,  4.662555642420727e-01,
 -1.579638322438846e-03,  3.096588611908938e-06, -2.382050740522851e-09, -7.917322909011578e-12,  3.512632507605942e-14, -5.385636655883424e-17, -7.059991288925107e-20,
  5.959111778034925e-22, -1.363463010505613e-24, -1.502042647934118e-28,  1.110476515499438e-29,  5.142825943712025e-01, -1.707718601748895e-03,  3.139116446842397e-06,
 -1.516593289116748e-09, -1.107154690148523e-11,  3.805628758664553e-14, -3.556439820591642e-17, -1.593342001506916e-19,  7.300258039906816e-22, -9.936058183434689e-25,
 -2.698866253823496e-27,  1.642206278754869e-29,  5.644339183586277e-01, -1.833590422917988e-03,  3.129156573583816e-06, -4.688341997067321e-10, -1.422030922302086e-11,
  3.856793680190695e-14, -8.052659642873678e-18, -2.532885548875692e-19,  7.724354041689678e-22, -2.189209939233509e-25, -5.674536236036997e-27,  1.861016438487000e-29,
  6.166453692837981e-01, -1.955762313983446e-03,  3.060555416221907e-06,  7.497908426052235e-10, -1.716785165504124e-11,  3.599836921959969e-14,  2.808196510510252e-17,
 -3.389888526149610e-19,  6.771037028065316e-22,  9.438085589045856e-25, -8.342078439109156e-27,  1.502724456193506e-29,  6.708427073436761e-01, -2.072626060909894e-03,
  2.927680466147521e-06,  2.118253450430440e-09, -1.968490451867829e-11,  2.979259129201976e-14,  7.089595819471657e-17, -3.991612299439198e-19,  4.083937781541492e-22,
  2.361307711202074e-24, -9.663360202788141e-27,  3.777280933138524e-30,  7.269401289862939e-01, -2.182456370546159e-03,  2.725681626635130e-06,  3.604554047643372e-09,
 -2.151577085256173e-11,  1.959882638052234e-14,  1.168549386075644e-16, -4.143177515695415e-19, -4.521617645359585e-23,  3.759418382579852e-24, -8.491166096635556e-27,
 -1.495917717162752e-29,  7.848385720998738e-01, -2.283413540233649e-03,  2.450805111532343e-06,  5.164509678087170e-09, -2.239027976036963e-11,  5.379153059378469e-15,
  1.607308669389527e-16, -3.656143629377663e-19, -6.559820067521307e-22,  4.729280931978440e-24, -3.938318255659862e-27, -3.758631085427514e-29,  8.444237967014131e-01,
 -2.373550276345482e-03,  2.100764277984887e-06,  6.740878679051584e-09, -2.204168653857473e-11, -1.247219006721081e-14,  1.957385326387403e-16, -2.390820633716145e-19,
 -1.343801070121553e-21,  4.783685805370070e-24,  4.102655932063140e-27, -5.643043471787591e-29,  9.055642220848211e-01, -2.450824105880144e-03,  1.675169171201198e-06,
  8.263055121740462e-09, -2.023142909283644e-11, -3.301675027348057e-14,  2.140229761731905e-16, -3.103001677424857e-20, -1.970680101037849e-21,  3.479048267505642e-24,
  1.440868393050821e-26, -6.069737369030886e-29,  9.681085050545322e-01, -2.513117176401507e-03,  1.176012010061282e-06,  9.647637562834199e-09, -1.678118999125723e-11,
 -5.468801195453212e-14,  2.076044348872515e-16,  2.460773518612419e-19, -2.349941430748949e-21,  6.031179084599123e-25,  2.408882685762211e-26, -3.992562369472200e-29,
  1.031882850697670e+00, -2.558265630969355e-03,  6.081985438012987e-07,  1.080025133550166e-08, -1.161181124417521e-11, -7.526692008565834e-14,  1.698468302913543e-16,
  5.586591957375896e-19, -2.277553324480409e-21, -3.602113100384284e-24,  2.881727131185735e-26,  9.938656975642534e-30,  1.096688058486477e+00, -2.584101152756289e-03,
 -1.989579982932830e-08,  1.161906816787410e-08, -4.787092175634944e-12, -9.195664135996530e-14,  9.741890507044558e-17,  8.501579771882065e-19, -1.589992637615690e-21,
 -8.258329916164999e-24,  2.399937455396562e-26,  7.942324904640709e-29,  1.162296324099420e+00, -2.588507652300223e-03, -6.958818094634975e-07,  1.200049772209502e-08,
  3.441786903880086e-12, -1.016012368238223e-13, -7.456061582701867e-18,  1.045104707520482e-18, -2.449092663573494e-22, -1.183456519805570e-23,  6.996515151824013e-27,
  1.414000233644597e-28,  1.228447843373928e+00, -2.569496337483041e-03, -1.402882651976140e-06,  1.184748463222258e-08,  1.259858892917487e-11, -1.010882021140479e-13,
 -1.349223759873175e-16,  1.061924210847997e-18,  1.593618433453863e-21, -1.244421015487573e-23, -2.006575015847803e-26,  1.559253871664073e-28,  1.294847301802979e+00,
 -2.525302431478250e-03, -2.119215865738205e-06,  1.108067624718634e-08,  2.196222178819214e-11, -8.795259370980287e-14, -2.663576275854590e-16,  8.359032016928775e-19,
  3.502538867582949e-21, -8.549721766773884e-24, -4.830478776174292e-26,  8.885171341903955e-29,  1.361160383697344e+00, -2.454506390640525e-03, -2.818349043526247e-06,
  9.652358411372740e-09,  3.057967903741679e-11, -6.115157420609870e-14, -3.752253568589851e-16,  3.501924202160978e-19,  4.833361246117077e-21,  1.341036338082570e-26,
 -6.311560753777059e-26, -5.841473952455824e-29,  1.427010502047098e+00, -2.356181348042973e-03, -3.469280854533036e-06,  7.562410636953343e-09,  3.732886939229524e-11,
 -2.189626801199976e-14, -4.309989017673201e-16, -3.332711316784264e-19,  4.882414640014171e-21,  1.110232825181999e-23, -5.018518694756447e-26, -2.245975599139836e-28,
  1.491976034662096e+00, -2.230066316857304e-03, -4.037526889179524e-06,  4.874550422695448e-09,  4.104692265095202e-11,  2.568300176509335e-14, -4.067644036640160e-16,
 -1.058222516729550e-18,  3.205759851059686e-21,  2.016768596417529e-23, -5.923324980627096e-27, -2.988277244186864e-28,  1.555588453370103e+00, -2.076761031507597e-03,
 -4.486898555509889e-06,  1.729837084104522e-09,  4.073083402646303e-11,  7.437494635120444e-14, -2.898255206434696e-16, -1.593687777476372e-18, -8.864832689487853e-24,
  2.176962598703159e-23,  5.317376521129482e-26, -1.872446691291230e-28,  1.617331845498618e+00, -1.897932822210757e-03, -4.782233039730697e-06, -1.647032889590237e-09,
  3.579804193589317e-11,  1.146192517392326e-13, -9.248161216022590e-17, -1.703490651058961e-18, -3.725510190215115e-21,  1.279112508581021e-23,  9.217309560689914e-26,
  8.727068871459923e-29,  1.676644438114637e+00, -1.696518457514026e-03, -4.893137647101815e-06, -4.954240377014284e-09,  2.636343784661216e-11,  1.364190497884442e-13,
  1.422853038933413e-16, -1.258830138164680e-18, -6.276369223841908e-21, -4.126144928118472e-24,  7.780018781166187e-26,  3.417228212985322e-28,  1.732922823237370e+00,
 -1.476894782552578e-03, -4.798627146935549e-06, -7.837818035781216e-09,  1.345086966168456e-11,  1.323592334359183e-13,  3.466254516200240e-16, -3.496702435996174e-19,
 -6.152056461686336e-21, -1.996462887982814e-23,  9.501691217021590e-27,  3.459236314829797e-28,  1.785529612355738e+00, -1.244982412423271e-03, -4.492245401547915e-06,
 -9.938652278821323e-09, -9.741128109396019e-13,  1.010155013409123e-13,  4.490435483024242e-16,  6.840129197572792e-19, -3.089411803163894e-21, -2.411148507600754e-23,
 -6.635781617124816e-26,  5.841357621601692e-29,  1.833805176023544e+00, -1.008239100117756e-03, -3.986893711563655e-06, -1.095991952950438e-08, -1.426197463647171e-11,
  4.930655845073239e-14,  4.071374398600317e-16,  1.373111450658097e-18,  1.328159306171804e-21, -1.295922521096527e-23, -8.724163002662440e-26, -2.597219544812821e-28,
  1.877083899535467e+00, -7.754973891333172e-04, -3.318217234273123e-06, -1.074503472422460e-08, -2.367514043550356e-11, -8.004966887914836e-15,  2.368102184680017e-16,
  1.380656622701201e-18,  4.394303115609364e-21,  4.999759011187033e-24, -3.641222406590972e-26, -2.855866667321542e-28,  1.914714969483765e+00, -5.566092940838959e-04,
 -2.545178121445581e-06, -9.346467812121194e-09, -2.723131331655714e-11, -5.278642148168499e-14,  1.609750523100528e-17,  7.538171982647306e-19,  4.250148108298856e-21,
  1.512199210524389e-23,  3.111201492189643e-26, -3.222030825410325e-29,  1.946087093963199e+00, -3.618828788575130e-04, -1.746569394553632e-06, -7.058911797425804e-09,
 -2.452468047745477e-11, -7.112814127674111e-14, -1.501154111097639e-16, -5.842938393668088e-20,  1.559983007586655e-21,  1.069891656445734e-23,  4.727063015553255e-26,
  1.551311907119150e-28,  1.970655818472635e+00, -2.013324117611996e-04, -1.012865990725770e-06, -4.392100356292794e-09, -1.713365377474871e-11, -6.063600949643222e-14,
 -1.920541480250739e-16, -5.189990724320538e-19, -1.015481246927267e-21, -6.529789985171673e-26,  1.296885320477859e-26,  8.839073696730875e-29,  1.987971482762309e+00,
 -8.380949766110042e-05, -4.339736189765431e-07, -1.973357739282717e-09, -8.283199183254699e-12, -3.273642092814243e-14, -1.227539933178156e-16, -4.370523228621083e-19,
 -1.469704146831695e-21, -4.605268782252336e-24, -1.304983599723116e-26, -3.097602443719453e-29,  1.997707613098445e+00, -1.611106848483556e-05, -8.477787377137797e-08,
 -3.956557202132709e-10, -1.726311409188369e-12, -7.206863128972595e-15, -2.913667857609749e-17, -1.148708277764077e-19, -4.434824387568882e-22, -1.680958479306232e-24,
 -6.264826446486062e-27, -2.297489340710532e-29,  3.059552581471135e-04, -1.204460482597061e-06,  3.555736631292115e-09, -9.329654198376575e-12,  2.294411086448243e-14,
 -5.416018216711111e-17,  1.242489620501316e-19, -2.791839604543486e-22,  6.171355306858978e-25, -1.347413620435940e-27,  2.909021418363875e-30, -6.233485706830073e-33,
  2.753481853628580e-03, -1.083237232219559e-05,  3.192963454620972e-08, -8.355083577812580e-11,  2.046084223929673e-13, -4.800664441548856e-16,  1.092279573423609e-18,
 -2.427994130190999e-21,  5.293901449459211e-24, -1.136292374162450e-26,  2.402431634044585e-29, -5.020246604677322e-32,  7.647915193335521e-03, -3.004667264280624e-05,
  8.829328304299375e-08, -2.297776816455233e-10,  5.579105710671213e-13, -1.292891466963176e-15,  2.891892637187925e-18, -6.283961561659073e-21,  1.330217435218956e-23,
 -2.749241660278846e-26,  5.539142174011405e-29, -1.089250256420880e-31,  1.498799623315331e-02, -5.876396582378414e-05,  1.718775674842025e-07, -4.435957762695914e-10,
  1.063018986218279e-12, -2.416325232631793e-15,  5.259798620920716e-18, -1.101068200967554e-20,  2.215469986592222e-23, -4.273716100233438e-26,  7.824317079225938e-29,
 -1.342286729878056e-31,  2.477178768637122e-02, -9.685828379408276e-05,  2.815268203969377e-07, -7.184258279004134e-10,  1.690743962072613e-12, -3.740064593484684e-15,
  7.824866511216224e-18, -1.546850396831722e-20,  2.861211773761293e-23, -4.851204884576621e-26,  7.132781971476781e-29, -7.719191030882102e-32,  3.699661452454256e-02,
 -1.441600298688520e-04,  4.156965821155083e-07, -1.045576677743107e-09,  2.403218498353838e-12, -5.124803503279547e-15,  1.013607086512345e-17, -1.834596396908644e-20,
  2.922629193003531e-23, -3.667142847638554e-26,  1.782809233281924e-29,  9.001590789399894e-32,  5.165898289635812e-02, -2.004545597654967e-04,  5.724508825864632e-07,
 -1.414319712861530e-09,  3.154825161231932e-12, -6.408872623590051e-15,  1.169867057856936e-17, -1.832397189637169e-20,  2.098762128424134e-23, -1.773649285209648e-27,
 -8.755277971937446e-29,  3.543957720413995e-31,  6.875447591532113e-02, -2.654803910499761e-04,  7.494592917630057e-07, -1.811987978289810e-09,  3.893384529801282e-12,
 -7.416501171481083e-15,  1.201757863480977e-17, -1.426287154358352e-20,  2.011249443289875e-24,  5.676200273421864e-26, -2.329121079991141e-28,  6.507504659883990e-31,
  8.827762431582520e-02, -3.389270307373664e-04,  9.439940712292798e-07, -2.224104221241419e-09,  4.561623559384690e-12, -7.967647213576718e-15,  1.064648289434118e-17,
 -5.399609876950406e-21, -2.781719114182229e-23,  1.329999938649314e-25, -3.865077389913110e-28,  8.643589800404955e-31,  1.102217494815566e-01, -4.204324097859498e-04,
  1.152927861733162e-06, -2.634543104274359e-09,  5.098943970650726e-12, -7.889301172162821e-15,  7.240788177665956e-18,  8.460807434925020e-21, -6.632750276675938e-23,
  2.137446470574861e-25, -4.986101726015171e-28,  8.514446147615737e-31,  1.345787757992038e-01, -5.095799130010902e-04,  1.372732464788630e-06, -3.025733896616657e-09,
  5.443511106075378e-12, -7.028106673133903e-15,  1.611855908529795e-18,  2.677851112905393e-20, -1.087814402128196e-22,  2.790895759018047e-25, -5.088345023583173e-28,
  4.778606680794439e-31,  1.613390086725406e-01, -6.058949936974793e-04,  1.599479426726758e-06, -3.378911085828713e-09,  5.534681958450477e-12, -5.264057942656171e-15,
 -6.220688099922084e-18,  4.815851659111344e-20, -1.479200198257765e-22,  3.045572962799020e-25, -3.591489145662261e-28, -3.282057615962564e-31,  1.904908738343100e-01,
 -7.088413647476868e-04,  1.828843316567403e-06, -3.674421523435575e-09,  5.315786429328316e-12, -2.524918049257999e-15, -1.598262145720781e-17,  7.030139683353848e-20,
 -1.744335153161616e-22,  2.649693604157377e-25, -1.162817718239206e-29, -1.519238215261788e-30,  2.220206128022045e-01, -8.178167618921470e-04,  2.056108811667361e-06,
 -3.892097884709938e-09,  4.737267204976844e-12,  1.199148682831858e-15, -2.710971484264642e-17,  9.005069039514473e-20, -1.779242476189164e-22,  1.399467126117536e-25,
  5.314079490593821e-28, -2.882470501790837e-30,  2.559119284259569e-01, -9.321482820902125e-04,  2.276182974807433e-06, -4.011709310180548e-09,  3.760169495188278e-12,
  5.841429724118482e-15, -3.872913273354285e-17,  1.035624907642350e-19, -1.483924223194054e-22, -7.939202136296976e-26,  1.208843665187977e-27, -4.024869673994976e-30,
  2.921455734498964e-01, -1.051087310161911e-03,  2.483614431250780e-06, -4.013500986349673e-09,  2.359950420973454e-12,  1.124594226422473e-14, -4.966442961070827e-17,
  1.066194398812849e-19, -7.821250595706745e-23, -3.833853343948680e-25,  1.889338804531685e-27, -4.410278285619077e-30,  3.306988738541249e-01, -1.173804062195323e-03,
  2.672621542435918e-06, -3.878834935185492e-09,  5.305467687318288e-13,  1.715736409585766e-14, -5.847162637359769e-17,  9.510388699956431e-20,  3.552229369278960e-23,
 -7.377676513115402e-25,  2.373684277656265e-27, -3.466016862085620e-30,  3.715451774237039e-01, -1.299381795724430e-03,  2.837132131679030e-06, -3.590944150057730e-09,
 -1.711403605138370e-12,  2.321517984542498e-14, -6.351412934863101e-17,  6.563159298789611e-20,  1.885291020221688e-22, -1.080405240502897e-24,  2.417718387151925e-27,
 -7.643700783137342e-31,  4.146532165177705e-01, -1.426810766520647e-03,  2.970837851663518e-06, -3.135811057121604e-09, -4.322350401313400e-12,  2.895397220952963e-14,
 -6.308377473813891e-17,  1.632617329700474e-20,  3.671256884342382e-22, -1.323019718328455e-24,  1.780935277773558e-27,  3.737449077777449e-30,  4.599863723638141e-01,
 -1.554982052558390e-03,  3.067266894164268e-06, -2.503178557681491e-09, -7.227871112216181e-12,  3.381216015016054e-14, -5.557357785150850e-17, -5.231634339566921e-20,
  5.468316136055996e-22, -1.360192542142773e-24,  3.016529111177240e-28,  9.447293485285909e-30,  5.075018263906688e-01, -1.682681420575875e-03,  3.119879421765031e-06,
 -1.687696879301251e-09, -1.031930447542038e-11,  3.715181175008002e-14, -3.970422212762411e-17, -1.365651384177532e-19,  6.924831171196472e-22, -1.087531395956858e-24,
 -2.008029299596829e-27,  1.496522025252601e-29,  5.571495821573250e-01, -1.808583483751738e-03,  3.122190827857974e-06, -6.902011392187437e-10, -1.345144318494531e-11,
  3.829235233358635e-14, -1.480017600227032e-17, -2.287389331316113e-19,  7.606648422707490e-22, -4.296490465142067e-25, -4.865512117176755e-27,  1.811068785649309e-29,
  6.088713393785939e-01, -1.931246495409286e-03,  3.067928661405286e-06,  4.808983913376923e-10, -1.644190064708441e-11,  3.656091365949779e-14,  1.889827605090035e-17,
 -3.168409826056805e-19,  7.052376705647302e-22,  6.237597266197183e-25, -7.651194427263849e-27,  1.628697536982789e-29,  6.625991994761918e-01, -2.049108249442508e-03,
  2.951229708976792e-06,  1.808150468601156e-09, -1.907293500484914e-11,  3.136152875597201e-14,  5.991465390013599e-17, -3.848067264949209e-19,  4.864931817693845e-22,
  1.979174822386198e-24, -9.417737533830734e-27,  7.284786112474604e-30,  7.182541801346862e-01, -2.160483720467840e-03,  2.766884179244809e-06,  3.263585959394896e-09,
 -2.109668913531417e-11,  2.226409332049348e-14,  1.052536563638200e-16, -4.136659848278865e-19,  8.386559311536311e-23,  3.408246670983801e-24, -9.027582542144426e-27,
 -9.491172914231223e-30,  7.757445147380657e-01, -2.263565283512359e-03,  2.510633980371876e-06,  4.807331938140324e-09, -2.224496210012847e-11,  9.111631558646371e-15,
  1.502251447164829e-16, -3.839152558607180e-19, -4.889461902595245e-22,  4.540416678477117e-24, -5.461384738864008e-27, -3.161564765553061e-29,  8.349637116443314e-01,
 -2.356426612594827e-03,  2.179531408954936e-06,  6.386469025634652e-09, -2.224471976417402e-11, -7.859495904093014e-15,  1.884682992713521e-16, -2.793014176960420e-19,
 -1.169223484123168e-21,  4.899177824800056e-24,  1.699692088088803e-27, -5.262454612567159e-29,  8.957883485274764e-01, -2.437031677187644e-03,  1.772362727334576e-06,
  7.934348240082016e-09, -2.084050528301899e-11, -2.789763133631180e-14,  2.122908622324570e-16, -9.198187555543889e-20, -1.835709453053181e-21,  4.001381270863251e-24,
  1.169640757348483e-26, -6.228644894277906e-29,  9.580755792101991e-01, -2.503250639557621e-03,  1.290137455443010e-06,  9.370661347344560e-09, -1.782461086918214e-11,
 -4.963129429272857e-14,  2.134463961386685e-16,  1.714089771332881e-19, -2.311334977498480e-21,  1.528667287335159e-24,  2.212116425920883e-26, -4.918796300729548e-29,
  1.021660335561668e+00, -2.552884901908478e-03,  7.366378813856013e-07,  1.060264629745861e-08, -1.307516240991917e-11, -7.101123415278677e-14,  1.844510388790950e-16,
  4.839257074080160e-19, -2.386419543533667e-21, -2.445493768743554e-24,  2.889603656289897e-26, -6.207825370344059e-30,  1.086352216570399e+00, -2.583704044880950e-03,
  1.190131993082170e-07,  1.152789665131223e-08, -6.600947162166875e-12, -8.933895188863555e-14,  1.204676766976590e-16,  7.947132263032220e-19, -1.869216393364902e-21,
 -7.233495933863378e-24,  2.711507788476231e-26,  6.196343102924532e-29,  1.151932072537112e+00, -2.593497901166967e-03, -5.516124864303436e-07,  1.203931032040479e-08,
  1.410336770712995e-12, -1.014303041469190e-13,  2.163355714500636e-17,  1.030516952703014e-18, -6.644370426588762e-22, -1.143256459810618e-23,  1.303925950769041e-26,
  1.325846963837098e-28,  1.218148316944295e+00, -2.580147447366851e-03, -1.259570632117108e-06,  1.203272221181282e-08,  1.054687996664528e-11, -1.039641892249949e-13,
 -1.045429307573780e-16,  1.105610854684685e-18,  1.132864020602065e-21, -1.310628895834279e-23, -1.296510875229646e-26,  1.659533737078434e-28,  1.284713035009052e+00,
 -2.541718448124068e-03, -1.984198529002940e-06,  1.141766023234562e-08,  2.014120411252377e-11, -9.405194564605422e-14, -2.414320832076590e-16,  9.426951118975782e-19,
  3.160998448308134e-21, -1.039422589972045e-23, -4.369038558364268e-26,  1.204139044938966e-28,  1.351298009745391e+00, -2.476581648223764e-03, -2.699627028527252e-06,
  1.013136337833786e-08,  2.926747796799832e-11, -7.002185776916912e-14, -3.632580502407099e-16,  5.043761255262545e-19,  4.787888277952954e-21, -2.550827118411736e-24,
 -6.479848472897913e-26, -1.755404865723028e-29,  1.417530857190250e+00, -2.383562482664384e-03, -3.374964635398568e-06,  8.155604271259285e-09,  3.678684119446045e-11,
 -3.233421095902331e-14, -4.380859582794913e-16, -1.710453188903156e-19,  5.243639447297611e-21,  8.903554360289930e-24, -5.958114191952950e-26, -2.009365019547301e-28,
  1.482991555239359e+00, -2.262121353244574e-03, -3.975076573930091e-06,  5.534870187456559e-09,  4.146062192870953e-11,  1.557735391809033e-14, -4.348497831079132e-16,
 -9.440934493698045e-19,  3.924304639496898e-21,  1.966150958788399e-23, -1.952370482280729e-26, -3.177742829630544e-28,  1.547209766121306e+00, -2.112561998465561e-03,
 -4.462182528628373e-06,  2.393037324395510e-09,  4.214516330400807e-11,  6.688436110979829e-14, -3.343321045390492e-16, -1.581038828140415e-18,  8.109789557297285e-22,
  2.371397776727484e-23,  4.360347240323333e-26, -2.476595888386290e-28,  1.609663487281698e+00, -1.936259833683616e-03, -4.798485609198361e-06, -1.056062188257573e-09,
  3.806430014337045e-11,  1.118142998358513e-13, -1.417740415912770e-16, -1.814621206435207e-18, -3.197893449243503e-21,  1.653778591061546e-23,  9.471638319244830e-26,
  2.638276914646600e-29,  1.669779707958346e+00, -1.735893982872607e-03, -4.949967037737746e-06, -4.510425177385598e-09,  2.912299449389435e-11,  1.393881197537649e-13,
  1.042083683113401e-16, -1.461420604361677e-18, -6.365274749196500e-21, -7.140696863507169e-25,  9.276166149545922e-26,  3.359250888986805e-28,  1.726937875832697e+00,
 -1.515656152252768e-03, -4.891300868715008e-06, -7.600978381817716e-09,  1.618033361090618e-11,  1.405378485134043e-13,  3.339712157505095e-16, -5.579314515637687e-19,
 -6.860106392859082e-21, -1.926178924196009e-23,  2.609211433541023e-26,  4.079050939532949e-28,  1.780477051275253e+00, -1.281397538524387e-03, -4.611534159446848e-06,
 -9.937483750426785e-09,  1.155457804124842e-12,  1.120103833142179e-13,  4.666777446919406e-16,  5.707574361036679e-19, -4.004405183379838e-21, -2.669461829884620e-23,
 -6.228476354978516e-26,  1.290018714474646e-28,  1.829707590996440e+00, -1.040664126744315e-03, -4.119747597492843e-06, -1.117967801444991e-08, -1.317499336322917e-11,
  5.954356937072620e-14,  4.461045093987632e-16,  1.407452205761999e-18,  7.960645065702100e-22, -1.667669358857672e-23, -9.859220917405693e-26, -2.542342560361952e-28,
  1.873927992775858e+00, -8.025653384073334e-04, -3.449434710831147e-06, -1.112479553361672e-08, -2.377519120373915e-11, -1.841575583328706e-15,  2.774621593050419e-16,
  1.523847564212904e-18,  4.544906178506322e-21,  3.276176955108726e-24, -5.016487145483350e-26, -3.402111382296155e-28,  1.912447088563541e+00, -5.774268364898731e-04,
 -2.659984692023613e-06, -9.790586202113334e-09, -2.828138709518122e-11, -5.213091871648210e-14,  3.919198676839913e-17,  8.987690166408171e-19,  4.816506664878471e-21,
  1.632785746261477e-23,  2.890915084226738e-26, -6.961060104528178e-29,  1.944611071298537e+00, -3.762010418821941e-04, -1.833678285374665e-06, -7.462883388238439e-09,
 -2.598337280772362e-11, -7.474453324629443e-14, -1.509919784719698e-16, -1.968794872047847e-21,  1.980865866134657e-21,  1.273086036935918e-23,  5.443917911378346e-26,
  1.705778144783542e-28,  1.969833942467194e+00, -2.096509146765500e-04, -1.067256870425872e-06, -4.676196023742681e-09, -1.839366302296756e-11, -6.542336311498504e-14,
 -2.070406513683874e-16, -5.514239873601919e-19, -1.007500491200118e-21,  5.375190754919067e-25,  1.733530120035349e-26,  1.108252110481575e-28,  1.987629147970885e+00,
 -8.737831163495993e-05, -4.584712351233349e-07, -2.111291083119503e-09, -8.968407924106865e-12, -3.583483765666732e-14, -1.356755434176457e-16, -4.868389382595022e-19,
 -1.645223813172557e-21, -5.155136094328496e-24, -1.445817932554582e-26, -3.298404883684383e-29,  1.997641781631027e+00, -1.680876371310699e-05, -8.969635097128540e-08,
 -4.244689182447191e-10, -1.877710533199670e-12, -7.946401340263457e-15, -3.256119585678184e-17, -1.300809121157862e-19, -5.087623302788972e-22, -1.952998019561129e-24,
 -7.368981044053161e-27, -2.734774386422710e-29,  3.011936076524185e-04, -1.176456253433965e-06,  3.445948187495250e-09, -8.971054651294233e-12,  2.189010512852515e-14,
 -5.126982535707531e-17,  1.167011527320060e-19, -2.601898015754623e-22,  5.706586999462196e-25, -1.236356423985037e-27,  2.648217513178718e-30, -5.632112828753586e-33,
  2.710656966248118e-03, -1.058089075301295e-05,  3.094635463301936e-08, -8.035251009321977e-11,  1.952638312690986e-13, -4.546487691236053e-16,  1.026607207180653e-18,
 -2.264953094975450e-21,  4.901614367139032e-24, -1.044470742421860e-26,  2.192077818621443e-29, -4.549512897373246e-32,  7.529123943866388e-03, -2.935120589649439e-05,
  8.558866902365578e-08, -2.210542630846559e-10,  5.327327887012168e-13, -1.225550253541121e-15,  2.721755293909322e-18, -5.873709194624527e-21,  1.235120029753886e-23,
 -2.536975377145077e-26,  5.081083635638893e-29, -9.943392283762771e-32,  1.475565710107141e-02, -5.740995236877517e-05,  1.666548951514007e-07, -4.269673291483112e-10,
  1.015930269080029e-12, -2.293710943786260e-15,  4.961197777118906e-18, -1.032575556094205e-20,  2.067110001543498e-23, -3.972268463827812e-26,  7.255051238885089e-29,
 -1.246358304770674e-31,  2.438880502179154e-02, -9.464009940761832e-05,  2.730655860941656e-07, -6.919622766355205e-10,  1.617786083525270e-12, -3.557363347313347e-15,
  7.404307969048362e-18, -1.458031513281301e-20,  2.691622164022306e-23, -4.572683483586425e-26,  6.793500358420828e-29, -7.690326471273805e-32,  3.642654699922641e-02,
 -1.408839989217160e-04,  4.033770309302120e-07, -1.007932105661366e-09,  2.303114017672665e-12, -4.887597578871221e-15,  9.635279811334898e-18, -1.743170035450885e-20,
  2.791985609857332e-23, -3.588510333312836e-26,  2.134512546384763e-29,  7.036937585464256e-32,  5.086621758185262e-02, -1.959419915818143e-04,  5.557777283334977e-07,
 -1.364852847914988e-09,  3.029414222811411e-12, -6.134185575447270e-15,  1.119498757443735e-17, -1.765403588255465e-20,  2.086436283403781e-23, -4.977769061346224e-27,
 -7.298642643685357e-29,  3.086349488267330e-31,  6.770440946902750e-02, -2.595706443101802e-04,  7.280843564392285e-07, -1.750864930706020e-09,  3.747906422420159e-12,
 -7.132862511196584e-15,  1.161941396616919e-17, -1.416755994773455e-20,  3.893699628357980e-24,  4.799787018291585e-26, -2.057854390727864e-28,  5.833396177497804e-31,
  8.693685280190418e-02, -3.314806064294327e-04,  9.177375226149770e-07, -2.152379237990078e-09,  4.404813023236025e-12, -7.714042160742923e-15,  1.048353066345551e-17,
 -6.216062695017614e-21, -2.329850088050413e-23,  1.182795493119713e-25, -3.500217105579274e-28,  7.947205476231295e-31,  1.085582684051867e-01, -4.113340699783408e-04,
  1.121797666959259e-06, -2.554212770622107e-09,  4.942913715628948e-12, -7.712912290666555e-15,  7.449105828402184e-18,  6.457667628354806e-21, -5.898276419733976e-23,
  1.945386833573417e-25, -4.619624094534005e-28,  8.137916401948624e-31,  1.325621919871026e-01, -4.987418185426272e-04,  1.336941604033271e-06, -2.939759866154986e-09,
  5.303394557673441e-12, -6.980808761052383e-15,  2.314402803281887e-18,  2.345437429263017e-20, -9.909539924208444e-23,  2.591685631688075e-25, -4.869497732242482e-28,
  5.144745376137412e-31,  1.589407656860408e-01, -5.932598486341245e-04,  1.559460323840211e-06, -3.291206086566857e-09,  5.428014336266640e-12, -5.397698043253753e-15,
 -4.936889457756582e-18,  4.359770283332290e-20, -1.372176085733399e-22,  2.899478303060609e-25, -3.702518829097305e-28, -1.808973379450843e-31,  1.876844926483840e-01,
 -6.943855485243669e-04,  1.785258841628494e-06, -3.589793110758412e-09,  5.261608460328073e-12, -2.885501638900907e-15, -1.409089591954000e-17,  6.487193111132399e-20,
 -1.649183523872039e-22,  2.632489924973337e-25, -7.243047804653226e-29, -1.250124006855618e-30,  2.187819495174129e-01, -8.015534219633525e-04,  2.009859093943882e-06,
 -3.816144250940668e-09,  4.754944777257770e-12,  5.781339803387768e-16, -2.466722033932824e-17,  8.444158461494162e-20, -1.725331399883023e-22,  1.587734494536233e-25,
  4.125238685055020e-28, -2.526185913308391e-30,  2.522194507904894e-01, -9.141303490168236e-04,  2.228407133779127e-06, -3.950661496060279e-09,  3.867935194367233e-12,
  4.946188632702685e-15, -3.589622790809836e-17,  9.877719550815648e-20, -1.504219067922179e-22, -3.447693780396706e-26,  1.039454315220055e-27, -3.675693363773457e-30,
  2.879806579423078e-01, -1.031410384174642e-03,  2.435686189955131e-06, -3.974006181497436e-09,  2.573190102157629e-12,  1.008952502814832e-14, -4.671609757198425e-17,
  1.039100190066907e-19, -9.070033986713331e-23, -3.116394866920022e-25,  1.699340565272528e-27, -4.220029497955865e-30,  3.260461249960623e-01, -1.152609104035678e-03,
  2.626137535058376e-06, -3.867676348239210e-09,  8.598771179973838e-13,  1.578610452414382e-14, -5.579666744453797e-17,  9.583366958854834e-20,  1.063448056725000e-23,
 -6.459214069123883e-25,  2.217531541525238e-27, -3.616802823776451e-30,  3.663927708318279e-01, -1.276857534739850e-03,  2.793891562603002e-06, -3.614694364765347e-09,
 -1.262191173670088e-12,  2.171353940438855e-14, -6.159769823045295e-17,  7.106079763440086e-20,  1.513653210428430e-22, -9.845696815097661e-25,  2.369350885814312e-27,
 -1.411095243848360e-30,  4.089932669332433e-01, -1.403195714840931e-03,  2.932812016976278e-06, -3.200418110481173e-09, -3.758367359391551e-12,  2.744673122671645e-14,
 -6.246922998176487e-17,  2.732618466414352e-20,  3.208155826409138e-22, -1.248853737501759e-24,  1.918722153480597e-27,  2.550906651770024e-30,  4.538153274739780e-01,
 -1.530565985035453e-03,  3.036556955851747e-06, -2.613487480853823e-09, -6.565074193807735e-12,  3.246274819088300e-14, -5.680079509216013e-17, -3.559808900859965e-20,
  4.981777730013067e-22, -1.340281293148750e-24,  6.824942561139506e-28,  7.880260830594517e-30,  5.008208866255586e-01, -1.657806145374672e-03,  3.098660755023991e-06,
 -1.846914490852035e-09, -9.586094197767585e-12,  3.615549185298550e-14, -4.322380247918462e-17, -1.150463373022110e-19,  6.520408572293488e-22, -1.155127497153729e-24,
 -1.382848793010110e-27,  1.344559884828491e-29,  5.499651457314900e-01, -1.783642687507725e-03,  3.112642280246934e-06, -8.993188815387438e-10, -1.268965281052456e-11,
  3.786302679567175e-14, -2.086667237166050e-17, -2.046811514877175e-19,  7.418844475399725e-22, -6.085452106747017e-25, -4.085037933694516e-27,  1.732335535299398e-29,
  6.011954705635789e-01, -1.906684399474329e-03,  3.072145221537868e-06,  2.236994003208848e-10, -1.570685212304006e-11,  3.691058252594104e-14,  1.034563787813777e-17,
 -2.939717411126477e-19,  7.223592498675528e-22,  3.322990966575928e-25, -6.916419463996056e-27,  1.703176880933971e-29,  6.544501163126599e-01, -2.025416760227458e-03,
  2.971117454596402e-06,  1.508075850940213e-09, -1.843218829290612e-11,  3.267200780125433e-14,  4.936821134538858e-17, -3.681709635520466e-19,  5.510481770066304e-22,
  1.609770492522751e-24, -9.031451012280392e-27,  1.017216873832086e-29,  7.096567553768038e-01, -2.138197698493669e-03,  2.804037056749567e-06,  2.929734507712132e-09,
 -2.062708254659067e-11,  2.465160342200214e-14,  9.372652484478733e-17, -4.090895544304432e-19,  1.999757910928225e-22,  3.040302250562812e-24, -9.333125925597286e-27,
 -4.479152448875341e-30,  7.667307805827047e-01, -2.243255495261925e-03,  2.566193085437002e-06,  4.453062614413140e-09, -2.202755465624434e-11,  1.258642093607687e-14,
  1.392807265635494e-16, -3.969910302552446e-19, -3.297424292031177e-22,  4.295919941276978e-24, -6.719396930253017e-27, -2.556970486257754e-29,  8.255733545124133e-01,
 -2.338689871736966e-03,  2.254029145544254e-06,  6.029539019801740e-09, -2.235733190359480e-11, -3.434166585369081e-15,  1.801506295086537e-16, -3.138859717010680e-19,
 -9.921753201973487e-22,  4.922187203413822e-24, -5.148107819407887e-28, -4.790356025625445e-29,  8.860691745764282e-01, -2.422477635881578e-03,  1.865556699311973e-06,
  7.596712368468114e-09, -2.134775044729331e-11, -2.284005828093118e-14,  2.089152400429257e-16, -1.483348535638211e-19, -1.683899686647620e-21,  4.414352084577125e-24,
  8.953349930541953e-27, -6.212223599981154e-29,  9.480839240796936e-01, -2.492484670087316e-03,  1.400842378009305e-06,  9.077806382608936e-09, -1.876566382095988e-11,
 -4.445928830857102e-14,  2.172198349174141e-16,  9.849317301210528e-20, -2.240918321210736e-21,  2.367949660059548e-24,  1.979028507260783e-26, -5.641851742779197e-29,
  1.011461382800082e+00, -2.546486534631459e-03,  8.625683452824271e-07,  1.038232687634836e-08, -1.445006621375507e-11, -6.643051286470039e-14,  1.969201937234104e-16,
  4.063739488212165e-19, -2.453759258356200e-21, -1.299627835980175e-24,  2.828799594877853e-26, -2.120302658127263e-29,  1.076020178009742e+00, -2.582200530442397e-03,
  2.566558337163870e-07,  1.140815179532498e-08, -8.357047473238005e-12, -8.618769609525540e-14,  1.418446121293685e-16,  7.309461471073362e-19, -2.109491413945893e-21,
 -6.099767474843223e-24,  2.943623342382325e-26,  4.342388877489334e-29,  1.141550170458839e+00, -2.597332684493697e-03, -4.070721961848919e-07,  1.204568483269425e-08,
 -6.107540628298269e-13, -1.005676240987308e-13,  5.012927376613147e-17,  1.002781680929627e-18, -1.065246376048732e-21, -1.079779934808437e-23,  1.860625777144106e-26,
  1.198602024660719e-28,  1.207808492352208e+00, -2.589643731864990e-03, -1.114234494128469e-06,  1.218471229052078e-08,  8.445032713226638e-12, -1.060980770699823e-13,
 -7.314986529446804e-17,  1.134227585181296e-18,  6.534791316783925e-22, -1.347710729823715e-23, -5.542570449681032e-27,  1.705148561994141e-28,  1.274515289325490e+00,
 -2.557038655216416e-03, -1.845316119706711e-06,  1.172456553496127e-08,  1.820441709461537e-11, -9.951849746128544e-14, -2.136790884680004e-16,  1.037533578560352e-18,
  2.756704414457370e-21, -1.202733336536367e-23, -3.776087948662587e-26,  1.484188531775085e-28,  1.341349270198198e+00, -2.497684507741461e-03, -2.575288725063475e-06,
  1.058797095196438e-08,  2.778109185638585e-11, -7.855337035191379e-14, -3.470079214195594e-16,  6.556182711023812e-19,  4.649332032013715e-21, -5.145604373732065e-24,
 -6.462529769679101e-26,  2.567859599082047e-29,  1.407943241708017e+00, -2.410160777587898e-03, -3.273589042063198e-06,  8.738447708934517e-09,  3.603472760319125e-11,
 -4.288650488024302e-14, -4.404812676323993e-16,  1.402858360985213e-21,  5.519219241741838e-21,  6.352506649683142e-24, -6.773190971480062e-26, -1.680888139207718e-28,
  1.473879905198734e+00, -2.293644994827878e-03, -3.904669491652373e-06,  6.200156746673062e-09,  4.166573994610861e-11,  4.838581960612175e-15, -4.594211371741024e-16,
 -8.073689558035597e-19,  4.614660835590236e-21,  1.859762862192723e-23, -3.373160608972040e-26, -3.261616077142669e-28,  1.538688321391942e+00, -2.148133030661308e-03,
 -4.429377454575617e-06,  3.077610477458292e-09,  4.339904357007093e-11,  5.833289436405633e-14, -3.781072617723676e-16, -1.541113992502565e-18,  1.693291545673633e-21,
  2.522276666982795e-23,  3.141122226146607e-26, -3.059273913807942e-28,  1.601841606755639e+00, -1.974687887382560e-03, -4.807431031746197e-06, -4.293454472741284e-10,
  4.026238747670978e-11,  1.077910228189935e-13, -1.939213687236449e-16, -1.906695760761734e-18, -2.534242537175688e-21,  2.032919357155488e-23,  9.432829979224040e-26,
 -4.576923795423290e-29,  1.662756601225528e+00, -1.775702085446480e-03, -5.001203935071246e-06, -4.022033605481064e-09,  3.193233343591962e-11,  1.413750689976081e-13,
  6.043835543604170e-17, -1.664775954972006e-18, -6.320675550692793e-21,  3.286848331203490e-24,  1.071259682670276e-25,  3.141567958971834e-28,  1.720796419233845e+00,
 -1.555146788695351e-03, -4.980865147200752e-06, -7.319177255742033e-09,  1.906984739292227e-11,  1.483402539453099e-13,  3.151732072950703e-16, -7.883120502850722e-19,
 -7.530258283429067e-21, -1.784155899991109e-23,  4.534554017666744e-26,  4.663485568328277e-28,  1.775276921999016e+00, -1.318766322500105e-03, -4.730597128208726e-06,
 -9.900461054889562e-09,  3.508883942922861e-12,  1.233870388960735e-13,  4.807171511523254e-16,  4.267720422485525e-19, -5.008673174139094e-21, -2.904863972334347e-23,
 -5.480145025757847e-26,  2.134137741242687e-28,  1.825478163937344e+00, -1.074162221314817e-03, -4.255127313208614e-06, -1.138035577352393e-08, -1.187385236995560e-11,
  7.072527762360321e-14,  4.857740017558071e-16,  1.422537733354865e-18,  1.220606872809388e-22, -2.083956515456462e-23, -1.094116751261318e-25, -2.349950642250506e-28,
  1.870661685852081e+00, -8.307012735069107e-04, -3.585214678676979e-06, -1.150511663035807e-08, -2.374189036605360e-11,  5.346057791617896e-15,  3.221808041389153e-16,
  1.670754080827361e-18,  4.622968919471652e-21,  9.533177401584763e-25, -6.640057464297484e-26, -3.981862380614624e-28,  1.910094066413906e+00, -5.991844335642388e-04,
 -2.780220956321092e-06, -1.025136935962369e-08, -2.931246864036538e-11, -5.087035721009144e-14,  6.660523319414731e-17,  1.062518475465762e-18,  5.424265100597227e-21,
  1.740952196841899e-23,  2.481962590762438e-26, -1.183094031626716e-28,  1.943076350970290e+00, -3.912358689356755e-04, -1.925777258733981e-06, -7.890773256323292e-09,
 -2.751446714134358e-11, -7.836140056043965e-14, -1.500876947680803e-16,  6.918709820014193e-20,  2.480221068053495e-21,  1.506281725564098e-23,  6.226123158146037e-26,
  1.846375841502727e-28,  1.968977900111146e+00, -2.184185313493270e-04, -1.125181082821182e-06, -4.981237666040371e-09, -1.975308940528378e-11, -7.058123742019566e-14,
 -2.229279625933714e-16, -5.832105740632761e-19, -9.744240912972547e-22,  1.336120387209772e-24,  2.279382710762115e-26,  1.381708812187812e-28,  1.987272135209303e+00,
 -9.114991853674056e-05, -4.846919322940145e-07, -2.260700848813096e-09, -9.718802446754911e-12, -3.926075325313465e-14, -1.500728059249634e-16, -5.425699451367472e-19,
 -1.841572972620805e-21, -5.762987640042448e-24, -1.594572222289114e-26, -3.453409946727674e-29,  1.997573078437600e+00, -1.754723212689206e-05, -9.497562382998290e-08,
 -4.558274431104967e-10, -2.044758061546766e-12, -8.773483970185247e-15, -3.644237619325297e-17, -1.475455629843701e-19, -5.846792728933342e-22, -2.273303205124490e-24,
 -8.684639946036551e-27, -3.261791441374286e-29,  2.965422443138153e-04, -1.149313401402261e-06,  3.340363629953169e-09, -8.628866403393544e-12,  2.089213728014387e-14,
 -4.855439837002815e-17,  1.096649452233772e-19, -2.426208951235463e-22,  5.279983537916468e-25, -1.135221031113090e-27,  2.412477779577458e-30, -5.093014322173165e-33,
  2.668822512200450e-03, -1.033712440714564e-05,  3.000057404974586e-08, -7.729971514804065e-11,  1.864121948514933e-13, -4.307538376315874e-16,  9.653291012228657e-19,
 -2.113952196594956e-21,  4.540917134934862e-24, -9.606632901852036e-27,  2.001379010091111e-29, -4.125972112295079e-32,  7.413071941002895e-03, -2.867696408566675e-05,
  8.298636269700632e-08, -2.127231324619631e-10,  5.088619106170183e-13, -1.162157860920699e-15,  2.562690220920243e-18, -5.492699904636639e-21,  1.147344232882675e-23,
 -2.342222434753669e-26,  4.662841789985634e-29, -9.081254226416565e-32,  1.452865170597470e-02, -5.609693475122189e-05,  1.616273233489363e-07, -4.110730661652764e-10,
  9.712236996237024e-13, -2.178038205879700e-15,  4.681126226896587e-18, -9.686611102146865e-21,  1.929202259285194e-23, -3.692766250593544e-26,  6.726581404759040e-29,
 -1.156807346449289e-31,  2.401456169858463e-02, -9.248835421547385e-05,  2.649150292794554e-07, -6.666373592899299e-10,  1.548383278960347e-12, -3.384463115353831e-15,
  7.007873839867203e-18, -1.374481684415728e-20,  2.531815539786127e-23, -4.307687123472722e-26,  6.457015513219554e-29, -7.594746491389684e-32,  3.586938930789727e-02,
 -1.377047443166680e-04,  3.914997590438980e-07, -9.718518967350101e-10,  2.207635514876352e-12, -4.662108144165099e-15,  9.159507295145096e-18, -1.655876424841408e-20,
  2.664406011364860e-23, -3.497449038624416e-26,  2.406386222396297e-29,  5.365916798557944e-32,  5.009123948148287e-02, -1.915604679211246e-04,  5.396863161931012e-07,
 -1.317349258489662e-09,  2.909377658106232e-12, -5.871362369262703e-15,  1.070999099760841e-17, -1.698978110148550e-20,  2.063577326674635e-23, -7.637902010648381e-27,
 -6.031489407904734e-29,  2.681671951042615e-31,  6.667764460078009e-02, -2.538290022889733e-04,  7.074291173105826e-07, -1.692024668835240e-09,  3.608005778859882e-12,
 -6.858741255507898e-15,  1.122471538840901e-17, -1.401685435836309e-20,  5.479474372779173e-24,  4.026133803562194e-26, -1.814870459354087e-28,  5.221131447078303e-31,
  8.562545227182697e-02, -3.242408339796215e-04,  8.923267866587013e-07, -2.083122866483208e-09,  4.253033710297238e-12, -7.464606429750865e-15,  1.029966443366260e-17,
 -6.896120654886079e-21, -1.928420490456523e-23,  1.049583890829931e-25, -3.165154236362846e-28,  7.289384356423191e-31,  1.069306886504761e-01, -4.024809580433539e-04,
  1.091616574530323e-06, -2.476350445783102e-09,  4.790456825936204e-12, -7.532170910786367e-15,  7.604524062799133e-18,  4.678776444054408e-21, -5.230346177187949e-23,
  1.767645725717271e-25, -4.270381084131428e-28,  7.733087902526582e-31,  1.305883943793867e-01, -4.881859622507557e-04,  1.302169014554018e-06, -2.856019247704736e-09,
  5.164385217848530e-12, -6.917732265288552e-15,  2.928106621995781e-18,  2.042888811405905e-20, -9.011040745934666e-23,  2.401510238159406e-25, -4.637586354118412e-28,
  5.376545934556957e-31,  1.565924295985135e-01, -5.809406757599601e-04,  1.520483357956402e-06, -3.205227520331550e-09,  5.318971877753641e-12, -5.502021198671333e-15,
 -3.776078526953275e-18,  3.937087768406105e-20, -1.270476402078253e-22,  2.750162323738109e-25, -3.754387649463174e-28, -5.875403422926957e-32,  1.849352437860046e-01,
 -6.802743612054718e-04,  1.742684476422424e-06, -3.506086823219883e-09,  5.200660697152977e-12, -3.202473782739021e-15, -1.234694515506062e-17,  5.974551284592543e-20,
 -1.555061365501093e-22,  2.593235199947054e-25, -1.221219205521842e-28, -1.013757180365074e-30,  2.156076053748985e-01, -7.856564301171385e-04,  1.964522117174923e-06,
 -3.740004006394729e-09,  4.760775636007164e-12,  1.387457481769731e-17, -2.237927005965802e-17,  7.901495084062301e-20, -1.665461669697639e-22,  1.731497153201689e-25,
  3.086705605394199e-28, -2.199251578331089e-30,  2.485982851531107e-01, -8.964916644013058e-04,  2.181373633009702e-06, -3.888029020889241e-09,  3.958465084071485e-12,
  4.117323507319984e-15, -3.319798662818749e-17,  9.395155007513736e-20, -1.509527257684949e-22,  3.967596383351039e-27,  8.852516350046604e-28, -3.335360646204259e-30,
  2.838936863680105e-01, -1.012114932098819e-03,  2.388251606473114e-06, -3.931280750455088e-09,  2.764002669908097e-12,  9.002914574109558e-15, -4.384884593849179e-17,
  1.008408632465605e-19, -1.007400136086853e-22, -2.473163121799788e-25,  1.518429063293859e-27, -3.999009762789771e-30,  3.214774131983164e-01, -1.131785394806650e-03,
  2.579818152720598e-06, -3.851464383722579e-09,  1.162425468821829e-12,  1.447920219112675e-14, -5.311193593351484e-17,  9.581872867627619e-20, -1.106066087839065e-23,
 -5.604282844963534e-25,  2.056636281568144e-27, -3.684075525196577e-30,  3.613297677992777e-01, -1.254680218398412e-03,  2.750408132491711e-06, -3.631494894704875e-09,
 -8.425399751599375e-13,  2.025958631190848e-14, -5.954538306661414e-17,  7.535553593398038e-20,  1.176103045628178e-22, -8.911978527056343e-25,  2.295498209980724e-27,
 -1.925147486803450e-30,  4.034271644455000e-01, -1.379887819859179e-03,  2.894064048116485e-06, -3.256241690621575e-09, -3.224357553202438e-12,  2.595777036714175e-14,
 -6.156702344265385e-17,  3.688795653889274e-20,  2.772624857793292e-22, -1.170175562658160e-24,  2.007647372771170e-27,  1.515675032543151e-30,  4.477414473635400e-01,
 -1.506400713627293e-03,  3.004586043596942e-06, -2.713409003534341e-09, -5.929523035781866e-12,  3.108932518315339e-14, -5.758157018158319e-17, -2.042248158986317e-20,
  4.504986047416195e-22, -1.306484578881285e-24,  9.967158142847741e-28,  6.421549969678731e-30,  4.942390966415667e-01, -1.633108064062774e-03,  3.075601193246511e-06,
 -1.994564536475841e-09, -8.873606977408704e-12,  3.508178402620549e-14, -4.615930671243842e-17, -9.485592881029756e-20,  6.095990716509046e-22, -1.199062055665257e-24,
 -8.250863259178788e-28,  1.190743832487719e-29,  5.428803041125246e-01, -1.758788110792089e-03,  3.100657143246951e-06, -1.096324352931149e-09, -1.193785071838339e-11,
  3.729611511247397e-14, -2.626889011431219e-17, -1.813214334648884e-19,  7.172167347045976e-22, -7.569856235873539e-25, -3.344353938970783e-27,  1.631222839616158e-29,
  5.936178983330119e-01, -1.882100716216557e-03,  3.073346153688954e-06, -2.169380122587864e-11, -1.496681070781868e-11,  3.706272456209967e-14,  2.439472321802219e-18,
 -2.707167622128342e-19,  7.295239139607789e-22,  7.074645916072961e-26, -6.159109600096368e-27,  1.732148749210567e-29,  6.463960947528086e-01, -2.001580396442611e-03,
  2.987466637298922e-06,  1.218449267172394e-09, -1.776772426169258e-11,  3.373518309714053e-14,  3.931451422213769e-17, -3.496789978082008e-19,  6.026117216138622e-22,
  1.258178831141747e-24, -8.531510693665987e-27,  1.245477202812110e-29,  7.011490439651386e-01, -2.115630347104545e-03,  2.837230326269596e-06,  2.603763782649479e-09,
 -2.011247977040080e-11,  2.676440758902385e-14,  8.237754506772723e-17, -4.010114700831215e-19,  3.026717779668364e-22,  2.664395522821639e-24, -9.429547713386499e-27,
  4.715434614590380e-33,  7.577991476918884e-01, -2.222518174775302e-03,  2.617524076548352e-06,  4.102813390335546e-09, -2.174330480156000e-11,  1.579471803114988e-14,
  1.280401205651131e-16, -4.051223067767823e-19, -1.801823508345953e-22,  4.006405108822270e-24, -7.713035371144545e-27, -1.962573766162064e-29,  8.162551091465664e-01,
 -2.320374305602727e-03,  2.324235796009830e-06,  5.671504108464694e-09, -2.238350882542150e-11,  7.805586195368969e-16,  1.709439148707295e-16, -3.428084074436042e-19,
 -8.158412005877371e-22,  4.860987076864744e-24, -2.505863000137714e-27, -4.250693136257592e-29,  8.764096820491437e-01, -2.407194379635925e-03,  1.954653667592112e-06,
  7.251764857667635e-09, -2.175477921578005e-11, -1.788187283375424e-14,  2.040318294887769e-16, -1.996131812559840e-19, -1.519191854473315e-21,  4.718223045817038e-24,
  6.252891315733033e-27, -6.038289785162106e-29,  9.381370814978893e-01, -2.480847366351201e-03,  1.507946127493466e-06,  8.770726322940172e-09, -1.960253496876577e-11,
 -3.922093761746267e-14,  2.189875883234863e-16,  2.829554857068705e-20, -2.142036818066680e-21,  3.108248019790491e-24,  1.718720167909438e-26, -6.155821212631234e-29,
  1.001290021132095e+00, -2.539091665884659e-03,  9.857260592797609e-07,  1.014075742737340e-08, -1.573053997946662e-11, -6.157679483487255e-14,  2.071938917448671e-16,
  3.273213790370066e-19, -2.480440682643532e-21, -1.908437567123725e-25,  2.705341555418015e-26, -3.462466507468298e-29,  1.065696346020577e+00, -2.579602095373012e-03,
  3.926951126525739e-07,  1.126084078860635e-08, -1.004514115569521e-11, -8.254565011130998e-14,  1.613346803341407e-16,  6.601596079492262e-19, -2.307479129854227e-21,
 -4.889668848222262e-24,  3.093085248241347e-26,  2.450859238308517e-29,  1.131155241602298e+00, -2.600011387707308e-03, -2.626487475608475e-07,  1.201989678903965e-08,
 -2.607822622234883e-12, -9.903179260640589e-14,  7.767257530352152e-17,  9.626279551494584e-19, -1.439340266255539e-21, -9.952576649517298e-24,  2.353792471380603e-26,
  1.038139936377082e-28,  1.197433018740533e+00, -2.597970606414216e-03, -9.672775276243339e-07,  1.230277256878283e-08,  6.308097937763230e-12, -1.074706598564892e-13,
 -4.117189235027710e-17,  1.147348003975015e-18,  1.661223959566934e-22, -1.354865624271950e-23,  1.957577537382203e-27,  1.694808368427154e-28,  1.264258507502531e+00,
 -2.571233606455598e-03, -1.702940266626225e-06,  1.199964466278637e-08,  1.616516707296094e-11, -1.042886262340225e-13, -1.834602388243992e-16,  1.118542074972280e-18,
  2.298172870584878e-21, -1.339993367038160e-23, -3.069963555277565e-26,  1.716754854827395e-28,  1.331318142740278e+00, -2.517771160788056e-03, -2.445619382030653e-06,
  1.101945392566698e-08,  2.612831558608637e-11, -8.664464967374534e-14, -3.265990974634177e-16,  8.009371043765153e-19,  4.417950058699693e-21, -7.695092060824088e-24,
 -6.252938282902500e-26,  6.954437065738537e-29,  1.398250899041710e+00, -2.435920311906178e-03, -3.165298500485798e-06,  9.307567497165155e-09,  3.507138915369913e-11,
 -5.343743417672300e-14, -4.379388060326760e-16,  1.811402421770305e-19,  5.697464361703898e-21,  3.506877023466781e-24, -7.424912700872613e-26, -1.268586255686375e-28,
  1.464643337723861e+00, -2.324573406730476e-03, -3.826266467049753e-06,  6.866976295646212e-09,  4.165050822740864e-11, -6.441506061149289e-15, -4.798614687477467e-16,
 -6.492760613577766e-19,  5.256429971329718e-21,  1.696150545158510e-23, -4.804796259222775e-26, -3.224948046371711e-28,  1.530025169906428e+00, -2.183408435064823e-03,
 -4.388242957876847e-06,  3.780820835386621e-09,  4.447149570199065e-11,  4.874747573218070e-14, -4.203617817476247e-16, -1.472185155866898e-18,  2.620535868023239e-21,
  2.619391218147007e-23,  1.675984786265708e-26, -3.589003955055892e-28,  1.593865919353936e+00, -2.013156830739909e-03, -4.808647714938962e-06,  2.318281348430314e-10,
  4.236729802270388e-11,  1.024877985155573e-13, -2.483290068883357e-16, -1.975359021545801e-18, -1.735172807068545e-21,  2.403860956096162e-23,  9.054683230214936e-26,
 -1.275134151464604e-28,  1.655573480492106e+00, -1.815895873623629e-03, -5.046309315780387e-06, -3.488433706020482e-09,  3.477044676229287e-11,  1.422435088044488e-13,
  1.101680439197834e-17, -1.864290893865925e-18, -6.121979237078401e-21,  7.837945505938036e-24,  1.201371696909881e-25,  2.740754472209630e-28,  1.714495589602648e+00,
 -1.595339615274682e-03, -5.066765354761900e-06, -6.989922273050550e-09,  2.211036295477383e-11,  1.556117287030876e-13,  2.896330886250676e-16, -1.039165900159025e-18,
 -8.134816718952570e-21, -1.560169413927592e-23,  6.701809044731751e-26,  5.171262094017116e-28,  1.769925416319756e+00, -1.357085175600238e-03, -4.848982331724465e-06,
 -9.823946405908139e-09,  6.092867000105436e-12,  1.350485536531908e-13,  4.902627696992700e-16,  2.493594320510307e-19, -6.091366448692572e-21, -3.102506055035845e-23,
 -4.330773670229522e-26,  3.111263692175137e-28,  1.821112563695475e+00, -1.108752614900325e-03, -4.392782704723616e-06, -1.155837437640320e-08, -1.033953551360834e-11,
  8.286154381871798e-14,  5.255408211970311e-16,  1.413575739838233e-18, -7.093487468179186e-22, -2.541342449580098e-23, -1.190144542073147e-25, -1.982955486329140e-28,
  1.867280633831695e+00, -8.599416833930508e-04, -3.725550366242398e-06, -1.188369517664963e-08, -2.355377008789856e-11,  1.365649963400280e-14,  3.710343095334368e-16,
  1.818690272019370e-18,  4.605098811980833e-21, -2.070552523667610e-24, -8.522511321141353e-26, -4.574763586217868e-28,  1.907652054683118e+00, -6.219263166425250e-04,
 -2.906084650217274e-06, -1.072841078626060e-08, -3.031137688649092e-11, -4.889462557294807e-14,  9.888134375691458e-17,  1.246303257062579e-18,  6.067468410711286e-21,
  1.828096602665056e-23,  1.830068591372069e-26, -1.803879659613561e-28,  1.941479984635452e+00, -4.070284484338368e-04, -2.023160276947755e-06, -8.343737442425380e-09,
 -2.911751074251514e-11, -8.193077125880940e-14, -1.469542770377310e-16,  1.577271209434507e-19,  3.069301432935263e-21,  1.771931965571814e-23,  7.064598762890005e-26,
  1.958787005792804e-28,  1.968085836785317e+00, -2.276645614601314e-04, -1.186899771982689e-06, -5.308876407498810e-09, -2.121955758383790e-11, -7.613093975235150e-14,
 -2.396858434451383e-16, -6.134341313123118e-19, -9.083630971321488e-22,  2.378769498024049e-24,  2.958004120648717e-26,  1.713328919217502e-28,  1.986899604838642e+00,
 -9.513867212400226e-05, -5.127799079265201e-07, -2.422684390990680e-09, -1.054130077893796e-11, -4.305165939989287e-14, -1.661218733323981e-16, -6.049458534319348e-19,
 -2.060890491982843e-21, -6.431506517602916e-24, -1.748601691678877e-26, -3.532314651674650e-29,  1.997501334453059e+00, -1.832948666056094e-05, -1.006477982849174e-07,
 -4.899962940522094e-10, -2.229319800909688e-12, -9.699868595864217e-15, -4.084838616521632e-17, -1.676346803058420e-19, -6.731331237815976e-22, -2.651178845819377e-24,
 -1.025546790759347e-26, -3.898227921843793e-29,  2.919977886588731e-04, -1.122999068173592e-06,  3.238791289383736e-09, -8.302220183440489e-12,  1.994682834478728e-14,
 -4.600208817020024e-17,  1.031020898936865e-19, -2.263606402904078e-22,  4.888147120074443e-25, -1.043057616496967e-27,  2.199214564644905e-30, -4.609402530885825e-33,
  2.627948219707545e-03, -1.010078014362408e-05,  2.909059276440660e-08, -7.438480168873970e-11,  1.780240861640370e-13, -4.082801213016424e-16,  9.081218608316548e-19,
 -1.974025243864026e-21,  4.209061297150835e-24, -8.841238485454317e-27,  1.828369639524381e-29, -3.744680388827923e-32,  7.299675892606358e-03, -2.802314722903463e-05,
  8.048177951039647e-08, -2.047639969557299e-10,  4.862215527639992e-13, -1.102458121257050e-15,  2.413910486536683e-18, -5.138688653323191e-21,  1.066287332364700e-23,
 -2.163464268065382e-26,  4.280770199351450e-29, -8.298028278115015e-32,  1.430681913122488e-02, -5.482338677017239e-05,  1.567862660489974e-07, -3.958759598726647e-10,
  9.287647919501706e-13, -2.068877327850402e-15,  4.418347735035384e-18, -9.090027226205143e-21,  1.800985428525084e-23, -3.433632961595468e-26,  6.236160113040827e-29,
 -1.073364884933349e-31,  2.364879684562262e-02, -9.040061649988848e-05,  2.570618212647546e-07, -6.423957318792692e-10,  1.482345200259751e-12, -3.220802266455321e-15,
  6.634131886019014e-18, -1.295895618067764e-20,  2.381307678613215e-23, -4.056049809189212e-26,  6.125924898328378e-29, -7.447390072549919e-32,  3.532476130451712e-02,
 -1.346188016680808e-04,  3.800464305643033e-07, -9.372638777234547e-10,  2.116554571478450e-12, -4.447748525587886e-15,  8.707610503102504e-18, -1.572610950344222e-20,
  2.540283358323123e-23, -3.396905936931124e-26,  2.610448946002299e-29,  3.948436484831435e-32,  4.933353357786195e-02, -1.873054276397976e-04,  5.241535950475278e-07,
 -1.271724828514432e-09,  2.794482660241239e-12, -5.619956802969325e-15,  1.024347742757746e-17, -1.633427899551440e-20,  2.032012636608474e-23, -9.825357828847727e-27,
 -4.931824668982443e-29,  2.324128779360357e-31,  6.567352023547461e-02, -2.482498154878727e-04,  6.874667101195875e-07, -1.635379471012809e-09,  3.473493203121903e-12,
 -6.594036645215966e-15,  1.083490643149680e-17, -1.381967780221742e-20,  6.803595228070292e-24,  3.344457669119612e-26, -1.597553220108640e-28,  4.665953952794439e-31,
  8.434260946547256e-02, -3.172010640180478e-04,  8.677327201803242e-07, -2.016255300246546e-09,  4.106197514883722e-12, -7.219797906060078e-15,  1.009848470320660e-17,
 -7.455141055562963e-21, -1.572603319341984e-23,  9.292074933852794e-26, -2.858169630657851e-28,  6.670986802547160e-31,  1.053380443053837e-01, -3.938655986485189e-04,
  1.062355314038600e-06, -2.400898326401015e-09,  4.641648152040821e-12, -7.348273630046590e-15,  7.713031379909376e-18,  3.103651144990652e-21, -4.623931651591532e-23,
  1.603512306950039e-25, -3.939364429242482e-28,  7.311091263050918e-31,  1.286562701464470e-01, -4.779043048346381e-04,  1.268388011745006e-06, -2.774491914408721e-09,
  5.026778000303280e-12, -6.840911577654264e-15,  3.461020468072941e-18,  1.768014839222058e-20, -8.179313515989972e-23,  2.220781015805988e-25, -4.397997805740394e-28,
  5.497270687794357e-31,  1.542927530633305e-01, -5.689292214501695e-04,  1.482527602733013e-06, -3.121008851023996e-09,  5.208112152260532e-12, -5.579868828257704e-15,
 -2.729143590908694e-18,  3.546086098597073e-20, -1.174177101536580e-22,  2.599779404765674e-25, -3.757470969107839e-28,  4.134589827986332e-32,  1.822417648207145e-01,
 -6.664997679514777e-04,  1.701108533714506e-06, -3.423404189516356e-09,  5.133780587860996e-12, -3.479279693992884e-15, -1.074234129385183e-17,  5.491766059488899e-20,
 -1.462685918129066e-22,  2.536093495928976e-25, -1.620843254784845e-28, -8.074529900512725e-31,  2.124961295959315e-01, -7.701184786058901e-04,  1.920099020215843e-06,
 -3.663857817392735e-09,  4.755858220919529e-12, -4.972752738100804e-16, -2.024051111305402e-17,  7.378740680689119e-20, -1.601130342389784e-22,  1.836509597445564e-25,
  2.185611224192832e-28, -1.901372497061814e-30,  2.450469265113808e-01, -8.792262180462490e-04,  2.135099877032557e-06, -3.824077213355080e-09,  4.033054299965473e-12,
  3.351594073327490e-15, -3.063490148416965e-17,  8.912990112362030e-20, -1.502069906170341e-22,  3.653994141933209e-26,  7.457497224468295e-28, -3.008072358439601e-30,
  2.798831409669384e-01, -9.931968555966478e-04,  2.341347341037131e-06, -3.885672466949838e-09,  2.933764029402431e-12,  7.984052709670891e-15, -4.107169016820965e-17,
  9.748611088098910e-20, -1.085919024356666e-22, -1.900282888926097e-25,  1.347734997094062e-27, -3.757096580269257e-30,  3.169912564730665e-01, -1.111331382132628e-03,
  2.533721507379757e-06, -3.830617250593805e-09,  1.439479681129530e-12,  1.323665274391182e-14, -5.043688838543544e-17,  9.515754067161774e-20, -2.979441179714917e-23,
 -4.814088365836217e-25,  1.894350861571411e-27, -3.682258199709277e-30,  3.563547771786257e-01, -1.232851463970604e-03,  2.706762431702656e-06, -3.641810923014552e-09,
 -4.514661601050064e-13,  1.885621284177091e-14, -5.738743645985162e-17,  7.862328366221364e-20,  8.715837739114044e-23, -8.011966325051580e-25,  2.201682112221457e-27,
 -2.320892020965499e-30,  3.979536695296759e-01, -1.356892445164622e-03,  2.854696482575128e-06, -3.303758082894737e-09, -2.719889551268778e-12,  2.449352037139422e-14,
 -6.041616888096976e-17,  4.510194794829237e-20,  2.365952465702965e-22, -1.088808123390344e-24,  2.054242951583580e-27,  6.256130816655953e-31,  4.417637094513947e-01,
 -1.482495834973857e-03,  2.971476176611276e-06, -2.803382332113206e-09, -5.321594191606163e-12,  2.970209137736889e-14, -5.795858904510169e-17, -6.750838336964145e-21,
  4.042472042510523e-22, -1.261367964296858e-24,  1.249365330693967e-27,  5.083039735280040e-30,  4.877557190798437e-01, -1.608601354306724e-03,  3.050837509166472e-06,
 -2.130990218289343e-09, -8.183253441558553e-12,  3.394425329481591e-14, -4.854870126861076e-17, -7.604479008803847e-20,  5.659609427291756e-22, -1.222036747470768e-24,
 -3.347217137882584e-28,  1.038752735300922e-29,  5.358946743533136e-01, -1.734038667851286e-03,  3.086379717214063e-06, -1.281398520492057e-09, -1.119863089352999e-11,
  3.660730513475645e-14, -3.102884999993136e-17, -1.588309560989083e-19,  6.877272513523627e-22, -8.767410508880111e-25, -2.651987818605765e-27,  1.513636171242066e-29,
  5.861386616849049e-01, -1.857519002918611e-03,  3.071673479021233e-06, -2.552320852990619e-10, -1.422557109157915e-11,  3.703294971446094e-14, -4.813717787814161e-18,
 -2.473773042891173e-19,  7.278199170387709e-22, -1.603788920110718e-25, -5.397912242801161e-27,  1.721893328968959e-29,  6.384376584805780e-01, -1.977626959006210e-03,
  3.000404749260868e-06,  9.396112851799294e-10, -1.708436675758470e-11,  3.456345786365171e-14,  2.979981839736816e-17, -3.297354697675370e-19,  6.419005606841212e-22,
  9.284218220333255e-25, -7.943901212893924e-27,  1.416326218980643e-29,  6.927321084792880e-01, -2.092812953066386e-03,  2.866562695693906e-06,  2.286350035026987e-09,
 -1.955832447886725e-11,  2.860790930502346e-14,  7.129872192672196e-17, -3.898640048158434e-19,  3.918117354305539e-22,  2.288411318821476e-24, -9.341180961079597e-27,
  3.914885798279304e-30,  7.489512588753963e-01, -2.201386936225547e-03,  2.664681434764221e-06,  3.757610765911992e-09, -2.139760243899518e-11,  1.873103939051992e-14,
  1.166372231402911e-16, -4.086415843128857e-19, -4.169776362990802e-23,  3.682311131860531e-24, -8.450194623837382e-27, -1.393400923350664e-29,  8.070112221393050e-01,
 -2.301514272733568e-03,  2.390146256659556e-06,  5.313712452953948e-09, -2.232766316601805e-11,  4.765239785263456e-15,  1.610059316502673e-16, -3.661382999933831e-19,
 -6.430852512176240e-22,  4.725040681385208e-24, -4.248902321399248e-27, -3.666770137935859e-29,  8.668127217359056e-01, -2.391215008343685e-03,  2.039575441447949e-06,
  6.901091350943269e-09, -2.206392947485146e-11, -1.305751380766906e-14,  1.977879117760978e-16, -2.454665012183391e-19, -1.345466727959129e-21,  4.916023298182355e-24,
  3.659727479606072e-27, -5.728287854359541e-29,  9.282384781420907e-01, -2.468368192117050e-03,  1.611288039600037e-06,  8.451096104627215e-09, -2.033437210039910e-11,
 -3.396336579436654e-14,  2.188379679982816e-16, -3.833195731582062e-20, -2.018427709331526e-21,  3.740512884856500e-24,  1.440367406968042e-26, -6.463083179616033e-29,
  9.911501906213714e-01, -2.530723471587349e-03,  1.105865259198417e-06,  9.879489636086567e-09, -1.691165333172711e-11, -5.650312968218467e-14,  2.152480907881435e-16,
  2.480430090985534e-19, -2.468232227176184e-21,  8.572855179876493e-25,  2.526912412349652e-26, -4.614377698924128e-29,  1.055385072563791e+00, -2.575922870464308e-03,
  5.268070867198456e-07,  1.108712773912587e-08, -1.165588037378434e-11, -7.846030206622823e-14,  1.787606488409362e-16,  5.837443907768202e-19, -2.461027455463863e-21,
 -3.636389471457460e-24,  3.159748463839807e-26,  5.896348191591456e-30,  1.120751905984684e+00, -2.601536481794854e-03, -1.187253451529230e-07,  1.196243689171118e-08,
 -4.567662094988496e-12, -9.684973681101821e-14,  1.039288159929938e-16,  9.110267142766206e-19, -1.779633090787767e-21, -8.925031855317768e-24,  2.770331860296518e-26,
  8.515434316901734e-29,  1.187026597091715e+00, -2.605116741399230e-03, -8.191097540842410e-07,  1.238646406985906e-08,  4.151406866890659e-12, -1.080731254274903e-13,
 -9.044858908237167e-18,  1.144889509468338e-18, -3.184358084613482e-22, -1.332273698466043e-23,  9.290965391875050e-27,  1.629759701365075e-28,  1.253947244001974e+00,
 -2.584276908738884e-03, -1.557462250620339e-06,  1.224137271584674e-08,  1.403794197150034e-11, -1.083079854719979e-13, -1.511856021517467e-16,  1.184143362647512e-18,
  1.795543756960886e-21, -1.447124200160090e-23, -2.273804403369827e-26,  1.892022813541903e-28,  1.321208775521711e+00, -2.536800209581835e-03, -2.310936160131388e-06,
  1.142322585476258e-08,  2.431893674867928e-11, -9.419821090422988e-14, -3.022386659506033e-16,  9.374031546991984e-19,  4.096758968669904e-21, -1.012236213221644e-23,
 -5.852322736194041e-26,  1.122004332455183e-28,  1.388457293748871e+00, -2.460786482177397e-03, -3.050277950114195e-06,  9.859590758353032e-09,  3.389805287655414e-11,
 -6.386640446498011e-14, -4.302995819170353e-16,  3.648957560815161e-19,  5.769031796168387e-21,  4.390360056084176e-25, -7.879085804262892e-26, -7.854816579428440e-29,
  1.455284361699394e+00, -2.354842608552194e-03, -3.739870597091286e-06,  7.531722214903904e-09,  4.140513937145986e-11, -1.815678055441072e-14, -4.955973264399633e-16,
 -4.716989426082113e-19,  5.829064167584786e-21,  1.475974291219464e-23, -6.191846536557261e-26, -3.057794521856580e-28,  1.521221628791401e+00, -2.218320732614900e-03,
 -4.338573484398650e-06,  4.499602377448977e-09,  4.534227215742093e-11,  3.817448977528548e-14, -4.602664651738918e-16, -1.373142656355640e-18,  3.571651136166404e-21,
  2.653467647042973e-23, -4.519586834234654e-29, -4.032731157886283e-28,  1.585736387758139e+00, -2.051603207220061e-03, -4.801731975337312e-06,  9.257602221259842e-10,
  4.435294597344569e-11,  9.585873164615831e-14, -3.042814073329396e-16, -2.016351796264011e-18, -8.061747483679292e-22,  2.752254701522232e-23,  8.300309591891814e-26,
 -2.162836205740823e-28,  1.648228904564513e+00, -1.856424119192492e-03, -5.084738679557393e-06, -2.909351373153920e-09,  3.761361958110752e-11,  1.418596677397577e-13,
 -4.387682399136214e-17, -2.054729467019193e-18, -5.750553021110539e-21,  1.286841702807707e-23,  1.309485323969552e-25,  2.139413032174652e-28,  1.708032640467034e+00,
 -1.636203001430848e-03, -5.148417928362620e-06, -6.610891336168002e-09,  2.528959848707478e-11,  1.621838482293354e-13,  2.568115593695392e-16, -1.307903966105869e-18,
 -8.642626733070982e-21, -1.245354197119363e-23,  9.066924094240812e-26,  5.554475917345388e-28,  1.764418747895663e+00, -1.396346716984256e-03, -4.966193564944692e-06,
 -9.704211498376946e-09,  8.911948428962277e-12,  1.468755752405037e-13,  4.943457745826441e-16,  3.625957812501060e-20, -7.235866184684023e-21, -3.245214196825821e-23,
 -2.724903382080641e-26,  4.205496260460187e-28,  1.816606386477508e+00, -1.144452360393327e-03, -4.532418847511852e-06, -1.170985039243731e-08, -8.552985814883287e-12,
  9.594604136348062e-14,  5.646589711556354e-16,  1.375303480443550e-18, -1.711887782869041e-21, -3.033309376404483e-23, -1.265464440039094e-25, -1.402148266127367e-28,
  1.863780346118215e+00, -8.903228863284794e-04, -3.870405241725390e-06, -1.225786901697509e-08, -2.318738139244260e-11,  2.318896163983878e-14,  4.240045916720683e-16,
  1.964162452102853e-18,  4.464188759157289e-21, -5.899338383734678e-24, -1.066342200761040e-25, -5.150818745597449e-28,  1.905117024966500e+00, -6.456982756780893e-04,
 -3.037767291225442e-06, -1.122107474789755e-08, -3.126259527325383e-11, -4.608016272116002e-14,  1.365959085166814e-16,  1.451116566426434e-18,  6.736651909039180e-21,
  1.883261351088108e-23,  8.716874186089052e-27, -2.579694213516316e-28,  1.939818854806368e+00, -4.236222757810536e-04, -2.126135097731697e-06, -8.822916457102429e-09,
 -3.079097753641034e-11, -8.539296966659469e-14, -1.410629869233376e-16,  2.667134869895751e-19,  3.760161049492589e-21,  2.071985910798098e-23,  7.942828894826699e-26,
  2.023316922677161e-28,  1.967155776365048e+00, -2.374204752020921e-04, -1.252694641350489e-06, -5.660888727431359e-09, -2.280110885868810e-11, -8.209271083513605e-14,
 -2.572543551543585e-16, -6.408878130098503e-19, -7.995115480807629e-22,  3.723982360863520e-24,  3.797172267281572e-26,  2.113212202458207e-28,  1.986510657411662e+00,
 -9.936013434704701e-05, -5.428932173518628e-07, -2.598455987826114e-09, -1.144361467331800e-11, -4.724951718586554e-14, -1.840194235281094e-16, -6.747369301333811e-19,
 -2.305389282778559e-21, -7.162018803825110e-24, -1.903679591567479e-26, -3.492935023915445e-29,  1.997426368025983e+00, -1.915881034191338e-05, -1.067483474397412e-07,
 -5.272722969690334e-10, -2.433513945286388e-12, -1.073908027059776e-14, -4.585865354900290e-17, -1.907846737899695e-19, -7.763923544616661e-22, -3.097862346043076e-24,
 -1.213476299631843e-26, -4.668348156635147e-29,  };
  constexpr double w[18816] = {  6.344282951268558e-02, -1.679953048206630e-04,  4.639633094692903e-07, -1.324520861813877e-09,  3.871162286403559e-12,
 -1.148637348592557e-14,  3.437618320981948e-17, -1.032952827617871e-19,  3.106892621809219e-22, -9.336170531889348e-25,  2.799680438625916e-27, -8.372754323262569e-30,
  6.325383771569196e-02, -2.295455838340484e-04,  9.695287913911517e-07, -4.170009303659093e-09,  1.757085246172615e-11, -7.214269887222062e-14,  2.893229574824865e-16,
 -1.137172719237925e-18,  4.393083533853619e-21, -1.671817190283450e-23,  6.278350739792815e-26, -2.329908318258202e-28,  6.287825341312621e-02, -3.513107405127893e-04,
  2.146975505480794e-06, -1.227363968656119e-08,  6.596777666263954e-11, -3.381157017402179e-13,  1.668901919237166e-15, -7.985123113209983e-18,  3.720890098207425e-20,
 -1.694527414200552e-22,  7.562623422537853e-25, -3.314813540502653e-27,  6.232080895128226e-02, -5.306632553984083e-04,  4.318056655294436e-06, -3.112526901958246e-08,
  2.060965229688829e-10, -1.281256747227329e-12,  7.577364940999058e-15, -4.300733648569883e-17,  2.357522864172151e-19, -1.254063831585334e-21,  6.497279978805807e-24,
 -3.288152164181250e-26,  6.158844019661530e-02, -7.637679616890805e-04,  7.938930497296091e-06, -7.052030002690779e-08,  5.641097348928306e-10, -4.175007061536500e-12,
  2.906227097516151e-14, -1.923866874027908e-16,  1.220724982241081e-18, -7.468138891084671e-21,  4.425162104496095e-23, -2.548684229023354e-25,  6.069009939392660e-02,
 -1.045703652069355e-03,  1.357036397683043e-05, -1.461624503126970e-07,  1.391399037071188e-09, -1.208921321305781e-11,  9.776449660663103e-14, -7.455690212867114e-16,
  5.412022432149087e-18, -3.765308597798800e-20,  2.524191311391778e-22, -1.637327129968856e-24,  5.963651850529531e-02, -1.370616082100322e-03,  2.184111773133948e-05,
 -2.813857414432190e-07,  3.148944786625924e-09, -3.176278933500019e-11,  2.953378054924316e-13, -2.569583887422864e-15,  2.114242129717099e-17, -1.658102828175186e-19,
  1.246976111008776e-21, -9.035399002074601e-24,  5.843993301781807e-02, -1.731895315105642e-03,  3.340686051362497e-05, -5.087051864217295e-07,  6.623039472190085e-09,
 -7.683328257198909e-11,  8.143604920259991e-13, -8.018398355264886e-15,  7.421303838169534e-17, -6.513118924353194e-19,  5.456671784724216e-21, -4.387041468978662e-23,
  5.711377751142566e-02, -2.122369483748346e-03,  4.890718420744234e-05, -8.709048557111785e-07,  1.307128940924649e-08, -1.729823664701440e-10,  2.074368398324877e-12,
 -2.295388629116700e-14,  2.374084709934922e-16, -2.317103982428082e-18,  2.149726092785256e-20, -1.906726188446629e-22,  5.567236493083403e-02, -2.534506656450252e-03,
  6.892332367848978e-05, -1.421405534186038e-06,  2.439187640776680e-08, -3.655486581085139e-10,  4.926653316887511e-12, -6.088875221243878e-14,  6.996859894724706e-16,
 -7.552725843270748e-18,  7.718987242706750e-20, -7.515175317391993e-22,  5.413056150369316e-02, -2.960616591498522e-03,  9.393903521386871e-05, -2.223717838864105e-06,
  4.330236223818238e-08, -7.300180729120044e-10,  1.099094302520273e-11, -1.508707496445933e-13,  1.916117994117167e-15, -2.276269400499860e-17,  2.550656743211006e-19,
 -2.713585367656312e-21,  5.250346863237093e-02, -3.393044701611059e-03,  1.243067751259096e-04, -3.349872891328333e-06,  7.350799084826070e-08, -1.385495555783371e-09,
  2.317285304142252e-11, -3.514808244432004e-13,  4.910029353972464e-15, -6.390268380997593e-17,  7.817177001482752e-19, -9.050377126742265e-21,  5.080612194159133e-02,
 -3.824351470341571e-03,  1.602208804332309e-04, -4.877821578267708e-06,  1.198346760436949e-07, -2.510786564585606e-09,  4.640903238915621e-11, -7.741064633704080e-13,
  1.184165600279876e-14, -1.681350272643177e-16,  2.236465827643940e-18, -2.807068816853950e-20,  4.905321610056500e-02, -4.247471770263622e-03,  2.016989288004967e-04,
 -6.887894233414983e-06,  1.882996837630497e-07, -4.362104806409201e-09,  8.867303478929777e-11, -1.619268776676232e-12,  2.701134146812954e-14, -4.167702538909139e-16,
  6.005615926125959e-18, -8.142929197244010e-20,  4.725886218715849e-02, -4.655849929709213e-03,  2.485718911366782e-04, -9.458504703496752e-06,  2.860941187670516e-07,
 -7.290745134171334e-09,  1.622459115308696e-10, -3.229925658304353e-12,  5.852257195297540e-14, -9.776191718389382e-16,  1.520770994536122e-17, -2.220073023470594e-19,
  4.543638236043866e-02, -5.043547874874154e-03,  3.004831324818878e-04, -1.266135720270568e-05,  4.214559407789379e-07, -1.175841889580004e-08,  2.852103112542183e-10,
 -6.164982453800152e-12,  1.208764669988278e-13, -2.178495986787990e-15,  3.646185589797764e-17, -5.712755211949428e-19,  4.359814458917081e-02, -5.405325137685517e-03,
  3.568958051629881e-04, -1.655646451939744e-05,  6.034201021128789e-07, -1.834746141734411e-08,  4.830676930029021e-10, -1.129436864606849e-11,  2.387823353178581e-13,
 -4.627320848004872e-15,  8.306556243417812e-17, -1.392573617180641e-18,  4.175543826567216e-02, -5.736690880041245e-03,  4.171077447591717e-04, -2.118730837743021e-05,
  8.414427930154992e-07, -2.776290232554142e-08,  7.903111049235249e-10, -1.991375406495620e-11,  4.524204207207486e-13, -9.396969062003825e-15,  1.803716397808135e-16,
 -3.226248161216050e-18,  3.991838981336936e-02, -6.033929272968569e-03,  4.802726463578721e-04, -2.657646652681528e-05,  1.144908620797702e-06, -4.082352927117953e-08,
  1.251720421287093e-09, -3.387228164755916e-11,  8.242541520049523e-13, -1.829304027900524e-14,  3.743573929414515e-16, -7.124242313775458e-18,  3.809591594308854e-02,
 -6.294100536970946e-03,  5.454260774473422e-04, -3.272199875088964e-05,  1.522541549019182e-06, -5.843962179978843e-08,  1.923095054276635e-09, -5.570091196814002e-11,
  1.447238594641274e-12, -3.421800532331240e-14,  7.444784849508401e-16, -1.503351202544162e-17,  3.629571107067930e-02, -6.515020671096938e-03,  6.115147759377847e-04,
 -3.959483005161094e-05,  1.981751269063044e-06, -8.157597748544738e-08,  2.871113766739628e-09, -8.872280381191329e-11,  2.453905094673723e-12, -6.163365679852103e-14,
  1.421774137154343e-15, -3.038552114566595e-17,  3.452426459375352e-02, -6.695223367247377e-03,  6.774276797169239e-04, -4.713730001419440e-05,  2.527955193555478e-06,
 -1.112001318827657e-07,  4.172023552504453e-09, -1.371216296438738e-10,  4.025341529063797e-12, -1.071040004011703e-13,  2.612700027450612e-15, -5.894676789975071e-17,
  3.278690323140031e-02, -6.833907834738727e-03,  7.420272234144042e-04, -5.526296972885586e-05,  3.163921552849284e-06, -1.482171702186995e-07,  5.908916989293447e-09,
 -2.059400989820646e-10,  6.398587761252081e-12, -1.798726511896720e-13,  4.628184987466452e-15, -1.099648523578057e-16,  3.108785343202637e-02, -6.930876273763420e-03,
  8.041795996415296e-04, -6.385769861448703e-05,  3.889180616500790e-06, -1.933940870280510e-07,  8.167461587256435e-09, -3.009805118323298e-10,  9.870513512655645e-12,
 -2.923945777538874e-13,  7.915876267262938e-15, -1.975979694901261e-16,  2.943031891144740e-02, -6.986464570246415e-03,  8.627828945637960e-04, -7.278192931008374e-05,
  4.699548734051645e-06, -2.472780971949966e-07,  1.103009015428044e-08, -4.285829373515411e-10,  1.479595106208693e-11, -4.607064203999783e-13,  1.309151608686252e-14,
 -3.425375662757075e-16,  2.781656864799695e-02, -7.001469479032218e-03,  9.167922497557829e-04, -8.187405454878610e-05,  5.586803968790242e-06, -3.101144696661127e-07,
  1.456883587535946e-08, -5.952651796512476e-10,  2.157783473788995e-11, -7.044898859997944e-13,  2.096311007049575e-14, -5.736251796469156e-16,  2.624803108214240e-02,
 -6.977075159029379e-03,  9.652414539582581e-04, -9.095468919243329e-05,  6.538543191404232e-06, -3.817702009627875e-07,  1.883718166719297e-08, -8.072219392757153e-10,
  3.064745315579835e-11, -1.046667917960981e-12,  3.253942717715330e-14, -9.291359345591487e-16,  2.472539079400369e-02, -6.914781462690390e-03,  1.007260612533930e-03,
 -9.983163537913459e-05,  7.538239453298729e-06, -4.616700703693723e-07,  2.386146874909395e-08, -1.069697598838142e-09,  4.243370633252542e-11, -1.512382679852388e-12,
  4.901299541656042e-14, -1.457275577966446e-15,  2.324868451634237e-02, -6.816335898525789e-03,  1.042089765658368e-03, -1.083053095051094e-04,  8.565506247760074e-06,
 -5.487512775453968e-07,  2.963255169239831e-08, -1.386266174991029e-09,  5.732147093906690e-11, -2.127245202483903e-12,  7.170778995713977e-14, -2.215349381392039e-15,
  2.181739394238548e-02, -6.683670708904629e-03,  1.069088519082319e-03, -1.161743956995756e-04,  9.596562887884606e-06, -6.414419697291279e-07,  3.609847601389464e-08,
 -1.758070891794427e-09,  7.560072677912068e-11, -2.914821979984026e-12,  1.019838486631325e-13, -3.267050772092405e-15,  2.043053337422118e-02, -6.518846059225694e-03,
  1.087741908009769e-03, -1.232414997175135e-04,  1.060488360401783e-05, -7.376675878381943e-07,  4.315897411995413e-08, -2.183091913399607e-09,  9.740981985749981e-11,
 -3.893430907509985e-12,  1.410954547786676e-13, -4.677424462647787e-15,  1.908673080344823e-02, -6.323999934993745e-03,  1.097662833067547e-03, -1.293185972466365e-04,
  1.156200285971448e-05, -8.348872120116783e-07,  5.066251762631432e-08, -2.655521425602280e-09,  1.226779004378604e-10, -5.072447631530790e-12,  1.900062483145442e-13,
 -6.505309162178267e-15,  1.778430150408929e-02, -6.101305000466711e-03,  1.098591488194906e-03, -1.342320986256426e-04,  1.243844137299417e-05, -9.301601122253046e-07,
  5.840652864218716e-08, -3.165328292237020e-09,  1.510729102906403e-10, -6.448456677561994e-12,  2.491730886548386e-13, -8.793459231638085e-15,  1.652131363837094e-02,
 -5.852932390936080e-03,  1.090392246454069e-03, -1.378273849667503e-04,  1.320471175608877e-05, -1.020240668657222e-06,  6.614114789516925e-08, -3.698088520261320e-09,
  1.819622377287466e-10, -8.001697643547278e-12,  3.183195607642283e-13, -1.155704867604684e-14,  1.529564572473328e-02, -5.581022190465410e-03,  1.073048485658494e-03,
 -1.399727059146645e-04,  1.383235968034789e-05, -1.101697878901718e-06,  7.357669961246731e-08, -4.235142364992568e-09,  2.143930963729347e-10, -9.693331518503882e-12,
  3.962281170147177e-13, -1.477180278181354e-14,  1.410503609506604e-02, -5.287660184735041e-03,  1.046655826594116e-03, -1.405623643607768e-04,  1.429499596610636e-05,
 -1.171053959342085e-06,  8.039470379813536e-08, -4.754114870356843e-09,  2.470986883891122e-10, -1.146406441624964e-11,  4.805851813136997e-13, -1.836347924484976e-14,
  1.294712467897395e-02, -4.974860368855275e-03,  1.011414228031167e-03, -1.395191464334718e-04,  1.456927676370719e-05, -1.224935194193116e-06,  8.626199144068300e-08,
 -5.229805872524349e-09,  2.785342807828408e-10, -1.323460111333946e-11,  5.679144358951330e-13, -2.220071325123616e-14,  1.181948760359503e-02, -4.644552625525808e-03,
  9.676193401132471e-04, -1.367959845808318e-04,  1.463579269020521e-05, -1.260227272438614e-06,  9.084720363790112e-08, -5.635420849371377e-09,  3.069445849807201e-10,
 -1.490825472109774e-11,  6.536287827323359e-13, -2.609323993049471e-14,  1.071966519636652e-02, -4.298574962031543e-03,  9.156534660359794e-04, -1.323768666350248e-04,
  1.447983300613255e-05, -1.274226927531566e-06,  9.383872630507925e-08, -5.944078959431912e-09,  3.304605451129582e-10, -1.637582042977852e-11,  7.322207736643646e-13,
 -2.979713953181553e-14,  9.645184034151271e-03, -3.938669697620748e-03,  8.559764255140769e-04, -1.262770239481384e-04,  1.409199722139844e-05, -1.264781767808865e-06,
  9.496294868248884e-08, -6.130502909748658e-09,  3.472201712516315e-10, -1.752255243237317e-11,  7.975953415753673e-13, -3.302800325983022e-14,  8.593573704745195e-03,
 -3.566483018797434e-03,  7.891165559910294e-04, -1.185424469707248e-04,  1.346863348279366e-05, -1.230410733999136e-06,  9.400165111830062e-08, -6.172770461733395e-09,
  3.555048210806231e-10, -1.823679671886530e-11,  8.435292317758312e-13, -3.548185476410495e-14,  7.562378946366300e-03, -3.183567363323211e-03,  7.156620318418592e-04,
 -1.092487872998912e-04,  1.261209033194872e-05, -1.170398592853884e-06,  9.080733349912509e-08, -6.053992371983897e-09,  3.538797615843334e-10, -1.841956799122150e-11,
  8.642213241456092e-13, -3.686242384707297e-14,  6.549167821635811e-03, -2.791386151609805e-03,  6.362526306820622e-04, -9.849971185896282e-05,  1.153077561235868e-05,
 -1.084859201039394e-06,  8.531539086806863e-08, -5.763778384804428e-09,  3.413263017593313e-10, -1.799415697632087e-11,  8.548802647355082e-13, -3.691215404857274e-14,
  5.551536595973051e-03, -2.391320462851813e-03,  5.515720332561272e-04, -8.642477854583700e-05,  1.023902323099270e-05, -9.747638683693309e-07,  7.755222100986828e-08,
 -5.299362411854763e-09,  3.173525424608112e-10, -1.691474996275124e-11,  8.122836866492557e-13, -3.544335942932237e-14,  4.567112133806927e-03, -1.984677394065631e-03,
  4.623407207644098e-04, -7.317690586358910e-05,  8.756775157954168e-06, -8.419329398736833e-07,  6.763859886887377e-08, -4.666279940612339e-09,  2.820709630392971e-10,
 -1.517305935083524e-11,  7.352394001839435e-13, -3.236543659159472e-14,  3.593553419552828e-03, -1.572700268461098e-03,  3.693095855504009e-04, -5.892952125726712e-05,
  7.109093417488355e-06, -6.889907109376993e-07,  5.578796524347999e-08, -3.878523950349579e-09,  2.362336408267032e-10, -1.280211199447816e-11,  6.248848289391125e-13,
 -2.770413614313025e-14,  2.628558705652425e-03, -1.156583100016780e-03,  2.732548612075874e-04, -4.387355362922854e-05,  5.325531996497804e-06, -5.192866017722026e-07,
  4.229968865237963e-08, -2.958151523901879e-09,  1.812199094515974e-10, -9.876624398340377e-12,  4.847773143119504e-13, -2.160968216002910e-14,  1.669929444581304e-03,
 -7.375115610201105e-04,  1.749796635849879e-04, -2.821519321989339e-05,  3.439495858060895e-06, -3.367963605838940e-07,  2.754844506264157e-08, -1.934410561785572e-09,
  1.189789408137784e-10, -6.509925155453152e-12,  3.207601381351556e-13, -1.435224695289564e-14,  7.166730871145595e-04, -3.171649717730415e-04,  7.542551118789353e-05,
 -1.219120372509705e-05,  1.489657518121070e-06, -1.462091018197917e-07,  1.198680847204241e-08, -8.436013389921955e-10,  5.200234378496779e-11, -2.851510199374636e-12,
  1.408015273662161e-13, -6.313268457088907e-15,  6.277817250663757e-02, -1.643461395629879e-04,  4.484332522664023e-07, -1.264376221995427e-09,  3.649456504087253e-12,
 -1.069495915209009e-14,  3.161820136859699e-17, -9.387007629938771e-20,  2.790091457408249e-22, -8.286585296269275e-25,  2.456331271414863e-27, -7.262164933927102e-30,
  6.235085752596780e-02, -2.219848419359942e-04,  9.211290605951334e-07, -3.900051765997976e-09,  1.619493668597349e-11, -6.556569180425729e-14,  2.593630869393974e-16,
 -1.005758376416056e-18,  3.834068744764584e-21, -1.440033452199922e-23,  5.338078710773714e-26, -1.955644719153839e-28,  6.150645393395070e-02, -3.347066281033974e-04,
  2.005808426844912e-06, -1.127015119203656e-08,  5.958856100797120e-11, -3.006159444474793e-13,  1.461111011257882e-15, -6.886478363076238e-18,  3.161971962892210e-20,
 -1.419281098638731e-22,  6.244518562178997e-25, -2.698849886320621e-27,  6.026495596761337e-02, -4.975586421017769e-04,  3.963523987683265e-06, -2.802323945765998e-08,
  1.821966500036184e-10, -1.113037962925813e-12,  6.472331421777475e-15, -3.613814305371589e-17,  1.949552746380826e-19, -1.020946166893773e-21,  5.208914456959676e-24,
 -2.596648324497778e-26,  5.865524024587468e-02, -7.034941628404069e-04,  7.144203865998664e-06, -6.212640336857105e-08,  4.871700072196985e-10, -3.537977071568334e-12,
  2.418422521346913e-14, -1.573042959105948e-16,  9.812043599728122e-19, -5.903517156455232e-21,  3.441445082026818e-23, -1.950647838480352e-25,  5.671381333551733e-02,
 -9.437956585372187e-04,  1.194240437729843e-05, -1.257136160454529e-07,  1.171483369312873e-09, -9.974992770060402e-12,  7.912248939453775e-14, -5.922564616368286e-16,
  4.222135305391788e-18, -2.886249505031135e-20,  1.901946701318508e-22, -1.213151607822500e-24,  5.448327529655048e-02, -1.208583036292834e-03,  1.874700792291057e-05,
 -2.357227050520998e-07,  2.579115155624004e-09, -2.546680084381922e-11,  2.320282753853096e-13, -1.979633672484160e-15,  1.598285279011186e-17, -1.230622149940898e-19,
  9.090547847429037e-22, -6.472607494067365e-24,  5.201059745572989e-02, -1.487367060829511e-03,  2.789074242886750e-05, -4.140397245250788e-07,  5.264934766629114e-09,
 -5.973470587042297e-11,  6.198476791136347e-13, -5.980117865883617e-15,  5.426987330579671e-17, -4.672858121870964e-19,  3.842920211425272e-21, -3.034204041679231e-23,
  4.934531935888588e-02, -1.769606437015522e-03,  3.960520155356045e-05, -6.869404354517887e-07,  1.006156106775530e-08, -1.301230867840330e-10,  1.526572909086359e-12,
 -1.654064042026103e-14,  1.676408216478806e-16, -1.604329708773890e-18,  1.460284997858045e-20, -1.271348034075279e-22,  4.653776786027318e-02, -2.045229541180052e-03,
  5.398614458843986e-05, -1.083736103478537e-06,  1.813728670327650e-08, -2.654689623089407e-10,  3.498253310726608e-12, -4.231246745978841e-14,  4.762171518013990e-16,
 -5.038112632216984e-18,  5.049430174680090e-20, -4.823556426915945e-22,  4.363739146254061e-02, -2.305087691898126e-03,  7.097241751756438e-05, -1.634671428440828e-06,
  3.103048650716520e-08, -5.106914882459301e-10,  7.514583606185631e-12, -1.009093207846619e-13,  1.254740899102909e-15, -1.460372269548628e-17,  1.604228471394676e-19,
 -1.674058835040177e-21,  4.069128690927670e-02, -2.541315262265499e-03,  9.034009343934428e-05, -2.368258844273015e-06,  5.064587222057978e-08, -9.316177114458216e-10,
  1.522413838165570e-11, -2.258349552968264e-13,  3.087915984071485e-15, -3.936425303589288e-17,  4.719631029059879e-19, -5.358540837935761e-21,  3.774297472555337e-02,
 -2.747581739097049e-03,  1.117116365316074e-04, -3.308340363230730e-06,  7.920107218505473e-08, -1.619280684719702e-09,  2.923954305621617e-11, -4.769134270413012e-13,
  7.139696229707517e-15, -9.928125383996317e-17,  1.294169824563341e-18, -1.592773128051604e-20,  3.483145816709472e-02, -2.919230877193549e-03,  1.345782860903347e-04,
 -4.471227158315975e-06,  1.191180944926246e-07, -2.692717644654721e-09,  5.347294516980612e-11, -9.548152294973849e-13,  1.558692468877541e-14, -2.355258986199642e-16,
  3.325884294247678e-18, -4.421735103307341e-20,  3.199057805405661e-02, -3.053311338101005e-03,  1.583326210206452e-04, -5.863269715503376e-06,  1.728623271462300e-07,
 -4.299232165134190e-09,  9.347311111636984e-11, -1.819704003283220e-12,  3.226844575341690e-14, -5.279370481450104e-16,  8.048468092426839e-18, -1.152150512700296e-19,
  2.924865608701810e-02, -3.148510830047308e-03,  1.823075121847714e-04, -7.479159899227227e-06,  2.427403693288716e-07, -6.611215735265284e-09,  1.567070509497807e-10,
 -3.313108301403074e-12,  6.358716368082234e-14, -1.122573498341527e-15,  1.841633710618258e-17, -2.829898276515237e-19,  2.662840284489632e-02, -3.205011262729310e-03,
  2.058174317168206e-04, -9.301172188832677e-06,  3.306755273403402e-07, -9.818962316985669e-09,  2.527160487250765e-10, -5.780925131025841e-12,  1.196689643174524e-13,
 -2.272229430144317e-15,  3.999059607890821e-17, -6.576887831351032e-19,  2.414705456493008e-02, -3.224285594739446e-03,  2.281983231303498e-04, -1.129943236779117e-05,
  4.379847995545181e-07, -1.411941820916886e-08,  3.930730504966172e-10, -9.694173734977217e-12,  2.157266383335114e-13, -4.391810392147294e-15,  8.267657880043331e-17,
 -1.451164979343927e-18,  2.181669527139608e-02, -3.208857965970307e-03,  2.488428463254601e-04, -1.343317808681529e-05,  5.651826782385947e-07, -1.970141065439731e-08,
  5.910788336941713e-10, -1.566302121253566e-11,  3.735022492772996e-13, -8.128281585311280e-15,  1.632059454127790e-16, -3.049053619064792e-18,  1.964471764172187e-02,
 -3.162047680750305e-03,  2.672286673107904e-04, -1.565286550338639e-05,  7.118348567330419e-07, -2.672848736548763e-08,  8.611590173895797e-10, -2.443901919146085e-11,
  6.225780909808564e-13, -1.444137876244779e-14,  3.084272797150652e-16, -6.117027280253068e-18,  1.763437660204849e-02, -3.087715094514152e-03,  2.829384246976839e-04,
 -1.790289372768252e-05,  8.764793862644443e-07, -3.532096737545342e-08,  1.217960453246981e-09, -3.690070794909895e-11,  1.001271333635018e-12, -2.468663464547486e-14,
  5.593199857290227e-16, -1.174644373443954e-17,  1.578539322558807e-02, -2.990023976656672e-03,  2.956709468473496e-04, -2.012467207789001e-05,  1.056624971111197e-06,
 -4.553906338479829e-08,  1.675188671238954e-09, -5.401892434399975e-11,  1.556781361309068e-12, -4.068716893376237e-14,  9.754223974867317e-16, -2.163861540810998e-17,
  1.409457216520421e-02, -2.873230985493996e-03,  3.052441147419489e-04, -2.225974573634266e-05,  1.248827235917944e-06, -5.736893768644505e-08,  2.244270746978558e-09,
 -7.680027042394065e-11,  2.344261572722726e-12, -6.477617186584537e-14,  1.639085606252821e-15, -3.831691396118248e-17,  1.255640270089110e-02, -2.741508944322567e-03,
  3.115904005262299e-04, -2.425271928012743e-05,  1.448835303150971e-06, -7.071329579046112e-08,  2.932962679551677e-09, -1.062100308063301e-10,  3.424552732747994e-12,
 -9.978937964940461e-14,  2.658674372831794e-15, -6.534226424815004e-17,  1.116362073776507e-02, -2.598806997550723e-03,  3.147465302256118e-04, -2.605376674049719e-05,
  1.651794042753136e-06, -8.538764753041022e-08,  3.744040751360390e-09, -1.430789605032680e-10,  4.860445492737012e-12, -1.489873582132264e-13,  4.169603190720600e-15,
 -1.074919963753262e-16,  9.907716118214799e-03, -2.448747686196494e-03,  3.148389229308244e-04, -2.762058130422077e-05,  1.852482691738064e-06, -1.011227524407985e-07,
  4.674218491982982e-09, -1.880012889951370e-10,  6.711524502920089e-12, -2.158919631086134e-13,  6.331998368863363e-15, -1.708476501911150e-16,  8.779375955869617e-03,
 -2.294558635174255e-03,  3.120665733196885e-04, -2.891968732820282e-05,  2.045568534689624e-06, -1.175731095114144e-07,  5.713414101514784e-09, -2.412334888739228e-10,
  9.027861630231180e-12, -3.040301189578233e-13,  9.323888806367091e-15, -2.627283759681370e-16,  7.768860075188145e-03, -2.139034917427519e-03,  3.066829104381719e-04,
 -2.992710314467297e-05,  2.225854902154195e-06, -1.343307448191954e-07,  6.844460043837644e-09, -3.026044308726167e-10,  1.184303795324809e-11, -4.165903746840409e-13,
  1.332919426642574e-14, -3.914075207493575e-16,  6.866308918233888e-03, -1.984527205281933e-03,  2.989779302944877e-04, -3.062839860875202e-05,  2.388505453620935e-06,
 -1.509430707805244e-07,  8.043302114370797e-09, -3.714472706376982e-10,  1.516714725469695e-11, -5.560119867487526e-13,  1.852039963598123e-14, -5.655644024192676e-16,
  6.061987452155439e-03, -1.832950441619479e-03,  2.892616093383619e-04, -3.101823255936364e-05,  2.529230918789884e-06, -1.669332871928093e-07,  9.279686219021468e-09,
 -4.465617918190563e-10,  1.898053574166215e-11, -7.235403646383598e-13,  2.503661994491769e-14, -7.934525873985279e-16,  5.346470758553624e-03, -1.685807841050830e-03,
  2.778493006277446e-04, -3.109948096114715e-05,  2.644429447844076e-06, -1.818216848135509e-07,  1.051828418504919e-08, -5.262131890229083e-10,  2.322904242889494e-11,
 -9.187941363844497e-13,  3.295866331530151e-14, -1.081808552217860e-15,  4.710778246815928e-03, -1.544225436162949e-03,  2.650495257821542e-04, -3.088207721996506e-05,
  2.731276780200232e-06, -1.951462856838648e-07,  1.172017103450693e-08, -6.081698046585822e-10,  2.782141556400028e-11, -1.139395642167738e-12,  4.228353951573622e-14,
 -1.434575358889732e-15,  4.146463972627983e-03, -1.408992995972843e-03,  2.511543250414793e-04, -3.038168426583442e-05,  2.787767019490617e-06, -2.064814768351705e-07,
  1.284453939057178e-08, -6.897786165834846e-10,  3.262940203756737e-11, -1.380716802202542e-12,  5.290148157464800e-14, -1.851566916949953e-15,  3.645670530339813e-03,
 -1.280607859767008e-03,  2.364321267321125e-04, -2.961830656096008e-05,  2.812708512000139e-06, -2.154536178779512e-07,  1.385052398972369e-08, -7.680737915408528e-10,
  3.749076201409485e-11, -1.635785480959537e-12,  6.457880870838519e-14, -2.327239911409573e-15,  3.201153583080848e-03, -1.159318967955964e-03,  2.211229499866489e-04,
 -2.861493255143336e-05,  2.805681962922149e-06, -2.217529763759910e-07,  1.469901043088112e-08, -8.399107800990620e-10,  4.221518230385678e-11, -1.895384234654110e-12,
  7.694977188459999e-14, -2.849763126770868e-15,  2.806283436458967e-03, -1.045169073303217e-03,  2.054356583885918e-04, -2.739627736474550e-05,  2.766969452799395e-06,
 -2.251417195975593e-07,  1.535431533154770e-08, -9.021165099763731e-10,  4.659278483252713e-11, -2.148355233009753e-12,  8.951986915735210e-14, -3.400570485202587e-15,
  2.455029264196008e-03, -9.380337425977447e-04,  1.895469310139220e-04, -2.598767437917252e-05,  2.697463528812401e-06, -2.254580282047031e-07,  1.578564682243026e-08,
 -9.516453600309005e-10,  5.040468396536652e-11, -2.382104455656314e-12,  1.016820525239279e-13, -3.954551331799427e-15,  2.141930744991206e-03, -8.376562898730056e-04,
  1.736016026457810e-04, -2.441414461626283e-05,  2.598565221469620e-06, -2.226166699300712e-07,  1.596828110421154e-08, -9.857307409923782e-10,  5.343486414143853e-11,
 -2.583277567745857e-12,  1.127458949165548e-13, -4.480970902665607e-15,  1.862061032810217e-03, -7.436782107792879e-04,  1.577140376147939e-04, -2.269965601360479e-05,
  2.472078898369707e-06, -2.166065653125023e-07,  1.588441898330586e-08, -1.002023123224615e-09,  5.548254283759995e-11, -2.738561676538233e-12,  1.219783155867902e-13,
 -4.945131968433247e-15,  1.610984200149085e-03, -6.556650167686989e-04,  1.419702330626659e-04, -2.086657118318012e-05,  2.320110540202007e-06, -2.074859905725509e-07,
  1.552371278678500e-08, -9.987070075190948e-10,  5.637415787895888e-11, -2.835553509431610e-12,  1.286530643977382e-13, -5.310695813523583e-15,  1.384709590965117e-03,
 -5.731276068920508e-04,  1.264303898575549e-04, -1.893527240966210e-05,  2.144974515784801e-06, -1.953761010985953e-07,  1.488347652096026e-08, -9.745913677454807e-10,
  5.597416713204305e-11, -2.863626789383977e-12,  1.321050201055635e-13, -5.542489776139161e-15,  1.179644909208832e-03, -4.955394774079149e-04,  1.111317368005849e-04,
 -1.692394618641051e-05,  1.949112410803549e-06, -1.804534351461349e-07,  1.396860918513919e-08, -9.291702458798152e-10,  5.419395964016765e-11, -2.814730273405420e-12,
  1.317846085168430e-13, -5.609552590006973e-15,  9.925493536121818e-04, -4.223501698737442e-04,  9.609144165405011e-05, -1.484850609269270e-05,  1.735026053246731e-06,
 -1.629419867421126e-07,  1.279127226516384e-08, -8.626522308997613e-10,  5.099833273997436e-11, -2.684052854586097e-12,  1.273073838135132e-13, -5.488119001103028e-15,
  8.204876889570758e-04, -3.529954126145101e-04,  8.130948808918990e-05, -1.272263177144733e-05,  1.505225661715177e-06, -1.431053360106563e-07,  1.137036786786608e-08,
 -7.759593443311966e-10,  4.640917079098294e-11, -2.470502473126234e-12,  1.184940692886595e-13, -5.164229374700866e-15,  6.607858245800952e-04, -2.869044376759139e-04,
  6.677144044751417e-05, -1.055790280941623e-05,  1.262193087695198e-06, -1.212392117200036e-07,  9.730864696231434e-09, -6.706973060814269e-10,  4.050615097419390e-11,
 -2.176960106115199e-12,  1.053970927388453e-13, -4.635671579506093e-15,  5.109883135494364e-04, -2.235049983531044e-04,  5.245106477841808e-05, -8.364010089648435e-06,
  1.008359583644698e-06, -9.766476164794893e-08,  7.903017381535258e-09, -5.491003144261708e-10,  3.342449052966258e-11, -1.810287582996271e-12,  8.831080716696553e-14,
 -3.913020253693775e-15,  3.688186562839470e-04, -1.622268913159950e-04,  3.831287488580768e-05, -6.149041287681683e-06,  7.460983804885666e-07, -7.272282826900608e-08,
  5.921529810534332e-09, -4.139549255121341e-10,  2.534996179116376e-11, -1.381088769768116e-12,  6.776413241175186e-14, -3.019630597023166e-15,  2.321493034894569e-04,
 -1.025074897230187e-04,  2.431534508126568e-05, -3.919945096233677e-06,  4.777448279967673e-07, -4.677068437548226e-08,  3.824808896686107e-09, -2.685152385163288e-10,
  1.651198894858512e-11, -9.032660594165770e-13,  4.449711893778532e-14, -1.990603919766706e-15,  9.911670415471875e-05, -4.385968801386567e-05,  1.042909397799126e-05,
 -1.685471995098934e-06,  2.059244203393249e-07, -2.020889386368850e-08,  1.656604498966085e-09, -1.165735901973264e-10,  7.185119844886744e-12, -3.939442627479535e-13,
  1.944986285797715e-14, -8.719939887046628e-16,  6.212786816811972e-02, -1.608183869441760e-04,  4.336041579102812e-07, -1.207655757098161e-09,  3.442937891613860e-12,
 -9.966680669488038e-15,  2.911048229293477e-17, -8.540073545031773e-20,  2.508716590017712e-22, -7.365048698898396e-25,  2.158291286105276e-27, -6.308987743924549e-30,
  6.147736590943231e-02, -2.147987044222939e-04,  8.758409499436564e-07, -3.651094411629401e-09,  1.494365860148639e-11, -5.966551322477032e-14,  2.328444240454394e-16,
 -8.909669201409921e-19,  3.352104914531183e-21, -1.242763975950607e-23,  4.547997955468620e-26, -1.645126752629972e-28,  6.019888611965494e-02, -3.191853647322976e-04,
  1.876094705299021e-06, -1.036299103929713e-08,  5.391186171379025e-11, -2.677533543213554e-13,  1.281720207233788e-15, -5.951800081728041e-18,  2.693270742964530e-20,
 -1.191714073807608e-22,  5.169878584936677e-25, -2.203548458238321e-27,  5.833607581684565e-02, -4.671476468475801e-04,  3.644027816248771e-06, -2.527807098484143e-08,
  1.614107932526949e-10, -9.691720430688377e-13,  5.542552281109596e-15, -3.044955849202482e-17,  1.616917926376397e-19, -8.337562903043948e-22,  4.189793593788285e-24,
 -2.057683546844410e-26,  5.595102948221723e-02, -6.491952690525739e-04,  6.443218492127740e-06, -5.486765948332266e-08,  4.218754504281825e-10, -3.007049150318136e-12,
  2.018913587824656e-14, -1.290564217837315e-16,  7.915187636417554e-19, -4.684385882399590e-21,  2.687053044077727e-23, -1.499143383145717e-25,  5.312058560785791e-02,
 -8.539865521938674e-04,  1.054003933598832e-05, -1.084680806595357e-07,  9.897046860450626e-10, -8.260694014006345e-12,  6.428451464868299e-14, -4.724030106074101e-16,
  3.308069258358749e-18, -2.222400696105592e-20,  1.439831540051699e-22, -9.032565409285160e-25,  4.993192206425622e-02, -1.069256976740746e-03,  1.615005341527664e-05,
 -1.982468422241284e-07,  2.121258303540030e-09, -2.050934091692124e-11,  1.831398217630677e-13, -1.532569831962992e-15,  1.214384811479950e-17, -9.181754233423723e-20,
  6.663332208614108e-22, -4.662935646539299e-24,  4.647782238549013e-02, -1.282768780288796e-03,  2.339074533280707e-05, -3.386036291056296e-07,  4.206393084690600e-09,
 -4.668598566580848e-11,  4.743856274590689e-13, -4.485399526561213e-15,  3.992026876047614e-17, -3.372991410918126e-19,  2.723413267877988e-21, -2.112092482418606e-23,
  4.285198762381389e-02, -1.483186814586248e-03,  3.224798778052809e-05, -5.449317079508263e-07,  7.790882920550272e-09, -9.848639408753609e-11,  1.130599952848453e-12,
 -1.199759800790468e-14,  1.191767379978015e-16, -1.118532393688164e-18,  9.990204751342138e-21, -8.538768330843577e-23,  3.914473181983213e-02, -1.660802132166355e-03,
  4.256102750215342e-05, -8.318266789039239e-07,  1.357975959670535e-08, -1.941604847456458e-10,  2.502139141755138e-12, -2.962371403676773e-14,  3.266046274566417e-16,
 -3.387036397740721e-18,  3.329520345113888e-20, -3.121184414630504e-22,  3.543933137883811e-02, -1.808049333710597e-03,  5.402753119873752e-05, -1.210980106842903e-06,
  2.241283214033796e-08, -3.601546943750979e-10,  5.180270807202963e-12, -6.806199284407593e-14,  8.287048792582064e-16, -9.451087249743057e-18,  1.017935746683584e-19,
 -1.042070291109162e-21,  3.180921110065891e-02, -1.919792254609203e-03,  6.622700510866309e-05, -1.689096082532043e-06,  3.520770809200948e-08, -6.321427552783499e-10,
  1.009463478375650e-11, -1.464683138849962e-13,  1.960497519576293e-15, -2.448267039830180e-17,  2.877347756043495e-19, -3.204076142933882e-21,  2.831605490461148e-02,
 -1.993380673167562e-03,  7.865826464106512e-05, -2.266194527229572e-06,  5.287192110105572e-08, -1.054933963496019e-09,  1.861124268585114e-11, -2.968661039256169e-13,
  4.349844295716369e-15, -5.924424204678953e-17,  7.568882762773746e-19, -9.134952413558420e-21,  2.500883927561086e-02, -2.028504611339181e-03,  9.078497562329534e-05,
 -2.934611581633835e-06,  7.619283311823148e-08, -1.680825345843800e-09,  3.260952184599630e-11, -5.694019033815942e-13,  9.097146290287631e-15, -1.346299813332052e-16,
  1.863149587296063e-18, -2.428983143201704e-20,  2.192371159409763e-02, -2.026889892127906e-03,  1.020827741673979e-04, -3.678889904309388e-06,  1.057200176855186e-07,
 -2.566178454391413e-09,  5.451189599687624e-11, -1.037807960733955e-12,  1.801183092003161e-14, -2.886270808058505e-16,  4.312432160924855e-18, -6.053790425808438e-20,
  1.908457989655790e-02, -1.991887763735227e-03,  1.120820234491529e-04, -4.476599276818513e-06,  1.416582162592063e-07, -3.766322760694810e-09,  8.723962078678787e-11,
 -1.804023155829314e-12,  3.389239342770755e-14, -5.861128432909213e-16,  9.424970020139162e-18, -1.420404625189430e-19,  1.650424770278938e-02, -1.928012813236170e-03,
  1.204016281517556e-04, -5.299974960786406e-06,  1.837887342367127e-07, -5.329248579623775e-09,  1.340756231398085e-10, -3.000611931728898e-12,  6.081704647412141e-14,
 -1.131431366169914e-15,  1.952263031696501e-17, -3.149611516126056e-19,  1.418591651179211e-02, -1.840478361077000e-03,  1.267711464428605e-04, -6.118138573005808e-06,
  2.314332796488267e-07, -7.288866426107812e-09,  1.984287425115300e-10, -4.789539396241570e-12,  1.043909748600026e-13, -2.082915246498969e-15,  3.845433665049259e-17,
 -6.623108639827317e-19,  1.212488608212054e-02, -1.734768995568871e-03,  1.310403465247417e-04, -6.899594405940256e-06,  2.834676163128850e-07, -9.658795598545087e-09,
  2.835118421993497e-10, -7.356108566698533e-12,  1.718796127642856e-13, -3.667508573202474e-15,  7.224500947221091e-17, -1.324885007577793e-18,  1.031030384474565e-02,
 -1.616278028965784e-03,  1.331770386157147e-04, -7.614680381061196e-06,  3.383844886720225e-07, -1.242765088101119e-08,  3.919649578165339e-10, -1.089746764169082e-11,
  2.721518255626635e-13, -6.192602040445829e-15,  1.298116227012755e-16, -2.528321601381794e-18,  8.726844408069522e-03, -1.490025422171480e-03,  1.332552641255071e-04,
 -8.237691738967955e-06,  3.943977491405720e-07, -1.555661480116202e-08,  5.254695759959943e-10, -1.560597824493295e-11,  4.153676441164902e-13, -1.005140116198597e-14,
  2.236392218392246e-16, -4.614702943133841e-18,  7.356233084779741e-03, -1.360460695602826e-03,  1.314366487374919e-04, -8.748472420118192e-06,  4.495739151659006e-07,
 -1.897975115104614e-08,  6.844075122204538e-10, -2.164873608123019e-11,  6.123741258706031e-13, -1.571793579694934e-14,  3.702607803633704e-16, -8.074939464468519e-18,
  6.178559565310231e-03, -1.231346530196936e-03,  1.279479374697065e-04, -9.133364683803479e-06,  5.019743946937786e-07, -2.260710407035986e-08,  8.676155998740899e-10,
 -2.914543651264575e-11,  8.738171500604544e-13, -2.372843557972743e-14,  5.903523519222200e-16, -1.357576226200205e-17,  5.173356327498619e-03, -1.105712622086963e-03,
  1.230575172063021e-04, -9.385502954809473e-06,  5.497915714061500e-07, -2.633022000287911e-08,  1.072275687664503e-09, -3.814736640765423e-11,  1.209028983844542e-12,
 -3.464732475034526e-14,  9.082543051003089e-16, -2.197310265262954e-17,  4.320439373585952e-03, -9.858658761642703e-04,  1.170532276269940e-04, -9.504518193446040e-06,
  5.914644519341816e-07, -3.002940360156390e-08,  1.293960603944750e-09, -4.862042981467350e-11,  1.624800680546364e-12, -4.901838386824876e-14,  1.350771320425225e-15,
 -3.430267858512505e-17,  3.600525775798946e-03, -8.734418629529852e-04,  1.102231060862846e-04, -9.495775127390270e-06,  6.257638417155965e-07, -3.358182514298797e-08,
  1.526834598206159e-09, -6.043473125043820e-11,  2.124183747937956e-12, -6.730430984819732e-14,  1.945190218044682e-15, -5.173940482229798e-17,  2.995653483472212e-03,
 -7.694830872973364e-04,  1.028400308394218e-04, -9.369293463330445e-06,  6.518420528383702e-07, -3.686955559634608e-08,  1.763985593811881e-09, -7.336241358036321e-11,
  2.705478486402422e-12, -8.982045169589562e-14,  2.716576141732626e-15, -7.552017480030664e-17,  2.489434652000116e-03, -6.745314350866087e-04,  9.515061384279954e-05,
 -9.138507834671958e-06,  6.692470279871088e-07, -3.978670380558555e-08,  1.997850108842338e-09, -8.708433856528403e-11,  3.361553119200854e-12, -1.166703537028148e-13,
  3.684544082207147e-15, -1.068295309463720e-16,  2.067175447301868e-03, -5.887246231080389e-04,  8.736820643010772e-05, -8.819005265991414e-06,  6.779047806861118e-07,
 -4.224503211696857e-08,  2.220682339754273e-09, -1.012050190214224e-10,  4.079600183333944e-12, -1.476914632253297e-13,  4.859827506948704e-15, -1.466541048773436e-16,
  1.715893989917301e-03, -5.118891234040004e-04,  7.966954170166539e-05, -8.427350409915937e-06,  6.780767945422093e-07, -4.417768390789113e-08,  2.425017425508834e-09,
 -1.152741731094848e-10,  4.841381581128965e-12, -1.824187478916053e-13,  6.241052010217851e-15, -1.956183654342446e-16,  1.424264888304076e-03, -4.436245382554669e-04,
  7.219434287053895e-05, -7.980074736955816e-06,  6.703003844125119e-07, -4.554092017599944e-08,  2.604084538464152e-09, -1.288125378853704e-10,  5.623951420214058e-12,
 -2.200720883883951e-13,  7.812148889233623e-15, -2.538198253893447e-16,  1.182514564667126e-03, -3.833765605499089e-04,  6.504715580880876e-05, -7.492872061223795e-06,
  6.553201338262235e-07, -4.631399278553766e-08,  2.752136274697633e-09, -1.413392401202600e-10,  6.400787265841317e-12, -2.595704964440111e-13,  9.540802487160401e-15,
 -3.206851746424579e-16,  9.822869878314520e-04, -3.304973693006154e-04,  5.830068648759953e-05, -6.980013361895786e-06,  6.340176738179480e-07, -4.649745331822253e-08,
  2.864674382369266e-09, -1.523980843852006e-10,  7.143215031106772e-12, -2.995729541888229e-13,  1.137822086482936e-14, -3.948689688307544e-16,  8.164949801745506e-04,
 -2.842935653944800e-04,  5.200000803426319e-05, -6.453971089923371e-06,  6.073456111196221e-07, -4.611029808057709e-08,  2.938565732030206e-09, -1.615805179491738e-10,
  7.821986420515460e-12, -3.385425348915621e-13,  1.326036910346415e-14, -4.742132536737375e-16,  6.791682614427221e-04, -2.440625865429481e-04,  4.616711903179657e-05,
 -5.925227731599976e-06,  5.762696903621204e-07, -4.518638414800728e-08,  2.972054609638517e-09, -1.685436597280196e-10,  8.408862525802517e-12, -3.748279343950077e-13,
  1.511063366403360e-14, -5.557802603223018e-16,  5.653059868770638e-04, -2.091190214018498e-04,  4.080546159483295e-05, -5.402234869098410e-06,  5.417215669509844e-07,
 -4.377053008664074e-08,  2.964686607502401e-09, -1.730225098499635e-10,  8.878070941639419e-12, -4.067549500865646e-13,  1.684372243173181e-14, -6.359620442347001e-16,
  4.707387779685595e-04, -1.788124507090230e-04,  3.590412852267263e-05, -4.891486154756179e-06,  5.045630714943168e-07, -4.191465471338734e-08,  2.917165049493877e-09,
 -1.748361696551989e-10,  9.207531901918650e-12, -4.327199235970683e-13,  1.837047265623728e-14, -7.106619770345426e-16,  3.920031064916935e-04, -1.525384560255851e-04,
  3.144159362762327e-05, -4.397669013420817e-06,  4.655616731260786e-07, -3.967422533400683e-08,  2.831163107156830e-09, -1.738885082965258e-10,  9.379785263208064e-12,
 -4.512776541125396e-13,  1.960315456698226e-14, -7.755347091569541e-16,  3.262293086496130e-04, -1.297443225401682e-04,  2.738888356201456e-05, -3.923864014760535e-06,
  4.253760332557948e-07, -3.710519873286954e-08,  2.709114092776269e-09, -1.701641562802735e-10,  9.382588409129129e-12, -4.612175794610032e-13,  2.046082882805792e-14,
 -8.262647601821933e-16,  2.710433884236109e-04, -1.099307763859884e-04,  2.371217235667718e-05, -3.471766415975751e-06,  3.845500637049370e-07, -3.426155552015121e-08,
  2.553999650568477e-09, -1.637209685916370e-10,  9.209190008342137e-12, -4.616238130098698e-13,  2.087433847398272e-14, -8.588600208761675e-16,  2.244820252944967e-04,
 -9.265088007235930e-05,  2.037482316908237e-05, -3.041910353823662e-06,  3.435137105185468e-07, -3.119345883263018e-08,  2.369151561535519e-09, -1.546801902171421e-10,
  8.858312315691458e-12, -4.519165967722700e-13,  2.079058030547169e-14, -8.699354398655659e-16,  1.849197445594827e-04, -7.750699027467021e-05,  1.733892851030090e-05,
 -2.633881861543548e-06,  3.025887083803686e-07, -2.794601550143522e-08,  2.158078401592101e-09, -1.432155046791261e-10,  8.333893439004033e-12, -4.318746018220263e-13,
  2.017579227784554e-14, -8.569638350269492e-16,  1.510069625421971e-04, -6.414647815586098e-05,  1.456641407306586e-05, -2.246511881334329e-06,  2.619977208751843e-07,
 -2.455858220624524e-08,  1.924323951100853e-09, -1.295419915707313e-10,  7.644650419268216e-12, -4.016390659695480e-13,  1.901769640806163e-14, -8.184745830110464e-16,
  1.216175213971623e-04, -5.225673342173548e-05,  1.201977577245998e-05, -1.878044548765511e-06,  2.218755377478590e-07, -2.106453929581998e-08,  1.671360459072940e-09,
 -1.139058038670181e-10,  6.803525081230595e-12, -3.617018850349581e-13,  1.732643708132537e-14, -7.541861733079194e-16,  9.580433071818134e-05, -4.155982409756412e-05,
  9.662518032887813e-06, -1.526279243733037e-06,  1.822812962718207e-07, -1.749144839502229e-08,  1.402516863822211e-09, -9.657513894255424e-11,  5.827069287010362e-12,
 -3.128804388585829e-13,  1.513434207549817e-14, -6.650645107629974e-16,  7.276180723940274e-05, -3.180706887108803e-05,  7.459357274793162e-06, -1.188687475756619e-06,
  1.432110144442562e-07, -1.386151529639677e-08,  1.120940085489070e-09, -7.783285891177609e-11,  4.734817259980721e-12, -2.562822092420906e-13,  1.249460378249730e-14,
 -5.533048142219380e-16,  5.179398699728250e-05, -2.277372459078352e-05,  5.376256842255773e-06, -8.625088529942671e-07,  1.046101826923468e-07, -1.019230711105714e-08,
  8.295875806434105e-10, -5.797101313603446e-11,  3.548686888242300e-12, -1.932624796743283e-13,  9.479041987759764e-15, -4.222410566191023e-16,  3.228813615915306e-05,
 -1.425429579462998e-05,  3.380441311654185e-06, -5.448459141099252e-07,  6.638816148870957e-08, -6.497858412927405e-09,  5.312627658329181e-10, -3.728834249358819e-11,
  2.292500708353013e-12, -1.253814228674714e-13,  6.175303038005284e-15, -2.761988348315992e-16,  1.371154241595213e-05, -6.066781880083017e-06,  1.442401222318291e-06,
 -2.330806981987057e-07,  2.847329512506380e-08, -2.793944607019710e-09,  2.290023284104451e-10, -1.611267224956037e-11,  9.929978888237918e-13, -5.443730096699594e-14,
  2.687363664666543e-15, -1.204681488212579e-16,  6.149144180745278e-02, -1.574065995848298e-04,  4.194363536333050e-07, -1.154126256672850e-09,  3.250401691560905e-12,
 -9.295840506205568e-15,  2.682778196137206e-17, -7.778093498475174e-20,  2.258468470986647e-22, -6.554749509290347e-25,  1.899170829111116e-27, -5.489518426963326e-30,
  6.063191268499677e-02, -2.079632534395284e-04,  8.334239898637895e-07, -3.421246996096821e-09,  1.380427122030091e-11, -5.436489190325990e-14,  2.093342584892847e-16,
 -7.905204541457905e-19,  2.935783952949001e-21, -1.074526591518813e-23,  3.882668194077530e-26, -1.386898278571284e-28,  5.895139476761251e-02, -3.046597630341324e-04,
  1.756742897615901e-06, -9.541625383822597e-09,  4.885139579614816e-11, -2.388983114856765e-13,  1.126518096004284e-15, -5.154787140853931e-18,  2.299254022879516e-20,
 -1.003072130915350e-22,  4.291289336491034e-25, -1.804099611516083e-27,  5.652392863808910e-02, -4.391662955717457e-04,  3.355569391290786e-06, -2.284361803645454e-08,
  1.432914134213189e-10, -8.458237824606745e-13,  4.758111023056032e-15, -2.572501020464849e-17,  1.344871409781000e-19, -6.829561700344960e-22,  3.380887093052068e-24,
 -1.636099539932866e-26,  5.345332614206889e-02, -6.001728242178879e-04,  5.823404010769471e-06, -4.857363255661249e-08,  3.663013167583378e-10, -2.563159427242156e-12,
  1.690621205576158e-14, -1.062308313325180e-16,  6.407372340509679e-19, -3.730725563186572e-21,  2.106150414680437e-23, -1.156808867567940e-25,  4.986540060632034e-02,
 -7.746155388248405e-04,  9.328241707695716e-06, -9.387498087682566e-08,  8.389065021704032e-10, -6.865332456848497e-12,  5.242646547894121e-14, -3.783075937352893e-16,
  2.602760428844716e-18, -1.718747225553836e-20,  1.094982055648567e-22, -6.757205206778526e-25,  4.589900358421231e-02, -9.490251075816504e-04,  1.396193147808405e-05,
 -1.673632270054753e-07,  1.751763796843689e-09, -1.658789627472043e-11,  1.452058692186396e-13, -1.192085616252050e-15,  9.272525197808537e-18, -6.885737140875123e-20,
  4.910181503982940e-22, -3.377707550169650e-24,  4.169679182622756e-02, -1.110818798535288e-03,  1.970239585230144e-05, -2.781927391999210e-07,  3.377054053449264e-09,
 -3.667398405504957e-11,  3.649932472791261e-13, -3.382902900742272e-15,  2.953324481153982e-17, -2.449137940216766e-19,  1.941824820801928e-21, -1.479453284663375e-23,
  3.739659910244931e-02, -1.249381172187452e-03,  2.639621227423483e-05, -4.346680167046709e-07,  6.067367248763076e-09, -7.498686614974746e-11,  8.425149292747648e-13,
 -8.757888179907481e-15,  8.528021678336901e-17, -7.851037194915127e-19,  6.881924146133466e-21, -5.775597319595723e-23,  3.312413152647446e-02, -1.356823142530546e-03,
  3.376446499291507e-05, -6.426155412912193e-07,  1.023553364524662e-08, -1.429858114783194e-10,  1.802351265456911e-12, -2.089092435312953e-14,  2.256640895739474e-16,
 -2.294390358285635e-18,  2.212514254308528e-20, -2.035651372826434e-22,  2.898747643926805e-02, -1.428366397899518e-03,  4.142993225944566e-05, -9.038422754344712e-07,
  1.631288701087050e-08, -2.559887844813862e-10,  3.599768184486656e-12, -4.628316235857066e-14,  5.518975130284853e-16, -6.168473140951045e-18,  6.515003075006337e-20,
 -6.543698321991426e-22,  2.507365567337492e-02, -1.462358103008331e-03,  4.895969342532004e-05, -1.215028727075379e-06,  2.468882578233297e-08, -4.327370227105338e-10,
  6.753695103316891e-12, -9.586254885348259e-14,  1.256254789734670e-15, -1.537028442529437e-17,  1.770910494320008e-19, -1.934329636858605e-21,  2.144720517539102e-02,
 -1.459969519554027e-03,  5.591490013866993e-05, -1.567330676277058e-06,  3.564027751180702e-08, -6.940618569129297e-10,  1.196459806775340e-11, -1.866582551980695e-13,
  2.677192800295549e-15, -3.571757852637744e-17,  4.472730024027829e-19, -5.294205044097452e-21,  1.815055747304728e-02, -1.424664991749688e-03,  6.189904421793907e-05,
 -1.946817057570586e-06,  4.926393030449041e-08, -1.060632110058884e-09,  2.010475240875318e-11, -3.433179296696137e-13,  5.368607687435871e-15, -7.781972742528395e-17,
  1.055516937613981e-18, -1.349472511725642e-20,  1.520586179060565e-02, -1.361542021767190e-03,  6.659737626923109e-05, -2.335695030177521e-06,  6.542537178648756e-08,
 -1.549993777965117e-09,  3.217073606174058e-11, -5.989876093913618e-13,  1.017518597040516e-14, -1.597043801164782e-16,  2.338707723616620e-18, -3.219654764881550e-20,
  1.261780549980268e-02, -1.276640128880844e-03,  6.980263203468489e-05, -2.714114739626347e-06,  8.373697631040246e-08, -2.173337794942714e-09,  4.919424239378192e-11,
 -9.950115345339695e-13,  1.829870167344047e-14, -3.099841247279977e-16,  4.886020666529830e-18, -7.222019552512453e-20,  1.037699473352984e-02, -1.176299897619572e-03,
  7.142519662062949e-05, -3.062243636097458e-06,  1.035710253187255e-07, -2.932575852078687e-09,  7.211656773607518e-11, -1.578989465892827e-12,  3.133408264759812e-14,
 -5.711426260136219e-16,  9.661677555428875e-18, -1.529048241367825e-19,  8.463497542695231e-03, -1.066629560418089e-03,  7.148860700815612e-05, -3.362272091161055e-06,
  1.241075661207816e-07, -3.818317185839067e-09,  1.016421073987057e-10, -2.400974560144376e-12,  5.125179355544768e-14, -1.002224030268411e-15,  1.814484198553557e-17,
 -3.066428650605825e-19,  6.850231849585325e-03, -9.531101704634788e-04,  7.011337128910334e-05, -3.600055570258354e-06,  1.444097474467461e-07, -4.809207968722887e-09,
  1.380940193434935e-10, -3.507973796028202e-12,  8.030683573081229e-14, -1.679982335250817e-15,  3.246438991153115e-17, -5.843683747759735e-19,  5.505974292094226e-03,
 -8.403464450694756e-04,  6.749323117615180e-05, -3.766193847275225e-06,  1.635144642796689e-07, -5.872849444002861e-09,  1.812983611550925e-10, -4.937340685042724e-12,
  1.208652636447864e-13, -2.697497156997280e-15,  5.549461510600334e-17, -1.061343282086274e-18,  4.397859246013006e-03, -7.319516691183806e-04,  6.386821773342158e-05,
 -3.856466073579494e-06,  1.805240979867212e-07, -6.968213810422752e-09,  2.305201920547792e-10, -6.710011147620217e-12,  1.751552216670058e-13, -4.159472641675634e-15,
  9.087053847025639e-17, -1.842093287477729e-18,  3.493318664049444e-03, -6.305429320990388e-04,  5.949833407131962e-05, -3.871653580268122e-06,  1.946861038062568e-07,
 -8.049202283946662e-09,  2.844667827262583e-10, -8.824718694712883e-12,  2.449676522138549e-13, -6.173926139800057e-15,  1.428825857742047e-16, -3.062931482198121e-18,
  2.761476549596313e-03, -5.378172950080719e-04,  5.464072088205051e-05, -3.816868838294885e-06,  2.054505722975634e-07, -9.068800800715669e-09,  3.413611849112776e-10,
 -1.125426838124938e-11,  3.313473191588830e-13, -8.840673510217393e-15,  2.162226861053615e-16, -4.890343036034738e-18,  2.174054907346824e-03, -4.546791345453143e-04,
  4.953200885155220e-05, -3.700558206726606e-06,  2.125006026925386e-07, -9.983220716507675e-09,  3.990768830146407e-10, -1.394465056579773e-11,  4.343231389732181e-13,
 -1.223777820245114e-14,  3.155770944502343e-16, -7.513737004390361e-18,  1.705872172895558e-03, -3.813923016987931e-04,  4.437647306395349e-05, -3.533357455027204e-06,
  2.157551953726963e-07, -1.075546605255718e-08,  4.553139906455524e-10, -1.681730199921565e-11,  5.527252084160529e-13, -1.640775876243066e-14,  4.450916897840704e-16,
 -1.113176576328849e-17,  1.335023729822339e-03, -3.177362134638179e-04,  3.933973364595191e-05, -3.326959748011650e-06,  2.153484218950085e-07, -1.135791780388331e-08,
  5.077915672804840e-10, -1.977428481829570e-11,  6.841241761041898e-13, -2.134566697681222e-14,  6.077664702063767e-16, -1.593250396789558e-17,  1.042831351872508e-03,
 -2.631511580393139e-04,  3.454716353915449e-05, -3.093117050941912e-06,  2.115912744864510e-07, -1.177372509279791e-08,  5.544299364491684e-10, -2.270567593706971e-11,
  8.249092323275376e-13, -2.699105148748903e-14,  8.048596465612949e-16, -2.206906786966261e-17,  8.136384160109282e-04, -2.168639059360780e-04,  3.008586717413384e-05,
 -2.842849475857928e-06,  2.049236693552012e-07, -1.199699527614949e-08,  5.935008984006652e-10, -2.549813873100839e-11,  9.704983948854720e-13, -3.322531040573830e-14,
  1.035391504326842e-15, -2.963345097181212e-17,  6.345140908527359e-04, -1.779895631787094e-04,  2.600903497307606e-05, -2.585892650121477e-06,  1.958637676327660e-07,
 -1.203194223258003e-08,  6.237309844594556e-10, -2.804353744731248e-11,  1.115653935811149e-12, -3.987511809183903e-14,  1.295830686245255e-15, -3.863214956293081e-17,
  4.949151329563843e-04, -1.456092170546577e-04,  2.234158804326187e-05, -2.330377139417088e-06,  1.849604871865891e-07, -1.189126132771680e-08,  6.443514931612868e-10,
 -3.024655041853226e-11,  1.254860921064870e-12, -4.672166572104721e-14,  1.580021670042998e-15, -4.896732520541843e-17,  3.863402460483652e-04, -1.188253128953972e-04,
  1.908623313113612e-05, -2.082709235828599e-06,  1.727532803546442e-07, -1.159404509856367e-08,  6.550971675804525e-10, -3.203049419448922e-11,  1.382720345234307e-12,
 -5.351458325419008e-14,  1.879376911904946e-15, -6.042672030130942e-17,  3.020002121170077e-04, -9.679802866668006e-05,  1.622928880347696e-05, -1.847609115652698e-06,
  1.597413730495187e-07, -1.116354323923475e-08,  6.561616857370476e-10, -3.334091475945883e-11,  1.494310528099755e-12, -5.998878041421126e-14,  2.183317879725152e-15,
 -7.268439703381037e-17,  2.365176119412522e-04, -7.876642468375221e-05,  1.374587579490831e-05, -1.628258689103644e-06,  1.463630111329659e-07, -1.062501997627395e-08,
  6.481219623747984e-10, -3.414685757801255e-11,  1.585479726183166e-12, -6.588215458818234e-14,  2.479913960886189e-15, -8.531284220368102e-17,  1.856629165628833e-04,
 -6.405809147842590e-05,  1.160426104048591e-05, -1.426514714225021e-06,  1.329840155977407e-07, -1.000389001626963e-08,  6.318445515184840e-10, -3.444003239170099e-11,
  1.653046551907463e-12, -7.095217871124031e-14,  2.756643418524601e-15, -9.780538089974533e-17,  1.461287982251423e-04, -5.209062370392548e-05,  9.769294608954554e-06,
 -1.243150127971552e-06,  1.198941612353335e-07, -9.324237800232005e-09,  6.083866160327581e-10, -3.423230227612195e-11,  1.694899699885093e-12, -7.498974270363625e-14,
  3.001189739369948e-15, -1.096064762562658e-16,  1.153413075545491e-04, -4.236768807378419e-05,  8.204980919021377e-06, -1.078095653030682e-06,  1.073095266376071e-07,
 -8.607756312560349e-09,  5.789016681736818e-10, -3.355203609462006e-11,  1.710001959679466e-12, -7.782917083832667e-14,  3.202190138291777e-15, -1.201465903560877e-16,
  9.130469454656431e-05, -3.447185310502172e-05,  6.876286208787193e-06, -9.306627999244365e-07,  9.537892751774416e-08, -7.873088457807824e-09,  5.445573097411306e-10,
 -3.243987741663370e-11,  1.698313706844050e-12, -7.935395194014556e-14,  3.349868121047990e-15, -1.288779533380718e-16,  7.247574523054858e-05, -2.805578594108722e-05,
  5.750312238783881e-06, -7.997372998030028e-07,  8.419273339163570e-08, -7.135518581339646e-09,  5.064691392741079e-10, -3.094442349916179e-11,  1.660657176728847e-12,
 -7.949828996036265e-14,  3.436504551554622e-15, -1.353078186974126e-16,  5.766325289344208e-05, -2.283293813099254e-05,  4.796971158437002e-06, -6.839382486177609e-07,
  7.379267865099846e-08, -6.406943076719431e-09,  4.656522953287796e-10, -2.911820316653158e-11,  1.598544909267430e-12, -7.824503129719109e-14,  3.456726779897852e-15,
 -1.390264553195491e-16,  4.594839867688571e-05, -1.856845313976891e-05,  3.989286853003882e-06, -5.817427165816757e-07,  6.418163171158977e-08, -5.696044079933106e-09,
  4.229900205266056e-10, -2.701421948939796e-11,  1.513994519408058e-12, -7.562081304281446e-14,  3.407618750286938e-15, -1.397280641186022e-16,  3.662220153113890e-05,
 -1.507073205074781e-05,  3.303430675821016e-06, -4.915784439107085e-07,  5.533262355595190e-08, -5.008595034717580e-09,  3.792172397122570e-10, -2.468320380203539e-11,
  1.409348436877490e-12, -7.168939976780812e-14,  3.288673538695295e-15, -1.372238194532027e-16,  2.913668710248198e-05, -1.218387963038348e-05,  2.718579135082822e-06,
 -4.118888054284419e-07,  4.719672637085374e-08, -4.347837543918985e-09,  3.349164010887736e-10, -2.217162626554661e-11,  1.287112559315450e-12, -6.654415871502202e-14,
  3.101621871496526e-15, -1.314471586829637e-16,  2.306693789016145e-05, -9.781105963356110e-06,  2.216661020774288e-06, -3.411748214614724e-07,  3.970959985983388e-08,
 -3.714882160192453e-09,  2.905226123544491e-10, -1.952043214247490e-11,  1.149822813970753e-12, -6.030050250745999e-14,  2.850175636692046e-15, -1.224521630046430e-16,
  1.808167414644118e-05, -7.759064016375017e-06,  1.782043444096451e-06, -2.780189373151043e-07,  3.279668642733186e-08, -3.109099257139844e-09,  2.463352676793584e-10,
 -1.676442361292639e-11,  9.999441121577502e-13, -5.308894701686181e-14,  2.539725054916061e-15, -1.104063328635058e-16,  1.392045070975874e-05, -6.033047013614938e-06,
  1.401191169435232e-06, -2.210948549959155e-07,  2.637714455060460e-08, -2.528478413491536e-09,  2.025337660715022e-10, -1.393218193611904e-11,  8.398025288660661e-13,
 -4.504922893470278e-14,  2.177023511528234e-15, -9.557925998698316e-17,  1.037592962087444e-05, -4.532940400379532e-06,  1.062321760200242e-06, -1.691671003514771e-07,
  2.036667618609446e-08, -1.969945351312538e-09,  1.591954686096087e-10, -1.104642069882109e-11,  6.715489989143366e-13, -3.632573740993106e-14,  1.769886961668339e-15,
 -7.832868274346016e-17,  7.280009345492834e-06, -3.199816303333228e-06,  7.550711770709935e-07, -1.210835396125975e-07,  1.467945988876866e-08, -1.429636032787467e-09,
  1.163147926374431e-10, -8.124682817567559e-12,  4.971520171405324e-13, -2.706439189882804e-14,  1.326928620948609e-15, -5.908532116637877e-17,  4.492956087180475e-06,
 -1.983108475151112e-06,  4.701900519350155e-07, -7.576540988051851e-08,  9.229653094092322e-09, -9.031573773098063e-10,  7.382480995726655e-11, -5.180447331098123e-12,
  3.184244476140015e-13, -1.741142831421411e-14,  8.573641047420540e-16, -3.833862092739840e-17,  1.897328018971826e-06, -8.393955163453952e-07,  1.995444303396264e-07,
 -3.224064254645866e-08,  3.938028029359852e-09, -3.863695035683656e-10,  3.166426304869347e-11, -2.227624816166975e-12,  1.372677068901336e-13, -7.524243284312900e-15,
  3.713979462412634e-16, -1.664688152185223e-17,  6.086843990698337e-02, -1.541056366128337e-04,  4.058928531929701e-07, -1.103572906717176e-09,  3.070751271920699e-12,
 -8.677312762077001e-15,  2.474764959712311e-17, -7.091718726023946e-20,  2.035609157368799e-22, -5.841235376633021e-25,  1.673537683754818e-27, -4.783826703736131e-30,
  5.981313963438704e-02, -2.014564075124177e-04,  7.936592192339956e-07, -3.208811406642383e-09,  1.276547408915310e-11, -4.959621577946958e-14,  1.884588334742449e-16,
 -7.024764332344418e-19,  2.575499711052401e-21, -9.307626435312749e-24,  3.321196542533877e-26, -1.171666470519913e-28,  5.776015673022464e-02, -2.910508841112500e-04,
  1.646780081956845e-06, -8.796805420693359e-09,  4.433251879717205e-11, -2.135139665428588e-13,  9.919646014535658e-16, -4.473639113122347e-18,  1.967224289961452e-20,
 -8.462959989159669e-23,  3.571029991729045e-25, -1.481028005163835e-27,  5.481926982930110e-02, -4.133805053654674e-04,  3.094663156392148e-06, -2.068031908508106e-08,
  1.274609602763884e-10, -7.398082342299630e-13,  4.094543057018486e-15, -2.179004915560697e-17,  1.121709700718673e-19, -5.610862131981776e-22,  2.736689530187688e-24,
 -1.305176836097736e-26,  5.114225341092589e-02, -5.558212501661418e-04,  5.274062406827996e-06, -4.310184246413782e-08,  3.188661554686145e-10, -2.190905514294855e-12,
  1.419971240656830e-14, -8.772299855761532e-17,  5.204442124985192e-19, -2.981877291052336e-21,  1.657051149522978e-23, -8.961660846073880e-26,  4.690936474025172e-02,
 -7.042774300422772e-04,  8.277957843025562e-06, -8.148600512347092e-08,  7.133705230037317e-10, -5.725339936084038e-12,  4.291257696897730e-14, -3.041288193164327e-16,
  2.056175290008273e-18, -1.334906013498385e-20,  8.364325953780808e-23, -5.078419083736714e-25,  4.231421537117652e-02, -8.449106483094436e-04,  1.211137779875080e-05,
 -1.418104946856151e-07,  1.452315666466853e-09, -1.347212853837875e-11,  1.156343380008242e-13, -9.315087284449221e-16,  7.114081495894976e-18, -5.189642590370838e-20,
  3.637020044969031e-22, -2.459821541750234e-24,  3.754883932077335e-02, -9.656871291621757e-04,  1.666553348457535e-05, -2.295821438302900e-07,  2.724019529218199e-09,
 -2.895165004696187e-11,  2.822773173089759e-13, -2.565105429960632e-15,  2.197057620651824e-17, -1.788567841458233e-19,  1.392768632943561e-21, -1.042646861521041e-23,
  3.279056714829655e-02, -1.057532449661333e-03,  2.171651563240060e-05, -3.485675436811284e-07,  4.751460054339812e-09, -5.742511742250784e-11,  6.316024310633975e-13,
 -6.432615177799184e-15,  6.141434712891238e-17, -5.546874938495306e-19,  4.772689199348074e-21, -3.933582619352686e-23,  2.819189361442228e-02, -1.114971903316176e-03,
  2.694842213132422e-05, -4.995595882668995e-07,  7.764915366430061e-09, -1.060033516054017e-10,  1.307208939264377e-12, -1.483654654525756e-14,  1.570491498445978e-16,
 -1.565743298665071e-18,  1.481378694069914e-20, -1.337919416511903e-22,  2.387398481092397e-02, -1.136234919817369e-03,  3.199499204592570e-05, -6.795073641865542e-07,
  1.196158988253711e-08, -1.833383378415175e-10,  2.520989937196211e-12, -3.172394128916319e-14,  3.705366362642500e-16, -4.059321424217084e-18,  4.204862363181450e-20,
 -4.144316295630928e-22,  1.992391639802088e-02, -1.122891337147210e-03,  3.649008693199257e-05, -8.812756028899474e-07,  1.745902876469988e-08, -2.987817666185738e-10,
  4.558022298291663e-12, -6.329940293003025e-14,  8.122573110540993e-16, -9.737924917947463e-18,  1.100061627182309e-19, -1.178763872271966e-21,  1.639526104795306e-02,
 -1.079149809604770e-03,  4.011638929699902e-05, -1.094151203732544e-06,  2.425260839611132e-08, -4.610230251930438e-10,  7.766452622172523e-12, -1.185182316037281e-13,
  1.664122207512807e-15, -2.175024885029880e-17,  2.669961671152506e-19, -3.099773379818261e-21,  1.331131229548294e-02, -1.010976816169130e-03,  4.264332551923133e-05,
 -1.305028342746808e-06,  3.218810270429419e-08, -6.763836549179567e-10,  1.252781749597978e-11, -2.092343392364673e-13,  3.202677189739725e-15, -4.547449758831390e-17,
  6.045708225559199e-19, -7.580554701697353e-21,  1.067006780792352e-02, -9.251899524389374e-04,  4.394864090015103e-05, -1.500040051378931e-06,  4.095772707244072e-08,
 -9.470919824549312e-10,  1.920750486637167e-11, -3.497690450022775e-13,  5.815839846864326e-15, -8.941388666011971e-17,  1.283395120204469e-18, -1.732780611624376e-20,
  8.450086926948050e-03, -8.286494371104881e-04,  4.402211829641496e-05, -1.666309879454540e-06,  5.012282016232622e-08, -1.269934021643216e-09,  2.809081592403160e-11,
 -5.557395680886638e-13,  1.000470837955013e-14, -1.660249481506667e-16,  2.565169530196857e-18, -3.718777853927737e-20,  6.616449746555464e-03, -7.276283660671101e-04,
  4.295356358085431e-05, -1.793492363178389e-06,  5.916004446392332e-08, -1.635639981270579e-09,  3.931557570250439e-11, -8.421420609629168e-13,  1.636212960597340e-14,
 -2.922051959840436e-16,  4.846078004326807e-18, -7.523259233028633e-20,  5.126230631469426e-03, -6.273965208171636e-04,  4.090964596221546e-05, -1.874846011267990e-06,
  6.752257680823062e-08, -2.029222285737307e-09,  5.281549051723333e-11, -1.220890994813986e-12,  2.552292786836286e-14, -4.891196992876306e-16,  8.683632940144963e-18,
 -1.439886996899324e-19,  3.933110781511770e-03, -5.320133040653827e-04,  3.810519801290784e-05, -1.907706392370765e-06,  7.470472969053574e-08, -2.431270822340576e-09,
  6.828805458460423e-11, -1.698214070627725e-12,  3.808673364706443e-14, -7.810866224605989e-16,  1.480598877822432e-17, -2.615756364214791e-19,  2.990953942650907e-03,
 -4.442977379987331e-04,  3.477428049147913e-05, -1.893360634706953e-06,  8.029842924393342e-08, -2.819996277987131e-09,  8.519653659540836e-11, -2.272421355360822e-12,
  5.452189352983446e-14, -1.193389262971059e-15,  2.409229145092330e-17, -4.524056804422048e-19,  2.256331666426841e-03, -3.659288045454943e-04,  3.114510119902883e-05,
 -1.836434339265949e-06,  8.403264414177807e-08, -3.173654130195476e-09,  1.028085123580326e-10, -2.932559668071189e-12,  7.506580065919954e-14, -1.749119512198538e-15,
  3.751558780609575e-17, -7.470322856728254e-19,  1.690098309014548e-03, -2.976262429352912e-04,  2.742124038879724e-05, -1.743967255612331e-06,  8.579116660733125e-08,
 -3.472919635307170e-09,  1.202655550136068e-10, -3.658318497998136e-12,  9.964083173733781e-14, -2.465429229329057e-15,  5.604643956367478e-17, -1.180775035836620e-18,
  1.258181180870861e-03, -2.393671095658727e-04,  2.377002059448925e-05, -1.624370610345289e-06,  8.560877876719469e-08, -3.702825281473494e-09,  1.366722423873642e-10,
 -4.421306838261597e-12,  1.278043395048944e-13, -3.349792052908731e-15,  8.052454406964343e-17, -1.790916892468643e-18,  9.317753389018414e-04, -1.906033387173797e-04,
  2.031756923119928e-05, -1.486435125270674e-06,  8.364965093142555e-08, -3.853993800853452e-09,  1.511892273927307e-10, -5.187538722891391e-12,  1.587456467111920e-13,
 -4.396982302931984e-15,  1.115150528141337e-16, -2.612551136349073e-18,  6.871265063918112e-04, -1.504570123461243e-04,  1.714929711038432e-05, -1.338510051320996e-06,
  8.017412295490607e-08, -3.923060831987665e-09,  1.631153510776866e-10, -5.920725008656025e-12,  1.913340409611823e-13, -5.587415467819025e-15,  1.491730930558279e-16,
 -3.673491621337224e-18,  5.050610396350826e-04, -1.178807218864376e-04,  1.431415440741689e-05, -1.187916659941327e-06,  7.550065670617307e-08, -3.912337680509598e-09,
  1.719471858316331e-10, -6.585829392779055e-12,  2.242117482817345e-13, -6.887271645057901e-15,  1.931419053842111e-16, -4.988961086153368e-18,  3.703886829177951e-04,
 -9.177894633126064e-05,  1.183103595115034e-05, -1.040608015510172e-06,  6.996899178801429e-08, -3.828882418447127e-09,  1.774097325367589e-10, -7.152333585706316e-12,
  2.559173671793724e-13, -8.250493453861675e-15,  2.425060152466155e-16, -6.556946232880735e-18,  2.712694500916622e-04, -7.109230279511860e-05,  9.695959489039096e-06,
 -9.010485876963430e-07,  6.390890585242813e-08, -3.683209799580052e-09,  1.794577373687642e-10, -7.596758749857683e-12,  2.850202745632837e-13, -9.622398033784786e-15,
  2.958116951795147e-16, -8.355092710294800e-18,  1.986050150729431e-04, -5.484998329912443e-05,  7.889005887730465e-06, -7.722650454287307e-07,  5.761703682024925e-08,
 -3.487877283225017e-09,  1.782519181123495e-10, -7.904168529892017e-12,  3.102459303088376e-13, -1.094435583345881e-14,  3.511548821495266e-16, -1.033979816547824e-17,
  1.454898235263803e-04, -4.219715154610068e-05,  6.380388462835965e-06, -6.560119926422651e-07,  5.134242541287684e-08, -3.256148456504117e-09,  1.741174786876154e-10,
 -8.068581918634584e-12,  3.305754301559791e-13, -1.215883003333732e-14,  4.063246826987390e-16, -1.244779412253756e-17,  1.067383678978932e-04, -3.240413152392652e-05,
  5.135345570483610e-06, -5.529997283274553e-07,  4.528006579384584e-08, -3.000874751739313e-09,  1.674934175154043e-10, -8.092404623287136e-12,  3.453087720331385e-13,
 -1.321406316225721e-14,  4.589814317781126e-16, -1.460007609226509e-17,  7.849222245100447e-05, -2.486343910903270e-05,  4.117796084833575e-06, -4.631409291764363e-07,
  3.957091404921481e-08, -2.733669711183877e-09,  1.588805644798223e-10, -7.985113694240519e-12,  3.540883811091322e-13, -1.406782473304737e-14,  5.068437975368870e-16,
 -1.670764773393526e-17,  5.790248413158155e-05, -1.907953950101764e-05,  3.292857005133558e-06, -3.857855253714763e-07,  3.430646445775386e-08, -2.464390965151186e-09,
  1.487945658598481e-10, -7.761489670595910e-12,  3.568858750567330e-13, -1.468984920377782e-14,  5.478601106075888e-16, -1.867827397712127e-17,  4.287901096448444e-05,
 -1.465497164817217e-05,  2.628407535377374e-06, -3.199250930038321e-07,  2.953604678847998e-08, -2.200901431698275e-09,  1.377278052244566e-10, -7.439688450675503e-12,
  3.539597271795795e-13, -1.506283909606654e-14,  5.803441264427326e-16, -2.042333637117388e-17,  3.189616545565752e-05, -1.127535390769642e-05,  2.095912966793117e-06,
 -2.643581277894532e-07,  2.527528171870426e-08, -1.949055315506618e-09,  1.261220409153067e-10, -7.039397891984911e-12,  3.457939250848501e-13, -1.518213059849670e-14,
  6.030631354361909e-16, -2.186395273958463e-17,  2.384472020644148e-05, -8.694862248693024e-06,  1.670713810037709e-06, -2.178149128866894e-07,  2.151452464126238e-08,
 -1.712844522290302e-09,  1.143517213883995e-10, -6.580252452805952e-12,  3.330280316497823e-13, -1.505428201291424e-14,  6.152747770522472e-16, -2.293572517821428e-17,
  1.792045806006382e-05, -6.723075088233909e-06,  1.331957356145240e-06, -1.790453780294793e-07,  1.822653121061277e-08, -1.494643142928237e-09,  1.027166803719111e-10,
 -6.080602158455319e-12,  3.163877327950536e-13, -1.469493342540530e-14,  6.167163975431475e-16, -2.359175592338750e-17,  1.354130507353878e-05, -5.213589401353054e-06,
  1.062312462743935e-06, -1.468757999680856e-07,  1.537292892843524e-08, -1.295497123082534e-09,  9.144222752200043e-11, -5.556663931848624e-12,  2.966226722969976e-13,
 -1.412630224944565e-14,  6.075561997393764e-16, -2.380385626620958e-17,  1.028625384242569e-05, -4.054494458955085e-06,  8.475718731916300e-07, -1.202410025424537e-07,
  1.290934898128224e-08, -1.115419031947871e-09,  8.068444629009536e-11, -5.022031808783253e-12,  2.744557740268498e-13, -1.337463981660136e-14,  5.883183287516672e-16,
 -2.356211761412020e-17,  7.850682734668845e-06, -3.160601074089093e-06,  6.762142354060108e-07, -9.819845589261329e-08,  1.078925678728017e-08, -9.536609279627811e-10,
  7.053865052331380e-11, -4.487490129045199e-12,  2.505458373981098e-13, -1.246790064448353e-14,  5.597945676102643e-16, -2.287318414405810e-17,  6.013861432673013e-06,
 -2.467227417267801e-06,  5.389720629422344e-07, -7.992982758532802e-08,  8.966628384649396e-09, -8.089497942423094e-10,  6.104929224603937e-11, -3.961058811238916e-12,
  2.254632690688984e-13, -1.143378959949314e-14,  5.229540189954763e-16, -2.175765294071124e-17,  4.615422227504934e-06, -1.925305926905547e-06,  4.284323851145909e-07,
 -6.473445446876957e-08,  7.397669717569298e-09, -6.796789886711950e-10,  5.222003523252233e-11, -3.448198416920297e-12,  1.996775054459912e-13, -1.029826968593956e-14,
  4.788597254520606e-16, -2.024703744965737e-17,  3.538371911532456e-06, -1.497575861699205e-06,  3.386830666356980e-07, -5.201811031222974e-08,  6.041784975079584e-09,
 -5.640554600027763e-10,  4.402312677098041e-11, -2.952110332397150e-12,  1.735539682584054e-13, -9.084545356491233e-15,  4.285983113931799e-16, -1.838068197916465e-17,
  2.696840894850052e-06, -1.155645870730969e-06,  2.650086568208082e-07, -4.127946811970716e-08,  4.861984223427979e-09, -4.602064066719704e-10,  3.640756250882915e-11,
 -2.474079854895559e-12,  1.473581762595523e-13, -7.812487887412138e-15,  3.732259560237802e-16, -1.620293157513269e-17,  2.027241448687516e-06, -8.777395360879375e-07,
  2.036340158350941e-07, -3.209585318196217e-08,  3.824891973761568e-09, -3.662511009431322e-10,  2.930582454133647e-11, -2.013824021970083e-12,  1.212647731152962e-13,
 -6.498440787833165e-15,  3.137316814089065e-16, -1.376076450603333e-17,  1.481863788068209e-06, -6.469674303817100e-07,  1.515108566366829e-07, -2.410926553475121e-08,
  2.900485984872810e-09, -2.803443458626733e-10,  2.263918172363783e-11, -1.569819679755628e-12,  9.536959962737066e-14, -5.155332309105263e-15,  2.510172618020736e-16,
 -1.110200207449887e-17,  1.024203609069020e-06, -4.499985292420620e-07,  1.061410347698688e-07, -1.701322296357485e-08,  2.061667467510597e-09, -2.006982214631247e-10,
  1.632170423934398e-11, -1.139600796014142e-12,  6.970351243324643e-14, -3.793029598874283e-15,  1.858922883046085e-16, -8.274144190103597e-18,  6.255220414431603e-07,
 -2.760356619199357e-07,  6.543164747986804e-08, -1.054093066345610e-08,  1.283769838103462e-09, -1.255914550432758e-10,  1.026349444840678e-11, -7.200422241606782e-13,
  4.424828963062220e-14, -2.418942136118355e-15,  1.190855282933089e-16, -5.323958677476194e-18,  2.626142235984280e-07, -1.161698278833474e-07,  2.761277954521668e-08,
 -4.460839290870541e-09,  5.447960091196280e-10, -5.344418738821406e-11,  4.379353795636040e-12, -3.080535921377293e-13,  1.898002621919715e-14, -1.040246097338175e-15,
  5.134028154736571e-17, -2.300900986660765e-18,  6.025842893668144e-02, -1.509106430256186e-04,  3.929391461287647e-07, -1.055797647606447e-09,  2.902987335745619e-12,
 -8.106480248755468e-15,  2.285009214981515e-17, -6.472717387645654e-20,  1.836883903535708e-22, -5.212061114796553e-25,  1.476765376185228e-27, -4.175123706057354e-30,
  5.901977348670099e-02, -1.952577583192719e-04,  7.563470125365954e-07, -3.012259989322722e-09,  1.181723352675669e-11, -4.530022353626780e-14,  1.698947155764056e-16,
 -6.251749873546206e-19,  2.263146085671652e-21, -8.076728011802938e-24,  2.846383345661339e-26, -9.918741427571357e-29,  5.662164972401868e-02, -2.782871480143473e-04,
  1.545337496189368e-06, -8.120395177101021e-09,  4.029052079511455e-11, -1.911415436397075e-13,  8.750767967540868e-16, -3.890239684596513e-18,  1.686773238192358e-20,
 -7.156768013667877e-23,  2.979000518488514e-25, -1.218997157029458e-27,  5.321373821899965e-02, -3.895822768698214e-04,  2.858264051730020e-06, -1.875417412968372e-08,
  1.136000858083981e-10, -6.484729826650718e-13,  3.531782042640050e-15, -1.850371029779887e-17,  9.381136086672835e-20, -4.622918796249102e-22,  2.221992870409178e-24,
 -1.044531605948773e-26,  4.900019586941499e-02, -5.156141216448345e-04,  4.786063227099778e-06, -3.833281492571940e-08,  2.782663416133548e-10, -1.877800217206181e-12,
  1.196135879147611e-14, -7.266575146154024e-17,  4.241347528599310e-19, -2.391666451724970e-21,  1.308497895284361e-23, -6.969149177194504e-26,  4.421877231094202e-02,
 -6.417794115732389e-04,  7.365004289165333e-06, -7.093494015295647e-08,  6.085096008192263e-10, -4.790612236474966e-12,  3.525025393322479e-14, -2.454158410137783e-16,
  1.630810253740309e-18, -1.041089652839169e-20,  6.416999823792157e-23, -3.833917363662197e-25,  3.911810909871175e-02, -7.544510400053767e-04,  1.054064783849480e-05,
 -1.205866237231923e-07,  1.208638646895065e-09, -1.098579773980734e-11,  9.247719438683105e-14, -7.311415043823077e-16,  5.483531769502708e-18, -3.930313777636637e-20,
  2.707543479334181e-22, -1.800705416231675e-24,  3.393628197259142e-02, -8.426836016178113e-04,  1.415407444203342e-05, -1.902850688218840e-07,  2.207302096440892e-09,
 -2.296501042820065e-11,  2.194009676966118e-13, -1.955153774372004e-15,  1.643297636596535e-17, -1.313478379270146e-19,  1.004733327728964e-21, -7.391808282356315e-24,
  2.888312633532948e-02, -8.993213933940537e-04,  1.795445438661152e-05, -2.809660591511571e-07,  3.741027072921572e-09, -4.422315653120435e-11,  4.762451673973636e-13,
 -4.753149737911053e-15,  4.450188488736811e-17, -3.943978156109173e-19,  3.331622479345417e-21, -2.697060012235486e-23,  2.412799666566786e-02, -9.214020418824418e-04,
  2.163433567397316e-05, -3.907085341470950e-07,  5.927657134853280e-09, -7.909578917902446e-11,  9.544230271269540e-13, -1.060908330957443e-14,  1.100663806745776e-16,
 -1.076199165856490e-18,  9.991595356406214e-21, -8.859563009453620e-23,  1.979357347086454e-02, -9.098965081043279e-04,  2.487809093221477e-05, -5.144482174749585e-07,
  8.834301992474845e-09, -1.322782125559589e-10,  1.778873858386688e-12, -2.191293901992128e-14,  2.507392340256899e-16, -2.692860656148514e-18,  2.736133062573373e-20,
 -2.646621243389181e-22,  1.595536623781572e-02, -8.689413382468307e-04,  2.741137575355222e-05, -6.443462013313195e-07,  1.244766363602151e-08, -2.080166044297058e-10,
  3.102342225341394e-12, -4.215906458312687e-14,  5.297982374044776e-16, -6.224578411550067e-18,  6.895284753090754e-20, -7.249223032041147e-22,  1.264583419985096e-02,
 -8.047813932003422e-04,  2.904051442192481e-05, -7.707743227534785e-07,  1.665557466797010e-08, -3.090887383485834e-10,  5.089038033387820e-12, -7.597363229489571e-14,
  1.044432813280038e-15, -1.337471411424987e-17,  1.609615051203087e-19, -1.833110048793946e-21,  9.861643416399141e-03, -7.246474816795449e-04,  2.967456731796950e-05,
 -8.837052209451263e-07,  2.124655444130878e-08, -4.357985422287428e-10,  7.887787852159638e-12, -1.288580124740184e-13,  1.930834138996406e-15, -2.685738911749460e-17,
  3.500120907263536e-19, -4.304538962809148e-21,  7.572499514720187e-03, -6.357542170425044e-04,  2.932788986430657e-05, -9.741908789496481e-07,  2.592965792902378e-08,
 -5.852579712050947e-10,  1.159839911095296e-11, -2.065795548301091e-13,  3.362408981012034e-15, -5.063915962654850e-17,  7.124641026863998e-19, -9.434523138438544e-21,
  5.730176375508655e-03, -5.445381212814155e-04,  2.810565912442357e-05, -1.035607905442857e-06,  3.037139529342545e-08, -7.511925355093483e-10,  1.623825636973784e-11,
 -3.142319685595442e-13,  5.537789533732670e-15, -9.002593028863159e-17,  1.363483200644628e-18, -1.938773207346720e-20,  4.276703240738734e-03, -4.561849253012589e-04,
  2.617797535939362e-05, -1.064431788727243e-06,  3.424193437434061e-08, -9.243874944778616e-10,  2.171776047645002e-11, -4.551014588806763e-13,  8.657196675186285e-15,
 -1.514764031298303e-16,  2.462871371095001e-18, -3.750630968986205e-20,  3.151073238409454e-03, -3.744344044033756e-04,  2.374929493699929e-05, -1.060438463605425e-06,
  3.726063156551295e-08, -1.093727466020041e-09,  2.783221468403002e-11, -6.295725041202968e-13,  1.288887081748231e-14, -2.420548341505920e-16,  4.213903770618243e-18,
 -6.855612149097355e-20,  2.294211054676397e-03, -3.016101810816058e-04,  2.102932326722531e-05, -1.026372282437957e-06,  3.923167243751133e-08, -1.247627887157017e-09,
  3.427422218700240e-11, -8.343477589015773e-13,  1.833084386115303e-14, -3.685128693953694e-16,  6.851724940990412e-18, -1.187995705622474e-19,  1.652232942758810e-03,
 -2.388028246409107e-04,  1.820971219524178e-05, -9.672253533281924e-07,  4.006370950013956e-08, -1.375562162135223e-09,  4.066563895526059e-11, -1.062216269077013e-12,
  2.497602727806750e-14, -5.360978132527998e-16,  1.061955623330883e-17, -1.957777085124813e-19,  1.178226663006198e-03, -1.861340043183250e-04,  1.544870602688273e-05,
 -8.893236616344731e-07,  3.977163866651288e-08, -1.469379214921967e-09,  4.660324307303789e-11, -1.302488402156974e-12,  3.268928691105097e-14, -7.472905519847125e-16,
  1.573390905902862e-17, -3.077181083033426e-19,  8.328759437051014e-04, -1.430413120880556e-04,  1.286388496939489e-05, -7.994105856927851e-07,  3.846269032457841e-08,
 -1.524177233436600e-09,  5.170906924659105e-11, -1.542058527044248e-12,  4.120334583192456e-14, -1.000741830139976e-15,  2.234345790767351e-17, -4.625605571893761e-19,
  5.842730627300716e-04, -1.085411182495054e-04,  1.053173804855711e-05, -7.038736107162218e-07,  3.631179437558581e-08, -1.538620414026529e-09,  5.567568720269919e-11,
 -1.766906633175468e-12,  5.013638253137775e-14, -1.290671407386415e-15,  3.048908944580939e-17, -6.666956051795852e-19,  4.072298761828631e-04, -8.144509237816181e-05,
  8.492072085015941e-06, -6.081967904647029e-07,  3.353226894370057e-08, -1.514715760633044e-09,  5.829853810930205e-11, -1.963752884835862e-12,  5.902923400735876e-14,
 -1.606914211489012e-15,  4.007382031695483e-17, -9.236121249970184e-19,  2.823368093435762e-04, -6.052136224626813e-05,  6.755143534653768e-06, -5.166596316751090e-07,
  3.034741452690683e-08, -1.457170660540854e-09,  5.949097038393164e-11, -2.121559485503378e-12,  6.739566699810050e-14, -1.935661039102574e-15,  5.085015530591123e-17,
 -1.232714823703092e-18,  1.949505706033802e-04, -4.460215167219493e-05,  5.309695616315709e-06, -4.322558024869603e-07,  2.696708399282893e-08, -1.372508418474056e-09,
  5.928164344397912e-11, -2.232630273295038e-12,  7.477651255257257e-14, -2.260788244433556e-15,  6.242918692735995e-17, -1.588574717964264e-18,  1.342276239025533e-04,
 -3.264605989370600e-05,  4.130584422352651e-06, -3.567777308466822e-07,  2.357138045102980e-08, -1.268125339837291e-09,  5.779737986919994e-11, -2.293165742195221e-12,
  8.078818162241485e-14, -2.565545422632643e-15,  7.431119583514087e-17, -1.980807794577358e-18,  9.226856411895469e-05, -2.376572124539558e-05,  3.185212130065976e-06,
 -2.910046277288559e-07,  2.030185374823978e-08, -1.151440388262527e-09,  5.523663290229683e-11, -2.303254356502612e-12,  8.515801824409660e-14, -2.834305434677897e-15,
  8.593298643453754e-17, -2.394655187809103e-18,  6.340056846665919e-05, -1.723155908693466e-05,  2.438442077969976e-06, -2.349367984058637e-07,  1.725925855729061e-08,
 -1.029234791307751e-09,  5.183930644193307e-11, -2.266386981317896e-12,  8.774231188710752e-14, -3.054089140327162e-15,  9.672391552693249e-17, -2.812195464408600e-18,
  4.360011860672203e-05, -1.246083511891231e-05,  1.855999147324778e-06, -1.880321860388747e-07,  1.450621587885716e-08, -9.072219652213155e-10,  4.785796591938813e-11,
 -2.188648523302202e-12,  8.852652822919612e-14, -3.215647474275478e-15,  1.061613135008156e-16, -3.213994807877515e-18,  3.004376252973261e-05, -8.999075675277249e-06,
  1.406555234442651e-06, -1.494165467356452e-07,  1.207292692371631e-08, -7.898407166134299e-10,  4.353400357210492e-11, -2.077763019389420e-12,  8.761047954547919e-14,
 -3.313989980255648e-15,  1.138168705235934e-16, -3.580925211894009e-18,  2.076794465107670e-05, -6.498818930513510e-06,  1.062786117271095e-06, -1.180527622121526e-07,
  9.964272159599769e-09, -6.802333219415781e-10,  3.908060326942874e-11, -1.942151830318459e-12,  8.518314849334503e-14, -3.348360598249946e-15,  1.193880792292974e-16,
 -3.895868668555411e-18,  1.441723657939556e-05, -4.698794088299744e-06,  8.016955747363855e-07, -9.286562225534851e-08,  8.167015493608747e-09, -5.803554719230245e-10,
  3.467281051497391e-11, -1.790123172241687e-12,  8.149254063483791e-14, -3.321752334953234e-15,  1.227121524657609e-16, -4.145072252394138e-18,  1.006154066416197e-05,
 -3.405239450004805e-06,  6.044672121754984e-07, -7.282546052230010e-08,  6.656277180449025e-09, -4.911640698247795e-10,  3.044389646325311e-11, -1.629260455878208e-12,
  7.681546897949613e-14, -3.240107390922688e-15,  1.237630863726561e-16, -4.319005803207888e-18,  7.065503106889820e-06, -2.476088896469432e-06,  4.560494217330735e-07,
 -5.699772366551040e-08,  5.400840057718212e-09, -4.128367258539107e-10,  2.648658033042222e-11, -1.466029534014670e-12,  7.143097026039045e-14, -3.111365522735988e-15,
  1.226350384840868e-16, -4.412674903195542e-18,  4.996485847053711e-06, -1.808139197342274e-06,  3.446212814084263e-07, -4.456673706626856e-08,  4.367161944772433e-09,
 -3.449888025749686e-10,  2.285748531074781e-11, -1.305588816160793e-12,  6.559956162524637e-14, -2.944507613009339e-15,  1.195165955435541e-16, -4.425433109896040e-18,
  3.560443307155375e-06, -1.326965255545412e-06,  2.610364949072359e-07, -3.484150786473761e-08,  3.522170540711912e-09, -2.868664033993505e-10,  1.958332603304012e-11,
 -1.151764123634517e-12,  5.954913378778097e-14, -2.748705434509354e-15,  1.146608076709419e-16, -4.360402626657367e-18,  2.557657026258940e-06, -9.791918442787098e-07,
  1.983026305355982e-07, -2.725014754460402e-08,  2.835027775138461e-09, -2.375045005047062e-10,  1.666762432200649e-11, -1.007141148518887e-12,  5.346717182133089e-14,
 -2.532644953112453e-15,  1.083552973170325e-16, -4.223645218288021e-18,  1.852406397404566e-06, -7.266887613656630e-07,  1.511243111621787e-07, -2.132795696682648e-08,
  2.278091013499554e-09, -1.958474614464241e-10,  1.409710883347090e-11, -8.732293075910021e-13,  4.749828744904353e-14, -2.304049334875313e-15,  1.008956601442976e-16,
 -4.023227356992813e-18,  1.352308320038827e-06, -5.422801426849016e-07,  1.155201473843630e-07, -1.670273884151990e-08,  1.827293150861462e-09, -1.608344506693008e-10,
  1.184729292161918e-11, -7.506578507449768e-13,  4.174571875443694e-14, -2.069395391990236e-15,  9.256410683339838e-17, -3.768303131748266e-18,  9.943030313819831e-07,
 -4.066132865767665e-07,  8.851190221881068e-08, -1.307965850978317e-08,  1.462133240524736e-09, -1.314549725773140e-10,  9.887000137243479e-12, -6.393748709582092e-13,
  3.627542325277776e-14, -1.833795992635365e-15,  8.361411962725508e-17, -3.468305371146338e-18,  7.351744980413138e-07, -3.058964012850128e-07,  6.787843698343109e-08,
 -1.022701923223960e-08,  1.165429124848619e-09, -1.067808175714047e-10,  8.181803347386880e-12, -5.388298401625337e-13,  3.112155453667685e-14, -1.601010519257199e-15,
  7.426097784375746e-17, -3.132299027419730e-18,  5.451466774110147e-07, -2.302763788981720e-07,  5.196456221603460e-08, -7.963639898108352e-09,  9.229432510992524e-10,
 -8.598050504763048e-11,  6.696465939626777e-12, -4.481289317928729e-13,  2.629237441979442e-14, -1.373543613350548e-15,  6.467740328065096e-17, -2.768518059930168e-18,
  4.035568485738589e-07, -1.726814545641425e-07,  3.953459752946574e-08, -6.148075370384775e-09,  7.229576518788295e-10, -6.832151377894288e-11,  5.396536076433045e-12,
 -3.661590101314818e-13,  2.177593721552599e-14, -1.152796387838195e-15,  5.499327392555899e-17, -2.384081799638468e-18,  2.959266152970469e-07, -1.279976265060101e-07,
  2.966124735656109e-08, -4.669647351471174e-09,  5.558459772709518e-10, -5.316453214569260e-11,  4.249264671371434e-12, -2.916807013848650e-13,  1.754514297620650e-14,
 -9.392413755525590e-16,  4.529829357350444e-17, -1.984870398446876e-18,  2.119704754352006e-07, -9.248223805936946e-08,  2.164169089148625e-08, -3.441105294817099e-09,
  4.136696138215925e-10, -3.995289632936566e-11,  3.224010974888472e-12, -2.233937208091120e-13,  1.356196998298319e-14, -7.326007175298480e-16,  3.564661468175283e-17,
 -1.575531050355750e-18,  1.442310940866613e-07, -6.334441133244848e-08,  1.493420053856939e-08, -2.392672794344272e-09,  2.898107447091610e-10, -2.819948186458396e-11,
  2.292281974327853e-12, -1.599792478288228e-13,  9.780869755790520e-15, -5.320157653620360e-16,  2.606265355776529e-17, -1.159587007319206e-18,  8.713293182850027e-08,
 -3.844233789962823e-08,  9.110124872537394e-09, -1.467253399098263e-09,  1.786501217930520e-10, -1.747299474294342e-11,  1.427562318129305e-12, -1.001271769961841e-13,
  6.151575436073655e-15, -3.362117602616897e-16,  1.654800553136410e-17, -7.396437153166171e-19,  3.635942236089921e-08, -1.608205789685769e-08,  3.822088208879436e-09,
 -6.173735150770451e-10,  7.538866133077410e-11, -7.394581602948807e-12,  6.058494010272832e-13, -4.261112989309541e-14,  2.625042541564254e-15, -1.438530458379094e-16,
  7.098806093635309e-18, -3.181045930731792e-19,  5.966099424903775e-02, -1.478170306623937e-04,  3.805430057281511e-07, -1.010617695024920e-09,  2.746198312309688e-12,
 -7.579179088880968e-15,  2.111728216050154e-17, -5.913830909673299e-20,  1.659454386254119e-22, -4.656492441804823e-25,  1.304906787462096e-27, -3.649240587526561e-30,
  5.825061952267911e-02, -1.893484238569012e-04,  7.213051506560547e-07, -2.830216553751149e-09,  1.095062707243987e-11, -4.142488663613008e-14,  1.533615127158869e-16,
 -5.571950230186610e-19,  1.991868510560599e-21, -7.020835466703325e-24,  2.444035997850192e-26, -8.413603099379666e-29,  5.553262447949901e-02, -2.663035512926876e-04,
  1.451638088349836e-06, -7.505224358653846e-09,  3.666919070320981e-11, -1.713881282589927e-13,  7.733353139722905e-16, -3.389496346722885e-18,  1.449346372099356e-20,
 -6.065847710062794e-23,  2.491111073926578e-25, -1.005892441627387e-27,  5.169975837866084e-02, -3.675864221989809e-04,  2.643706029445342e-06, -1.703589323360903e-08,
  1.014379774857747e-10, -5.696030243414436e-13,  3.053321005130934e-15, -1.575173296115295e-17,  7.866383076017052e-20, -3.819626088803678e-22,  1.809458814727144e-24,
 -8.385553507058159e-27,  4.701150631529179e-02, -4.790926587450933e-04,  4.351592367509439e-06, -3.416606905277077e-08,  2.434238587775597e-10, -1.613685715325281e-12,
  1.010447332585289e-14, -6.037572828737320e-17,  3.467611334806439e-19, -1.924801104109437e-21,  1.036953823138013e-23, -5.439923585104523e-26,  4.176432810766704e-02,
 -5.861057340496167e-04,  6.569182884306183e-06, -6.192155269877592e-08,  5.206298828969475e-10, -4.021498235005890e-12,  2.905621926868396e-14, -1.987624018704295e-16,
  1.298424990682574e-18, -8.152218867129167e-21,  4.943795808757313e-23, -2.907092680740513e-25,  3.626023376884575e-02, -6.756012136337633e-04,  9.202759466276458e-06,
 -1.028921625189366e-07,  1.009556178494087e-09, -8.993416482286846e-12,  7.426319655652873e-14, -5.763625641730818e-16,  4.245865799007204e-18, -2.990627699564792e-20,
  2.025481862682147e-22, -1.324890179462685e-24,  3.077835490781013e-02, -7.380174395184679e-04,  1.206827605946332e-05, -1.583741354368462e-07,  1.796513351784416e-09,
 -1.830100403999233e-11,  1.713596036900374e-13, -1.497792725581757e-15,  1.235576889068945e-17, -9.698381427107521e-20,  7.288837906604664e-22, -5.270765379172594e-24,
  2.555311136454660e-02, -7.682179676773063e-04,  1.491470763321828e-05, -2.276068216220851e-07,  2.960861791358367e-09, -3.424166606636465e-11,  3.611300903907231e-13,
 -3.532697327915327e-15,  3.244134272636925e-17, -2.821693438903100e-19,  2.340516998362261e-21, -1.861348021228322e-23,  2.076097133975944e-02, -7.655816569765319e-04,
  1.746645693636395e-05, -3.073710494327546e-07,  4.552655953206833e-09, -5.938950710040702e-11,  7.013627581912750e-13, -7.636746483985622e-15,  7.766679250759474e-17,
 -7.449021346304411e-19,  6.787470680466021e-21, -5.909709408535336e-23,  1.651608391102322e-02, -7.333493304203413e-04,  1.947248256313627e-05, -3.921376244245350e-07,
  6.570300414811376e-09, -9.612386582081897e-11,  1.264452525422172e-12, -1.525000376094093e-14,  1.709774456603592e-16, -1.800389410788814e-18,  1.794646130835559e-20,
 -1.703916621898227e-22,  1.287360645821510e-02, -6.774849488641899e-04,  2.074899127852697e-05, -4.747901496951776e-07,  8.945363801264108e-09, -1.459995477643270e-10,
  2.129012482908125e-12, -2.831529863614085e-14,  3.485198606436633e-16, -4.013401484556502e-18,  4.360168341176638e-20, -4.498071956458675e-22,  9.838604574785163e-03,
 -6.053541629580216e-04,  2.120583097743120e-05, -5.477638334406698e-07,  1.154064132896306e-08, -2.091063845105976e-10,  3.365320084936386e-12, -4.915541226127027e-14,
  6.616953076562007e-16, -8.303034757683528e-18,  9.797586459890694e-20, -1.094645070236160e-21,  7.378047622952317e-03, -5.244909365945476e-04,  2.085239221644059e-05,
 -6.043141178196786e-07,  1.416401946327432e-08, -2.836112544888749e-10,  5.016735724050799e-12, -8.017098045397284e-14,  1.176100599941795e-15, -1.602753442284629e-17,
  2.047689213935255e-19, -2.470211088897350e-21,  5.433587358455220e-03, -4.416396686510343e-04,  1.978467742372602e-05, -6.396009970745026e-07,  1.659593692091375e-08,
 -3.656548715374795e-10,  7.081431616938020e-12, -1.233721765075165e-13,  1.965806190027994e-15, -2.900332917852394e-17,  4.000115691336711e-19, -5.195525066473471e-21,
  3.933322245012982e-03, -3.621587618140384e-04,  1.815943817362104e-05, -6.513478806998437e-07,  1.862407890547020e-08, -4.496875588184406e-10,  9.499834546133554e-12,
 -1.798229161670896e-13,  3.102409093336775e-15, -4.940920068446607e-17,  7.335753733940379e-19, -1.023127760472274e-20,  2.801418786404556e-03, -2.897805461557553e-04,
  1.616304889049443e-05, -6.399706784735250e-07,  2.007692141737231e-08, -5.292021194651952e-10,  1.215243174725469e-11, -2.491312781248865e-13,  4.639947626801389e-15,
 -7.954311857015994e-17,  1.267933427650334e-18, -1.894126378284113e-20,  1.965111684059989e-03, -2.266595474644698e-04,  1.398219520608938e-05, -6.082193315051304e-07,
  2.084845173460748e-08, -5.977044194939214e-10,  1.487006494628661e-11, -3.291377691153079e-13,  6.598562552068454e-15, -1.214370421704106e-16,  2.072986578541497e-18,
 -3.308897733049759e-20,  1.359122803245841e-03, -1.736115576749851e-04,  1.178129543961121e-05, -5.604831018524368e-07,  2.090932785319258e-08, -6.496961339104649e-10,
  1.745536706989754e-11, -4.159199137798379e-13,  8.951004579338270e-15, -1.763850372894755e-16,  3.216583622568372e-18, -5.473219329597450e-20,  9.278755378069354e-04,
 -1.304452693574024e-04,  9.688859755803742e-06, -5.019580011363645e-07,  2.030366116107130e-08, -6.814498032971914e-10,  1.971082487249013e-11, -5.041539501668281e-13,
  1.161610058444192e-14, -2.444848330030097e-16,  4.751648720341154e-18, -8.599506677691948e-20,  6.260404276998780e-04, -9.630655204571229e-05,  7.792582693068903e-06,
 -4.378609232199204e-07,  1.913413470199746e-08, -6.914257805148024e-10,  2.146719261740307e-11, -5.877777460346371e-13,  1.446190909630907e-14, -3.243130548534087e-16,
  6.702199423810042e-18, -1.287287724572600e-19,  4.179672605591427e-04, -6.998207119162312e-05,  6.141357608684114e-06, -3.728198922137330e-07,  1.754032778502316e-08,
 -6.802839305960546e-10,  2.260615750417376e-11, -6.608171371478435e-13,  1.731889037780761e-14, -4.128376478384864e-16,  9.051468152568770e-18, -1.841100391989491e-19,
  2.764884757566497e-04, -5.013530695809169e-05,  4.751710349198737e-06, -3.104995559277161e-07,  1.567558835829410e-08, -6.505433322819724e-10,  2.307303897491751e-11,
 -7.181980942181310e-13,  2.000078413897946e-14, -5.056190368321799e-16,  1.173538733698652e-17, -2.522588666553191e-19,  1.814657186665290e-04, -3.546894960614804e-05,
  3.616211322104248e-06, -2.534581622071290e-07,  1.368686023480819e-08, -6.060118711048453e-10,  2.287809998313622e-11, -7.563797591657535e-13,  2.232891401976006e-14,
 -5.972800071326726e-16,  1.464372172201064e-17, -3.319689001844220e-19,  1.183316581020250e-04, -2.482123152559030e-05,  2.711949352267209e-06, -2.031899033477950e-07,
  1.170015674848876e-08, -5.511319755216332e-10,  2.208778911309189e-11, -7.736994340301734e-13,  2.415493373262001e-14, -6.821565478461261e-16,  1.762937683157785e-17,
 -4.206289542680346e-19,  7.677462016400029e-05, -1.721045617015416e-05,  2.007846515390137e-06, -1.602878546158563e-07,  9.812539807974243e-09, -4.903728178013378e-10,
  2.080915049233923e-11, -7.703977317042259e-13,  2.537771628252483e-14, -7.549995620638061e-16,  2.052442758860353e-17, -5.143743235906120e-19,  4.963395870409257e-05,
 -1.184349115030972e-05,  1.470245714353433e-06, -1.246636648797371e-07,  8.090000767406594e-09, -4.277578015702761e-10,  1.917138669262177e-11, -7.483649420747347e-13,
  2.595180786669959e-14, -8.115918982776724e-16,  2.315982298397273e-17, -6.084534206254482e-19,  3.202048301626640e-05, -8.102306625162428e-06,  1.066696002486311e-06,
 -9.577322480474127e-08,  6.569772542653477e-09, -3.665667519683780e-10,  1.730822197649503e-11, -7.106991747301768e-13,  2.588698641863913e-14, -8.491747343436264e-16,
  2.538499454145479e-17, -6.977453191047195e-19,  2.064489902533633e-05, -5.519491383496010e-06,  7.681633844982581e-07, -7.281526304402281e-08,  5.265323507797161e-09,
 -3.092092326988673e-10,  1.534365975089194e-11, -6.611851412858658e-13,  2.524033671727187e-14, -8.666291899052334e-16,  2.708387049913047e-17, -7.773317464882796e-19,
  1.332238481289024e-05, -3.750282402141021e-06,  5.500307362145907e-07, -5.488665993183749e-08,  4.172441694613084e-09, -2.572367449939836e-10,  1.338241795028133e-11,
 -6.037925264034859e-13,  2.410344098857510e-14, -8.644156781735389e-16,  2.818488429857454e-17, -8.430208761294049e-19,  8.617445586520529e-06, -2.545688437347394e-06,
  3.922677465782917e-07, -4.109119301292464e-08,  3.275214334836424e-09, -2.114487472833915e-10,  1.150514331696732e-11, -5.422646836685817e-13,  2.258764409953505e-14,
 -8.443194074998773e-16,  2.866405846952144e-17, -8.917389728265135e-19,  5.595431839039943e-06, -1.729051277215216e-06,  2.791007563219759e-07, -3.060657161731106e-08,
  2.551167919613304e-09, -1.720475718802552e-10,  9.767675012729996e-12, -4.798337151121137e-13,  2.081000624057062e-14, -8.090765037548850e-16,  2.854169204563947e-17,
 -9.217413129089921e-19,  3.652234051702581e-06, -1.176882114610981e-06,  1.984334352414081e-07, -2.271851126863496e-08,  1.975240401610607e-09, -1.388055545863790e-10,
  8.203209881142374e-12, -4.190666144982481e-13,  1.888177591472790e-14, -7.619599340001223e-16,  2.787423601110481e-17, -9.326342295213824e-19,  2.399584370826462e-06,
 -8.039131004313239e-07,  1.411889583313226e-07, -1.683141214624978e-08,  1.522553982342425e-09, -1.112192507006880e-10,  6.826156597283642e-12, -3.618247834499166e-13,
  1.690030267913857e-14, -7.063922238614380e-16,  2.674344643640171e-17, -9.252349167311525e-19,  1.588942432206402e-06, -5.518506365863835e-07,  1.006766747319866e-07,
 -1.246418589653097e-08,  1.170135564556985e-09, -8.863692093239045e-11,  5.636636316719179e-12, -3.093074511287656e-13,  1.494449962873029e-14, -6.456302847154393e-16,
  2.524488126005241e-17, -9.013179243641056e-19,  1.061605397479462e-06, -3.811523254889611e-07,  7.203602803220572e-08, -9.237939117582732e-09,  8.978117449105833e-10,
 -7.035451517654655e-11,  4.624869907451324e-12, -2.621469343328151e-13,  1.307339308442345e-14, -5.825439270445261e-16,  2.347740121989509e-17, -8.633050985566956e-19,
  7.163364814240386e-07, -2.651514531941576e-07,  5.177702344651750e-08, -6.860255250552629e-09,  6.885162194898640e-10, -5.568147673258748e-11,  3.774989164379067e-12,
 -2.205273717100107e-13,  1.132699384876817e-14, -5.194893253415579e-16,  2.153474268904923e-17, -8.139511441213536e-19,  4.885297871012346e-07, -1.859362906046581e-07,
  3.741664309434983e-08, -5.109096835209184e-09,  5.282189419323791e-10, -4.398103714799245e-11,  3.068061785190578e-12, -1.843054602340841e-13,  9.728652494888336e-15,
 -4.582646677121273e-16,  1.949962636583454e-17, -7.560643926495360e-19,  3.368832628267573e-07, -1.315032173642016e-07,  2.720045141524499e-08, -3.818025915265693e-09,
  4.056411074556913e-10, -3.469091148913159e-11,  2.484302011439660e-12, -1.531193169842898e-13,  8.288148137982349e-15, -4.001279494890635e-16,  1.744037120459294e-17,
 -6.922866129686274e-19,  2.349121196959295e-07, -9.381333148502442e-08,  1.989476898325380e-08, -2.863519155283212e-09,  3.118729379811154e-10, -2.733017330847096e-11,
  2.004549922592293e-12, -1.264782858428187e-13,  7.004929862896578e-15, -3.458552515625449e-16,  1.540965303772885e-17, -6.249407771276433e-19,  1.655598804778981e-07,
 -6.747815493615668e-08,  1.463457646170950e-08, -2.154572881497756e-09,  2.399703239453364e-10, -2.149722844363257e-11,  1.611155137303714e-12, -1.038315590536605e-13,
  5.871120889768130e-15, -2.958200664064381e-16,  1.344488372710652e-17, -5.559440595804139e-19,  1.177808076776925e-07, -4.887698445717839e-08,  1.081391646611904e-08,
 -1.624466055967930e-09,  1.845746937688054e-10, -1.686268201919505e-11,  1.288412516212160e-12, -8.461676729952953e-14,  4.874067607847228e-15, -2.500784569855422e-16,
  1.156965765267523e-17, -4.867759360183611e-19,  8.437211427137743e-08, -3.556698262250906e-08,  8.007850812586317e-09, -1.224394553065697e-09,  1.415780811080294e-10,
 -1.315979088254197e-11,  1.022684835341799e-12, -6.829145573239932e-14,  3.998349158438056e-15, -2.084495879586132e-16,  9.795772821553161e-18, -4.184878388954900e-19,
  6.059659423653488e-08, -2.588999891769191e-08,  5.917365641754810e-09, -9.186422461408885e-10,  1.078408094752202e-10, -1.017425902843675e-11,  8.023231781699523e-13,
 -5.435100394715346e-14,  3.227253936565709e-15, -1.705855008968591e-16,  8.125440296762329e-18, -3.517405362078716e-19,  4.330454313509341e-08, -1.871065312161136e-08,
  4.330688807626698e-09, -6.809658178046412e-10,  8.096060530377715e-11, -7.734414311612612e-12,  6.174686527011356e-13, -4.233646802356294e-14,  2.543782103105922e-15,
 -1.360274423487259e-16,  6.553414183304647e-18, -2.868571344838579e-19,  3.037091342987701e-08, -1.324148340969972e-08,  3.096182353752007e-09, -4.919095442513708e-10,
  5.908746723897017e-11, -5.702293073127051e-12,  4.597940252361044e-13, -3.183535891764462e-14,  1.931257169390111e-15, -1.042484916219411e-16,  5.068883955723112e-18,
 -2.238823874967156e-19,  2.033138923809261e-08, -8.925521942788309e-09,  2.103295992510072e-09, -3.368149427734917e-10,  4.077681865556909e-11, -3.965825115106410e-12,
  3.222236535700748e-13, -2.247779000921064e-14,  1.373636250755163e-15, -7.468387121549232e-17,  3.657065337228763e-18, -1.626422646782394e-19,  1.214394328345315e-08,
 -5.356591362239859e-09,  1.269085598521955e-09, -2.043418587249842e-10,  2.487376291175197e-11, -2.432162980886722e-12,  1.986593928138619e-13, -1.393016944541954e-14,
  8.556239727410175e-16, -4.675234893701602e-17,  2.300551274640198e-18, -1.028031983774554e-19,  5.035492283963841e-09, -2.226971905102865e-09,  5.291935654261656e-10,
 -8.546751575690194e-11,  1.043513862904829e-11, -1.023399592263298e-12,  8.383710883968568e-14, -5.895698461651189e-15,  3.631531640905738e-16, -1.989823305795168e-17,
  9.818009090123122e-19, -4.398976015938160e-20,  5.907573904710849e-02, -1.448204606441873e-04,  3.686743138542918e-07, -9.678642061420955e-10,  2.599551789311824e-12,
 -7.091649866991860e-15,  1.953330301298688e-17, -5.408650081727537e-20,  1.500841737857987e-22, -4.165255966869458e-25,  1.154588642849780e-27, -3.194197925193194e-30,
  5.750455573683443e-02, -1.837109161680372e-04,  6.883671053956343e-07, -2.661439696880971e-09,  1.015770864146512e-11, -3.792445223240909e-14,  1.386157168205839e-16,
 -4.973175581653533e-19,  1.755858911235193e-21, -6.113383398680742e-24,  2.102416270464366e-26, -7.150900363732013e-29,  5.449007983226018e-02, -2.550409774499506e-04,
  1.364985702804363e-06, -6.944962328975003e-09,  3.341960377088885e-11, -1.539164942010894e-13,  6.846074301160308e-16, -2.958804957560008e-18,  1.247894588191858e-20,
 -5.152549829234491e-23,  2.088026314922309e-25, -8.321152949640721e-28,  5.027045510085057e-02, -3.472277463618727e-04,  2.448649917952360e-06, -1.550018554403476e-08,
  9.074440702615681e-11, -5.013436775536690e-13,  2.645542262279817e-15, -1.344122254941803e-17,  6.613174403355486e-20, -3.164553841784082e-22,  1.477785661647295e-24,
 -6.752526717652743e-27,  4.516225488234055e-02, -4.458560497918945e-04,  3.963944360119705e-06, -3.051685380436248e-08,  2.134445045545897e-10, -1.390271988185255e-12,
  8.559429634256255e-15, -5.031246107266995e-17,  2.843915266893434e-19, -1.554200130245281e-21,  8.246225424385051e-24, -4.261735500352493e-26,  3.952049822143318e-02,
 -5.363887697524915e-04,  5.873568291132463e-06, -5.419883607144987e-08,  4.467457796975976e-10, -3.386496159500487e-12,  2.403102937348113e-14, -1.615505006059403e-16,
  1.037659568966468e-18, -6.408656426600584e-21,  3.824445173982766e-23, -2.213745979004148e-25,  3.369762366879275e-02, -6.066564294211576e-04,  8.059334587905107e-06,
 -8.808659405719682e-08,  8.462791458884530e-10, -7.390346131016324e-12,  5.987586096629080e-14, -4.562645016923485e-16,  3.302038788605771e-18, -2.286058801336504e-20,
  1.522467404041255e-22, -9.796204101398139e-25,  2.800799606446770e-02, -6.486109713443785e-04,  1.032885976437828e-05, -1.323481241266504e-07,  1.468440494820556e-09,
 -1.464998902265873e-11,  1.344695510228758e-13, -1.153068111459360e-15,  9.337671492411929e-18, -7.198965970952579e-20,  5.316629318959322e-22, -3.779553153925974e-24,
  2.270264870828499e-02, -6.590692262772442e-04,  1.244650735756986e-05, -1.852724208296800e-07,  2.355256199178883e-09, -2.665299993603863e-11,  2.753412892989972e-13,
 -2.640524139239722e-15,  2.378802435567848e-17, -2.030959160350525e-19,  1.654465090637900e-21, -1.292781724204509e-23,  1.795638409443541e-02, -6.394501610154848e-04,
  1.417863765525669e-05, -2.431842473013440e-07,  3.517225460113918e-09, -4.486492827579979e-11,  5.186432221110428e-13, -5.532770468694864e-15,  5.516909785047829e-17,
 -5.191088740657364e-19,  4.643052829392169e-21, -3.970174045806665e-23,  1.386678688023928e-02, -5.947410281328976e-04,  1.533910771837719e-05, -3.008785682125762e-07,
  4.919662723239264e-09, -7.033802717553311e-11,  9.052154615521689e-13, -1.069065479786411e-14,  1.174601040085789e-16, -1.212889351798599e-18,  1.186279543419690e-20,
 -1.105689852523430e-22,  1.046273010053242e-02, -5.320549409928305e-04,  1.582221219134871e-05, -3.524965112939420e-07,  6.478104297883072e-09, -1.032793018580980e-10,
  1.472793226683796e-12, -1.917304083249965e-14,  2.311779872363662e-16, -2.609618822261688e-18,  2.780825044465059e-20, -2.815372949268278e-22,  7.718897000841596e-03,
 -4.591526153876606e-04,  1.561558922170499e-05, -3.926104175310710e-07,  8.065991189028461e-09, -1.427135440933791e-10,  2.245363705955222e-12, -3.209253666328965e-14,
  4.230705927317183e-16, -5.202566320746260e-18,  6.019964365729679e-20, -6.599077267629588e-22,  5.572714167975514e-03, -3.832183511295500e-04,  1.479246085904322e-05,
 -4.172188108895768e-07,  9.533889823543788e-09, -1.863757432598014e-10,  3.222247624469331e-12, -5.037764303860332e-14,  7.236044317231718e-16, -9.662023405656635e-18,
  1.210272956810465e-19, -1.432247619274152e-21,  3.940682949040641e-03, -3.100501552871673e-04,  1.348832892729576e-05, -4.243945676178426e-07,  1.073558709383814e-08,
 -2.309097204108954e-10,  4.370395559392695e-12, -7.448252120678421e-14,  1.161899821404421e-15, -1.679488859635268e-17,  2.270802405682587e-19, -2.893106571757335e-21,
  2.732078157843857e-03, -2.436929946477332e-04,  1.187027477312943e-05, -4.144541474944248e-07,  1.155412587331160e-08, -2.723546645751021e-10,  5.623055016024169e-12,
 -1.041205326446400e-13,  1.758636957992946e-15, -2.743977874658561e-17,  3.993835235126089e-19, -5.463872070026793e-21,  1.859033295422295e-03, -1.864459137971393e-04,
  1.010702235110130e-05, -3.896661210926659e-07,  1.192107189617390e-08, -3.068063420650725e-10,  6.886312398359722e-12, -1.381104185772237e-13,  2.518438891208476e-15,
 -4.230075234437708e-17,  6.610659142330446e-19, -9.687526403504262e-21,  1.242913562590142e-03, -1.391222432415732e-04,  8.345710152157429e-06, -3.536369878967414e-07,
  1.182474409442466e-08, -3.310835429132636e-10,  8.052604047092234e-12, -1.744038877142755e-13,  3.423897369914688e-15, -6.174724589916760e-17,  1.033547554316268e-18,
 -1.618587503717187e-20,  8.174726268718918e-04, -1.014342318504383e-04,  6.698160608699647e-06, -3.105679451030044e-07,  1.130665918245998e-08, -3.432333692106687e-10,
  9.018065045307110e-12, -2.103141808643077e-13,  4.433366523996337e-15, -8.562920402716975e-17,  1.531514240345390e-18, -2.557309799821903e-20,  5.295829598441337e-04,
 -7.239567834591088e-05,  5.236518176201846e-06, -2.645649132044504e-07,  1.044865903967386e-08, -3.427657960058000e-10,  9.699414374607215e-12, -2.429043960997422e-13,
  5.483798751839540e-15, -1.131641726128746e-16,  2.157737573434866e-18, -3.833265862602333e-20,  3.383792720375366e-04, -5.067221676488704e-05,  3.996171942839092e-06,
 -2.191264364991124e-07,  9.355098684378238e-09, -3.305924317898217e-10,  1.004635679413575e-11, -2.694453353236938e-13,  6.498488416523439e-15, -1.429412493634216e-16,
  2.899149606876061e-18, -5.467983469290762e-20,  2.135465626283483e-04, -3.484530875254722e-05,  2.983074873612282e-06, -1.768600524879639e-07,  8.134751391366057e-09,
 -3.087239078599582e-10,  1.004699886826679e-11, -2.878335948887772e-13,  7.398135639608427e-15, -1.730573041132739e-16,  3.725486427587181e-18, -7.444337893090013e-20,
  1.333027453916830e-04, -2.358451575713742e-05,  2.182711477331996e-06, -1.394132912165465e-07,  6.886050273792546e-09, -2.798300163550746e-10,  9.725864608847431e-12,
 -2.968767762441664e-13,  8.112685148461777e-15, -2.013637124800109e-16,  4.591245682856755e-18, -9.700148546249166e-20,  8.243446547824042e-05, -1.574036574885748e-05,
  1.568658499159192e-06, -1.075650799143499e-07,  5.687593049017238e-09, -2.467775405938328e-10,  9.135984819733087e-12, -2.963952158631310e-13,  8.591258817722092e-15,
 -2.257704566318214e-16,  5.440828672291598e-18, -1.212970684304100e-19,  5.058157805610719e-05, -1.037796899230922e-05,  1.109544971193375e-06, -8.140930298158103e-08,
  4.594159413323191e-09, -2.122388735521949e-10,  8.347669378961525e-12, -2.871411559459061e-13,  8.808171392813957e-15, -2.445398239889778e-16,  6.215862492541692e-18,
 -1.459378636422638e-19,  3.084629482661555e-05, -6.772236924666151e-06,  7.739784883440304e-07, -6.056855633614098e-08,  3.637278921133195e-09, -1.784250472982621e-10,
  7.436776519242936e-12, -2.705791582838795e-13,  8.764188077888498e-15, -2.565080558580997e-16,  6.863126513816404e-18, -1.693644945724411e-19,  1.872723963556960e-05,
 -4.382220716196593e-06,  5.335344848767642e-07, -4.439343493969471e-08,  2.828800727610943e-09, -1.469557509155796e-10,  6.474737483685266e-12, -2.485946198756320e-13,
  8.483412043089388e-15, -2.611961914593935e-16,  7.341417024608679e-18, -1.900520366644045e-19,  1.133845818077416e-05, -2.817246724456400e-06,  3.641886795357264e-07,
 -3.212251456302813e-08,  2.165879285927170e-09, -1.188476884302684e-10,  5.521639686615276e-12, -2.231983233727806e-13,  8.007101058158579e-15, -2.588017225769480e-16,
  7.626062782708174e-18, -2.067033776258559e-19,  6.858121270981408e-06, -1.802826168415681e-06,  2.466598059629971e-07, -2.299494460598180e-08,  1.636104787077942e-09,
 -9.458590050962621e-11,  4.622689715922746e-12, -1.962793268331248e-13,  7.386111016118002e-15, -2.500902881735566e-16,  7.710480405991076e-18, -2.183973096951235e-19,
  4.151411863544127e-06, -1.150564581165703e-06,  1.660925383026347e-07, -1.631885095869628e-08,  1.221961838273211e-09, -7.423940865211109e-11,  3.807629656732204e-12,
 -1.694349796653632e-13,  6.673562419491345e-15, -2.362241990882678e-16,  7.604888630989744e-18, -2.246680959193052e-19,  2.519392210601296e-06, -7.337049754027445e-07,
  1.114149697711743e-07, -1.150454399872071e-08,  9.042344535907029e-10, -5.758848771999026e-11,  3.092272083417332e-12, -1.438838452171811e-13,  5.918882783251045e-15,
 -2.185695688384226e-16,  7.332869995873911e-18, -2.255109304903719e-19,  1.535567880602520e-06, -4.683813880728804e-07,  7.459766281187609e-08, -8.073112701213588e-09,
  6.643032120179885e-10, -4.424108128889325e-11,  2.481226693947866e-12, -1.204503187793375e-13,  5.163804064201567e-15, -1.985180911413864e-16,  6.926758830128669e-18,
 -2.213237105800299e-19,  9.415975383335202e-07, -2.998758881608716e-07,  4.994814339225753e-08, -5.649991529204728e-09,  4.854784920558834e-10, -3.372636575963224e-11,
  1.971018161800460e-12, -9.960072696149263e-14,  4.440370279404471e-15, -1.773474384341496e-16,  6.422837821084786e-18, -2.128059711888346e-19,  5.818488608601174e-07,
 -1.928925779297486e-07,  3.350571270652501e-08, -3.950925587333494e-09,  3.535994380832397e-10, -2.556188960925873e-11,  1.553027130378286e-12, -8.150886454354390e-14,
  3.770643205575468e-15, -1.561306533095321e-16,  5.857116981312870e-18, -2.008393473347424e-19,  3.629047773477988e-07, -1.248677760989471e-07,  2.255662564827646e-08,
 -2.765400480536680e-09,  2.571361491164407e-10, -1.929622430627736e-11,  1.215932185519529e-12, -6.613197579737667e-14,  3.167612196666129e-15, -1.356934122081076e-16,
  5.262158928442023e-18, -1.863714349163651e-19,  2.287969854954957e-07, -8.147433269598660e-08,  1.526436337652320e-08, -1.940572997593941e-09,  1.869973812108320e-10,
 -1.453185677131222e-11,  9.475339484560369e-13, -5.328356676937938e-14,  2.636789914660991e-15, -1.166105160548634e-16,  4.665105051169901e-18, -1.703186762280988e-19,
  1.459990269249155e-07, -5.365727660004655e-08,  1.039802473037215e-08, -1.367231389336968e-09,  1.361947823001196e-10, -1.093382435353074e-11,  7.359811267138123e-13,
 -4.269510445040895e-14,  2.178054529325589e-15, -9.922962294103663e-17,  4.086816180294002e-18, -1.534964218291750e-19,  9.439813444417711e-08, -3.570904879546106e-08,
  7.138541293705208e-09, -9.683230342047599e-10,  9.946424362994750e-11, -8.229133731912264e-12,  5.704943436867918e-13, -3.406338247564611e-14,  1.787424369162967e-15,
 -8.371023305144213e-17,  3.541896282374833e-18, -1.365776207994863e-19,  6.189194574299165e-08, -2.403499022777769e-08,  4.943577933016369e-09, -6.900128676898594e-10,
  7.290363037125082e-11, -6.200975817650938e-12,  4.417110088739776e-13, -2.708361990421232e-14,  1.458579802303912e-15, -7.006799208344289e-17,  3.039313566299892e-18,
 -1.200767975344804e-19,  4.116529095546910e-08, -1.636904558886179e-08,  3.455057997139932e-09, -4.949552578339109e-10,  5.365629432614591e-11, -4.680599264496539e-12,
  3.417707399372508e-13, -2.147023772978929e-14,  1.184053761970847e-15, -5.821728829074047e-17,  2.583346904710679e-18, -1.043533744443255e-19,  2.777036089645515e-08,
 -1.127898708419704e-08,  2.436770205570065e-09, -3.573658339769202e-10,  3.965041786896524e-11, -3.538684995309732e-12,  2.642410696413745e-13, -1.696802510574690e-14,
  9.560870153299058e-16, -4.800799652161374e-17,  2.174637987346273e-18, -8.962769534987778e-20,  1.898301852852440e-08, -7.855771554524240e-09,  1.732734971747339e-09,
 -2.594859767055347e-10,  2.939307053941549e-11, -2.677273654724188e-12,  2.039582027547132e-13, -1.335643801080337e-14,  7.671879399093601e-16, -3.925457144132279e-17,
  1.811196129735967e-18, -7.600370998186896e-20,  1.312028175354355e-08, -5.519028915261577e-09,  1.239647920374276e-09, -1.890864994491007e-10,  2.181237085835370e-11,
 -2.022745825894848e-12,  1.568338864814186e-13, -1.044940163146769e-14,  6.104556613045588e-16, -3.175733501251924e-17,  1.489265859575802e-18, -6.349357968260476e-20,
  9.131670248201809e-09, -3.895351275798547e-09,  8.887395116171470e-10, -1.377257981618422e-10,  1.613921016423509e-11, -1.520004615696301e-12,  1.196600441470641e-13,
 -8.092460127231586e-15,  4.797279068959240e-16, -2.531677595169704e-17,  1.204018080502287e-18, -5.204096063179976e-20,  6.353317962634368e-09, -2.742031586687452e-09,
  6.338660871198180e-10, -9.954418497395478e-11,  1.182004476583657e-11, -1.127810702864886e-12,  8.992846847805502e-14, -6.158587045372919e-15,  3.696080237313660e-16,
 -1.974212307554399e-17,  9.500609514324867e-19, -4.154109061954172e-20,  4.358999969720728e-09, -1.899099698056746e-09,  4.436897550450422e-10, -7.043275407091217e-11,
  8.453257205068729e-12, -8.151225240843131e-13,  6.567313100976531e-14, -4.543515194073698e-15,  2.754146958918826e-16, -1.485554121151998e-17,  7.217879155459342e-19,
 -3.185689301946961e-20,  2.868989957551013e-09, -1.258939591285946e-09,  2.965213396558552e-10, -4.745999026624798e-11,  5.742905566006150e-12, -5.582604543144697e-13,
  4.533663329620356e-14, -3.161097112333580e-15,  1.930866666838026e-16, -1.049319208900542e-17,  5.135913476805948e-19, -2.283110865822405e-20,  1.693494087477947e-09,
 -7.468098548117335e-10,  1.768870653951784e-10, -2.847369684962155e-11,  3.465051857852352e-12, -3.387224046763735e-13,  2.765954229930849e-14, -1.939004028141197e-15,
  1.190675832161158e-16, -6.504354263205015e-18,  3.199813720565856e-19, -1.429531082869494e-20,  6.975841210197650e-10, -3.084722488355245e-10,  7.329173615399118e-11,
 -1.183529548660637e-11,  1.444819833469304e-12, -1.416767276557368e-13,  1.160454020315847e-14, -8.159544759794227e-16,  5.025279479945694e-17, -2.753121280603361e-18,
  1.358236608520503e-19, -6.084791116233629e-21,  5.850228342009535e-02, -1.419168271535000e-04,  3.573049009883456e-07, -9.273810753786721e-10,  2.462286863628259e-12,
 -6.640494497886022e-15,  1.808392645560748e-17, -4.951508020837002e-20,  1.358877863762315e-22, -3.730327821843583e-25,  1.022923259945161e-27, -2.799849378615887e-30,
  5.678052750244235e-02, -1.783290220274371e-04,  6.573805117701441e-07, -2.504808138862489e-09,  9.431391423835809e-12, -3.475862224389870e-14,  1.254454868524770e-16,
 -4.444950320202732e-19,  1.550186132103671e-21, -5.332086826091283e-24,  1.811794030941292e-26, -6.089388536482536e-29,  5.349124040838690e-02, -2.444455881767802e-04,
  1.284755668657361e-06, -6.434009957014748e-09,  3.049909523817895e-11, -1.384366085123427e-13,  6.070836939388836e-16, -2.587614366913586e-18,  1.076594553344548e-20,
 -4.386176093752900e-23,  1.754183310522167e-25, -6.900381843150621e-28,  4.891957836862743e-02, -3.283586136932811e-04,  2.271039102879126e-06, -1.412516402200322e-08,
  8.132317156619276e-11, -4.421379142721632e-13,  2.297180488518060e-15, -1.149643308428859e-17,  5.573546879940362e-20, -2.628823221207597e-22,  1.210318838867015e-24,
 -5.453721463759348e-27,  4.344001377716406e-02, -4.155532899913012e-04,  3.617350096832254e-06, -2.731348486705155e-08,  1.875843225715611e-10, -1.200771814586693e-12,
  7.270110285701704e-15, -4.204698437232563e-17,  2.339519678495886e-19, -1.259002626394620e-21,  6.579939182058189e-24, -3.350588606767486e-26,  3.746496613484580e-02,
 -4.918852039565942e-04,  5.263932227227175e-06, -4.756287960435646e-08,  3.844354311617611e-10, -2.860483320536934e-12,  1.993980278372462e-14, -1.317595815734353e-16,
  8.322879372506251e-19, -5.057273399795423e-21,  2.970362208862884e-23, -1.692785707561117e-25,  3.139356349800615e-02, -5.461904680878388e-04,  7.078902172736656e-06,
 -7.565464314384961e-08,  7.118662501819900e-10, -6.095410577566440e-12,  4.846396236430100e-14, -3.626710266862159e-16,  2.579025437070771e-18, -1.755289787648283e-20,
  1.149687537357792e-22, -7.278149858198516e-25,  2.556929137188459e-02, -5.719545682638301e-04,  8.872522973598740e-06, -1.110321251836138e-07,  1.205263098378619e-09,
 -1.177864125167244e-11,  1.060047938677242e-13, -8.919288121230086e-16,  7.091879475397644e-18, -5.371225197910014e-20,  3.898720992490649e-22, -2.725130885204785e-24,
  2.025228901609915e-02, -5.677879126027263e-04,  1.043284982429780e-05, -1.515174290716854e-07,  1.882706862068812e-09, -2.085233285009423e-11,  2.110494929917203e-13,
 -1.984553583058302e-15,  1.754230837483366e-17, -1.470407693730872e-19,  1.176581246940123e-21, -9.034658833154540e-24,  1.560822558792966e-02, -5.368012667199704e-04,
  1.157052449118133e-05, -1.934600097929218e-07,  2.732815077964255e-09, -3.409307627123993e-11,  3.858690253508825e-13, -4.033681412621249e-15,  3.944182522239569e-17,
 -3.641589799204303e-19,  3.197734337495318e-21, -2.685734274821687e-23,  1.171213899241247e-02, -4.852319101646972e-04,  1.215799229720206e-05, -2.323322678912511e-07,
  3.707942581076585e-09, -5.181747280982113e-11,  6.525367475842330e-13, -7.547716941204123e-15,  8.128103363145579e-17, -8.231721218883439e-19,  7.900866705142642e-21,
 -7.230360101520723e-23,  8.563171298255554e-03, -4.207803874266243e-04,  1.215174400035948e-05, -2.636195371214874e-07,  4.726482205987101e-09, -7.361815771224771e-11,
  1.026793324352017e-12, -1.308591378519810e-14,  1.545865557589978e-16, -1.710836486563308e-18,  1.788419227388020e-20, -1.777160632319212e-22,  6.105131155423538e-03,
 -3.510785661855519e-04,  1.159311978035284e-05, -2.837408325932718e-07,  5.685049969233993e-09, -9.823583269260905e-11,  1.511162976442005e-12, -2.113766899305359e-14,
  2.729243550830373e-16, -3.289466799872596e-18,  3.732900048584467e-20, -4.015311514425505e-22,  4.248130720805667e-03, -2.825701446132710e-04,  1.059048586995157e-05,
 -2.907312127678278e-07,  6.477729268182340e-09, -1.236429464812497e-10,  2.089566577127979e-12, -3.196415827457876e-14,  4.495799559085046e-16, -5.882492166282390e-18,
  7.224969559243095e-20, -8.388329273112957e-22,  2.887744012801266e-03, -2.199115766538330e-04,  9.290500676963767e-06, -2.845118033768077e-07,  7.016914021194668e-09,
 -1.473465750346661e-10,  2.725711473946631e-12, -4.544478088823624e-14,  6.941000183657853e-16, -9.830238671343643e-18,  1.303092356406731e-19, -1.628616186284483e-21,
  1.919677563968591e-03, -1.658527078962746e-04,  7.847562337079235e-06, -2.667199262558141e-07,  7.249779456454331e-09, -1.668397653181754e-10,  3.366571318285354e-12,
 -6.098272801503888e-14,  1.008446872893108e-15, -1.541607214739296e-17,  2.199764871461272e-19, -2.952103808217026e-21,  1.249376480496116e-03, -1.214651018190573e-04,
  6.398813278925041e-06, -2.402055852612418e-07,  7.166122780959934e-09, -1.800766360620246e-10,  3.950609557817911e-12, -7.751478205879921e-14,  1.383939643428237e-15,
 -2.277556848296764e-17,  3.489613356091845e-19, -5.016600763084091e-21,  7.970336168661966e-04, -8.655725425060194e-05,  5.048688176796257e-06, -2.083751877064431e-07,
  6.796357723406535e-09, -1.858397383254743e-10,  4.418735570961386e-12, -9.364065319829099e-14,  1.800179557027261e-15, -3.181288055039398e-17,  5.221312067980568e-19,
 -8.022336432872373e-21,  4.990424027484184e-04, -6.013499475641312e-05,  3.863494457323183e-06, -1.745656760638922e-07,  6.201479047118633e-09, -1.839088151176480e-10,
  4.725028643578034e-12, -1.078477479601155e-13,  2.226686508494068e-15, -4.215291908278388e-17,  7.393946762174369e-19, -1.211538908276482e-20,  3.070940474625735e-04,
 -4.080962701234083e-05,  2.874001238751692e-06, -1.415795033428904e-07,  5.458734919970503e-09, -1.750077813970757e-10,  4.844400274034238e-12, -1.187746228118523e-13,
  2.627148380430808e-15, -5.315161965721351e-17,  9.942007321215687e-19, -1.733634700401499e-20,  1.859989056188437e-04, -2.710491895857671e-05,  2.082879265553586e-06,
 -1.114354208474017e-07,  4.647118765589774e-09, -1.605726383184028e-10,  4.775465637662842e-12, -1.254439783521008e-13,  2.965327567451980e-15, -6.397047333198239e-17,
  1.273240922885171e-18, -2.357899073827914e-20,  1.110509164048373e-04, -1.765335987216536e-05,  1.473899937826053e-06, -8.532220597850571e-08,  3.835865050593744e-09,
 -1.424240510330682e-10,  4.538444203849143e-12, -1.274079601059192e-13,  3.211130140174180e-15, -7.370148006476786e-17,  1.557642864462488e-18, -3.057337169988294e-20,
  6.546504743576118e-05, -1.129675240421408e-05,  1.020590323000738e-06, -6.370004998651974e-08,  3.077553698923992e-09, -1.224357064058301e-10,  4.169286401996153e-12,
 -1.247782418215729e-13,  3.345326442852272e-15, -8.151266320514120e-17,  1.825504897414324e-18, -3.790231961044421e-20,  3.816886136144789e-05, -7.116930998440618e-06,
  6.930557215032579e-07, -4.648069305296984e-08,  2.405876650494388e-09, -1.022690191374962e-10,  3.711987214718744e-12, -1.181480001904568e-13,  3.361889908737116e-15,
 -8.677844103775676e-17,  2.055209965752616e-18, -4.505115370191034e-20,  2.204908295329035e-05, -4.423086602511216e-06,  4.625683598248872e-07, -3.322567229538264e-08,
  1.837049172157270e-09, -8.321026562350908e-11,  3.211080551500529e-12, -1.084397606953854e-13,  3.267670073154313e-15, -8.916513647849159e-17,  2.228729326642371e-18,
 -5.148056984675440e-20,  1.264308580937316e-05, -2.717364230966843e-06,  3.041155217304790e-07, -2.332147492681595e-08,  1.373398911381771e-09, -6.611233603620512e-11,
  2.705781157222504e-12, -9.672490209592719e-14,  3.079840947194389e-15, -8.865650704392517e-17,  2.334159271431654e-18, -5.670599633437372e-20,  7.209816788312965e-06,
 -1.653756244212488e-06,  1.973907454488026e-07, -1.611137982961631e-08,  1.007734147309007e-09, -5.141964419923501e-11,  2.226468237018677e-12, -8.405708690693048e-14,
  2.822034416523827e-15, -8.552132189768228e-17,  2.366994021787160e-18, -6.036545470136386e-20,  4.096903560721635e-06, -9.991297879513525e-07,  1.267703255578468e-07,
 -1.098040159018521e-08,  7.274614030124060e-10, -3.924439755212402e-11,  1.793486300924428e-12, -7.134807258552972e-14,  2.520188365998418e-15, -8.023872635795929e-17,
  2.330011075376085e-18, -6.226216025364088e-20,  2.324447277884111e-06, -6.005321237425984e-07,  8.074078891425988e-08, -7.399910788088017e-09,  5.178758385885149e-10,
 -2.946331729051346e-11,  1.417757760633331e-12, -5.929721292210809e-14,  2.198959910157097e-15, -7.340385798949532e-17,  2.231994593130623e-18, -6.237575497984661e-20,
  1.319481914696807e-06, -3.598816408898494e-07,  5.111365209955609e-08, -4.942752430181011e-09,  3.644379683569667e-10, -2.181145927638663e-11,  1.102505397013526e-12,
 -4.837130832318517e-14,  1.879208665522414e-15, -6.563553830524727e-17,  2.085745742893320e-18, -6.084426169769695e-20,  7.509368930209994e-07, -2.154966707636039e-07,
  3.223525986393173e-08, -3.279821689759100e-09,  2.541115855365818e-10, -1.595944300206156e-11,  8.454169920821884e-13, -3.882241148393265e-14,  1.576688644340425e-15,
 -5.750196193763149e-17,  1.905888858773956e-18, -5.792502072904776e-20,  4.293563810519694e-07, -1.292182739477247e-07,  2.029783203106758e-08, -2.167023897465055e-09,
  1.759680387564035e-10, -1.156894472433247e-11,  6.407512869389327e-13, -3.072809540572471e-14,  1.301804402763237e-15, -4.947226508574520e-17,  1.706903005892388e-18,
 -5.394567603450855e-20,  2.471370943972064e-07, -7.775772896660220e-08,  1.278941867168196e-08, -1.428839471436305e-09,  1.212928918299611e-10, -8.327247978370954e-12,
  4.810901120891943e-13, -2.404008884816339e-14,  1.060131455908393e-15, -4.189445596492488e-17,  1.501650017175252e-18, -4.925576040797689e-20,  1.434949376668539e-07,
 -4.705565516056511e-08,  8.081055360063049e-09, -9.422269150068579e-10,  8.340308409129184e-11, -5.964810580221459e-12,  3.586219925797924e-13, -1.863098407339782e-14,
  8.533649133269162e-16, -3.499509033095062e-17,  1.300497215885008e-18, -4.418662099846002e-20,  8.420848295099037e-08, -2.869505610871048e-08,  5.130950416693611e-09,
 -6.227103228699891e-10,  5.733037461331283e-11, -4.260794450620773e-12,  2.659683593206538e-13, -1.433306776943608e-14,  6.804068935525211e-16, -2.889370581275222e-17,
  1.110993502530087e-18, -3.902371335978568e-20,  5.003690109586729e-08, -1.766680167462810e-08,  3.280075640094696e-09, -4.132628495161707e-10,  3.947272009069266e-11,
 -3.041135897655899e-12,  1.966320207622187e-13, -1.096702232955964e-14,  5.383891353945691e-16, -2.362493348466083e-17,  9.379732180254881e-19, -3.399186676530102e-20,
  3.015555182900866e-08, -1.100077279657607e-08,  2.114939304779214e-09, -2.759010836885506e-10,  2.727071770277989e-11, -2.172737801412573e-12,  1.451708484673424e-13,
 -8.360783491379214e-15,  4.235173298876070e-16, -1.916252611481692e-17,  7.839326100635635e-19, -2.925169331944045e-20,  1.845948745452181e-08, -6.938504880074291e-09,
  1.377570677837776e-09, -1.855857417381519e-10,  1.893476127914235e-11, -1.556243596182544e-12,  1.071942940492814e-13, -6.360216693257526e-15,  3.316971940905864e-16,
 -1.544142504958067e-17,  6.495347062593541e-19, -2.490407484893701e-20,  1.149084631929871e-08, -4.438320406213437e-09,  9.075563122832458e-10, -1.259342145242590e-10,
  1.322904387836869e-11, -1.118879092795499e-12,  7.926114939771033e-14, -4.833748235090069e-15,  2.589514959099572e-16, -1.237580646857262e-17,  5.341316614905092e-19,
 -2.099944217262582e-20,  7.279343907393288e-09, -2.881612656603402e-09,  6.052556290939755e-10, -8.628065170302783e-11,  9.308118320182707e-12, -8.081234261609113e-13,
  5.873423744372937e-14, -3.672990575637985e-15,  2.016633715664356e-16, -9.872465491875607e-18,  4.362333294128402e-19, -1.754901426111835e-20,  4.693768947491847e-09,
 -1.899427509369382e-09,  4.087164205862312e-10, -5.969883707468281e-11,  6.597334242046107e-12, -5.864934620360261e-13,  4.362730611484549e-14, -2.791023843922193e-15,
  1.566899813319076e-16, -7.839815749043596e-18,  3.538864092557940e-19, -1.453593103485475e-20,  3.078708436760114e-09, -1.270371926612492e-09,  2.793055749520571e-10,
 -4.169235706549509e-11,  4.707596347046922e-12, -4.274486516545034e-13,  3.246367185119909e-14, -2.119540832686234e-15,  1.213883758663786e-16, -6.193255462871958e-18,
  2.849550507902875e-19, -1.192501652674666e-20,  2.050373144731910e-09, -8.605597067920409e-10,  1.928132163749145e-10, -2.933655589761763e-11,  3.375774782230999e-12,
 -3.122861692167250e-13,  2.415536773831226e-14, -1.605646266146564e-15,  9.358793233151382e-17, -4.857797931463274e-18,  2.273104154224357e-19, -9.670584414250796e-21,
  1.381269226025371e-09, -5.882411855679651e-10,  1.339614179632016e-10, -2.072088209706066e-11,  2.423655891897027e-12, -2.278467571206941e-13,  1.790490231494821e-14,
 -1.208772502081744e-15,  7.153469596847525e-17, -3.768810923138410e-18,  1.789449217456212e-19, -7.722180231562573e-21,  9.346191083934990e-10, -4.029029909956497e-10,
  9.301603024269313e-11, -1.458818713032951e-11,  1.729955114595907e-12, -1.648509160452196e-13,  1.312811842506698e-14, -8.979409845686560e-16,  5.382462068977141e-17,
 -2.871558952484457e-18,  1.380291840260912e-19, -6.028446355827332e-21,  6.267512623453207e-10, -2.728498627248510e-10,  6.369142844192551e-11, -1.010174896685200e-11,
  1.211348945722879e-12, -1.167070418733318e-13,  9.395018528289318e-15, -6.494486862186555e-16,  3.933600305791304e-17, -2.120064991079311e-18,  1.029283756460620e-19,
 -4.539435207898489e-21,  4.052882916788835e-10, -1.777628134445875e-10,  4.184725482246649e-11, -6.694374825208906e-12,  8.096304689410618e-13, -7.866253497051406e-14,
  6.384987130699502e-15, -4.449716482345439e-16,  2.716656212780508e-17, -1.475645641848070e-18,  7.219187873314508e-20, -3.207735105731442e-21,  2.362998840125741e-10,
 -1.041797908872617e-10,  2.466883900517755e-11, -3.969843182993233e-12,  4.829659546241921e-13, -4.719862415161583e-14,  3.853104326825984e-15, -2.700391564023662e-16,
  1.657775728518953e-17, -9.053627151188585e-19,  4.452780229004448e-20, -1.988797608583495e-21,  9.666840190325026e-11, -4.274145012223491e-11,  1.015372849523971e-11,
 -1.639402050752334e-12,  2.001040058002293e-13, -1.961899273002782e-14,  1.606729680534315e-15, -1.129583091657889e-16,  6.955855955793925e-18, -3.810259561270911e-19,
  1.879508388345550e-20, -8.418894551965508e-22,  5.794026344133622e-02, -1.391022424378341e-04,  3.464084000158001e-07, -8.890238459396179e-10,  2.333707303642469e-12,
 -6.222638091742813e-15,  1.675641802179002e-17, -4.537387561649220e-20,  1.231663769890369e-22, -3.344754645555769e-25,  9.074345931489251e-28, -2.457586212556777e-30,
  5.607754269041401e-02, -1.731876951764125e-04,  6.282058055472447e-07, -2.359307807692462e-09,  8.765346016095306e-12, -3.189184790965890e-14,  1.136662197671156e-16,
 -3.978255616976615e-19,  1.370655383470182e-21, -4.658212713453794e-24,  1.564085970846027e-26, -5.195202724459585e-29,  5.253353660218015e-02, -2.344682849515050e-04,
  1.210386592813122e-06, -5.967406605349527e-09,  2.787038961944436e-11, -1.246985206566407e-13,  5.392255772565584e-16, -2.267071456685691e-18,  9.306236628281093e-21,
 -3.741630472849091e-23,  1.477021063164141e-25, -5.735823644858281e-28,  4.764143739295827e-02, -3.108468419575750e-04,  2.109061760797856e-06, -1.289184574878477e-08,
  7.300666834501820e-11, -3.906752663257585e-13,  1.998891127273552e-15, -9.855424399576114e-18,  4.708826613466725e-20, -2.189468782324722e-22,  9.939938233008146e-25,
 -4.417538901109605e-27,  4.183367209516639e-02, -3.878762790626099e-04,  3.306833514719765e-06, -2.449516455879374e-08,  1.652225509579041e-10, -1.039611116397859e-12,
  6.191137607436794e-15, -3.523765846671100e-17,  1.930305089321706e-19, -1.023078631949691e-21,  5.267714832114074e-24, -2.643371781638679e-26,  3.557817555205983e-02,
 -4.519563829419709e-04,  4.728276478569997e-06, -4.184479081678881e-08,  3.317273553577222e-10, -2.423350093284215e-12,  1.659758377869098e-14, -1.078238571614326e-16,
  6.699318207808047e-19, -4.005719651447540e-21,  2.316000541451971e-23, -1.299677421481125e-25,  2.931657594606581e-02, -4.930059168790984e-04,  6.235558310208380e-06,
 -6.518014385135681e-08,  6.008126816053811e-10, -5.045360821192004e-12,  3.937556353916359e-14, -2.894241776421098e-16,  2.022721054123235e-18, -1.353614295840272e-20,
  8.721096621673103e-23, -5.432699758077451e-25,  2.341543532354891e-02, -5.059931407418697e-04,  7.648494451767740e-06, -9.350231962072978e-08,  9.932338545572489e-10,
 -9.510254652791306e-12,  8.393743130014173e-14, -6.931369542883321e-16,  5.412261855115681e-18, -4.027623850001059e-20,  2.873788139339121e-22, -1.975389763642059e-24,
  1.813723095285329e-02, -4.911158512431022e-04,  8.782460462085306e-06, -1.244730953104378e-07,  1.512119314405780e-09, -1.639510671365259e-11,  1.626056804898609e-13,
 -1.499536473520137e-15,  1.300816099805822e-17, -1.070658592069374e-19,  8.416580693967590e-22, -6.352105840128739e-24,  1.363243092796983e-02, -4.528285586931509e-04,
  9.490384032468409e-06, -1.547226691581201e-07,  2.135102454132240e-09, -2.605619979027686e-11,  2.887885187247107e-13, -2.958752377341674e-15,  2.837539982217462e-17,
 -2.571106204986808e-19,  2.216905401938644e-21, -1.829150351985704e-23,  9.949408536998479e-03, -3.981849309463623e-04,  9.694340027210572e-06, -1.805119711912197e-07,
  2.812493979408014e-09, -3.842405758548396e-11,  4.735608593484174e-13, -5.365601238565266e-15,  5.664350897555639e-17, -5.627168502072897e-19,  5.300992616055215e-21,
 -4.763692014052007e-23,  7.056120255738182e-03, -3.350383506916271e-04,  9.397483358146714e-06, -1.985509928703027e-07,  3.473534845295719e-09, -5.286532704904149e-11,
  7.212857641466966e-13, -9.000497375805944e-15,  1.041861981599950e-16, -1.130614392867002e-18,  1.159574150301802e-20, -1.131117083006985e-22,  4.866743687929259e-03,
 -2.705442817238976e-04,  8.675032132020659e-06, -2.067119915743430e-07,  4.039743220997512e-09, -6.818319693275698e-11,  1.025646059053084e-12, -1.404200533296116e-14,
  1.776013639040309e-16, -2.098270799870585e-18,  2.335492934938600e-20, -2.465384172323860e-22,  3.267462601315291e-03, -2.102110480861280e-04,  7.650029168128560e-06,
 -2.044229954347655e-07,  4.441510267213954e-09, -8.278501162020176e-11,  1.367739891124723e-12, -2.047319911560306e-14,  2.820042085634432e-16, -3.616113935086877e-18,
  4.355311584128803e-20, -4.961405676043676e-22,  2.137548704687398e-03, -1.575383897996407e-04,  6.463165564953842e-06, -1.926536424272009e-07,  4.632788877529680e-09,
 -9.498329891135093e-11,  1.717447141489432e-12, -2.801517884261411e-14,  4.189770524146625e-16, -5.814336353040160e-18,  7.557072233117605e-20, -9.265902960983887e-22,
  1.364039289875798e-03, -1.141305374553693e-04,  5.245566632904033e-06, -1.735487758480888e-07,  4.599524654630311e-09, -1.033435438583939e-10,  2.038185375563300e-12,
 -3.611938890542697e-14,  5.848117961713874e-16, -8.759438685695344e-18,  1.225446999809079e-19, -1.613306523421774e-21,  8.500704714471720e-04, -8.009885423278025e-05,
  4.100311844575636e-06, -1.498650297785672e-07,  4.359900171270083e-09, -1.069736556832558e-10,  2.293901958829790e-12, -4.403369942076177e-14,  7.697610357711649e-16,
 -1.241236444632722e-17,  1.864598458779301e-19, -2.629618400432572e-21,  5.180267509135400e-04, -5.457018270847043e-05,  3.094465961860806e-06, -1.243923994152464e-07,
  3.957308279384375e-09, -1.056734516044248e-10,  2.456280478902680e-12, -5.093145580930210e-14,  9.587854921976138e-16, -1.660341425529303e-17,  2.672003938883275e-19,
 -4.027850699623206e-21,  3.091090024256165e-04, -3.616346596104820e-05,  2.260134916040964e-06, -9.950397600584259e-08,  3.449040909550449e-09, -9.991454892550907e-11,
  2.510067433654872e-12, -5.606916940005778e-14,  1.133805253437135e-15, -2.103646376432937e-17,  3.618742600253449e-19, -5.818419961032686e-21,  1.808705529806724e-04,
 -2.335861821284728e-05,  1.601320745054956e-06, -7.690392877039182e-08,  2.894340043643438e-09, -9.067726580034998e-11,  2.455145037047514e-12, -5.892785897918497e-14,
  1.276926615021066e-15, -2.532645437969591e-17,  4.647013235783898e-19, -7.953274780927047e-21,  1.039434794459287e-04, -1.473561200126983e-05,  1.103119392957170e-06,
 -5.757141075082088e-08,  2.344791797969040e-09, -7.920903829344867e-11,  2.305121467586912e-12, -5.929957518668336e-14,  1.373761348291242e-15, -2.906288091992352e-17,
  5.676085692008232e-19, -1.032011973058123e-20,  5.876493017536258e-05, -9.097576639129646e-06,  7.405748937649156e-07, -4.184974229322053e-08,  1.838634318097662e-09,
 -6.677806312087634e-11,  2.083276322437236e-12, -5.730050416950353e-14,  1.415932143855651e-15, -3.188285203376010e-17,  6.614487400336630e-19, -1.275131590040923e-20,
  3.274092897734088e-05, -5.508438402029592e-06,  4.856496635862320e-07, -2.961275896708352e-08,  1.399087303213578e-09, -5.447983615515357e-11,  1.817301869936716e-12,
 -5.331598258848082e-14,  1.402159349037617e-15, -3.353413437043151e-17,  7.375477967853052e-19, -1.504690443973112e-20,  1.801013584537404e-05, -3.277970136137485e-06,
  3.118159527448699e-07, -2.044741018123417e-08,  1.035784972018815e-09, -4.312518270825253e-11,  1.534302257500455e-12, -4.790119264461045e-14,  1.337801540343819e-15,
 -3.391246153785815e-17,  7.891781976611724e-19, -1.700659470260509e-20,  9.800264213343174e-06, -1.921347481009878e-06,  1.964806795729701e-07, -1.381175634074916e-08,
  7.479731138902875e-10, -3.320965831077186e-11,  1.257088303126233e-12, -4.166871032444302e-14,  1.233174206351571e-15, -3.306621648471273e-17,  8.125899638726095e-19,
 -1.846267369738354e-20,  5.286077851806223e-06, -1.111745768121939e-06,  1.217942552211454e-07, -9.149469304552080e-09,  5.282173051639097e-10, -2.494477092969573e-11,
  1.002197959083381e-12, -3.519042664140594e-14,  1.101240889039534e-15, -3.117150917839756e-17,  8.073857798117550e-19, -1.930571850562959e-20,  2.832179792206057e-06,
 -6.365047003813760e-07,  7.445150288799618e-08, -5.959002392996391e-09,  3.657400179528182e-10, -1.832398761059227e-11,  7.795299872087854e-13, -2.893072356977742e-14,
  9.553063712210898e-16, -2.848800436313535e-17,  7.762300779886905e-19, -1.949756583400929e-20,  1.510599902442031e-06, -3.614223086188899e-07,  4.499136651416121e-08,
 -3.825476429011955e-09,  2.489392996875338e-10, -1.319868717696670e-11,  5.931443100157121e-13, -2.321554088358757e-14,  8.071882186093358e-16, -2.530865902040904e-17,
  7.240568053684301e-19, -1.907000311256905e-20,  8.038940133849401e-07, -2.040265731538849e-07,  2.694492598415889e-08, -2.426855665912659e-09,  1.669966553511075e-10,
 -9.346681820654161e-12,  4.426805740315216e-13, -1.823233795508649e-14,  6.661012779745832e-16, -2.191496608487610e-17,  6.570339586115114e-19, -1.811151086910468e-20,
  4.278314684785993e-07, -1.147824004628460e-07,  1.603285769707142e-08, -1.525341621772945e-09,  1.107005760771222e-10, -6.524463601855965e-12,  3.249177751169229e-13,
 -1.405085103922419e-14,  5.382591528292081e-16, -1.854501452354037e-17,  5.815437505087257e-19, -1.674687270239361e-20,  2.282409180462304e-07, -6.451359283405532e-08,
  9.502367471994599e-09, -9.523042414716198e-10,  7.270310843755111e-11, -4.501249321414375e-12,  2.351541344932136e-13, -1.065375373842415e-14,  4.270401701041506e-16,
 -1.537673920415385e-17,  5.033690167444307e-19, -1.511510333475611e-20,  1.223472400197677e-07, -3.631539472981652e-08,  5.623948261166000e-09, -5.920893590986333e-10,
  4.742897533678221e-11, -3.077181316369466e-12,  1.682515874887837e-13, -7.968401112056791e-15,  3.335002613398037e-16, -1.252476289123703e-17,  4.271788498127375e-19,
 -1.335020110642431e-20,  6.605553824765838e-08, -2.052425680047300e-08,  3.332223391442772e-09, -3.675433987187823e-10,  3.081308154951941e-11, -2.089870366212196e-12,
  1.193179119163635e-13, -5.894080959069675e-15,  2.570247207851446e-16, -1.004698451059104e-17,  3.563160001396416e-19, -1.156741973618843e-20,  3.600503334333344e-08,
 -1.167458227550635e-08,  1.981471166879947e-09, -2.283633155386142e-10,  1.998558799485144e-11, -1.413581032938156e-12,  8.407691689572945e-14, -4.322306059825810e-15,
  1.959631791759899e-16, -7.956507139346121e-18,  2.928273005206547e-19, -9.855838465408836e-21,  1.985896829204399e-08, -6.699552568533598e-09,  1.185358674368157e-09,
 -1.423619637991842e-10,  1.297309103971963e-11, -9.545713496918601e-13,  5.900892956171239e-14, -3.149968878317272e-15,  1.481568046800407e-16, -6.235120285398159e-18,
  2.376517395733335e-19, -8.276530910465490e-21,  1.110833284864663e-08, -3.887500242860582e-09,  7.150250613088573e-10, -8.925162250664185e-11,  8.447299391825328e-12,
 -6.450308920239890e-13,  4.134460730273887e-14, -2.286487446245324e-15,  1.113230870542349e-16, -4.845727987921879e-18,  1.908824425357258e-19, -6.864814328498977e-21,
  6.314457352774278e-09, -2.285808565484010e-09,  4.358488271312341e-10, -5.639333878940446e-11,  5.529321598991310e-12, -4.370811027172773e-13,  2.897983720174371e-14,
 -1.656562414100701e-15,  8.330236668824159e-17, -3.742339167766628e-18,  1.520371988219589e-19, -5.634858982569937e-21,  3.654462124602702e-09, -1.364539440849939e-09,
  2.689878789929552e-10, -3.598053455651469e-11,  3.645347843422451e-12, -2.975627059996614e-13,  2.035936008448468e-14, -1.200124272755061e-15,  6.219097317216422e-17,
 -2.877212816920851e-18,  1.202962129081848e-19, -4.585160935074025e-21,  2.156696036645947e-09, -8.283464691674803e-10,  1.683526777157798e-10, -2.321890888814342e-11,
  2.424483887540565e-12, -2.038547472864464e-13,  1.435830094936901e-14, -8.707446056938871e-16,  4.639250446063026e-17, -2.205377415324480e-18,  9.468773013708593e-20,
 -3.703809079219338e-21,  1.299368791316715e-09, -5.119661670666928e-10,  1.069856355364578e-10, -1.517311860297946e-11,  1.628658712990745e-12, -1.407007393587799e-13,
  1.017672917813479e-14, -6.334081492596285e-16,  3.461675345069506e-17, -1.687050685825310e-18,  7.421832988504029e-20, -2.972930835083108e-21,  7.996576063856535e-10,
 -3.223636714654037e-10,  6.907553431116034e-11, -1.004703502601565e-11,  1.105693236414791e-12, -9.789446159452194e-14,  7.253046026613787e-15, -4.622022671718791e-16,
  2.584970675174087e-17, -1.288560893671773e-18,  5.795430600284410e-20, -2.372074918453219e-21,  5.025679743877902e-10, -2.067464620222060e-10,  4.530331630688071e-11,
 -6.739691266736986e-12,  7.584619935129911e-13, -6.864302097477482e-14,  5.196583269437957e-15, -3.382212440658752e-16,  1.931106265398447e-17, -9.823105932556068e-19,
  4.506477112185982e-20, -1.880544210413862e-21,  3.220765032766260e-10, -1.348623169268447e-10,  3.013820995789108e-11, -4.573524005207091e-12,  5.249153031976783e-13,
 -4.843535528794738e-14,  3.737146175213510e-15, -2.478087604125400e-16,  1.440956286348463e-17, -7.462050536973806e-19,  3.483766893365675e-20, -1.478831958792753e-21,
  2.097507484709747e-10, -8.917181994875840e-11,  2.026802628077310e-11, -3.128892796055521e-12,  3.652689973864970e-13, -3.427350267097174e-14,  2.688300989460482e-15,
 -1.811582416631125e-16,  1.070176282685866e-17, -5.628405242610274e-19,  2.667840837120230e-20, -1.149367151753985e-21,  1.378756162495528e-10, -5.936406238337867e-11,
  1.368633018578463e-11, -2.143529326648582e-12,  2.538442831745302e-13, -2.415672767213492e-14,  1.921209585718418e-15, -1.312373684701953e-16,  7.856701660723403e-18,
 -4.186379957367183e-19,  2.009857877885386e-20, -8.767716504263217e-22,  9.028539133533805e-11, -3.927338369818388e-11,  9.159339352772031e-12, -1.451385925577738e-12,
  1.738849503812395e-13, -1.673794956862464e-14,  1.346239936158928e-15, -9.298157766675833e-17,  5.627004668411901e-18, -3.030253252356198e-19,  1.469992831555952e-20,
 -6.477997450668610e-22,  5.731818527846006e-11, -2.512820775857241e-11,  5.912249567905052e-12, -9.452730547743952e-13,  1.142607642779987e-13, -1.109544086835143e-14,
  9.001336626870959e-16, -6.269803906002605e-17,  3.825915093835730e-18, -2.077141805084799e-19,  1.015687693132320e-20, -4.510898227447244e-22,  3.299202768552811e-11,
 -1.454180895782632e-11,  3.442374973217938e-12, -5.538025422746187e-13,  6.735513575271084e-14, -6.580480122970958e-15,  5.370501991081932e-16, -3.762779078272809e-17,
  2.309338940715927e-18, -1.260858958097477e-19,  6.199536682907572e-21, -2.768248163286875e-22,  1.340014687101333e-11, -5.924038832315022e-12,  1.407115640956510e-12,
 -2.271557511830364e-13,  2.772221725838051e-14, -2.717585457728170e-15,  2.225277938377578e-16, -1.564210829863328e-17,  9.630838690756622e-19, -5.274791515457456e-20,
  2.601554970745771e-21, -1.165152543990479e-22,  5.738933032402253e-02, -1.363730229324882e-04,  3.359601124423611e-07, -8.526587248935693e-10,  2.213175429598557e-12,
 -5.835295192475879e-15,  1.553936660737532e-17, -4.161841005379014e-20,  1.117533832099724e-22, -3.002501704434734e-25,  8.059961438839885e-28, -2.160091809162391e-30,
  5.539466719837588e-02, -1.682729588637634e-04,  6.007150064411424e-07, -2.224020446422771e-09,  8.153911654918561e-12, -2.929272247600065e-14,  1.031167830724408e-16,
 -3.565313033678584e-19,  1.213691485555841e-21, -4.075981890001824e-24,  1.352562434194425e-26, -4.440474196758881e-29,  5.161458658291775e-02, -2.250642320582588e-04,
  1.141373190069972e-06, -5.540749977233042e-09,  2.550086040483318e-11, -1.124863964982282e-13,  4.797221258993622e-16, -1.989730986270554e-18,  8.059784255330246e-21,
 -3.198344442866513e-23,  1.246374215039471e-25, -4.778897260112948e-28,  4.643084250544990e-02, -2.945738759988242e-04,  1.961118600430750e-06, -1.178373139476318e-08,
  6.565139483604829e-11, -3.458500485199208e-13,  1.742902431591802e-15, -8.467404167765600e-18,  3.987737920997045e-20, -1.828171024531724e-22,  8.185290269775471e-25,
 -3.588379427583656e-27,  4.033327610882400e-02, -3.625539676833340e-04,  3.028092025639610e-06, -2.201019160535704e-08,  1.458397507061328e-10, -9.021983008744762e-13,
  5.285701214074214e-15, -2.961147868666817e-17,  1.597279859832929e-19, -8.339103840110279e-22,  4.230779620677518e-24, -2.092477548098857e-26,  3.384294493787750e-02,
 -4.160520390342904e-04,  4.256452808616209e-06, -3.690423044258009e-08,  2.870112057647237e-10, -2.058941545335474e-12,  1.385817905065456e-14, -8.852515104937816e-17,
  5.411093335423381e-19, -3.184323891372512e-21,  1.812645629494638e-23, -1.001807287729823e-25,  2.743958852589707e-02, -4.460940247758077e-04,  5.507903761812816e-06,
 -5.632568220915517e-08,  5.087351603776975e-10, -4.190706964472765e-12,  3.210915031081259e-14, -2.318647740508493e-16,  1.592848242348476e-18, -1.048276299828812e-20,
  6.644630932849243e-23, -4.073709291080623e-25,  2.150709569623901e-02, -4.490369127179455e-04,  6.615877631786492e-06, -7.902902725653109e-08,  8.216974454018788e-10,
 -7.710344022951223e-12,  6.675119943701868e-14, -5.410846453634600e-16,  4.149862635551463e-18, -3.034860028284451e-20,  2.128998079920666e-22, -1.439385465583171e-24,
  1.630437641087810e-02, -4.264431902235145e-04,  7.423775784614614e-06, -1.027038383070868e-07,  1.220070382685416e-09, -1.295271911078039e-11,  1.259102152836057e-13,
 -1.138957614821376e-15,  9.697952993977021e-18, -7.839250812320934e-20,  6.055249368591377e-22, -4.492372177127354e-24,  1.196197449751902e-02, -3.837887182008942e-04,
  7.822631842286031e-06, -1.243798667789433e-07,  1.677073348326717e-09, -2.002478817050182e-11,  2.173776174149150e-13, -2.183180348577527e-15,  2.053886752635652e-17,
 -1.826715300722268e-19,  1.546832179060688e-21, -1.253988864227902e-23,  8.499067101229810e-03, -3.285844189677948e-04,  7.774705043191767e-06, -1.410900150141996e-07,
  2.146482392566384e-09, -2.867396661449294e-11,  3.459245133675189e-13, -3.839987402259033e-15,  3.974573150203612e-17, -3.873793565939060e-19,  3.582218661473974e-21,
 -3.161567026622238e-23,  5.852471816293995e-03, -2.685187740240367e-04,  7.316267588373831e-06, -1.505716898608348e-07,  2.570722123084106e-09, -3.823653234564434e-11,
  5.104143065670963e-13, -6.237164026675181e-15,  7.075731388871602e-17, -7.530176353071595e-19,  7.578301438769096e-21, -7.257545135099473e-23,  3.909081774955248e-03,
 -2.100629589713253e-04,  6.541295723989389e-06, -1.517709294398830e-07,  2.893431789042769e-09, -4.770743865401171e-11,  7.018516165701828e-13, -9.406354945500075e-15,
  1.165539961781552e-16, -1.349985436991380e-18,  1.473991160120825e-20, -1.527160290935330e-22,  2.535035866272621e-03, -1.577301716013320e-04,  5.573985910816458e-06,
 -1.449988892895109e-07,  3.072434653683285e-09, -5.592776649426449e-11,  9.034282760491897e-13, -1.323426260957889e-14,  1.785432184313675e-16, -2.243923419504962e-18,
  2.650526135479959e-20, -2.962827926904491e-22,  1.597769598579077e-03, -1.139513673706044e-04,  4.539966971790590e-06, -1.317285313993554e-07,  3.088850961231328e-09,
 -6.183701525240461e-11,  1.092995348053007e-12, -1.744503360777165e-14,  2.554845149118181e-16, -3.474391095329707e-18,  4.428020692233469e-20, -5.326824486059244e-22,
  9.798354560466218e-04, -7.938665425317986e-05,  3.544082772750343e-06, -1.141427904800330e-07,  2.949704962694462e-09, -6.470922944224560e-11,  1.247449082722327e-12,
 -2.162830990714386e-14,  3.428890098051023e-16, -5.032440800206164e-18,  6.902996596911694e-20, -8.915612668637359e-22,  5.853722933620854e-04, -5.344904883932670e-05,
  2.658533280870805e-06, -9.460511047640368e-08,  2.683899157730796e-09, -6.429839870121344e-11,  1.347719765230426e-12, -2.531116123047100e-14,  4.332457653499711e-16,
 -6.845312925250973e-18,  1.008232654348644e-19, -1.394944587455063e-21,  3.411350433155436e-04, -3.485089279753100e-05,  1.921100844987502e-06, -7.520913370701765e-08,
  2.333651458502556e-09, -6.085503622883386e-11,  1.382791590749731e-12, -2.805466278873700e-14,  5.171598002112259e-16, -8.775886964141324e-18,  1.384828310592156e-19,
 -2.048092790125130e-21,  1.942030775497770e-04, -2.205342203959731e-05,  1.340555396060940e-06, -5.750060981158656e-08,  1.944547833880764e-09, -5.502336177956058e-11,
  1.351571496965631e-12, -2.954568907536850e-14,  5.851425733852922e-16, -1.064021405446459e-17,  1.794988028643531e-19, -2.831952078313670e-21,  1.081653899209880e-04,
 -1.357169154375450e-05,  9.054996895521125e-07, -4.238891497577527e-08,  1.557087171763335e-09, -4.766552646923498e-11,  1.262247598578212e-12, -2.965635547605152e-14,
  6.295359442146153e-16, -1.223999157596032e-17,  2.202926262845254e-19, -3.700319346094898e-21,  5.903874915226461e-05, -8.139648459175660e-06,  5.934697701203886e-07,
 -3.020847064006094e-08,  1.201426135103829e-09, -3.967287392619429e-11,  1.129634506209508e-12, -2.845606475489658e-14,  6.459973891192714e-16, -1.340111648521640e-17,
  2.568001287381780e-19, -4.583725778396498e-21,  3.163478018473140e-05, -4.767886098199842e-06,  3.783179709279107e-07, -2.086486036915208e-08,  8.956490586205730e-10,
 -3.181435013883919e-11,  9.715410478125188e-13, -2.617797416143573e-14,  6.341448090680541e-16, -1.400712091014669e-17,  2.852248744884951e-19, -5.399877372751521e-21,
  1.667178315565299e-05, -2.733708542385368e-06,  2.351336863141350e-07, -1.400323783054475e-08,  6.468421235651070e-10, -2.464856405542960e-11,  8.052710801273369e-13,
 -2.315545483730706e-14,  5.972637381125206e-16, -1.401830774397605e-17,  3.027496682470203e-19, -6.068164706900152e-21,  8.658608241386500e-06, -1.537691245081617e-06,
  1.428364655209647e-07, -9.155700737479740e-09,  4.537781796849385e-10, -1.850102777672813e-11,  6.450623610630894e-13, -1.975001003840275e-14,  5.412787055364325e-16,
 -1.347262533905540e-17,  3.080119112907491e-19, -6.524293333851486e-21,  4.440892976580616e-06, -8.505328583031776e-07,  8.501900433156509e-08, -5.847109437018990e-09,
  3.100603276599749e-10, -1.349071021169962e-11,  5.007942109938165e-13, -1.628970434904561e-14,  4.733698456312499e-16, -1.247029920825702e-17,  3.012351070261759e-19,
 -6.731103644758295e-21,  2.254255950398272e-06, -4.637290837928607e-07,  4.971119908521385e-08, -3.657038007357213e-09,  2.069136442454220e-10, -9.583274995229781e-12,
  3.778650905668702e-13, -1.302941772544048e-14,  4.006344064667192e-16, -1.114857950369419e-17,  2.840227576980399e-19, -6.683054479649448e-21,  1.135133261599896e-06,
 -2.498432876928645e-07,  2.862769264377451e-08, -2.246085317533923e-09,  1.352285646726932e-10, -6.650398138269231e-12,  2.778825505827149e-13, -1.013534816692119e-14,
  3.290831799554935e-16, -9.654408894845353e-18,  2.589153202410460e-19, -6.403953176334881e-21,  5.683870604706025e-07, -1.333558572794775e-07,  1.628055650422542e-08,
 -1.358376121358348e-09,  8.679489909850391e-11, -4.521270045489275e-12,  1.997407587021936e-13, -7.689421051999679e-15,  2.630965496137926e-16, -8.121538417146608e-18,
  2.288556184611097e-19, -5.939446399409583e-21,  2.837120298949980e-07, -7.070317088457161e-08,  9.168181995459276e-09, -8.111802375296157e-10,  5.486434695144556e-11,
 -3.019860958522561e-12,  1.407322639879405e-13, -5.706017551488337e-15,  2.053145584702185e-16, -6.655771951119393e-18,  1.966990104297020e-19, -5.346892401092121e-21,
  1.415353683082469e-07, -3.733504246910605e-08,  5.126601127755866e-09, -4.796679859176386e-10,  3.425249400918524e-11, -1.987330920071006e-12,  9.747386794697926e-14,
 -4.153389961255601e-15,  1.568419823112057e-16, -5.328982415800149e-18,  1.648586357782415e-19, -4.685325014556574e-21,  7.075419378326275e-08, -1.968958117552841e-08,
  2.854475398205240e-09, -2.816598870990356e-10,  2.118089962656479e-11, -1.292285418853484e-12,  6.655773631430479e-14, -2.974046048080670e-15,  1.176204310489889e-16,
 -4.180311593667814e-18,  1.351184140424305e-19, -4.007521607883808e-21,  3.553914371404694e-08, -1.039933324749668e-08,  1.587094210225311e-09, -1.647069090355131e-10,
  1.301051013900517e-11, -8.327222122452420e-13,  4.493351296356116e-14, -2.100913290044981e-15,  8.683872319866096e-17, -3.221918251464621e-18,  1.085983086316617e-19,
 -3.355141532094863e-21,  1.798492314152433e-08, -5.516177243832170e-09,  8.836715199665071e-10, -9.619267047054940e-11,  7.961324689448353e-12, -5.332572100711407e-13,
  3.007736449477820e-14, -1.468291091843216e-15,  6.329545097713747e-17, -2.446631644306253e-18,  8.582846645907618e-20, -2.756927621824623e-21,  9.194670104138623e-09,
 -2.946764512898920e-09,  4.941004894927665e-10, -5.626589820163413e-11,  4.866836633264475e-12, -3.403243031617616e-13,  2.001814374125851e-14, -1.018044399157505e-15,
  4.567251491102810e-17, -1.835491730849753e-18,  6.688157834235743e-20, -2.229314950805754e-21,  4.761609344264331e-09, -1.589718166674133e-09,  2.782142165734810e-10,
 -3.305423736294672e-11,  2.980444220288880e-12, -2.170522290835747e-13,  1.328336207420672e-14, -7.021748684283848e-16,  3.271300314346449e-17, -1.363988332411097e-18,
  5.152014321018297e-20, -1.778528860991298e-21,  2.504333374718547e-09, -8.683996546535295e-10,  1.581785973009762e-10, -1.955473233035489e-11,  1.833355804847198e-12,
 -1.387076010086775e-13,  8.811103956348149e-15, -4.830276452489016e-16,  2.331727190725178e-17, -1.006550240810432e-18,  3.932943538096650e-20, -1.403300244202451e-21,
  1.340989901089495e-09, -4.815516556539421e-10,  9.103835792495802e-11, -1.167940064541772e-11,  1.135631913262931e-12, -8.903969423564276e-14,  5.856795550107158e-15,
 -3.322009871987533e-16,  1.657922743725886e-17, -7.393438143343262e-19,  2.982149724295246e-20, -1.097545321972276e-21,  7.327266850852437e-10, -2.717072102977804e-10,
  5.316473683833490e-11, -7.058992034215355e-12,  7.099924593399648e-13, -5.754430259361280e-14,  3.909943277158214e-15, -2.289227304288666e-16,  1.178471808672402e-17,
 -5.417064577933803e-19,  2.250676986452186e-20, -8.526241725427792e-22,  4.093595981451059e-10, -1.563074369018504e-10,  3.156689924463345e-11, -4.326118642948628e-12,
  4.489156438494916e-13, -3.751563501434148e-14,  2.626648174767300e-15, -1.583649841716939e-16,  8.389714947276648e-18, -3.966190329858965e-19,  1.693691216073024e-20,
 -6.590240001604874e-22,  2.342072513439475e-10, -9.183005094740879e-11,  1.908779158325113e-11, -2.692692685849537e-12,  2.875133751740616e-13, -2.471079559348114e-14,
  1.778325723965763e-15, -1.101414627954489e-16,  5.990577362108338e-18, -2.905867295310426e-19,  1.272544831220305e-20, -5.074733992296957e-22,  1.373605104561826e-10,
 -5.515309824797216e-11,  1.176649617994620e-11, -1.703929921669953e-12,  1.867090812294331e-13, -1.646048640122668e-14,  1.214504743043661e-15, -7.708087741839881e-17,
  4.293856017339096e-18, -2.132136229287446e-19,  9.553309703532184e-21, -3.895809388093524e-22,  8.259601823217324e-11, -3.387057118886795e-11,  7.395921149154750e-12,
 -1.096403635797423e-12,  1.229565696165489e-13, -1.108996551549726e-14,  8.367569162521843e-16, -5.428285503900517e-17,  3.089450107138142e-18, -1.566641017783260e-19,
  7.165315290525071e-21, -2.981216973393333e-22,  5.086472163644572e-11, -2.124634141432643e-11,  4.735113725062316e-12, -7.165947144781675e-13,  8.202293423971782e-14,
 -7.548371805490065e-15,  5.808977127519810e-16, -3.842112073071050e-17,  2.228553798398688e-18, -1.151262493871833e-19,  5.362083774914196e-21, -2.270901683880773e-22,
  3.198160535028514e-11, -1.357175008280646e-11,  3.078507932792182e-12, -4.742761345615941e-13,  5.525537804222307e-14, -5.174360423440242e-15,  4.050699422306172e-16,
 -2.724472659188690e-17,  1.606461686441963e-18, -8.433530749873422e-20,  3.990350671451814e-21, -1.716156055338115e-22,  2.039921959985032e-11, -8.771926955885261e-12,
  2.019467603272090e-12, -3.158279049735020e-13,  3.734785471025366e-14, -3.549146643246245e-15,  2.818773423212226e-16, -1.922893163957167e-17,  1.149642793410517e-18,
 -6.117853257786802e-20,  2.933432374114926e-21, -1.278089904160120e-22,  1.303137149380383e-11, -5.663789295207381e-12,  1.319664405477803e-12, -2.089139010239488e-13,
  2.500546865853533e-14, -2.404751974051136e-15,  1.932382702616599e-16, -1.333454706528104e-17,  8.062644346420479e-19, -4.338166217513041e-20,  2.102701299813927e-21,
 -9.258640223560434e-23,  8.115878857709906e-12, -3.556211597866130e-12,  8.362452451483429e-13, -1.336254577655443e-13,  1.614290827673226e-14, -1.566698674235969e-15,
  1.270306214047391e-16, -8.843423457579415e-18,  5.393509792453420e-19, -2.926689250516200e-20,  1.430373900159592e-21, -6.349455788992869e-23,  4.609252616298162e-12,
 -2.031070516582541e-12,  4.806559486301239e-13, -7.730333571109501e-14,  9.399000720906183e-15, -9.179895959923030e-16,  7.489730716597629e-17, -5.246060448420903e-18,
  3.218753131562691e-19, -1.756888123126530e-20,  8.636079264407121e-22, -3.855180351370123e-23,  1.858127773206628e-12, -8.213455177684617e-13,  1.950614835949953e-13,
 -3.148455763522086e-14,  3.841792095388471e-15, -3.765490665101527e-16,  3.082873806444641e-17, -2.166709288187909e-18,  1.333841222900462e-19, -7.304337221607104e-21,
  3.602009386014096e-22, -1.612991039281288e-23,  5.684914963035747e-02, -1.337256764079645e-04,  3.259368858629858e-07, -8.181616909795265e-10,  2.100106630041535e-12,
 -5.475939849018232e-15,  1.442253499640509e-17, -3.820920473613021e-20,  1.015025111084743e-22, -2.698323815666682e-25,  7.167787382521276e-28, -1.901137322013205e-30,
  5.473102085094971e-02, -1.635718175975616e-04,  5.747906298836636e-07, -2.098113548175655e-09,  7.592018739754606e-12, -2.693345743448684e-14,  9.365630405033935e-17,
 -3.199402266145510e-19,  1.076241671578018e-21, -3.572076903867840e-24,  1.171608939283308e-26, -3.802217705565250e-29,  5.073218010064263e-02, -2.161924333096523e-04,
  1.077260007742886e-06, -5.150126907740011e-09,  2.336189930388543e-11, -1.016135013954644e-13,  4.274539763439815e-16, -1.749317805380247e-18,  6.993275015767180e-21,
 -2.739418155137483e-23,  1.053994541987317e-25, -3.990669810309877e-28,  4.528305387065213e-02, -2.794332004390666e-04,  1.825795244411099e-06, -1.078645043152477e-08,
  5.913420659814352e-11, -3.067271040793865e-13,  1.522734099797145e-15, -7.290607900574373e-18,  3.384915273795743e-20, -1.530272312937621e-22,  6.758073632071114e-25,
 -2.922924760315636e-27,  3.892989118514913e-02, -3.393473801825923e-04,  2.777396472374563e-06, -1.981448662195335e-08,  1.290000655450891e-10, -7.847399667077601e-13,
  4.523847662263196e-15, -2.494957276384185e-17,  1.325438697213829e-19, -6.817485637288022e-22,  3.408643650156840e-24, -1.661854123158696e-26,  3.224414153430645e-02,
 -3.836967688089398e-04,  3.839852533748430e-06, -3.262421959818587e-08,  2.489672431090161e-10, -1.754234173199567e-12,  1.160560813500208e-14, -7.291207349533025e-17,
  4.385280617400251e-19, -2.540304720554126e-21,  1.423935611984795e-23, -7.751842098986950e-26,  2.573924542104996e-02, -4.046021598625611e-04,  4.878198121944817e-06,
 -4.881667044597369e-08,  4.321296993995490e-10, -3.492565372545650e-12,  2.627726370582855e-14, -1.864518491242905e-16,  1.259283900018082e-18, -8.151603949841441e-21,
  5.084284566220877e-23, -3.068271267832814e-25,  1.981109664413520e-02, -3.996909619941313e-04,  5.741591937590748e-06, -6.703337313702369e-08,  6.823571461136650e-10,
 -6.276067454580353e-12,  5.330675894936235e-14, -4.242426013529126e-16,  3.196471328150975e-18, -2.297663830077334e-20,  1.584990804928331e-22, -1.054150366778720e-24,
  1.471002240160116e-02, -3.716695818434476e-04,  6.300411354307258e-06, -8.510120411460414e-08,  9.888220452692829e-10, -1.028094551842462e-11,  9.797104010484057e-14,
 -8.694636130078755e-16,  7.268011831000335e-18, -5.770908678701054e-20,  4.380726722540222e-22, -3.195364877623031e-24,  1.054313493100390e-02, -3.267504271892325e-04,
  6.478720591151331e-06, -1.004867204287878e-07,  1.324156278257779e-09, -1.547268012708843e-11,  1.645406320669791e-13, -1.620215712448116e-15,  1.495507187012554e-17,
 -1.305783852697018e-19,  1.086070351682306e-21, -8.652131354780305e-24,  7.299172133791805e-03, -2.726160814255085e-04,  6.270129537114395e-06, -1.109171726317944e-07,
  1.648007334701694e-09, -2.153025398851574e-11,  2.542969065493553e-13, -2.766110113988801e-15,  2.807566276704558e-17, -2.685036449428402e-19,  2.437695114572279e-21,
 -2.113275719084530e-23,  4.884929193184221e-03, -2.165709104647192e-04,  5.732964691754373e-06, -1.149474768348412e-07,  1.915568189469129e-09, -2.784951925898256e-11,
  3.637811729155969e-13, -4.353889405053816e-15,  4.841356838746883e-17, -5.053506945517998e-19,  4.991169580031732e-21, -4.693390154987785e-23,  3.162978534648205e-03,
 -1.642975692343510e-04,  4.969064130270537e-06, -1.122765000368989e-07,  2.088395226141291e-09, -3.364321682649223e-11,  4.841247385531959e-13, -6.352395028786333e-15,
  7.712401799536119e-17, -8.758582846606868e-19,  9.382140365985437e-21, -9.541722395985150e-23,  1.983355705728437e-03, -1.193404665794284e-04,  4.095538482761871e-06,
 -1.037255706536396e-07,  2.143731418111416e-09, -3.811449956270105e-11,  6.020354450163100e-13, -8.631819404025899e-15,  1.140692797562744e-16, -1.405267448552458e-18,
  1.628080167643608e-20, -1.786006362528464e-22,  1.205665163481565e-03, -8.319992786491080e-05,  3.219141896315499e-06, -9.092639695050514e-08,  2.079189378341755e-09,
 -4.064722371448666e-11,  7.023829764010387e-13, -1.097010106039443e-14,  1.573397387169023e-16, -2.096982912645050e-18,  2.620838911157636e-20, -3.093565190742536e-22,
  7.113344868230483e-04, -5.579925446146741e-05,  2.419588872711297e-06, -7.585987947074449e-08,  1.911616425852723e-09, -4.094776601917596e-11,  7.716315682742809e-13,
 -1.309003121642666e-14,  2.032146428730907e-16, -2.922623273673641e-18,  3.930969792542446e-20, -4.981161984894103e-22,  4.078374548845046e-04, -3.607921419886323e-05,
  1.743585701125584e-06, -6.040848288326828e-08,  1.671200990600064e-09, -3.909364350754246e-11,  8.009774443559625e-13, -1.471804405985787e-14,  2.466834510128140e-16,
 -3.819230661500621e-18,  5.515646803570307e-20, -7.486821246389918e-22,  2.275406492028227e-04, -2.253935716398738e-05,  1.207642139601738e-06, -4.604118709225258e-08,
  1.393344990064354e-09, -3.548201089594959e-11,  7.881620620396785e-13, -1.564608886318268e-14,  2.824316256327441e-16, -4.696500832341506e-18,  7.266906496802165e-20,
 -1.054449543142459e-21,  1.237175573836851e-04, -1.363353234971490e-05,  8.059323912629514e-07, -3.367643118689139e-08,  1.111044088157566e-09, -3.070695347350690e-11,
  7.374762998232141e-13, -1.577637913639117e-14,  3.059978731771638e-16, -5.453224923871077e-18,  9.021606658560987e-20, -1.396621881679550e-21,  6.565940134645323e-05,
 -8.001843863179968e-06,  5.195024508566805e-07, -2.370208124398104e-08,  8.496909216333489e-10, -2.541312828078911e-11,  6.581560961334351e-13, -1.513580087687758e-14,
  3.147330430742733e-16, -5.998381228912880e-18,  1.058895044485969e-19, -1.745585441015216e-21,  3.407226881086535e-05, -4.567033646671229e-06,  3.242422918471518e-07,
 -1.609422780389354e-08,  6.249531588949659e-10, -2.017054528203532e-11,  5.618771395367693e-13, -1.385851230718303e-14,  3.082703519213798e-16, -6.270334734429663e-18,
  1.178846007635264e-19, -2.065559854412519e-21,  1.731980453343996e-05, -2.540454317317735e-06,  1.964350260791910e-07, -1.057111764961113e-08,  4.432875245390254e-10,
 -1.539747872845023e-11,  4.602059645251779e-13, -1.214606236374151e-14,  2.884069542537613e-16, -6.248340757767824e-18,  1.248700484301417e-19, -2.321400660655479e-21,
  8.641259130803147e-06, -1.380452073643155e-06,  1.158047535546236e-07, -6.734288218169511e-09,  3.040695179662745e-10, -1.133668562906513e-11,  3.626778412078418e-13,
 -1.021984684452457e-14,  2.585033650266637e-16, -5.953541237182702e-18,  1.262384578444874e-19, -2.485580238867530e-21,  4.240463675114803e-06, -7.345101918669145e-07,
  6.660483028502962e-08, -4.172062538939999e-09,  2.022632846829932e-10, -8.073538194095362e-12,  2.758082885944014e-13, -8.279826771288142e-15,  2.226416740685775e-16,
 -5.440377978456968e-18,  1.221729732978731e-19, -2.543308250808090e-21,  2.051248630218585e-06, -3.836298997545713e-07,  3.747123617585150e-08, -2.520501393388135e-09,
  1.308399932243476e-10, -5.577379674437387e-12,  2.029910404263894e-13, -6.478077658766225e-15,  1.848067611976728e-16, -4.782184584405365e-18,  1.135316034223595e-19,
 -2.494469970461807e-21,  9.804246628293516e-07, -1.971864973796210e-07,  2.067641384804355e-08, -1.489063066629791e-09,  8.254388637615761e-11, -3.748409124123510e-12,
  1.450127561146941e-13, -4.909147730940650e-15,  1.482842473396473e-16, -4.055713788210216e-18,  1.016063208064860e-19, -2.352191513361383e-21,  4.641715040140281e-07,
 -1.000105482756012e-07,  1.122128032481051e-08, -8.627186809572810e-10,  5.093472423222773e-11, -2.458068943659405e-12,  1.008523218666279e-13, -3.614086964096429e-15,
  1.153558405019004e-16, -3.328555127772582e-18,  8.783982681064818e-20, -2.138879241104415e-21,  2.182436562089954e-07, -5.018965591216493e-08,  6.006740441367697e-09,
 -4.916131947848727e-10,  3.083294410599152e-11, -1.577505503708986e-12,  6.848926875313834e-14, -2.592589362038306e-15,  8.726951221811151e-17, -2.651561115410384e-18,
  7.357605521235183e-20, -1.881148439273986e-21,  1.021844091172557e-07, -2.499304687339129e-08,  3.180809143053625e-09, -2.763583726228944e-10,  1.836534944896682e-11,
 -9.937952026855955e-13,  4.555532849390189e-14, -1.817753018818072e-15,  6.439987880657249e-17, -2.056468514937690e-18,  5.989182107383761e-20, -1.605049528709014e-21,
  4.777874078229556e-08, -1.238613719403010e-08,  1.671258093618828e-09, -1.537233201037458e-10,  1.079692817559700e-11, -6.164677130436513e-13,  2.976969782398957e-14,
 -1.249504313954649e-15,  4.649836370514739e-17, -1.557545352103714e-18,  4.752258148564030e-20, -1.332566252831894e-21,  2.237482381004317e-08, -6.127359817038833e-09,
  8.739561490160344e-10, -8.487339533361377e-11,  6.284504978137927e-12, -3.777159405339343e-13,  1.917253445487218e-14, -8.446715792517464e-16,  3.295019072387549e-17,
 -1.155541301971521e-18,  3.686813141899610e-20, -1.079766064631358e-21,  1.052592801557878e-08, -3.035068620422358e-09,  4.562800473316057e-10, -4.665871842591354e-11,
  3.633114642244967e-12, -2.293120663320054e-13,  1.220713387342006e-14, -5.632949921622210e-16,  2.298718921968405e-17, -8.423338717499638e-19,  2.805016561715987e-20,
 -8.564689505922155e-22,  4.989552200447538e-09, -1.510000819442789e-09,  2.385827159649496e-10, -2.562114602914680e-11,  2.092659120431820e-12, -1.383770150423323e-13,
  7.707918640017568e-15, -3.717326767932365e-16,  1.583643189011669e-17, -6.051435431506724e-19,  2.099223486662175e-20, -6.669974580449341e-22,  2.390556817452146e-09,
 -7.569427484168225e-10,  1.253388559613537e-10, -1.409755772159372e-11,  1.204758947169039e-12, -8.326052455870032e-14,  4.841736348430229e-15, -2.435062759760769e-16,
  1.080673914931071e-17, -4.297476489309585e-19,  1.549918252427854e-20, -5.114898516129054e-22,  1.161194017296016e-09, -3.835153777001781e-10,  6.636434363287985e-11,
 -7.797045482903701e-12,  6.954057925478238e-13, -5.010669784658342e-14,  3.034836987469103e-15, -1.588136829450050e-16,  7.326459594232980e-18, -3.025709178694340e-19,
  1.132253798821394e-20, -3.873362189530158e-22,  5.735710614282490e-10, -1.970005629348221e-10,  3.552389134106526e-11, -4.347971888336742e-12,  4.036759287463373e-13,
 -3.025106000730416e-14,  1.903841129218970e-15, -1.034277537537454e-16,  4.948910297319719e-18, -2.118033251436510e-19,  8.206836146724129e-21, -2.904476944433271e-22,
  2.889395750517312e-10, -1.028959902630744e-10,  1.928079669292220e-11, -2.451820795663056e-12,  2.363451716311462e-13, -1.837474329241977e-14,  1.198718431042601e-15,
 -6.744787065193667e-17,  3.339878319622700e-18, -1.478080590786100e-19,  5.917658947020229e-21, -2.162214664820675e-22,  1.488489000650953e-10, -5.479948606985594e-11,
  1.064014253260934e-11, -1.401929275731824e-12,  1.399446138256933e-13, -1.125893147789951e-14,  7.595126322715579e-16, -4.415712058230378e-17,  2.257639761409276e-18,
 -1.030854788509701e-19,  4.255169870971314e-21, -1.601796982683041e-22,  7.860756899043558e-11, -2.983190947982774e-11,  5.985001961113662e-12, -8.148249366475111e-13,
  8.400620890225509e-14, -6.975900562155212e-15,  4.853956712977817e-16, -2.908871515595476e-17,  1.531964057351186e-18, -7.200689972149280e-20,  3.057704323810491e-21,
 -1.183281939110050e-22,  4.264314988867755e-11, -1.663471442300427e-11,  3.438541862768740e-12, -4.823808014930838e-13,  5.122508575734836e-14, -4.379070402128667e-15,
  3.134947273746984e-16, -1.931735268806127e-17,  1.045434922685996e-18, -5.046477738280673e-20,  2.199486812411151e-21, -8.730759583080238e-23,  2.379761516381252e-11,
 -9.515435938834792e-12,  2.020791520496771e-12, -2.912958793675388e-13,  3.177491120640769e-14, -2.788925374985864e-15,  2.048856631745666e-16, -1.294854504697823e-17,
  7.183357398045360e-19, -3.552578144490898e-20,  1.585525787388298e-21, -6.440996243659575e-23,  1.367040605548643e-11, -5.587286685218729e-12,  1.215569851950143e-12,
 -1.795387179398652e-13,  2.006134950248130e-14, -1.802974447926464e-15,  1.355636417255217e-16, -8.764471792853449e-18,  4.971621323480486e-19, -2.512894927016316e-20,
  1.145675520577619e-21, -4.752012690083727e-23,  8.078027021230769e-12, -3.365569396774254e-12,  7.479453917651440e-13, -1.128674168761104e-13,  1.288251415507042e-14,
 -1.182256195207977e-15,  9.073533686032924e-17, -5.985380058058477e-18,  3.462711443522532e-19, -1.784289413757062e-20,  8.289877597625061e-22, -3.502389892966264e-23,
  4.897187899993508e-12, -2.074227174152109e-12,  4.695050748511885e-13, -7.217752884569147e-14,  8.391240169142439e-15, -7.841612954107295e-16,  6.126245849736223e-17,
 -4.112272546915621e-18,  2.420050103686149e-19, -1.268052773015138e-20,  5.988691214647859e-22, -2.570936965542729e-23,  3.027403620873695e-12, -1.300081725399922e-12,
  2.988559225728695e-13, -4.666781143962198e-14,  5.510373772447035e-15, -5.228761555984372e-16,  4.146744740892682e-17, -2.824801339768061e-18,  1.686532964852732e-19,
 -8.962797601818347e-21,  4.291869483794965e-22, -1.867550383364349e-23,  1.884740643397122e-12, -8.184413492544171e-13,  1.905090203067212e-13, -3.012904323605770e-14,
  3.602655632415546e-15, -3.461263590608638e-16,  2.778703608915355e-17, -1.915669468069597e-18,  1.157235359772319e-19, -6.221009947834626e-21,  3.012668404389749e-22,
 -1.325407588420582e-23,  1.150577889565505e-12, -5.038963541312726e-13,  1.184216629129363e-13, -1.891153109768489e-14,  2.283290203650474e-15, -2.214677131799889e-16,
  1.794665379375058e-17, -1.248677840793673e-18,  7.611342752914346e-20, -4.127918834854404e-21,  2.016386121864626e-22, -8.946139300328909e-24,  6.443753217719855e-13,
 -2.838662913119931e-13,  6.715641757805605e-14, -1.079725412906645e-14,  1.312378955927889e-15, -1.281384461413770e-16,  1.045139025084702e-17, -7.318288757430338e-19,
  4.488844916420815e-20, -2.449424332100835e-21,  1.203682160260499e-22, -5.371775085646420e-24,  2.577428892308007e-13, -1.139140433662569e-13,  2.704921656129782e-14,
 -4.365268018072116e-15,  5.325706765409430e-16, -5.219098598146572e-17,  4.272291654040251e-18, -3.002187385822348e-19,  1.847881542434375e-20, -1.011776307589936e-21,
  4.988650654665859e-23, -2.233602188367137e-24,  5.631940053022981e-02, -1.311568900562446e-04,  3.163170016299542e-07, -7.854176855503891e-10,  1.993964442482113e-12,
 -5.142279050657603e-15,  1.339672858023188e-17, -3.511117376483331e-20,  9.228509587522247e-23, -2.427655465655781e-25,  6.382065259059676e-28, -1.675411258030787e-30,
  5.408577363634989e-02, -1.590721771399490e-04,  5.503247124698985e-07, -1.980831451014182e-09,  7.075121099708676e-12, -2.478943003052873e-14,  8.516142828955370e-17,
 -2.874707331112385e-19,  9.556945028535178e-22, -3.135236146538431e-24,  1.016531735911014e-26, -3.261434496846107e-29,  4.988426388968192e-02, -2.078153558146738e-04,
  1.017635923404898e-06, -4.792053489057872e-09,  2.142837770426036e-11, -9.191797204008652e-14,  3.814634159631678e-16, -1.540531496420269e-18,  6.078924677849060e-21,
 -2.350932242031146e-23,  8.931722098783180e-26, -3.339856390652861e-28,  4.419373613126872e-02, -2.653289572607519e-04,  1.701838530725460e-06, -9.887461085244174e-09,
  5.334919723384650e-11, -2.725136412128490e-13,  1.332969104963577e-15, -6.290602915874527e-18,  2.879728664780801e-20, -1.284010282474979e-22,  5.594007501462825e-25,
 -2.387316107865918e-27,  3.761548211728099e-02, -3.180453713675104e-04,  2.551507190711396e-06, -1.787037404917310e-08,  1.143367880815545e-10, -6.840931717182759e-13,
  3.881129300456448e-15, -2.107590738257617e-17,  1.102886248594974e-19, -5.589734659630273e-22,  2.754687184262783e-24, -1.324097080530558e-26,  3.076840486664415e-02,
 -3.544787634366636e-04,  3.471152151245009e-06, -2.890695410205538e-08,  2.165103914471781e-10, -1.498693046707529e-12,  9.747529253415537e-15, -6.023880277306961e-17,
  3.565575182061372e-19, -2.033513230524634e-21,  1.122614298980264e-23, -6.020828758299216e-26,  2.419533709336888e-02, -3.678073303599483e-04,  4.331683769669953e-06,
 -4.242883660075689e-08,  3.681844943734303e-10, -2.920263043141862e-12,  2.157930722711502e-14, -1.504825430691884e-16,  9.993973055702234e-19, -6.364293655103423e-21,
  3.906613220737345e-23, -2.321016706521751e-25,  1.829935372411474e-02, -3.567993345074754e-04,  4.998770153870524e-06, -5.705415779386578e-08,  5.687238816981978e-10,
 -5.128415006438377e-12,  4.274386087984280e-14, -3.340517452701950e-16,  2.473071339814471e-18, -1.747584023397359e-20,  1.185643296683441e-22, -7.758419235073719e-25,
  1.331804306666474e-02, -3.250970254926039e-04,  5.367730697295852e-06, -7.080507635147091e-08,  8.048723390643885e-10, -8.197304397255106e-12,  7.659241401038422e-14,
 -6.670028478361735e-16,  5.474708630909149e-18, -4.270687238346403e-20,  3.186510295579109e-22, -2.285538855617093e-24,  9.332634896806179e-03, -2.794060518295541e-04,
  5.390442080773354e-06, -8.157579217210622e-08,  1.050779861828509e-09, -1.201808114707610e-11,  1.252234987464314e-13, -1.209174203366635e-15,  1.095237419531736e-17,
 -9.389689646102166e-20,  7.672220688826566e-22, -6.007130295704397e-24,  6.301192426586579e-03, -2.273615066999366e-04,  5.084128560041181e-06, -8.768690774296100e-08,
  1.272649064725265e-09, -1.626332075439915e-11,  1.880949016868210e-13, -2.005208249546770e-15,  1.996139409337738e-17, -1.873498080851664e-19,  1.670172480694205e-21,
 -1.422418114029267e-23,  4.102320391660489e-03, -1.757430802854095e-04,  4.520539329515055e-06, -8.831844017468398e-08,  1.436848797166782e-09, -2.042214067797795e-11,
  2.610795505316239e-13, -3.060913692444666e-15,  3.336659028579042e-17, -3.416586954730914e-19,  3.312112666782297e-21, -3.058538369602911e-23,  2.577499615872500e-03,
 -1.294136019618346e-04,  3.801918565202476e-06, -8.366959908483741e-08,  1.518640071452480e-09, -2.390648216809361e-11,  3.365415054815788e-13, -4.323980763755419e-15,
  5.144472786167238e-17, -5.729065881846127e-19,  6.021553099986569e-21, -6.012023571825965e-23,  1.564392084238144e-03, -9.102510454564901e-05,  3.033809389517500e-06,
 -7.481444506346693e-08,  1.508301550871354e-09, -2.619607030009562e-11,  4.046564783221953e-13, -5.679274170323194e-15,  7.352454180928857e-17, -8.879673251520149e-19,
  1.009144972925625e-20, -1.086522898570475e-22,  9.181851775992919e-04, -6.130203324696866e-05,  2.303504482143641e-06, -6.334204194045311e-08,  1.412605360586073e-09,
 -2.697017501770063e-11,  4.556610603253281e-13, -6.964715323586504e-15,  9.783789897175971e-17, -1.278043989173508e-18,  1.566550370102336e-20, -1.814515623797557e-22,
  5.217450811690140e-04, -3.962013038348262e-05,  1.668708152193435e-06, -5.093199476947140e-08,  1.251585967668273e-09, -2.617937827014779e-11,  4.822717017344372e-13,
 -8.005412790142187e-15,  1.217059291295440e-16, -1.715347959861522e-18,  2.262435377318746e-20, -2.812890189397260e-22,  2.873980934253863e-04, -2.462884123875132e-05,
  1.156353241105440e-06, -3.900533219474707e-08,  1.052303803746088e-09, -2.403671707201940e-11,  4.814157213812197e-13, -8.655365972210809e-15,  1.420567379077981e-16,
 -2.155230117110927e-18,  3.052011668461898e-20, -4.064530416000199e-22,  1.536778940137606e-04, -1.475713380457005e-05,  7.684533277455018e-07, -2.852942277237991e-08,
  8.420598926607219e-10, -2.094014256271448e-11,  4.547119247930704e-13, -8.832293311381621e-15,  1.561260405935107e-16, -2.544126022566157e-18,  3.860040212490025e-20,
 -5.495387845439758e-22,  7.989109042082924e-05, -8.541436781709014e-06,  4.909568889817692e-07, -1.998355361638677e-08,  6.431491806903645e-10, -1.736108012829042e-11,
  4.076573927312899e-13, -8.533948469561804e-15,  1.621056517179628e-16, -2.831226352436276e-18,  4.593253689144968e-20, -6.977222116366978e-22,  4.044430143563450e-05,
 -4.786100576150381e-06,  3.023057195645162e-07, -1.344080430422799e-08,  4.701884233730879e-10, -1.373857804630139e-11,  3.479494753556040e-13, -7.832008744322220e-15,
  1.595234354174328e-16, -2.980092364063813e-18,  5.159795723418655e-20, -8.347463991761325e-22,  1.997369463521191e-05, -2.602111941290933e-06,  1.798504154892827e-07,
 -8.703838308115083e-09,  3.299432385721836e-10, -1.040721266194899e-11,  2.835931236317210e-13, -6.848134740285283e-15,  1.492496446572374e-16, -2.976393963437077e-18,
  5.489595632825288e-20, -9.441725061983078e-22,  9.641200915192620e-06, -1.375825031207026e-06,  1.036428205751971e-07, -5.441232007134218e-09,  2.228591100108409e-10,
 -7.568495256123056e-12,  2.213706613154975e-13, -5.722167160294216e-15,  1.331685379955110e-16, -2.829537891357908e-18,  5.549107297374443e-20, -1.012910819686827e-21,
  4.557918576826206e-06, -7.091347247424074e-07,  5.800343600278828e-08, -3.292821293689505e-09,  1.453021041767992e-10, -5.299395259026545e-12,  1.659872183425852e-13,
 -4.582949910438048e-15,  1.136620759044342e-16, -2.568313039834605e-18,  5.346124670911282e-20, -1.033919224838285e-21,  2.115041081157916e-06, -3.571897250298412e-07,
  3.160886396497511e-08, -1.934326746448590e-09,  9.170800058017924e-11, -3.583074736862682e-12,  1.199090686486317e-13, -3.528871525900415e-15,  9.308492841179393e-17,
 -2.232668684023870e-18,  4.924199564970808e-20, -1.007290494420303e-21,  9.656199931304216e-07, -1.762770665953814e-07,  1.681876049743963e-08, -1.106157401403649e-09,
  5.619566063274613e-11, -2.346321784638462e-12,  8.370639343769537e-14, -2.620307083050790e-15,  7.337069541148049e-17, -1.864585704837308e-18,  4.349681601042888e-20,
 -9.395631365757110e-22,  4.348226802495170e-07, -8.546541428146271e-08,  8.762698031117961e-09, -6.175854734547704e-10,  3.353148406309860e-11, -1.492567814372942e-12,
  5.663957507936441e-14, -1.882039455564863e-15,  5.583239990503387e-17, -1.500608749560345e-18,  3.696177905719819e-20, -8.416869924092301e-22,  1.936354140187829e-07,
 -4.082302426090649e-08,  4.483445836473146e-09, -3.376558380060380e-10,  1.954261975355845e-11, -9.251987814763307e-13,  3.726359186139509e-14, -1.311654151624436e-15,
  4.114593295605444e-17, -1.167446587269830e-18,  3.030949294420748e-20, -7.264136370653412e-22,  8.551378528758892e-08, -1.926704133129850e-08,  2.259602855592691e-09,
 -1.813388991355613e-10,  1.115968774865783e-11, -5.606085197953137e-13,  2.391261715138491e-14, -8.898155650201563e-16,  2.945911127135527e-17, -8.807720683837019e-19,
  2.406043810096146e-20, -6.058846084131318e-22,  3.756126197188230e-08, -9.012535427917897e-09,  1.125276076599340e-09, -9.596853022795124e-11,  6.264037355981503e-12,
 -3.331253508608806e-13,  1.501579379247706e-14, -5.894812865676446e-16,  2.055699556895578e-17, -6.464520569189048e-19,  1.854853694887097e-20, -4.899397405074225e-22,
  1.645998228566479e-08, -4.191585260782776e-09,  5.555166419835009e-10, -5.021202620905206e-11,  3.467506270044347e-12, -1.947639709979005e-13,  9.257116815786381e-15,
 -3.826059679057758e-16,  1.402690599869503e-17, -4.630857054185305e-19,  1.393134029752969e-20, -3.853249537977097e-22,  7.219208622549508e-09, -1.944611206538939e-09,
  2.727663394885506e-10, -2.606051743390180e-11,  1.899326420177021e-12, -1.124137894552041e-13,  5.621613571186132e-15, -2.441115437707051e-16,  9.389859649091132e-18,
 -3.248324894067543e-19,  1.022729910152918e-20, -2.956904120415236e-22,  3.179458805322498e-09, -9.029733104552034e-10,  1.336657364153173e-10, -1.346296152781614e-11,
  1.032967708250863e-12, -6.427182182162132e-14,  3.374234159718957e-15, -1.536170758660218e-16,  6.187249664800125e-18, -2.238525913768085e-19,  7.362571790860535e-21,
 -2.221121065009866e-22,  1.410878394655425e-09, -4.211157772513768e-10,  6.559826417445802e-11, -6.946874453412387e-12,  5.597360943884021e-13, -3.652646325894563e-14,
  2.008641389195069e-15, -9.566980109180470e-17,  4.026529953734613e-18, -1.520566104547085e-19,  5.214541629057786e-21, -1.638440153122301e-22,  6.329842287861954e-10,
 -1.979385355596809e-10,  3.235425674619571e-11, -3.592950149250454e-12,  3.032515799008062e-13, -2.070534584314876e-14,  1.189952251198375e-15, -5.916492334547450e-17,
  2.596629920263239e-18, -1.021456954157708e-19,  3.645280365991786e-21, -1.190696690578449e-22,  2.881152445460837e-10, -9.409902911192970e-11,  1.609397539966832e-11,
 -1.869157853857216e-12,  1.648371471182905e-13, -1.174733771756883e-14,  7.039361410876238e-16, -3.645564766458854e-17,  1.664833677617793e-18, -6.808006530187481e-20,
  2.523273811338884e-21, -8.551669396478683e-23,  1.335062297954324e-10, -4.540210887744340e-11,  8.102092362810469e-12, -9.814629913106026e-13,  9.020393990330974e-14,
 -6.693406602483466e-15,  4.172172666008771e-16, -2.245448934261743e-17,  1.064674330196576e-18, -4.516313813323905e-20,  1.734884351992853e-21, -6.088475693950603e-23,
  6.319078172721552e-11, -2.230870757459011e-11,  4.141909408542772e-12, -5.219043137833610e-13,  4.986016268449512e-14, -3.842601711734468e-15,  2.485501770679510e-16,
 -1.386925236569169e-17,  6.812340565968375e-19, -2.991127554979598e-20,  1.188351934391906e-21, -4.309659439328216e-23,  3.064839801548423e-11, -1.119902868429311e-11,
  2.157086286024807e-12, -2.819530486290364e-13,  2.792550262655983e-14, -2.229531711983435e-15,  1.492809995444572e-16, -8.615982891097817e-18,  4.373945150322762e-19,
 -1.983392811016662e-20,  8.131979521012830e-22, -3.041124125389642e-23,  1.527690755755205e-11, -5.760759347447920e-12,  1.147825694607858e-12, -1.552007490910199e-13,
  1.589312729788438e-14, -1.311085053713464e-15,  9.064154443762089e-17, -5.397908593505323e-18,  2.825446121144518e-19, -1.320128941423843e-20,  5.573217491072194e-22,
 -2.144544430493717e-23,  7.845802391052068e-12, -3.044293274207358e-12,  6.256488183874039e-13, -8.726288660897740e-14,  9.213932641838005e-15, -7.832838073809143e-16,
  5.576972397179702e-17, -3.418250705359657e-18,  1.840339205915679e-19, -8.838716690348344e-21,  3.833329932583280e-22, -1.514322095612916e-23,  4.159700427726705e-12,
 -1.656005716176858e-12,  3.500118506639222e-13, -5.021313597113227e-14,  5.451540755263941e-15, -4.762830914607573e-16,  3.483200294740249e-17, -2.191657689209503e-18,
  1.210626453354094e-19, -5.962145181604548e-21,  2.650041628132277e-22, -1.072260424156512e-23,  2.279222351473029e-12, -9.283142242924600e-13,  2.011921806166964e-13,
 -2.960177494125036e-14,  3.295115049015218e-15, -2.950413794387815e-16,  2.210319437029080e-17, -1.423942946930929e-18,  8.049269398556470e-20, -4.054715402419820e-21,
  1.842513215712913e-22, -7.617764415651763e-24,  1.290413942553397e-12, -5.361856361993903e-13,  1.188049111818397e-13, -1.787440586257442e-14,  2.034127566392517e-15,
 -1.861348840976426e-16,  1.424486234849431e-17, -9.370594078046893e-19,  5.406464426535313e-20, -2.778508622875563e-21,  1.287571053563773e-22, -5.426174349129244e-24,
  7.532257675185534e-13, -3.183970528244716e-13,  7.190999533879413e-14, -1.103007420827368e-14,  1.279502040379205e-15, -1.193097567202317e-16,  9.301229842700969e-18,
 -6.230511973312934e-19,  3.659171203372769e-20, -1.913518589673965e-21,  9.019539867840311e-23, -3.864763708607816e-24,  4.507318459384733e-13, -1.932900456300297e-13,
  4.436282879557324e-14, -6.916492194319314e-15,  8.153942522901016e-16, -7.725299188022158e-17,  6.117404261074019e-18, -4.161073351814141e-19,  2.480756875505639e-20,
 -1.316494662256950e-21,  6.295383468825260e-23, -2.735669203933157e-24,  2.731759593296908e-13, -1.185166384695492e-13,  2.755870211884224e-14, -4.353858527309978e-15,
  5.200697456825296e-16, -4.991495823063204e-17,  4.003169939632141e-18, -2.757129577358095e-19,  1.663957610015437e-20, -8.936645961973662e-22,  4.323814939981264e-23,
 -1.900541239150675e-24,  1.633268926944474e-13, -7.149006195043313e-14,  1.679066525315647e-14, -2.679734506891856e-15,  3.233378501598670e-16, -3.134297527066491e-17,
  2.538355418645245e-18, -1.765076724749538e-19,  1.075285743992849e-20, -5.828386839553414e-22,  2.845448056322721e-23, -1.261763910027109e-24,  9.014583143923619e-14,
 -3.970051288014892e-14,  9.389202458485139e-15, -1.509075102239568e-15,  1.833638847264880e-16, -1.789751562153513e-17,  1.459312439546824e-18, -1.021520378523367e-19,
  6.263798629849187e-21, -3.416924161257670e-22,  1.678624977421913e-23, -7.489157960826543e-25,  3.576409183858799e-14, -1.580433530378073e-14,  3.752177860258984e-15,
 -6.054352787223199e-16,  7.385196983457000e-17, -7.236171451405259e-18,  5.922478233716656e-19, -4.161121869722304e-20,  2.560812026769730e-21, -1.401909271936234e-22,
  6.911164441759127e-24, -3.093910836598278e-25,  5.579977510580501e-02, -1.286635194381856e-04,  3.070800717743544e-07, -7.543198781411035e-10,  1.894256135172395e-12,
 -4.832229118916426e-15,  1.245367990023442e-17, -3.229309726437904e-20,  8.398782808017395e-23, -2.186517115653108e-25,  5.689198412796049e-28, -1.478377092999281e-30,
  5.345814224806038e-02, -1.547627718886845e-04,  5.272179380504738e-07, -1.871487447577561e-09,  6.599136685725256e-12, -2.283879167928782e-14,  7.752397466350511e-17,
 -2.586186505016529e-19,  8.498120856285426e-22, -2.755918395773984e-24,  8.833989031472980e-27, -2.802387459042059e-29,  4.906892849341003e-02, -1.998985950309728e-04,
  9.621293120940591e-07, -4.463423173189481e-09,  1.967818592986175e-11, -8.325924530296181e-14,  3.409294143743478e-16, -1.358885483913722e-18,  5.293508308592131e-21,
 -2.021394869180919e-23,  7.584351471471513e-26, -2.801251441548453e-28,  4.315891822552101e-02, -2.521747393831084e-04,  1.588136132857610e-06, -9.075795986709571e-09,
  4.820509049284723e-11, -2.425360159534072e-13,  1.169068141010808e-15, -5.438927472052138e-18,  2.455353511406766e-20, -1.079918728467800e-22,  4.642032826611944e-25,
 -1.955004957756977e-27,  3.638280917307708e-02, -2.984610000983110e-04,  2.347603394714532e-06, -1.614557305331224e-08,  1.015405803735703e-10, -5.976466303741727e-13,
  3.337533300443965e-15, -1.784846297753417e-17,  9.201617637704088e-20, -4.596094863750967e-22,  2.232852418082186e-24, -1.058298135806521e-26,  2.940391155607798e-02,
 -3.280403873853277e-04,  3.144104222829004e-06, -2.567041906226494e-08,  1.887457031184665e-10, -1.283767938216334e-12,  8.210164301315589e-15, -4.991852749507997e-17,
  2.908337875384722e-19, -1.633288236888937e-21,  8.881667010682792e-24, -4.693514063272758e-26,  2.279032587322674e-02, -3.350945610143410e-04,  3.856043455757258e-06,
 -3.697835754719255e-08,  3.146347889505377e-10, -2.449509377319187e-12,  1.778112228646642e-14, -1.218849701333701e-16,  7.961116060099906e-19, -4.988294812420440e-21,
  3.013953074614300e-23, -1.763179583929676e-25,  1.694800914284143e-02, -3.194005281797161e-04,  4.365505231477220e-06, -4.872241051365672e-08,  4.757003428289227e-10,
 -4.206411277257522e-12,  3.440992723770910e-14, -2.641270660688922e-16,  1.921673402710135e-18, -1.335183274764226e-20,  8.910536006762652e-23, -5.737662697010627e-25,
  1.209845089423493e-02, -2.853467394539928e-04,  4.590234300355884e-06, -5.914482219326746e-08,  6.578922563521947e-10, -6.564740157472567e-12,  6.015433583007112e-14,
 -5.141354365820799e-16,  4.144352599652026e-18, -3.176691782441177e-20,  2.330122427287212e-22, -1.643685887845992e-24,  8.295438687798289e-03, -2.399296020645164e-04,
  4.504974630851148e-06, -6.653375276279088e-08,  8.379216272853509e-10, -9.382319680993948e-12,  9.580452598359726e-14, -9.073409853672409e-16,  8.066186285768341e-18,
 -6.791141716011947e-20,  5.452106679982552e-22, -4.196207693229578e-24,  5.466886255064411e-03, -1.905745057172256e-04,  4.144071499663738e-06, -6.969924476424315e-08,
  9.883257929427193e-10, -1.235641230161503e-11,  1.399631286185150e-13, -1.462595846784533e-15,  1.428227949231223e-17, -1.315740186562343e-19,  1.151920096715501e-21,
 -9.639181931025362e-24,  3.465477942081656e-03, -1.434561940271759e-04,  3.586205023652066e-06, -6.828306045737386e-08,  1.084701382138070e-09, -1.507455684023477e-11,
  1.886412476210044e-13, -2.166828802763853e-15,  2.315913329671884e-17, -2.326596706592404e-19,  2.214102273437223e-21, -2.008118714297574e-23,  2.114855622360668e-03,
 -1.026350023466524e-04,  2.929211175878829e-06, -6.279559117404296e-08,  1.112359795594701e-09, -1.711383432543859e-11,  2.357203894921702e-13, -2.965984084226748e-15,
  3.458520596304942e-17, -3.777368006224089e-19,  3.896060447408050e-21, -3.819249639710426e-23,  1.243677422212492e-03, -6.997210478177306e-05,  2.265115871824686e-06,
 -5.439495558154684e-08,  1.069875236129316e-09, -1.815365351114381e-11,  2.742756844675554e-13, -3.768538200758448e-15,  4.780102674035832e-17, -5.660127436015337e-19,
  6.310601171653430e-21, -6.669303525175456e-23,  7.055120035071412e-04, -4.556762614959172e-05,  1.662967538326815e-06, -4.452184616498267e-08,  9.684271175687682e-10,
 -1.805921881013199e-11,  2.983430738464581e-13, -4.463193512109902e-15,  6.141409706066812e-17, -7.863763942039426e-19,  9.454146420397819e-21, -1.074669099419586e-22,
  3.865259249709940e-04, -2.841082495493555e-05,  1.162244537744662e-06, -3.453540519940169e-08,  8.276405943987837e-10, -1.690595384623645e-11,  3.044786115569272e-13,
 -4.945869084536372e-15,  7.364051628553853e-17, -1.017213078974934e-18,  1.315721933492526e-20, -1.605152940064053e-22,  2.047805702428606e-04, -1.699687638401508e-05,
  7.752749415952691e-07, -2.546057920094574e-08,  6.698575021722519e-10, -1.494132588312916e-11,  2.925394312284302e-13, -5.146425200791083e-15,  8.271607860469694e-17,
 -1.229813215943469e-18,  1.707752272768440e-20, -2.231479016291738e-22,  1.050621515859513e-04, -9.778235549163643e-06,  4.948307477565528e-07, -1.788885721557553e-08,
  5.149501649422963e-10, -1.250519439039100e-11,  2.654618592853977e-13, -5.045383139842229e-15,  8.733730053788805e-17, -1.394682632741647e-18,  2.074995128176777e-20,
 -2.898439191577620e-22,  5.227798632140412e-05, -5.421355191164640e-06,  3.029611992650160e-07, -1.201114401217201e-08,  3.770819409915784e-10, -9.941380318310126e-12,
  2.282253418527637e-13, -4.675290697014885e-15,  8.697423371032095e-17, -1.488698152924184e-18,  2.368464483511908e-20, -3.530169337360328e-22,  2.527161718590321e-05,
 -2.903189027128040e-06,  1.783751771414837e-07, -7.727561255755938e-09,  2.637689193659367e-10, -7.528996358204111e-12,  1.864626514980002e-13, -4.107807798009781e-15,
  8.195198861511726e-17, -1.500596433869021e-18,  2.548224694850023e-20, -4.045587278912252e-22,  1.188987807142369e-05, -1.505052883328686e-06,  1.012507891752251e-07,
 -4.776713429331245e-09,  1.767481357528611e-10, -5.447916884968879e-12,  1.452082352533038e-13, -3.432700529766340e-15,  7.329477506779826e-17, -1.432983259617955e-18,
  2.592683284753255e-20, -4.376903112563692e-22,  5.455133086451521e-06, -7.571116229528631e-07,  5.555202750670568e-08, -2.844660250945368e-09,  1.137790731930190e-10,
 -3.777432063628084e-12,  1.081091107414827e-13, -2.736607922931709e-15,  6.241388827971239e-17, -1.300498663281086e-18,  2.502614381845786e-20, -4.485000729818070e-22,
  2.445895318963029e-06, -3.704793018345222e-07,  2.953857502864083e-08, -1.636643757556640e-09,  7.056599031151027e-11, -2.517190932181323e-12,  7.718104562529804e-14,
 -2.087694090537683e-15,  5.076089516661498e-17, -1.125205463359499e-18,  2.299046413552995e-20, -4.366756437470286e-22,  1.074152696585322e-06, -1.767974570181800e-07,
  1.526352709419719e-08, -9.123012902591050e-10,  4.228898278817896e-11, -1.616919660790513e-12,  5.299759011106058e-14, -1.528744502254227e-15,  3.955186110754490e-17,
 -9.310402876048405e-19,  2.016428913162124e-20, -4.052637564979455e-22,  4.631835624121133e-07, -8.250146510796069e-08,  7.686467035318099e-09, -4.941478564590938e-10,
  2.456189416660669e-11, -1.004243398345670e-12,  3.511073581783672e-14, -1.077878786328913e-15,  2.961806859404970e-17, -7.390773122385151e-19,  1.693852912649711e-20,
 -3.596502424508035e-22,  1.966239507983137e-07, -3.775237175357385e-08,  3.783416897349046e-09, -2.608710236699179e-10,  1.386882866727622e-11, -6.049577756292579e-13,
  2.251286791392839e-14, -7.340885730130035e-16,  2.138358557368745e-17, -5.646525981468135e-19,  1.367141927171390e-20, -3.061791106760329e-22,  8.240013606095452e-08,
 -1.699057916193859e-08,  1.825822363382161e-09, -1.346501425819863e-10,  7.637344160088814e-12, -3.546013063638461e-13,  1.401618371232813e-14, -4.844794512487277e-16,
  1.493291362846244e-17, -4.165323933234196e-19,  1.063655579092709e-20, -2.508564796354083e-22,  3.419122741933447e-08, -7.543989305276009e-09,  8.666347006651090e-10,
 -6.817270696028212e-11,  4.115237799659703e-12, -2.029168480312719e-13,  8.501067028070415e-15, -3.108760653551945e-16,  1.012006207360280e-17, -2.976614781579669e-19,
  8.003191923807388e-21, -1.984490232533923e-22,  1.409151388898111e-08, -3.315387453418015e-09,  4.059378168220299e-10, -3.397021022266700e-11,  2.177050893445044e-12,
 -1.137452340550644e-13,  5.040063774306477e-15, -1.946053589134041e-16,  6.678225329450363e-18, -2.067569370609689e-19,  5.843174327589217e-21, -1.520847736356493e-22,
  5.787476608331339e-09, -1.447045405820489e-09,  1.882900943110840e-10, -1.671789524336004e-11,  1.134697744585720e-12, -6.267612563296373e-14,  2.931093498607829e-15,
 -1.192566822979952e-16,  4.305996744050521e-18, -1.400702011597923e-19,  4.153656097369186e-21, -1.132910710495238e-22,  2.376890790236901e-09, -6.294757686459224e-10,
  8.679452065490747e-11, -8.154940703477821e-12,  5.847774914807398e-13, -3.407072663202938e-14,  1.678041711629173e-15, -7.179739225402557e-17,  2.722362276649554e-18,
 -9.287318218613862e-20,  2.884721351907715e-21, -8.231113480363791e-23,  9.796666914651641e-10, -2.739139376530281e-10,  3.990759120787156e-11, -3.957493758564148e-12,
  2.990892019596066e-13, -1.833848609553705e-14,  9.491527183067049e-16, -4.261860942246736e-17,  1.693668304684780e-18, -6.048213578780254e-20,  1.964191843282660e-21,
 -5.852894856936199e-23,  4.067330207522395e-10, -1.196806226271382e-10,  1.837216871466943e-11, -1.917880269172788e-12,  1.523857493583654e-13, -9.810029497925391e-15,
  5.323980859503080e-16, -2.503478518601746e-17,  1.040617715729351e-18, -3.882450846233321e-20,  1.315828437654732e-21, -4.087323803745292e-23,  1.707478876229115e-10,
 -5.270847087935255e-11,  8.501227120906748e-12, -9.317365469345893e-13,  7.763874966810232e-14, -5.235322149065948e-15,  2.972535345138288e-16, -1.460646133228275e-17,
  6.337455723846032e-19, -2.465381308816145e-20,  8.703284807337919e-22, -2.813017415261329e-23,  7.276004217487818e-11, -2.348967195047494e-11,  3.969267261141940e-12,
 -4.555294747915347e-13,  3.970722023855113e-14, -2.797887249155470e-15,  1.658187724763329e-16, -8.495818987279028e-18,  3.839522418619460e-19, -1.554222924284155e-20,
  5.703755406127528e-22, -1.914560981266691e-23,  3.159383778562293e-11, -1.063426110258598e-11,  1.877305794218498e-12, -2.249917324288143e-13,  2.046321590206009e-14,
 -1.503022983785675e-15,  9.276137157600730e-17, -4.944349903928981e-18,  2.322390646114165e-19, -9.761634834908941e-21,  3.716485168856854e-22, -1.293005430796844e-23,
  1.403266781249667e-11, -4.909530783723579e-12,  9.028500272213732e-13, -1.126903845837923e-13,  1.066630651972052e-14, -8.146059539177239e-16,  5.222743119212669e-17,
 -2.889347243340270e-18,  1.407351138844274e-19, -6.129072913485547e-21,  2.415737505317621e-22, -8.693343975779146e-24,  6.398892442817776e-12, -2.319977718304421e-12,
  4.431492049050092e-13, -5.744552687213055e-14,  5.643457522838815e-15, -4.469971296064292e-16,  2.969806255126170e-17, -1.701165289558993e-18,  8.572689121473642e-20,
 -3.859545640964118e-21,  1.571399133413252e-22, -5.836732570195902e-24,  3.006011313337506e-12, -1.126011948804526e-12,  2.227559634710822e-13, -2.990507020260498e-14,
  3.040970557438307e-15, -2.491457435134953e-16,  1.710966781647206e-17, -1.012287439905915e-18,  5.265028252594578e-20, -2.444752938932940e-21,  1.025881421989913e-22,
 -3.924369857621299e-24,  1.459242715694202e-12, -5.630623759760303e-13,  1.150213132330332e-13, -1.594611157616853e-14,  1.673748580806665e-15, -1.414619229566050e-16,
  1.001505706079016e-17, -6.104547228348064e-19,  3.268899140697601e-20, -1.561727286960728e-21,  6.738469311402028e-23, -2.648698544216312e-24,  7.338314441436892e-13,
 -2.908129613351892e-13,  6.116051496851477e-14, -8.730457189505114e-15,  9.431973792090602e-16, -8.200799049689332e-17,  5.969321959487046e-18, -3.738726166789779e-19,
  2.055956975818256e-20, -1.008107921749720e-21,  4.461741002366975e-23, -1.797830882608606e-24,  3.829174220161083e-13, -1.553929432606419e-13,  3.354353231553224e-14,
 -4.915512647753797e-15,  5.450032540352213e-16, -4.860971008239571e-17,  3.627808597590029e-18, -2.328465358797377e-19,  1.311475281287807e-20, -6.583070261666410e-22,
  2.981126422594705e-23, -1.228397660213447e-24,  2.073943094874023e-13, -8.593301657113269e-14,  1.898134215181031e-14, -2.846837723316376e-15,  3.229721846877022e-16,
 -2.946430378730763e-17,  2.248209475348359e-18, -1.474637723485286e-19,  8.484005081515679e-21, -4.348084491897806e-22,  2.009485247896593e-23, -8.446287228240281e-25,
  1.163916188431099e-13, -4.909734518479045e-14,  1.106289510413132e-14, -1.692933118413768e-15,  1.959277787611200e-16, -1.822817142461458e-17,  1.417883356197342e-18,
 -9.477167386111905e-20,  5.554104769953766e-21, -2.898425700223670e-22,  1.363431329632625e-23, -5.830615115655657e-25,  6.733191909302010e-14, -2.883192053481150e-14,
  6.606467331472301e-15, -1.028287227740607e-15,  1.210270098492537e-16, -1.144797303327498e-17,  9.050935363226952e-19, -6.146949841455200e-20,  3.659162398880775e-21,
 -1.938986685197204e-22,  9.258720746926010e-24, -4.017738809285523e-25,  3.968310170832232e-14, -1.719982974719756e-14,  3.995156163843613e-15, -6.304834652036165e-16,
  7.522978613122869e-17, -7.212662588669019e-18,  5.778494372652199e-19, -3.975787715122963e-20,  2.397029165907869e-21, -1.286116548976965e-22,  6.216660033761311e-24,
 -2.729996498017748e-25,  2.321591470894389e-14, -1.015606735462307e-14,  2.383789153798928e-15, -3.801961372254184e-16,  4.584486336435649e-17, -4.441164278109899e-18,
  3.594484452623025e-19, -2.497932622759835e-20,  1.520825783787739e-21, -8.238494973785520e-23,  4.019754529881196e-24, -1.781485887948005e-25,  1.262010201219631e-14,
 -5.556274761394179e-15,  1.313618920362572e-15, -2.110581097195588e-16,  2.563635224071823e-17, -2.501429537259604e-18,  2.038915387449921e-19, -1.426776130657619e-20,
  8.745950698703061e-22, -4.769442117714911e-23,  2.342348337947970e-24, -1.044718437055933e-25,  4.964340789183615e-15, -2.193447259632731e-15,  5.206693439921445e-16,
 -8.399863713431630e-17,  1.024454038920778e-17, -1.003611537908280e-18,  8.212727829870096e-20, -5.769290650809568e-21,  3.549920491783912e-22, -1.943080138660587e-23,
  9.577515278480730e-25, -4.286880622747124e-26,  5.528997769873155e-02, -1.262425782214579e-04,  2.982069443317081e-07, -7.247689990967843e-10,  1.800528734487957e-12,
 -4.543894701301069e-15,  1.158594697277299e-17, -2.972716215794843e-20,  7.651079193459067e-23, -1.971435181401732e-25,  5.077438033464265e-28, -1.306154094983260e-30,
  5.284738690358068e-02, -1.506330988867690e-04,  5.053788530635176e-07, -1.769456783926407e-09,  6.160395559924695e-12, -2.106212852642280e-14,  7.064892584412317e-17,
 -2.329462137878008e-19,  7.566732931958339e-22, -2.426024968405247e-24,  7.689101999198786e-27, -2.412013994680585e-29,  4.828439635525207e-02, -1.924105761085163e-04,
  9.104037943122881e-07, -4.161461706229401e-09,  1.809183827709799e-11, -7.551503559932597e-14,  3.051467535692613e-16, -1.200574213956137e-18,  4.617569388330279e-21,
 -1.741296282290935e-23,  6.453097625361410e-26, -2.354495049794625e-28,  4.217495772250228e-02, -2.398925357441284e-04,  1.483698996347683e-06, -8.341846062534272e-09,
  4.362305510643158e-11, -2.162205427781375e-13,  1.027218311274067e-15, -4.711995681443624e-18,  2.098031958132617e-20, -9.103579110460992e-23,  3.861473057213273e-25,
 -1.605110549103741e-27,  3.522533759196397e-02, -2.804284223765275e-04,  2.163223614476095e-06, -1.461235920585121e-08,  9.034983233979990e-11, -5.232248782057313e-13,
  2.876629995145096e-15, -1.515231375091643e-17,  7.697168422704400e-20, -3.789547626772918e-22,  1.815153737578403e-24, -8.484476196006480e-27,  2.814017471276311e-02,
 -3.040702789420408e-04,  2.853364920070791e-06, -2.284564160461560e-08,  1.649327817357429e-10, -1.102496939912982e-12,  6.934366129136043e-15, -4.148789780278093e-17,
  2.379620139170575e-19, -1.316123432959779e-21,  7.050896124881565e-24, -3.671906636146601e-26,  2.150895006320815e-02, -3.059391720381017e-04,  3.440963485929063e-06,
 -3.231404644019108e-08,  2.696498383763020e-10, -2.060995025418616e-12,  1.469957944842014e-14, -9.906434731387615e-17,  6.364854412116041e-19, -3.924688647832756e-21,
  2.334497951157928e-23, -1.344940550737442e-25,  1.573672680249409e-02, -2.866918857585454e-04,  3.823866072847163e-06, -4.174175521667617e-08,  3.992655729621962e-10,
 -3.462791657471829e-12,  2.780765148798738e-14, -2.096827925973435e-16,  1.499511188843268e-18, -1.024575927125505e-20,  6.727046843131028e-23, -4.263197450139887e-25,
  1.102625276721370e-02, -2.512943618504316e-04,  3.939562701094943e-06, -4.959510114519191e-08,  5.399416236291679e-10, -5.279795342592219e-12,  4.745534086762205e-14,
 -3.981475751664872e-16,  3.152427449234176e-18, -2.374749945764702e-20,  1.712685109382240e-22, -1.188369879353705e-24,  7.403047240721140e-03, -2.068690007871596e-04,
  3.781200022436735e-06, -5.451138942629524e-08,  6.713521459189669e-10, -7.360827302182534e-12,  7.367313219350720e-14, -6.844674311701580e-16,  5.973144258096031e-18,
 -4.939467656457303e-20,  3.896920537190627e-22, -2.948671205111643e-24,  4.765952402115334e-03, -1.605163343720624e-04,  3.394959886108455e-06, -5.569359397436366e-08,
  7.717209602582979e-10, -9.441162831398728e-12,  1.047557274611612e-13, -1.073225123140662e-15,  1.028197961530569e-17, -9.298813231330188e-20,  7.996300317182362e-22,
 -6.575388752710905e-24,  2.944231144883378e-03, -1.177705137424778e-04,  2.861734302512645e-06, -5.311299425550169e-08,  8.239718288778459e-10, -1.119864625459941e-11,
  1.371987125343312e-13, -1.544246837763492e-15,  1.618518327317716e-17, -1.595504969758452e-19,  1.490732558110295e-21, -1.328106693325155e-23,  1.746805731835639e-03,
 -8.193708703121710e-05,  2.272079108546747e-06, -4.745480571020321e-08,  8.205258286368523e-10, -1.233962136157494e-11,  1.663194839319144e-13, -2.049763750597235e-15,
  2.342879698462685e-17, -2.509937114740610e-19,  2.540777477755425e-21, -2.445753749949712e-23,  9.962740165820711e-04, -5.419656577512874e-05,  1.704170521771202e-06,
 -3.985687269431434e-08,  7.649006092837576e-10, -1.268163579431469e-11,  1.874248965573835e-13, -2.521428605048917e-15,  3.133925311697171e-17, -3.638756616050144e-19,
  3.980473132269566e-21, -4.129678042592121e-23,  5.468039492970185e-04, -3.416264054472134e-05,  1.210908343088597e-06, -3.156625325111327e-08,  6.697680760408389e-10,
 -1.220030541970477e-11,  1.971025478771790e-13, -2.886260613424710e-15,  3.890637552721261e-17, -4.883710369544549e-19,  5.759392313274741e-21, -6.425475267283945e-23,
  2.891407673019036e-04, -2.056878307561587e-05,  8.172833627218667e-07, -2.364376232097772e-08,  5.526239637574250e-10, -1.102451534039796e-11,  1.941313268819132e-13,
 -3.086100969557880e-15,  4.500544931743275e-17, -6.093246164790545e-19,  7.729690534491568e-21, -9.253839269219054e-23,  1.474925920494166e-04, -1.185503890727127e-05,
  5.253067514362740e-07, -1.679609380534632e-08,  4.309563089692174e-10, -9.387107834913302e-12,  1.796797777402970e-13, -3.093142113520460e-15,  4.868731817001028e-17,
 -7.094246505226425e-19,  9.660699392611407e-21, -1.238633859528730e-22,  7.268219614207810e-05, -6.555164464618574e-06,  3.223488050502660e-07, -1.134721607993825e-08,
  3.185685145875145e-10, -7.554775280856413e-12,  1.567822641949409e-13, -2.915780411701045e-15,  4.942838418839538e-17, -7.735301267440901e-19,  1.128548942409832e-20,
 -1.546752622088496e-22,  3.465416591048172e-05, -3.485011609448542e-06,  1.893207925399511e-07, -7.310274024480249e-09,  2.238616846452641e-10, -5.764035472785805e-12,
  1.293710880440218e-13, -2.593402721307370e-15,  4.724824901657525e-17, -7.925789200338712e-19,  1.236570874848877e-20, -1.808491001974843e-22,  1.601354501060338e-05,
 -1.785404292175049e-06,  1.066894533714528e-07, -4.503101985602258e-09,  1.499663096189863e-10, -4.181436764338865e-12,  1.012607408696244e-13, -2.183257546607554e-15,
  4.266182547798871e-17, -7.656529153611749e-19,  1.275166740288533e-20, -1.986660178411578e-22,  7.184975237009074e-06, -8.834487529029791e-07,  5.783676737530373e-08,
 -2.659516391870380e-09,  9.604521208531946e-11, -2.892618373507160e-12,  7.540796271463708e-14, -1.745019758705658e-15,  3.650121417116184e-17, -6.995885009662444e-19,
  1.241616650356839e-20, -2.057267722108281e-22,  3.136459671865778e-06, -4.232315717562919e-07,  3.023994784412264e-08, -1.510095098563991e-09,  5.897519651783682e-11,
 -1.913827579099082e-12,  5.358887532224749e-14, -1.328284415952812e-15,  2.968572300033836e-17, -6.065330602755735e-19,  1.145198278998579e-20, -2.014824671705250e-22,
  1.334980854244257e-06, -1.967946588975829e-07,  1.529056317208075e-08, -8.266906085678006e-10,  3.482095231119721e-11, -1.214665344976732e-12,  3.645304893191259e-14,
 -9.658688569508992e-16,  2.302074659787305e-17, -5.005444341647403e-19,  1.003775729383950e-20, -1.872264444196622e-22,  5.553315561565057e-07, -8.904885317344113e-08,
  7.498010250014546e-09, -4.376045305658708e-10,  1.982833856565820e-11, -7.417789538539702e-13,  2.380872317856728e-14, -6.730363659755289e-16,  1.707625870876211e-17,
 -3.944470106527315e-19,  8.387784961363925e-21, -1.656081255061347e-22,  2.263459651775757e-07, -3.932107015057128e-08,  3.576137554637512e-09, -2.246610255151200e-10,
  1.092299681422322e-11, -4.372319173538730e-13,  1.497792138144649e-14, -4.508514478707272e-16,  1.215507270726058e-17, -2.977758857094199e-19,  6.703710107255046e-21,
 -1.398905163482651e-22,  9.064004699914114e-08, -1.699311217499386e-08,  1.663989200389014e-09, -1.122116974604153e-10,  5.839658466172985e-12, -2.495539210481079e-13,
  9.105129877114384e-15, -2.912834083889363e-16,  8.329733696534659e-18, -2.160554369421732e-19,  5.141172019125779e-21, -1.132164436514635e-22,  3.576541101553850e-08,
 -7.209589877987843e-09,  7.577733349361369e-10, -5.470486058907430e-11,  3.039862820569762e-12, -1.383800881268338e-13,  5.366452898316692e-15, -1.821106924977312e-16,
  5.513962957556040e-18, -1.511697592697924e-19,  3.796076135369318e-21, -8.808239512471940e-23,  1.394944800089552e-08, -3.012671186084703e-09,  3.388682488297794e-10,
 -2.611942606115087e-11,  1.546061240026983e-12, -7.480505840456076e-14,  3.077147483756485e-15, -1.105565348449234e-16,  3.537887623426273e-18, -1.023462393865351e-19,
  2.707762719431358e-21, -6.609935659060848e-23,  5.395638930784902e-09, -1.244187577674735e-09,  1.493288168932310e-10, -1.225705376978168e-11,  7.709889140273905e-13,
 -3.956223656482664e-14,  1.722705621336723e-15, -6.540324402219004e-17,  2.208009343596624e-18, -6.728317278160675e-20,  1.872404569611429e-21, -4.801022982121696e-23,
  2.077051560558281e-09, -5.096576086966528e-10,  6.508261681529530e-11, -5.674026960064697e-12,  3.783722484929619e-13, -2.054573061636028e-14,  9.450777074813671e-16,
 -3.784101428465348e-17,  1.345259294365758e-18, -4.310499836747323e-20,  1.259643560432549e-21, -3.387116607772885e-23,  7.986909739861816e-10, -2.078594032291201e-10,
  2.816114275076345e-11, -2.600997526910760e-12,  1.834419400345497e-13, -1.051731455974089e-14,  5.099866778593087e-16, -2.149329506155288e-17,  8.031055050942122e-19,
 -2.701049441669214e-20,  8.274364206059561e-22, -2.329425525534428e-23,  3.079801226115541e-10, -8.473632593445180e-11,  1.214559691805627e-11, -1.185362185651093e-12,
  8.820618874709551e-14, -5.327610028355375e-15,  2.717517808245894e-16, -1.203069214456369e-17,  4.715772752179542e-19, -1.661703946113641e-20,  5.326875843671860e-22,
 -1.567403723058578e-23,  1.195729509400532e-10, -3.466984484875316e-11,  5.242613944220068e-12, -5.392582904426405e-13,  4.223589026451251e-14, -2.681329880606993e-15,
  1.435608416726004e-16, -6.662435025394493e-18,  2.734212114915858e-19, -1.007519146134798e-20,  3.373649737115916e-22, -1.035715738643143e-23,  4.693756351324444e-11,
 -1.429692598000095e-11,  2.274374729284911e-12, -2.459190799725834e-13,  2.022303151121022e-14, -1.346291543859993e-15,  7.549332690178532e-17, -3.664925716580253e-18,
  1.571521493381067e-19, -6.043866646335230e-21,  2.109955186110164e-22, -6.746165478747540e-24,  1.870844465051273e-11, -5.967684623010923e-12,  9.959079710965880e-13,
 -1.128966804544103e-13,  9.723389246312125e-15, -6.771753093741186e-16,  3.967956200569217e-17, -2.010651328239157e-18,  8.989557286281481e-20, -3.601056954651384e-21,
  1.308139074109277e-22, -4.347719763011899e-24,  7.604255857657141e-12, -2.532344930055928e-12,  4.420697933029022e-13, -5.239829888741400e-14,  4.714402452995156e-15,
 -3.426422301007233e-16,  2.093085896609790e-17, -1.104571076883232e-18,  5.138077129626708e-20, -2.139345267855596e-21,  8.070333862917974e-23, -2.782728545222854e-24,
  3.165500839400526e-12, -1.097148705789072e-12,  1.997723515162219e-13, -2.469092858223180e-14,  2.314644848490713e-15, -1.751218953219619e-16,  1.112550550737475e-17,
 -6.100333565356994e-19,  2.945716397997921e-20, -1.272085905320208e-21,  4.972784861409439e-23, -1.775265878061085e-24,  1.355238630602011e-12, -4.873718275438199e-13,
  9.229184215564290e-14, -1.186118662842276e-14,  1.155442391100944e-15, -9.076649152816044e-17,  5.982144743095911e-18, -3.399955269816243e-19,  1.700316212455218e-20,
 -7.598366618483136e-22,  3.071317795126890e-23, -1.132787512579726e-24,  5.991094261528844e-13, -2.228650162923395e-13,  4.376133349802705e-14, -5.831478671689177e-15,
  5.886766618475618e-16, -4.788734173821359e-17,  3.265783132055349e-18, -1.919129420280440e-19,  9.915867024662855e-21, -4.574752156254942e-22,  1.907669933642179e-23,
 -7.253103790392497e-25,  2.744653567241256e-13, -1.052902826244646e-13,  2.137349421544438e-14, -2.944552370455501e-15,  3.071620342867258e-16, -2.580407559246008e-17,
  1.816085350182794e-18, -1.100610618641248e-19,  5.860595954727106e-21, -2.784624971655779e-22,  1.195098249426470e-23, -4.673247204893065e-25,  1.307043679469125e-13,
 -5.155063166181858e-14,  1.078529019120272e-14, -1.531560807262526e-15,  1.646157066960761e-16, -1.424108315622482e-17,  1.031527136978507e-18, -6.429832547039255e-20,
  3.519342714636462e-21, -1.717814732005061e-22,  7.569102819638765e-24, -3.036769519258571e-25,  6.484436632197152e-14, -2.621450211367421e-14,  5.635091632806886e-15,
 -8.223100046601116e-16,  9.079592603870832e-17, -8.065422392134811e-18,  5.995496241933991e-19, -3.833258360240179e-20,  2.150882563702825e-21, -1.075680895212887e-22,
  4.853700157644151e-24, -1.993017769814214e-25,  3.354460009236940e-14, -1.385811200847640e-14,  3.051090784088879e-15, -4.561066557976552e-16,  5.157781457287345e-17,
 -4.690459690908616e-18,  3.567859732083031e-19, -2.333132661690824e-20,  1.338349264767021e-21, -6.839304168259684e-23,  3.151914999058422e-24, -1.321186106232574e-25,
  1.807286354182185e-14, -7.606965012769969e-15,  1.709875720689973e-15, -2.610172833506318e-16,  3.013505444672648e-17, -2.796953372822775e-18,  2.170555724481488e-19,
 -1.447505748297438e-20,  8.464284122806596e-22, -4.407533539796323e-23,  2.068933210952628e-24, -8.829410872464720e-26,  1.009359042349796e-14, -4.315471716238173e-15,
  9.871327298254740e-16, -1.533785898321407e-16,  1.802124901937718e-17, -1.701754163696755e-18,  1.343205873488141e-19, -9.107634922509301e-21,  5.413031084476176e-22,
 -2.863930638988275e-23,  1.365473170688375e-24, -5.916645597517006e-26,  5.778115817136082e-15, -2.501878045099252e-15,  5.804748385726089e-16, -9.150084916403396e-17,
  1.090555751511784e-17, -1.044404235173286e-18,  8.358191794474786e-20, -5.744544749664647e-21,  3.459798663057375e-22, -1.854441535729192e-23,  8.954788598771893e-25,
 -3.928591062792411e-26,  3.304661534031656e-15, -1.444797299654717e-15,  3.388880474710309e-16, -5.401309401167833e-17,  6.508597121619316e-18, -6.300912672992662e-19,
  5.096341755177348e-20, -3.539351425178006e-21,  2.153521861949146e-22, -1.165870620605973e-23,  5.685130127884814e-25, -2.518071471878680e-26,  1.768085783282112e-15,
 -7.781961900162676e-16,  1.839169491404716e-16, -2.953919974613951e-17,  3.586724787158404e-18, -3.498462484248808e-19,  2.850609413202438e-20, -1.994098203256848e-21,
  1.221947730614631e-22, -6.661481046609538e-24,  3.270506357713606e-25, -1.458230384659433e-26,  6.893416877244875e-16, -3.045332773399790e-16,  7.227614333414514e-17,
 -1.165812927322542e-17,  1.421584707179146e-18, -1.392419519967903e-19,  1.139244342389378e-20, -8.001617195729407e-22,  4.922671320737150e-23, -2.694019708889142e-24,
  1.327674881009734e-25, -5.941694244971121e-27,  5.478972429693012e-02, -1.238912286448939e-04,  2.896796163081333e-07, -6.966727325300593e-10,  1.712365449038883e-12,
 -4.275550057788606e-15,  1.078682363520732e-17, -2.738856134192228e-20,  6.976577022747489e-23, -1.779373583395205e-25,  4.536617226777303e-28, -1.155417396869262e-30,
  5.225280841509121e-02, -1.466733577870082e-04,  4.847231611032788e-07, -1.674170438767407e-09,  5.755594215415311e-12, -1.944216673066450e-14,  6.445270333521723e-17,
 -2.100727131333647e-19,  6.746261125407336e-22, -2.138669108977954e-24,  6.702902313333354e-27, -2.079449349630156e-29,  4.752901103955986e-02, -1.853222871891056e-04,
  8.621544888064968e-07, -3.883687924437940e-09,  1.665213378213110e-11, -6.857877122122374e-14,  2.735085455521451e-16, -1.062363250799329e-18,  4.034773293261460e-21,
 -1.502749025023999e-23,  5.501299753048033e-26, -1.983099926902921e-28,  4.123850911181114e-02, -2.284118070832871e-04,  1.387646170934083e-06, -7.677176506062493e-09,
  3.953486944675897e-11, -1.930775939768161e-13,  9.042094094869995e-16, -4.090213810437487e-18,  1.796484457144701e-20, -7.691451812303293e-23,  3.219829464919631e-25,
 -1.321160375746270e-27,  3.413715861663255e-02, -2.638002231755763e-04,  1.996215327945729e-06, -1.324686614262607e-08,  8.054274725008555e-11, -4.590107281803516e-13,
  2.484893453906524e-15, -1.289418349723114e-17,  6.455101585140150e-20, -3.132976352077282e-22,  1.479796928538334e-24, -6.822435141598249e-27,  2.696787236342373e-02,
 -2.822967076091632e-04,  2.594351367541599e-06, -2.037445421989110e-08,  1.444572643553315e-10, -9.491935246976652e-13,  5.872559635896086e-15, -3.457977689099683e-17,
  1.952916148191002e-19, -1.063929614649515e-21,  5.616212244422864e-24, -2.882698465053908e-26,  2.033789248996362e-02, -2.798922063209870e-04,  3.077780666729340e-06,
 -2.831114327487892e-08,  2.317445222184736e-10, -1.739313590737115e-12,  1.219090365065469e-14, -8.078817911577391e-17,  5.106703556951830e-19, -3.099326822275828e-21,
  1.815216097475004e-23, -1.030039387778519e-25,  1.464811540690850e-02, -2.580009985760893e-04,  3.359121293673267e-06, -3.587319435426347e-08,  3.362346570188616e-10,
 -2.860762324671839e-12,  2.255636469848323e-14, -1.671152553686702e-16,  1.174894299639111e-18, -7.895847023054549e-21,  5.101124703073759e-23, -3.182172874864411e-25,
  1.008053633666657e-02, -2.220192022411770e-04,  3.392961785557403e-06, -4.174251560965002e-08,  4.448877246948726e-10, -4.263990648338873e-12,  3.759984050805845e-14,
 -3.097221803842456e-16,  2.409186986879031e-18, -1.783897079598699e-20,  1.265186738376888e-22, -8.636333120713563e-25,  6.632171369052361e-03, -1.790639346576079e-04,
  3.186949291814196e-06, -4.485756527043763e-08,  5.403698056410058e-10, -5.802595767466307e-12,  5.693675212929867e-14, -5.190064228652425e-16,  4.446816210644569e-18,
 -3.612430587537753e-20,  2.801099365854900e-22, -2.084061876347142e-24,  4.174252189605424e-03, -1.358335509092449e-04,  2.794906902554292e-06, -4.472962894535753e-08,
  6.057847883376196e-10, -7.253335071754708e-12,  7.884943656723579e-14, -7.921146275505484e-16,  7.446590192176125e-18, -6.612325800905438e-20,  5.585862889834359e-22,
 -4.514396187544799e-24,  2.515195594304181e-03, -9.721787123919670e-05,  2.296630313046965e-06, -4.155603370168262e-08,  6.297056023545245e-10, -8.371140932922283e-12,
  1.004231477025712e-13, -1.107767431517889e-15,  1.138725872102210e-17, -1.101654131752792e-19,  1.010725277582918e-21, -8.846403443823852e-24,  1.452096101322806e-03,
 -6.583254001851092e-05,  1.773900433461283e-06, -3.610194125913647e-08,  6.094060171970367e-10, -8.959652433333715e-12,  1.181923484700378e-13, -1.426928634208220e-15,
  1.598946468138773e-17, -1.680425395411335e-19,  1.669731808964361e-21, -1.578485660645203e-23,  8.039955314937177e-04, -4.228607814694932e-05,  1.291679313871212e-06,
 -2.942523268376200e-08,  5.510693083553941e-10, -8.928402899146014e-12,  1.290956641045847e-13, -1.700671822084647e-15,  2.071543605896534e-17, -2.358771614865379e-19,
  2.531948785441734e-21, -2.579030045017907e-23,  4.273635754772770e-04, -2.582537846508643e-05,  8.891219901227372e-07, -2.257013074489757e-08,  4.671840631720000e-10,
 -8.313724923176075e-12,  1.313618321088060e-13, -1.883098012161954e-15,  2.486948647985853e-17, -3.060603755058889e-19,  3.540884272169612e-21, -3.877553866949672e-23,
  2.183372644280841e-04, -1.503035044173835e-05,  5.800801915541888e-07, -1.633924599874695e-08,  3.724881295964921e-10, -7.257870804054297e-12,  1.249686121197026e-13,
 -1.944379434860734e-15,  2.777494773167930e-17, -3.686048992462253e-19,  4.586383882478676e-21, -5.388542128851772e-23,  1.073492702294770e-04, -8.354457744606794e-06,
  3.596154632362868e-07, -1.119498497857391e-08,  2.801407057639162e-10, -5.959209721455041e-12,  1.115200153629746e-13, -1.878705645507390e-15,  2.896227051395394e-17,
 -4.136092489957859e-19,  5.523757786632226e-21, -6.949605774682602e-23,  5.086544073404215e-05, -4.444670568639897e-06,  2.123721196596658e-07, -7.279283797023055e-09,
  1.993126581359308e-10, -4.615886818533895e-12,  9.364961648623166e-14, -1.704290412080227e-15,  2.829411656121392e-17, -4.339478719767153e-19,  6.208656921058370e-21,
 -8.349617768545703e-23,  2.326332787574539e-05, -2.268224515122935e-06,  1.197696913118684e-07, -4.503955203693645e-09,  1.345305897617123e-10, -3.382964107286820e-12,
  7.423343657295109e-14, -1.456201225690152e-15,  2.598207697250472e-17, -4.271451493953599e-19,  6.535410889285224e-21, -9.378722969131991e-23,  1.028689784680875e-05,
 -1.112837580562246e-06,  6.466621471848637e-08, -2.658930802549636e-09,  8.638928710843268e-11, -2.352819473282621e-12,  5.571203476043991e-14, -1.175564017585585e-15,
  2.249863486233417e-17, -3.957572104524747e-19,  6.464252761532458e-21, -9.882835303870625e-23,  4.406244377981517e-06, -5.261188002203408e-07,  3.351204253400583e-08,
 -1.501785469306121e-09,  5.292763547762465e-11, -1.557402853259010e-12,  3.970652617375813e-14, -8.994096573240974e-16,  1.842941880396665e-17, -3.462532508556090e-19,
  6.027768619628541e-21, -9.802303312546913e-23,  1.831920225606928e-06, -2.402660610318051e-07,  1.671324928109078e-08, -8.137689454774702e-10,  3.102684229814725e-11,
 -9.840521193388323e-13,  2.695572867977348e-14, -6.541746893519654e-16,  1.432524688636946e-17, -2.869815680185108e-19,  5.316080088436462e-21, -9.181355751074639e-23,
  7.408996241361968e-07, -1.062576985999152e-07,  8.043451001164182e-09, -4.242533706369480e-10,  1.745428209290147e-11, -5.953140322438350e-13,  1.748422684837369e-14,
 -4.537377676921123e-16,  1.059974749293093e-17, -2.260442268080190e-19,  4.448590010694813e-21, -8.147624457641178e-23,  2.921939797999063e-07, -4.563009677752987e-08,
  3.746111953972488e-09, -2.134333801111327e-10,  9.451268216366645e-12, -3.458783502039911e-13,  1.086938543361310e-14, -3.010671383068207e-16,  7.489916196643335e-18,
 -1.697494980393008e-19,  3.543690148555890e-21, -6.872529131228227e-23,  1.126610921409213e-07, -1.908083178845484e-08,  1.693438454549029e-09, -1.039311147538538e-10,
  4.941538315863997e-12, -1.936106125367542e-13,  6.497105253001190e-15, -1.917223184002102e-16,  5.070588047446418e-18, -1.219320334132997e-19,  2.695974416583219e-21,
 -5.528311935957849e-23,  4.258833210553168e-08, -7.793004436958920e-09,  7.453621807318105e-10, -4.914362379211216e-11,  2.502833307746988e-12, -1.047589869701201e-13,
  3.746521909192334e-15, -1.175644492677081e-16,  3.299792114742056e-18, -8.405636993803964e-20,  1.965409181785131e-21, -4.255101034531581e-23,  1.583212945738536e-08,
 -3.118613251289367e-09,  3.204830620795921e-10, -2.264041646977901e-11,  1.232176469284405e-12, -5.497847646224205e-14,  2.091307220892373e-15, -6.965668343550666e-17,
  2.071336641055737e-18, -5.580254575315715e-20,  1.377690137852473e-21, -3.144482209667085e-23,  5.806783286477644e-09, -1.226985391892414e-09,  1.350796037909179e-10,
 -1.019823359012643e-11,  5.917303125832648e-13, -2.808515206962490e-14,  1.134050419239130e-15, -4.001973662873229e-17,  1.258598670314209e-18, -3.580128189818878e-20,
  9.318266573066064e-22, -2.238857068256305e-23,  2.108599772652665e-09, -4.763203154001585e-10,  5.601560194298338e-11, -4.508071024872538e-12,  2.782226261087333e-13,
 -1.401688044825276e-14,  5.996194689411506e-16, -2.237728658594300e-17,  7.429930240656392e-19, -2.227833386485481e-20,  6.103390672202467e-22, -1.541336490470097e-23,
  7.609022838199401e-10, -1.831433322253937e-10,  2.294208213801191e-11, -1.963180730557351e-12,  1.285754441790528e-13, -6.861058570667113e-15,  3.103232182971299e-16,
 -1.222412574096792e-17,  4.277458086392753e-19, -1.349693221900328e-20,  3.885737622777739e-22, -1.029818825516045e-23,  2.739374207833958e-10, -7.002536603992369e-11,
  9.317811283936849e-12, -8.456465328210487e-13,  5.863698234811017e-14, -3.307028322563708e-15,  1.578255238423482e-16, -6.549672129587711e-18,  2.410947527580035e-19,
 -7.991625384617987e-21,  2.413808278382744e-22, -6.702826979932958e-24,  9.880221929481386e-11, -2.673736392842287e-11,  3.768644231220289e-12, -3.618316060909815e-13,
  2.650049156462997e-14, -1.576154458137376e-15,  7.920539829851357e-17, -3.456079093857061e-18,  1.335798566017532e-19, -4.643134637373847e-21,  1.468807694205461e-22,
 -4.266501977759780e-24,  3.585639225374215e-11, -1.023972138271186e-11,  1.524594042544337e-12, -1.544587838986464e-13,  1.192038783054582e-14, -7.460036445664894e-16,
  3.939064077297219e-17, -1.803570436671122e-18,  7.305395223201753e-20, -2.657885132731302e-21,  8.790353614724892e-23, -2.666382525040476e-24,  1.315281107971270e-11,
 -3.951323188890188e-12,  6.197184707660484e-13, -6.607956770115684e-14,  5.360709543997013e-15, -3.521950584246350e-16,  1.949780244646466e-17, -9.348337714386884e-19,
  3.960354537416555e-20, -1.505284661117296e-21,  5.195242264421004e-23, -1.642699891613326e-24,  4.899488675578199e-12, -1.543536960263118e-12,  2.542909161166033e-13,
 -2.846277495176875e-14,  2.421215817672216e-15, -1.666030673684900e-16,  9.648522897613477e-18, -4.833757407698911e-19,  2.137357935414630e-20, -8.470146151780227e-22,
  3.044824588569956e-23, -1.001716394521126e-24,  1.862218625974088e-12, -6.133145732252760e-13,  1.058328692899692e-13, -1.240159350626225e-14,  1.103396526376818e-15,
 -7.932630616098498e-17,  4.794715533763117e-18, -2.504346354053199e-19,  1.153314389345187e-20, -4.755445725725061e-22,  1.776958878662993e-23, -6.070817103941494e-25,
  7.256664201576058e-13, -2.490703361301689e-13,  4.488755327504815e-14, -5.491664505565710e-15,  5.097083506583467e-16, -3.819065721651149e-17,  2.403403827648792e-18,
 -1.305751298136895e-19,  6.248910336624043e-21, -2.675095464546120e-22,  1.036886580797254e-23, -3.671183583697668e-25,  2.912877170000619e-13, -1.038690209388618e-13,
  1.949297901342812e-14, -2.482895355433762e-15,  2.397570815607028e-16, -1.867382047242662e-17,  1.220517462086094e-18, -6.880724337957811e-20,  3.413947513867394e-21,
 -1.513920699436975e-22,  6.073652421674067e-24, -2.223852080385909e-25,  1.209935405855454e-13, -4.468390275452371e-14,  8.706208756960532e-15, -1.151224617888223e-15,
  1.153355645258577e-16, -9.312973562166288e-18,  6.305451550543857e-19, -3.679378360434821e-20,  1.888082338843865e-21, -8.652756708347094e-23,  3.584768700275173e-24,
 -1.354348997110996e-25,  5.222638073503659e-14, -1.991357856668652e-14,  4.015917582777741e-15, -5.496432176275452e-16,  5.696791787721633e-17, -4.755700617673546e-18,
  3.326534468527511e-19, -2.003945034920272e-20,  1.060855224133863e-21, -5.011960805469734e-23,  2.139113196939790e-24, -8.319632770824980e-26,  2.351270984999050e-14,
 -9.227354996419529e-15,  1.920060912972904e-15, -2.711782765995167e-16,  2.899124804818803e-17, -2.494958389346057e-18,  1.797956432099240e-19, -1.115143660076406e-20,
  6.074063608290275e-22, -2.950758157762716e-23,  1.294174325104938e-24, -5.168994693346878e-26,  1.107207828154025e-14, -4.458236395878470e-15,  9.541590372628389e-16,
 -1.386268091731321e-16,  1.524045166718763e-17, -1.348084264022516e-18,  9.979660012517797e-20, -6.354810377259690e-21,  3.551715087158258e-22, -1.769432894250165e-23,
  7.954156656931345e-25, -3.254221842788793e-26,  5.461671570697768e-15, -2.249381542861494e-15,  4.935504675529635e-16, -7.352786158822442e-17,  8.286624526748504e-18,
 -7.510838044005911e-19,  5.694705116452244e-20, -3.712158802529227e-21,  2.122821039186535e-22, -1.081546865705514e-23,  4.969691738659421e-25, -2.077184055766252e-26,
  2.820564870491341e-15, -1.184463989616543e-15,  2.655622969998894e-16, -4.043468662818929e-17,  4.656435232607572e-18, -4.311064645239929e-19,  3.337424898168177e-20,
 -2.220375825015260e-21,  1.295348199768857e-22, -6.729862830529972e-24,  3.152064493998866e-25, -1.342283129434607e-26,  1.518668632908425e-15, -6.482499131063928e-16,
  1.480147152844638e-16, -2.295629006904072e-17,  2.692392676697039e-18, -2.537938716783644e-19,  1.999741691906181e-20, -1.353632722838908e-21,  8.031870373583210e-23,
 -4.242642945963617e-24,  2.019628896710963e-25, -8.737687154034188e-27,  8.433972522443688e-16, -3.647975164964848e-16,  8.453818746052692e-17, -1.330983011011979e-17,
  1.584449368403155e-18, -1.515622785100903e-19,  1.211538226183118e-20, -8.317512827560138e-22,  5.003946641557967e-23, -2.679228855525298e-24,  1.292401661976655e-25,
 -5.664169513725659e-27,  4.710960487035675e-16, -2.058340524125382e-16,  4.824584019869380e-17, -7.684078631624341e-18,  9.252772458490942e-19, -8.951268277388439e-20,
  7.235057952626428e-21, -5.021293248671663e-22,  3.053203711149397e-23, -1.651876610479896e-24,  8.049974040751530e-26, -3.563327149329386e-27,  2.479022982253235e-16,
 -1.090750611031239e-16,  2.576906248158512e-17, -4.137265431526573e-18,  5.021707539262541e-19, -4.896338121101097e-20,  3.988185070707057e-21, -2.788883203783864e-22,
  1.708383891022397e-23, -9.310125938258458e-25,  4.569351016688596e-26, -2.036684037137198e-27,  9.575709987280945e-17, -4.229643216631995e-17,  1.003660929802946e-17,
 -1.618609975643297e-18,  1.973364805532014e-19, -1.932531677500646e-20,  1.580869877910988e-21, -1.110147524752935e-22,  6.828549329715955e-24, -3.736406292785567e-25,
  1.841076405202181e-26, -8.237935114027475e-28,  5.429874195817749e-02, -1.216067726509146e-04,  2.814811535997169e-07, -6.699451636116762e-10,  1.629382447412445e-12,
 -4.025622370240568e-15,  1.005026039126978e-17, -2.525514335670470e-20,  6.367477754857168e-23, -1.607675104180700e-25,  4.057925427286155e-28, -1.023314064116208e-30,
  5.167374548942950e-02, -1.428743961734201e-04,  4.651730879402146e-07, -1.585109588569525e-09,  5.381755396813744e-12, -1.796351616818046e-14,  5.886168421021058e-17,
 -1.896665415963752e-19,  6.022475718059541e-22, -1.887984192616395e-24,  5.852005649877546e-27, -1.795638744520499e-29,  4.680122746218850e-02, -1.786070408903730e-04,
  8.171047048514250e-07, -3.627879589643689e-09,  1.534386430337812e-11, -6.235741554228543e-14,  2.454915561006467e-16, -9.414981290909590e-19,  3.531377522984460e-21,
 -1.299196617737548e-23,  4.698844002850304e-26, -1.673681864238368e-28,  4.034649556068038e-02, -2.176686747097810e-04,  1.299191684845751e-06, -7.074369722910063e-09,
  3.588137640546990e-11, -1.726883914607118e-13,  7.973324966141917e-16, -3.557265197006705e-18,  1.541439701317446e-20, -6.512636241397985e-23,  2.691063831055066e-25,
 -1.090121237979928e-27,  3.311292044170347e-02, -2.484451197367206e-04,  1.844692261501887e-06, -1.202850228483261e-08,  7.193082665480013e-11, -4.034823416380584e-13,
  2.151157775039396e-15, -1.099814854169629e-17,  5.426918947564432e-20, -2.596988072789231e-22,  1.209753182445454e-24, -5.502002101674609e-27,  2.587870032649152e-02,
 -2.624819727016205e-04,  2.363123282382375e-06, -1.820766806946442e-08,  1.268078861235151e-10, -8.191986236819877e-13,  4.986353863204009e-15, -2.890227566849422e-17,
  1.607457747216771e-19, -8.627349062077770e-22,  4.488039970092485e-24, -2.270829416078006e-26,  1.926550213837156e-02, -2.565684055175090e-04,  2.759195944698484e-06,
 -2.486636130964231e-08,  1.997099631730152e-10, -1.472128444126250e-12,  1.014179141203027e-14, -6.610021220353772e-17,  4.111409869489549e-19, -2.456393131917409e-21,
  1.416769769751824e-23, -7.919652605710666e-26,  1.366725460311977e-02, -2.327626505895915e-04,  2.959124493370316e-06, -3.092326604823187e-08,  2.840748117083757e-10,
 -2.371561097175421e-12,  1.836341454250891e-14, -1.336986817443626e-16,  9.242302912338517e-19, -6.110223335392548e-21,  3.884900639800938e-23, -2.385892090507992e-25,
  9.243737161078005e-03, -1.967643159923442e-04,  2.932097712595736e-06, -3.526031941991007e-08,  3.679720498494207e-10, -3.457509739352802e-12,  2.991694632978022e-14,
 -2.419964955151971e-16,  1.849605150287968e-18, -1.346406523085784e-20,  9.391929143712520e-23, -6.308065452940869e-25,  5.963694096791643e-03, -1.555828838529577e-04,
  2.696931961440007e-06, -3.707048449089128e-08,  4.368838750825768e-10, -4.595548732315538e-12,  4.421567844455838e-14, -3.955209338963601e-16,  3.327709565374928e-18,
 -2.656067269651118e-20,  2.024524285292378e-22, -1.481313916605069e-24,  3.672455928349709e-03, -1.154669370370400e-04,  2.311833056914938e-06, -3.610186949164867e-08,
  4.779757959029420e-10, -5.602226689414086e-12,  5.967707209999673e-14, -5.879592230920795e-16,  5.424638147024141e-18, -4.730218824982008e-20,  3.926057527466590e-22,
 -3.118929246799890e-24,  2.160137978255708e-03, -8.068016128180667e-05,  1.853281751739376e-06, -3.269902429878552e-08,  4.840701356422827e-10, -6.295422248124575e-12,
  7.396244669625320e-14, -7.997305262628012e-16,  8.064002432614861e-18, -7.657486576900850e-20,  6.899566790976220e-22, -5.933553223759361e-24,  1.214621841284588e-03,
 -5.322115209388108e-05,  1.393731229109813e-06, -2.764347801490563e-08,  4.556195251043236e-10, -6.549826635356142e-12,  8.457676891722380e-14, -1.000414631015004e-15,
  1.099154225791073e-17, -1.133379831272864e-19,  1.105562892166364e-21, -1.026549197640602e-23,  6.534767741690151e-04, -3.322771666323554e-05,  9.860905295388580e-07,
 -2.188326423384921e-08,  3.999832994446010e-10, -6.333824348185160e-12,  8.960827328502943e-14, -1.156120754515098e-15,  1.380267557747174e-17, -1.541471597144577e-19,
  1.623838848226407e-21, -1.624102640872928e-23,  3.367367221932075e-04, -1.968030157617075e-05,  6.581525504443973e-07, -1.627051647853790e-08,  3.285904071536748e-10,
 -5.713114044781687e-12,  8.829733633128928e-14, -1.239253502881568e-15,  1.603651163599167e-17, -1.935116480668791e-19,  2.196513160917833e-21, -2.361239203921894e-23,
  1.663850834487453e-04, -1.108273424586767e-05,  4.154592260510211e-07, -1.139458519788862e-08,  2.533846211211412e-10, -4.822602898278287e-12,  8.120215162068501e-14,
 -1.236664858951329e-15,  1.730532817198159e-17, -2.251382913570774e-19,  2.747836753659094e-21, -3.168603537352286e-23,  7.893118989406344e-05, -5.946889959047961e-06,
  2.486624438058202e-07, -7.536948572651339e-09,  1.839483845049162e-10, -3.821616713719949e-12,  6.992544376226466e-14, -1.152854791654365e-15,  1.740743469533316e-17,
 -2.436619682583401e-19,  3.191550695576938e-21, -3.940443435516270e-23,  3.599968204285079e-05, -3.047182609138377e-06,  1.414635470664616e-07, -4.721257545798976e-09,
  1.260787175836781e-10, -2.851509957811091e-12,  5.656085118829451e-14, -1.007279210774123e-15,  1.637762447541034e-17, -2.461789024724465e-19,  3.454185713761326e-21,
 -4.558274447405002e-23,  1.581004035597843e-05, -1.494240256728066e-06,  7.668379734984653e-08, -2.808278085094969e-09,  8.181590570334496e-11, -2.009280489875815e-12,
  4.310580869322652e-14, -8.274674862690555e-16,  1.445925861459050e-17, -2.329696326887858e-19,  3.495626245347602e-21, -4.922397052185150e-23,  6.697119914323163e-06,
 -7.027931021441029e-07,  3.970749262924261e-08, -1.590385138139962e-09,  5.040807650043540e-11, -1.340935737640988e-12,  3.104565463337731e-14, -6.410953786653841e-16,
  1.201715073939990e-17, -2.071807952201622e-19,  3.318865352331027e-21, -4.979161179688244e-23,  2.741406503569455e-06, -3.177808112364722e-07,  1.969070331787310e-08,
 -8.598465663462049e-10,  2.957026518367874e-11, -8.500488418371566e-13,  2.119400186246219e-14, -4.698927662856388e-16,  9.431498293917568e-18, -1.736971522200724e-19,
  2.965908614251095e-21, -4.733508085489224e-23,  1.086617823633081e-06, -1.384765838222320e-07,  9.375972035624298e-09, -4.450425956240969e-10,  1.656348247077613e-11,
 -5.133708346878653e-13,  1.375574392713438e-14, -3.268261152261562e-16,  7.012041246481674e-18, -1.377246577899604e-19,  2.502839229636227e-21, -4.243077053110943e-23,
  4.179936483876149e-07, -5.830238452946752e-08,  4.298636933335261e-09, -2.211511611498125e-10,  8.885288990340720e-12, -2.962651559992559e-13,  8.514285324918814e-15,
 -2.163867777645026e-16,  4.954100340903166e-18, -1.036083761614331e-19,  2.000870072029075e-21, -3.598054679353290e-23,  1.564273338058125e-07, -2.378138349696726e-08,
  1.903066913694103e-09, -1.058225955933225e-10,  4.578685055268339e-12, -1.638857043064366e-13,  5.041648079769790e-15, -1.368115621288777e-16,  3.336849517306062e-18,
 -7.419052390833542e-20,  1.520309892103926e-21, -2.895807709445529e-23,  5.710326553441670e-08, -9.425046134485950e-09,  8.160203318217161e-10, -4.891277113455472e-11,
  2.273726277419062e-12, -8.717855432173331e-14,  2.865281572229453e-15, -8.287305324895885e-17,  2.149751554921519e-18, -5.073496070069295e-20,  1.101572691737204e-21,
 -2.219382547452000e-23,  2.039246153203254e-08, -3.640517979296531e-09,  3.399851417367640e-10, -2.190992756072754e-11,  1.091702307501184e-12, -4.474452803086247e-14,
  1.568175397832218e-15, -4.825806445899942e-17,  1.329201236667667e-18, -3.324639523530788e-20,  7.637234564699388e-22, -1.625285361918963e-23,  7.146583342770649e-09,
 -1.375003910090807e-09,  1.381021314679451e-10, -9.543971337775242e-12,  5.085674008582851e-13, -2.223564522274733e-14,  8.294233356441809e-16, -2.710910399714226e-17,
  7.915268913889860e-19, -2.094977868964127e-20,  5.084134837583839e-22, -1.141232731562892e-23,  2.466129389608260e-09, -5.096000144707689e-10,  5.488823102963241e-11,
 -4.057538164192438e-12,  2.307046705418172e-13, -1.073810895596094e-14,  4.255005769219342e-16, -1.474462146572594e-17,  4.556088756686617e-19, -1.274043817520463e-20,
  3.261525838712936e-22, -7.711212896468539e-24,  8.410121656118601e-10, -1.860219070659182e-10,  2.142624630860971e-11, -1.690065706102221e-12,  1.023043761420961e-13,
 -5.058701483396642e-15,  2.125327867208318e-16, -7.794296592461711e-18,  2.544556662766300e-19, -7.505683642220659e-21,  2.023795213227066e-22, -5.032478058509873e-24,
  2.845456369900128e-10, -6.714849581192367e-11,  8.247966195995754e-12, -6.924754562727946e-13,  4.452594739925109e-14, -2.334147534452784e-15,  1.037739860863892e-16,
 -4.020384213174043e-18,  1.384311797694497e-19, -4.300215928555288e-21,  1.219358602594006e-22, -3.184289335021332e-24,  9.591196353577190e-11, -2.407019497610110e-11,
  3.144310821106159e-12, -2.802910690297133e-13,  1.910077702631625e-14, -1.059307608012152e-15,  4.973931621721698e-17, -2.031892012063241e-18,  7.366042242513336e-20,
 -2.405700284844109e-21,  7.162298246453850e-23, -1.961240888645609e-24,  3.235073322270385e-11, -8.606599707869743e-12,  1.192402644992541e-12, -1.125780455344286e-13,
  8.112066901423133e-15, -4.749282406601611e-16,  2.350435013005481e-17, -1.010515908351856e-18,  3.849968768412452e-20, -1.319667321665413e-21,  4.118371030764198e-23,
 -1.180615515448153e-24,  1.097011235667502e-11, -3.084106511028976e-12,  4.519323626930227e-13, -4.507758247162222e-14,  3.426577337077616e-15, -2.113152877196173e-16,
  1.100005594683561e-17, -4.967414995567042e-19,  1.985231102166290e-20, -7.129173939918381e-22,  2.328103087101997e-23, -6.975381309633582e-25,  3.758158401681897e-12,
 -1.113015218395227e-12,  1.720269009013144e-13, -1.808142073596893e-14,  1.446500357215251e-15, -9.375308090372435e-17,  5.122312412903304e-18, -2.424703387764656e-19,
  1.014519768229581e-20, -3.809765797313531e-22,  1.299518495247157e-23, -4.062341590361732e-25,  1.307312864805403e-12, -4.065862461573290e-13,  6.609723426456992e-14,
 -7.301953504539422e-15,  6.132648957815036e-16, -4.167772832241153e-17,  2.384740389154005e-18, -1.180789767760407e-19,  5.161962886406295e-21, -2.023087914312024e-22,
  7.194534649102292e-24, -2.342252968325341e-25,  4.641828757012725e-13, -1.511290449552315e-13,  2.576788893771133e-14, -2.983993559919246e-15,  2.624432034726609e-16,
 -1.865682308512805e-17,  1.115409450923751e-18, -5.764320335602348e-20,  2.627304668906107e-21, -1.072469178858320e-22,  3.968430019500988e-24, -1.342936769265904e-25,
  1.691224571989732e-13, -5.746203509916610e-14,  1.024598365412941e-14, -1.240361633834590e-15,  1.139419537314271e-16, -8.451836387522107e-18,  5.267073342240010e-19,
 -2.834435579969402e-20,  1.343957207020504e-21, -5.701683092251564e-23,  2.190691732143552e-24, -7.690399391935457e-26,  6.356348554290783e-14, -2.246666204081154e-14,
  4.177026905488556e-15, -5.271263630907976e-16,  5.044031666240426e-17, -3.893914611035160e-18,  2.523155961686334e-19, -1.410523339530787e-20,  6.941379063945294e-22,
 -3.053715822834231e-23,  1.215633147321132e-24, -4.417529503236346e-26,  2.477093882871657e-14, -9.079223296609131e-15,  1.754760035280178e-15, -2.301742743493969e-16,
  2.287887294376895e-17, -1.833222080765346e-18,  1.231920282117272e-19, -7.136164891141974e-21,  3.635951380573693e-22, -1.654774261620608e-23,  6.809424528398567e-25,
 -2.555796242511448e-26,  1.005800984137472e-14, -3.810760016810225e-15,  7.632609176143777e-16, -1.037532284966323e-16,  1.068159445816368e-17, -8.858724501507543e-19,
  6.157006231820454e-20, -3.685994056788598e-21,  1.939481187144854e-22, -9.108889611492240e-24,  3.865321372698837e-25, -1.494924522223420e-26,  4.273648706816733e-15,
 -1.668412453522121e-15,  3.452040234635558e-16, -4.847854569246572e-17,  5.153897631238952e-18, -4.411224266688649e-19,  3.161976608508544e-20, -1.950973848552170e-21,
  1.057299472223496e-22, -5.111002286957271e-24,  2.230864989373899e-25, -8.868541063147569e-27,  1.906876646784940e-15, -7.646071225376315e-16,  1.628945424976690e-16,
 -2.355798105178129e-17,  2.578243202529171e-18, -2.270488918120393e-19,  1.673551838711754e-20, -1.061189138167040e-21,  5.906640567220372e-23, -2.930848612707950e-24,
  1.312362705083841e-25, -5.348769451837574e-27,  8.954273672272166e-16, -3.675855395432654e-16,  8.036627382968748e-17, -1.192980649751433e-17,  1.339738488400031e-18,
 -1.210103862835814e-19,  9.143901863665756e-21, -5.940842788940484e-22,  3.386344790170334e-23, -1.719863482698556e-24,  7.878485598879775e-26, -3.283139157102404e-27,
  4.425364151979231e-16, -1.853901100922492e-16,  4.145422240267034e-17, -6.294856121947723e-18,  7.229855386334604e-19, -6.676167786587892e-20,  5.155204212628832e-21,
 -3.421199347239438e-22,  1.991048563202972e-23, -1.031978339386017e-24,  4.822293257421799e-26, -2.048915157215556e-27,  2.293757938598750e-16, -9.774368969434233e-17,
  2.227551621685141e-17, -3.448209902063470e-18,  4.036539151022078e-19, -3.797920623923205e-20,  2.987100808052102e-21, -2.018394199982652e-22,  1.195553613905434e-23,
 -6.304547961809546e-25,  2.996206357484741e-26, -1.294191221397025e-27,  1.234223925402814e-16, -5.332496546404199e-17,  1.234213118248979e-17, -1.940717182828361e-18,
  2.307418213200721e-19, -2.204483211379315e-20,  1.760076107950870e-21, -1.206918424399346e-22,  7.252684594370448e-24, -3.878904692696564e-25,  1.869051622100816e-26,
 -8.182705797327761e-28,  6.726096321607869e-17, -2.936875828790651e-17,  6.878709746154216e-18, -1.094746057318855e-18,  1.317257899437808e-19, -1.273403528324415e-20,
  1.028518574245655e-21, -7.133140965993801e-23,  4.334336675243031e-24, -2.343433447156776e-25,  1.141258682627856e-26, -5.048554376366638e-28,  3.478634540210506e-17,
 -1.530053955311623e-17,  3.613379285417584e-18, -5.799081436689875e-19,  7.036053529102999e-20, -6.857775663207964e-21,  5.583725808803891e-22, -3.903183494806957e-23,
  2.390105086212163e-24, -1.302066011510232e-25,  6.388235127796512e-27, -2.846442110814915e-28,  1.330687449447328e-17, -5.876776591863589e-18,  1.394257817780362e-18,
 -2.248107636539821e-19,  2.740318847379816e-20, -2.683118196439581e-21,  2.194470059876774e-22, -1.540762099517561e-23,  9.475578979910633e-25, -5.183879400168583e-26,
  2.553860541337099e-27, -1.142535241477875e-28,  5.381676826792033e-02, -1.193866436329218e-04,  2.735956172457518e-07, -6.445062748467082e-10,  1.551225951498342e-12,
 -3.792676838932000e-15,  9.370794439075767e-18, -2.330710578376964e-20,  5.816878923520131e-23, -1.454011071508707e-25,  3.633716723918839e-28, -9.073924780471401e-31,
  5.110957223702674e-02, -1.392276597073582e-04,  4.466568092655444e-07, -1.501800676405584e-09,  5.036192708008161e-12, -1.661244720202887e-14,  5.381092355236588e-17,
 -1.714384211721646e-19,  5.383099787799085e-22, -1.668963889960113e-24,  5.116672835019545e-27, -1.553021065861133e-29,  4.609960302470217e-02, -1.722402606878259e-04,
  7.750030178618658e-07, -3.392043565022157e-09,  1.415356285483882e-11, -5.676961164940549e-14,  2.206438582880431e-16, -8.356285924757639e-19,  3.095796571253609e-21,
 -1.125177087357030e-23,  4.020937481882652e-26, -1.415349468781093e-28,  3.949608371738972e-02, -2.076052071388384e-04,  1.217633163723183e-06, -6.526891010878913e-09,
  3.261117963246466e-11, -1.546940085335587e-13,  7.042965427846730e-16, -3.099530054162107e-18,  1.325258044377634e-20, -5.526315627000449e-23,  2.254256647455670e-25,
 -9.016514314478548e-28,  3.214776770796577e-02, -2.342459801439300e-04,  1.706998103767869e-06, -1.093946240256092e-08,  6.435349259107649e-11, -3.553620116316419e-13,
  1.866180663368937e-15, -9.402235302162014e-18,  4.573572094673049e-20, -2.158234037627029e-22,  9.916740472209082e-25, -4.449790777634506e-27,  2.486524572958198e-02,
 -2.444176670271937e-04,  2.156284486473581e-06, -1.630357651376250e-08,  1.115579748130714e-10, -7.086835448478396e-13,  4.244671280932366e-15, -2.422256209616389e-17,
  1.326916147915403e-19, -7.017087198357028e-22,  3.597905201791412e-24, -1.794784461827959e-26,  1.828155965098673e-02, -2.356362569258290e-04,  2.479041342381752e-06,
 -2.189392109009116e-08,  1.725588593327951e-10, -1.249526397087236e-12,  8.462624661725531e-15, -5.425567715823333e-17,  3.321241663643693e-19, -1.953697448459744e-21,
  1.109854296945363e-23, -6.112497449922214e-26,  1.278130434510484e-02, -2.105001583458443e-04,  2.613825480950588e-06, -2.673478813017594e-08,  2.407640276410769e-10,
 -1.972612903466222e-12,  1.500286305643824e-14, -1.073622796435086e-16,  7.298755566010135e-19, -4.747590300068253e-21,  2.971115522650144e-23, -1.796672363966713e-25,
  8.501048354538802e-03, -1.749049541528042e-04,  2.542137591922456e-06, -2.988914545275969e-08,  3.054858292728182e-10, -2.814548906982841e-12,  2.390167112360348e-14,
 -1.898903896877525e-16,  1.426325036320753e-18, -1.020902489226889e-20,  7.005264099268690e-23, -4.630179994129770e-25,  5.381855119948637e-03, -1.356746074941730e-04,
  2.291170913643290e-06, -3.076153270408323e-08,  3.547462546127933e-10, -3.656065122575363e-12,  3.449860558211093e-14, -3.028894120354244e-16,  2.502835353316592e-18,
 -1.963084131362383e-20,  1.471108167517843e-22, -1.058705159084287e-24,  3.245006687492137e-03, -9.858318912414324e-05,  1.921036419380562e-06, -2.927805772919180e-08,
  3.790153408180023e-10, -4.349387157361579e-12,  4.540860011259618e-14, -4.388354969881754e-16,  3.974201518647366e-18, -3.403623156303122e-20,  2.776010098006555e-22,
 -2.168061472410957e-24,  1.864758727864880e-03, -6.730077156497297e-05,  1.503502024564109e-06, -2.587184232719975e-08,  3.742394350511294e-10, -4.762242225920892e-12,
  5.480345061433964e-14, -5.809351814096233e-16,  5.746955720296724e-18, -5.357313285670715e-20,  4.741239336340435e-22, -4.006853139284511e-24,  1.022098708511692e-03,
 -4.328354443542966e-05,  1.101758932975325e-06, -2.130010410024459e-08,  3.428429329190566e-10, -4.819863545518391e-12,  6.093207289999127e-14, -7.062449552329041e-16,
  7.609267042676716e-18, -7.699291083452410e-20,  7.373886168120026e-22, -6.725895679710566e-24,  5.348220222718934e-04, -2.628951311576043e-05,  7.580598904301989e-07,
 -1.639026399827273e-08,  2.924284292308116e-10, -4.526483585346897e-12,  6.266812715695622e-14, -7.919646294308872e-16,  9.268473424651224e-18, -1.015347515873142e-19,
  1.049813896224291e-21, -1.031102295888091e-23,  2.674250026992728e-04, -1.511467985529381e-05,  4.910234518437915e-07, -1.182285976569344e-08,  2.329832911798368e-10,
 -3.958256632760968e-12,  5.984536797686148e-14, -8.224353008789563e-16,  1.042931663223751e-17, -1.234118781503865e-19,  1.374520117589171e-21, -1.450644551887831e-23,
  1.279239412040126e-04, -8.243776510921819e-06,  3.001795540701610e-07, -8.016896316110097e-09,  1.739105053477000e-10, -3.233487642825326e-12,  5.324665191788676e-14,
 -7.938197519979204e-16,  1.088291811298284e-17, -1.388083604435440e-19,  1.661985896635358e-21, -1.881121878252071e-23,  5.861308361438583e-05, -4.274596653572021e-06,
  1.736237317166612e-07, -5.123988807895133e-09,  1.219773550075006e-10, -2.475121572214965e-12,  4.428312270901163e-14, -7.145647002767912e-16,  1.056862691198655e-17,
 -1.450096851568144e-19,  1.862987989361158e-21, -2.257354078321066e-23,  2.575880291128380e-05, -2.111699913672090e-06,  9.524508204765272e-08, -3.095104369989561e-09,
  8.061311207580865e-11, -1.780598316812826e-12,  3.453144564383353e-14, -6.018168103626264e-16,  9.583715761982366e-18, -1.411928204118133e-19,  1.942953034079980e-21,
 -2.516068711712102e-23,  1.087439817565086e-05, -9.960378205457112e-07,  4.967528250469071e-08, -1.771525867582482e-09,  5.033952662384928e-11, -1.207365687092454e-12,
  2.532396845274385e-14, -4.757156622533836e-16,  8.141302698827959e-18, -1.285607628386401e-19,  1.891787280140971e-21, -2.614054553462397e-23,  4.417365406670570e-06,
 -4.495632612918880e-07,  2.469319544653508e-08, -9.633235777884110e-10,  2.978466992863729e-11, -7.738657664995337e-13,  1.751789823980418e-14, -3.540159685681233e-16,
  6.499312237306279e-18, -1.098218779398123e-19,  1.725355968350949e-21, -2.540083858155246e-23,  1.729839450821523e-06, -1.946171779423208e-07,  1.172888874733813e-08,
 -4.990196528871308e-10,  1.674455533759005e-11, -4.702225215661316e-13,  1.146456698740736e-14, -2.487795851931117e-16,  4.891123118468262e-18, -8.829508881257923e-20,
  1.478739190138890e-21, -2.316110327376895e-23,  6.543653409161794e-07, -8.100314918565120e-08,  5.337315861338456e-09, -2.469364698356130e-10,  8.970055536712562e-12,
 -2.716623879910514e-13,  7.119752549275093e-15, -1.655979803513530e-16,  3.480752329583323e-18, -6.702385886688338e-20,  1.194841057491591e-21, -1.988235694657507e-23,
  2.396528387972459e-07, -3.249899281841645e-08,  2.333300850151846e-09, -1.170633079781693e-10,  4.592395623854083e-12, -1.496765898969974e-13,  4.208592423245597e-15,
 -1.047362391624440e-16,  2.349807573680335e-18, -4.818984509318057e-20,  9.131416089831161e-22, -1.612102458131141e-23,  8.518499548402067e-08, -1.260300689013695e-08,
  9.827832243368789e-10, -5.332432828932881e-11,  2.253915019981393e-12, -7.889156361119863e-14,  2.375447705666837e-15, -6.314330716375210e-17,  1.509683008880641e-18,
 -3.292501882785591e-20,  6.622124743392091e-22, -1.238697437802957e-23,  2.946684083599399e-08, -4.737895476664202e-09,  4.000490955262732e-10, -2.341345327820838e-11,
  1.063851629798011e-12, -3.990875619946887e-14,  1.284435176345977e-15, -3.640637707425774e-17,  9.261319547572896e-19, -2.144800674467294e-20,  4.572351296191755e-22,
 -9.049874162176993e-24,  9.948864514777463e-09, -1.732069661185045e-09,  1.578876935738789e-10, -9.942196585860635e-12,  4.845409068378651e-13, -1.944194498330843e-14,
  6.676024833992809e-16, -2.014343080405508e-17,  5.443558485402936e-19, -1.336686342329740e-20,  3.016179768826787e-22, -6.308374047209375e-24,  3.289095936446672e-09,
 -6.178378680851508e-10,  6.062667994232515e-11, -4.097330810686637e-12,  2.137098252724224e-13, -9.153585984041060e-15,  3.347434343085691e-16, -1.073359079250917e-17,
  3.076551784629581e-19, -7.998334063579168e-21,  1.907623378016294e-22, -4.210448156625699e-24,  1.068454752806872e-09, -2.158143916849659e-10,  2.273311930402677e-11,
 -1.644895079898370e-12,  9.161954972191984e-14, -4.180711067617522e-15,  1.625250301949106e-16, -5.528836075634778e-18,  1.678156182670839e-19, -4.612170872280629e-21,
  1.161037651232348e-22, -2.700643522782864e-24,  3.423344261340972e-10, -7.410774327183091e-11,  8.356765012589162e-12, -6.458163844601935e-13,  3.833005033009327e-14,
 -1.859651591332685e-15,  7.670987820699483e-17, -2.763753853823255e-18,  8.869040750565586e-20, -2.572910651567367e-21,  6.826270544163736e-23, -1.671039389784468e-24,
  1.086242026479517e-10, -2.512018805341307e-11,  3.024236584649587e-12, -2.490191403291378e-13,  1.571428041261739e-14, -8.089915492822518e-16,  3.534290930916147e-17,
 -1.346249184636045e-18,  4.560005013614948e-20, -1.394150067749230e-21,  3.892596324710583e-23, -1.001392834507266e-24,  3.428319776489268e-11, -8.442643472292456e-12,
  1.082231195503809e-12, -9.471871484334440e-14,  6.341202313807664e-15, -3.456944418827941e-16,  1.596474721864001e-17, -6.417743184035367e-19,  2.290597761997690e-20,
 -7.368675674491092e-22,  2.161832696973543e-23, -5.835889481026656e-25,  1.081288856332332e-11, -2.826652547719779e-12,  3.847637397234368e-13, -3.570700000002618e-14,
  2.530414790534790e-15, -1.457737981122653e-16,  7.102510860810072e-18, -3.007655356354996e-19,  1.129173314471366e-20, -3.815683697800075e-22,  1.174393181579600e-23,
 -3.321620931503100e-25,  3.425003372902809e-12, -9.474719897431439e-13,  1.365820683984206e-13, -1.340685569641047e-14,  1.003405731314829e-15, -6.095415512006326e-17,
  3.126969512500311e-18, -1.392214765819307e-19,  5.488008722879945e-21, -1.944653592349105e-22,  6.268548747280495e-24, -1.854624858553499e-25,  1.095243709986073e-12,
 -3.196204212599822e-13,  4.866094780648891e-14, -5.039625083667870e-15,  3.974134625324368e-16, -2.540103481916491e-17,  1.369157302804796e-18, -6.396462032903752e-20,
  2.642409919904480e-21, -9.800607976982980e-23,  3.302944233451489e-24, -1.020489524883526e-25,  3.555232446932704e-13, -1.091067616620004e-13,  1.749489145777778e-14,
 -1.906767762409827e-15,  1.580481753004854e-16, -1.060448142665387e-17,  5.992807440368859e-19, -2.931704899322656e-20,  1.266687009461097e-21, -4.908148723673890e-23,
  1.726193713551236e-24, -5.559569658890000e-26,  1.178135640878698e-13, -3.790307567896104e-14,  6.382907763422136e-15, -7.301752196167989e-16,  6.345746987634827e-17,
 -4.459064462882766e-18,  2.635965706861985e-19, -1.347380106189148e-20,  6.076050185008921e-22, -2.454661502748938e-23,  8.991725985093279e-25, -3.013153749642633e-26,
  4.008783311901931e-14, -1.347764440882154e-14,  2.376757786644813e-15, -2.845981699265793e-16,  2.586589470818789e-17, -1.898784650889218e-18,  1.171378643758017e-19,
 -6.241919553867918e-21,  2.931414979808684e-22, -1.232104766921101e-23,  4.691228687545963e-25, -1.632397314562192e-26,  1.408827951268443e-14, -4.933982322979596e-15,
  9.084577139413729e-16, -1.135445645258026e-16,  1.076296635644727e-17, -8.232761499653932e-19,  5.287049437668569e-20, -2.929974556689909e-21,  1.429700576099053e-22,
 -6.237949803758265e-24,  2.463340210430942e-25, -8.881939695019665e-27,  5.143209563411774e-15, -1.870320681420699e-15,  3.584531881429590e-16, -4.662723405999055e-17,
  4.596814452408903e-18, -3.653947765835493e-19,  2.436372897286156e-20, -1.400646843003847e-21,  7.083882200533865e-23, -3.200854183563356e-24,  1.307955727092726e-25,
 -4.875839659428146e-27,  1.961263591637752e-15, -7.381619889014798e-16,  1.467950622629606e-16, -1.981288465832352e-17,  2.025564943305782e-18, -1.668457940734884e-19,
  1.151917916211038e-20, -6.851547123962889e-22,  3.582405066724113e-23, -1.672171576645994e-24,  7.053364845094637e-26, -2.712051033664435e-27,  7.851430675439666e-16,
 -3.048441217782061e-16,  6.270102707038380e-17, -8.753340979349091e-18,  9.251856914253513e-19, -7.873669744065363e-20,  5.612568703369041e-21, -3.444293408764703e-22,
  1.856745625993566e-23, -8.929453571137077e-25,  3.878052068057488e-26, -1.534173534617585e-27,  3.313639452460010e-16, -1.322865205299944e-16,  2.804801188520121e-17,
 -4.036896428744659e-18,  4.397237098030123e-19, -3.854478272590450e-20,  2.828284326341020e-21, -1.785511814764392e-22,  9.895654630690814e-24, -4.889658696821161e-25,
  2.180550647315832e-26, -8.852017754327876e-28,  1.478656463377144e-16, -6.049459734816605e-17,  1.317664344144787e-17, -1.948632695278407e-18,  2.180246942431927e-19,
 -1.962141721326113e-20,  1.477398499397854e-21, -9.565545784663945e-23,  5.434074557067665e-24, -2.750791396870688e-25,  1.256062997987075e-26, -5.217966435238995e-28,
  6.981853091397203e-17, -2.917478119039339e-17,  6.505349997753487e-18, -9.850550869351256e-19,  1.128218721995000e-19, -1.038971800582377e-20,  8.001322794134222e-22,
 -5.296160390698463e-23,  3.074389569926305e-24, -1.589531116026044e-25,  7.409690084922126e-27, -3.140848990354898e-28,  3.478387638729921e-17, -1.479597409578026e-17,
  3.365258600107200e-18, -5.198915074803745e-19,  6.073891584976383e-20, -5.703728283642746e-21,  4.477506710648909e-22, -3.019846246475965e-23,  1.785498653122784e-24,
 -9.398856221053946e-26,  4.459046180710706e-27, -1.922817747491641e-28,  1.811027384736702e-17, -7.815455589136867e-18,  1.806531708998860e-18, -2.836895524581306e-19,
  3.368520958443342e-20, -3.214117429315644e-21,  2.562949454189424e-22, -1.755303963805502e-23,  1.053540690739819e-24, -5.627971987883127e-26,  2.708734285931495e-27,
 -1.184561096320887e-28,  9.618768332492558e-18, -4.197037160010671e-18,  9.822623763982631e-19, -1.562042584533170e-19,  1.878072543601288e-20, -1.814158542506412e-21,
  1.464183348555051e-22, -1.014717420606883e-23,  6.161335851865163e-25, -3.328892022167644e-26,  1.620066505477641e-27, -7.161846238681182e-29,  4.885434460468432e-18,
 -2.148066308041628e-18,  5.070851445362818e-19, -8.134860875791470e-20,  9.866082701387448e-21, -9.612270848770339e-22,  7.823423577752152e-23, -5.466695672330304e-24,
  3.346257039835083e-25, -1.822279063277541e-26,  8.937283523523777e-28, -3.980827382136750e-29,  1.849929474874843e-18, -8.168576634663672e-19,  1.937618859790644e-19,
 -3.123622796837479e-20,  3.806789254761097e-21, -3.726614510844934e-22,  3.047348986937206e-23, -2.139178590049565e-24,  1.315337629430617e-25, -7.194614692908933e-27,
  3.543823832162207e-28, -1.585142115285485e-29,  5.334355082895661e-02, -1.172283987492555e-04,  2.660079954571692e-07, -6.202814865614049e-10,  1.477569611762390e-12,
 -3.575403359823566e-15,  8.743487740795649e-18, -2.152672656026069e-20,  5.318663837665212e-23, -1.316338121182671e-25,  3.257346741097162e-28, -8.055428237954984e-31,
  5.055969587146537e-02, -1.357251466242814e-04,  4.291079343541572e-07, -1.423811012956312e-09,  4.716479392672290e-12, -1.537669595395591e-14,  4.924305226732583e-17,
 -1.551356224713123e-19,  4.817524237199108e-22, -1.477328706656739e-24,  4.480211385669253e-27, -1.345270354797970e-29,  4.542278955843506e-02, -1.661992893261640e-04,
  7.356206799098435e-07, -3.174389736088127e-09,  1.306928624765208e-11, -5.174409933208413e-14,  1.985744245389434e-16, -7.427454838973127e-19,  2.718243710011838e-21,
 -9.761305568033941e-24,  3.447122177558241e-26, -1.199218930812186e-28,  3.868466119576500e-02, -1.981687916678823e-04,  1.142341943140628e-06, -6.028973443745412e-09,
  2.967954098196095e-11, -1.387861901959892e-13,  6.231597453671477e-16, -2.705613477115174e-18,  1.141628982882481e-20, -4.699196826918003e-23,  1.892555564462780e-25,
 -7.475217974894161e-28,  3.123728837689149e-02, -2.210981101317145e-04,  1.581675596441595e-06, -9.964317566603441e-09,  5.767363665951666e-11, -3.135743610316568e-13,
  1.622292083790717e-15, -8.055717850286492e-18,  3.863530140658838e-20, -1.798110612831608e-22,  8.150629117391243e-25, -3.608838200265597e-27,  2.392087800344601e-02,
 -2.279206613878542e-04,  1.970900722312400e-06, -1.462672548845674e-08,  9.835047244045045e-11, -6.144927876073169e-13,  3.622277169955436e-15, -2.035431268022271e-17,
  1.098409641173522e-19, -5.724259671926938e-22,  2.893272908979507e-24, -1.423142828950772e-26,  1.737707919259738e-02, -2.168097284535165e-04,  2.232089637458175e-06,
 -1.932236401231793e-08,  1.494822511453694e-10, -1.063514401581871e-12,  7.082265618000256e-15, -4.467234916526754e-17,  2.691737206608103e-19, -1.559220607792323e-21,
  8.725479782419943e-24, -4.735343810360641e-26,  1.197918172993414e-02, -1.908102126686377e-04,  2.314880134959111e-06, -2.317959457005648e-08,  2.046819574969334e-10,
 -1.646128776458449e-12,  1.229955944721841e-14, -8.652611966167806e-17,  5.785768470436790e-19, -3.703417453437301e-21,  2.281599717428262e-23, -1.358725983817394e-25,
  7.839943075113390e-03, -1.559235244856396e-04,  2.211033119302344e-06, -2.542225136261459e-08,  2.545258622635227e-10, -2.299875580001300e-12,  1.917211919865361e-14,
 -1.496250609539458e-16,  1.104685079864038e-18, -7.775758730944158e-21,  5.249426673419150e-23, -3.414930822544833e-25,  4.873606795380436e-03, -1.187305814027137e-04,
  1.953813376492044e-06, -2.562830553220228e-08,  2.892618072177367e-10, -2.921433721637058e-12,  2.704032839301434e-14, -2.330556111132164e-16,  1.891699824231430e-18,
 -1.458280183215485e-20,  1.074570257275085e-22, -7.607384833372807e-25,  2.879322667541694e-03, -8.452339847344110e-05,  1.603395586962858e-06, -2.385443435720054e-08,
  3.020001131167829e-10, -3.393718708554122e-12,  3.473170680739184e-14, -3.292965112898505e-16,  2.927723132010921e-18, -2.463031267508449e-20,  1.974322758379720e-22,
 -1.516115859983989e-24,  1.617780131493476e-03, -5.641961100157563e-05,  1.226041053705830e-06, -2.057968465372973e-08,  2.909301451133242e-10, -3.623031893325273e-12,
  4.084618946141202e-14, -4.245496841199272e-16,  4.121058476935219e-18, -3.771861243913649e-20,  3.279226275189131e-22, -2.723708538501057e-24,  8.650964702990059e-04,
 -3.540546614432711e-05,  8.761296255445164e-07, -1.651259924985884e-08,  2.595996274936897e-10, -3.569648026661908e-12,  4.418694203552041e-14, -5.019364185601953e-16,
  5.304047574235575e-18, -5.267036357544915e-20,  4.953444689658087e-22, -4.438883466131358e-24,  4.406511153382464e-04, -2.093861058668586e-05,  5.867078446247974e-07,
 -1.236090437353659e-08,  2.153027978873421e-10, -3.258142098938783e-12,  4.414890447632929e-14, -5.465647653594686e-16,  6.271089960694797e-18, -6.739665827033819e-20,
  6.840356200821553e-22, -6.598383579712866e-24,  2.140062487551543e-04, -1.169616388206289e-05,  3.691360005356519e-07, -8.657609982149176e-09,  1.664945346286746e-10,
 -2.764348231152823e-12,  4.089059372069819e-14, -5.503062083024030e-16,  6.839314966182852e-18, -7.937170893982919e-20,  8.675085267568110e-22, -8.989428691860808e-24,
  9.920325132855087e-05, -6.184346075759430e-06,  2.187439537893139e-07, -5.689156710875023e-09,  1.204049021931873e-10, -2.187134545783694e-12,  3.522689146696909e-14,
 -5.141519427728727e-16,  6.906408435223381e-18, -8.637018394404298e-20,  1.014577035564796e-21, -1.127262775591081e-23,  4.394556721790943e-05, -3.101798621132796e-06,
  1.223821063462635e-07, -3.516797572493871e-09,  8.166100648462247e-11, -1.618557963564423e-12,  2.831754156828138e-14, -4.472552611123126e-16,  6.480102513273550e-18,
 -8.716012153771430e-20,  1.098401611755638e-21, -1.306252934227356e-23,  1.862842037745204e-05, -1.478817565616628e-06,  6.479907933995059e-08, -2.050322398376686e-09,
  5.208473577225640e-11, -1.123608895598004e-12,  2.130551480602785e-14, -3.633950849073363e-16,  5.668128765028867e-18, -8.185019313742890e-20,  1.104705418827094e-21,
 -1.403892056520550e-23,  7.567571461807856e-06, -6.716176109468808e-07,  3.254846446243509e-08, -1.130298718304606e-09,  3.132677622969063e-11, -7.337970670172349e-13,
  1.504784659948013e-14, -2.766309266747580e-16,  4.636711288194321e-18, -7.176257827555776e-20,  1.035648789634789e-21, -1.404293202480858e-23,  2.951045801383239e-06,
 -2.911988278578570e-07,  1.554760078639262e-08, -5.907339589387385e-10,  1.781627377900571e-11, -4.521100642944100e-13,  1.000641483834126e-14, -1.978955703768283e-16,
  3.558328833490191e-18, -5.893076806677983e-20,  9.079951114660504e-22, -1.311770317288629e-23,  1.106704459908134e-06, -1.208126880716074e-07,  7.080429743418002e-09,
 -2.934767255069539e-10,  9.607652441812293e-12, -2.635499694697788e-13,  6.283229826781878e-15, -1.334430435906200e-16,  2.569739606410400e-18, -4.546972688964289e-20,
  7.468923404288090e-22, -1.148046298741427e-23,  3.999501439182302e-07, -4.807732330654745e-08,  3.082161432290039e-09, -1.389730755812326e-10,  4.926637076995150e-12,
 -1.457805267216492e-13,  3.736661441603970e-15, -8.507509584577041e-17,  1.751803744921658e-18, -3.306799759345134e-20,  5.782651400839983e-22, -9.444407518224101e-24,
  1.395959394751606e-07, -1.839874023661079e-08,  1.286005000701899e-09, -6.290774923655003e-11,  2.409313347024432e-12, -7.674640448171110e-14,  2.111097475574830e-15,
 -5.144027320162861e-17,  1.130840074668566e-18, -2.273955970001789e-20,  4.227563196064161e-22, -7.326876564193775e-24,  4.717439061569390e-08, -6.789663631962880e-09,
  5.157991824868663e-10, -2.730208506530722e-11,  1.127137075539737e-12, -3.857376742294205e-14,  1.136652829635989e-15, -2.959270400143904e-17,  6.934828684021778e-19,
 -1.483392658724750e-20,  2.927990640929223e-22, -5.378047847714439e-24,  1.547703136573608e-08, -2.423264742961851e-09,  1.994834239445100e-10, -1.139669799326007e-11,
  5.060556320122182e-13, -1.857016993701198e-14,  5.851528910726568e-16, -1.625112596067734e-17,  4.053536321465092e-19, -9.210475099207964e-21,  1.927630472497073e-22,
 -3.747620719797624e-24,  4.944398512718160e-09, -8.391200261246273e-10,  7.463585164603455e-11, -4.591023514801892e-12,  2.187922806405713e-13, -8.592418810206676e-15,
  2.890190306634579e-16, -8.548664764462829e-18,  2.266199030054400e-19, -5.462151609790750e-21,  1.210480327040093e-22, -2.487813947688535e-24,  1.543133331259474e-09,
 -2.828811943814778e-10,  2.710990908584543e-11, -1.791164344635570e-12,  9.141953218448504e-14, -3.834939124270447e-15,  1.374578528841291e-16, -4.323144593330384e-18,
  1.216176971585267e-19, -3.105043939011410e-21,  7.276703366950776e-23, -1.578958564681949e-24,  4.721804489674751e-10, -9.318460221800049e-11,  9.595827100467153e-12,
 -6.793709150437653e-13,  3.705754748637590e-14, -1.657310583143978e-15,  6.319102158204892e-17, -2.109793069685469e-18,  6.288917876072230e-20, -1.698370167075838e-21,
  4.203246767429179e-23, -9.616918830429194e-25,  1.422050322948974e-10, -3.011432327478429e-11,  3.323238699800287e-12, -2.515270677235595e-13,  1.463211995361283e-14,
 -6.963220966899538e-16,  2.819259633283584e-17, -9.976085237017037e-19,  3.146052164297192e-20, -8.973789076300114e-22,  2.342145885502295e-23, -5.642946985681110e-25,
  4.233069451334152e-11, -9.588534125398525e-12,  1.130943192974229e-12, -9.129504451846190e-14,  5.652035847722770e-15, -2.856553187824619e-16,  1.225917466917167e-17,
 -4.589851116730161e-19,  1.528933766687038e-20, -4.599421333474205e-22,  1.264180923647359e-23, -3.202951272553618e-25,  1.251144917270776e-11, -3.021903072108906e-12,
  3.799491130861728e-13, -3.263593654001685e-14,  2.145661233276249e-15, -1.149415790171764e-16,  5.219068347267087e-18, -2.063928173898701e-19,  7.250408382189452e-21,
 -2.296734113241045e-22,  6.638113790637027e-24, -1.766120407982786e-25,  3.689767454625346e-12, -9.473221706205202e-13,  1.266349953157762e-13, -1.154674108866441e-14,
  8.044292705126148e-16, -4.558335251523035e-17,  2.185741303754391e-18, -9.113632696658469e-20,  3.370578941978593e-21, -1.122505914107490e-22,  3.406301786395458e-24,
 -9.502790388551669e-26,  1.091451657267988e-12, -2.969501993720441e-13,  4.209174105496207e-14, -4.064355009012695e-15,  2.993761069277153e-16, -1.790752915556686e-17,
  9.050153856170311e-19, -3.971334488326320e-20,  1.543584268648399e-21, -5.395359377958260e-23,  1.716229973892623e-24, -5.012579844370236e-26,  3.256424807630178e-13,
 -9.359524092214402e-14,  1.402990345356488e-14, -1.431097337033638e-15,  1.111980201785214e-16, -7.006185073596660e-18,  3.724316823100972e-19, -1.716625907390490e-20,
  6.999217110023097e-22, -2.563173942326748e-23,  8.532107740349626e-25, -2.604640690952924e-26,  9.857262033625183e-14, -2.983657806106606e-14,  4.716781041865687e-15,
 -5.069684825234669e-16,  4.145549611697506e-17, -2.745117615882562e-18,  1.531608718452997e-19, -7.400226579255476e-21,  3.159044302607721e-22, -1.209798579585983e-23,
  4.206630051706503e-25, -1.339913872815467e-26,  3.045862598788416e-14, -9.678728283260483e-15,  1.609127790463313e-15, -1.817656262571205e-16,  1.560331201578656e-17,
 -1.083365317775227e-18,  6.330172801381436e-20, -3.199292865248785e-21,  1.426958410673615e-22, -5.703480548310855e-24,  2.067647034074123e-25, -6.859115613403840e-27,
  9.668253863908156e-15, -3.215082456020840e-15,  5.605130010975763e-16, -6.636156383399442e-17,  5.964997537804107e-18, -4.331956135658869e-19,  2.644599390822769e-20,
 -1.394957844137887e-21,  6.486680828192606e-23, -2.700303434119276e-24,  1.018553777732950e-25, -3.512133274917745e-27,  3.172927105104086e-15, -1.100637199682294e-15,
  2.006162445416484e-16, -2.482468518476679e-17,  2.330235339455855e-18, -1.765517112217421e-19,  1.123334576231369e-20, -6.169334226274625e-22,  2.984039620703247e-23,
 -1.290889799655146e-24,  5.055434470824847e-26, -1.808134722337023e-27,  1.083497522549311e-15, -3.907848024965794e-16,  7.424240756706453e-17, -9.573754494639144e-18,
  9.358343600583690e-19, -7.377245053424038e-20,  4.879320652028353e-21, -2.783052000854924e-22,  1.396793944541071e-23, -6.264461806911186e-25,  2.541284775856781e-26,
 -9.406780932963041e-28,  3.873899494571690e-16, -1.447939689129157e-16,  2.858087318800437e-17, -3.829035475052441e-18,  3.886207029258845e-19, -3.178391381088540e-20,
  2.179235089050214e-21, -1.287478186147218e-22,  6.687618248484721e-24, -3.101687330531109e-25,  1.300188947199298e-26, -4.969090331736514e-28,  1.458574109827764e-16,
 -5.630812003513883e-17,  1.151004025235207e-17, -1.596938382628935e-18,  1.677652581375085e-19, -1.419282161458182e-20,  1.005854577552136e-21, -6.137899645060891e-23,
  3.290648451867320e-24, -1.574074421043352e-25,  6.800572102364658e-27, -2.676709139841916e-28,  5.812135950836110e-17, -2.309664349738745e-17,  4.872555178664695e-18,
 -6.977835026882643e-19,  7.563213918933195e-20, -6.597692918516512e-21,  4.818367260366584e-22, -3.027896795983278e-23,  1.670610185820384e-24, -8.218851676312232e-26,
  3.649633557457280e-27, -1.475459751759469e-28,  2.460212211837511e-17, -1.002928506558331e-17,  2.175969424226715e-18, -3.205281243938293e-19,  3.572360860853600e-20,
 -3.202791605967463e-21,  2.402609494328884e-22, -1.549965297100836e-23,  8.774124617425055e-25, -4.426296414542341e-26,  2.014357948775492e-27, -8.340830492851555e-29,
  1.107927744390485e-17, -4.617343549911823e-18,  1.026540450592816e-18, -1.549812005639552e-19,  1.769874189412962e-20, -1.625207800067733e-21,  1.248105319741129e-22,
 -8.238800612889244e-24,  4.769845371282569e-25, -2.459720096183388e-26,  1.143710401544109e-27, -4.836071846639562e-29,  5.297087176957992e-18, -2.248990504952053e-18,
  5.104522638239609e-19, -7.869273776488643e-20,  9.174566613831436e-21, -8.597878306476995e-22,  6.736001596707895e-23, -4.534239803532904e-24,  2.675797384117353e-25,
 -1.405927250899249e-26,  6.657998341234840e-28, -2.865992788469949e-29,  2.664905923011431e-18, -1.148624432935247e-18,  2.651383940927861e-19, -4.157838028650690e-20,
  4.930232356624174e-21, -4.697909500589750e-22,  3.741193079938995e-23, -2.558954319886220e-24,  1.533962273960202e-25, -8.184297219741605e-27,  3.934365397134847e-28,
 -1.718535344217329e-29,  1.377882274650816e-18, -6.007884180017779e-19,  1.404924996675511e-19, -2.232343308384523e-20,  2.681799848147761e-21, -2.588457699424036e-22,
  2.087469097943428e-23, -1.445558757379126e-24,  8.770794435617897e-26, -4.735267438509850e-27,  2.302849910561521e-28, -1.017311019740244e-29,  6.867200107261108e-19,
 -3.018310238442461e-19,  7.122226776003431e-20, -1.142091469046438e-20,  1.384562549291510e-21, -1.348383662053686e-22,  1.097001175391134e-23, -7.662336805444069e-25,
  4.688405067131018e-26, -2.552193514012297e-27,  1.251239658701882e-28, -5.571194845799589e-30,  2.572847139911856e-19, -1.135875956051587e-19,  2.693817913829122e-20,
 -4.341821423076641e-21,  5.290366498069500e-22, -5.177923941461009e-23,  4.233296147837568e-24, -2.971117829528537e-25,  1.826533392553495e-26, -9.988876349729424e-28,
  4.919275380708186e-29, -2.199979065844747e-30,  5.287884678080763e-02, -1.151297117595606e-04,  2.587041409156919e-07, -5.972012373322981e-10,  1.408112134700853e-12,
 -3.372604601732214e-15,  8.163872143906903e-18, -1.989812821996936e-20,  4.867405733263523e-23, -1.192860989474841e-25,  2.923033603981638e-28, -7.159468554633107e-31,
  5.002355458311084e-02, -1.323593661582731e-04,  4.124650396424102e-07, -1.350744847253697e-09,  4.420420757413984e-12, -1.424529418527000e-14,  4.510732466853027e-17,
 -1.405370238404313e-19,  4.316566819429665e-22, -1.309414331226719e-24,  3.928480145162582e-27, -1.167084083220412e-29,  4.476952599537698e-02, -1.604632167514676e-04,
  6.987493233258835e-07, -2.973308169135062e-09,  1.208042703065932e-11, -4.721836189150058e-14,  1.789443351695747e-16, -6.611280626619848e-19,  2.390435427758085e-21,
 -8.482423143007382e-24,  2.960479880901186e-26, -1.018027207119613e-28,  3.790981642351616e-02, -1.893115798134394e-04,  1.072754462457974e-06, -5.575519012417651e-09,
  2.704744608522552e-11, -1.246996735851421e-13,  5.522728010244535e-16, -2.365960487060991e-18,  9.853274785147138e-21, -4.004055309203527e-23,  1.592348876275031e-25,
 -6.211661318334974e-28,  3.037746699290680e-02, -2.089077686339743e-04,  1.467440144587587e-06, -9.089670060364961e-09,  5.177392660122826e-11, -2.772121306932034e-13,
  1.413110586580280e-15, -6.916964944671017e-18,  3.271260512037732e-20, -1.501751060011415e-22,  6.716402053270377e-25, -2.934786960673058e-27,  2.303965471096987e-02,
 -2.128296913792299e-04,  1.804430884292935e-06, -1.314690018948676e-08,  8.688577434813779e-11, -5.340182715691949e-13,  3.098619622873432e-15, -1.714795253125786e-17,
  9.117424178554519e-20, -4.683102780977635e-22,  2.333692951991266e-24, -1.132035512906649e-26,  1.654414055630886e-02, -1.998413842375769e-04,  2.013898440139495e-06,
 -1.709198343463595e-08,  1.298152086560364e-10, -9.076261586542377e-13,  5.944048810197626e-15, -3.689341394279958e-17,  2.188524640724995e-19, -1.248566758050001e-21,
  6.883851574406951e-24, -3.681848129215039e-26,  1.125129273771149e-02, -1.733505204917573e-04,  2.055337812954626e-06, -2.015281283562848e-08,  1.745253467164516e-10,
 -1.378037162900985e-12,  1.011717881408823e-14, -6.997975183908947e-17,  4.603357586098427e-19, -2.900028840246311e-21,  1.759121119428007e-23, -1.031798875932200e-25,
  7.249786741273143e-03, -1.393896367378647e-04,  1.928959924879822e-06, -2.169417295572762e-08,  2.128099069093552e-10, -1.886269058053065e-12,  1.543816157554406e-14,
 -1.183763885026943e-16,  8.591918435097329e-19, -5.948427639717432e-21,  3.951542205993814e-23, -2.530447747911282e-25,  4.428103230268131e-03, -1.042557758743945e-04,
  1.672223136708780e-06, -2.143438698036590e-08,  2.368276381289941e-10, -2.344389106002360e-12,  2.128888641485378e-14, -1.801526705481785e-16,  1.436645118200430e-18,
 -1.088651764699482e-20,  7.889270327983721e-23, -5.495040745664808e-25,  2.565179985619033e-03, -7.276398162672270e-05,  1.344033108896027e-06, -1.952309181385741e-08,
  2.417659292018913e-10, -2.660982600449373e-12,  2.669988017680344e-14, -2.483938418704777e-16,  2.168444533032264e-18, -1.792270267635933e-20,  1.412162320825701e-22,
 -1.066410215554781e-24,  1.410259157610514e-03, -4.752515442567307e-05,  1.004785033694117e-06, -1.645501284057499e-08,  2.273817160343120e-10, -2.771639938296301e-12,
  3.061767556225343e-14, -3.120874230497460e-16,  2.972990397160252e-18, -2.672036076439943e-20,  2.282392982000457e-22, -1.863444882454876e-24,  7.363306990880895e-04,
 -2.912349671464272e-05,  7.007184046234699e-07, -1.287698366289198e-08,  1.977652976425644e-10, -2.660256824295231e-12,  3.224908321958043e-14, -3.590730379294081e-16,
  3.721992246608922e-18, -3.627819010946454e-20,  3.350733026495902e-22, -2.950357335989892e-24,  3.654211582515625e-04, -1.678431149532121e-05,  4.570688776689020e-07,
 -9.384614459099781e-09,  1.596044096854442e-10, -2.361604143132868e-12,  3.132438486539940e-14, -3.799499064972612e-16,  4.274487840018815e-18, -4.507373031589601e-20,
  4.491172971170420e-22, -4.255387866378863e-24,  1.725285917163669e-04, -9.117234340967273e-06,  2.795630953164678e-07, -6.387497392177910e-09,  1.198906414461270e-10,
 -1.945564544738413e-12,  2.816008306072552e-14, -3.711736124990056e-16,  4.521579932570093e-18, -5.146885661227545e-20,  5.520950497047764e-22, -5.617799834149591e-24,
  7.757559518378027e-05, -4.677772432434973e-06,  1.607258658478430e-07, -4.071163582965586e-09,  8.406839145324795e-11, -1.492085905029623e-12,  2.350795392499632e-14,
 -3.359414958229901e-16,  4.421859550614506e-18, -5.422503817982200e-20,  6.249873124976257e-22, -6.817122216242268e-24,  3.325760238246391e-05, -2.271576109335387e-06,
  8.706066255286524e-08, -2.436135329268938e-09,  5.518149993086788e-11, -1.068404509507473e-12,  1.828027850124102e-14, -2.826272413372653e-16,  4.011661993278867e-18,
 -5.289950875263507e-20,  6.539705921778643e-22, -7.633657489496681e-24,  1.361206778945915e-05, -1.046216533555031e-06,  4.453512238425629e-08, -1.372084528809121e-09,
  3.399709491461815e-11, -7.163265721089952e-13,  1.328124918244324e-14, -2.217112339690434e-16,  3.387382083001376e-18, -4.794796951954556e-20,  6.347437050476074e-22,
 -7.916555932730473e-24,  5.326678691321286e-06, -4.579631845833266e-07,  2.156497535139757e-08, -7.292153021758070e-10,  1.971239247113787e-11, -4.509589967741099e-13,
  9.041731988462522e-15, -1.626678238442272e-16,  2.670471923464290e-18, -4.051017790562408e-20,  5.733820013809377e-22, -7.629689258696082e-24,  1.996148151158088e-06,
 -1.909381514919287e-07,  9.908389408151948e-09, -3.666381473891110e-10,  1.078579466570171e-11, -2.673171619123303e-13,  5.784647524021439e-15, -1.119571954157693e-16,
  1.971651806337222e-18, -3.200403346252926e-20,  4.836177763401608e-22, -6.856243666793837e-24,  7.176576371845026e-07, -7.599590558838838e-08,  4.330533848961659e-09,
 -1.748496748274484e-10,  5.584263242687381e-12, -1.496255979681918e-13,  3.487994417950696e-15, -7.249911409708931e-17,  1.367463821338861e-18, -2.371629141147169e-20,
  3.820820996106930e-22, -5.763497609304016e-24,  2.480286378956894e-07, -2.894422627539095e-08,  1.805043710071736e-09, -7.930777535976315e-11,  2.743467380661975e-12,
 -7.930980650287494e-14,  1.988062640395130e-15, -4.430492494268713e-17,  8.936715078609270e-19, -1.653662519364569e-20,  2.836524452763864e-22, -4.546817159506147e-24,
  8.258733124482558e-08, -1.057587122569764e-08,  7.194907312400330e-10, -3.431008668373816e-11,  1.282684996771115e-12, -3.992854214017838e-14,  1.074376945915905e-15,
 -2.562993630276595e-17,  5.520430947944866e-19, -1.088377076414940e-20,  1.985103216371837e-22, -3.377209063263590e-24,  2.655970325033428e-08, -3.717426566797888e-09,
  2.750483494748983e-10, -1.419971460703714e-11,  5.724692623653290e-13, -1.915240183165490e-14,  5.522314474130524e-16, -1.407991478674093e-17,  3.233667776782731e-19,
 -6.783457224610984e-21,  1.313907713368310e-22, -2.369556256016007e-24,  8.272090277291826e-09, -1.260734148364416e-09,  1.011529025801243e-10, -5.639793949802984e-12,
  2.446773277494495e-13, -8.781332316292701e-15,  2.708633325720665e-16, -7.369642122777152e-18,  1.802148278668270e-19, -4.017119371795605e-21,  8.252608304789358e-23,
 -1.575796736133004e-24,  2.502625884234165e-09, -4.138541000676312e-10,  3.590608331165561e-11, -2.156929945146668e-12,  1.004906942051219e-13, -3.861780523304376e-15,
  1.272166978053583e-16, -3.688008505063837e-18,  9.588862840655811e-20, -2.268200958586505e-21,  4.936000243275904e-23, -9.967165695162347e-25,  7.379097938702188e-10,
 -1.319525153411173e-10,  1.234583290345720e-11, -7.971906923180239e-13,  3.980383375903236e-14, -1.634885632730844e-15,  5.742327168588213e-17, -1.771013073227324e-18,
  4.888874690179157e-20, -1.225554928800582e-21,  2.821596587318091e-23, -6.018055255786266e-25,  2.128219146509748e-10, -4.101719984421714e-11,  4.127587132558394e-12,
 -2.858366256354737e-13,  1.526417934393705e-14, -6.688723602792267e-16,  2.500705168830185e-17, -8.192413440907671e-19,  2.397647961249892e-20, -6.361076837884582e-22,
  1.547407498401625e-23, -3.481765806474935e-25,  6.027872354402867e-11, -1.248133388544215e-11,  1.347365365774859e-12, -9.983926213505055e-14,  5.690762504563201e-15,
 -2.655520176463459e-16,  1.055004492864245e-17, -3.665545819736293e-19,  1.135694800393495e-20, -3.184401097529241e-22,  8.174181564854071e-24, -1.937886793485943e-25,
  1.683965112228025e-11, -3.734376079457754e-12,  4.313361819216917e-13, -3.412263385861102e-14,  2.071764249702760e-15, -1.027591950064044e-16,  4.330762205475817e-18,
 -1.593264041795231e-19,  5.218029457810749e-21, -1.544100785176301e-22,  4.176834119853258e-24, -1.041976852915853e-25,  4.662023966980062e-12, -1.103841842892187e-12,
  1.360698789554047e-13, -1.146596183121674e-14,  7.400149433649885e-16, -3.894017693968421e-17,  1.737861205009250e-18, -6.758664347393456e-20,  2.336144921988562e-21,
 -7.285027948474995e-23,  2.073706717375727e-24, -5.436245072337519e-26,  1.285606156652730e-12, -3.240087454576134e-13,  4.251572256320352e-14, -3.807315810497324e-15,
  2.606553147409866e-16, -1.452295257740209e-17,  6.851024156608052e-19, -2.811774683930707e-20,  1.024085778137606e-21, -3.360169840214251e-23,  1.005038739172626e-24,
 -2.764781819309998e-26,  3.550772961124314e-13, -9.496397007317124e-14,  1.322995861647960e-14, -1.256112275580034e-15,  9.102374893777481e-17, -5.359195035882526e-18,
  2.667244142277636e-19, -1.153165380367651e-20,  4.418021773851590e-22, -1.522802238581816e-23,  4.778564088511398e-25, -1.377378641037272e-26,  9.880424889246525e-14,
 -2.795530018789828e-14,  4.124020878426900e-15, -4.141379000612192e-16,  3.169417736925611e-17, -1.967758887957251e-18,  1.031193438122622e-19, -4.687692528268457e-21,
  1.885819936203212e-22, -6.816546199693470e-24,  2.240463108934013e-25, -6.755905055666138e-27,  2.787277922127789e-14, -8.317168185905547e-15,  1.295726884888610e-15,
 -1.372814890049515e-16,  1.106997214105430e-17, -7.231636223078327e-19,  3.982073893030857e-20, -1.899592775115782e-21,  8.009139334146454e-23, -3.030476295097253e-24,
  1.041467138484523e-25, -3.279804427150232e-27,  8.024032146341553e-15, -2.517284603390653e-15,  4.129932265195321e-16, -4.604643310664418e-17,  3.902814568431840e-18,
 -2.676507038937116e-19,  1.545239846925843e-20, -7.719178492643043e-22,  3.404153491613843e-23, -1.345724912362388e-24,  4.826617837640237e-26, -1.584594373416668e-27,
  2.373471763078208e-15, -7.803432952152558e-16,  1.344377028942704e-16, -1.573121635671926e-17,  1.397938735691439e-18, -1.003987609131913e-19,  6.063253903386944e-21,
 -3.164758363817266e-22,  1.456676633677014e-23, -6.003947775335455e-25,  2.242898167564638e-26, -7.661569825547388e-28,  7.264445569372422e-16, -2.494941953072524e-16,
  4.500159773405462e-17, -5.511100789352547e-18,  5.120918855003133e-19, -3.841739311346084e-20,  2.420970565235560e-21, -1.317218706635369e-22,  6.313567637556868e-24,
 -2.707183061664827e-25,  1.051111113258211e-26, -3.728112757268719e-28,  2.316952117714349e-16, -8.285156347319903e-17,  1.559760916133182e-17, -1.993245715081465e-18,
  1.931220314757824e-19, -1.509305513646143e-20,  9.899002178322840e-22, -5.600163599235820e-23,  2.788399104884797e-24, -1.240916104047229e-25,  4.996175721848235e-27,
 -1.835878930910389e-28,  7.754261037755998e-17, -2.877353371111285e-17,  5.635658873572283e-18, -7.492052904295542e-19,  7.546481098721516e-20, -6.126491839384648e-21,
  4.170393433241233e-22, -2.446604580977163e-23,  1.262197359983563e-24, -5.815196456425064e-26,  2.421919082862060e-27, -9.198064075266479e-29,  2.741065448094898e-17,
 -1.051862516879405e-17,  2.136254381424501e-18, -2.944814437099172e-19,  3.074083588202034e-20, -2.584578022059270e-21,  1.820667554229126e-22, -1.104479248443333e-23,
  5.887465652890024e-25, -2.800570254282242e-26,  1.203384131907865e-27, -4.711554964927850e-29,  1.029387652990528e-17, -4.070971790145096e-18,  8.543299082258089e-19,
 -1.217047844602603e-19,  1.312348516472573e-20, -1.139043632935523e-21,  8.277649374147060e-23, -5.176798100691893e-24,  2.842902456984957e-25, -1.392249849744177e-26,
  6.154965905632254e-28, -2.477583711300526e-29,  4.125613771971052e-18, -1.675547723537522e-18,  3.620360550446670e-19, -5.310944695266631e-20,  5.895150641497125e-21,
 -5.264289371137296e-22,  3.933749592930139e-23, -2.528132233594813e-24,  1.425862070006697e-25, -7.167224379006064e-27,  3.250303030979423e-28, -1.341268755521185e-29,
  1.768833813691212e-18, -7.351108873331537e-19,  1.629273889159557e-19, -2.452150321251299e-20,  2.791768655296245e-21, -2.555889509363674e-22,  1.957089224751487e-23,
 -1.288191757497777e-24,  7.437189323779840e-26, -3.824799427672207e-27,  1.773728964906888e-28, -7.480732776906123e-30,  8.102377517778874e-19, -3.433254178903130e-19,
  7.775356814964044e-20, -1.196022725968115e-20,  1.391368673490369e-21, -1.301123118323491e-22,  1.017233177010539e-23, -6.833380125071116e-25,  4.024562401495158e-26,
 -2.110493218837707e-27,  9.975654022899887e-29, -4.286195746283847e-30,  3.933003958496759e-19, -1.693012051324219e-19,  3.902363543875169e-20, -6.110681770266465e-21,
  7.235420534475180e-22, -6.884730589705056e-23,  5.475093728758374e-24, -3.739873157911033e-25,  2.238905620875626e-26, -1.193007035390672e-27,  5.727832455117155e-29,
 -2.498865016634803e-30,  1.977318144487607e-19, -8.615022003964300e-20,  2.012877985007767e-20, -3.195584442690979e-21,  3.835697777857459e-22, -3.699083786876086e-23,
  2.980681741173205e-24, -2.062440871258277e-25,  1.250382059832862e-26, -6.745500029711342e-28,  3.277998720248341e-29, -1.447034389693886e-30,  9.661738497016232e-20,
 -4.244942846097714e-20,  1.001231114718656e-20, -1.604822757021977e-21,  1.944678273486559e-22, -1.893042752294617e-23,  1.539462469865649e-24, -1.074835137676872e-25,
  6.573973546349201e-27, -3.577191869100403e-28,  1.753066968108607e-29, -7.802606813697699e-31,  3.579797394161296e-20, -1.580150909595445e-20,  3.746695778169836e-21,
 -6.037578302740893e-22,  7.355078167761477e-23, -7.197284709467537e-24,  5.883072460098013e-25, -4.128184728126497e-26,  2.537358254828712e-27, -1.387353018354139e-28,
  6.831072595855922e-30, -3.054395121043979e-31,  5.242242234677236e-02, -1.130883663432488e-04,  2.516707128877177e-07, -5.752006005377628e-10,  1.342575136097765e-12,
 -3.183185324722608e-15,  7.627900693694871e-18, -1.840707076572218e-20,  4.458284369932646e-23, -1.082000448721461e-25,  2.625739249076939e-28, -6.370354253074584e-31,
  4.950061557187106e-02, -1.291233005165841e-04,  3.966712469180103e-07, -1.282239852631317e-09,  4.146029779497659e-12, -1.320842045908531e-14,  4.135879418962859e-17,
 -1.274488809375613e-19,  3.872268006020586e-22, -1.162078051818312e-24,  3.449478440424932e-27, -1.014009387954904e-29,  4.413863169225419e-02, -1.550127253673487e-04,
  6.641989212026002e-07, -2.787349073096054e-09,  1.117755049901143e-11, -4.313746726181722e-14,  1.614593377126984e-16, -5.892999337527145e-19,  2.105347026315622e-21,
 -7.383145237360137e-24,  2.546989558706254e-26, -8.658228765556086e-29,  3.716932057829848e-02, -1.809899970949645e-04,  1.008364760112252e-06, -5.162013558660351e-09,
  2.468081072932274e-11, -1.122057488889520e-13,  4.902319392771405e-16, -2.072541272200162e-18,  8.520171581548794e-21, -3.418574291844834e-23,  1.342614013592877e-25,
 -5.173310018294842e-28,  2.956464348610656e-02, -1.975908788411982e-04,  1.363157234852713e-06, -8.303862263009231e-09,  4.655373364223591e-11, -2.455081041669600e-13,
  1.233313622207784e-15, -5.951719729729032e-18,  2.776030765539221e-20, -1.257240537986885e-22,  5.548553903938143e-25, -2.392986947252604e-27,  2.221624000126011e-02,
 -1.990024488266913e-04,  1.654669320669663e-06, -1.183828763381813e-08,  7.691182609980122e-11, -4.650983836815090e-13,  2.656911535456475e-15, -1.448303818569100e-17,
  7.588185827345948e-20, -3.842111128608054e-22,  1.887911455145540e-24, -9.032646166158858e-27,  1.577574649519255e-02, -1.845166331060460e-04,  1.820682046830580e-06,
 -1.515274674334846e-08,  1.130095032820389e-10, -7.766135116847929e-13,  5.002683179881898e-15, -3.055918006435610e-17,  1.784933872254615e-19, -1.003076897871782e-21,
  5.449490268262741e-24, -2.872924576700585e-26,  1.058930880720049e-02, -1.578296942037157e-04,  1.829389971823470e-06, -1.756833788211744e-08,  1.492422226948953e-10,
 -1.157165316182433e-12,  8.349200351139340e-15, -5.679202735747490e-17,  3.675775696623489e-19, -2.279452172669683e-21,  1.361588464055893e-23, -7.867106921333564e-26,
  6.721520893090639e-03, -1.249441350592977e-04,  1.687876923718308e-06, -1.857195961047371e-08,  1.785364618504252e-10, -1.552608286771099e-12,  1.247840276303620e-14,
 -9.402400574245366e-17,  6.710057158557455e-19, -4.569981888603401e-21,  2.987721118285875e-23, -1.883626903250069e-25,  4.036293144451362e-03, -9.184581550083326e-05,
  1.436284102803226e-06, -1.799411234320086e-08,  1.946659895097694e-10, -1.889133690617443e-12,  1.683339375165557e-14, -1.398859530680183e-16,  1.096150350297928e-18,
 -8.166357554533478e-21,  5.820973263698231e-23, -3.989569706384241e-25,  2.294232610662999e-03, -6.288689451458608e-05,  1.131315930562673e-06, -1.604800842763784e-08,
  1.944290201624053e-10, -2.096364072935220e-12,  2.062658955711964e-14, -1.883225225834208e-16,  1.614521844605734e-18, -1.311236335345783e-20,  1.015684724067890e-22,
 -7.543718953435071e-25,  1.235066589340944e-03, -4.021883444817763e-05,  8.274458949741427e-07, -1.322323078103708e-08,  1.786413498985757e-10, -2.131756350567081e-12,
  2.307820749223907e-14, -2.307294681707524e-16,  2.157367617675503e-18, -1.904315684594776e-20,  1.598383617007538e-22, -1.282930618733990e-24,  6.301404912447178e-04,
 -2.408583894750236e-05,  5.635517305665420e-07, -1.009951801926800e-08,  1.515503168203708e-10, -1.994588838726807e-12,  2.368322200769275e-14, -2.585130815288421e-16,
  2.628888587655177e-18, -2.515440720998574e-20,  2.282021123462134e-22, -1.974598027779126e-24,  3.049406527207268e-04, -1.353815071840253e-05,  3.583399295405880e-07,
 -7.171310663660927e-09,  1.191023958984178e-10, -1.723409401525137e-12,  2.237956697892517e-14, -2.659976196038015e-16,  2.934606401717042e-18, -3.036611376911134e-20,
  2.970811964812690e-22, -2.765201150918895e-24,  1.400896336426186e-04, -7.157454304973918e-06,  2.132485119267687e-07, -4.747076643965905e-09,  8.697370161310048e-11,
 -1.379657703246780e-12,  1.954213814665182e-14, -2.523079365924165e-16,  3.013011828659886e-18, -3.364390905929323e-20,  3.542300749311984e-22, -3.539797466670078e-24,
  6.115623581671951e-05, -3.566598351316698e-06,  1.190488961196109e-07, -2.937080701634156e-09,  5.918223295788210e-11, -1.026426645664039e-12,  1.582039282339753e-14,
 -2.213825504581003e-16,  2.855681835698875e-18, -3.434246183346702e-20,  3.884139756915643e-22, -4.159631680009293e-24,  2.539835084975197e-05, -1.678497412408915e-06,
  6.248976224019073e-08, -1.702789081127330e-09,  3.762778941266041e-11, -7.117285966577606e-13,  1.191016178497490e-14, -1.802672510291946e-16,  2.506959694744379e-18,
 -3.241168176461737e-20,  3.931026480418768e-22, -4.504246485960512e-24,  1.004723450360057e-05, -7.475343496865931e-07,  3.091187560509423e-08, -9.273336646268719e-10,
  2.241234510384797e-11, -4.612580584646093e-13,  8.362734255123374e-15, -1.366423974476190e-16,  2.045053948425255e-18, -2.837681418907396e-20,  3.684847488498205e-22,
 -4.510592043739895e-24,  3.791198926267004e-06, -3.156998399201755e-07,  1.444349288854617e-08, -4.755707342343850e-10,  1.253901314135713e-11, -2.801615425118978e-13,
  5.492283223295639e-15, -9.670351967762514e-17,  1.554971394741707e-18, -2.312085211292377e-20,  3.209713879531080e-22, -4.191441300071189e-24,  1.366727168763815e-06,
 -1.266980599537247e-07,  6.389542184877994e-09, -2.302429931706644e-10,  6.606619491882928e-12, -1.599181439513344e-13,  3.383487069879722e-15, -6.408568641633694e-17,
  1.105383785170914e-18, -1.758622888093927e-20,  2.606355085553866e-22, -3.626056279819723e-24,  4.715519266789488e-07, -4.842647767477857e-08,  2.682715595250709e-09,
 -1.055036010056841e-10,  3.286997339970860e-12, -8.602324219631563e-14,  1.960754627184623e-15, -3.988553594334637e-17,  7.368555432352913e-19, -1.252582820312124e-20,
  1.979188435119692e-22, -2.929824961587995e-24,  1.560185141006404e-07, -1.767001494373680e-08,  1.071749918527032e-09, -4.587942303494741e-11,  1.548546163515687e-12,
 -4.373174438716301e-14,  1.071994829155771e-15, -2.338277763165903e-17,  4.620045880461232e-19, -8.380027033541380e-21,  1.409908252446959e-22, -2.218050061990280e-24,
  4.961081091037502e-08, -6.170608599065032e-09,  4.085034178026996e-10, -1.898693970049714e-11,  6.927947840122027e-13, -2.107265066470435e-14,  5.545936597967305e-16,
 -1.295168533986510e-17,  2.733051068519386e-19, -5.282640067914943e-21,  9.452003190003354e-23, -1.578409895868452e-24,  1.519821213818550e-08, -2.067936662779377e-09,
  1.489796019024934e-10, -7.500054682047584e-12,  2.952265324157935e-13, -9.654272791501566e-15,  2.723482833176413e-16, -6.799491973827089e-18,  1.530281697985296e-19,
 -3.147900935602007e-21,  5.982688599686211e-23, -1.059275911735345e-24,  4.497850468413998e-09, -6.670277052870279e-10,  5.214604097202872e-11, -2.836710660106600e-12,
  1.202176357243267e-13, -4.218968828112459e-15,  1.273688029689025e-16, -3.394519241392486e-18,  8.136878176533686e-20, -1.779115466898795e-21,  3.587272854239649e-23,
 -6.726698925619748e-25,  1.289801331745925e-09, -2.077486925934250e-10,  1.757583574070003e-11, -1.030792432117985e-12,  4.693802332407343e-14, -1.764706742276990e-15,
  5.692341654895328e-17, -1.617103660133099e-18,  4.123035638558016e-20, -9.570029438784965e-22,  2.044764359878462e-23, -4.056166004255235e-25,  3.595791808243849e-10,
 -6.269529158519597e-11,  5.724830468798672e-12, -3.611653229030523e-13,  1.763640263170285e-14, -7.091025229921503e-16,  2.440065990411061e-17, -7.378171314295636e-19,
  1.998212038173001e-20, -4.917436816087753e-22,  1.112040678347113e-23, -2.330960814834824e-25,  9.781818395156072e-11, -1.840284345056341e-11,  1.809010992351356e-12,
 -1.224937580670788e-13,  6.402124929435661e-15, -2.747999598448322e-16,  1.007147316404058e-17, -3.236712062643336e-19,  9.298612581820040e-21, -2.423039285186862e-22,
  5.792536556742953e-24, -1.281515654744033e-25,  2.607109164562640e-11, -5.275802855532728e-12,  5.568934113844254e-13, -4.038527344520567e-14,  2.254733198860225e-15,
 -1.031379080670469e-16,  4.019572593968869e-18, -1.370907746623782e-19,  4.171955609841959e-21, -1.149631886708481e-22,  2.901719001026259e-24, -6.767640096133684e-26,
  6.838278364778196e-12, -1.483906804009661e-12,  1.677751549222747e-13, -1.300188579284633e-14,  7.739087940111461e-16, -3.765908717471808e-17,  1.558131496551668e-18,
 -5.631023504982651e-20,  1.812655506852046e-21, -5.275033897013814e-23,  1.403956751165182e-24, -3.447704538613066e-26,  1.773768539854999e-12, -4.115008268450735e-13,
  4.970986608951824e-14, -4.107637512878977e-15,  2.601497104920737e-16, -1.344216910774545e-17,  5.894461914130783e-19, -2.253711403665669e-20,  7.662653406452496e-22,
 -2.351639551216270e-23,  6.590998844088544e-25, -1.702024713083174e-26,  4.574176105051322e-13, -1.131074713324666e-13,  1.456203589335286e-14, -1.280181814752600e-15,
  8.609294697622146e-17, -4.714821754001382e-18,  2.187370410252514e-19, -8.833560504923725e-21,  3.167360338422402e-22, -1.023604606940027e-23,  3.016861834674806e-25,
 -8.181310418718733e-27,  1.179479518955515e-13, -3.099294806136056e-14,  4.241769755334397e-15, -3.958261971591911e-16,  2.820690356713784e-17, -1.634031377604601e-18,
  8.005878707372227e-20, -3.409072927321314e-21,  1.286980197010123e-22, -4.372966666686715e-24,  1.353310334370574e-25, -3.848547996522091e-27,  3.059975896537270e-14,
 -8.518536254290448e-15,  1.236161799821061e-15, -1.221573210117439e-16,  9.204110216451179e-18, -5.628758633325291e-19,  2.906852547891494e-20, -1.302801344987815e-21,
  5.169393030182856e-23, -1.843733871288693e-24,  5.981791492781762e-26, -1.781150971939313e-27,  8.040276497106738e-15, -2.364052475937904e-15,  3.627744387790076e-16,
 -3.787126405728992e-17,  3.010224549815789e-18, -1.939233232046677e-19,  1.053480298262910e-20, -4.959940594663988e-22,  2.064751337099648e-23, -7.716452208025101e-25,
  2.620163307696796e-26, -8.155641543922213e-28,  2.154754357823349e-15, -6.670620986835195e-16,  1.079495626286749e-16, -1.187465325992702e-17,  9.933532312567548e-19,
 -6.726025717625269e-20,  3.835413925978163e-21, -1.893085444492223e-22,  8.251657330995841e-24, -3.225259748886049e-25,  1.144101553092067e-26, -3.716132844987927e-28,
  5.933294105081548e-16, -1.927808268821883e-16,  3.280612732383134e-17, -3.792524402196074e-18,  3.330551007745229e-19, -2.364611041173139e-20,  1.412155086612924e-21,
 -7.291229399591686e-23,  3.320781027608803e-24, -1.354748844524053e-25,  5.010704195263064e-27, -1.695114233946117e-28,  1.691508869311041e-16, -5.749487610161323e-17,
  1.025810997226631e-17, -1.242802533383509e-18,  1.142729728440705e-19, -8.485476002505759e-21,  5.294356533423583e-22, -2.852839974864252e-23,  1.354587261945151e-24,
 -5.755392234543541e-26,  2.214824070333929e-27, -7.787962857608797e-29,  5.031504237982030e-17, -1.783179159003045e-17,  3.325326589817953e-18, -4.209725322930345e-19,
  4.041372083639255e-20, -3.130255348873474e-21,  2.035185641290530e-22, -1.141633400674941e-23,  5.637608550937815e-25, -2.488822031155009e-26,  9.942474775184053e-28,
 -3.625795480732556e-29,  1.573648618481094e-17, -5.795210644937685e-18,  1.125907089382188e-18, -1.484772871999674e-19,  1.483797433567564e-20, -1.195354112797622e-21,
  8.076135059516438e-23, -4.703478326002602e-24,  2.409331976491769e-25, -1.102377965314134e-26,  4.560395991441546e-28, -1.720677722264679e-29,  5.213250727143496e-18,
 -1.988030209717152e-18,  4.010317054266159e-19, -5.491026101195859e-20,  5.694231245850606e-21, -4.756640639544522e-22,  3.329690639638097e-23, -2.007543388295042e-24,
  1.063752009295764e-25, -5.030739230002290e-27,  2.149461127599084e-28, -8.369500302845291e-30,  1.841645070991076e-18, -7.246515217218245e-19,  1.512409613453280e-19,
 -2.142714690598056e-20,  2.298049845329037e-21, -1.984070245780677e-22,  1.434454567053235e-23, -8.926093624807045e-25,  4.877972229135401e-26, -2.377536397876042e-27,
  1.046218145490372e-28, -4.192456977481366e-30,  6.975317676273291e-19, -2.821768676050300e-19,  6.070742071316921e-20, -8.867117310177832e-21,  9.800671788111158e-22,
 -8.715474007369466e-23,  6.486222263320542e-24, -4.152055381562603e-25,  2.332723089698785e-26, -1.168159792046801e-27,  5.278164046046773e-29, -2.170338935085293e-30,
  2.841967724699007e-19, -1.177627038795352e-19,  2.601592579178849e-20, -3.902794620215456e-21,  4.429063811685026e-22, -4.042104479868884e-23,  3.085610039422969e-24,
 -2.024924000644783e-25,  1.165648512438943e-26, -5.977646914126804e-28,  2.764414745284467e-29, -1.162755093859220e-30,  1.245077332069420e-19, -5.264877471970933e-20,
  1.189600061972625e-20, -1.825623870444838e-21,  2.118939990466167e-22, -1.977057207511201e-23,  1.542296699146880e-24, -1.033837924265667e-25,  6.076142404058459e-27,
 -3.179862016683455e-28,  1.500040242150156e-29, -6.432720769552490e-31,  5.822585377514618e-20, -2.503006111120749e-20,  5.760638784319434e-21, -9.006738109828356e-22,
  1.064840398479077e-22, -1.011726226395699e-23,  8.034096252241830e-25, -5.480073964878765e-26,  3.276152825230197e-27, -1.743350789082537e-28,  8.359105893875231e-30,
 -3.642131714577164e-31,  2.842827233931469e-20, -1.237610598220672e-20,  2.889056492077053e-21, -4.582424469562207e-22,  5.495407055491268e-23, -5.295011986814421e-24,
  4.262982501188850e-25, -2.947222090267468e-26,  1.785319061298388e-27, -9.623593838632952e-29,  4.672938818155061e-30, -2.061233990461111e-31,  1.360654553762336e-20,
 -5.975704361230718e-21,  1.408813540892779e-21, -2.257070906681842e-22,  2.733797388030784e-23, -2.660004533832032e-24,  2.162210557074018e-25, -1.508972797839623e-26,
  9.225332111246258e-28, -5.017814634874273e-29,  2.458062845726647e-30, -1.093605084302220e-31,  4.983045062376064e-21, -2.199153210753560e-21,  5.213326359674208e-22,
 -8.399179684298630e-23,  1.022984662401863e-23, -1.000827124973816e-24,  8.179076016264238e-26, -5.738125822238457e-27,  3.526183600079961e-28, -1.927629702950226e-29,
  9.489434504952300e-31, -4.242218245356564e-32,  5.197405240681003e-02, -1.111022498632123e-04,  2.448951237403463e-07, -5.542189336099740e-10,  1.280701196684035e-12,
 -3.006142800316044e-15,  7.131904388400076e-18, -1.704076947203909e-20,  4.087013359363593e-23, -9.823656367416208e-26,  2.361067948623678e-28, -5.674525218303193e-31,
  4.899037322556653e-02, -1.260103700663968e-04,  3.816738414316906e-07, -1.217963980172970e-09,  3.891505502718776e-12, -1.225726973485568e-14,  3.795759888835419e-17,
 -1.157011986547337e-19,  3.477717762007513e-22, -1.032620173012097e-24,  3.033004676165636e-27, -8.823001665978220e-30,  4.352900034241617e-02, -1.498299506878746e-04,
  6.317959734433191e-07, -2.615205193144932e-09,  1.035225319014720e-11, -3.945307374273302e-14,  1.458635373332607e-16, -5.259921061646799e-19,  1.857010085152565e-21,
 -6.436611110162004e-24,  2.195006709068476e-26, -7.377184574540499e-29,  3.646111137073590e-02, -1.731643089796120e-04,  9.487179175761068e-07, -4.784453434877074e-09,
  2.254980542430346e-11, -1.011068484432971e-13,  4.358399470619378e-16, -1.818593192473397e-18,  7.380909632836962e-21, -2.924416069674364e-23,  1.134402539975047e-25,
 -4.318021919991187e-28,  2.879547679043035e-02, -1.870719067332844e-04,  1.267823069711674e-06, -7.596730486928351e-09,  4.192656990756360e-11, -2.178120076772967e-13,
  1.078451056088428e-15, -5.131721168231235e-18,  2.360960741315111e-20, -1.055002979171514e-22,  4.595105742141282e-25, -1.956287651680326e-27,  2.144583383485109e-02,
 -1.863130971562769e-04,  1.519697297034281e-06, -1.067878264562782e-08,  6.821603534811677e-11, -4.059366967920822e-13,  2.283401765498964e-15, -1.226229277508478e-17,
  6.331894623205250e-20, -3.160814049315570e-22,  1.531697711708901e-24, -7.229068385032455e-27,  1.506570115776294e-02, -1.706489094586232e-04,  1.649205796785964e-06,
 -1.346260907818132e-08,  9.861176817230391e-11, -6.662034890286489e-13,  4.221848731658037e-15, -2.538544721969850e-17,  1.460196040193837e-19, -8.084262451252728e-22,
  4.328396058013949e-24, -2.249521846975738e-26,  9.985980152251585e-03, -1.439989515101126e-04,  1.632167286774566e-06, -1.535523909473908e-08,  1.279804808346816e-10,
 -9.746096950801856e-13,  6.912073900876049e-15, -4.624381027411284e-17,  2.945401101433142e-19, -1.798236494576678e-21,  1.057909722696380e-23, -6.022126557058402e-26,
  6.247404489231308e-03, -1.122862703339796e-04,  1.481178551275557e-06, -1.594837503405111e-08,  1.502777897972377e-10, -1.282436483437207e-12,  1.012316352994106e-14,
 -7.496876929531064e-17,  5.261395754039898e-19, -3.525601087945423e-21,  2.268741221672744e-23, -1.408401759288872e-25,  3.690594013386501e-03, -8.116904612599786e-05,
  1.237863491363448e-06, -1.516103088681288e-08,  1.606254568721964e-10, -1.528426631290687e-12,  1.336648152593210e-14, -1.090958113157866e-16,  8.401596278085856e-19,
 -6.154692227987279e-21,  4.315764201501458e-23, -2.911031370323956e-25,  2.059637108243435e-03, -5.455680699893511e-05,  9.561038843360814e-07, -1.324735840284787e-08,
  1.570534231638007e-10, -1.659173843430823e-12,  1.601113614442752e-14, -1.434870681466293e-16,  1.208252723903794e-18, -9.643683647428537e-21,  7.344822848787901e-23,
 -5.366065344962989e-25,  1.086489980208006e-03, -3.418844703187389e-05,  6.846015376055824e-07, -1.067802011094974e-08,  1.410594793721003e-10, -1.648195352990034e-12,
  1.748941831307851e-14, -1.715311903624473e-16,  1.574471588188115e-18, -1.365147575761693e-20,  1.126100363845294e-22, -8.886982667832335e-25,  5.421008365747340e-04,
 -2.002382297167893e-05,  4.556836191107073e-07, -7.965264391524043e-09,  1.168020001727189e-10, -1.504323561499947e-12,  1.749810209395048e-14, -1.872728982841782e-16,
  1.868636526710366e-18, -1.755493472841913e-20,  1.564496113373504e-22, -1.330496809001102e-24,  2.560189750955052e-04, -1.098570016417909e-05,  2.826686264308279e-07,
 -5.514588436982023e-09,  8.945285760777421e-11, -1.265997089761561e-12,  1.609706460395512e-14, -1.875063059583475e-16,  2.028901469831006e-18, -2.060424169647101e-20,
  1.979458940957011e-22, -1.810182670919918e-24,  1.145418427619443e-04, -5.657611736343042e-06,  1.637989188403891e-07, -3.552979088470622e-09,  6.355031764554637e-11,
 -9.855552132136815e-13,  1.366312743074951e-14, -1.728140979970646e-16,  2.023292758991666e-18, -2.216494469261224e-20,  2.290891103068051e-22, -2.248460713046292e-24,
  4.859223255378410e-05, -2.740525383494026e-06,  8.886946450726534e-08, -2.135698871479217e-09,  4.199738172301108e-11, -7.118390170777111e-13,  1.073463382429311e-14,
 -1.471084939424462e-16,  1.859838692639610e-18, -2.193654144051816e-20,  2.434819562119234e-22, -2.560345021990529e-24,  1.956792564524934e-05, -1.251067258908492e-06,
  4.524480407931905e-08, -1.200656039918553e-09,  2.588545145134563e-11, -4.783678728847177e-13,  7.829963955981169e-15, -1.160286974280583e-16,  1.581081138884172e-18,
 -2.004344874890917e-20,  2.385122999226272e-22, -2.682894178365126e-24,  7.488973705220373e-06, -5.392914231065889e-07,  2.166309205839004e-08, -6.328113805411529e-10,
  1.491888926083868e-11, -2.999204433989369e-13,  5.317588866376598e-15, -8.504900320612470e-17,  1.246982657574522e-18, -1.696293086329045e-20,  2.160790412238238e-22,
 -2.596152042676300e-24,  2.727659106866236e-06, -2.199521868832185e-07,  9.776390329461543e-09, -3.134389362323253e-10,  8.060698390105017e-12, -1.759050389286861e-13,
  3.371855515937603e-15, -5.810532578898645e-17,  9.151852619664732e-19, -1.333875269501037e-20,  1.816266795561590e-22, -2.327715406384618e-24,  9.469183372097835e-07,
 -8.505355722723833e-08,  4.168098695264736e-09, -1.462569431943007e-10,  4.093361280970361e-12, -9.677027250514041e-14,  2.001841054095857e-15, -3.710687213881086e-17,
  6.268861418768746e-19, -9.775585071201914e-21,  1.420943043364087e-22, -1.940011479084790e-24,  3.138598466215059e-07, -3.125071378159950e-08,  1.682798260926021e-09,
 -6.445515695402977e-11,  1.958836014663399e-12, -5.006989414105822e-14,  1.115867800233567e-15, -2.221440999150735e-17,  4.019595827077714e-19, -6.697273768078710e-21,
  1.037884135085664e-22, -1.507746373661255e-24,  9.951684500395106e-08, -1.093540807774237e-08,  6.449794643362169e-10, -2.689765229594519e-11,  8.857368082620718e-13,
 -2.443397277281091e-14,  5.856796118075375e-16, -1.250335867264531e-17,  2.419835655701573e-19, -4.302312871498769e-21,  7.099724854791219e-23, -1.096151966442453e-24,
  3.025047724559553e-08, -3.653393130570111e-09,  2.353045567800494e-10, -1.065819561667383e-11,  3.795168765748572e-13, -1.127854558360539e-14,  2.903050871655299e-16,
 -6.636435655522886e-18,  1.371905956338115e-19, -2.599556051790148e-21,  4.562657637791902e-23, -7.478474602778148e-25,  8.836712634306687e-09, -1.168453161547066e-09,
  8.194373869160920e-11, -4.021942525207666e-12,  1.545524523298489e-13, -4.939403064342429e-15,  1.363124887906403e-16, -3.332076661052952e-18,  7.347985970776057e-20,
 -1.482088484481154e-21,  2.763603689343543e-23, -4.803586285349819e-25,  2.487381527051167e-09, -3.587973598639685e-10,  2.732285987665346e-11, -1.449867822391919e-12,
  6.000941428336683e-14, -2.058994555292044e-15,  6.082936992699944e-17, -1.587772306052295e-18,  3.730342486392594e-20, -7.999567349751806e-22,  1.582934669705987e-23,
 -2.914633642405639e-25,  6.766932167541342e-10, -1.061198009508083e-10,  8.751718157432822e-12, -5.009799678987959e-13,  2.229141935136670e-14, -8.197526948938354e-16,
  2.588708642269041e-17, -7.205364504391999e-19,  1.801239107757641e-20, -4.101906941187719e-22,  8.603837320131547e-24, -1.676422371750853e-25,  1.785214865243537e-10,
 -3.033683311985227e-11,  2.702536183172135e-12, -1.665277470883404e-13,  7.950917359613632e-15, -3.128597962184878e-16,  1.054484546582008e-17, -3.125459084275780e-19,
  8.302928175500703e-21, -2.005513403316109e-22,  4.454048391186171e-24, -9.173884299112648e-26,  4.584056119020471e-11, -8.414605373041361e-12,  8.077034715585294e-13,
 -5.346041562501729e-14,  2.733812143878356e-15, -1.149124477966964e-16,  4.127555242789526e-18, -1.300964825392870e-19,  3.667974221055928e-21, -9.385922337230748e-23,
  2.204627742306655e-24, -4.794794953549408e-26,  1.150415718920493e-11, -2.274103094009734e-12,  2.346265965563454e-13, -1.664589727623911e-14,  9.099993783005190e-16,
 -4.079233298770538e-17,  1.559109441847864e-18, -5.218387955719599e-20,  1.559445438991260e-21, -4.222228688081446e-23,  1.047665296799999e-24, -2.403313782256511e-26,
  2.834496276835030e-12, -6.015845692155885e-13,  6.655111762145711e-14, -5.050322324332504e-15,  2.946017693228370e-16, -1.405961959694469e-17,  5.709085277520844e-19,
 -2.026214678418241e-20,  6.409219913841466e-22, -1.833768255133925e-23,  4.800907243195992e-25, -1.160280360731460e-26,  6.890995715445343e-13, -1.565588537098125e-13,
  1.852560920506202e-14, -1.500536811827293e-15,  9.322154844590226e-17, -4.728236650362338e-18,  2.036522946634192e-19, -7.652747966561857e-21,  2.558661181496991e-22,
 -7.725792066383090e-24,  2.131433041102057e-25, -5.420479529916870e-27,  1.662073555248422e-13, -4.030282062120729e-14,  5.088670158228385e-15, -4.389855683921475e-16,
  2.898834666852271e-17, -1.559805047267756e-18,  7.114310714546463e-20, -2.826126820136880e-21,  9.972937121094226e-23, -3.173494331749459e-24,  9.213784039091869e-26,
 -2.462494131036307e-27,  4.001048249871810e-14, -1.032426664511506e-14,  1.387472024900231e-15, -1.271979451612655e-16,  8.910019172918287e-18, -5.076648414325572e-19,
  2.447672830815676e-20, -1.026193361850403e-21,  3.816112005540464e-23, -1.277842353391788e-24,  3.898832829212135e-26, -1.093582324289013e-27,  9.675317188535598e-15,
 -2.648799380746579e-15,  3.779271048795205e-16, -3.673503957761254e-17,  2.723893253400259e-18, -1.640168696511397e-19,  8.344086401253079e-21, -3.685662874538911e-22,
  1.441947477765333e-23, -5.072955239468747e-25,  1.624118299692768e-26, -4.773972333320376e-28,  2.366760163126646e-15, -6.853536873147039e-16,  1.035457894733746e-16,
 -1.064604840363992e-17,  8.337783606173874e-19, -5.294811943618740e-20,  2.836653879760062e-21, -1.317644944602430e-22,  5.413839660502759e-24, -1.997726276861284e-25,
  6.700142053201034e-27, -2.060665962216280e-28,  5.900345777405123e-16, -1.801632880547702e-16,  2.874524572263477e-17, -3.118345923677826e-18,  2.573525214371143e-19,
 -1.719794335749278e-20,  9.682622528633849e-22, -4.720383454954135e-23,  2.032970293246388e-24, -7.853922314691835e-26,  2.754614435411922e-27, -8.849221143363228e-29,
  1.510974123414772e-16, -4.849465536065143e-17,  8.147971011327545e-18, -9.301914840150902e-19,  8.069515280299700e-20, -5.661449581279148e-21,  3.342226009194677e-22,
 -1.706414180561308e-23,  7.687648278923888e-25, -3.103238124753929e-26,  1.136019550748464e-27, -3.804926708784602e-29,  4.007422090384658e-17, -1.347514097640041e-17,
  2.377177817271458e-18, -2.848047385190988e-19,  2.590323726842778e-20, -1.903179857307358e-21,  1.175273608246143e-22, -6.269773359407732e-24,  2.948169099867234e-25,
 -1.240820647253784e-26,  4.731240252851481e-28, -1.648833864077073e-29,  1.110117386857160e-17, -3.897736525006151e-18,  7.197254344232042e-19, -9.022803306801021e-20,
  8.579565830591211e-21, -6.583737007112144e-22,  4.241925981664915e-23, -2.358635260264689e-24,  1.154808160556623e-25, -5.055821529951728e-27,  2.003428077823334e-28,
 -7.248787607415520e-30,  3.239292733397186e-18, -1.183509855759512e-18,  2.280007825453260e-19, -2.981594356125051e-20,  2.955238799130498e-21, -2.361743718830416e-22,
  1.583252521724140e-23, -9.150986626025280e-25,  4.653045141989593e-26, -2.113732305310885e-27,  8.683302217175645e-29, -3.254109367870053e-30,  1.003896201101527e-18,
 -3.803204256922458e-19,  7.617892625994163e-20, -1.035738485698275e-20,  1.066670504831699e-21, -8.850459364908985e-23,  6.154816822677006e-24, -3.687208042798093e-25,
  1.941640931597620e-26, -9.127010663637498e-28,  3.876722808467797e-29, -1.500882069383441e-30,  3.329616597107401e-19, -1.303209693878845e-19,  2.704300332170280e-20,
 -3.809362646215422e-21,  4.062503696473564e-22, -3.488141162096169e-23,  2.508341296059258e-24, -1.552690257347588e-25,  8.442017486539013e-27, -4.094267650803049e-28,
  1.792959139867001e-29, -7.151150805533912e-31,  1.189471758104262e-19, -4.791974012062033e-20,  1.026286497764691e-20, -1.492243056146593e-21,  1.642007603265966e-22,
 -1.453835586386708e-23,  1.077376169837300e-24, -6.868106475243971e-26,  3.843103874738473e-27, -1.916955507338564e-28,  8.628357553070448e-30, -3.534725572505047e-31,
  4.596587520225056e-20, -1.898807673754381e-20,  4.180534532018633e-21, -6.250017882885775e-22,  7.068914152446483e-23, -6.430053158300724e-24,  4.892697969489268e-25,
 -3.200746978834810e-26,  1.836877763968529e-27, -9.391763088992594e-29,  4.330696107741244e-30, -1.816419471546942e-31,  1.922587268096562e-20, -8.112023022777191e-21,
  1.828473926421511e-21, -2.799233211924804e-22,  3.241163087053484e-23, -3.017012786641994e-24,  2.348146365008383e-25, -1.570483512139508e-26,  9.209942721154825e-28,
 -4.809604494027956e-29,  2.264121054449837e-30, -9.689746970845807e-32,  8.648154107071682e-21, -3.712349566499580e-21,  8.530305882626705e-22, -1.331565139458800e-22,
  1.571769777027250e-23, -1.491043397684068e-24,  1.182230645162198e-25, -8.052025208454947e-27,  4.806755900725100e-28, -2.554214832624755e-29,  1.223016779001347e-30,
 -5.321630369077632e-32,  4.095188215414328e-21, -1.781325840675158e-21,  4.154384084014262e-22, -6.583132892931709e-23,  7.887298336972127e-24, -7.592656584867776e-25,
  6.107270686301911e-26, -4.218539143530379e-27,  2.553227614760030e-28, -1.375131562032291e-29,  6.671738138234201e-31, -2.940543526498298e-32,  1.918123472996296e-21,
 -8.420428926113679e-22,  1.984227070731329e-22, -3.177406445415687e-23,  3.846672771573117e-24, -3.741069847219254e-25,  3.039552910676538e-26, -2.120290724286014e-27,
  1.295693719702082e-28, -7.044421804404016e-30,  3.449356801091069e-31, -1.533997056694755e-32,  6.939523670868780e-22, -3.062020595912461e-22,  7.257281422295074e-23,
 -1.168961938938054e-23,  1.423433627977282e-24, -1.392299427313899e-25,  1.137586611564539e-26, -7.979179725267394e-28,  4.902328533261593e-29, -2.679364436483333e-30,
  1.318744240560069e-31, -5.894228131196954e-33,  5.153352009453816e-02, -1.091693475410876e-04,  2.383654894858702e-07, -5.341995569182540e-10,  1.222252099413644e-12,
 -2.840558210896022e-15,  6.672553724756654e-18, -1.578773442421561e-20,  3.749776761126040e-23, -8.927301455969536e-26,  2.125179421250746e-28, -5.060247739784186e-31,
  4.849234743167442e-02, -1.230144014313462e-04,  3.674239257766492e-07, -1.157612637860691e-09,  3.655213877824076e-12, -1.138393895189700e-14,  3.486834118328389e-17,
 -1.051446146135413e-19,  3.126908297294398e-22, -9.187179090526545e-25,  2.670372089188199e-27, -7.687993185100426e-30,  4.293959441737327e-02, -1.448983556940266e-04,
  6.013818911335951e-07, -2.455696317167671e-09,  9.597039830962558e-12, -3.612257544845207e-14,  1.319340362887367e-16, -4.701119650826904e-19,  1.640344266652059e-21,
 -5.620214483138301e-24,  1.894840563259061e-26, -6.296914844327815e-29,  3.578327846409352e-02, -1.657982359308216e-04,  8.934043219703608e-07, -4.439282153540653e-09,
  2.062827939095968e-11, -9.123199002019057e-14,  3.880737508229507e-16, -1.598408802502091e-18,  6.405417965768274e-21, -2.506477124529551e-23,  9.604319287865653e-26,
 -3.611903961628984e-28,  2.806691265562391e-02, -1.772828833860229e-04,  1.180547924147344e-06, -6.959396351227621e-09,  3.781794603704311e-11, -1.935714548817279e-13,
  9.447933490250213e-16, -4.433596194640772e-18,  2.012270530549230e-20, -8.873207323563177e-23,  3.814692795649536e-25, -1.603350912634551e-27,  2.072411042063909e-02,
 -1.746501438274677e-04,  1.397842062213126e-06, -9.649411144011133e-09,  6.061864713516430e-11, -3.550363297553493e-13,  1.966794657934753e-15, -1.040691977599024e-17,
  5.297026918757523e-20, -2.607309644266713e-22,  1.246203377386873e-24, -5.802725377142569e-27,  1.440850622987148e-02, -1.580756239433441e-04,  1.496698718191577e-06,
 -1.198614055795805e-08,  8.624598679465562e-11, -5.729063658865313e-13,  3.572325266000061e-15, -2.114690210168657e-17,  1.198080704402333e-19, -6.535771429137209e-22,
  3.449137202678312e-24, -1.767374572749460e-26,  9.434979287205436e-03, -1.316452789597431e-04,  1.459575339616745e-06, -1.345489742606776e-08,  1.100475644765707e-10,
 -8.232498046256458e-13,  5.740022707580207e-15, -3.777755491354983e-17,  2.368224348702969e-19, -1.423679406553804e-21,  8.250191998420413e-24, -4.627631887257391e-26,
  5.820801428755399e-03, -1.011633553159411e-04,  1.303419200003171e-06, -1.373660054627111e-08,  1.268979469190748e-10, -1.062878845631660e-12,  8.241849837818971e-15,
 -5.999934379698896e-17,  4.141618755262224e-19, -2.730946705750585e-21,  1.730037770386610e-23, -1.057659703823175e-25,  3.384630160219394e-03, -7.195239246411713e-05,
  1.070396151303250e-06, -1.281912839033048e-08,  1.330323241102097e-10, -1.241442659907078e-12,  1.065711891975203e-14, -8.544616604339938e-17,  6.468057838067923e-19,
 -4.659846256501936e-21,  3.214928715406575e-23, -2.134425842435230e-25,  1.855757889654383e-03, -4.750352337059448e-05,  8.111817366839278e-07, -1.098038423630858e-08,
  1.274084791728374e-10, -1.319050791505763e-12,  1.248639383343519e-14, -1.098538975812638e-16,  9.087253560576566e-19, -7.129052553324944e-21,  5.339417092035855e-23,
 -3.837755829172283e-25,  9.599293282448327e-04, -2.918817631510309e-05,  5.689888452662647e-07, -8.663509568820184e-09,  1.119316040916600e-10, -1.280815319445268e-12,
  1.332380799612493e-14, -1.282131414367931e-16,  1.155477681596021e-18, -9.842381541586148e-21,  7.980212174322022e-23, -6.193065868491763e-25,  4.687331363097932e-04,
 -1.673106327571009e-05,  3.703899026566133e-07, -6.315974981294873e-09,  9.052293020466231e-11, -1.141079256363200e-12,  1.300459299475460e-14, -1.364863269214932e-16,
  1.336480807031562e-18, -1.232907410409171e-20,  1.079527984887686e-22, -9.024221847421948e-25,  2.162117381658972e-04, -8.966516516838383e-06,  2.243088976389006e-07,
 -4.266573015216560e-09,  6.760614194357735e-11, -9.359675195598669e-13,  1.165438002638563e-14, -1.330647126394701e-16,  1.412342599122977e-18, -1.407825777460828e-20,
  1.328303646075884e-22, -1.193576260900832e-24,  9.428471683041582e-05, -4.501867649670859e-06,  1.266670490837038e-07, -2.677568542348271e-09,  4.676131991838097e-11,
 -7.090680120366886e-13,  9.622381112640454e-15, -1.192442163537023e-16,  1.368926750669369e-18, -1.471438965582744e-20,  1.493099596753025e-22, -1.439479656108324e-24,
  3.890453643828696e-05, -2.121657469016302e-06,  6.684480157620825e-08, -1.564925249240173e-09,  3.003515989283175e-11, -4.975786582344121e-13,  7.342307147533251e-15,
 -9.854983331898891e-17,  1.221270079969380e-18, -1.412933151238664e-20,  1.539216269449281e-22, -1.589445388717747e-24,  1.520538231941031e-05, -9.403653511396052e-07,
  3.303649797198739e-08, -8.538270724437138e-10,  1.796107280377046e-11, -3.243233848928114e-13,  5.192910223272604e-15, -7.534652255639991e-17,  1.006120101685188e-18,
 -1.250751070767072e-20,  1.460429786429395e-22, -1.612821324706748e-24,  5.635503846449702e-06, -3.927182371936072e-07,  1.532405118987920e-08, -4.358975118823838e-10,
  1.002492040817213e-11, -1.968754056981331e-13,  3.413773653640652e-15, -5.344874646627844e-17,  7.677709588804967e-19, -1.023963394544112e-20,  1.279622922968126e-22,
 -1.509148378016356e-24,  1.983226942155435e-06, -1.548349553410158e-07,  6.685715944468456e-09, -2.087145197488906e-10,  5.235447977190114e-12, -1.115927091761046e-13,
  2.091663953804416e-15, -3.527908723319337e-17,  5.443082638917301e-19, -7.776740578711366e-21,  1.038688821769832e-22, -1.306501144391005e-24,  6.636754895411288e-07,
 -5.774743944443414e-08,  2.749690039132331e-09, -9.395228998535164e-11,  2.564705230514342e-12, -5.921690690837338e-14,  1.197736724973768e-15, -2.172821509428308e-17,
  3.595437845906330e-19, -5.495563427482340e-21,  7.834862132828768e-23, -1.049778582249492e-24,  2.115457687785132e-07, -2.041697729201401e-08,  1.068531335700533e-09,
 -3.985779874371557e-11,  1.181525424174233e-12, -2.949667256105417e-14,  6.427352892857036e-16, -1.252223343929590e-17,  2.219269245125391e-19, -3.624252984007238e-21,
  5.508603867963260e-23, -7.853229076640490e-25,  6.434741889116563e-08, -6.858449870262613e-09,  3.932948743293677e-10, -1.597651967153085e-11,  5.132422387186071e-13,
 -1.382940390178089e-14,  3.241310296609657e-16, -6.772289190253670e-18,  1.283783086863083e-19, -2.237250983527412e-21,  3.621092660478422e-23, -5.486681474130803e-25,
  1.871764176670145e-08, -2.194286317225182e-09,  1.374689070931994e-10, -6.067184153105526e-12,  2.108058320229157e-13, -6.120293870621315e-15,  1.540588654675808e-16,
 -3.447209849493851e-18,  6.980726408495313e-20, -1.296656852845456e-21,  2.232387272891931e-23, -3.591245424569381e-25,  5.219065238230823e-09, -6.704113367255818e-10,
  4.575683451475449e-11, -2.189161209186329e-12,  8.211102958001161e-14, -2.564363880096440e-15,  6.922288411854215e-17, -1.656589267525596e-18,  3.579225431471665e-20,
 -7.078099001472049e-22,  1.294829572033668e-23, -2.209273046583633e-25,  1.398653433656394e-09, -1.961661541663935e-10,  1.454723189497729e-11, -7.528259409757858e-13,
  3.042582909501851e-14, -1.020483569813520e-15,  2.949876009522010e-17, -7.540198472385804e-19,  1.736094532904957e-20, -3.651030981721384e-22,  7.089311596535121e-24,
 -1.281641407529552e-25,  3.613239182099921e-10, -5.514637581045086e-11,  4.431984219614210e-12, -2.475625930654100e-13,  1.076142659317510e-14, -3.870147133486613e-16,
  1.196281693097844e-17, -3.261839329977819e-19,  7.993737688187931e-21, -1.785757803085334e-22,  3.676620165408613e-24, -7.035661901507756e-26,  9.028163036970312e-11,
 -1.494627905942642e-11,  1.298550876304291e-12, -7.813019008245701e-14,  3.646405354729991e-15, -1.403884526165161e-16,  4.633713979119479e-18, -1.346002469705207e-19,
  3.506794465009808e-21, -8.312444482085546e-23,  1.812744517905305e-24, -3.668200916964964e-26,  2.189946470839761e-11, -3.920481281426958e-12,  3.673308173635276e-13,
 -2.375770523487353e-14,  1.188342100747976e-15, -4.890261260835894e-17,  1.721087508334390e-18, -5.319126388849016e-20,  1.471488738596053e-21, -3.696838104329112e-23,
  8.530166298402616e-25, -1.823451661458592e-26,  5.178431796668476e-12, -9.994783125680792e-13,  1.007511149985079e-13, -6.990447311239413e-15,  3.740776527468265e-16,
 -1.642806560278372e-17,  6.156067771824545e-19, -2.021551293478430e-20,  5.930860085626938e-22, -1.577407591919442e-23,  3.846944697308178e-25, -8.678023047655391e-27,
  1.199201890344318e-12, -2.488052666464182e-13,  2.691975194766894e-14, -1.999651193426833e-15,  1.142752832656345e-16, -5.346989942698562e-18,  2.130252833947646e-19,
 -7.422734784622573e-21,  2.306536810115890e-22, -6.486639034902068e-24,  1.670108939603856e-25, -3.971438732219806e-27,  2.733560263301226e-13, -6.078904696731401e-14,
  7.042865332658674e-15, -5.589493283319011e-16,  3.405013149090083e-17, -1.694682143320306e-18,  7.167254987729450e-20, -2.646197294551539e-21,  8.697738287960648e-23,
 -2.583185173086496e-24,  7.013229251338767e-26, -1.756004673514966e-27,  6.168057632223376e-14, -1.465937231788876e-14,  1.814351711953717e-15, -1.535252406174106e-16,
  9.950836598117194e-18, -5.258913574082082e-19,  2.357294184332780e-20, -9.208223483097892e-22,  3.196995140554820e-23, -1.001400175213877e-24,  2.863266282134047e-26,
 -7.539632108686578e-28,  1.386219983204693e-14, -3.510781604236017e-15,  4.630672875980307e-16, -4.168773002048052e-17,  2.869306187980847e-18, -1.607318305145015e-19,
  7.623389045786154e-21, -3.145739263587623e-22,  1.151935863085856e-23, -3.800143005627420e-25,  1.142779989842854e-26, -3.160611654986954e-28,  3.123973410842577e-15,
 -8.406253668794955e-16,  1.178697501093996e-16, -1.126443330685019e-17,  8.216448175939395e-19, -4.869431039588138e-20,  2.439412726800729e-21, -1.061569535919839e-22,
  4.093610100420692e-24, -1.420132838107623e-25,  4.485107656924530e-27, -1.301058179171498e-28,  7.111319532109899e-16, -2.027046136064973e-16,  3.013785677810271e-17,
 -3.050398345657824e-18,  2.352924206491567e-19, -1.472320037384974e-20,  7.775914889384861e-22, -3.562272523392253e-23,  1.444103282358524e-24, -5.259738266479419e-26,
  1.741845997863363e-27, -5.291668202726468e-29,  1.648084534968095e-16, -4.961060301342475e-17,  7.800383542926140e-18, -8.341417583668845e-19,  6.788636622719431e-20,
 -4.475586041781543e-21,  2.486927337934705e-22, -1.197056936744724e-23,  5.092124828592128e-25, -1.943749856047266e-26,  6.738266237400916e-28, -2.140298537895160e-29,
  3.921379848688963e-17, -1.242627477420439e-17,  2.060461667666882e-18, -2.321932432474526e-19,  1.988993897483034e-20, -1.378413903250283e-21,  8.041000557433916e-23,
 -4.058191569110361e-24,  1.807843960347748e-25, -7.218402554884565e-27,  2.614588602176084e-28, -8.667423130061291e-30,  9.664166842352908e-18, -3.213333714674209e-18,
  5.602578804946683e-19, -6.635069454070266e-20,  5.966869749033072e-21, -4.336121779280957e-22,  2.649265783216987e-23, -1.398736756361683e-24,  6.511218498181039e-26,
 -2.713736833394084e-27,  1.024945068752441e-28, -3.539074859257888e-30,  2.489607819965691e-18, -8.656594644905235e-19,  1.582134550149025e-19, -1.963388020795387e-20,
  1.848494307286234e-21, -1.404841321117557e-22,  8.966769323212682e-24, -4.940446157736692e-25,  2.397500662634368e-26, -1.040617815748490e-27,  4.089092821391137e-29,
 -1.467500454883036e-30,  6.766615774076101e-19, -2.451874566209438e-19,  4.682059185699500e-20, -6.069479661276244e-21,  5.964553523050902e-22, -4.727100523393435e-23,
  3.143304288298980e-24, -1.802499085434832e-25,  9.095146712408552e-27, -4.100900139784217e-28,  1.672473201754782e-29, -6.223617954077076e-31,  1.958205341197536e-19,
 -7.367682111526776e-20,  1.464897342058386e-20, -1.977096255101358e-21,  2.021509812150512e-22, -1.665541756958352e-23,  1.150347268662932e-24, -6.845664055024185e-26,
  3.581536994613565e-27, -1.672969300748131e-28,  7.062475256318338e-30, -2.717995326653656e-31,  6.085942864375017e-20, -2.368817938277018e-20,  4.886014533795595e-21,
 -6.841303142760144e-22,  7.252943288066016e-23, -6.191681459369344e-24,  4.427505053682520e-25, -2.725708974470279e-26,  1.474098669483099e-27, -7.112202160917673e-29,
  3.098888322913914e-30, -1.229935690222591e-31,  2.046544074346872e-20, -8.209054353766746e-21,  1.749784438348076e-21, -2.532156487850300e-22,  2.773292562769309e-23,
 -2.444280407600383e-24,  1.803298162766884e-25, -1.144594394644290e-26,  6.377649479957076e-28, -3.168129793325671e-29,  1.420295406005441e-30, -5.795833623341485e-32,
  7.486354337039407e-21, -3.082497200724655e-21,  6.762352294380140e-22, -1.007362739567605e-22,  1.135324453576697e-23, -1.029147724803340e-24,  7.804475865811359e-26,
 -5.088806940113525e-27,  2.911059711306144e-28, -1.483749179611483e-29,  6.821014827055111e-31, -2.852483631264257e-32,  2.983901388419271e-21, -1.256112388283099e-21,
  2.824102148227449e-22, -4.312373618657849e-23,  4.980575723330199e-24, -4.624661195852402e-25,  3.590684557386464e-26, -2.395856135977593e-27,  1.401798121986830e-28,
 -7.304065214940094e-30,  3.430888827752879e-31, -1.465203774456952e-32,  1.288896777719423e-21, -5.524462170721308e-22,  1.267291581204694e-22, -1.974872818526393e-23,
  2.327232537882611e-24, -2.204091140897231e-25,  1.744801240915704e-26, -1.186506179471798e-27,  7.072203958411397e-29, -3.752446112839428e-30,  1.794155051290759e-31,
 -7.795793028328439e-33,  5.911384973948876e-22, -2.569069005010039e-22,  5.985622918347559e-23, -9.475475909343076e-24,  1.134141327244394e-24, -1.090714300179050e-25,
  8.764996267387021e-27, -6.048718009500635e-28,  3.657606022048624e-29, -1.968190548993850e-30,  9.540839538313886e-32, -4.201554324198605e-33,  2.706833564263376e-22,
 -1.187755062414025e-22,  2.797480249818452e-23, -4.477425199810622e-24,  5.417794341261153e-25, -5.266452769912463e-26,  4.276822294746915e-27, -2.981949494288133e-28,
  1.821398253752573e-29, -9.898056127018471e-31,  4.844499624604589e-32, -2.153507111326045e-33,  9.668740629229308e-23, -4.265433741990543e-23,  1.010723100117007e-23,
 -1.627645089182870e-24,  1.981517294446215e-25, -1.937740124396368e-26,  1.582890395689226e-27, -1.110016612041250e-28,  6.818360095301748e-30, -3.725778648172612e-31,
  1.833390701230054e-32, -8.192798628064215e-34,  5.110061641676190e-02, -1.072877370132168e-04,  2.320705840159627e-07, -5.150894595285617e-10,  1.167007229875053e-12,
 -2.685588920321512e-15,  6.246824464863014e-18, -1.463762903399953e-20,  3.443173691959158e-23, -8.120113316735913e-26,  1.914714320463503e-28, -4.517355537002247e-31,
  4.800608201135585e-02, -1.201295982266465e-04,  3.538761058518654e-07, -1.100906158749488e-09,  3.435670749200318e-12, -1.058132650320395e-14,  3.205954859867541e-17,
 -9.564771787573522e-20,  2.814608688922819e-22, -8.183696740791844e-25,  2.354171649864759e-27, -6.708415160124990e-30,  4.236944008619026e-02, -1.402026174037115e-04,
  5.728115555641439e-07, -2.307755621056281e-09,  8.905216156816486e-12, -3.310836656486149e-14,  1.194763712655229e-16, -4.207171601126456e-19,  1.451017350747477e-21,
 -4.914893203058917e-24,  1.638409962181591e-26, -5.384243646393759e-29,  3.513405034655986e-02, -1.588586114651894e-04,  8.420546364620564e-07, -4.123335564081683e-09,
  1.889326836011959e-11, -8.243293136195703e-14,  3.460573926263364e-16, -1.407161274634253e-18,  5.568572593385459e-21, -2.152289102696831e-23,  8.147611072090988e-26,
 -3.027628524488081e-28,  2.737615511875108e-02, -1.681625509650641e-04,  1.100541812143268e-06, -6.384089572414502e-09,  3.416357584779498e-11, -1.723161887358231e-13,
  8.292076329957409e-16, -3.837966960888155e-18,  1.718682078094741e-20, -7.479570876943577e-23,  3.174304003442791e-25, -1.317357216310357e-27,  2.004716454955149e-02,
 -1.639146142634439e-04,  1.287642239727968e-06, -8.733849638007608e-09,  5.396730268257137e-11, -3.111467834753575e-13,  1.697786313262492e-15, -8.852909463757679e-18,
  4.442292905421884e-20, -2.156371834152390e-22,  1.016719123765059e-24, -4.671269605676182e-27,  1.379927197420310e-02, -1.466547515578926e-04,  1.360781085629173e-06,
 -1.069340526927970e-08,  7.559940643330341e-11, -4.938635175591316e-13,  3.030530246623674e-15, -1.766432659869613e-17,  9.858604140635871e-20, -5.299943034700003e-22,
  2.757230183411302e-24, -1.393173573422755e-26,  8.930769472220644e-03, -1.205857828169390e-04,  1.308161090817166e-06, -1.181871619406174e-08,  9.487872710256508e-11,
 -6.973713431471534e-13,  4.781074695933380e-15, -3.095936422486167e-17,  1.910500801318063e-19, -1.131068280668964e-21,  6.457338012884675e-24, -3.569458640921992e-26,
  5.436005416477598e-03, -9.136239078175014e-05,  1.150094011598261e-06, -1.186609200694258e-08,  1.074897065150461e-10, -8.838229028652710e-13,  6.733534827758178e-15,
 -4.819422955792481e-17,  3.272583971915786e-19, -2.123787256133365e-21,  1.324669607965694e-23, -7.976420538334861e-26,  3.113021380591739e-03, -6.397015720426827e-05,
  9.285612517549121e-07, -1.087611841742873e-08,  1.105788482003290e-10, -1.012189433963498e-12,  8.530844695267952e-15, -6.720153395573411e-17,  5.001005359518896e-19,
 -3.543842924351608e-21,  2.405948231071536e-23, -1.572453545206207e-25,  1.677934603433183e-03, -4.150837694876155e-05,  6.908277873003803e-07, -9.137604028198711e-09,
  1.037910763267232e-10, -1.053225480021870e-12,  9.781769227967663e-15, -8.449972798906813e-17,  6.867726911406312e-19, -5.296532644935165e-21,  3.901577103231646e-23,
 -2.759262323641409e-25,  8.516625679134993e-04, -2.502350834444548e-05,  4.749799432311614e-07, -7.061309513794950e-09,  8.924250463858791e-11, -1.000251957876774e-12,
  1.020232882807991e-14, -9.634062803868699e-17,  8.525940069284145e-19, -7.135731107501875e-21,  5.687620636160325e-23, -4.341049089209442e-25,  4.072877129526562e-04,
 -1.404811899725813e-05,  3.025868713940506e-07, -5.034440167688818e-09,  7.053623486888625e-11, -8.703778502597426e-13,  9.720514507057256e-15, -1.000590413793894e-16,
  9.616502492639060e-19, -8.712428122974531e-21,  7.495996729603699e-23, -6.160245829923990e-25,  1.836345571193704e-04, -7.359781840359861e-06,  1.790284481275785e-07,
 -3.320612786936828e-09,  5.140658438759465e-11, -6.962991407088741e-13,  8.491862060370712e-15, -9.504802725242362e-17,  9.897189753783569e-19, -9.684811623993072e-21,
  8.975388784788812e-23, -7.925668440372017e-25,  7.811705540692189e-05, -3.605337025445605e-06,  9.859507303478865e-08, -2.031342755386363e-09,  3.464253151381702e-11,
 -5.136980045887163e-13,  6.824739890346501e-15, -8.287489077537482e-17,  9.330043437550329e-19, -9.841297455829512e-21,  9.805239755359329e-23, -9.286659840914977e-25,
  3.137909846103871e-05, -1.654544375294582e-06,  5.064930136606131e-08, -1.155265278526731e-09,  2.164320255621689e-11, -3.504905909697327e-13,  5.061312873462319e-15,
 -6.654402416649993e-17,  8.084097218840293e-19, -9.174982878520236e-21,  9.810878790349451e-23, -9.949738522756135e-25,  1.191391250545033e-05, -7.126239449604413e-07,
  2.432090428514823e-08, -6.122268970159102e-10,  1.256719096058858e-11, -2.217507719018191e-13,  3.473558178158005e-15, -4.935323667709319e-17,  6.458643261644920e-19,
 -7.874178137713048e-21,  9.022468892355148e-23, -9.783208222856686e-25,  4.280176113395451e-06, -2.885947965213836e-07,  1.093887648362728e-08, -3.030102125526919e-10,
  6.798517916222298e-12, -1.304356206674515e-13,  2.212108705556271e-15, -3.390710226701290e-17,  4.772223634506902e-19, -6.240483776003642e-21,  7.651266274081936e-23,
 -8.858217072757738e-25,  1.456803500410991e-06, -1.100969175436373e-07,  4.618089576133596e-09, -1.403781541615130e-10,  3.434750569735543e-12, -7.151090521610281e-14,
  1.310736899723448e-15, -2.163927148719685e-17,  3.270608480833299e-19, -4.580908033323240e-21,  6.001866900669221e-23, -7.409820188315774e-25,  4.704182087984812e-07,
 -3.964283119427416e-08,  1.833936743900297e-09, -6.101547008640648e-11,  1.624559845960858e-12, -3.663502102969548e-14,  7.245197675594814e-16, -1.286362347246173e-17,
  2.084962360237785e-19, -3.123772334443023e-21,  4.368157254580693e-23, -5.744042433790668e-25,  1.443459643387161e-07, -1.350045387423372e-08,  6.866172371699259e-10,
 -2.494091364051996e-11,  7.211342261858844e-13, -1.758288369781320e-14,  3.746018755228609e-16, -7.142463960749751e-18,  1.239823018172932e-19, -1.984564012817132e-21,
  2.958455997118211e-23, -4.139082730218461e-25,  4.216459846204756e-08, -4.357925786745046e-09,  2.429316622310704e-10, -9.611665488568341e-12,  3.012023475992149e-13,
 -7.927015587546045e-15,  1.816613366022211e-16, -3.714618165265266e-18,  6.896972349585077e-20, -1.178098197821150e-21,  1.870191404764604e-23, -2.780942067403397e-25,
  1.174904274662746e-08, -1.336564607343264e-09,  8.143157740953495e-11, -3.501418585855051e-12,  1.186975377240808e-13, -3.366379360596762e-15,  8.286308855430109e-17,
 -1.814756746823474e-18,  3.599760634759534e-20, -6.554340023426909e-22,  1.106833506554911e-23, -1.747521314292235e-25,  3.130198064150161e-09, -3.904833650804789e-10,
  2.593139660074635e-11, -1.209128380011968e-12,  4.426071887624610e-14, -1.350595590972243e-15,  3.565831390162244e-17, -8.353601911072089e-19,  1.768214252721138e-20,
 -3.428098493809228e-22,  6.151980884889141e-24, -1.030319027973830e-25,  7.994444714803939e-10, -1.089808780992831e-10,  7.868084706715476e-12, -3.970107816093210e-13,
  1.566498353429746e-14, -5.135176126271300e-16,  1.452228052505059e-17, -3.634679449711747e-19,  8.200486492323946e-21, -1.691073665517801e-22,  3.221828108070722e-24,
 -5.718309747321710e-26,  1.963033216842346e-10, -2.914685330249884e-11,  2.282050518935906e-12, -1.243550191740751e-13,  5.279867398546810e-15, -1.856573122383924e-16,
  5.616312111869210e-18, -1.499929436700711e-19,  3.603042850237511e-21, -7.894848732458125e-23,  1.595279118766140e-24, -2.997831733471822e-26,  4.649698348400683e-11,
 -7.495977257220472e-12,  6.349394855946451e-13, -3.729180369009796e-14,  1.700854302550989e-15, -6.405772257372751e-17,  2.070092565320527e-18, -5.892093193483579e-20,
  1.505244076314713e-21, -3.500902686528404e-23,  7.495501494470320e-25, -1.489953750962976e-26,  1.066327771337368e-11, -1.860900098288408e-12,  1.701299546472091e-13,
 -1.074871438591132e-14,  5.257409100860674e-16, -2.117600662180322e-17,  7.300606418125850e-19, -2.211909811567589e-20,  6.002781343485500e-22, -1.480357034709832e-23,
  3.354935785268045e-25, -7.047715554931560e-27,  2.377553591976693e-12, -4.478362585904710e-13,  4.408922932440929e-14, -2.990619027415098e-15,  1.566046197086608e-16,
 -6.735846649512574e-18,  2.474077999107271e-19, -7.969104663814715e-21,  2.294780781776951e-22, -5.994145520780274e-24,  1.436482465067747e-25, -3.185927154919166e-27,
  5.177980617887472e-13, -1.049685702000487e-13,  1.110298258746086e-14, -8.070088547683093e-16,  4.516574337718019e-17, -2.071323592982563e-18,  8.094148063281695e-20,
 -2.768206254902709e-21,  8.448100487295400e-23, -2.334703527660314e-24,  5.910188021657619e-26, -1.382516597416892e-27,  1.107205030180676e-13, -2.408816575476595e-14,
  2.731261659252704e-15, -2.123050780801409e-16,  1.267719039734479e-17, -6.189140096560316e-19,  2.569392149620439e-20, -9.317731610031471e-22,  3.009949790888524e-23,
 -8.790421416965529e-25,  2.347975687911447e-26, -5.786753981144089e-28,  2.337909451865852e-14, -5.443137604883650e-15,  6.600717634063008e-16, -5.476181627557016e-17,
  3.482523725767764e-18, -1.807013105035614e-19,  7.957655320986039e-21, -3.055691501918699e-22,  1.043461765060096e-23, -3.216368150261543e-25,  9.054232212006812e-27,
 -2.348411343701430e-28,  4.905877170742177e-15, -1.218834957794920e-15,  1.577078462732944e-16, -1.393589081890854e-17,  9.420968553758974e-19, -5.186568817251582e-20,
  2.419015857188251e-21, -9.821160585641602e-23,  3.540298647905656e-24, -1.150247343512229e-25,  3.408232365929599e-27, -9.291895911057575e-29,  1.030213353459449e-15,
 -2.723354465108911e-16,  3.750892896207467e-17, -3.522739893609025e-18,  2.526604028939108e-19, -1.473174032467681e-20,  7.264640755521131e-22, -3.113493192322724e-23,
  1.182991328086853e-24, -4.045505358293708e-26,  1.259991305008086e-27, -3.605967467805835e-29,  2.181588178917576e-16, -6.118048407753579e-17,  8.947096345539174e-18,
 -8.910807708130394e-19,  6.766615556565957e-20, -4.170459191288741e-21,  2.170496437003160e-22, -9.802990081817648e-24,  3.919593811319770e-25, -1.408626415258243e-26,
  4.604668936109630e-28, -1.381354578609289e-29,  4.697285518538642e-17, -1.393247882683778e-17,  2.157763333709511e-18, -2.273511199939328e-19,  1.823863690345390e-20,
 -1.185774721296344e-21,  6.500451534024077e-23, -3.088172699540588e-24,  1.297065713993615e-25, -4.890361328787900e-27,  1.675096616263318e-28, -5.259092629986638e-30,
  1.037552856596331e-17, -3.244647071407022e-18,  5.307101364688531e-19, -5.900825128704944e-20,  4.989106462618870e-21, -3.413978268575044e-22,  1.967192898047437e-23,
 -9.810332225833110e-25,  4.319946895795797e-26, -1.705571827551306e-27,  6.110577039730778e-29, -2.004280733212941e-30,  2.373347056332443e-18, -7.799717756971951e-19,
  1.343453551963523e-19, -1.572056292001179e-20,  1.397293031478298e-21, -1.003929419566845e-22,  6.066397119304551e-24, -3.168721672838019e-25,  1.459779793264084e-26,
 -6.022800659879884e-28,  2.252476567054214e-29, -7.703777632079214e-31,  5.677881443112062e-19, -1.954313171565892e-19,  3.533890786409306e-20, -4.339414254532055e-21,
  4.043573865943548e-22, -3.042407367483853e-23,  1.923053471853269e-24, -1.049559556563438e-25,  5.046633664996938e-27, -2.170944570949461e-28,  8.456814397738626e-30,
 -3.009477389275632e-31,  1.435090477403790e-19, -5.155240571880336e-20,  9.754351934052570e-21, -1.253016937673532e-21,  1.220431241403485e-22, -9.588709378865209e-24,
  6.322439780774614e-25, -3.595905593445060e-26,  1.800019757811863e-27, -8.053362172041672e-29,  3.259720545619902e-30, -1.204156961203040e-31,  3.870976767408135e-20,
 -1.445984813670886e-20,  2.852899661243172e-21, -3.820950496739926e-22,  3.877492675937431e-23, -3.171343953649233e-24,  2.174774384529799e-25, -1.285235738995568e-26,
  6.678846064657343e-28, -3.099311097654236e-29,  1.300041260329844e-30, -4.972249796877422e-32,  1.125116521211929e-20, -4.353774804195170e-21,  8.923754795274426e-22,
 -1.241643600734296e-22,  1.308243771476304e-23, -1.110103039901780e-24,  7.891541331528924e-26, -4.830571288252483e-27,  2.597938745183938e-28, -1.246680580538532e-29,
  5.403426271531407e-31, -2.133656598883511e-32,  3.554135843086066e-21, -1.419127332849901e-21,  3.009873686120668e-22, -4.334001032520963e-23,  4.723524896923248e-24,
 -4.143261808612533e-25,  3.042510621419746e-26, -1.922394212797013e-27,  1.066424813336971e-28, -5.274759502472894e-30,  2.354823872974429e-31, -9.570365638740915e-33,
  1.228187155674822e-21, -5.039756534571938e-22,  1.101461974017010e-22, -1.634623052723965e-23,  1.835429739622884e-24, -1.657742453291353e-25,  1.252689256441571e-26,
 -8.139830013016525e-28,  4.640763689912035e-29, -2.357633606356350e-30,  1.080388236766452e-31, -4.504110552611377e-33,  4.655861344093034e-22, -1.955201701593506e-22,
  4.384073707672558e-23, -6.676393145879192e-24,  7.690422163456260e-25, -7.122296259753511e-26,  5.515866637758218e-27, -3.671311817280267e-28,  2.142878889565127e-29,
 -1.113924010450183e-30,  5.220389239729114e-32, -2.224477710724937e-33,  1.927859480148483e-22, -8.250087176806625e-23,  1.889197579916806e-23, -2.938774796451163e-24,
  3.457032617659926e-25, -3.268474436279336e-26,  2.583036352918313e-27, -1.753643575437328e-28,  1.043591802517649e-29, -5.528565615805848e-31,  2.639351968977339e-32,
 -1.145132036947683e-33,  8.551489334920840e-23, -3.713001597037330e-23,  8.641849678964157e-24, -1.366601028500937e-24,  1.634016644611067e-25, -1.569846951683086e-26,
  1.260273029679248e-27, -8.688660832936301e-29,  5.248957993254541e-30, -2.821889177765320e-31,  1.366676848788772e-32, -6.013209643018021e-34,  3.824057004990919e-23,
 -1.677212401949057e-23,  3.948215109915660e-24, -6.315846952729420e-25,  7.638309110063326e-26, -7.421095370142271e-27,  6.023520833274244e-28, -4.197719521021621e-29,
  2.562751919831978e-30, -1.392017382142691e-31,  6.809908571133844e-33, -3.025807422283286e-34,  1.347791931547183e-23, -5.944671990078145e-24,  1.408304440393201e-24,
 -2.267366220029390e-25,  2.759673226843663e-26, -2.698075894765971e-27,  2.203482607037392e-28, -1.544862627176802e-29,  9.487317564570065e-31, -5.183047580832846e-32,
  2.549936330793855e-33, -1.139238217262589e-34,  5.067513989406906e-02, -1.054555832390348e-04,  2.259997967181509e-07, -4.968390293630278e-10,  1.114762123385227e-12,
 -2.540461520532701e-15,  5.851967127262975e-18, -1.358114514392137e-20,  3.164169873320612e-23, -7.392523902142407e-26,  1.726730241542213e-28, -4.037029537256280e-31,
  4.753114326570414e-02, -1.173505141894630e-04,  3.409882056381783e-07, -1.047587525949336e-09,  3.231526728519910e-12, -9.843043794024361e-15,  2.950320425740616e-17,
 -8.709473852360838e-20,  2.536257950081321e-22, -7.298480525699657e-25,  2.078073927440033e-27, -5.861727720725014e-30,  4.181762256654233e-02, -1.357285243422363e-04,
  5.459520312878470e-07, -2.170417616889682e-09,  8.270795407056854e-12, -3.037720682048455e-14,  1.083206228030003e-16, -3.769935884968052e-19,  1.285328524996174e-21,
 -4.304543421804880e-24,  1.418962641556091e-26, -4.611751521797491e-29,  3.451178249481282e-02, -1.523150779429002e-04,  7.943353837168054e-07, -3.833794323356942e-09,
  1.732457317260964e-11, -7.458091824644530e-14,  3.090394535672519e-16, -1.240760292313114e-18,  4.849337859089864e-21, -1.851535875550893e-23,  6.925318966494650e-26,
 -2.543107078734277e-28,  2.672064117520250e-02, -1.596556153472877e-04,  1.027102117234712e-06, -5.863997112658245e-09,  3.090786833564806e-11, -1.536450180159462e-13,
  7.290562957045231e-16, -3.328729466202080e-18,  1.470941686176816e-20, -6.318587736952985e-23,  2.647522138020177e-25, -1.085010598241373e-27,  1.941146471328915e-02,
 -1.540184809883774e-04,  1.187818496181739e-06, -7.918023845993154e-09,  4.813255805766156e-11, -2.732207581952523e-13,  1.468693007955322e-15, -7.548118658153494e-18,
  3.734506996344235e-20, -1.787992353865201e-22,  8.317291655102198e-25, -3.771054871944122e-27,  1.323364083836467e-02, -1.362619490947296e-04,  1.239404171930396e-06,
 -9.559043087024815e-09,  6.641117089159280e-11, -4.267264156183258e-13,  2.577372407023961e-15, -1.479470763739947e-17,  8.135210855407455e-20, -4.310544003871481e-22,
  2.210967689478305e-24, -1.101759937318721e-26,  8.468493781171918e-03, -1.106630063675275e-04,  1.175004008050951e-06, -1.040628422303468e-08,  8.201195926968853e-11,
 -5.923729744942877e-13,  3.994019975689763e-15, -2.545032363630100e-17,  1.546257455525181e-19, -9.016541993095600e-22,  5.072003141746470e-24, -2.763390409706337e-26,
  5.088095108592124e-03, -8.270326246385098e-05,  1.017463834394092e-06, -1.027932622682586e-08,  9.132582111173524e-11, -7.372951142290146e-13,  5.519905413359020e-15,
 -3.884948843503690e-17,  2.595502822170633e-19, -1.657998973038801e-21,  1.018352014456823e-23, -6.040447652598726e-26,  2.871211667972901e-03, -5.703511273130722e-05,
  8.080297165400360e-07, -9.258291605274740e-09,  9.223891796147209e-11, -8.283320751683886e-13,  6.855317293059864e-15, -5.306656875293000e-17,  3.882974615555762e-19,
 -2.706866381511275e-21,  1.808646793312457e-23, -1.163825457551999e-25,  1.522297727166843e-03, -3.639365032239529e-05,  5.904845764936370e-07, -7.633469370497876e-09,
  8.489467013487420e-11, -8.445375322600222e-13,  7.696803488428298e-15, -6.529484948493787e-17,  5.214889262245414e-19, -3.954287389588452e-21,  2.865271082750644e-23,
 -1.994104315159399e-25,  7.586639223047779e-04, -2.153977598112218e-05,  3.981920590299688e-07, -5.781030505181928e-09,  7.148250421099808e-11, -7.849060795064236e-13,
  7.851061392182509e-15, -7.276354598508855e-17,  6.324362015463590e-19, -5.201564463460119e-21,  4.076289221677572e-23, -3.060275193009233e-25,  3.555794493892299e-04,
 -1.185113640780732e-05,  2.484092181588085e-07, -4.033338834156188e-09,  5.525148027870242e-11, -6.674983741853631e-13,  7.306366758430875e-15, -7.377507633766314e-17,
  6.960193772830286e-19, -6.193822218610078e-21,  5.237140942874741e-23, -4.231672456715991e-25,  1.568259485440317e-04, -6.073951754268141e-06,  1.436901130493719e-07,
 -2.599286276421405e-09,  3.932029340949400e-11, -5.211507375036537e-13,  6.226068330037961e-15, -6.832550696889161e-17,  6.980768129096225e-19, -6.706725184588164e-21,
  6.105786430084800e-23, -5.299163080246553e-25,  6.513118804048521e-05, -2.905384810898446e-06,  7.723241174660332e-08, -1.551086684058396e-09,  2.583468811837782e-11,
 -3.746786199876654e-13,  4.873934340992911e-15, -5.800371409272205e-17,  6.404563033239352e-19, -6.630068811550944e-21,  6.486858763050258e-23, -6.036282944535383e-25,
  2.549116864588743e-05, -1.299408557244029e-06,  3.865230830138979e-08, -8.590371459493738e-10,  1.571108863688631e-11, -2.487347618591841e-13,  3.515533913942690e-15,
 -4.528043252854919e-17,  5.393231891107380e-19, -6.005296766332588e-21,  6.303879219422737e-23, -6.279337981380576e-25,  9.410437778707843e-06, -5.443351319131891e-07,
  1.804775916788434e-08, -4.425333961942058e-10,  8.864939177686365e-12, -1.528715793264370e-13,  2.342916902036382e-15, -3.260093734062174e-17,  4.181550987930444e-19,
 -5.000180372189918e-21,  5.622847982121788e-23, -5.986890254891381e-25,  3.280161206340749e-06, -2.139600842742828e-07,  7.877855425819311e-09, -2.125132500067039e-10,
  4.651918977146371e-12, -8.720037368204209e-14,  1.446539005154159e-15, -2.170854880250436e-17,  2.993861094878188e-19, -3.838910443730231e-21,  4.618210978555213e-23,
 -5.249065549428725e-25,  1.080824996696422e-06, -7.905463484940845e-08,  3.221111522909992e-09, -9.534121805784551e-11,  2.275552554873551e-12, -4.627863022195384e-14,
  8.295358381211502e-16, -1.340570022936862e-17,  1.984996554067422e-19, -2.725705921960507e-21,  3.503371435390710e-23, -4.245503416501180e-25,  3.371101619008025e-07,
 -2.750830381314445e-08,  1.236285466891371e-09, -4.004946127196687e-11,  1.040065176510592e-12, -2.290777565151084e-14,  4.429838074833607e-16, -7.697797283384921e-18,
  1.222150837248889e-19, -1.794913123434773e-21,  2.461948030372141e-23, -3.177369765290286e-25,  9.967981659755485e-08, -9.032391210905632e-09,  4.463647055834884e-10,
 -1.578824875170694e-11,  4.452458685613991e-13, -1.060263926856437e-14,  2.208591613827903e-16, -4.121220393437969e-18,  7.006911011615943e-20, -1.099349257600346e-21,
  1.607385252217976e-23, -2.206981417666267e-25,  2.799083573050444e-08, -2.804574367742631e-09,  1.519557842787965e-10, -5.855195823034946e-12,  1.789756660387463e-13,
 -4.600424148034745e-15,  1.030799704732024e-16, -2.062787615005503e-18,  3.751295542647492e-20, -6.280586905262853e-22,  9.778708830924600e-24, -1.426989665027800e-25,
  7.479205388561606e-09, -8.253863776415775e-10,  4.889559940172886e-11, -2.048011761930933e-12,  6.773146242906030e-14, -1.876339155049924e-15,  4.516140868702798e-17,
 -9.680104907665020e-19,  1.880787828095221e-20, -3.356684911967147e-22,  5.559796766949508e-24, -8.614913771496979e-26,  1.905900140436946e-09, -2.308175182964682e-10,
  1.491086437295197e-11, -6.774869832414464e-13,  2.419980340484743e-14, -7.214403866459803e-16,  1.862780783709385e-17, -4.271576752513875e-19,  8.857390481397810e-21,
 -1.683400600705405e-22,  2.963394750899740e-24, -4.871271837312084e-26,  4.643601089412094e-10, -6.150459467063997e-11,  4.321902703064047e-12, -2.125877182668994e-13,
  8.187898677466071e-15, -2.622995949217794e-16,  7.256125760384659e-18, -1.778034962156605e-19,  3.930548373101199e-21, -7.947247313009058e-23,  1.485492572635644e-24,
 -2.588232418191138e-26,  1.084854506726741e-10, -1.566422601489351e-11,  1.194444141012041e-12, -6.348193888120019e-14,  2.632061047773846e-15, -9.047720790090428e-17,
  2.678199479945185e-18, -7.004722079008841e-20,  1.649087811448134e-21, -3.543781398971102e-23,  7.027109391280986e-25, -1.296625067214247e-26,  2.438180119597116e-11,
 -3.826098843076832e-12,  3.158600319881986e-13, -1.810408031023083e-14,  8.067400986152969e-16, -2.971554207711916e-17,  9.400243665030076e-19, -2.621235100220235e-20,
  6.565164255681706e-22, -1.497984642736352e-23,  3.148317629890859e-25, -6.146768813515642e-27,  5.290984614411551e-12, -8.997059347823266e-13,  8.023063725707180e-14,
 -4.950047292014698e-15,  2.366920544561964e-16, -9.328903702974836e-18,  3.149864033497717e-19, -9.353653098532222e-21,  2.489721600344360e-22, -6.025958776748067e-24,
  1.341095552213046e-25, -2.768087618868550e-27,  1.113230812947948e-12, -2.045419608129682e-13,  1.965900395060881e-14, -1.303209713691544e-15,  6.675918172559435e-17,
 -2.811514333405422e-18,  1.011938511655584e-19, -3.196401255347415e-21,  9.032219304801495e-23, -2.316586761496071e-24,  5.454255113540447e-26, -1.189099628290530e-27,
  2.281588462986123e-13, -4.517026545289539e-14,  4.668948192223330e-15, -3.319333801883269e-16,  1.818728174702131e-17, -8.172475881244260e-19,  3.131507193921207e-20,
 -1.050893039014272e-21,  3.149005595652951e-23, -8.549787916265521e-25,  2.127503528540437e-26, -4.894523871855445e-28,  4.578922764670415e-14, -9.740807381626717e-15,
  1.080430263563528e-15, -8.222313382678760e-17,  4.810763794246585e-18, -2.303097118523360e-19,  9.382331311373606e-21, -3.340967587346194e-22,  1.060387459057065e-23,
 -3.044392830592387e-25,  7.998263775815664e-27, -1.939836945121233e-28,  9.051072709617282e-15, -2.063228900476172e-15,  2.450321060722852e-16, -1.992298163152871e-17,
  1.242617795785778e-18, -6.328165591464006e-20,  2.736905600461863e-21, -1.032778016984714e-22,  3.467708902629505e-24, -1.051548710140377e-25,  2.913578049569962e-27,
 -7.441624709074564e-29,  1.773659947814407e-15, -4.320387551165698e-16,  5.481389484426242e-17, -4.752233248105048e-18,  3.154079718907054e-19, -1.705886393637980e-20,
  7.821030323023161e-22, -3.123120931916776e-23,  1.107888336938575e-24, -3.543986674893197e-26,  1.034370458329854e-27, -2.779033435716169e-29,  3.470563203986103e-16,
 -9.007941577062405e-17,  1.218075023032912e-17, -1.123729283444867e-18,  7.921650747263274e-20, -4.542361867267868e-21,  2.204096650019290e-22, -9.299916890168078e-24,
  3.480484151118764e-25, -1.172890485175905e-26,  3.601362277192941e-28, -1.016530604396809e-29,  6.834855629381062e-17, -1.884799846079853e-17,  2.709823582651072e-18,
 -2.654402192001917e-19,  1.983517347046438e-20, -1.203617575317941e-21,  6.170505420465012e-23, -2.746522664482021e-24,  1.082738014583611e-25, -3.838131351897399e-27,
  1.238049635170460e-28, -3.666340263764159e-30,  1.366525975719952e-17, -3.991722874054891e-18,  6.086361340670648e-19, -6.315687044403656e-20,  4.992056071232377e-21,
 -3.199280404846342e-22,  1.729620978203435e-23, -8.106851303180354e-25,  3.360722275784294e-26, -1.251121363931948e-27,  4.232973025583171e-29, -1.313175087220052e-30,
  2.799860780191521e-18, -8.636396010897024e-19,  1.392778359093422e-19, -1.527254539573669e-20,  1.273975412294922e-21, -8.604251111109368e-23,  4.895367472743044e-24,
 -2.411426123277889e-25,  1.049250567789881e-26, -4.094799768890065e-28,  1.450610729116737e-29, -4.706285499132413e-31,  5.938045243005135e-19, -1.927895705724703e-19,
  3.278996261929350e-20, -3.789527575758298e-21,  3.327684420312673e-22, -2.362903185202286e-23,  1.411600756622622e-24, -7.292046734002805e-26,  3.323360505262662e-27,
 -1.356900128109147e-28,  5.023398354679613e-30, -1.701216242927797e-31,  1.317463741771354e-19, -4.486938926118506e-20,  8.023910536566327e-21, -9.745423843476051e-22,
  8.984338214071116e-23, -6.689856368826175e-24,  4.185994031061479e-25, -2.262291894489420e-26,  1.077457149071066e-27, -4.592205886355839e-29,  1.772828731171369e-30,
 -6.253943611053493e-32,  3.091608693081188e-20, -1.100595594251082e-20,  2.062614826907089e-21, -2.624557685633861e-22,  2.532702198763640e-23, -1.972008556617427e-24,
  1.288902477069051e-25, -7.268384540425681e-27,  3.608325842888872e-28, -1.601421366484181e-29,  6.431406866709873e-31, -2.357796177822664e-32,  7.758626627090911e-21,
 -2.876406963421773e-21,  5.629480851926640e-22, -7.479461529586274e-23,  7.530768734761535e-24, -6.112338907926795e-25,  4.160483714551689e-26, -2.440997409889721e-27,
  1.259587264105703e-28, -5.805225105471420e-30,  2.418911583562854e-31, -9.191996673036759e-33,  2.104749525368824e-21, -8.094836763242481e-22,  1.648231912914501e-22,
 -2.278271971914031e-23,  2.385010249218089e-24, -2.011064956731840e-25,  1.420881537809547e-26, -8.645696444631634e-28,  4.622818421214998e-29, -2.205863731179376e-30,
  9.508352135751017e-32, -3.734592610924249e-33,  6.232600162292309e-22, -2.476680642455018e-22,  5.225466942401156e-23, -7.485054773421690e-24,  8.115992830375631e-25,
 -7.083361679534914e-26,  5.176145691568420e-27, -3.254996584851340e-28,  1.797329432854900e-29, -8.850011846864254e-31,  3.933654590973356e-32, -1.591910667584603e-33,
  2.030326737564723e-22, -8.301277966169474e-23,  1.807114692776351e-23, -2.671226573136610e-24,  2.987692942148196e-25, -2.688180238165804e-26,  2.023806899755987e-27,
 -1.310290107490341e-28,  7.444056800080046e-30, -3.768820959196921e-31,  1.721305034284918e-32, -7.152834170475496e-34,  7.305455800150979e-23, -3.060057020212921e-23,
  6.842088350793809e-24, -1.039009977698553e-24,  1.193475414906487e-25, -1.102287634924692e-26,  8.513909000688807e-28, -5.652054345972590e-29,  3.290651263392023e-30,
 -1.706348963120527e-31,  7.977584994785613e-33, -3.391431647945097e-34,  2.894509905144360e-23, -1.236608026347990e-23,  2.826455916516961e-24, -4.388505206940683e-25,
  5.152883667910736e-26, -4.863007612122562e-27,  3.836380954909548e-28, -2.600056797591668e-29,  1.544690331240703e-30, -8.169795869173546e-32,  3.894057223005696e-33,
 -1.686889409700805e-34,  1.239879382615240e-23, -5.378214823004114e-24,  1.250385469776912e-24, -1.975142861598152e-25,  2.359057423553889e-26, -2.263985587553917e-27,
  1.815622497847509e-28, -1.250457696720684e-29,  7.546667902667237e-31, -4.053206238494613e-32,  1.961153655830248e-33, -8.620858406834798e-35,  5.408637028230370e-24,
 -2.371046073512352e-24,  5.578459505899608e-25, -8.918739160803010e-26,  1.078027032914567e-26, -1.046802882050180e-27,  8.492124844082258e-29, -5.914979678185181e-30,
  3.609318337375537e-31, -1.959507489350054e-32,  9.581466768162746e-34, -4.255256651051573e-35,  1.879733041509627e-24, -8.289144547097600e-25,  1.963244372182635e-25,
 -3.160045860862086e-26,  3.845240864194599e-27, -3.758506449904601e-28,  3.068791699468630e-29, -2.151026858313877e-30,  1.320684799700577e-31, -7.213438319342081e-33,
  3.548047734789202e-34, -1.584818486718340e-35,  5.025689622113342e-02, -1.036711337359588e-04,  2.201430931953599e-07, -4.794018055320659e-10,  1.065327144103846e-12,
 -2.404465570099989e-15,  5.485479767398417e-18, -1.260989265147042e-20,  2.910055193785337e-23, -6.736068058104759e-26,  1.558646678450359e-28, -3.611610371602861e-31,
  4.706711862507525e-02, -1.146720284858589e-04,  3.287210078788991e-07, -9.974203260691222e-10,  3.041553729580023e-12, -9.163337329456857e-15,  2.717433751915985e-17,
 -7.938355379348606e-20,  2.287873684568040e-22, -6.516600298854255e-25,  1.836663217580588e-27, -5.128837773747097e-30,  4.128328186617929e-02, -1.314628837543405e-04,
  5.206814152250672e-07, -2.042807500532593e-09,  7.688416625221902e-12, -2.789967333690106e-14,  9.831809192368576e-17, -3.382367962201742e-19,  1.140110872992836e-21,
 -3.775535458045527e-24,  1.230845740452425e-26, -3.956730326304829e-29,  3.391494668721611e-02, -1.461398155189863e-04,  7.499450613056473e-07, -3.568142616330708e-09,
  1.590439831097400e-11, -6.756392892176460e-14,  2.763741522616827e-16, -1.095732827428644e-18,  4.230064348874274e-21, -1.595663222623956e-23,  5.897624327046411e-26,
 -2.140442483870416e-28,  2.609801825221855e-02, -1.517120908480266e-04,  9.596028967243097e-07, -5.393134491547164e-09,  2.800265815725849e-11, -1.372149617555970e-13,
  6.421137761094957e-16, -2.892469126929956e-18,  1.261437937411714e-20, -5.349208065502093e-23,  2.213149532044061e-25, -8.957708408439763e-28,  1.881381206608050e-02,
 -1.448833093076696e-04,  1.097248623007289e-06, -7.189772565244841e-09,  4.300418355953445e-11, -2.403789798975205e-13,  1.273152581119479e-15, -6.449954788999786e-18,
  3.146920797571731e-20, -1.486254031550562e-22,  6.821898294678684e-25, -3.052730013975551e-27,  1.270772169486989e-02, -1.267881134160160e-04,  1.130800002189884e-06,
 -8.561515416632000e-09,  5.846311917146268e-11, -3.695600814111209e-13,  2.197349885273818e-15, -1.242356367919517e-17,  6.731576460601091e-20, -3.516002067479577e-22,
  1.778309394540004e-24, -8.740609903377036e-27,  8.043881288911219e-03, -1.017410364258105e-04,  1.057627011432060e-06, -9.183896947151507e-09,  7.106811052708538e-11,
 -5.045373265211162e-13,  3.346069467564237e-15, -2.098475684738440e-17,  1.255428388549028e-19, -7.211577088216147e-22,  3.997658570764242e-24, -2.147046045253478e-26,
  4.772813899618120e-03, -7.503319451815416e-05,  9.024149284111221e-07, -8.929235992179993e-09,  7.782121176275951e-11, -6.169847430572696e-13,  4.539956945531786e-15,
 -3.142518925022045e-17,  2.065960649420774e-19, -1.299247845935108e-21,  7.859319774448931e-24, -4.592898234127828e-26,  2.655329892336713e-03, -5.099138740626421e-05,
  7.052660891133244e-07, -7.906543754830249e-09,  7.720408945619519e-11, -6.803160299870676e-13,  5.529701405967108e-15, -4.207001346600775e-17,  3.027258712424947e-19,
 -2.076356732180080e-21,  1.365609478271386e-23, -8.652932409552058e-26,  1.385621721063964e-03, -3.201431033361462e-05,  5.065063286012262e-07, -6.400833312853523e-09,
  6.971227851294477e-11, -6.799916460268558e-13,  6.082257070868875e-15, -5.067976787388684e-17,  3.978109190602677e-19, -2.966258022567773e-21,  2.114547104178444e-23,
 -1.448400034570011e-25,  6.784624891197200e-04, -1.861341555440217e-05,  3.351953399397387e-07, -4.753311302015309e-09,  5.751473333833170e-11, -6.188046614780634e-13,
  6.070962401237639e-15, -5.523157936499676e-17,  4.715485679693062e-19, -3.811781625737064e-21,  2.937369648388021e-23, -2.169421260903457e-25,  3.118628703294474e-04,
 -1.004339053368438e-05,  2.049017919018997e-07, -3.247246949276888e-09,  4.349990173957769e-11, -5.146096210762617e-13,  5.521644794144359e-15, -5.469961117716559e-17,
  5.066527408360831e-19, -4.429188603261579e-21,  3.680981657633472e-23, -2.924737521537690e-25,  1.346457549008899e-04, -5.039243927538194e-06,  1.159540914493376e-07,
 -2.046034651632960e-09,  3.024872970132483e-11, -3.923655264287270e-13,  4.592509436084543e-15, -4.942089013601209e-17,  4.954989282545719e-19, -4.674507999402007e-21,
  4.181110434409990e-23, -3.566923804961854e-25,  5.463670332359076e-05, -2.355481443690465e-06,  6.087138688713143e-08, -1.191837831108062e-09,  1.939040180312844e-11,
 -2.750813994632596e-13,  3.504163201631540e-15, -4.087498460478022e-17,  4.427108253407467e-19, -4.498443658582005e-21,  4.322559718613538e-23, -3.952389669253413e-25,
  2.085225418831037e-05, -1.027500756991334e-06,  2.970171310187834e-08, -6.432714143936938e-10,  1.148671601761414e-11, -1.778095922831221e-13,  2.459977688277382e-15,
 -3.104386555128810e-17,  3.625607469210918e-19, -3.961197787627469e-21,  4.082420162419369e-23, -3.994580128491075e-25,  7.491349889832343e-06, -4.189973510659866e-07,
  1.349660692486348e-08, -3.223838030543109e-10,  6.303030068701594e-12, -1.062354335160590e-13,  1.593182956834955e-15, -2.171280493430593e-17,  2.729913237297084e-19,
 -3.202020899161866e-21,  3.534163865440908e-23, -3.695392197866988e-25,  2.535841410736442e-06, -1.599937966466887e-07,  5.722317452898462e-09, -1.503370263641498e-10,
  3.210941978271726e-12, -5.881091685666209e-14,  9.543504087885167e-16, -1.402367403332176e-17,  1.895264839064805e-19, -2.383201959181500e-21,  2.813274658323104e-23,
 -3.139418281680478e-25,  8.096875171666752e-07, -5.730707144995693e-08,  2.268110037259556e-09, -6.537102486736390e-11,  1.522021743304657e-12, -3.023814303586788e-14,
  5.300878297966705e-16, -8.386045335250036e-18,  1.216577722688594e-19, -1.637884126146286e-21,  2.065332927697799e-23, -2.456864899899796e-25,  2.441715523596565e-07,
 -1.928889735449923e-08,  8.421075814278317e-10, -2.656204678228110e-11,  6.728204957542909e-13, -1.447422640855233e-14,  2.736952036475183e-16, -4.655100594723280e-18,
  7.239849702127989e-20, -1.042328677323918e-21,  1.402412173064533e-23, -1.776448467234732e-25,  6.964404664407313e-08, -6.112625298022096e-09,  2.934873226036607e-10,
 -1.010784061052453e-11,  2.780213884720249e-13, -6.465941037421593e-15,  1.316917973996267e-16, -2.404962042056318e-18,  4.005037201597218e-20, -6.159262111837508e-22,
  8.832976679768510e-24, -1.190242095810216e-25,  1.881933532017722e-08, -1.827503901606444e-09,  9.622591114562200e-11, -3.610677320001308e-12,  1.076492936086370e-13,
 -2.702423453586370e-15,  5.920314658792086e-17, -1.159440746933607e-18,  2.065166841491364e-20, -3.388979436444040e-22,  5.175196010472798e-24, -7.411393319118890e-26,
  4.827020831847840e-09, -5.166138543187986e-10,  2.975153797123269e-11, -1.213753309168471e-12,  3.915711924308613e-14, -1.059504449180912e-15,  2.493417790286826e-17,
 -5.230526190710338e-19,  9.953944006161609e-21, -1.741281857489302e-22,  2.828795881802785e-24, -4.301654951385886e-26,  1.177738543673878e-09, -1.384244821259225e-10,
  8.696869090687131e-12, -3.849846776388848e-13,  1.341731622368071e-14, -3.907445715600719e-16,  9.866071067110940e-18, -2.214386958449681e-19,  4.497804947237242e-21,
 -8.379563646881542e-23,  1.446910401004761e-24, -2.334370985070302e-26,  2.740223137656447e-10, -3.525116815176297e-11,  2.410344513160363e-12, -1.155544970952605e-13,
  4.343687684006777e-15, -1.359644628240781e-16,  3.678833487040207e-18, -8.824812799704170e-20,  1.911251140859431e-21, -3.788658158789368e-23,  6.947348534686065e-25,
 -1.188193666940254e-26,  6.096942895881417e-11, -8.557643159936483e-12,  6.353432043679711e-13, -3.292589991495293e-14,  1.332860105794142e-15, -4.478253414893382e-17,
  1.296916972855392e-18, -3.321469258391442e-20,  7.662739386758413e-22, -1.614754634628015e-23,  3.141860880133332e-25, -5.691776645957775e-27,  1.301419906975226e-11,
 -1.987070127804625e-12,  1.598251203511319e-13, -8.937386513325820e-15,  3.890188274721146e-16, -1.401127683732443e-17,  4.338013039942933e-19, -1.184874230330649e-20,
  2.909023532786924e-22, -6.510812050488516e-24,  1.343067967675391e-25, -2.575173844370768e-27,  2.674733609244396e-12, -4.429784670273728e-13,  3.851666845838128e-14,
 -2.319951810906784e-15,  1.084167923159525e-16, -4.180368332309647e-18,  1.382063373632770e-19, -4.021719288911305e-21,  1.049748133644586e-22, -2.493137643404004e-24,
  5.447836980743742e-26, -1.104668414133765e-27,  5.314849396544222e-13, -9.521192122364153e-14,  8.930323161154854e-15, -5.783589642072185e-16,  2.897456052696585e-17,
 -1.194454668289274e-18,  4.211799854367448e-20, -1.304323743592262e-21,  3.615980173282293e-23, -9.104571196612388e-25,  2.105601062889062e-26, -4.511550328247162e-28,
  1.025824062545359e-13, -1.982391494837671e-14,  2.001521467417886e-15, -1.391313864905583e-16,  7.460768684412661e-18, -3.283858667953725e-19,  1.233498769150469e-20,
 -4.060763777325382e-22,  1.194455210759631e-23, -3.185368883970039e-25,  7.789753745329724e-27, -1.762149743826032e-28,  1.933346638256521e-14, -4.019512839325810e-15,
  4.359378909846864e-16, -3.246755499579875e-17,  1.860671937285777e-18, -8.732006212462259e-20,  3.489603800197818e-21, -1.219811837739252e-22,  3.802848954980120e-24,
 -1.073044164589778e-25,  2.772144114966580e-27, -6.614696995166815e-29,  3.579062320974111e-15, -7.983837867798967e-16,  9.281512215301694e-17, -7.392843059506489e-18,
  4.520570478051590e-19, -2.258656094769734e-20,  9.590557090116575e-22, -3.555296917830763e-23,  1.173409349994121e-24, -3.499529178396174e-26,  9.541125507800351e-28,
 -2.399084090526668e-29,  6.551306542678082e-16, -1.563757118694844e-16,  1.944406508893606e-17, -1.653208973658746e-18,  1.076809291465440e-19, -5.719298766495740e-21,
  2.576650700482950e-22, -1.011656899833848e-23,  3.530450305799910e-25, -1.111570571660619e-26,  3.194765844981542e-28, -8.456219034741197e-30,  1.194518735668069e-16,
 -3.042498276224920e-17,  4.037216180310144e-18, -3.656898024024714e-19,  2.532671888171390e-20, -1.427644440365358e-21,  6.813862681685611e-23, -2.829440124639712e-24,
  1.042652396439809e-25, -3.461322372431769e-27,  1.047442115393934e-28, -2.915093140312525e-30,  2.187359893690913e-17, -5.928111472634710e-18,  8.374939017589047e-19,
 -8.064839216807125e-20,  5.927748662056693e-21, -3.539998280487311e-22,  1.786990437612854e-23, -7.835845183053973e-25,  3.044593538349983e-26, -1.064191187860271e-27,
  3.386193087584383e-29, -9.895961972786639e-31,  4.059052269004692e-18, -1.167071122231320e-18,  1.751057549557673e-19, -1.788667738926250e-20,  1.392387906364744e-21,
 -8.792538413033718e-23,  4.685945664874130e-24, -2.166091157120430e-25,  8.859707191670083e-27, -3.255537978968971e-28,  1.087603678196691e-29, -3.332837606808394e-31,
  7.708665362119373e-19, -2.344183113300337e-19,  3.725535291867037e-20, -4.027091845067949e-21,  3.312763091396787e-22, -2.207370975693412e-23,  1.239540718279284e-24,
 -6.028873401402466e-26,  2.591156814610205e-27, -9.992106702765480e-29,  3.498929298242610e-30, -1.122465312298825e-31,  1.514249707601248e-19, -4.854551785021649e-20,
  8.149224460583426e-21, -9.297468993728496e-22,  8.062581914269262e-23, -5.655735860546576e-24,  3.339059576384545e-25, -1.705233755389808e-26,  7.685659024398420e-28,
 -3.104282883213483e-29,  1.137247589506358e-30, -3.812384734443572e-32,  3.111661945435846e-20, -1.048122747900348e-20,  1.852818624325195e-21, -2.224845185195329e-22,
  2.028428456110073e-23, -1.494170128905019e-24,  9.251829249161409e-26, -4.949443750412025e-27,  2.334075667544827e-28, -9.852961825008386e-30,  3.768434725854611e-31,
 -1.317399577577780e-32,  6.768639650661190e-21, -2.386939852858796e-21,  4.428901366471442e-22, -5.580109570073471e-23,  5.333082333790077e-24, -4.113611177824053e-25,
  2.664218742856897e-26, -1.489143238970950e-27,  7.329311358665934e-29, -3.225730518378319e-30,  1.284977853681842e-31, -4.673778510090091e-33,  1.577485333066197e-21,
 -5.802266911504957e-22,  1.126037838289491e-22, -1.483605625264392e-23,  1.481592420324949e-24, -1.192971455145176e-25,  8.057397361722086e-27, -4.691817137669901e-28,
  2.403350160778022e-29, -1.099796216339261e-30,  4.550967520641672e-32, -1.717803708053504e-33,  3.986030555732168e-22, -1.523194685111157e-22,  3.080049485792437e-23,
 -4.228140440360740e-24,  4.396407260356712e-25, -3.682734561484377e-26,  2.585326046615301e-27, -1.563317195740765e-28,  8.308425735154470e-30, -3.941199460877632e-31,
  1.689131790843307e-32, -6.597568640750926e-34,  1.104105674740788e-22, -4.365329556637988e-23,  9.159825448367724e-24, -1.304893322118732e-24,  1.407288812063500e-25,
 -1.221794787668758e-26,  8.882638122917680e-28, -5.558050685606879e-29,  3.054183873949032e-30, -1.496802487311003e-31,  6.622561031060688e-33, -2.668188004757250e-34,
  3.383216040323460e-23, -1.378031976185728e-23,  2.987389899745951e-24, -4.397500825103901e-25,  4.898360382021969e-26, -4.389686087033748e-27,  3.291914015975028e-28,
 -2.123224557970488e-29,  1.201798121648045e-30, -6.062672802470432e-32,  2.759278297414823e-33, -1.142719574565454e-34,  1.153047595450643e-23, -4.816811409871926e-24,
  1.073807322546442e-24, -1.625771708239476e-25,  1.861982393568198e-26, -1.714775621773744e-27,  1.320755273513918e-28, -8.744039010225274e-30,  5.077282196781684e-31,
 -2.625981797813836e-32,  1.224615376303548e-33, -5.193352134737229e-35,  4.363167614485013e-24, -1.860770665196615e-24,  4.244735889374529e-25, -6.577594010258199e-26,
  7.708232832307257e-27, -7.260744254365363e-28,  5.717277334769632e-29, -3.867781620629550e-30,  2.293783066414376e-31, -1.211082855599529e-32,  5.762835445113722e-34,
 -2.492371150934317e-35,  1.801994192258671e-24, -7.808443015849467e-25,  1.813297452788652e-25, -2.860999900602560e-26,  3.413172711600299e-27, -3.271926585378299e-28,
  2.621057657887159e-29, -1.803235951833800e-30,  1.087133263883891e-31, -5.832860206032421e-33,  2.819427419617385e-34, -1.238164368713875e-35,  7.659075034443572e-25,
 -3.355879428172399e-25,  7.890970421512003e-26, -1.260857961232623e-26,  1.523145213568648e-27, -1.478188213949612e-28,  1.198503378425665e-29, -8.343329018906436e-31,
  5.088382355615752e-32, -2.761055252527827e-33,  1.349394363760217e-34, -5.989864707372947e-36,  2.622998199053480e-25, -1.156422620127431e-25,  2.738251620008769e-26,
 -4.406384305250585e-27,  5.360469786148500e-28, -5.238248179042065e-29,  4.275935366697442e-30, -2.996429957261205e-31,  1.839304934081888e-32, -1.004372555058392e-33,
  4.939029483493987e-35, -2.205633314481259e-36,  4.984569794546839e-02, -1.019327141169813e-04,  2.144909788346864e-07, -4.627342508332955e-10,  1.018526283086471e-12,
 -2.276947950440128e-15,  5.145083666586067e-18, -1.171630185858248e-20,  2.678406492061345e-23, -6.143248480972762e-26,  1.408197605322711e-28, -3.234438548611352e-31,
  4.661361539319189e-02, -1.120893229976088e-04,  3.170380180761825e-07, -9.501869061525864e-10,  2.864632967499735e-12, -8.537019988544982e-15,  2.505066656101968e-17,
 -7.242396483301246e-20,  2.065973931457879e-22, -5.825133059809388e-25,  1.625298433114445e-27, -4.493545474835127e-30,  4.076560887790664e-02, -1.273934375334867e-04,
  4.968878061028062e-07, -1.924131722890006e-09,  7.153273165050658e-12, -2.564968632792534e-14,  8.933845634608388e-17, -3.038362374786396e-19,  1.012649744598359e-21,
 -3.316312872672022e-24,  1.069317783386004e-26, -3.400336028368635e-29,  3.334212134206068e-02, -1.403073002842087e-04,  7.086107195046037e-07, -3.324132242914757e-09,
  1.461704126394444e-11, -6.128433453280758e-14,  2.475054870742209e-16, -9.691242871299279e-19,  3.695913492207404e-21, -1.377562607288405e-23,  5.031816964781044e-26,
 -1.805099214985746e-28,  2.550612414168445e-02, -1.442867246670156e-04,  8.974856151107287e-07, -4.966235776415575e-09,  2.540613451170005e-11, -1.227322072905843e-13,
  5.664981323573847e-16, -2.517986064501751e-18,  1.083895141238865e-20, -4.538000986267028e-23,  1.854131766490095e-25, -7.412592417234693e-28,  1.825130442921502e-02,
 -1.364390871554659e-04,  1.014946318533401e-06, -6.538565491934938e-09,  3.848809986615179e-11, -2.118814719924364e-13,  1.105883771193457e-15, -5.523533722896293e-18,
  2.657914115111887e-20, -1.238457256508687e-22,  5.609772265865978e-25, -2.477907077762275e-27,  1.221803309806330e-02, -1.181373078553632e-04,  1.033439335645964e-06,
 -7.682483816802036e-09,  5.157231496920694e-11, -3.207658105514828e-13,  1.877838393401026e-15, -1.045897067231059e-17,  5.585098316205954e-20, -2.876026523220602e-22,
  1.434555977857103e-24, -6.955660434718527e-27,  7.653167512822748e-03, -9.370225637027733e-05,  9.539233989950224e-07, -8.123361780677720e-09,  6.173507546515632e-11,
 -4.308515039648717e-13,  2.811046338393152e-15, -1.735366816611650e-17,  1.022454741065170e-19, -5.786622328339662e-22,  3.161526686083672e-24, -1.674031732399892e-26,
  4.486469832074792e-03, -6.822221183573747e-05,  8.023461134381298e-07, -7.777180319428018e-09,  6.650351930623652e-11, -5.178787314942217e-13,  3.745985872666773e-15,
 -2.550555127416666e-17,  1.650264251241235e-19, -1.021867439022246e-21,  6.088751446967770e-24, -3.506065442660598e-26,  2.462076042509397e-03, -4.570876242536695e-05,
  6.173724567478288e-07, -6.773299819020504e-09,  6.483485981045823e-11, -5.607095392127588e-13,  4.476835579134924e-15, -3.348036370696542e-17,  2.369559723849751e-19,
 -1.599317398207183e-21,  1.035520476913954e-23, -6.461863164788116e-26,  1.265207586576439e-03, -2.825152231692623e-05,  4.359643459234178e-07, -5.386762056869729e-09,
  5.746428146400964e-11, -5.497005217044913e-13,  4.826484906025616e-15, -3.950684068774715e-17,  3.048296910948018e-19, -2.235438314185192e-21,  1.567991242442407e-23,
 -1.057214279017210e-25,  6.090316080036012e-04, -1.614525941108511e-05,  2.832928851592431e-07, -3.924664454771533e-09,  4.647870821097627e-11, -4.900733819816634e-13,
  4.716617239837002e-15, -4.212828994042577e-17,  3.533577834784460e-19, -2.807783033888895e-21,  2.127914548348781e-23, -1.546277389036660e-25,  2.747366747083042e-04,
 -8.548949963728156e-06,  1.697931527293991e-07, -2.626875407306893e-09,  3.441772356041502e-11, -3.987749219561863e-13,  4.194954322953036e-15, -4.077716694599939e-17,
  3.708696691245363e-19, -3.185462195411460e-21,  2.602402418970161e-23, -2.033571529291063e-25,  1.161994215433981e-04, -4.202152904098953e-06,  9.406477912826721e-08,
 -1.619284963807514e-09,  2.340017461341893e-11, -2.971036645805047e-13,  3.407544479348285e-15, -3.596305655796904e-17,  3.538841095877409e-19, -3.278674020310055e-21,
  2.881604933179525e-23, -2.416722711857822e-25,  4.610506988770544e-05, -1.920834632911728e-06,  4.826306148277560e-08, -9.213971317534292e-10,  1.464474780052647e-11,
 -2.032531320969139e-13,  2.535848086507568e-15, -2.899694114027184e-17,  3.081058678432490e-19, -3.073335832970596e-21,  2.900703200213123e-23, -2.606489015101708e-25,
  1.717266908239650e-05, -8.178904999629618e-07,  2.297746327699775e-08, -4.849992160439868e-10,  8.456766172643374e-12, -1.280111409358803e-13,  1.733800978124940e-15,
 -2.143987122431017e-17,  2.455528223605120e-19, -2.632695284965627e-21,  2.664141673894230e-23, -2.560968312771950e-25,  6.009028326859664e-06, -3.249334330144940e-07,
  1.016918155783038e-08, -2.366457010937810e-10,  4.516123489617161e-12, -7.440489954756860e-14,  1.091970405983993e-15, -1.457754982195006e-17,  1.796752512590940e-19,
 -2.067447541208587e-21,  2.239913789523975e-23, -2.300249564133610e-25,  1.977122266421330e-06, -1.206399814538294e-07,  4.191402363735540e-09, -1.072493480043934e-10,
  2.235193779826762e-12, -4.000526426994755e-14,  6.351022504417213e-16, -9.138807212314093e-18,  1.210439180011019e-19, -1.492745528257048e-21,  1.729253884038277e-23,
 -1.894783482554936e-25,  6.123098626098972e-07, -4.192784798191842e-08,  1.611853240405031e-09, -4.523811156549294e-11,  1.027521945886711e-12, -1.994309731833032e-14,
  3.419419162607931e-16, -5.295983736894578e-18,  7.527863674935572e-20, -9.937310053044376e-22,  1.229431999741850e-23, -1.435727742425356e-25,  1.787029991043203e-07,
 -1.366389217585181e-08,  5.794462387845013e-10, -1.779591195416189e-11,  4.396838680084101e-13, -9.239011423069396e-15,  1.708372830691199e-16, -2.844120682455257e-18,
  4.333229329608255e-20, -6.115959044587866e-22,  8.072204618968339e-24, -1.003639449289099e-25,  4.921622762088039e-08, -4.183097715845703e-09,  1.951152201112067e-10,
 -6.542852891567675e-12,  1.755237904433024e-13, -3.986865064621470e-15,  7.939461581571372e-17, -1.419022330289284e-18,  2.314708115138412e-20, -3.489340224384302e-22,
  4.908265448076618e-24, -6.491094212406395e-26,  1.281101543995703e-08, -1.205384435632986e-09,  6.167137597996205e-11, -2.253301334849352e-12,  6.552280426769171e-14,
 -1.606431920193173e-15,  3.440831168862694e-17, -6.594605056128869e-19,  1.150470607380301e-20, -1.850486364091415e-22,  2.771551206991260e-24, -3.895225607182601e-26,
  3.157496665742902e-09, -3.276325050042286e-10,  1.833943627602550e-11, -7.286450229723012e-13,  2.292896357162194e-14, -6.059307317254845e-16,  1.394225412873859e-17,
 -2.862245789321020e-19,  5.335014221149296e-21, -9.147519685866936e-23,  1.457512312133137e-24, -2.175109304278487e-26,  7.383946939019341e-10, -8.419902100161287e-11,
  5.143771834779758e-12, -2.218090166303712e-13,  7.541594485122839e-15, -2.145309581194154e-16,  5.296624198484692e-18, -1.163494046190982e-19,  2.314820442168053e-21,
 -4.227234345540280e-23,  7.159386453977848e-25, -1.133604983345233e-26,  1.642312312443198e-10, -2.051276055184896e-11,  1.364459448671375e-12, -6.374283283112086e-14,
  2.338165909462646e-15, -7.150388796296332e-17,  1.892106646337687e-18, -4.442835853525929e-20,  9.426177108105515e-22, -1.831783822237187e-23,  3.295012958919227e-25,
 -5.531357559256040e-27,  3.483619559095618e-11, -4.751273673166843e-12,  3.433512446371477e-13, -1.734663158971740e-14,  6.854600944029216e-16, -2.250700739432797e-17,
  6.376173796476742e-19, -1.598798598710905e-20,  3.614089222714917e-22, -7.467493245551763e-24,  1.425551804348185e-25, -2.535283281049165e-27,  7.069211805717452e-12,
 -1.049764360761377e-12,  8.223917865018342e-14, -4.485536565137071e-15,  1.906692141707603e-16, -6.713670551619533e-18,  2.034019764782534e-19, -5.441045710876396e-21,
  1.309270648378372e-22, -2.873985544635763e-24,  5.818132942254145e-26, -1.095417670548079e-27,  1.377297022934390e-12, -2.220623452360840e-13,  1.881977445730093e-14,
 -1.106309682132336e-15,  5.051556406450076e-17, -1.905084739552013e-18,  6.165800115493383e-20, -1.757861131614677e-21,  4.498675878441241e-23, -1.048236892884441e-24,
  2.248606148831911e-26, -4.478617640262772e-28,  2.586839795396895e-13, -4.516151833222905e-14,  4.132130375465323e-15, -2.613592014185698e-16,  1.280125126792930e-17,
 -5.164328569726294e-19,  1.783573854195919e-20, -5.414048123052324e-22,  1.472242938276860e-23, -3.638370279858135e-25,  8.263656957483677e-27, -1.739849381784762e-28,
  4.705546263773957e-14, -8.871816153653324e-15,  8.745961340460370e-16, -5.942200566714167e-17,  3.117493320590791e-18, -1.343668752012113e-19,  4.946315641747352e-21,
 -1.596995943958171e-22,  4.610086642492868e-24, -1.207281541223402e-25,  2.900869246313735e-27, -6.451144909377163e-29,  8.333640656815094e-15, -1.692411242810537e-15,
  1.793966921373172e-16, -1.307061532461135e-17,  7.334343616763065e-19, -3.372941482427699e-20,  1.321910298703254e-21, -4.534714323737100e-23,  1.388267717658179e-24,
 -3.848960123750340e-26,  9.775507542629084e-28, -2.294336506193865e-29,  1.445542084257028e-15, -3.153814162368107e-16,  3.587337253479275e-17, -2.797974900352846e-18,
  1.676705628027157e-19, -8.216282292885327e-21,  3.424018595131480e-22, -1.246570826743278e-23,  4.042964814512480e-25, -1.185525924529397e-26,  3.179633503661806e-28,
 -7.868932115507037e-30,  2.472382063363653e-16, -5.779742003055180e-17,  7.039880667113678e-18, -5.867422418820170e-19,  3.749012456571197e-20, -1.954707664495631e-21,
  8.650436369633098e-23, -3.338272696610420e-24,  1.145695198922649e-25, -3.549394261323471e-27,  1.004262848104675e-28, -2.618077103866877e-30,  4.201121895346358e-17,
 -1.049479952652932e-17,  1.365879031295605e-18, -1.214189724326364e-19,  8.258074780037929e-21, -4.574258713373491e-22,  2.146614692478410e-23, -8.769285558958755e-25,
  3.180779570455433e-26, -1.039870802079431e-27,  3.100349210977279e-29, -8.504949462704102e-31,  7.152178764518797e-18, -1.903946359466381e-18,  2.641736282736435e-19,
 -2.499696555679901e-20,  1.806402283955844e-21, -1.061226005917588e-22,  5.272821273758764e-24, -2.276907361931910e-25,  8.716400670643057e-27, -3.003123869740391e-28,
  9.423171048725944e-30, -2.716804579987754e-31,  1.231383775064845e-18, -3.483052169663090e-19,  5.139828423202809e-20, -5.165803027032133e-21,  3.958636313924077e-22,
 -2.462049128896496e-23,  1.292972083031656e-24, -5.892236970631937e-26,  2.376981646547042e-27, -8.618134497687012e-29,  2.841950851007912e-30, -8.599744303431471e-32,
  2.166186242480129e-19, -6.490757573674008e-20,  1.016069408594579e-20, -1.082168336090198e-21,  8.775034672460011e-23, -5.766102158806807e-24,  3.194518269549243e-25,
 -1.533555998516959e-26,  6.508018771151303e-28, -2.478951027846649e-29,  8.577442318639989e-31, -2.719965416112672e-32,  3.937380580002614e-20, -1.245812875597872e-20,
  2.063098695455757e-21, -2.322593633695896e-22,  1.988131241258115e-23, -1.377178140846176e-24,  8.031954657518324e-26, -4.053569001887152e-27,  1.806113796975607e-28,
 -7.214105011728272e-30,  2.614408237335258e-31, -8.672684709397344e-33,  7.484317991109981e-21, -2.492168032312485e-21,  4.352956172441810e-22, -5.165508912426406e-23,
  4.655492518400597e-24, -3.391108092795209e-25,  2.077056375376921e-26, -1.099501886191833e-27,  5.132254354040841e-29, -2.145077196502197e-30,  8.125380781555007e-32,
 -2.814055453014358e-33,  1.506769563098500e-21, -5.261375674748311e-22,  9.661273528638106e-23, -1.204793814865089e-23,  1.139950188516653e-24, -8.707391272605723e-26,
  5.586162669977949e-27, -3.093702714674717e-28,  1.509105230967002e-29, -6.584310045294723e-31,  2.600823478395693e-32, -9.382667354940854e-34,  3.255226687105848e-22,
 -1.187456136878697e-22,  2.284257873591986e-23, -2.983417244219217e-24,  2.954005653673366e-25, -2.358834496838367e-26,  1.580330301777725e-27, -9.130187570947511e-29,
  4.641288217457594e-30, -2.108194718451489e-31,  8.661039278774541e-33, -3.246395194299038e-34,  7.645903548383334e-23, -2.902094988922631e-23,  5.825895714142919e-24,
 -7.939972980204963e-25,  8.197778642008614e-26, -6.819853285617203e-27,  4.755624252214246e-28, -2.856985535494466e-29,  1.508786850877613e-30, -7.113166449160177e-32,
  3.030387464386088e-33, -1.176783011613412e-34,  1.976740167920098e-23, -7.774056631932726e-24,  1.621861143923471e-24, -2.297218617895481e-25,  2.463534139322580e-26,
 -2.127067278122934e-27,  1.538139587531460e-28, -9.574381157303393e-30,  5.234563331927938e-31, -2.552747790981374e-32,  1.124052905731384e-33, -4.507718304281936e-35,
  5.684847046470859e-24, -2.306270792611245e-24,  4.977836077768359e-25, -7.295426515359015e-26,  8.091419154300028e-27, -7.220716380402709e-28,  5.392810332062692e-29,
 -3.464416231954719e-30,  1.953350886564196e-31, -9.816882473648944e-33,  4.451542662885440e-34, -1.836993899429351e-35,  1.831164966916185e-24, -7.627912701568880e-25,
  1.695159593248942e-25, -2.558451232845108e-26,  2.921112822002854e-27, -2.682040412791708e-28,  2.059673887880758e-29, -1.359689738364454e-30,  7.873067784975506e-32,
 -4.060897884069996e-33,  1.888772449796166e-34, -7.989346587494332e-36,  6.604590506399038e-25, -2.811435837380058e-25,  6.400105925865535e-26, -9.896901397512516e-27,
  1.157432881717166e-27, -1.088052690115926e-28,  8.550802357797676e-30, -5.773643947681313e-31,  3.417688102978066e-32, -1.801221929817813e-33,  8.555859648580594e-35,
 -3.693996754507209e-36,  2.625536230266482e-25, -1.136467116398739e-25,  2.635926151148323e-26, -4.153834359867219e-27,  4.949525186274204e-28, -4.739071031236162e-29,
  3.791948286951324e-30, -2.605834028941664e-31,  1.569269655296120e-32, -8.410640044144933e-34,  4.061186471336067e-35, -1.781671676353866e-36,  1.085964772890740e-25,
 -4.755676871190714e-26,  1.117567135119396e-26, -1.784610117341366e-27,  2.154542646917811e-28, -2.089703392055685e-29,  1.693325885681750e-30, -1.178128147760073e-31,
  7.181089506914499e-33, -3.894472687959928e-34,  1.902308088629709e-35, -8.439823361483632e-37,  3.662156262889279e-26, -1.614198213457515e-26,  3.821216776720402e-27,
 -6.147472039231181e-28,  7.476585207884784e-29, -7.304222298712738e-30,  5.960848666277193e-31, -4.176109418570934e-32,  2.562795950080183e-33, -1.399102324742761e-34,
  6.878478653380682e-36, -3.071017506904023e-37,  4.944136416346408e-02, -1.002387239091133e-04,  2.090344649944231e-07, -4.467955426094048e-10,  9.741960635934401e-13,
 -2.157307773988489e-15,  4.828701595531826e-18, -1.089353698798967e-20,  2.467054876430692e-23, -5.607418307279807e-26,  1.273390560135635e-28, -2.899718092717786e-31,
  4.617025957845991e-02, -1.095978614117380e-04,  3.059052494959843e-07, -9.056867120811285e-10,  2.699744250421524e-12, -7.959410324605189e-15,  2.311228588241960e-17,
 -6.613620518023003e-20,  1.867510191304117e-22, -5.212877150987218e-25,  1.439996236824613e-27, -3.942083780724727e-30,  4.026384179505055e-02, -1.235087859618076e-04,
  4.744683804768092e-07, -1.813669632740963e-09,  6.661050034229669e-12, -2.360409804319526e-14,  8.126733293268667e-17, -2.732619291831021e-19,  9.006142910247247e-22,
 -2.917059789192973e-24,  9.303943166540843e-27, -2.926900455694628e-29,  3.279198277110217e-02, -1.347940881407781e-04,  6.700849417107620e-07, -3.099751320418664e-09,
  1.344862509039082e-11, -5.565690889948639e-14,  2.219539046993700e-16, -8.584163728827870e-19,  3.234384920718058e-21, -1.191314371094955e-23,  4.300966465046093e-26,
 -1.525244484514157e-28,  2.494296909484335e-02, -1.373384904646053e-04,  8.402511004965783e-07, -4.578659348760460e-09,  2.308193545934028e-11, -1.099445616639824e-13,
  5.006146235296292e-16, -2.195908536703663e-18,  9.331267235211872e-21, -3.857673073014898e-23,  1.556712293016941e-25, -6.147973413517607e-28,  1.772130465702401e-02,
 -1.286232119326583e-04,  9.400430800710650e-07, -5.955265763345005e-09,  3.450383493368424e-11, -1.871040285286110e-13,  9.624917131501325e-16, -4.740210144973790e-18,
  2.249963964991802e-20, -1.034440593918741e-22,  4.624629989150767e-25, -2.016633380848739e-27,  1.176145420765101e-02, -1.102249968587054e-04,  9.459964350640034e-07,
 -6.906296660422725e-09,  4.558496356915471e-11, -2.790191312921041e-13,  1.608527571996184e-15, -8.826895516928233e-18,  4.646043980470118e-20, -2.359037571012578e-22,
  1.160602614118783e-24, -5.551964404732939e-27,  7.293026758103393e-03, -8.644463047638391e-05,  8.620967008262919e-07, -7.201030002900751e-09,  5.375517053627622e-11,
 -3.688659151018529e-13,  2.367983892303921e-15, -1.439208649795811e-17,  8.352293805816567e-20, -4.657912575882494e-22,  2.508527224600010e-24, -1.309707463837705e-26,
  4.225851994922508e-03, -6.215941522934761e-05,  7.150776720161733e-07, -6.791332338267041e-09,  5.699008035491472e-11, -4.359805828521727e-13,  3.100550356755964e-15,
 -2.076915584684493e-17,  1.322751127547655e-19, -8.065911467093464e-22,  4.734657665023481e-24, -2.686759630471593e-26,  2.288628000173105e-03, -4.107808195366866e-05,
  5.419650121047222e-07, -5.820121766687659e-09,  5.462338856276579e-11, -4.637085281561817e-13,  3.637425453684741e-15, -2.674428539257995e-17,  1.861982865016993e-19,
 -1.236861322343103e-21,  7.885073933679198e-24, -4.846476446807911e-26,  1.158788546935080e-03, -2.500753828841547e-05,  3.764963750804790e-07, -4.549349086247802e-09,
  4.754442207007726e-11, -4.461071651245944e-13,  3.845571921360651e-15, -3.092740271817449e-17,  2.346052632017619e-19, -1.692310276760334e-21,  1.168138996678024e-23,
 -7.753912747217365e-26,  5.487018957545389e-04, -1.405536486913929e-05,  2.403542992481548e-07, -3.253645609865435e-09,  3.771990933745658e-11, -3.898397701846102e-13,
  3.681232079222374e-15, -3.228629488160319e-17,  2.660886543296191e-19, -2.078668445043691e-21,  1.549516058454626e-23, -1.107988100585358e-25,  2.430703825569787e-04,
 -7.307905572672094e-06,  1.413282719021426e-07, -2.134890958517907e-09,  2.736303753890675e-11, -3.105552706490157e-13,  3.203440531327394e-15, -3.055954877424985e-17,
  2.729561371630503e-19, -2.303786734941001e-21,  1.850398538707712e-23, -1.422224816394090e-25,  1.007812054057951e-04, -3.521419841572903e-06,  7.669719842680340e-08,
 -1.288295986856785e-09,  1.820052575707403e-11, -2.262281337572927e-13,  2.542847966970840e-15, -2.632408561592595e-17,  2.542674561118449e-19, -2.313823462200929e-21,
  1.998494158936960e-23, -1.647931991256504e-25,  3.912915590499451e-05, -1.575262586451019e-06,  3.848804732254672e-08, -7.165521637385030e-10,  1.112787516452470e-11,
 -1.511163871162777e-13,  1.846807626775546e-15, -2.070453070178775e-17,  2.158516264272686e-19, -2.113917496505216e-21,  1.959966007948536e-23, -1.730954475571062e-25,
  1.423489475891390e-05, -6.552313560314252e-07,  1.789163691127134e-08, -3.681010496746033e-10,  6.268272353885956e-12, -9.279652714815878e-14,  1.230591914605045e-15,
 -1.491314227529846e-17,  1.675181328550579e-19, -1.762697256586956e-21,  1.751654693430466e-23, -1.654380907331671e-25,  4.855612376991840e-06, -2.538150772930187e-07,
  7.718133389790490e-09, -1.749964927987011e-10,  3.260123484352331e-12, -5.250900732742627e-14,  7.542313884475286e-16, -9.863913340309490e-18,  1.191983292679120e-19,
 -1.345650541657915e-21,  1.431221456947368e-23, -1.443650823176171e-25,  1.554258258627574e-06, -9.170458798408352e-08,  3.095047926879514e-09, -7.713863534457387e-11,
  1.568853744375553e-12, -2.744101149415812e-14,  4.262295179478687e-16, -6.006501373735326e-18,  7.797583622041310e-20, -9.431774172945421e-22,  1.072322968577371e-23,
 -1.153789177318287e-25,  4.673079945751867e-07, -3.095261381491197e-08,  1.155793096008089e-09, -3.158867646559753e-11,  6.999927445788830e-13, -1.327367931202612e-14,
  2.226123401117804e-16, -3.375673245323619e-18,  4.701753834218433e-20, -6.086144192122411e-22,  7.388179322953896e-24, -8.470541050607031e-26,  1.321180764513065e-07,
 -9.775651809075224e-09,  4.026610932664592e-10, -1.204093732589870e-11,  2.901850604288447e-13, -5.956164533694642e-15,  1.077035892496282e-16, -1.755179877692437e-18,
  2.619821666412798e-20, -3.625147958078183e-22,  4.693891070495395e-24, -5.728615267535984e-26,  3.516860715872019e-08, -2.893939257775339e-09,  1.311217151229058e-10,
 -4.280979675127977e-12,  1.120106951959071e-13, -2.484864811635882e-15,  4.838432790231227e-17, -8.463771016642634e-19,  1.352362979639766e-20, -1.998387253362858e-22,
  2.757307768748666e-24, -3.578912694224835e-26,  8.827242802501277e-09, -8.045283399612133e-10,  3.999153461650867e-11, -1.422698677683661e-12,  4.034792369766052e-14,
 -9.660762482491207e-16,  2.023112365622219e-17, -3.794619774555269e-19,  6.483930938980381e-21, -1.022232750301443e-22,  1.501658368521631e-24, -2.071204195780744e-26,
  2.092744870331728e-09, -2.104704364833634e-10,  1.144916681758012e-11, -4.429629637189061e-13,  1.359544960006392e-14, -3.508792189192786e-16,  7.893516602242571e-18,
 -1.585832280156960e-19,  2.895054207198459e-21, -4.865328467863573e-23,  7.603130223578628e-25, -1.113504315252562e-26,  4.695580077550165e-10, -5.193052410929321e-11,
  3.084139534021680e-12, -1.295349568913339e-13,  4.296225908755644e-15, -1.193652923796998e-16,  2.881487770013147e-18, -6.194610309894973e-20,  1.207127366308282e-21,
 -2.160691340444766e-23,  3.589183209580033e-25, -5.577307629517233e-27,  9.993954663311772e-11, -1.211529121199282e-11,  7.837856353827829e-13, -3.567412397289286e-14,
  1.276757044684223e-15, -3.814168836526147e-17,  9.869715787472062e-19, -2.268306398624257e-20,  4.714193004071125e-22, -8.980225893761680e-24,  1.584499309658555e-25,
 -2.610642533559416e-27,  2.023047469110204e-11, -2.680135786123672e-12,  1.884689888067941e-13, -9.280465684344100e-15,  3.579149257929190e-16, -1.148316096576003e-17,
  3.181894249439042e-19, -7.810596053351115e-21,  1.729794884915270e-22, -3.504142474624208e-24,  6.562634804626535e-26, -1.145689715054236e-27,  3.906737069311799e-12,
 -5.640026076657159e-13,  4.302171804387986e-14, -2.288144755635804e-15,  9.496482490275560e-17, -3.268389022505958e-18,  9.688110308441854e-20, -2.537740126184679e-21,
  5.984208186212258e-23, -1.288171579922455e-24,  2.558922005754795e-26, -4.730329193811109e-28,  7.222339205651474e-13, -1.133127240767156e-13,  9.357095205555466e-15,
 -5.366727611463185e-16,  2.393757609691567e-17, -8.827629476302747e-19,  2.796367352627481e-20, -7.809465981334359e-22,  1.959182213774113e-23, -4.478107306501770e-25,
  9.428873359985863e-27, -1.844384703477604e-28,  1.283326549922644e-13, -2.182382646250328e-14,  1.947157126075075e-15, -1.202422485568740e-16,  5.756290913479102e-18,
 -2.271963350952965e-19,  7.683447854535405e-21, -2.285634593143641e-22,  6.095278975930650e-24, -1.478199051117169e-25,  3.296624197961892e-27, -6.819058185972057e-29,
  2.201835913747735e-14, -4.048164910038883e-15,  3.894921788189971e-16, -2.585577851008336e-17,  1.326711596926182e-18, -5.597869471478430e-20,  2.018978344083111e-21,
 -6.391441629214795e-23,  1.810282079700349e-24, -4.654360973958559e-26,  1.098613217741555e-27, -2.401356334348018e-29,  3.666893368947379e-15, -7.270288694310135e-16,
  7.528809805285471e-17, -5.364079514057511e-18,  2.946133066962134e-19, -1.327281306904556e-20,  5.099849404957846e-22, -1.716386838508918e-23,  5.158594062592079e-25,
 -1.404931431532506e-26,  3.507081741292462e-28, -8.094479504163741e-30,  5.963093704787943e-16, -1.271763476708716e-16,  1.414716027039879e-17, -1.080035733311288e-18,
  6.340398252264681e-20, -3.046095682426161e-21,  1.245456531231548e-22, -4.451682726393322e-24,  1.418371421333888e-25, -4.088198087949210e-27,  1.078349118009278e-28,
 -2.625918379712881e-30,  9.533469693221469e-17, -2.181501508321651e-17,  2.601596472365039e-18, -2.124570699742737e-19,  1.331135150795942e-20, -6.810568368383206e-22,
  2.959570584361458e-23, -1.122207446077002e-24,  3.786457150290135e-26, -1.153892255022563e-27,  3.213100332772476e-29, -8.247778767593189e-31,  1.509967278294039e-17,
 -3.697467116256853e-18,  4.717482772839576e-19, -4.113651326581838e-20,  2.746373767257134e-21, -1.494266483911369e-22,  6.892192840679784e-24, -2.768951150158897e-25,
  9.882514989633616e-27, -3.180650318934572e-28,  9.340191873547235e-30, -2.524796733666119e-31,  2.389839626924173e-18, -6.245410885878595e-19,  8.506332982742805e-20,
 -7.905283319076615e-21,  5.614158469937690e-22, -3.243221634019307e-23,  1.585463109988119e-24, -6.739601591805843e-26,  2.541085047604014e-27, -8.626858590264439e-29,
  2.668493589772884e-30, -7.587627086485566e-32,  3.816311340570608e-19, -1.061359600774849e-19,  1.539616919801126e-20, -1.521781866706269e-21,  1.147467455317749e-22,
 -7.025907639960526e-24,  3.634358438443078e-25, -1.632158438953489e-26,  6.491580662148801e-28, -2.321498120329727e-29,  7.554046382659262e-31, -2.256484818902026e-32,
  6.214963622627532e-20, -1.833961290474176e-20,  2.826358490271086e-21, -2.964547023668345e-22,  2.368481327840093e-23, -1.534138416669909e-24,  8.381982786696653e-26,
 -3.969992452737325e-27,  1.662905649004765e-28, -6.254410954706147e-30,  2.137657151583405e-31, -6.698339626613462e-33,  1.044370481774333e-20, -3.259634221521319e-21,
  5.322560063967919e-22, -5.909815898766369e-23,  4.991300900516034e-24, -3.412744363025136e-25,  1.965414916105926e-26, -9.798466771835009e-28,  4.314336819837532e-29,
 -1.703542931724057e-30,  6.105085124680610e-32, -2.003394311046746e-33,  1.834098212398377e-21, -6.034516458777406e-22,  1.040951409633593e-22, -1.220183132834568e-23,
  1.086632970071154e-24, -7.823761336075319e-26,  4.738382674046300e-27, -2.481033715944412e-28,  1.145885021327624e-29, -4.740316364118691e-31,  1.777743308166494e-32,
 -6.097476408957876e-34,  3.412244496942125e-22, -1.179268396997198e-22,  2.142089201016367e-23, -2.642797989494822e-24,  2.474564302026594e-25, -1.871067919617460e-26,
  1.188590489695416e-27, -6.519892327340736e-29,  3.150985636081355e-30, -1.362446496428727e-31,  5.334759353933754e-33, -1.908271039915272e-34,  6.821134031924983e-23,
 -2.466755739093551e-23,  4.701687274027095e-24, -6.084979494861576e-25,  5.971493213798893e-26, -4.727153112122295e-27,  3.140418258485913e-28, -1.799543410785257e-29,
  9.075422935071271e-31, -4.090571366558625e-32,  1.667952620242903e-33, -6.206603601147641e-35,  1.486217525705898e-23, -5.601273143554822e-24,  1.115928442191970e-24,
 -1.509422329946267e-25,  1.546945901332653e-26, -1.277685798606313e-27,  8.847345891238238e-29, -5.279052164326964e-30,  2.769506326232212e-31, -1.297315460094589e-32,
  5.492470836614397e-34, -2.119995167774262e-35,  3.578370812398781e-24, -1.399441346002907e-24,  2.901955556681604e-25, -4.085610870635692e-26,  4.355538825964044e-27,
 -3.739012261932537e-28,  2.688630434727623e-29, -1.664460054850512e-30,  9.051840655209918e-32, -4.391600775916350e-33,  1.924079105166104e-34, -7.678561188019589e-36,
  9.636157498120517e-25, -3.892810941370937e-25,  8.363567596529449e-26, -1.220111317283913e-26,  1.347122813114304e-27, -1.196859832587250e-28,  8.900385735136028e-30,
 -5.693838874557352e-31,  3.197326176203813e-32, -1.600519036750747e-33,  7.229795097125320e-35, -2.972361348201522e-36,  2.927000800412842e-25, -1.215621457965051e-25,
  2.692573900079803e-26, -4.050367895345017e-27,  4.609456028387762e-28, -4.218742116527071e-29,  3.229740045964587e-30, -2.125671586588610e-31,  1.227221959026489e-32,
 -6.311881240251180e-34,  2.927574563436245e-35, -1.235000820590586e-36,  1.004159081260073e-25, -4.266096085377855e-26,  9.690388815231215e-27, -1.495201272985898e-27,
  1.744845177397445e-28, -1.636786709236260e-29,  1.283667776976187e-30, -8.650127294865403e-32,  5.110397841044472e-33, -2.688202434702338e-34,  1.274538640819446e-35,
 -5.492931604911052e-37,  3.835582186670334e-26, -1.658332829871082e-26,  3.841412139943438e-27, -6.045679389419915e-28,  7.194575457704734e-29, -6.880053213763028e-30,
  5.498326817302638e-31, -3.773961930294331e-32,  2.270095032754583e-33, -1.215301719157434e-34,  5.861776306469765e-36, -2.568850834907906e-37,  1.541820114699060e-26,
 -6.748151443750154e-27,  1.584783410145969e-27, -2.529066169514778e-28,  3.051373435090418e-29, -2.957693811970284e-30,  2.395206877588196e-31, -1.665462339701518e-32,
  1.014561468636397e-33, -5.499058214580845e-35,  2.684589769464003e-36, -1.190403551348092e-37,  5.115897930662468e-27, -2.254443787411228e-27,  5.335411713371459e-28,
 -8.581127004910156e-29,  1.043357147412578e-29, -1.019029960360185e-30,  8.313923138071764e-32, -5.823130754594076e-33,  3.572624310860233e-34, -1.949904500584831e-35,
  9.584041515666281e-37, -4.277925253469843e-38,  4.904372023262527e-02, -9.858763263258138e-05,  2.037650375989694e-07, -4.315473803339196e-10,  9.321845432087569e-13,
 -2.044991786132230e-15,  4.534438359114062e-18, -1.013541951151693e-20,  2.274056990261611e-23, -5.122678931084266e-26,  1.152471277898415e-28, -2.602400124848235e-31,
  4.573669480560881e-02, -1.071933699530876e-04,  2.952910271229674e-07, -8.637347889911613e-10,  2.545956413468907e-12, -7.426278887583311e-15,  2.134139272072183e-17,
 -6.044964796058096e-20,  1.689809946458545e-22, -4.670109386194896e-25,  1.277332692010109e-27, -3.462734752276823e-30,  3.977726281779127e-02, -1.197983184571693e-04,
  4.533285632860016e-07, -1.710766059359199e-09,  6.207868903289032e-12, -2.174233596583750e-14,  7.400418485838763e-17, -2.460531160661190e-19,  8.019999343007911e-22,
 -2.569424299658839e-24,  8.107209133930525e-27, -2.523370962120641e-29,  3.226329725156188e-02, -1.295786214022905e-04,  6.341431760143940e-07, -2.893196963173299e-09,
  1.238686776597876e-11, -5.060713227683938e-14,  1.993050701445240e-16, -7.614586820079153e-19,  2.834927370511648e-21, -1.031978696190451e-23,  3.682852686804902e-26,
 -1.291223735968397e-28,  2.440671982083557e-02, -1.308301419988326e-04,  7.874525496073666e-07, -4.226307023824508e-09,  2.099838050489708e-11, -9.863513562909647e-14,
  4.431090862449646e-16, -1.918377365660998e-18,  8.048363234599085e-21, -3.285887599639121e-23,  1.309766570688500e-25, -5.110478130193388e-28,  1.722141278289808e-02,
 -1.213796114677677e-04,  8.717727160982976e-07, -5.431929665687884e-09,  3.098240790057860e-11, -1.655188968115756e-13,  8.393103117098573e-16, -4.076401794142982e-18,
  1.908830120906740e-20, -8.660507571323763e-23,  3.821873948431145e-25, -1.645467120341154e-27,  1.133518224677443e-02, -1.029765393946951e-04,  8.673194508931058e-07,
 -6.219563891325198e-09,  4.037144424469182e-11, -2.432198437143088e-13,  1.380973279322867e-15, -7.467538951389686e-18,  3.874784146626230e-20, -1.940203979626246e-22,
  9.416227999668854e-25, -4.444647625453270e-27,  6.960514432376262e-03, -7.987942617698656e-05,  7.806110263166314e-07, -6.397009740580219e-09,  4.691502467823275e-11,
 -3.165828524200803e-13,  2.000034690966313e-15, -1.196935578901038e-17,  6.842983390626399e-20, -3.760940992469608e-22,  1.996817991903636e-24, -1.028109380711308e-26,
  3.988160477917857e-03, -5.674991387406103e-05,  6.387775609542969e-07, -5.945394276470204e-09,  4.896985902147440e-11, -3.680930825229363e-13,  2.574155764476260e-15,
 -1.696659025578018e-17,  1.063798720748805e-19, -6.388977832933507e-22,  3.695114912497776e-24, -2.066685984598784e-26,  2.132564866741011e-03, -3.700754537724895e-05,
  4.770760454425330e-07, -5.015840710003537e-09,  4.616485675840744e-11, -3.847621697247889e-13,  2.965719382818221e-15, -2.144143904606051e-17,  1.468695282857334e-19,
 -9.603254929572756e-22,  6.028712604693582e-24, -3.650266650720129e-26,  1.064453987640061e-03, -2.220165086649057e-05,  3.261894942766604e-07, -3.855280710684686e-09,
  3.947922933425359e-11, -3.634099403552392e-13,  3.076155280024827e-15, -2.431090027270426e-17,  1.813303937532606e-19, -1.286805096530622e-21,  8.742215147143312e-24,
 -5.713644199105375e-26,  4.960925687116024e-04, -1.227900847676657e-05,  2.046891184914518e-07, -2.707991997247216e-09,  3.073807841252760e-11, -3.114413115703324e-13,
  2.885974421014140e-15, -2.485807561813349e-17,  2.013298116711819e-19, -1.546462128003431e-21,  1.134044830573265e-23, -7.980545789071496e-26,  2.159476784655582e-04,
 -6.272757697224900e-06,  1.181442426449753e-07, -1.742868017784746e-09,  2.185624227720860e-11, -2.430255102796622e-13,  2.458541118000463e-15, -2.302048864273734e-17,
  2.019600930398062e-19, -1.675228440105251e-21,  1.323050483194932e-23, -1.000353463600524e-25,  8.783133205642823e-05, -2.965053422542082e-06,  6.284568051003182e-08,
 -1.030203200254760e-09,  1.423098772188903e-11, -1.731970270982599e-13,  1.908185909778715e-15, -1.937915766167206e-17,  1.837664629582512e-19, -1.642730672542849e-21,
  1.394542005410099e-23, -1.130748326171223e-25,  3.339344519908271e-05, -1.298940904959926e-06,  3.086525484783985e-08, -5.604604607846604e-10,  8.505577396395415e-12,
 -1.130344618800340e-13,  1.353339966709694e-15, -1.487733094367675e-17,  1.521999327385024e-19, -1.463608678543820e-21,  1.333232082807890e-23, -1.157386377012227e-25,
  1.187449322117408e-05, -5.281934292559505e-07,  1.401976753949126e-08, -2.811832256439402e-10,  4.676759163344454e-12, -6.772152169948209e-14,  8.794197831968224e-16,
 -1.044571624614955e-17,  1.150942649481751e-19, -1.188723478463362e-21,  1.160151766289669e-23, -1.076686406657464e-25,  3.951696643966806e-06, -1.996569486768121e-07,
  5.899438169399445e-09, -1.303391271450893e-10,  2.370638602317640e-12, -3.733180647601317e-14,  5.248811622365431e-16, -6.725512780511838e-18,  7.969131384581765e-20,
 -8.827443926062471e-22,  9.217893054430178e-24, -9.133588354628286e-26,  1.231649810844421e-06, -7.025849476871105e-08,  2.303538736918429e-09, -5.592421764806088e-11,
  1.110039968273518e-12, -1.897636970009491e-14,  2.884134245853735e-16, -3.980774352415314e-18,  5.065614137642605e-20, -6.010298292616907e-22,  6.706968653051580e-24,
 -7.087035261201546e-26,  3.598338811817895e-07, -2.305056547955098e-08,  8.360269954185179e-10, -2.225161297694788e-11,  4.810897315264490e-13, -8.913566802962493e-15,
  1.462314866139410e-16, -2.171214827545910e-18,  2.963537251325704e-20, -3.761933800220584e-22,  4.481239793931709e-24, -5.044397877625494e-26,  9.864348629654198e-08,
 -7.061615158281504e-09,  2.825096165611071e-10, -8.225664780193351e-12,  1.933726574420128e-13, -3.877161708883451e-15,  6.856575138218858e-17, -1.093829652010257e-18,
  1.599600943370295e-20, -2.170161944853015e-22,  2.756792450015894e-24, -3.302753029063893e-26,  2.540394706527295e-08, -2.023389439011614e-09,  8.904728055436223e-11,
 -2.830549696454641e-12,  7.223312004438907e-14, -1.565078534749878e-15,  2.979842121176275e-17, -5.101858949274350e-19,  7.985394108712535e-21, -1.156747901660282e-22,
  1.565604117978250e-24, -1.994528645919302e-26,  6.154622396830448e-09, -5.432243635782762e-10,  2.623145453212989e-11, -9.085531741193499e-13,  2.512936953035433e-14,
 -5.876087645118110e-16,  1.203110443027262e-17, -2.208415265677233e-19,  3.696070702531313e-21, -5.711627448776935e-23,  8.229496723053216e-25, -1.113973771836766e-26,
  1.404978032448123e-09, -1.369146209820591e-10,  7.236823261508812e-12, -2.726235104805627e-13,  8.160571769866490e-15, -2.056803540659621e-16,  4.523734555139976e-18,
 -8.893835534091679e-20,  1.590209623485969e-21, -2.619354601854573e-23,  4.014614097503025e-25, -5.769953786639570e-27,  3.027755565453723e-10, -3.246617371703147e-11,
  1.874107464322132e-12, -7.665584344933223e-14,  2.479818107396398e-15, -6.728889892732208e-17,  1.588133308831840e-18, -3.341152921987045e-20,  6.376827809142834e-22,
 -1.118743540270322e-23,  1.822653395515625e-25, -2.779485223619066e-27,  6.173091713787539e-11, -7.260659529485857e-12,  4.567365148674928e-13, -2.025038102675603e-14,
  7.070365647720081e-16, -2.063120487637903e-17,  5.220107870110000e-19, -1.174155944620218e-20,  2.390190543134736e-22, -4.463005560302125e-24,  7.723782212398467e-26,
 -1.248945708395285e-27,  1.193754155559693e-11, -1.535580218827332e-12,  1.050493677762957e-13, -5.040649639939574e-15,  1.896996226255145e-16, -5.946107426967994e-18,
  1.611335084674888e-19, -3.871704442414043e-21,  8.399929615720020e-23, -1.668150421250453e-24,  3.064671866847351e-26, -5.251508074400610e-28,  2.195996245142786e-12,
 -3.080824004961937e-13,  2.287498183909697e-14, -1.186069678599564e-15,  4.805222112032428e-17, -1.616214768880069e-18,  4.686479132949494e-20, -1.201917095769802e-21,
  2.777094649332392e-23, -5.861622209928435e-25,  1.142449374465375e-26, -2.073306625316823e-28,  3.855912802507440e-13, -5.884245218153876e-14,  4.732908549578660e-15,
 -2.647770466673256e-16,  1.153368208960667e-17, -4.158285129199904e-19,  1.289010420601563e-20, -3.525656159699624e-22,  8.669160401972713e-24, -1.943464213887477e-25,
  4.015983542389343e-27, -7.714121376068379e-29,  6.487908155512625e-14, -1.074211714517667e-14,  9.342471918728105e-16, -5.630824816193023e-17,  2.633951751474029e-18,
 -1.016846953226451e-19,  3.366588332064010e-21, -9.812285441911286e-23,  2.565680594831061e-24, -6.104853355707372e-26,  1.336621987287451e-27, -2.715865890397322e-29,
  1.050817242873060e-14, -1.883025440441547e-15,  1.767523893905483e-16, -1.146014262351512e-17,  5.749544642246279e-19, -2.374193677230654e-20,  8.387480041916898e-22,
 -2.602791098367593e-23,  7.231546028619844e-25, -1.825018323406014e-26,  4.230871638746843e-28, -9.087855719626249e-30,  1.646844506463702e-15, -3.186123191299952e-16,
  3.221908866936748e-17, -2.243891942243489e-18,  1.205869505189161e-19, -5.320302929975014e-21,  2.003571277235765e-22, -6.613844569243093e-24,  1.950975087944878e-25,
 -5.218237471078419e-27,  1.279998333892475e-28, -2.904571048325510e-30,  2.512296220939636e-16, -5.234800487366391e-17,  5.692301939057086e-18, -4.251807142952763e-19,
  2.444292572957944e-20, -1.150899611192609e-21,  4.615365932235543e-23, -1.619141498118038e-24,  5.066512105582326e-26, -1.435040264845850e-27,  3.721694672629612e-29,
 -8.915345817516082e-31,  3.756151637360419e-17, -8.408477179156715e-18,  9.813349651981948e-19, -7.848846509170543e-20,  4.820166261385854e-21, -2.419112199601188e-22,
  1.031900035352007e-23, -3.843251804644489e-25,  1.274486392747222e-26, -3.819311079479349e-28,  1.046372640695475e-29, -2.643980975700122e-31,  5.546789405351963e-18,
 -1.330637294430174e-18,  1.663464552687797e-19, -1.422237873641112e-20,  9.316610264601726e-22, -4.977128322074612e-23,  2.255488832050416e-24, -8.908238316003334e-26,
  3.127376824453814e-27, -9.905845966427352e-29,  2.864220780156973e-30, -7.627082119761277e-32,  8.161844419699533e-19, -2.092704826290791e-19,  2.796472169461235e-20,
 -2.551258812972810e-21,  1.779785147156762e-22, -1.010591808822790e-23,  4.858783751038974e-25, -2.032442706665645e-26,  7.544686831538692e-28, -2.523038667407715e-29,
  7.691040935529169e-31, -2.156091214217356e-32,  1.208615532068030e-19, -3.303027606252777e-20,  4.707561926335640e-21, -4.573766437817981e-22,  3.391899220824319e-23,
 -2.043751173717308e-24,  1.040898048912527e-25, -4.604865780305194e-27,  1.805037279343550e-28, -6.364730992984151e-30,  2.042919658902833e-31, -6.022066262308912e-33,
  1.821186483570255e-20, -5.289521997450813e-21,  8.021139598049706e-22, -8.281593928530586e-23,  6.516017391397488e-24, -4.158603904380148e-25,  2.239793721484925e-26,
 -1.046229857847653e-27,  4.323833349543754e-29, -1.605201163095281e-30,  5.417404390136607e-32, -1.676864983207908e-33,  2.826943329243467e-21, -8.698977039383900e-22,
  1.399855087114161e-22, -1.532240750626019e-23,  1.276250566279264e-24, -8.609576477862391e-26,  4.894083332596302e-27, -2.409298023512553e-28,  1.047924216796579e-29,
 -4.088955127720892e-31,  1.448593707473711e-32, -4.700775828655153e-34,  4.581493716418491e-22, -1.488687163322145e-22,  2.534898680049731e-23, -2.933721052427156e-24,
  2.580414132125665e-25, -1.835671810883344e-26,  1.098858488887652e-27, -5.688934171673729e-29,  2.598807520712392e-30, -1.063694559558753e-31,  3.948121409637070e-33,
 -1.340664853713895e-34,  7.865067967165940e-23, -2.689023274830484e-23,  4.829602226066472e-24, -5.892447343393738e-25,  5.457705763748881e-26, -4.083338042537750e-27,
  2.567487213944067e-28, -1.394438955073772e-29,  6.674469637357616e-31, -2.859066007849336e-32,  1.109358580927174e-33, -3.933415921073108e-35,  1.452178033053777e-23,
 -5.204077956988690e-24,  9.824076155565597e-25, -1.259388799485381e-25,  1.224455865449660e-26, -9.605724423047125e-28,  6.325595917812594e-29, -3.593944606706646e-30,
  1.797543449817800e-31, -8.037195021227743e-33,  3.251717362555149e-34, -1.200867218194011e-35,  2.929040066230524e-24, -1.095713698988191e-24,  2.165646507981341e-25,
 -2.906207961283099e-26,  2.955495283131328e-27, -2.422740605331417e-28,  1.665387581602722e-29, -9.866631518525650e-31,  5.140613928738283e-32, -2.391906131827512e-33,
  1.006086757935460e-34, -3.858850264594931e-36,  6.552772694124479e-25, -2.547641499828017e-25,  5.249427472038803e-26, -7.343887650623762e-27,  7.780616112364805e-28,
 -6.638963013853216e-29,  4.745888011821110e-30, -2.921289790997591e-31,  1.579878210728691e-32, -7.623661839962378e-34,  3.322646839676773e-35, -1.319261786284094e-36,
  1.648405739099608e-25, -6.629665168556383e-26,  1.417464635995301e-26, -2.057851119008880e-27,  2.261280869452244e-28, -1.999740353700543e-29,  1.480388595228858e-30,
 -9.428937269322559e-32,  5.272159672781933e-33, -2.628201058102054e-34,  1.182416383589494e-35, -4.842236485606141e-37,  4.710594138972085e-26, -1.950183251667300e-26,
  4.304578832639918e-27, -6.452680963691475e-28,  7.318193483165110e-29, -6.675447517774106e-30,  5.093845544399798e-31, -3.341899662967833e-32,  1.923434051052896e-33,
 -9.862955515265618e-35,  4.561276939340343e-36, -1.918731782601234e-37,  1.533815635873397e-26, -6.502771530851164e-27,  1.473695527583160e-27, -2.268610999674863e-28,
  2.641354315198329e-29, -2.472254714719121e-30,  1.934680586344138e-31, -1.300946336987381e-32,  7.670019741060703e-34, -4.026547587403967e-35,  1.905358038252205e-36,
 -8.196071621504121e-38,  5.618948032411891e-27, -2.426436181929981e-27,  5.613064232087855e-28, -8.821890316418660e-29,  1.048424734143032e-29, -1.001270791697941e-30,
  7.991558919472572e-32, -5.478398950087844e-33,  3.291314271104630e-34, -1.759917835468706e-35,  8.478792053200112e-37, -3.711544217502584e-38,  2.192096722172189e-27,
 -9.588538998481169e-28,  2.250334229813685e-28, -3.588752495780011e-29,  4.327011436129531e-30, -4.191413542238616e-31,  3.392118156275347e-32, -2.357163434195533e-33,
  1.435048322760430e-34, -7.773490052568195e-36,  3.792725451521616e-37, -1.680816092679818e-38,  7.150930814748953e-28, -3.150457171083853e-28,  7.453860164177397e-29,
 -1.198490297204858e-29,  1.456802161037632e-30, -1.422437986514751e-31,  1.160200332144495e-32, -8.123927720369461e-34,  4.982890932924943e-35, -2.718904184219791e-36,
  1.336034798715877e-37, -5.962015380022927e-39,  4.865259749900413e-02, -9.697797612229476e-05,  1.986746279498710e-07, -4.169538084520382e-10,  8.923504034197351e-13,
 -1.939490209312993e-15,  4.260563364585200e-18, -9.436360111175241e-21,  2.097669713323472e-23, -4.683790995537761e-26,  1.043893062569346e-28, -2.338083442748861e-31,
  4.531258130137579e-02, -1.048718196157837e-04,  2.851658087263638e-07, -8.241604265045282e-10,  2.402418763424688e-12, -6.933800698058469e-15,  1.972204721640300e-17,
 -5.530168375690888e-20,  1.530527255540931e-22, -4.188378337801330e-25,  1.134360357100854e-27, -3.045509262813147e-30,  3.930519512378052e-02, -1.162521506141974e-04,
  4.333812823632671e-07, -1.614824720527834e-09,  5.790239772935757e-12, -2.004609262873533e-14,  6.746052181195664e-17, -2.218086267886800e-19,  7.150799362376658e-22,
 -2.266288057432959e-24,  7.074684833725479e-27, -2.178853273546700e-29,  3.175491383102425e-02, -1.246410554899593e-04,  6.005813735466740e-07, -2.702851395226648e-09,
  1.142088290756208e-11, -4.606974299395015e-14,  1.792003883037304e-16, -6.764116345409815e-19,  2.488617663406666e-21, -8.954250622027126e-24,  3.159102831898597e-26,
 -1.095142067894693e-28,  2.389568516463423e-02, -1.247278190395971e-04,  7.386894336829651e-07, -3.905554496207942e-09,  1.912781899096920e-11, -8.861704739898139e-14,
  3.928293166015055e-16, -1.678787698334558e-18,  6.954569613612566e-21, -2.804321000298219e-23,  1.104276150622677e-25, -4.257340871450671e-28,  1.674944144810281e-02,
 -1.146579798138202e-04,  8.094580709188988e-07, -4.961637303543764e-09,  2.786456403041986e-11, -1.466788757821038e-13,  7.332741569930881e-16, -3.512646160496058e-18,
  1.622909841786029e-20, -7.267278470973008e-23,  3.166065510254373e-25, -1.346007652705991e-27,  1.093669554309548e-02, -9.632590015904345e-05,  7.964054626262034e-07,
 -5.610803819613498e-09,  3.582224222852772e-11, -2.124516690647066e-13,  1.188240876730180e-15, -6.332460346773192e-18,  3.239645548536703e-20, -1.599939972149633e-22,
  7.660729534873553e-25, -3.568468961429178e-27,  6.653017732962019e-03, -7.392929835711019e-05,  7.081499542934393e-07, -5.694524208348072e-09,  4.103745712441632e-11,
 -2.723682614913954e-13,  1.693618859166553e-15, -9.981659010043453e-18,  5.622542864585415e-20, -3.045856046918191e-22,  1.594497045134433e-24, -8.097032133385987e-27,
  3.770947506725210e-03, -5.191229097799815e-05,  5.719014426527773e-07, -5.217569589998864e-09,  4.218921594795412e-11, -3.116497236527660e-13,  2.143485229703144e-15,
 -1.390360135726432e-17,  8.583453745168987e-20, -5.077994156620611e-22,  2.894072853612926e-24, -1.595583301346193e-26,  1.991803684765839e-03, -3.341970121564904e-05,
  4.210758317432096e-07, -4.335092612062536e-09,  3.913537179290157e-11, -3.202885027150867e-13,  2.426273831847464e-15, -1.725118951237608e-17,  1.162773460782477e-19,
 -7.484895468895210e-22,  4.627785572213727e-24, -2.760645969280092e-26,  9.805878779816592e-04, -1.976697746088673e-05,  2.834886697561581e-07, -3.277967493866986e-09,
  3.289738614584423e-11, -2.971354931504503e-13,  2.470176019163649e-15, -1.918666599469646e-17,  1.407374634013667e-19, -9.826851676805288e-22,  6.571695110816079e-24,
 -4.229531514385970e-26,  4.500569620296516e-04, -1.076356845208782e-05,  1.749500926858202e-07, -2.262474222376984e-09,  2.514906296087992e-11, -2.498507037333503e-13,
  2.272361140906180e-15, -1.922517206774708e-17,  1.530410747917257e-19, -1.156041815575401e-21,  8.340730171131531e-24, -5.777328192043400e-26,  1.926224283351804e-04,
 -5.405666130087136e-06,  9.917744506251066e-08, -1.429052981124711e-09,  1.753712187748845e-11, -1.910773953750312e-13,  1.896060425612986e-15, -1.742858908829435e-17,
  1.502040513476367e-19, -1.224643917930475e-21,  9.511517343356797e-24, -7.075496639494384e-26,  7.690349072608063e-05, -2.508114866446199e-06,  5.174269030188280e-08,
 -8.279038449201691e-10,  1.118427549480657e-11, -1.332984853831836e-13,  1.439721053206302e-15, -1.434622030157699e-17,  1.335745425021176e-19, -1.173121396276064e-21,
  9.789419485889767e-24, -7.806264193609017e-26,  2.865198391337954e-05, -1.076768463137538e-06,  2.488701406691640e-08, -4.408243009271614e-10,  6.538598328027057e-12,
 -8.504796900563004e-14,  9.977190969680034e-16, -1.075624870403141e-17,  1.079959591533843e-19, -1.019885271057354e-21,  9.128632656744286e-24, -7.790496677134418e-26,
  9.966334838657580e-06, -4.283559565110983e-07,  1.105330144201625e-08, -2.161361914338261e-10,  3.511692642810279e-12, -4.974558167834839e-14,  6.326571812509508e-16,
 -7.366357746051722e-18,  7.962411901274106e-20, -8.072995094579356e-22,  7.738941846911851e-24, -7.058156190940924e-26,  3.238394836154218e-06, -1.581255033300655e-07,
  4.540364818450457e-09, -9.775674852031915e-11,  1.736093831153704e-12, -2.673326846662653e-14,  3.679562702618387e-16, -4.619875777167010e-18,  5.368204215475358e-20,
 -5.835281003409190e-22,  5.983095065615714e-24, -5.824165726551339e-26,  9.836133012124270e-07, -5.423919269251435e-08,  1.727609677415175e-09, -4.085854667916817e-11,
  7.915715087123062e-13, -1.322709717885266e-14,  1.967294966771705e-16, -2.659738334654483e-18,  3.317966329901574e-20, -3.861959746354913e-22,  4.230347185644724e-24,
 -4.390261212777206e-26,  2.794852484392757e-07, -1.731197559238298e-08,  6.098748183694210e-10, -1.580855302319275e-11,  3.334945421200561e-13, -6.037754286171230e-15,
  9.690173554233776e-17, -1.408899126902825e-18,  1.884651393215175e-20, -2.346307556876389e-22,  2.742822134457459e-24, -3.031649118638984e-26,  7.435918765024636e-08,
 -5.149132941247330e-09,  2.000699740513993e-10, -5.672096516468829e-12,  1.300752585361353e-13, -2.547791744224553e-15,  4.406694775928483e-17, -6.882298940919839e-19,
  9.861314774176318e-21, -1.311804444214102e-22,  1.634980156615679e-24, -1.922940850461144e-26,  1.854491605404428e-08, -1.429378801119432e-09,  6.109586046388505e-11,
 -1.890758020491608e-12,  4.706041866475413e-14, -9.959184220220806e-16,  1.854178524099405e-17, -3.107279236706880e-19,  4.764368026415449e-21, -6.765853794912117e-23,
  8.983020730656344e-25, -1.123289531082845e-26,  4.340967023552577e-09, -3.709488684446940e-10,  1.739901889072509e-11, -5.866963394217960e-13,  1.582555733370721e-14,
 -3.613944871272594e-16,  7.234550221703365e-18, -1.299633217379841e-19,  2.130485137918123e-21, -3.227126769139711e-23,  4.560701654826001e-25, -6.058895455840352e-27,
  9.551544201870865e-10, -9.016441603618605e-11,  4.630028494200051e-12, -1.698176699170037e-13,  4.957336467699723e-15, -1.220154873682393e-16,  2.623630162614574e-18,
 -5.047722823781174e-20,  8.839438812993430e-22, -1.427081259767133e-23,  2.145201373937446e-25, -3.025705912760344e-27,  1.979033460607410e-10, -2.056853426400726e-11,
  1.153818762394466e-12, -4.595495945833003e-14,  1.449918413096191e-15, -3.842129990699073e-17,  8.865419999183558e-19, -1.825174267196296e-20,  3.411681402249818e-22,
 -5.866367575747104e-24,  9.373541722764572e-26, -1.402769998433443e-27,  3.869215376639813e-11, -4.413906528207418e-12,  2.699240784289368e-13, -1.165602795205796e-14,
  3.969718607766895e-16, -1.131334904123669e-17,  2.798732567113256e-19, -6.160662423868668e-21,  1.228314419416916e-22, -2.248001214438698e-24,  3.815716247739622e-26,
 -6.055197826733307e-28,  7.155370137114717e-12, -8.933741573406373e-13,  5.943997846609572e-14, -2.778744393017016e-15,  1.020303495876482e-16, -3.124085281475352e-18,
  8.278576353053836e-20, -1.946913951834524e-21,  4.137562672919985e-23, -8.054550748201188e-25,  1.451475636907127e-26, -2.441126828139902e-28,  1.255176908893046e-12,
 -1.710535455291171e-13,  1.235901043313157e-14, -6.245743156699134e-16,  2.469597627523494e-17, -8.116214899673168e-19,  2.301863032155724e-20, -5.779227536057362e-22,
  1.308249122000150e-23, -2.707257594901471e-25,  5.176539638467243e-27, -9.221801721556423e-29,  2.095402359817155e-13, -3.108880556540791e-14,  2.434844221726858e-15,
 -1.328275248874409e-16,  5.649258085895202e-18, -1.990817622949181e-19,  6.037909526473809e-21, -1.617166639175029e-22,  3.896811601802377e-24, -8.566970888356763e-26,
  1.737140551841117e-27, -3.276253121172702e-29,  3.341778866571428e-14, -5.384579831670024e-15,  4.563153580148774e-16, -2.683455208515202e-17,  1.226204565440667e-18,
 -4.629089615911166e-20,  1.500083029348287e-21, -4.282905586310510e-23,  1.097833199305778e-24, -2.562519878092885e-26,  5.507145869105575e-28, -1.099014887681201e-29,
  5.113992318553880e-15, -8.927504211358085e-16,  8.172080005522809e-17, -5.173358513721724e-18,  2.536923960057033e-19, -1.024959696310984e-20,  3.545840304752686e-22,
 -1.078366778642719e-23,  2.938382957348169e-25, -7.277428982115085e-27,  1.656663859025880e-28, -3.496274724036658e-30,  7.548188310433620e-16, -1.424240377613897e-16,
  1.405792165720063e-17, -9.566745444968401e-19,  5.028699169421975e-20, -2.172112483091101e-21,  8.014946494231987e-23, -2.594332705778813e-24,  7.509251626306206e-26,
 -1.972036042621600e-27,  4.752237129156099e-29, -1.060003875110621e-30,  1.080933849621087e-16, -2.199313390507051e-17,  2.336675165106802e-18, -1.706953352555586e-19,
  9.605947267565582e-21, -4.431315551416025e-22,  1.742395753798954e-23, -5.997623817691965e-25,  1.842639089557261e-26, -5.127350713847626e-28,  1.307100935249640e-29,
 -3.079478450009992e-31,  1.512140809804372e-17, -3.309727684678292e-18,  3.778289891914050e-19, -2.958351657579975e-20,  1.780065816574520e-21, -8.759933110495150e-23,
  3.666633152828902e-24, -1.340921520476808e-25,  4.368998678446891e-27, -1.287128297672989e-28,  3.468517328892279e-30, -8.624988507779529e-32,  2.082671614878131e-18,
 -4.891819225050609e-19,  5.988950702785791e-20, -5.018214550551662e-21,  3.224053261483087e-22, -1.690449305890207e-23,  7.523739821068813e-25, -2.920281330757578e-26,
  1.008100344126232e-27, -3.141517662263260e-29,  8.941226933763032e-31, -2.344787132479365e-32,  2.849478443791220e-19, -7.164071503208847e-20,  9.387625587783530e-21,
 -8.403476073526636e-22,  5.756026125880765e-23, -3.211178189763728e-24,  1.517805995162978e-25, -6.245347592596099e-27,  2.281720538581250e-28, -7.513572564435625e-30,
  2.256388789583559e-31, -6.234509770210367e-33,  3.912292765999035e-20, -1.050046646576605e-20,  1.469585515136466e-21, -1.402801088262203e-22,  1.022691864800771e-23,
 -6.061266981025336e-25,  3.038219820547274e-26, -1.323524439306531e-27,  5.111166182357363e-29, -1.776375741550520e-30,  5.622344049682541e-32, -1.634972351663020e-33,
  5.452353535895607e-21, -1.557789234002467e-21,  2.323163245764626e-22, -2.359867796443121e-23,  1.827715419897906e-24, -1.148818986911867e-25,  6.096871858124935e-27,
 -2.807552029769299e-28,  1.144371164373558e-29, -4.191887265850772e-31,  1.396459867789456e-32, -4.268407664092325e-34,  7.812120904244400e-22, -2.368741216077399e-22,
  3.754643074474598e-23, -4.049380960194330e-24,  3.324785209906024e-25, -2.211935044035007e-26,  1.240558735797282e-27, -6.028044153151307e-29,  2.588996269178859e-30,
 -9.979216994259265e-32,  3.493589059572078e-33, -1.120713004050103e-34,  1.167099629020093e-22, -3.743298772153043e-23,  6.288721390863311e-24, -7.182510280545704e-25,
  6.236798137594698e-26, -4.381790529676458e-27,  2.591495292295586e-28, -1.326031565495069e-29,  5.989171619673561e-31, -2.424530145168497e-32,  8.903496008811179e-34,
 -2.992211597259870e-35,  1.846105045015544e-23, -6.241072400688065e-24,  1.107803367169522e-24, -1.336005302856361e-25,  1.223528616691807e-26, -9.054279743198735e-28,
  5.632808157031823e-29, -3.027848926866776e-30,  1.434842802068124e-31, -6.086868347728018e-33,  2.339632180501413e-34, -8.220102651748445e-36,  3.142705784825204e-24,
 -1.115564644758308e-24,  2.084853832042389e-25, -2.646217613413048e-26,  2.547972495671437e-27, -1.980092579110037e-28,  1.292053798374566e-29, -7.275993057057774e-31,
  3.607915697899190e-32, -1.599733770136845e-33,  6.419896256391441e-35, -2.352289008020790e-36,  5.855825529009575e-25, -2.173527196128078e-25,  4.260211620585719e-26,
 -5.669887071734243e-27,  5.719558623334095e-28, -4.651768899333925e-29,  3.173240805360166e-30, -1.866077957102534e-31,  9.652576645861496e-33, -4.459959884303069e-34,
  1.863239435882348e-35, -7.099510273057380e-37,  1.214462605163185e-25, -4.692524041815062e-26,  9.604572439286868e-27, -1.334760730913179e-27,  1.404955146725994e-28,
 -1.191222186577975e-29,  8.463120857417970e-31, -5.178269577370085e-32,  2.784232425705932e-33, -1.335949733389906e-34,  5.790627777189549e-36, -2.286971349700008e-37,
  2.846997785535532e-26, -1.139663438767571e-26,  2.424252264621950e-27, -3.501574831313166e-28,  3.828513330111438e-29, -3.369219426581992e-30,  2.482382516147425e-31,
 -1.573804116468133e-32,  8.760487170348898e-34, -4.348159377870027e-35,  1.947951786672222e-36, -7.944582310955063e-38,  7.635479099102506e-27, -3.150520938933156e-27,
  6.928515116041199e-28, -1.034784549819598e-28,  1.169343056881397e-29, -1.062879583160290e-30,  8.082679247821067e-32, -5.285057781783200e-33,  3.031941738282402e-34,
 -1.549806319511132e-35,  7.145326837265997e-37, -2.996787558941232e-38,  2.354320118074718e-27, -9.959467081673260e-28,  2.251581265370655e-28, -3.457623172766630e-29,
  4.016049324246184e-30, -3.750109935669866e-31,  2.927954873520948e-32, -1.964469528281568e-33,  1.155685193501317e-34, -6.054230027383813e-36,  2.858978649457505e-37,
 -1.227369060761064e-38,  8.255722755410321e-28, -3.560510903816207e-28,  8.224742872194318e-29, -1.290798477019834e-29,  1.531854041904112e-30, -1.460925535045244e-31,
  1.164445010085380e-32, -7.971995844998537e-34,  4.783256440680237e-35, -2.554479122364058e-36,  1.229175864071273e-37, -5.374279634057239e-39,  3.121226129583347e-28,
 -1.364412741467251e-28,  3.199886186307283e-29, -5.099433023118987e-30,  6.144135434721684e-31, -5.947483739033480e-32,  4.810056765131576e-33, -3.340274409036966e-34,
  2.032258655707330e-35, -1.100158416606625e-36,  5.364433911708742e-38, -2.375927612358707e-39,  1.000159212634105e-28, -4.405236960219462e-29,  1.041960406177313e-29,
 -1.674852236885341e-30,  2.035237623991156e-31, -1.986652832550118e-32,  1.619935112664053e-33, -1.133988723818517e-34,  6.953512397075754e-36, -3.793141515689504e-37,
  1.863405238357607e-38, -8.313223394489611e-40,  4.826783303889345e-02, -9.540835307456192e-05,  1.937555855780399e-07, -4.029810531453474e-10,  8.545621182806578e-13,
 -1.840332983517696e-15,  4.005494986177980e-18, -8.791298245961663e-21,  1.936327857017886e-23, -4.286096805239589e-26,  9.462902053079080e-29, -2.102929648117988e-31,
  4.489759494850067e-02, -1.026294097634072e-04,  2.755020213921436e-07, -7.868059335422852e-10,  2.268353418824270e-12, -6.478513117446489e-15,  1.823996189197709e-17,
 -5.063674528394564e-20,  1.387600225129924e-22, -3.760328129170797e-25,  1.008538282765753e-27, -2.681879185071970e-30,  3.884700007914986e-02, -1.128610669054915e-04,
  4.145462976074763e-07, -1.525302356505532e-09,  5.405018434108895e-12, -1.849905555335483e-14,  6.155834972096528e-17, -2.001786548298864e-19,  6.383645543853087e-22,
 -2.001573981469568e-24,  6.182467986496346e-27, -1.884237739333796e-29,  3.126575778950461e-02, -1.199631034275550e-04,  5.692138952619070e-07, -2.527261031548306e-09,
  1.054100731364959e-11, -4.198749850489102e-14,  1.613289885378793e-16, -6.016987535395450e-19,  2.187895290446729e-21, -7.781927976214736e-24,  2.714493558740258e-26,
 -9.305293802650035e-29,  2.340830326886465e-02, -1.190006988665972e-04,  6.936021798063873e-07, -3.613191411784028e-09,  1.744607570515415e-11, -7.972897197665063e-14,
  3.487930106002781e-16, -1.471577181581510e-18,  6.020206670020332e-21, -2.397906927788094e-23,  9.329121725406029e-26, -3.554208330489843e-28,  1.630339418722334e-02,
 -1.084131115770540e-04,  7.524996218200972e-07, -4.538349124395514e-09,  2.509929897141558e-11, -1.302041934893323e-13,  6.418141730840099e-16, -3.032841610784389e-18,
  1.382725176200571e-20, -6.111798269233950e-23,  2.628965349330771e-25, -1.103769437294517e-27,  1.056372135108480e-02, -9.021454454221755e-05,  7.323793932815782e-07,
 -5.070148988483009e-09,  3.184460822470351e-11, -1.859495670738223e-13,  1.024620162512560e-15, -5.382310166811449e-18,  2.715239517905514e-20, -1.322749989168238e-22,
  6.249369875261408e-25, -2.873113874930108e-27,  6.368213385036219e-03, -6.852667380519915e-05,  6.435823993584160e-07, -5.079386830361379e-09,  3.597493131384028e-11,
 -2.348816434415288e-13,  1.437756866689441e-15, -8.346241535646663e-18,  4.632741735221124e-20, -2.473999036784069e-22,  1.277154311835262e-24, -6.397378028777864e-27,
  3.572067828819870e-03, -4.757650349351990e-05,  5.131437888929220e-07, -4.589737972850828e-09,  3.644065976238233e-11, -2.645834358780500e-13,  1.790041730921838e-15,
 -1.142835066410497e-17,  6.947869746226022e-20, -4.049494748363878e-22,  2.274559664350938e-24, -1.236309783629112e-26,  1.864547037231572e-03, -3.024900125479486e-05,
  3.726101430600563e-07, -3.757165936285322e-09,  3.327485356699351e-11, -2.674575484303280e-13,  1.991523537648216e-15, -1.392796553142319e-17,  9.239033706382648e-20,
 -5.855754054353196e-22,  3.566243973048657e-24, -2.096250695116774e-26,  9.058187237600636e-04, -1.764789404318436e-05,  2.471250555758697e-07, -2.796103787656283e-09,
  2.750650088575927e-11, -2.438200421922101e-13,  1.991023128570269e-15, -1.520178960582375e-17,  1.096756919118601e-19, -7.535978132776097e-22,  4.961540159385277e-24,
 -3.144936512117904e-26,  4.096391213916595e-04, -9.466087319642374e-06,  1.500589319018807e-07, -1.897275706879706e-09,  2.065651772343393e-11, -2.012565674662233e-13,
  1.796794026143534e-15, -1.493401141162691e-17,  1.168626707601132e-19, -8.682350257972048e-22,  6.164056077218202e-24, -4.203074083728175e-26,  1.724843655205394e-04,
 -4.676346175542026e-06,  8.359383994953350e-08, -1.176715597111782e-09,  1.413374367678760e-11, -1.509230677931621e-13,  1.469213811883965e-15, -1.325971205952024e-17,
  1.122755041625376e-19, -8.998981588474650e-22,  6.874307797374296e-24, -5.031783655916766e-26,  6.764003582255010e-05, -2.131061666458919e-06,  4.279928569717368e-08,
 -6.685341590843983e-10,  8.833641590493374e-12, -1.031189828261558e-13,  1.092021589590218e-15, -1.067822341225824e-17,  9.763399532540048e-20, -8.425544820802458e-22,
  6.912210110280115e-24, -5.421372140109818e-26,  2.471195008472589e-05, -8.971747198240214e-07,  2.017264682205065e-08, -3.486091617067255e-10,  5.054579293466298e-12,
 -6.435785934632950e-14,  7.398728009513150e-16, -7.823561071869664e-18,  7.710214098694189e-20, -7.151535985984194e-22,  6.290439530001637e-24, -5.278113988091974e-26,
  8.414592635881039e-06, -3.494194834364731e-07,  8.766450044251233e-09, -1.671486890219820e-10,  2.653293214872115e-12, -3.677384406348688e-14,  4.580948307018904e-16,
 -5.229236761458846e-18,  5.545755379076904e-20, -5.520340309465552e-22,  5.198474671135831e-24, -4.659820773833685e-26,  2.671725910119555e-06, -1.260604134184462e-07,
  3.517746857371360e-09, -7.381747737893349e-11,  1.280186567519082e-12, -1.927835724811722e-14,  2.597936261892201e-16, -3.196562449160594e-18,  3.642876814227460e-20,
 -3.886277110394491e-22,  3.913014084060439e-24, -3.742498681313035e-26,  7.914724481131785e-07, -4.218277404041961e-08,  1.305334757205961e-09, -3.007651875248120e-11,
  5.687818749699390e-13, -9.291049702314833e-15,  1.352438507932291e-16, -1.791220288842097e-18,  2.190757354193746e-20, -2.501752527926797e-22,  2.690244320363185e-24,
 -2.742342681993605e-26,  2.189108138656894e-07, -1.310949544652875e-08,  4.485781524178706e-10, -1.132460081386536e-11,  2.331221363538444e-13, -4.124461427518276e-15,
  6.476305527498398e-17, -9.221457589945800e-19,  1.209013851867765e-20, -1.476299878816826e-22,  1.693745698422250e-24, -1.838373262009562e-26,  5.657797276863659e-08,
 -3.788982723953103e-09,  1.429801654398589e-10, -3.947037926247433e-12,  8.830187763924371e-14, -1.689721912139113e-15,  2.858565722209160e-17, -4.370952378445502e-19,
  6.136858675094376e-21, -8.005036557979620e-23,  9.789639740673918e-25, -1.130392446762276e-26,  1.367749374784322e-08, -1.019938099094438e-09,  4.233818391008751e-11,
 -1.275634525651351e-12,  3.096766533744567e-14, -6.401168745888637e-16,  1.165402277922467e-17, -1.911693008268933e-19,  2.871581577185392e-21, -3.997923990232250e-23,
  5.207291140993372e-25, -6.391644948035565e-27,  3.096390045328295e-09, -2.561072424416263e-10,  1.166688005649597e-11, -3.829879431886052e-13,  1.007488210646463e-14,
 -2.246885332035592e-16,  4.397753138739510e-18, -7.731860008499322e-20,  1.241512979912537e-21, -1.843397166127536e-23,  2.555343776313541e-25, -3.331836632097672e-27,
  6.573555128028442e-10, -6.009244853919585e-11,  2.997485983091418e-12, -1.070301333231904e-13,  3.046916891607915e-15, -7.323373732183812e-17,  1.539492017018055e-18,
 -2.898477913341735e-20,  4.971233077705115e-22, -7.866375318041373e-24,  1.159757417438958e-25, -1.605312339780402e-27,  1.310860119751641e-10, -1.320111447516801e-11,
  7.195117945706861e-13, -2.790145048527075e-14,  8.585006385257043e-16, -2.221518809687313e-17,  5.011219871125703e-19, -1.009557197749267e-20,  1.848164590333125e-22,
 -3.114642586222728e-24,  4.880864439306371e-26, -7.167966280207272e-28,  2.460188687203161e-11, -2.721113860415187e-12,  1.617335020431843e-13, -6.801181497670179e-15,
  2.259148086879149e-16, -6.287623030316847e-18,  1.520691047486026e-19, -3.275674935027219e-21,  6.396406954838771e-23, -1.147349061856501e-24,  1.910004319394645e-26,
 -2.974465461211968e-28,  4.355430611542163e-12, -5.276112228817073e-13,  3.413291011929925e-14, -1.554310245376208e-15,  5.567423314332238e-17, -1.665028083965531e-18,
  4.314085618458538e-20, -9.929223135091646e-22,  2.066819126317029e-23, -3.943706987867059e-25,  6.970492321839556e-27, -1.150527699729284e-28,  7.293120512592756e-13,
 -9.650659446479691e-14,  6.783282704221913e-15, -3.340352834197779e-16,  1.288819375592673e-17, -4.138016891958709e-19,  1.147721537795608e-20, -2.820563876907619e-22,
  6.254789476439310e-24, -1.268876310616282e-25,  2.380008895147012e-27, -4.161647147106003e-29,  1.158741937853335e-13, -1.670735343252081e-14,  1.273685467499826e-15,
 -6.773736202995045e-17,  2.812223496177340e-18, -9.684986527841520e-20,  2.873372724808176e-21, -7.534889305158128e-23,  1.779044406169770e-24, -3.834998697932333e-26,
  7.629760996648297e-28, -1.412699840738004e-29,  1.753303101109946e-14, -2.748009309567824e-15,  2.268374617612940e-16, -1.301161656678225e-17,  5.806559052572606e-19,
 -2.143067461763347e-20,  6.795952253484725e-22, -1.900351134676252e-23,  4.774420352088306e-25, -1.093045605596293e-26,  2.305452668638213e-28, -4.518001543397800e-30,
  2.537469767433185e-15, -4.313178338171162e-16,  3.848754945155563e-17, -2.378086590821181e-18,  1.139525769503399e-19, -4.503226299042163e-21,  1.525201673293498e-22,
 -4.544818152900191e-24,  1.214276488114977e-25, -2.950769813323210e-27,  6.594848653372109e-29, -1.367220636403226e-30,  3.530259036983493e-16, -6.493091190468960e-17,
  6.253008005874955e-18, -4.156457756282950e-19,  2.136301068564465e-20, -9.031250716595534e-22,  3.264337380299159e-23, -1.035818349810003e-24,  2.941187322122113e-26,
 -7.582070448735656e-28,  1.794629134221237e-29, -3.933969605584889e-31,  4.749185688262778e-17, -9.430376971631310e-18,  9.785048179576360e-19, -6.987896288391001e-20,
  3.848076648629731e-21, -1.738592497757186e-22,  6.700723723022834e-24, -2.262461931569108e-25,  6.822759842705635e-27, -1.864652775765424e-28,  4.671393389302819e-30,
 -1.082138059543543e-31,  6.219993108241445e-18, -1.330362567545353e-18,  1.484784989902860e-19, -1.137610167109711e-20,  6.704030797798888e-22, -3.233784661861077e-23,
  1.327741434516232e-24, -4.766329337450420e-26,  1.525360937565162e-27, -4.416490029972017e-29,  1.170308831840604e-30, -2.863145581998484e-32,  7.993352792644904e-19,
 -1.837205529889971e-19,  2.201618594432713e-20, -1.807084484508706e-21,  1.138185152026889e-22, -5.854896717866627e-24,  2.558344338758803e-25, -9.755228593209991e-27,
  3.310267209122228e-28, -1.014579498463464e-29,  2.841551259978046e-31, -7.336530191585558e-33,  1.017090221387678e-19, -2.505950465408159e-20,  3.218337894008976e-21,
 -2.825420099158246e-22,  1.899336078124284e-23, -1.040624252999053e-24,  4.833633884219031e-26, -1.955694394351692e-27,  7.029674969355076e-29, -2.278627577144368e-30,
  6.739166636344766e-32, -1.834703220655200e-33,  1.294702716307948e-20, -3.410699376334113e-21,  4.684869888871523e-22, -4.391417577885395e-23,  3.145793402953341e-24,
 -1.833122786132020e-25,  9.039465045654318e-27, -3.876042758737859e-28,  1.474119558675001e-29, -5.047927349496173e-31,  1.574918957448865e-32, -4.516552561328675e-34,
  1.668251099003468e-21, -4.685920261563022e-22,  6.868811785636866e-23, -6.861189037099219e-24,  5.228364458030661e-25, -3.235125152477994e-26,  1.691049039037825e-27,
 -7.673655460584776e-29,  3.083687953970351e-30, -1.114126126546226e-31,  3.662317506613034e-33, -1.105034307238504e-34,  2.204852379901093e-22, -6.583841389511183e-23,
  1.027386492959585e-23, -1.091215717682474e-24,  8.827634360579443e-26, -5.789212788975261e-27,  3.202085591962177e-28, -1.535160142775085e-29,  6.508095323067996e-31,
 -2.477069757760974e-32,  8.566392066634496e-34, -2.715623171121959e-35,  3.033368587280578e-23, -9.598153639365798e-24,  1.590087856565884e-24, -1.791335406190574e-25,
  1.534878709809485e-26, -1.064522751751854e-27,  6.217580594207313e-29, -3.143133900969385e-30,  1.403061322868334e-31, -5.615566005717534e-33,  2.039531006279198e-34,
 -6.781322352405847e-36,  4.414945105227097e-24, -1.475099979025040e-24,  2.586418973069130e-25, -3.081782957900152e-26,  2.789364869885900e-27, -2.040770557861208e-28,
  1.255642320678363e-29, -6.677644939319380e-31,  3.131723140275017e-32, -1.315220595519696e-33,  5.006193928881256e-35, -1.742305260284559e-36,  6.917427026508265e-25,
 -2.431121605157360e-25,  4.495988634717969e-26, -5.647663750261194e-27,  5.383237405226669e-28, -4.142526567226798e-29,  2.677432838303992e-30, -1.493871122819628e-31,
  7.341431176497327e-33, -3.226945055506121e-34,  1.284111321013023e-35, -4.666700577630083e-37,  1.188249659097866e-25, -4.374406439782017e-26,  8.499387647879476e-27,
 -1.121416626208182e-27,  1.121703198131081e-28, -9.048097164614075e-30,  6.123074007630843e-31, -3.572943217323526e-32,  1.834294993293981e-33, -8.413618378090367e-35,
  3.490110839152671e-36, -1.320727609862450e-37,  2.279218364974769e-26, -8.749334313177085e-27,  1.778268259674302e-27, -2.454088957447273e-28,  2.565557055100606e-29,
 -2.160839239405617e-30,  1.525289316489790e-31, -9.274267664873549e-33,  4.956250810015512e-34, -2.364111054797252e-35,  1.018844488175084e-36, -4.001519298860872e-38,
  4.966717805974378e-27, -1.978373749502408e-27,  4.185734318169033e-28, -6.013465819373448e-29,  6.540412138948547e-30, -5.726319173661132e-31,  4.198048665965146e-32,
 -2.648643228350269e-33,  1.467423840306912e-34, -7.250137019714530e-36,  3.233623903360130e-37, -1.313145079468353e-38,  1.246990970556843e-27, -5.127110522890341e-28,
  1.123166875564303e-28, -1.670962386252755e-29,  1.881056552629711e-30, -1.703441758832728e-31,  1.290699175273512e-32, -8.409875952312659e-34,  4.808106323355979e-35,
 -2.449549495273465e-36,  1.125712529290220e-37, -4.706534658159632e-39,  3.632402836656476e-28, -1.533042679023569e-28,  3.456907450441646e-29, -5.294875549830202e-30,
  6.134421776331148e-31, -5.714004663427439e-32,  4.450520265498476e-33, -2.978995828184056e-34,  1.748519704486067e-35, -9.139531323021879e-37,  4.306623251525516e-38,
 -1.844976072776755e-39,  1.216751532809743e-28, -5.240469898640856e-29,  1.208714463789027e-29, -1.894083190698286e-30,  2.244434335066385e-31, -2.137374413254707e-32,
  1.701179531495653e-33, -1.163035414938259e-34,  6.968836787005257e-36, -3.716768599424496e-37,  1.786155023247630e-38, -7.799807539893526e-40,  4.451064798354895e-29,
 -1.944453057607742e-29,  4.556842466111205e-30, -7.256477639411982e-31,  8.736612077522521e-32, -8.450841330637144e-33,  6.829804035653766e-34, -4.739568125639826e-35,
  2.881651458456269e-36, -1.558944740368499e-37,  7.596603598579415e-39, -3.362455234209357e-40,  1.399755961574542e-29, -6.163636116652332e-30,  1.457431209692723e-30,
 -2.341963715024428e-31,  2.845026074316264e-32, -2.776273262144421e-33,  2.263127266214327e-34, -1.583774730956715e-35,  9.708775675577398e-37, -5.294647974096564e-38,
  2.600311642824245e-39, -1.159765363155958e-40,  4.788926941391049e-02, -9.387742180337444e-05,  1.890006529774062e-07, -3.895973718162254e-10,  8.186971946471298e-13,
 -1.747086362494670e-15,  3.767786525972804e-18, -8.195648429094337e-21,  1.788624470026359e-23, -3.925452662581875e-26,  8.584548551864853e-29, -1.893590785044458e-31,
  4.449142640279492e-02, -1.004625529801183e-04,  2.662739120490085e-07, -7.515255292217259e-10,  2.143048444254810e-12, -6.057278457810663e-15,  1.688231662640469e-17,
 -4.640545852201823e-20,  1.259214348073547e-22, -3.379548005498309e-25,  8.976728060360745e-28, -2.364553094520116e-30,  3.840207466841111e-02, -1.096164684790675e-04,
  3.967495966359866e-07, -1.441703503367870e-09,  5.049368975096076e-12, -1.708667177507826e-14,  5.622883330857877e-17, -1.808577419905666e-19,  5.705665357283920e-22,
 -1.770085470549800e-24,  5.410329263755926e-27, -1.631893150134253e-29,  3.079482469157175e-02, -1.155278961230751e-04,  5.398716539742366e-07, -2.365118130369143e-09,
  9.738651463610406e-12, -3.831011369114228e-14,  1.454209336786262e-16, -5.359666866142913e-19,  1.926342508207943e-21, -6.773768063899653e-24,  2.336385280877352e-26,
 -7.920718574334738e-29,  2.294313004888345e-02, -1.136206875843797e-04,  6.518675209551986e-07, -3.346369637664357e-09,  1.593197826334532e-11, -7.183139321576820e-14,
  3.101610903262263e-16, -1.292051805464323e-18,  5.220525422479891e-21, -2.054229071529857e-23,  7.897046378658599e-26, -2.973416159111230e-28,  1.588144620421130e-02,
 -1.026043209638475e-04,  7.003656645037352e-07, -4.156784084577946e-09,  2.264262205179336e-11, -1.157716515245404e-13,  5.627723841299505e-16, -2.623635247109112e-18,
  1.180514465481869e-20, -5.151262895978507e-23,  2.188009408418076e-25, -9.073165872031341e-28,  1.021420777820483e-02, -8.459048902414090e-05,  6.744761532186337e-07,
 -4.589100610797129e-09,  2.835980800435413e-11, -1.630731897641092e-13,  8.853968946980772e-16, -4.585036197274687e-18,  2.281156686373613e-20, -1.096337892678564e-22,
  5.111510492738534e-25, -2.319654444486462e-27,  6.104031333353774e-03, -6.361238521888557e-05,  5.859341919301289e-07, -4.539570701715792e-09,  3.160426290325662e-11,
 -2.030201860234320e-13,  1.223545088904721e-15, -6.996932196868570e-18,  3.827655136894639e-20, -2.015289894881728e-22,  1.026046913458166e-24, -5.070336724876321e-27,
  3.389636776836179e-03, -4.368213626957983e-05,  4.613978858667292e-07, -4.046790996415355e-09,  3.155392502216492e-11, -2.252239929952381e-13,  1.499102071769126e-15,
 -9.421734951098202e-18,  5.641505514869115e-20, -3.239838146041556e-22,  1.793729091212414e-24, -9.613080032230363e-27,  1.749239511928003e-03, -2.743980361309001e-05,
  3.305500796297943e-07, -3.265091364088626e-09,  2.837372700084161e-11, -2.240252336340279e-13,  1.639948551524022e-15, -1.128294279797492e-17,  7.366952438667886e-20,
 -4.598020440639766e-22,  2.758662608556562e-24, -1.598019359011746e-26,  8.389787388750258e-04, -1.579797924125454e-05,  2.160595441355578e-07, -2.392552580150184e-09,
  2.307541595827928e-11, -2.007704634990826e-13,  1.610687429127679e-15, -1.209048880554909e-17,  8.580828751336905e-20, -5.802892815465485e-22,  3.761788477484665e-24,
 -2.348697664728805e-26,  3.740390692045045e-04, -8.351357889279683e-06,  1.291490385075545e-07, -1.596764377706978e-09,  1.703081389511982e-11, -1.627560283382363e-13,
  1.426616706667390e-15, -1.165031921740158e-17,  8.963191378467529e-20, -6.550604038229875e-22,  4.576865554436271e-24, -3.072576143077746e-26,  1.550321917290502e-04,
 -4.060450980529310e-06,  7.073636078258725e-08, -9.729268281260877e-10,  1.143979836744591e-11, -1.197393501372454e-13,  1.143725728159735e-15, -1.013621591563240e-17,
  8.433758820101538e-20, -6.646146896887111e-22,  4.994120466737538e-24, -3.597439213706917e-26,  5.975296566769783e-05, -1.818502239342706e-06,  3.556119633251292e-08,
 -5.423665808180629e-10,  7.010841150927408e-12, -8.017153159299469e-14,  8.325664871239914e-16, -7.990226624984870e-18,  7.175266689795870e-20, -6.085148306369063e-22,
  4.908527798898584e-24, -3.787071851225870e-26,  2.142133871171772e-05, -7.512438455950205e-07,  1.643503346553772e-08, -2.771381091776978e-10,  3.928593657992135e-12,
 -4.897298615860936e-14,  5.518060160191724e-16, -5.723866081477369e-18,  5.537644107923387e-20, -5.045486199730988e-22,  4.361800264234568e-24, -3.598766442507185e-26,
  7.145424376253418e-06, -2.866415729422687e-07,  6.992918356072549e-09, -1.300288532894792e-10,  2.016862574665247e-12, -2.735307861495058e-14,  3.337980314591854e-16,
 -3.736130544263096e-18,  3.888031409933455e-20, -3.800167194932875e-22,  3.515820499876045e-24, -3.097792747755503e-26,  2.218613634818886e-06, -1.011407108602178e-07,
  2.743130906809575e-09, -5.610847548467445e-11,  9.503497040053389e-13, -1.399755079914114e-14,  1.847047569589678e-16, -2.227436267477537e-18,  2.489885727870434e-20,
 -2.607196627418607e-22,  2.578171329225424e-24, -2.422978255846877e-26,  6.415420321949254e-07, -3.304211604352772e-08,  9.934153883693323e-10, -2.230194564357378e-11,
  4.117335398668344e-13, -6.575463355973255e-15,  9.368575897950625e-17, -1.215662692827176e-18,  1.457858820983515e-20, -1.633515991314129e-22,  1.724614333726509e-24,
 -1.726943936617679e-26,  1.728713079068492e-07, -1.000680294903082e-08,  3.325918603584694e-10, -8.178160320675149e-12,  1.642913005809087e-13, -2.840750820409172e-15,
  4.364517373040260e-17, -6.086554059651799e-19,  7.822081245675502e-21, -9.368988239720108e-23,  1.055027571986298e-24, -1.124576054097830e-26,  4.344055303265260e-08,
 -2.812926458038947e-09,  1.030877418834304e-10, -2.771081227617484e-12,  6.048096287489606e-14, -1.130754140356255e-15,  1.871179348358882e-17, -2.801443568627924e-19,
  3.854357394042342e-21, -4.930409457828851e-23,  5.916659454834728e-25, -6.707759261192654e-27,  1.018892705267369e-08, -7.349224566705307e-10,  2.962565743414729e-11,
 -8.690225734244329e-13,  2.057722485118969e-14, -4.154682633636155e-16,  7.397142021992581e-18, -1.187796883536882e-19,  1.748019480157685e-21, -2.386046576925515e-23,
  3.048995084151884e-25, -3.673764776795331e-27,  2.232985389506878e-09, -1.787228757986432e-10,  7.906662477265766e-12, -2.526678426278555e-13,  6.482048662688962e-15,
 -1.411813630118392e-16,  2.701825460349145e-18, -4.649078237255417e-20,  7.312361687549531e-22, -1.064314742119767e-23,  1.447205204874350e-25, -1.852045673316375e-27,
  4.578493627571931e-10, -4.052076772103449e-11,  1.963114127059076e-12, -6.823601957630305e-14,  1.894269044071989e-15, -4.445999380294212e-17,  9.137190706816530e-19,
 -1.683475184850511e-20,  2.827936667826786e-22, -4.386033104087638e-24,  6.342250636206638e-26, -8.615403483894443e-28,  8.796319689383887e-11, -8.580731709601224e-12,
  4.543288529310973e-13, -1.715169944820271e-14,  5.146281523667618e-16, -1.300359606452239e-17,  2.867537570937098e-19, -5.652872511882767e-21,  1.013485273160479e-22,
 -1.673965904307215e-24,  2.572677085042898e-26, -3.707641025031171e-28,  1.586388096340237e-11, -1.700662058996498e-12,  9.822349383590003e-14, -4.021730930081926e-15,
  1.302804466679731e-16, -3.540762833093553e-18,  8.371596563798549e-20, -1.764572711675393e-21,  3.374497930355270e-23, -5.932323028400957e-25,  9.685192773233582e-27,
 -1.480102374382402e-28,  2.691435948454483e-12, -3.162187949845675e-13,  1.988629900739093e-14, -8.819302492576064e-16,  3.081239933869183e-17, -8.999476611505630e-19,
  2.279699055917864e-20, -5.134567234595128e-22,  1.046764595385321e-23, -1.957619787046913e-25,  3.393529276074673e-27, -5.496850884140897e-29,  4.306593211758590e-13,
 -5.531202964105591e-14,  3.781033080120534e-15, -1.813926729702353e-16,  6.828101162366241e-18, -2.141451298404133e-19,  5.807842088267833e-21, -1.396927201545833e-22,
  3.034324203930039e-24, -6.033858514615753e-26,  1.110109249170939e-27, -1.905140275199937e-29,  6.518833674558200e-14, -9.130349122821374e-15,  6.773135397366173e-16,
 -3.510695553992468e-17,  1.422457816151372e-18, -4.786489164886926e-20,  1.388918250574155e-21, -3.565449830374853e-23,  8.247475497636676e-25, -1.743034043310106e-26,
  3.402036225364727e-28, -6.183385574779180e-30,  9.367825791246046e-15, -1.427532387524790e-15,  1.147388150436909e-16, -6.417790992456345e-18,  2.796289462485625e-19,
 -1.008757479251845e-20,  3.129747980854916e-22, -8.569872386671745e-24,  2.109975128076653e-25, -4.737114387894380e-27,  9.804524816636654e-29, -1.886553846879271e-30,
  1.283397391069403e-15, -2.123098471115818e-16,  1.846044837065886e-17, -1.112941285100370e-18,  5.209594365481286e-20, -2.013219074790587e-21,  6.673956853896656e-23,
 -1.948141872156130e-24,  5.102623807950591e-26, -1.216403445300841e-27,  2.668596592613540e-29, -5.433825504098094e-31,  1.684516051874832e-16, -3.018547709135290e-17,
  2.834975220619783e-18, -1.839984925549984e-19,  9.243969742291678e-21, -3.823614483331354e-22,  1.353419087769073e-23, -4.208965525128358e-25,  1.172143311840487e-26,
 -2.965493046457803e-28,  6.892814698703875e-30, -1.484612556534457e-31,  2.130520652742427e-17, -4.126481637481601e-18,  4.179618746223599e-19, -2.916786320786034e-20,
  1.571168364003468e-21, -6.950154103193451e-23,  2.624794296939572e-24, -8.690770014866539e-26,  2.571808749852537e-27, -6.901634831592224e-29,  1.698746499021963e-30,
 -3.868417721293532e-32,  2.614080782695656e-18, -5.460492861820336e-19,  5.955297401771399e-20, -4.462920536073522e-21,  2.574813227722716e-22, -1.216950044551858e-23,
  4.899635001373837e-25, -1.725961565687495e-26,  5.423752586458764e-28, -1.542929816493728e-29,  4.019327978442128e-31, -9.671917368692598e-33,  3.136037113174079e-19,
 -7.049106538156011e-20,  8.264166582181258e-21, -6.641581176100334e-22,  4.099229972628353e-23, -2.067966054599830e-24,  8.868108739345150e-26, -3.320826973310791e-27,
  1.107326857202814e-28, -3.336957843812374e-30,  9.193962692881647e-32, -2.336377895923776e-33,  3.712111903067065e-20, -8.957615545351316e-21,  1.126893617894689e-21,
 -9.697739203472518e-23,  6.395112735599766e-24, -3.439599781423781e-25,  1.569437215752214e-26, -6.241600252480752e-28,  2.206504682612560e-29, -7.038021683484057e-31,
  2.049315954953336e-32, -5.495479917228462e-34,  4.381194696031375e-21, -1.132139965956884e-21,  1.525401970398575e-22, -1.403388783648423e-23,  9.873604338529525e-25,
 -5.654419235389371e-26,  2.741913046458645e-27, -1.156807774741962e-28,  4.331102820331241e-30, -1.460793865020798e-31,  4.491048723336991e-33, -1.269724995996708e-34,
  5.218112952612392e-22, -1.440110386316772e-22,  2.073758415442401e-23, -2.035926514235847e-24,  1.525683247185635e-25, -9.289109511113977e-27,  4.780371618442905e-28,
 -2.136757491244164e-29,  8.462191623143973e-31, -3.014435326139456e-32,  9.774061599465056e-34, -2.910234804437288e-35,  6.357887665697955e-23, -1.868574037397968e-23,
  2.868996422671050e-24, -2.999436399349253e-25,  2.389576478989941e-26, -1.544054161501002e-27,  8.418882434067824e-29, -3.980667147142590e-30,  1.665054401508984e-31,
 -6.255564971719660e-33,  2.136248731388656e-34, -6.689902095792346e-36,  8.047411058004127e-24, -2.510685336174103e-24,  4.099392273552223e-25, -4.552999180104608e-26,
  3.847673375177310e-27, -2.633128756172468e-28,  1.518160286870763e-29, -7.579088799008222e-31,  3.342406650717141e-32, -1.322108154225081e-33,  4.747323897579307e-35,
 -1.561107212021639e-36,  1.076298591897699e-24, -3.552189351154423e-25,  6.149322227667302e-26, -7.235655170550965e-27,  6.469610321745146e-28, -4.677620074335784e-29,
  2.845213393824104e-30, -1.496392916798103e-31,  6.942695888598986e-33, -2.885415072791585e-34,  1.087222036212549e-35, -3.746909179165794e-37,  1.549466502671886e-25,
 -5.389026689081522e-26,  9.857416605976209e-27, -1.224911892917572e-27,  1.155308246791282e-28, -8.799774019840052e-30,  5.631336006667173e-31, -3.111891165357504e-32,
  1.515087267046134e-33, -6.599580343909625e-35,  2.603228706039898e-36, -9.380453525742578e-38,  2.448651904314612e-26, -8.937034726428651e-27,  1.720611882940922e-27,
 -2.249690167329085e-28,  2.230425363538130e-29, -1.783728093303378e-30,  1.197051329891610e-31, -6.928670880574961e-33,  3.529223121265945e-34, -1.606499848120696e-35,
  6.614895116519831e-37, -2.485326937823522e-38,  4.333733299703412e-27, -1.652218134023643e-27,  3.333383950179636e-28, -4.566620213079786e-29,  4.739939919499205e-30,
 -3.964458240949390e-31,  2.779526331207471e-32, -1.678965723784567e-33,  8.915456403768153e-35, -4.226375687891634e-36,  1.810493614956306e-37, -7.069435112436522e-39,
  8.756225752785915e-28, -3.469648725328165e-28,  7.299372253374757e-29, -1.042757395403269e-29,  1.127867292718469e-30, -9.821661035776077e-32,  7.162733935534931e-33,
 -4.496166683175730e-34,  2.478714781622096e-35, -1.218798573247157e-36,  5.410665085770319e-38, -2.187321771999137e-39,  2.052693930567812e-28, -8.408301170791900e-29,
  1.834421906804182e-29, -2.717947705966985e-30,  3.047396917309536e-31, -2.748846037576285e-32,  2.074867536909543e-33, -1.346926511007813e-34,  7.672969826588651e-36,
 -3.895433677270202e-37,  1.784107431950662e-38, -7.434721636020164e-40,  5.634822595867921e-29, -2.372305529507098e-29,  5.334843797303409e-30, -8.148991339352286e-31,
  9.415775575968938e-32, -8.747519543601144e-33,  6.795898180309475e-34, -4.537620325226759e-35,  2.656936354533366e-36, -1.385531721365696e-37,  6.513885783357465e-39,
 -2.784423161307453e-40,  1.799163202967254e-29, -7.737762510040484e-30,  1.781863563756578e-30, -2.787733501408633e-31,  3.298155995961615e-32, -3.135972196706848e-33,
  2.492217072589401e-34, -1.701335769798571e-35,  1.017972300702302e-36, -5.421714839866220e-38,  2.601969985136268e-39, -1.134740784416828e-40,  6.357871604242907e-30,
 -2.775507781904249e-30,  6.499339548190309e-31, -1.034160647535512e-31,  1.244131624747534e-32, -1.202516248162323e-33,  9.711234560591865e-35, -6.734229595305728e-36,
  4.091488438149759e-37, -2.211917950156094e-38,  1.077119040915294e-39, -4.764473061944422e-41,  1.960304603630141e-30, -8.629544386298437e-31,  2.039870533235932e-31,
 -3.276845866933894e-32,  3.979460059755804e-33, -3.882074969847188e-34,  3.163564235171460e-35, -2.213244478211205e-36,  1.356347997321430e-37, -7.394636440448088e-39,
  3.630618159997171e-40, -1.618838191866085e-41,  };
  int offset = -49;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 49;
    if (std::isnan(t)) {
      fill_n(rr+offset, 49, 0.5);
      fill_n(ww+offset, 49, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 49; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=49; ++j) {
        const int boxof = it*588+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
