// Coordinates: 49.665548, 10.541500
// Map Width: 5000km

RMS.LoadLibrary("rmgen");
RMS.LoadLibrary("rmgen2");

InitMap();

log("Initializing environment...");
setBiome(1);
initMapSettings();
initTileClasses(["autumn", "desert", "medit", "polar", "steppe", "temp"]);

setSunColor(0.733, 0.746, 0.574);

setWindAngle(-0.589049);
setWaterTint(0.556863, 0.615686, 0.643137);
setWaterColor(0.494118, 0.639216, 0.713726);
setWaterWaviness(8);
setWaterMurkiness(0.87);
setWaterType("ocean");

setTerrainAmbientColor(0.72, 0.72, 0.82);

setSunRotation(PI * 0.95);
setSunElevation(PI / 6);

setSkySet("cumulus");
setFogFactor(0);
setFogThickness(0);
setFogColor(0.69, 0.616, 0.541);

setPPEffect("hdr");
setPPContrast(0.67);
setPPSaturation(0.42);
setPPBloom(0.23);

log("Resetting terrain...");
resetTerrain(g_Terrains.mainTerrain, g_TileClasses.land, 1);
RMS.SetProgress(10);

var biomes = {
	"autumn": {
		// terrains
		"mainTerrain": "temp_grass_d_aut",
		"forestFloor1": "temp_grass_long_b_aut",
		"forestFloor2": "temp_grass_long_b_aut",
		"roadWild": "road_rome_a",
		"road": "road_muddy",
		// gaia
		"tree1": "gaia/flora_tree_oak_aut_new",
		"tree2": "gaia/flora_tree_oak_dead",
		"tree3": "gaia/flora_tree_apple",
		"tree4": "gaia/flora_tree_euro_beech_aut",
		"tree5": "gaia/flora_tree_pine",
		"fruitBush": "gaia/flora_bush_berry",
		"mainHuntableAnimal": "gaia/fauna_sheep",
		"secondaryHuntableAnimal": "gaia/fauna_wolf",
		"stoneLarge": "gaia/geology_stonemine_temperate_quarry",
		"stoneSmall": "gaia/geology_stone_temperate",
		"metalLarge": "gaia/geology_metal_temperate_slabs",
		"metalSmall": "gaia/geology_metal_temperate",
		// decoratives
		"grass": "actor|props/flora/grass_soft_dry_small.xml",
		"grassShort": "actor|props/flora/grass_soft_dry_tuft_a.xml",
		"rockLarge": "actor|geology/stone_granite_med.xml",
		"rockMedium": "actor|geology/stone_granite_small.xml",
		"bushMedium": "actor|props/flora/bush_medit_me_dry.xml",
		"bushSmall": "actor|props/flora/bush_medit_sm_dry.xml",
	},
	"desert": {
		// terrains
		"mainTerrain": "sand_scrub_100",
		"forestFloor1": "sand_scrub_25",
		"forestFloor2": "sand_scrub_25",
		"roadWild": "desert_city_tile_pers",
		"road": "desert_city_tile_pers_dirt",
		// gaia
		"tree1": "gaia/flora_tree_cretan_date_palm_short",
		"tree2": "gaia/flora_tree_senegal_date_palm",
		"tree3": "gaia/flora_tree_date_palm",
		"tree4": "gaia/flora_tree_cretan_date_palm_tall",
		"tree5": "gaia/flora_tree_date_palm",
		"fruitBush": "gaia/flora_bush_grapes",
		"mainHuntableAnimal": "gaia/fauna_camel",
		"secondaryHuntableAnimal": "gaia/fauna_gazelle",
		"stoneLarge": "gaia/geology_stonemine_desert_quarry",
		"stoneSmall": "gaia/geology_stone_desert_small",
		"metalLarge": "gaia/geology_metal_desert_slabs",
		"metalSmall": "gaia/geology_metal_desert_small",
		// decoratives
		"grass": "actor|props/flora/grass_field_parched_tall.xml",
		"grassShort": "actor|props/flora/grass_soft_dry_tuft_a.xml",
		"rockLarge": "actor|structures/gravestone.xml",
		"rockMedium": "actor|geology/stone_desert_med.xml",
		"bushMedium": "actor|props/flora/bush_desert_dry_a.xml",
		"bushSmall": "actor|props/flora/plant_desert_a.xml",
	},
	"medit": {
		// terrains
		"mainTerrain": "medit_grass_field_a",
		"forestFloor1": "medit_grass_wild",
		"forestFloor2": "medit_grass_wild",
		"roadWild": "road_rome_a",
		"road": "road_muddy",
		// gaia
		"tree1": "gaia/flora_tree_poplar_lombardy",
		"tree2": "gaia/flora_tree_cypress",
		"tree3": "gaia/flora_tree_olive",
		"tree4": "gaia/flora_tree_carob",
		"tree5": "gaia/flora_tree_tamarix",
		"fruitBush": "gaia/flora_bush_grapes",
		"mainHuntableAnimal": "gaia/fauna_deer",
		"secondaryHuntableAnimal": "gaia/fauna_goat",
		"stoneLarge": "gaia/geology_stonemine_medit_quarry",
		"stoneSmall": "gaia/geology_stone_mediterranean",
		"metalLarge": "gaia/geology_metal_mediterranean_slabs",
		"metalSmall": "gaia/geology_metal_greek",
		// decoratives
		"grass": "actor|props/flora/grass_soft_small_tall.xml",
		"grassShort": "actor|props/flora/grass_soft_small.xml",
		"rockLarge": "actor|geology/stone_granite_greek_large.xml",
		"rockMedium": "actor|geology/stone_granite_greek_med.xml",
		"bushMedium": "actor|props/flora/bush_medit_underbrush.xml",
		"bushSmall": "actor|props/flora/bush_medit_me_lush.xml",
	},
	"polar": {
		// terrains
		"mainTerrain": "polar_tundra_snow",
		"forestFloor1": "ice_dirt",
		"forestFloor2": "ice_dirt",
		"roadWild": "road_flat",
		"road": "road1",
		// gaia
		"tree1": "gaia/flora_tree_pine_w",
		"tree2": "gaia/flora_tree_dead",
		"tree3": "gaia/flora_tree_dead",
		"tree4": "gaia/flora_tree_pine_w",
		"tree5": "gaia/flora_tree_pine_w",
		"fruitBush": "gaia/fauna_wolf_snow",
		"mainHuntableAnimal": "gaia/fauna_muskox",
		"secondaryHuntableAnimal": "gaia/fauna_wolf",
		"stoneLarge": "gaia/geology_stonemine_alpine_quarry",
		"stoneSmall": "gaia/geology_stone_alpine_a",
		"metalLarge": "gaia/geology_metal_alpine_slabs",
		"metalSmall": "gaia/geology_metal_alpine",
		// decoratives
		"grass": "actor|props/flora/grass_field_parched_short.xml",
		"grassShort": "actor|props/flora/grass_soft_dry_tuft_a.xml",
		"rockLarge": "actor|geology/stone_granite_med.xml",
		"rockMedium": "actor|geology/stone_granite_small.xml",
		"bushMedium": "actor|props/flora/bush_highlands.xml",
		"bushSmall": "actor|props/flora/bush_medit_sm.xml",
	},
	"steppe": {
		// terrains
		"mainTerrain": "steppe_grass_a",
		"forestFloor1": "steppe_grass_c",
		"forestFloor2": "steppe_grass_c",
		"roadWild": "road2",
		"road": "medit_city_tile_dirt",
		// gaia
		"tree1": "gaia/flora_tree_poplar",
		"tree2": "gaia/flora_tree_toona",
		"tree3": "gaia/flora_tree_dead",
		"tree4": "gaia/flora_tree_acacia",
		"tree5": "gaia/flora_tree_poplar_lombardy",
		"fruitBush": "gaia/flora_bush_grapes",
		"mainHuntableAnimal": "gaia/fauna_deer",
		"secondaryHuntableAnimal": "gaia/fauna_horse",
		"stoneLarge": "gaia/geology_stonemine_alpine_quarry",
		"stoneSmall": "gaia/geology_stone_alpine_a",
		"metalLarge": "gaia/geology_metal_alpine_slabs",
		"metalSmall": "gaia/geology_metal_alpine",
		// decoratives
		"grass": "actor|props/flora/grass_medit_flowering_tall.xml",
		"grassShort": "actor|props/flora/grass_field_bloom_short.xml",
		"rockLarge": "actor|geology/stone_granite_greek_med.xml",
		"rockMedium": "actor|geology/stone_granite_greek_small.xml",
		"bushMedium": "actor|props/flora/bush_dry_a.xml",
		"bushSmall": "actor|props/flora/bush_highlands.xml",
	},
	"temp": {
		// terrains
		"mainTerrain": "temp_grass_long",
		"forestFloor1": "temp_grass_clovers_2",
		"forestFloor2": "temp_grass_clovers_2",
		"roadWild": "temp_road_overgrown",
		"road": "temp_road",
		// gaia
		"tree1": "gaia/flora_tree_oak_new",
		"tree2": "gaia/flora_tree_oak_dead",
		"tree3": "gaia/flora_tree_apple",
		"tree4": "gaia/flora_tree_euro_beech",
		"tree5": "gaia/flora_tree_oak_large",
		"fruitBush": "gaia/flora_bush_berry",
		"mainHuntableAnimal": "gaia/fauna_pig",
		"secondaryHuntableAnimal": "gaia/fauna_boar",
		"stoneLarge": "gaia/geology_stonemine_temperate_quarry",
		"stoneSmall": "gaia/geology_stone_temperate",
		"metalLarge": "gaia/geology_metal_temperate_slabs",
		"metalSmall": "gaia/geology_metal_temperate",
		// decoratives
		"grass": "actor|props/flora/grass_soft_large_tall.xml",
		"grassShort": "actor|props/flora/grass_soft_large.xml",
		"rockLarge": "actor|geology/stone_granite_large.xml",
		"rockMedium": "actor|geology/stone_granite_med.xml",
		"bushMedium": "actor|props/flora/bush_tempe_b.xml",
		"bushSmall": "actor|props/flora/bush_tempe_underbrush.xml",
	}
};

log("Copying heightmap...");
var scale = paintHeightmap(getHeightMap(), getTileMap(), getTilePallet(), (tile, x, y) => {

	if (tile.indexOf("cliff") >= 0)
		addToClass(x, y, g_TileClasses.mountain);

	if (tile.indexOf("desert") >= 0)
		addToClass(x, y, g_TileClasses.desert);

	if (tile.indexOf("medit") >= 0 && tile.indexOf("sand") < 0)
		addToClass(x, y, g_TileClasses.medit);

	if (tile.indexOf("polar") >= 0)
		addToClass(x, y, g_TileClasses.polar);

	if (tile.indexOf("steppe") >= 0)
		addToClass(x, y, g_TileClasses.steppe);

	if (tile.indexOf("temp") >= 0)
		addToClass(x, y, g_TileClasses.temp);

	if (tile.indexOf("aut") >= 0)
		addToClass(x, y, g_TileClasses.autumn);
});
RMS.SetProgress(30);

log("Rendering water...");
paintTileClassBasedOnHeight(-100, -1, 3, g_TileClasses.water);
RMS.SetProgress(40);

log("Placing player bases...");
// Coordinate system of the heightmap
var singleBases = [
	[70,30],
	[90,180],
	[270,75],
	[240,280],
	[160,180]
];

if (g_MapInfo.mapSize >= 320 || g_MapInfo.numPlayers > singleBases.length)
	singleBases.push(
		[140,60],
		[170,250],
		[210, 35],
		[300,155],
		[50,105]
	);

var strongholdBases = [
	[110,50],
	[180,260],
	[260,55]
];

randomPlayerPlacementAt(singleBases, strongholdBases, scale, 0.06, (tileX, tileY) => {

	for (let biome in biomes)
		if (checkIfInClass(tileX, tileY, g_TileClasses[biome]))
		{
			setLocalBiome(biomes[biome]);
			break;
		}
});
RMS.SetProgress(50);

function setLocalBiome(b)
{
	g_Terrains.mainTerrain = b.mainTerrain;
	g_Terrains.forestFloor1 = b.forestFloor1;
	g_Terrains.forestFloor2 = b.forestFloor2;
	g_Terrains.roadWild = b.roadWild;
	g_Terrains.road = b.road;
	g_Gaia.tree1 = b.tree1;
	g_Gaia.tree2 = b.tree2;
	g_Gaia.tree3 = b.tree3;
	g_Gaia.tree4 = b.tree4;
	g_Gaia.tree5 = b.tree5;
	g_Gaia.fruitBush = b.fruitBush;
	g_Gaia.mainHuntableAnimal = b.mainHuntableAnimal;
	g_Gaia.secondaryHuntableAnimal = b.secondaryHuntableAnimal;
	g_Gaia.stoneLarge = b.stoneLarge;
	g_Gaia.stoneSmall = b.stoneSmall;
	g_Gaia.metalLarge = b.metalLarge;
	g_Gaia.metalSmall = b.metalSmall;
	g_Decoratives.grass = b.grass;
	g_Decoratives.grassShort = b.grassShort;
	g_Decoratives.rockLarge = b.rockLarge;
	g_Decoratives.rockMedium = b.rockMedium;
	g_Decoratives.bushMedium = b.bushMedium;
	g_Decoratives.bushSmall = b.bushSmall;
	initBiome();
}

log("Placing fish...");
g_Gaia.fish = "gaia/fauna_fish";
addElements([
	{
		"func": addFish,
		"avoid": [
			g_TileClasses.fish, 10,
		],
		"stay": [g_TileClasses.water, 4],
		"sizes": ["normal"],
		"mixes": ["similar"],
		"amounts": ["many"]
	}
]);
RMS.SetProgress(60);

log("Placing whale...");
g_Gaia.fish = "gaia/fauna_whale_fin";
addElements([
	{
		"func": addFish,
		"avoid": [
			g_TileClasses.fish, 2,
			g_TileClasses.desert, 50,
			g_TileClasses.steppe, 50
		],
		"stay": [g_TileClasses.water, 7],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["scarce"]
	}
]);
RMS.SetProgress(70);

log("Rendering local biomes...");
for (let biome in biomes)
{
	setLocalBiome(biomes[biome]);

	let localAvoid = g_TileClasses[biome == "temp" ? "plateau" : "autumn"];

	addElements([
		{
			"func": addMetal,
			"avoid": [
				g_TileClasses.berries, 5,
				g_TileClasses.forest, 3,
				g_TileClasses.mountain, 2,
				g_TileClasses.player, 30,
				g_TileClasses.rock, 10,
				g_TileClasses.metal, 25,
				g_TileClasses.water, 4,
				localAvoid, 2
			],
			"stay": [g_TileClasses[biome], 0],
			"sizes": ["normal"],
			"mixes": ["same"],
			"amounts": ["many"]
		},
		{
			"func": addStone,
			"avoid": [
				g_TileClasses.berries, 5,
				g_TileClasses.forest, 3,
				g_TileClasses.mountain, 2,
				g_TileClasses.player, 30,
				g_TileClasses.rock, 10,
				g_TileClasses.metal, 25,
				g_TileClasses.water, 4,
				localAvoid, 2
			],
			"stay": [g_TileClasses[biome], 0],
			"sizes": ["normal"],
			"mixes": ["same"],
			"amounts": ["many"]
		},
		{
			"func": addForests,
			"avoid": [
				g_TileClasses.berries, 3,
				g_TileClasses.forest, 15,
				g_TileClasses.metal, 3,
				g_TileClasses.mountain, 2,
				g_TileClasses.player, 12,
				g_TileClasses.rock, 2,
				g_TileClasses.water, 2,
				localAvoid, 2
			],
			"stay": [g_TileClasses[biome], 0],
			"sizes": ["normal"],
			"mixes": ["normal"],
			"amounts": ["normal"]
		},
		{
			"func": addSmallMetal,
			"avoid": [
				g_TileClasses.berries, 5,
				g_TileClasses.forest, 3,
				g_TileClasses.mountain, 2,
				g_TileClasses.player, 30,
				g_TileClasses.rock, 10,
				g_TileClasses.metal, 15,
				g_TileClasses.water, 4,
				localAvoid, 2
			],
			"stay": [g_TileClasses[biome], 0],
			"sizes": ["normal"],
			"mixes": ["same"],
			"amounts": ["few", "normal", "many"]
		},
		{
			"func": addBerries,
			"avoid": [
				g_TileClasses.berries, 30,
				g_TileClasses.forest, 2,
				g_TileClasses.metal, 4,
				g_TileClasses.mountain, 2,
				g_TileClasses.player, 20,
				g_TileClasses.rock, 4,
				g_TileClasses.water, 2,
				localAvoid, 2
			],
			"stay": [g_TileClasses[biome], 0],
			"sizes": ["normal"],
			"mixes": ["normal"],
			"amounts": ["tons"]
		},
		{
			"func": addAnimals,
			"avoid": [
				g_TileClasses.animals, 10,
				g_TileClasses.forest, 1,
				g_TileClasses.metal, 2,
				g_TileClasses.mountain, 1,
				g_TileClasses.player, 15,
				g_TileClasses.rock, 2,
				g_TileClasses.water, 1,
				localAvoid, 2
			],
			"stay": [g_TileClasses[biome], 0],
			"sizes": ["normal"],
			"mixes": ["normal"],
			"amounts": ["tons"]
		},
				{
			"func": addAnimals,
			"avoid": [
				g_TileClasses.animals, 10,
				g_TileClasses.forest, 1,
				g_TileClasses.metal, 2,
				g_TileClasses.mountain, 1,
				g_TileClasses.player, 15,
				g_TileClasses.rock, 2,
				g_TileClasses.water, 1,
				localAvoid, 2
			],
			"stay": [g_TileClasses[biome], 0],
			"sizes": ["small"],
			"mixes": ["normal"],
			"amounts": ["tons"]
		},
		{
			"func": addStragglerTrees,
			"avoid": [
				g_TileClasses.berries, 5,
				g_TileClasses.forest, 5,
				g_TileClasses.metal, 2,
				g_TileClasses.mountain, 1,
				g_TileClasses.player, 12,
				g_TileClasses.rock, 2,
				g_TileClasses.water, 3,
				localAvoid, 2
			],
			"stay": [g_TileClasses[biome], 0],
			"sizes": ["normal"],
			"mixes": ["normal"],
			"amounts": ["some"]
		},
		{
			"func": addDecoration,
			"avoid": [
				g_TileClasses.forest, 2,
				g_TileClasses.mountain, 2,
				g_TileClasses.player, 12,
				g_TileClasses.water, 4,
				localAvoid, 2
			],
			"stay": [g_TileClasses[biome], 0],
			"sizes": ["small"],
			"mixes": ["same"],
			"amounts": ["normal"]
		}
	]);
}
RMS.SetProgress(90);

ExportMap();

function getHeightMap()
{
	return [5,5,5,5,5,5,5,3.75,2.50,1.25,-0.89,-1.78,-2.25,-2.75,-3,-3,-3,-3.10,-3.23,-3.40,-3.59,-3.59,-2.75,-5.17,-5.59,-6.89,-7.50,-8.04,-9.64,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-9.73,-8.76,-7.73,-6.92,-6.54,-6.24,-6.40,-6.39,-6.38,-6.38,-6.40,-6.54,-6.80,-7.14,-7.53,-7.86,-8.09,-8.25,-8.34,-8.36,-8.28,-8.43,-8.50,-8.41,-8.26,-7.98,-7.55,-7.03,-6.67,-6.54,-7.34,-7.97,-8.38,-8.61,-8.89,-9.17,-9.38,-9.68,-10,-10,-10,-10,-10,-10,-9.87,-9.60,-9.14,-8.53,-7.76,-6.99,-6.63,-6.28,-5.98,-5.63,-5.23,-4.99,-5.02,-5.38,-5.76,-6.03,-6.61,-7.36,-7.97,-8.39,-8.73,-8.99,-9.42,-10,-10,-10,-11,-11,-11,-10,-10,-10,-10,-9.42,-8.99,-8.68,-8.39,-7.93,-7.64,-7.50,-7.54,-7.51,-7.38,-7.10,-6.74,-6.26,-6.02,-5.97,-5.85,-5.84,-5.78,-5.63,-5.35,-5.11,-5.11,-5.36,-5.75,-6.12,-6.41,-6.72,-6.88,-6.93,-6.90,-6.79,-6.65,-6.84,-6.99,-7.36,-7.73,-7.89,-8.23,-8.59,-8.86,-9.02,-9.04,-8.88,-8.75,-8.62,-8.35,-8.11,-8,-8.11,-8.25,-8.26,-8.16,-8.04,-7.98,-7.91,-8,-8.25,-8.63,-8.88,-8.88,-8.50,-8.34,-8.12,-8.05,-8.22,-8.39,-8.68,-9.05,-9.75,-10,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-9.86,-9.63,-9.65,-9.73,-9.76,-9.66,-9.63,-9.78,-10,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-14,-14,-13,-13,-13,-13,-13,-13,-13,-12,-11,-10,-9.84,-8.90,-7.88,-6.75,-5.75,-5.50,-5.23,-5.13,-5.50,-5.90,-6.24,-6.38,-6.42,-6.54,-6.66,-6.75,-6.75,-6.66,-7.12,-7.39,-7.68,-8.04,-8.50,-8.88,-9.05,-9.48,-9.89,-10,-10,-10,-10,-9.75,-9.68,-10,-10,-11,-11,-12,-12,-12,-13,-13,-12,-11,-12,-13,-13,-13,-13,-13,-13,-13,-14,-14,-13,-12,-10,-9.43,-8.26,-7.42,-6.59,-6.10,-5.89,-6.03,-6.67,-7.18,-7.63,-7.90,-8.23,-8.49,-8.60,-8.54,-8.63,-8.66,-8.63,-8.50,-8.27,-7.93,-7.51,-7,-6.36,5,5,5,5,5,5,3.75,3.75,2.50,1.25,-0.78,-1.25,-2.04,-2.63,-2.93,-3,-3,-3.16,-3.42,-3.76,-4.22,-4.64,-5.53,-6.50,-7.75,-7.85,-7.86,-8.60,-9.24,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.51,-8.47,-7.64,-7.25,-7.09,-7.26,-7.34,-7.38,-7.38,-7.28,-7.54,-7.67,-7.75,-7.89,-8.12,-8.34,-8.49,-8.55,-8.60,-8.67,-8.85,-8.88,-8.80,-8.63,-8.37,-7.97,-7.60,-7.38,-7.63,-8.27,-8.88,-9.27,-9.52,-9.66,-9.93,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.72,-9.14,-8.52,-7.93,-7.63,-7.17,-6.86,-6.38,-6.14,-6.26,-6.39,-6.63,-7.01,-7.67,-8.25,-8.75,-9.18,-9.63,-9.98,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-9.88,-9.34,-9.03,-8.59,-8.28,-8.15,-8.18,-8.13,-7.98,-7.73,-7.36,-6.98,-6.67,-6.72,-6.62,-6.60,-6.53,-6.37,-6.29,-6.24,-6.01,-6.28,-6.74,-7.03,-7.23,-7.43,-7.62,-7.67,-7.64,-7.66,-7.73,-7.89,-7.93,-8.37,-8.75,-8.88,-9.22,-9.53,-9.86,-10,-10,-9.89,-9.62,-9.43,-9.16,-8.77,-8.72,-8.86,-9,-9,-8.90,-8.86,-8.76,-9.22,-9.17,-9.90,-10,-10,-10,-9.90,-9.11,-8.84,-8.27,-8.38,-8.61,-8.93,-9.75,-10,-10,-11,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-9.99,-9.92,-9.75,-9.60,-9.54,-9.64,-9.74,-9.63,-9.53,-9.75,-10,-10,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-14,-14,-15,-16,-16,-16,-15,-15,-14,-14,-13,-12,-11,-10,-9.27,-8.40,-7.50,-6.90,-6.79,-7,-7.38,-7.72,-7.88,-7.78,-7.55,-7.27,-7.25,-7.17,-7.39,-7.88,-8.17,-8.63,-9.17,-9.51,-9.74,-10,-10,-10,-11,-11,-11,-10,-10,-10,-11,-11,-12,-13,-13,-14,-14,-14,-15,-13,-14,-13,-14,-14,-15,-15,-15,-15,-16,-16,-15,-15,-13,-12,-10,-9.74,-8.77,-7.88,-6.88,-6.15,-6.50,-7.10,-7.63,-8.02,-8.49,-8.88,-9.11,-9.25,-9.23,-9.13,-9.17,-9.14,-9.01,-8.78,-8.50,-8.05,-7.52,-6.88,5,5,5,5,5,5,3.75,3.75,2.50,1.25,0.90,-0.79,-1.75,-2.63,-2.80,-3,-3,-3.18,-3.53,-4.03,-4.72,-5.55,-6.60,-7.75,-8.61,-9.13,-8.50,-8.75,-9.02,-9.55,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9,-8.22,-7.84,-7.90,-8.27,-8.36,-8.40,-8.42,-8.38,-8.55,-8.68,-8.64,-8.64,-8.61,-8.50,-8.64,-8.74,-8.75,-8.98,-9.13,-9.14,-9.10,-8.92,-8.63,-8.25,-8.13,-8.25,-8.53,-9.03,-9.65,-10,-10,-10,-10,-11,-11,-12,-12,-13,-13,-12,-12,-12,-11,-11,-10,-10,-9.97,-9.23,-8.74,-8.25,-7.88,-7.49,-7.27,-7.38,-7.35,-7.43,-7.88,-8.63,-9.14,-9.53,-9.98,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-10,-10,-9.64,-9.38,-9.14,-9.03,-9,-8.92,-8.68,-8.36,-7.88,-7.63,-7.51,-7.50,-7.41,-7.23,-7.28,-7.37,-7.47,-7.40,-7.38,-7.84,-8.18,-8.52,-8.63,-8.53,-8.40,-8.28,-8.41,-8.53,-8.63,-8.80,-9,-9.42,-9.75,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.84,-9.77,-9.75,-9.72,-9.62,-9.50,-9.42,-9.66,-10,-10,-10,-11,-11,-11,-10,-10,-9.73,-9.15,-8.79,-8.67,-9.28,-10,-10,-11,-12,-12,-12,-12,-11,-11,-10,-10,-10,-10,-9.89,-9.77,-9.75,-9.53,-9.41,-9.37,-9.50,-9.51,-9.47,-9.30,-9.54,-9.88,-10,-10,-10,-11,-11,-12,-12,-13,-13,-14,-15,-15,-15,-15,-15,-15,-15,-15,-16,-17,-18,-18,-18,-17,-17,-17,-16,-15,-14,-13,-12,-11,-11,-10,-9.66,-9.22,-9.29,-9.50,-9.73,-9.85,-9.76,-9.48,-9,-8.37,-8,-8.16,-8.50,-8.92,-9.50,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-14,-15,-15,-15,-16,-16,-17,-15,-16,-17,-15,-16,-18,-16,-18,-18,-18,-18,-17,-15,-13,-12,-11,-10,-9.15,-8.13,-7.18,-7.10,-7.43,-7.92,-8.49,-9,-9.38,-9.63,-9.75,-9.73,-9.59,-9.61,-9.54,-9.43,-9.24,-8.89,-8.50,-7.98,-7.36,5,5,5,5,5,5,3.75,3.75,2.50,2.50,0.93,-0.63,-1.17,-1.93,-2.63,-2.88,-3,-3.04,-3.48,-4.09,-4.90,-5.93,-7.17,-8.38,-9.36,-10,-9.55,-8.91,-8.88,-9.05,-9.92,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-9.36,-8.73,-8.55,-8.75,-9.05,-9.16,-9.25,-9.29,-9.27,-9.41,-9.64,-9.65,-9.48,-9.41,-9.18,-8.90,-8.85,-8.89,-9.14,-9.30,-9.36,-9.27,-9.12,-8.84,-8.55,-8.63,-8.93,-9.28,-9.75,-10,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-13,-13,-13,-12,-12,-11,-11,-11,-10,-9.84,-9.36,-8.91,-8.62,-8.40,-8.27,-8.25,-8.25,-8.62,-9.37,-9.90,-10,-10,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-12,-11,-11,-10,-10,-10,-10,-10,-9.76,-9.36,-8.98,-8.59,-8.37,-8.13,-8.16,-8.14,-8.11,-8.34,-8.61,-8.84,-9.13,-9.50,-9.74,-9.97,-10,-9.99,-9.75,-9.50,-9.38,-9.25,-9.39,-9.59,-9.87,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.50,-9.28,-9.54,-10,-10,-11,-11,-12,-12,-12,-11,-10,-10,-9.90,-10,-10,-10,-9.49,-9.39,-9.17,-9.15,-9.01,-9.25,-9.34,-9.24,-8.97,-9.25,-9.51,-9.89,-10,-10,-10,-11,-11,-12,-12,-13,-14,-15,-15,-16,-16,-16,-15,-16,-17,-18,-19,-19,-19,-19,-19,-19,-19,-18,-17,-16,-15,-14,-14,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-10,-9.98,-9.30,-9.34,-9.38,-9.65,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-11,-12,-13,-14,-15,-16,-16,-17,-17,-17,-18,-18,-19,-18,-18,-18,-19,-19,-19,-19,-20,-20,-19,-18,-16,-14,-13,-12,-11,-10,-9.28,-8.49,-8.05,-8.15,-8.50,-9.02,-9.39,-9.77,-10,-10,-10,-9.97,-9.91,-9.88,-9.75,-9.52,-9.24,-8.80,-8.30,-7.65,5,5,5,5,5,5,3.75,3.75,2.50,2.50,1.52,0.77,-0.63,-1.13,-1.68,-2.15,-2.53,-2.65,-3.13,-3.80,-4.74,-5.89,-7.24,-8.52,-9.74,-10,-10,-9.42,-9.05,-8.77,-9.55,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-9.63,-9.25,-9.18,-9.35,-9.68,-9.78,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-9.67,-9.37,-9.17,-9.25,-9.39,-9.40,-9.38,-9.17,-8.90,-8.88,-9.05,-9.48,-9.78,-10,-10,-11,-11,-11,-12,-12,-13,-14,-14,-15,-15,-14,-14,-14,-14,-13,-13,-13,-12,-11,-10,-10,-10,-9.91,-9.78,-9.64,-9.38,-9.15,-9.50,-10,-10,-11,-11,-11,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,-10,-10,-9.74,-9.28,-9.11,-9.05,-8.90,-9.02,-9.50,-9.89,-10,-10,-10,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-9.98,-9.65,-9.79,-9.88,-10,-10,-11,-11,-12,-11,-11,-10,-10,-10,-10,-10,-10,-9.75,-9.13,-8.75,-8.75,-8.75,-9.34,-9.84,-9.73,-9.11,-8.97,-9.09,-9.38,-9.60,-9.79,-10,-10,-11,-11,-12,-13,-14,-15,-15,-15,-15,-15,-15,-16,-18,-19,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-16,-16,-16,-16,-15,-14,-13,-13,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-14,-15,-16,-17,-18,-18,-18,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-17,-15,-14,-13,-12,-11,-10,-9.50,-8.91,-8.78,-9.25,-9.59,-9.97,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.75,-9.43,-9.02,-8.52,-7.90,5,5,5,5,5,5,3.75,3.75,3.75,2.50,2.34,1.38,0.90,-0.25,-0.76,-1.25,-1.66,-2,-2.50,-3.25,-4.22,-5.41,-6.86,-8.34,-9.67,-10,-10,-9.74,-9.04,-8.75,-9.24,-10,-10,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-9.92,-9.74,-9.72,-9.77,-10,-10,-10,-10,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.85,-9.68,-9.53,-9.40,-9.38,-9.16,-9.05,-9.13,-9.37,-9.76,-10,-10,-11,-11,-11,-12,-12,-13,-14,-15,-15,-16,-16,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-11,-11,-11,-11,-11,-10,-10,-10,-11,-11,-12,-12,-12,-12,-13,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-12,-12,-11,-11,-11,-11,-10,-10,-10,-9.93,-9.87,-10,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-12,-12,-12,-12,-12,-11,-11,-11,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.88,-9.73,-9.75,-9.92,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-9.73,-8.38,-8.88,-9.79,-10,-11,-12,-11,-10,-9.27,-9.10,-9.26,-9.65,-10,-10,-10,-11,-12,-13,-14,-14,-15,-15,-15,-15,-15,-17,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-18,-18,-18,-17,-16,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-15,-16,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-16,-15,-14,-13,-12,-11,-10,-9.68,-9.54,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.60,-9.17,-8.66,-8.01,5,5,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,1.25,0.93,0.30,-0.29,-0.75,-1.15,-1.63,-2.38,-3.40,-4.65,-6.10,-7.62,-9,-10,-10,-10,-9.43,-8.68,-8.91,-9.76,-10,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-11,-11,-11,-10,-10,-10,-10,-9.89,-9.47,-9.13,-9.13,-9.23,-9.48,-9.88,-10,-10,-11,-11,-11,-12,-13,-14,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-15,-16,-16,-16,-16,-16,-17,-16,-16,-16,-15,-15,-14,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-12,-12,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-11,-10,-9.68,-9.23,-9.13,-9.77,-10,-11,-11,-11,-11,-11,-12,-13,-13,-13,-12,-11,-10,-10,-11,-13,-15,-15,-15,-13,-11,-9.97,-10,-10,-10,-10,-10,-10,-11,-12,-13,-14,-14,-14,-15,-15,-16,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-16,-15,-15,-15,-15,-15,-15,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-12,-13,-13,-13,-14,-14,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,-17,-16,-14,-13,-13,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.93,-9.42,-8.85,-8.10,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.02,1.39,0.73,0.14,-0.25,-0.67,-1.34,-2.47,-3.73,-5.22,-6.85,-8.50,-9.88,-10,-11,-10,-9.26,-8.68,-9.38,-10,-10,-11,-11,-11,-11,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.75,-9.43,-9.26,-9.43,-9.75,-10,-10,-11,-11,-12,-12,-13,-14,-15,-16,-16,-17,-17,-16,-16,-16,-16,-17,-16,-16,-16,-15,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-16,-16,-17,-17,-17,-17,-18,-17,-17,-16,-16,-16,-15,-14,-14,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-12,-12,-12,-12,-13,-13,-13,-13,-13,-12,-12,-11,-11,-10,-10,-10,-9.67,-9.73,-10,-11,-11,-12,-12,-12,-11,-10,-9.61,-9.24,-9.05,-9.74,-10,-11,-11,-12,-13,-13,-13,-14,-14,-14,-14,-13,-13,-12,-14,-16,-17,-18,-17,-16,-14,-11,-11,-11,-11,-11,-10,-9.84,-10,-11,-12,-13,-13,-14,-14,-14,-16,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-17,-17,-17,-16,-16,-15,-15,-15,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-14,-14,-14,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-17,-16,-15,-14,-13,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.66,-9.03,-8.26,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.80,2.34,1.55,1.09,0.72,0.30,-0.38,-1.43,-2.64,-4.26,-5.99,-7.75,-9.52,-10,-11,-11,-10,-9.25,-8.99,-9.54,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-9.92,-9.77,-9.84,-10,-10,-11,-11,-12,-13,-14,-14,-15,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-14,-14,-14,-14,-14,-14,-15,-15,-16,-16,-16,-16,-15,-16,-16,-16,-16,-17,-17,-17,-18,-18,-18,-18,-17,-17,-17,-16,-16,-15,-14,-14,-14,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-13,-13,-13,-13,-13,-13,-13,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-12,-11,-11,-10,-10,-9.68,-9.17,-9.47,-10,-10,-11,-12,-12,-12,-12,-11,-10,-10,-10,-11,-11,-12,-13,-14,-15,-16,-16,-16,-15,-15,-14,-14,-13,-14,-16,-17,-18,-19,-18,-17,-15,-13,-11,-11,-11,-11,-11,-10,-10,-10,-11,-12,-12,-13,-13,-14,-16,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,-18,-18,-18,-17,-17,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-13,-14,-14,-14,-15,-15,-17,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-17,-16,-15,-14,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.77,-9.13,-8.38,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.27,2.79,2.27,2,1.65,1.09,0.60,-0.50,-1.54,-3.28,-5.09,-6.92,-8.75,-10,-11,-11,-11,-10,-9.29,-8.97,-9.50,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-11,-11,-12,-12,-13,-14,-15,-16,-16,-17,-17,-17,-17,-17,-17,-17,-18,-18,-17,-17,-16,-16,-15,-15,-15,-15,-15,-15,-14,-15,-15,-16,-16,-16,-16,-16,-16,-16,-17,-17,-17,-17,-17,-18,-18,-18,-18,-18,-18,-17,-17,-17,-16,-15,-15,-15,-14,-14,-13,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-15,-15,-15,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-13,-13,-13,-14,-14,-14,-13,-13,-12,-12,-11,-10,-9.93,-9.41,-9.11,-9.50,-10,-10,-11,-12,-12,-12,-13,-12,-12,-13,-14,-14,-14,-14,-15,-16,-16,-16,-17,-16,-15,-15,-14,-14,-13,-14,-15,-17,-18,-17,-17,-15,-14,-12,-12,-12,-12,-11,-11,-11,-10,-9.68,-10,-11,-11,-12,-12,-13,-15,-17,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-18,-18,-18,-18,-17,-17,-17,-17,-16,-16,-16,-15,-14,-14,-13,-13,-14,-14,-15,-15,-16,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,-17,-16,-15,-15,-14,-13,-12,-11,-11,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.74,-9.11,-8.35,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.92,2.80,2.45,1.87,1.38,0.34,-0.65,-2.35,-4.11,-6,-7.88,-9.61,-10,-11,-11,-11,-10,-8.85,-8.55,-9.09,-9.80,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-12,-13,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-14,-15,-16,-16,-17,-17,-17,-17,-17,-17,-18,-18,-18,-17,-17,-17,-16,-16,-16,-16,-15,-15,-15,-15,-15,-16,-16,-17,-17,-17,-17,-16,-16,-17,-17,-17,-17,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-16,-15,-15,-15,-15,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-13,-12,-12,-11,-10,-9.80,-9.28,-9.04,-9.28,-9.88,-10,-11,-12,-12,-12,-13,-13,-14,-16,-16,-16,-16,-16,-16,-16,-15,-15,-16,-15,-14,-13,-12,-12,-11,-12,-13,-15,-16,-15,-15,-13,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-9.38,-9.72,-10,-10,-11,-12,-14,-16,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-18,-18,-18,-17,-17,-17,-16,-16,-16,-15,-15,-14,-14,-14,-14,-15,-15,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-16,-15,-15,-14,-13,-12,-11,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.55,-8.92,-8.15,6.25,6.25,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.42,3.12,2.64,2.02,1.12,0.03,-1.47,-3.09,-4.92,-6.64,-8.25,-9.55,-10,-10,-10,-10,-8.67,-7.65,-8.89,-10,-10,-11,-11,-11,-10,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-12,-12,-12,-13,-13,-14,-15,-16,-16,-16,-16,-16,-17,-17,-17,-18,-18,-18,-17,-17,-17,-16,-16,-16,-16,-16,-15,-15,-15,-15,-16,-17,-17,-17,-17,-17,-16,-16,-17,-17,-17,-17,-18,-18,-18,-18,-18,-18,-17,-17,-17,-16,-16,-15,-15,-15,-15,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-13,-13,-12,-12,-11,-10,-9.53,-9.13,-9.04,-8.87,-9.63,-10,-11,-12,-12,-13,-14,-15,-16,-17,-16,-16,-16,-15,-15,-15,-14,-13,-12,-12,-12,-11,-10,-9.92,-9.50,-9.63,-10,-11,-12,-12,-11,-10,-9.91,-9.59,-9.78,-10,-10,-11,-12,-12,-11,-11,-10,-9.43,-9.02,-9.42,-9.88,-11,-13,-15,-17,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-19,-19,-18,-18,-18,-17,-17,-16,-16,-15,-15,-14,-14,-14,-14,-15,-15,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-17,-16,-15,-14,-14,-13,-12,-11,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-9.80,-9.27,-8.63,-8.01,6.25,6.25,6.25,6.25,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.12,2.80,2.01,0.62,-0.75,-2.11,-3.80,-5.42,-6.88,-8.13,-9.09,-9.55,-9.63,-9.13,-8.41,-7.50,-8.55,-9.75,-10,-11,-11,-12,-11,-11,-11,-11,-10,-11,-11,-11,-10,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-11,-12,-12,-12,-12,-12,-13,-13,-14,-14,-15,-16,-16,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-15,-15,-16,-16,-17,-17,-17,-17,-16,-16,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-15,-14,-14,-14,-13,-13,-13,-13,-12,-13,-13,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-12,-12,-12,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-12,-12,-11,-10,-10,-9.37,-9.11,-8.92,-8.76,-9.41,-10,-11,-12,-12,-14,-15,-16,-17,-17,-16,-16,-15,-14,-13,-12,-11,-10,-10,-9.75,-9.05,-8.51,-7.93,-7.50,-7,-6.98,-7.17,-7.66,-8.47,-8.66,-8.34,-7.36,-6.78,-7.13,-7.88,-8.93,-10,-11,-12,-13,-13,-13,-12,-10,-9.37,-8.24,-8.50,-9.63,-11,-14,-16,-18,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-20,-20,-20,-19,-18,-18,-18,-17,-16,-16,-16,-15,-15,-14,-14,-14,-14,-14,-15,-15,-16,-16,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-16,-16,-15,-15,-14,-13,-13,-12,-11,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-9.88,-9.39,-8.86,-8.29,-7.77,6.25,6.25,7.50,6.25,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.59,3.38,2.48,1.25,-0.13,-1.29,-2.76,-4.25,-5.60,-6.79,-7.77,-8.41,-8.66,-8.40,-7.54,-7.16,-7.67,-8.59,-9.77,-11,-12,-12,-12,-11,-11,-11,-12,-12,-12,-12,-11,-11,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-14,-15,-15,-15,-15,-15,-16,-16,-16,-16,-17,-17,-16,-16,-16,-16,-17,-17,-16,-16,-15,-15,-15,-15,-16,-16,-16,-17,-16,-16,-16,-16,-16,-16,-16,-16,-16,-17,-17,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-12,-12,-13,-13,-14,-14,-15,-14,-15,-15,-15,-15,-14,-14,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-12,-12,-13,-13,-13,-13,-12,-12,-11,-11,-10,-9.73,-9.30,-9.13,-8.84,-9.04,-9.87,-10,-11,-11,-13,-15,-16,-16,-16,-16,-15,-14,-12,-11,-10,-9.80,-9.09,-8.42,-7.84,-7.27,-6.52,-6.14,-5.63,-5.38,-4.93,-4.76,-4.62,-4.66,-3.93,-4.63,-4.49,-3.76,-3.68,-4.13,-5.49,-7.28,-9.38,-11,-13,-14,-15,-14,-13,-12,-10,-9.02,-7.75,-8.40,-10,-12,-14,-16,-18,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-20,-20,-20,-19,-18,-18,-17,-17,-16,-16,-15,-15,-14,-14,-14,-14,-14,-14,-14,-15,-15,-16,-17,-17,-18,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,-17,-17,-16,-16,-15,-15,-14,-14,-13,-12,-11,-11,-11,-11,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-9.63,-9.13,-8.61,-8.09,-7.42,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,3.75,3.75,3.75,5,5,3.75,4.18,3.89,3.12,1.87,0.46,-0.75,-1.86,-3.11,-4.42,-5.63,-6.62,-7.35,-7.75,-7.84,-7.66,-7.40,-7.88,-8.42,-10,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-13,-12,-11,-10,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-14,-14,-15,-15,-15,-16,-16,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-16,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,-10,-10,-11,-11,-12,-12,-13,-12,-12,-12,-11,-11,-10,-10,-9.50,-9.25,-9.05,-8.80,-9.79,-10,-10,-11,-12,-14,-16,-17,-16,-16,-15,-13,-12,-9.85,-8.27,-7.50,-6.84,-6.37,-6.11,-5.63,-5.22,-4.62,-4.24,-3.88,-3.59,-3.38,-3.15,-2.78,-2.66,-2.66,-2.75,-2.99,-3,-3,-3.02,-3.62,-5.36,-8.63,-11,-14,-16,-16,-15,-14,-13,-11,-9.80,-8.17,-7.24,-8.92,-10,-12,-14,-16,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-20,-20,-20,-19,-18,-17,-17,-16,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-14,-15,-16,-16,-16,-17,-17,-17,-18,-18,-19,-20,-20,-20,-20,-20,-20,-19,-18,-17,-16,-15,-15,-15,-15,-14,-14,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.77,-9.55,-9.22,-8.80,-8.40,-7.89,-7.25,6.25,6.25,6.25,6.25,5,5,6.25,6.25,6.25,6.25,6.25,5,5,3.75,3.75,5,5,5,5,5,3.75,2.64,1.23,-0.15,-1.17,-2.23,-3.42,-4.61,-5.62,-6.47,-7.10,-7.50,-7.68,-7.72,-9.38,-11,-12,-13,-12,-11,-10,-10,-11,-11,-12,-13,-13,-13,-13,-11,-10,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-15,-14,-14,-14,-14,-14,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-13,-13,-13,-12,-11,-10,-10,-9.80,-9.47,-9.75,-10,-10,-11,-11,-12,-12,-12,-11,-11,-11,-10,-10,-9.75,-9.25,-9.09,-9.09,-9.55,-10,-11,-11,-11,-13,-16,-17,-17,-16,-15,-13,-11,-9.34,-7.38,-5.75,-4.10,-3.34,-3.47,-3.73,-3.77,-3.37,-3.02,-3,-3,-3,-2.74,-2.53,-2.38,-2.26,-2.39,-2.50,-2.65,-2.67,-2.75,-2.90,-3,-4,-7.35,-10,-13,-15,-17,-15,-14,-13,-12,-10,-8.27,-6.76,-7.14,-9.13,-11,-13,-14,-16,-18,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-19,-19,-20,-20,-20,-20,-20,-18,-16,-15,-14,-14,-14,-13,-13,-14,-14,-14,-14,-13,-14,-14,-15,-15,-15,-15,-15,-16,-16,-16,-16,-17,-18,-19,-19,-19,-19,-18,-18,-17,-16,-15,-14,-14,-14,-14,-14,-13,-13,-12,-11,-11,-10,-10,-10,-10,-10,-10,-11,-10,-10,-10,-9.50,-9.14,-8.99,-8.78,-8.48,-8.11,-7.59,-6.89,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,3.75,3.75,5,5,5,5,5,4.95,3.38,2,0.40,-0.77,-1.60,-2.62,-3.67,-4.68,-5.63,-6.43,-7.18,-7.88,-9.14,-12,-14,-16,-16,-15,-12,-8.50,-8.72,-9.62,-10,-11,-12,-13,-14,-13,-12,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-13,-14,-13,-13,-13,-13,-12,-12,-11,-10,-9.74,-9.11,-8.88,-9,-9.38,-9.80,-10,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.74,-9.13,-8.87,-9.25,-9.77,-10,-10,-11,-12,-15,-17,-18,-17,-15,-13,-11,-9.18,-7.01,-5,-3.40,-1.75,-1.51,-1.53,-1.87,-2.25,-2.74,-3,-2.88,-2.79,-2.60,-2.25,-2.13,-1.87,-1.50,-1.65,-1.85,-1.74,-1.75,-2.13,-2.42,-2.88,-3.91,-5.63,-8.52,-11,-14,-15,-15,-14,-13,-12,-10,-8.76,-7.12,-6.75,-8.78,-10,-12,-13,-15,-16,-17,-18,-18,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-17,-17,-18,-19,-20,-20,-20,-20,-20,-20,-18,-15,-14,-13,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-16,-17,-17,-17,-17,-16,-16,-15,-14,-14,-13,-13,-13,-13,-13,-13,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.98,-9.42,-8.86,-8.54,-8.50,-8.34,-8,-7.61,-7.04,-6.43,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,3.75,3.75,3.75,5,5,5,5,4.97,3.70,2.64,1.03,-0.38,-1.25,-1.88,-2.84,-3.84,-4.86,-5.87,-6.91,-8.16,-10,-14,-17,-18,-18,-18,-16,-10,-6.99,-7.29,-8.99,-10,-12,-13,-13,-12,-11,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-13,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-10,-9.97,-9.40,-8.86,-8.63,-8.68,-9.13,-9.38,-9.74,-10,-10,-10,-10,-10,-10,-10,-10,-9.97,-9.52,-9.05,-8.99,-9.25,-10,-10,-10,-10,-12,-15,-17,-17,-16,-15,-13,-9.85,-7.38,-5.22,-3.15,-1.64,-0.60,-0.18,-0.53,-1,-1.43,-2.13,-2.63,-2.50,-2.36,-1.85,-1.13,-0.48,0.15,0.57,1.20,1.28,0.80,-0.03,-0.91,-2.02,-2.63,-3.72,-5.14,-6.38,-8.79,-11,-13,-12,-12,-11,-11,-10,-8.90,-8.38,-8.27,-9.04,-10,-13,-14,-15,-15,-16,-17,-17,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-18,-16,-17,-17,-18,-20,-20,-20,-20,-20,-20,-20,-17,-14,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.60,-8.97,-8.25,-7.99,-7.88,-7.72,-7.39,-7.11,-6.84,-6.48,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,3.75,3.75,3.75,3.75,5,5,5,3.75,3.75,3.75,1.55,0.46,-0.41,-1.14,-2.02,-3,-4.12,-5.25,-6.52,-8.30,-11,-15,-18,-19,-19,-18,-17,-16,-11,-7.64,-7.49,-9.41,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-9.98,-9.75,-9.68,-9.59,-9.36,-9.24,-9.17,-9,-9.13,-9.49,-10,-11,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-13,-13,-13,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.64,-9.17,-9.25,-9.87,-10,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-9.30,-8.91,-8.66,-8.52,-8.68,-9.14,-9.40,-9.64,-9.99,-10,-10,-10,-10,-10,-10,-9.90,-9.61,-9.15,-8.88,-9.17,-9.78,-10,-10,-10,-10,-13,-15,-16,-16,-15,-14,-12,-8.63,-5.85,-3.41,-1.67,-0.37,1.09,1.12,0.65,-0.25,-0.78,-1.38,-1.92,-1.87,-1.62,-1.04,0.01,1.42,2.96,3.59,2.36,4.30,3.72,2.64,-0.11,-1.43,-2.40,-2.99,-4.54,-5.53,-6.40,-7.80,-9.99,-9.99,-9.93,-9.97,-9.80,-9.13,-9.38,-10,-10,-10,-12,-14,-16,-16,-16,-16,-17,-18,-18,-17,-18,-18,-20,-20,-20,-20,-20,-20,-18,-17,-16,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-18,-15,-12,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.65,-8.91,-8.25,-7.75,-7.53,-7.42,-7.26,-7.04,-6.77,-6.42,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.59,1.51,0.46,-0.40,-1.25,-2.22,-3.38,-4.60,-5.91,-7.80,-11,-15,-18,-19,-19,-19,-19,-18,-16,-12,-8.54,-7.88,-9.26,-9.89,-9.77,-10,-10,-10,-10,-9.98,-9.99,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-12,-11,-11,-11,-11,-10,-10,-10,-9.75,-9.54,-9.39,-9.25,-9.23,-9.11,-8.77,-8.38,-7.92,-7.65,-8.51,-9.86,-10,-11,-12,-12,-12,-12,-12,-12,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.92,-9.60,-9.67,-9.99,-10,-10,-9.85,-9.93,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.73,-9.36,-9,-8.38,-8.25,-8.61,-9.85,-10,-11,-11,-11,-11,-10,-10,-10,-11,-11,-12,-12,-11,-11,-11,-10,-10,-10,-9.90,-9.52,-8.91,-8.67,-8.66,-8.68,-8.88,-8.91,-9.24,-9.49,-9.67,-9.88,-10,-10,-10,-10,-10,-9.92,-9.64,-9.24,-8.85,-8.54,-9.30,-9.88,-9.92,-10,-10,-11,-12,-14,-15,-15,-14,-13,-10,-7.17,-4.38,-2.24,-0.75,0.28,1.34,2.61,1.82,0.77,-0.14,-0.50,-0.98,-1.13,-0.73,-0.25,1.02,2.65,4.52,4.07,4.46,4.53,4.34,2.62,0.62,-1.25,-2.50,-2.88,-3.50,-4.54,-5.14,-5.38,-5.87,-7.10,-7.60,-8.14,-8.65,-9.24,-10,-11,-11,-12,-14,-16,-16,-17,-18,-18,-17,-18,-18,-18,-17,-17,-18,-19,-20,-20,-19,-18,-17,-17,-17,-17,-17,-17,-18,-20,-20,-20,-20,-20,-20,-20,-16,-13,-11,-11,-11,-10,-10,-10,-10,-10,-11,-11,-12,-12,-12,-14,-15,-15,-15,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.67,-8.91,-8.40,-7.98,-7.61,-7.34,-7.14,-6.91,-6.65,-6.30,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,3.75,3.75,3.75,3.75,3.75,5,5,5,5,5,3.59,2.61,1.54,0.46,-0.50,-1.38,-2.75,-3.98,-5.13,-6.66,-9.88,-14,-18,-19,-19,-19,-19,-19,-17,-15,-12,-9.13,-8.62,-9.38,-9.78,-9.93,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.97,-9.89,-9.54,-9.23,-9.34,-9.53,-9.36,-9,-8.47,-7.51,-7.22,-8.47,-9.53,-9.97,-10,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-9.75,-9.41,-9.15,-8.86,-8.87,-9.22,-9.38,-9.36,-9.25,-9.26,-9.38,-9.38,-9.52,-9.79,-9.90,-9.86,-9.63,-9.39,-9.18,-9.14,-9.04,-8.90,-8.86,-8.53,-8.17,-7.88,-7.98,-8.59,-9.63,-10,-11,-11,-11,-11,-11,-11,-10,-10,-11,-11,-11,-11,-10,-10,-10,-9.77,-9.34,-9,-8.62,-8.29,-8.50,-8.59,-8.76,-9.03,-9.11,-9.11,-9.30,-9.53,-9.75,-9.79,-9.97,-10,-10,-9.98,-9.63,-9.25,-8.92,-8.67,-8.72,-9.10,-9.63,-9.66,-9.49,-10,-11,-13,-14,-14,-14,-13,-11,-8.39,-5.63,-3.27,-1.38,-0.36,0.71,1.80,2.51,2.18,1.28,0.82,0.75,0.35,0.11,-0.05,0.64,1.59,2.80,4.30,3.43,4.63,4.57,4.05,2.32,0.26,-1.25,-2.26,-2.75,-2.92,-3.04,-3.72,-3.92,-3.75,-3.74,-5.60,-6.50,-7.65,-8.88,-10,-11,-13,-16,-17,-17,-17,-17,-18,-18,-17,-17,-18,-17,-17,-16,-17,-18,-18,-18,-17,-16,-17,-18,-18,-18,-18,-18,-18,-20,-20,-20,-20,-20,-20,-20,-19,-14,-11,-11,-11,-10,-10,-9.85,-9.86,-10,-11,-11,-11,-12,-13,-15,-17,-17,-17,-16,-15,-14,-14,-14,-13,-13,-12,-12,-12,-12,-12,-12,-12,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.59,-8.88,-8.62,-8.14,-7.75,-7.35,-6.97,-6.75,-6.47,-6.12,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,3.75,3.75,3.75,3.75,5,5,5,5,5,5,5,3.59,2.64,1.55,0.30,-0.75,-2.13,-3.38,-4.39,-5.38,-6.97,-11,-17,-18,-19,-19,-19,-19,-18,-16,-13,-11,-9.48,-10,-10,-10,-11,-11,-11,-11,-11,-10,-9.53,-9.51,-9.88,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.68,-9.63,-9.75,-9.41,-9.25,-8.89,-8.60,-8.37,-8.18,-8.76,-9.59,-9.97,-10,-10,-10,-10,-9.75,-9.63,-9.59,-9.12,-9.13,-9.75,-10,-10,-10,-10,-10,-10,-10,-9.77,-9.40,-9.04,-8.75,-8.49,-8.29,-8.28,-8.41,-8.53,-9.12,-9.18,-8.75,-8.53,-8.48,-8.48,-8.76,-8.90,-8.86,-8.90,-9.18,-9.03,-8.49,-8.53,-8.50,-8.28,-8.02,-7.78,-7.63,-7.87,-8.63,-9.77,-11,-11,-11,-12,-12,-12,-12,-11,-10,-10,-10,-10,-10,-10,-10,-9.68,-9.17,-8.72,-8.38,-8.09,-8.25,-8.50,-8.61,-8.78,-9.13,-9.22,-9.04,-9.13,-9.34,-9.43,-9.64,-9.75,-9.80,-9.80,-9.67,-9.37,-8.99,-8.65,-8.38,-8.59,-9.25,-9.50,-9.49,-9.13,-9.99,-11,-13,-13,-13,-13,-12,-9.41,-6.98,-4.63,-2.74,-1.05,0.11,1.34,2.17,2.82,2.75,2.34,2.13,2.13,1.71,1.27,1.07,1.52,1.98,2.60,3.25,4.65,3.37,3.05,2.53,1.27,-0.13,-1.05,-1.99,-2.51,-2.77,-2.41,-2.50,-3,-3,-3.03,-3.77,-5,-6.66,-8.28,-10,-12,-17,-20,-19,-18,-18,-17,-17,-16,-16,-15,-16,-16,-15,-13,-14,-15,-15,-15,-15,-16,-19,-19,-20,-20,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-15,-12,-11,-11,-10,-10,-9.42,-9.36,-9.79,-10,-10,-11,-12,-15,-17,-18,-19,-20,-19,-17,-15,-14,-14,-13,-13,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.52,-9.04,-8.79,-8.38,-7.98,-7.55,-7.04,-6.60,-6.17,-5.84,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,3.75,3.75,5,5,6.25,6.25,6.25,6.25,5,5,4.65,3.75,2.50,1.23,-0.13,-1.55,-3.01,-3.88,-4.42,-5.11,-7.65,-11,-15,-16,-17,-17,-17,-16,-15,-12,-11,-10,-9.77,-10,-10,-11,-12,-12,-12,-11,-10,-9.13,-8.79,-9.23,-9.68,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.63,-9.64,-9.75,-9.16,-8.75,-9.10,-9.43,-9.53,-9.26,-9.27,-9.80,-9.78,-9.78,-10,-9.98,-9.34,-8.29,-9.15,-9.25,-9.38,-9.40,-9.41,-9.49,-9.47,-9.38,-9.30,-9.24,-9.12,-8.93,-8.75,-8.50,-8.25,-8,-7.79,-7.72,-7.74,-7.91,-8.25,-8.50,-8.54,-8.40,-8.16,-8.05,-8.11,-8.23,-8.37,-8.49,-8.55,-8.63,-8.59,-8.48,-8.22,-8.11,-7.88,-7.72,-7.59,-7.64,-8.04,-8.80,-9.87,-10,-12,-12,-12,-13,-13,-12,-11,-10,-10,-9.62,-9.63,-9.72,-9.73,-9.55,-9.25,-8.87,-8.53,-8.04,-7.79,-8.10,-8.55,-8.89,-9.13,-9.27,-9.29,-9.13,-8.90,-9.34,-9.63,-9.75,-9.75,-9.50,-9.36,-9.18,-9,-8.78,-8.40,-8.25,-8.84,-9.78,-9.93,-9.53,-9.61,-11,-13,-13,-14,-14,-13,-10,-8.12,-5.50,-3.52,-2.13,-0.90,0.62,2.03,2.90,3.29,3.52,3.46,3.14,3.05,2.68,2.28,1.73,1.87,2.01,2.37,2.90,2.75,2.62,2.51,1.84,0.93,-0.02,-0.88,-1.55,-2.04,-1.52,-1.38,-1.25,-1.67,-2.93,-3,-3.25,-4.25,-5.77,-7.13,-9.84,-15,-19,-20,-19,-18,-17,-16,-14,-14,-13,-13,-13,-13,-12,-11,-11,-11,-11,-11,-12,-16,-18,-20,-20,-20,-20,-20,-20,-18,-20,-20,-20,-20,-20,-20,-19,-15,-13,-12,-11,-10,-9.88,-9.37,-9.16,-9.43,-10,-10,-11,-13,-16,-18,-20,-20,-20,-20,-18,-16,-15,-14,-13,-13,-13,-12,-12,-12,-12,-12,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.38,-9.10,-8.79,-8.38,-8.02,-7.64,-7.14,-6.51,-6.13,-5.74,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5.62,4.65,3.55,2.18,0.90,-0.59,-2.04,-3.12,-3.78,-4.23,-5.68,-7.89,-10,-12,-13,-14,-14,-13,-12,-11,-10,-9.50,-9.24,-9.54,-10,-11,-12,-12,-12,-11,-10,-9.66,-8.65,-8.79,-9.03,-9.15,-9.40,-9.63,-9.79,-10,-10,-10,-10,-10,-10,-9.88,-9.98,-10,-10,-9.97,-9.55,-9.47,-9.42,-8.85,-8.80,-9.72,-10,-10,-10,-10,-10,-10,-9.61,-9.63,-9.50,-9.18,-9.01,-9.01,-9.25,-9.42,-9.38,-9.13,-8.91,-8.65,-8.47,-8.26,-8.13,-8,-7.87,-7.73,-7.52,-7.38,-7.23,-7.05,-7,-7.05,-7.36,-7.72,-7.92,-8.03,-7.87,-7.66,-7.55,-7.59,-7.64,-7.75,-7.91,-7.90,-8,-8,-8,-7.63,-7.51,-7.27,-7.18,-7.13,-7.28,-7.72,-8.39,-9.38,-10,-11,-12,-13,-13,-14,-13,-11,-10,-10,-9.54,-9.43,-9.24,-9.22,-9.02,-8.84,-8.55,-8.22,-7.91,-8.17,-8.77,-9.16,-9.47,-9.60,-9.74,-9.53,-9.25,-9,-9.30,-9.59,-9.75,-9.73,-9.50,-9.14,-8.93,-8.75,-8.42,-8.12,-8.59,-9.17,-10,-10,-11,-11,-13,-14,-15,-14,-13,-12,-10,-6.92,-4.50,-3.03,-2.13,-0.75,0.90,2.46,3.30,3.71,3.68,4.80,3.90,3.26,3,2.90,2.30,2.32,2.04,1.72,2.79,2.50,2.50,2.47,1.53,1.07,0,-0.42,-0.88,-0.65,-0.13,0.64,0.62,-0.38,-1.75,-3,-3,-3.40,-4.88,-6.63,-10,-15,-19,-20,-20,-18,-17,-15,-13,-11,-9.93,-10,-11,-11,-10,-9.60,-9.16,-8.80,-8.80,-9.15,-10,-13,-17,-20,-20,-20,-20,-20,-20,-19,-18,-20,-20,-20,-20,-20,-17,-15,-14,-13,-12,-11,-10,-9.61,-9,-8.97,-9.63,-10,-11,-13,-16,-18,-20,-20,-20,-20,-19,-17,-15,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-9.98,-10,-10,-10,-11,-11,-10,-10,-10,-9.61,-9.36,-9.02,-8.60,-8.27,-7.88,-7.37,-6.76,-6.28,-5.88,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,6.25,6.25,6.25,5,5,5,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,3.75,2.02,0.72,-0.80,-2,-2.85,-3.13,-3.85,-4.91,-6.42,-8.74,-10,-10,-11,-10,-10,-9.73,-8.77,-8.25,-8.14,-8.63,-9.84,-11,-12,-12,-12,-12,-11,-10,-9.29,-9.42,-9.25,-9,-8.74,-9.16,-9.68,-10,-10,-10,-9.90,-9.68,-9.50,-9.25,-9.50,-10,-10,-10,-9.42,-8.88,-8.77,-8.35,-9.05,-10,-10,-11,-11,-12,-11,-11,-10,-9.62,-9.28,-9.03,-8.97,-8.93,-9.18,-9.24,-9.05,-8.60,-8.24,-7.76,-7.42,-7.15,-6.98,-6.87,-6.73,-6.63,-6.50,-6.43,-6.38,-6.26,-6.25,-6.34,-6.63,-7.02,-7.25,-7.40,-7.17,-7.03,-6.92,-6.90,-6.92,-6.99,-7.10,-7.04,-7.09,-7.10,-7.01,-6.72,-6.54,-6.28,-6.22,-6.17,-6.38,-6.80,-7.50,-8.50,-9.60,-10,-11,-12,-13,-14,-13,-11,-10,-10,-9.97,-9.52,-9,-8.55,-8.64,-8.53,-8.30,-8.23,-8.65,-9.23,-9.77,-10,-10,-10,-10,-10,-9.67,-9.24,-9.14,-9.39,-9.54,-9.60,-9.52,-9.36,-9,-8.62,-8.26,-8.26,-9.50,-9.92,-10,-11,-12,-13,-15,-16,-17,-16,-14,-12,-9.50,-6.24,-3.99,-2.76,-1.92,-0.63,1.02,2.46,3.27,3.42,3.68,3.88,3.75,2.68,2.68,2.64,3.89,1.39,1.39,2.64,2.50,2.50,2.50,3.75,2.50,1.42,0.78,0.29,0,0.43,1.57,2.50,2.20,1.09,-1.25,-2.63,-3,-3.02,-3.88,-6.29,-10,-14,-17,-20,-20,-16,-14,-12,-10,-8.24,-7.77,-8.52,-9.03,-8.93,-8.63,-7.91,-8.38,-8.10,-7.80,-7.18,-7.60,-10,-15,-18,-20,-20,-20,-20,-20,-19,-18,-18,-18,-20,-20,-18,-17,-17,-17,-15,-14,-12,-11,-9.88,-8.88,-8.60,-8.90,-9.43,-10,-13,-16,-19,-20,-20,-20,-20,-19,-16,-15,-14,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-9.87,-9.76,-9.80,-9.87,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-9.89,-9.42,-9.02,-8.75,-8.38,-7.88,-7.25,-6.50,-5.93,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,6.25,6.25,5,5,5,6.25,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,5,6.25,7.50,5,3.43,1.97,0.72,-0.43,-1.42,-1.87,-2.39,-3.02,-3.88,-5.80,-7.02,-7.76,-8.10,-8.04,-7.75,-7.38,-6.80,-6.51,-6.61,-7.18,-8.42,-9.98,-11,-11,-12,-12,-11,-10,-10,-10,-10,-9.78,-9.63,-9.73,-11,-12,-12,-11,-11,-10,-9.38,-9.17,-9.87,-11,-11,-11,-10,-9.13,-8.25,-7.86,-9.79,-11,-11,-12,-12,-12,-11,-11,-10,-9.55,-9.01,-8.65,-8.51,-8.47,-8.63,-8.59,-8.27,-7.72,-7.25,-6.66,-6.25,-5.89,-5.66,-5.55,-5.42,-5.41,-5.38,-5.39,-5.42,-5.38,-5.39,-5.50,-5.80,-6.18,-6.41,-6.55,-6.37,-6.24,-6.13,-6.09,-6.02,-6,-6.01,-5.98,-5.92,-5.87,-5.74,-5.43,-5.22,-4.90,-4.75,-4.73,-4.89,-5.40,-6.17,-7.22,-8.37,-9.62,-10,-12,-13,-14,-12,-11,-10,-10,-10,-10,-9.73,-9.02,-8.60,-8.63,-8.86,-9.25,-9.78,-10,-10,-11,-11,-11,-10,-10,-10,-9.75,-9.52,-9.41,-9.48,-9.54,-9.52,-9.35,-9.01,-8.54,-8.34,-9.27,-10,-10,-11,-12,-13,-14,-16,-18,-18,-17,-15,-12,-8.88,-5.72,-3.55,-2.53,-1.75,-0.51,0.72,1.90,2.79,2.98,3.25,3.72,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.34,1.64,1.25,1.21,1.37,2.82,3.61,3.07,1.82,-0.50,-2.41,-3,-3,-3.26,-5.34,-9.24,-13,-16,-17,-16,-13,-11,-9.15,-7.02,-6.42,-6,-6.03,-6.75,-6.76,-6.64,-6.47,-7,-7.14,-6.97,-6.25,-6.62,-7.84,-11,-15,-19,-20,-20,-20,-20,-19,-19,-18,-17,-17,-17,-18,-19,-19,-19,-18,-16,-13,-11,-10,-9.34,-8.34,-8.25,-8.75,-10,-12,-15,-19,-20,-20,-20,-20,-18,-15,-15,-14,-13,-13,-13,-13,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-9.97,-9.63,-9.54,-9.60,-9.67,-9.93,-10,-10,-10,-10,-10,-10,-10,-10,-9.85,-9.39,-9.13,-8.75,-8.27,-7.63,-6.88,-6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,7.50,6.25,4.84,3.59,2.02,1.09,0,-0.55,-1.22,-1.80,-2.39,-3.67,-4.53,-5.10,-5.35,-5.35,-5.13,-4.87,-4.60,-4.48,-4.66,-5.29,-6.42,-7.89,-9.10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-12,-13,-14,-14,-13,-12,-10,-10,-10,-10,-11,-11,-11,-10,-8.22,-8.77,-10,-11,-11,-12,-13,-12,-11,-10,-10,-9.24,-8.50,-7.99,-7.72,-7.53,-7.54,-7.40,-7.05,-6.50,-5.99,-5.38,-4.88,-4.47,-4.16,-4.04,-3.90,-3.99,-4.04,-4.23,-4.38,-4.41,-4.50,-4.63,-4.88,-5.22,-5.39,-5.51,-5.38,-5.25,-5.13,-5.04,-4.98,-4.88,-4.79,-4.75,-4.66,-4.52,-4.30,-4.03,-3.67,-3.35,-3.05,-2.98,-3.13,-3.63,-4.59,-5.65,-6.87,-8.25,-9.92,-11,-13,-14,-13,-11,-10,-10,-10,-10,-10,-9.73,-9.28,-9.17,-9.64,-10,-11,-11,-12,-12,-12,-12,-11,-11,-10,-10,-9.88,-9.84,-9.63,-9.38,-9.37,-9.22,-8.89,-8.49,-8.68,-9.50,-10,-11,-12,-14,-14,-15,-18,-19,-20,-19,-15,-12,-8.78,-4.38,-2.92,-2.63,-2.02,-1,0,1.39,2.21,2.47,2.90,3.71,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,2.50,1.37,2.34,3.38,3.28,3.59,3.54,1.37,-0.51,-2.64,-3,-3,-3,-3.68,-6.22,-10,-12,-13,-12,-10,-8.29,-6.22,-4.26,-4.17,-3.90,-3.76,-3.13,-3.59,-4.09,-4.90,-5.18,-5.64,-5.42,-5.12,-5.38,-5.99,-7.25,-11,-16,-19,-20,-19,-20,-19,-19,-18,-17,-17,-16,-18,-20,-20,-20,-20,-18,-16,-13,-11,-9.74,-8.64,-8.13,-8.39,-9.40,-11,-14,-17,-19,-20,-20,-19,-17,-16,-14,-13,-13,-13,-13,-13,-13,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.61,-9.13,-9.12,-9.38,-9.64,-9.91,-10,-10,-11,-11,-11,-10,-10,-10,-9.67,-9.30,-9,-8.50,-7.88,-7.13,-6.42,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,7.50,7.50,6.25,5,5,1.97,2.15,1.02,-0.24,-0.88,-1.43,-2.15,-2.63,-2.89,-2.92,-2.79,-2.55,-2.29,-2.16,-2.22,-2.42,-3.01,-4.04,-5.50,-6.80,-7.97,-8.67,-8.77,-8.93,-9.13,-9.34,-9.55,-9.86,-10,-11,-12,-13,-15,-15,-16,-15,-13,-12,-11,-11,-10,-11,-12,-12,-11,-9.76,-10,-10,-10,-11,-11,-11,-11,-10,-10,-9.39,-8.43,-7.62,-7,-6.60,-6.35,-6.18,-6,-5.63,-5.13,-4.52,-3.88,-3.29,-2.79,-2.42,-2.22,-2.09,-2.25,-2.54,-2.97,-3.24,-3.38,-3.49,-3.63,-3.86,-4.12,-4.26,-4.37,-4.26,-4.16,-4.03,-3.91,-3.76,-3.63,-3.53,-3.50,-3.41,-3.26,-3,-2.67,-2.23,-1.66,-1.16,-0.93,-1.13,-2,-3.14,-4.27,-5.51,-6.99,-8.75,-10,-13,-15,-14,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-11,-12,-12,-13,-13,-13,-13,-12,-12,-11,-10,-10,-10,-9.86,-9.51,-9.22,-8.92,-8.63,-8.61,-8.79,-9.25,-11,-12,-13,-14,-15,-16,-19,-20,-20,-19,-16,-12,-9.01,-6.25,-4.13,-2.87,-2.39,-1.74,-0.61,0.57,1.72,2.46,2.90,3.47,5,3.75,3.75,5,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,5,3.75,2.50,3.75,3.75,3.75,3,2.59,1.02,-0.29,-1.65,-2.76,-2.98,-3,-3.04,-4.64,-6.85,-9.13,-10,-8.63,-7.15,-5.53,-3.80,-2.34,-2.25,-2.14,-1.92,-1.15,-1.93,-2.40,-2.04,-3.15,-3.73,-3.76,-3.75,-3.88,-4.54,-5.60,-9.75,-15,-19,-20,-20,-20,-20,-19,-18,-17,-17,-16,-18,-20,-20,-20,-20,-19,-17,-14,-11,-10,-9.13,-8.50,-8.12,-9,-11,-13,-14,-17,-19,-19,-18,-16,-15,-14,-12,-13,-13,-13,-13,-13,-12,-11,-11,-10,-10,-11,-11,-11,-11,-10,-9.98,-9.12,-8.75,-9.03,-9.49,-9.93,-10,-10,-10,-11,-11,-11,-10,-10,-9.97,-9.43,-9.10,-8.62,-7.99,-7.24,-6.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.45,6.09,1.39,1.07,-0.13,-0.75,-1,-1.25,-1.17,-0.88,-0.47,-0.10,0.46,0.46,0.30,-0.05,-0.25,-1.24,-3.04,-4.38,-5.54,-6.30,-6.66,-7.05,-7.50,-7.91,-8.38,-8.88,-9.67,-10,-12,-14,-15,-16,-16,-15,-14,-13,-12,-11,-10,-11,-12,-12,-11,-11,-11,-11,-10,-9.99,-9.76,-9.68,-9.79,-9.52,-8.92,-8.24,-7.26,-6.40,-5.75,-5.25,-4.98,-4.75,-4.52,-4.16,-3.66,-3.02,-2.29,-1.60,-1,-0.49,0.04,0.09,0.03,-1.14,-1.65,-2.13,-2.17,-2.37,-2.54,-2.76,-2.98,-3.10,-3.13,-3.11,-3.01,-2.88,-2.72,-2.50,-2.34,-2.25,-2.24,-2.22,-2.12,-1.90,-1.42,-0.87,-0.22,0.46,0.77,0.30,-0.84,-1.89,-3,-4.17,-5.59,-7.38,-9.66,-12,-14,-15,-13,-12,-11,-11,-11,-11,-11,-11,-11,-11,-12,-13,-13,-14,-14,-14,-14,-13,-13,-12,-11,-10,-10,-9.91,-9.65,-9.25,-8.89,-8.52,-8.59,-9.02,-10,-11,-12,-13,-15,-16,-17,-18,-19,-20,-20,-16,-12,-9.89,-7.18,-4.91,-3,-2.50,-2.04,-1.15,-0.03,1.35,2.20,2.90,3.27,3.85,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,2.50,3.75,3.75,2.50,2.93,2.34,2.22,0.14,-1.25,-2.60,-2.86,-3,-3,-3.47,-4.43,-5.18,-6,-5.38,-4.27,-3.13,-1.89,-0.55,-0.50,-0.75,-0.80,-0.43,0.28,0.57,-1.24,-1.91,-2.52,-3.15,-3.05,-3.05,-3.18,-4.98,-9.05,-14,-19,-20,-20,-20,-19,-20,-18,-17,-16,-16,-18,-20,-20,-20,-20,-20,-18,-14,-11,-10,-9.79,-8.97,-8.48,-9.05,-10,-12,-14,-16,-17,-18,-17,-16,-14,-13,-13,-13,-13,-13,-13,-12,-12,-11,-10,-10,-11,-11,-12,-12,-11,-11,-10,-9.93,-9.30,-9.22,-9.43,-9.91,-10,-10,-10,-11,-11,-10,-10,-10,-10,-9.53,-9.03,-8.55,-7.93,-7.18,-6.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,7.50,8.75,7.50,7.50,8.75,11.25,10,6.25,1.82,1.55,0.46,-0.13,-0.25,0,1.23,2.47,3.05,3.27,3.75,3.37,2.63,1.84,0.77,-0.38,-1.88,-3.13,-4.02,-4.47,-5.03,-5.63,-6.22,-6.80,-7.49,-8.34,-9.48,-10,-13,-14,-15,-16,-15,-14,-13,-12,-11,-10,-10,-12,-12,-12,-11,-11,-10,-9.10,-7.50,-7.26,-8.55,-8.67,-8.38,-7.72,-6.86,-5.88,-4.98,-4.26,-3.78,-3.50,-3.30,-3.13,-2.77,-2.27,-1.51,-0.75,0.14,1.02,1.35,1.97,1.97,1.10,0.27,-0.29,-0.65,-0.88,-1.05,-1.43,-1.66,-1.88,-1.88,-1.89,-1.90,-1.86,-1.72,-1.48,-1.16,-0.90,-0.78,-1,-1,-1,-1,-0.88,0.90,1.25,1.68,3.40,1.70,0.29,-0.90,-2.04,-3.22,-4.50,-6.13,-8.30,-10,-13,-15,-13,-12,-11,-12,-12,-12,-11,-11,-12,-12,-13,-14,-14,-15,-15,-15,-14,-14,-13,-12,-12,-11,-10,-10,-9.67,-9.29,-8.76,-8.40,-8.38,-9.72,-10,-11,-11,-12,-14,-16,-15,-17,-19,-20,-20,-17,-14,-11,-8.38,-5.79,-3.62,-2.63,-2.17,-1.37,-0.43,0.62,1.57,2.30,2.64,2.85,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.59,3.53,3.59,2.18,2.61,2.27,0.61,-0.79,-2.50,-2.77,-2.80,-2.89,-2.88,-2.92,-3.30,-3.14,-2.43,-1.35,-1,-0.88,-0.53,-0.50,-0.42,-0.41,0.01,1.25,1.25,0.92,-0.49,-1.14,-1.35,-2.93,-3.04,-3.03,-4.27,-8.54,-14,-17,-20,-20,-19,-19,-18,-17,-16,-15,-15,-17,-19,-20,-20,-20,-19,-17,-13,-11,-10,-10,-9.38,-8.48,-8.88,-9.77,-11,-14,-16,-17,-18,-17,-15,-14,-13,-13,-13,-13,-13,-12,-12,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-11,-10,-10,-9.76,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.50,-8.87,-8.38,-7.84,-7.15,-6.60,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.48,7.48,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.48,7.48,6.25,6.25,6.25,7.50,8.75,7.50,8.75,10,12.50,12.50,8.75,6.25,3.75,1.25,1.25,1.25,1.25,1.25,7.50,8.75,8.75,8.75,7.50,6.25,4.37,2.50,1.71,0.62,-0.47,-1.23,-2.30,-3,-3.68,-4.39,-5.12,-5.84,-6.68,-7.75,-9.13,-10,-12,-14,-15,-15,-14,-13,-12,-11,-9.98,-10,-11,-11,-11,-11,-12,-10,-8.18,-6.63,-7.39,-7.92,-7.91,-7.41,-6.60,-5.51,-4.38,-3.29,-2.52,-2.13,-2.02,-2,-2,-2,-1.63,-1.13,-0.25,0.46,1.39,1.85,2.18,2.27,2.15,1.64,1.23,0.93,0.62,0.27,-0.25,-0.67,-0.68,-0.64,-0.64,-0.68,-0.76,-0.52,-0.25,0.29,0.88,1.25,1.55,1.25,1.25,1.25,1.25,1.25,3.75,3.75,5,3.43,1.46,-0.11,-1.14,-2.28,-3.54,-5.12,-7.05,-9.40,-11,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-13,-14,-14,-15,-15,-15,-15,-15,-15,-14,-13,-12,-11,-11,-10,-9.72,-9.22,-8.67,-8.16,-8.14,-9.60,-10,-10,-11,-12,-13,-14,-14,-16,-19,-20,-20,-19,-16,-12,-9.29,-6.50,-4.25,-2.91,-2.30,-1.63,-0.89,-0.26,0.48,0.93,2.30,3,3.87,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.53,2.60,2.53,2.50,2.50,2.50,2.80,3.12,3.37,3.12,2.80,2.22,1.50,0.46,-0.63,-1.38,-1.91,-2.37,-2.39,-2.38,-2.26,-2.02,-1.88,-1.43,-1.04,-0.79,-0.54,-0.38,-0.25,-0.17,-0.36,-0.01,1.42,1.39,1.52,1.55,-0.28,-1.17,-2.51,-3.01,-3.01,-3.66,-6.76,-11,-14,-17,-17,-16,-16,-16,-15,-15,-13,-12,-15,-18,-19,-19,-19,-18,-15,-11,-10,-10,-10,-9.48,-8.41,-8.26,-9.03,-10,-13,-16,-17,-17,-16,-15,-14,-13,-13,-13,-13,-13,-12,-11,-11,-11,-12,-12,-12,-12,-13,-13,-12,-12,-12,-11,-10,-10,-10,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-9.60,-8.98,-8.47,-7.88,-7.17,-6.64,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.46,7.46,7.46,7.46,7.46,7.46,7.46,7.46,7.46,7.47,6.25,6.25,6.25,6.25,7.50,8.75,8.75,11.25,13.75,13.75,11.25,10,7.50,6.25,3.75,3.75,3.75,6.25,10,13.75,12.50,12.50,11.25,8.75,6.25,6.25,5,1.25,1.39,0.57,-0.47,-1.14,-1.88,-2.63,-3.38,-4.11,-4.97,-5.91,-7.02,-8.39,-10,-12,-14,-14,-14,-13,-12,-11,-10,-11,-10,-10,-10,-12,-13,-11,-9.39,-6.87,-7.98,-7.98,-7.52,-6.75,-5.65,-4.34,-2.92,-1.67,-0.87,-1,-1,-1,-0.89,-0.88,-0.88,-0.88,-0.88,1.09,1.25,2.50,2.50,2.50,2.50,2.48,2.59,2.50,2.18,1.96,1.39,1.25,1.09,1.25,1.35,1.35,1.25,1.25,1.53,2.12,2.80,3.75,4.37,4.98,3.75,5,5,5,5,5,5,4.82,2.50,0.80,-0.24,-1.36,-2.74,-4.30,-6.17,-8.25,-10,-11,-12,-13,-12,-11,-12,-12,-12,-12,-12,-13,-14,-15,-15,-15,-16,-16,-16,-15,-15,-14,-13,-12,-11,-10,-9.75,-8.98,-8.43,-7.85,-7.90,-9.03,-10,-11,-11,-11,-13,-16,-17,-16,-18,-20,-20,-18,-16,-14,-10,-7.63,-5.36,-3.60,-2.42,-2.02,-1.52,-1.38,-0.54,0.46,2.18,2.95,3.86,3.75,3.75,3.75,3.75,2.50,2.51,2.64,2.70,2.75,2.70,3.89,2.80,2.64,2.80,2.96,3.14,3.01,2.67,1.88,1.13,0.32,-0.40,-0.91,-1.35,-1.67,-1.66,-1.53,-1.38,-1.25,-1.02,-0.88,-0.65,-0.42,-0.14,0.25,0.14,-0.49,-0.88,-0.74,-0.13,-0.15,-0.25,-0.17,-0.92,-1.63,-2.78,-3,-3,-3.25,-5.37,-8.13,-11,-12,-13,-14,-15,-15,-14,-13,-11,-11,-14,-17,-17,-17,-17,-15,-13,-11,-10,-10,-9.98,-9.25,-8.22,-7.63,-8.23,-9.99,-12,-14,-15,-15,-14,-14,-13,-13,-12,-13,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-12,-11,-11,-11,-11,-11,-11,-11,-10,-11,-11,-10,-10,-10,-10,-9.92,-9.30,-8.75,-8.14,-7.39,-6.84,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.26,6.28,6.28,6.28,6.28,6.28,6.28,6.28,6.28,6.28,6.26,6.26,6.26,6.25,6.25,7.48,8.73,10,11.25,12.50,15,15,13.75,12.50,10,7.50,6.25,5,6.25,11.25,13.75,16.25,15,13.75,10,7.50,6.25,5,5,3.12,2.02,1.27,0.47,-0.26,-0.99,-1.72,-2.42,-3.25,-4.17,-5.13,-5.87,-8.38,-11,-13,-14,-13,-13,-12,-11,-10,-11,-11,-10,-10,-12,-14,-13,-11,-9.55,-8.84,-8.26,-7.43,-6.36,-4.99,-3.39,-1.74,-0.38,0.62,1.25,1.25,1.25,1.18,1.09,1.09,1.09,1.09,1.25,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,2.61,3.52,3.73,4.04,3.89,3.75,3.75,3.75,3.75,5,5,6.25,8.75,6.25,7.50,7.50,7.50,7.50,6.25,6.25,6.20,3.61,2.29,1.04,-0.39,-1.89,-3.50,-5.26,-7.17,-9.02,-10,-11,-12,-11,-11,-12,-13,-13,-13,-13,-14,-15,-15,-16,-16,-16,-16,-16,-15,-15,-14,-13,-12,-11,-10,-9.77,-8.74,-8.10,-7.63,-8.50,-9.73,-12,-13,-12,-12,-16,-17,-19,-17,-18,-19,-18,-17,-16,-14,-12,-8.42,-6.01,-4.42,-3.13,-2.36,-2.04,-1.65,-1.52,0.20,1.60,2.67,3.14,3.27,3.75,3.75,3.75,3.75,2.64,2.76,2.80,2.98,3.12,2.93,2.64,2.50,2.76,2.75,2.85,2.79,2.36,1.55,0.79,0.15,-0.28,-0.62,-0.53,-1.13,-1,-0.75,-0.50,-0.18,-0.14,-0.17,-0.25,-0.13,0.27,0.77,0.46,-0.12,-0.75,-0.75,-1.68,-2.16,-2.38,-1.80,-1.63,-2.25,-2.80,-3,-3.13,-4.18,-5.25,-6.65,-7.36,-9.14,-12,-13,-13,-14,-14,-13,-11,-11,-13,-15,-16,-16,-15,-13,-12,-10,-10,-9.97,-9.51,-9.09,-8.53,-7.90,-7.72,-8.98,-10,-12,-13,-14,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.50,-8.88,-8.27,-7.60,-7.05,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.34,7.43,6.28,6.28,6.26,6.26,7.50,8.75,10,12.50,15,16.25,16.25,17.50,15,11.25,7.50,6.25,6.25,8.75,15,17.50,16.25,13.75,10,7.50,6.25,5,5,5,3.75,2.80,2.18,1.51,0.72,-0.13,-0.87,-1.84,-2.68,-3.60,-4.50,-7.24,-9.74,-11,-12,-13,-12,-12,-11,-11,-11,-11,-10,-12,-14,-15,-14,-12,-10,-9.72,-8.62,-7.50,-6.13,-4.53,-2.87,-1.17,0.34,2.34,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,5,5,6.25,5,5,5,6.25,7.50,7.50,6.25,5,5,6.25,6.25,7.50,10,10,11.25,7.50,6.25,8.75,7.50,7.50,7.50,7.50,5.92,4.22,2.64,0.63,-1.15,-2.92,-4.73,-6.52,-8.22,-9.52,-10,-10,-10,-11,-12,-13,-13,-13,-13,-14,-15,-16,-16,-16,-16,-16,-16,-15,-15,-14,-13,-12,-11,-10,-9.92,-8.84,-8,-8.47,-10,-13,-14,-15,-15,-17,-18,-16,-15,-18,-17,-16,-16,-17,-15,-14,-11,-8.53,-6.75,-5.25,-4,-2.85,-2.16,-1.85,-1.48,0.25,1.42,2.45,2.85,3.37,3.86,3.89,4.05,4,4.23,3.27,3.43,3.59,2.43,2.22,2.27,2.38,2.63,2.48,2.43,2.47,1.87,1.22,0.60,0.13,-0.18,-0.25,-0.50,-0.63,-0.43,-0.25,0.14,0.62,0.93,0.88,-0.04,-0.91,1.25,1.25,1.25,-1,1.25,-0.77,-1,-1.38,-1.52,-1.13,-1.50,-1.92,-2.75,-3,-3.75,-5.42,-6.17,-6.28,-6.88,-8.13,-9.89,-11,-12,-13,-13,-13,-12,-12,-13,-15,-15,-15,-14,-12,-11,-9.80,-9.38,-9.39,-9.41,-9.36,-9.16,-8.68,-8.35,-8.43,-9.55,-10,-11,-12,-11,-11,-11,-11,-12,-12,-12,-12,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-9.50,-8.88,-8.25,-7.72,-7.17,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.35,7.38,7.38,6.34,6.28,6.28,6.26,7.51,9.97,11.25,13.75,15,18.75,20,16.25,13.75,11.25,7.50,6.25,8.75,16.25,21.25,18.75,15,10,7.50,6.25,5,5,5,5,3.75,3.75,2.92,2.13,1.25,0.40,-0.65,-1.50,-2.38,-3.63,-5.43,-8.30,-10,-11,-12,-12,-12,-11,-11,-11,-9.97,-10,-15,-17,-17,-16,-13,-11,-10,-8.89,-7.54,-6.01,-4.34,-2.60,-0.89,0.93,2.64,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,3.75,3.75,5,6.25,7.50,7.50,6.25,6.25,7.50,8.75,7.50,7.50,6.25,7.50,7.50,8.75,10,11.25,11.25,10,7.50,7.50,8.75,8.75,7.50,7.50,7.50,7.50,7.50,4.15,1.72,-0.65,-2.50,-4.28,-6.11,-7.76,-9.10,-9.79,-9.88,-9.23,-10,-11,-12,-13,-13,-14,-14,-15,-16,-16,-16,-16,-16,-16,-15,-14,-14,-13,-12,-11,-10,-10,-9.63,-9.36,-9.65,-12,-14,-16,-16,-16,-15,-16,-11,-12,-16,-17,-15,-15,-17,-16,-13,-10,-8.41,-7.39,-6.02,-4.63,-3.47,-2.38,-2,-1.61,-0.50,0.95,1.98,2.52,2.93,4.52,4.52,4.57,5,3.43,2.85,2.50,2.12,1.87,-0.13,1.40,1.80,1.89,2,2.02,1.88,1.25,0.77,0.30,0.01,-0.15,-0.26,-0.38,-0.25,-0.13,0.14,0.73,1.39,1.96,1.98,1.38,1.25,1.25,1.25,1.25,1.25,1.25,0.93,-0.63,-0.50,0.46,-0.41,-0.76,-1.50,-2.25,-3,-4.15,-5.89,-7.17,-7.76,-8,-8.75,-9.75,-11,-12,-13,-13,-13,-14,-14,-15,-16,-16,-15,-14,-12,-11,-9.84,-9.03,-9.38,-9.68,-9.79,-9.62,-9.24,-8.75,-8.88,-8.97,-9.29,-9.91,-10,-10,-10,-10,-11,-12,-12,-12,-12,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.37,-8.74,-8.13,-7.68,-7.15,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.36,7.37,7.37,7.37,6.34,6.25,6.28,7.43,8.76,11.22,12.50,15,17.50,18.75,18.75,17.50,13.75,11.25,7.50,10,16.25,23.75,20,16.25,10,8.75,6.25,6.25,6.25,6.25,6.25,5,5,3.89,3.07,2.18,1.25,0.46,-0.43,-1.29,-2.14,-3.64,-6.90,-9.24,-10,-11,-12,-12,-11,-11,-9.92,-9.74,-12,-16,-17,-18,-15,-12,-11,-10,-9,-7.59,-5.98,-4.24,-2.47,-0.73,1.25,3.70,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,3.75,3.75,3.75,3.75,3.75,3.75,5,6.25,8.75,8.75,7.50,7.50,7.50,7.50,8.75,10,10,10,8.75,8.75,10,11.25,11.25,10,8.75,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7,1.67,-0.50,-2.30,-4.09,-5.93,-7.75,-9.24,-10,-10,-9.25,-10,-11,-12,-12,-13,-14,-15,-15,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-12,-11,-11,-12,-11,-11,-12,-14,-16,-17,-17,-16,-15,-13,-10,-9.98,-12,-12,-12,-13,-14,-13,-13,-10,-9,-8.18,-6.91,-5.25,-3.89,-2.89,-2.27,-1.93,-1.50,0.10,1.34,1.68,1.86,2.34,2.30,2.65,3.11,2.34,1.73,1.27,0.82,0.20,-0.49,0.28,0.60,0.80,1.02,0.96,0.80,0.62,0.28,0,-0.13,-0.25,-0.24,-0.13,0.13,0.30,0.55,1.20,2.34,3.40,3.71,3.59,1.25,6.25,6.25,5,5,5,1.50,1.71,1.55,1.38,0.93,0.57,-1,-2,-2.90,-3.76,-6.41,-8.68,-10,-10,-9.99,-11,-12,-12,-13,-13,-15,-16,-16,-17,-17,-16,-15,-13,-11,-10,-9.63,-9.50,-9.52,-9.88,-9.97,-9.86,-9.79,-9.73,-9.43,-9.03,-9.10,-9.34,-9.18,-9.13,-9.55,-10,-12,-13,-13,-13,-12,-11,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-13,-13,-13,-13,-13,-13,-12,-11,-11,-11,-10,-10,-9.84,-9.14,-8.50,-8,-7.60,-7.09,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.38,7.36,7.48,7.36,6.35,6.25,6.34,6.34,7.53,11.21,11.25,12.50,14.98,16.25,17.50,18.75,16.25,12.50,10,10,16.25,22.50,21.25,16.25,11.25,8.75,7.50,6.25,6.25,6.25,7.50,6.25,5,5,3.75,2.50,2.50,1.25,1.25,-0.43,-1.38,-2.80,-5.52,-7.75,-9.41,-10,-11,-12,-13,-12,-11,-10,-11,-15,-16,-16,-15,-12,-11,-10,-9.13,-7.66,-6,-4.17,-2.25,-0.50,1.53,4.84,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,7.50,8.75,8.75,11.25,8.75,7.50,8.75,8.75,11.25,10,8.75,10,8.75,8.75,10,10,10,10,10,7.50,8.75,8.75,8.75,8.75,8.75,7.50,1.25,1.07,-0.65,-2.34,-4.10,-6.03,-8.03,-9.76,-10,-11,-10,-10,-11,-12,-12,-13,-14,-15,-15,-16,-16,-16,-16,-16,-15,-15,-14,-13,-12,-12,-12,-13,-14,-13,-13,-14,-17,-17,-18,-18,-17,-15,-12,-10,-9.85,-10,-10,-10,-11,-11,-11,-13,-12,-9.49,-10,-8.02,-5.65,-4.18,-3.13,-2.49,-2.16,-1.72,-0.13,0,0.26,0.01,-0.38,-0.11,0.27,0.61,0.62,0.27,-0.13,-0.50,-1,-0.88,-0.75,-0.40,-0.11,0.14,0.27,0.15,0,-0.13,-0.28,-0.39,-0.38,-0.15,0.14,0.46,0.87,1.09,1.39,3.59,6.25,6.25,5,5,6.25,7.50,7.50,7.50,6.25,4.84,4.52,3.12,2.59,3.09,0.77,-0.63,-1.75,-2.89,-3.65,-6.04,-9.40,-10,-11,-11,-12,-13,-12,-13,-13,-15,-16,-16,-18,-18,-17,-14,-12,-11,-10,-10,-10,-10,-9.78,-9.99,-10,-10,-10,-9.73,-8.84,-8.47,-8.53,-8.47,-7.92,-9.30,-11,-12,-13,-13,-13,-12,-11,-10,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-13,-13,-12,-12,-11,-10,-10,-9.65,-8.99,-8.47,-8.11,-7.66,-7.15,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.38,7.34,7.47,7.34,6.36,6.36,6.35,6.34,7.50,8.75,10.01,11.26,12.50,14.98,17.50,18.75,17.50,15,13.75,11.25,15,21.25,21.25,18.75,12.50,10,7.50,7.50,7.50,6.25,6.25,6.25,6.25,5,3.75,3.75,3.75,3.75,1.25,0.46,-0.76,-2.15,-4.26,-6.16,-7.92,-9.75,-11,-13,-14,-13,-12,-10,-10,-13,-14,-15,-13,-11,-11,-10,-9.17,-7.75,-6.04,-4.22,-2.25,0.47,1.39,3.59,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,5,5,5,6.25,7.50,10,10,12.50,10,8.75,10,8.75,8.75,7.50,8.75,8.75,10,8.75,8.75,11.25,12.50,11.25,8.75,10,10,10,10,8.75,8.75,1.25,-0.05,-0.93,-2.37,-4.12,-6.12,-8.25,-10,-11,-11,-11,-11,-11,-12,-13,-14,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-14,-13,-12,-12,-13,-14,-14,-14,-14,-15,-17,-17,-17,-17,-16,-14,-11,-10,-10,-11,-11,-10,-9.64,-8.76,-8.60,-9.84,-9.29,-9.15,-9.14,-7.50,-5.78,-4.30,-3.17,-2.49,-1.92,-1.75,-1.79,-0.61,-1.13,-1.76,-1.75,-1.28,-1.13,-0.88,-1.04,-1.41,-3.23,-5,-5.10,-4.25,-3.13,-1.38,-0.67,-0.38,-0.25,-0.14,-0.17,-0.30,-0.50,-0.64,-0.50,-0.13,0.30,0.90,1.25,1.80,1.37,5,6.25,7.50,6.25,6.25,6.25,6.25,6.25,6.25,5,5,3.43,3.27,3.23,3.22,1.37,-0.75,-1.16,-2.04,-3.25,-5.38,-8.26,-9.91,-11,-12,-13,-12,-12,-13,-14,-15,-15,-17,-18,-17,-16,-13,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.97,-9.34,-8.76,-8.25,-7.88,-7.79,-9.63,-11,-12,-13,-13,-13,-12,-11,-10,-10,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-12,-12,-11,-10,-9.50,-8.93,-8.73,-8.38,-7.99,-7.42,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.39,7.34,7.47,7.34,7.34,7.36,6.36,6.35,6.35,7.59,8.75,10.01,11.26,13.75,16.25,17.50,18.75,16.25,15,13.75,15,17.50,20,21.25,13.75,10,8.75,7.50,7.50,6.25,6.25,6.25,6.25,5,5,5,3.75,3.75,3.75,1.25,-0.18,-1.48,-3.13,-4.63,-6.23,-8.36,-11,-13,-15,-15,-13,-11,-10,-10,-11,-12,-10,-10,-10,-10,-9.42,-7.92,-6.17,-4.34,-2.38,-0.55,0.77,2.02,3.12,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,6.25,5,5,5,5,5,5,6.25,6.25,7.50,10,10,11.25,10,10,8.75,7.50,7.50,7.50,7.50,7.50,10,10,12.50,12.50,11.25,12.50,12.50,12.50,10,10,8.75,8.75,1.25,-0.54,-1.05,-2.38,-4.03,-6.03,-8.25,-10,-11,-12,-11,-11,-11,-12,-13,-14,-15,-15,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-12,-12,-13,-14,-15,-14,-14,-15,-15,-15,-15,-14,-13,-12,-11,-9.43,-11,-12,-12,-11,-9.28,-8,-7.38,-7.13,-6.92,-7.30,-7.90,-6.86,-5.73,-4.13,-3.02,-2.25,-1.67,-1.41,-1.24,-1.29,-2.11,-3.23,-4.23,-3.75,-5.50,-5.60,-5.43,-7.36,-6.92,-10,-10,-7.47,-6.13,-3.79,-1.13,-0.75,-0.50,-0.27,-0.14,-0.13,-0.50,-0.27,-0.25,-0.03,0.43,1.39,2.02,1.25,5,5,6.25,7.50,6.25,6.25,6.25,6.25,6.25,3.75,1.87,1.87,1.87,2.17,2.47,2.80,1.52,1.04,-0.80,-1.66,-2.38,-4.04,-6.50,-9.73,-11,-12,-13,-13,-13,-13,-13,-14,-16,-17,-16,-15,-14,-13,-11,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-10,-9.40,-9.13,-8.63,-8.18,-8.29,-9.50,-11,-12,-13,-13,-13,-12,-11,-10,-10,-11,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-15,-15,-15,-14,-13,-13,-12,-11,-10,-9.53,-9.13,-8.89,-8.59,-8.14,-7.63,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.39,7.34,7.34,7.47,7.47,7.34,6.38,6.36,6.35,6.35,7.59,8.78,11.21,12.50,13.75,17.50,18.75,17.50,16.25,15,16.25,21.25,23.75,23.75,17.50,12.50,10,8.75,7.50,7.50,6.25,6.25,6.25,6.25,5,5,5,5,3.75,2.12,0.46,-0.75,-2.12,-3.25,-4,-5.50,-10,-13,-14,-14,-13,-13,-12,-12,-12,-9.99,-10,-10,-11,-11,-9.75,-8.13,-6.34,-4.50,-2.76,-1.17,-0.13,1.39,2.64,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,6.25,7.50,6.25,5,5,6.25,7.50,8.75,10,11.25,11.25,10,8.75,7.50,6.25,6.25,7.50,8.75,10,11.25,13.75,15,13.75,11.25,12.50,11.25,11.25,11.25,8.75,7.50,1.25,1.25,-1,-2.38,-4.01,-5.91,-7.90,-9.62,-10,-11,-11,-11,-11,-12,-13,-14,-15,-15,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-12,-12,-13,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,-10,-11,-13,-12,-11,-8.76,-6.98,-5.88,-5.26,-5,-5.49,-5.74,-5.52,-4.88,-3.78,-2.77,-1.87,-0.99,-0.90,-1.13,-1.24,-2.53,-4.04,-5.75,-10,-8.24,-9.48,-9.02,-9.74,-8.18,-6.67,-5.42,-7.76,-9.15,-5.88,-3.13,-0.93,-0.55,-0.25,0.11,0.46,0.80,0.77,0.93,0.25,1.39,1.75,3.75,3.75,3.75,6.25,8.75,8.75,7.50,6.25,6.25,7.50,6.25,4.05,1.71,0.39,0.30,1.03,1.39,1.71,1.55,0.93,-0.78,-1.38,-1.75,-2.22,-5.02,-8.10,-10,-11,-11,-13,-13,-13,-13,-13,-15,-15,-14,-13,-13,-12,-12,-13,-14,-14,-13,-12,-12,-11,-10,-10,-10,-9.74,-9.52,-9.78,-9.87,-9.26,-8.87,-9.63,-10,-11,-11,-12,-12,-11,-11,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-14,-14,-15,-15,-15,-14,-14,-13,-12,-11,-10,-9.88,-9.38,-8.98,-8.63,-8.24,-7.67,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.38,6.39,7.34,7.34,7.48,7.34,7.34,6.38,6.36,6.36,6.35,7.59,9.93,11.26,13.75,16.25,18.75,18.75,17.50,17.50,21.25,23.75,26.25,27.50,20,13.75,10,8.75,8.75,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,5,3.75,3.12,1.25,-0.25,-1.16,-2.36,-2.99,-3.91,-6.68,-10,-12,-13,-13,-13,-14,-14,-14,-14,-14,-13,-13,-11,-10,-8.25,-6.38,-4.55,-2.93,-1.76,-0.51,0.93,2.50,3.75,3.75,5,5,5,5,5,5,5,5,5,5,6.25,7.50,6.25,5,5,6.25,7.50,8.75,10,10,10,10,8.75,7.50,7.50,6.25,7.50,8.75,11.25,12.50,15,16.25,15,11.25,10,11.25,12.50,13.75,12.46,10.57,5.14,1.70,-0.63,-2.25,-3.93,-5.75,-7.52,-9.04,-9.97,-10,-9.91,-10,-11,-13,-14,-15,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-14,-13,-12,-12,-12,-13,-12,-12,-11,-11,-10,-10,-9.91,-9.39,-8.89,-8.64,-9.11,-10,-11,-12,-12,-10,-7.73,-5.86,-4.49,-3.72,-3.40,-3.78,-4.25,-4.36,-4.09,-3.34,-2.50,-1.50,-0.17,0.11,-0.54,-1.39,-2.17,-3.13,-6.91,-10,-11,-6.35,-5.67,-4.88,-4.38,-3.87,-4.50,-5.98,-10,-6.53,-3.86,-2.13,-0.99,-0.13,0.46,1.25,2.18,3.43,2.32,2.34,2.50,3.27,3.75,5,3.75,6.25,7.50,8.75,7.50,7.50,7.50,7.50,7.50,4.37,1.67,0,-0.40,0,0.40,0.75,0.93,0.93,-0.79,-0.88,-1.14,-2.01,-3.88,-6.76,-9.63,-11,-13,-13,-13,-13,-13,-13,-12,-13,-13,-12,-12,-11,-12,-13,-14,-15,-14,-12,-11,-10,-10,-9.88,-9.47,-9.63,-10,-11,-11,-10,-9.48,-9.52,-10,-11,-11,-11,-11,-11,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-14,-15,-15,-15,-14,-13,-13,-12,-11,-11,-10,-9.54,-9.03,-8.62,-8.16,-7.63,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.39,6.39,7.34,7.48,7.48,7.34,7.34,6.38,6.36,6.35,7.37,8.84,11.18,13.71,15,18.73,20,20,21.25,23.75,26.25,26.25,26.25,21.25,17.50,12.50,10,8.75,8.75,7.50,6.25,6.25,6.25,6.25,7.50,7.50,6.25,5,3.75,1.25,1.25,-0.75,-1.78,-2.18,-2.85,-4.41,-7.18,-9.62,-11,-13,-14,-15,-16,-16,-17,-18,-20,-14,-12,-10,-8.18,-6.22,-4.40,-2.88,-1.43,-0.43,0.88,2.34,3.75,3.75,5,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,5,5,6.25,7.50,8.75,11.25,10,10,10,8.75,8.75,7.50,8.75,7.50,8.75,10,11.25,13.75,13.75,15,15,11.25,12.50,13.75,16.25,13.40,10.60,6.39,2.48,-0.63,-2.11,-3.76,-5.60,-7.34,-8.66,-9.41,-9.49,-8.37,-10,-12,-14,-16,-16,-17,-16,-16,-16,-16,-15,-15,-14,-15,-14,-14,-13,-12,-11,-11,-11,-11,-10,-9.88,-9.10,-8.63,-8.15,-7.75,-7.38,-7.16,-7.37,-8.25,-9.59,-11,-11,-10,-8.75,-6.53,-4.50,-2.85,-2.01,-1.88,-2.50,-3,-3.26,-3.25,-2.99,-2.26,-1.38,0.11,0.62,-0.13,-0.88,-1.66,-2.30,-4.53,-9.29,-6.41,-4.63,-1.27,-0.88,-0.88,-0.99,-2.01,-4.25,-9.49,-7.61,-3.27,-2.87,-1.49,-0.28,0.30,1.52,3.75,5,4.36,3.89,3.86,4.04,5,5,3.75,5,7.50,7.50,7.50,7.50,8.75,8.75,7.50,4.78,2.18,0.30,-0.50,-0.68,-0.63,-0.25,0.45,1.09,1.04,-0.52,-0.88,-2.62,-4.16,-6.36,-9.17,-12,-14,-14,-14,-13,-13,-12,-11,-10,-10,-11,-11,-11,-12,-13,-14,-14,-14,-13,-11,-11,-10,-9.62,-9.38,-10,-11,-12,-12,-12,-10,-9.80,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-13,-13,-12,-12,-11,-10,-9.75,-9.11,-8.43,-8,-7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.39,7.32,7.48,7.48,7.48,7.34,7.34,6.38,6.36,6.35,7.59,10,11.28,13.76,17.48,20,21.25,22.50,25,23.75,23.75,23.75,23.75,18.75,15,11.25,10,8.75,7.50,6.25,6.25,6.25,7.50,7.50,8.75,7.50,6.25,5,3.75,1.25,-0.25,-1.25,-1.75,-2.51,-3.73,-5.49,-7.77,-10,-12,-13,-15,-16,-17,-18,-19,-19,-15,-12,-10,-7.92,-5.80,-4,-2.51,-1.25,-0.27,0.93,2.34,3.75,5,5,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,6.25,6.25,6.25,5,6.25,6.25,8.75,10,10,10,10,10,8.75,8.75,8.75,8.75,10,10,11.25,12.50,13.75,15,15,15,13.75,16.25,16.25,14.21,11.09,6.71,2.50,-0.43,-1.88,-3.62,-5.36,-6.98,-8.25,-9.02,-9.37,-9.11,-11,-13,-15,-16,-17,-17,-17,-16,-16,-15,-15,-14,-14,-15,-14,-13,-12,-11,-11,-10,-10,-9.75,-8.84,-7.85,-6.87,-6.51,-6.13,-5.86,-5.75,-5.91,-6.48,-7.50,-8.99,-9.88,-10,-9.55,-7.47,-5.38,-3.15,-1.59,-0.63,-1,-1.38,-1.92,-2.29,-2.40,-2.38,-1.88,-1,-0.04,0.77,0.43,-0.39,-1.13,-1.76,-2.38,-3.74,-3.86,-1.35,-0.27,0.15,1.26,-0.63,-1.61,-3.87,-8.25,-10,-7.63,-3.90,-2,-0.66,-0.13,1.09,2.50,5,6.25,5,5,5,5,3.75,3.75,5,5,6.25,6.25,7.50,8.75,10,7.50,5.14,2.75,0.61,-0.54,-1.16,-1.38,-1.02,-0.43,1.09,-0.88,-0.25,-2.13,-4.13,-6.88,-8.37,-9.49,-12,-13,-14,-14,-13,-12,-10,-10,-10,-10,-10,-11,-12,-12,-13,-13,-14,-14,-13,-12,-12,-11,-11,-10,-10,-12,-14,-14,-14,-13,-11,-10,-9.98,-10,-9.86,-9.38,-9.63,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-13,-13,-12,-12,-11,-10,-9.92,-9.01,-8.35,-7.75,-7.23,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.42,7.32,7.48,7.50,7.48,7.48,7.34,7.34,6.38,6.36,7.50,8.84,11.18,11.26,15,18.73,20,21.25,21.25,21.25,20,22.50,23.75,22.50,18.75,13.75,11.25,8.75,7.50,7.50,6.25,7.50,7.50,8.75,8.75,8.75,7.50,6.25,5,1.25,0.62,-0.43,-1.13,-1.80,-2.74,-4.17,-6.35,-8.78,-10,-12,-14,-15,-16,-17,-17,-18,-15,-12,-9.89,-7.36,-5.13,-3.38,-2.01,-1,-0.03,1.21,2.45,3.75,5,6.25,7.50,7.50,7.50,7.50,7.50,6.25,5,5,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,8.75,10,10,10,10,10,10,10,10,10,10,11.25,11.25,12.50,13.75,13.75,13.75,15,16.25,16.25,15,11.65,7,2.64,-0.13,-1.61,-3.38,-5.13,-6.75,-8.05,-8.99,-9.67,-10,-12,-14,-15,-17,-17,-18,-17,-17,-15,-14,-14,-14,-14,-14,-14,-13,-12,-11,-10,-10,-9.39,-8.38,-7.17,-6.05,-4.97,-4.63,-4.34,-4.18,-4.36,-4.79,-5.61,-6.72,-7.89,-9.25,-9.28,-8.27,-6.50,-4.43,-2.38,-0.29,-0.05,0.62,-0.63,-1.16,-1.63,-1.88,-1.93,-1.66,-1,-0.13,0.77,0.87,0.39,-0.38,-1.02,-1.50,-1.28,-0.48,0.27,0.82,0.93,1.22,-0.51,-1.74,-3.66,-6.80,-11,-10,-4.80,-1,-0.90,-0.50,1.21,1.25,3.75,5,6.25,5,5,3.75,3.75,3.75,3.75,3.75,5,5,6.25,8.75,7.50,8.75,5.25,3.05,1.04,-0.50,-1.41,-1.88,-1.88,-1.38,-1.13,-0.91,-1.86,-4.04,-7.38,-10,-11,-11,-11,-13,-13,-12,-12,-11,-10,-9.68,-9.29,-10,-11,-11,-12,-12,-12,-13,-13,-14,-13,-13,-13,-13,-12,-12,-12,-13,-14,-15,-15,-15,-14,-11,-10,-9.63,-9.48,-9.35,-9.36,-9.88,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-12,-12,-12,-13,-14,-14,-14,-14,-14,-13,-13,-13,-12,-11,-10,-10,-9.11,-8.17,-7.37,-7,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.42,7.29,7.48,7.50,7.50,7.50,7.48,7.34,7.34,6.36,7.36,7.60,8.84,11.28,13.75,17.48,17.50,18.75,18.75,18.75,18.75,21.25,23.75,26.25,21.25,16.25,12.50,10,8.75,7.50,7.50,7.50,7.50,8.75,10,8.75,7.50,7.50,6.25,3.75,1.71,0.77,-0.38,-0.92,-1.76,-3.03,-4.89,-7.14,-9.02,-10,-12,-13,-14,-15,-16,-17,-15,-12,-9.18,-6.38,-4,-2.34,-1.25,-0.53,0.30,1.39,2.50,3.75,5,6.25,8.75,8.75,7.50,7.50,7.50,6.25,5,5,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,8.75,10,11.25,11.25,10,10,10,10,10,10,10,11.25,11.25,11.25,11.25,12.50,12.50,13.75,15,16.25,15,11.97,7.02,2.64,0,-1.36,-3.24,-5,-6.62,-7.97,-9,-10,-11,-12,-14,-16,-17,-17,-18,-17,-17,-15,-14,-13,-13,-14,-14,-13,-13,-11,-11,-10,-9.50,-8.49,-7.17,-5.85,-4.62,-3.42,-2.92,-2.63,-2.63,-3,-3.66,-4.64,-5.86,-7.14,-8.50,-8.72,-7.49,-5.75,-3.75,-1.89,-0.38,0.45,0.77,0.40,-0.27,-0.75,-1.14,-1.38,-1.28,-0.88,-0.02,1.09,1.71,1.39,0.76,0,-0.25,-0.18,0.60,1.36,2.03,1.43,-0.18,-0.52,-2.55,-5,-5.97,-10,-11,-4.52,-0.75,-0.43,-1,-1,1.25,1.25,5,5,5,5,5,1.25,1.84,2.79,2.92,3.12,3.75,4.84,7.43,6.25,6.25,4.79,2.96,1.09,-0.42,-1.51,-2.15,-2.38,-2.27,-2.05,-2.01,-3.04,-6.03,-10,-13,-13,-13,-12,-12,-12,-11,-10,-10,-10,-9.48,-9.51,-10,-10,-11,-11,-11,-11,-12,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-15,-16,-16,-16,-14,-12,-10,-9.87,-9.85,-9.63,-9.30,-9.50,-9.79,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-14,-14,-14,-14,-14,-13,-13,-13,-12,-11,-11,-10,-9.09,-8.25,-7.38,-6.79,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.43,7.29,7.48,7.50,7.50,7.50,7.63,7.64,7.63,7.50,7.36,7.60,8.84,10.03,12.51,13.75,16.23,17.50,17.50,17.50,17.50,18.75,23.75,27.50,23.75,20,15,12.50,10,8.75,7.50,7.50,7.50,8.75,10,10,10,7.50,6.25,6.25,5,1.25,0.76,-0.04,-0.67,-1.72,-3.18,-5.05,-6.63,-8.13,-9.25,-10,-11,-12,-13,-14,-14,-11,-8.16,-4.91,-2.52,-1.11,-0.50,-0.01,0.71,1.52,2.50,3.75,5,6.25,7.50,8.75,7.50,7.50,7.50,6.25,6.25,5,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,8.75,10,12.50,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,11.25,11.25,12.50,15,16.25,15.14,12.34,7.64,3.57,0.46,-1.35,-3.24,-4.99,-6.53,-7.88,-9.01,-10,-11,-13,-15,-16,-17,-18,-18,-17,-17,-15,-13,-12,-12,-12,-13,-12,-12,-11,-10,-9.87,-8.80,-7.60,-6.12,-4.65,-3.29,-2.13,-1.23,-0.79,-0.88,-1.50,-2.36,-3.60,-5,-6.36,-7.38,-7.98,-7.25,-5.09,-3.34,-1.47,-0.50,0.77,2.18,1.23,0.77,0.14,-0.38,-0.66,-0.78,-0.50,0.14,1.55,2.96,3.59,2.13,2.02,1.71,1.55,2,2.34,2.51,1.98,1.10,-0.62,-1.75,-3.42,-3.85,-3.60,-6,-1.50,0.46,1.21,1.25,1.25,1.25,1.25,3.75,6.25,6.25,5,4.84,2.02,1.36,1.39,1.52,1.71,2.18,3.07,3.75,4.97,3.75,3.70,2.64,1.04,-0.39,-1.51,-2.25,-2.68,-2.88,-3,-3.25,-4.49,-8.09,-11,-14,-15,-13,-12,-11,-11,-10,-9.98,-9.78,-9.72,-9.87,-10,-10,-10,-10,-11,-11,-12,-11,-10,-11,-12,-14,-15,-16,-16,-16,-17,-16,-15,-15,-15,-15,-14,-12,-10,-10,-10,-9.88,-9.25,-9.25,-9.53,-9.79,-10,-10,-10,-11,-11,-12,-12,-13,-12,-12,-12,-12,-13,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-11,-11,-10,-9.35,-8.30,-7.43,-6.67,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.43,7.28,7.47,7.50,7.50,7.64,7.64,8.59,8.59,7.63,7.63,7.61,8.75,10.09,12.43,12.50,14.98,16.25,17.50,17.50,16.25,17.50,22.50,27.50,27.50,22.50,17.50,15,12.50,11.25,8.75,7.50,8.75,8.75,10,10,10,8.75,7.50,6.25,5,3.75,1.25,1.23,0.46,-0.37,-1.25,-2.76,-4,-5.05,-5.98,-6.73,-7.48,-8.42,-9.55,-10,-10,-9.16,-6.50,-3.50,-0.88,-0.13,0.30,0.62,1.09,1.38,2.50,3.75,5,6.25,7.50,8.75,7.50,7.50,7.50,7.50,6.25,6.25,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,10,11.25,12.50,12.50,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,11.25,12.50,15,16.25,15.57,12.32,8.07,3.68,0.30,-1.47,-3.35,-5.09,-6.63,-7.90,-9.03,-10,-11,-13,-15,-16,-17,-18,-18,-17,-16,-14,-13,-12,-11,-11,-11,-11,-10,-10,-9.75,-9.10,-7.99,-6.63,-5.03,-3.50,-2.13,-1.12,-0.41,-0.01,-0.25,-0.90,-1.80,-2.75,-4.34,-5.67,-6.76,-7.52,-7.14,-4.91,-3.24,-1.88,-0.75,0.59,1.85,1.96,1.71,1.25,0.62,0,-0.38,-0.28,0.62,1.39,3.75,5,4.84,4.21,3.85,3.38,3.27,3.25,3.14,3.43,1.21,-0.51,-1.68,-1.87,-2,-2,-1,1.25,1.25,3.75,2.50,1.25,1.25,1.25,5,5,5,4.84,3.43,1.96,0.62,0.28,0,0.26,0.43,0.90,1.55,1.25,2.50,2.48,2.12,1.09,-0.63,-1.38,-2.25,-2.77,-3.02,-3.39,-4.73,-5.91,-8.09,-10,-12,-14,-13,-12,-11,-10,-9.38,-9.30,-9.85,-9.98,-9.98,-10,-11,-11,-11,-12,-12,-12,-11,-10,-10,-12,-14,-16,-17,-16,-17,-16,-16,-15,-14,-14,-14,-12,-11,-10,-10,-10,-9.77,-9.16,-8.92,-9.22,-9.52,-9.79,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-11,-10,-9.49,-8.37,-7.34,-6.52,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.43,7.28,7.34,7.50,7.64,7.64,8.57,8.87,9.84,8.59,7.63,7.61,8.75,10.09,12.43,12.51,14.97,16.25,17.50,16.25,16.25,17.50,21.25,26.25,28.75,25,22.50,18.75,17.50,13.75,8.75,8.75,8.75,10,10,11.25,10,10,8.75,6.25,6.25,5,3.75,2.47,1.59,0.82,0.26,-0.54,-1.41,-2,-2.74,-3.37,-3.86,-3.55,-5.62,-6.55,-6.73,-5.90,-4.16,-1.91,0.93,1.22,1.39,1.25,1.25,2.50,2.50,2.50,3.75,5,6.25,7.50,7.50,7.50,7.50,7.50,7.50,6.25,5,6.25,6.25,7.50,7.50,7.50,6.25,6.25,10,12.50,13.75,12.50,12.50,12.50,11.25,11.25,11.25,10,10,10,10,10,10,10,10,11.25,12.50,15,17.50,17.46,13.23,8.43,3.59,-0.05,-1.74,-3.49,-5.22,-6.74,-7.98,-9,-10,-11,-13,-14,-16,-17,-17,-17,-16,-15,-13,-12,-12,-11,-10,-10,-10,-9.55,-9.14,-8.86,-8.13,-7.05,-5.59,-3.89,-2.11,-0.80,0,0.59,0.77,0.46,-0.67,-1.29,-2.25,-3.77,-5.10,-6.24,-6.84,-6.98,-4.75,-3.13,-2,-0.88,0.46,1.87,2.45,2.29,2.18,1.71,0.62,0,-0.25,1.35,3.59,4.93,6.25,5,6.18,4.84,4.84,4.84,3.71,3.60,3.59,1.57,-0.77,-0.87,-0.99,-1,-1,-1,1.25,3.75,5,5,2.50,2.50,3.75,3.75,5,5,4.77,3.38,1.51,0,-0.63,-0.90,-0.88,-0.77,-0.52,-0.16,1.20,1.25,1.03,0.92,0.77,0.77,-1.13,-2.04,-3.13,-4.24,-5.51,-6.74,-7.75,-9.03,-10,-12,-12,-12,-11,-11,-10,-9.27,-9.50,-10,-10,-9.63,-9.77,-11,-11,-12,-13,-13,-13,-12,-10,-10,-11,-14,-16,-16,-16,-16,-15,-14,-14,-13,-12,-12,-11,-10,-10,-10,-10,-9.63,-8.76,-8.63,-8.68,-9.10,-9.50,-9.89,-10,-10,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-11,-10,-9.39,-8.34,-7.37,-6.60,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.39,6.43,7.28,7.48,7.67,8.54,8.59,8.89,9.84,8.88,8.59,7.61,8.62,9.88,11.28,13.71,14.98,16.23,16.25,16.25,16.25,17.50,20,23.75,27.50,26.25,25,21.25,17.50,15,11.25,8.75,8.75,10,11.25,11.25,10,10,8.75,7.50,6.25,6.25,5,3.75,2.50,1.25,1.25,1.25,1.25,1.25,1.25,-1,-1.13,-0.88,-1.93,-3.04,-3.26,-2.80,-1.78,-0.11,1.37,2.32,2.34,2.50,2.50,2.50,2.50,2.50,3.75,5,6.25,7.50,7.50,7.50,7.50,7.50,6.25,6.25,5,6.25,7.50,8.75,8.75,8.75,6.25,6.25,10,16.25,15,13.75,12.50,12.50,11.25,11.25,11.25,10,10,10,10,10,10,10,10,11.25,12.50,15,16.25,17.50,14.84,8.89,4.03,0.30,-1.74,-3.52,-5.27,-6.86,-8.02,-8.88,-9.73,-10,-12,-13,-15,-16,-16,-16,-15,-14,-13,-13,-13,-11,-10,-9.63,-8.73,-7.89,-8.25,-7.93,-7.13,-5.98,-4.40,-2.67,-1.05,0.14,1.04,1.55,2.18,1.39,0.88,-0.89,-2,-3,-4.52,-5.75,-6.54,-6.85,-4.97,-3.35,-2.16,-1.13,0.28,1.52,2.02,2.46,3.43,3.52,1.09,-0.89,1.09,1.36,3.68,6.25,5,5,5,5,5,3.75,3.75,3.75,3.75,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,3.75,5,5,5,6.25,3.75,3.75,5,3.75,3.73,3.27,0.93,-0.38,-1.25,-1.63,-1.77,-1.88,-1.77,-1.38,-1.23,-0.97,-0.87,-0.85,-1.04,-1.63,-2,-3.65,-5.38,-6.40,-7.28,-8.36,-9,-10,-12,-12,-13,-12,-12,-11,-10,-10,-10,-10,-10,-10,-10,-10,-11,-12,-13,-13,-13,-12,-10,-10,-11,-13,-14,-15,-15,-14,-14,-15,-15,-14,-12,-11,-10,-9.99,-9.91,-9.99,-9.75,-9.23,-8.87,-8.59,-8.26,-8.53,-9.01,-9.34,-9.72,-10,-10,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-14,-13,-13,-13,-12,-12,-11,-11,-10,-9.41,-8.49,-7.47,-6.59,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.45,7.28,7.34,7.67,8.54,8.73,8.88,8.89,8.88,8.59,7.63,7.61,8.85,11.25,13.71,16.22,16.23,16.25,16.25,18.75,17.50,18.75,22.50,25,27.50,27.50,23.75,18.75,16.25,16.25,11.25,10,11.25,11.25,11.25,11.25,11.25,11.25,8.75,7.50,6.25,5,3.75,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,0.93,0.46,-0.04,-0.38,-0.18,0.46,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,5,6.25,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,7.50,10,10,8.75,7.50,7.50,8.75,13.75,16.25,15,13.75,12.50,12.50,11.25,11.25,10,10,10,10,10,10,10,10,11.25,12.50,13.75,16.25,16.25,14.35,8.89,3.89,0.26,-1.75,-3.49,-5.13,-6.59,-7.72,-8.60,-9.38,-10,-11,-12,-14,-14,-15,-14,-14,-14,-14,-14,-14,-12,-10,-9.12,-7.72,-7.38,-7.54,-7.16,-6.25,-4.98,-3.43,-1.84,-0.43,0.89,2.18,2.59,3.43,2.28,0.77,-0.53,-1.67,-2.39,-3.92,-5.09,-6.03,-6.09,-5.41,-3.47,-2.25,-1.38,-0.38,0.42,1.09,1.85,3.37,3.43,1.25,-1,1.25,1.25,3.75,6.25,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,1.25,1.25,2.50,2.50,3.75,3.75,3.75,5,6.25,6.25,7.50,6.25,5,3.75,3.75,5,2.77,1.64,0.30,-0.88,-1.67,-2.25,-2.43,-2.77,-3.38,-3.35,-3.02,-2.77,-2.62,-2.50,-2.77,-3.40,-4.66,-6.89,-7.54,-8.37,-8.72,-9.38,-10,-11,-13,-13,-14,-13,-13,-11,-10,-10,-10,-10,-10,-10,-10,-10,-11,-12,-12,-12,-11,-11,-11,-11,-11,-12,-13,-13,-12,-13,-16,-17,-17,-16,-14,-11,-9.79,-9.61,-9.34,-9.34,-9.05,-9,-8.84,-8.59,-8.38,-8.47,-8.65,-8.89,-9.01,-9.39,-10,-10,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-14,-13,-13,-13,-12,-12,-12,-11,-11,-10,-9.38,-8.49,-7.50,-6.63,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.39,6.43,7.28,7.68,8.54,8.59,8.73,8.75,8.73,8.59,7.63,7.61,8.85,11.13,12.53,14.96,15,16.25,16.25,18.75,18.75,18.75,21.25,23.75,28.75,30,25,21.25,22.50,18.75,17.50,13.75,11.25,12.50,12.50,12.50,12.50,12.50,11.25,8.75,6.25,6.25,5,3.75,2.50,2.50,2.50,3.75,3.75,2.50,2.50,3.75,2.64,1.71,0.04,-0.47,0,0.77,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,6.25,7.50,7.50,8.75,7.50,7.50,7.50,6.25,6.25,7.50,7.50,8.75,10,10,7.50,7.50,7.50,13.75,16.25,17.50,16.25,13.75,12.50,11.25,11.25,10,10,10,10,10,10,10,11.25,11.25,12.50,13.75,17.50,17.50,12.96,8.52,3.75,0.14,-1.78,-3.39,-5,-6.40,-7.50,-8.37,-9.02,-9.68,-10,-11,-12,-13,-13,-13,-14,-14,-15,-15,-14,-13,-11,-9.52,-8.27,-7.59,-7.02,-6.38,-5.38,-4.09,-2.66,-1.40,-0.38,1.03,2.32,3.57,3.55,2.80,1.25,-0.13,-1.25,-2.13,-2.66,-4.60,-5.72,-6.02,-5.84,-4.02,-3.17,-2.14,-1.13,-0.53,0,0.77,1.65,2.18,1.25,-1,-1,1.25,2.50,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,3.75,3.75,3.75,5,6.25,7.50,6.25,7.50,7.50,5,3.75,3.75,3.43,2.51,1.71,0.59,-0.50,-1.38,-2.25,-3.13,-4.27,-5,-5.03,-5.02,-4.86,-4.60,-4.28,-4.17,-4.40,-5.15,-6.63,-8.54,-9.30,-9.55,-9.84,-10,-11,-12,-13,-15,-15,-14,-14,-12,-11,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-12,-13,-13,-13,-13,-12,-14,-16,-18,-17,-16,-14,-11,-10,-9.16,-8.80,-8.88,-8.93,-8.88,-8.73,-8.49,-8.51,-8.64,-8.92,-8.90,-8.86,-8.72,-9.16,-9.97,-10,-11,-11,-11,-12,-12,-12,-13,-13,-14,-14,-14,-13,-13,-12,-12,-12,-11,-10,-10,-9.18,-8.37,-7.37,-6.55,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.45,7.28,7.63,7.67,8.54,8.72,8.73,8.73,8.59,7.63,7.61,8.85,11.13,11.28,13.71,13.75,16.25,16.25,17.50,20,20,20,22.50,27.50,28.75,28.75,26.25,25,22.50,20,18.75,13.75,13.75,13.75,15,15,13.75,12.50,10,7.50,6.25,5,3.75,3.75,2.50,3.75,3.77,4.15,4.11,4.01,3.61,2.76,1.43,0.22,-0.38,0.10,0.77,2.50,3.75,6.25,6.25,6.25,6.25,5,3.75,3.75,3.75,5,5,6.25,7.50,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,8.75,8.75,8.75,7.50,7.50,7.50,11.25,17.50,17.50,15,13.75,12.50,11.25,11.25,10,10,10,10,11.25,11.25,11.25,11.25,11.25,12.50,13.75,15,16.25,12.50,8.12,3.54,0.10,-1.59,-3.25,-4.87,-6.25,-7.39,-8.36,-9.01,-9.63,-9.76,-10,-11,-12,-12,-13,-14,-15,-15,-15,-14,-13,-11,-9.76,-8.42,-7.39,-6.51,-5.61,-4.48,-3.25,-2.04,-1,0.27,1.38,2.50,3.75,3.71,2.95,1.82,0.27,-1,-1.91,-2.63,-4.16,-5.11,-5.75,-5.75,-5.67,-4.52,-3.53,-2.61,-1.50,-0.88,-0.13,0.77,1.39,1.25,1.25,1.25,1.25,2.50,2.50,3.75,3.75,3.75,3.75,5,3.75,3.75,2.50,2.50,2.50,2.50,3.75,3.75,5,5,5,6.25,7.50,6.20,5.62,5,4.05,3.12,2.45,1.82,1.12,0.57,-0.60,-1.84,-3.11,-4.13,-5.11,-5.75,-6.27,-6.60,-6.75,-6.62,-6.30,-5.87,-5.55,-5.65,-6.28,-7.63,-9.24,-10,-10,-10,-10,-11,-12,-14,-15,-15,-14,-14,-13,-11,-10,-9.98,-10,-10,-10,-10,-10,-10,-11,-11,-10,-10,-11,-11,-13,-14,-14,-13,-11,-12,-13,-14,-16,-16,-15,-13,-10,-9.55,-8.52,-8.59,-8.73,-8.75,-8.67,-8.51,-8.42,-8.78,-9.38,-9.63,-9.60,-9.25,-8.79,-8.62,-8.90,-9.50,-10,-10,-11,-11,-11,-12,-13,-13,-14,-14,-13,-13,-12,-12,-12,-11,-11,-10,-9.76,-8.92,-8.09,-7.17,-6.41,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.45,7.28,7.50,7.67,8.54,8.59,8.73,8.73,8.59,8.59,8.61,8.85,9.88,10.03,11.26,12.50,13.75,15,16.25,20,22.50,21.25,22.50,26.25,27.50,28.75,28.75,27.50,23.75,20,20,16.25,13.75,15,15,15,13.75,13.75,11.25,8.75,7.50,6.25,5,3.75,3.89,4.15,4.73,5.09,5.27,5.21,4.39,2.98,1.21,-0.09,-0.28,-0.28,0.59,1.25,1.25,1.25,8.75,8.75,7.50,6.25,5,3.75,3.75,3.75,5,6.25,8.75,8.75,8.75,7.50,7.50,7.50,8.75,8.75,8.75,8.75,8.75,8.75,8.75,7.50,8.75,11.25,15,15,15,13.75,12.50,11.25,11.25,10,10,11.25,11.25,11.25,11.25,11.25,11.25,11.25,12.50,13.75,13.75,15,12.50,7.95,3.27,-0.13,-1.42,-3.03,-4.62,-6.11,-7.43,-8.63,-9.60,-10,-10,-11,-12,-13,-13,-14,-14,-15,-15,-15,-14,-12,-11,-9.79,-8.38,-7.11,-5.93,-4.79,-3.61,-2.16,-1.75,-0.63,0.62,2.50,2.50,3.75,3.75,2.93,2.02,0.42,-0.88,-1.88,-2.63,-3.88,-4.62,-5.40,-5.89,-6.36,-6.25,-5.75,-4.65,-3,-1.51,-0.63,0.43,1.39,2.02,2.46,1.25,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,3.75,3.75,3.75,5,5,5,5,5,6.25,5,4.84,4.21,3.54,2.64,1.87,1.09,0.39,-0.24,-0.88,-2.41,-3.53,-4.79,-5.88,-6.77,-7.14,-7.59,-8.02,-8.41,-8.37,-8.01,-7.28,-6.74,-6.50,-6.88,-7.75,-9.12,-10,-10,-10,-10,-10,-12,-13,-14,-14,-14,-13,-12,-10,-9.60,-9.49,-9.88,-10,-10,-10,-9.41,-9.50,-10,-10,-9.66,-10,-11,-12,-12,-13,-13,-11,-10,-10,-10,-11,-12,-13,-11,-10,-8.87,-7.92,-8.03,-8.26,-8.41,-8.43,-8.38,-8.34,-8.38,-9.25,-9.76,-10,-9.91,-9.62,-9.16,-8.90,-8.50,-8.88,-9.40,-9.90,-10,-10,-11,-12,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-10,-10,-9.25,-8.53,-7.68,-6.89,-6.15,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.45,7.28,7.34,7.63,7.67,8.57,8.59,8.72,8.72,8.72,8.73,8.85,8.84,10.03,11.25,12.47,12.50,13.75,15,18.75,22.50,21.25,20,22.50,26.25,28.75,28.75,27.50,23.75,22.50,20,18.75,16.25,16.25,16.25,15,15,15,12.50,10,8.75,8.75,6.25,4.93,4.35,5.11,5.64,6.07,6.27,6.15,6.43,2.84,0.59,-0.89,-1.62,-1.62,-1.13,-1,-1,1.25,8.75,8.75,8.75,6.25,5,5,3.75,3.75,5,6.25,7.50,10,8.75,8.75,8.75,8.75,8.75,8.75,10,8.75,10,11.25,8.75,7.50,8.75,10,11.25,12.50,15,13.75,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,12.50,12.50,13.75,13.75,12.77,7.77,2.96,0,-1.13,-2.78,-4.43,-6.03,-7.59,-9,-10,-11,-11,-12,-13,-14,-14,-15,-15,-15,-15,-14,-13,-12,-11,-9.63,-8.13,-6.68,-5.35,-4.09,-2.80,-1.50,-0.91,-0.15,1.07,2.50,2.50,3.75,3.75,2.64,1.39,0.14,-0.92,-1.88,-2.50,-2.88,-4,-4.72,-5.50,-6.43,-7.97,-10,-6.92,-4.23,-2.13,-0.75,0.46,1.71,2.63,3.11,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,5,5,6.25,5,3.75,3.75,3.75,3.75,3.75,3.89,3.27,2.34,1.37,0.46,-0.25,-0.75,-1.40,-2.99,-4.09,-5.27,-6.42,-7.42,-7.93,-8.16,-8.39,-8.99,-10,-10,-9.39,-9.02,-7.43,-6.87,-7.04,-7.40,-8.15,-8.84,-8.97,-9.02,-9.38,-9.80,-11,-12,-12,-12,-13,-12,-10,-9.41,-9.30,-9.16,-9.61,-10,-10,-9.65,-8.90,-8.79,-8.75,-8.55,-10,-12,-13,-13,-12,-11,-9.84,-9.49,-9.62,-8.97,-8.37,-9.13,-9.23,-8.01,-8.50,-8.30,-7.87,-8.43,-8.30,-7.97,-8,-8.04,-8.09,-8.13,-8.54,-9.39,-9.88,-10,-10,-9.67,-9.38,-8.99,-8.42,-8.60,-9.12,-9.61,-10,-10,-11,-11,-12,-13,-13,-13,-13,-12,-12,-11,-10,-10,-10,-9.37,-8.68,-8,-7.14,-6.52,-5.77,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.39,6.43,7.28,7.48,7.64,7.64,8.57,8.59,8.59,8.59,8.61,8.85,8.84,10.03,11.25,12.47,12.50,12.50,13.75,16.25,18.75,18.75,17.50,20,23.75,25,27.50,27.50,25,23.75,22.50,20,18.75,20,18.75,20,17.50,16.25,15,12.50,10,7.50,6.25,5.39,5.50,6.05,6.67,7.01,6.93,6.80,4.64,2.17,-0.40,-2.25,-3.64,-3.52,-2.89,-1.98,-0.80,1.25,6.25,7.50,7.50,7.50,6.25,5,5,5,5,5,7.50,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,10,11.25,8.75,7.50,7.50,8.75,10,11.25,13.75,15,13.75,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,12.50,12.50,13.75,12.50,11.86,7.96,2.64,0.77,-0.88,-2.54,-4.34,-6,-7.66,-9.27,-10,-12,-12,-13,-14,-14,-14,-15,-15,-14,-14,-13,-12,-12,-10,-9.18,-7.67,-6.17,-4.77,-3.51,-2.35,-0.88,-0.42,0.25,1.35,2.50,2.50,3.75,3.75,2.18,0.87,-0.25,-1.02,-1.76,-2.29,-2.64,-3.17,-3.98,-4.88,-6.13,-8.10,-13,-7.88,-4.68,-2.54,-0.89,0.62,2.02,2.77,2.77,2.50,2.50,2.50,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.59,2.76,1.64,0.47,-0.38,-1.14,-2.34,-3.75,-5.22,-5.42,-6.40,-7.50,-9.39,-8.75,-8.79,-8.89,-9.05,-10,-10,-10,-9.93,-8.38,-7.48,-7.74,-7.98,-8.09,-8.13,-8.11,-8.25,-8.49,-8.84,-9.13,-10,-11,-11,-11,-10,-9.13,-9.12,-9.01,-8.89,-9.38,-10,-10,-10,-9.29,-8.75,-8.30,-8.78,-10,-14,-15,-15,-14,-10,-8.38,-8.97,-9.98,-9.87,-9.54,-8.29,-7.16,-8.13,-9.13,-10,-10,-10,-10,-9.05,-7.74,-7.64,-7.79,-7.88,-8.38,-9.25,-9.73,-9.90,-9.80,-9.66,-9.39,-8.87,-8.23,-8.12,-8.64,-9.13,-9.62,-9.91,-10,-11,-11,-12,-12,-12,-12,-12,-11,-10,-10,-9.64,-9.14,-8.55,-8,-7.27,-6.66,-6.10,-5.43,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.43,7.28,7.34,7.50,7.64,7.64,8.59,8.59,7.63,8.61,8.85,9.88,10.03,12.46,11.25,11.25,11.25,12.50,13.75,15,15,16.25,16.25,18.75,23.75,23.75,25,25,25,22.50,21.25,20,21.25,22.50,21.25,21.25,20,17.50,13.75,10,7.50,7.50,5.52,6.09,7.17,7.79,7.97,7.46,5.93,3.64,0.93,-1.47,-3.64,-6.25,-6.11,-4.41,-2.92,-1.38,0.46,1.52,4.84,7.50,7.50,6.25,6.25,6.25,5,5,5,6.25,7.50,8.75,8.75,8.75,10,8.75,8.75,8.75,10,10,10,8.75,7.50,7.50,7.50,8.75,11.25,13.75,16.25,16.25,15,13.75,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,12.50,12.50,12.50,12.50,11.22,8.40,5.26,1.39,-0.66,-2.52,-4.25,-5.90,-7.59,-9.18,-10,-11,-13,-14,-14,-14,-14,-14,-14,-13,-13,-12,-11,-11,-10,-8.53,-7.04,-5.61,-4.25,-3.12,-2.11,-1.13,-0.26,0.59,1.71,2.50,2.50,3.75,3.75,1.87,0.25,-0.25,-0.90,-1.50,-1.77,-2,-2.37,-3.03,-3.98,-5.22,-6.92,-7.72,-6.78,-4.50,-2.66,-1.13,0.57,1.82,2.48,2.61,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,3.75,3.59,2.50,0.93,-0.25,-1.15,-2.72,-3.97,-4.88,-5.67,-6.25,-6.90,-7.78,-8.68,-9.09,-9.17,-9.18,-8.84,-9.89,-11,-11,-10,-9.16,-8.36,-8.60,-8.66,-8.64,-8.72,-8.63,-8.49,-8.25,-8.17,-8.28,-9.17,-9.98,-10,-10,-10,-10,-10,-9.25,-8.65,-8.63,-9.49,-10,-10,-10,-10,-8.86,-8.84,-12,-16,-19,-19,-16,-13,-11,-11,-12,-13,-12,-9.51,-8.29,-9.75,-11,-12,-12,-12,-11,-10,-8.79,-7.40,-7.48,-7.51,-8,-8.84,-9.28,-9.50,-9.50,-9.49,-9.16,-8.63,-7.79,-7.61,-8.01,-8.79,-9.38,-9.63,-9.85,-10,-11,-11,-11,-12,-11,-11,-10,-10,-9.49,-8.88,-8.38,-7.92,-7.38,-6.84,-6.38,-5.87,-5.22,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.39,6.43,7.29,7.47,7.50,7.63,7.64,7.64,7.63,8.61,8.85,9.88,11.18,11.21,11.22,11.25,11.25,11.25,12.50,12.50,13.75,13.75,15,16.25,20,21.25,22.50,23.75,26.25,23.75,21.25,20,21.25,22.50,22.50,21.25,20,18.75,16.25,11.25,8.75,6.25,6.51,7.17,8.34,9.14,9.23,8.09,5.52,2.70,-0.14,-2.39,-4.74,-7.51,-7.97,-5.66,-3.89,-2.18,-0.75,0.77,1.52,6.25,7.50,7.50,7.50,7.50,6.25,5,5,6.25,7.50,8.75,10,10,10,8.75,8.75,10,10,10,11.25,8.75,8.75,7.50,7.50,8.75,10,12.50,13.75,17.50,16.25,15,13.75,13.75,12.50,12.50,11.25,11.25,11.25,11.25,11.25,12.50,12.50,12.50,12.50,11.25,11.22,4.96,1.25,-1,-2.59,-4.14,-5.77,-7.47,-9.12,-10,-11,-13,-14,-15,-15,-14,-13,-13,-13,-13,-11,-11,-10,-9.13,-7.72,-6.25,-4.89,-3.72,-2.75,-1.97,-1.40,-0.38,0.76,1.87,2.50,2.50,2.50,3.75,1.50,0.62,-0.25,-0.88,-1.25,-1.27,-1.28,-1.50,-1.80,-2.79,-3.88,-4.92,-5.50,-5.23,-4.13,-2.73,-1.26,0.15,1.39,2.05,2.34,2.50,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.63,2.62,2.47,2.61,2.64,3.59,2.89,1.71,0.25,-0.89,-2.75,-4.25,-5.34,-5.89,-6.36,-6.60,-6.93,-7.60,-8.25,-8.88,-9.63,-9.73,-9.01,-10,-11,-11,-10,-8.99,-9.11,-9.30,-9.40,-9.39,-9.25,-9.10,-8.93,-8.73,-8.42,-8.10,-8.36,-8.90,-9.93,-11,-12,-12,-12,-10,-9.79,-8.48,-9.03,-10,-11,-12,-11,-10,-9.47,-12,-16,-20,-20,-18,-15,-14,-14,-13,-14,-13,-10,-9.38,-10,-10,-11,-13,-13,-12,-12,-10,-7.74,-7.02,-7.13,-7.24,-8.11,-8.60,-8.86,-9.03,-8.99,-8.68,-8.13,-7.27,-7.38,-8,-8.60,-9.22,-9.62,-9.78,-9.75,-10,-10,-11,-11,-10,-10,-9.67,-9.25,-8.63,-8.16,-7.80,-7.36,-6.89,-6.51,-6.05,-5.50,-4.88,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.43,7.29,7.34,7.48,7.50,7.50,7.64,7.63,8.61,8.85,9.88,10.03,10.01,10,10,10,11.25,11.25,11.25,12.50,13.75,13.75,15,17.50,20,20,22.50,23.75,27.50,21.25,20,20,21.25,22.50,22.50,20,18.75,15,11.25,8.75,6.25,6.77,8.05,9.46,10.71,11.62,8.68,5.22,1.85,-0.83,-3.01,-5.27,-7.75,-8.11,-6.53,-4.66,-2.99,-1.51,-0.63,1.55,7.50,8.75,8.75,8.75,8.75,7.50,6.25,6.25,6.25,7.50,8.75,11.25,10,10,10,10,10,10,10,10,10,8.75,7.50,8.75,8.75,10,11.25,12.50,13.75,16.25,16.25,15,13.75,13.75,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,11.25,11.25,8.75,1.25,1.25,-1,-2.13,-3.97,-5.61,-7.36,-9.12,-10,-12,-13,-14,-15,-15,-15,-13,-12,-12,-11,-10,-10,-9.50,-8.22,-6.75,-5.30,-4.01,-3.01,-2.27,-1.75,-1.25,-0.18,1.09,2.46,2.50,2.50,2.50,2.50,2.29,1.03,-0.04,-0.75,-1.13,-1,-0.76,-0.75,-0.88,-1.28,-2.27,-3.47,-4.48,-5.01,-4.03,-2.88,-1.61,-0.28,0.78,1.55,2.27,2.77,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.48,2.47,2.32,2.32,2.34,3.12,2.98,1.68,0.59,-0.63,-2.35,-4.05,-5.59,-6.42,-6.88,-6.99,-6.84,-6.75,-7.23,-8.52,-9.49,-9.55,-9.72,-9.23,-9.25,-10,-9.88,-9.36,-9.50,-9.72,-9.91,-10,-10,-9.88,-9.63,-9.36,-9.10,-8.79,-8.43,-8.11,-8.38,-10,-11,-12,-13,-13,-11,-10,-9.11,-8.89,-11,-13,-13,-12,-10,-10,-11,-15,-18,-19,-17,-14,-13,-14,-14,-14,-13,-9.73,-8,-9.30,-9.03,-9.75,-11,-11,-12,-11,-10,-8.63,-7.36,-7.72,-7.37,-7.24,-7.72,-8.15,-8.38,-8.28,-7.97,-7.38,-7,-7.52,-7.98,-8.15,-8.63,-9.16,-9.38,-9.38,-9.37,-10,-10,-10,-9.75,-9.50,-9.14,-8.64,-7.89,-7.50,-7.13,-6.80,-6.50,-6.13,-5.66,-5.13,-4.47,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.39,6.42,7.32,7.48,7.50,7.50,7.64,8.59,8.61,8.73,8.84,9.93,10,10,10,10,10,10,11.25,12.50,12.50,13.75,13.75,16.25,17.50,20,21.25,22.50,23.75,21.25,20,18.75,20,21.25,21.25,20,17.50,15.02,12.51,8.88,7.63,8.01,8.39,10.35,12.43,13.92,9.71,4.40,0.97,-1.26,-3.17,-5.59,-7.61,-8.38,-6.75,-5.17,-3.54,-2.13,-0.88,1.55,1.25,11.25,10,11.25,10,8.75,7.50,6.25,6.25,7.50,8.75,10,10,11.25,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,10,11.25,12.50,13.75,15,16.25,15,13.75,12.50,12.50,12.50,13.75,15,15,12.50,12.50,12.50,11.25,10,7.50,1.39,-0.88,-0.88,-2,-3.62,-5.29,-7.24,-9.12,-10,-12,-12,-13,-14,-14,-14,-13,-11,-10,-10,-11,-9.76,-8.64,-7.25,-5.64,-4.13,-3,-2.17,-1.75,-1.38,-0.66,0.89,1.38,2.50,2.50,2.50,2.50,2.50,2.18,1.39,0.30,-0.53,-0.88,-0.75,-0.43,-0.15,0,0.14,-1.28,-2.38,-3.59,-5.09,-4.23,-3.23,-1.98,-0.63,0.27,1.12,1.96,2.63,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.47,2.32,2.02,1.67,2.02,1.55,1.12,0.43,-0.51,-2.34,-3.91,-5.37,-6.63,-7.63,-7.62,-7.39,-7,-6.04,-6.43,-7.74,-8.84,-8.75,-8.78,-9.25,-9.05,-8.79,-9.38,-9.88,-10,-10,-10,-10,-10,-10,-10,-9.77,-9.38,-9.05,-8.73,-8.25,-8.52,-10,-12,-13,-13,-12,-11,-10,-10,-12,-14,-15,-15,-13,-12,-10,-11,-12,-14,-15,-14,-12,-10,-11,-12,-13,-11,-8.04,-6.47,-6.63,-7.16,-7.34,-7.27,-8.63,-9.97,-10,-9.75,-8.97,-8.84,-8.76,-8.52,-8.09,-7.47,-7.34,-7.36,-7.27,-6.91,-6.78,-6.97,-7.38,-7.76,-7.99,-8.24,-8.47,-8.62,-9.04,-9.15,-9.30,-9.50,-9.63,-9.77,-9.62,-8.92,-8.54,-8.13,-7.43,-6.90,-6.38,-6.04,-5.65,-5.16,-4.63,-3.98,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.42,7.32,7.48,7.50,7.50,7.63,7.63,7.61,8.62,8.73,8.76,9.97,11.23,11.25,10,10,10,11.25,12.50,13.75,13.75,13.75,15,16.25,20,21.25,20,21.25,21.25,18.75,17.50,18.75,18.75,20,20,16.34,15.13,13.92,12.29,10.20,9.07,9.32,11.05,12.87,14.01,11.59,2.20,-0.42,-1.25,-3,-4.78,-6.38,-7.17,-6.52,-5.26,-3.87,-2.55,-1.38,-0.78,8.75,10,11.25,11.25,11.25,10,10,7.50,7.50,7.50,8.75,10,10,10,10,10,10,11.25,11.25,10,10,8.75,8.75,8.75,8.75,8.75,10,11.25,12.50,13.75,15,16.25,15,13.75,12.50,12.50,13.75,15,16.25,17.50,12.50,11.25,10,10,10,6.25,1.53,0.88,-0.88,-1.91,-2.88,-4.91,-6.62,-8.16,-9.50,-10,-11,-12,-12,-12,-12,-11,-10,-10,-10,-10,-9.25,-8.04,-6.53,-4.63,-3.01,-1.84,-1.13,-0.67,-0.66,0.77,1.09,1.39,2.50,2.50,2.50,2.50,2.50,2.30,2.14,0.73,-0.13,-0.40,-0.26,0,0.39,0.77,0.62,-1,-1.63,-3.09,-4.90,-4.63,-3.78,-2.38,-0.80,-0.02,0.90,1.75,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.45,2.14,1.40,1.09,0.77,0.30,-0.38,-0.86,-2.29,-3.87,-5.65,-6.60,-7.80,-8.75,-8.49,-7.92,-7.15,-6.68,-6.76,-7.04,-7.65,-8.54,-9.01,-9.10,-8.89,-9.53,-10,-10,-10,-11,-11,-11,-10,-10,-10,-10,-9.67,-9.25,-8.89,-8.65,-8.80,-10,-12,-13,-12,-11,-11,-11,-13,-15,-15,-16,-15,-14,-13,-11,-9.88,-10,-11,-10,-10,-9.78,-8.25,-8.43,-9.53,-9.16,-8.36,-7.62,-6.52,-6.55,-6.99,-6.60,-6.13,-6.99,-8.03,-8.25,-8.22,-8.49,-8.92,-9.11,-9.75,-9.37,-8.40,-8.05,-7.24,-6.63,-6.51,-6.40,-6.63,-7,-7.28,-7.62,-7.79,-8.02,-8.25,-8.63,-8.68,-8.73,-8.89,-9.54,-9.79,-9.54,-9,-8.76,-8.53,-8.09,-7.10,-6.49,-5.72,-5.11,-4.63,-4.22,-3.67,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.42,7.32,7.48,7.50,7.50,7.50,7.50,7.60,7.59,8.68,8.76,9.97,10,11.25,10,10,11.25,11.25,11.25,12.50,12.50,13.75,13.75,15,17.50,18.75,20,21.25,21.25,17.50,16.25,16.25,17.50,20,20,21.12,18.59,16.46,14.75,12.25,8.96,10.27,11.61,13.46,14.71,11.71,6.10,1.55,-0.89,-2.63,-4.23,-5.53,-6.47,-6.27,-5.15,-4,-2.79,-1.63,-0.89,8.75,11.25,11.25,11.25,12.50,12.50,10,8.75,7.50,7.50,8.75,11.25,10,10,10,10,10,10,10,10,10,10,10,8.75,8.75,10,10,11.25,11.25,12.50,13.75,15,15,13.75,12.50,12.50,13.75,15,16.25,16.25,12.50,10,10,10,8.75,7.27,3.85,1.18,-0.63,-1.88,-2.64,-4.35,-5.91,-7.26,-8.39,-9.30,-10,-10,-11,-11,-11,-10,-10,-10,-9.50,-9.30,-8.92,-8.04,-6.14,-3.89,-1.66,-0.64,0.93,0.89,0.89,1.09,1.50,2.34,2.50,2.50,2.50,2.50,2.50,2.43,2.18,1.18,0.62,0.46,0.72,0.88,0.93,0.77,0.30,1.25,-1.28,-2.63,-4.88,-4.75,-4.04,-2.65,-1.01,-0.24,0.77,1.71,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.18,2.13,0.79,-0.25,0.26,-0.75,-1.76,-2.87,-3.78,-5.35,-6.25,-7.72,-8.89,-9.66,-9.77,-8.53,-7.15,-6.50,-6.62,-6.74,-7.42,-8.49,-8.93,-8.92,-9.50,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.97,-9.38,-9,-9.64,-10,-11,-12,-12,-11,-11,-10,-12,-15,-17,-17,-15,-15,-14,-13,-11,-9.39,-9.39,-8.65,-8.27,-8,-6.91,-7.24,-7.39,-7.60,-7.16,-6.88,-6.99,-6.50,-6.75,-7.40,-7.24,-7.14,-6.78,-7.02,-7.26,-7,-7.52,-8.03,-9.10,-9.74,-9.29,-9.13,-8.75,-8.12,-7.64,-6.87,-6.68,-6.67,-6.53,-6.63,-7.10,-7.29,-7.34,-7.75,-8.25,-8.25,-8.27,-8.75,-9.38,-9.62,-9.42,-9.43,-9.11,-8.88,-8.38,-7.38,-6.50,-5.75,-4.75,-4.36,-3.88,-3.38,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.39,7.32,7.48,7.50,7.50,7.50,7.50,7.50,7.59,7.53,8.71,8.75,10,10,10,10,10,10,11.25,11.25,12.50,12.50,13.75,15,16.25,17.50,18.75,21.25,21.25,17.50,16.25,15,16.25,18.75,22.50,23.61,23.54,18.50,15.98,13.48,10.25,10.20,12.36,13.75,15,11.50,7.02,2.64,-0.61,-2.34,-3.87,-5.17,-6.15,-6.09,-5.14,-4.09,-2.88,-1.54,0.28,7.50,12.02,12.50,12.50,13.75,13.75,11.25,10,7.50,7.50,8.75,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11.25,11.25,12.50,13.75,13.75,13.75,13.75,12.50,13.75,15,16.25,16.25,13.75,11.25,10,10,10,8.75,7.18,4.52,1.65,-0.38,-1.63,-2.38,-3.76,-5.12,-6.26,-7.25,-8.01,-8.64,-9.14,-9.63,-9.98,-10,-9.85,-9.84,-9.34,-8.59,-8.50,-7.77,-6.36,-4.13,-1.90,-0.67,0.14,1.04,1.22,1.37,1.39,2.34,2.50,2.50,2.50,2.50,2.50,2.50,2.47,2.18,1.82,1.71,1.71,1.87,1.71,1.50,0.75,-0.13,-1,-1.60,-2.88,-4.38,-4.50,-3.97,-2.79,-1.30,-0.43,0.62,1.57,2.48,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.71,1.51,0.93,0.10,-0.42,-1.01,-2.36,-3.43,-4.73,-5.79,-6.72,-7.04,-8.87,-10,-10,-10,-9.03,-7.25,-6.13,-6.60,-7.25,-7.93,-8.60,-9.01,-9.43,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.54,-9.35,-10,-11,-11,-12,-12,-12,-12,-10,-12,-14,-16,-16,-15,-14,-12,-12,-12,-10,-8.22,-7.36,-6.79,-6.74,-6.48,-6.05,-6.23,-6.50,-6.11,-5.76,-5.28,-5.29,-6.50,-7.40,-7.61,-7.50,-6.84,-6.54,-6.63,-6.38,-6.78,-7.30,-7.98,-8.42,-8.25,-8.42,-8.55,-8.76,-8.39,-8.48,-7.93,-7.38,-7.36,-6.38,-6.89,-7.13,-6.72,-6.89,-7.40,-7.38,-7.75,-8.30,-8.98,-9.22,-9.30,-9.25,-9,-8.88,-8.37,-7.38,-6.41,-5.66,-4.68,-3.97,-3.50,-3.15,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.38,6.39,6.38,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.39,7.34,7.48,7.50,7.50,7.50,7.50,7.50,7.50,7.53,8.72,8.75,10,10,10,10,10,10,10,11.25,12.50,12.50,13.75,15,16.25,17.50,18.75,20,21.25,18.75,16.25,13.75,13.75,15,18.75,23.61,21.04,18.43,14.12,12.37,10.37,10.32,11.45,13.75,13.75,10.77,6.85,2.64,-0.63,-2.16,-3.72,-5.12,-6.14,-6.17,-5.37,-4.14,-2.84,-1.25,0.77,7.61,16.25,17.50,16.25,13.75,13.75,12.50,10,8.75,8.75,8.75,10,10,11.25,11.25,10,10,10,10,10,10,10,10,10,10,10,11.25,12.50,12.50,12.50,13.75,13.75,13.75,13.75,13.75,13.75,15,15,16.25,13.75,12.50,10,11.25,10,8.75,7.18,4.52,1.97,-0.26,-1.38,-2.15,-3.16,-4.23,-5.17,-6.01,-6.65,-7.17,-7.60,-7.98,-8.25,-8.88,-8.75,-8.37,-7.87,-6.84,-6.28,-5.39,-3.30,-2.09,-1.01,-0.02,1.04,1.25,1.25,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.63,2.77,2.80,2.96,2.89,2.48,1.86,0.61,-0.53,-1.88,-2.13,-2.88,-4.30,-4.54,-4.01,-3.09,-1.75,-0.75,0.32,1.43,2.32,3.59,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.09,0.89,0.60,0,-0.54,-1.13,-2.75,-3.90,-5.15,-6.22,-7.14,-7.86,-9.11,-10,-10,-10,-10,-9.27,-7.53,-6.67,-7.13,-7.75,-8.49,-9.09,-9.51,-9.87,-10,-11,-11,-11,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.61,-10,-11,-12,-12,-12,-12,-13,-13,-11,-10,-13,-13,-13,-12,-10,-10,-10,-10,-9.03,-6.92,-6.05,-6.13,-5.61,-5.49,-4.78,-3.97,-3.91,-3.51,-3.12,-3.50,-4.03,-5.13,-6.14,-6.30,-6.68,-6.38,-6.24,-6.18,-6.43,-6.37,-6.50,-6.75,-6.49,-6.47,-7.14,-7.88,-7.97,-8.50,-8.64,-8.88,-8.50,-7.78,-7.75,-7.04,-7.65,-7.50,-6.14,-6.66,-7.53,-7.98,-8.13,-8.30,-8.35,-8.51,-8.42,-8.63,-8.50,-7.93,-6.93,-6.10,-5.35,-4.37,-3.51,-3.15,-3,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.39,7.27,6.39,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.39,7.34,7.48,7.50,7.50,7.50,7.50,7.50,7.50,7.51,8.72,8.75,10,10,10,10,10,10,10,11.25,12.50,12.50,13.75,13.75,15,16.25,17.50,20,22.50,18.75,16.25,15,13.75,12.50,15,16.37,17.25,15.14,13.30,11.38,10.29,10.12,10.98,12.43,11.25,9.68,6.22,2.50,-0.63,-2,-3.63,-5.36,-6.63,-7.24,-5.73,-4.29,-2.88,-1.27,1.09,7.90,14.68,22.50,17.50,15,12.50,12.50,11.25,11.25,10,10,10,10,11.25,11.25,11.25,10,10,10,10,10,10,11.25,11.25,11.25,11.25,11.25,12.50,12.50,12.50,13.75,13.75,13.75,13.75,13.75,13.75,13.75,15,15,12.50,10,8.75,9.85,11,9.70,7.80,5.35,2.43,-0.17,-1.16,-1.93,-2.55,-3.27,-4.02,-4.72,-5.24,-5.63,-5.91,-6.15,-6.26,-6.75,-6.03,-6.38,-5.51,-4.63,-3.92,-2.41,-1.89,-1.38,-0.50,0.55,1.55,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.71,3.73,3.89,3.43,2.80,2.02,0.62,-0.88,-1.88,-2.78,-2.88,-4.54,-4.54,-4.23,-3.41,-2.51,-1.40,-0.25,1.09,2.17,2.76,2.64,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,0.93,0.30,-0.17,-0.66,-1.50,-3.24,-4.49,-5.42,-6.42,-7.15,-7.78,-8.38,-9.38,-10,-10,-11,-10,-9.25,-7.72,-7.42,-7.50,-8.13,-8.84,-9.42,-9.88,-10,-10,-11,-11,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.52,-10,-11,-12,-12,-12,-13,-13,-12,-11,-11,-11,-12,-12,-9.38,-9.01,-8.78,-9,-8.05,-6.62,-6.01,-5.25,-4.40,-3.84,-2.91,-2.65,-2.30,-1.75,-1.63,-1.63,-1.88,-2.53,-2.89,-3.28,-4,-4.48,-5,-5.67,-6.25,-6.29,-6.34,-6.41,-6.15,-5.75,-5.89,-6.05,-6.48,-7.22,-7.50,-8.02,-8.76,-8.38,-7.88,-7.55,-7.88,-7.98,-7.85,-7.36,-7.02,-8.48,-9.13,-8.79,-8.50,-7.39,-7.18,-8.12,-8.52,-8.41,-7.74,-6.16,-5.61,-5.47,-4.89,-3.78,-3.13,-3,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.39,6.43,6.43,6.39,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.39,7.34,7.63,7.63,7.61,7.50,7.50,7.50,7.50,7.51,8.73,10,10,10,10,10,10,10,11.25,11.25,12.50,13.75,13.75,13.75,15,15,16.25,18.75,21.25,18.75,17.50,15,13.75,13.75,12.50,13.84,12.76,12.86,11.68,10.45,9.17,9.11,9.72,9.96,10,8.27,5.39,2.02,-0.54,-1.87,-3.50,-5.25,-6.76,-8.03,-6.14,-4.52,-2.93,-1.18,1.76,6.25,12.96,20,17.50,15,12.50,11.25,13.75,15,13.75,11.25,10,11.25,11.25,11.25,11.25,11.25,10,10,10,10,11.25,11.25,12.50,12.50,12.50,12.50,12.50,12.50,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,11.25,8.75,7.64,9.04,10.72,10.59,9.12,6.52,3.30,0.40,-0.88,-1.63,-1.89,-2.37,-2.88,-3.36,-3.74,-4,-4.22,-4.30,-4.22,-3.38,-3.59,-3.17,-2.99,-2.50,-1.66,-1.38,-1.13,-0.75,-0.04,0.93,1.97,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,5,3.75,2.50,2.50,1.09,-0.88,-1.88,-2.76,-2.88,-4.52,-4.63,-4.37,-4,-2.90,-1.38,-0.25,1.25,2.30,2.64,3.43,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.46,1.39,1.09,0.25,-0.63,-1.54,-4.16,-6.13,-6.16,-6.75,-7.38,-8.02,-8.22,-8.38,-8.99,-9.79,-10,-11,-10,-8.98,-7.93,-7.68,-7.75,-8.38,-9.09,-9.67,-10,-10,-10,-11,-11,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.93,-9.38,-9.35,-10,-11,-11,-12,-13,-12,-12,-12,-11,-11,-12,-10,-9.03,-7.52,-7.34,-6.36,-5.93,-4.92,-4,-3.53,-2.34,-1.75,-1.50,-1.38,-1.13,-0.92,-0.88,-0.88,-0.79,-1.13,-1.50,-1.92,-2.38,-2.75,-3.50,-4.42,-4.99,-5.72,-6.36,-6.35,-6.40,-6.52,-6.10,-6.25,-6.29,-6.50,-6.61,-7.28,-7.60,-7,-7.12,-7.35,-7.80,-7.75,-7.93,-7.88,-7.86,-8.37,-9.53,-9.28,-8.16,-6.97,-6.64,-7.75,-8.90,-8.79,-7.37,-6.34,-5.90,-6.41,-6.38,-5.98,-4.25,-3.15,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.38,6.39,6.39,6.39,6.43,7.28,6.43,6.39,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.27,6.39,7.34,7.63,8.59,7.61,7.51,7.50,7.50,7.50,7.50,8.73,8.75,10,10,10,10,10,10,11.25,12.50,12.50,13.75,13.75,13.75,13.75,15,15,17.50,18.75,20,17.50,16.25,16.25,15,15,13.75,13.80,12.82,11.62,10.39,9.12,7.82,7.70,8.61,8.75,7.34,4.84,2.02,0,-1.63,-3.34,-5.14,-6.85,-8.41,-6.49,-4.78,-3.11,-1.39,1.04,4.52,10.62,15.62,16.25,16.25,13.75,11.25,13.75,17.50,16.25,13.75,12.50,12.50,12.50,12.50,12.50,12.50,10,10,10,10,11.25,11.25,12.50,13.75,12.50,12.50,12.50,13.75,13.75,15,15,13.75,12.50,12.50,13.75,13.75,12.50,12.50,10,7.50,7.89,8.27,9.40,10.10,8.87,7.55,3.39,1.46,-0.13,-1,-1.14,-1.40,-1.73,-1.99,-2.22,-2.37,-2.49,-2.52,-2.36,-1.75,-1.63,-1.41,-1.38,-0.92,-0.64,-0.50,-0.28,-0.02,0.46,1.36,2.45,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,2.46,0.77,-0.50,-1.39,-1.89,-2.27,-4.04,-3.87,-3.88,-3.65,-2.86,-1.38,0.46,1.25,2.51,2.78,2.50,2.50,2.34,2.18,2.30,2.34,2.46,2.47,2.46,2.32,2.18,1.39,0.30,-0.75,-2.93,-5.43,-7.27,-7.75,-8,-7.85,-7.88,-7.98,-8.11,-8.62,-9.43,-10,-12,-11,-9.72,-8.76,-7.53,-7.93,-8.50,-9.18,-9.77,-10,-10,-10,-11,-11,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.63,-9.05,-8.38,-9.35,-10,-11,-12,-13,-14,-12,-12,-11,-11,-10,-9.85,-7.41,-5.66,-4.92,-3.85,-3.03,-2.74,-2.38,-1.62,-1,-0.90,-0.88,-0.75,-0.50,-0.28,-0.17,-0.04,0.09,0.72,-0.63,-1.25,-1.76,-2.16,-2.43,-2.75,-3.34,-4.34,-4.98,-5.76,-6.48,-6.42,-6.80,-6.85,-6.37,-6.38,-6.38,-6,-6.18,-6.22,-5.75,-6.38,-7.25,-7.68,-7.40,-7.05,-7.26,-8.22,-9.09,-8.54,-7.15,-6.24,-6.03,-6.75,-7.86,-7.72,-6.79,-6.13,-6.35,-7.34,-7.88,-7.50,-5.97,-3.75,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.42,7.29,6.42,6.42,7.29,7.29,7.29,6.39,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.34,6.60,7.01,7.59,8.27,7.78,7.52,7.50,7.52,7.64,7.61,8.71,8.75,8.75,10,10,10,10,10,11.25,12.50,12.50,12.50,12.50,12.50,13.75,13.75,15,16.25,17.50,17.50,18.75,17.50,17.50,17.50,16.25,15,14.86,14.79,13.50,11.45,9.01,7.75,7.67,7.51,7.50,7.50,4.50,2.15,0.39,-1.50,-3.16,-4.91,-6.65,-8.42,-7.36,-5.02,-3.29,-1.62,0.47,3.59,8.89,12.62,15,15,13.75,12.50,13.75,16.25,17.50,16.25,15,12.50,13.75,12.50,12.50,12.50,11.25,10,10,11.25,11.25,12.50,12.50,13.75,13.75,13.75,15,15,15,15,15,13.75,11.25,12.50,12.50,13.75,11.25,10,8.75,7.64,7.85,8.40,9.05,9.39,9.03,7.48,5.14,2.67,0.85,-0.13,-0.30,-0.50,-0.55,-0.63,-0.63,-0.66,-0.75,-0.80,-0.88,-0.77,-0.63,-0.29,-0.18,0,0.40,0.62,0.62,0.62,1.25,1.25,2.50,2.50,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.47,1.09,0.09,-0.50,-1,-1.43,-2.29,-3,-3.35,-3.40,-2.89,-1.54,-0.41,1.07,2.15,2.59,2.46,1.75,1.80,1.39,1.59,2.12,2.27,2.30,2.29,2.17,2.01,1.25,0.14,-0.88,-3.05,-5.72,-7.66,-8.50,-8.61,-8.05,-7.85,-7.67,-7.66,-8.18,-9.22,-10,-11,-11,-10,-9.41,-8.11,-8.01,-8.64,-9.75,-10,-10,-11,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.77,-9.22,-8.63,-7.89,-7.66,-8.72,-10,-11,-13,-13,-11,-10,-10,-10,-9.02,-7.13,-4.88,-3.93,-2.41,-1.97,-1.64,-1.40,-1.15,-0.88,-0.63,-0.38,-0.26,-0.13,0,0.28,0.46,0.62,0.77,0.77,0,-0.55,-1.01,-1.38,-1.75,-2,-2.16,-2.63,-3.29,-4.29,-5.02,-5.75,-6.34,-6.38,-6.68,-6.64,-6.11,-5.42,-5.63,-5.78,-5.42,-5.68,-6.48,-6.91,-6.36,-6.22,-6.10,-6.91,-7.63,-7.47,-6.55,-5.43,-5.16,-5.52,-6.25,-6.50,-5.75,-5.25,-6.12,-7.49,-8.25,-7.99,-6.88,-4.75,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.39,7.32,6.42,6.42,7.29,7.29,6.42,6.39,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.35,6.53,6.85,7.22,7.50,7.62,7.53,7.52,7.61,7.80,8.37,8.54,8.72,8.84,8.75,10,10,10,10,11.25,11.25,12.50,12.50,12.50,12.50,12.50,13.75,15,15,16.25,16.25,17.50,18.75,18.75,17.50,16.25,16.25,16.12,16.05,16.02,12.75,10.25,8.92,7.68,6.37,6.25,6.25,4.18,1.85,0,-1.54,-3.10,-4.67,-6.30,-8.13,-6.92,-5.15,-3.52,-1.97,-0.25,2.02,5.90,10,13.75,15,13.75,13.75,13.75,15,16.25,16.25,15,13.75,13.75,13.75,12.50,11.25,11.25,10,10,11.25,11.25,12.50,13.75,15,16.25,17.50,17.50,16.25,16.25,15,13.75,12.50,11.25,11.25,12.50,12.50,10,7.50,7.50,7.61,7.95,8.53,9.15,9.53,9.42,8.60,6.23,3.05,2,1.09,0.72,0.46,0.46,0.40,0.45,0.29,0.14,0.14,0.26,0.30,0.30,0.62,0.62,1.07,1.25,1.65,1.65,1.25,1.25,2.50,2.50,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,5,3.75,3.75,3.75,2.78,1.82,1.09,0.61,0.14,-0.53,-1.25,-2,-2.93,-3.09,-2.90,-2.41,-1.17,0.12,1.39,1.86,2.28,1.42,0.45,0.79,0.79,1.39,1.70,1.96,1.96,1.84,1.55,0.77,-0.17,-1.05,-2.26,-5.97,-7.87,-8.38,-8.40,-8.12,-7.86,-7.48,-6.88,-7.59,-8.53,-10,-12,-11,-10,-9.91,-9.16,-8.74,-9.62,-10,-11,-12,-12,-11,-11,-10,-11,-11,-11,-11,-10,-10,-10,-10,-9.88,-9.25,-8.18,-7.47,-7.37,-8.38,-10,-10,-10,-10,-9.39,-8.37,-7.97,-7.42,-5.23,-3.24,-2.67,-1.88,-1.50,-1.25,-0.93,-0.66,-0.41,-0.27,-0.25,0,0.30,0.46,0.62,0.77,0.93,1.02,1.09,1.09,0.62,0,-0.38,-0.63,-0.75,-1.04,-1.43,-2,-2.18,-2.51,-3.17,-4.25,-4.41,-5.25,-5.90,-5.78,-5.67,-5.42,-5.75,-5.38,-5.40,-5.80,-5.51,-5.54,-6.04,-5.30,-5.04,-5.25,-6.10,-6.38,-5.91,-5.25,-4.80,-5,-5.42,-5.43,-5.01,-4.77,-5.51,-7.39,-8.41,-9.22,-7.47,-5.14,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.38,6.39,6.39,6.39,6.39,6.39,6.39,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.27,6.39,6.64,6.90,7.21,7.45,7.52,7.59,7.64,7.95,8.27,8.62,8.71,8.75,8.89,8.84,10,10,10,10,11.25,11.25,11.25,11.25,11.25,12.50,12.50,13.75,13.75,15,16.25,17.50,17.50,17.50,17.50,16.25,16.25,16.23,16.22,16.05,14.79,11.45,10.02,8.76,7.55,6.25,6.25,3.89,1.39,-0.50,-1.63,-3,-4.41,-5.91,-7.36,-6.53,-5.13,-3.75,-2.38,-0.98,0.42,3.25,7.48,11.25,13.75,12.50,13.75,13.75,13.75,13.75,15,13.75,12.50,12.50,13.75,11.25,11.25,11.25,10,10,11.25,11.25,12.50,13.75,15,17.50,18.75,18.75,17.50,16.25,16.25,13.75,12.50,11.25,10,10,10,7.50,7.50,6.25,7.39,8.14,8.89,9.63,10.13,10.15,9.86,7.18,4.89,2.97,2.02,1.65,1.52,1.39,1.39,1.39,1.39,1.23,1.22,1.25,1.39,1.39,1.39,1.36,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.12,2.59,2.02,1.71,1.25,0.46,-0.50,-1.38,-2.05,-3,-3.36,-3.13,-2.15,-0.88,0.75,1.09,0.89,0.30,-0.13,-0.54,-0.16,0.72,0.77,1.25,1.39,1.25,0.93,0.27,-0.53,-1.51,-3.51,-5.88,-7.25,-7.88,-8.01,-8,-8.10,-7.75,-6.51,-6.63,-8.78,-10,-12,-11,-10,-10,-9.53,-9.88,-10,-11,-12,-14,-13,-12,-11,-10,-10,-10,-10,-10,-10,-11,-11,-10,-10,-10,-10,-9.40,-9.78,-10,-11,-10,-9.50,-8.39,-6.67,-5.88,-5.22,-3.68,-2.02,-1.50,-1.25,-1.03,-0.79,-0.52,-0.26,0,0.27,0.46,0.45,0.93,1.04,1.21,1.25,1.25,1.25,1.25,1.25,1.25,1.21,0.62,-0.17,0.29,0.27,0.14,-0.63,-1.25,-1.53,-1.79,-2,-2.25,-2.99,-3.35,-3.59,-4.47,-4.42,-4.89,-5.38,-4.99,-5.35,-5.73,-5.26,-5.24,-5.66,-5.34,-4.84,-5.04,-5.15,-5.34,-5.42,-5.50,-5.02,-4.88,-4.74,-4.74,-5.05,-5.51,-5.77,-7.40,-9.48,-9.26,-8.16,-5.88,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.35,6.51,6.72,7.04,7.38,7.52,7.63,7.68,7.96,8.30,8.59,8.72,8.75,8.76,8.89,8.90,9.96,10,10,10,10,11.25,11.25,11.25,11.25,12.50,13.75,13.75,15,16.25,16.25,17.50,17.50,17.50,16.25,16.25,16.25,16.18,16.12,14.86,12.63,11.37,10.05,8.75,8.75,6.25,4.21,1.39,-0.63,-1.67,-2.88,-4.16,-5.40,-6.23,-6.34,-5.26,-4.09,-2.75,-1.50,-0.10,2.02,4.52,7.50,8.84,10,12.50,13.75,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,10,10,11.25,11.25,12.50,13.75,15,16.25,18.75,18.75,17.50,16.25,15,13.75,12.50,11.25,10,8.75,7.50,7.50,6.25,6.25,7.36,8.53,9.43,10.37,11.03,11.36,10.22,8.21,5.52,3.88,2.50,2.45,2.29,2.18,2.02,2.13,2.14,2.02,1.96,2.01,2.02,1.87,1.36,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,5,3.75,3.59,3.12,2.64,2.18,1.98,1.34,0.14,-0.76,-2,-3.13,-3.24,-3.25,-3.15,-1.52,-0.55,-0.13,0.46,-0.13,-1.03,-1.43,-1.13,-0.78,-0.38,0.09,0.28,0.14,-0.01,-0.40,-1.22,-3,-5.73,-6.39,-7.24,-7.65,-7.78,-7.84,-7.54,-7.13,-6.43,-6.55,-8.09,-9.63,-10,-9.75,-9.75,-9.54,-9.30,-10,-11,-11,-14,-15,-15,-13,-11,-10,-10,-10,-9.93,-10,-11,-12,-12,-12,-11,-12,-13,-13,-13,-13,-12,-11,-8.37,-6.04,-4.61,-3.53,-2.88,-1.38,-1.05,-0.67,-0.40,-0.39,-0.25,-0.13,0.25,0.46,0.75,0.88,1.02,1.09,1.21,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,0.60,-0.39,-0.77,-1.04,-1.27,-1.50,-1.75,-2,-2.38,-2.87,-3.50,-3.64,-4.16,-4.40,-4.50,-4.98,-4.42,-4.88,-5.29,-4.88,-4.84,-5.04,-5.05,-4.80,-5.30,-5.73,-5.26,-4.68,-4.88,-4.90,-5.36,-6.18,-6.85,-7.55,-8.75,-9,-7.98,-6.63,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.27,6.39,6.64,6.90,7.29,7.50,7.64,7.82,8.11,8.43,8.62,8.75,8.73,8.75,8.75,8.90,9.03,8.85,8.75,10,10,10,10,11.25,11.25,12.50,13.75,13.75,15,15,16.25,16.25,16.25,16.25,16.25,15,15,15,15,13.75,13.75,12.50,12.50,10,8.75,8.75,4.84,1.71,-0.63,-1.63,-2.75,-3.88,-5,-5.97,-6.75,-5.91,-4.40,-3.27,-2.12,-0.88,0.52,2.02,2.96,5.12,7.34,10,11.25,11.25,11.25,10,8.75,8.75,10,11.25,11.25,11.25,11.25,10,10,10,11.25,12.50,13.75,15,16.25,17.50,16.25,16.25,15,13.75,13.75,12.50,11.25,10,8.75,7.50,6.25,6.25,6.25,7.75,8.89,10.50,11.03,12.43,13.17,12.70,8.27,6.28,3.89,3.75,2.50,2.50,2.50,2.46,2.34,2.34,2.43,2.45,2.48,2.48,2.46,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.72,3.27,2.80,2.50,2.43,2.01,1.07,-0.25,-1,-2.02,-2.25,-2.36,-2.30,-1.88,-1.38,-0.67,-0.88,-1.15,-1.65,-2.34,-3.24,-3.05,-1.63,-1.03,-0.88,-0.88,-0.97,-1.39,-3.01,-5.02,-6.03,-7,-7.52,-7.67,-7.62,-7.47,-8.25,-7.76,-7.13,-7.51,-7.88,-9.41,-10,-10,-9.12,-8.61,-9.15,-9.55,-10,-11,-14,-16,-16,-15,-11,-9.92,-9.77,-9.52,-9.15,-10,-11,-12,-12,-14,-14,-14,-14,-14,-15,-13,-11,-9.28,-6.50,-4,-2.62,-2.14,-1.63,-0.78,-0.25,-0.13,0.12,0.25,0.30,0.39,0.55,0.77,1.04,1.18,1.23,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.21,0.60,0,-0.30,-0.51,-0.75,-0.88,-1.29,-1.75,-2.40,-3,-3,-3.13,-3.61,-3.61,-3.24,-3.54,-3.65,-4.05,-4.39,-4.42,-4.17,-4.22,-4.39,-4.93,-5.34,-4.79,-4.68,-4.88,-4.90,-5.36,-6.18,-6.85,-7.47,-7.75,-8.09,-7.50,-6.27,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.23,6.23,6.23,6.25,6.25,6.37,6.53,6.76,7.05,7.35,7.63,7.92,8.25,8.57,8.75,8.73,8.71,8.68,8.63,8.63,8.63,8.70,8.87,8.75,10,10,10,11.25,11.25,12.50,12.50,13.75,13.75,15,16.25,16.25,16.25,16.25,16.25,15,15,15,15,13.75,12.50,12.50,12.50,11.25,10,10,5.77,2.34,-0.38,-1.65,-2.50,-3.50,-4.54,-5.48,-5.99,-5.99,-4.80,-3.87,-2.85,-1.78,-0.76,0.14,1.25,2.18,2.59,1.82,7.50,8.75,10,8.75,7.50,7.50,8.75,10,11.25,11.25,11.25,10,10,10,11.25,12.50,13.75,15,15,15,15,15,15,15,13.75,13.75,11.25,8.75,7.50,6.25,6.25,6.25,7.50,7.64,9.71,10.35,11.80,14.03,16.84,15.67,10.39,6.39,5,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.72,3.27,2.95,2.64,2.80,2.59,1.71,0.62,-1,-1,-1.02,-1.13,-1.04,-0.87,-0.75,-0.76,-1.14,-1.92,-2.35,-4.43,-5.51,-4.64,-3.90,-3.38,-3.11,-2.55,-2.50,-3.15,-4.29,-5.42,-6.52,-7.55,-8.10,-8.18,-6.85,-7.17,-7.88,-8.09,-7.60,-7.05,-8.90,-11,-13,-12,-10,-9,-8.75,-8.91,-8.88,-10,-14,-16,-17,-15,-12,-9.47,-9.25,-9,-8.63,-9.38,-10,-10,-12,-14,-15,-14,-14,-14,-13,-12,-10,-7.05,-4.13,-2.25,-1.77,-1.38,-0.93,-0.18,0.13,0.30,0.62,1.02,1.20,0.93,0.90,0.93,1.09,1.21,1.23,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,0.77,0.42,0,-0.25,-0.50,-0.50,-1.40,-2.13,-2.53,-2.88,-2.90,-2.92,-2.92,-2.92,-2.93,-3,-3,-3.55,-3.62,-3.16,-3.13,-3.60,-3.68,-4.09,-4.35,-4.35,-4.09,-4.05,-4.50,-5.40,-5.55,-5.75,-6.43,-6.03,-5.97,-4.63,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.23,6.23,6.23,6.23,6.23,6.25,6.34,6.40,6.60,6.89,7.20,7.52,7.93,8.27,8.59,8.68,8.59,8.55,8.54,8.45,8.40,8.38,8.46,8.60,8.89,8.75,10,10,11.25,11.25,12.50,12.50,12.50,13.75,15,16.25,17.50,17.50,16.25,16.25,15,15,15,15,13.80,12.62,12.63,13.61,11.37,10.05,10,6.39,2.61,-0.25,-1.50,-2.12,-3.04,-4.05,-5,-5.67,-6,-5.29,-4.63,-3.88,-3,-2.04,-1.14,-0.42,0,0.57,1.87,3.43,5.93,8.75,7.50,6.25,7.50,8.75,10,11.25,11.25,12.50,10,10,10,11.25,12.50,12.50,15,16.25,15,15,15,15,15,13.75,12.50,10,8.75,7.50,6.25,6.25,6.25,7.50,8.75,8.89,10.25,12.78,16.11,18.50,18.60,12.50,6.25,5,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.73,3.27,2.95,2.80,3.12,3.12,2.75,1.25,1.25,1.25,1.25,1.25,1.09,0.93,0.88,0.77,-0.77,-1.79,-3.34,-5.50,-6.55,-6.27,-5.61,-5.26,-5.13,-5.16,-4.84,-4.91,-5.40,-6.12,-6.98,-8,-8.67,-9.37,-8.89,-7.53,-7.25,-7.59,-8.13,-9.38,-9.47,-11,-13,-13,-13,-10,-8.40,-7.84,-7.63,-9.09,-13,-15,-16,-15,-11,-9.35,-8.54,-8.29,-7.93,-7.66,-8.99,-10,-12,-13,-12,-13,-13,-12,-11,-9.92,-6.61,-4.01,-1.89,-1.25,-0.88,-0.63,-0.26,0,0.77,-0.13,1.70,2.64,2.61,2.18,1.39,1.21,1.25,1.25,1.55,2.96,2.80,1.53,1.25,-1,-1,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.23,0.93,0.61,0.14,-0.04,-0.50,-1.13,-1.65,-2.03,-2.38,-2.53,-2.63,-2.63,-2.50,-2.38,-2.26,-2.75,-2.75,-2.75,-3,-3,-2.93,-3,-3.03,-3.49,-3.48,-3.01,-3.02,-3.35,-3.61,-3.63,-3.60,-3.75,-4.10,-3.55,-2.51,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.23,6.22,6.22,6.22,6.21,6.22,6.25,6.27,6.39,6.54,6.73,7.05,7.46,7.80,8.14,8.37,8.38,8.30,8.27,8.26,8.15,8.12,8.13,8.22,8.61,8.89,8.90,10,10,11.25,11.25,12.50,13.75,13.75,13.75,15,16.25,16.25,17.50,16.25,16.25,15,15,15,14.93,13.88,13.57,13.54,13.54,12.63,11.38,9.93,6.25,2.96,0.46,-0.75,-1.63,-2.43,-3.37,-4.27,-5.16,-6.01,-6.09,-5.60,-5,-4.25,-3.38,-2.47,-1.63,-0.97,-0.38,0.59,1.80,3.59,5,5,6.25,7.50,8.75,10,10,11.25,11.25,10,8.75,8.75,10,11.25,12.50,13.75,16.25,15,16.25,16.25,16.25,16.25,12.50,11.25,10,7.50,6.25,6.25,6.25,6.25,7.50,8.75,10,11.25,15,18.75,21.25,21.25,13.75,7.50,6.25,5,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.73,2.50,2.50,3.72,3.72,3.73,3.75,2.50,1.25,1.25,2.50,2.34,3.43,2.13,0.89,-0.66,-1.25,-3.30,-5.63,-7.38,-7.13,-6.75,-6.43,-6.51,-7.55,-6.50,-6.37,-6.50,-6.75,-7.14,-8.61,-9.26,-9.87,-9.63,-9.13,-7.39,-7.97,-10,-12,-12,-11,-13,-17,-17,-14,-10,-7.85,-7.27,-8.03,-10,-14,-16,-15,-11,-9.61,-8.03,-8.10,-7.87,-7.38,-7.04,-8.60,-10,-12,-11,-12,-12,-10,-8.84,-7.13,-4.28,-1.77,-0.78,-0.13,0.30,0.57,0.60,1.04,1.53,1.03,1.53,8.55,7.43,7.50,1.25,1.25,1.25,1.25,2.64,5,5.10,2.60,1.25,1.25,-1,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.21,0.93,0.88,-0.64,-0.63,-0.78,-1.25,-1.63,-1.88,-1.88,-1.90,-1.79,-1.53,-1.28,-1.38,-1.38,-2.63,-2.80,-2.75,-2.50,-2.30,-2.26,-2.25,-2.25,-2.25,-2.25,-2.25,-2.38,-2.50,-2.54,-2.63,-2.63,-2.64,-2.04,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.23,6.22,6.22,6.21,6.20,6.18,6.18,6.21,6.25,6.38,6.52,6.71,7,7.34,7.67,7.96,8.01,8,7.96,7.95,7.93,7.92,7.96,8.07,8.39,8.75,9.10,9.64,10.13,11.25,11.25,12.50,13.75,15,15,15,15,16.25,16.25,16.25,17.50,16.25,15,15,15,14.87,13.92,13.75,13.88,13.88,13.75,13.57,10.12,7.34,3.23,1.85,0,-0.93,-1.67,-2.60,-3.59,-4.66,-6.02,-6.80,-6.40,-6.18,-5.63,-4.75,-3.76,-2.80,-1.93,-1.14,-0.39,0.57,1.97,3.12,4.05,5,7.50,8.75,8.75,10,10,11.25,10,8.75,7.50,8.75,8.75,10,13.75,12.50,13.75,17.50,18.75,17.50,13.75,12.50,10,7.50,6.25,6.25,6.25,6.25,6.25,7.50,8.75,11.25,12.50,15,18.75,22.50,20,13.75,8.75,6.25,5,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,5,5,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.60,2.50,2.15,1.25,0.77,-0.79,-1.90,-4.68,-6.38,-8.38,-7.18,-7.10,-7.13,-7.80,-7.59,-7.73,-7.72,-7.30,-7.10,-7.90,-8.88,-9.54,-9.30,-8.50,-6.91,-6.67,-10,-14,-12,-11,-14,-17,-17,-15,-13,-10,-8,-7.91,-10,-14,-16,-15,-13,-10,-8.77,-8.25,-8.88,-9,-8.60,-8.54,-9.59,-11,-12,-12,-11,-10,-8.23,-6.48,-3.42,-1.16,0.09,1.35,2.02,2.47,2.80,2.77,1.50,1.39,3.89,8.68,12.50,8.75,5,1.25,1.25,1.87,3.12,5.12,4.52,2.50,2.02,2.02,1.85,1.50,1.25,1.80,3.88,1.80,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.23,1.20,0.77,-0.63,0.73,0.73,-0.30,-0.63,-0.75,-0.77,-0.93,-1,-0.88,-0.15,0.77,-1.03,-1.92,-2.63,-2.63,-1.75,-1.63,-1.50,-1.43,-1.38,-1.30,-1.28,-1.38,-1.52,-1.75,-1.79,-1.79,-1.88,-2,-1.88,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.23,6.22,6.22,6.21,6.18,6.11,6.09,6.09,6.09,6.21,6.36,6.52,6.67,6.88,7.21,7.53,7.77,7.79,7.75,7.65,7.65,7.67,7.78,7.95,8.22,8.55,8.92,9.37,9.79,10.28,11.12,12.50,13.75,16.25,15,15,16.25,15,16.25,16.25,16.25,16.25,16.25,15,15,15,14.86,13.95,13.88,14.01,14.73,14.75,14.79,12.36,9.21,6.09,3.43,1.71,0.14,-0.78,-1.75,-2.80,-3.98,-5.13,-6.24,-7.11,-7.40,-7.13,-6.29,-5.34,-4.26,-3.25,-2.27,-1.13,-0.38,0.62,1.71,2.59,3.43,4.52,6.02,7.50,8.75,10,8.75,7.50,6.25,6.25,6.25,6.25,8.75,10,10,12.50,15,17.50,16.25,13.75,11.25,8.75,6.25,5,5,6.25,7.50,6.25,7.50,8.75,10,12.50,13.75,17.50,21.25,18.75,15,10,7.50,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,5,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.47,2.18,1.55,0.90,-0.65,-1.13,-2.13,-3.63,-5.50,-5.86,-6.25,-6.60,-7.34,-7.79,-9.42,-10,-7.88,-5.67,-6.97,-8.65,-9,-8.66,-7.62,-6.25,-7.74,-10,-12,-11,-8.38,-12,-15,-15,-15,-14,-11,-9.78,-9.13,-10,-13,-15,-16,-14,-12,-9.53,-8.62,-9.91,-10,-10,-10,-10,-11,-12,-12,-11,-10,-8.79,-5.80,-2.49,-0.77,0.90,2.64,4.05,4.98,5.62,6.50,8.75,8.75,8.75,10,13.75,12.50,6.25,3.75,3.89,4.65,5.93,6.80,6.86,5.90,4.79,4.52,4.21,3.89,2.96,4.95,6.39,4.37,1.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.23,0.93,0.77,-0.63,0.73,0.73,0.46,0.30,0.30,0.29,0,-0.27,-0.25,0,0.77,-0.63,-1.63,-1.76,-1.63,-1.04,-0.65,-0.67,-0.63,-0.54,-0.41,-0.29,-0.50,-0.63,-0.75,-0.76,-0.78,-0.88,-0.91,-0.38,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.23,6.22,6.21,6.18,6.11,6.05,5.93,5.92,5.93,6.09,6.25,6.39,6.55,6.82,7.15,7.48,7.64,7.64,7.61,7.53,7.53,7.64,7.80,8.09,8.37,8.71,9.05,9.39,9.84,10.15,10.30,11.28,13.73,13.75,15,16.25,15,16.25,17.50,16.25,16.25,16.25,16.25,15,15,15,14.86,13.95,14,14.73,14.85,15,14.79,14.86,11.98,8.27,5.60,3.42,1.55,0.28,-0.86,-1.97,-3.13,-4.34,-5.67,-7.04,-9.39,-9.10,-8.13,-7,-5.79,-4.85,-3.80,-2.79,-1.75,-0.39,0.39,1.04,1.55,2.30,2.59,7.50,10,10,7.50,5,3.75,3.75,3.75,3.75,6.25,6.25,7.50,10,13.75,15,13.75,12.50,10,8.75,6.25,5,5,6.25,6.25,6.25,6.25,7.50,10,11.25,13.75,17.50,20,20,15,10,7.50,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,5,5,5,3.75,3.75,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.34,1.39,1.02,0.77,-0.63,-1.13,-1.75,-2.38,-3.86,-4.72,-5.39,-6.17,-7.17,-8.25,-8.38,-7.75,-6.87,-6.62,-6.10,-7.26,-7.35,-6.79,-6.11,-6.67,-9.43,-10,-8.87,-7.97,-10,-12,-14,-14,-13,-11,-10,-9.63,-10,-12,-15,-16,-15,-12,-9.72,-9.39,-10,-10,-10,-10,-11,-11,-12,-12,-9.85,-9.35,-7.78,-4,-2.22,-0.50,1.55,3.85,5.88,7.34,8.71,9.93,12.50,12.50,12.50,12.50,13.75,13.75,11.25,5.62,5.59,7.93,8.12,9.21,9.46,9.63,8.12,7.50,8.23,7.80,6.96,5.87,7.02,3.75,2.34,2.02,1.84,1.72,1.71,2.89,2.64,1.50,1.23,0.93,-0.75,-0.64,-0.63,0.77,0.93,1.09,1.09,1.09,0.87,0.39,-0.13,0.59,0.77,-0.64,-0.63,-0.63,-0.75,-0.38,-0.18,-0.02,0,0,0.14,0.46,0.30,0.29,0.28,0.27,0.26,0.14,-0.13,-0.04,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.22,6.21,6.18,6.10,6.05,5.90,5.77,5.65,5.75,5.92,6.10,6.27,6.45,6.71,7.04,7.35,7.50,7.50,7.48,7.48,7.51,7.64,7.85,8.13,8.45,8.76,9.07,9.37,9.68,10,10.47,11.35,12.43,13.71,14.97,14.98,15,16.25,16.25,16.25,16.25,16.25,16.25,15,15,15,14.87,13.92,13.96,14.75,15,15,15,14.87,13.75,10,7.45,5.14,3.25,1.55,0.12,-1.09,-2.25,-3.50,-4.72,-7.42,-9.86,-10,-10,-8.73,-7.39,-6.40,-5.49,-4.59,-3.62,-2.61,-1.59,-0.75,-0.16,0.25,1.65,2.34,9.47,10,6.25,1.25,1.71,1.34,1.39,1.71,2.18,2.96,2.64,5.89,8.27,10,12.50,12.50,10,8.75,6.25,5,5,5,5,6.25,6.25,7.50,10,12.50,15,21.25,22.50,16.25,13.75,10,7.50,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,6.25,6.25,6.25,5,5,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.02,0.90,-0.42,-1.13,-1.63,-2.10,-2.65,-3.01,-4.60,-6.36,-7.04,-7.36,-7.11,-6.49,-6.09,-6.16,-6.48,-6.68,-6.51,-5.54,-6.42,-6.68,-7.99,-8.02,-9.01,-10,-10,-10,-11,-11,-12,-11,-9.03,-8.63,-11,-14,-15,-14,-10,-9.38,-9.03,-10,-9.74,-8.74,-9.28,-10,-11,-12,-11,-10,-8.50,-6.54,-4.47,-1.76,-0.04,2.14,4.47,6.55,8.42,9.68,11.23,13.75,13.75,13.75,13.75,13.75,13.75,11.25,6.39,7.80,8.85,9.22,10.40,11.18,11.82,10.62,9.84,10.25,10.14,9.34,7.50,6.09,4.64,3.88,4.20,4.93,3.52,4.02,5.59,5.30,3.07,1.51,1.09,0.93,0.88,-0.67,0.77,1.18,1.22,1.21,1.20,1.09,0.89,0.90,1.03,0.93,0.88,0.77,0.77,0.88,0,0.42,0.60,0.62,0.62,0.77,0.92,0.90,0.93,1.04,1.03,1.03,1.05,0.55,-0.40,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.22,6.22,6.20,6.11,6.07,5.92,5.73,5.55,5.46,5.57,5.76,5.95,6.12,6.36,6.60,6.89,7.17,7.22,7.30,7.34,7.37,7.50,7.65,7.93,8.22,8.52,8.77,9.05,9.30,9.54,9.88,10.34,10.93,11.39,12.48,12.59,13.76,14.97,15,16.25,17.50,16.25,16.25,16.25,15,15,15,14.93,13.88,13.92,14.79,14.85,15,15,14.93,13.75,11.25,9.05,7,4.96,2.96,1.25,-0.25,-1.53,-2.89,-4.66,-6.88,-9.50,-11,-12,-10,-8.87,-7.88,-7,-6.29,-5.53,-4.64,-3.77,-2.76,-1.85,-0.88,0.12,1.85,3.59,4.47,3.25,1.51,0.12,-0.17,-0.51,-0.41,-0.25,0.14,0.87,2.34,3.84,5.93,7.78,9.37,10,8.75,6.25,6.25,5,5,5,5,6.25,8.75,10,13.75,18.75,22.50,20,16.25,11.25,8.75,7.50,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,6.25,6.25,6.25,6.25,6.25,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.18,0.90,0.14,-0.50,-1,-1.39,-1.78,-2.13,-2.76,-4.38,-5.35,-5.79,-5.75,-5.50,-5.34,-5.50,-5.93,-6.63,-6.88,-6.53,-6.80,-6.72,-5.63,-7.52,-9.48,-10,-10,-9.15,-9.47,-11,-12,-11,-9,-8.52,-9.24,-10,-11,-11,-10,-8.37,-7.38,-7.99,-8,-7.91,-9.99,-12,-12,-11,-10,-9.84,-8.75,-7.49,-4.84,-1.88,0.39,2.50,4.77,7.01,8.59,9.98,11.25,12.50,12.50,12.50,13.75,13.75,12.50,12.50,7.64,7.80,8.85,9.22,10.40,11.84,13.75,13.12,11.09,11.04,10.93,10.30,8.68,7.01,5.92,5.62,7.02,7.64,6.05,4.96,5.93,4.79,3.27,2.62,1.87,1.25,1.25,1.55,1.52,1.39,1.39,1.71,1.87,1.86,1.64,1.39,1.25,1.20,1.20,1.18,1.18,0.93,0.89,0.89,1.09,1.07,1.05,1.05,1.09,1.09,1.18,1.21,1.23,1.23,1.09,0.93,1.20,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.21,6.12,6.05,5.90,5.72,5.48,5.34,5.30,5.45,5.62,5.77,5.95,6.13,6.39,6.67,6.86,7,7.05,7.18,7.30,7.47,7.64,7.93,8.23,8.47,8.75,8.93,9.18,9.40,9.78,10.14,10.61,11.11,11.38,12.36,13.62,13.84,15.01,16.22,16.25,16.25,16.25,16.25,15,15,15,15,13.80,13.87,13.88,14.86,14.87,15,15,13.75,12.50,10,8.12,6.36,4.15,2.27,0.57,-0.85,-2.25,-4.14,-6.27,-8.60,-10,-12,-11,-9.76,-8.87,-8.18,-7.87,-7.18,-6.63,-5.84,-4.66,-3.67,-2.77,-1.68,-0.48,0.78,1.39,1.09,0.14,-0.76,-1.25,-1.75,-1.75,-1.53,-1.25,-0.78,0,1.25,2.50,4.21,5.46,6.25,6.87,6.25,6.25,6.25,5,5,5,6.25,8.75,11.25,13.75,17.50,21.25,22.50,18.75,13.75,8.75,7.50,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,3.75,3.75,3.75,5,6.25,6.25,6.25,7.50,7.50,7.50,6.25,6.25,6.25,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.37,1.02,0.62,0.11,-0.30,-0.75,-1.13,-1.50,-1.88,-2.13,-2.97,-3.73,-4.22,-4.10,-4.13,-4.49,-5.15,-6.35,-7.97,-7.88,-7.34,-7.13,-6.63,-7.15,-10,-11,-10,-9.99,-11,-11,-11,-11,-9.84,-9.04,-9.13,-8.62,-8.41,-9.25,-8.63,-7.01,-6.63,-6.88,-7.64,-9.66,-10,-12,-14,-12,-10,-10,-9.29,-7.85,-5.75,-2.25,0.62,2.64,4.68,6.71,8.27,9.46,10,10,11.25,11.25,11.25,11.25,12.50,11.25,10.62,8.09,8.23,9.53,9.52,11.39,14.48,13.73,11.52,10.55,10.73,10.12,8.38,7.35,7.96,6.87,6.82,7.50,6.05,6.22,5.77,4.52,4.02,4.79,3.09,2.34,2.60,2.79,2.77,2.92,2.80,2.89,3.27,3.26,2.77,2.50,3.12,2.02,1.80,1.40,1.50,1.80,1.71,1.50,1.51,2.02,2.34,2.34,2.02,2.32,2.60,2.32,1.71,1.25,1.25,1.25,1.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.21,6.12,6.05,5.90,5.72,5.47,5.30,5.20,5.26,5.32,5.46,5.59,5.73,5.93,6.13,6.38,6.55,6.71,6.86,7.02,7.18,7.37,7.63,7.90,8.14,8.43,8.63,8.86,9.05,9.32,9.64,10,10.45,10.80,11.25,11.39,12.63,14.86,15.10,16.18,17.46,16.25,16.25,16.25,16.25,15,15,15,13.75,13.75,13.75,13.75,15,15,15,13.75,12.50,10,8.75,7.18,5,3.09,1.34,-0.25,-1.59,-3.38,-5.35,-7.59,-9.53,-11,-10,-9.87,-9.35,-8.67,-8.63,-8.39,-8.02,-7.41,-6.41,-5.64,-4.93,-4,-2.80,-1.73,-0.88,-0.61,-0.84,-1.41,-1.89,-2.41,-2.50,-2.38,-2.13,-1.78,-1.17,-0.50,0.14,1.23,2.18,2.96,3.85,5,5,5,6.25,5,5,6.25,8.75,11.25,13.75,16.25,21.25,22.50,18.75,12.50,8.75,6.25,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,5,5,6.25,6.25,7.50,7.50,8.75,8.75,7.50,7.50,6.25,6.25,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.37,1.25,0.92,0.62,0.30,-0.02,-0.38,-0.63,-0.78,-1.13,-1.38,-1.75,-2,-2.43,-2.62,-3.05,-3.90,-5.34,-8.03,-7.43,-7.66,-7.74,-8.12,-10,-12,-13,-12,-11,-11,-11,-12,-12,-10,-8.77,-9.18,-8.98,-8.12,-7.79,-7.75,-7.04,-7.29,-8.55,-9.74,-11,-12,-13,-15,-14,-12,-11,-9.84,-8.36,-6.09,-2.18,0.61,2.64,4.50,6.09,7.48,8.43,9.21,9.96,11.25,10,10,10,11.25,12.50,10,6.39,7.34,9.68,8.26,7.18,8.85,8.59,7.96,8.75,8.89,8.59,7.02,7.79,8.43,7.78,6.55,6.09,6.39,6.85,6.38,5.09,5.46,6.55,6.18,3.60,3.26,3.40,3.59,4.34,4.52,4.52,4.37,4.37,5,4.98,5.46,4.05,2.96,4.21,3.23,2.64,2.65,3.07,3.59,4.01,4.84,5.14,5.62,5.61,5.25,4.52,3.43,2.30,1.25,1.25,1.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.21,6.12,6.05,5.90,5.72,5.47,5.30,5.14,5.14,5.15,5.27,5.30,5.35,5.47,5.64,5.89,6.10,6.28,6.50,6.67,6.87,7.05,7.32,7.53,7.80,8.09,8.30,8.54,8.75,8.92,9.21,9.52,9.87,10.28,10.64,10.97,11.39,12.34,13.75,16.09,16.11,16.23,16.26,16.23,16.25,16.25,15,15,15,13.75,13.75,13.75,13.75,13.75,15,13.75,13.75,11.25,10,8.75,7.50,5.90,3.71,1.71,0.30,-1.02,-2.52,-4.18,-5.88,-7.63,-8.78,-9.25,-9.99,-9.01,-7.73,-8.90,-9.52,-9,-8.36,-7.99,-7.75,-7.38,-6.50,-5.22,-3.86,-2.74,-2.05,-1.87,-1.93,-2.38,-2.76,-3,-3.37,-3.43,-3.26,-2.76,-1.91,-1.39,-0.73,0.10,0.46,1.35,1.71,2.34,4.37,6.25,6.25,6.25,6.25,7.50,11.25,13.75,15,17.50,20,18.75,12.50,8.75,6.25,5,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,5,5,6.25,6.25,7.50,7.50,10,10,10,8.75,7.50,6.25,6.25,5,5,5,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.37,1.09,0.93,0.77,0.62,0.45,0.30,0.28,-0.13,-0.42,-0.65,-0.76,-0.88,-0.88,-1.01,-1.78,-3.38,-5.30,-6.38,-7.18,-7.88,-9.13,-10,-11,-12,-13,-12,-12,-12,-12,-12,-11,-10,-8.38,-7.87,-7.98,-7.14,-6.75,-8.16,-10,-10,-11,-12,-13,-14,-13,-12,-11,-10,-9.53,-7.88,-5.13,-2,0.30,1.87,3.43,4.84,6.20,7.27,8.27,8.87,10,10,8.75,10,11.25,11.25,10,5,4.67,5.61,3.43,2.96,4.79,6.72,4.96,5.30,5.77,5.46,5.13,5,6.23,7.47,7.48,5.93,6.20,6.55,6.09,4.84,4.52,6.82,6.70,6.25,3.89,3.84,4.78,5.77,6.39,6.10,5.72,6.35,6.38,5.89,5.14,3.87,4.79,6.39,5.42,3.43,3.55,4.48,5.43,5.62,6.55,7.34,8.52,8.09,7.03,6.21,4.78,3.42,1.71,1.25,1.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.21,6.12,6.05,5.90,5.72,5.47,5.29,5.14,5.09,5.09,5.12,5.14,5.14,5.18,5.30,5.46,5.64,5.90,6.10,6.28,6.52,6.72,7,7.21,7.48,7.70,7.96,8.21,8.42,8.61,8.86,9.09,9.39,9.77,10.12,10.46,10.78,11.22,11.42,12.64,14.84,15.13,16.11,16.13,16.23,16.23,16.25,15,15,15,13.75,13.75,13.75,13.75,13.75,13.75,15,12.50,11.25,10,8.75,7.50,5.93,4.15,2.50,0.77,-0.67,-1.67,-2.93,-4.43,-5.92,-7.27,-8.50,-10,-10,-9.03,-7.62,-8.03,-8.88,-8.99,-9.40,-9.93,-10,-9.29,-7.76,-5.62,-4.09,-3.11,-2.61,-2.40,-2.67,-3.05,-4.01,-4.60,-5.34,-5.90,-6.50,-6.36,-5.65,-4.29,-2.72,-1.38,-0.51,-0.25,0.77,2.34,6.25,7.50,7.50,7.50,8.75,10,13.75,17.50,18.75,18.75,20,15,10,7.50,5,5,3.75,3.75,3.75,3.75,5,5,5,5,5,6.25,6.25,7.50,7.50,7.50,8.75,8.75,10,10,8.75,7.50,6.25,6.25,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.23,1.23,1.21,1.09,1.09,1.09,1.09,0.62,0.46,0.30,0.10,-0.02,-0.27,-0.43,-0.76,-1.62,-2.50,-4.50,-5.80,-7.01,-8.65,-9.98,-11,-12,-12,-12,-12,-13,-13,-12,-12,-11,-8.90,-7.02,-6.86,-7.17,-8.52,-12,-13,-13,-12,-11,-11,-11,-10,-9.17,-8.89,-8.76,-7.90,-6.28,-4,-2,-0.63,0.72,2.12,3.43,4.68,5.77,6.98,7.34,7.50,8.75,7.50,7.50,10,10,7.50,7.50,3.75,1.25,1.25,2.65,6.86,8.22,5,2.45,3.85,2.64,2.34,2.18,3.75,7.13,7.96,6.09,5,5.46,5,4.04,3.89,4.02,6.09,5.87,5.30,5.45,5.62,6.50,7.28,7.96,6.39,5.93,6.04,5,4.78,4.37,4.67,6.10,5,4.04,4.05,5.30,6.25,6.84,7.46,8.75,9.84,9.37,8.22,7.02,5.60,4,2.30,1.25,1.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.21,6.12,6.07,5.90,5.72,5.47,5.29,5.14,5.02,5,5,5.02,5.03,5.09,5.11,5.14,5.30,5.48,5.75,5.93,6.18,6.39,6.64,6.87,7.14,7.36,7.61,7.80,8.05,8.27,8.52,8.75,9.01,9.30,9.63,9.95,10.26,10.62,10.95,11.45,12.28,12.65,13.89,14.84,15.11,17.37,16.18,15,15,15,15,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,11.25,10,8.75,7.50,6.38,5.14,2.80,1.39,-0.78,-0.89,-1.63,-3.04,-4.49,-5.98,-7.53,-8.90,-9.68,-9.78,-8.28,-7.26,-8.30,-10,-11,-11,-12,-11,-9.50,-6.77,-4.88,-3.65,-3.02,-2.77,-2.89,-3.59,-4.50,-5.49,-6.88,-9.03,-10,-12,-10,-8.27,-5.88,-3.59,-1.64,-1.25,-0.25,1.65,5,7.50,8.75,8.75,8.75,11.25,13.75,17.50,18.75,21.25,21.25,13.75,10,7.50,6.25,5,5,5,5,5,5,6.25,6.25,6.25,6.25,6.25,7.50,8.75,8.75,8.75,8.75,10,10,10,8.75,7.50,7.50,6.25,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,3.75,3.75,3.75,3.75,3.75,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.22,1.09,1.09,0.62,0.25,-0.28,-0.38,-0.38,-0.40,-0.78,-1.63,-3.66,-5.03,-6.75,-8.75,-10,-11,-11,-12,-12,-14,-13,-11,-11,-10,-8.02,-8.25,-9.87,-10,-12,-14,-14,-14,-13,-11,-10,-9.85,-9.25,-8.79,-9.25,-8.37,-8.64,-7.40,-5.98,-5.18,-1.50,-0.39,0.73,1.87,2.96,4.04,4.98,5.46,5.89,6.09,6.36,6.86,7.50,7.50,8.75,5,2.50,1.25,1.25,1.55,3.37,4.68,1.87,2.75,3.75,2.75,1.25,1.25,1.67,3.59,4.37,3.59,3.27,3.27,3.26,3.12,3.21,2.93,3.21,5.42,5.30,6.70,7.80,6.39,7.60,8.22,7.18,5.46,5.28,5.27,5.76,6.39,5.46,5.93,7.18,4.52,4.05,5.30,6.25,6.84,7.46,8.75,9.84,9.37,8.22,7.02,5.60,4,2.30,1.25,1.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.21,6.13,6.07,5.92,5.72,5.47,5.29,5.14,5.02,5,5,5,5,5,5,5.01,5.10,5.18,5.39,5.61,5.80,6.05,6.26,6.53,6.76,7.02,7.28,7.50,7.67,7.90,8.12,8.37,8.59,8.88,9.18,9.48,9.78,10.02,10.39,10.77,11.23,11.50,12.27,12.67,13.75,14.84,15.12,15.10,15.03,15,15,15,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,12.50,11.25,10,8.75,7.50,7.50,5,1.25,1.25,1.25,-0.52,-1.75,-3.13,-4.63,-6.18,-7.65,-8.61,-9.26,-8.75,-7.68,-9.74,-12,-13,-13,-12,-12,-10,-6.76,-4.88,-3.73,-3.11,-3,-3,-3.59,-4.50,-5.74,-8.14,-11,-13,-16,-15,-12,-8.64,-5.68,-3.50,-1.92,-0.88,0.62,1.25,6.25,8.75,8.75,10,10,13.75,18.75,18.75,23.75,21.25,15,10,7.50,6.25,5,5,5,5,5,6.25,6.25,7.50,7.50,7.50,7.50,8.75,10,11.25,11.25,10,11.25,11.25,10,8.75,8.75,7.50,6.25,6.25,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,0.93,-0.75,-0.65,-0.43,0.40,0.30,0.30,-0.53,-1.38,-2.63,-4.66,-6.86,-8.93,-10,-10,-11,-12,-12,-12,-11,-10,-9.13,-10,-12,-15,-16,-15,-15,-15,-14,-12,-9.67,-8.38,-7.11,-6.80,-6.15,-6.40,-5.90,-6.55,-6.35,-8.77,-8.66,-2.35,-1.38,-0.51,0.30,1.25,2.17,2.96,3.43,3.89,4.30,4.84,5.46,6.25,7.50,6.25,5,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.55,2.75,1.55,1.25,1.25,1.25,1.25,1.54,1.72,1.80,1.55,1.55,2.02,2.12,1.87,2.96,4.63,5.72,6.55,7.01,6.39,5.30,6.25,5.46,4.84,4.68,4.96,6.71,7.50,6.71,7.97,8.70,6.54,6.25,5,5.43,5.62,6.55,7.34,8.52,8.09,7.03,6.21,4.78,3.42,1.71,1.25,1.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.21,6.13,6.07,5.92,5.72,5.47,5.29,5.14,5.02,5,5,5,5,5,5,5,5,5.02,5.14,5.28,5.46,5.71,5.93,6.18,6.39,6.68,6.90,7.17,7.35,7.53,7.76,7.96,8.15,8.43,8.72,9.02,9.32,9.57,9.85,10.14,10.46,10.93,11.23,11.50,12.27,12.67,13.59,13.89,14.86,14.98,15,15,15,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,11.25,10,10,8.75,7.50,6.25,3.75,3.75,1.65,0.46,-0.61,-1.75,-3.23,-4.90,-6.43,-7.73,-8.26,-8.16,-8.80,-10,-13,-13,-13,-11,-9.62,-7.63,-5.75,-4.27,-3.25,-2.78,-2.75,-2.75,-2.90,-3.90,-4.84,-7.91,-10,-14,-17,-17,-15,-10,-7.25,-4.97,-3.11,-1.55,-0.18,1.71,3.85,5.90,7.32,7.50,8.75,12.50,15,18.75,20,21.25,16.25,11.25,7.50,6.25,5,7.50,6.25,6.25,6.25,6.25,7.50,8.75,7.50,8.75,8.75,10,11.25,12.50,13.75,12.50,12.50,12.50,10,10,8.75,7.50,6.25,6.25,5,5,3.75,3.75,5,5,5,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,3.75,3.75,3.75,3.75,5,5,3.75,3.75,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,0.93,0.88,-0.65,-0.40,0.46,0.77,0.62,0.46,-0.63,-1.38,-2.75,-5.93,-7.75,-9.05,-9.93,-10,-11,-11,-12,-12,-11,-11,-13,-14,-16,-18,-16,-14,-14,-12,-7.76,-4.79,-4.48,-3,-2.79,-2.77,-2.77,-2.79,-3,-3.98,-6.79,-7.23,-4.03,-2.30,-1.52,-0.89,-0.28,0.30,1.05,1.65,2.02,2.64,3.42,4.21,5.14,5.93,4.84,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.35,1.71,3.89,4.22,3.90,4.52,3.59,3.43,3.72,3.53,3.53,3.27,3.89,4.93,6.25,4.98,5.10,6.09,5.90,7.28,5.88,3.75,4.03,4.84,5.14,5.62,5.61,5.25,4.52,3.43,2.30,1.25,1.25,1.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.21,6.13,6.07,5.92,5.72,5.47,5.29,5.14,5.02,5,5,5,5,5,5,5,5,5,5,5.09,5.15,5.34,5.57,5.78,6.05,6.27,6.55,6.82,7.02,7.22,7.45,7.62,7.80,7.98,8.26,8.53,8.78,9.09,9.38,9.67,9.87,10.14,10.30,10.93,11.09,11.50,12.27,12.67,13.87,14.84,14.98,15,15,15,15,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,12.50,11.25,11.25,10,7.50,6.25,5,3.75,2.92,1.71,0.62,-0.55,-1.84,-3.65,-5.22,-6.43,-7.25,-7.76,-8.40,-10,-12,-14,-12,-9.25,-6.05,-5.91,-4.75,-3.77,-2.80,-1.38,-1.29,-1.27,-1.38,-2.90,-4.03,-5.77,-8.47,-11,-13,-15,-14,-10,-8.13,-6.17,-4.38,-2.63,-0.78,0.46,2.28,4.05,5.77,7.50,8.75,11.25,13.75,17.50,20,17.50,15,10,7.50,6.25,6.25,7.50,7.50,7.50,7.50,7.50,8.75,8.75,8.75,8.75,10,11.25,12.50,13.75,13.75,13.75,12.50,11.25,10,8.75,7.50,7.50,6.25,6.25,5,5,3.75,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,3.75,3.75,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,0.92,-0.67,0.46,0.73,0.93,1.03,0.76,0.13,-0.75,-1.62,-3.79,-6.61,-8.18,-8.63,-9.54,-10,-12,-14,-16,-16,-16,-15,-15,-15,-16,-13,-10,-9.27,-6.05,-2.28,-1.50,-1.13,-1.38,-1.38,-1.13,-1.25,-1.30,-2.13,-3.75,-4.78,-8,-10,-5.86,-2.39,-2,-1.50,-1,-0.50,0,0.46,1.23,2.15,3.05,3.84,4.05,4.68,1.39,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.54,2.64,1.67,1.87,2.50,2.65,2.64,2.34,2.34,2.64,3.25,3.72,4.04,3.75,2.93,2.02,2.76,6.03,2.63,1.84,2.30,2.50,2.34,2.34,2.89,3.12,2.50,1.71,1.25,1.25,1.25,1.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.22,6.18,6.09,5.92,5.72,5.47,5.29,5.14,5.02,5,5,5,5,5,5,5,5,5,5,5,5.01,5.12,5.26,5.45,5.64,5.93,6.18,6.40,6.68,6.88,7.12,7.32,7.48,7.64,7.80,8.05,8.28,8.59,8.89,9.18,9.46,9.68,9.85,10.11,10.28,10.29,11.09,11.50,12.50,13.54,14.82,14.98,15.11,15.03,15,15,15,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,11.25,10,10,7.50,6.25,6.25,5,4,2.95,1.80,0.59,-0.64,-2.50,-4.11,-5.49,-6.53,-7.25,-7.25,-8.80,-12,-14,-14,-10,-6.25,-5.39,-4.22,-3.41,-2.48,-1.38,0.72,0.72,-1.13,-2.13,-3.10,-4.23,-6.27,-8.11,-9.64,-10,-10,-9.73,-8.63,-7.51,-5.93,-4.35,-2.65,-0.92,0.77,2.30,4.51,7.50,8.75,10,12.50,16.25,18.75,13.75,12.50,10,7.50,6.25,5,6.25,8.75,10,8.75,8.75,8.75,10,10,10,11.25,13.75,12.50,12.50,12.50,11.25,11.25,10,8.75,7.50,7.50,7.50,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,5,3.75,3.75,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,2.34,1.09,0.92,0.77,1.02,1.09,1.09,0.93,0.45,-0.15,-0.88,-1.76,-4.38,-6.22,-6.63,-8.12,-9.88,-12,-15,-18,-18,-16,-15,-13,-11,-10,-8,-5.01,-2.67,-1.50,-0.89,-0.52,0.93,-0.28,-0.34,0.73,0.73,-0.63,-1.38,-2.25,-3.89,-6.76,-10,-8.92,-4.75,-3.55,-2.27,-1.91,-1.50,-1.17,-0.65,0,0.93,1.84,2.34,1.70,1.55,1.50,1.25,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.53,1.72,1.71,1.40,1.71,3.75,3.27,3.25,3.25,2.96,2.43,1.52,2.77,3.75,2.92,1.55,1.55,1.39,1.84,2.34,2.64,2.64,2.43,1.82,1.25,1.25,1.25,1.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.21,6.10,5.95,5.76,5.48,5.29,5.14,5.02,5,5,5,5,5,5,5,5,5,5,5,5,5,5.03,5.14,5.30,5.55,5.78,6.05,6.27,6.53,6.73,6.98,7.18,7.34,7.50,7.65,7.85,8.12,8.39,8.68,8.92,9.21,9.48,9.70,9.87,10,10.30,10.93,11.52,12.22,12.70,13.88,16.09,15.13,16.12,15.01,15,15,13.75,13.75,13.75,13.75,13.75,13.75,13.75,12.50,11.25,11.25,10,8.75,7.50,7.50,6.25,5.14,4.05,2.96,1.70,0.30,-1.41,-3.09,-4.61,-5.75,-6.74,-7.88,-9.72,-12,-14,-15,-13,-8.55,-6.36,-4.90,-3.75,-2.75,-1.50,-0.64,0.72,-1,-2.03,-2.75,-3.36,-4.63,-5.97,-6.88,-7.49,-7.87,-8.40,-8.72,-8.53,-7.48,-6.09,-4.49,-2.73,-0.63,0.89,2.80,6.25,8.75,8.75,11.25,12.50,13.75,13.75,8.75,7.50,7.50,5,5,5,7.50,10,10,8.75,8.75,10,11.25,11.25,13.75,13.75,13.75,12.50,12.50,11.25,10,10,8.75,8.75,7.50,7.50,7.50,6.25,5,5,5,5,6.25,6.25,6.25,6.25,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,6.25,6.25,5,5,5,3.75,3.75,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.35,1.20,1.09,1.09,1.20,1.21,1.09,0.76,0.28,-0.38,-1.13,-2,-3.92,-5.03,-6.51,-8.40,-10,-14,-16,-15,-14,-11,-9.18,-7.63,-5.64,-3.75,-1.30,-0.88,-0.50,0.11,1.09,0.93,0.30,0.10,0.71,0.71,0.73,-0.88,-1.65,-2.17,-2.50,-5.61,-7.73,-7.79,-6.13,-4.26,-3.75,-2.38,-2,-1.42,-0.75,-0.01,0.62,1.09,1.39,1.55,1.53,2.50,3.75,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,2.50,4.02,3.75,2.64,2.64,2.43,1.82,1.36,1.72,2.92,1.87,2.28,4.37,2.34,2.48,2.96,3.27,3.27,3.05,2.96,0.14,-0.13,1.71,1.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.22,6.20,6.07,5.87,5.59,5.30,5.14,5.02,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.01,5.12,5.26,5.45,5.65,5.93,6.13,6.39,6.59,6.85,7.04,7.27,7.43,7.53,7.75,7.96,8.22,8.46,8.75,9,9.22,9.53,9.79,9.98,10.27,10.93,11.23,11.52,12.22,12.68,13.89,14.98,15.11,15.09,15,15,15,13.75,13.75,13.75,13.75,13.75,13.75,12.50,12.50,12.50,11.25,10,10,8.75,7.50,6.55,5.30,3.89,2.50,0.93,-0.50,-2.12,-3.68,-5.01,-6.29,-7.72,-9.72,-12,-15,-15,-13,-9.78,-7.27,-5.53,-4.13,-3.15,-2.54,-1.38,-1.27,-1.38,-2.25,-2.80,-3.10,-3.61,-4.25,-5.03,-5.63,-6.22,-7.13,-8.79,-9.64,-8.42,-7.73,-6.24,-4.75,-3,-1.10,1.18,2.64,5.12,6.96,7.50,7.50,10,7.50,5,5,5,3.75,2.50,3.75,5,7.50,10,8.75,10,10,11.25,11.25,11.25,13.75,13.75,13.75,12.50,11.25,11.25,11.25,10,10,10,8.75,8.75,6.25,5,5,5,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,6.25,6.25,6.25,5,5,5,3.75,3.75,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.22,1.22,1.23,1.20,1.03,0.62,-0.03,-0.63,-1.29,-2.04,-3.50,-4.93,-6.79,-8.68,-10,-11,-12,-9.86,-7.86,-5.42,-4.01,-2.39,-1.16,-0.37,-0.01,0.59,1.09,2.43,0.93,0.12,0.30,-0.63,-0.63,0.73,-0.25,-1,-1.50,-1.75,-3.02,-4.30,-6.53,-7.88,-8.16,-6.88,-3.88,-2.63,-2,-1.27,-0.63,-0.13,0.12,0.93,2.02,2.34,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.53,2.50,1.71,1.82,1.82,1.50,1.25,1.36,1.52,1.55,1.70,4.50,6.25,4.84,2.77,3.27,3.57,3.59,4.52,5.15,2.35,4.21,3.60,2.35,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.21,6.12,5.97,5.76,5.46,5.18,5.03,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.01,5.09,5.15,5.32,5.59,5.79,6.05,6.25,6.50,6.71,6.96,7.17,7.34,7.48,7.63,7.80,8.05,8.28,8.55,8.76,9.01,9.23,9.62,9.84,10.13,10.30,10.93,11.25,11.51,12.34,13.54,14.84,14.84,15.10,16.21,15,15,15,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,12.50,11.25,10,8.75,10,7.96,6.55,5,3.43,1.71,-0.02,-1.16,-2.29,-4.26,-5.67,-7.37,-9.50,-12,-15,-16,-15,-10,-8.41,-6.78,-5.25,-3.98,-3.04,-2.75,-2.17,-2.25,-2.89,-3,-3,-2.59,-2.88,-3.59,-4.14,-5.01,-5.98,-7.01,-8,-8.63,-8.66,-7.93,-6.99,-5.54,-3.52,-0.75,0.93,2.50,3.89,4.47,4.84,4.46,3.12,2.63,2.18,1.82,1.54,1.64,2.13,3.59,5,7.50,8.75,10,11.25,11.25,12.50,12.50,15,15,13.75,12.50,12.50,12.50,11.25,11.25,10,8.75,8.75,7.50,6.25,6.25,5,6.25,6.25,7.50,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,6.25,6.25,6.25,5,3.75,3.75,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.23,1.09,0.93,0.30,-0.25,-0.90,-1.63,-2.47,-3.65,-5.05,-6.36,-7.22,-7.66,-7.25,-6.25,-4.85,-3.04,-1.62,-0.48,0.02,0.62,0.93,1.39,2.34,1.25,1.38,1.05,0.77,0.73,-0.63,0.77,0.14,-0.25,-0.63,-0.88,-1.18,-1.75,-4.25,-8.52,-8.97,-6,-3.99,-2.78,-2.16,-1.51,-0.88,-0.41,-0.38,1.09,2.15,2.75,3.75,3.75,3.75,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.39,1.55,1.55,2.18,4.35,2.61,2.65,3.27,3.59,4.05,5.77,6.39,6.05,5.42,4.80,3.60,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.21,6.13,6.07,5.89,5.62,5.32,5.14,5.01,5,5,5,5,5,5,5,5,5.01,5.03,5.09,5.10,5.10,5.10,5.09,5.09,5.10,5.14,5.28,5.46,5.72,5.93,6.18,6.38,6.57,6.84,7.02,7.21,7.36,7.51,7.67,7.90,8.12,8.37,8.59,8.75,8.93,9.15,9.62,9.84,10.13,10.30,10.93,11.25,11.50,12.68,13.87,14.84,15.11,16.13,16.22,15,15,15,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,12.50,11.25,10,11.25,9.95,7.62,6.25,4.62,2.78,0.89,-0.75,-1.88,-3.51,-4.98,-6.72,-8.85,-11,-14,-15,-13,-11,-9.85,-8.04,-6.28,-4.60,-3.49,-3,-3,-3,-2.88,-2.76,-1.30,-1.30,-1.65,-2.38,-3,-3.86,-4.66,-5.63,-6.75,-8.25,-9.25,-9.78,-9.63,-8.41,-6.22,-3.62,-0.88,0.55,1.39,2.18,2.34,1.98,1.25,0.40,0,-0.38,-0.26,0.11,0.77,2,3.75,5,7.50,8.75,11.25,11.25,12.50,15,15,13.75,13.75,12.50,12.50,11.25,11.25,10,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,7.50,6.25,6.25,7.50,6.25,5,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.23,1.20,1.09,0.62,0.11,-0.52,-1.25,-1.88,-2.39,-3.55,-4.29,-4.65,-4.67,-3.98,-3.35,-2.26,-1.26,-0.53,0.14,0.93,1.35,1.25,2.50,2.50,2.50,2.34,1.52,1.21,1.05,1.04,1.03,0.75,0.46,0.29,0.12,-0.38,-1.25,-4.84,-7.50,-5.99,-4.97,-4.02,-2.75,-2.53,-1.38,-0.64,-0.39,0.77,1.55,2.76,3.59,3.75,3.75,5,3.75,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,2.18,5.30,2.29,1.52,1.52,1.39,1.55,2.43,3.05,3.28,4.52,6.09,6.68,6.25,5.93,5.30,4.21,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.22,6.18,6.09,5.93,5.72,5.46,5.25,5.10,5,5,5,5,5,5,5,5.01,5.09,5.12,5.14,5.18,5.25,5.25,5.25,5.18,5.14,5.14,5.14,5.26,5.42,5.62,5.87,6.09,6.26,6.50,6.70,6.88,7.12,7.29,7.45,7.60,7.77,7.96,8.14,8.37,8.55,8.68,8.89,9.14,9.62,9.84,10.14,10.30,10.93,11.38,12.27,13.54,13.89,15.12,16.12,16.21,16.25,15,15,13.75,13.75,13.75,13.75,13.75,13.75,15,15,12.50,11.25,11.25,11.25,11.25,8.75,7.64,5.77,3.75,1.64,-0.26,-1.63,-2.63,-4.14,-5.75,-7.80,-10,-13,-14,-15,-13,-11,-9.40,-7.22,-5.40,-4,-3.25,-3,-3,-2.76,-2.64,-1.05,0.73,-0.64,-1.38,-2.10,-2.86,-3.86,-4.88,-6.09,-7.67,-10,-11,-11,-10,-8.27,-5.54,-3.13,-1.27,-0.16,0.28,0.42,0.13,-0.38,-0.77,-1.16,-1.54,-1.38,-0.91,-0.38,0.71,1.25,3.75,5,6.25,7.50,8.75,12.50,13.75,13.75,13.75,13.75,12.50,12.50,11.25,10,8.75,7.50,7.50,7.50,6.25,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,7.50,7.50,7.50,6.25,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.23,1.23,1.23,0.89,0.39,-0.25,-0.88,-1.41,-1.75,-2.14,-2.88,-2.67,-2.52,-2,-1.40,-0.77,-0.38,0,0.62,1.18,1.37,2.50,2.50,2.50,2.50,2.50,1.39,1.39,1.53,2.18,1.39,1.02,0.92,0.88,0.77,0.10,-2.84,-7.73,-6.55,-3.98,-4.75,-3.67,-2.75,-1.38,-0.55,0.62,1.09,1.71,3.43,3.59,3.75,3.75,3.75,3.75,3.75,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.39,5.46,7.96,5.15,1.36,1.36,1.25,1.25,1.82,2.48,2.80,4.01,5.57,6.09,5.93,5.89,5.30,4.21,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.21,6.11,5.96,5.76,5.47,5.28,5.13,5.01,5,5,5,5,5,5,5.01,5.10,5.14,5.27,5.32,5.42,5.45,5.46,5.45,5.40,5.32,5.27,5.20,5.25,5.34,5.55,5.77,5.96,6.20,6.37,6.55,6.75,6.98,7.18,7.34,7.50,7.64,7.79,7.96,8.12,8.29,8.52,8.68,8.89,9.14,9.68,9.98,10.14,10.29,10.95,11.50,12.63,13.59,14.84,16.12,16.23,16.23,16.25,15,15,13.75,13.75,13.75,13.75,13.75,15,13.75,12.50,11.25,11.25,12.50,12.50,11.25,8.89,6.87,4.52,2.34,0.27,-1.15,-2.17,-3.37,-4.88,-6.75,-9,-11,-13,-14,-13,-12,-10,-7.87,-5.86,-4.18,-3.30,-3,-3,-2.75,-1.41,-0.53,0.61,0.61,-0.63,-1.13,-2.05,-3.09,-4.18,-5.59,-7.88,-10,-12,-14,-13,-10,-7,-4.89,-3.50,-2.68,-2.38,-2.14,-1.75,-1.76,-1.67,-2,-2.29,-2.13,-1.64,-1.13,-0.38,0.46,1.39,1.25,3.75,5,6.25,8.75,8.75,8.75,11.25,12.50,13.75,12.50,11.25,10,8.75,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,6.25,5,5,5,6.25,6.25,7.50,7.50,7.50,6.25,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.23,1.23,1.23,1.02,0.57,0,-0.43,-0.88,-1.17,-1.38,-1.26,-1.02,-0.88,-0.67,-0.39,-0.13,0.30,0.77,1.09,1.37,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,2.50,2.50,1.25,0.62,0.28,0.14,0.11,-2.37,-5.91,-6.88,-5.63,-3.90,-2.90,-2,-1.25,-0.75,0.90,1.51,2.34,3.59,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,2.18,5.15,2.02,1.25,1.25,1.25,1.25,1.25,1.54,1.87,2.45,4.04,4.85,5.42,5.30,4.80,3.60,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.20,6.09,5.88,5.59,5.30,5.13,5.02,5,5,5,5,5,5,5.01,5.10,5.15,5.30,5.46,5.57,5.62,5.65,5.71,5.65,5.62,5.51,5.43,5.30,5.28,5.30,5.46,5.65,5.92,6.09,6.25,6.42,6.64,6.87,7.05,7.29,7.43,7.51,7.64,7.77,7.90,8.05,8.28,8.54,8.75,9.03,9.62,9.82,9.98,10.14,10.28,11.25,12.27,12.65,13.89,15.11,17.38,16.25,16.25,16.25,15,15,13.75,13.75,13.75,13.75,15,15,12.50,11.25,11.25,12.50,13.75,12.50,9.32,7.80,5.30,2.96,0.77,-0.88,-2,-2.84,-4.02,-5.62,-7.62,-9.61,-11,-11,-12,-11,-10,-8.27,-6.29,-5.03,-3.97,-3.38,-3.02,-2.75,-1.25,0.62,0.77,0.77,0.62,-0.88,-1.15,-2.52,-3.74,-5.28,-7.59,-10,-12,-14,-14,-10,-7.77,-6.13,-5.16,-4.74,-4.50,-4.38,-3.89,-3.52,-3.29,-3.11,-2.67,-2.50,-2.13,-1.75,-1.05,-0.54,-0.03,1.25,2.50,3.75,5,6.25,6.25,7.50,8.75,10,11.25,11.25,11.25,8.75,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,7.50,7.50,7.50,5,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.09,0.73,0.30,-0.04,-0.38,-0.64,-0.63,-0.38,0.62,-0.03,0,0.39,0.73,1.09,1.38,2.34,1.25,1.25,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,-0.42,-0.63,-0.77,-1.93,-7.25,-7.61,-3,-3.23,-3.01,-1.67,-0.92,-0.80,1.02,1.38,2.34,3.59,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,2.47,3.68,4.21,4.21,3.60,2.35,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.22,6.13,6.03,5.77,5.46,5.17,5.03,5,5,5,5,5,5,5,5.10,5.17,5.30,5.48,5.64,5.77,5.89,5.93,5.93,5.92,5.82,5.75,5.60,5.46,5.34,5.34,5.46,5.63,5.87,6.05,6.22,6.37,6.55,6.76,7.02,7.21,7.36,7.48,7.52,7.62,7.67,7.80,7.98,8.28,8.59,8.88,9.14,9.63,9.82,10,10.28,10.95,11.45,12.34,13.59,14.85,15.09,16.22,17.50,16.25,16.25,15,13.75,13.75,13.75,13.75,13.75,12.50,12.50,11.25,11.25,12.50,13.75,13.75,10,8.59,6.20,3.72,1.34,-0.50,-1.68,-2.77,-3.30,-4.63,-6.40,-8.11,-9.38,-9.80,-9.73,-9.59,-10,-8.80,-7.11,-5.91,-4.64,-3.87,-3.27,-2.76,-1.13,0.73,1.84,0.77,0.71,0.93,-1.13,-2.24,-3.27,-4.67,-6.79,-9.25,-11,-12,-12,-9.86,-7.76,-6.97,-6.50,-6.36,-6.28,-6.25,-5.61,-4.97,-4.49,-4.02,-3.54,-3.03,-2.50,-2.13,-1.54,-1,-0.13,1.25,2.50,3.75,3.75,5,5,6.25,6.25,7.50,8.75,8.75,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,6.25,5,5,5,5,5,5,5,5,5,5,6.25,6.25,7.50,7.50,6.25,5,3.75,3.75,3.75,5,5,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.23,0.93,0.77,0.59,0.09,-0.14,-0.25,0.77,0.77,0.77,0.87,0.93,1.36,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,2.34,0.93,-0.77,-0.77,-1.25,-1.63,-2.88,-5.18,-11,-8.99,-1.93,-1.88,-1.50,-0.88,0,0.77,1.25,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.71,2.35,2.35,1.71,1.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.20,6.09,5.90,5.62,5.32,5.13,5,5,5,5,5,5,5,5.03,5.14,5.30,5.50,5.73,5.90,6.04,6.09,6.11,6.11,6.09,6.04,5.92,5.77,5.62,5.48,5.46,5.51,5.65,5.88,6.04,6.20,6.34,6.51,6.71,6.98,7.18,7.34,7.45,7.48,7.50,7.53,7.62,7.75,7.95,8.28,8.59,8.88,9.10,9.63,9.84,10.13,10.28,11.09,11.43,12.63,13.59,13.85,15.01,16.25,17.50,17.50,15,13.75,13.75,13.75,13.75,12.50,12.50,11.25,11.25,11.25,11.25,12.50,15,11.25,9.36,7.30,4.67,1.87,-0.14,-1.25,-2,-2.93,-4.13,-5.60,-7,-8.03,-8.40,-7.13,-9.52,-10,-9.54,-9,-7.18,-5.92,-5.12,-4.11,-2.78,-1.38,0.87,0.72,0.73,-0.68,-0.80,-1.17,-2.13,-3,-4.05,-5.63,-7.78,-9.66,-10,-10,-7.89,-7.54,-7.50,-7.61,-7.63,-7.74,-7.63,-6.87,-6.15,-5.51,-4.91,-4.28,-3.61,-2.89,-2.54,-1.91,-1.05,-0.01,1.38,2.50,2.50,3.75,3.75,5,5,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,6.25,6.25,7.50,7.50,6.25,5,3.75,5,5,5,5,5,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,-1,1.09,0.93,1.09,1.18,1.18,1.22,1.25,1.39,0.51,0.01,0.01,1.09,-0.80,-0.77,-0.62,0.21,0.26,0.40,0.93,0.39,-0.86,-2.78,-5.65,-6.55,-6.63,-9.24,-9.65,-5.87,-1.63,-1.14,-0.63,-0.04,0.73,1.55,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,3.75,3.75,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.22,6.12,5.97,5.76,5.46,5.20,5.09,5,5,5,5,5,5,5,5.12,5.28,5.47,5.75,5.95,6.13,6.26,6.35,6.35,6.28,6.25,6.21,6.09,5.93,5.78,5.71,5.64,5.72,5.78,5.93,6.09,6.20,6.27,6.42,6.67,6.88,7.14,7.30,7.38,7.46,7.48,7.50,7.50,7.51,7.65,7.93,8.28,8.59,8.88,9.09,9.65,9.84,10.28,10.97,11.25,11.39,12.50,13.62,13.76,15,16.25,17.50,15,13.75,13.75,13.75,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,9.80,5.93,2.64,0.45,-0.52,-1.42,-2.38,-3.60,-4.92,-6.28,-7.39,-7.97,-8.54,-9.01,-10,-10,-9.75,-8.63,-7.50,-6.40,-5.13,-3.63,-2.13,-1,-0.90,-0.88,1.03,-0.88,-1.88,-1.90,-3,-3.38,-4.63,-6.61,-8.48,-9.91,-9.90,-7.66,-7.40,-8.25,-8.26,-8.65,-8.76,-8.53,-7.87,-7.16,-6.49,-5.75,-4.89,-4.05,-3.29,-2.62,-2,-1.03,0.09,1.64,2.50,2.50,2.50,3.75,5,6.25,6.25,6.25,7.50,6.25,6.25,7.50,7.50,7.50,6.25,7.50,7.50,7.50,8.75,8.75,8.75,8.75,8.75,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,6.25,7.50,6.25,5,6.25,6.25,6.25,5,5,5,5,6.25,6.25,6.25,6.25,5,3.75,3.75,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,0.60,0.21,0.11,0.20,0.93,0.62,-0.61,-2.84,-3.75,-4.64,-3.61,-1.29,-3.84,-4.41,-6.29,-13,-13,-6.63,-6.74,-4.43,-1.66,-1.13,-0.50,0.14,0.77,1.39,2.02,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,1.25,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.23,1.23,1.23,1.23,1.23,1.23,1.23,1.23,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.22,6.12,5.90,5.59,5.30,5.12,5.01,5,5,5,5,5,5,5,5.14,5.39,5.63,5.93,6.23,6.40,6.54,6.55,6.55,6.52,6.42,6.38,6.25,6.12,6.03,5.93,5.93,5.93,6.02,6.09,6.12,6.21,6.26,6.39,6.57,6.84,7.03,7.21,7.34,7.43,7.47,7.48,7.48,7.50,7.50,7.64,7.93,8.29,8.59,8.89,9.07,9.68,10.13,10.25,11.03,11.38,11.39,12.37,12.53,13.75,16.25,15,16.25,15,13.75,13.75,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,9.98,8.59,2.80,1.71,0.25,-1,-2.05,-3.22,-4.54,-5.99,-7.27,-8.17,-8.73,-9.63,-10,-10,-11,-10,-8.88,-7.73,-6.16,-4.76,-3.50,-2.54,-2,-1.13,-1.13,-0.75,-1,-1.38,-2.01,-3.09,-4.37,-6,-7.67,-9.25,-8.53,-8.25,-8.09,-8.25,-9.18,-9.75,-9.88,-9.38,-8.63,-8.13,-7.38,-6.53,-5.49,-4.50,-3.60,-2.79,-2,-1.04,0.12,1.53,2.50,2.50,3.75,5,6.25,7.50,8.75,8.75,10,11.25,8.75,8.75,8.75,7.50,7.50,7.50,8.75,10,10,11.25,11.25,12.50,10,10,8.75,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,6.25,6.25,6.25,5,5,5,5,5,5,6.25,6.25,7.50,6.25,6.25,6.25,5,5,5,5,6.25,6.25,6.25,6.25,6.25,5,5,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,0.39,0.14,-0.12,-0.25,0.89,1.04,0.15,-1.61,-5.59,-5.50,-6.61,-5.39,-4.75,-8.49,-7.04,-8,-14,-16,-7.97,-2.41,-1.78,-1.13,-0.50,0.25,1.05,1.70,2.18,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.23,1.22,1.22,1.22,1.22,1.22,1.22,1.22,1.23,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.22,6.12,5.80,5.46,5.14,5.01,5,5,5,5,5,5,5,5.01,5.18,5.46,5.79,6.18,6.50,6.71,6.82,6.84,6.80,6.72,6.68,6.55,6.45,6.37,6.25,6.22,6.22,6.23,6.25,6.25,6.25,6.25,6.26,6.37,6.52,6.71,6.96,7.15,7.30,7.37,7.46,7.47,7.48,7.48,7.50,7.50,7.64,7.92,8.43,8.75,9.07,9.68,9.98,10.26,11.02,11.09,11.38,11.36,12.43,12.50,13.75,15,15,15,15,13.75,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,12.50,10,6.25,3.27,1.09,-0.63,-1.79,-2.89,-4.41,-5.99,-7.26,-8.18,-8.84,-8.85,-9.26,-10,-10,-9.84,-10,-8.59,-7.11,-5.88,-4.76,-3.78,-3,-3,-1.78,-0.88,0.77,-0.63,-1.38,-2.60,-3.88,-5.51,-7.14,-8.68,-8.15,-8.02,-8.51,-9.27,-10,-10,-10,-9.97,-9.68,-9.11,-8.28,-7.25,-6,-4.84,-3.77,-2.90,-2.25,-1.14,0.12,1.55,2.50,3.75,5,6.25,8.75,10,11.25,11.25,11.25,12.50,12.50,11.25,10,10,8.75,8.75,7.50,8.75,10,10,12.50,12.50,12.50,12.50,10,10,8.75,7.50,6.25,6.25,6.25,7.50,7.50,8.75,8.75,7.50,7.50,6.25,6.25,5,5,5,5,5,6.25,7.50,6.25,6.25,6.25,6.25,5,5,5,6.25,6.25,6.25,7.50,7.50,6.25,6.25,5,5,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.09,-0.80,-0.14,-0.25,-0.30,-0.39,0.77,0.46,-1,-3.51,-3.86,-1.84,-1.76,-1.86,-4.79,-6.61,-5.03,-9.13,-13,-14,-7.35,-2,-1.25,-0.52,0.14,1.04,1.87,2.43,2.79,3.11,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.21,1.18,1.09,1.09,1.09,1.21,1.23,1.23,1.25,1.25,1.25,1.25,1.25,1.25,1.23,1.23,1.23,1.20,1.09,1.09,1.09,1.09,1.09,1.09,1.09,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.13,5.78,5.45,5.13,5.01,5,5,5,5,5,5,5,5.02,5.25,5.51,5.92,6.34,6.70,6.89,7.03,7.07,7.04,7.02,6.96,6.85,6.71,6.57,6.52,6.45,6.50,6.51,6.45,6.39,6.36,6.28,6.27,6.35,6.40,6.57,6.80,7.02,7.20,7.34,7.43,7.47,7.47,7.48,7.48,7.50,7.50,7.92,8.32,8.73,9.03,9.68,9.84,10.12,10.20,11.07,11.09,11.36,11.28,12.50,12.50,13.75,13.75,15,15,15,13.75,12.50,12.50,12.50,11.25,11.25,11.25,11.25,12.50,13.75,12.50,11.25,11.25,7.64,4.64,1.87,-0.14,-1.38,-2.25,-4.23,-5.99,-7.51,-8.36,-8.80,-8.79,-8.78,-9.41,-7.89,-8.92,-9.75,-8.75,-7.76,-6.88,-6.01,-5.22,-4.39,-3.62,-2.75,-0.90,0.72,0.72,-1.16,-2.40,-4,-5.43,-6.80,-7.75,-8.34,-7.93,-8.73,-10,-11,-12,-12,-12,-10,-10,-9.28,-8.05,-6.49,-5.11,-3.91,-2.99,-2.16,-1.17,0.09,1.86,3.75,5,6.25,10,11.25,11.25,12.50,12.50,13.75,13.75,13.75,11.25,12.50,12.50,12.50,8.75,8.75,10,10,10,10,10,12.50,11.25,11.25,11.25,11.25,8.75,7.50,7.50,6.25,7.50,8.75,10,10,8.75,7.50,7.50,6.25,6.25,5,5,5,5,6.25,6.25,5,5,5,5,5,5,5,6.25,6.25,6.25,7.50,7.50,8.75,6.25,6.25,5,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.37,1.21,0.46,-0.13,-0.50,-4.75,-4.92,-0.35,0.30,-0.10,-2.26,-3.38,-1.49,0.39,-0.38,0.14,-1.72,-2.28,-5.41,-10,-11,-6.88,-2.38,-1.38,-0.63,0.14,1.03,1.80,2.59,2.96,3.27,3.54,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.21,0.77,0.77,0.77,1.09,0.77,0.77,0.71,0.77,0.77,0.87,0.93,1.09,1.18,1.18,1.18,1.22,1.23,1.23,1.23,1.22,1.23,1.09,0.93,0.89,0.77,0.77,0.76,0.77,0.93,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.22,6.13,5.79,5.46,5.14,5.01,5,5,5,5,5,5,5,5.03,5.27,5.59,5.93,6.39,6.76,7.04,7.22,7.34,7.34,7.32,7.21,7.13,7,6.87,6.75,6.71,6.71,6.71,6.67,6.55,6.43,6.38,6.35,6.34,6.37,6.50,6.67,6.87,7.12,7.29,7.37,7.46,7.47,7.48,7.48,7.50,7.50,7.78,8.32,8.59,8.88,9.05,9.68,9.84,10.13,10.14,11.09,11.11,11.28,11.25,12.50,12.50,13.75,13.75,16.25,15,13.75,13.75,12.50,11.25,11.25,11.25,11.25,11.25,12.50,13.75,12.50,11.25,10,8.27,5.14,2.50,0.26,-0.88,-1.78,-3.91,-5.88,-7.54,-8.27,-8.80,-8.60,-8.30,-9,-8.15,-7.50,-8.78,-8.74,-8.24,-7.79,-7.22,-6.54,-5.77,-4.99,-3.91,-2.47,0.59,-0.63,-1.38,-2.72,-4.38,-5.74,-6.78,-7.61,-8.13,-7.38,-7.98,-10,-12,-14,-15,-14,-12,-10,-9.93,-8.63,-6.80,-5.24,-3.89,-2.89,-2.13,-1.13,0.30,2.46,5,6.25,7.50,11.25,12.50,12.50,12.50,13.75,16.25,16.25,16.25,18.75,20,16.25,11.25,12.50,12.50,11.25,12.50,11.25,12.50,10,10,10,10,12.50,12.50,11.25,8.75,7.50,7.50,7.50,8.75,10,8.75,8.75,7.50,7.50,7.50,5,5,5,5,5,6.25,5,5,5,5,5,6.25,5,5,5,6.25,6.25,6.25,7.50,7.50,7.50,6.25,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.39,1.35,1.07,0.46,-0.03,-0.67,-6.04,-5.55,-1.22,-1.04,-2.38,-2.50,-1.17,0.11,0.30,0.46,-0.13,-0.54,-1.03,-4.50,-8.17,-5.59,-2.13,-1.25,-0.75,0,1.03,1.71,2.45,3.10,3.42,3.59,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,3.75,3.75,5,3.75,3.75,3.75,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.22,1.18,1.09,1.09,0.87,0.45,0.13,-0.01,0.09,0.14,0,0,-0.13,-0.13,0,0.27,0.46,0.77,0.93,0.93,1.05,1.09,1.20,1.22,1.22,1.21,1.18,0.93,0.62,0.42,0.14,0.12,0,0,0.46,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.18,5.87,5.46,5.14,5,5,5,5,5,5,5,5,5.09,5.28,5.59,5.93,6.37,6.75,7.13,7.35,7.50,7.61,7.61,7.51,7.38,7.27,7.13,7.02,6.98,6.96,6.88,6.82,6.70,6.55,6.43,6.38,6.35,6.35,6.39,6.53,6.72,6.98,7.18,7.35,7.45,7.48,7.48,7.50,7.50,7.50,7.64,7.85,8.43,8.73,8.89,9.03,9.72,9.98,10.13,10.14,11.12,11.18,11.25,11.25,12.50,12.50,13.75,15,15,15,13.75,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,12.50,12.50,10,8.75,6.25,2.89,1.22,-0.29,-1.38,-3.47,-5.42,-7.13,-7.98,-8.50,-8.25,-7.77,-8.43,-8.55,-8.60,-8.40,-8.54,-8.68,-8.50,-8.25,-7.84,-6.92,-6.28,-5.47,-4.25,-2.98,-1.77,-2.55,-4,-5.17,-6.25,-7.05,-7.65,-8.13,-6.88,-8.29,-10,-13,-15,-16,-16,-14,-12,-10,-8.89,-6.92,-5.22,-3.77,-2.75,-2.13,-1,0.46,2.75,6.25,6.25,7.50,10,12.50,11.25,11.25,13.75,17.50,18.75,22.50,23.75,25,18.75,16.25,13.75,13.75,16.25,15,13.75,15,11.25,8.75,10,10,10,10,11.25,10,8.75,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,5,5,5,5,6.25,6.25,6.25,6.25,6.25,5,5,3.75,3.75,3.75,5,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.51,1.09,0.77,0.30,0,-2,-5.62,-6,-1.65,-3.75,-4.62,-1.25,0.11,0.77,0.77,0.62,0,-0.38,-0.75,-1.01,-3.13,-3.13,-1.02,-0.63,-0.13,0.77,1.71,2.34,2.96,3.52,3.72,3.89,3.75,3.75,3.75,3.75,5,3.75,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.21,1.18,0.89,0.73,0.72,0.59,0.14,-0.38,-0.64,-0.88,-0.88,-0.88,-0.88,-0.88,-0.91,-0.92,-0.75,-0.50,-0.25,0.10,0.45,0.46,0.77,0.93,1.09,1.20,1.09,1.09,1.09,0.62,0.14,-0.25,-0.51,-0.75,-0.88,-0.79,-0.27,6.25,6.25,6.25,6.25,6.25,6.26,6.26,6.25,6.23,6.18,5.95,5.47,5.14,5,5,5,5,5,5,5,5,5.10,5.27,5.55,5.89,6.27,6.70,7.05,7.38,7.65,7.80,7.84,7.80,7.65,7.50,7.34,7.22,7.18,7.13,7.02,6.88,6.73,6.60,6.51,6.39,6.36,6.28,6.34,6.39,6.59,6.87,7.14,7.34,7.45,7.50,7.50,7.50,7.50,7.50,7.51,7.85,8.38,8.72,8.75,9.03,9.72,9.97,10,10.13,10.10,11.21,11.25,11.25,11.25,11.25,12.50,13.75,15,15,13.75,13.75,12.50,12.50,12.50,11.25,10,10,11.25,11.25,12.50,10,8.75,6.25,4.52,2.32,0.46,-0.93,-2.60,-4.65,-6.29,-7.38,-7.90,-7.97,-7.40,-7.88,-9.50,-10,-9.42,-9.17,-9.63,-9.25,-8.54,-8.29,-7.61,-7.35,-6.90,-5.88,-5.05,-4.52,-4.62,-5.29,-6.22,-7,-7.50,-7.80,-7.89,-7.15,-8.41,-10,-13,-16,-16,-16,-14,-12,-10,-8.75,-6.84,-5.18,-3.79,-2.68,-1.75,-0.55,1.09,3.27,6.25,6.25,7.50,8.75,10,11.25,12.50,15,16.25,23.75,27.50,28.75,26.25,21.25,20,16.25,21.25,20,18.75,21.25,17.50,13.75,11.25,12.50,11.25,10,8.75,8.75,10,8.75,7.50,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,6.25,5,5,5,3.75,3.75,5,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.55,0.89,0.30,-0.03,-1.59,-4.60,-9.02,-13,-7.91,-4.72,-2.65,0.09,0.27,0.45,0.46,0.39,0.12,-0.14,-0.38,-0.53,-0.64,-0.63,-0.38,0,0.73,1.55,2.34,2.92,3.54,3.89,4.21,3.75,5,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.20,1.09,0.77,0.30,0,-0.13,-0.26,-0.67,-1.13,-1.50,-1.67,-1.77,-1.88,-1.75,-1.75,-1.77,-1.88,-1.54,-1.29,-1.03,-0.75,-0.38,-0.13,0.14,0.55,0.77,0.93,0.77,0.77,0.90,0.14,-0.38,-0.88,-1.27,-1.63,-1.78,-1.91,-1.50,6.25,6.25,6.25,6.25,6.26,7.43,6.28,6.25,6.23,6.21,6.09,5.35,5.11,5,5,5,5,5,5,5,5,5.09,5.26,5.47,5.80,6.21,6.59,7.02,7.43,7.78,8,8.10,8.05,7.90,7.68,7.51,7.38,7.32,7.22,7.13,6.97,6.76,6.60,6.51,6.39,6.35,6.26,6.26,6.35,6.51,6.80,7.12,7.34,7.46,7.50,7.64,7.64,7.78,7.64,7.79,7.85,8.43,8.72,8.75,9.03,9.72,9.97,9.98,9.98,10.10,10.01,10,10,10,11.25,12.50,12.50,13.75,15,13.75,13.75,13.75,12.50,11.25,11.25,10,10,10,11.25,12.50,10,10,8.75,5.93,3.52,1.22,-0.63,-2,-4.37,-5.73,-7,-7.73,-8,-7.84,-9.12,-11,-12,-11,-10,-9.15,-8.55,-8.13,-7.86,-7.49,-7.55,-7.59,-6.87,-6.25,-5.79,-5.99,-6.52,-7.30,-7.88,-8.09,-8,-7.49,-7.50,-8.13,-10,-12,-14,-15,-15,-13,-11,-9.88,-8.25,-6.52,-5.03,-3.75,-2.64,-1.50,-0.38,1.25,3.27,5,7.50,8.75,10,11.25,15,17.50,15,17.50,22.50,27.50,27.50,26.25,21.25,23.75,23.75,22.50,23.75,27.50,26.25,21.25,15,17.50,16.25,13.75,11.25,10,10,8.75,10,7.50,6.25,6.25,7.50,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,5,6.25,6.25,6.25,6.25,5,5,5,5,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.86,0.93,0.27,-0.17,-2.01,-5.93,-10,-15,-13,-6.62,-3.37,-1.42,0,0.14,0.14,0.14,0.12,0.09,0,-0.03,-0.02,0.11,0.40,0.90,1.55,2.34,2.80,3.52,3.75,5,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,1.25,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,0.88,0.62,0.12,-0.38,-0.66,-0.88,-1.13,-1.50,-1.79,-2.13,-2.38,-2.50,-2.54,-2.38,-2.38,-2.43,-2.50,-2.25,-2.04,-1.88,-1.63,-1.27,-0.88,-0.50,-0.13,0.10,0.14,0.10,0.10,0.14,-0.28,-0.93,-1.50,-2,-2.38,-2.51,-2.63,-3,6.25,6.25,6.25,6.25,6.28,6.34,6.34,6.25,6.23,6.23,6.11,5.17,5.02,5,5,5,5,5,5,5,5,5.09,5.18,5.45,5.76,6.09,6.53,6.98,7.43,7.82,8.13,8.27,8.23,8.07,7.82,7.64,7.50,7.38,7.32,7.18,7,6.75,6.57,6.43,6.37,6.28,6.25,6.25,6.26,6.39,6.60,6.97,7.22,7.45,7.50,7.64,8.27,7.80,8.29,7.89,8.38,8.57,8.72,8.89,9.02,9.77,9.97,9.97,9.98,9.98,9.98,10,10,10,10,11.25,12.50,13.75,13.75,15,13.75,13.75,12.50,11.25,10,10,8.75,10,11.25,12.50,11.25,10,10,7.45,4.67,1.96,-0.43,-1.75,-3.25,-5.14,-6.63,-7.63,-8.24,-9,-10,-11,-13,-13,-10,-8.79,-6.89,-6.39,-6.29,-6.51,-7.36,-7.84,-6.97,-6.42,-6.22,-6.53,-7.22,-7.89,-8.26,-8.17,-8.05,-7.38,-7.47,-8.53,-9.42,-10,-12,-13,-12,-11,-10,-9.16,-7.39,-6.24,-5.02,-3.87,-2.75,-1.53,-0.38,1.09,2.96,5,7.50,10,12.50,13.75,16.25,17.50,17.50,18.75,21.25,26.25,23.75,23.75,26.25,23.75,27.50,26.25,26.25,27.50,26.25,20,18.75,20,18.75,16.25,15,11.25,10,10,8.75,8.75,7.50,7.50,8.75,10,8.75,8.75,7.50,7.50,8.75,8.75,6.25,5,5,5,5,5,5,6.25,5,5,5,5,6.25,7.50,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.02,1.39,0.62,-0.05,-1.55,-4.42,-10,-15,-15,-11,-6.92,-3.87,-0.18,-0.18,-0.14,-0.13,0.13,0.30,0.45,0.59,0.72,0.92,1.21,1.64,2.30,2.95,3.59,3.59,3.75,3.75,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.23,0.89,0.39,-0.13,-0.63,-1.02,-1.38,-1.63,-1.88,-2.16,-2.38,-2.63,-2.75,-2.88,-2.88,-2.85,-3.29,-3.66,-3.30,-3.55,-4.22,-3.38,-2.38,-2.13,-1.50,-1.04,-0.80,-0.75,-0.78,-0.88,-0.88,-0.92,-1.16,-1.55,-2,-2.50,-2.75,-2.88,-2.89,-2.91,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.09,5.13,5,5,5,5,5,5,5,5,5,5.02,5.14,5.35,5.62,5.97,6.39,6.88,7.38,7.89,8.25,8.38,8.30,8.13,7.93,7.68,7.52,7.46,7.34,7.18,6.98,6.72,6.54,6.39,6.34,6.25,6.25,6.25,6.25,6.34,6.43,6.71,7.02,7.30,7.47,7.62,7.64,7.78,7.79,8.37,8.38,8.43,8.59,8.88,9.71,9.77,9.80,9.84,9.86,9.98,9.98,10,10,10,10,11.25,13.75,15,13.75,13.75,13.75,13.75,12.50,11.25,10,8.75,8.75,8.75,10,12.50,11.25,10,10,8.75,7.50,2.34,-0.50,-1.79,-2.63,-4.61,-6.16,-7.37,-8.25,-9.24,-10,-11,-12,-12,-10,-7.88,-6.85,-6.63,-6.22,-6.13,-6.49,-7.35,-6.77,-6.25,-6,-6.37,-7.49,-8.27,-8.13,-8.18,-7.10,-6.53,-7.18,-8.54,-9.48,-9.91,-10,-10,-10,-10,-9.85,-8.36,-6.59,-6.13,-5.04,-3.93,-2.89,-1.88,-0.88,0.46,2.43,5,7.50,11.25,12.50,15,17.50,21.25,22.50,22.50,25,25,25,23.75,22.50,25,27.50,26.25,23.75,25,27.50,26.25,22.50,20,22.50,20,15,13.75,11.25,10,8.75,8.75,8.75,8.75,11.25,11.25,11.25,10,10,8.75,10,10,7.50,6.25,5,5,5,5,5,5,5,5,5,5,6.25,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.29,1.87,1.34,0.61,-0.25,-1.13,-6.84,-11,-13,-12,-9.38,-6.97,-3.80,-1.38,-0.39,-0.25,0.14,0.55,0.88,1.09,1.39,1.55,1.85,2.14,2.62,3.09,3.75,3.75,3.75,3.75,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.09,0.57,-0.13,-0.75,-1.28,-1.63,-2,-2.25,-2.41,-2.63,-2.75,-2.88,-2.92,-3,-3.49,-4.75,-5.68,-5.17,-5.35,-6.30,-6.37,-7.63,-7.42,-5.99,-1.76,-1.25,-1.13,-1.25,-1.50,-1.63,-1.75,-1.88,-2.03,-2.25,-2.50,-2.67,-2.90,-3,-3,-2.88,6.25,6.25,6.25,6.34,6.35,6.36,6.25,6.25,6.25,6.23,6.09,5.14,5,5,5,5,5,5,5,5,5,5.01,5.13,5.29,5.51,5.88,6.34,6.85,7.36,7.89,8.27,8.43,8.38,8.15,7.96,7.70,7.53,7.47,7.35,7.18,6.98,6.71,6.51,6.36,6.26,6.25,6.25,6.25,6.25,6.25,6.26,6.40,6.68,7.02,7.04,7.18,7.34,7.50,7.63,7.77,7.82,7.80,8.43,8.59,8.88,8.93,8.89,8.89,9.87,9.93,9.98,10,10,10,10,10,11.25,13.75,13.75,12.50,12.50,13.75,12.50,11.25,8.75,8.75,7.50,8.75,10,11.25,10,10,8.75,10,8.75,2.64,-0.50,-1.66,-2.38,-4.04,-5.48,-6.73,-7.73,-8.61,-10,-10,-10,-10,-8.27,-7.23,-7.36,-7.29,-7.13,-7.25,-7.12,-6.86,-6.49,-6.03,-5.34,-5.72,-6.65,-7.17,-7.50,-7.13,-6.40,-6.29,-6.98,-8.36,-9.47,-9.98,-9.90,-9.59,-9.48,-9.97,-9.72,-8.99,-7.43,-6.47,-5.40,-4.38,-3.34,-2.36,-1.35,-0.25,1.39,3.75,6.25,10,12.50,15,20,23.75,25,25,25,25,22.50,20,18.75,20,21.25,23.75,22.50,21.25,26.25,28.75,26.25,23.75,25,22.50,16.25,15,12.50,11.25,8.75,8.75,8.75,8.75,10,11.25,10,10,10,8.75,8.75,8.75,7.50,6.25,5,5,5,5,6.25,5,5,6.25,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.46,2.28,1.97,1.37,0.61,-0.13,-1.02,-6.88,-10,-12,-12,-10,-8.27,-4.93,-1.38,-0.15,0.30,0.88,1.36,1.71,1.97,2.02,2.18,2.47,2.62,2.50,3.75,3.75,3.75,3.75,3.75,5,5,5,5,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.03,0.28,-0.50,-1.18,-1.78,-2.13,-2.38,-2.63,-3.16,-3.63,-3.35,-3,-3.02,-3.89,-6.13,-8.16,-8.25,-6.88,-6.99,-7.50,-7.18,-6.37,-5.88,-9.90,-12,-5.01,-1.50,-1.43,-1.75,-2.02,-2.13,-2.38,-2.53,-2.67,-2.75,-2.78,-3,-3,-3,-2.79,6.28,6.34,6.35,6.35,7.36,6.36,6.38,6.25,6.25,6.23,6.09,5.14,5,5,5,5,5,5,5,5,5,5,5.09,5.18,5.43,5.77,6.23,6.76,7.35,7.89,8.27,8.43,8.38,8.15,7.96,7.70,7.59,7.47,7.35,7.18,6.98,6.71,6.45,6.34,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.39,6.53,6.67,6.68,7.04,7.07,7.12,7.13,7.14,7.20,7.50,7.77,8.52,8.54,8.59,8.75,8.85,8.76,10,10,10,8.75,8.75,8.75,10,10,11.25,12.50,12.50,12.50,12.50,10,8.75,7.50,7.50,8.75,10,11.25,11.25,10,8.75,7.50,8.75,2.64,-0.13,-1.38,-2.14,-3.39,-4.88,-6.13,-7.10,-7.75,-7.67,-8.53,-8.64,-7.85,-7.10,-7.41,-7.68,-7.73,-8.13,-8.35,-8.16,-7.75,-7.38,-6.97,-6.52,-6.50,-6.73,-7,-6.77,-6.77,-6.75,-6.99,-7.10,-8.13,-9.17,-9.74,-9.75,-9.17,-9.25,-9.41,-9.93,-9.25,-8.75,-7.15,-5.88,-4.87,-3.85,-2.87,-1.91,-0.93,0.10,1.25,1.25,1.25,10,12.50,17.50,23.75,25,25,21.25,17.50,13.75,12.50,11.25,13.75,15,18.75,22.50,23.75,27.50,28.75,25,25,25,27.50,18.75,15,15,11.25,10,8.75,8.75,8.75,8.75,8.75,10,10,10,8.75,8.75,7.50,7.50,6.25,5,5,5,5,5,6.25,5,5,5,6.25,6.25,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,5,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,-0.17,-3.41,-7,-10,-12,-12,-10,-7.03,-2.22,-0.05,0.62,1.25,1.87,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.23,1.22,0.77,0,-0.75,-1.50,-2.13,-2.50,-2.65,-4.13,-6.68,-7.12,-5.29,-3.99,-4.78,-6.88,-9.09,-10,-10,-7.75,-6.37,-6.51,-6.38,-5.15,-2.75,-3.18,-2.87,-3.13,-4.38,-2.99,-1.52,-1.76,-1.88,-2.05,-2.28,-2.50,-2.52,-2.53,-2.75,-2.75,-2.75,-2.76,7.38,7.37,7.37,7.36,7.34,7.34,6.39,6.39,6.38,6.25,6.09,5.14,5.14,5,5,5,5,5,5,5,5,5,5.02,5.14,5.32,5.65,6.13,6.72,7.34,7.89,8.27,8.43,8.39,8.21,7.96,7.70,7.53,7.48,7.36,7.20,6.98,6.70,6.43,6.28,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.39,6.53,6.60,6.59,6.57,6.55,6.54,6.53,7.22,7.34,7.62,7.64,8.61,8.63,8.72,8.75,8.75,8.75,8.75,8.75,7.50,7.50,8.75,10,10,11.25,11.25,12.50,10,8.75,7.50,7.50,8.75,10,11.25,11.25,11.25,10,10,7.50,2.34,-0.02,-1.25,-2.02,-2.75,-4.26,-5.42,-6.36,-6.92,-6.90,-6.90,-6.55,-6.50,-6.79,-7.42,-7.75,-8.38,-8.90,-9.04,-8.88,-8.78,-8.50,-8.13,-8.18,-8.17,-8.15,-7.75,-7.48,-7.40,-7.88,-7.99,-7.74,-7.97,-8.38,-8.91,-8.97,-8.41,-8.34,-8.84,-9.15,-9.88,-9.74,-7.86,-6.54,-5.48,-4.55,-3.67,-2.84,-1.92,-1,-0.75,-0.75,1.39,1.38,8.75,15,22.50,23.75,20,15,11.25,8.75,7.50,7.50,7.50,8.75,12.50,18.75,21.25,26.25,27.50,25,23.75,26.25,23.75,23.75,17.50,16.25,12.50,10,8.75,8.75,7.50,7.50,8.75,8.75,10,10,10,8.75,7.50,7.50,6.25,6.25,5,5,5,5,5,5,5,5,5,6.25,6.25,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.35,0.92,-0.26,-4.25,-8.41,-11,-12,-11,-7.38,-1.88,-0.16,0.77,1.54,2.02,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.22,0.62,-0.13,-0.92,-1.64,-2.25,-2.63,-3.77,-7.78,-11,-11,-10,-8.29,-8.13,-9.49,-10,-10,-9.13,-6.50,-3.89,-3.63,-3.75,-2.38,-1.04,-0.75,-0.51,-0.40,-0.63,-0.93,-1,-1.13,-1.13,-1.25,-1.40,-1.80,-1.88,-1.88,-2,-2,-2.13,-2.76,7.60,7.61,7.61,7.63,7.63,7.64,7.50,7.34,6.39,6.38,6.09,6.07,5.14,5.14,5.14,5,5,5,5,5,5,5,5.02,5.12,5.30,5.62,6.11,6.71,7.34,7.90,8.27,8.43,8.39,8.21,7.96,7.75,7.53,7.48,7.36,7.21,6.98,6.70,6.42,6.27,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.38,6.45,6.42,6.39,7.34,7.50,7.51,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,8.75,10,10,10,8.75,7.50,7.50,7.50,8.75,11.25,13.75,12.50,12.50,12.50,11.25,7.50,2.34,-0.40,-1.38,-2.13,-2.63,-3.86,-4.90,-5.80,-6.50,-7.15,-6.86,-6.28,-6,-6.50,-7.34,-7.92,-8.80,-9.29,-9.43,-9.35,-9.48,-9.24,-9.29,-9.51,-9.50,-9.34,-8.91,-8.48,-8.15,-8.63,-8.77,-8.43,-7.75,-8.05,-8.13,-7.88,-7.38,-6.84,-7.55,-8.59,-10,-10,-8.64,-7.25,-6.11,-5.26,-4.53,-3.84,-3.05,-2.38,-1.75,-1.16,-0.67,1.25,1.25,12.50,21.25,21.25,15,10,7.50,7.50,6.25,6.25,6.25,6.25,7.50,11.25,15,17.50,21.25,20,20,21.25,26.25,23.75,22.50,18.75,16.25,12.50,10,8.75,8.75,7.50,7.50,8.75,8.75,10,10,10,8.75,7.50,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,6.25,6.25,6.25,7.50,7.50,8.75,6.25,5,5,5,5,6.25,6.25,5,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.50,1.09,0.77,-1.54,-5.92,-8.64,-11,-10,-7.13,-3.50,-1.40,0.30,1.21,2.46,2.50,1.25,1.25,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.46,2.34,2.34,2.18,1.84,1.25,1.07,0.40,-0.29,-1.05,-1.75,-2.38,-2.75,-5.26,-10,-15,-16,-14,-12,-11,-10,-9.49,-8.13,-6.04,-3.41,-2.12,-1.66,-1.12,-0.55,-0.26,-0.04,0.10,0.14,-0.13,-0.25,-0.28,-0.13,-0.13,-0.13,-0.25,-0.75,-0.88,-0.88,-0.75,-0.89,-1,-0.79,8.62,8.61,8.59,8.59,8.59,8.59,8.59,7.63,7.32,6.39,6.39,6.25,6.04,6.04,5.17,5.14,5,5,5,5.02,5.09,5.10,5.11,5.14,5.30,5.63,6.12,6.72,7.35,7.93,8.29,8.43,8.39,8.21,7.96,7.75,7.59,7.48,7.37,7.21,6.98,6.68,6.39,6.26,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.22,6.09,5.93,5.93,5.93,5.93,5.93,5.98,6.23,6.45,6.42,7.35,7.38,7.39,7.45,7.47,7.50,7.50,6.25,6.25,6.25,6.25,7.50,8.75,10,8.75,8.75,7.50,7.50,7.50,8.75,12.50,13.75,12.50,12.50,12.50,12.50,8.75,-0.05,-0.50,-1.30,-2.03,-2.63,-3.51,-4.39,-5.26,-6.02,-6.49,-6.63,-6.15,-6.12,-6.40,-7.26,-8.11,-8.92,-9.38,-9.52,-9.63,-9.78,-9.85,-10,-10,-10,-10,-9.63,-9.13,-9.04,-8.99,-9.12,-8.80,-8,-7.42,-7.48,-7.18,-6.50,-5.75,-5.53,-8.86,-10,-10,-9.61,-7.63,-6.54,-5.89,-5.37,-4.85,-4.26,-3.73,-3.13,-2.38,-1.25,-0.75,1.25,8.75,15,17.50,12.50,8.75,7.50,6.25,5,5,6.25,5,6.25,6.25,8.75,11.25,13.75,13.75,16.25,21.25,21.25,25,23.75,20,17.50,15,11.25,10,10,8.75,7.50,8.75,8.75,8.75,8.75,8.75,10,8.75,7.50,7.50,7.50,6.25,6.25,6.25,5,5,5,5,5,6.25,6.25,6.25,7.50,7.50,8.75,6.25,5,5,5,5,5,5,5,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.55,1.09,0.77,0.46,-3.89,-8.50,-13,-13,-8.75,-5.97,-3,-0.38,0.30,0.77,0.77,1.25,1.25,1.25,2.50,2.50,2.50,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,1.25,1.38,1.52,1.87,2.01,2.14,2.18,2.15,2.17,2.17,1.98,1.55,1.20,0.77,0.10,-0.52,-1.17,-1.88,-2.39,-3.15,-6.25,-11,-16,-17,-14,-12,-12,-10,-7.24,-4.50,-2.88,-1.80,-1.25,-0.68,-0.25,0.30,0.46,0.62,0.62,0.77,0.60,0.46,0.46,0.62,0.62,0.62,0.62,0.14,0.13,0.30,0.93,0.93,-0.79,1.04,8.86,8.88,9.84,9.84,8.89,8.87,8.57,7.64,7.50,7.29,7.29,6.42,6.42,6.37,6.04,5.17,5.17,5.17,5.17,5.28,5.34,5.27,5.25,5.29,5.46,5.73,6.21,6.73,7.36,7.95,8.30,8.45,8.38,8.13,7.93,7.71,7.59,7.47,7.36,7.20,6.97,6.68,6.42,6.27,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.22,6.07,5.93,5.30,5.34,5.32,5.32,5.30,5.30,5.92,5.95,6.10,6.38,6.40,6.39,6.37,6.35,6.29,6.26,6.25,6.25,6.25,5,6.25,7.50,7.50,8.75,8.75,7.50,7.50,7.50,10,12.50,13.75,12.50,12.50,13.75,13.75,10,2.77,0.30,-1.13,-2,-2.53,-3.16,-3.92,-4.76,-5.60,-6.25,-6.38,-6.60,-6.49,-6.25,-7,-7.88,-8.72,-9.16,-9.38,-9.54,-9.75,-10,-10,-10,-10,-10,-9.91,-9.60,-9.53,-9.39,-9.23,-8.67,-7.89,-7,-6.65,-6.13,-5.59,-5.73,-6.88,-7.92,-9.63,-9.79,-8.75,-7.48,-6.72,-6.38,-6.13,-5.85,-5.50,-5.12,-4.67,-4.09,-3.13,-1.88,-0.03,1.25,10,12.50,11.25,8.75,7.50,6.25,5,5,5,5,5,5,6.25,7.50,8.75,10,12.50,15,20,22.50,25,20,17.50,15,12.50,12.50,11.25,10,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,6.25,6.25,5,5,6.25,6.25,5,6.25,6.25,7.50,8.75,7.50,6.25,6.25,5,5,5,5,5,5,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.70,1.05,0.59,0.11,-2.63,-6.65,-10,-13,-11,-8.59,-5.49,-2.29,-0.40,-0.27,-0.39,-0.18,0,0.30,0.90,1.25,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.09,-0.77,0.57,1.09,1.39,1.71,1.86,1.71,1.71,1.55,1.50,1.25,0.77,0.30,-0.25,-0.78,-1.30,-1.79,-2.25,-3.41,-5.78,-9.63,-12,-12,-11,-10,-9.88,-7.93,-4.65,-2.50,-1.75,-1,-0.41,0,0.46,0.92,0.93,0.93,1.03,1.09,1.09,1.05,1.04,1.23,1.23,1.23,1.23,0.93,0.92,1.04,1.21,1.04,1.09,1.09,8.88,9.84,10.12,11.09,9.84,8.89,8.59,8.57,7.67,7.50,7.34,7.28,7.28,7.28,6.43,6.38,6.25,6.25,6.25,6.11,6.04,5.28,5.39,5.77,5.51,5.90,6.25,6.73,7.36,7.95,8.29,8.39,8.29,8.11,7.89,7.68,7.54,7.48,7.37,7.21,6.98,6.68,6.40,6.27,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.22,6.07,5.93,5.34,5.25,5.12,5.10,5.09,5.10,5.18,5.30,5.29,5.26,5.98,6.02,6.04,6.05,6.07,6.10,6.13,6.20,5,5,5,5,5,6.25,7.50,7.50,7.50,7.50,8.75,10,12.50,12.50,12.50,12.50,12.50,13.75,11.25,5.93,1.86,-0.63,-1.64,-2.38,-2.77,-3.49,-4.26,-5.15,-6.02,-7.15,-7.51,-7.04,-7.14,-6.65,-7.35,-8.22,-8.72,-8.90,-9.11,-9.50,-10,-10,-10,-10,-10,-9.85,-9.67,-9.62,-9.48,-9.27,-8.75,-7.78,-6.88,-6.79,-6.48,-6.16,-6.78,-7.88,-8.43,-8.38,-8.38,-7.40,-6.63,-6.41,-6.63,-6.97,-6.86,-6.73,-6.62,-6.50,-6.22,-5.48,-4.13,-2.38,-1.01,1.25,7.50,7.50,7.50,7.50,5,5,5,5,5,5,5,5,6.25,6.25,7.50,10,11.25,17.50,18.75,25,21.25,18.75,17.50,15,12.50,12.50,10,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,6.25,6.25,5,5,5,5,6.25,6.25,7.50,8.75,7.50,6.25,6.25,5,5,5,5,5,5,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.68,0.93,0.30,-0.26,-3.02,-6.15,-9.55,-14,-12,-10,-7.50,-3.89,-0.91,-1,-1.29,-1.15,-0.88,-0.39,0.29,1.34,2.50,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,1.25,0.93,0.30,-0.25,-0.50,-0.63,-0.75,-0.75,-0.50,0,0.47,1.07,1.22,1.09,1.07,0.93,0.93,0.77,0.30,-0.15,-0.68,-1.13,-1.50,-1.64,-2,-3,-5,-7.51,-10,-9.63,-7.63,-6.79,-6.09,-4.79,-2.86,-1.76,-1.13,-0.26,0.30,0.72,0.93,1.09,1.18,1.18,1.18,1.23,1.22,1.21,1.23,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,8.88,9.84,11.09,10.12,9.82,8.89,8.73,8.54,7.67,7.68,7.68,7.63,7.50,7.50,7.50,7.48,7.34,7.28,7.28,7.28,6.43,6.10,6.04,5.97,6.02,6.07,6.27,6.71,7.29,8.05,8.22,8.38,8.26,8.02,7.80,7.64,7.52,7.48,7.38,7.23,7,6.68,6.40,6.26,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.21,6.18,6.03,5.89,5.40,5.26,5.10,5.01,5,5,5.01,5.02,5.03,5.02,5.14,5.28,5.28,5.26,5.25,5.21,5.17,5.14,5.11,4.93,5,3.75,3.75,5,5,6.25,6.25,7.50,7.50,8.75,11.25,12.50,13.75,12.50,12.50,12.50,12.50,11.25,7.47,3.40,0.43,-1,-1.80,-2.41,-3.05,-3.88,-4.79,-5.77,-6.75,-7.66,-7.92,-7.60,-7.23,-6.65,-7.43,-7.93,-8.13,-8.25,-9.13,-9.88,-10,-10,-9.76,-9.73,-9.34,-9.37,-9.27,-9.22,-9.02,-8.49,-7.74,-8.22,-8.54,-8.16,-7.53,-7.38,-7.92,-8.93,-8.79,-8.13,-7.68,-6.60,-6.73,-7.91,-7.75,-7.89,-7.86,-8.11,-8.50,-8.63,-8.25,-6.38,-4.48,-2.43,-0.24,1.55,2.34,2.60,2.50,4.01,4.52,5,5,5,5,5,5,5,6.25,7.50,10,13.75,13.75,22.50,23.75,23.75,21.25,18.75,13.75,12.50,12.50,10,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,6.25,6.25,5,5,5,5,6.25,6.25,7.50,8.75,7.50,6.25,6.25,5,5,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.55,0.87,0.14,-0.55,-3,-5.75,-8.88,-12,-13,-12,-9.05,-4.88,-2.26,-2,-2.01,-2.13,-1.78,-1.13,-0.25,0.77,1.72,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,0.61,0.26,-0.25,-0.76,-1.38,-1.75,-1.88,-1.80,-1.68,-1.18,-0.75,-0.38,-0.13,0.14,0.28,0.30,0.30,0.28,0.14,-0.25,-0.63,-1.13,-1.38,-1.25,-0.91,-1.02,-1.61,-4.12,-7.17,-10,-9.84,-7,-4.39,-3.51,-2.67,-1.64,-1.05,-0.42,0.40,0.89,1.05,1.09,1.22,1.22,1.22,1.22,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,8.89,8.89,9.84,9.82,8.89,8.89,8.75,8.59,8.53,8.53,8.53,7.68,7.70,7.70,8.52,8.57,8.52,7.70,7.48,7.34,7.28,6.43,6.23,6.21,6.18,6.21,6.26,6.43,7.17,7.51,8.27,8.23,8.21,7.86,7.70,7.60,7.51,7.47,7.39,7.28,7.01,6.68,6.39,6.26,6.25,6.25,6.23,6.23,6.25,6.25,6.23,6.23,6.21,6.13,5.98,5.84,5.43,5.28,5.12,5.02,5,5,5,5,5,5,5,5,5,5,5,5,4.98,4.84,4.79,4.82,3.87,3.79,3.75,3.75,3.75,5,5,6.25,7.50,8.75,10,11.25,12.50,13.75,12.50,12.50,12.50,12.50,11.25,9.32,3.59,1.25,-0.50,-1.38,-2,-2.50,-3.48,-4.38,-5.37,-6.50,-7.37,-8.10,-7.75,-6.84,-5.93,-6.28,-6.80,-7.23,-7.49,-8.34,-9.12,-9.55,-9.91,-9.53,-8.99,-8.87,-9.72,-9.63,-8.80,-8.54,-8.59,-9.11,-10,-10,-9.98,-9,-7.74,-9.01,-10,-10,-10,-9.30,-8.84,-8.36,-7.88,-8.38,-8.38,-8.78,-9.41,-10,-10,-10,-8.25,-6,-3.93,-2.13,-0.88,-0.41,-0.13,0.93,2.75,4.15,5,5,5,5,5,5,5,6.25,7.50,10,12.50,15,18.75,26.25,26.25,22.50,18.75,16.25,16.25,16.25,15,11.25,11.25,10,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,8.75,7.50,6.25,6.25,5,5,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.39,0.62,-0.05,-0.78,-2.90,-5.36,-8.11,-11,-13,-13,-10,-7.50,-5.88,-4.76,-4.23,-3.67,-2.98,-2.01,-0.90,-0.13,0.77,1.52,2.50,2.50,1.25,1.25,1.25,1.25,-1,-1,-0.52,-0.80,-1.38,-1.76,-2.25,-2.50,-2.63,-2.50,-2.63,-1.91,-1.50,-1.13,-0.88,-0.64,-0.50,-0.25,-0.28,-0.38,-0.53,-0.80,-1.13,-1.29,-1.13,-0.68,-0.03,0.30,-1.13,-3.40,-7.66,-10,-9.99,-7.25,-3.79,-1.75,-1.38,-0.88,-0.38,0.14,0.87,1.09,1.21,1.22,1.23,1.23,1.23,1.23,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,8.75,8.88,8.89,8.89,8.89,8.75,8.89,8.93,8.93,8.93,8.95,8.95,8.95,8.95,9.77,9.77,8.52,7.70,7.50,7.47,7.27,6.43,6.25,6.25,6.23,6.23,6.25,6.43,6.55,7.07,7.34,7.54,7.63,7.64,7.60,7.52,7.50,7.47,7.39,7.27,7.01,6.70,6.40,6.27,6.25,6.25,6.23,6.23,6.23,6.25,6.23,6.23,6.14,6.02,5.82,5.45,5.28,5.13,5.03,5,5,5,5,5,5,5,5,5,5,5,4.98,4.97,4.82,4.68,4.01,3.93,3.88,3.75,3.75,3.75,3.75,3.75,5,6.25,8.75,10,12.50,13.75,13.75,13.75,12.50,12.50,12.50,12.50,11.25,9.95,5.40,2.50,0.61,-0.64,-1.51,-2.25,-3.05,-3.93,-4.88,-5.87,-6.85,-7.76,-7.63,-6.36,-5.17,-5.16,-6,-6.87,-7.24,-7.87,-8.78,-10,-10,-10,-10,-10,-10,-10,-9.73,-8.74,-8.90,-10,-11,-10,-10,-9.66,-8.73,-8.90,-9.47,-9.77,-9.88,-9.38,-8.64,-8.53,-8.03,-8.10,-7.75,-8,-8.63,-9.63,-11,-12,-9,-6.88,-5.16,-3.41,-2,-1.63,-1.01,-0.03,2.18,4.17,5,5,5,5,5,3.75,5,5,7.50,11.25,12.50,15,23.75,27.50,27.50,26.25,23.75,23.75,20,21.25,17.50,16.25,12.50,11.25,10,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,5,5,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.20,0.39,-0.18,-0.75,-2.68,-4.86,-7.23,-9.75,-11,-12,-12,-10,-8.68,-7.36,-6.40,-5.60,-4.59,-3.29,-2.05,-0.92,-0.25,0.30,0.77,1.09,1.34,1.09,1.09,0.29,-0.39,-1.13,-1.29,-1.63,-2.13,-3,-3,-3,-3,-3,-2.88,-2.63,-2.18,-1.88,-1.65,-1.41,-1.16,-0.88,-0.79,-1,-1.25,-1.50,-1.63,-1.50,-1,-0.53,0.77,0.77,-0.90,-3.01,-6.60,-9.34,-9,-6.01,-2.34,-0.92,-0.53,-0.13,0.30,0.76,1.23,1.22,1.23,1.23,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,8.75,8.75,8.75,8.75,8.75,8.89,8.93,9.78,10,10.14,10.20,11.02,10.20,11.02,9.84,8.95,7.70,7.64,7.50,7.47,7.20,6.52,6.28,6.27,6.26,6.25,6.27,6.36,6.51,6.67,6.76,6.82,7.27,7.45,7.50,7.48,7.47,7.46,7.38,7.23,7.01,6.70,6.42,6.28,6.25,6.25,6.23,6.23,6.23,6.22,6.23,6.22,6.12,5.89,5.43,5.30,5.14,5.04,5,5,5,5,5,5,5,5,5,5,4.98,4.98,4.97,4.82,4.64,4.07,3.89,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,6.25,8.75,12.50,13.75,15,16.25,13.75,12.50,12.50,12.50,11.25,10,10,6.35,3.68,1.39,-0.14,-1.18,-2.01,-2.75,-3.51,-4.30,-5.25,-6.37,-7.13,-7.63,-6.98,-4.84,-5.38,-6.87,-6.89,-7.90,-8.60,-10,-11,-11,-12,-13,-13,-12,-10,-9.91,-8.74,-8.38,-8.88,-9.36,-9.34,-9,-8.29,-7.99,-8.13,-8.61,-8.85,-9.17,-8.50,-7.61,-7.26,-6.62,-6.88,-6.63,-6.63,-7.22,-8.22,-9.41,-10,-8.78,-7.12,-5.74,-4.28,-3.12,-2.18,-1.63,-0.39,2.28,4.97,7.50,6.25,5,5,3.75,3.75,3.75,5,7.50,12.50,13.75,18.75,25,26.25,26.25,28.75,28.75,27.50,26.25,22.50,21.25,17.50,16.25,12.50,11.25,10,8.75,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,8.75,7.50,7.50,7.50,6.25,6.25,5,5,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,0.89,0,-0.25,-0.50,-2,-3.79,-5.87,-7.98,-9.76,-11,-12,-12,-11,-9.75,-8.63,-7.63,-6.35,-4.91,-3.55,-2.30,-1.39,-0.77,-0.39,0,0.77,0.62,0.62,-0.13,-0.65,-1.27,-1.76,-2.25,-3,-3,-3,-3,-3,-3,-3,-2.88,-3.25,-3.42,-2.90,-2.25,-1.89,-1.55,-1.50,-1.67,-2,-2.25,-2.25,-1.80,-1.15,0.62,0.76,-0.63,-1,-2,-3.86,-5.40,-5.14,-2.54,-0.63,-0.17,0.14,0.62,0.88,1.07,1.23,1.23,1.23,1.23,1.25,1.25,1.25,1.25,1.25,1.23,1.23,1.22,1.22,1.20,1.09,1.09,1.09,1.18,1.25,1.25,1.25,1.25,1.25,8.89,8.89,8.89,8.92,8.92,8.93,9.78,10.12,11.02,12.27,11.39,11.45,12.22,11.39,10.25,9.02,7.78,7.80,7.64,7.50,7.17,6.55,6.43,6.43,6.42,6.36,6.37,6.37,6.40,6.52,6.64,6.86,7.13,7.34,7.45,7.47,7.47,7.46,7.37,7.23,7,6.70,6.43,6.29,6.25,6.25,6.23,6.23,6.22,6.22,6.21,6.18,6.07,5.82,5.43,5.18,5.09,5.01,5,5,5,5,5,5,5,5,5,5,4.98,4.98,4.95,4.68,4.14,3.90,3.76,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,7.50,10,13.75,16.25,16.25,15,15,12.50,12.50,12.50,11.25,11.25,8.75,7.64,4.37,2.02,0.25,-1,-1.90,-2.63,-3.15,-3.89,-4.80,-5.92,-7.10,-8.47,-7.80,-7.75,-6.90,-7.53,-8.35,-8.93,-9.89,-10,-11,-12,-13,-13,-13,-11,-10,-8.63,-7.52,-7,-7.01,-7.42,-7.40,-7.05,-6.68,-6.53,-6.68,-6.93,-7.12,-7.25,-6.50,-5.54,-4.84,-4.25,-3.97,-4.25,-4.67,-5.26,-6.04,-6.88,-7.55,-7.53,-6.78,-6.09,-4.97,-3.75,-2.64,-1.88,-0.50,2.80,6.25,8.75,10,6.25,5,3.75,3.75,3.75,5,6.25,11.25,17.50,20,21.25,25,27.50,30,30,30,27.50,25,22.50,21.25,17.50,13.75,12.50,10,8.75,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,5,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.21,-0.43,0.27,0.11,-0.43,-2.38,-4.27,-6.02,-7.63,-9.47,-11,-12,-13,-11,-9.88,-9.73,-8.25,-6.51,-5.02,-3.79,-2.89,-2.27,-1.75,-1.25,-0.75,-0.68,-0.75,-0.65,-1.04,-1.63,-1.90,-2.15,-3,-3,-3,-3,-3,-3,-2.88,-3.41,-4.51,-4.92,-4.75,-4.30,-3.78,-3.24,-3.25,-3.59,-3.51,-3.24,-2.88,-2.63,-1.43,-0.75,-0.63,-0.75,-1.13,-1.26,-1.88,-2.13,-1.38,-0.43,-0.01,0.46,0.76,1.09,1.09,1.20,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.23,1.23,1.22,1.21,1.18,1.09,1.03,0.93,0.93,0.93,1.09,1.25,1.25,1.25,1.25,9.84,8.89,8.89,9.79,9.79,9.78,9.84,10.20,11.02,11.45,12.27,12.62,13.46,12.63,11.54,10.30,9.05,8.60,7.82,7.65,7.21,6.59,6.60,7.12,6.59,6.61,6.53,6.43,6.46,6.57,6.73,6.98,7.18,7.34,7.43,7.46,7.46,7.45,7.37,7.22,7,6.71,6.43,6.29,6.25,6.25,6.23,6.23,6.22,6.22,6.20,6.14,6.05,5.76,5.45,5.17,5.03,5,5,5,5,5,5,5,5,5,5,5,4.98,4.97,4.89,4.54,4.17,3.78,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,12.50,15,17.50,17.50,15,13.75,12.50,12.50,11.25,11.25,10,8.75,7.30,4.68,2.47,0.55,-0.80,-1.88,-2.63,-2.90,-3.49,-4.36,-5.60,-6.90,-8.23,-9.05,-9.59,-9.01,-8.40,-10,-10,-10,-10,-11,-12,-12,-11,-10,-9.50,-8.13,-6.88,-5.85,-5.13,-5,-5.03,-5.01,-4.90,-4.84,-4.88,-5,-5.12,-5,-4.74,-3.99,-3,-2,-1.25,-1.04,-1.51,-2.26,-3.05,-3.80,-4.53,-5.47,-6.05,-6.15,-5.97,-5.14,-4.10,-2.75,-1.77,0,2.64,9.21,11.25,8.75,6.25,5,3.75,3.75,3.75,5,6.25,11.25,13.75,17.50,20,23.75,27.50,28.75,30,28.75,26.25,25,21.25,21.25,17.50,17.50,13.75,11.25,10,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,8.75,7.50,8.75,10,8.75,7.50,6.25,6.25,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,0.93,0.90,-0.93,-2.41,-4.10,-5.75,-7.65,-10,-11,-12,-12,-12,-12,-9.93,-8.02,-6.42,-5.10,-4.25,-3.73,-3.36,-2.89,-2.61,-2.50,-2.49,-2.38,-2.24,-2,-1.88,-2,-1.13,-1.52,-1.38,-1.13,-1,-1,-2.04,-4.80,-5.72,-6.72,-6.87,-6.48,-6,-5.39,-5.68,-5.91,-5.40,-4.59,-3.64,-2.76,-2,-1.17,-0.76,-0.76,-1,-1.04,-1,-0.75,-0.38,0.09,0.55,0.93,1.07,1.22,1.22,1.23,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.23,1.22,1.21,1.18,1.09,0.93,0.78,0.75,0.71,0.77,1.02,1.22,1.25,1.25,1.25,9.84,9.82,9.82,9.84,9.98,10,10.13,10.20,11.02,11.45,12.34,13.45,13.95,14.68,13.42,12.15,10.87,9.77,8.86,7.92,7.53,7.28,7.20,7.18,7.13,7,6.75,6.61,6.61,6.75,6.97,7.15,7.30,7.37,7.43,7.45,7.46,7.45,7.36,7.22,7,6.71,6.43,6.29,6.25,6.25,6.23,6.23,6.22,6.22,6.20,6.12,6.04,5.75,5.45,5.18,5.03,5,5,5,5,5,5,5,5,5,5,5,4.98,4.97,4.87,4.53,4.15,3.79,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,10,15,17.50,17.50,15,13.75,12.50,12.50,11.25,11.25,10,10,7.50,5.28,2.96,1.09,-0.50,-1.50,-2.38,-2.73,-3.17,-4,-5.24,-6.61,-7.99,-8.99,-10,-9.66,-11,-11,-11,-10,-9.68,-9.61,-9.63,-9.38,-8.84,-8,-7.03,-5.92,-4.80,-3.89,-3.13,-2.88,-2.68,-2.74,-2.74,-3.02,-3.38,-3.68,-3.25,-2.63,-2.38,-1.38,-0.50,1.20,2.68,3.10,2.02,0.25,-1,-1.79,-2.50,-3.75,-5.01,-5.54,-5.42,-4.90,-4.26,-3.28,-1.50,-0.63,7.02,8.40,10,10,6.25,5,3.75,3.75,3.75,5,7.50,11.25,13.75,15,17.50,21.25,26.25,28.75,25,27.50,27.50,26.25,25,18.75,18.75,17.50,13.75,11.25,10,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,8.75,8.75,8.75,8.75,8.75,8.75,10,8.75,7.50,6.25,6.25,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.39,1.07,0.87,-0.86,-2.25,-3.97,-5.86,-7.78,-9.50,-11,-12,-12,-12,-11,-9.99,-7.60,-6.14,-5.40,-5.18,-5,-4.63,-4.38,-4.37,-4.38,-4.13,-3.49,-2.50,-1.38,-0.89,-0.88,-0.30,-0.13,0.14,1.25,-1,-1.10,-4.04,-6.88,-8.79,-9.73,-9.77,-8.88,-8.55,-9.18,-8.91,-7.49,-6.24,-5.13,-4.03,-2.75,-1.38,0.13,-0.88,-0.93,-0.88,-0.68,-0.38,0,0.43,0.89,1.09,1.20,1.23,1.22,1.22,1.22,1.22,1.22,1.22,1.23,1.23,1.23,1.25,1.23,1.22,1.20,1.09,1.04,0.88,0.62,0.55,0.46,0.71,0.92,1.18,1.25,1.25,1.25,10.14,10.14,10.17,10.17,10.18,10.18,10.20,11.02,11.10,11.51,12.34,13.43,14.65,15.89,15.87,13.72,12.18,10.80,9.54,8.62,7.96,7.85,7.75,7.63,7.46,7.27,7.02,6.87,6.87,7,7.15,7.29,7.36,7.39,7.45,7.45,7.46,7.45,7.36,7.21,6.98,6.70,6.43,6.28,6.25,6.25,6.23,6.23,6.22,6.22,6.18,6.11,6.04,5.73,5.45,5.18,5.04,5,5,5,5,5,5,5,5,5,5,5,4.98,4.96,4.85,4.52,4.17,3.86,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,10,13.75,16.25,18.75,15,13.75,12.50,12.50,11.25,11.25,11.25,10,8.75,5.93,3.70,1.71,0,-1.15,-2.05,-2.65,-3.09,-4,-5.10,-6.35,-7.62,-8.75,-9.88,-10,-11,-11,-9.87,-8.76,-7.88,-7.26,-6.89,-6.54,-6.03,-5.42,-4.61,-3.73,-2.68,-2,-1.29,-1.02,-0.41,-0.51,-0.88,-1.68,-2.27,-2.53,-2.13,-1.80,-1.25,-0.38,1.39,3.75,8.75,8.92,5.45,2.17,-0.13,-1.14,-2,-3.14,-4.30,-4.93,-4.97,-4.50,-3.99,-3.29,-1.09,1.39,1.70,9.68,11.25,8.75,7.50,5,3.75,3.75,3.75,5,7.50,10,13.75,15,18.75,21.25,26.25,26.25,23.75,25,27.50,26.25,25,21.25,20,17.50,15,11.25,10,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,8.75,8.75,10,8.75,8.75,10,8.75,10,10,8.75,7.50,6.25,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.34,1.50,1.20,0.40,-0.50,-2.10,-4,-5.75,-7.54,-9.36,-11,-12,-13,-12,-10,-8.26,-6.60,-6.25,-6.54,-6.78,-6.50,-6.24,-6.38,-6.65,-6.38,-5.10,-3.16,-0.88,-0.29,0.92,0.15,0.14,0.14,1.25,1.25,-1.04,-4.59,-8.97,-11,-14,-13,-12,-12,-11,-10,-9.10,-7.51,-6.60,-5.17,-3.90,-2.52,-1.26,-1.04,-1.01,-0.88,-0.52,-0.15,0.25,0.62,1.09,1.22,1.22,1.22,1.20,1.18,1.10,1.10,1.18,1.21,1.22,1.22,1.23,1.23,1.22,1.21,1.18,1.09,0.93,0.77,0.60,0.46,0.46,0.62,0.87,1.09,1.23,1.25,1.25,11.09,11.07,11.04,11.04,11.03,11.09,11.37,11.45,11.50,11.53,12.17,12.82,14.62,15,15.79,14.54,13.27,11.26,10.01,9.10,8.68,8.47,8.32,7.96,7.80,7.54,7.30,7.15,7.12,7.18,7.29,7.36,7.39,7.45,7.45,7.45,7.46,7.45,7.36,7.21,6.98,6.70,6.43,6.28,6.25,6.25,6.23,6.23,6.22,6.22,6.18,6.11,6.05,5.75,5.45,5.20,5.04,5,5,5,5,5,5,5,5,5,5,5,4.98,4.96,4.84,4.52,4.17,3.88,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,10,13.75,16.25,16.25,16.25,13.75,12.50,12.50,12.50,12.50,11.25,10,8.75,7.50,5,2.34,0.46,-0.90,-1.89,-2.63,-2.90,-3.86,-4.99,-6.18,-7.49,-8.68,-8.79,-10,-11,-10,-9.09,-7.05,-5.62,-4.73,-4.36,-4.09,-3.50,-3.12,-2.40,-1.79,-0.88,-0.23,0.39,0.78,0.93,0.71,-0.02,-0.91,-1.50,-1.88,-1.25,-0.79,-0.38,1.34,3.22,7.02,11.96,10.73,5.90,2.80,0.61,-0.68,-1.59,-3.30,-4.22,-4.52,-4.36,-3.88,-3.27,-1.98,-0.54,1.65,5.90,8.71,11.25,8.75,6.25,3.75,3.75,3.75,3.75,5,6.25,8.75,10,12.50,15,16.25,21.25,21.25,18.75,18.75,23.75,25,22.50,23.75,21.25,21.25,16.25,12.50,11.25,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,8.75,10,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,6.25,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.34,2.30,1.09,0.30,-0.73,-2.24,-3.79,-5.54,-7.47,-9.27,-11,-12,-11,-10,-9.25,-7.12,-6.75,-8.24,-9.17,-8.63,-7.63,-8.16,-9.64,-9.91,-7.50,-4.72,-2.52,-0.97,1.04,1.25,-1,-1,-1,-1,-2.24,-5.89,-11,-14,-14,-15,-15,-14,-14,-13,-12,-11,-10,-9.11,-7.43,-4.99,-2.97,-1.93,-1.18,-0.88,-0.42,-0.02,0.42,0.77,1.18,1.23,1.23,1.21,1.09,1.05,0.93,0.93,1.05,1.09,1.21,1.22,1.23,1.23,1.22,1.21,1.10,1.09,0.93,0.75,0.47,0.43,0.46,0.60,0.77,1.09,1.23,1.23,1.25,12.32,11.39,11.42,11.42,11.43,12.28,12.27,12.21,12.18,11.55,11.57,12.36,12.90,14.54,14.52,13.39,12.29,11.25,10.26,9.23,9.23,9.47,9.02,8.63,8.23,7.84,7.53,7.37,7.32,7.34,7.37,7.43,7.45,7.46,7.46,7.46,7.46,7.43,7.36,7.21,6.97,6.68,6.43,6.28,6.25,6.25,6.23,6.23,6.22,6.22,6.20,6.12,6.07,5.75,5.45,5.20,5.09,5,5,5,5,5,5,5,5,5,5,5,4.98,4.95,4.80,4.52,4.18,3.89,3.76,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,10,15,13.75,15,15,13.75,12.50,12.50,13.75,12.50,11.25,11.25,8.75,7.50,5,2.50,0.72,-0.76,-1.88,-2.63,-2.90,-3.66,-4.75,-6,-7.38,-8.85,-10,-11,-11,-9.78,-7.88,-5.50,-3.35,-2.40,-2.13,-1.99,-1.55,-1.27,-0.75,-0.25,0.45,1.22,1.87,2.34,2.62,2.14,1.09,0,-0.63,-0.88,-0.50,0.30,0.48,2.02,6.80,9.84,8.59,7.21,5.14,2.18,0.40,-0.75,-2.49,-3.72,-4.35,-4.35,-3.85,-3.18,-2.28,-1.51,-0.38,1.39,7.34,12.43,10,7.50,5,3.75,3.75,3.75,3.75,3.75,5,7.50,7.50,8.75,11.25,15,13.75,13.75,16.25,18.75,22.50,22.50,23.75,21.25,22.50,21.25,16.25,13.75,11.25,10,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,8.75,8.75,6.25,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.82,1.09,0.45,-0.25,-1.63,-3.54,-5.38,-7.18,-9.11,-9.99,-10,-8.88,-8.54,-7.76,-6.37,-7.51,-9.25,-8.80,-8.48,-9.53,-11,-11,-9.63,-6.34,-4.26,-2.60,-1.41,-1.04,-1,-2,-2.25,-2.73,-3.88,-9.11,-14,-17,-16,-16,-16,-16,-16,-15,-14,-14,-13,-11,-9.84,-7.47,-5.05,-2.85,-1.41,-0.90,-0.40,0,0.46,0.89,1.22,1.25,1.25,1.20,1.05,0.78,0.62,0.76,0.87,1.02,1.09,1.20,1.22,1.22,1.21,1.18,1.09,1.04,0.89,0.72,0.47,0.43,0.46,0.59,0.77,0.93,1.20,1.23,1.25,12.34,12.32,12.29,12.29,12.34,12.62,12.76,12.75,12.34,11.59,11.64,11.67,12.30,12.68,12.68,11.71,11.64,11.02,10.46,10.11,9.98,9.84,9.62,9.46,8.59,8.09,7.71,7.52,7.46,7.43,7.45,7.46,7.46,7.46,7.46,7.46,7.46,7.43,7.36,7.20,6.97,6.68,6.43,6.28,6.25,6.25,6.23,6.23,6.22,6.22,6.20,6.12,6.09,5.76,5.46,5.21,5.10,5.01,5,5,5,5,5,5,5,5,5,5,4.98,4.95,4.79,4.52,4.18,3.89,3.76,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,8.75,12.50,15,15,15,13.75,12.50,12.50,12.50,12.50,11.25,11.25,8.75,6.25,3.75,2.34,0.57,-0.75,-1.75,-2.40,-2.79,-3.47,-4.43,-5.72,-7.23,-8.99,-11,-13,-11,-9.30,-6.68,-3.27,-1.37,-0.51,-0.30,-0.13,0,0.27,0.14,0.80,1.73,2.80,3.73,4.50,4.47,3.75,2.50,1.23,0.14,-0.25,-0.17,0.01,0.47,1.39,2.48,2.04,2.14,2.12,1.87,0.18,-0.79,-1.80,-3.25,-4.05,-4.25,-4,-3.41,-2.34,-1.75,-1,0,1.25,8.75,12.50,10,7.50,5,3.75,3.75,3.75,3.75,3.75,5,7.50,10,8.75,10,11.25,13.75,12.50,13.75,18.75,20,20,26.25,27.50,23.75,20,15,15,12.50,10,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,8.75,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,7.50,7.50,6.25,5,5,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.34,2,1.37,0.72,0.14,-1.68,-3.28,-5,-6.63,-7.93,-8.65,-8.62,-9.16,-7.50,-6.40,-6.63,-7.34,-7.89,-7.38,-8.38,-11,-12,-10,-7.90,-5.76,-4.04,-2.99,-2.50,-2.61,-2.97,-3.62,-6,-8.77,-13,-17,-18,-17,-16,-15,-15,-16,-16,-16,-16,-15,-14,-11,-8.87,-6.53,-3.65,-2.38,-1.27,-0.40,0.11,0.60,0.93,1.23,1.25,1.25,1.18,0.93,0.62,0.46,0.61,0.76,0.93,1.09,1.10,1.20,1.21,1.18,1.09,1.09,0.93,0.87,0.71,0.47,0.45,0.45,0.47,0.62,0.88,1.09,1.21,1.25,12.50,12.50,12.50,12.63,12.68,13.52,13.43,13.42,12.82,12.48,12.07,11.70,11.71,11.71,11.71,11.55,11.25,11.02,10.55,10.95,10.93,10.59,10.12,9.53,8.90,8.25,7.86,7.63,7.51,7.47,7.47,7.47,7.47,7.47,7.47,7.46,7.46,7.43,7.36,7.20,6.97,6.68,6.43,6.28,6.25,6.25,6.23,6.23,6.22,6.22,6.20,6.12,6.09,5.76,5.46,5.26,5.11,5.01,5,5,5,5,5,5,5,5,5,5,4.98,4.93,4.78,4.52,4.20,3.90,3.77,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,8.75,12.50,15,15,13.75,15,13.75,12.50,12.50,11.25,11.25,11.25,8.75,6.25,3.75,1.87,0.28,-0.88,-1.75,-2.41,-2.80,-3,-4.03,-5.25,-6.80,-8.67,-10,-12,-11,-8.98,-6.50,-3.91,-1.75,-0.13,0.30,0.77,1.20,1.68,1.84,2.34,3.75,5,6.25,6.97,6.65,5.46,3.92,2.34,0.95,0,-0.38,-0.63,-0.54,-0.28,-0.13,-0.36,-0.14,-0.28,-1.16,-1.91,-2.30,-2.91,-3.60,-3.97,-4.23,-3.64,-2.92,-1.55,-1,-0.25,1.11,1.25,10,12.50,10,7.50,5,3.75,3.75,3.75,3.75,3.75,5,7.50,8.75,8.75,12.50,12.50,16.25,16.25,18.75,20,18.75,21.25,25,28.75,25,21.25,17.50,13.75,11.25,11.25,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,8.75,10,8.75,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,5,6.25,6.25,6.25,6.25,6.25,5,5,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,2.50,3.71,2.50,2.18,1.64,1.25,0.55,-1.25,-2.73,-4.50,-6.22,-7.80,-9.34,-9.87,-8.85,-6.93,-6.39,-6.60,-6.84,-6.60,-7,-8.49,-10,-10,-9.73,-7,-5.14,-4,-3.75,-3.86,-4.25,-6.62,-10,-15,-18,-18,-18,-14,-12,-13,-14,-15,-16,-18,-18,-18,-15,-11,-8.75,-6.75,-4.63,-3.26,-1.87,-0.38,0.14,0.71,1.02,1.25,1.25,1.25,1.18,0.93,0.76,0.61,0.62,0.76,0.93,1.07,1.09,1.10,1.18,1.09,1.09,1.04,0.93,0.78,0.71,0.57,0.46,0.46,0.46,0.62,0.75,0.89,1.10,1.25,12.64,12.64,12.67,12.67,13.60,14.01,14.05,13.88,13.55,13.29,12.64,12.13,11.68,11.51,11.45,11.39,11.28,11.18,11.26,11.72,13.12,11.52,10.60,9.98,9.21,8.53,8,7.70,7.53,7.50,7.48,7.47,7.47,7.47,7.47,7.46,7.46,7.43,7.35,7.20,6.97,6.70,6.43,6.29,6.25,6.23,6.23,6.23,6.22,6.21,6.18,6.12,6.09,5.76,5.47,5.27,5.11,5.01,5,5,5,5,5,5,5,5,5,5,4.98,4.93,4.78,4.51,4.20,3.92,3.77,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,6.25,8.75,11.25,13.75,13.75,13.75,13.75,13.75,12.50,11.25,11.25,11.25,10,8.75,6.25,5,1.25,0.14,-0.75,-1.63,-2.26,-2.75,-3,-3.30,-4.38,-6.13,-8.12,-10,-10,-10,-8.77,-6.79,-4.53,-2.17,-0.13,0.59,1.25,1.98,2.77,3.43,4.84,6.25,8.75,8.75,7.50,7.50,7.80,4.84,2.97,1.39,0,-0.88,-1.39,-1.66,-1.63,-1.55,-1.50,-1.42,-2.49,-3.53,-3.48,-3.38,-3.29,-3.38,-3.64,-3.76,-2.99,-2.11,-0.76,-0.12,0.80,2.34,6.25,11.25,13.75,11.25,7.50,5,3.75,3.75,3.75,3.75,3.75,3.75,5,6.25,7.50,11.25,15,15,17.50,20,21.25,22.50,21.25,23.75,27.50,27.50,20,18.75,15,13.75,11.25,10,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,10,11.25,10,8.75,7.50,7.50,7.50,7.50,7.50,6.25,5,5,5,5,6.25,6.25,6.25,6.25,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.63,2.34,1.54,0.62,-0.29,-2.17,-4.73,-7.25,-9.79,-12,-13,-10,-8.26,-6.86,-7.88,-7.51,-6.66,-6.38,-8,-9.64,-9.63,-8.38,-5.73,-5.05,-5.02,-5.16,-5.54,-7.93,-12,-17,-19,-17,-13,-12,-12,-8.88,-9.36,-10,-12,-14,-17,-16,-13,-9.38,-7,-5.78,-5.14,-3.88,-2.51,-0.38,0.30,0.77,1.05,1.25,1.25,1.25,1.20,1.05,0.88,0.77,0.76,0.87,0.93,1.09,1.09,1.09,1.09,1.07,1.02,0.93,0.92,0.77,0.72,0.62,0.47,0.46,0.46,0.57,0.62,0.75,1.09,1.25,13.75,13.75,13.75,13.92,14.71,15.11,15,14.62,14.05,13.54,13.27,12.38,11.73,11.71,11.70,11.57,11.45,11.39,11.65,12.32,13.12,12.20,11.27,10.62,9.51,8.72,8.12,7.77,7.59,7.50,7.48,7.47,7.47,7.47,7.47,7.47,7.46,7.45,7.35,7.20,6.97,6.70,6.45,6.29,6.25,6.23,6.23,6.23,6.22,6.21,6.18,6.10,6.03,5.75,5.47,5.27,5.12,5.02,5,5,5,5,5,5,5,5,5,5,4.98,4.93,4.78,4.51,4.20,3.92,3.77,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,7.50,10,11.25,13.75,13.75,13.75,13.75,13.75,12.50,11.25,10,10,10,8.75,7.50,5,1.25,0.77,-0.18,-1.14,-2,-2.50,-2.88,-3.38,-4.23,-5.48,-7.01,-8.72,-9.91,-9.37,-8.75,-7.25,-5.38,-3.34,-1.38,0.30,1.22,2.34,3.75,5.14,7.65,10.10,11.25,10,7.50,6.36,6.55,4.36,2.64,1.09,-0.25,-1.29,-2.13,-3.13,-3.41,-3.30,-3.18,-5.22,-6.34,-5.97,-5.34,-4.34,-3.59,-3.12,-2.85,-2.64,-1.85,-0.63,0.11,1.02,1.98,3.43,5,11.25,12.50,10,7.50,5,3.75,3.75,3.75,2.50,2.50,3.75,3.75,3.75,6.25,8.75,8.75,11.25,13.75,16.25,20,23.75,23.75,23.75,26.25,26.25,23.75,18.75,18.75,16.25,13.75,11.25,8.75,7.50,7.50,7.50,7.50,7.50,7.50,8.75,10,11.25,10,8.75,8.75,8.75,8.75,7.50,7.50,6.25,5,5,5,5,5,6.25,6.25,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.68,3.57,2.34,1.52,0.71,-0.13,-3.38,-6.42,-9.65,-13,-19,-14,-10,-8.41,-7.89,-7.50,-7,-6.61,-7.39,-9.99,-9.41,-7.91,-6.04,-6.29,-6.50,-6.52,-6.64,-7.22,-10,-13,-13,-11,-10,-11,-7.63,-6.52,-7.34,-8.79,-9.50,-9.75,-10,-11,-8.14,-5.63,-5.54,-5.13,-4.51,-3.80,-2.78,-1.66,0.14,0.73,1.09,1.25,1.25,1.25,1.21,1.09,0.93,0.93,0.93,0.93,1.09,1.09,1.09,1.05,0.93,0.93,0.92,0.89,0.87,0.77,0.75,0.62,0.62,0.60,0.57,0.57,0.62,0.76,1.07,1.25,14.98,14.98,14.98,15.20,15.93,17.17,15.89,15.11,14.53,13.59,12.97,12.67,12.43,12.22,12.07,11.90,11.71,11.60,11.85,12.46,13.11,12.36,11.85,10.64,9.63,8.77,8.15,7.78,7.59,7.50,7.48,7.48,7.48,7.47,7.47,7.47,7.46,7.45,7.35,7.20,6.97,6.70,6.45,6.29,6.25,6.23,6.23,6.22,6.22,6.21,6.14,6.09,5.98,5.73,5.47,5.28,5.13,5.02,5,5,5,5,5,5,5,5,5,5,4.98,4.93,4.78,4.51,4.20,3.92,3.78,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,7.50,10,11.25,12.50,13.75,13.75,13.75,12.50,11.25,10,10,10,10,10,8.75,7.50,3.75,2.18,0.46,-0.76,-1.75,-2.38,-2.75,-3.17,-3.88,-4.97,-6.25,-7.18,-7.98,-8.52,-8.97,-7.91,-6.23,-4.42,-2.55,-0.86,0.62,2.20,5.30,6.72,7.98,10.43,9.68,6.39,2.64,2.80,3.27,2.50,1.25,0.14,-0.87,-1.75,-2.63,-4.09,-4.87,-5.12,-7.48,-8.75,-10,-8.50,-6.88,-5.23,-3.80,-2.64,-1.90,-1.38,-0.29,0.55,1.09,2.30,3.43,3.70,5,8.75,10,8.75,6.25,5,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,3.75,5,6.25,7.50,10,13.75,17.50,21.25,22.50,22.50,25,23.75,25,21.25,18.75,16.25,15,10,8.75,8.75,7.50,7.50,7.50,7.50,7.50,8.75,10,11.25,10,8.75,8.75,8.75,7.50,7.50,7.50,6.25,5,5,5,5,5,5,6.25,6.25,5,5,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,3.75,3.75,3.75,3.68,2.93,2.18,1.39,0.46,-1.77,-5.38,-8.97,-13,-17,-15,-11,-8.50,-7.54,-7.42,-7.99,-8.54,-9,-9.99,-9.47,-7.37,-6.26,-7.13,-7.38,-7.35,-7.75,-7.16,-7.16,-7.51,-7.38,-7.63,-10,-9.28,-6.27,-8.50,-10,-9.51,-8.34,-6.55,-5.41,-5.51,-4.66,-4.38,-4.53,-4.26,-3.97,-3.72,-3.24,-2.54,-0.35,0.46,1.20,1.25,1.25,1.25,1.21,1.18,1.09,1.07,1.09,1.09,1.09,1.09,1.09,0.93,0.78,0.77,0.77,0.77,0.77,0.77,0.77,0.76,0.73,0.62,0.62,0.62,0.62,0.78,1.05,1.23,16.23,16.09,16.05,16.09,17.18,17.14,17.12,15.02,14.20,13.60,12.97,13.01,13.15,12.80,12.53,12.30,12.05,11.87,11.87,12.46,13.10,12.02,11.25,10.59,9.50,8.75,8.15,7.79,7.60,7.50,7.48,7.48,7.48,7.48,7.47,7.47,7.46,7.45,7.35,7.20,6.97,6.70,6.45,6.29,6.25,6.23,6.23,6.22,6.22,6.21,6.14,6.09,5.97,5.72,5.47,5.28,5.13,5.03,5,5,5,5,5,5,5,5,5,5,4.98,4.93,4.78,4.51,4.20,3.92,3.78,3.75,3.75,3.75,3.75,3.75,3.87,3.75,6.25,7.50,10,11.25,12.50,12.50,13.75,15,12.50,11.25,10,8.75,8.75,8.75,8.75,7.50,7.50,7.50,3.59,1.25,-0.25,-1.15,-1.88,-2.39,-2.90,-3.63,-4.75,-6,-6.88,-7.68,-8.89,-9.13,-8.41,-7.11,-5.61,-3.85,-1.87,0.14,1.67,3.27,4.62,5.57,3.27,3.76,2.29,0.62,0.42,0.77,0.55,-0.13,-0.80,-1.54,-2.40,-4.13,-5.88,-6.85,-7.88,-9.29,-11,-11,-10,-7.93,-5.77,-3.75,-2.13,-0.92,-0.18,0.87,2.02,3.11,4.46,3.59,3.75,5,7.50,8.75,10,6.25,5,3.75,2.50,2.50,1.25,1.25,1.25,1.25,1.25,2.50,3.75,3.75,6.25,10,12.50,16.25,16.25,18.75,21.25,22.50,26.25,25,21.25,20,21.25,17.50,11.25,10,8.75,8.75,7.50,7.50,7.50,8.75,10,11.25,11.25,10,8.75,8.75,8.75,7.50,7.50,7.50,6.25,6.25,5,5,5,5,5,6.25,6.25,6.25,5,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.26,2.64,1.87,0.92,-0.26,-4.25,-7.75,-10,-12,-12,-9.61,-6.51,-6.88,-8.42,-9.65,-10,-11,-10,-8.10,-6.80,-6,-6.25,-6.38,-6.34,-6.40,-6.17,-5.66,-4.53,-3.75,-6.11,-7.75,-7.52,-8.67,-11,-13,-11,-6.59,-3.25,-1.85,-2.59,-3.30,-2.84,-2.59,-2.74,-3.11,-3.49,-3.64,-3.35,-2.23,-1.17,-0.90,1.09,1.25,1.25,1.18,1.09,1.09,1.09,1.09,1.10,1.20,1.10,1.09,0.93,0.77,0.62,0.62,0.72,0.75,0.77,0.77,0.77,0.77,0.77,0.77,0.77,0.78,0.93,1.09,1.21,17.34,17.34,16.43,16.38,16.25,16.10,15.39,14.18,14.07,13.68,13.43,13.52,13.47,13.32,12.95,12.64,12.48,12.43,12.50,12.51,12.15,11.35,10.48,9.82,9.21,8.61,8.12,7.79,7.60,7.50,7.50,7.48,7.48,7.48,7.47,7.47,7.47,7.45,7.35,7.20,6.97,6.70,6.45,6.29,6.25,6.23,6.23,6.22,6.22,6.21,6.14,6.09,5.97,5.72,5.47,5.28,5.13,5.03,5,5,5,5,5,5,5,5,5,5,4.98,4.93,4.78,4.51,4.20,3.92,3.77,3.75,3.75,3.75,3.75,3.76,3.87,5,6.25,7.50,8.75,11.25,11.25,12.50,13.75,13.75,12.50,12.50,11.25,10,8.75,8.75,7.50,7.50,7.50,7.50,5,1.97,0.46,-0.63,-1.38,-2.02,-2.50,-3.36,-4.61,-6,-7.13,-7.80,-8.01,-8.49,-8.63,-8,-6.72,-5.13,-3.34,-1.39,0.46,1.54,2.29,2.15,1.42,0.59,-0.26,-0.63,-0.88,-1,-1.59,-2.16,-2.51,-3.38,-4.88,-7.13,-8.02,-8.73,-9.51,-10,-13,-13,-11,-8.67,-5.98,-3.49,-1.62,-0.61,0.55,1.97,3.59,5.77,4.82,5,5,6.25,8.75,8.75,8.75,6.25,3.75,3.75,2.50,1.25,1.39,1.25,0.93,0.73,0.77,1.25,1.86,3.25,5.43,10,13.75,12.50,15,17.50,20,21.25,21.25,25,23.75,22.50,18.75,18.75,13.75,11.25,10,8.75,8.75,7.50,7.50,10,10,11.25,11.25,8.75,8.75,8.75,8.75,8.75,7.50,7.50,6.25,6.25,5,5,5,5,6.25,7.50,8.75,6.25,5,5,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.43,2.80,2.02,0.87,-0.36,-3,-6.27,-8.64,-10,-10,-9.26,-8.25,-9.80,-10,-10,-11,-11,-9.97,-6.66,-5.10,-4.14,-3.64,-3.88,-3.52,-3.14,-3.38,-3.36,-2.65,-2.25,-2.98,-5.03,-4.84,-6.30,-13,-15,-8.02,-2.38,-0.92,-0.13,2.60,1.68,1.02,0.20,-0.38,-1.15,-3.66,-4.37,-4.25,-3.50,-2.92,-1.88,0.72,0.59,0.77,0.93,1.02,1.02,1.07,1.09,1.18,1.21,1.18,1.09,0.93,0.76,0.62,0.55,0.62,0.62,0.72,0.76,0.77,0.77,0.77,0.78,0.87,0.92,0.93,1.09,1.20,18.73,17.64,17.27,16.28,15.30,15.35,15.29,14.80,14.21,13.85,13.75,13.78,14.38,13.60,13.27,13.07,12.96,12.96,13.07,13.07,11.86,10.65,9.39,9.26,8.89,8.48,8.12,7.80,7.63,7.52,7.50,7.48,7.48,7.48,7.48,7.48,7.47,7.45,7.35,7.20,6.97,6.70,6.46,6.34,6.25,6.23,6.23,6.23,6.22,6.21,6.14,6.10,5.96,5.72,5.47,5.28,5.13,5.03,5,5,5,5,5,5,5,5,5,5,4.98,4.93,4.78,4.51,4.20,3.92,3.77,3.75,3.75,3.75,3.75,3.75,3.85,3.75,6.25,7.50,8.75,10,11.25,12.50,13.75,13.75,12.50,11.25,11.25,10,8.75,8.75,7.50,6.25,6.25,6.25,5,2.45,1.53,0.30,-0.63,-1.39,-2.04,-2.52,-4.29,-5.85,-7.13,-7.68,-7.63,-7.04,-8.23,-8.88,-8,-6.61,-5,-3.37,-1.87,-0.18,0.09,0.02,-0.38,-0.88,-1.42,-1.75,-2.25,-4.03,-4.73,-5.10,-5.50,-6.27,-7.61,-9.27,-10,-10,-10,-11,-13,-14,-12,-8.88,-5.63,-2.88,-1.13,-0.16,1.22,3.12,4.70,5,5,6.25,6.25,7.50,8.75,10,7.50,5,3.75,2.50,1.25,1.35,1.37,1.09,0.59,-0.03,-0.16,0.14,0.77,2.17,4.20,6.50,7.77,9.02,13.50,15.13,17.50,17.50,22.50,23.75,23.75,21.25,18.75,16.25,15,11.25,10,8.75,7.50,7.50,7.50,8.75,10,10,10,8.75,8.75,8.75,8.75,7.50,7.50,7.50,6.25,6.25,5,5,5,5,6.25,10,10,7.50,6.25,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.12,2.50,1.55,0.46,-0.60,-2.59,-4.88,-7,-8.50,-9.38,-9.98,-10,-11,-11,-11,-10,-9.86,-7.74,-5.12,-3.04,-2.39,-2.15,-1.30,-1.27,-1.25,-1.25,-1.13,-1.13,-1.02,-1.13,-1.98,-2.11,-5.22,-11,-19,-11,-0.64,0.20,2.47,4.40,4.87,2.97,1.02,0.51,-0.11,-0.88,-2.43,-3.14,-3.38,-4.24,-2.87,-1.77,-0.90,0.12,0.43,0.75,0.78,0.89,1.03,1.09,1.20,1.18,1.09,1.03,0.77,0.60,0.46,0.46,0.59,0.62,0.62,0.73,0.77,0.77,0.77,0.78,0.90,0.93,1.09,1.10,21.09,18.90,17.51,16.42,15.30,15.35,15.79,15.77,14.22,14.01,13.86,13.89,13.89,13.76,13.54,13.43,13.46,13.52,13.39,13.05,11.72,10.46,9.46,9,8.71,8.43,8.13,7.89,7.67,7.54,7.50,7.50,7.48,7.48,7.48,7.48,7.47,7.45,7.35,7.20,6.97,6.71,6.46,6.34,6.25,6.25,6.23,6.23,6.22,6.21,6.18,6.12,5.97,5.72,5.47,5.28,5.13,5.03,5,5,5,5,5,5,5,5,5,5,4.98,4.93,4.78,4.51,4.20,3.90,3.77,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,7.50,8.75,8.75,10,11.25,12.50,13.75,12.50,12.50,11.25,11.25,10,8.75,7.50,7.50,6.25,5,5,4.37,2.64,1.36,0.10,-0.88,-1.63,-2.25,-3.92,-5.52,-6.89,-7.54,-7.90,-7.23,-8.74,-9.92,-9.42,-8.30,-6.84,-5.27,-3.88,-2.67,-2.63,-3,-3.28,-3.49,-3.75,-4.13,-5.38,-6.88,-7.68,-7.79,-8.10,-8.63,-9.85,-12,-11,-10,-10,-11,-13,-14,-12,-8.62,-4.97,-1.55,-0.75,0.57,2.36,4.52,4.84,5,6.25,6.25,6.25,8.75,8.75,8.75,6.25,3.75,2.50,1.25,1.25,1.39,0.87,0.57,0.09,-0.65,-0.88,-0.63,0,1.38,2.92,4.50,6,7.90,10.35,13.47,14.86,16.25,20,23.75,23.75,22.50,20,17.50,15,15,11.25,10,7.50,7.50,7.50,8.75,10,10,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,6.25,6.25,5,5,5,5,6.25,8.75,11.25,7.50,6.25,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.80,2.18,1.25,0.26,-0.62,-2.39,-3.88,-5.64,-7.27,-8.49,-10,-11,-12,-10,-9.63,-8.87,-7.63,-5.97,-3.63,-2.13,-1.68,-1.13,-0.67,-0.13,-0.14,-0.13,0,0.14,0.14,0.14,-0.03,-0.88,-3.47,-13,-19,-14,-4.86,0.88,1.37,3.15,3.54,1.71,0.89,0.80,0.62,0.14,-0.39,0,-2.60,-3.38,-3,-2.50,-1.85,-1.01,-0.25,0,0.30,0.57,0.77,1.02,1.09,1.10,1.10,1.07,0.87,0.60,0.42,0.42,0.46,0.46,0.60,0.62,0.72,0.75,0.77,0.77,0.78,0.92,0.93,1.09,22.34,19.84,17.75,16.55,16.10,15.80,15.45,15.11,14.62,14.09,13.89,13.84,13.78,13.75,13.72,13.73,13.89,14.30,13.53,12.68,11.76,10.43,9.46,8.92,8.70,8.46,8.23,7.97,7.77,7.62,7.52,7.50,7.50,7.50,7.48,7.48,7.47,7.45,7.35,7.20,6.98,6.71,6.50,6.35,6.26,6.25,6.23,6.23,6.22,6.21,6.18,6.12,5.97,5.72,5.46,5.28,5.13,5.03,5,5,5,5,5,5,5,5,5,5,4.98,4.93,4.78,4.52,4.20,3.90,3.77,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,6.25,7.50,8.75,8.75,10,11.25,12.50,12.50,12.50,11.25,11.25,11.25,8.75,7.50,7.50,6.25,5,5,5,3.86,2.18,0.77,-0.38,-1.14,-1.88,-3.48,-5.10,-6.50,-7.49,-8,-7.63,-8.75,-10,-11,-10,-8.68,-7.14,-5.91,-5.13,-5.34,-5.90,-6,-5.99,-6.04,-6.47,-7.78,-9.77,-10,-10,-10,-10,-11,-13,-12,-11,-10,-11,-13,-14,-12,-7.85,-3.74,-1.25,-0.25,0.77,3.89,5.79,6.20,6.25,6.25,6.25,6.25,7.50,8.75,7.50,6.25,3.59,1.71,0.62,-0.11,-0.25,-0.25,-0.17,-0.63,-1.27,-1.49,-1.15,-0.52,0.62,2.03,3.54,5.18,7.22,10.11,11.86,12.75,13.75,18.75,20,20,20,21.25,17.50,16.25,16.25,13.75,10,8.75,7.50,7.50,7.50,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,6.25,6.25,6.25,5,5,5,6.25,7.50,8.75,7.50,6.25,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.47,2.02,1.25,0.26,-0.51,-1.75,-3.18,-4.12,-5.68,-6.73,-8.52,-10,-10,-8.88,-7.52,-6.65,-5.63,-4.64,-2.30,-1.29,-0.79,-0.25,0.77,0.93,1.02,1.09,1.20,1.39,1.25,1.25,0.77,0.88,0.34,-9.35,-17,-13,-6.24,-0.13,-0.24,0.95,1.26,0.55,0.93,1.22,1.35,0.93,0.77,0.57,-0.40,-2.16,-2.77,-2.51,-2.25,-1.68,-0.78,-0.53,-0.25,0.14,0.46,0.77,0.93,1.09,1.09,1.09,0.89,0.57,0.30,0.30,0.30,0.43,0.46,0.57,0.62,0.62,0.62,0.73,0.77,0.78,0.93,1.09,22.34,20.18,18.75,17.37,16.50,15.87,15.43,14.98,14.55,14.20,13.89,13.78,13.78,13.85,13.88,13.93,14.09,14.32,13.53,12.64,11.54,10.42,9.46,8.93,8.75,8.59,8.37,8.10,7.84,7.64,7.53,7.50,7.50,7.50,7.48,7.48,7.47,7.45,7.35,7.20,6.98,6.71,6.51,6.36,6.26,6.25,6.23,6.23,6.22,6.22,6.21,6.12,5.97,5.72,5.46,5.26,5.13,5.02,5,5,5,5,5,5,5,5,5,5,4.98,4.93,4.79,4.52,4.18,3.90,3.77,3.75,3.75,3.75,3.75,3.75,3.85,3.75,5,6.25,7.50,7.50,8.75,10,11.25,10,11.25,11.25,11.25,11.25,10,10,8.75,7.50,6.25,6.25,5,5,4.52,2.79,1.25,0,-0.80,-1.55,-3.09,-4.66,-6.13,-7.38,-8.25,-9.97,-10,-14,-15,-12,-10,-8.75,-7.63,-7.12,-7.75,-8.52,-8.38,-8.24,-8.11,-8.47,-9.60,-11,-12,-11,-11,-11,-12,-13,-11,-10,-10,-11,-12,-12,-10,-6.27,-2.48,-0.78,0.48,2.46,4.35,5.93,6.25,6.25,6.25,6.25,7.50,7.50,8.75,8.75,6.25,2.59,0.77,-0.29,-1,-1.15,-1.25,-1.65,-1.75,-1.78,-1.72,-1.54,-0.93,0.17,1.43,2.82,4.64,6.22,10.27,14.10,13.37,12.50,13.75,18.75,21.25,18.75,18.75,18.75,16.25,15,12.50,11.25,8.75,7.50,6.25,7.50,8.75,10,8.75,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,6.25,6.25,5,5,6.25,6.25,7.50,7.50,7.50,6.25,5,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.43,1.39,0.72,-0.38,-1,-1.52,-2,-2.12,-4.03,-6.22,-7.14,-6.53,-5.25,-4.89,-4.37,-3.61,-2.34,-0.90,-0.41,0.09,0.75,1.25,1.55,1.71,1.85,1.96,1.97,1.87,1.39,1.09,0.47,-1.02,-6.52,-10,-12,-6.28,-2.89,-0.63,-0.15,0.30,0.77,1.25,1.55,1.84,1.70,1.71,1.09,0.46,-0.38,-2.04,-2.37,-2.60,-2.23,-1.91,-1.52,-0.75,-0.38,0,0.46,0.89,1.09,1.09,1.18,0.93,0.46,0.14,0.14,0.26,0.30,0.45,0.46,0.55,0.60,0.62,0.62,0.76,0.77,0.93,1.09,22.34,21.04,19.71,17.80,16.57,15.92,15.42,14.97,14.54,14.20,13.90,13.87,13.89,14.02,14.09,14.21,14.22,14.05,13.57,12.65,11.57,10.46,9.47,9.05,8.78,8.70,8.52,8.15,7.92,7.68,7.54,7.50,7.50,7.50,7.48,7.48,7.47,7.45,7.35,7.20,6.98,6.71,6.51,6.36,6.27,6.25,6.23,6.23,6.22,6.23,6.21,6.12,5.97,5.72,5.46,5.26,5.11,5.02,5,5,5,5,5,5,5,5,5,5,4.98,4.95,4.79,4.52,4.18,3.89,3.76,3.75,3.75,3.75,3.75,3.75,3.85,5,5,6.25,6.25,7.50,7.50,8.75,8.75,8.75,8.75,8.75,10,10,11.25,10,8.75,7.50,6.25,5,5,5,5,2.96,1.55,0.30,-0.51,-1.38,-2.75,-4.38,-5.92,-7.39,-8.77,-11,-14,-16,-17,-14,-11,-9.86,-8.68,-8.47,-9.27,-10,-10,-10,-9.64,-9.67,-10,-11,-12,-11,-12,-12,-12,-12,-9.63,-8.75,-10,-10,-10,-9.87,-7.10,-3.65,-1.38,-0.16,1.25,3.71,5.62,6.20,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,5,2.02,-0.13,-1,-1.77,-3,-3.28,-3.09,-2.77,-2.39,-2.03,-1.78,-1.13,-0.03,1.21,2.46,4.59,7.22,10.53,15.21,13.88,12.50,12.50,15,17.50,18.75,17.50,17.50,17.50,15,13.75,11.25,8.75,7.50,7.50,7.50,10,10,8.75,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,6.25,5,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.53,0.77,0.14,-0.50,-0.50,-0.50,-0.41,-1.13,-2.25,-2.54,-2.02,-1.75,-2.04,-2.34,-1.53,-0.63,0.10,0.62,1.07,1.52,2.17,2.02,2.17,2.18,2.29,2.29,1.98,1.55,1.09,0.09,-2.91,-5.65,-9.25,-11,-9.77,-6.34,-0.75,-0.14,0.45,0.93,1.39,1.86,2.18,2.13,2.01,1.71,1.20,0.46,-0.49,-1.74,-2.38,-2.51,-2.61,-2.25,-1.97,-0.88,-0.43,0,0.46,0.90,1.09,1.09,1.09,0.46,-0.01,0.09,0.26,0.30,0.46,0.46,0.55,0.61,0.62,0.71,0.77,0.89,0.93,1.09,21.09,20.18,19.71,17.80,16.59,16.07,15.45,14.98,14.55,14.21,14.01,14.01,14.15,14.35,14.52,14.55,14.51,14.23,13.73,13.01,11.80,10.65,9.78,9.18,8.88,8.73,8.54,8.27,7.95,7.70,7.54,7.50,7.50,7.50,7.48,7.48,7.47,7.45,7.36,7.20,7,6.72,6.52,6.37,6.27,6.25,6.23,6.23,6.23,6.23,6.21,6.13,5.98,5.72,5.46,5.25,5.10,5.01,5,5,5,5,5,5,5,5,5,5,4.98,4.95,4.79,4.52,4.18,3.89,3.76,3.75,3.75,3.75,3.75,3.75,3.79,3.75,5,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,8.75,8.75,8.75,10,8.75,8.75,6.25,5,5,3.75,3.75,3.21,1.65,0.59,-0.27,-1.50,-2.79,-4.25,-5.75,-7.25,-9.13,-11,-15,-18,-16,-14,-12,-10,-8.48,-9.13,-10,-11,-11,-11,-10,-10,-10,-11,-10,-10,-10,-10,-10,-9.66,-8.14,-7.98,-8.86,-9.25,-8.38,-6.60,-3.93,-2.03,-0.67,0.61,2.50,4.07,4.68,6.25,6.25,5,6.25,7.50,7.50,8.75,6.25,5,3.75,1.23,-0.41,-1.64,-3.43,-5.55,-5.29,-4.59,-3.75,-2.90,-2.14,-1.75,-1.01,0.12,1.52,3.05,5,7.46,10.42,13.32,15.37,13.68,10,11.25,12.50,13.75,16.25,16.25,15,16.25,12.50,11.25,10,8.75,7.50,7.50,8.75,10,8.75,7.50,7.50,7.50,7.50,8.75,7.50,7.50,7.50,8.75,7.50,6.25,6.25,7.50,8.75,7.50,7.50,6.25,6.25,5,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.27,1.39,0.90,0.39,0.14,0.14,0.14,0,-0.40,-0.75,-0.88,-0.77,-0.79,-0.63,-0.38,0.30,1.09,1.71,1.84,2.12,2.32,2.34,2.34,2.43,2.46,2.45,2.02,1.54,0.62,-0.13,-2.74,-4.89,-8.50,-9.80,-9.03,-6.18,-0.80,-0.03,0.71,1.09,1.25,2.50,2.45,2.34,2.29,2.13,1.86,1.20,0.46,-0.49,-2.36,-2.72,-2.68,-2.73,-2.54,-2.64,-0.92,-0.50,-0.03,0.46,0.77,1.09,1.21,1.18,-0.50,0.30,0.42,0.46,0.47,0.57,0.61,0.62,0.73,0.77,0.88,0.93,1.09,1.20,19.84,19.79,18.87,17.80,17.34,16.52,15.43,15.12,14.64,14.23,14.09,14.23,14.52,14.84,15.01,15.10,14.96,14.65,14.26,13.15,12.21,11.09,10.11,9.37,8.92,8.75,8.57,8.27,7.93,7.67,7.54,7.50,7.50,7.50,7.48,7.48,7.47,7.45,7.36,7.21,7.01,6.75,6.54,6.38,6.27,6.25,6.25,6.25,6.23,6.23,6.21,6.13,5.98,5.73,5.46,5.25,5.10,5.01,5,5,5,5,5,5,5,5,5,5,4.98,4.96,4.80,4.52,4.17,3.87,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,6.25,5,5,3.75,3.75,2.50,1.39,0.61,-0.25,-1.53,-2.84,-4.26,-5.73,-7.05,-8.13,-12,-13,-16,-17,-13,-10,-8.36,-8.38,-8.49,-9.34,-11,-11,-10,-10,-9.90,-9.04,-8.13,-8.04,-7.63,-7.89,-9.28,-9.25,-7.55,-7.42,-7.92,-8.17,-8,-6.14,-4.38,-2.65,-1.30,0.01,2.27,3.86,4.37,4.95,5,5,5,6.25,7.50,7.50,8.75,6.09,4.05,2.18,0.46,-0.88,-3.01,-5.29,-8.39,-7.38,-6.09,-4.66,-3.17,-1.89,-0.93,-0.25,1.11,2.38,3.85,5.57,7.63,9.82,11.87,13.25,14.85,10.05,8.75,11.25,13.75,15,13.75,13.75,13.75,15,13.75,12.50,10,7.50,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,8.75,7.50,7.50,7.50,7.50,8.75,7.50,7.50,6.25,5,5,3.75,3.75,3.75,3.75,3.75,3.75,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.34,2.18,1.71,1.25,1.05,0.90,0.77,0.55,-0.02,-0.27,-0.25,0.14,0.62,-0.01,0.60,1.21,1.84,2.18,2.43,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.98,1.25,0.43,-0.38,-3.29,-5.13,-5.40,-6.84,-5.85,-2.59,-0.53,0.14,0.77,1.25,1.25,2.50,2.50,2.50,2.43,2.34,2.18,1.87,1.09,0.30,-1.39,-2.25,-2.62,-2.74,-2.84,-2.65,-2.88,-1,-0.51,-0.03,0.45,0.87,1.09,1.25,1.18,0.62,0.73,0.72,0.62,0.62,0.62,0.73,0.77,0.89,0.93,1.09,1.20,1.25,18.71,18.59,18.47,18.43,18.39,17.07,16.09,15.30,14.77,14.23,14.22,14.54,15,15.40,15.65,15.75,15.55,15.17,14.64,13.89,12.80,11.70,10.57,9.40,9.05,8.77,8.59,8.27,7.93,7.64,7.52,7.50,7.50,7.50,7.48,7.48,7.47,7.45,7.36,7.22,7.02,6.80,6.57,6.40,6.29,6.25,6.25,6.25,6.23,6.23,6.22,6.14,6.02,5.73,5.46,5.25,5.10,5.01,5,5,5,5,5,5,5,5,5,5,4.98,4.96,4.84,4.52,4.17,3.78,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,6.25,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,3.75,2.50,1.71,0.90,0.11,-0.68,-1.64,-2.98,-4.51,-6,-6.98,-8.13,-10,-12,-13,-14,-11,-8.63,-7.34,-7.43,-8.34,-9.09,-10,-11,-10,-10,-9.74,-8.01,-7.43,-6.74,-5.99,-7.26,-8.49,-8.36,-7.50,-6.73,-7.88,-7.39,-6.47,-4.91,-2.99,-1.80,-0.66,0.92,2.64,4.15,5,5,5,6.25,6.25,7.50,8.75,8.75,7.50,5.46,3.27,1.25,-0.38,-2.38,-5,-9.16,-11,-9.38,-7.66,-5.65,-3.38,-0.76,0.11,1.05,2.45,3.77,4.82,6.40,7.87,9.35,10.72,12.30,13.32,12.22,8.75,11.25,15,15,15,12.50,13.75,13.75,16.25,12.50,11.25,8.75,7.50,6.25,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,8.75,8.75,7.50,6.25,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.46,2.43,2.18,1.96,1.52,1.25,0.93,0.46,-0.01,-0.25,0.76,0.77,1.04,1.36,2.13,2.30,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.96,1.09,0.25,-0.50,-3.62,-4.53,-4.60,-3.36,-2.66,-0.86,-0.01,0.62,1.23,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.34,1.87,1.09,0.09,-1.60,-2.38,-2.63,-2.89,-2.98,-2.99,-2.54,-1.53,-0.53,-0.13,0.26,0.62,1.25,1.25,1.25,1.18,0.93,0.78,0.73,0.62,0.76,0.78,0.93,1.18,1.25,1.25,1.25,17.50,17.62,17.75,18.43,17.64,17.07,16.20,15.77,14.79,14.25,14.30,14.82,15.63,15.88,16.22,16.84,16.12,15.63,15.57,14.54,13.60,12.43,11.11,10.01,9.22,8.86,8.59,8.27,7.93,7.64,7.50,7.50,7.50,7.50,7.48,7.48,7.48,7.46,7.38,7.28,7.07,6.87,6.65,6.45,6.34,6.25,6.25,6.25,6.23,6.23,6.22,6.14,6.03,5.77,5.46,5.25,5.10,5.01,5,5,5,5,5,5,5,5,5,5,5,5,4.95,4.57,4.14,3.77,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,6.25,5,5,5,5,6.25,5,5,5,5,5,5,5,5,5,5,5,1.25,1.09,0.46,-0.25,-0.88,-1.77,-3.43,-5.26,-6.90,-8.01,-9,-9.99,-10,-11,-10,-9.66,-8.42,-6.91,-7.25,-8.26,-9.48,-10,-10,-10,-10,-9.63,-8.23,-7.80,-7.14,-7.05,-7.16,-7.61,-8.04,-8.38,-7.92,-7.35,-6.99,-5.54,-3.62,-2.13,-1.02,0.14,1.71,3.25,4.55,5.93,6.25,7.50,7.50,7.50,10,10,8.59,6.86,4.80,2.64,0.77,-1.25,-4.13,-6.54,-11,-12,-11,-9.52,-6.35,-3.13,0.30,1.09,2.28,3.60,5.76,6.47,7.45,8.30,9.07,9.89,10.52,14.40,12.05,10.14,10,11.25,13.75,13.75,12.50,12.50,12.50,12.50,13.75,11.25,10,8.75,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,8.75,8.75,8.75,6.25,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,2.50,2.50,2.50,2.50,3.75,2.50,2.50,1.25,1.25,1.25,1.09,0.93,0.93,1.18,1.50,2.13,2.29,2.60,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.97,1.09,0.28,-0.50,-1.55,-3,-3,-0.79,-0.29,0.28,0.77,1.39,1.87,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.18,1.71,0.59,-0.51,-1.84,-2.34,-2.75,-2.88,-3,-2.43,-1.97,-1.30,-0.63,-0.13,-0.05,1.25,1.25,1.25,1.25,1.18,0.88,0.59,0.46,0.46,0.62,0.77,0.93,1.09,1.25,1.25,16.27,16.40,17.22,17.30,17.17,16.57,15.93,15.30,14.77,14.25,14.26,14.98,15.64,16.21,16.57,16.85,16.85,16.13,15.64,15.57,14.38,13.09,11.82,10.30,9.37,8.89,8.59,8.27,7.93,7.64,7.50,7.50,7.50,7.50,7.50,7.50,7.48,7.48,7.46,7.36,7.18,6.97,6.72,6.53,6.38,6.28,6.25,6.25,6.23,6.23,6.22,6.18,6.05,5.77,5.47,5.27,5.10,5.01,5,5,5,5,5,5,5,5,5,5,5,5,4.95,4.63,4.09,3.79,3.76,3.76,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.43,3.73,3.89,4.05,4.05,4.32,5,5,5,3.75,3.75,3.75,3.75,3.75,2.50,3.68,3.54,3.43,3.40,1.55,0.77,0.29,-0.38,-0.92,-1.55,-4.38,-6.84,-8.36,-9.17,-9.51,-9.64,-10,-11,-10,-8.63,-7.65,-6.78,-7.61,-9.35,-9.80,-10,-9.98,-10,-10,-9.15,-8.93,-8.59,-7.77,-7.61,-7.75,-8.36,-8.75,-9.22,-9.40,-7.93,-6.51,-4.72,-2.54,-1.39,-0.11,1.38,2.76,3.92,5.27,6.38,10,10,10,10,12.50,11.25,8.43,6.09,4,2.02,0.30,-2.18,-5.61,-9,-11,-12,-10,-8.65,-5.35,-1.99,0.30,1.25,2.48,4.39,6.43,8.05,8.72,8.75,8.93,9.26,9.93,10.52,10.73,9.84,8.75,11.25,11.25,10,10,10,11.25,12.50,12.50,12.50,10,8.75,7.50,6.25,5,5,5,5,5,5,5,6.25,6.25,7.50,7.50,6.25,7.50,8.75,11.25,10,7.50,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.20,1.20,1.25,1.53,2.18,2.60,2.50,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.02,1.34,0.60,-0.02,-0.38,-0.28,-0.13,0.28,0.77,1.37,1.82,2.14,2.34,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.34,1.87,1.09,-0.13,-0.88,-2.01,-2.68,-2.66,-2.63,-2.25,-1.88,-1.40,-0.88,-0.27,0.45,1.25,1.25,1.25,1.25,0.93,0.46,0,-0.13,-0.13,0,0.30,0.62,0.93,1.23,1.25,15.11,15.14,16.22,16.52,17.18,16.09,15.39,15.10,14.64,14.23,14.25,15.12,15.93,16.54,16.86,17.02,16.86,16.39,15.93,15.57,15.59,13.32,11.72,10.39,9.36,8.89,8.59,8.27,7.93,7.63,7.50,7.50,7.50,7.50,7.50,7.48,7.48,7.48,7.47,7.39,7.32,7.09,6.87,6.67,6.50,6.37,6.28,6.26,6.25,6.23,6.22,6.20,6.09,5.90,5.57,5.29,5.11,5,5,5,5,5,5,5,5,5,5,5,5,5,4.95,4.68,4.05,4.03,4.01,3.93,3.89,3.86,3.77,3.75,3.75,2.50,2.50,2.34,2.34,2.50,2.80,3.21,3.59,3.86,3.75,3.75,3.75,2.50,2.50,2.77,2.34,1.82,1.39,1.25,1.25,1.23,0.93,0.60,0.14,-0.25,-0.89,-2.25,-6.50,-8.86,-10,-10,-10,-9.49,-8.64,-10,-9.84,-8.62,-7.43,-7.73,-9.10,-9.73,-10,-9.51,-9.25,-9.25,-9.60,-9.88,-9.84,-9.41,-8.52,-7.68,-8.13,-8.68,-9.26,-10,-9.79,-8.38,-6.48,-3.61,-1.88,-0.62,1.09,3.46,3.68,5,6.25,8.75,11.25,15,13.75,12.50,12.50,11.25,7.02,4.67,2.75,1.22,-0.27,-3.10,-6.93,-10,-12,-11,-9.84,-7.36,-4.25,-0.55,0.29,0.93,2.02,4.32,7,9.75,9.51,9.12,8.73,8.65,8.85,9.10,9.12,8.97,8.75,8.75,7.50,7.50,7.50,10,11.25,12.50,13.75,11.25,10,8.75,6.25,6.25,5,5,5,5,5,5,5,5,6.25,6.25,6.25,6.25,6.25,8.75,8.75,8.75,6.25,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,2.50,2.50,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.45,1.55,0.93,0.57,0.30,0.30,0.76,1.25,1.71,2.14,2.34,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.34,1.37,0.88,-0.63,-0.98,-1.34,-1.87,-1.97,-1.79,-1.74,-1.41,-0.93,-0.13,0.76,1.25,1.25,1.25,1.25,0.93,0,-0.41,-0.63,-0.63,-0.40,-0.05,0.40,0.77,1.21,1.25,15.01,15.14,16.03,16.07,15.93,15.32,15.15,14.87,14.53,14.21,14.25,15.43,16.39,17.12,17.45,17.35,17.04,16.57,16.07,15.46,14.52,13.22,11.65,10.25,9.34,8.89,8.59,8.27,7.93,7.61,7.50,7.50,7.50,7.50,7.50,7.50,7.48,7.48,7.47,7.46,7.37,7.22,7.03,6.85,6.65,6.51,6.39,6.29,6.26,6.25,6.23,6.21,6.13,6.05,5.93,5.27,5.10,5,5,5,5,5,5,5,5,5,5,5,5,5,4.96,4.82,4.71,4.77,4.79,4.84,4.87,4.93,5,3.75,3.27,2.34,1.67,1.25,1.21,1.37,1.71,2.29,2.80,3.43,3.39,3.27,2.50,2.50,2.45,2.15,1.55,0.71,-0.05,-0.38,-0.40,-0.63,0.75,0,-1.02,-1.99,-3.12,-5.11,-7.72,-10,-11,-11,-10,-9.53,-8.27,-10,-10,-9.90,-8.25,-8.24,-10,-10,-9.88,-9.72,-9.17,-9.27,-10,-10,-10,-10,-9.12,-8.13,-7.63,-8.13,-9.61,-10,-10,-8.65,-5.75,-3.13,-1.30,0.30,2.18,4.95,5,7.50,8.75,11.25,15,15,15,13.75,12.50,7.50,5.14,2.64,1.23,0.13,-1.41,-3.52,-7.61,-10,-10,-9.93,-8.28,-5.86,-3.25,-0.77,-0.25,0.46,1.25,3.52,7.87,9.53,9.55,8.84,8.35,8.10,8.03,8.09,8.09,8.10,8.59,7.50,6.25,6.25,7.50,8.75,8.75,10,11.25,10,7.50,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,6.25,7.50,8.75,7.50,6.25,6.25,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,2.50,2.50,2.50,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.09,1.04,1.23,1.50,2.28,2.34,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.39,0.93,-0.75,-0.18,-0.38,-0.64,-1.11,-1.23,-1.12,-0.75,0.10,0.77,1.09,1.22,1.20,1.09,0.30,-0.38,-0.88,-1.13,-1.13,-0.79,-0.38,0.14,0.72,1.20,1.25,15,15.13,16.05,15.25,15.28,15.14,14.97,14.71,14.53,14.21,14.82,15.77,17.02,18.15,18.26,17.84,17.30,16.82,16.25,15.46,14.35,12.96,11.54,10.17,9.30,8.89,8.59,8.27,7.92,7.60,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.48,7.48,7.48,7.46,7.36,7.23,7.04,6.87,6.70,6.54,6.39,6.29,6.25,6.23,6.22,6.20,6.14,5.96,5.27,5,5,5,5,5,5,5,5,5,5,5,5,5,5.01,5,5,4.98,4.98,4.97,4.97,4.98,5,5,5,2.80,1.68,0.77,0.14,0,0.14,0.60,1.36,2.02,2.80,2.89,2.80,2.59,2.18,2.01,1.87,0.93,-0.05,-0.91,-1.39,-1.63,-1.39,-2.13,-2.50,-2.92,-4.11,-5.28,-6.99,-9.27,-12,-13,-12,-11,-8.91,-9.86,-11,-12,-10,-8.87,-8.60,-9.87,-10,-10,-9.63,-9.01,-9.55,-10,-11,-11,-10,-9.35,-8.39,-7.27,-7.88,-9.63,-10,-10,-8.40,-5.25,-2.85,-1,1.11,3.89,7.50,7.50,8.75,11.25,13.75,16.25,15,16.25,14.95,9.21,5.93,3.10,1.36,0,-0.76,-2.26,-5.72,-8.54,-10,-9.92,-8.50,-6.74,-4.60,-2.47,-0.63,-0.38,-0.88,1.25,1.26,9.53,10.51,9,8.21,7.68,7.40,7.30,7.29,7.28,7.29,7.05,6.37,6.25,6.25,6.25,6.25,7.50,7.50,8.75,8.75,6.25,5,5,5,5,5,5,5,5,5,5,5,6.25,5,5,6.25,7.50,7.50,6.25,6.25,6.25,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.34,1.38,0.93,0.62,0.62,0.26,-0.16,-0.52,-0.64,-0.50,0.14,0.71,1.09,1.21,1.09,0.77,0,-0.67,-1.25,-1.50,-1.42,-1.13,-0.63,-0.01,0.62,1.09,1.25,15,15.12,15.14,15.14,15,14.93,14.77,14.57,14.17,14.18,14.88,15.92,17.28,19.46,19.40,18.14,17.43,16.87,16.87,15.62,14.37,12.97,11.54,10.18,9.30,8.88,8.61,8.27,7.92,7.59,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.53,7.59,7.59,7.50,7.35,7.18,6.98,6.73,6.54,6.38,6.28,6.25,6.23,6.22,6.18,5.92,5.28,5.01,5,5,5,5,5,5,5,5,5,5,5.01,5.15,5.21,5.18,5.17,5.14,5.13,5.10,5.02,5,5,6.25,3.75,2.34,0.77,-0.13,-0.63,-0.80,-0.65,-0.38,0.30,1.09,1.96,2.02,2.18,2.15,1.84,1.39,1.05,0.25,-0.54,-1.28,-2,-2.76,-3.63,-4.63,-5.38,-5.50,-6.17,-7.05,-8.38,-10,-12,-13,-12,-11,-9.52,-11,-11,-12,-10,-8.66,-8.23,-8.61,-9.29,-9.49,-8.38,-9.23,-10,-10,-11,-11,-11,-10,-8.77,-7.43,-7.61,-8.55,-9.51,-9.05,-7.75,-5.14,-2.51,-0.88,1.65,4.52,8.75,8.75,10,11.25,13.75,16.25,15,16.25,10.12,6.70,3.25,1.25,-0.13,-0.88,-1.64,-4.30,-7.15,-9.36,-10,-9.04,-7.35,-5.47,-3.47,-1.80,-0.77,0.14,-0.88,-1,7.50,11.22,9.84,8.13,7.32,6.87,6.68,6.61,6.60,6.60,6.52,6.34,5.92,5,5,5,5,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.34,1.39,1.55,1.55,1.37,1.09,0.71,0,-0.38,-0.51,0.59,1.09,1.20,1.09,0.55,-0.38,-1,-1.50,-1.75,-1.63,-1.26,-0.75,-0.13,0.55,1.09,1.25,14.98,15,14.97,14.84,14.72,14.68,14.68,14.07,13.89,14.05,14.65,15.77,16.71,18.22,18.25,18.21,17.18,16.59,16.09,15.62,14.50,13.14,11.71,10.30,9.32,8.87,8.63,8.28,7.92,7.53,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.52,7.62,7.76,7.82,7.82,7.71,7.52,7.29,7.02,6.71,6.52,6.37,6.27,6.25,6.22,6.14,5.88,5.32,5.03,5,5,5,5.01,5.03,5.04,5.04,5.04,5.03,5.03,5.17,5.17,6.09,6.10,6.11,6.13,6.18,6.22,6.25,6.25,6.25,5,3.27,1.80,0.46,-0.42,-1,-1.25,-1.38,-1.13,-0.54,0,0.75,1.09,1.37,1.53,1.09,0.61,0.14,-1.03,-1.74,-2.38,-3.02,-4.16,-5.87,-7.43,-8.64,-8.18,-8.27,-8.63,-9.47,-10,-12,-12,-11,-9.23,-9.13,-11,-11,-10,-9.13,-6.89,-6.67,-7.59,-7.91,-8.60,-9.63,-9.61,-10,-11,-11,-11,-11,-10,-9.48,-8.14,-7.05,-7.54,-8.80,-8.78,-7.10,-4.88,-2.48,-0.75,1.53,4.05,6.25,8.75,13.75,12.50,13.75,13.75,13.75,12.50,7.34,2.96,1.25,-0.25,-1,-1.75,-3.05,-6.10,-8.64,-10,-9.73,-8.03,-6.10,-4.12,-2.37,-1.38,-0.25,0.42,7.34,8.75,8.75,9.84,7.67,6.85,6.20,6.09,5.97,5.95,5.97,5.98,5.93,5.77,5.46,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,5,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.46,2.14,2.02,2.02,1.71,0.93,-0.51,-1,0.30,0.87,0.93,0.60,-0.04,-0.75,-1.25,-1.66,-1.88,-1.75,-1.38,-0.76,-0.13,0.46,1.09,1.25,14.96,14.88,14.85,14.82,13.93,13.95,13.75,13.52,13.42,13.54,14.05,14.84,15.46,16.71,17.22,17.17,16.70,16.05,15.46,14.85,14.40,13.27,11.89,10.47,9.30,8.92,8.70,8.29,7.90,7.52,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.59,7.64,7.79,7.96,8.22,8.21,8.15,7.86,7.62,7.32,7.02,6.71,6.51,6.35,6.26,6.22,6.13,5.82,5.35,5.11,5.03,5.02,5.01,5.01,5.15,5.21,5.21,5.21,5.17,5.17,5.14,6.12,6.13,6.29,7.45,6.26,7.50,6.25,6.25,5,5,3.75,2.50,1.25,0.14,-0.63,-1.16,-1.63,-2.23,-2.42,-2.25,-1.79,-1.27,-0.67,-0.34,0,-0.73,-1.13,-1.75,-2.76,-3.50,-4.05,-4.60,-5.75,-7.75,-9.75,-11,-11,-10,-9.78,-10,-11,-11,-12,-11,-9.54,-8.97,-8.87,-8.10,-7.49,-6.77,-6.25,-6.10,-6.55,-7,-8.99,-10,-10,-10,-11,-11,-11,-11,-10,-9.89,-8.63,-7.02,-7.35,-8.28,-7.98,-6.54,-4.64,-2.63,-0.66,1.09,3.27,5,8.75,12.50,15,15,12.50,11.25,6.88,2.75,1.67,0,-0.88,-1.65,-3.50,-5.52,-7.62,-9.37,-10,-9.01,-7.05,-4.66,-2.50,-1.13,-0.66,0.62,6.09,8.70,10,9.87,7.65,6.53,5.87,5.55,5.34,5.30,5.32,5.43,5.47,5.48,5.42,5.18,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,-1,0.39,0.77,0.62,0.14,-0.38,-1,-1.52,-1.79,-1.93,-1.80,-1.38,-0.77,-0.13,0.62,1.09,1.25,14.97,13.78,13.86,13.87,13.59,13.53,12.77,12.79,12.80,12.84,12.89,14.14,15.15,16.04,16.67,16.71,16.25,15.46,14.79,14.21,13.70,13.21,11.98,10.50,9.65,9.05,8.73,8.29,7.93,7.61,7.50,7.50,7.50,7.50,7.50,7.50,7.52,7.65,7.82,8.01,8.25,8.42,8.46,8.34,8.17,7.92,7.64,7.34,7.02,6.67,6.46,6.34,6.23,6.12,5.88,5.36,5.35,5.30,5.29,5.26,5.18,5.15,6.09,6.10,6.11,5.09,5.03,6.22,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,3.75,3.75,2.50,1.87,0.87,0.13,-0.51,-1.14,-2.52,-3.60,-4.23,-4.29,-3.93,-3.37,-2.47,-2.34,-2.24,-2.75,-3.25,-4.01,-4.85,-5.50,-5.84,-6.13,-7.15,-9,-11,-13,-13,-11,-10,-10,-12,-12,-11,-11,-9.42,-7.37,-5.87,-5.15,-4.78,-4.75,-4.88,-5.09,-5.75,-6.75,-8.60,-10,-10,-10,-10,-11,-11,-10,-10,-9.80,-8.59,-7.52,-7.13,-7.39,-7.13,-6.10,-4.59,-2.47,-0.67,0.57,1.25,5,11.25,16.25,17.50,17.50,15,8.90,2.77,1.55,0.14,-0.75,-1.51,-2.78,-5.25,-7.50,-9.25,-9.68,-9.52,-7.90,-5.63,-3.25,-1.34,-0.13,1.03,2.46,6.87,10,11.25,9.84,7.75,6.25,5.73,5.30,5.13,5.10,5.10,5.14,5.15,5.18,5.14,5.10,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,7.50,8.75,7.50,8.75,8.75,8.75,7.50,6.25,6.25,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,0.77,0.77,0.59,0.11,-0.50,-1,-1.63,-2,-2.13,-2,-1.50,-0.75,0,0.71,1.09,1.25,13.75,13.75,13.61,13.59,12.64,12.68,12.75,12.68,12.67,12.61,12.84,13.84,14.97,15.92,16.55,17.02,16.09,15.15,14.21,13.54,12.97,12.70,12.01,10.97,9.86,9.18,8.75,8.32,7.96,7.64,7.53,7.50,7.50,7.50,7.50,7.50,7.59,7.76,8.12,8.22,8.42,8.57,8.59,8.53,8.39,8.17,7.92,7.63,7.30,7.02,6.60,6.38,6.26,6.18,6.03,5.89,5.87,5.88,5.92,5.95,6.02,6.05,6.10,6.22,6.13,6.18,6.21,6.25,6.25,6.25,6.25,5,5,5,5,3.75,3.75,3.75,2.50,1.55,0.71,-0.13,-0.75,-2.16,-3.84,-5.38,-6.50,-6.98,-6.74,-6,-4.92,-4.77,-4.75,-5.05,-5.55,-6.30,-6.91,-7.47,-7.49,-7.25,-8.04,-9.65,-11,-11,-11,-10,-9.50,-10,-12,-13,-11,-8.34,-7.62,-5.18,-2.40,-2.74,-2.68,-3.02,-3.55,-4.09,-5,-6.11,-8.10,-9.54,-9.89,-10,-10,-10,-11,-10,-10,-9.62,-8.48,-8.25,-7.39,-6.98,-6.36,-5.15,-3.85,-1.79,-0.52,0.39,1.25,5,10,16.25,17.50,16.25,13.86,6.55,2.63,0.43,-0.52,-1.38,-2.78,-4.74,-6.90,-8.88,-10,-9.77,-8.64,-6.59,-4.29,-2.16,-0.50,0.89,2.76,7.50,8.75,10,10,8.88,7.50,6.25,5.72,5.32,5.14,5.02,5.01,5.02,5.09,5.10,5.01,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,7.50,7.50,7.50,8.75,8.75,8.75,7.50,7.50,6.25,6.25,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,2.50,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.39,1.09,0.76,0.14,-0.38,-0.88,-1.41,-1.75,-2.01,-2,-1.40,-0.63,0.14,0.88,1.09,1.25,13.75,13.71,12.59,12.63,12.64,12.51,12.64,13.45,12.64,12.59,12.80,13.75,14.97,16.05,17.04,17.03,16.18,15,13.89,12.96,12.64,12.45,12.01,11.09,9.98,9.18,8.75,8.42,8.07,7.80,7.63,7.51,7.50,7.50,7.50,7.50,7.59,7.76,7.98,8.27,8.52,8.61,8.70,8.63,8.55,8.40,8.23,7.92,7.61,7.20,6.71,6.52,6.36,6.25,6.20,6.14,6.14,6.18,6.18,6.21,6.22,6.25,6.25,6.25,6.25,6.27,6.25,6.25,7.50,6.25,5,5,5,5,3.75,3.75,3.75,2.50,2.50,1.09,0.25,-0.42,-1.02,-3.16,-5.28,-7.38,-9.25,-10,-10,-9.36,-7.77,-7.11,-7.12,-7.18,-7.63,-8.15,-8.63,-9.25,-8.63,-7.34,-6.86,-8.47,-9.10,-9.09,-9.64,-9.01,-9.98,-10,-11,-11,-9.78,-7.51,-6.11,-3.17,-0.63,-0.98,-1.13,-1.64,-2.38,-3.15,-4.17,-5.26,-6.66,-8,-9.09,-9.47,-10,-10,-10,-10,-10,-9.28,-8.63,-7.88,-7.25,-6.42,-5.41,-3.97,-1.75,-0.89,-0.38,1.20,1.25,6.25,8.75,12.50,13.75,12.50,8.12,2.67,1.52,-0.11,-1,-1.85,-4.34,-6.49,-8.62,-10,-11,-9.61,-7.72,-5.55,-3.22,-1.25,-0.03,1.55,3.71,10,10,10,10,7.65,7.50,6.34,5.76,5.30,5.13,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,7.50,8.75,7.50,8.75,8.75,10,10,8.75,7.50,7.50,6.25,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.87,1.51,1.07,0.55,-0.04,-0.52,-1.03,-1.29,-1.50,-1.38,-0.88,-0.25,0.43,0.93,1.09,1.25,13.75,12.50,12.53,12.50,12.50,12.50,12.62,12.64,12.64,12.53,12.80,13.78,15.01,16.36,17.27,17.28,16.34,14.84,13.60,12.80,12.35,12.13,12.01,10.87,9.85,9.21,8.78,8.52,8.25,7.96,7.76,7.60,7.50,7.50,7.50,7.50,7.52,7.65,7.96,8.26,8.52,8.62,8.71,8.72,8.63,8.59,8.42,8.27,7.89,7.50,7.09,6.71,6.53,6.39,6.37,6.35,6.34,6.34,6.29,6.29,6.29,6.40,6.38,6.35,6.27,6.26,7.50,7.50,6.25,6.25,5,5,5,5,3.75,3.75,3.75,2.50,1.25,0.46,-0.38,-1,-1.63,-4.22,-6.65,-9.27,-12,-15,-16,-13,-9.61,-8.97,-8.88,-9.13,-9.13,-9.53,-9.17,-9.22,-8.47,-7.11,-5.87,-6.38,-7.51,-9.01,-10,-10,-10,-10,-11,-10,-8.63,-7.52,-5.73,-1.90,-0.25,0.60,0.43,-0.41,-1.25,-2.26,-3.38,-4.43,-5.54,-6.86,-7.60,-8.66,-9.52,-10,-10,-10,-9.50,-8.63,-8.14,-7.72,-6.90,-5.86,-4.50,-2.78,-0.27,-0.26,0.62,1.25,3.75,6.25,10,10,11.25,8.75,5.88,2.80,0.40,-0.63,-1.63,-3.34,-6.27,-8.55,-10,-11,-11,-9.27,-7.04,-4.63,-2.52,-0.89,0.14,2.32,5.62,10,10,11.25,10,9.79,7.64,6.50,5.77,5.30,5.13,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,7.50,8.75,10,10,11.25,10,11.25,11.25,10,8.75,6.25,6.25,5,6.25,5,5,5,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.28,1.85,1.39,1.03,0.46,-0.05,-0.50,-0.67,-0.75,-0.63,-0.25,0.14,0.72,1.04,1.20,1.25,12.50,12.50,12.50,12.48,12.34,12.32,12.29,12.34,12.50,12.64,12.80,13.92,15.17,16.60,18.32,18.30,16.34,14.55,12.95,12.50,12.02,11.57,11.09,10.46,9.70,9.21,8.87,8.59,8.39,8.12,7.82,7.63,7.50,7.50,7.50,7.50,7.50,7.63,7.84,8.13,8.43,8.60,8.71,8.72,8.72,8.64,8.59,8.43,8.27,7.86,7.48,7.09,6.71,6.71,6.68,6.67,6.64,6.59,6.55,6.55,6.55,6.53,7.23,7.30,7.35,7.37,7.38,7.39,7.39,6.20,5.01,5,5,3.75,3.75,3.75,3.75,2.50,1.25,-0.13,-0.92,-1.63,-2.91,-5.14,-7.75,-10,-13,-17,-17,-14,-11,-9.14,-9.23,-9.97,-9.49,-8.40,-7.51,-7.23,-7.13,-6.50,-5.88,-5.88,-7.25,-11,-13,-13,-12,-11,-10,-9.88,-8.52,-7.01,-5.09,-1.89,-0.17,1.09,1.23,0.60,-0.63,-1.68,-2.75,-3.79,-4.77,-5.79,-6.98,-7.87,-8.49,-9,-9.17,-9,-8.43,-7.72,-7.72,-7.63,-6.62,-5.36,-3.80,-2.12,-0.80,-0.13,0.77,2.50,3.75,6.25,11.25,10,8.75,8.75,4.68,2.02,-0.13,-1.25,-2.78,-6.01,-8.04,-10,-11,-12,-11,-9.12,-6.55,-4,-1.47,-0.75,0.93,1.25,6.25,8.75,11.25,11.25,11.09,9.53,8.12,6.82,5.93,5.46,5.17,5.11,5.01,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,7.50,10,11.25,11.25,10,11.25,11.25,11.25,11.25,8.75,7.50,6.25,6.25,5,5,5,5,3.75,3.75,3.75,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.43,2.14,1.87,1.54,1.09,0.61,0.14,-0.02,-0.02,0.13,0.42,0.73,0.93,1.09,1.23,1.25,12.50,12.50,12.48,12.43,12.36,11.39,11.39,12.28,12.34,12.77,13.43,14.05,15.30,17.14,18.37,18.32,16.04,14.17,12.92,12.05,11.64,11.09,10.45,10.13,9.64,9.21,8.89,8.70,8.46,8.22,7.92,7.64,7.51,7.50,7.50,7.50,7.50,7.59,7.76,8.01,8.30,8.57,8.68,8.72,8.73,8.73,8.70,8.61,8.45,8.27,7.85,7.48,7.18,7.04,7.04,7.04,7.07,7.07,7.09,7.12,7.12,7.13,7.23,7.38,7.47,7.63,7.65,7.64,7.34,6.25,5.10,5,4.97,3.75,3.75,3.75,3.75,2.45,1.07,-0.25,-1.18,-2.25,-3.85,-5.77,-8.29,-11,-14,-16,-15,-13,-11,-8.51,-8.15,-8.09,-8.04,-7.03,-6.68,-6.98,-7.09,-7.03,-7.25,-7.17,-9,-12,-15,-15,-14,-12,-10,-9.75,-9.03,-6.65,-3.87,-1.88,0.13,1.87,2.59,1.50,-0.25,-1.38,-2.38,-3.28,-4.25,-5.18,-6.16,-7.18,-7.79,-8.04,-8.11,-7.89,-7.55,-7.93,-8.27,-7.42,-6.38,-5.17,-3.26,-1.76,-0.89,-0.02,1.25,2.50,3.75,6.25,10,8.75,8.75,6.25,4.15,1.25,-0.66,-1.88,-4.28,-8.13,-9.53,-11,-12,-12,-10,-8.61,-6.14,-3.62,-1.22,0.77,1.55,3.75,6.25,10,11.22,11.39,11.03,10.59,8.30,6.98,6.09,5.50,5.27,5.14,5.14,5.14,5.12,5.02,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,7.50,7.50,8.75,10,10,10,11.25,11.25,11.25,10,8.75,7.50,6.25,6.25,5,5,5,5,3.75,3.75,3.75,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,2.50,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.34,2.18,1.98,1.70,1.25,0.93,0.76,0.76,0.93,1.09,1.18,1.21,1.25,1.25,1.25,12.50,12.50,12.48,12.46,11.35,11.38,11.39,11.40,12.28,12.75,13.61,14.84,16.25,17.59,18.39,17.12,15.35,13.60,12.36,11.67,11.23,10.79,10.30,9.97,9.55,9.21,8.89,8.72,8.53,8.26,7.95,7.64,7.51,7.50,7.50,7.50,7.50,7.51,7.64,7.85,8.14,8.43,8.59,8.70,8.72,8.73,8.73,8.71,8.62,8.46,8.27,7.79,7.50,7.37,7.34,7.34,7.30,7.29,7.30,7.32,7.34,7.35,7.38,7.45,7.51,7.75,8.52,8.53,7.47,6.39,5.14,5,4.89,3.78,3.75,3.75,3.75,2.34,0.93,-0.43,-1.50,-2.80,-4.50,-6.43,-8.54,-10,-12,-12,-12,-10,-8.86,-8.27,-8.02,-7.64,-6.63,-6.90,-7.50,-7.92,-8.38,-8.38,-8.40,-8.34,-9.79,-13,-15,-15,-15,-12,-10,-10,-8.68,-6.10,-3.03,-1.49,0.88,4.17,4.23,2.50,-0.03,-1.41,-2.25,-3.04,-3.90,-4.86,-5.87,-6.79,-7.47,-7.26,-7.04,-6.92,-7.66,-8.15,-8.34,-7.72,-6.59,-4.47,-3,-1.67,-0.61,0.59,1.87,3.75,5,6.25,7.50,10,7.50,5.73,3.29,1.07,-0.80,-1.93,-4.50,-8.38,-10,-12,-13,-12,-10,-8.23,-5.67,-3.23,-0.67,0.77,3.43,5,7.59,11.09,12.18,11.89,11.25,10.28,8.53,7.12,6.20,5.62,5.30,5.26,5.27,5.30,5.29,5.14,5.02,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,7.50,8.75,8.75,10,10,12.50,11.25,12.50,11.25,10,8.75,7.50,6.25,6.25,5,5,5,5,3.75,3.75,3.75,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.46,2.34,2.29,2.14,1.87,1.71,1.39,1.25,1.09,1.21,1.23,1.23,1.25,1.25,1.25,12.50,12.50,12.50,11.25,11.28,11.25,11.25,11.39,12.29,12.68,14.01,15.28,17.18,18.43,18.40,16.21,14.64,12.85,11.60,11.25,10.82,10.40,10.14,9.88,9.52,9.20,8.89,8.72,8.53,8.26,7.95,7.64,7.51,7.50,7.50,7.50,7.50,7.50,7.59,7.75,7.96,8.26,8.47,8.62,8.72,8.73,8.73,8.75,8.72,8.62,8.39,7.93,7.75,7.54,7.50,7.43,7.39,7.39,7.39,7.43,7.43,7.45,7.46,7.48,7.53,7.80,8.45,8.48,8.47,6.46,5.18,5,4.84,3.86,3.75,3.75,3.75,2.18,0.77,-0.63,-1.75,-3.26,-5,-6.88,-8.85,-10,-10,-10,-8.91,-8.17,-9.05,-10,-10,-9.25,-7.99,-7.47,-8.13,-8.80,-9.28,-9.28,-9.23,-9.13,-9.12,-11,-13,-13,-13,-11,-10,-10,-7.87,-4.67,-2.77,-0.76,2.28,5.34,6.02,2.50,-0.13,-1.51,-2.04,-2.76,-3.59,-4.49,-5.50,-6.76,-7.29,-7.12,-6.14,-6.42,-7.64,-8.28,-8.34,-7.50,-6.54,-4.11,-2.26,-1.50,-0.38,0.93,2.64,5,6.25,6.25,8.75,7.50,7.50,4.84,2.76,0.73,-0.90,-2.25,-4.24,-8.48,-11,-13,-14,-12,-10,-7.75,-5.02,-2.66,-0.63,0.87,1.52,7.34,9.79,12.15,13.27,12.96,11.64,9.84,8.57,7.27,6.27,5.71,5.39,5.30,5.32,5.47,5.46,5.28,5.10,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,5,6.25,7.50,8.75,8.75,10,10,12.50,12.50,15,13.75,11.25,10,8.75,6.25,6.25,5,5,5,5,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,3.75,2.50,2.50,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,12.50,12.50,11.25,11.25,11.25,11.25,11.36,11.39,12.64,13.89,15,16.36,18.45,17.27,16.34,15.10,13.59,12.34,11.39,10.87,10.35,10.15,10.02,9.84,9.52,9.20,8.89,8.73,8.54,8.27,7.95,7.64,7.51,7.50,7.50,7.50,7.50,7.50,7.50,7.61,7.77,8.07,8.37,8.59,8.71,8.73,8.73,8.75,8.75,8.71,8.54,8.29,7.89,7.67,7.59,7.51,7.48,7.47,7.47,7.47,7.47,7.48,7.48,7.50,7.59,7.92,8.39,8.59,8.43,6.53,5.26,5,4.79,3.89,3.75,3.70,2.50,1.87,0.55,-0.75,-1.88,-3.50,-5.26,-7.13,-8.98,-11,-10,-8.37,-7.51,-7.66,-10,-12,-12,-11,-9.17,-8.24,-8.48,-9.36,-9.79,-9.80,-9.88,-9.88,-9.50,-9.09,-9.68,-10,-10,-10,-9.78,-8.80,-6.63,-3.91,-2.49,-0.25,3.12,5.87,6.64,2.02,-0.26,-1.11,-1.80,-2.47,-3.22,-4.11,-5.13,-6.18,-7.30,-7.27,-6.49,-7.04,-7.63,-8.02,-7.74,-6.63,-5.18,-2.92,-1.63,-0.99,-0.13,0.72,2.46,8.75,7.50,7.50,7.50,6.25,5,3.75,2.01,0.39,-0.91,-2.75,-4.68,-8.88,-12,-15,-17,-14,-10,-7.22,-3.90,-1.75,-0.63,-0.80,1.43,8.54,12.18,12.80,14.21,13.76,11.96,10.42,8.89,7.61,6.42,5.75,5.45,5.30,5.34,5.59,5.48,5.30,5.09,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,7.50,8.75,8.75,10,11.25,13.75,13.75,16.25,11.25,10,8.75,7.50,6.25,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,12.50,11.25,11.25,11.25,11.25,11.25,11.34,12.35,13.59,14.97,16.09,17.28,17.22,16.04,14.82,13.59,12.50,11.55,11.09,10.32,10.15,10,9.98,9.84,9.52,9.20,8.89,8.73,8.54,8.27,7.93,7.64,7.51,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.62,7.84,8.15,8.46,8.63,8.72,8.73,8.75,8.75,8.72,8.68,8.53,8.29,7.96,7.77,7.63,7.52,7.50,7.50,7.48,7.48,7.50,7.51,7.53,7.63,7.86,8.30,8.47,8.40,7.17,5.30,5.15,4.77,3.93,3.75,3.62,2.52,1.39,0.14,-0.93,-1.89,-3.60,-5.35,-7.11,-8.74,-9.88,-9.50,-6.86,-6.38,-7.60,-10,-12,-13,-12,-10,-8.25,-8.63,-9.50,-10,-10,-10,-10,-10,-9.38,-8.50,-8.34,-8.92,-8.66,-8.23,-7.13,-5.09,-3.35,-1.93,0.59,3.43,6.21,6.37,0.93,0.79,-0.66,-1.49,-2.03,-2.79,-3.68,-4.67,-5.72,-6.62,-7.38,-7.63,-7.38,-7.28,-7,-6.60,-5.29,-3.54,-1.88,-1.12,-0.13,0.64,1.51,1.71,12.34,10.77,8.75,7.50,6.25,3.75,2.62,1.09,-0.03,-1.48,-3.87,-6.38,-10,-14,-18,-18,-16,-11,-7.09,-3.02,-0.63,-0.13,-0.93,1.40,7.46,12.04,14.21,13.93,13.59,12.30,10.79,9.37,7.96,6.75,5.90,5.46,5.29,5.30,5.43,5.62,5.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,7.50,8.75,8.75,11.25,12.50,12.50,11.25,11.25,11.25,8.75,7.50,6.25,6.25,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,11.25,11.25,11.25,11.25,11.25,11.25,11.28,12.60,14.85,16.09,17.32,17.29,15.18,14.82,13.59,11.53,11.53,11.39,10.93,10.30,10.02,10.01,9.96,9.84,9.52,9.20,8.89,8.73,8.54,8.27,7.93,7.64,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.52,7.67,7.96,8.27,8.53,8.70,8.73,8.75,8.75,8.75,8.72,8.68,8.48,8.23,7.97,7.78,7.64,7.54,7.52,7.51,7.51,7.52,7.54,7.67,7.76,7.86,7.97,8.38,8.37,7.54,6.53,5.30,4.72,3.96,3.75,3.59,2.39,1.10,-0.25,-1.25,-2.04,-3.50,-5.16,-6.87,-8.24,-9.10,-8.15,-7.24,-5.77,-6.48,-9.30,-12,-13,-12,-9.09,-7.51,-8.41,-9.63,-10,-10,-10,-10,-10,-9.67,-8.88,-8.18,-8.50,-7.88,-6.48,-5.01,-4.17,-2.55,-1.16,1.09,3.73,6.03,6.96,7.47,1.39,0.11,-0.75,-1.63,-2.28,-3.22,-4.16,-5.17,-6.23,-7.39,-7.88,-7.36,-6.93,-6.13,-5.50,-3.78,-2.16,-1.30,-0.25,0.95,2.30,1.38,6.25,12.61,10.47,10,6.25,5,3.55,1.52,0.46,-0.38,-2.61,-4.85,-7.35,-10,-17,-19,-19,-17,-13,-8.25,-3.40,-0.50,-0.13,1.09,1.51,9.65,11.89,13.43,13.87,13.43,12.60,11.27,9.84,8.40,7.12,6.09,5.45,5.18,5.14,5.18,5.15,5.01,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,5,6.25,6.25,7.50,8.75,10,10,10,11.25,10,10,7.50,7.50,6.25,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,13.68,14.87,17.35,17.34,15.14,14.84,13.93,12.75,11.50,11.42,11.25,10.93,10.28,10.14,10.02,9.96,9.80,9.52,9.20,8.89,8.73,8.55,8.27,7.93,7.64,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.53,7.70,7.97,8.42,8.63,8.73,8.75,8.75,8.75,8.75,8.72,8.61,8.42,8.22,7.98,7.80,7.71,7.67,7.65,7.64,7.65,7.68,7.80,8.13,7.80,7.98,8.28,8.45,8.34,7.18,6.09,5.01,4.03,3.88,3.57,2.34,0.97,-0.39,-1.39,-2.13,-3.43,-5,-6.54,-7.84,-8.63,-8.34,-6.62,-6.16,-5.75,-8.30,-11,-12,-11,-8.59,-7.53,-8.11,-9.42,-10,-10,-10,-10,-10,-9.63,-9.05,-9.13,-8.88,-7.75,-5.74,-3.92,-3.88,-2.11,0.14,0.45,4.52,6.20,7.45,8.43,1.71,1.65,-0.25,-1.15,-1.85,-2.64,-3.55,-4.50,-5.47,-6.24,-6.62,-6.77,-6.17,-5.11,-3.98,-2.50,-1.79,-0.92,0.30,2.34,5,7.45,8.75,10,10,8.75,6.25,3.71,0.93,0.71,0,-1.12,-3.25,-5.75,-8.30,-12,-18,-20,-20,-18,-16,-8.43,-2.99,-0.50,-0.13,-0.88,1.53,8.38,13.10,13.59,13.92,13.62,12.80,11.86,10.30,8.75,7.34,6.25,5.43,5.17,5.13,5.10,5.02,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,7.50,8.75,8.75,8.75,10,11.25,8.75,8.75,6.25,6.25,5,5,5,5,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,1.25,1.25,11.25,11.25,11.25,11.25,11.25,11.25,12.50,13.72,14.93,15.09,15,13.88,13.89,14.82,13.54,12.28,11.50,11.39,11.09,10.95,10.27,10.09,9.96,9.82,9.52,9.20,8.89,8.73,8.55,8.27,7.93,7.64,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.60,7.92,8.28,8.61,8.72,8.75,8.75,8.75,8.75,8.72,8.64,8.57,8.42,8.23,8.09,7.97,7.95,7.93,7.93,7.93,7.95,7.96,7.89,7.82,7.97,8.28,8.57,8.45,8.32,6.60,5.32,4.68,4.01,3.54,2.35,1.02,-0.38,-1.40,-2.13,-3.25,-4.86,-6.51,-7.80,-8.51,-8.79,-7.14,-5.88,-6.13,-7.54,-9.90,-10,-9.74,-8.91,-7.92,-8.37,-9.34,-10,-10,-10,-10,-10,-9.38,-9.52,-10,-10,-8.43,-6.38,-4.52,-4.01,-2.01,-1.77,0.63,4.80,6.25,8.43,8.27,9.47,2.34,0.55,-0.75,-1.36,-1.99,-2.80,-3.75,-4.63,-5.27,-5.62,-5.68,-4.99,-3.97,-2.88,-2.30,-1.63,-0.75,0.17,2.50,9.46,8.75,10,11.25,11.25,8.75,6.20,3.85,1.86,0.30,-0.30,-1.52,-4.37,-6.23,-9.26,-13,-17,-19,-19,-17,-13,-7.47,-2.88,-0.53,-0.55,1.04,1.54,9.55,12.28,13.90,14.97,13.85,13,11.88,10.62,8.87,7.37,6.26,5.46,5.25,5.10,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,8.75,8.75,8.75,8.75,10,8.75,8.75,6.25,6.25,5,5,5,5,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,1.25,11.25,11.25,11.25,11.25,11.25,11.25,12.50,13.75,13.75,13.76,13.84,13.75,13.59,13.59,12.64,12.32,12.29,11.39,11.22,10.97,10.27,10.10,9.97,9.84,9.52,9.20,8.88,8.73,8.57,8.27,7.93,7.64,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.53,7.80,8.22,8.53,8.70,8.75,8.75,8.75,8.75,8.73,8.71,8.64,8.57,8.45,8.34,8.28,8.27,8.27,8.27,8.26,8.23,8.10,7.90,7.78,7.89,8.21,8.47,8.60,8.37,8.34,6.60,5.30,4.03,3.52,2.48,1.22,-0.11,-1.04,-1.88,-3.12,-4.75,-6.47,-7.97,-8.76,-8.88,-8,-6.63,-7.04,-8.38,-9.50,-10,-9.98,-9.13,-7.88,-8.88,-9.99,-10,-11,-10,-10,-9.66,-9.24,-10,-12,-11,-9.75,-7.13,-4.73,-3.16,-2.29,-0.89,1.25,4.97,7.50,7.32,8.52,9.47,9.47,1.71,0.73,-0.50,-1.25,-1.80,-3.04,-3.84,-4.36,-4.50,-4.62,-3.09,-2.63,-2.52,-2.18,-1.66,-0.26,1.54,1.25,8.75,11.25,11.25,10,10,7.50,6.09,4.02,1.98,0.14,-0.67,-2.25,-4.10,-6.48,-9.63,-14,-18,-19,-19,-17,-10,-5.10,-1.49,-0.14,-1,1.40,5.89,10.71,12.80,13.75,13.75,14.64,12.80,11.64,10.28,8.84,7.37,6.22,5.62,5.27,5.10,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,5,5,5,6.25,6.25,8.75,7.50,7.50,7.50,7.50,6.25,7.50,6.25,6.25,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,11.25,11.25,11.25,11.25,11.25,12.50,12.50,13.75,13.75,13.73,13.71,12.53,13.62,12.36,11.38,11.39,11.39,11.39,11.23,11.04,10.25,10.10,9.98,9.84,9.54,9.20,8.88,8.75,8.59,8.27,7.95,7.64,7.51,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.51,7.67,8,8.42,8.63,8.75,8.75,8.75,8.75,8.73,8.72,8.71,8.64,8.61,8.57,8.54,8.53,8.53,8.54,8.53,8.46,8.28,8.02,7.82,7.80,7.98,8.27,8.53,8.64,8.42,8.37,6.39,5.01,3.85,2.70,1.57,0.39,-0.63,-1.50,-2.50,-4.55,-6.25,-7.62,-8.53,-9.15,-8.43,-7.99,-8.16,-8.75,-9.90,-10,-10,-9,-8.26,-8.99,-10,-10,-10,-10,-9.43,-9.25,-9.48,-11,-12,-12,-10,-7.11,-4,-2.62,-1.50,0.13,2.14,5,5,6.22,7.64,9.47,10.72,7.02,2.17,-0.13,-1,-1.65,-2.50,-3.12,-3.43,-3.50,-2.91,-2.63,-2.38,-2.13,-1.75,-1.03,0.93,1.59,7.50,11.25,10,11.25,10,8.75,7.50,5.93,4.05,1.89,0.11,-0.88,-2.38,-4.16,-6.42,-9.54,-13,-16,-18,-17,-13,-8.67,-4,-1.10,0.27,1.34,1.43,6.43,10.61,12.76,12.50,13.38,13.23,12.62,11.55,10.39,8.77,7.37,6.39,5.76,5.30,5.11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,7.50,6.25,6.25,6.25,7.50,6.25,6.25,6.25,5,5,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,11.25,11.25,11.25,11.25,12.50,12.50,12.50,12.50,12.50,13.75,12.50,12.47,11.26,11.28,11.35,11.25,11.25,11.25,11.23,11.07,10.20,10.11,10.03,9.95,9.57,9.17,8.89,8.77,8.61,8.39,8,7.78,7.62,7.52,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.60,7.92,8.29,8.62,8.75,8.75,8.75,8.75,8.73,8.73,8.73,8.72,8.71,8.70,8.68,8.68,8.68,8.68,8.64,8.60,8.45,8.25,7.97,7.79,7.80,8.01,8.45,8.84,8.96,8.52,7.43,5.93,4.02,3.21,2.07,0.92,-0.25,-1.25,-2.61,-4.38,-6.09,-7.48,-8.52,-9.39,-9.12,-8.50,-9.34,-9.88,-10,-10,-9.73,-9,-9.37,-9.85,-9.98,-10,-10,-9.50,-8.68,-8.26,-9.67,-11,-12,-11,-9.16,-5.77,-3.13,-2.13,-0.63,1.57,3.93,5,3.75,4.02,5.93,9.52,10.77,8.27,2.46,0.30,-0.75,-1.42,-2.16,-2.63,-2.63,-2.64,-2.63,-2.41,-1.88,-1.52,-0.92,0.46,2.78,6.25,10,11.25,8.75,10,8.75,6.25,6.25,5.77,4,1.87,-0.16,-1.25,-2.63,-4.48,-7.50,-10,-13,-15,-16,-14,-10,-6.25,-2.53,-0.27,0.73,1.97,4.03,7.20,10.29,12.18,12.98,13.11,12.96,12.45,11.72,11.02,9.37,7.92,6.68,5.93,5.40,5.13,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,7.50,7.50,7.50,6.25,6.25,6.25,5,3.75,3.75,3.75,3.75,3.75,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,11.25,11.25,11.25,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.23,11.10,10.15,10.25,10.28,10.26,9.86,9.14,9.15,8.90,8.72,8.52,8.27,7.98,7.82,7.65,7.51,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.52,7.65,7.93,8.26,8.54,8.68,8.72,8.73,8.73,8.73,8.73,8.73,8.73,8.73,8.73,8.73,8.73,8.73,8.72,8.71,8.68,8.59,8.42,8.13,7.85,7.71,7.96,8.40,8.96,9.54,9.57,8.38,6.55,5.18,3.89,2.70,1.45,0.27,-0.91,-2.47,-4.13,-5.80,-7.25,-8.50,-9.54,-9.63,-9.61,-10,-10,-11,-10,-10,-10,-10,-10,-10,-10,-10,-9.24,-8.12,-8.13,-9.60,-11,-11,-10,-7.42,-4.09,-2.63,-1.62,0.15,2.67,4.67,6.25,1.25,1.38,1.52,7.15,7.15,1.52,1.84,0.39,-0.38,-1.03,-1.76,-2.13,-2.13,-2.16,-2.16,-1.91,-1.25,-0.67,-0.13,1.71,7.50,9.37,12.50,8.75,7.50,6.25,6.25,6.25,6.25,5.28,3.75,1.71,-0.14,-1.38,-3.14,-5.51,-8.76,-11,-14,-15,-15,-12,-8.54,-5.10,-2.37,-0.39,0.72,2.48,5.29,8.12,11.55,12.95,13.60,13.43,12.96,12.63,12.05,11.12,10,8.37,6.87,5.95,5.42,5.14,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,7.50,8.75,7.50,7.50,6.25,6.25,5,3.75,3.75,3.75,3.75,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,11.25,11.25,11.25,12.50,13.75,13.75,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.26,11.28,11.28,11.25,11.25,11.25,11.09,10.93,10.30,10,9.57,9.14,8.77,8.68,8.52,8.38,8.27,7.80,7.53,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.52,7.65,7.90,8.21,8.45,8.61,8.71,8.73,8.73,8.72,8.72,8.72,8.73,8.73,8.73,8.73,8.73,8.72,8.72,8.71,8.68,8.62,8.52,8.26,7.92,7.70,7.84,8.27,8.93,9.54,9.57,8.63,7.34,5.95,4.77,3.28,1.96,0.59,-0.75,-1.99,-3.93,-5.62,-7.13,-8.50,-9.80,-9.86,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.52,-9.11,-8.03,-8.12,-9.88,-11,-11,-9.66,-5.75,-2.98,-2.37,-1.38,-0.11,2.18,3.57,1.09,1.18,0.40,1.39,2.34,2.46,1.55,0.43,0.90,0.25,-0.63,-1.13,-1.29,-1.38,-1.50,-1.51,-0.76,0.43,0.46,1.25,1.25,5,7.59,10.09,7.50,3.75,3.75,3.75,3.75,6.25,4.52,3.54,1.39,-0.38,-1.66,-3.72,-6.29,-10,-13,-15,-15,-13,-10,-7.15,-4.12,-1.99,-0.51,0.59,2.75,6.39,9.84,12.50,15.12,14.46,14.03,13.52,12.96,12.36,11.59,10.40,8.84,6.87,5.72,5.46,5.14,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,8.75,10,8.75,7.50,7.50,6.25,5,5,3.75,3.75,3.75,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,11.25,11.25,11.25,12.50,13.75,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,12.48,11.25,11.26,12.37,12.34,12.28,11.22,11.07,10.92,10.27,9.07,8.95,8.75,8.70,8.59,8.28,7.90,7.53,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.51,7.63,7.82,8.11,8.37,8.55,8.64,8.72,8.73,8.72,8.71,8.71,8.71,8.70,8.68,8.68,8.68,8.64,8.63,8.60,8.59,8.57,8.47,8.29,7.96,7.67,7.63,7.95,8.54,9.54,9.57,9.63,7.52,6.20,4.98,3.76,2.47,0.90,-0.63,-2.16,-3.79,-5.43,-6.99,-8.38,-9.79,-9.77,-10,-11,-12,-12,-12,-12,-12,-11,-11,-10,-9.63,-9.49,-9.15,-7.93,-8.05,-10,-11,-11,-9.63,-4.86,-2.75,-2.38,-1.63,-0.75,-0.13,0.14,-0.11,-0.51,-0.75,-0.38,0,0.14,0.01,-0.13,0.32,0.93,0,-0.25,-0.38,-0.50,-0.63,-0.43,0.14,2.17,6.40,7.50,6.25,1.39,1.40,2.02,2.64,1.96,1.71,1.87,2.34,2.50,2.96,2.96,1.39,-0.40,-1.88,-3.85,-8,-11,-14,-15,-14,-12,-9.35,-6.62,-4.05,-2.01,-0.51,1.09,2.50,8.27,11.84,14.05,15.14,15.25,14.62,13.76,13.21,12.60,11.87,11.64,9.01,7.30,6.18,5.47,5.14,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,7.50,8.75,11.25,10,8.75,7.50,6.25,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,11.25,11.25,12.50,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,12.50,12.50,12.50,12.45,12.36,11.39,11.39,11.34,12.17,10.88,9.98,9.14,8.96,8.76,8.59,8.27,7.92,7.53,7.51,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.60,7.75,7.96,8.22,8.43,8.59,8.70,8.72,8.70,8.68,8.64,8.61,8.59,8.55,8.54,8.53,8.52,8.47,8.42,8.37,8.37,8.37,8.21,8.07,7.37,7.15,7.37,7.85,8.37,8.59,8.38,7.28,6.10,5.15,4.20,3.01,1.09,-0.55,-2.15,-3.76,-5.38,-6.88,-8.29,-9.48,-10,-11,-12,-12,-13,-13,-13,-12,-11,-10,-9.59,-8.74,-8.93,-8.62,-7.50,-8,-9.85,-11,-11,-9.01,-5.47,-3.05,-2.42,-2,-1.61,-1.38,-1.27,-1.38,-1.65,-2.13,-1.63,-1.38,-1.13,-0.88,-0.51,0.46,0.93,1.03,1.04,0.93,0.77,0.28,0.30,1.25,1.25,8.75,12.50,10.09,1.40,-0.79,-0.37,-0.38,-0.30,-0.13,0.26,0.77,1.21,1.71,2.01,1.40,-0.30,-1.77,-2.99,-7.38,-10,-13,-13,-12,-10,-8.50,-5.97,-3.63,-1.50,-0.13,2.50,6.71,10.77,13.07,15.43,15.92,16.37,14.93,13.87,13.09,12.43,12.47,10.46,8.90,7.37,6.25,5.61,5.17,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,8.75,10,10,10,8.75,7.50,6.25,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,11.25,11.25,12.50,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.28,11.39,11.36,11.23,11.28,11.22,10.92,10.79,9.80,9.21,8.86,8.59,8.27,7.93,7.64,7.52,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.52,7.63,7.80,8.05,8.28,8.48,8.62,8.70,8.62,8.60,8.57,8.48,8.42,8.34,8.28,8.27,8.26,8.22,8.11,7.98,7.95,8,8.02,7.32,6.86,6.71,6.71,7.09,7.36,7.46,7.17,6.55,5.96,5.04,4.67,3.17,1.23,-0.63,-2.14,-3.75,-5.37,-6.92,-8.28,-9.60,-10,-11,-12,-12,-13,-13,-13,-12,-11,-10,-8.13,-7.64,-7.76,-7.55,-7.76,-8.43,-9.59,-10,-10,-8.36,-6.01,-4.38,-3.50,-3.05,-2.99,-3,-2.60,-2.41,-2.36,-3.13,-2.50,-2.16,-1.92,-1.49,-0.78,0.25,1.18,1.18,1.55,4.68,1.34,1.25,1.25,1.25,7.50,12.50,13.75,10.72,2.50,-0.17,-1.03,-1.25,-1.24,-1.16,-0.75,-0.25,0.29,1.04,1.52,1.09,-0.25,-1.67,-3.04,-7.13,-10,-12,-12,-11,-9.28,-7.16,-5.02,-3.05,-1.51,0.46,2.34,8.57,11.98,14.21,15.43,17.61,15.93,14.96,13.75,12.48,12.02,11.11,10,8.54,7.34,6.25,5.50,5.15,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,7.50,8.75,10,11.25,10,8.75,7.50,6.25,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,11.25,12.50,12.50,12.50,12.50,12.50,11.25,11.25,12.50,12.50,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.23,11.12,11.03,10.97,10.92,10.89,10.80,10.77,10.43,10.73,9.25,8.95,8.61,8.27,7.96,7.70,7.54,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.54,7.67,7.89,8.12,8.37,8.53,8.60,8.54,8.48,8.42,8.30,8.21,8.09,7.98,7.96,7.93,7.85,7.71,7.52,7.38,7.28,6.90,6.75,6.46,6.34,6.38,6.50,6.60,6.51,6.23,5.93,5.26,4.82,4.02,2.71,1.09,-0.63,-2.13,-3.76,-5.52,-7.18,-8.68,-9.92,-10,-10,-11,-12,-12,-12,-12,-12,-11,-9.65,-7.52,-7.14,-7.36,-8.67,-9.63,-9.63,-10,-10,-9.16,-8.52,-7.27,-6.22,-5.53,-5.93,-5.99,-5.50,-4.75,-4.10,-3.78,-3.55,-3.36,-3,-2.63,-2.38,-1.26,-0.88,-0.51,-0.02,1.21,1.38,1.25,1.20,1.09,1.39,1.39,9.34,8.75,5.62,2.80,0.02,-1.66,-2.51,-2.79,-2.60,-1.54,-0.75,-0.15,0.59,1.18,0.92,-0.38,-1.67,-3.34,-7.75,-10,-12,-11,-9.77,-7.79,-5.76,-3.90,-2.25,-1.04,2.02,8.53,10.93,12.04,13.89,15.63,16.12,15.90,14.68,13.70,12.62,11.39,10.76,9.65,8.57,7.43,6.39,5.50,5.10,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,7.50,8.75,11.25,10,10,10,8.75,6.25,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,13.75,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.21,11.18,11.09,10.25,10.28,10.32,10.35,10.29,10.18,10.12,9.84,9.50,9.02,8.63,8.27,7.96,7.71,7.59,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.51,7.60,7.75,7.95,8.14,8.34,8.43,8.39,8.29,8.23,8.11,7.96,7.84,7.76,7.68,7.64,7.53,7.36,7.12,6.87,6.67,6.51,6.35,6.23,6.07,5.93,5.88,5.88,5.88,5.30,5,4.77,4.82,3.45,2.28,0.76,-0.64,-1.75,-3.80,-5.84,-7.73,-9.26,-10,-10,-10,-11,-11,-12,-12,-12,-11,-10,-8.59,-7.50,-7.42,-8.85,-10,-11,-11,-10,-10,-8.75,-8.02,-7.88,-7,-7.76,-8.41,-8.88,-7.89,-6.37,-5.40,-4.79,-4.41,-4.11,-3.77,-3.47,-2.99,-2.26,-2,-1.90,-1.50,-1.04,-0.42,-0.15,-0.13,-0.13,0.14,1.53,2.96,3.86,2.90,1.20,-1.09,-2.88,-3.85,-4.25,-4.04,-3.01,-1.18,-0.38,0.17,0.93,0.47,-0.66,-2.03,-5.59,-9.10,-11,-13,-10,-8.77,-6.75,-4.87,-3.28,-2.02,-0.63,3.25,7.18,10.78,11.87,14,15.45,17.20,15.42,14.52,13.62,12.68,11.71,10.73,9.68,8.71,7.64,6.52,5.62,5.13,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,7.50,8.75,10,11.25,10,10,8.75,6.25,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.21,10.09,10.11,10.15,10.18,10.04,10,9.87,9.78,9.68,9.62,9.51,9.38,9.01,8.63,8.27,7.97,7.75,7.60,7.51,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.52,7.63,7.78,7.96,8.11,8.17,8.15,8.10,8,7.89,7.78,7.65,7.61,7.53,7.50,7.36,7.14,6.84,6.55,6.39,6.27,6.18,5.98,5.76,5.42,5.36,5.34,5.11,4.72,4.01,3.93,3.75,2.96,1.68,0.30,-0.88,-1.88,-4.02,-6.34,-8.55,-10,-11,-11,-9.88,-10,-10,-11,-11,-11,-9.87,-9.18,-8,-7.34,-7.84,-9.16,-11,-12,-12,-11,-9.76,-8.55,-7.89,-7.75,-7.91,-8.41,-9.36,-9.68,-8.84,-7.30,-6.27,-5.62,-5.15,-4.79,-4.50,-4.17,-3.88,-3.63,-3.50,-3,-2.63,-2.18,-1.68,-1.25,-1.03,-1.05,-0.75,-0.38,0.46,0.96,0.28,-0.65,-2.77,-4.40,-5.23,-5.55,-5.13,-3.80,-2.30,-0.41,0.17,0.47,0.17,-0.88,-3.36,-6.87,-9.88,-12,-13,-10,-7.92,-5.88,-4.09,-2.73,-1.75,-0.25,3,7.36,10.73,12.20,14.21,16.03,15.72,15.17,14.37,13.61,12.84,12.18,10.88,9.82,8.84,7.80,6.64,5.63,5.14,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,8.75,8.75,10,12.50,11.25,10,7.50,6.25,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,11.25,11.25,11.25,10,10.01,10.04,10.11,10.01,10.01,9.98,9.89,9.73,9.53,9.21,9.22,9.20,9.17,9.05,8.88,8.59,8.27,7.97,7.75,7.60,7.51,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.52,7.60,7.67,7.79,7.89,7.95,7.93,7.89,7.80,7.70,7.63,7.54,7.51,7.48,7.45,7.29,7.02,6.71,6.42,6.25,6.13,5.97,5.75,5.42,5.14,4.87,4.71,4.68,4.03,3.90,3.75,3.61,2.54,1.25,-0.13,-1.13,-2,-4.09,-7.13,-9.75,-11,-12,-11,-10,-9.85,-10,-10,-10,-10,-9.38,-8.05,-7.26,-6.79,-7.50,-8.40,-10,-12,-12,-11,-10,-8.65,-8.38,-7.50,-7.75,-8.22,-8.88,-9.50,-8.74,-7.53,-6.73,-6.14,-5.75,-5.41,-5.12,-4.88,-4.68,-4.50,-4.36,-4.03,-3.63,-3.24,-2.76,-2.37,-2.03,-1.78,-1.63,-1.47,-1.26,-1.18,-1.67,-2.49,-4.61,-6.05,-6.37,-6.18,-5.34,-3.74,-2.23,-0.25,0.27,0.39,-0.05,-1.16,-3.63,-6.12,-8.59,-10,-11,-9.13,-7.10,-5.22,-3.52,-2.13,-1.25,0.13,2.78,5.73,8.12,12.68,14.87,15.77,15.40,14.84,14.23,13.59,12.93,12.02,10.93,9.84,8.75,7.77,6.72,5.62,5.25,5.01,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,6.25,7.50,10,11.25,12.50,11.25,8.75,7.50,6.25,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,9.98,9.96,9.88,9.72,9.55,9.20,9.04,8.92,8.90,8.89,8.86,8.75,8.52,8.25,7.96,7.75,7.60,7.51,7.50,7.50,7.50,7.50,7.50,7.50,7.51,7.53,7.61,7.64,7.71,7.79,7.80,7.80,7.77,7.70,7.64,7.61,7.53,7.50,7.48,7.46,7.38,7.23,6.98,6.65,6.36,6.14,5.96,5.75,5.43,5.18,5,4.68,4.05,4.03,3.90,3.75,3.63,3.64,2.38,1.02,-0.27,-1.27,-2.03,-4.43,-7.49,-9.98,-11,-11,-10,-9.42,-8.92,-9.38,-9.75,-9.62,-9.25,-8.65,-7.63,-6.62,-6.25,-6.99,-8.13,-8.50,-9.61,-10,-10,-9.91,-9.26,-8.02,-6.90,-6.50,-7.27,-7.36,-7.87,-7.92,-7.23,-6.88,-6.52,-6.23,-5.85,-5.54,-5.39,-5.29,-5.22,-5.15,-4.92,-4.62,-4.25,-3.84,-3.40,-3.10,-2.80,-2.75,-2.73,-2.78,-2.98,-3.59,-4.50,-6.11,-6.88,-6.90,-6.09,-4.77,-3.25,-0.76,0.12,0.59,0.46,-0.28,-1.63,-3.50,-5.37,-7.13,-8.66,-8.92,-7.67,-6.14,-4.47,-2.92,-1.55,-0.64,0.62,2.50,4.03,9.30,12.47,14.52,15.28,15.15,14.68,14.15,13.53,12.80,11.98,10.88,9.68,8.59,7.62,6.68,5.89,5.30,5.01,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,7.50,6.25,7.50,8.75,7.50,6.25,5,5,5,5,5,5,5,6.25,6.25,8.75,10,12.50,11.25,11.25,8.75,7.50,6.25,5,5,5,6.25,5,6.25,5,6.25,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,9.98,9.98,9.98,9.98,9.96,9.89,9.73,9.59,9.17,9.01,8.86,8.78,8.76,8.76,8.75,8.70,8.46,8.23,7.96,7.75,7.60,7.51,7.50,7.50,7.50,7.50,7.50,7.52,7.61,7.67,7.79,7.90,7.96,7.96,7.95,7.85,7.75,7.62,7.59,7.52,7.50,7.48,7.47,7.45,7.35,7.18,6.87,6.54,6.25,5.98,5.75,5.45,5.20,5.03,4.96,4.68,4.03,3.79,3.75,3.73,3.62,3.07,2.27,1.09,-0.02,-1.01,-2.02,-4.85,-7.55,-10,-11,-11,-9.27,-7.77,-8.05,-8.51,-8.88,-8.80,-8.30,-7.93,-7.17,-6.11,-6.88,-7.75,-8.35,-8.64,-8.75,-9.39,-9.93,-9.88,-9.55,-8.38,-7.14,-6.63,-6.63,-6.72,-6.13,-6.25,-6.68,-6.50,-6.77,-6.38,-5.99,-5.76,-5.74,-5.75,-5.76,-5.86,-5.75,-5.52,-5.25,-4.88,-4.50,-4.17,-3.93,-3.99,-4.05,-4.26,-4.64,-5.37,-6.35,-7.37,-7.35,-6.75,-5.63,-4.13,-2.38,0,0.57,0.62,0.29,-0.79,-1.92,-3.25,-4.54,-5.75,-6.65,-6.75,-6.04,-4.92,-3.50,-2.18,-1.01,-0.01,1.39,3.59,6.59,10.46,13.76,15,15.32,15.14,14.65,14.03,13.30,12.61,11.71,10.76,9.50,8.37,7.34,6.52,5.93,5.14,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,7.50,8.75,10,10,8.75,6.25,6.25,5,5,5,5,6.25,6.25,6.25,7.50,8.75,12.50,12.50,12.50,11.25,8.75,7.50,6.25,5,5,5,6.25,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,9.98,9.98,9.98,9.98,9.96,9.85,9.68,9.50,9.25,9.05,8.89,8.79,8.76,8.75,8.75,8.71,8.62,8.43,8.22,7.96,7.75,7.60,7.51,7.50,7.50,7.50,7.50,7.52,7.63,7.77,7.96,8.13,8.27,8.30,8.27,8.13,7.96,7.78,7.62,7.51,7.50,7.48,7.47,7.45,7.39,7.30,7.05,6.73,6.39,6.05,5.76,5.46,5.20,5.04,5,4.95,4.72,3.96,3.76,3.72,3.62,3.70,2.77,2.02,1.25,0.11,-0.92,-2.61,-5.40,-7.78,-9.65,-10,-9.28,-7.50,-7.15,-7.50,-7.88,-8.40,-8.51,-8.24,-7.52,-6.42,-6.22,-7.63,-8.66,-9.98,-10,-10,-10,-10,-9.89,-9.55,-8.55,-7.38,-7.36,-7.23,-6.78,-6.40,-6.35,-6.27,-6.18,-6.38,-6,-5.68,-5.88,-5.89,-6.02,-6.22,-6.42,-6.61,-6.43,-6.25,-5.92,-5.63,-5.36,-5.18,-5.28,-5.43,-5.66,-6.11,-7,-8.10,-9.02,-7.73,-6.60,-5.25,-3.63,-1.75,-0.04,0.30,0.11,-0.26,-1.26,-2,-3.04,-3.75,-4.38,-4.85,-4.75,-4.34,-3.50,-2.39,-1.26,-0.63,0.14,1.71,4.54,8.27,12.67,16.10,15.77,15.75,15.30,14.52,13.75,13.09,12.32,11.42,10.46,9.30,8.11,7.21,6.38,5.28,5.14,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,7.50,8.75,11.25,13.75,12.50,8.75,7.50,6.25,5,5,5,6.25,7.50,8.75,8.75,7.50,10,12.50,12.50,12.50,11.25,8.75,7.50,6.25,5,5,5,5,5,5,6.25,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,9.98,9.98,9.98,9.89,9.85,9.68,9.47,9.23,9.04,8.89,8.79,8.76,8.75,8.73,8.73,8.70,8.60,8.42,8.21,7.96,7.75,7.60,7.51,7.50,7.50,7.50,7.51,7.60,7.75,7.97,8.29,8.59,8.76,8.72,8.54,8.27,8.01,7.79,7.61,7.51,7.50,7.47,7.46,7.39,7.35,7.23,6.96,6.55,6.12,5.77,5.45,5.21,5.09,5,4.97,4.80,4.79,3.90,3.75,3.62,3.70,2.50,2.32,1.71,1.02,-0.05,-1.78,-3.98,-6.12,-8.17,-9.38,-9.40,-8.04,-6.85,-6.73,-7.41,-7.98,-8.42,-8.38,-8.02,-7.54,-6.64,-6.75,-7.66,-9.22,-11,-12,-12,-12,-11,-9.50,-8.55,-7.66,-7.72,-7.84,-7.67,-7.29,-7.18,-7,-6.84,-6.75,-6.75,-6.75,-6.47,-5.92,-5.75,-6.04,-6.62,-7,-7.37,-7.38,-7.27,-6.99,-6.66,-6.42,-6.38,-6.63,-6.88,-6.98,-7.10,-7.77,-9.25,-9.59,-7.92,-6.73,-5.43,-3.86,-2.28,-0.75,-0.43,-0.66,-1.25,-1.88,-2.88,-2.97,-2.91,-3.05,-3.11,-2.98,-2.55,-1.84,-1,-0.51,-0.13,-0.88,1.37,5.32,9.25,12.62,16.07,15.80,16.80,15.32,14.05,13.28,12.64,12,11.18,10.28,9.01,7.89,6.64,7.15,5.25,5,5,5,5,5,5,5,6.25,6.25,6.25,6.25,6.25,5,5,6.25,6.25,6.25,6.25,6.25,8.75,12.50,13.75,15,12.50,10,7.50,6.25,6.25,6.25,6.25,6.25,8.75,10,7.50,8.75,11.25,13.75,12.50,13.75,11.25,8.75,7.50,6.25,5,5,5,5,5,5,5,6.25,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,10,9.98,9.97,9.93,9.84,9.68,9.48,9.22,9.03,8.88,8.78,8.75,8.75,8.75,8.73,8.73,8.70,8.60,8.40,8.17,7.96,7.76,7.61,7.51,7.50,7.50,7.50,7.52,7.63,7.82,8.13,8.59,8.96,9.03,8.96,8.57,8.23,7.95,7.71,7.59,7.51,7.50,7.47,7.45,7.37,7.30,7.13,6.97,6.34,5.84,5.45,5.26,5.10,5.01,4.98,4.95,4.82,3.89,3.87,3.64,3.70,2.50,2.50,1.65,1.04,0.30,-0.54,-2.65,-4.79,-6.88,-8.67,-10,-9.59,-7.73,-6.73,-7.28,-7.88,-8.17,-8.64,-8.65,-8.25,-7.49,-6.65,-6.60,-7.63,-8.78,-11,-12,-11,-11,-10,-8.54,-7.25,-7.73,-8.50,-8.62,-8,-7.73,-7.60,-7.38,-7.50,-7.48,-7.36,-7.35,-7.09,-6.51,-6.14,-6.40,-6.73,-7.10,-7.88,-8.76,-8.25,-7.84,-7.55,-7.29,-7.38,-7.79,-8.68,-8.50,-7.40,-6.73,-8.55,-8.79,-7.74,-7.05,-6.16,-4.93,-3.49,-1.90,-1.75,-1.88,-2.16,-2.67,-2.64,-2.38,-2.13,-1.76,-1.40,-1,-0.63,-0.13,0.55,1.39,1.87,1.37,1.42,7.03,9.68,11.82,13.12,13.87,13.87,13.59,13.10,12.62,12.18,11.67,10.95,10.01,9.09,6.84,7.14,6.23,5.14,5.09,5,5,5,5,5,6.25,7.50,8.75,10,8.75,7.50,6.25,7.50,8.75,7.50,6.25,6.25,7.50,8.75,12.50,13.75,15,12.50,10,7.50,6.25,6.25,6.25,6.25,7.50,8.75,10,8.75,11.25,13.75,13.75,13.75,12.50,11.25,8.75,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,9.97,9.89,9.85,9.68,9.48,9.23,9.03,8.88,8.78,8.75,8.75,8.75,8.75,8.73,8.73,8.70,8.60,8.40,8.17,7.96,7.76,7.61,7.51,7.50,7.50,7.50,7.52,7.63,7.82,8.13,8.55,9,8.89,8.68,8.37,8.02,7.79,7.64,7.54,7.50,7.48,7.47,7.45,7.36,7.23,7.01,6.54,6.02,5.43,5.27,5.12,5.02,4.98,4.96,4.84,4.86,3.85,3.70,3.72,2.50,2.50,1.25,0.77,0,-0.53,-1.75,-3.77,-5.66,-7.27,-8.41,-8.75,-7.86,-6.68,-6.85,-7.63,-8.13,-8.38,-8.63,-8.65,-8.24,-7.48,-6.68,-6.25,-6.73,-7.34,-8.91,-10,-10,-10,-9,-7.36,-7.22,-8.61,-9.37,-9.42,-8.88,-7.89,-7.64,-7.55,-7.89,-7.87,-7.75,-7.72,-7.64,-7.25,-6.76,-6.49,-6.64,-7,-7.72,-7.88,-7.67,-8.68,-7.79,-7.68,-7.88,-8.24,-8.88,-7.90,-6.88,-6.12,-6.09,-6.80,-7.43,-7.51,-7.03,-6,-4.60,-3.13,-3,-3,-2.75,-2.63,-2,-1.38,-1,-0.64,-0.25,0.40,1.03,1.87,2.76,4.15,5.46,5.90,7.34,9.17,10.62,11.25,11.55,11.64,11.70,11.85,11.87,11.82,11.68,11.39,10.88,10.27,8.25,6.73,6.20,6.09,6.25,6.25,6.25,6.25,7.50,6.25,6.25,6.25,7.50,7.50,10,11.25,10,10,10,11.25,10,8.75,7.50,7.50,10,11.25,12.50,15,12.50,8.75,7.50,7.50,7.50,6.25,6.25,7.50,8.75,10,8.75,12.50,15,13.75,12.50,12.50,10,7.50,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,9.98,9.95,9.85,9.68,9.48,9.23,9.03,8.88,8.78,8.75,8.75,8.75,8.75,8.75,8.73,8.73,8.70,8.60,8.40,8.17,7.96,7.77,7.62,7.52,7.50,7.50,7.50,7.51,7.61,7.75,7.96,8.26,8.43,8.43,8.26,8.01,7.80,7.65,7.60,7.52,7.50,7.47,7.46,7.39,7.34,7.27,7.05,6.29,5.39,5.30,5.13,5.03,5,4.96,4.84,4.86,3.84,3.75,3.75,2.50,2.50,1.25,1.25,-0.52,-0.88,-1.41,-3.13,-5.11,-6.76,-7.92,-8.38,-7.97,-7.13,-6.53,-6.85,-7.50,-8,-8.40,-8.41,-8.41,-8.14,-7.51,-6.84,-5.98,-5.79,-6.10,-6.50,-7.75,-8.66,-8.68,-8.14,-7.38,-7.91,-8.80,-9.50,-9.59,-9.05,-8.13,-7.39,-7.64,-7.97,-7.88,-8.22,-8.47,-8.38,-7.97,-7.49,-7.10,-6.54,-6.18,-6.38,-7.14,-7.54,-7.63,-7.50,-7.16,-8,-8.64,-7.89,-7.34,-6.54,-6.22,-6.91,-7.23,-7.51,-8.28,-7.92,-6.93,-5.50,-3.85,-3,-3,-2.75,-1.38,-0.88,-0.13,0.46,0.88,1.39,2.02,3.07,5,6.22,7.50,8.61,9.46,11.51,12.63,12.34,11.59,10.40,9.09,10.40,10.32,10.93,11.10,11.09,10.96,11.25,9.48,8.22,6.70,5.14,5.12,7.47,8.75,8.75,8.75,7.50,6.25,6.25,5,6.25,8.75,8.75,11.25,13.75,16.25,15,11.25,10,6.25,6.25,8.75,8.75,11.25,12.50,11.25,10,8.75,7.50,7.50,6.25,6.25,6.25,7.50,10,11.25,11.25,12.50,15,13.75,12.50,11.25,8.75,7.50,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,12.50,11.25,11.25,11.25,11.25,10,10,10,10,10,10,9.97,9.88,9.71,9.50,9.23,9.03,8.88,8.78,8.75,8.75,8.75,8.75,8.75,8.75,8.73,8.73,8.70,8.60,8.40,8.21,7.96,7.77,7.62,7.52,7.50,7.50,7.50,7.50,7.53,7.62,7.76,7.86,7.96,7.96,7.89,7.76,7.65,7.61,7.60,7.53,7.51,7.48,7.43,7.35,7.28,7.13,7.09,6.09,5.30,5.12,5.02,5,5,4.97,4.88,3.79,3.77,3.72,2.50,2.50,1.25,1.25,-1,-1,-2,-2.30,-4.66,-6.61,-8.39,-9.18,-8.87,-8.04,-7.24,-7.34,-7.80,-7.75,-8.36,-8.75,-8.84,-8.63,-8.37,-7.74,-6.78,-5.72,-6.13,-6.23,-6.13,-6.63,-7.37,-8.17,-8.14,-8.02,-8.39,-9.28,-9.35,-9.12,-8.60,-7.51,-7.03,-7.41,-7.74,-8.05,-8.59,-8.85,-8.75,-8.27,-7.89,-7.51,-6.88,-6.38,-5.80,-6.29,-6.88,-6.51,-6.25,-6.67,-6.73,-6.67,-6.72,-6.24,-6.26,-7.27,-8.13,-8.22,-9.65,-9.03,-8.65,-7.53,-5.88,-4.50,-2.75,-2.63,-1.79,-0.26,1.25,2.29,2.64,2.90,3.27,4,5.14,6.25,8.87,12.28,11.52,12.65,13.38,14.52,15.80,13.27,11.71,10.42,10.25,10.14,10.46,10.62,10.62,10.46,9.84,9.02,8.11,8.27,6.37,6.25,7.50,8.75,10,10,8.75,6.25,5,5,5,7.50,10,8.75,12.50,17.50,17.50,12.50,8.75,7.50,7.50,7.50,8.75,8.75,8.75,8.75,8.75,7.50,7.50,6.25,6.25,6.25,6.25,7.50,10,12.50,13.75,15,16.25,13.75,12.50,11.25,8.75,7.50,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,9.97,9.93,9.73,9.51,9.23,9.03,8.87,8.77,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.73,8.73,8.70,8.61,8.42,8.21,7.96,7.77,7.62,7.52,7.50,7.50,7.50,7.50,7.50,7.52,7.60,7.63,7.65,7.65,7.63,7.61,7.62,7.63,7.64,7.62,7.54,7.48,7.37,7.28,7.13,7.02,6.40,5.89,5.30,5.09,5,5,5,4.97,4.87,3.85,3.75,3.71,2.50,1.25,0.71,-0.41,-1.13,-1.76,-2.84,-4.48,-6.14,-8.10,-9.49,-9.89,-9.65,-7.92,-7.13,-7.55,-8.42,-8.55,-8.67,-9.05,-9.14,-8.90,-8.38,-7.50,-6.49,-6.37,-6.38,-6.43,-6.42,-6.88,-7.52,-8.13,-8.52,-8.54,-8.34,-8.97,-9,-8.41,-7.59,-6.84,-7.13,-7,-7.50,-8.13,-8.64,-8.88,-8.76,-8.29,-8.09,-7.67,-7.63,-7.60,-7.17,-7.13,-6.85,-6.84,-6.92,-6.84,-6.50,-6.34,-5.92,-5.91,-6.87,-7.78,-7.88,-7.68,-9.77,-9.05,-8.38,-7.12,-5.38,-3.67,-2.25,-2,-1.50,0.10,7.15,5.90,5.27,5.12,5,6.25,7.50,8.87,11.22,13.23,13.85,13.75,14.63,16.98,16.96,14.39,13.13,12.01,10.93,10.46,10.30,10.34,10.27,9.84,9.15,8.27,7.64,7.27,7.34,7.50,7.50,7.50,7.50,7.50,8.75,6.25,5,3.75,5,6.25,7.50,7.50,10,13.75,13.75,13.75,11.25,11.25,10,8.75,8.75,7.50,6.25,7.50,7.50,7.50,6.25,6.25,6.25,6.25,7.50,7.50,10,12.50,15,16.25,16.25,13.75,12.50,10,8.75,7.50,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,9.96,9.79,9.51,9.22,9.02,8.87,8.77,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.73,8.73,8.70,8.61,8.42,8.21,7.96,7.77,7.62,7.52,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.51,7.52,7.52,7.51,7.54,7.62,7.68,7.76,7.75,7.64,7.48,7.32,7.14,6.92,6.59,6.10,5.34,5.20,5.03,5,5,5,4.97,4.85,3.86,3.75,3.68,2.48,1.25,-0.25,-1.13,-1.75,-2.18,-4,-5.75,-7.52,-9.25,-11,-10,-9.97,-9.28,-8.25,-8.27,-8.54,-8.63,-8.66,-9.02,-9.13,-8.87,-8.28,-7.43,-6.99,-6.89,-6.74,-6.88,-7.05,-7.25,-7.87,-8.18,-8.59,-8.63,-8.34,-8.13,-8.05,-7.39,-7.24,-7.03,-7.16,-7.09,-7.04,-7.79,-8.38,-8.61,-8.48,-8.23,-8,-8.29,-8.75,-8.64,-8.50,-8.50,-7.93,-8,-7.88,-7.51,-7.14,-6.62,-6.25,-5.79,-6.67,-8.10,-8.16,-8.27,-8.88,-8.63,-7.63,-6.22,-4.50,-2.23,-1.63,-1.29,-0.88,0.14,7.50,11.25,8.75,8.75,8.75,10,10,12.18,13.22,14.30,14.15,14.53,15.12,15.46,15.39,14.17,13.09,13.12,11.12,10.46,10.15,10.14,10.10,9.38,8.53,7.63,6.75,6.55,7.32,7.50,7.50,7.50,7.50,6.25,6.25,5,3.75,3.75,3.75,5,5,6.25,6.25,8.75,12.50,13.75,13.75,15,13.75,11.25,8.75,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,8.75,10,12.50,15,16.25,15,13.75,12.50,11.25,8.75,7.50,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,9.97,9.80,9.51,9.22,9.01,8.86,8.77,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.73,8.73,8.70,8.61,8.43,8.21,7.96,7.77,7.62,7.52,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.53,7.64,7.78,7.90,7.93,7.68,7.45,7.18,6.96,6.70,6.38,5.89,5.32,5.11,5.01,5,5,5,4.96,4.84,3.88,3.75,3.64,2.43,1.22,-0.52,-1.63,-2.16,-2.75,-4.92,-6.88,-8.59,-9.77,-10,-9.88,-9.22,-10,-10,-10,-9.48,-8.50,-8.85,-8.91,-8.75,-8.47,-8.13,-7.64,-7.63,-7.65,-7.49,-7.65,-7.75,-7.88,-8.13,-8.23,-8.25,-8.54,-8.49,-7.88,-7.14,-7.25,-7.63,-7.38,-7.35,-7,-7,-7.24,-7.77,-7.98,-7.88,-7.89,-8.38,-9.10,-9.59,-9.50,-9.62,-9.38,-8.76,-8.76,-8.72,-8.29,-7.62,-7.01,-6.38,-5.99,-6.38,-7.65,-8.48,-9,-8.88,-8.10,-6.88,-5.43,-3.62,-1.49,-1,-0.63,-0.13,2.80,10,8.75,11.25,11.25,13.75,12.50,12.34,12.50,13.13,13.75,14.22,14.55,15.32,14.68,14.15,13.39,12.50,11.55,10.76,10.14,9.97,9.95,9.80,9.25,8.22,6.86,6.71,7.37,7.76,7.50,7.50,7.50,6.25,6.25,5,3.75,3.75,3.75,3.75,3.75,5,5,5,6.25,8.75,12.50,16.25,17.50,16.25,13.75,10,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,8.75,10,12.50,13.75,13.75,13.75,13.75,12.50,12.50,10,7.50,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,9.82,9.52,9.21,9,8.85,8.76,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.73,8.73,8.71,8.61,8.46,8.22,7.96,7.77,7.62,7.52,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.53,7.64,7.82,8,7.96,7.68,7.34,7.02,6.71,6.50,6.25,5.88,5.30,5.09,5,5,5,5,4.96,4.84,3.89,3.75,3.62,2.43,0.96,-0.38,-1.42,-2.16,-3.37,-5.77,-7.97,-9.50,-10,-10,-8.24,-9.22,-11,-12,-12,-10,-9.63,-9.51,-9.63,-9.37,-8.73,-8.10,-8.04,-8.37,-8.38,-8.42,-8.59,-8.50,-8.78,-8.80,-8.60,-8.79,-8.78,-8.43,-7.91,-7,-6.98,-7.50,-8.12,-8.05,-7.55,-6.87,-6.50,-7.05,-7.35,-7.51,-7.91,-8.91,-9.68,-10,-10,-10,-10,-9.63,-9.25,-9.22,-8.84,-8.11,-7.24,-6.38,-6.40,-6.50,-6.63,-8.48,-8.98,-8.52,-7.55,-6.25,-4.62,-2.64,-1.02,-0.43,0.10,1.39,2.61,8.75,12.50,11.25,12.50,14.95,12.96,12.97,13.05,13.27,13.59,13.89,14.22,14.05,13.75,13.30,12.64,11.65,10.50,9.84,9.70,9.67,9.82,9.87,9.65,8.73,6.71,7.96,8.38,8.72,8.75,8.75,8.75,6.25,5,3.75,3.75,3.75,3.75,3.75,5,5,3.75,5,6.25,7.50,11.25,16.25,17.50,17.50,15,10,8.75,7.50,7.50,6.25,6.25,6.25,6.25,7.50,8.75,10,11.25,13.75,13.75,13.75,12.50,12.50,11.25,11.25,8.75,7.50,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,10,10,10,10,10,10,10,10,10,10,10,9.55,9.21,8.96,8.84,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.73,8.73,8.71,8.62,8.47,8.22,7.96,7.76,7.61,7.51,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.53,7.64,7.79,7.98,8.02,7.61,7.20,6.80,6.54,6.37,6.20,5.90,5.28,5.10,5.02,5.01,5,5,4.96,4.82,3.89,3.75,3.62,2.39,1.05,-0.28,-1.38,-2.13,-3.87,-6.50,-8.99,-10,-10,-9.60,-7.68,-9.65,-12,-12,-12,-11,-10,-10,-10,-9.97,-9.27,-8.61,-8.28,-8.59,-8.77,-9.14,-9.24,-9.24,-9.38,-9.41,-9.42,-9.36,-9.26,-8.88,-8.18,-7.42,-6.74,-7.63,-8.40,-8.37,-8.29,-7.23,-6.63,-6.62,-6.99,-7.54,-8.53,-9.41,-10,-10,-11,-10,-10,-10,-9.84,-9.38,-9,-8.30,-7.37,-6.99,-6.80,-6.52,-7.64,-8.18,-8.52,-7.91,-6.85,-5.48,-3.72,-1.51,-0.80,-0.13,0.93,2.80,6.70,12.50,15,11.25,13.70,14.50,13.86,13.43,13.39,13.42,13.43,13.45,13.37,13.12,12.75,12.36,12.79,10.64,9.05,9.05,9.34,9.53,9.71,10.64,10.79,10.15,9.21,9.18,10.90,8.93,10,11.25,8.75,6.25,5,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,5,6.25,7.50,10,13.75,15,15,13.75,10,8.75,8.75,7.50,7.50,6.25,6.25,7.50,8.75,10,11.25,13.75,12.50,13.75,15,12.50,11.25,10,8.75,7.50,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,10,10,10,10,10,10,10,10,10,10,10,9.20,8.93,8.79,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.73,8.73,8.72,8.70,8.62,8.47,8.25,7.96,7.76,7.61,7.51,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.51,7.60,7.68,7.77,7.68,7.47,7.05,6.71,6.40,6.27,6.18,5.93,5.26,5.25,5.25,5.14,5.01,5,4.96,4.82,3.89,3.75,3.62,2.45,1.18,-0.13,-1.15,-2.01,-3.41,-6.77,-9.49,-10,-10,-8.75,-6.88,-9.13,-12,-12,-11,-9.92,-9.72,-10,-10,-10,-9.73,-9.09,-8.73,-8.77,-9.14,-9.51,-9.65,-9.98,-10,-10,-10,-9.85,-9.47,-9.05,-8.73,-7.99,-7.12,-7.25,-8.22,-8.66,-8.52,-8.38,-7.43,-7.16,-7.40,-8.25,-9.38,-10,-11,-11,-11,-11,-10,-10,-10,-9.55,-8.88,-8.29,-8.14,-7.59,-6.89,-6.75,-6.87,-7.04,-7.11,-6.66,-5.87,-4.51,-2.50,-1.25,-0.38,-0.63,1.55,4.63,7.50,11.21,11.27,12.59,13.46,14.09,13.90,13.62,13.59,13.54,13.37,12.96,12.62,12.18,11.73,11.39,10.76,9.84,8.92,8.85,8.87,9.97,10.92,11.87,13.12,12.13,11.39,10.88,10.27,10.14,12.50,13.75,8.75,6.25,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,6.25,8.75,10,12.50,11.25,12.50,13.75,10,10,8.75,7.50,7.50,7.50,8.75,10,11.25,13.75,12.50,13.75,12.50,13.75,12.50,11.25,8.75,7.50,6.25,5,5,5,5,5,5,3.75,3.75,5,5,5,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,10,8.75,8.75,10,10,10,10,8.75,8.75,10,8.75,8.90,8.79,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.73,8.73,8.72,8.71,8.70,8.60,8.46,8.25,7.95,7.75,7.60,7.51,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.52,7.59,7.60,7.50,7.23,7.01,6.55,6.37,6.27,6.25,6.10,5.98,5.98,5.98,5.25,5.02,5,4.96,4.79,3.90,3.75,3.60,2.50,1.29,0.09,-0.90,-1.77,-2.74,-5.90,-8.17,-9.13,-8.63,-7.75,-6.85,-9.63,-12,-13,-11,-9.01,-9.24,-9.77,-9.99,-9.77,-9.65,-9.42,-8.80,-8.38,-9,-9.34,-9.86,-10,-10,-10,-10,-10,-9.38,-9.17,-8.87,-8.11,-7.28,-7.50,-8.88,-9.50,-9.18,-9.09,-8,-7.75,-8.35,-9.13,-10,-10,-11,-11,-11,-11,-11,-10,-9.89,-9.38,-8.48,-8.34,-8.22,-7.27,-6.60,-6.13,-5.88,-5.80,-5.86,-5.42,-4.59,-2.90,-2.38,-1.01,0.46,1.54,1.55,5.28,7.64,10.10,11.36,12.63,14.64,13.93,13.75,13.57,13.54,13.92,13.10,12.52,12.02,11.51,10.93,10.30,9.68,9,8.76,8.85,9.96,11.03,12.03,13.09,14.46,14.63,12.65,12.18,10.14,10,12.50,11.25,7.50,6.25,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,6.25,6.25,7.50,8.75,11.25,13.75,17.50,16.25,10,8.75,7.50,7.50,7.50,8.75,11.25,12.50,13.75,13.75,12.50,12.50,11.25,11.25,10,7.50,6.25,6.25,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,5,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,8.75,8.75,8.75,8.75,10,10,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.73,8.72,8.71,8.68,8.60,8.45,8.23,7.96,7.67,7.59,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.37,7.12,6.61,6.43,6.34,6.40,6.50,6.50,6.50,6.34,5.98,5.25,5.02,5,4.96,4.79,3.90,3.75,3.60,2.59,1.45,0.27,-0.76,-1.75,-3.47,-5.30,-6.92,-7.54,-7.40,-6.80,-8.63,-12,-14,-14,-12,-10,-9.03,-9.24,-9.18,-9.22,-9.38,-9.16,-8.38,-8.13,-8.52,-9,-9.77,-10,-10,-10,-10,-10,-9.14,-9,-8.61,-7.80,-7.76,-8.78,-9.51,-10,-10,-8.89,-8.51,-8.68,-9.35,-10,-11,-12,-12,-12,-12,-12,-11,-10,-9.63,-8.88,-8.02,-8.14,-8,-6.78,-5.88,-5.24,-4.76,-4.50,-4.35,-4,-3,-2.51,-1.75,-0.63,1.09,3.43,5.93,6.39,8.85,11.37,14.68,17.04,14.14,13.68,13.37,13.13,13.12,12.96,12.64,12.17,11.67,11.04,10.28,9.39,8.76,8.43,8.72,9.39,10.64,12.89,13.12,13.59,13.75,13.45,13.52,12.34,10,11.25,12.50,10,7.50,6.25,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,6.25,7.50,8.75,10,12.50,17.50,17.50,12.50,8.75,8.75,7.50,8.75,10,11.25,13.75,13.75,13.75,12.50,11.25,11.25,10,8.75,7.50,6.25,6.25,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.73,8.72,8.68,8.60,8.45,8.23,7.96,7.68,7.51,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.48,7.48,7.48,7.46,7.36,7.14,6.52,6.34,6.29,6.50,7.23,7.23,7.23,6.39,5.98,5.25,5.02,5,4.96,4.79,3.90,3.75,3.60,2.63,1.55,0.36,-0.68,-1.63,-3.38,-5,-6.25,-6.67,-6.24,-6.35,-10,-14,-15,-14,-12,-10,-8.84,-8.61,-8.53,-8.48,-8.78,-8.78,-8.37,-7.99,-8.27,-8.99,-9.77,-10,-10,-10,-10,-9.92,-8.67,-8.38,-7.92,-7.39,-8.38,-9.42,-10,-10,-10,-9.41,-8.63,-9.16,-10,-11,-12,-13,-13,-13,-12,-12,-11,-10,-9.15,-8.03,-7.92,-7.43,-6.86,-5.97,-5,-4.17,-3.50,-3.03,-2.80,-2.59,-2.50,-1.67,-1.04,-0.75,1.39,5,7.46,8.85,11.09,12.78,14.52,14.38,13.59,12.92,12.65,12.60,12.45,12.20,11.97,11.70,11.39,10.90,10,8.75,7.37,8.12,8.87,9.77,11.07,13.09,14.38,14.53,12.78,12.63,12.32,11.40,11.25,11.37,12.34,9.96,7.50,6.25,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,6.25,6.25,7.50,8.75,11.25,16.25,17.50,15,11.25,8.75,8.75,8.75,10,11.25,12.50,13.75,15,13.75,11.25,10,8.75,7.50,6.25,6.25,5,6.25,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.77,8.77,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.77,8.78,8.78,8.77,8.76,8.75,8.73,8.70,8.60,8.46,8.23,7.96,7.70,7.53,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.48,7.48,7.47,7.47,7.38,7.23,6.46,6.27,6.27,6.50,7.23,7.23,6.50,6.37,5.98,5.25,5.02,5,4.96,4.79,3.90,3.75,3.60,2.65,1.57,0.42,-0.65,-1.63,-3.28,-4.76,-5.86,-6.24,-6.25,-7.22,-10,-14,-16,-14,-11,-9.41,-8.34,-8,-7.97,-8.13,-8.62,-8.63,-8.13,-7.86,-8.18,-8.60,-9.29,-10,-10,-10,-10,-9.50,-8.25,-7.37,-6.97,-7.25,-8.28,-9.92,-11,-11,-10,-9.55,-8.50,-10,-11,-12,-13,-14,-14,-13,-12,-11,-11,-10,-8.88,-8,-7.99,-7.15,-6.13,-5.03,-4,-3.03,-2.23,-1.53,-1.26,-1.18,-1,-0.75,-0.67,1.09,1.25,5,9.93,10.11,13.59,13.30,14.38,12.68,12.18,12,11.87,11.87,11.71,11.40,11.05,10.77,11.07,11.38,10.18,8.75,7.29,7.97,9.05,10.30,10.77,11.88,13.12,12.96,12.52,11.50,11.53,11.39,11.25,11.22,10.96,9.79,8.59,6.25,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,6.25,6.25,8.75,10,12.50,16.25,15,12.50,10,8.75,10,10,11.25,12.50,13.75,12.50,12.50,11.25,8.75,7.50,6.25,6.25,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,9.05,8.92,8.85,8.77,8.75,8.75,8.75,8.75,8.75,8.75,8.76,8.79,8.84,8.85,8.84,8.79,8.77,8.75,8.71,8.61,8.45,8.23,7.96,7.68,7.54,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.48,7.48,7.47,7.47,7.43,7.29,6.45,6.27,6.25,6.38,6.50,6.50,6.38,6.20,5.98,5.25,5.03,4.98,4.95,4.79,3.90,3.75,3.60,2.68,1.64,0.45,-0.65,-1.63,-3.25,-4.66,-5.66,-6.04,-6.02,-7.09,-9.49,-12,-13,-11,-9.25,-7.97,-7.41,-7.47,-7.38,-7.60,-8.04,-8.03,-7.78,-7.63,-7.77,-8.50,-8.90,-9.09,-9.38,-9.41,-9.39,-8.61,-7.27,-6.47,-6.42,-6.88,-8.49,-10,-12,-11,-10,-8.92,-9.18,-10,-12,-13,-13,-14,-14,-13,-12,-11,-10,-9.63,-8.25,-7.92,-7.68,-6.50,-5.41,-4.25,-3.09,-1.92,-0.92,-0.41,-0.38,-0.25,0.77,0.77,0.93,1.25,1.25,6.25,8.89,13.43,13.39,14.32,11.87,10.90,10.92,11.02,11.09,11.12,11.10,10.55,10.15,9.02,9.35,9.84,11.73,8.27,7.15,8.07,9.46,10.62,11.73,11.87,11.87,12.64,11.68,12.28,11.57,12.12,10.34,10.88,10.90,9.03,7.67,6.37,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,6.25,7.50,10,12.50,16.25,17.50,13.75,11.25,10,10,11.25,11.25,12.50,13.75,11.25,10,8.75,6.25,6.25,6.25,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,8.75,8.75,8.75,8.75,8.75,10,10,10,10,10,10,9.54,9.20,8.95,8.84,8.76,8.75,8.75,8.75,8.75,8.75,8.77,8.79,8.86,8.87,8.87,8.85,8.79,8.76,8.72,8.62,8.46,8.23,7.95,7.68,7.53,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.48,7.47,7.47,7.39,7.27,6.52,6.26,6.18,6.13,6.13,6.13,6.11,5.98,5.92,5.29,5.03,4.98,4.95,4.79,3.90,3.75,3.60,2.75,1.72,0.51,-0.65,-1.68,-2.79,-5.13,-5.92,-5.92,-6.01,-7.02,-9.09,-10,-10,-8.14,-7.15,-7.29,-7.37,-7.36,-7.18,-6.73,-7.01,-7.01,-7,-7.22,-7.87,-8.25,-8.47,-8.88,-8.92,-8.63,-8.37,-7.66,-6.72,-6.39,-5.92,-6.92,-9.40,-10,-12,-11,-9.52,-8.75,-9.88,-11,-12,-13,-13,-14,-13,-13,-12,-11,-10,-9.10,-8.34,-7.42,-6.65,-5.87,-4.72,-3.41,-2.16,-1.01,-0.38,-0.05,-0.01,0.39,1.05,2.02,1.53,1.25,2.50,7.35,10.15,12.12,12.02,10.75,9.67,9.71,9.80,10.27,10.42,10.32,10.39,10.71,6.71,5.46,6.64,9.65,7.78,6.84,6.87,8.11,9.59,11.45,11.68,12.01,12.03,13.10,14.52,12.89,12.64,11.55,10.45,10.77,10.39,9.05,7.78,6.39,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,6.25,8.75,11.25,13.75,16.25,15,12.50,11.25,10,11.25,11.25,12.50,12.50,8.75,7.50,6.25,6.25,6.25,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,10,10,10,10,10,10,11.25,11.25,11.25,11.25,10,9.96,9.40,9.07,8.89,8.77,8.75,8.75,8.75,8.75,8.75,8.76,8.78,8.85,8.86,8.87,8.86,8.79,8.76,8.73,8.62,8.46,8.23,7.95,7.70,7.54,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.51,7.54,7.50,7.48,7.47,7.45,7.36,7.18,6.57,6.23,5.98,5.89,5.80,5.80,5.80,5.82,5.39,5.20,5.02,4.98,4.95,4.82,3.89,3.75,3.62,2.77,1.80,0.60,-0.66,-1.75,-3.16,-4.65,-5.89,-6.01,-5.50,-7.25,-8.64,-9.38,-8.60,-6.48,-7,-8.25,-9.76,-9.37,-7.63,-6.75,-6,-6.10,-6.50,-7.05,-7.79,-8.63,-9.14,-9,-8.88,-8.51,-7.80,-7.16,-6.35,-6.29,-6.09,-7.27,-9.29,-10,-11,-10,-9.25,-8.87,-10,-12,-13,-13,-14,-14,-13,-12,-11,-11,-10,-9,-8.15,-6.92,-6.03,-5.09,-3.97,-2.75,-1.38,-0.26,-0.25,-0.15,0,0.42,1.50,3.38,1.39,3.75,6.36,11.04,10.88,10.95,9.79,7.02,8.12,8.59,9.15,9.54,10.17,9.53,8.46,7.03,4.05,4,4.93,5.17,5.30,5.46,6.70,7.79,9.34,11.45,11.65,12.23,13.39,15.85,19.55,15.89,13.52,11.71,11.11,11.21,10.93,10.12,8.45,6.50,5.13,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,6.25,8.75,11.25,13.75,15,13.75,12.50,12.50,12.50,13.75,12.50,10,7.50,6.25,6.25,6.25,6.25,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,11.25,10,10,11.25,11.25,11.25,11.25,12.50,12.50,12.50,11.25,10.13,9.55,9.18,8.92,8.79,8.76,8.75,8.75,8.75,8.75,8.75,8.76,8.78,8.79,8.84,8.84,8.78,8.76,8.73,8.63,8.47,8.26,7.96,7.70,7.54,7.50,7.50,7.50,7.50,7.50,7.50,7.50,8.75,8.75,8.75,8.73,7.52,7.59,7.50,7.46,7.37,7.22,7.13,6.50,6.07,5.79,5.46,5.46,5.46,5.45,5.34,5.21,5.09,5,4.98,4.93,4.77,3.89,3.75,3.62,2.80,1.89,0.71,-0.67,-1.88,-3.36,-4.79,-5.87,-6.25,-6.39,-6.63,-7.38,-8.23,-7.68,-6.72,-7.54,-10,-12,-11,-9.12,-6.42,-5.65,-6.67,-7.43,-7.12,-8.27,-9.29,-9.88,-9.77,-8.88,-8.39,-7.68,-6.68,-6.24,-6.27,-6.12,-6.50,-8.52,-9.89,-10,-9.53,-8.30,-9,-10,-12,-13,-13,-14,-13,-13,-12,-11,-10,-9.63,-9,-7.48,-6.54,-5.49,-4.41,-3.30,-2.11,-0.88,-0.17,-0.25,-0.27,-0.38,0.27,1.25,2.78,4.84,6.34,8.55,9.95,12.03,11.98,8.10,5.77,6.71,7.67,8.27,9.02,9.50,10.46,6.39,2.46,2.34,2.18,2.96,3.71,3.92,5.30,6.10,7.23,8.47,9.97,10.93,13.43,15.37,18.05,20.77,18.26,14.22,11.73,11.11,11.50,13.26,11.12,9.63,7.50,6.07,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,6.25,8.75,10,11.25,11.25,12.50,15,15,12.50,11.25,8.75,7.50,6.25,5,5,6.25,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,11.25,11.25,11.25,11.25,11.25,12.50,12.50,12.50,11.25,11.25,11.25,10.01,9.63,9.23,8.95,8.84,8.77,8.76,8.75,8.75,8.75,8.75,8.75,8.75,8.76,8.77,8.77,8.76,8.75,8.72,8.64,8.52,8.27,7.98,7.75,7.59,7.50,7.50,7.50,7.50,7.50,7.50,8.75,8.75,8.75,8.75,8.75,8.71,7.54,7.64,7.45,7.27,7.14,6.61,6.22,5.80,5.48,5.29,5.15,5.14,5.14,5.11,5.04,5.01,5,4.97,4.88,4.71,3.93,3.76,3.62,2.77,1.82,0.60,-0.67,-1.78,-3.42,-5.14,-6.38,-6.76,-6.50,-6.27,-7.28,-7.84,-7.79,-7.28,-7.90,-11,-13,-13,-10,-6.75,-7.13,-8.18,-9.78,-10,-8.49,-9.27,-9.86,-9.75,-8.88,-7.92,-7.53,-7.13,-6.75,-6.79,-6.62,-6,-7.67,-8.75,-8.66,-8.24,-7.54,-9.11,-10,-12,-13,-13,-13,-13,-12,-11,-10,-9.52,-9.55,-8.89,-7.37,-6.03,-4.90,-3.85,-2.76,-1.65,-0.63,-0.25,-0.17,-0.38,-0.65,-0.77,1.02,2.64,6.25,11.09,9,10.30,10.77,9.25,6.87,5.62,5.78,6.39,7.02,7.92,9.21,8.73,2.77,1.07,0.27,0.64,1.85,3.09,4.25,5.11,5.65,5.73,7.92,8.34,11.57,15.39,16.75,16.88,17.95,18.26,13.75,11.21,10.48,11.39,12.32,13.27,10.34,7.80,6.40,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,6.25,7.50,8.75,10,11.25,13.75,12.50,10,8.75,7.50,6.25,5,5,5,5,5,5,5,5,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,12.50,11.25,12.50,11.25,11.25,11.25,11.25,11.25,11.25,10.02,9.72,9.26,8.93,8.84,8.78,8.77,8.76,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.73,8.72,8.64,8.54,8.30,8.02,7.78,7.61,7.50,7.50,7.50,7.50,7.50,8.75,8.75,8.75,10,10,10,8.76,8.61,7.67,7.45,7.15,6.64,6.28,5.88,5.50,5.29,5.13,5.03,5.01,5,5,5,4.98,4.98,4.96,4.86,4.68,4,3.77,3.64,2.68,1.68,0.46,-0.75,-1.88,-3.48,-5.85,-7.43,-7.65,-7.09,-5.50,-6.63,-7.98,-7.51,-6.75,-8.38,-9.89,-12,-12,-10,-8.85,-8.17,-10,-11,-11,-10,-8.64,-9.13,-9,-8.11,-7.74,-7.63,-7.41,-8.13,-8.09,-7.34,-7.10,-6.88,-7.89,-7.93,-7.79,-8.52,-9.34,-10,-11,-13,-13,-13,-12,-11,-11,-9.90,-8.92,-8.40,-8,-6.59,-5.38,-4.26,-3.26,-2.30,-1.37,-0.63,0,0.46,0.72,1.09,-1,1.25,1.25,7.50,12.32,12.18,12.13,10.77,8.27,5.62,5.30,5.14,5.17,5.34,5.80,7.97,2.80,0.77,-0.39,0.10,0.77,1.97,3.37,4.65,5.60,5.29,5.42,8,9.28,11.70,14.28,14.48,16.82,17.02,15.76,11.73,9.23,9.23,10.46,13.26,13.27,12.12,9.05,7.29,6.25,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,6.25,7.50,7.50,8.75,10,8.75,7.50,7.50,6.25,5,5,5,5,5,6.25,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,10,10.03,9.87,9.18,8.89,8.79,8.77,8.76,8.75,8.75,8.75,8.75,8.75,8.73,8.73,8.73,8.73,8.72,8.71,8.70,8.63,8.54,8.32,8.07,7.79,7.61,7.51,7.50,7.53,7.50,8.75,8.75,8.75,10,10,10,10,9.95,8.61,7.71,7.43,7.14,6.59,6.05,5.48,5.30,5.14,5.03,5,5,4.98,4.98,4.97,4.97,4.97,4.95,4.84,4.65,4.02,3.78,3.61,2.59,1.39,0.14,-0.93,-1.88,-3.55,-6.97,-8.92,-9.18,-8.36,-6.42,-6.38,-7.66,-7.54,-7,-6.89,-8.64,-9.91,-10,-9.38,-8.61,-9.93,-10,-11,-10,-10,-8.63,-8.11,-7.92,-7.40,-7.53,-7.50,-8.12,-8.75,-8.64,-7.88,-7.68,-8,-7.73,-8.97,-9.65,-9.17,-9.48,-10,-11,-12,-12,-12,-12,-11,-10,-9.38,-8.68,-7.99,-6.41,-5.65,-4.54,-3.52,-2.64,-1.86,-1.25,-0.39,0.73,1.85,2.13,1.25,-1,-1,1.25,8.75,12.30,14.68,12.15,10.01,7.92,5.90,5.17,4.62,4.18,3.70,3.09,2.50,1.22,-0.38,-0.42,-0.13,1.04,2.27,3.54,4.84,5,4.62,6.62,10.78,12,11.30,11.86,14.46,16.88,17.02,13.92,10.89,7.98,7.98,9.05,10.76,12.02,13.38,10.11,7.64,6.25,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,6.25,6.25,6.25,6.25,6.25,5,5,5,3.75,3.75,3.75,5,5,5,5,5,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,10,9.97,9.87,8.90,8.85,8.76,8.76,8.75,8.75,8.75,8.75,8.75,8.75,8.73,8.73,8.73,8.72,8.71,8.70,8.63,8.59,8.46,8.27,8.01,7.77,7.60,7.50,7.50,7.54,8.75,8.75,8.75,10,10,11.25,11.25,11.22,9.89,8.75,7.75,7.34,7.12,6.43,5.93,5.50,5.21,5.09,5,4.98,4.98,4.97,4.97,4.97,4.96,4.95,4.87,4.80,4.64,4.04,3.76,3.61,2.37,1.09,-0.25,-1.25,-2.04,-4.65,-8.89,-10,-11,-10,-8.75,-7.30,-8.42,-9,-8.63,-7,-6.76,-7.87,-8.66,-8.74,-7.59,-9.27,-10,-10,-10,-8.48,-8.10,-7.50,-6.49,-6.80,-7.26,-7.50,-8.09,-8.68,-8.55,-8.02,-7.91,-8.13,-8.48,-9.50,-10,-9.61,-10,-10,-11,-11,-12,-12,-12,-11,-9.91,-9.50,-8.12,-7.50,-6.02,-4.75,-3.67,-2.72,-1.89,-1.38,-0.75,0.14,1.87,3.85,5.87,1.25,1.25,1.25,-1,1.25,11.05,14.68,11.96,9.32,7.59,6.13,4.73,4,3.01,2.32,1.35,0.14,-0.25,-0.67,-0.62,0.12,1.09,2.34,3.43,4.52,4.52,5,6.54,12.12,10.37,10.42,11.76,13.84,15.75,15.80,13.43,9.21,6.71,6.71,7.61,7.95,10.18,12.15,10.25,8.59,6.25,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,10,9.97,9.87,8.89,8.77,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.73,8.73,8.72,8.72,8.70,8.63,8.59,8.46,8.29,8.11,7.90,7.68,7.54,7.50,7.50,7.54,8.75,8.75,8.75,10,11.25,11.25,11.25,11.20,9.85,8.60,7.77,7.22,6.64,6.29,5.88,5.47,5.18,5.03,5,4.98,4.97,4.97,4.96,4.95,4.89,4.86,4.79,4.67,4.62,4.03,3.61,3.59,1.97,0.62,-0.51,-1.43,-2.26,-5.25,-9.75,-11,-12,-11,-10,-8.65,-9.61,-11,-10,-9.37,-7.40,-7.50,-9.29,-9.66,-8.98,-6.77,-7.53,-8.39,-8,-8.09,-7.63,-7.38,-7,-6.65,-7,-7.24,-7.30,-7.99,-7.90,-7.67,-7.47,-6.88,-8.25,-9.75,-10,-10,-10,-11,-11,-12,-12,-12,-11,-10,-9.75,-9.01,-7.63,-6.12,-5.15,-4,-2.87,-1.88,-1.03,-0.39,0.14,1.39,2.80,7.12,9.68,10,8.75,1.25,-1,1.25,9.82,14.68,10.09,7.04,7.80,6.47,3.57,2.29,1.93,1.15,0.14,-0.62,-0.87,-0.88,-0.53,0.10,1.02,2,2.75,3.27,3.53,4.35,6.15,8.50,7.79,9.70,10.32,14.63,15.25,15.30,13.86,11.25,7.95,6.70,6.52,6.64,8.59,9.82,12.29,8.75,7.50,6.25,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,10,10,9.97,9.87,8.89,8.77,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.73,8.73,8.72,8.71,8.64,8.59,8.46,8.30,8.12,7.96,7.78,7.63,7.51,7.50,7.50,7.54,8.75,8.75,8.75,10,11.25,11.25,10.01,9.88,8.89,8.53,7.62,7.15,6.57,6.20,5.80,5.46,5.18,5.03,5,4.97,4.97,4.96,4.93,4.88,4.84,4.77,4.64,4.48,4.18,3.88,3.48,2.64,1.53,0.15,-0.88,-1.77,-3.13,-5.25,-9.13,-11,-11,-11,-10,-10,-11,-12,-11,-10,-8.91,-8.26,-9.40,-10,-9.16,-7.52,-6.01,-6.40,-7.47,-7.63,-8.28,-8.02,-7.34,-7.05,-6.63,-6.74,-6.66,-6.75,-7.25,-7.02,-6.17,-6.78,-7.40,-9.03,-10,-10,-11,-11,-12,-12,-12,-12,-11,-10,-9.13,-8.62,-6.90,-5.25,-4.53,-3.38,-2.14,-1,-0.05,0.93,2.03,3.47,5.68,7.86,9.78,10.36,10.55,1.26,-1,1.25,8.59,12.21,8.11,3.27,3.45,5.22,2.25,1.64,0.96,0.26,-0.51,-1.18,-1.23,-0.97,-0.63,-0.04,0.62,1.25,1.65,1.87,2.18,2.80,4.79,5.13,6.25,8.75,11.25,13.59,16.03,15.93,15.90,13.38,9.62,6.59,5.32,6.39,7.48,8.57,8.87,8.75,7.50,6.25,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,10,10,10,9.97,9.87,8.89,8.79,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.73,8.73,8.72,8.70,8.60,8.48,8.30,8.12,7.96,7.79,7.64,7.54,7.50,7.50,7.50,7.54,7.50,8.75,8.75,10,10,10,9.95,8.87,8.55,7.75,7.22,6.57,6.40,6.11,5.78,5.46,5.18,5.03,5,4.97,4.96,4.93,4.86,4.80,4.71,4.62,4.42,4.21,4,3.73,3.45,2.39,1.13,-0.23,-1.16,-2.41,-3.97,-6.01,-8.37,-9.93,-11,-10,-10,-10,-10,-9.91,-9.59,-8.98,-8.98,-8.61,-9.09,-9.10,-8.63,-8,-6.38,-6.99,-8.27,-8.34,-8.51,-7.43,-7.03,-7.27,-6.42,-6.25,-6.66,-6.91,-6.91,-6.73,-6.55,-6.67,-7.24,-7.65,-9.23,-10,-11,-12,-13,-13,-13,-12,-11,-9.79,-8.84,-7.90,-6.47,-5.50,-4.28,-3.04,-1.77,-0.40,0.87,2.64,3.60,5.88,7.17,9.20,10.61,10.80,11.20,1.93,-1,-1,7.37,12.30,6.21,2,2.10,2.21,1.80,0.93,0.27,-0.38,-1.02,-1.68,-2.16,-1.87,-0.77,-0.17,0.29,0.62,0.77,0.77,0.76,1.04,1.55,1.51,4.84,6.25,10,12.47,14.84,16.04,15.96,13.43,9.68,6.55,5.28,5.96,6.40,7.34,7.50,10,7.50,6.25,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,1.25,1.25,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,9.97,9.86,8.92,8.79,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.73,8.73,8.71,8.63,8.54,8.37,8.14,7.95,7.78,7.64,7.54,7.50,7.48,7.47,7.48,7.48,7.50,7.50,8.75,8.75,8.75,8.75,8.64,8.59,7.68,7.22,6.55,6.42,6.25,6.11,5.78,5.46,5.15,5.03,5,4.97,4.95,4.86,4.79,4.68,4.53,4.38,4.21,4.03,3.84,3.68,3.39,2.32,1.04,-0.37,-1.38,-2.63,-4.12,-5.63,-7.18,-8.29,-9,-9.12,-8.75,-8.50,-8.25,-7.84,-7.51,-7.15,-7.02,-6.77,-7,-7.13,-7.04,-6.73,-6.67,-7.38,-7.88,-8.15,-8.13,-7.59,-7.17,-7.49,-7.22,-6.39,-6.75,-7,-7.01,-6.84,-6.89,-6.92,-7.28,-7.84,-9.10,-10,-12,-13,-14,-14,-14,-13,-11,-10,-8.41,-7.17,-6.60,-5.62,-4.28,-2.85,-1.50,-0.25,0.93,2.02,4.67,6.77,8.23,9.01,9.32,10.45,9.55,2.35,-1,-1,1.25,6.10,4.59,1.89,1.50,1.27,0.92,0.37,-0.25,-1,-1.53,-3.13,-4,-3.51,-2.51,-1.25,0.10,0.14,0.12,-0.13,-0.18,-0.26,-0.68,0.93,1.39,6.25,7.50,11.25,13.75,13.62,13.59,11.07,8.73,6.40,5.14,5.13,6.12,6.25,7.50,8.75,8.75,7.50,6.25,6.25,6.25,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,1.25,1.25,2.50,3.75,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,9.97,9.85,8.95,8.79,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.73,8.73,8.72,8.70,8.60,8.43,8.22,7.96,7.77,7.64,7.54,7.50,7.47,7.46,7.43,7.43,7.45,7.50,7.50,7.50,7.50,7.50,7.50,7.59,7.63,7.28,6.53,6.42,6.27,6.22,6.09,5.79,5.45,5.15,5.02,5,4.97,4.89,4.84,4.68,4.52,4.35,4.17,4,3.86,3.75,3.62,3.30,2.32,1.09,-0.13,-1.13,-2,-3.64,-4.88,-6,-6.59,-6.99,-7.02,-6.79,-6.49,-6.10,-5.62,-5.27,-4.92,-4.61,-4.55,-4.84,-5.12,-5.26,-5.48,-5.80,-6.38,-7.13,-7.23,-7.63,-8.05,-8.17,-8,-7.14,-6.79,-6.61,-6.80,-6.84,-6.77,-6.88,-7.49,-8.12,-8.55,-9.75,-11,-13,-15,-15,-15,-15,-14,-12,-10,-9,-7.88,-7.22,-5.92,-4.48,-3,-1.62,-0.38,0.10,1.85,5.72,7.36,9.01,7.62,7.04,6.43,4.87,2.25,-0.77,-0.77,1.50,3.57,3.43,1.70,1.22,0.84,0.39,-0.13,-0.78,-1.37,-3.25,-6.98,-6.53,-5.63,-4.14,-2.38,-1.03,-0.15,-0.25,-0.50,-1,-0.75,-0.65,-0.75,1.51,3.75,7.50,8.75,10,12.50,10,8.75,7.50,6.25,5,5,5,5,6.25,6.25,7.50,10,7.50,7.50,6.25,6.25,5,6.25,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,1.25,1.25,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,2.50,3.75,3.75,3.75,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,9.96,9.84,9,8.79,8.75,8.75,8.75,8.75,8.75,8.75,8.73,8.73,8.73,8.72,8.68,8.57,8.34,8.07,7.80,7.64,7.53,7.50,7.47,7.45,7.38,7.35,7.28,7.35,7.39,7.45,7.47,7.50,7.50,7.50,7.37,7.32,6.46,6.42,6.27,6.25,6.21,6.07,5.78,5.45,5.15,5.01,5,4.98,4.95,4.82,4.62,4.35,4.09,3.92,3.85,3.77,3.72,3.60,3.27,2.36,1.28,0.17,-0.76,-1.52,-2.75,-3.78,-4.63,-4.92,-5.13,-5.09,-4.77,-4.28,-3.60,-3.13,-2.78,-2.52,-2.16,-2.35,-2.64,-3.13,-3.54,-4,-4.52,-5.16,-5.73,-6.25,-6.92,-8.13,-8.52,-8.12,-7.65,-7.13,-6.80,-6.50,-6.52,-6.90,-7.66,-8.03,-8.50,-9.05,-10,-12,-14,-16,-16,-16,-15,-14,-12,-10,-9.55,-9.23,-8.12,-6.30,-4.68,-3.09,-1.63,-0.39,0.59,1.84,5.42,8.11,7.76,5.72,3.63,3.57,2.79,1.38,-0.66,-0.66,1.53,3.43,3.59,1.60,1.12,0.63,0.04,-0.52,-1.12,-2.55,-6.78,-11,-9.36,-7.88,-5.99,-3.89,-2.13,-0.90,0.72,-0.88,-1.63,-1,0.77,0.88,0.93,1.25,1.25,7.50,8.75,8.75,8.75,7.50,6.25,5,5,5,5,5,5,5,6.25,7.50,10,7.50,7.50,6.25,6.25,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,1.25,1.25,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,9.96,9.85,9,8.79,8.75,8.75,8.75,8.75,8.75,8.73,8.73,8.73,8.73,8.72,8.64,8.53,8.27,7.97,7.71,7.59,7.50,7.48,7.46,7.43,7.34,7.20,7.21,6.42,6.39,6.37,6.35,6.28,6.26,6.25,6.36,6.40,6.40,6.27,6.25,6.23,6.20,6.05,5.77,5.45,5.15,5.01,5,4.98,4.93,4.79,4.53,4.23,4,3.85,3.76,3.75,3.71,3.59,3.25,2.52,1.54,0.63,-0.28,-1.13,-1.75,-2.59,-3.14,-3.38,-3.47,-3.28,-2.90,-2.24,-1.12,-0.47,0.11,-0.11,-0.25,-0.53,-0.77,-1.25,-1.88,-2.48,-3.11,-3.78,-4.49,-5.23,-6.15,-7.50,-8.29,-8.16,-8.55,-8.27,-8.34,-8.40,-7.65,-7.72,-8.38,-8.75,-8.92,-9.37,-11,-13,-14,-16,-16,-16,-15,-14,-12,-10,-9.54,-9.39,-8.24,-6.66,-5,-3.27,-1.73,-0.50,0.62,1.71,6.09,9.55,5.79,3.50,1.23,1.71,1.42,0.73,0.61,0.76,1.71,3.37,3.43,1.50,1.37,0.62,-0.25,-0.75,-1.75,-4.35,-8.40,-13,-11,-10,-8.13,-5.92,-3.92,-2.53,-1.75,-1.63,-1.72,-1.13,-0.78,-0.63,-0.79,-1,1.25,3.75,7.50,7.50,7.50,7.50,6.25,5,5,5,5,5,5,5,5,6.25,8.75,7.50,7.50,6.25,5,5,6.25,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,1.25,1.25,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,13.75,12.50,12.50,11.25,11.25,11.25,11.25,11.25,10,10,9.98,9.96,9.84,9,8.78,8.75,8.75,8.75,8.75,8.73,8.73,8.73,8.73,8.72,8.71,8.63,8.48,8.26,7.96,7.70,7.54,7.50,7.48,7.46,7.39,7.30,7.07,6.59,6.40,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.26,6.25,6.25,6.25,6.23,6.20,6.04,5.77,5.45,5.15,5.02,5,4.98,4.93,4.78,4.52,4.21,3.93,3.78,3.75,3.73,3.70,3.57,3.23,2.65,2.15,1.10,0.28,-0.42,-1.03,-1.38,-1.68,-1.88,-1.75,-1.63,-1.13,-0.51,0.14,0.76,1.25,1.86,1.55,1.25,0.93,0.46,-0.34,-0.98,-1.67,-2.48,-3.25,-4.11,-5.13,-6.03,-6.88,-7.75,-8.65,-9.59,-10,-11,-9.80,-9.25,-9.05,-9.28,-9.05,-9.51,-11,-13,-14,-15,-16,-16,-15,-13,-12,-10,-9.11,-9.67,-8.25,-7.18,-5.63,-3.84,-2.12,-0.74,0.59,1.71,5.39,7.45,3.09,0.93,0.82,0.55,0.51,0.30,-0.38,0.60,1.71,4.52,2.34,1.87,1.25,0.62,-0.13,-0.64,-2.18,-4.50,-8.15,-13,-13,-13,-10,-7.90,-5.42,-4.22,-3.27,-3.25,-3.05,-2.63,-2,-1.43,-1.29,-1,1.25,1.25,5,7.50,7.50,6.25,6.25,5,5,5,5,5,5,5,5,5,6.25,6.25,7.50,6.25,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,1.25,1.39,1.55,1.71,1.86,1.87,2.02,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,15,13.75,12.50,12.50,11.25,11.25,11.25,10,10,10,9.98,9.96,9.85,8.95,8.77,8.75,8.75,8.75,8.75,8.73,8.73,8.73,8.72,8.71,8.68,8.60,8.45,8.22,7.93,7.68,7.53,7.50,7.48,7.46,7.38,7.28,7.02,6.61,6.27,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.20,6.04,5.77,5.45,5.17,5.02,5,4.98,4.89,4.77,4.51,4.20,3.93,3.78,3.75,3.73,3.70,3.55,3.25,2.78,2.14,1.50,0.84,0.28,-0.25,-0.50,-0.66,-0.75,-0.75,-0.53,-0.15,0.46,1.25,1.64,2.12,2.64,2.75,2.64,2.48,2.15,1.51,0.60,-0.30,-1.22,-2.04,-2.98,-3.90,-4.76,-5.85,-7,-8.43,-10,-12,-14,-13,-10,-9.97,-9.59,-9.64,-10,-12,-13,-14,-14,-15,-15,-14,-12,-11,-10,-10,-10,-9.18,-8.28,-6.90,-5.16,-3.50,-1.88,-0.49,1.11,2.48,2.36,1.47,0.29,-0.15,-0.16,-0.14,-0.14,-0.13,-0.38,1.67,4.37,2.34,1.55,1.18,0.57,-0.15,-0.75,-1.87,-4.03,-7,-12,-16,-15,-13,-10,-7.17,-5.88,-5.17,-5.10,-4.66,-3.90,-2.99,-2.11,-1.41,-1,-1,1.25,3.75,7.50,7.50,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,3.75,2.50,3.75,2.50,2.13,1.80,1.51,1.25,1.25,1.25,1.25,1.25,1.25,1.39,1.67,1.85,1.87,1.25,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,16.25,15,13.75,12.50,11.25,11.25,11.25,10,10,10,9.98,9.96,9.85,8.95,8.77,8.75,8.75,8.75,8.75,8.73,8.73,8.72,8.72,8.70,8.62,8.53,8.37,8.12,7.86,7.64,7.52,7.50,7.47,7.46,7.39,7.28,7.01,6.64,6.28,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.18,6.04,5.77,5.46,5.17,5.02,5,4.98,4.89,4.77,4.51,4.20,3.93,3.78,3.75,3.73,3.70,3.54,3.26,2.78,2.18,1.64,1.34,0.97,0.75,0.42,0.30,0.30,0.30,0.46,0.87,1.39,2,2.17,2.61,3.21,3.43,3.70,3.89,3.89,3.27,2.18,1.09,0,-0.92,-1.90,-2.78,-3.62,-4.78,-6.15,-7.99,-10,-14,-16,-15,-13,-10,-10,-10,-11,-12,-13,-13,-14,-14,-13,-13,-11,-11,-11,-12,-12,-12,-11,-8.98,-6.87,-5,-3.42,-1.93,-0.75,-0.13,-0.03,-0.50,-0.92,-0.92,-0.75,-0.55,-0.50,-0.38,0.09,0.93,1.55,1.55,1.07,0.61,0.14,-0.39,-1.02,-1.75,-3.63,-5.97,-12,-15,-16,-15,-12,-9.13,-7.63,-7.22,-7.27,-6.38,-5.17,-3.75,-2.48,-1.38,-2,-1,1.25,3.75,6.25,7.50,6.25,6.25,5,3.75,5,5,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,5,5,3.75,3.75,3.75,3.75,3.75,2.50,2.50,1.98,1.55,1.55,1.25,1.25,1.09,1.09,1.25,1.07,1.04,0.87,0.77,0.46,0.30,0.40,0.59,0.77,1.09,0.89,1.04,1.25,1.71,1.87,1.96,2.45,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,17.50,16.25,13.75,12.50,11.25,11.25,11.25,10,10,10,9.98,9.96,9.85,8.90,8.76,8.75,8.75,8.75,8.75,8.73,8.73,8.72,8.71,8.63,8.55,8.40,8.21,7.97,7.77,7.62,7.51,7.48,7.47,7.46,7.39,7.28,7.01,6.64,6.28,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.18,6.04,5.77,5.46,5.17,5.02,5,4.98,4.89,4.77,4.51,4.21,3.93,3.78,3.75,3.73,3.70,3.54,3.25,2.78,2.18,1.51,1.37,2.45,1.25,1.25,1.39,1.53,1.25,1.39,1.65,1.97,2.27,2.34,2.80,3.39,3.89,4.32,4.84,5.30,4.84,4,2.80,1.54,0.14,-0.93,-1.85,-2.63,-3.76,-5.38,-7.29,-9.84,-12,-14,-15,-15,-12,-11,-11,-12,-13,-13,-13,-13,-13,-13,-11,-11,-11,-13,-14,-15,-15,-13,-11,-9.02,-6.86,-5.18,-3.67,-2.97,-2.27,-2.11,-2.30,-2.36,-2.65,-1.98,-1.25,-0.91,-0.65,-0.25,0.25,0.61,0.62,0.45,0.09,-0.25,-1,-2.25,-3.84,-4.61,-7.18,-12,-18,-18,-17,-14,-11,-7.92,-8.53,-9.50,-7.50,-5.75,-3.98,-2.53,-1.38,-1.88,-0.88,0.93,1.39,4.84,5,5,5,3.75,3.75,3.75,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,3.12,3.10,2.96,2.93,2.96,2.64,2.34,1.87,1.39,0.88,0.30,0.13,-0.13,-0.04,0.11,0.40,0.75,0.62,0.46,0.14,-0.01,-0.38,-0.63,-0.67,-0.63,-0.38,0,0.13,0,0.27,0.46,0.55,0.77,1.05,1.39,1.82,2.15,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,17.50,16.25,13.75,12.50,11.25,11.25,11.25,10,10,10,9.98,9.96,9.85,8.90,8.76,8.75,8.75,8.75,8.75,8.73,8.73,8.72,8.70,8.60,8.43,8.25,8,7.80,7.64,7.53,7.50,7.48,7.47,7.46,7.43,7.29,7.02,6.65,6.28,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.23,6.23,6.23,6.18,6.03,5.77,5.46,5.18,5.03,5,4.98,4.89,4.77,4.51,4.21,3.93,3.78,3.75,3.73,3.70,3.54,3.25,2.77,2.15,1.50,1.38,1.34,1.25,1.87,2.02,2.02,2,2.01,2.15,2.29,2.34,2.47,2.50,3.75,3.75,4.50,5,5.77,5.62,5.30,4.51,3.11,1.55,-0.13,-1.13,-1.90,-2.80,-4.43,-6.41,-8.66,-10,-13,-15,-15,-13,-11,-11,-11,-12,-13,-12,-12,-12,-11,-10,-10,-11,-12,-13,-15,-16,-15,-14,-11,-8.88,-7.22,-5.88,-5.14,-4.38,-4.22,-5,-5.13,-4.93,-4.50,-3.88,-3.10,-2.34,-1.63,-0.50,-0.13,0,-0.13,-0.38,-0.89,-2.48,-4.17,-5.89,-7.39,-9.29,-14,-18,-18,-17,-15,-12,-10,-8.27,-9.29,-7.15,-5.22,-3.61,-2.28,-1.41,-1.75,-0.88,-0.75,1.55,2.76,3.59,3.75,3.75,3.75,3.75,3.64,4.05,4.96,5.80,5.37,5.22,4.93,3.75,1.71,1.87,2.17,2.50,2.02,1.55,1.25,1.35,1.39,1.67,1.87,2.02,1.51,1.09,0.62,0.14,-0.28,-0.75,-0.89,-1.13,-1,-0.77,-0.50,-0.13,-0.14,-0.25,-0.63,-0.88,-1.17,-1.43,-1.65,-1.75,-1.38,-1.01,-1.01,-0.93,-0.88,-0.76,-0.63,-0.40,-0.13,0.39,0.93,1.70,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,16.25,15,13.75,12.50,11.25,11.25,11.25,10,10,10,9.98,9.96,9.85,8.90,8.77,8.75,8.75,8.75,8.75,8.73,8.73,8.72,8.68,8.55,8.34,8.10,7.84,7.65,7.59,7.50,7.48,7.47,7.47,7.46,7.43,7.28,7.02,6.65,6.29,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.23,6.23,6.22,6.18,6.03,5.77,5.46,5.18,5.03,5,4.97,4.89,4.77,4.51,4.21,3.93,3.78,3.75,3.73,3.70,3.54,3.25,2.77,2.15,1.46,1.27,1.25,1.25,2.50,2.50,2.50,2.32,2.34,2.34,2.43,2.47,2.50,2.50,2.50,3.75,3.75,5,5,5.77,5.92,5.77,4.82,2.96,1.25,-0.25,-1.15,-1.89,-3.75,-5.61,-7.64,-9.80,-11,-13,-14,-13,-12,-12,-11,-12,-12,-11,-11,-10,-10,-9.60,-8.38,-9.37,-10,-11,-12,-13,-15,-15,-13,-10,-9.28,-8.30,-7.50,-6.90,-6.90,-7.86,-7.90,-7.59,-7.10,-6.48,-5.78,-5,-4.29,-3.54,-3,-2.65,-2.04,-1.60,-2.13,-3.52,-5.30,-8.55,-10,-12,-15,-17,-18,-17,-15,-12,-9.17,-7.75,-6.74,-5.62,-4.25,-2.89,-1.74,-1.51,-1.67,-0.88,0.77,1.36,2.18,2.64,2.50,2.50,2.50,2.64,2.86,3.95,4.93,5.67,5.92,5.77,4.71,3.68,1.50,0.30,0.75,0.89,0.62,0.14,-0.18,-0.25,-0.13,0.14,0.62,0.76,0.27,-0.25,-0.63,-0.92,-1.25,-1.63,-1.88,-2,-1.79,-1.65,-1.38,-1.04,-1,-1.13,-1.42,-1.75,-2.02,-2.25,-2.39,-2.43,-2.25,-2.13,-2,-1.88,-1.88,-1.88,-1.51,-1.29,-0.88,-0.50,0.14,1.09,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,15,13.75,13.75,12.50,11.25,11.25,11.25,10,10,10,9.98,9.96,9.85,8.90,8.95,8.90,8.76,8.75,8.75,8.73,8.73,8.72,8.68,8.54,8.28,7.98,7.75,7.60,7.51,7.50,7.48,7.47,7.47,7.46,7.39,7.27,7.01,6.67,6.36,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.22,6.22,6.22,6.22,6.14,6.03,5.77,5.46,5.18,5.03,5,4.97,4.89,4.77,4.51,4.21,3.93,3.78,3.75,3.73,3.68,3.54,3.25,2.78,2.18,1.45,1.29,1.38,1.28,2.45,2.48,2.47,2.46,2.47,2.48,2.48,2.50,2.50,2.50,2.50,3.75,3.75,3.75,5,5.27,5.76,6.25,6.21,6.25,1.87,1.25,-0.39,-1.38,-2.92,-4.67,-6.62,-8.65,-10,-12,-13,-14,-14,-13,-12,-12,-12,-11,-10,-9.28,-8.98,-8.16,-7.75,-7.77,-8.25,-8.72,-9.40,-10,-11,-12,-12,-12,-10,-10,-9.78,-9.38,-9.55,-10,-10,-10,-9.63,-9.13,-8.63,-8.10,-7.22,-6.38,-5.63,-5.10,-4.50,-4.34,-4.66,-5.86,-7.75,-10,-11,-13,-15,-16,-16,-15,-11,-9.47,-7.47,-5.98,-4.89,-3.90,-2.92,-1.98,-1.17,-1.65,-1.64,-0.75,0.77,1.20,2.12,2.47,2.50,2.50,2.50,2.72,2.98,3.80,4.89,5.88,6.82,5.85,4.52,2.61,0.88,-0.13,-0.40,-0.50,-0.63,-0.89,-1.13,-1.25,-1.22,-0.99,-0.67,-0.38,-0.75,-1.16,-1.63,-1.88,-2.11,-2.35,-2.50,-2.61,-2.59,-2.41,-2.25,-2.05,-2,-2,-2,-3,-2.64,-2.75,-2.88,-2.90,-2.88,-2.75,-2.65,-2.63,-2.63,-2.63,-2.18,-1.79,-1.16,-0.63,-0.04,0.77,1.55,2.17,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,15,13.75,13.75,12.50,12.50,11.25,11.25,10,10,10,9.98,9.97,9.85,9.82,9.79,9,8.92,8.76,8.75,8.73,8.73,8.72,8.68,8.54,8.28,7.96,7.68,7.53,7.50,7.48,7.48,7.48,7.47,7.46,7.37,7.22,7,6.68,6.39,6.26,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.22,6.22,6.22,6.21,6.13,6.02,5.77,5.46,5.18,5.03,5,4.97,4.88,4.73,4.50,4.21,3.93,3.78,3.75,3.72,3.68,3.54,3.26,2.77,2.18,1.51,1.36,1.40,2.39,2.39,2.39,2.48,2.48,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,5,5,6.25,7.50,8.75,7.50,2.48,1.09,-0.63,-2.23,-3.80,-5.63,-7.63,-9.61,-11,-13,-14,-14,-13,-13,-12,-11,-11,-10,-8.75,-7.35,-7.03,-6.63,-6.37,-6.24,-5.92,-6.26,-7.38,-8.66,-9.87,-10,-11,-13,-11,-12,-11,-11,-12,-12,-12,-12,-11,-11,-11,-10,-8.90,-7.75,-7.17,-6.63,-6.51,-6.85,-8,-10,-11,-12,-13,-13,-13,-12,-10,-8.50,-6.63,-5,-3.89,-2.93,-2.11,-1.36,-0.64,-0.79,-0.75,-0.64,-0.63,0.14,0.77,1.50,2.34,3.75,3.75,3.75,2.75,3.01,3.76,4.82,5.96,6.76,6.85,4.03,1.93,0.30,-0.64,-1.16,-1.52,-1.53,-1.86,-2.23,-2.42,-2.52,-2.50,-2.25,-1.98,-2.02,-2.34,-2.55,-2.87,-3.01,-3.25,-3.37,-3.55,-3.50,-3.38,-3.37,-3.26,-3.10,-3.09,-3.13,-3.36,-3.48,-3.61,-3.63,-3.49,-3.24,-3.01,-3,-3,-2.90,-2.89,-2.63,-2.13,-1.38,-0.75,-0.13,0.46,1.25,1.97,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,16.25,15,13.75,13.75,12.50,11.25,11.25,11.25,10,10,9.98,10,10.11,10.14,10.12,9.78,9.01,8.90,8.76,8.73,8.73,8.72,8.70,8.57,8.28,7.96,7.67,7.52,7.50,7.48,7.48,7.48,7.47,7.45,7.36,7.21,6.98,6.70,6.43,6.26,6.25,6.25,6.25,6.23,6.23,6.23,6.23,6.22,6.22,6.21,6.20,6.12,5.97,5.76,5.46,5.20,5.04,5,4.96,4.87,4.72,4.50,4.21,3.93,3.78,3.75,3.72,3.68,3.54,3.27,2.77,2.17,1.53,1.36,1.40,1.37,1.37,2.36,2.48,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,5,6.25,7.50,8.75,10,6.87,2.18,-0.25,-1.55,-3.03,-4.75,-6.74,-8.65,-11,-13,-14,-14,-13,-13,-12,-11,-10,-8.98,-7.75,-6.92,-6.16,-5.61,-5.05,-4.41,-3.75,-3.75,-4.75,-6.26,-7.79,-9.18,-10,-12,-12,-11,-11,-11,-13,-14,-14,-14,-13,-13,-14,-12,-10,-9,-8.72,-8.37,-8.50,-9.10,-10,-12,-12,-12,-12,-11,-10,-8.52,-6.68,-5,-3.80,-2.50,-1.76,-1,-0.47,1.25,1.25,1.23,1.09,0.77,0.55,0.29,0.59,1.21,2.28,2.50,3.75,2.50,2.71,2.95,3.60,4.53,5.47,6.76,5.60,2.96,1.18,-0.27,-1.15,-1.63,-2.01,-2.35,-2.86,-3.50,-3.99,-4.28,-4.35,-4.02,-3.52,-3.47,-3.63,-3.74,-4,-4.14,-4.39,-4.54,-4.86,-4.91,-4.84,-4.74,-4.60,-4.29,-4.25,-4.14,-4.41,-4.50,-4.79,-4.79,-4.50,-4,-3.50,-3.02,-3,-3,-3,-2.88,-2.25,-1.51,-0.75,-0.13,0.55,1.22,1.86,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,17.50,17.50,15,13.75,12.50,12.50,11.25,11.25,11.25,10,10,10.03,10.11,11.09,11.07,10.12,9.73,9.02,8.76,8.73,8.73,8.73,8.70,8.59,8.29,7.97,7.68,7.54,7.50,7.48,7.48,7.47,7.47,7.45,7.35,7.20,6.98,6.70,6.43,6.27,6.25,6.25,6.23,6.23,6.23,6.23,6.23,6.22,6.21,6.21,6.18,6.10,5.95,5.73,5.46,5.21,5.09,5,4.95,4.85,4.70,4.47,4.20,3.95,3.79,3.75,3.72,3.62,3.53,3.29,2.79,2.15,1.55,1.35,1.26,1.25,1.38,2.35,2.48,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,5,5,6.25,7.50,8.75,7.50,2.96,0.11,-1.05,-1.97,-3.91,-5.80,-8.13,-10,-13,-14,-14,-12,-12,-11,-10,-9.74,-8.12,-7.14,-6.26,-5.42,-4.67,-3.90,-2.88,-2,-1.79,-2.65,-4.17,-5.91,-7.50,-8.88,-9.35,-11,-10,-11,-12,-13,-14,-13,-13,-13,-13,-13,-12,-8.88,-9.34,-9.54,-9.67,-10,-11,-12,-13,-13,-12,-10,-8.80,-7.27,-5.62,-3.43,-2.18,-1.65,-1,-0.24,1.04,1.25,1.25,3.75,3.59,3.43,2.18,1.09,0.30,0.26,0.93,1.37,2.50,2.50,2.50,2.25,2.64,3.29,3.97,4.37,4.32,2,1.60,0.22,-0.80,-1.52,-2.16,-2.63,-3.18,-4.02,-5.11,-5.99,-6.59,-6.64,-6.23,-5.60,-5.18,-5.16,-5.15,-5.37,-5.50,-5.77,-6.05,-6.38,-6.60,-6.62,-6.39,-6.13,-5.75,-5.65,-5.53,-5.87,-6.14,-6.51,-6.52,-6.13,-5.48,-4.60,-3.85,-3.34,-3,-3,-3,-3,-1.68,-0.88,-0.13,0.61,1.09,1.64,2.02,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,21.25,20,17.50,15,13.75,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.34,11.37,11.09,10.18,9.78,9.01,8.77,8.75,8.73,8.73,8.71,8.59,8.34,8.02,7.77,7.61,7.51,7.50,7.48,7.47,7.47,7.43,7.35,7.20,6.97,6.70,6.42,6.27,6.25,6.23,6.23,6.23,6.23,6.23,6.23,6.22,6.22,6.20,6.13,6.07,5.92,5.71,5.46,5.25,5.10,5,4.93,4.84,4.67,4.46,4.20,3.96,3.84,3.75,3.71,3.62,3.48,3.34,2.78,2.15,1.55,1.34,1.25,1.25,1.40,2.32,2.48,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,5,5,6.25,7.50,7.50,2.96,0.55,-0.78,-1.92,-3.63,-5.62,-7.98,-10,-13,-14,-13,-12,-11,-11,-10,-9.38,-8.10,-6.75,-5.87,-4.97,-4.11,-3.13,-1.88,-0.01,0,-0.13,-2.37,-4.27,-5.91,-7.30,-8.75,-9.51,-10,-13,-14,-15,-15,-14,-12,-12,-12,-11,-8.91,-8.18,-9.13,-10,-11,-11,-12,-14,-14,-12,-10,-8.13,-6.26,-4.63,-3.17,-1.54,-0.75,-0.47,-0.38,-0.63,0.93,1.25,3.75,3.75,6.25,4.84,3.53,1.51,0.93,-0.05,-0.13,0.77,1.25,1.25,1.25,1.39,2.13,2.89,3.47,3.37,1.82,1.36,0.28,-0.59,-1.36,-2.10,-2.79,-3.39,-4.27,-5.38,-6.88,-8.47,-9.61,-9.54,-8.78,-7.78,-7.11,-6.88,-6.84,-6.79,-6.87,-7.25,-7.73,-8.05,-8.47,-8.63,-8.24,-7.86,-7.42,-7.26,-7.16,-7.53,-8.12,-8.72,-8.87,-8.29,-7,-5.62,-4.51,-3.72,-3.01,-3,-3,-3,-2,-1,-0.13,0.62,1.09,1.39,1.71,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,23.75,22.50,20,17.50,16.25,15,13.75,12.50,12.50,12.50,12.50,12.50,12.43,12.37,11.38,11.07,10,8.96,8.90,8.77,8.76,8.77,8.76,8.64,8.43,8.12,7.85,7.64,7.53,7.50,7.48,7.47,7.46,7.43,7.34,7.18,6.97,6.70,6.42,6.27,6.25,6.23,6.23,6.23,6.22,6.22,6.22,6.21,6.21,6.20,6.12,6.03,5.88,5.64,5.45,5.25,5.11,5,4.89,4.80,4.64,4.40,4.20,4,3.85,3.75,3.71,3.61,3.47,3.17,2.76,2.14,1.57,1.34,1.26,1.39,1.42,2.30,2.48,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,5,5,6.21,5.46,3.27,1.05,-0.51,-1.75,-3.25,-5.23,-7.76,-10,-12,-13,-12,-11,-10,-10,-9.88,-8.84,-7.85,-6.59,-5.52,-4.63,-3.74,-2.68,-1.38,0.45,1.27,1.05,-1.15,-2.88,-4.51,-6.10,-7.49,-9.34,-11,-13,-15,-17,-17,-15,-14,-13,-12,-10,-9.09,-8.86,-9.40,-10,-12,-12,-12,-13,-12,-9.88,-7.75,-5.75,-4.13,-2.51,-1.65,-0.43,0,0.27,0.09,0.62,-0.79,1.25,1.25,5,6.25,5,5,3.75,1.25,0.77,-0.25,-0.63,-0.63,-1,-0.25,0.46,1.39,2.46,3.34,3.30,1.62,0.40,-0.47,-1.18,-1.99,-2.80,-3.72,-4.51,-5.38,-6.75,-8.41,-12,-13,-13,-11,-9.79,-8.73,-8.54,-8.65,-8.61,-8.01,-8.26,-9.48,-9.75,-9.84,-10,-10,-9.40,-9.13,-9.03,-8.75,-8.90,-10,-11,-11,-11,-8.10,-6.25,-4.89,-3.88,-3.13,-3,-3,-3,-2.50,-1.38,-0.25,0.27,0.77,1.20,1.55,1.87,2.18,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,25,22.50,20,18.75,18.75,17.50,16.25,15,13.75,13.75,13.75,13.75,13.71,12.59,11.37,11.09,10.17,9.78,8.96,9.01,9.01,9.03,9.05,8.87,8.55,8.23,7.95,7.71,7.59,7.50,7.48,7.47,7.46,7.39,7.34,7.18,6.97,6.70,6.42,6.28,6.25,6.23,6.23,6.22,6.22,6.22,6.22,6.21,6.20,6.18,6.12,6.02,5.80,5.62,5.42,5.21,5.10,5,4.88,4.78,4.63,4.39,4.20,4.01,3.87,3.76,3.71,3.60,3.43,3.13,2.70,2.17,1.59,1.37,1.28,1.43,2.29,2.34,2.48,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,5,5,5,3.07,1.22,-0.50,-1.74,-3.22,-5.04,-7.42,-10,-12,-12,-11,-10,-9.93,-9.63,-8.99,-8.27,-7.26,-6.17,-5.25,-4.37,-3.50,-2.55,-1.49,0.47,6.55,1.39,-0.38,-1.78,-3.35,-4.99,-6.65,-8.85,-11,-13,-15,-16,-18,-16,-15,-14,-13,-11,-9.72,-9.50,-9.55,-10,-12,-12,-11,-10,-9,-7.24,-5.30,-3.75,-2.15,-1.15,-0.80,-0.38,-0.01,0.14,0.09,-0.51,-0.88,-1,1.25,7.50,6.25,6.25,6.25,5,2.50,1.25,-1,-1.63,-1.63,-2,-1.04,-0.38,1.25,1.25,3.75,3.75,1.25,-0.13,-1.04,-1.75,-2.68,-3.75,-4.77,-5.88,-7.34,-9.67,-12,-15,-16,-14,-12,-9.93,-9.22,-9.60,-9.13,-9.18,-8.55,-8.35,-9.05,-9.36,-9.55,-10,-10,-9.05,-9.63,-9.51,-9.15,-9.38,-10,-11,-11,-11,-8.25,-6.27,-4.88,-3.88,-3.13,-3,-3,-2.88,-2.75,-1.65,-0.78,-0.13,0.46,0.93,1.25,1.55,2.01,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,21.25,21.25,18.75,20,18.75,18.75,18.75,16.25,16.25,15,15,15,14.98,13.71,12.39,11.25,10.14,10,9.78,9.78,9.77,9.72,9.63,9.05,8.64,8.28,7.98,7.77,7.61,7.51,7.48,7.46,7.45,7.39,7.34,7.18,6.97,6.68,6.42,6.28,6.25,6.23,6.23,6.22,6.22,6.22,6.21,6.20,6.13,6.11,6.07,5.93,5.77,5.55,5.35,5.18,5.09,4.98,4.87,4.78,4.62,4.39,4.20,4.01,3.87,3.76,3.71,3.59,3.42,3.12,2.71,2.23,1.82,1.50,1.45,1.46,2.27,2.47,2.48,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,4.21,4,2.76,0.93,-0.66,-1.86,-3.14,-4.79,-6.88,-9.10,-10,-10,-8.97,-8.93,-9.18,-9.11,-8.50,-7.43,-6.42,-5.89,-5.16,-4.35,-3.52,-2.75,-1.80,-0.05,1.05,1.11,-0.14,-1.15,-2.40,-3.97,-5.87,-8.15,-10,-12,-14,-16,-16,-15,-15,-15,-13,-11,-9.84,-9.38,-9.43,-10,-10,-10,-8.54,-7.27,-6.09,-4.52,-3.15,-2.01,-0.88,-0.38,-0.40,-0.38,-0.17,-0.13,-0.13,-0.63,1.09,1.25,1.25,5,7.50,7.50,6.25,6.25,3.75,1.25,-0.13,-0.79,-1,-2,-1.88,-1.04,-0.29,1.03,1.25,2.50,1.20,-0.28,-1.25,-2.26,-3.48,-4.75,-6.15,-7.55,-9.61,-12,-17,-19,-18,-15,-10,-8.18,-9.02,-9.54,-8.91,-8.55,-8.14,-8,-7.80,-8.17,-8.48,-8.27,-8.62,-8.61,-8.62,-9.25,-8.80,-8.87,-8.89,-9.26,-9.48,-9.50,-7.63,-6.03,-4.68,-3.52,-3.01,-3,-2.78,-2.67,-2.63,-1.63,-1,-0.40,0.12,0.62,1.04,1.39,1.71,2.02,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,17.50,17.50,16.25,16.25,17.50,17.50,18.75,18.75,17.50,16.25,16.25,16.25,15,13.73,12.48,11.34,11.11,10.14,9.98,9.98,10.11,10.88,9.72,9.20,8.72,8.32,8.01,7.78,7.62,7.51,7.48,7.46,7.43,7.38,7.32,7.17,6.96,6.68,6.43,6.29,6.25,6.23,6.23,6.22,6.22,6.21,6.20,6.14,6.11,6.05,5.95,5.80,5.63,5.46,5.28,5.14,5.03,4.98,4.89,4.82,4.65,4.42,4.20,4.01,3.87,3.76,3.70,3.59,3.42,3.13,2.79,2.38,2.02,1.75,1.51,2.27,2.34,2.48,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.27,2.64,1.55,0.26,-0.92,-2.02,-3.23,-4.72,-6.42,-8.25,-8.92,-8.65,-8.60,-8.80,-9.30,-9.25,-8.60,-7.39,-6.40,-5.90,-5.26,-4.50,-3.75,-3.05,-2.67,-1.13,-0.17,0.12,-0.18,-0.90,-1.88,-3.13,-4.91,-7.28,-9.85,-12,-14,-15,-16,-15,-15,-14,-13,-11,-9.84,-8.63,-8.75,-9.54,-9.75,-8.49,-7.23,-5.52,-4,-2.90,-1.61,-0.88,-0.15,-0.05,-0.12,-0.25,-0.26,-0.26,0,1.09,1.25,6.25,6.25,6.25,7.50,6.25,6.25,5,3.75,1.25,0.43,-0.25,-0.90,-2,-2,-1.66,-1.03,-0.13,1.18,2.50,0.77,-0.40,-1.38,-2.73,-4.17,-5.88,-7.88,-10,-12,-15,-18,-19,-18,-14,-9.53,-7.22,-7.87,-8.38,-8.51,-8,-7.93,-7.91,-7.97,-7.92,-7.88,-7.88,-7.63,-7.84,-8,-8.18,-8.87,-8.88,-8.16,-7.63,-7.89,-7.39,-6.86,-5.80,-4.59,-3.37,-2.22,-1.25,-1.13,-1.25,-1.26,-1.29,-0.92,-0.51,-0.13,0.42,0.77,1.20,1.39,1.71,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,13.75,13.75,13.75,13.75,15,16.25,17.50,17.50,16.25,15,13.75,13.75,13.75,12.50,12.48,12.45,11.14,10.12,10,9.98,10.11,10,9.68,9.17,8.72,8.34,8.02,7.79,7.63,7.52,7.48,7.46,7.43,7.36,7.30,7.17,6.90,6.67,6.43,6.29,6.25,6.23,6.23,6.22,6.22,6.21,6.18,6.12,6.07,5.95,5.82,5.65,5.48,5.32,5.18,5.10,5.01,4.97,4.89,4.82,4.65,4.42,4.21,4.01,3.87,3.76,3.70,3.59,3.42,3.14,2.84,2.52,2.27,2.05,2.14,2.29,2.47,2.48,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,2.64,1.55,0.55,-0.42,-1.27,-2.25,-3.40,-4.84,-6.30,-7.50,-8.34,-8.67,-8.55,-9.15,-9.50,-9.34,-8.88,-8.25,-7.25,-6.15,-5.60,-4.80,-4.02,-3.29,-2.43,-1.54,-0.50,0.09,0.03,-0.41,-1.38,-2.17,-3.25,-6.40,-9.13,-11,-13,-15,-16,-16,-16,-14,-12,-11,-10,-9.10,-9.24,-10,-10,-8.37,-6.17,-4.11,-2.47,-1.60,-0.73,-0.25,0.20,0.30,0.35,0.30,0.14,0.14,0.88,1.39,6.25,7.50,7.50,6.25,6.25,6.25,6.25,5,3.75,1.25,1.25,0.27,-0.30,-1.13,-1.63,-2,-2,-0.50,0.77,2.50,0.62,-0.55,-1.50,-3.02,-4.79,-6.88,-9.48,-13,-13,-15,-17,-17,-15,-12,-10,-8.04,-7.55,-7.97,-8.22,-8.14,-8.25,-8.25,-8.12,-8.11,-8.13,-8.13,-7.97,-7.73,-8.03,-8.62,-8.90,-8.91,-8.63,-8,-7.38,-6.79,-6.50,-5.79,-4.74,-3.47,-2,0.77,0.46,0.42,-0.39,-0.63,-0.63,-0.38,-0.15,0.29,0.72,1.05,1.25,1.39,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,12.50,12.50,12.50,12.50,13.75,13.75,13.75,13.75,12.50,12.50,11.25,11.25,11.25,11.25,11.23,10.02,10.09,9.93,9.87,9.84,9.79,9.42,9.05,8.68,8.32,8.02,7.80,7.64,7.52,7.48,7.45,7.39,7.36,7.29,7.12,6.88,6.65,6.43,6.29,6.25,6.23,6.23,6.22,6.21,6.20,6.13,6.09,5.97,5.87,5.67,5.51,5.35,5.21,5.12,5.03,5,4.96,4.88,4.80,4.65,4.42,4.21,4.02,3.88,3.76,3.70,3.59,3.42,3.15,2.90,2.63,2.45,2.34,2.36,2.43,2.47,2.48,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.54,2.51,3.75,3.75,3.75,3.75,3.75,2.01,0.62,-0.26,-1,-1.65,-2.55,-3.75,-5.12,-6.42,-7.52,-8.73,-8.18,-8.50,-9.29,-9.72,-9.72,-9.28,-8.75,-8.50,-7.27,-6,-5.13,-4.26,-3.41,-2.51,-1.63,-0.38,0.93,1.21,0.30,-0.89,-1.90,-2.67,-5.63,-8.38,-10,-13,-15,-18,-18,-17,-15,-12,-11,-10,-9.41,-10,-12,-11,-8.51,-5.86,-3.50,-1.97,-0.86,-0.13,0.18,0.51,0.79,1.09,1.18,1.39,1.87,2.02,3.75,5,6.25,6.25,6.25,6.25,6.25,6.25,5,5,2.50,1.25,1.25,1.25,-0.63,-1.25,-1.42,-2,-0.88,0.30,1.25,0.57,-0.51,-1.38,-3.16,-5.15,-7.47,-10,-13,-13,-11,-13,-13,-12,-12,-10,-9.89,-9.22,-8.68,-8.50,-9,-9.39,-8.93,-8.28,-8.03,-8.09,-8.18,-8.66,-8.66,-8.50,-8.91,-9.23,-9.22,-8.88,-8.27,-7.75,-7.17,-6.78,-6.12,-5.01,-3.73,-2.16,-0.64,0.46,0.45,0.62,0.77,0.77,-0.38,0.09,0.30,0.62,0.93,1.20,1.23,1.25,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,12.50,11.25,11.25,11.25,11.25,12.50,12.50,12.50,11.25,11.25,10,10,10,10,10,10,10,9.96,9.79,9.67,9.55,9.47,9.21,8.90,8.60,8.28,8.01,7.80,7.64,7.52,7.48,7.45,7.38,7.35,7.22,7.05,6.86,6.61,6.42,6.29,6.25,6.23,6.22,6.22,6.21,6.18,6.11,6.03,5.90,5.75,5.52,5.36,5.25,5.13,5.04,5,4.98,4.96,4.88,4.80,4.64,4.42,4.21,4.02,3.88,3.77,3.71,3.59,3.43,3.17,2.93,2.67,2.51,2.46,2.46,2.47,2.48,2.48,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.59,3.71,3.75,3.75,3.75,3.75,3.75,1.80,0.14,-0.75,-1.38,-2,-2.88,-4.05,-5.40,-6.75,-7.89,-8.25,-8,-8.50,-9.49,-9.99,-10,-9.50,-9.05,-8.75,-7.63,-6.50,-5.52,-4.54,-3.59,-2.54,-1.38,-0.02,1.39,2.64,0.88,-0.50,-1.65,-2.61,-5.24,-7.74,-10,-12,-15,-18,-20,-18,-15,-12,-11,-10,-10,-11,-12,-11,-8.02,-5.15,-2.76,-1.37,-0.50,-0.11,0.32,0.79,1.39,2.02,2.61,3.30,4.34,4.95,5,5,5,6.25,6.25,6.25,5,5,6.25,5,3.75,2.50,2.50,1.25,-1,-0.55,-0.93,-2,-0.88,0,1.25,0.61,-0.26,-1.13,-2.93,-5,-7.36,-10,-13,-13,-11,-8.04,-8.25,-10,-10,-10,-10,-10,-9.91,-10,-10,-11,-11,-9.75,-8.10,-7.80,-9.22,-11,-11,-9.91,-9.05,-9.22,-9.18,-8.88,-8.23,-7.88,-7.43,-7.77,-6.60,-5.47,-4.12,-2.64,-1.30,-0.53,0.59,1.25,2.15,1.39,1.09,0.57,0.46,0.77,0.93,1.05,1.07,1.25,1.25,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,3.75,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,10,9.84,9.55,9.37,9.23,9.15,9.01,8.78,8.54,8.27,8,7.80,7.64,7.52,7.48,7.45,7.38,7.32,7.18,7.02,6.82,6.59,6.40,6.29,6.25,6.23,6.22,6.22,6.20,6.14,6.09,5.97,5.80,5.63,5.42,5.25,5.14,5.04,5.01,5,4.98,4.96,4.88,4.80,4.64,4.42,4.21,4.03,3.88,3.77,3.71,3.60,3.43,3.22,2.95,2.68,2.53,2.50,2.48,2.48,2.48,2.48,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.59,3.70,3.75,3.75,3.75,3.75,3.75,1.71,0.14,-0.88,-1.63,-2.15,-3.11,-4.30,-5.68,-7.10,-8.61,-8.11,-8.14,-8.52,-9.50,-9.99,-10,-9.51,-9.09,-8.85,-8.14,-7,-6,-4.88,-3.77,-2.68,-1.38,-0.38,0.77,1.18,0.72,-0.38,-1.27,-2.90,-4.91,-7.24,-9.62,-11,-14,-17,-19,-18,-15,-12,-11,-10,-11,-11,-11,-9.47,-6.89,-4.37,-2.38,-0.92,-0.39,-0.23,0.62,0.93,1.53,3.54,4.84,6.13,5,5,5,6.25,6.25,7.50,8.75,6.25,6.25,5,6.25,6.25,6.25,3.75,2.50,1.25,1.25,-1,-0.15,-0.40,-0.53,-0.13,1.25,0.93,0.27,-0.63,-2.38,-4.37,-6.64,-9.15,-12,-13,-12,-8.97,-6.75,-8.02,-8.85,-9.50,-10,-10,-10,-11,-12,-13,-13,-11,-9,-8.15,-11,-13,-13,-12,-9.66,-8.90,-8.89,-8.54,-8.13,-7.78,-7.97,-7.49,-6.84,-5.63,-4.27,-2.98,-1.63,-0.65,0.27,1.34,2.50,2.50,1.25,1.25,1.09,0.93,0.77,0.62,0.60,0.77,0.93,1.25,1.54,1.84,2,2.34,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,11.25,11.25,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9.98,9.68,9.35,8.95,8.87,8.89,8.86,8.71,8.47,8.25,7.98,7.78,7.63,7.52,7.48,7.45,7.37,7.29,7.15,6.98,6.76,6.55,6.39,6.29,6.25,6.22,6.22,6.21,6.20,6.13,6.07,5.93,5.77,5.57,5.30,5.14,5.04,5.01,5,4.98,4.97,4.96,4.88,4.80,4.64,4.42,4.21,4.03,3.88,3.77,3.72,3.61,3.46,3.23,2.95,2.70,2.54,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.59,2.53,3.75,3.75,3.75,3.75,3.75,2.02,0.46,-0.80,-1.75,-2.38,-3.37,-4.50,-5.76,-7.09,-8.41,-8.74,-8.43,-9.18,-9.76,-10,-10,-9.79,-9.35,-9.29,-9.23,-7.99,-6.49,-5.26,-4.13,-3,-1.89,-0.88,0,0.61,0.46,-0.25,-1.13,-2.75,-4.84,-7.03,-9.17,-11,-13,-15,-17,-16,-14,-11,-11,-10,-11,-11,-10,-7.98,-5.48,-3.12,-1.60,-0.54,-0.37,-0.35,-0.55,0.97,2.63,4.72,8.57,7.37,5,3.75,5,5,7.50,8.75,8.75,7.50,6.25,7.50,7.50,8.75,8.75,6.25,5,3.75,1.25,1.25,1.20,0.72,0.13,-1,1.25,1.71,1.09,0,-1.39,-3.22,-5.38,-7.73,-10,-11,-11,-13,-10,-9.55,-9.51,-9,-9.23,-9,-9.10,-10,-12,-13,-13,-12,-9.22,-9.35,-12,-14,-14,-13,-10,-8.62,-8.49,-8,-7.85,-7.50,-7.63,-6.99,-6.29,-5.25,-3.91,-2.79,-1.50,-0.63,0.30,1.39,2.50,2.50,2.50,2.50,1.25,1.25,1.25,-0.90,-0.13,0.14,0.42,0.62,0.88,1.09,1.39,1.71,2.02,2.18,2.43,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,11.25,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9.98,9.62,9.22,8.87,8.76,8.75,8.75,8.62,8.43,8.22,7.97,7.78,7.63,7.52,7.48,7.43,7.36,7.28,7.13,6.96,6.73,6.55,6.39,6.28,6.25,6.22,6.21,6.21,6.18,6.12,6.05,5.92,5.76,5.51,5.28,5.12,5.02,5,5,4.98,4.97,4.96,4.89,4.80,4.65,4.42,4.21,4.02,3.88,3.77,3.73,3.63,3.47,3.25,2.95,2.70,2.54,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.53,3.75,3.75,3.75,3.75,3.75,2.80,0.77,-0.54,-1.55,-2.37,-3.41,-4.54,-5.75,-6.98,-8.05,-8.27,-8.75,-9.60,-10,-10,-10,-10,-9.63,-9.38,-9.36,-8.25,-6.88,-5.64,-4.54,-3.50,-2.47,-1.50,-0.63,-0.03,0.14,-0.17,-0.92,-2.16,-4.88,-6.99,-8.88,-10,-12,-14,-15,-15,-13,-12,-11,-11,-11,-11,-9,-6.67,-4.24,-2.30,-0.84,-0.13,0.09,-0.43,-0.61,1.38,2.80,5.14,7.29,6.37,5,6.25,5,6.25,8.75,10,11.25,8.75,10,8.75,10,10,10,10,8.75,8.75,6.25,5,3.75,1.25,1.25,1.25,1.25,3.70,2.18,0.93,-0.25,-1.75,-3.68,-5.90,-8,-9.76,-11,-12,-15,-13,-12,-9.88,-8.92,-7.90,-7.34,-8.54,-10,-12,-13,-11,-8.63,-8.76,-12,-14,-15,-13,-9.97,-8.36,-8.38,-8.27,-7.77,-6.98,-6.67,-6.12,-5.35,-4.26,-3.04,-1.85,-1,-0.25,0.77,1.70,2.50,2.50,2.50,2.50,1.25,1.25,1.25,-0.78,-0.38,-0.25,-0.16,-0.03,0.14,0.45,0.72,1.05,1.51,1.85,2.12,2.30,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,10,10,10,10,10,10,10,10,9.98,9.98,9.98,9.98,9.98,9.98,9.98,9.96,9.89,9.54,9.20,8.90,8.76,8.73,8.70,8.59,8.43,8.21,7.97,7.79,7.64,7.52,7.48,7.43,7.35,7.27,7.12,6.90,6.72,6.54,6.39,6.28,6.25,6.22,6.21,6.20,6.18,6.11,6.04,5.93,5.73,5.48,5.26,5.11,5.01,5,5,5,4.98,4.98,4.95,4.85,4.68,4.47,4.20,4.01,3.87,3.77,3.73,3.63,3.47,3.25,2.96,2.70,2.54,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.53,3.75,3.75,3.75,3.75,3.75,2.64,1.09,-0.38,-1.39,-2.25,-3.38,-4.50,-5.63,-6.75,-8.12,-7.85,-9.03,-10,-10,-11,-11,-10,-10,-9.63,-9,-8.65,-7.11,-5.97,-4.99,-4.01,-3.03,-2.12,-1.25,-0.50,0.09,-0.13,-0.75,-2.29,-4.75,-6.87,-8.67,-10,-11,-13,-15,-14,-13,-11,-11,-11,-11,-10,-8.13,-5.66,-3.24,-1.50,-0.22,0.50,1.02,1.27,1.65,1.60,3.85,5.27,6.42,8.60,7.50,5,5,7.50,8.75,11.25,11.25,11.25,12.50,12.50,11.25,10,10,11.25,10,12.50,12.50,7.64,7.25,4.98,4.70,3.93,4.10,4.71,3.28,1.92,0.50,-0.54,-1.63,-4.12,-6.25,-8.04,-9.72,-11,-13,-13,-13,-12,-11,-9.93,-7.77,-5.61,-6.99,-9.55,-10,-9.40,-7.78,-7.02,-10,-12,-13,-11,-8.50,-8.23,-8.50,-8.42,-7.93,-7.04,-6.35,-5.52,-4.53,-3.38,-2.10,-0.63,-0.05,0.77,1.71,2.43,2.50,2.50,2.50,2.50,1.25,1.25,1.25,0.77,-0.51,-0.65,-0.68,-0.63,-0.50,-0.30,-0.13,0.26,0.62,1.04,1.39,1.84,2.43,3.12,3.71,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,10,10,10,10,10,10,9.98,9.98,9.98,9.98,9.98,9.98,9.98,9.97,9.95,9.86,9.73,9.40,9.15,8.89,8.76,8.73,8.68,8.59,8.42,8.22,7.97,7.79,7.64,7.53,7.48,7.43,7.35,7.23,7.09,6.90,6.71,6.54,6.39,6.28,6.25,6.22,6.21,6.20,6.18,6.11,6.07,5.92,5.72,5.47,5.26,5.11,5.01,5,5,5,4.98,4.98,4.95,4.85,4.68,4.47,4.20,4,3.86,3.77,3.73,3.63,3.47,3.25,2.96,2.70,2.54,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.59,2.52,3.75,3.75,3.75,3.75,3.57,2.50,1.18,-0.26,-1.38,-2.23,-3.29,-4.39,-5.47,-6.48,-7.29,-8.25,-9.22,-10,-11,-11,-11,-11,-10,-9.38,-9.15,-8.38,-7.05,-6.18,-5.49,-4.75,-3.89,-2.97,-1.98,-0.90,-0.15,0,-0.41,-2.48,-4.63,-6.75,-8.55,-10,-11,-12,-14,-14,-13,-11,-11,-12,-12,-10,-7.48,-4.84,-2.47,-1,0.34,1.10,2.34,3.27,3.59,4.10,5.92,5.27,6.42,8.60,10,6.25,5,7.50,8.75,10,11.25,12.50,12.50,15,12.50,11.25,11.25,11.25,12.50,15,14.85,10.29,7.89,7.07,6.39,6.57,5.84,5.22,4.18,2.80,1.42,0.13,-0.87,-2.66,-4.53,-6.36,-8.03,-9.66,-11,-12,-12,-12,-12,-11,-10,-7.54,-6.35,-7.01,-8.40,-7.77,-7.11,-7.16,-7.41,-9.38,-10,-8.42,-7.73,-7.80,-8.30,-8.29,-7.80,-7.12,-6.34,-5.30,-4.12,-2.73,-1.14,0.14,1.07,2.02,2.92,3.52,3.75,3.75,2.50,2.50,1.25,1.25,1.09,-0.51,-0.75,-1.13,-1.25,-1.25,-1.13,-1,-0.75,-0.50,-0.17,0.14,0.62,1.09,1.87,2.32,2.78,3.12,3.43,3.71,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,10,10,10,10,9.98,9.98,9.98,9.98,9.98,9.98,9.98,9.98,9.98,9.96,9.87,9.73,9.52,9.26,9.05,8.88,8.76,8.72,8.64,8.57,8.42,8.22,7.97,7.79,7.64,7.53,7.48,7.43,7.35,7.23,7.09,6.89,6.71,6.54,6.39,6.28,6.25,6.22,6.21,6.20,6.18,6.13,6.05,5.90,5.71,5.47,5.26,5.11,5.01,5,5,5,4.98,4.98,4.95,4.85,4.68,4.47,4.20,4,3.86,3.77,3.73,3.63,3.47,3.25,2.96,2.70,2.54,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.60,2.54,3.72,3.75,3.75,3.75,3.75,3.40,2.47,1.25,-0.03,-1.04,-2.03,-3.25,-4.38,-5.38,-6.16,-6.89,-8,-8.98,-10,-10,-11,-11,-11,-10,-9.02,-8.12,-7.34,-6.63,-6.43,-6.13,-5.65,-4.97,-4.04,-2.98,-1.85,-0.40,0.14,-0.02,-2.25,-4.55,-6.67,-8.62,-10,-11,-11,-13,-14,-13,-11,-11,-11,-11,-9.26,-6.75,-4.26,-2.25,-0.79,-0.36,1.71,3.70,5.77,5.80,5.35,7.17,7.21,6.42,8.87,12.50,7.50,6.25,6.25,7.50,8.75,11.25,12.50,12.50,16.25,15,12.50,11.25,11.25,12.50,15,14.75,10.39,9.05,8.14,7.78,7.36,7.22,5.96,4.90,3.75,2.48,1.20,-0.15,-0.93,-3.03,-4.72,-6.25,-7.65,-9.04,-10,-11,-12,-12,-11,-11,-10,-9.01,-8.88,-8.68,-8.63,-6.86,-6.89,-7.55,-7.49,-7.88,-7.49,-7.27,-7.79,-8.25,-8.38,-8.11,-7.40,-6.51,-5.38,-3.98,-2.25,-0.38,0.77,1.87,3.12,4.21,4.95,5,3.75,3.75,2.50,1.25,1.25,0.93,-0.50,-1.13,-1.50,-1.65,-1.75,-1.75,-1.64,-1.40,-1.17,-0.90,-0.63,-0.25,0.27,0.77,1.25,1.71,2.18,2.64,3.12,3.59,3.72,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,10,10,10,9.98,9.98,9.98,9.98,9.98,9.98,9.98,9.98,9.98,9.97,9.95,9.80,9.57,9.34,9.10,8.93,8.84,8.75,8.71,8.63,8.59,8.43,8.23,7.98,7.79,7.64,7.53,7.48,7.43,7.35,7.23,7.09,6.89,6.71,6.54,6.39,6.28,6.25,6.22,6.21,6.20,6.20,6.12,6.04,5.90,5.71,5.47,5.26,5.11,5.01,5,5,5,4.98,4.98,4.95,4.85,4.68,4.47,4.20,3.96,3.86,3.76,3.73,3.64,3.48,3.25,2.96,2.70,2.54,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.62,2.59,3.70,3.73,3.75,3.75,3.75,3.72,3.27,2.64,1.39,0.28,-0.75,-1.87,-3.22,-4.42,-5.49,-6.16,-6.14,-6.85,-8.27,-9.75,-10,-11,-11,-11,-10,-8.89,-7.13,-6.35,-6.24,-6.78,-7.15,-6.85,-6.25,-5.39,-4.28,-3.02,-1.72,-0.25,-0.03,-2.30,-4.63,-6.78,-8.75,-10,-11,-12,-14,-15,-14,-12,-11,-11,-10,-8.38,-5.88,-3.50,-1.63,-0.39,-0.50,1.86,5.77,7.03,7.05,7.14,6.54,7.22,8.57,8.85,11.25,8.75,7.50,8.75,7.50,8.75,10,12.50,15,15,16.25,15,11.25,12.50,12.50,15,13.75,11.67,10.01,9.18,8.61,8.21,7.59,6.85,5.92,4.89,3.76,2.48,1.12,-0.39,-1.61,-3.11,-4.41,-5.65,-6.77,-7.85,-8.92,-10,-10,-11,-11,-11,-11,-11,-12,-11,-10,-8.80,-8.01,-7.77,-6.49,-6.79,-7.62,-8.18,-8.50,-8.55,-8.47,-7.99,-6.88,-5.64,-4.18,-2.38,0.77,0.77,1.65,4.03,4.78,4.78,4.78,3.75,3.27,2.50,2.50,1.21,0.77,-0.53,-1.34,-2.30,-2.60,-2.27,-2.22,-2.24,-2.09,-1.88,-1.64,-1.29,-1,-0.63,-0.25,0.14,0.75,1.25,1.71,2.28,2.61,2.62,3.72,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,5,10,10,9.98,9.98,9.98,9.98,9.98,9.98,9.98,9.97,9.96,9.95,9.93,9.79,9.72,9.32,9.10,8.95,8.86,8.77,8.73,8.70,8.64,8.59,8.43,8.26,8.02,7.80,7.64,7.53,7.48,7.43,7.35,7.23,7.09,6.90,6.71,6.53,6.39,6.27,6.25,6.22,6.22,6.21,6.20,6.12,6.04,5.89,5.71,5.47,5.26,5.11,5.01,5,5,5,4.98,4.98,4.95,4.85,4.68,4.47,4.20,3.96,3.86,3.76,3.73,3.64,3.48,3.25,2.96,2.70,2.54,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.52,2.61,3.64,3.71,3.73,3.75,3.75,3.75,3.70,3.27,2.64,1.71,0.62,-0.50,-1.73,-3.23,-4.63,-5.75,-6.38,-6.75,-5.88,-7.52,-9.05,-10,-10,-10,-10,-9.50,-8.22,-6.55,-5.88,-6.47,-7.54,-8.25,-8.35,-7.92,-6.89,-5.73,-4.47,-3.24,-2.23,-1.01,-3.11,-5.13,-7.18,-9.13,-10,-12,-13,-14,-14,-13,-12,-11,-10,-9.66,-7.42,-5.03,-2.77,-1.24,0.42,1.28,1.71,5.89,8.29,7.85,8.40,7.77,6.45,7.64,9.88,10,8.75,7.50,8.75,8.75,8.75,10,12.50,13.75,15,15,15,15,12.50,13.75,15,15.95,12.89,11.10,9.95,9.32,8.88,8.37,7.79,7.10,6.25,5.22,4,2.53,0.87,-0.63,-1.75,-2.74,-3.67,-4.62,-5.41,-6.25,-7.43,-8.43,-9.25,-10,-10,-11,-12,-14,-16,-15,-13,-9.80,-8.90,-7.65,-6.97,-7.67,-8.35,-8.91,-9.18,-9.10,-8.62,-7.34,-6.13,-4.77,-3.16,-1.66,-0.64,0.77,1.34,1.87,2.13,2.18,2.43,2.80,3.75,2.50,1.09,-0.55,-0.88,-2.42,-3.40,-3.79,-3.50,-3.60,-3.75,-3.77,-3.23,-2.38,-1.97,-1.65,-1.39,-1.03,-0.67,-0.25,0.14,0.62,1.09,1.51,2.30,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,9.98,9.98,9.98,9.98,9.98,9.97,9.97,9.96,9.89,9.85,9.72,9.64,9.68,9.68,9.04,9.04,8.90,8.85,8.77,8.75,8.72,8.70,8.63,8.59,8.45,8.27,8.07,7.85,7.67,7.54,7.50,7.45,7.37,7.29,7.14,6.92,6.71,6.52,6.37,6.27,6.23,6.22,6.22,6.21,6.20,6.12,6.04,5.89,5.71,5.47,5.26,5.11,5.01,5,5,5,4.98,4.98,4.95,4.85,4.68,4.47,4.20,3.95,3.86,3.76,3.72,3.63,3.47,3.25,2.96,2.70,2.54,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.52,2.65,2.67,3.57,3.71,3.75,3.75,3.73,3.72,3.59,3.22,2.62,1.71,0.76,-0.30,-1.38,-3.38,-4.93,-6.23,-6.99,-6.99,-6.65,-6.73,-7.78,-8.86,-9.42,-9.51,-9.13,-8.24,-7.41,-6.43,-6,-6.14,-7.55,-9.41,-10,-9.54,-8.60,-7.14,-5.76,-4.63,-3.75,-3.35,-4.17,-5.80,-7.88,-9.75,-11,-12,-13,-14,-15,-13,-12,-10,-10,-9.25,-6.77,-4.41,-2.48,-1.14,-0.53,1.71,7.02,7.05,7.89,9.64,10.93,7.76,7.67,7.62,9.95,8.75,7.50,8.75,10,10,10,11.25,12.50,13.75,15,16.25,16.25,15,13.75,13.75,15,14.75,13.43,12.02,10.48,9.87,9.51,9.22,8.87,8.42,7.79,6.96,5.80,4.28,2.43,0,-0.75,-1.16,-1.84,-2.52,-3.26,-3.76,-4.09,-5.38,-6.34,-7.49,-8.63,-9.85,-11,-13,-15,-16,-14,-11,-10,-9.39,-7.87,-7.75,-8.43,-9.13,-9.37,-9.25,-8.76,-7.76,-6.76,-5.73,-4.65,-3.60,-2.50,-1.54,-0.79,-0.50,-0.38,0,0.93,1.71,3.43,2.34,0.93,-0.54,-1.35,-2.65,-3.49,-4.03,-4.41,-4.78,-5.24,-5.63,-6,-4.85,-4.50,-3.75,-2.93,-2.42,-1.60,-1.03,-0.65,-0.38,-0.15,0.93,1.03,1.39,2.18,2.30,2.50,2.75,2.64,3.75,3.75,3.75,3.75,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,9.98,9.98,9.98,9.98,9.98,9.97,9.96,9.89,9.84,9.68,9.51,9.35,9.21,9.07,8.92,8.79,8.78,8.76,8.75,8.73,8.72,8.70,8.63,8.59,8.46,8.30,8.11,7.90,7.70,7.59,7.50,7.45,7.37,7.28,7.13,6.92,6.71,6.53,6.38,6.27,6.23,6.22,6.22,6.21,6.20,6.12,6.04,5.89,5.71,5.47,5.26,5.11,5.01,5,5,5,4.98,4.98,4.95,4.86,4.68,4.42,4.21,4.01,3.87,3.76,3.72,3.61,3.45,3.23,2.96,2.71,2.59,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.54,2.77,3.48,3.53,3.71,3.75,3.75,3.72,3.63,3.52,3.02,2.34,1.55,0.61,-0.38,-1.17,-3.40,-5.04,-6.43,-7.36,-7.27,-6.88,-6.48,-7.25,-7.93,-8.52,-8.72,-8.50,-7.87,-7.13,-6.42,-6.13,-5.90,-6.65,-8.97,-10,-11,-10,-8.17,-6.75,-5.72,-5.02,-4.93,-5.84,-7.23,-8.88,-10,-12,-13,-14,-14,-14,-13,-11,-11,-10,-8.68,-6.25,-3.74,-1.88,-0.85,-0.64,1.68,7.04,8.32,9.64,10.92,10.93,8.95,9.82,8.85,7.50,8.75,8.75,10,10,11.25,11.25,11.25,12.50,13.75,13.75,15,15,15,16.25,15,15,13.89,13.59,12.34,10.98,9.98,10.17,10.13,10.02,9.84,9.50,8.92,7.97,6.51,4.25,1.87,0.61,0.13,-0.18,-0.86,-1.43,-1.90,-1.88,-2.13,-3.67,-4.90,-6.38,-7.76,-9.24,-10,-12,-13,-14,-12,-11,-9.90,-8.78,-8.26,-8.87,-9.28,-9.43,-9.35,-8.91,-8.25,-7.49,-6.79,-6.13,-5.37,-4.52,-3.68,-2.97,-2.25,-1.51,-0.90,-0.38,0.30,0.73,0.77,0.30,-0.03,-1.17,-2.40,-3.24,-4.48,-5.13,-5.75,-6.49,-7.41,-8.88,-9,-8.12,-7.72,-7.26,-6.13,-4.38,-2,-1.15,-0.88,-0.88,-0.76,-0.65,0.77,1.52,1.87,2.18,2.34,2.59,2.64,2.50,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,3.75,3.75,2.50,2.50,2.50,2.50,2.50,9.98,9.98,9.98,9.98,9.98,9.97,9.95,9.86,9.71,9.51,9.26,9.05,8.90,8.87,8.84,8.76,8.75,8.75,8.73,8.72,8.72,8.71,8.64,8.59,8.47,8.32,8.13,7.93,7.75,7.61,7.50,7.45,7.37,7.28,7.13,6.92,6.71,6.53,6.38,6.27,6.23,6.22,6.22,6.21,6.20,6.12,6.04,5.90,5.72,5.47,5.25,5.10,5.01,5,5,5,4.98,4.98,4.93,4.84,4.65,4.42,4.21,4.01,3.86,3.76,3.71,3.60,3.43,3.22,2.96,2.75,2.59,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.60,2.80,3.43,3.68,3.73,3.75,3.75,3.72,3.60,3.30,2.80,2.02,1.21,0.26,-0.55,-1.28,-3.29,-5,-6.38,-7.27,-7.25,-6.25,-6.28,-7.26,-8.04,-8.51,-8.65,-8.50,-8.04,-7.75,-7.14,-6.22,-6.13,-5.86,-7.23,-9.59,-10,-10,-8.50,-7.25,-6.29,-5.87,-6.02,-6.99,-8.38,-10,-11,-12,-13,-14,-14,-13,-12,-11,-11,-10,-8.88,-5.72,-3.15,-1.48,-0.67,0.80,-0.67,1.60,8.39,10.92,10.93,10.25,11.07,11.37,12.45,8.75,7.50,8.75,10,10,10,11.25,12.50,13.75,15,16.25,15,15,15,15,15,15,15,13.73,12.62,11.61,10.84,10.96,10.98,11.13,11.21,11.21,10.97,10.37,9.27,7.29,2.28,2.64,2.64,1.71,0.77,-0.63,-0.64,-0.75,-0.93,-1.52,-2.53,-3.89,-5.23,-6.66,-8.25,-9.79,-11,-12,-12,-12,-10,-8.78,-8.79,-8.97,-9.38,-9.51,-9.65,-9.49,-8.64,-8.13,-7.84,-7.63,-7.18,-6.52,-5.78,-5.11,-4.43,-3.75,-2.93,-2,-1,-0.68,-0.50,-0.17,-0.03,-0.51,-2.74,-3.92,-4.99,-5.73,-6.42,-7.30,-8.59,-10,-9.88,-9.88,-10,-10,-9.17,-6.63,-4.52,-2.24,-0.88,-0.88,-1.53,-0.42,0.62,0.76,1.21,1.80,1.87,2.13,2.34,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,9.98,9.98,9.98,9.98,9.98,9.97,9.95,9.82,9.62,9.35,9.07,8.89,8.79,8.76,8.75,8.75,8.73,8.73,8.73,8.72,8.72,8.71,8.68,8.60,8.48,8.37,8.15,7.96,7.77,7.62,7.51,7.46,7.36,7.28,7.13,6.90,6.71,6.53,6.38,6.27,6.25,6.22,6.22,6.21,6.20,6.12,6.05,5.92,5.73,5.47,5.25,5.10,5.01,5,5,5,4.98,4.96,4.89,4.80,4.65,4.42,4.21,4.01,3.86,3.76,3.71,3.60,3.43,3.22,2.96,2.76,2.60,2.51,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.52,2.63,2.82,3.40,3.70,3.75,3.75,3.75,3.72,3.60,3.28,2.67,1.82,0.76,-0.25,-0.88,-1.50,-3.10,-4.75,-6.14,-7.03,-7.05,-6.51,-6.29,-7.22,-7.98,-8.41,-8.55,-8.39,-8.49,-8.22,-7.52,-6.79,-5.68,-5.43,-5.55,-6.91,-8.75,-8.68,-8.73,-7.09,-6.37,-6.15,-6.53,-7.68,-9.25,-11,-12,-13,-14,-14,-14,-13,-12,-11,-11,-10,-8.04,-5.63,-3.40,-1.91,-0.76,-0.73,0.89,1.55,7.43,10.93,10.25,11.42,11.39,13.68,15,8.75,8.75,11.25,10,10,11.25,11.25,12.50,13.75,15,16.25,16.25,16.25,15,15,15,16.25,16.25,13.75,12.50,12.50,12.20,11.62,11.70,11.90,12.65,12.46,12.87,13.17,12.05,11.70,10,8.59,7.18,5.88,1.67,1.67,1.55,1.09,0.46,0.18,-0.52,-1.35,-2.61,-4,-5.65,-7.30,-8.85,-10,-11,-11,-10,-9.18,-8.60,-8.75,-9.18,-9.66,-9.84,-9.62,-9,-8.35,-8.68,-9.03,-9.16,-8.61,-7.87,-7.22,-6.63,-5.87,-4.91,-3.88,-2.84,-2,-1.50,-2,-2.37,-3.25,-4.13,-4.97,-5.63,-6.23,-6.88,-7.63,-8.89,-10,-9.88,-10,-10,-11,-10,-7.79,-5.52,-2.55,-0.13,-0.43,-0.50,-0.38,-0.05,0.34,0.72,0.95,1.21,1.54,2.18,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,9.98,9.98,9.98,9.98,9.98,9.97,9.93,9.79,9.53,9.22,8.96,8.84,8.75,8.75,8.75,8.73,8.73,8.73,8.73,8.72,8.72,8.71,8.68,8.60,8.52,8.37,8.15,7.96,7.77,7.62,7.51,7.46,7.36,7.28,7.12,6.90,6.71,6.53,6.39,6.28,6.25,6.22,6.22,6.21,6.20,6.13,6.05,5.92,5.73,5.47,5.25,5.10,5.01,5,5,5,4.97,4.96,4.88,4.80,4.65,4.42,4.21,4.01,3.86,3.76,3.72,3.61,3.43,3.22,2.96,2.76,2.61,2.51,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.54,2.75,2.85,3.42,3.68,3.75,3.75,3.75,3.72,3.63,3.45,2.71,1.76,0.59,-0.36,-1,-1.63,-2.78,-4.34,-5.85,-6.75,-7.13,-6.63,-6.59,-6.80,-7.59,-8,-8.14,-8.39,-8.53,-8.47,-8,-7.17,-6.16,-5.67,-5.62,-5.75,-6.63,-7.39,-6.63,-5.92,-5.79,-6.01,-6.43,-7.24,-9.63,-11,-12,-13,-14,-14,-13,-13,-12,-11,-11,-10,-7.67,-5.38,-3.40,-2.11,-1.65,-0.67,1.20,4.68,8.46,12.27,12.61,13.59,13.75,14.98,13.75,11.25,10,11.25,12.50,11.25,12.50,12.50,12.50,15,15,16.25,16.25,15,15,15,16.25,16.25,15,15,12.50,12.50,12.50,12.35,11.78,12.60,12.60,13.05,13.78,15.01,14.65,14.02,13.75,12.50,8.89,8.57,8.43,6.25,5,2.75,2.96,2.34,1.55,0.76,-0.13,-1.52,-3.23,-4.99,-6.59,-7.99,-9.23,-10,-10,-9.13,-7.79,-8.26,-8.93,-9.50,-9.61,-9.38,-8.85,-8.55,-9.05,-10,-11,-10,-9.63,-9.13,-8.59,-7.93,-7,-5.75,-4.80,-4.25,-4,-4.25,-5,-5.77,-5.80,-5.93,-6.09,-6.25,-6.67,-6.90,-7.40,-7.79,-8.18,-8.88,-9.73,-9.92,-9.54,-7.23,-5.12,-2.18,0.55,0.59,-0.13,-0.22,-0.11,0.14,0.57,0.78,1.02,1.29,1.53,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,9.98,9.98,9.98,9.98,9.98,9.97,9.89,9.78,9.52,9.21,8.92,8.78,8.75,8.75,8.75,8.73,8.73,8.72,8.73,8.72,8.72,8.71,8.68,8.61,8.52,8.37,8.17,7.96,7.78,7.63,7.51,7.46,7.36,7.27,7.12,6.90,6.71,6.53,6.39,6.29,6.25,6.23,6.22,6.22,6.20,6.13,6.09,5.95,5.75,5.47,5.25,5.11,5.01,5,5,4.98,4.97,4.96,4.89,4.82,4.65,4.42,4.21,4,3.86,3.76,3.72,3.63,3.46,3.22,2.96,2.75,2.60,2.51,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.60,2.80,3.34,3.54,3.71,3.75,3.75,3.75,3.73,3.70,3.46,2.95,2.03,0.77,-0.17,-0.88,-1.63,-2.49,-3.88,-5.39,-6.50,-6.64,-7.16,-6.61,-6.65,-7.25,-7.60,-7.75,-8.62,-8.99,-8.88,-8.29,-7.37,-6.90,-6.23,-6.18,-6.64,-7.01,-7.34,-7.17,-6.51,-6.27,-6.36,-7.01,-7.99,-9,-10,-12,-13,-13,-14,-14,-13,-12,-11,-11,-9.75,-7.38,-5.25,-3.41,-2.26,-1.64,-0.66,1.60,4.05,8.47,12.32,14.85,14.93,15,15,16.25,16.25,12.50,12.50,12.50,12.50,12.50,12.50,13.75,13.75,15,17.50,16.25,15,15,15,15,15,15,13.75,12.50,12.50,12.50,12.50,13.75,12.27,12.18,12.78,14.02,15.75,17.20,17.50,15,12.50,12.50,11.25,12.50,10,10,7.34,6.25,5.40,4.46,3.27,1.98,0.62,-0.99,-2.75,-4.41,-5.84,-7,-7.88,-8.22,-7.89,-7.91,-7.55,-8.38,-8.88,-9,-9.09,-9.14,-8.77,-8.35,-10,-11,-11,-11,-10,-10,-9.97,-8.89,-7.52,-6.62,-6.25,-6.25,-6.65,-7.63,-8.01,-7.23,-6.73,-6.28,-6,-5.98,-5.75,-5.75,-5.88,-5.91,-6.12,-6.65,-7.01,-7.35,-5.73,-3.50,-1.38,0.30,0.42,0.21,0.13,0.27,0.36,0.73,0.89,1.04,1.22,1.38,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,9.98,9.98,9.98,9.98,9.98,9.97,9.89,9.77,9.51,9.20,8.92,8.78,8.75,8.75,8.75,8.73,8.73,8.72,8.72,8.72,8.72,8.71,8.68,8.61,8.52,8.37,8.17,7.96,7.78,7.63,7.51,7.46,7.36,7.27,7.12,6.90,6.71,6.54,6.39,6.34,6.27,6.25,6.25,6.22,6.21,6.18,6.11,5.97,5.77,5.51,5.21,5.13,5.02,5,4.98,4.98,4.97,4.96,4.89,4.82,4.65,4.42,4.20,4,3.85,3.75,3.72,3.63,3.48,3.23,2.96,2.71,2.60,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.52,2.60,2.92,3.30,3.63,3.72,3.75,3.75,3.75,3.73,3.71,3.59,3.42,2.53,1.55,0.45,-0.50,-1.28,-2.38,-3.61,-4.91,-6.13,-7.05,-7.38,-6.29,-6.29,-6.85,-7.50,-8.13,-8.91,-9.27,-9.13,-8.63,-8.09,-7.62,-6.63,-7.23,-7.97,-8.65,-9,-8.87,-8.25,-7.74,-7.49,-7.63,-8.73,-9.89,-10,-11,-12,-13,-13,-13,-13,-12,-11,-10,-9.18,-7.13,-5.29,-3.75,-2.55,-1.63,-0.65,1.60,4.95,8.47,10.14,12.53,16.25,16.25,15,15,16.25,13.75,13.75,13.75,13.75,12.50,12.50,15,15,16.25,16.25,16.25,15,15,15,16.25,15,13.75,13.75,12.50,12.50,12.50,12.50,13.75,11.25,10,12.50,13.75,15,17.50,17.50,16.25,15,13.75,13.75,13.75,13.75,11.25,11.71,9.37,8.59,7.64,6.38,4.84,3.27,1.51,-0.72,-2.39,-3.88,-5.16,-6.18,-6.93,-7.50,-8.09,-8.04,-7.60,-7.84,-8.59,-8.98,-9,-8.66,-8.29,-8.27,-9.68,-10,-9.43,-10,-11,-11,-10,-9.03,-8.13,-7.90,-8.13,-8.55,-9.40,-9.50,-8.13,-7,-6.11,-5.30,-4.66,-4.22,-3.99,-3.90,-3.73,-2.88,-2.23,-3.13,-3.88,-2.67,-1.88,-0.86,-0.13,0.39,0.55,0.67,0.88,0.98,1.21,1.26,1.35,1.51,1.39,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,9.98,9.98,9.98,9.98,9.98,9.97,9.89,9.77,9.51,9.20,8.92,8.78,8.75,8.75,8.75,8.73,8.73,8.72,8.72,8.72,8.72,8.71,8.68,8.61,8.52,8.37,8.21,7.96,7.77,7.63,7.51,7.46,7.36,7.27,7.12,6.90,6.72,6.55,6.42,6.37,6.34,6.28,6.26,6.25,6.23,6.21,6.14,6.05,5.88,5.62,5.30,5.14,5.04,5.01,5,4.98,4.97,4.96,4.89,4.84,4.67,4.42,4.20,3.96,3.84,3.75,3.72,3.63,3.48,3.25,2.95,2.70,2.54,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.52,2.68,2.95,3.42,3.68,3.75,3.75,3.75,3.75,3.75,3.73,3.70,3.53,3.45,2.22,1.09,-0.09,-0.98,-2,-3.24,-4.60,-5.98,-7.67,-7.68,-6.75,-5.74,-6.54,-7.25,-8,-8.75,-9.09,-9.17,-8.93,-8.54,-8.03,-7.72,-8.14,-9.13,-9.88,-10,-10,-9.40,-9.10,-9.01,-9.25,-9.80,-10,-11,-11,-12,-12,-13,-12,-12,-11,-10,-9.75,-8.34,-6.98,-5.38,-3.89,-2.63,-1.66,-0.66,1.57,5.30,9,12.34,13.84,16.23,15,15,16.25,15,15,13.75,13.75,13.75,13.75,13.75,15,15,16.25,18.75,17.50,15,15,16.25,16.25,15,13.75,12.50,12.50,12.50,12.50,12.50,12.50,13.75,11.25,11.25,12.50,15,16.25,17.50,16.25,16.25,16.25,16.25,15,12.50,11.25,11.25,11.39,11.21,10.71,9.64,8.27,6.25,3.89,1.51,-0.59,-2.18,-3.61,-4.85,-6,-7.11,-7.99,-8.63,-8,-7.38,-8.02,-8.41,-8.63,-8.54,-8.60,-8.34,-8.18,-8.16,-7.77,-7.84,-9.59,-11,-11,-9.97,-9.25,-9.25,-9.63,-10,-10,-10,-8.15,-6.74,-5.43,-4.28,-3.25,-2.55,-2.13,-2.09,-1.88,-1.25,-1.13,-1,-0.75,-0.55,-0.64,-0.25,0.12,0.55,0.95,1.34,1.55,2.02,1.82,1.84,1.86,1.96,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,9.98,9.98,9.98,9.98,9.98,9.97,9.89,9.77,9.51,9.20,8.92,8.78,8.75,8.75,8.75,8.73,8.73,8.72,8.72,8.72,8.72,8.71,8.68,8.60,8.52,8.37,8.17,7.96,7.77,7.61,7.51,7.46,7.36,7.27,7.12,6.92,6.72,6.55,6.45,6.39,6.38,6.36,6.29,6.25,6.23,6.23,6.22,6.13,6.02,5.78,5.51,5.29,5.13,5.02,5,4.98,4.96,4.95,4.87,4.79,4.64,4.40,4.18,3.95,3.84,3.75,3.73,3.64,3.52,3.25,2.93,2.67,2.52,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.59,2.80,3.27,3.53,3.70,3.75,3.75,3.75,3.75,3.75,3.73,3.72,3.64,3.43,2.80,1.57,0.36,-0.64,-1.63,-2.90,-4.22,-5.51,-6.54,-7.30,-7.24,-6.27,-6.38,-6.98,-7.75,-8.79,-9.36,-9.48,-9.13,-8.62,-8.43,-8.63,-9.03,-9.92,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-11,-11,-9.97,-9.24,-9.72,-8.25,-7,-5.41,-3.92,-2.62,-1.29,-0.75,1.55,5.28,10.97,14.80,16.09,16.23,15,16.25,17.50,16.25,15,13.75,15,13.75,15,15,16.25,16.25,17.50,16.25,16.25,15,15,15,15,13.75,12.50,12.50,12.50,12.50,12.50,12.50,12.50,13.75,12.50,11.25,12.50,13.75,16.25,16.25,16.25,17.50,18.75,16.25,15,13.75,11.25,11.25,12.46,13.11,13.12,12.80,11.70,10,6.87,3.89,1.04,-0.75,-2.26,-3.74,-5.11,-6.38,-7.62,-9.01,-8.43,-7.37,-7.50,-8.02,-8.26,-8.43,-8.54,-8.63,-8.37,-7.78,-7.23,-7.55,-7.88,-9.61,-11,-10,-9.93,-9.85,-11,-11,-11,-8.64,-7.75,-6.01,-4.40,-3.05,-1.75,-0.98,-0.54,-0.38,-0.40,-0.38,-0.26,-0.17,0,0.13,0.10,0.25,0.50,0.80,1.18,1.55,2.18,2.34,2.45,2.46,2.43,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,9.98,9.98,9.98,9.98,9.98,9.97,9.89,9.77,9.51,9.20,8.92,8.78,8.75,8.75,8.75,8.73,8.73,8.72,8.72,8.72,8.72,8.71,8.68,8.60,8.52,8.37,8.17,7.96,7.77,7.61,7.51,7.46,7.38,7.30,7.15,6.96,6.72,6.55,6.45,6.42,6.42,6.43,6.38,6.27,6.25,6.25,6.25,6.26,6.23,6.04,5.65,5.36,5.14,5.03,5,4.97,4.96,4.95,4.88,4.80,4.64,4.40,4.20,4,3.79,3.75,3.73,3.68,3.53,3.25,2.92,2.64,2.51,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.52,2.68,2.97,3.40,3.63,3.72,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.68,3.45,2.96,1.90,0.76,-0.37,-1.28,-2.53,-3.78,-5,-5.99,-6.68,-7.05,-6.50,-6.16,-7.02,-7.97,-9,-9.54,-9.65,-9.29,-8.87,-9.05,-9.03,-9.72,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-11,-11,-11,-11,-10,-10,-9.60,-8.75,-9.91,-9.92,-9.04,-7.29,-5.55,-3.98,-2.50,-1.23,0.93,1.59,7.80,12.75,15.97,17.43,18.60,17.51,17.50,17.50,16.25,15,15,13.75,13.75,15,15,15,16.25,16.25,16.25,16.25,16.25,15,15,16.25,13.75,12.50,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,12.50,12.50,12.50,13.75,16.25,16.25,17.50,17.50,18.75,16.25,13.75,13.75,12.50,12.50,13.75,13.75,13.75,13.59,12.50,10.46,6.39,2.96,0.10,-1.04,-2.66,-4.17,-5.65,-7.13,-8.76,-8.38,-7.73,-6.88,-7.30,-7.52,-8.17,-8.55,-8.61,-8.30,-7.79,-7.98,-8.15,-7.84,-8.88,-11,-10,-9.88,-9.86,-11,-12,-11,-9,-7.13,-5.35,-3.65,-2.01,-0.23,0.45,0.77,0.46,0.30,0.39,0.46,0.46,0.62,0.76,0.64,0.75,0.88,1.05,1.39,1.39,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,9.98,9.98,9.98,9.98,9.98,9.97,9.89,9.77,9.51,9.20,8.92,8.78,8.75,8.75,8.75,8.73,8.73,8.72,8.72,8.72,8.72,8.71,8.68,8.60,8.52,8.37,8.17,7.96,7.77,7.62,7.51,7.46,7.38,7.30,7.15,6.96,6.72,6.55,6.45,6.43,6.45,6.53,6.43,6.29,6.25,6.25,6.27,6.35,6.55,6.20,5.77,5.42,5.15,5.02,5,4.97,4.96,4.95,4.89,4.84,4.67,4.46,4.20,3.96,3.84,3.75,3.73,3.70,3.57,3.27,2.90,2.62,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.59,2.80,3.25,3.53,3.70,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.70,3.47,2.97,2.14,1.05,-0.10,-1,-2.17,-3.38,-4.51,-5.50,-6.34,-6.76,-5.97,-6.03,-7,-7.63,-8.65,-9.24,-9.30,-9.24,-9.22,-9.42,-9.30,-9.84,-10,-11,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-9.12,-8.25,-8.91,-9.77,-10,-10,-7.67,-5.86,-4.14,-2.51,-0.75,1.72,8.26,12.01,15.77,18.30,18.39,19.71,18.63,18.68,18.73,17.50,15,15,15,15,15,15,15,15,15,16.25,17.50,17.50,15,15,16.25,15,13.75,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,12.50,13.75,13.75,15,16.25,18.75,18.75,17.50,15,13.75,15,16.25,15,13.75,13.75,13.59,13.12,12.27,9.20,3.72,1.82,-0.13,-1.60,-3.22,-4.87,-6.50,-8.05,-8.77,-7.39,-7.05,-6.84,-7.25,-7.88,-8.24,-8.26,-8.09,-7.89,-8.11,-8.41,-8.65,-10,-11,-11,-9,-8.50,-10,-11,-12,-9.50,-7.38,-5.34,-3.36,-1.39,1.10,2.28,1.55,1.22,0.93,0.93,0.93,0.93,1.04,1.07,1.09,1.23,1.25,1.25,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,9.98,9.98,9.98,9.98,9.98,9.97,9.89,9.77,9.51,9.20,8.92,8.78,8.75,8.75,8.75,8.73,8.73,8.72,8.72,8.72,8.72,8.71,8.68,8.60,8.52,8.37,8.17,7.96,7.77,7.62,7.51,7.46,7.38,7.29,7.14,6.92,6.72,6.55,6.43,6.40,6.46,6.55,6.45,6.29,6.25,6.25,6.27,6.34,6.34,6.22,5.80,5.43,5.14,5.01,4.98,4.97,4.96,4.96,4.93,4.85,4.70,4.48,4.21,3.95,3.84,3.75,3.72,3.72,3.60,3.40,2.80,2.59,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.53,2.70,2.97,3.39,3.63,3.72,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.70,3.52,3.09,2.34,1.34,0.20,-0.75,-1.84,-2.97,-4.11,-5.13,-6,-6.60,-6.42,-6.39,-6.98,-7.50,-8.22,-8.86,-9.14,-9.10,-9,-9.23,-9.34,-9.77,-10,-11,-12,-13,-13,-13,-13,-12,-11,-10,-9.88,-9.89,-9.76,-9.53,-9.13,-8.16,-7.75,-8.43,-9.35,-10,-10,-7.86,-6.03,-4.35,-2.61,-0.67,1.86,9.37,11.88,14.39,16.39,17.95,19.62,19.68,17.53,16.23,14.98,13.75,13.75,13.75,13.75,15,15,15,15,15,16.25,17.50,17.50,15,15,15,15,13.75,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,12.50,12.50,13.75,15,16.25,17.50,17.50,17.50,17.50,16.25,17.50,17.50,16.25,15,13.75,12.50,13.05,12.60,10.62,7.34,4.04,1.51,-0.36,-2.13,-3.97,-5.75,-7.50,-8.17,-7.59,-7.53,-7.42,-7.35,-7.50,-7.64,-7.92,-8.15,-8.36,-8.30,-8.53,-9.40,-11,-12,-11,-9.50,-7.61,-8.90,-11,-12,-10,-7.78,-5.50,-3.30,-1.16,1.39,3.68,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,9.98,9.98,9.98,9.98,9.98,9.97,9.89,9.77,9.51,9.20,8.92,8.77,8.75,8.75,8.75,8.73,8.73,8.72,8.72,8.72,8.72,8.71,8.68,8.61,8.52,8.37,8.17,7.96,7.77,7.62,7.51,7.46,7.38,7.29,7.14,6.92,6.71,6.54,6.40,6.37,6.39,6.42,6.39,6.28,6.25,6.25,6.25,6.25,6.25,6.10,5.79,5.43,5.14,5,4.98,4.97,4.97,4.97,4.95,4.87,4.72,4.50,4.21,3.95,3.79,3.75,3.72,3.71,3.63,3.39,2.82,2.59,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.52,2.67,2.95,3.27,3.54,3.70,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.71,3.55,3.17,2.51,1.59,0.51,-0.50,-1.38,-2.53,-3.72,-4.87,-5.79,-6.50,-6.74,-6.84,-6.91,-7.43,-7.75,-8.30,-8.63,-8.60,-8.48,-8.55,-8.75,-9.75,-10,-11,-12,-13,-13,-13,-13,-12,-12,-10,-9.53,-8.53,-8.39,-8.30,-8.03,-7.25,-7,-7.15,-8.99,-9.77,-9.48,-7.78,-6.25,-4.64,-2.91,-1,1.84,4.68,8.23,11.84,15.62,18.15,19.51,18.32,15.93,13.70,12.61,12.38,12.48,12.50,13.75,15,16.25,16.25,17.50,18.75,17.50,17.50,17.50,15,13.75,15,15,15,12.50,12.50,12.50,11.25,11.25,12.50,12.50,12.50,12.50,12.50,12.50,13.75,13.75,15,15,16.25,17.50,17.50,17.50,17.50,16.25,16.25,18.75,16.25,15,13.75,12.62,13.07,12.02,9.78,6.71,3.71,1.40,-0.92,-3.05,-5.04,-6.78,-8.13,-8.88,-9.04,-9.73,-8.85,-8.13,-7.75,-8.12,-8.67,-8.88,-8.64,-8.18,-9.35,-10,-10,-10,-10,-7.92,-8.99,-12,-13,-10,-8.35,-5.88,-3.54,-1.28,1.22,2.30,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,9.98,9.98,9.98,9.98,9.98,9.97,9.89,9.78,9.51,9.20,8.92,8.77,8.75,8.75,8.75,8.73,8.73,8.73,8.72,8.72,8.72,8.71,8.68,8.61,8.53,8.38,8.21,7.97,7.77,7.62,7.51,7.46,7.37,7.29,7.14,6.92,6.71,6.52,6.37,6.29,6.29,6.29,6.28,6.26,6.25,6.25,6.25,6.22,6.14,6.02,5.76,5.46,5.20,5.04,4.98,4.97,4.97,4.97,4.96,4.89,4.77,4.51,4.21,3.93,3.78,3.75,3.72,3.70,3.64,3.42,2.84,2.67,2.51,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.54,2.80,3.26,3.52,3.68,3.72,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.72,3.60,3.28,2.70,1.86,0.80,-0.25,-1.13,-1.88,-3.41,-4.72,-5.79,-6.68,-7.84,-6.75,-6.66,-7.13,-7.38,-7.50,-7.91,-7.99,-7.88,-7.99,-7.92,-9,-9.90,-10,-11,-13,-13,-13,-13,-13,-11,-10,-9.62,-8.17,-7.99,-8.05,-7.79,-7.26,-6.88,-7.28,-7.63,-8.25,-8.55,-7.73,-6.62,-5.25,-3.63,-1.85,-0.05,1.82,2,9.25,10.75,16.87,18.14,17.02,12.13,9.79,9.80,9.84,11.13,11.25,12.50,15,16.25,17.50,20,18.75,17.50,17.50,17.50,15,15,15,15,13.75,12.50,12.50,12.50,12.50,12.50,12.50,13.75,13.75,13.75,13.75,15,13.75,15,15,15,15,15,15,15,13.75,16.25,16.25,16.25,16.25,16.25,16.25,15,13.75,13.75,11.71,9.62,6.51,3.43,0.46,-2.02,-4.29,-6.28,-8.05,-9.50,-11,-11,-10,-9.99,-8.25,-8.17,-8.75,-8.93,-8.75,-8.50,-8.62,-9.55,-10,-10,-10,-8.78,-9.49,-13,-14,-11,-8.89,-6.26,-3.79,-1.49,0.92,2.18,2.61,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,9.98,9.98,9.98,9.98,9.98,9.97,9.89,9.78,9.52,9.20,8.92,8.77,8.75,8.75,8.75,8.73,8.73,8.73,8.72,8.72,8.73,8.72,8.70,8.63,8.55,8.40,8.22,7.97,7.77,7.62,7.51,7.46,7.38,7.30,7.15,6.96,6.71,6.51,6.36,6.27,6.25,6.25,6.25,6.25,6.26,6.25,6.25,6.22,6.12,5.97,5.76,5.47,5.25,5.10,5,4.98,4.97,4.97,4.97,4.93,4.78,4.52,4.20,3.92,3.77,3.75,3.72,3.71,3.62,3.53,3.37,2.85,2.63,2.52,2.50,2.50,2.50,2.50,2.50,2.51,2.62,2.89,3.27,3.59,3.62,3.63,3.63,3.63,3.63,3.63,3.64,3.70,3.72,3.75,3.75,3.73,3.63,3.39,2.86,2.07,1.07,-0.04,-0.92,-1.75,-3.24,-4.63,-5.88,-6.99,-7.75,-7.13,-6.29,-6.60,-7.16,-7.50,-7.50,-7.43,-7.42,-7.59,-7.60,-8,-8.26,-9.55,-11,-12,-13,-13,-13,-13,-12,-10,-9.12,-8.41,-8.16,-8.24,-7.97,-7.60,-7.41,-7.10,-6.86,-7.50,-7.72,-8,-7.29,-6.11,-4.68,-3.16,-1.75,-0.66,-0.38,2.02,2,9.30,11.87,10.72,7.04,1.52,5.20,6.40,7.63,11.13,13.75,15,15,17.50,18.75,17.50,18.75,18.75,16.25,15,15,16.25,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,15,16.25,15,13.75,15,13.75,13.75,12.50,12.50,11.25,12.50,13.75,15,16.25,15,15,16.25,16.25,15,12.50,11.55,10.87,9.30,5.57,2.32,-1.13,-3.66,-5.93,-7.97,-9.88,-11,-11,-11,-10,-8.52,-7.87,-8.38,-8.77,-8.86,-8.59,-8.22,-9.40,-10,-11,-11,-10,-11,-13,-14,-12,-9.49,-6.65,-4.09,-1.74,0.71,3.40,3.59,3.75,2.50,2.50,1.25,1.25,1.25,1.25,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,9.98,9.98,9.98,9.98,9.98,9.97,9.93,9.78,9.52,9.20,8.90,8.77,8.75,8.75,8.75,8.75,8.73,8.73,8.73,8.73,8.73,8.72,8.71,8.64,8.59,8.46,8.26,7.96,7.75,7.59,7.50,7.47,7.45,7.34,7.18,6.97,6.71,6.52,6.37,6.27,6.25,6.26,6.28,6.29,6.34,6.29,6.27,6.25,6.14,5.98,5.77,5.52,5.29,5.13,5.02,5,4.98,4.97,4.96,4.88,4.78,4.52,4.21,3.93,3.78,3.75,3.73,3.72,3.63,3.59,3.32,2.93,2.76,2.60,2.50,2.50,2.50,2.50,2.50,2.51,2.64,2.89,3.17,3.34,3.30,3.30,3.30,3.30,3.30,3.30,3.42,3.54,3.68,3.72,3.75,3.73,3.68,3.46,3,2.27,1.25,0.12,-0.80,-1.64,-3.09,-4.52,-6,-7.22,-8.36,-7.88,-6.47,-6.53,-7.14,-7.50,-7.66,-7.63,-7.34,-7.11,-7.28,-7.55,-7.37,-8.63,-10,-11,-12,-12,-12,-12,-11,-10,-9.39,-8.13,-7.97,-8.03,-8.27,-8.01,-7.87,-7.53,-7.13,-7.17,-8.49,-9.12,-8.29,-7.22,-5.88,-4.62,-3.39,-2.43,-1.43,-0.36,1.26,1.98,1.88,1.84,-0.63,1.55,1.54,3.95,6.40,11.10,14.95,15,15,16.25,16.25,16.25,17.50,17.50,16.25,16.25,15,15,13.75,13.75,13.75,13.75,13.75,15,13.75,15,13.75,13.75,15,15,15,15,13.75,13.75,13.75,12.50,11.25,10,11.25,11.25,12.50,15,15,16.25,16.25,13.75,15,13.75,11.25,10.93,11.09,9.67,6.68,3.09,-0.49,-3.10,-5.61,-7.88,-9.92,-11,-11,-11,-10,-7.88,-7.43,-8.16,-8.59,-8.76,-8.63,-8.74,-9.35,-10,-11,-13,-12,-13,-15,-15,-13,-10,-6.90,-4.27,-1.99,0.30,2.14,4.84,5,3.75,2.50,2.50,1.25,1.25,1.25,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.98,9.98,9.97,9.93,9.79,9.52,9.20,8.90,8.77,8.75,8.75,8.75,8.75,8.73,8.73,8.73,8.73,8.73,8.73,8.72,8.68,8.60,8.52,8.26,7.96,7.71,7.59,7.50,7.47,7.45,7.35,7.18,7,6.73,6.54,6.38,6.34,6.35,6.37,6.39,6.40,6.42,6.40,6.38,6.29,6.21,6.05,5.84,5.61,5.39,5.18,5.09,5.01,5,4.97,4.96,4.88,4.73,4.53,4.23,4,3.85,3.76,3.75,3.72,3.68,3.59,3.42,3.25,2.85,2.63,2.51,2.50,2.50,2.50,2.50,2.51,2.62,2.80,3.12,3,2.96,2.90,2.90,2.90,2.90,2.92,3.01,3.27,3.52,3.68,3.72,3.73,3.70,3.54,3.12,2.38,1.38,0.21,-0.75,-1.63,-2.54,-4.47,-6.22,-7.74,-8.50,-8.68,-7.41,-6.63,-7.10,-7.50,-7.64,-7.54,-7.26,-6.73,-6.87,-7.18,-7.61,-8.11,-8.92,-10,-11,-11,-11,-11,-10,-10,-9.49,-8.50,-8.13,-8.59,-8.85,-8.86,-8.85,-8.88,-8.52,-7.88,-8.52,-9.30,-9.62,-8.39,-7.18,-5.92,-4.88,-4.13,-3.50,-2.79,-2.12,-1.42,-0.53,-0.67,-0.64,-0.74,0.92,1.52,5.20,10.14,14.87,17.48,16.25,16.25,16.25,16.25,17.50,17.50,18.75,17.50,15,15,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,15,13.75,13.75,13.75,15,15,13.75,13.75,13.75,12.50,11.25,10,10,10,11.25,12.50,13.75,15,15,13.75,13.75,13.75,12.50,11.25,10.77,10.29,7.02,2.12,-0.11,-2.75,-5.38,-7.80,-10,-11,-10,-11,-9.88,-7.77,-7.04,-7.90,-8.53,-8.73,-8.91,-9.60,-10,-11,-12,-13,-14,-14,-16,-15,-14,-10,-6.90,-4.36,-2.23,-0.26,1.39,3.59,5,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.98,9.98,9.97,9.93,9.79,9.52,9.20,8.90,8.77,8.75,8.75,8.75,8.75,8.75,8.73,8.73,8.73,8.73,8.73,8.72,8.70,8.62,8.52,8.27,7.96,7.70,7.54,7.50,7.47,7.45,7.36,7.22,7.02,6.80,6.51,6.50,6.52,6.51,6.54,6.55,6.60,6.60,6.59,6.52,6.39,6.26,6.11,5.93,5.72,5.48,5.29,5.14,5.03,5,4.98,4.96,4.88,4.79,4.59,4.36,4.10,3.93,3.85,3.77,3.75,3.70,3.61,3.48,3.25,2.93,2.64,2.52,2.50,2.50,2.50,2.50,2.50,2.59,2.67,2.76,2.77,2.68,2.64,2.59,2.60,2.60,2.61,2.70,2.95,3.27,3.53,3.68,3.72,3.71,3.57,3.30,2.50,1.50,0.30,-0.75,-1.63,-2.50,-4.15,-5.84,-7.30,-8.25,-8.63,-7.50,-6.78,-6.78,-7.18,-7.35,-7.25,-6.92,-6.38,-6,-6.64,-7.36,-8.05,-8.38,-8.91,-9.73,-10,-10,-10,-10,-10,-9.63,-9,-8.39,-8.99,-9.25,-9.51,-9.77,-9.92,-9.62,-8.86,-8.26,-9.36,-9.90,-10,-8.27,-7.10,-6.16,-5.74,-5.42,-5.04,-4.65,-4.02,-3.17,-2,-1.64,-1.14,-0.75,1.55,6.51,12.29,16.09,17.45,18.75,17.50,16.25,16.25,17.50,18.75,21.25,18.75,16.25,15,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,12.50,12.50,12.50,10,10,11.25,11.25,11.25,11.25,13.75,15,13.75,12.50,15,13.75,11.25,10.76,10.45,7.18,3.55,0.61,-2.50,-5.42,-8,-10,-11,-10,-10,-9.41,-7.42,-7.09,-7.43,-8.03,-8.88,-9.38,-9.53,-10,-11,-13,-13,-13,-14,-14,-14,-13,-9.63,-6.75,-4.42,-2.51,-0.88,0.45,1.25,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.98,9.98,9.97,9.95,9.80,9.54,9.22,8.93,8.78,8.75,8.75,8.75,8.75,8.75,8.73,8.73,8.73,8.73,8.73,8.73,8.71,8.70,8.54,8.28,7.97,7.70,7.54,7.50,7.48,7.46,7.39,7.30,7.14,6.77,6.75,6.84,6.85,6.86,6.87,6.89,6.89,6.87,6.82,6.68,6.52,6.36,6.20,6.03,5.80,5.61,5.39,5.18,5.09,5,4.98,4.96,4.89,4.84,4.68,4.52,4.30,4.10,3.96,3.86,3.76,3.72,3.63,3.52,3.26,2.95,2.67,2.52,2.50,2.50,2.50,2.50,2.50,2.51,2.54,2.59,2.59,2.54,2.52,2.51,2.50,2.50,2.50,2.53,2.68,2.95,3.28,3.53,3.68,3.70,3.59,3.26,2.62,1.64,0.45,-0.75,-1.75,-2.41,-3.80,-5.29,-6.73,-7.63,-8.25,-7.63,-6.28,-6.23,-6.62,-6.75,-6.64,-6.34,-6.16,-5.79,-6.37,-7,-7.62,-7.93,-8.28,-8.50,-8.73,-9.16,-9.80,-9.97,-10,-10,-9.84,-9.85,-9.85,-9.92,-9.91,-10,-10,-10,-9.48,-8.88,-8.63,-9.50,-10,-9.14,-7.85,-7.11,-6.98,-7.11,-7.14,-6.91,-6.37,-5.22,-3.87,-2.66,-1.79,-0.73,1.55,7.18,13.52,15.14,17.38,17.50,17.50,16.25,17.50,17.50,18.75,18.75,18.75,17.50,15,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,12.50,12.50,13.75,13.75,13.75,13.75,12.50,12.50,11.25,11.25,11.25,11.25,11.25,12.50,12.50,12.50,12.50,13.75,11.25,12.50,12.50,13.75,10,10,10,8.12,3.43,1.25,-2.25,-5.38,-8,-10,-11,-12,-11,-11,-8.79,-6.99,-6.93,-8,-8.88,-9.36,-9.39,-9.41,-11,-12,-12,-12,-11,-12,-12,-10,-8.64,-6.39,-4.40,-2.75,-1.29,-0.25,1.25,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.98,9.98,9.97,9.95,9.84,9.62,9.30,9.02,8.84,8.75,8.75,8.75,8.75,8.75,8.73,8.73,8.73,8.75,8.73,8.73,8.75,8.75,8.68,8.42,7.95,7.67,7.51,7.50,7.50,7.50,7.50,7.46,7.34,7.21,7.27,7.34,7.43,7.46,7.45,7.37,7.30,7.18,7.02,6.84,6.60,6.40,6.25,6.09,5.93,5.72,5.47,5.27,5.12,5.02,5,4.97,4.93,4.86,4.79,4.67,4.52,4.27,4.07,3.90,3.79,3.73,3.64,3.52,3.26,2.95,2.68,2.54,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.53,2.68,2.92,3.34,3.53,3.64,3.59,3.29,2.79,1.87,0.65,-0.51,-1.50,-2.27,-3.38,-4.61,-5.75,-6.74,-7.59,-7.25,-6.39,-5.92,-6.10,-6.23,-6.49,-6.54,-6.38,-5.97,-6.18,-7.15,-7.63,-7.67,-7.64,-7.98,-8.40,-8.65,-9.38,-9.76,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.89,-9.35,-8.48,-8.68,-9.39,-9.26,-8,-7.43,-7.63,-8.26,-9,-9,-7.91,-6.64,-5.01,-3.61,-2.65,-0.80,1.57,6.55,12.21,15.14,18.62,18.75,16.25,17.50,17.50,17.50,17.50,16.25,16.25,15,15,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,12.50,13.75,13.75,13.75,13.75,13.75,12.50,11.25,11.25,11.25,12.50,12.50,13.75,13.75,13.75,13.75,13.75,13.75,12.50,12.50,13.75,11.25,8.75,9.52,7.80,4.98,2.17,-1.52,-4.54,-7.30,-9.38,-11,-11,-11,-10,-9.42,-7.34,-6.92,-8.03,-8.88,-9.78,-9.93,-10,-11,-11,-11,-10,-9.11,-9.40,-10,-9.02,-7.88,-6.25,-4.60,-3.09,-1.78,-0.63,1.25,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.98,9.98,9.97,9.96,9.87,9.70,9.40,9.09,8.87,8.75,8.75,8.75,8.75,8.75,8.75,8.73,8.75,8.75,8.73,8.75,8.75,8.75,8.70,8.53,8.27,7.80,7.53,7.50,7.51,7.53,7.59,7.59,7.64,7.78,8.01,8.12,8.15,8.12,8.02,7.85,7.65,7.46,7.21,6.96,6.70,6.45,6.28,6.13,5.98,5.78,5.57,5.32,5.14,5.03,5,4.97,4.96,4.89,4.86,4.79,4.67,4.38,4.20,4.01,3.86,3.75,3.64,3.52,3.26,2.96,2.71,2.61,2.54,2.53,2.52,2.51,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.53,2.68,2.85,3.40,3.53,3.59,3.39,2.97,2.12,1.02,-0.25,-1.25,-2.02,-2.88,-3.88,-4.97,-5.89,-6.54,-6.80,-6.80,-6.13,-5.75,-6.15,-6.47,-6.50,-6.29,-5.91,-6,-6.88,-7.42,-7.50,-7.43,-7.66,-8.15,-8.76,-9.01,-9.97,-10,-11,-12,-12,-13,-13,-12,-12,-11,-10,-10,-9.40,-8.50,-7.40,-8.11,-8.02,-7.25,-7.01,-7.51,-8.76,-9.97,-10,-8.88,-7.38,-5.75,-4.13,-2.64,-0.98,1.59,6.55,12.76,18.55,21.10,20,17.50,17.50,16.25,16.25,16.25,15,15,15,15,15,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,15,15,13.75,13.75,11.25,12.50,12.50,13.75,13.75,13.75,13.75,15,13.75,13.75,13.75,12.50,12.50,12.50,11.25,10,10.14,8.59,5.57,2.64,-0.63,-3.38,-5.93,-8.25,-9.91,-10,-10,-9.86,-8.29,-6.92,-6.88,-8.09,-9.68,-10,-11,-11,-11,-11,-10,-9.25,-7.75,-7.77,-9.04,-8.25,-7.50,-6.14,-4.63,-3.15,-2,-0.75,1.25,7.50,6.25,6.25,6.25,5,5,5,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.98,9.98,9.97,9.97,9.93,9.78,9.51,9.14,8.88,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.72,8.61,8.28,7.93,7.62,7.59,7.65,7.80,7.97,8,7.98,8.60,8.87,8.93,8.89,8.73,8.48,8.26,7.96,7.64,7.34,7.02,6.73,6.51,6.34,6.21,6.05,5.88,5.63,5.40,5.20,5.11,5.01,4.98,4.96,4.93,4.87,4.82,4.67,4.48,4.26,4.05,3.89,3.77,3.68,3.48,3.26,2.98,2.79,2.70,2.68,2.67,2.64,2.61,2.53,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.52,2.67,2.78,3.47,3.60,3.43,3.12,2.39,1.25,0,-0.90,-1.78,-2.50,-3.41,-4.36,-5.23,-5.98,-6.62,-7.52,-6.98,-5.73,-5.89,-6.13,-6.14,-6.18,-6.13,-6.13,-6.25,-6.74,-6.85,-6.97,-7.38,-7.88,-8.51,-9.24,-9.75,-10,-11,-12,-13,-13,-13,-13,-12,-11,-11,-10,-9.23,-8.26,-7,-6.40,-6.38,-5.75,-5.84,-7.13,-8.28,-9.52,-9.91,-8.88,-7.34,-5.76,-4.25,-2.64,-1.18,1.60,8.42,14.02,21.04,22.35,20,17.50,17.50,16.25,15,15,15,15,15,15,15,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,15,15,15,15,13.75,12.50,12.50,13.75,13.75,15,13.75,13.75,13.75,13.75,13.75,12.50,12.50,10,11.25,11.25,11.25,10.62,9.21,5.93,2.79,-0.05,-1.88,-4.88,-7.35,-9.15,-10,-10,-8.29,-6.78,-5.63,-6.49,-8.14,-9.72,-10,-11,-11,-11,-10,-9.86,-9.88,-9.15,-8.88,-9.25,-8.68,-7.64,-6.17,-4.62,-3.09,-1.60,-0.76,1.25,8.75,10,7.50,7.50,6.25,6.25,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.98,9.98,9.97,9.97,9.96,9.82,9.53,9.17,8.89,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.63,8.42,7.97,7.80,7.76,7.92,8.28,8.84,9.07,9.25,9.57,9.77,9.68,9.48,9.14,8.79,8.46,8.13,7.79,7.46,7.12,6.80,6.55,6.38,6.25,6.10,5.93,5.73,5.47,5.29,5.14,5.02,4.98,4.96,4.95,4.89,4.82,4.68,4.52,4.34,4.11,3.93,3.79,3.68,3.52,3.27,3.05,2.92,2.90,2.95,2.95,2.86,2.77,2.64,2.54,2.51,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.53,2.76,3.54,3.59,3.57,3.22,2.59,1.52,0.30,-0.66,-1.63,-2.28,-3.12,-3.90,-4.73,-5.50,-6.38,-7.40,-7.34,-6.90,-5.89,-6,-6.22,-6.26,-6.17,-5.99,-6.35,-6.28,-5.93,-6.38,-6.64,-7.15,-7.78,-8.89,-9.86,-10,-11,-12,-13,-14,-14,-13,-13,-12,-11,-10,-9.09,-7.77,-6.75,-6.18,-6.10,-6.13,-7.40,-7.78,-7.79,-9.41,-8.87,-8.18,-6.84,-5.43,-4.13,-2.64,-1.37,-0.73,8.42,15.95,21.04,21.10,18.75,17.50,17.50,16.25,15,15,15,15,15,15,15,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,15,13.75,13.75,15,15,15,13.75,13.75,12.50,13.72,13.77,16.18,16.13,14.87,13.86,13.86,13.62,13.63,12.43,10.02,10,10,13.75,12.50,11.25,9.68,6.50,2.50,-0.38,-1.89,-4.13,-6.60,-8.61,-9.75,-9.88,-6.29,-5.28,-5.66,-5.90,-7.51,-9.59,-10,-10,-10,-10,-9.97,-10,-12,-12,-11,-11,-10,-8.11,-6.30,-4.55,-2.87,-1.22,-0.26,1.25,11.25,10,10,8.75,7.50,7.50,6.25,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.98,9.98,9.98,9.97,9.97,9.85,9.54,9.17,8.87,8.75,8.75,8.75,8.78,8.85,8.84,8.77,8.77,8.75,8.75,8.75,8.75,8.75,8.75,8.70,8.55,8.40,8.25,8,8,9.02,9.87,10.72,10.72,10.50,10.43,10.20,9.84,9.40,9.02,8.61,8.25,7.86,7.51,7.18,6.88,6.65,6.45,6.29,6.18,6.02,5.77,5.55,5.34,5.15,5.04,5,4.97,4.96,4.93,4.84,4.71,4.55,4.37,4.18,4.01,3.85,3.70,3.54,3.38,3.25,3.14,3.14,3.17,3.22,3.12,2.98,2.80,2.64,2.59,2.53,2.51,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.51,2.64,2.64,3.61,3.61,3.27,2.64,1.67,0.57,-0.50,-1.38,-2.13,-2.79,-3.50,-4.26,-5.05,-5.89,-6.73,-7.27,-7.80,-6.88,-6.11,-6.13,-6.16,-6.36,-6.38,-6.43,-6.40,-6.34,-6.68,-7.13,-7.43,-7.98,-9.16,-10,-10,-11,-12,-13,-13,-14,-13,-13,-12,-11,-9.90,-8.64,-7.37,-6.50,-7.25,-7.36,-8.93,-10,-9.48,-8.01,-7.64,-7.97,-7.25,-6.17,-4.92,-3.77,-2.64,-1.36,-0.74,7.80,17.21,19.80,19.97,18.75,17.50,16.25,16.25,15,15,15,15,15,15,15,13.75,13.75,13.75,13.75,13.75,13.75,13.75,15,15,13.75,13.75,13.75,15,13.75,13.75,13.71,13.68,13.75,14.85,15,15.14,16.09,14.84,13.89,13.59,12.64,12.34,11.37,10.10,12.43,12.46,13.75,12.50,10,7.50,1.39,-0.78,-0.99,-3.38,-5.92,-8.11,-9.50,-9.36,-6.88,-6.50,-8.40,-8.72,-8.05,-9.13,-10,-10,-10,-9.91,-10,-13,-14,-15,-14,-13,-10,-8.50,-6.43,-4.50,-2.62,-0.72,1.55,7.50,11.25,12.50,13.75,11.25,10,8.75,7.50,6.25,6.25,6.25,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.98,9.98,9.98,9.98,9.97,9.87,9.55,9.17,8.84,8.75,8.75,8.75,8.84,9.05,9.05,9.05,9.07,8.92,8.84,8.78,8.78,8.78,8.84,8.77,8.73,8.63,8.54,8.46,8.85,9.64,10.75,11.97,11.54,11.22,10.93,10.61,10.12,9.63,9.14,8.71,8.29,7.93,7.61,7.30,7.02,6.77,6.57,6.40,6.26,6.07,5.84,5.62,5.39,5.18,5.09,5,4.98,4.96,4.95,4.85,4.73,4.57,4.39,4.21,4.04,3.88,3.75,3.60,3.47,3.39,3.37,3.37,3.39,3.39,3.30,3.17,3.01,2.82,2.71,2.64,2.61,2.54,2.52,2.51,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.51,2.61,3.70,3.71,3.27,2.64,1.71,0.75,-0.25,-1.13,-1.88,-2.49,-3.13,-3.80,-4.55,-5.37,-6.18,-7.13,-7.90,-7.99,-6.84,-6,-6.26,-6.50,-6.50,-6.25,-6.50,-6.97,-7.37,-8.10,-8.50,-9.10,-9.85,-10,-10,-11,-12,-13,-13,-13,-13,-12,-11,-10,-9.18,-7.80,-7.13,-7.68,-8.63,-9.61,-11,-12,-11,-9.47,-7.88,-7.63,-6.78,-5.73,-4.49,-3,-2.65,-1,1.57,9.68,17.21,19.82,21.12,18.75,18.75,15,15,15,15,15,15,15,15,15,13.75,13.75,13.75,13.75,13.75,13.75,15,16.25,15,15,13.75,13.75,13.75,13.75,13.77,13.75,13.87,13.89,13.90,14.86,15.14,15.18,16.02,14.77,13.89,12.68,13.55,12.30,11.39,11.37,12.37,11.27,12.48,11.25,6.25,1.39,1.55,0.87,-2.62,-5.43,-7.87,-9.66,-11,-10,-12,-13,-14,-12,-9.23,-9.14,-9.88,-10,-10,-12,-14,-15,-15,-15,-13,-11,-8.68,-6.50,-4.38,-2.36,-0.25,2.64,7.50,12.50,15,13.75,13.75,11.25,11.25,8.75,7.50,7.50,6.25,6.25,6.25,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.98,9.98,9.98,9.98,9.98,9.89,9.55,9.17,8.79,8.75,8.75,8.75,8.78,9.03,10.93,10.13,9.85,9.14,9.17,9.15,9.17,9.18,9.18,9.05,8.92,8.84,8.77,8.89,9.25,10.26,11.26,11.97,12,11.61,11.28,10.88,10.32,9.78,9.22,8.75,8.34,8,7.70,7.45,7.20,6.98,6.75,6.55,6.38,6.14,5.92,5.65,5.43,5.21,5.10,5.01,4.98,4.97,4.95,4.86,4.73,4.62,4.46,4.26,4.10,3.93,3.79,3.70,3.59,3.54,3.52,3.53,3.54,3.54,3.47,3.38,3.25,3.11,2.97,2.89,2.79,2.68,2.64,2.60,2.53,2.51,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.53,2.50,3.75,3.59,2.80,1.87,0.93,-0.04,-0.88,-1.53,-2.13,-2.66,-3.34,-4.01,-4.78,-5.66,-6.68,-7.88,-8.34,-8.25,-7.03,-6.34,-6.38,-6.38,-6.54,-6.85,-7.49,-8.02,-8.75,-9.16,-9.78,-10,-10,-10,-11,-12,-12,-12,-12,-12,-11,-10,-9.22,-8.30,-8.29,-8.88,-8.75,-9.68,-11,-12,-12,-11,-10,-8.67,-7.41,-6.40,-5.34,-4.12,-2.64,-1.37,-0.73,1.55,13.43,18.52,19.84,18.84,20,17.50,15,16.25,15,15,15,15,15,15,15,15,15,13.75,15,15,15,15,15,15,15,13.75,15,14.98,14.93,13.87,13.89,13.90,14.78,15,15.26,15.27,15.27,15.27,15.14,14.70,14.02,13.59,11.45,11.43,12.64,13.59,11.37,10.03,11.23,8.75,6.39,3.89,1.54,-1.61,-4.43,-7.14,-9.73,-12,-16,-19,-20,-19,-15,-11,-8.91,-9.80,-10,-11,-12,-14,-15,-15,-14,-13,-11,-8.98,-6.66,-4.48,-2.26,0,2.96,7.50,12.50,15,17.50,16.25,16.25,12.50,10,8.75,8.75,7.50,7.50,6.25,6.25,5,5,5,6.25,6.25,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.98,9.98,9.98,9.98,9.96,9.87,9.53,9.15,8.84,8.75,8.75,8.75,8.76,9.03,10,12.15,10.88,9.84,9.55,9.55,9.68,9.84,9.82,9.54,9.22,9.17,9.20,9.25,9.84,10.50,11.97,12.18,12.21,11.90,11.57,11.11,10.50,9.87,9.30,8.79,8.42,8.11,7.84,7.62,7.39,7.18,6.97,6.72,6.51,6.25,5.98,5.73,5.46,5.26,5.11,5.01,4.98,4.97,4.95,4.85,4.78,4.65,4.52,4.36,4.20,4.04,3.89,3.77,3.71,3.63,3.62,3.62,3.62,3.62,3.59,3.53,3.43,3.32,3.25,3.15,3.07,2.97,2.86,2.76,2.64,2.60,2.53,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.68,2.64,1.97,1.09,0.28,-0.50,-1.18,-1.79,-2.28,-2.87,-3.48,-4.17,-5.02,-6,-7.10,-8.30,-8.35,-8.05,-6.92,-6.14,-6.52,-7.03,-7.65,-8.01,-8.12,-8.74,-9.17,-9.74,-10,-10,-10,-11,-11,-12,-12,-11,-10,-9.85,-8.88,-8.28,-8.98,-9.37,-10,-10,-10,-10,-11,-10,-9.36,-8.52,-7.61,-6.84,-5.97,-4.99,-3.87,-2.65,-1.35,1.51,9.68,17.21,19.79,18.59,16.27,18.75,17.50,13.75,16.25,16.25,15,15,15,15,15,15,17.50,16.25,15,15,17.50,17.50,16.25,16.25,16.25,15,15,13.75,15.09,16.10,14.84,13.92,14.77,15.26,15.95,16.25,16.54,16.53,16.12,15.30,15.30,15.93,14.68,13.88,12.76,14.77,13.73,12.64,10.12,12.38,12.48,11.07,7.18,1.55,-0.66,-3.13,-6.18,-9.36,-12,-17,-19,-20,-20,-16,-12,-9,-9.48,-10,-11,-11,-12,-13,-13,-12,-11,-11,-9.13,-6.86,-4.60,-2.35,0.01,3.27,7.50,11.25,15,20,20,17.50,13.75,11.25,10,10,8.75,8.75,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.98,9.98,9.98,10,9.98,9.86,9.53,9.17,8.87,8.76,8.75,8.76,8.79,9.04,9.68,10.12,10.25,10.03,9.88,9.95,10.10,10.77,10.77,10,9.77,9.65,9.77,10.01,10.50,11.34,12,12.35,12.38,12.13,11.77,11.28,10.63,9.96,9.35,8.87,8.52,8.25,8.01,7.82,7.63,7.39,7.14,6.87,6.61,6.36,6.07,5.77,5.47,5.27,5.11,5.01,4.98,4.97,4.93,4.86,4.80,4.70,4.57,4.46,4.30,4.15,4.02,3.89,3.78,3.73,3.71,3.70,3.70,3.68,3.64,3.61,3.57,3.52,3.43,3.39,3.37,3.27,3.17,2.98,2.92,2.80,2.70,2.60,2.59,2.53,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.02,1.39,0.62,-0.13,-0.77,-1.38,-1.93,-2.38,-2.88,-3.50,-4.27,-5.22,-6.29,-7.25,-7.88,-8.25,-7.79,-6.84,-6.79,-7.59,-8.24,-8.54,-8.54,-8.51,-8.87,-9.35,-10,-10,-11,-11,-10,-10,-11,-11,-10,-9.40,-8.23,-8.38,-8.63,-9.80,-11,-11,-10,-9.27,-8.59,-7.88,-7.13,-6.74,-6.25,-5.85,-5.25,-4.48,-3.59,-2.68,-1.29,-0.75,7.20,14.77,17.32,17.37,16.25,16.25,13.75,12.50,16.25,17.50,17.50,16.25,16.25,16.25,15,15,15,15,15,16.25,17.50,20,18.75,17.50,17.50,17.50,16.23,15.03,15.12,16.09,15.14,15,15.27,15.93,16.55,17.45,18.39,18.38,17.48,16.59,16.54,16.36,16.05,15.30,15.93,14.02,15.96,14.78,12.64,11.37,13.68,13.57,11.03,1.52,1.05,-2.04,-4.78,-7.87,-11,-14,-18,-20,-19,-13,-9.25,-7.73,-8.13,-9.55,-10,-11,-11,-11,-11,-10,-10,-11,-9.26,-7.02,-4.75,-2.49,-0.34,3.10,11.25,16.25,18.75,22.50,21.25,17.50,16.25,12.50,12.50,11.25,10,10,8.75,7.50,6.25,6.25,6.25,6.25,7.50,6.25,6.25,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,3.75,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.98,9.98,10,10.14,10.14,10.04,9.79,9,8.84,8.76,8.78,8.84,8.88,9,9.07,9.05,9.63,9.82,9.88,9.95,10.09,10.20,10.28,10.28,10.28,10.46,10.50,10.93,11.34,11.97,12.27,12.45,12.46,12.18,11.86,11.35,10.65,10,9.38,8.93,8.61,8.40,8.22,8.02,7.80,7.60,7.29,7.02,6.72,6.42,6.10,5.78,5.48,5.27,5.12,5.01,5,4.96,4.93,4.88,4.84,4.77,4.67,4.54,4.40,4.27,4.14,4.01,3.88,3.78,3.75,3.72,3.71,3.71,3.70,3.68,3.64,3.62,3.59,3.55,3.54,3.55,3.46,3.40,3.42,3.48,3.60,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.34,2.18,1.71,1.09,0.30,-0.28,-0.88,-1.40,-1.88,-2.26,-2.72,-3.38,-4.29,-5.35,-6.38,-7.30,-8.23,-9.15,-8.43,-7.17,-7.86,-8.47,-8.75,-8.75,-8.38,-8.97,-9.66,-10,-10,-10,-11,-10,-10,-9.93,-9.86,-9.29,-8.59,-7.59,-7.67,-8.64,-10,-12,-11,-9.35,-7.77,-6.64,-5.75,-4.97,-4.74,-4.55,-4.47,-4.16,-3.67,-2.97,-2.75,-1.88,-0.76,1.45,7.65,13.60,14.95,15,13.75,10,12.50,16.25,18.75,20,18.75,18.75,18.75,17.50,16.25,15,15,15,16.25,17.50,21.25,20,17.50,17.50,18.75,17.45,16.37,16.09,15.18,15.26,15.29,15.93,16.39,17.18,18.37,19.62,19.55,18.84,18.30,17.50,17.32,17.17,17.13,16.55,16.53,15.29,15.96,13.93,12.64,14.85,14.95,12.34,8.57,1.39,-0.92,-2.90,-5.79,-9.10,-12,-14,-15,-16,-11,-7.40,-6.50,-7.66,-9.09,-9.55,-10,-10,-10,-10,-10,-11,-11,-9.40,-7.13,-4.78,-2.63,-0.61,-0.04,12.50,18.75,23.75,25,25,20,17.50,15,13.75,12.50,11.25,10,10,7.50,7.50,7.50,6.25,6.25,6.25,7.50,6.25,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.98,9.98,10.01,10.18,10.72,10.10,9.63,9.20,8.88,8.86,8.93,9.02,9.03,8.96,8.95,9,9.09,9.57,9.54,9.55,9.62,9.71,9.93,10.29,10.75,11.09,11.97,11.40,11.97,12.05,12.32,12.36,12.36,12.05,11.71,11.21,10.59,9.98,9.42,9.03,8.75,8.54,8.38,8.17,7.96,7.68,7.37,7.07,6.77,6.46,6.12,5.79,5.50,5.27,5.12,5.01,5,4.97,4.96,4.93,4.87,4.84,4.73,4.65,4.52,4.38,4.23,4.09,3.93,3.85,3.76,3.73,3.72,3.72,3.72,3.71,3.71,3.71,3.68,3.64,3.63,3.63,3.63,3.63,3.64,3.68,3.71,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.47,2.30,2.02,1.55,0.93,0.30,-0.25,-0.77,-1.25,-1.65,-2.01,-2.50,-3.26,-4.26,-5.34,-6.47,-7.74,-8.98,-8.76,-8.63,-7.99,-8.38,-8.63,-8.61,-8.68,-8.90,-9.50,-9.67,-10,-10,-10,-10,-9.68,-9.22,-8.59,-8.25,-7.53,-6.92,-6.34,-8.40,-10,-10,-9.42,-8,-6.43,-5.04,-3.76,-2.85,-2.62,-2.67,-2.80,-2.88,-2.52,-2.54,-2.51,-2.28,-1.25,-0.88,1.38,7.38,11.25,12.50,10,8.75,11.25,17.50,20,21.25,22.50,22.50,22.50,22.50,20,18.75,17.50,16.25,15,17.50,18.75,18.75,18.75,17.50,17.46,17.37,17.34,16.42,16.51,16.25,16.25,16.55,16.60,17.50,18.30,18.87,19.54,20.78,18.75,18.29,17.92,18.30,18.30,18.37,17.77,18.42,16.52,15.14,14.79,16.09,16.12,13.71,10,1.25,1.25,0.46,-3.50,-6.16,-8.80,-10,-12,-12,-11,-9.61,-7.43,-8.76,-9.27,-9.84,-9.63,-9.99,-10,-9.98,-10,-11,-11,-9.47,-7.04,-4.79,-2.75,-0.90,2.15,10,16.25,20,25,25,25,20,17.50,15,15,12.50,11.25,10,8.75,8.75,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.98,9.98,10.01,10.15,10.17,10.03,9.59,9.20,8.89,8.88,9.05,9.18,9.17,9.02,8.89,8.89,9.01,9.05,9.15,9.15,9.17,9.21,9.55,10.11,10.75,12,11.40,11.45,11.55,11.97,12.03,12.12,12.04,11.65,11.28,10.87,10.36,9.89,9.47,9.09,8.84,8.62,8.46,8.27,8.01,7.68,7.38,7.09,6.80,6.46,6.13,5.79,5.50,5.27,5.12,5.02,5,4.98,4.97,4.96,4.95,4.87,4.84,4.72,4.63,4.48,4.32,4.15,4,3.87,3.78,3.75,3.73,3.73,3.73,3.73,3.73,3.75,3.75,3.73,3.72,3.71,3.72,3.72,3.72,3.73,3.73,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.47,2.34,2.13,1.53,0.93,0.42,-0.13,-0.55,-1,-1.29,-1.63,-2.25,-3.11,-4.16,-5.38,-6.72,-7.77,-8.53,-9.28,-8.68,-8.11,-8.25,-8.53,-9.03,-9.23,-9.11,-9.30,-9.27,-9.53,-9.68,-9.37,-9,-8.64,-8,-7.09,-6.75,-6.25,-6.26,-6.85,-8.25,-8.74,-7.88,-6.62,-5.09,-3.53,-1.91,-0.93,-0.38,-0.63,-1.04,-1.49,-1.80,-2.11,-2.30,-2.48,-2.38,-1.13,-0.93,-1,1.25,8.75,8.75,7.50,12.50,16.25,18.75,20,22.50,23.75,25,26.25,26.25,23.75,20,17.50,17.50,18.75,21.25,20,20,18.75,16.28,15.12,17.48,19.77,18.45,16.55,17.32,17.50,17.67,17.92,17.95,17.95,19.09,19.21,18.89,17.96,18.27,18.27,18.38,18.43,18.78,19.64,18.43,15.27,13.95,16.18,16.10,14.93,12.50,8.75,1.25,-1,-0.88,-3.51,-5.63,-7.67,-9.05,-9.98,-10,-10,-9.61,-9.38,-9.50,-9.52,-9.47,-9.29,-9.42,-9.28,-10,-11,-11,-9.49,-6.93,-4.72,-2.77,-1.02,1.02,1.34,12.50,17.50,22.50,25,25,25,20,16.25,13.75,13.75,12.50,11.25,10,8.75,8.75,7.50,7.50,6.25,6.25,7.50,6.25,6.25,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.98,9.98,10,10.01,10.01,9.87,9.57,9.20,8.90,8.88,9.05,9.21,9.20,9.02,8.87,8.84,8.85,8.87,8.84,8.78,8.84,8.93,9.21,9.68,10.30,10.77,10.93,10.89,10.93,11.07,11.26,11.97,11.26,10.93,10.65,10.36,10.10,9.79,9.40,9.10,8.85,8.63,8.45,8.25,7.97,7.63,7.34,7.02,6.73,6.42,6.11,5.78,5.48,5.27,5.12,5.03,5,5,5,5.01,5,4.97,4.88,4.80,4.68,4.52,4.35,4.15,4.01,3.89,3.84,3.77,3.76,3.75,3.75,3.75,3.76,3.78,3.79,3.78,3.76,3.73,3.73,3.73,3.73,3.73,3.73,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.46,2.34,1.98,1.55,1.07,0.55,0.09,-0.28,-0.63,-0.90,-1.25,-1.80,-2.84,-4.25,-5.54,-6.76,-7.93,-9.05,-9.38,-8.88,-8.01,-8.62,-9.09,-9.25,-9.50,-9.39,-8.88,-8.73,-8.34,-8.30,-8.23,-7.87,-7.29,-6.37,-6.34,-6.61,-6.63,-6.63,-7.13,-6.93,-7.01,-5.99,-4.43,-2.63,-0.59,0.96,1.25,0.72,0.02,-0.51,-1.01,-1.49,-1.89,-2.38,-2.53,-2.93,-2,-1,-1,1.25,1.25,5,11.25,13.75,15,16.25,18.75,21.25,23.75,23.75,26.25,25,22.50,18.75,17.50,20,22.50,23.75,22.50,20,17.60,16.39,17.68,19.71,19.68,18.43,18.37,18.59,18.89,19.05,19.07,19.10,19.10,19.09,18.76,18.38,17.97,17.97,18,18.38,18.88,19.52,19.53,18.32,17.17,17.18,17.29,16.37,15,11.25,7.50,1.25,-1,-1.87,-3.52,-5.17,-6.61,-7.89,-8.99,-9.43,-9.75,-10,-11,-10,-9.18,-8.92,-9.10,-8.85,-8.98,-11,-11,-9.09,-6.80,-4.77,-2.98,-1.28,-0.50,0,8.75,13.75,22.50,26.25,26.25,26.25,23.75,18.75,16.25,15,15,12.50,11.25,10,8.75,7.50,7.50,7.50,6.25,6.25,6.25,6.25,5,5,5,5,5,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.98,9.98,9.98,9.98,9.97,9.84,9.53,9.18,8.90,8.86,8.95,9.05,9.07,8.96,8.86,8.78,8.76,8.75,8.75,8.75,8.75,8.77,8.92,9.21,9.62,9.98,10.18,10.20,10.12,10.09,10.18,10.27,10.18,10.10,9.96,9.84,9.73,9.57,9.30,9.01,8.75,8.57,8.34,8.11,7.80,7.48,7.18,6.89,6.65,6.37,6.07,5.77,5.47,5.26,5.11,5.03,5.01,5.02,5.09,5.11,5.10,5.02,4.96,4.84,4.68,4.52,4.34,4.15,4.01,3.90,3.88,3.86,3.84,3.78,3.76,3.76,3.79,3.88,3.89,3.88,3.78,3.75,3.73,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.34,1.87,1.39,1.03,0.62,0.30,0,-0.25,-0.50,-1,-1.62,-3.13,-4.43,-5.75,-7.09,-8.80,-9.30,-9.67,-9.15,-8.47,-8.79,-9.26,-9.55,-9.41,-9.35,-9.23,-8.67,-7.99,-8,-7.92,-7.63,-7.17,-6.75,-6.90,-7.16,-7.12,-7.03,-7.28,-6.97,-6.01,-4.47,-2.37,-0.38,2.01,2.60,2.20,1.28,0.47,-0.18,-0.75,-1.35,-1.88,-2.49,-2.89,-3,-2,-1,-1,1.25,1.25,1.25,1.25,7.50,10,12.50,15,16.25,17.50,18.75,21.25,20,18.75,17.50,18.75,26.25,27.50,26.25,21.20,18.75,17.65,18.60,19.02,19.05,19.09,19.15,19.54,20,20.77,20.76,20.14,20,19.68,19.25,18.70,18.09,18.10,18.11,18.10,18.68,19.17,19.68,20.76,18.78,16.60,18.43,18.70,19.85,18.72,13.75,7.50,1.25,-1,-1.75,-3.05,-4.34,-5.64,-7,-8,-8.93,-10,-11,-13,-11,-10,-10,-9.52,-9.90,-10,-10,-8.48,-6.49,-4.64,-3,-1.50,-0.88,0.77,1.25,12.50,20,25,28.75,27.50,26.25,22.50,18.75,17.50,18.75,16.25,13.75,11.25,10,8.75,7.50,7.50,6.25,6.25,6.25,5,5,5,5,5,5,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.98,9.98,9.98,9.98,9.96,9.82,9.53,9.18,8.89,8.78,8.85,8.89,8.95,8.95,8.89,8.79,8.75,8.70,8.68,8.70,8.72,8.75,8.76,8.89,9.02,9.21,9.50,9.50,9.22,9.18,9.20,9.22,9.23,9.21,9.30,9.34,9.30,9.20,9,8.75,8.55,8.38,8.13,7.89,7.60,7.28,7.01,6.75,6.53,6.27,6.03,5.75,5.46,5.26,5.11,5.03,5.02,5.10,5.14,5.20,5.18,5.13,5.01,4.87,4.70,4.52,4.32,4.15,4.03,3.96,3.95,3.93,3.90,3.87,3.79,3.77,3.84,3.89,4.03,3.89,3.79,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.02,1.64,1.25,1.02,0.77,0.62,0.46,0.09,-0.40,-1,-2.11,-3.26,-4.60,-6,-7.24,-8.30,-9.50,-9.60,-8.98,-8.37,-8.98,-9.23,-9.41,-9.65,-9.53,-8.99,-8.50,-8.23,-8.27,-8.39,-8.04,-7.73,-7.16,-7.62,-8.02,-8.14,-8.13,-7.75,-6.67,-5.09,-2.98,-0.75,2.02,2.82,2.80,2.18,1.40,0.64,-0.10,-0.67,-1.27,-1.92,-2.88,-2.91,-3,-2,-1,-1,-1,-1,-1,-0.92,1.39,1.39,1.39,7.64,10.10,12.50,12.50,15,15,13.75,16.25,20,22.50,20,19.93,18.88,18.90,19.71,20.12,20.14,20.30,20.40,20.45,21.09,21.50,21.53,21.25,20.89,20.63,19.84,19.22,19.05,18.93,18.89,18.71,18.13,19.05,19.79,20.65,19.96,19.18,19.02,20.93,22.29,21.12,19.93,14.98,7.50,1.25,-1,-0.77,-1.59,-3.41,-4.63,-5.90,-7.39,-9,-10,-11,-12,-13,-12,-11,-11,-10,-8.87,-7.66,-6,-4.38,-2.88,-1.50,-0.76,0,1.25,7.50,16.25,25,28.75,28.75,25,25,20,20,22.50,20,17.50,13.75,11.25,10,8.75,7.50,6.25,6.25,6.25,5,5,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.98,9.98,9.98,9.97,9.96,9.80,9.52,9.17,8.89,8.76,8.77,8.86,8.95,9.05,9.02,8.87,8.68,8.57,8.54,8.59,8.62,8.71,8.70,8.59,8.46,8.47,8.59,8.59,8.47,8.40,8.47,8.60,8.75,8.76,8.85,8.85,8.77,8.64,8.46,8.30,8.21,8.09,7.85,7.61,7.30,7.02,6.80,6.59,6.39,6.22,5.98,5.73,5.46,5.25,5.10,5.03,5.04,5.14,5.26,5.32,5.30,5.21,5.09,4.89,4.71,4.52,4.35,4.18,4.07,4.05,4.05,4.05,4.03,3.92,3.86,3.79,3.79,3.88,3.89,3.88,3.78,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.09,1.09,1.02,0.77,0.46,-0.02,-0.55,-1.25,-1.84,-3.50,-4.87,-6.12,-7.30,-8.50,-9.63,-9.48,-8.64,-8.34,-8.75,-9.38,-9.62,-9.41,-8.88,-8.90,-9.12,-9.17,-9.36,-9.17,-9.13,-9.12,-9.03,-9.53,-9.84,-9.77,-9.05,-7.84,-6.14,-4.18,-2.03,-0.12,2.02,2.50,2.29,1.85,1.25,0.62,-0.13,-0.64,-1.38,-2,-2.88,-2.90,-2.88,-2.88,-2.13,-2,-2,-1.92,-1.18,-0.93,-0.75,-0.75,1.55,5.14,6.35,6.25,7.50,8.75,10,12.50,12.50,16.25,17.50,17.38,17.64,19.78,22.20,20.93,20.89,22.12,22.04,21.70,22.02,22.48,22.60,22.28,21.68,21.02,20.39,19.86,19.78,20.47,19.84,19.57,19.40,19.46,19.38,20.46,21.88,20.73,17.95,19.72,20.96,22.34,19.86,17.38,14.97,10,1.25,1.21,0.09,-0.38,-1,-3.65,-5.52,-7.17,-8.65,-10,-11,-12,-12,-11,-10,-10,-8.30,-6.93,-5.47,-4,-2.65,-1.39,-0.76,0,1.25,6.25,12.50,21.25,25,28.75,28.75,25,22.50,25,25,23.75,20,16.25,12.50,11.25,10,7.50,6.25,6.25,6.25,5,5,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.98,9.98,9.97,9.97,9.93,9.78,9.50,9.15,8.88,8.75,8.75,8.84,8.95,9.05,9.02,8.78,8.54,8.37,8.28,8.37,8.43,8.52,8.52,8.27,7.95,7.89,7.84,7.82,7.80,7.82,7.97,8.26,8.52,8.60,8.54,8.39,8.21,8.02,7.89,7.79,7.70,7.63,7.48,7.27,7.01,6.77,6.60,6.43,6.29,6.18,5.96,5.73,5.46,5.21,5.09,5.03,5.04,5.15,5.30,5.43,5.42,5.28,5.11,4.93,4.77,4.55,4.39,4.26,4.21,4.20,4.20,4.20,4.11,4.01,3.89,3.79,3.78,3.79,3.79,3.78,3.76,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.22,1.20,1.09,0.93,0.72,0.29,-0.18,-0.67,-1.17,-2.59,-3.87,-5.11,-6.28,-7.48,-8.27,-8.88,-8.75,-7.93,-8.28,-8.90,-9.13,-8.97,-9.16,-9.13,-9.59,-9.80,-10,-10,-10,-11,-11,-11,-11,-11,-10,-9.22,-7.43,-5.51,-3.54,-1.59,-0.09,1.25,1.39,1.38,1.09,0.73,0.42,-0.13,-0.75,-1.25,-1.88,-2.88,-2.88,-2.88,-2.88,-2.88,-3,-2.88,-2.75,-2.01,-1.64,-0.78,0.77,1.55,3.59,3.75,5,5,7.50,7.50,8.75,11.25,15,15.10,15.14,18.53,20.95,20.92,20.34,21.65,23.29,22.68,22.70,23.25,24.46,23.12,22.04,21.34,20.71,20.17,20.14,20.26,20.45,20.45,20.46,20,20.30,20.80,20.88,20.02,17.97,19.14,20,20.17,21.09,19.85,19.88,16.22,8.75,1.25,1.85,2.34,0.46,-1.86,-3.84,-5.43,-6.88,-8.16,-9.16,-9.76,-9.92,-9.68,-9.37,-8.38,-7.25,-6.04,-4.85,-3.62,-2.39,-1.27,-0.64,0.11,1.25,5,11.25,21.25,22.50,27.50,31.25,30,30,28.75,27.50,25,20,17.50,15,11.25,8.75,7.50,6.25,6.25,6.25,5,5,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.98,9.97,9.97,9.93,9.84,9.67,9.37,9.05,8.84,8.72,8.71,8.75,8.87,8.92,8.85,8.59,8.29,8.11,8.01,8.09,8.15,8.23,8.29,7.90,7.63,7.35,7.22,7.15,7.15,7.27,7.50,7.89,8.27,8.27,8.27,7.93,7.62,7.38,7.28,7.22,7.18,7.15,7.04,6.89,6.71,6.57,6.43,6.35,6.25,6.13,5.96,5.72,5.45,5.18,5.04,5.02,5.04,5.17,5.34,5.46,5.43,5.29,5.12,4.95,4.79,4.65,4.52,4.39,4.36,4.35,4.35,4.30,4.21,4.05,3.90,3.79,3.76,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,5,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.23,1.22,1.18,1.09,0.89,0.59,0.14,-0.26,-0.75,-1.85,-2.93,-4.15,-5.34,-6.38,-7.25,-7.87,-8.18,-8.15,-8.03,-8.13,-8.42,-8.87,-9.15,-9.42,-9.63,-10,-11,-11,-12,-13,-13,-13,-13,-12,-11,-10,-8.75,-6.85,-4.99,-3.10,-1.51,-0.05,0.30,0.57,0.60,0.46,0.30,0,-0.25,-0.76,-1.13,-1.17,-1.88,-2.13,-2.88,-2.88,-3,-2.92,-2.75,-2.50,-2,-1.25,-0.17,1.09,2.18,2.50,3.75,3.75,5,5,6.25,7.50,11.25,13.61,15.14,16.45,19.02,20.12,20.88,21.52,22.32,24.52,22.18,22.32,22.59,22.50,21.88,21.72,20.62,20.18,20.14,20.29,20.29,20.14,19.54,20.18,21.70,20.75,20.63,20.51,19.37,18.05,19.84,20.30,20.29,22.27,22.32,18.61,15,13.75,12.46,8.12,2.48,-0.77,-2.47,-3.88,-5.15,-6.28,-7.12,-7.63,-7.87,-7.77,-7.42,-6.88,-6.05,-5.14,-4.16,-3.13,-2.11,-1.15,-0.50,0.29,1.25,5,12.50,17.50,23.75,25,27.50,31.25,32.50,35,30,26.25,22.50,18.75,13.75,11.25,8.75,7.50,6.25,6.25,6.25,5,5,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.98,9.97,9.97,9.93,9.85,9.68,9.47,9.17,8.88,8.68,8.59,8.55,8.59,8.60,8.59,8.48,8.27,8.02,7.85,7.77,7.79,7.84,7.85,7.71,7.48,7.18,7.02,6.70,6.67,6.67,6.71,7.05,7.47,7.68,7.80,7.59,7.36,7.15,7.01,6.89,6.86,6.84,6.80,6.72,6.65,6.53,6.42,6.36,6.27,6.23,6.13,5.97,5.73,5.43,5.17,5.03,5.01,5.04,5.15,5.32,5.43,5.39,5.26,5.10,4.96,4.84,4.72,4.64,4.55,4.52,4.52,4.48,4.39,4.26,4.09,3.92,3.79,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,1.25,1.25,1.23,1.23,1.21,1.09,1.03,0.77,0.46,0.14,-0.38,-1,-2.10,-3.37,-4.50,-5.54,-6.49,-7.02,-7.63,-7.65,-8.53,-8.92,-7.99,-8.63,-9.18,-9.42,-9.64,-10,-11,-12,-13,-14,-14,-14,-14,-13,-12,-11,-9.75,-8,-6.22,-4.66,-3.37,-2.39,-1.74,-1.11,-1,-0.37,-0.15,-0.13,-0.14,-0.77,0.93,-0.90,-1.02,-1.25,-1.25,-2.88,-2.88,-3,-2.88,-2.75,-2.40,-1.75,-0.64,0.46,1.65,2.50,2.50,3.75,3.75,3.75,3.75,6.25,8.75,11.36,16.09,17.27,18.45,19.67,20.34,21.21,22.03,21.09,20.46,20.46,21.87,21.35,21.12,20.60,20.14,19.95,20.10,20.42,20.57,19.63,19.82,19.84,20.03,20.39,20.46,20.50,20.39,20.14,20.15,20.73,21.39,22.50,24.68,21.25,19.84,21.22,18.75,12.50,1.25,-0.50,-1.29,-2.43,-3.54,-4.52,-5.25,-5.75,-6,-6.01,-5.85,-5.48,-4.89,-4.25,-3.49,-2.63,-1.75,-1,-0.27,0.93,1.25,5,11.25,16.25,20,20,22.50,25,33.75,31.25,31.25,30,23.75,18.75,15,11.25,8.75,7.50,6.25,6.25,6.25,5,5,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.98,9.97,9.97,9.93,9.85,9.70,9.48,9.20,8.89,8.61,8.42,8.29,8.27,8.27,8.27,8.25,8.13,7.97,7.80,7.65,7.61,7.60,7.59,7.50,7.34,7.07,6.67,6.55,6.42,6.34,6.34,6.43,6.70,7.02,7.13,7.14,7.04,6.89,6.75,6.67,6.59,6.55,6.55,6.53,6.51,6.43,6.39,6.34,6.26,6.23,6.21,6.12,5.97,5.72,5.42,5.15,5.02,5.01,5.04,5.17,5.35,5.43,5.36,5.20,5.04,4.97,4.88,4.84,4.78,4.71,4.68,4.67,4.62,4.52,4.35,4.11,3.92,3.79,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.18,1.07,0.77,0.46,-0.13,-0.75,-1.60,-2.75,-3.84,-5.02,-6.10,-7.05,-7.91,-8.27,-9.11,-9.49,-9.02,-8.49,-8.88,-9.13,-9.61,-9.77,-10,-12,-13,-14,-14,-14,-14,-13,-12,-11,-10,-8.75,-7.25,-6.05,-5.14,-4.38,-3.85,-3.43,-2.84,-2.88,-2.75,-2.65,-2.63,-2.38,-2.25,-2,-1.75,-0.40,-1.25,-2.13,-2.68,-2.92,-2.90,-2.75,-2.39,-1.80,-1.02,-0.02,1.09,2.50,2.50,2.50,2.50,2.50,3.75,3.75,5,10.10,13.59,15.12,16.52,18.42,19.78,22.05,20.42,19.21,17.98,18.10,19.38,20.48,20.10,19.53,19.55,19.63,19.87,20.48,21.54,21.43,19.84,18.59,19.37,19.84,20.30,20.72,21.50,21.18,20.80,20.64,21.84,22.75,24.52,23.42,21.43,23.60,19.96,15,8.75,1.25,-1,-1,-2.16,-2.88,-3.49,-4,-4.34,-4.43,-4.39,-4.16,-3.79,-3.34,-2.77,-2.15,-1.43,-0.76,0,1.09,2.50,5,7.50,11.25,20,21.25,22.50,25,27.50,31.25,35,32.50,25,20,16.25,11.25,8.75,6.25,6.25,6.25,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,9.98,9.97,9.97,9.93,9.85,9.70,9.48,9.20,8.88,8.59,8.28,8.09,7.96,7.93,7.93,7.93,7.90,7.84,7.76,7.64,7.53,7.50,7.45,7.36,7.22,7.01,6.64,6.43,6.28,6.25,6.25,6.25,6.27,6.40,6.60,6.71,6.71,6.68,6.57,6.50,6.42,6.39,6.38,6.38,6.37,6.36,6.34,6.27,6.25,6.22,6.21,6.18,6.12,5.97,5.72,5.40,5.14,5.01,5.01,5.10,5.26,5.42,5.47,5.40,5.21,5.09,5,4.95,4.88,4.86,4.84,4.82,4.79,4.72,4.62,4.39,4.17,3.93,3.79,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,1.25,1.25,3.75,3.75,3.75,3.75,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.21,1.09,0.93,0.57,-0.01,-0.63,-1.38,-2.34,-3.38,-4.65,-5.92,-7.24,-8.60,-10,-10,-9.30,-8.79,-8.34,-8.35,-8.75,-9.13,-9.14,-10,-11,-12,-13,-14,-14,-14,-13,-12,-12,-10,-9.05,-8.18,-7.43,-6.78,-6.23,-5.88,-5.66,-5.59,-5.25,-5.11,-4.99,-4.84,-4.64,-4.22,-3.62,-2.86,-2.28,-2,-2.13,-2.63,-2.92,-2.92,-2.78,-2.50,-2,-1.25,-0.50,0.25,1.25,1.25,1.25,1.25,1.25,3.75,5,6.25,8.84,11.39,12.68,14.70,16.23,18.39,20.87,19.55,17.95,16.76,16.87,18.60,19.18,19.23,19.09,19.21,19.26,19.48,20.11,21.39,21.28,19.68,18.73,18.75,19.84,20,21.03,21.43,21.86,22.80,22.92,22.01,21.96,23.12,23.27,22.85,23.52,23.60,21.18,14.98,10,1.25,-1,-1,-1,-2,-2.43,-2.78,-3.01,-3.13,-2.99,-2.75,-2.48,-2.13,-1.67,-1.25,-0.50,0.43,1.25,2.50,3.75,5,10,17.50,21.25,22.50,27.50,27.50,31.25,37.50,32.50,28.75,21.25,15,10,7.50,6.25,6.25,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.21,1.09,1.09,1.09,1.09,1.09,1.22,1.22,1.21,1.20,1.20,1.09,1.09,1.09,1.09,1.20,1.23,1.23,1.23,1.23,1.25,1.25,9.97,9.97,9.93,9.85,9.70,9.48,9.20,8.88,8.59,8.27,7.98,7.79,7.67,7.64,7.64,7.64,7.64,7.63,7.60,7.51,7.47,7.39,7.34,7.18,6.98,6.71,6.42,6.26,6.25,6.25,6.25,6.25,6.25,6.34,6.39,6.43,6.45,6.42,6.39,6.35,6.29,6.27,6.27,6.26,6.26,6.25,6.25,6.22,6.18,6.13,6.13,6.13,6.10,5.96,5.67,5.35,5.12,5,5.01,5.12,5.29,5.50,5.60,5.51,5.32,5.14,5.03,4.98,4.96,4.93,4.89,4.88,4.86,4.82,4.68,4.46,4.18,3.93,3.78,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,1.25,1.25,2.50,3.75,3.75,3.75,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.21,1.09,0.93,0.55,-0.03,-0.63,-1.30,-2,-3,-4.41,-5.88,-7.42,-9.18,-11,-10,-9.38,-8.11,-8.68,-8.77,-8.77,-9.34,-9.87,-9.93,-10,-11,-13,-13,-14,-14,-13,-12,-11,-10,-9.37,-9.50,-9,-8.48,-7.90,-7.67,-7.77,-8.03,-7.42,-7.23,-7.13,-7,-6.47,-5.77,-4.99,-4.15,-3.50,-3.03,-2.42,-2.63,-2.76,-2.80,-2.67,-2.40,-1.92,-1.25,-0.65,-0.27,-1,-1,-1,-1,1.25,6.25,7.50,8.75,11.18,12.34,10.15,11.51,14.04,16.55,17.85,19.55,18.78,18.26,18.12,18.78,19.17,18.28,18.77,19.07,19.05,18.43,18.87,20,19.95,19,18.77,19.48,20.35,21.22,21.39,21.72,22.18,23.01,25.28,23,22.59,21.98,22.64,22.97,23.61,26.02,23.60,22.38,17.47,12.50,7.50,1.25,-1,-1,-1,-1,-2,-2,-1.78,-1.63,-1.54,-1.50,-1.28,-0.88,-0.13,1.09,2.50,2.50,3.75,5,7.50,13.75,17.50,21.25,21.25,27.50,32.50,37.50,35,30,20,15,11.25,8.75,6.25,6.25,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.23,0.93,0.62,0,-0.27,-0.50,-0.13,0.77,1.09,1.07,1.02,1.09,0.92,0.77,0.62,0.76,0.57,0.42,0.14,0.25,0.41,0.50,0.54,0.45,0.18,-0.03,-0.14,-0.17,-0.05,0.14,0.32,0.85,1.09,1.18,1.22,1.25,1.25,9.96,9.93,9.85,9.70,9.48,9.20,8.88,8.59,8.27,7.97,7.77,7.61,7.52,7.51,7.51,7.51,7.51,7.51,7.50,7.47,7.38,7.32,7.17,6.97,6.70,6.46,6.26,6.25,6.25,6.25,6.25,6.25,6.25,6.26,6.28,6.29,6.29,6.28,6.27,6.26,6.25,6.25,6.25,6.23,6.23,6.22,6.20,6.12,6.09,6.05,6.07,6.09,6.09,5.95,5.67,5.34,5.11,5,5.02,5.14,5.35,5.62,5.77,5.73,5.55,5.30,5.14,5.03,5,4.97,4.96,4.95,4.93,4.86,4.73,4.50,4.18,3.90,3.77,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,1.25,1.25,2.50,2.50,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.23,1.09,0.93,0.46,-0.03,-0.63,-1.30,-2,-2.67,-4.25,-5.79,-7.49,-9.35,-11,-9.89,-8.50,-8.88,-9.85,-10,-10,-11,-10,-10,-10,-12,-12,-13,-14,-14,-13,-12,-11,-11,-11,-11,-11,-10,-9.38,-9.03,-9.26,-9.86,-8.99,-8.86,-8.99,-9.09,-8.25,-7.34,-6.13,-5.17,-4.50,-3.88,-3.17,-2.54,-2.50,-2.40,-2.38,-2.04,-1.63,-0.89,-0.38,0.14,-1,-1,-1,1.25,7.50,11.25,11.25,10,11.20,12.35,10.15,8.95,12.53,15,18.38,18.30,19.52,19.40,18.89,19.37,20.46,19.17,18.14,17.80,17.02,16.82,17.17,17.59,17.77,17.70,18.11,19.34,22.28,22.29,22.51,21.34,22.50,23.22,23.32,23.23,22.84,22.64,21.98,22.90,23.45,23.75,24.79,23.60,22.43,21.25,16.25,11.25,7.50,1.25,1.25,-1,-1,-1,-0.91,-0.53,-0.50,-0.50,-0.38,-0.05,1.84,1.25,3.75,3.75,3.75,5,7.50,8.75,13.75,15,20,23.75,28.75,35,36.25,30,22.50,15,11.25,8.75,7.50,6.25,6.25,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.20,0.43,-0.50,-2.50,-3.53,-3.90,-3.89,-2.63,-0.76,0.36,0.53,0.60,0.27,0.11,-0.34,-1.02,-1.77,-2.16,-2.27,-2.10,-1.96,-1.89,-1.96,-1.22,-1.97,-2.82,-3.14,-3.27,-3.15,-2.84,-2.36,-1.73,-0.80,-0.02,0.73,1.04,1.25,1.25,9.93,9.85,9.70,9.48,9.20,8.88,8.59,8.27,7.97,7.76,7.61,7.51,7.50,7.50,7.48,7.48,7.48,7.47,7.46,7.38,7.32,7.17,6.97,6.70,6.46,6.34,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.22,6.21,6.18,6.11,6.04,5.95,5.92,5.93,5.98,6.03,5.93,5.65,5.34,5.12,5,5.01,5.14,5.45,5.84,6.10,6.10,5.84,5.57,5.30,5.14,5.03,5,4.98,4.97,4.96,4.93,4.80,4.52,4.18,3.89,3.76,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,1.25,1.25,1.25,1.23,1.03,0.62,0.09,-0.63,-1.30,-2,-2.64,-4.03,-5.63,-7.27,-9.03,-10,-9.84,-8.22,-8.30,-9.86,-11,-11,-11,-11,-11,-12,-12,-13,-15,-15,-16,-14,-12,-12,-13,-13,-13,-13,-12,-10,-9.79,-9.76,-10,-9.63,-9.76,-10,-10,-8.88,-7.65,-6.50,-5.60,-5.13,-4.10,-3.27,-2.25,-1.91,-1.65,-1.63,-1.38,-0.88,-0.17,0.77,1.38,1.25,1.25,1.25,1.25,11.25,11.25,10,10,10,10.10,10.14,10.18,11.51,13.89,15.90,16.60,17.51,18.26,18.87,19.47,20.46,18.77,17.38,15.95,14.84,14.97,15.09,15.95,16.09,16.09,16.54,18.45,20.76,24.71,23.52,23.57,23.61,23.55,22.38,23.10,23.26,23.21,22.90,22.85,23,22.96,22.77,23.90,26.10,27.45,25,20,15,12.50,11.25,10,8.75,7.50,1.25,1.25,1.25,1.25,1.25,1.25,7.50,7.50,7.50,7.50,5,5,5,8.75,11.25,13.75,17.50,21.25,23.75,28.75,35,32.50,22.50,15,11.25,8.75,7.50,6.25,6.25,6.25,5,5,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.21,0.97,-0.22,-0.85,-1.33,-1.87,-2.67,-3.39,-4.17,-4.66,-4.80,-4.70,-4.07,-3.09,-1.55,-1.50,-1.96,-2.03,-2.30,-4.02,-4.84,-5.23,-5.08,-4.89,-4.77,-4.88,-5.01,-5.33,-5.70,-6.21,-6.57,-6.62,-6.33,-5.76,-4.99,-4.07,-2.98,-1.64,-0.08,0.72,1.16,1.23,9.84,9.70,9.50,9.20,8.89,8.59,8.27,7.97,7.76,7.61,7.51,7.50,7.50,7.50,7.48,7.48,7.47,7.46,7.39,7.34,7.17,6.97,6.70,6.46,6.34,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.23,6.22,6.22,6.21,6.18,6.10,6.02,5.89,5.77,5.72,5.77,5.82,5.90,5.89,5.62,5.34,5.13,5.01,5,5.13,5.50,6.14,6.87,6.52,6.22,5.87,5.52,5.29,5.12,5.02,5,4.98,4.97,4.95,4.84,4.53,4.18,3.87,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,3.75,3.75,3.75,5,5,5,3.75,3.75,2.50,2.50,2.50,1.25,1.25,1.23,1.09,0.88,0.43,-0.27,-1.05,-1.90,-2.53,-3.77,-5.16,-6.65,-8.13,-9.43,-9.54,-9.54,-8.79,-9.13,-10,-10,-10,-10,-11,-12,-11,-13,-15,-16,-17,-15,-14,-14,-14,-14,-16,-15,-13,-11,-9.89,-9.13,-9.22,-9.29,-8.99,-9.38,-9.37,-8.24,-7.50,-6.22,-5.27,-4.89,-3.90,-2.39,-1.65,-1.13,-0.63,-0.38,-0.18,0,1.09,1.87,4.96,3.75,3.75,5,6.25,8.75,8.75,8.75,10,11.25,11.18,10.12,10.15,11.40,12.64,13.75,14.70,15.46,16.90,18.11,18.89,19.09,18.28,17.17,14.77,13.63,13.75,14.64,15.13,15.15,14.05,14.07,17.03,19.65,21.42,22.78,23.73,26.10,24.97,22.47,22.43,25.14,23.39,23.01,22.95,22.89,22.82,22.82,24.02,27.34,28.62,26.22,26.25,23.75,21.25,18.75,17.50,20,17.50,13.75,11.25,8.75,10,11.25,10,13.75,16.25,15,12.50,11.25,7.50,6.25,7.50,10,12.50,15,16.25,21.25,26.25,31.25,30,23.75,16.25,11.25,8.75,7.50,7.50,7.50,6.25,6.25,5,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,1.25,1.21,1.04,-0.89,-2.15,-2.98,-3.38,-3.79,-3.98,-4.52,-5.10,-5.60,-6.02,-6.39,-7.96,-5.60,-4.82,-4.59,-4.83,-5.20,-5.85,-6.87,-9.01,-8.18,-7.84,-7.61,-7.55,-7.79,-8.21,-8.64,-9.26,-9.73,-10,-10,-9.37,-8.10,-7.21,-6.15,-4.91,-3.41,-1.83,-0.21,1.08,1.22,9.68,9.50,9.20,8.89,8.59,8.27,7.97,7.76,7.61,7.51,7.50,7.50,7.50,7.50,7.48,7.48,7.47,7.43,7.34,7.18,6.97,6.71,6.50,6.35,6.26,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.23,6.22,6.22,6.21,6.18,6.10,6.02,5.87,5.71,5.55,5.47,5.52,5.62,5.71,5.71,5.51,5.30,5.12,5.01,5.01,5.20,5.43,7.01,6.96,6.89,6.57,6.21,5.82,5.48,5.26,5.09,5,4.98,4.97,4.96,4.86,4.54,4.18,3.87,3.76,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,6.25,5,5,3.75,3.75,2.50,2.50,2.50,1.25,1.25,1.50,1.25,0.77,0.60,-0.75,-1.67,-2.41,-3.29,-4.42,-5.67,-6.98,-8.26,-9,-9.37,-8.97,-9,-8.43,-8.49,-8.63,-8.66,-9.80,-10,-10,-12,-14,-16,-17,-17,-16,-14,-14,-15,-16,-16,-12,-10,-8.61,-7.73,-7.24,-7.13,-7.10,-7.15,-7.35,-6.75,-6,-5.04,-4.16,-3.38,-2.78,-1.77,-0.92,-0.04,0.93,1.71,2.18,2.48,1.97,5,3.75,3.75,3.75,5,7.50,7.50,8.75,8.75,10,11.25,11.21,11.12,11.09,11.10,11.51,12.18,12.64,13.59,14.80,16.87,17.64,19.23,19.18,17.95,16.71,14.95,13.84,14.86,15.18,15.09,14.72,14.10,15.39,18.01,19.88,21.39,23.10,24.82,26.13,23.75,22.48,23.22,23.23,22.84,22.78,22.96,22.98,22.93,24.67,25.20,23.89,25.14,24.88,23.75,24.86,22.36,21.11,19.88,21.13,17.45,14.97,13.75,15,16.25,16.25,16.25,18.75,20,20,18.75,12.50,7.50,7.50,8.75,11.25,12.50,17.50,20,26.25,28.75,31.25,26.25,22.50,15,11.25,8.75,8.75,8.75,7.50,6.25,5,5,5,5,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,1.25,-0.88,-1.59,-3.50,-3.80,-4.07,-4.45,-4.86,-5.10,-5.51,-6.01,-6.53,-7.04,-7.59,-7.70,-7.48,-7.07,-7.12,-7.67,-8.08,-8.54,-9.27,-10,-10,-9.98,-9.84,-9.91,-10,-10,-11,-12,-12,-11,-11,-10,-9.98,-9.09,-8.05,-6.85,-5.36,-3.60,-1.53,0.46,1.18,9.38,9.20,8.89,8.57,8.27,7.97,7.76,7.61,7.51,7.50,7.50,7.50,7.50,7.50,7.48,7.47,7.45,7.36,7.20,6.98,6.70,6.50,6.36,6.27,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.23,6.22,6.22,6.21,6.18,6.10,6.02,5.87,5.65,5.48,5.35,5.30,5.35,5.42,5.46,5.46,5.35,5.21,5.10,5.01,5.02,5.28,6.09,7.07,7.20,7.13,6.97,6.46,6.07,5.67,5.34,5.10,5,4.98,4.98,4.97,4.88,4.67,4.18,3.95,3.77,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,6.25,7.50,6.25,6.25,6.25,6.25,5,5,3.75,3.75,2.50,2.50,2.50,2.50,2.18,1.55,1.25,0.46,-0.50,-1.38,-1.91,-2.63,-3.53,-4.63,-5.77,-6.88,-7.86,-8.22,-8.03,-7.74,-7.35,-6.53,-6,-7.01,-7.34,-8.40,-10,-11,-13,-14,-15,-14,-13,-12,-12,-12,-12,-11,-10,-8.50,-7.10,-6,-5.38,-5.25,-5.12,-5.13,-5.05,-4.75,-4.25,-3.63,-2.89,-2.15,-1.88,-1.13,-0.25,1.39,3.07,4.37,4.98,5.46,6.21,5,5,5,5,6.25,7.50,7.50,7.50,8.75,8.75,11.25,11.25,11.20,11.10,10.14,11.03,10.26,10.29,11.55,12.67,13.10,15.76,19.26,18.05,20.28,18.87,16.25,15.63,15.61,15.62,15.90,15.18,15.12,15.40,17.05,18.59,20,21.55,23.55,24.84,23.72,23.30,23.14,22.92,22.32,22.62,22.85,23.27,23.76,24.21,24.98,25.27,23.95,23.90,23.89,21.43,21.52,19.05,19.96,19.65,18.39,16.55,15.28,17.45,18.89,21.11,22.45,22.50,21.25,22.50,21.25,16.25,12.50,8.75,10,11.25,12.50,15,21.25,23.75,28.75,28.75,32.50,26.25,21.25,17.50,12.50,10,10,8.75,6.25,5,5,5,5,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,1.25,-0.83,-2.27,-6.45,-4.79,-4.93,-5.26,-5.65,-5.96,-6.35,-6.82,-7.32,-7.80,-8.21,-8.46,-8.54,-8.64,-8.89,-9.30,-9.67,-9.95,-10,-10,-11,-11,-11,-11,-12,-12,-13,-13,-13,-13,-12,-11,-11,-10,-9.66,-8.66,-7.45,-5.91,-3.58,-0.09,0.77,9.04,8.87,8.59,8.27,7.97,7.76,7.61,7.51,7.50,7.50,7.50,7.50,7.50,7.48,7.48,7.45,7.37,7.21,6.98,6.70,6.46,6.35,6.27,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.23,6.22,6.22,6.21,6.18,6.11,6.02,5.87,5.65,5.47,5.30,5.21,5.21,5.26,5.25,5.20,5.25,5.18,5.13,5.03,5,5.01,5.20,6.22,7.18,7.30,7.17,7.05,6.52,6.21,5.78,5.40,5.09,5,4.98,4.98,4.97,4.93,4.79,4.67,4.05,3.78,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,5,5,5,5,6.25,6.25,7.50,8.75,8.75,6.25,6.25,6.25,5,5,5,3.75,2.50,2.50,2.50,2.50,2.34,2.18,1.64,0.88,-0.38,-0.66,-1.26,-1.88,-2.65,-3.55,-4.54,-5.51,-6.38,-6.86,-6.88,-6.88,-6.65,-6.29,-6.36,-6.13,-6.80,-7.89,-8.78,-10,-11,-12,-11,-11,-10,-10,-9.75,-9.49,-9.18,-8.63,-7.66,-6.52,-5.35,-4.39,-3.76,-3.59,-3.36,-3.34,-3.13,-3.03,-2.38,-2.25,-1.80,-1.29,-0.88,-0.75,1.55,1.53,6.04,8.59,7.46,7.50,6.25,6.25,5,5,6.25,7.50,7.50,7.50,7.50,7.50,8.75,8.75,10,10,11.18,9.98,9.84,8.93,9.01,10,10.46,11.71,13.12,14.68,15.90,16.36,16.39,16.25,17.35,16.03,15.93,15.87,15.71,15.55,15.87,16.55,17.53,18.57,19.79,21.12,22.20,22.92,23.62,23.72,22.93,22.34,22.21,23.21,23.26,24.36,24.82,25.76,26.05,27.15,25.92,24.64,24.52,22.01,20.47,19.23,19.26,19.47,17.97,19.21,20.40,21.55,23.53,26.04,23.88,22.52,20,20,18.75,16.25,12.50,12.50,11.25,12.50,15,17.50,21.25,26.25,28.75,32.50,32.50,30,23.75,17.50,15,12.50,10,7.50,6.25,5,5,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,1.25,1.05,-2.32,-4.20,-5.27,-5.57,-5.92,-6.33,-6.65,-7.04,-7.48,-7.95,-8.39,-8.78,-9.10,-9.36,-9.57,-10,-10,-10,-10,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-14,-14,-13,-12,-12,-11,-11,-10,-9.53,-8.59,-7.45,-3.40,-2.03,8.73,8.55,8.27,7.96,7.75,7.60,7.51,7.48,7.47,7.47,7.47,7.47,7.47,7.47,7.45,7.37,7.21,7,6.70,6.45,6.34,6.26,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.23,6.22,6.22,6.21,6.18,6.11,6.03,5.87,5.65,5.46,5.29,5.15,5.14,5.15,5.18,5.14,5.11,5.09,5.09,5.03,5,5,5,5.14,6.23,7.32,7.35,7.20,6.55,6.37,6.20,5.90,5.30,5.03,5,5,4.98,4.98,4.97,4.93,4.73,3.95,3.89,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,5,5,5,5,5,6.25,7.50,8.75,10,10,7.50,5,5,5,5,3.75,2.50,2.50,2.50,2.50,2.50,2.50,2.64,2.34,1.55,0.87,0.46,-0.54,-1.28,-1.88,-2.49,-3.30,-4.23,-4.92,-5.42,-5.67,-5.86,-5.98,-6.26,-6.75,-6.51,-6.89,-7.50,-8.34,-9.13,-9.48,-9.38,-9.10,-8.55,-8,-7.49,-7,-6.63,-6.30,-5.89,-5.28,-4.50,-3.63,-3.01,-2.49,-2.13,-1.84,-1.67,-1.79,-1.75,-1.63,-1.38,-0.75,-0.18,1.05,1.39,7.27,8.57,6.34,6.25,7.50,8.75,7.50,6.25,5,5,6.25,6.25,7.50,7.50,7.50,7.50,7.50,8.75,8.75,8.75,8.75,8.84,8.87,8.89,8.89,9.05,9.17,10.13,10.59,11.88,12.98,13.43,14.48,15.10,15.46,15.79,15.93,16.03,15.89,15.77,15.88,16.22,16.71,17.37,17.77,19.02,20.64,21.71,22.48,22.90,23.12,23.28,23.59,23.90,24.25,24.50,25.18,25.80,27,28.22,26.34,25.29,24.04,22.70,21.43,20.62,19.48,20.42,21.82,22.21,24.37,24.48,25.77,27.14,25.95,23.87,23.61,20,18.75,17.50,16.25,13.75,12.50,12.50,13.75,15,18.75,23.75,28.75,31.25,28.75,31.25,30,22.50,18.75,16.25,12.50,10,6.25,5,5,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,1.25,1.01,-2.22,-4.17,-5.34,-6.01,-6.47,-6.85,-7.22,-7.60,-8.03,-8.45,-8.86,-9.24,-9.58,-9.91,-10,-10,-11,-10,-11,-11,-11,-11,-12,-12,-13,-14,-15,-15,-15,-15,-14,-13,-13,-13,-12,-12,-11,-11,-11,-11,-15,-16,8.48,8.27,7.96,7.75,7.60,7.50,7.47,7.39,7.36,7.35,7.34,7.35,7.36,7.37,7.36,7.22,7,6.70,6.45,6.29,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.22,6.22,6.21,6.18,6.12,6.03,5.88,5.65,5.46,5.28,5.14,5.09,5.09,5.11,5.13,5.11,5.03,5,5,5,4.98,4.98,5,5.09,6.12,7.37,7.37,7.34,6.09,6.03,6.03,6.03,5.18,5.01,5,5,4.98,4.98,4.98,4.97,4.84,4.84,3.88,3.85,3.75,3.75,3.75,3.75,3.75,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,7.50,8.75,10,11.25,8.75,1.25,1.25,1.87,2.02,1.25,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.59,2.78,1.64,1.09,0.14,-0.63,-1.25,-1.75,-2.25,-2.98,-3.63,-4.13,-4.50,-4.75,-5.03,-5.39,-5.88,-5.91,-6.34,-6.78,-7.25,-8.17,-7.60,-7,-6.36,-5.68,-5.13,-4.76,-4.42,-4.12,-3.84,-3.50,-3.11,-2.63,-2.12,-1.88,-1.41,-0.78,-0.17,-0.18,-0.13,-0.25,-0.25,-0.29,0.72,1.87,1.25,7.50,10,7.50,6.25,6.25,7.50,7.50,6.25,6.25,5,5,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,8.68,8.60,8.76,8.87,9.05,9.20,9.25,10.20,10.76,11.88,12.84,13.54,14.21,14.88,15.97,15.95,15.93,15.77,15.63,15.78,16.12,16.54,17.37,18.45,19.67,20.77,21.39,22.52,23.29,24.03,25.13,24.80,24.98,25.26,25.51,25.73,26.53,26.80,26.42,25.46,24.38,23.27,22.05,22.05,21.80,20.87,22.96,25.43,25.46,25.25,25.50,25.48,25.40,25.93,23.47,21.39,20.02,21.25,18.75,18.75,15,13.75,12.50,12.50,16.25,21.25,23.75,25,27.50,27.50,30,25,22.50,22.50,18.75,12.50,7.50,6.25,6.25,5,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,1.25,1.21,-0.95,-2.98,-4.84,-5.85,-6.51,-6.99,-7.38,-7.73,-8.09,-8.46,-8.86,-9.22,-9.58,-9.90,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-13,-14,-15,-16,-15,-15,-14,-14,-13,-13,-13,-12,-12,-12,-13,-14,-15,-16,8.37,8.07,7.71,7.59,7.50,7.46,7.38,7.23,7.14,7.03,7.02,7.03,7.14,7.21,7.20,7,6.70,6.45,6.29,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.22,6.22,6.20,6.12,6.04,5.88,5.67,5.46,5.28,5.14,5.03,5.01,5.01,5.03,5.04,5.03,5.01,5,4.98,4.98,4.96,4.97,5,5,5,5,5,5,5.01,5.04,6.13,5.12,5.14,5,5,5,5,5,5,4.98,4.97,4.88,4.93,3.76,3.75,3.75,3.75,3.75,5,5,5,5,5,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,10,11.25,7.28,2.18,0.26,0.25,0.71,1.25,2.50,3.75,5,5,5,5,5,4.93,4,3.42,1.64,1.03,0.09,-0.63,-1.18,-1.75,-2.25,-2.54,-2.97,-3.38,-3.66,-3.91,-4.13,-4.40,-4.63,-5,-5.35,-5.59,-6,-5.40,-4.72,-3.92,-2.73,-2.25,-2.04,-2,-2,-1.53,-1.26,-1.01,-0.77,-0.79,-0.50,0.46,1.97,3.59,4.18,4.34,3.89,1.34,2.78,2.63,4.52,7.50,8.75,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,8.70,8.62,8.90,9.05,9.14,9.18,9.36,9.48,10.73,11.65,12.45,12.52,14.05,14.93,15.93,15.93,15.30,15.14,15.29,15.65,16.26,17.04,18.01,19.14,20.14,21.21,22.34,23.73,24.37,24.93,25.35,25.63,25.90,26.04,26.05,25.89,26.64,26.60,25.39,24.80,24.47,24.10,24.01,23.54,23.60,24.21,24.88,25.29,25.29,25.30,25.40,25.46,24.84,22.80,21.50,22.52,22.50,22.50,21.25,18.75,16.25,13.75,11.25,13.75,16.25,18.75,21.25,22.50,25,25,26.25,25,25,21.25,15,11.25,10,7.50,6.25,5,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,1.25,-0.40,-1.77,-4.67,-5.68,-6.54,-7.11,-7.53,-7.88,-8.20,-8.51,-8.84,-9.18,-9.51,-9.82,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-13,-14,-15,-16,-15,-15,-14,-13,-13,-13,-13,-12,-12,-13,-13,-14,-14,-13,8.28,7.95,7.54,7.50,7.46,7.39,7.23,7.02,6.77,6.68,6.65,6.67,6.77,6.88,6.87,6.68,6.45,6.29,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.22,6.20,6.13,6.04,5.89,5.67,5.46,5.28,5.13,5.03,5,5,5,5,5,5,5,4.98,4.98,4.96,4.95,4.82,5,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5.02,5,5,5,5,5,5,5,5,4.98,4.98,5,3.75,3.75,3.75,3.75,5,5,5,5,5,5,6.25,6.25,7.50,7.50,7.50,8.75,8.75,8.75,8.75,7.50,6.25,6.25,6.25,7.50,1.39,0.92,-0.26,-0.38,1.25,1.25,3.75,5,6.25,7.50,7.50,6.25,5,6.25,5.11,4.77,3.43,1.87,0.93,0.10,-0.63,-1.18,-1.75,-2,-2.25,-2.43,-2.65,-2.76,-2.88,-2.63,-3.22,-3.40,-3.52,-3.54,-3.13,-2.88,-2.63,-2.13,-1.77,-1.38,-1,-0.68,-0.63,-0.27,-0.02,0.29,1.25,2.32,3.12,3.57,7.34,9.32,10.46,11.05,10.46,8.89,7.30,7.01,7.45,8.75,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,8.71,8.75,9.79,9.68,9.62,9.25,9.37,10.11,10.97,11.85,12.65,13.43,14.14,14.52,14.54,14.40,14.37,14.55,15.12,15.93,16.70,17.62,18.59,19.80,20.78,22.13,23.70,24.21,24.98,25.63,26.18,26.54,26.43,26.43,25.76,24.71,24.72,24.79,25.18,25.14,26.38,25.20,25.12,25.11,24.86,25.14,25.11,25.02,25.01,25.46,25.46,25.65,24.79,24.05,24,26.09,24.98,21.25,20,17.50,15,11.25,12.50,13.75,16.25,17.50,18.75,23.75,25,28.75,30,26.25,21.25,17.50,15,13.75,12.50,10,8.75,6.25,5,3.75,3.75,2.50,2.50,2.35,1.90,0.72,-1.08,-3.48,-5.27,-6.63,-7.24,-7.71,-8.05,-8.35,-8.62,-8.89,-9.16,-9.47,-9.74,-9.98,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-13,-14,-15,-14,-14,-13,-13,-12,-12,-12,-12,-12,-12,-13,-13,-12,-8.96,8.43,7.93,7.51,7.47,7.43,7.27,7.02,6.70,6.50,6.38,6.36,6.37,6.45,6.55,6.55,6.42,6.28,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.23,6.21,6.13,6.05,5.90,5.67,5.46,5.28,5.13,5.03,5,5,5,5,5,5,5,5,4.98,4.97,4.93,4.79,4.52,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,6.25,7.50,7.50,8.75,8.75,10,11.25,11.25,11.25,10,7.50,5,1.25,1.25,-1.16,-3.16,-0.38,0.90,1.25,3.75,6.25,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,4.93,3.84,2.78,1.85,0.93,0.12,-0.54,-1,-1.38,-1.63,-1.88,-2,-2.13,-2,-1.88,-1.76,-1.88,-1.68,-1.52,-1.38,-1.13,-0.88,-0.75,-0.63,-0.27,0.30,1.23,1.85,2.18,2.64,3.12,2.93,7.50,8.72,11.36,14.21,16.07,17.34,19.93,20,16.25,13.75,10,8.75,8.75,7.50,7.50,6.25,6.25,7.50,6.25,6.25,6.25,6.25,5,6.25,6.25,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,8.72,8.85,9.78,9.68,9.53,9.30,10.11,10.93,11.87,12.67,13.27,13.52,13.53,13.40,13.29,13.37,13.68,14.32,15.14,16.09,17.13,18.15,18.95,20.46,21.70,22.68,23.60,24.50,26.25,26.36,26.35,26.13,25.90,25.43,24.82,23.70,23.70,24.80,25.28,25.47,25.61,26.04,25.17,24.95,24.79,24.88,24.51,24.48,24.67,25.32,26.75,26.96,25.43,25.90,25.97,24.86,21.25,18.75,17.50,15,13.75,12.50,11.25,12.50,16.25,16.25,20,25,28.75,28.75,30,26.25,22.50,20,20,17.50,13.75,12.50,10,7.50,5,3.75,3.75,2.64,1.97,1.35,-0.07,-2.40,-4.62,-6.22,-7.26,-7.88,-8.25,-8.53,-8.76,-8.99,-9.22,-9.46,-9.71,-9.93,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-13,-14,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-12,-11,-11,-7.51,8.72,7.78,7.50,7.46,7.28,7.02,6.68,6.45,6.29,6.26,6.25,6.26,6.27,6.29,6.29,6.27,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.22,6.18,6.09,5.92,5.71,5.47,5.28,5.13,5.03,5,5,5,5,5,5,5,5,5,4.98,4.97,4.89,4.64,4.20,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,7.50,7.50,7.50,8.75,8.75,8.75,10,10,10,11.25,11.25,8.75,1.39,1.97,0.46,-1.25,-14,-0.13,1.25,1.25,5,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,5,5,3.75,3.52,2.76,1.82,0.93,0.30,-0.16,-0.50,-0.75,-1,-1.16,-1.30,-1.16,-1,-0.79,-0.67,-0.50,-0.27,-0.13,0.26,0.46,0.62,0.62,0.87,1.71,3.27,5,4.68,5.93,8.09,11.21,12.50,12.50,13.75,15,16.25,17.50,18.75,18.75,16.25,12.50,10,10,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.53,8.73,8.89,9.05,9.54,10.14,11.03,12.12,13.12,13.55,13.38,12.80,12.48,12.30,12.35,12.68,13.32,14.22,15.32,16.55,18,19.10,20.30,21.23,22.17,22.80,23.72,24.67,26.20,25.60,25.63,25.50,25.18,24.68,24.39,24.51,24.82,25.14,25.39,25.77,25.30,25,24.63,24.36,24.05,23.77,23.62,23.75,24.36,25.28,25.48,26.20,26.25,27.18,23.54,19.96,16.25,15,13.75,12.50,11.25,11.25,13.75,13.75,13.75,13.75,18.75,26.25,27.50,28.75,30,23.75,22.50,20,21.25,18.75,17.50,13.75,10,7.50,5,3.75,2.46,1.16,-0.12,-2.46,-4.35,-5.83,-7.05,-7.88,-8.41,-8.73,-8.96,-9.14,-9.32,-9.50,-9.71,-9.95,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-10,-10,-9.80,-9.86,-9.90,-10,-10,-10,-10,-10,-10,-10,-9.10,-7.77,7.50,7.53,7.48,7.32,7.02,6.67,6.40,6.28,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.21,6.12,5.96,5.75,5.48,5.28,5.13,5.03,5,5,5,5,5,5,5,5,5,5,4.98,4.97,4.89,4.54,4.14,3.75,3.75,3.75,3.75,5,5,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,8.75,8.75,10,10,10,10,10,10,7.50,6.25,1.39,0.14,-4.63,-10,-0.55,0.71,1.25,5,8.75,8.75,8.75,7.50,7.50,7.50,7.50,7.50,6.25,6.25,5,5,5,4.96,3.75,2.77,1.96,1.39,1.07,0.62,0.30,-0.02,-0.26,-0.25,-0.13,0,0.45,0.93,1.38,1.67,2,2.27,2.18,2.17,1.68,1.51,1.87,4.96,6.25,6.25,8.75,13.75,15,15,15,15,17.50,18.75,20,21.25,20,16.25,13.75,11.25,10,10,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,8.62,8.59,9.01,9.55,10.03,10.96,12.27,13.95,15.14,13.25,12.34,11.80,11.53,11.55,11.87,12.50,13.39,14.52,15.92,17.63,20.77,20.30,20.89,21.28,21.86,22.59,23.45,24.18,24.65,24.87,25.78,24.80,24.52,24.62,24.79,25.09,25.26,25.29,25.15,25,24.63,24.21,23.75,23.28,22.93,22.65,22.64,23.11,23.59,24.40,25.47,28.22,24.72,22.20,17.63,15,11.25,11.25,11.25,10,11.25,12.50,12.50,12.50,11.25,13.75,21.25,25,27.50,25,26.25,21.25,23.75,20,20,18.75,18.75,12.50,8.75,6.25,3.75,1.83,-0.14,-2.68,-4.58,-6.11,-6.88,-7.76,-8.43,-8.88,-9.15,-9.33,-9.47,-9.59,-9.74,-9.91,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.74,-9.41,-9.20,-9.10,-9.08,-9,-8.79,-8.51,-8.30,-7.89,-7.63,-7.17,-7,-7.26,-7.79,-8.25,-8.52,-8.72,-9,-9.09,-8.77,-7.97,-6.77,-4.33,7.50,7.50,7.47,7.23,6.65,6.39,6.26,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.20,6.09,5.87,5.60,5.32,5.14,5.03,5,5,5,5,5,5,5,5,5,5,5,4.98,4.97,4.89,4.65,4.07,3.75,3.75,3.75,5,5,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,8.75,8.75,10,8.75,8.75,10,10,8.75,7.50,6.04,1.68,0.72,-1.63,-9.14,-0.98,-0.13,1.25,6.25,8.75,10,10,8.75,7.50,7.50,7.50,7.50,7.50,6.25,6.25,5,5,6.25,6.25,5,3.75,2.50,2.50,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,3.75,3.75,3.75,5,5,3.75,2.50,2.50,1.25,1.25,3.75,6.25,10,11.25,12.50,13.75,12.50,12.50,13.75,17.50,18.75,20,21.25,20,17.50,15,12.50,11.25,10,8.75,8.75,10,10,10,8.75,8.75,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.53,8.61,8.59,9.01,9.68,10.61,11.89,14.03,13.90,12.90,12,11.34,11.05,11.04,11.27,11.87,12.64,13.73,15.09,16.90,18.86,20.75,20.50,20.46,20.78,21.42,22.30,23,23.55,24,24.17,24.21,24.15,24.30,24.62,25.46,25.39,25.10,24.93,24.68,24.30,23.75,23.12,22.50,22.02,21.71,21.65,21.51,22.62,22.43,24.67,25.50,23,21.38,19.79,15.02,12.50,8.75,8.75,8.75,8.75,10,12.50,12.50,10,11.25,16.25,23.75,26.25,27.50,26.25,26.25,23.75,22.50,21.25,20,16.25,13.75,10,6.25,3.75,1.14,-2.05,-4.35,-6.12,-7.16,-7.83,-8.45,-8.97,-9.32,-9.54,-9.68,-9.76,-9.83,-9.95,-10,-10,-10,-11,-11,-11,-11,-10,-10,-9.87,-9.20,-8.58,-8.13,-7.88,-7.78,-7.59,-7.09,-6.25,-5.38,-4.72,-4.15,-3.62,-3.72,-4.15,-4.98,-5.64,-6.14,-6.71,-7.27,-7.47,-7,-5.96,-4.39,-2.49,7.50,7.50,7.50,6.25,6.38,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.20,6.05,5.78,5.48,5.21,5.04,5,5,5,5,5,5,5,5,5,5,5,5,4.98,4.98,4.95,4.82,4.73,5,5,5,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,8.75,8.75,10,8.75,8.75,8.75,10,10,7.50,5.60,2.97,0.27,-2.66,-9.27,-1.50,-0.51,1.09,1.25,8.75,8.75,10,10,8.75,8.75,7.50,7.50,7.50,7.50,6.25,6.25,5,5,6.25,6.25,6.25,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,6.25,6.25,6.25,3.75,3.75,2.50,2.50,2.50,3.75,5,7.50,10,10,11.25,11.25,11.25,11.25,12.50,13.75,15,16.25,17.50,16.25,15,13.75,12.50,11.25,10,10,10,11.25,11.25,11.25,10,10,8.75,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.48,7.59,7.65,8.43,8.92,9.85,11.09,12.12,12.53,12.29,11.71,11.13,10.80,10.77,11.02,11.39,12.02,12.92,14.18,15.60,17.85,20.62,19.93,19.80,19.35,20.62,21.53,22.20,22.75,22.98,23.23,23.39,23.61,23.86,24.23,24.64,24.87,24.87,24.77,24.54,24.18,23.53,22.63,21.71,21.03,20.72,20.96,21.89,22.77,23.72,24.03,23.70,22.50,20.46,20.96,17.36,12.50,8.75,7.50,7.50,7.50,8.75,10,11.25,10,8.75,12.50,20,25,27.50,27.50,26.25,25,21.25,21.25,17.50,15,15,10,6.25,3.58,0.12,-3.05,-6.54,-7.32,-8.15,-8.63,-9.11,-9.49,-9.76,-9.95,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-12,-11,-10,-9.71,-8.60,-7.59,-6.82,-6.35,-6.14,-6.36,-5.09,-3.95,-2.50,-1.88,-1.37,-0.53,0.77,-0.86,-2,-2.55,-3.34,-4.43,-5.85,-6.32,-5.78,-4.21,-2.70,-1.24,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.20,6.04,5.77,5.46,5.17,5.02,5,5,5,5,5,5,5,5,5,5,5,5,4.98,4.98,4.98,4.97,5.12,5,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,8.75,8.75,8.75,8.75,8.75,8.75,8.75,10,8.75,6.25,3.89,0.79,-2.04,-9.17,-1.50,-0.74,1.26,1.25,7.50,8.75,11.25,10,10,10,8.75,8.75,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,6.25,6.25,5,5,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,3.75,3.75,3.75,6.25,6.25,6.25,6.25,6.25,7.50,8.75,10,10,10,10,10,10,10,11.25,13.75,13.75,13.75,13.75,13.75,12.50,11.25,10,10,10,10,10,11.25,11.25,11.25,10,8.75,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.47,7.35,7.37,7.84,8.87,10,11.05,11.71,11.85,11.54,11.18,10.90,10.82,10.93,11.18,11.57,12.29,13.11,14.96,16.87,18.38,19.23,19.39,19.38,20.34,21.18,21.80,22.22,22.48,22.21,22.92,23.23,23.53,23.63,24.37,24.71,24.80,24.79,24.68,24.40,23.61,22.35,20.90,19.80,19.52,20.14,21.76,24.57,24.47,24.37,23.40,22.03,20.61,19.07,17.34,13.75,10,7.50,6.25,7.50,8.75,8.75,8.75,8.75,7.50,8.75,13.75,23.75,28.75,27.50,28.75,26.25,25,20,17.50,16.25,15,11.25,7.47,2.30,-0.65,-3.91,-6.38,-8.01,-8.82,-9.42,-9.71,-10,-10,-10,-10,-10,-10,-10,-10,-11,-12,-12,-13,-13,-13,-12,-11,-9.64,-7.98,-6.40,-5.14,-4.38,-4.02,-3.60,-2.84,-1.47,-0.49,0.73,1.03,1.07,1.09,1.07,1.09,0.75,0.15,-1.83,-4.20,-7.70,-4.35,-2.82,-1.49,-0.38,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.20,6.05,5.77,5.45,5.15,5.02,5,5,5,5,5,5,5,5,5,5,5,5,4.98,5,5.01,5.14,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,6.25,6.25,6.25,7.50,7.50,7.50,8.75,7.50,7.50,7.50,7.50,7.50,8.75,8.75,8.75,8.75,7.29,4.50,1.73,-0.05,-14,-1.68,-0.38,2.05,1.39,7.50,10,11.25,11.25,11.25,11.25,10,10,8.75,8.75,7.50,7.50,7.50,6.25,6.25,6.25,7.35,7.61,8.45,8.45,8.50,7.35,6.25,6.25,6.25,6.25,7.50,7.50,6.25,2.50,1.25,2.50,3.75,2.50,3.75,5,7.50,8.75,10,8.75,7.50,7.50,8.75,8.75,10,10,10,10,10,10,10,10,11.25,11.25,11.25,12.50,12.50,12.50,12.50,11.25,10,10,10,10,10,11.25,12.50,12.50,10,8.75,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.27,6.39,6.52,7.82,8.89,10.09,11.59,11.50,11.53,11.36,11.25,11.12,11.09,11.10,11.36,11.82,12.84,14.26,15.96,17.52,18.72,19.40,20,20.59,21.20,21.71,22.05,22.29,22.50,22.75,23.09,23.43,23.92,24.51,24.97,25.14,25.11,25,24.77,24.84,22.07,20.01,18.43,17.34,18.87,20.82,24.51,27.17,24.25,23.88,22.38,20.72,20,18.52,15,11.25,8.75,6.25,7.50,7.50,7.50,8.75,8.75,6.25,6.25,10,17.50,25,28.75,30,30,25,21.25,18.75,16.25,16.25,13.75,8.65,2.37,-1.39,-4.40,-6.63,-8.20,-9.23,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-11,-12,-13,-14,-14,-14,-14,-13,-11,-9.75,-7.39,-4.83,-2.96,-1.77,-1.52,-1.14,-0.13,0.46,1.05,1.22,1.23,1.23,1.23,1.23,1.20,1.16,0.72,-0.89,-2.58,-3.23,-2.85,-1.53,-0.51,0.28,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.20,6.05,5.77,5.45,5.15,5.02,5,5,5,5,5,5,5,5,5,5,5,5,5,5.01,5.14,5.13,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,8.71,8.43,8.27,7.77,6.71,4.84,2.61,-0.15,-3.73,-7.01,-0.50,2.48,5.10,8.63,11.25,11.25,13.75,13.75,13.75,12.50,11.25,10,10,8.75,8.75,8.75,7.50,7.48,7.25,7.13,7.38,7.95,9.05,9.20,8.23,7.13,7.35,6.25,6.25,6.25,6.25,5,1.25,1.25,1.25,1.25,2.50,3.75,7.50,8.75,8.75,8.75,10,8.75,8.75,8.75,8.75,10,11.25,11.25,11.25,10,10,10,10,10,10,10,11.25,11.25,12.50,12.50,13.75,12.50,11.25,10,8.75,8.75,8.75,10,11.25,12.50,12.50,10,8.75,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.42,6.55,7.92,9.05,10.14,11.53,11.39,11.53,11.64,11.55,11.37,11.20,11.25,11.67,12.50,13.77,15.40,17.03,18.59,19.71,20.50,21.03,21.45,21.86,22.15,22.37,22.61,22.84,23.14,23.60,24.21,25,25.60,25.82,25.71,25.43,24.88,23.75,21.90,19.50,16.28,16.20,17.18,18.88,21.20,22.96,23.85,23.59,22.97,22.03,21.09,20.92,17.46,12.50,8.75,7.50,6.25,6.25,7.50,7.50,8.75,6.25,6.25,7.50,12.50,20,26.25,31.25,31.25,28.75,23.75,20,18.75,16.25,13.75,8.61,2.30,-1.83,-4.88,-6.87,-8.43,-9.52,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-13,-14,-15,-15,-15,-15,-14,-12,-10,-7.04,-3.86,-1.22,0.43,0.89,1.25,1.25,1.25,1.55,1.55,1.39,1.25,1.25,1.23,1.23,1.23,1.16,0,-0.85,-1.29,-1.16,-0.66,-0.04,0.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.20,6.09,5.77,5.45,5.15,5.01,5,5,5,5,5,5,5,5,5,5,5,5,5.01,5.14,5.20,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,6.25,6.25,6.25,7.50,7.50,7.50,7.50,6.25,6.25,7.50,8.75,8.75,8.70,8.12,7.34,6.25,4.93,2.89,0.26,-1.53,-7.39,-1.24,0.98,4.84,8.59,12.50,13.75,13.75,13.75,16.25,15,13.75,12.50,11.25,10,10,10,8.75,8.75,7.75,7.62,7.45,7.48,7.72,7.90,7.71,7.12,6.30,5.30,3.75,2.50,1.25,1.25,1.25,1.25,1.25,2.50,5,6.25,8.75,10,11.25,10,8.75,8.75,8.75,10,10,11.25,12.50,12.50,12.50,12.50,10,10,10,10,10,10,10,10,11.25,11.25,12.50,12.50,11.25,11.25,11.25,8.75,8.75,8.75,8.75,11.25,11.25,12.50,11.25,10,8.75,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.40,6.57,7.97,9.07,10.12,10.93,11.43,12.38,12.28,11.55,11.27,11.25,11.53,12.18,13.37,14.93,16.71,18.53,20.46,21.03,21.55,21.88,22.17,22.35,22.52,22.76,22.97,23.32,23.86,24.54,25.48,27.01,26.71,26.45,25.88,24.98,23.68,21.86,19.52,16.52,16.03,14.93,16.02,18.27,21.26,23.13,24.01,23.87,23.28,22.37,21.03,19.93,15,11.25,7.50,6.25,6.25,6.25,6.25,7.50,7.50,6.25,6.25,10,17.50,23.75,30,33.75,31.25,26.25,23.75,20,17.50,12.50,7.34,2.07,-2.10,-5.16,-7.15,-8.71,-9.80,-10,-10,-11,-11,-11,-11,-11,-11,-12,-13,-14,-15,-16,-16,-16,-15,-14,-13,-10,-6.65,-3.25,0.63,2.27,3.75,3.75,2.50,2.50,2.46,2.13,1.71,1.39,1.25,1.23,1.23,1.23,1.23,0.74,0.25,-0.05,-0.07,0.12,0.40,0.70,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.21,6.09,5.77,5.45,5.14,5.01,5,5,5,5,5,5,5,5,5,5,5,5,5,5.27,6.22,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,6.25,6.25,6.25,6.25,5,5,5,5,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,8.75,10.59,8.59,7.34,5.93,4.37,3.09,0.98,-0.93,-7.40,-3.25,-0.35,2.75,6.25,12.50,16.25,15,15,16.25,15,13.75,13.75,13.75,11.25,11.25,11.25,11.25,10,8.75,8.37,7.78,7.60,7.47,7.38,7.18,6.78,6.09,5.40,4.17,2.50,1.25,1.25,1.25,2.50,2.50,6.25,6.25,7.50,8.75,10,10,10,10,8.75,8.75,8.75,10,11.25,12.50,13.75,16.25,15,12.50,11.25,10,10,10,10,10,10,10,10,11.25,11.25,12.50,11.25,10,10,8.75,7.50,7.50,8.75,8.75,10,11.25,11.25,10,10,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.26,6.50,6.68,8.11,9.14,10.12,11.39,11.54,11.68,11.54,11.34,11.25,11.39,11.90,12.90,14.52,16.39,18.43,20.15,21.71,22.14,22.48,22.63,22.65,22.76,22.89,23.12,23.47,24.04,24.82,25.80,26.88,28.07,27.04,26.25,25.15,23.77,22.05,20.14,18.21,16.42,15.09,14.86,17.13,20.60,23.85,25.14,25.14,24.37,24.25,22.02,19.85,16.25,11.25,8.75,7.50,6.25,5,6.25,6.25,7.50,7.50,6.25,10,17.50,23.75,27.50,30,32.50,27.50,23.75,20,15,11.25,6.13,1.65,-2.29,-5.40,-7.46,-9.02,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-14,-15,-16,-16,-17,-16,-16,-15,-12,-9.53,-6.14,-2.70,0.50,2.34,2.50,3.75,3.75,3.75,3.75,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.23,1.09,0.90,0.77,0.76,0.77,0.77,0.93,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.22,6.12,5.78,5.43,5.12,5,5,5,5,5,5,5,5,5,5,5.02,5.02,5,5.14,5.02,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,6.25,6.25,6.25,6.25,5,5,5,5,5,5,6.25,6.25,6.25,6.25,6.25,7.50,8.75,10,9.50,7.89,6.09,4.37,2.96,1.55,-0.36,-3.04,-8.65,-0.93,1.29,1.25,10,17.50,18.75,17.50,16.25,15,13.75,13.75,12.50,11.25,11.25,10,10,10,10,8.75,8.45,8.02,7.92,7.68,7.65,7.45,6.40,6.18,4.37,5.43,5,3.75,6.25,3.75,8.75,8.75,8.75,8.75,10,10,10,10,10,10,8.75,8.75,8.75,10,12.50,15,16.25,16.25,15,12.50,10,10,10,10,10,10,10,10,10,10,11.25,11.25,10,10,8.75,8.75,7.50,7.50,7.50,7.50,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,8.75,8.75,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.35,6.57,7.32,8.12,9.21,10.14,10.82,11.25,11.25,11.22,11.21,11.40,11.57,12.84,14.18,16.27,18.39,20.30,21.85,22.89,23.27,23.27,23.12,22.96,23.05,23.26,23.60,24.18,24.95,25.87,26.84,27.92,27.28,26.42,25.34,23.89,22.29,20.71,19.48,17,15.18,15,18.38,21.96,25.77,28.57,26.12,25.30,24.36,23.25,21.07,18.70,15,11.25,7.50,5,5,5,6.25,7.50,7.50,6.25,8.75,17.50,25,25,27.50,31.25,28.75,25,20,15,8.75,5.14,1.26,-2.58,-5.70,-7.85,-9.41,-10,-11,-11,-11,-11,-11,-11,-12,-12,-13,-15,-16,-17,-17,-17,-17,-16,-14,-12,-8.96,-5.47,-2.16,0.88,2.43,2.50,3.75,3.75,5,3.75,3.75,2.50,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.14,5.79,5.43,5.09,5,5,5,5,5,5,5,5,5,5.02,5.15,5.29,5.20,5.01,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,6.25,6.25,6.25,6.25,7.50,6.25,5,5,5,5,5,5,6.25,5,5,5,5,6.25,6.25,6.25,7.50,8.75,10,11.25,8.43,6.50,4.52,2.75,1.55,0.03,-1.13,-5.86,-0.87,0.46,1.43,8.75,15,16.25,16.25,14.86,13.32,12,11.82,10.62,9.59,7.35,7.50,1.25,1.25,7.50,7.50,8.75,8.29,8.32,8.62,8.79,8.92,8.90,8.87,8.95,9.12,9.12,10,11.25,11.25,10,11.25,11.25,10,10,10,10,10,11.25,10,10,8.75,8.75,8.75,10,12.50,13.75,15,15,12.50,11.25,10,10,10,10,10,10,10,10,10,10,10,10,10,10,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,8.75,8.75,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,6.25,6.25,6.25,6.28,6.45,6.68,7.45,8.26,9.21,10.14,10.59,10.80,10.93,11.18,11.52,12.52,13.57,14.14,16.75,18.87,20.64,22.63,24.03,24.57,24.37,23.72,23.32,23.27,23.46,23.85,24.37,25.02,25.79,26.55,26.96,26.98,26.65,25.27,23.76,22.20,20.72,19.46,17.13,15.26,16.34,19.03,22.90,28.22,27.28,26.90,25.89,25.11,24.50,21.43,19.93,17.50,15,10,6.25,5,5,5,6.25,6.25,6.25,8.75,16.25,23.75,25,25,28.75,27.50,25,21.25,13.75,8.75,3.85,1.07,-3.07,-6.11,-8.35,-9.91,-10,-11,-12,-12,-12,-12,-11,-11,-12,-13,-15,-17,-17,-17,-17,-17,-16,-14,-11,-8.37,-4.70,-1.18,1.28,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,2.50,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,2.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.21,5.84,5.43,5.03,5,5,5,5,5,5,5,5,5,5.01,5.29,6.10,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,7.50,7.50,9.96,10.62,9.21,7.02,4.84,2.96,1.25,-0.03,-1.47,-5.63,-4.75,-0.91,1.38,6.13,8.75,11.10,12.20,10.89,10.62,10.28,7.71,6.54,6.60,1.90,1.52,-0.63,-1.03,-1,1.25,3.75,6.25,7.87,9.28,9.90,10.36,10.85,11.23,11.67,12.76,13.26,13.47,13.75,13.75,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,8.75,8.75,8.75,10,12.50,12.50,13.75,12.50,11.25,11.25,10,10,10,10,10,10,10,10,10,10,10,10,10,10,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.35,6.53,6.71,7.52,8.30,9.17,10.11,10.14,10.46,10.97,12.07,13.43,14.84,16.13,17.80,19.77,21.84,23.77,25.62,26.71,25.90,24.79,23.87,23.72,23.87,24.23,24.68,25.26,25.79,26.25,26.51,26.39,25.87,24.84,23.32,21.73,20.18,18.59,16.90,15.43,16.43,19.26,22.63,25.72,28.30,27.59,26.13,25.90,25.64,24.77,20.10,18.75,17.50,12.50,7.50,5,5,5,5,5,6.25,7.50,15,22.50,27.50,26.25,25,25,23.75,17.50,13.75,7.50,1.28,1.13,-3.58,-6.75,-8.95,-10,-11,-12,-12,-12,-12,-12,-11,-11,-11,-13,-15,-17,-17,-17,-17,-17,-16,-14,-12,-7.74,-3.53,-0.41,1.43,2.50,2.50,3.75,3.75,3.75,3.75,5,5,3.75,1.25,1.25,1.25,1.25,1.25,1.25,1.25,3.75,3.75,3.75,2.50,3.75,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.22,5.17,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,7.50,7.50,8.75,9.37,9.37,7.78,5.29,3.28,1.46,0,-1.67,-3.97,-4.27,-3.37,-1.29,1.35,4.84,6.25,1.53,1.67,1.71,2.02,0.97,0.36,-1.09,-0.90,-2.75,-1.13,-2.39,1.71,1.25,1.25,7.50,8.75,9.85,10.79,11.46,12.12,12.79,13.92,14.04,14.32,13.52,13.68,13.75,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,8.75,8.75,8.75,10,10,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,10,10,10,10,10,10,8.75,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,6.25,6.25,6.25,6.27,6.38,6.54,6.84,7.59,8.27,8.88,9.36,9.78,10.50,11.87,14.84,16.09,17.27,18.75,20.77,22.95,25.12,27,29.38,27.34,26.11,25.03,24.05,24.62,24.86,25.18,25.55,25.89,26.10,26.13,25.92,25.30,24.23,22.79,21.23,19.64,18.10,16.65,15.55,16.55,19.18,22.03,25,28.25,29.70,27.65,26.96,26.43,27.17,24.85,21.25,18.75,13.75,8.75,6.25,5,3.75,3.75,5,6.25,7.50,13.75,23.75,27.50,26.25,22.50,23.75,21.25,15,11.25,6.25,1.25,-0.16,-3.98,-7.51,-9.80,-11,-12,-12,-12,-12,-12,-12,-11,-11,-11,-12,-13,-15,-16,-16,-16,-16,-15,-13,-10,-7.36,-3.03,-0.12,1.50,2.46,2.50,3.75,3.75,3.75,5,5,5,5,3.75,1.25,1.25,1.25,1.25,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,7.50,8.75,8.75,8.75,7.80,7.30,5.67,3.37,1.67,0.21,-1.63,-6.39,-6.39,-5.38,-3.29,-1.64,0.93,1.02,1.07,0.14,-1.76,-2.63,-6.47,-4.47,-7.34,-4.86,0.09,1.87,1.57,7.50,7.50,8.75,10,11.25,11.25,12.48,12.25,12.61,14.48,14.42,14.48,14,13.68,13.68,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,10,8.75,8.75,8.75,8.75,10,10,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,6.25,6.36,6.39,6.43,6.40,6.37,6.60,6.88,7.48,7.96,8.40,8.86,9.50,10.80,12.64,14.79,16.87,19.20,21.60,23.89,26.04,28.38,28.75,28.59,27.53,26.55,25.88,25.62,25.63,25.76,25.89,26.02,26.03,25.88,25.47,24.84,23.61,22.18,20.62,19.09,17.64,16.39,15.64,16.70,19.10,21.73,24.39,26.85,28.40,28.62,27.92,27.05,26.09,26.05,24.95,19.98,15,10,6.25,5,3.75,3.75,5,5,7.50,11.25,18.75,27.50,28.75,27.50,21.25,18.75,15,11.25,6.25,1.25,-0.21,-5.12,-7.85,-10,-11,-12,-12,-12,-12,-12,-12,-11,-11,-10,-11,-12,-13,-14,-15,-15,-15,-14,-12,-10,-7.04,-3.68,-0.41,1.46,2.18,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,7.50,8.75,7.50,7.48,6.71,5.46,4.21,2.90,1.38,0.09,-1.11,-6.87,-11,-11,-5.78,-4.67,-3.40,-2.62,-1.72,-1.41,-2.98,-8.30,-4.02,-0.76,0.03,0,0.46,2.13,8.07,9.71,11.25,11.25,13.75,13.75,13.75,15,13.75,12.50,12.50,13.75,15,13.75,13.75,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,12.50,11.25,11.25,11.25,10,10,10,8.75,8.75,8.75,8.75,8.75,8.75,10,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,6.25,7.36,7.34,7.22,6.54,6.43,6.40,6.65,6.89,7.22,7.52,7.82,8.37,8.57,11.09,13.29,16.09,19.21,22.20,24.79,26.50,28.10,29.62,29.26,28.92,27.92,27.18,26.70,26.39,26.25,26.13,26.05,25.88,25.57,25.01,24.15,22.96,21.53,20.11,18.61,17.29,16.03,15.77,17.13,19.15,21.60,24.03,26.25,28.07,29.84,28.89,27.05,25.65,24.02,23.60,22.43,16.22,11.25,7.50,5,3.75,3.75,3.75,5,6.25,8.75,13.75,22.50,30,28.75,26.25,20,15,11.25,6.25,3.75,-0.42,-5.85,-8.29,-10,-11,-12,-13,-13,-12,-12,-12,-11,-10,-10,-11,-12,-13,-14,-14,-14,-14,-13,-11,-9.52,-7.04,-4.33,-1.64,1.15,2.12,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,7.50,7.50,8.75,7.50,6.03,4.51,2.96,1.72,0.60,-0.38,-1.43,-4.89,-9.40,-15,-12,-7.88,-5.72,-6.53,-5.47,-4.49,-6.97,-4.04,-2.34,-1.50,0.21,2.01,3.43,5.57,7.53,10.30,12.60,13.75,13.75,15,16.25,16.25,15,13.75,12.50,12.50,12.50,13.75,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,12.50,12.50,11.25,11.25,11.25,10,10,10,8.75,8.75,8.75,8.75,8.75,8.75,8.75,10,10,11.25,11.25,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,6.25,6.36,7.34,8.47,7.30,6.55,6.55,6.53,6.60,6.73,6.88,7.07,7.18,8.43,9.71,12.28,14.84,19.14,23.71,24.84,26.20,27.78,29.63,29.55,29.36,28.76,28.09,27.45,26.96,26.55,26.27,25.97,25.62,25.12,24.67,23.39,22.18,20.90,19.57,18.27,17.13,16.09,15.88,17.21,19.21,21.53,24.05,25.77,27.65,29.86,28.92,26.67,24.71,23.39,20.14,18.60,14.93,10,6.25,5,3.75,3.75,3.75,3.75,5,7.50,10,16.25,23.75,28.75,26.25,22.50,16.25,11.25,7.50,3.75,-0.09,-5.20,-8.38,-10,-11,-12,-13,-13,-12,-12,-12,-11,-10,-10,-11,-11,-12,-13,-13,-13,-13,-12,-11,-9.38,-7.30,-4.98,-2.50,0,2.02,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,7.50,7.50,8.75,7.50,7.50,4.52,2.50,1.29,-0.04,-1.51,-4.22,-4.17,-6.35,-9.51,-10,-10,-6.25,-5.50,-6.75,-6.36,-7.04,-4.38,-3,-1.72,-0.30,1.43,3.76,6.10,8.75,11.25,13.75,17.50,16.25,16.25,15,16.25,15,13.75,12.50,11.25,11.25,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,12.50,11.25,11.25,11.25,11.25,10,10,10,8.75,8.75,8.75,8.75,8.75,8.75,8.75,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,6.11,6.39,7.28,8.45,7.17,6.71,6.64,6.54,6.50,6.52,6.67,7.15,8.12,9.63,11.02,14.68,18.43,23.72,23.78,25.26,26.90,28.40,29.47,29.62,29.21,28.46,27.79,27.18,26.67,26.22,25.77,25.18,24.52,23.59,22.60,21.42,20.29,19.17,18.09,17.18,16.54,15.93,16.88,19.37,21.53,23.47,25.18,26.59,28.63,27.65,24.96,23.47,22.04,19,16.09,12.50,8.78,6.25,3.75,3.75,3.75,3.75,3.75,5,6.25,7.50,11.25,18.75,23.75,27.50,22.50,16.25,11.25,7.50,3.75,-0.24,-4.76,-8.20,-10,-11,-12,-13,-13,-12,-12,-12,-11,-11,-11,-11,-12,-12,-13,-13,-13,-12,-12,-10,-9.50,-7.76,-5.73,-3.47,-1.03,1.87,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,6.25,5,2.59,1.05,-0.25,-1.75,-6.15,-7.84,-7.17,-6.49,-6.75,-7.98,-6.89,-5.75,-6.88,-8.10,-6.89,-5.50,-3.85,-2.37,-1.09,0.29,2.29,4.82,8.75,10,12.50,16.25,17.50,16.25,15,16.25,13.75,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,10,8.75,8.75,8.75,8.75,8.75,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5.09,6.09,6.25,6.52,6.55,7.03,6.96,6.43,6.35,6.35,6.54,7.07,8.12,9.57,11.57,14.17,17.21,19.84,22.01,23.75,25.77,27.62,29.01,30.45,29.15,28.43,27.77,27.13,26.45,25.82,25.25,24.84,23.71,22.75,21.72,20.75,19.77,18.85,17.98,17.37,17,17.13,18,19.65,21.68,23.40,24.55,25.01,24.88,23.61,22.37,21.38,22.02,17.60,13.93,10.14,7.62,5.02,3.75,3.75,3.75,3.75,3.75,3.75,5,7.50,10,13.75,21.25,25,21.25,16.25,12.50,7.50,3.75,-1.18,-4.79,-8,-10,-11,-12,-12,-13,-12,-12,-12,-11,-11,-11,-11,-12,-12,-13,-13,-12,-12,-11,-10,-9.78,-8.36,-6.65,-4.61,-2.12,0.62,1.80,2.46,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.02,5.77,4.34,2.37,1.25,-0.51,-2.77,-4.61,-7.11,-9.40,-7.48,-7.43,-7.49,-6.93,-6.15,-6.25,-7.91,-8.99,-7.61,-5.12,-3.29,-1.97,-0.75,0.76,2.62,5.71,8.75,11.25,15,15,15,15,15,13.75,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,10,8.75,8.75,8.75,8.75,10,10,11.25,11.25,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5.09,5.13,5.18,5.27,5.93,6.18,6.26,6.25,6.20,6.22,6.40,7.02,8.10,9.68,11.68,13.57,15.96,17.89,19.78,21.87,24.32,27.18,28.46,29.05,28.85,28.01,27.37,26.72,25.97,25.25,24.51,23.70,22.80,21.87,20.95,20.12,19.35,18.62,18.11,17.75,17.59,17.67,18.47,20,21.97,24.04,24.35,23.37,21.39,20,18.42,19.34,18.29,15.34,13.47,8.92,6.39,3.85,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,7.50,11.25,16.25,20,20,16.25,12.50,8.75,1.68,-1.63,-4.98,-7.92,-10,-11,-12,-12,-13,-12,-12,-12,-11,-11,-11,-11,-12,-12,-13,-13,-12,-12,-11,-11,-10,-8.97,-7.64,-5.95,-3.65,-0.39,0.93,2.01,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,5,3.75,3.75,3.75,3.75,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,7.50,7.50,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,6.25,7.50,7.50,7.50,8.75,8.10,6.09,4.35,2.67,1.25,-0.37,-3.53,-5.24,-6.25,-7.85,-8.47,-9.15,-9.40,-9.04,-8.13,-6.75,-5.80,-7.91,-9.11,-7.88,-4.30,-2.60,-1.63,-0.63,0.93,3.27,6.39,11.25,13.75,13.75,15,15,13.75,13.75,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,12.50,12.50,12.50,11.25,11.25,11.25,12.50,11.25,11.25,11.25,11.25,10,10,10,10,8.75,8.75,8.75,8.75,10,10,10,10,10,10,10,10,10,10,10,10,11.25,11.25,11.25,10,10,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.13,5.28,5.32,5.77,5.93,5.95,6.02,6.25,6.86,7.89,9.46,11.54,14.01,15.12,16.42,17.45,20,22.68,25.20,28.29,29.30,27.92,27.34,26.82,26.12,25.32,24.48,23.59,22.75,21.87,21.05,20.28,19.57,19.05,18.61,18.30,18.15,18.13,18.26,18.09,20.13,22.50,24.05,22.34,20.92,18.27,14.93,15.93,18,18.23,13.93,10.93,7.75,5.15,3.87,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,8.75,11.25,15,17.50,16.25,12.50,8.75,2.48,-2.03,-5.15,-7.93,-10,-11,-12,-12,-13,-12,-12,-12,-11,-11,-11,-11,-12,-12,-13,-12,-12,-12,-11,-11,-10,-9.37,-8.48,-7.57,-5.45,-2.88,0,1.52,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.43,6.25,4.77,2.96,1.39,-0.17,-3.27,-4.86,-6.77,-6.88,-8.63,-10,-11,-11,-10,-9.01,-7.49,-8.15,-8.98,-9.99,-8.78,-4.75,-1.93,-1.01,0.09,2.02,4.52,7.64,10,12.50,13.75,13.75,15,13.75,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,12.50,12.50,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,8.75,8.75,8.75,10,10,10,10,10,10,10,10,10,10,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.97,4.86,4.84,4.78,4.71,5,5.34,5.75,5.63,5.64,5.93,6.52,7.46,8.85,10.65,12.80,15.26,14.80,16.09,18.27,20.77,23.55,25.17,26.90,26.53,26.42,26.11,25.50,24.53,23.59,22.64,21.80,21.02,20.30,19.68,19.22,18.89,18.72,18.61,18.68,18.76,18.89,19.21,20.11,21.09,21.39,21.87,17.97,15.11,12.45,13.12,14.30,14.46,11.53,8.84,6.51,4.93,3.89,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,10,12.50,13.75,13.75,12.50,7.50,2.15,-2.26,-5.36,-8.02,-10,-11,-12,-12,-13,-12,-12,-12,-12,-11,-11,-11,-12,-12,-12,-12,-12,-12,-11,-10,-10,-9.37,-8.61,-7.83,-9.51,-3.38,-0.25,1.38,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,7.50,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6.25,5,5,5,5,5,6.25,5,6.25,6.25,7.50,8.75,7.50,7.50,7.50,7.01,5.93,4.52,3.12,1.67,0.21,-2.02,-4.13,-5.86,-6.29,-8.35,-10,-11,-12,-12,-11,-9.63,-9.25,-9.75,-9.54,-8.14,-6.38,-2.47,-1.17,-0.25,1.35,2.96,6.25,8.89,11.25,13.75,13.75,15,13.75,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,12.50,12.50,12.50,13.75,13.75,13.75,13.75,12.50,12.50,12.50,11.25,11.25,11.25,11.25,10,10,10,10,10,10,8.75,8.75,8.75,10,11.25,10,10,10,10,10,10,10,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3.84,3.88,3.90,4,4.68,4.96,5.18,5.30,5.39,5.61,6.09,6.84,7.95,9.39,11.13,12.59,14.03,14.84,16.72,18.86,20.89,22.64,23.89,24.78,25.29,26.26,24.68,23.70,22.65,21.72,20.92,20.20,19.68,19.26,19.03,18.89,18.88,19,19.21,19.50,19.71,19.98,20.03,20.39,20.14,18.70,15.34,11.37,9.87,9.64,10.63,10.26,8.86,6.55,5.28,4,3.89,3.75,3.75,3.75,3.75,3.75,3.75,3.75,2.50,3.75,5,8.75,10,11.25,11.25,11.25,7.50,1.52,-2.58,-5.55,-8.10,-10,-11,-12,-12,-13,-13,-12,-12,-12,-11,-11,-11,-12,-12,-12,-12,-12,-12,-11,-10,-9.88,-8.84,-7.77,-6.70,-4.74,-2.41,0.27,1.64,2.50,2.50,1.25,1.25,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,8.75,7.50,8.75,8.75,8.75,7.50,8.75,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,6.25,6.25,6.25,7.50,7.50,7.50,8.75,8.75,6.09,4.47,2.96,1.65,0.43,-1,-3.13,-4.29,-5.13,-7.50,-10,-12,-13,-13,-13,-11,-10,-10,-9.25,-9.36,-5.64,-2.18,-1.29,-0.38,0.93,1.87,5.73,7.64,11.25,13.75,13.75,13.75,13.75,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,12.50,13.75,15,13.75,15,15,13.75,13.75,12.50,12.50,11.25,11.25,11.25,11.25,10,10,10,10,10,10,8.75,8.75,8.75,10,10,10,10,10,10,10,10,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.76,3.89,4,4.68,4.80,4.97,5.03,5.27,5.62,6.21,7.01,8.12,9.47,10.92,12.13,13.70,15.14,16.84,18.75,20.62,21.65,23.13,24.37,24.38,23.78,22.77,21.73,20.87,20.13,19.57,19.21,19.03,18.93,19,19.14,19.37,19.70,20.13,20.79,20.55,20.48,20.30,19.68,18.12,15.30,11.35,9.85,8.32,8.12,8.07,6.71,5.30,5.10,4.01,3.90,3.75,3.75,3.75,3.75,3.75,3.75,2.50,2.50,2.50,3.75,7.50,8.75,8.75,8.75,7.50,4.84,0.91,-2.84,-5.90,-8.16,-10,-11,-12,-12,-13,-13,-13,-12,-12,-11,-11,-11,-12,-12,-12,-12,-12,-11,-11,-10,-9.40,-8.01,-6.32,-4.32,-1.95,-0.03,1.39,2.18,2.50,2.50,1.25,1.25,2.50,3.75,3.75,3.75,2.50,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,6.25,5,5,5,6.25,6.25,6.25,6.25,7.50,7.50,8.43,8.43,7.60,4.98,2.80,1.57,0.36,-0.93,-4,-5.25,-5.68,-6.49,-8.85,-11,-13,-14,-14,-13,-11,-10,-8.92,-8.85,-7.22,-3.59,-1.37,-0.43,0.77,2.34,4.52,6.51,8.75,11.25,13.75,15,15,13.75,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,12.50,13.75,13.75,13.75,13.75,15,15,15,13.75,12.50,12.50,11.25,11.25,11.25,10,10,10,10,10,10,10,8.75,8.75,8.75,10,10,10,11.25,10,10,10,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.89,4.02,4.68,4.55,4.68,4.93,5.28,5.62,6.27,6.96,8.23,9.50,11.07,12.60,13.55,14.87,16.36,19.63,21.87,23.29,23.92,23.71,22.89,21.86,20.87,20.02,19.50,19.14,19,18.95,19.05,19.22,19.51,19.84,20.25,20.65,20.97,21.11,21.02,20.64,20.03,19.14,17.62,15.62,13.42,11.50,10,8.84,7.79,6.57,5.30,5.01,3.93,3.89,3.75,3.75,3.75,3.75,2.50,2.50,2.50,2.50,3.75,5,6.25,6.25,6.25,5.10,3.43,0.23,-3.03,-6.03,-8.29,-10,-11,-12,-13,-13,-13,-13,-12,-12,-11,-11,-11,-11,-12,-12,-12,-12,-11,-11,-10,-9.01,-7.21,-4.91,-2.02,0.36,1.34,2.34,2.96,3.75,3.75,1.25,2.50,2.50,2.50,3.75,2.50,1.25,1.25,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,6.25,6.25,6.25,6.25,6.25,7.50,9.37,8.43,7.47,5.77,3.27,1.55,0.28,-0.98,-3.87,-5.26,-6.66,-6.39,-7.98,-10,-12,-13,-14,-14,-12,-10,-9.37,-7.90,-5.38,-3.79,-1.89,-0.63,0.61,2.02,3.89,7.18,7.34,8.75,11.25,15,16.25,16.25,13.75,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,12.50,13.75,13.75,13.75,13.75,13.75,15,13.75,12.50,12.50,12.50,11.25,11.25,11.25,10,10,10,10,10,10,10,8.75,8.75,8.75,10,10,10,10,10,10,10,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.89,4,4.05,4.10,4.68,5.09,5.46,5.62,6.76,7.77,8.14,10.55,12.14,13.43,15.15,16.26,19.79,22.50,24.63,24.48,23.28,22.17,21.07,19.86,19.37,19.01,18.88,18.93,19.17,19.39,19.72,20.09,20.46,20.78,21.13,21.43,21.68,21.59,21.27,20.77,20.46,20.97,20.02,16.52,14.14,11.89,10.51,9.21,8.40,7.34,6.25,5.14,3.89,3.85,3.75,3.75,2.50,2.50,1.25,1.25,2.50,2.76,3.50,4.01,3.72,3.18,2.43,1.30,-0.68,-3.36,-5.95,-8.20,-10,-11,-12,-13,-13,-13,-13,-13,-12,-12,-11,-11,-11,-12,-12,-12,-12,-12,-11,-10,-8.96,-6.90,-3.78,-0.49,1.09,1.54,2.28,3.71,2.50,2.50,2.50,2.50,2.50,2.50,2.50,2.50,1.25,1.25,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.78,7.27,5.46,3.12,1.64,0.25,-1.13,-4.14,-5.22,-6.48,-6.29,-7.75,-9.50,-11,-12,-13,-13,-13,-11,-11,-10,-7.99,-3.99,-2.02,-1,0.14,1.55,3.11,4.93,6.37,7.50,8.75,11.25,15,17.50,16.25,15,13.75,12.50,12.50,11.25,11.25,11.25,11.25,12.50,12.50,13.75,13.75,13.75,12.50,12.50,12.50,12.50,12.50,11.25,11.25,12.50,11.25,11.25,10,10,10,10,10,10,10,8.75,8.75,8.75,10,10,10,10,10,10,10,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.77,3.92,4.03,4.68,5.02,5.45,6.05,6.75,8.07,9.32,10.87,11.90,14.09,15.90,17.35,20.92,23.62,25.93,24.64,22.80,21.51,20.35,19.50,18.89,18.72,18.77,19.09,19.57,20.13,20.42,21.09,21.39,21.55,21.72,21.89,22.07,22.67,21.80,21.39,21.25,22.34,19.87,20.28,15.61,13.68,12.46,11.67,10.34,9.67,7.78,6.25,4.86,3.85,3.75,2.50,2.50,1.25,1.25,1.25,1.51,1.86,1.98,1.53,0.86,-0.16,-0.92,-1.88,-2.54,-4.34,-6.42,-8.50,-10,-11,-13,-13,-14,-14,-14,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-9.07,-7.39,-5.40,-3.49,-2.05,-1.09,-0.25,0.37,1.11,1.25,2.50,1.25,2.50,2.50,2.50,2.50,1.25,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.46,7.18,7.02,6.25,5,3.12,1.11,0.03,-1.24,-4.39,-5.73,-6.75,-6.28,-7.76,-9.41,-10,-12,-13,-13,-12,-11,-10,-10,-10,-8.37,-4.25,-1.53,-0.42,0.90,2.32,3.84,5.42,7.34,7.50,7.50,11.25,15,17.50,16.25,15,13.75,12.50,12.50,11.25,11.25,12.50,12.50,12.50,12.50,13.75,13.75,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,8.75,8.75,8.75,10,10,10,10,11.25,11.25,10,10,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.90,4.78,4.84,5.14,5.34,6.36,7.43,8.71,10.77,11.38,13.12,14.46,17.02,20.11,22.62,25.02,24.88,23.45,22.05,20.77,19.72,19.02,18.60,18.55,18.78,19.37,20.25,21.13,22.04,22.59,22.75,22.53,22.38,22.34,22.37,22.34,22.14,21.75,21.39,20.59,19.53,17.65,16.05,14.37,14.46,14.52,13.38,11.55,9.84,7.50,5.14,3.85,2.50,2.50,1.25,1.25,1.25,1.25,1.03,0.72,0.05,-1.07,-3.14,-3.85,-4.46,-4.65,-5.37,-6.47,-7.90,-9.43,-10,-12,-13,-14,-14,-14,-14,-14,-13,-13,-12,-12,-12,-13,-12,-12,-12,-12,-11,-10,-9.63,-8.45,-7.12,-5.84,-4.71,-3.75,-2.97,-2.17,-1.25,0.77,1.25,1.25,2.50,2.50,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,6.25,7.50,6.25,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,8.75,8.43,7.43,6.02,4.37,2.89,1.42,-0.12,-1.76,-5.75,-6.38,-7.40,-6.75,-8,-9.59,-11,-12,-13,-13,-12,-11,-10,-9.50,-8.51,-8.38,-6,-2.24,-0.93,0.14,1.55,2.89,4.35,6.02,7.60,8.75,10,12.50,16.25,17.50,17.50,16.25,13.75,12.50,12.50,12.50,12.50,12.50,13.75,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,8.75,8.75,8.75,10,10,10,11.25,11.25,11.25,10,10,10,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,3.75,3.88,4.84,4.98,5.18,5.96,6.53,7.80,9.63,10.32,11.60,13.23,15.50,18.84,22.93,25.29,25.18,23.57,22.43,21.18,20.01,19.05,18.61,18.39,18.43,18.85,19.62,20.77,22.47,23.70,24.96,24.22,23.62,23,22.68,22.52,22.45,22.30,22.07,21.57,20,18.53,17.15,14.52,15.26,15.73,16.11,15.88,15.93,11.52,8.86,6.09,3.85,2.50,1.25,1.25,1.23,1.23,1.23,0.10,-0.96,-2.27,-4.16,-5.68,-8.88,-7.03,-7,-7.43,-8.21,-9.22,-10,-11,-12,-14,-15,-15,-15,-15,-14,-14,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-10,-9.71,-8.85,-7.95,-7.10,-6.24,-5.49,-4.93,-3.79,-2.42,-0.41,1.25,2.50,2.50,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,6.25,6.25,5,5,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,7.50,6.25,6.25,6.25,7.50,8.75,11.25,9.02,6.98,4.67,2.95,1.35,-0.18,-1.43,-4.93,-8.13,-9,-7.38,-8.51,-9.91,-11,-12,-13,-13,-12,-12,-10,-9.13,-7.25,-7.14,-6.17,-3.42,-1.38,-0.26,0.93,2.27,3.52,4.82,6.39,8.68,11.25,13.75,16.25,18.75,18.75,18.75,16.25,13.75,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,10,8.75,8.75,8.75,10,10,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.84,4.86,5,5.13,6.09,7.34,7.65,8.93,10.97,11.10,12.70,15.40,19.48,25.59,25.47,23.59,22.17,21.64,20.62,18.87,18.75,18.40,18.27,18.42,18.89,19.65,21.11,22.70,25.14,26.39,26.39,24.14,23.39,22.96,22.68,22.60,22.52,22.53,22.50,21.88,19.70,17.07,15.75,15.60,16.71,17.60,19.64,17.18,14.70,9.78,6.09,3.62,1.25,1.16,0.79,0.71,0.71,0.40,-1.34,-3.02,-4.73,-6.72,-7.70,-8.35,-8.67,-8.60,-8.90,-9.47,-10,-11,-12,-13,-14,-15,-16,-16,-15,-15,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-11,-10,-9.97,-9.27,-8.46,-7.70,-7.09,-8.38,-4.08,-0.25,1.65,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,6.25,6.25,6.25,7.50,8.75,7.50,7.50,8.75,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,7.50,8.70,9.84,9.97,5.87,3.23,1.42,-0.25,-1.85,-4.75,-7.78,-9.04,-8.39,-9.25,-10,-11,-12,-13,-13,-13,-12,-11,-9.38,-7.88,-6.88,-4.50,-3.68,-1.67,-0.52,0.71,1.87,3.10,4.21,5.46,6.36,8.75,13.75,15,17.50,18.75,20,17.50,16.25,13.75,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,10,8.75,8.75,10,10,10,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,4.97,5.02,5.09,6.34,7.36,7.61,8.86,9.86,10.09,10.15,14.71,18.40,21.12,23.12,21.98,21.65,21.54,20.30,19.46,18.75,18.39,18.26,18.43,19,19.98,21.25,22.75,24.02,24.77,24.63,24.04,23.37,23.05,22.82,22.76,22.78,23.09,23.71,25.11,24.10,22.80,20.63,18.87,17.93,18.45,19.65,19.68,14.71,9.80,5.14,1.34,1.12,0.32,-0.18,-0.09,-0.04,-0.58,-3.05,-4.97,-6.74,-8.73,-8.66,-9,-9.26,-9.50,-9.80,-10,-10,-11,-12,-13,-15,-15,-15,-15,-15,-15,-15,-14,-14,-15,-15,-14,-14,-13,-13,-12,-12,-12,-12,-12,-12,-11,-11,-10,-9.36,-8.51,-6.85,-4.57,-0.67,2.15,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,7.46,7.47,7.89,8.84,6.39,4.23,1.96,-0.18,-2,-5.13,-10,-12,-11,-10,-11,-12,-13,-13,-13,-13,-12,-11,-9.65,-7.92,-7.30,-6.35,-4.05,-1.50,-0.63,0.72,1.71,3.26,3.89,5,6.25,7.50,10,13.75,15,17.50,18.75,18.75,17.50,15,13.75,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,5,6.25,7.50,8.75,7.50,8.75,10,10,10.10,11.39,15.29,19.17,21.89,20.65,21.07,20.80,20.39,19.68,19.04,18.54,18.37,18.57,19.21,20.26,21.40,22.53,23.40,23.76,23.72,23.37,22.98,22.80,23.21,22.77,22.79,23.43,24.52,26.40,30.34,29.22,25.62,22.01,17.89,18.72,19.67,18.43,14.72,8.54,1.45,0.71,-1.20,-2.13,-2.72,-2.90,-3.14,-3.72,-5.10,-6.88,-8.36,-9.60,-9.30,-9.36,-9.58,-9.84,-10,-10,-11,-11,-12,-13,-15,-15,-15,-15,-15,-15,-15,-15,-15,-16,-15,-15,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-12,-11,-10,-9.03,-6.99,-4.43,-0.75,2.27,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,6.25,7.50,6.25,7.50,7.50,7.50,8.75,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,8.75,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,7.34,6.68,6.25,5.77,5.14,4.05,2.29,0.17,-1.68,-4.75,-7.48,-10,-13,-12,-13,-13,-14,-14,-14,-13,-12,-11,-9.97,-8.38,-7.49,-5.30,-4.50,-1.64,-0.66,0.76,1.71,3.22,4.05,5.30,6.39,7.50,7.50,10,13.75,15,17.50,17.50,17.50,16.25,15,13.75,12.50,12.50,12.50,13.75,12.50,13.75,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,6.25,6.25,7.50,8.75,10,10,10,11.25,11.28,13.84,15.25,19.63,19.96,20.62,20.62,20.62,20.43,20.14,19.36,18.75,18.53,18.76,19.55,20.72,21.85,22.76,23.26,23.30,23.11,22.75,22.38,22.29,22.29,22.62,22.95,23.55,24.46,26.53,26.71,26.85,24.46,20.40,19.10,18.59,18.43,18.46,13.53,1.45,0.82,-2.50,-4.41,-5.70,-5.64,-5.73,-5.88,-6.27,-7,-8.20,-9.23,-9.83,-9.41,-9.35,-9.49,-9.76,-10,-10,-11,-11,-12,-13,-14,-14,-14,-14,-14,-15,-16,-17,-17,-17,-16,-15,-14,-14,-13,-13,-13,-12,-13,-13,-14,-14,-13,-12,-11,-9.54,-7.28,-4.55,-0.90,2.02,3.89,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,6.25,6.25,7.50,7.50,7.50,8.75,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,5,5,6.25,6.09,5.93,5,4.04,3.27,2.63,1.86,0.67,-1.14,-4.50,-7.67,-10,-12,-14,-15,-15,-15,-15,-14,-14,-13,-11,-10,-8.36,-7.61,-6.63,-4.39,-2.14,-0.85,0.87,1.55,3.26,4.03,5.30,6.55,8.43,8.75,10,12.50,13.75,15,16.25,17.50,17.50,16.25,15,13.75,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,6.25,7.50,8.75,10,10,11.25,11.25,11.25,14.97,16.09,16.38,18.43,19.10,19.95,20.51,20.62,20.51,20.28,19.62,19.05,18.75,18.88,20.18,21.43,22.64,23.39,23.59,23.30,22.80,22.21,21.72,21.40,21.40,21.84,23.63,22.93,23.60,24.37,24.68,23.09,21.68,19.10,19.07,18.43,17.18,15.97,8.55,1.46,-1.84,-3.97,-12,-8.75,-8.54,-8.35,-8.26,-8.27,-8.45,-8.86,-9.41,-9.50,-9.04,-8.91,-9.03,-9.30,-9.72,-10,-10,-11,-12,-12,-13,-13,-13,-13,-14,-16,-17,-19,-19,-18,-16,-15,-14,-13,-13,-12,-12,-12,-13,-13,-14,-14,-14,-13,-11,-10,-7.77,-5.05,-1.50,1.71,3.89,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,5,5,5,5,4.68,1.55,2.27,1.55,0.87,0.43,0,-0.59,-3.50,-6.79,-10,-13,-15,-16,-17,-17,-16,-15,-14,-12,-11,-10,-8.39,-6.76,-6.14,-4.59,-2.23,-0.89,-0.02,1.09,2.34,3.43,4.84,6.39,8.43,10.13,12.50,12.50,13.75,13.75,15,16.25,17.50,17.50,16.25,15,13.75,12.50,12.50,12.50,13.75,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,3.75,3.75,3.75,5,5,6.25,7.50,10,10,11.25,12.50,12.50,12.50,14.97,16.13,15.15,16.52,17.84,20,20.77,20.92,20.62,20.18,19.78,19.37,19.23,19.78,20.90,22.51,23.86,24.67,24.37,23.68,22.70,21.80,21.03,20.46,20.14,20.62,21.09,21.72,22.28,23,23.13,22.67,21.60,20.32,19.97,18.43,15.97,11.04,1.39,0.11,-4.16,-10,-10,-11,-10,-10,-9.71,-9.34,-8.98,-8.91,-8.95,-8.73,-8.25,-8.10,-8.20,-8.51,-8.99,-9.59,-10,-10,-11,-11,-12,-12,-12,-13,-14,-17,-19,-20,-20,-19,-17,-15,-13,-12,-12,-11,-11,-11,-12,-13,-14,-14,-14,-13,-11,-10,-8.46,-6.01,-2.39,1.02,3.73,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,8.75,7.50,7.50,7.50,7.50,8.75,8.75,8.75,8.75,8.75,8.75,8.75,7.50,6.25,5,3.75,3.75,1.25,1.53,0.77,-0.04,-0.38,-0.63,-0.88,-1.13,-2.02,-4.98,-8.50,-11,-14,-16,-17,-18,-17,-16,-14,-12,-11,-9.63,-8.12,-6.34,-5.74,-4.88,-3.01,-0.97,-0.13,0.77,1.64,2.64,4,5.28,7.75,10.14,13.75,12.50,13.75,13.75,15,16.25,17.50,17.50,16.25,15,15,13.75,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,6.25,6.25,7.50,10,10,11.25,11.25,12.50,12.50,13.75,15.01,17.35,16.42,19.03,20.82,21.98,21.34,20.64,20.14,19.82,19.68,19.77,19.82,21.70,23.52,26.11,26.07,25.46,24.22,22.64,21.25,20.18,19.47,18.75,18.61,19.78,19.62,21.04,21.90,22.12,22.50,22.64,22.18,22.18,19.71,13.53,1.39,1.37,-3.12,-5.61,-10,-11,-11,-11,-10,-9.95,-9.18,-8.51,-8.11,-7.99,-7.54,-7.05,-6.92,-7.01,-7.36,-7.97,-8.75,-9.57,-10,-10,-11,-11,-11,-11,-13,-15,-18,-20,-20,-20,-19,-16,-13,-11,-10,-10,-10,-10,-10,-10,-11,-12,-13,-14,-13,-11,-9.50,-10,-6.88,-3.77,0.57,3.27,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,6.25,6.25,6.25,7.50,7.50,7.50,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,6.25,7.50,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,8.75,10,8.75,10,8.75,8.75,10,8.75,7.50,6.25,5,3.75,1.25,1.25,-0.76,-0.77,-1.01,-1.38,-1.53,-1.75,-1.88,-3,-5.53,-8.92,-12,-14,-16,-17,-17,-16,-14,-12,-10,-8.55,-7.27,-6.15,-5.41,-2.26,-2.63,-1.13,-0.25,0.46,1.25,2.01,2.80,4.21,6.25,10,11.25,13.75,15,13.75,13.75,15,16.25,16.25,15,15,15,13.75,13.75,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,6.25,7.50,7.50,8.75,11.25,11.25,11.25,12.50,12.50,13.75,15,16.34,18.59,20.18,23.43,23.28,21.51,20.61,19.93,19.68,19.68,20.35,20.79,22.20,24.09,26.28,27.50,27.48,24.95,22.13,20.30,19.14,18.28,17.92,18.22,19.18,19.38,19.98,20.42,20.30,22.61,24.68,24.68,20.97,11.43,1.39,1.37,-1.05,-3.72,-14,-11,-10,-10,-10,-9.89,-9.07,-8.02,-7.04,-6.45,-6.18,-5.79,-5.60,-5.42,-5.50,-5.82,-6.60,-7.78,-8.97,-9.78,-10,-10,-10,-10,-10,-13,-17,-20,-20,-20,-20,-15,-12,-10,-9.41,-8.75,-8.40,-8.25,-8.25,-8.01,-8.78,-9.37,-10,-11,-17,-14,-8.42,-7.37,-7.23,-11,-4.25,0.62,3.21,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,7.50,7.50,6.25,6.25,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,8.75,7.50,8.75,7.50,8.75,8.75,8.75,10,10,10,8.75,8.75,7.50,6.25,6.25,5,2.50,1.25,-1,-0.79,-1.75,-1.17,-1,-1.50,-1.38,-1.43,-2.41,-4.40,-7.54,-10,-12,-14,-14,-14,-13,-10,-8.37,-6.50,-5.15,-4,-4.26,-4.39,-2.01,-0.25,-0.13,0.30,0.93,1.52,2.02,2.64,3.55,7.50,11.25,13.75,15,13.75,13.75,13.75,15,15,15,13.75,13.75,13.75,13.75,13.75,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,12.50,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,11.25,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,8.75,8.75,8.75,8.75,8.75,8.75,8.75,8.75,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,7.50,6.25,6.25,6.25,5,5,5,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,5,6.25,7.50,7.50,8.75,10,11.25,11.25,12.50,12.50,13.75,15,16.21,18.63,21.09,23.47,22.17,22.02,19.48,19.37,19.32,19.23,19.20,20.42,22.92,24.05,25.27,26.40,27.65,23.89,20.13,18.92,17.70,16.55,16.60,16.73,18.12,19.51,18.32,19.65,20.93,22.18,24.71,23.47,16.04,1.39,-0.90,-0.98,-1.02,-14,-14,-8.45,-8.04,-7.68,-7.50,-6.87,-6.30,-4.97,-4.48,-4.25,-4.01,-3.76,-3.66,-3.71,-3.78,-3.86,-4.27,-6.84,-9.08,-9.51,-9.76,-9.85,-9.89,-8.59,-8.93,-10,-17,-18,-18,-17,-16,-11,-9.05,-7.77,-7.13,-6.80,-6.68,-6.64,-6.64,-6.75,-6.97,-6.89,-6.80,-7.78,-18,-16,-5.35,-2.34,-4.39,-12,-3.25,0.77,2.96,5,5,5,5,5,3.75,3.75,3.75,3.75,3.75,3.75,3.75,3.75,];
}

function getTileMap()
{
	return [0,0,0,1,0,1,0,0,2,2,2,2,2,3,3,2,2,2,2,2,2,2,2,2,3,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,0,1,1,0,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,1,1,1,4,4,4,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,0,3,3,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,4,4,5,4,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,4,4,5,5,5,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,4,4,4,5,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,4,4,4,6,4,7,5,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,4,4,4,4,6,4,5,5,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,4,4,4,4,4,4,7,5,5,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,4,4,4,4,6,6,6,7,6,5,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,4,4,4,4,4,4,4,4,6,5,5,5,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,4,8,4,4,4,8,0,4,4,6,7,5,4,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,4,8,8,8,1,4,6,6,6,5,4,4,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,4,7,7,6,4,4,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,4,7,6,4,5,5,5,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,4,6,5,5,5,4,6,6,4,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,4,4,6,5,5,6,6,4,6,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,4,4,6,6,5,6,6,4,6,6,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,4,6,5,6,6,6,5,4,4,5,5,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,9,9,10,9,9,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,4,6,5,6,6,4,4,5,4,5,4,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,9,9,9,3,3,3,3,3,3,3,3,9,9,9,9,9,9,10,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,4,4,4,4,6,6,5,4,5,4,5,4,4,4,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,9,9,11,12,12,3,3,3,3,3,3,9,9,0,9,9,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,4,4,4,4,4,4,5,4,5,5,4,4,5,5,4,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,9,11,13,13,14,9,9,9,3,9,9,9,0,13,13,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,4,8,4,4,5,4,4,4,5,5,5,4,4,5,4,5,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,9,9,13,15,13,13,13,1,9,12,9,13,16,13,13,13,0,17,0,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,4,4,4,4,4,4,7,5,5,5,4,5,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,9,9,18,15,16,18,14,13,13,13,13,13,13,17,15,19,17,17,1,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,4,4,8,4,4,7,4,4,5,5,5,5,5,5,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,9,9,11,16,17,18,18,18,16,16,16,20,20,17,15,19,19,0,1,13,3,3,3,3,3,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,7,7,7,4,5,5,5,5,5,5,5,5,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,9,9,11,16,20,20,17,16,16,18,20,18,18,15,17,15,19,18,0,13,13,13,13,13,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,7,7,5,4,5,5,5,5,5,21,21,21,21,21,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,10,9,9,22,18,23,23,23,18,16,15,24,24,17,17,19,19,0,18,18,25,13,18,18,13,18,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,4,4,5,5,7,5,5,5,8,5,5,5,21,21,21,21,21,21,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,9,9,11,22,18,15,23,23,15,19,19,17,16,24,24,18,18,18,18,18,24,24,18,18,18,10,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,5,4,5,5,4,4,5,5,5,21,21,21,21,21,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,9,9,22,18,17,17,23,23,19,19,19,16,24,24,18,23,18,18,18,18,24,26,24,24,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,4,8,4,8,4,4,5,5,21,21,21,21,21,21,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,10,9,22,22,18,17,15,27,19,19,27,19,20,18,1,23,23,18,0,0,18,26,24,15,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,9,9,9,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,4,4,5,4,4,5,4,8,4,4,5,5,5,21,21,21,21,21,21,21,21,1,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,9,9,22,22,18,18,27,27,18,18,19,18,1,19,18,23,23,24,24,0,26,24,28,13,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,9,9,9,9,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,4,4,5,5,5,5,4,8,5,5,29,21,21,21,21,21,21,21,21,1,1,30,0,1,0,1,25,21,21,21,21,1,1,30,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,25,25,25,25,1,31,1,0,3,3,3,3,3,3,3,3,3,3,1,1,1,25,25,25,25,0,1,1,0,32,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,9,1,22,18,0,18,16,18,18,19,19,15,19,20,23,23,20,15,22,26,24,15,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,9,9,9,9,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,4,4,4,5,5,4,4,8,29,29,29,29,21,21,21,21,21,21,21,0,30,30,30,33,1,21,21,21,21,21,30,30,30,30,30,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,25,1,25,25,25,25,25,25,25,1,1,1,1,1,3,25,1,0,1,1,1,1,1,25,25,1,0,32,32,32,0,0,25,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,9,9,22,22,18,23,23,23,19,19,19,15,19,20,20,15,15,15,18,16,24,15,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,6,5,5,5,5,4,4,4,4,29,29,29,0,21,21,21,21,21,21,21,0,1,30,1,0,21,21,21,21,21,30,30,30,1,30,30,30,30,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,0,0,1,25,1,1,25,25,1,25,25,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,25,32,32,0,0,25,25,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,9,0,22,17,17,15,18,19,34,34,19,0,20,0,15,15,18,0,24,15,22,13,3,3,3,3,3,3,3,3,0,3,0,1,3,3,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,8,6,4,5,5,5,7,4,5,5,8,29,29,29,21,21,21,21,21,21,21,21,1,30,30,0,21,21,21,21,21,30,30,30,33,33,30,30,30,30,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,14,14,25,1,1,1,35,1,1,25,25,1,25,25,32,32,32,1,1,1,1,1,1,1,0,0,0,0,0,0,25,0,0,0,0,25,32,32,32,0,25,25,25,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,9,9,13,13,17,16,34,16,34,34,34,13,13,13,0,0,18,18,22,13,13,13,3,3,3,3,3,3,3,3,13,13,13,1,3,3,13,13,1,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,8,6,6,5,4,5,5,7,5,5,5,29,29,29,1,21,21,21,21,21,21,21,1,1,0,0,21,21,21,21,21,30,30,0,33,33,33,30,0,30,30,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,14,14,14,25,1,1,1,1,1,1,1,25,25,25,32,32,32,32,1,1,1,0,0,0,0,0,0,1,1,1,25,25,0,0,0,0,25,25,25,32,32,0,25,25,25,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,9,10,13,13,13,13,13,0,25,13,13,13,10,3,13,1,0,1,13,13,13,13,3,3,3,3,3,3,1,13,13,13,13,13,13,9,9,9,9,9,1,0,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,4,8,4,4,8,4,6,6,8,4,5,4,7,5,5,5,29,29,29,21,21,21,21,21,21,21,0,0,1,21,21,21,21,21,21,21,21,1,33,33,33,30,30,1,30,30,30,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,14,14,25,32,32,32,1,1,25,1,1,1,25,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,1,0,0,0,25,32,25,25,25,32,25,1,25,25,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,10,10,13,13,10,13,13,13,3,3,3,3,3,3,3,13,13,13,13,10,3,3,3,3,3,3,13,9,13,9,9,9,9,13,9,9,9,9,9,9,9,9,1,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,8,8,6,6,6,4,7,7,5,5,5,8,29,29,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,30,30,33,0,1,1,30,33,33,33,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,32,32,1,32,25,1,1,1,25,1,1,32,32,1,1,1,0,0,1,0,0,1,0,0,0,1,25,25,25,1,25,0,32,32,32,32,32,25,25,32,32,25,0,25,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,9,9,9,9,9,13,9,9,9,9,9,9,9,9,9,9,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,8,4,8,4,6,6,6,6,7,5,5,5,5,5,29,29,29,29,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,0,30,33,33,30,30,30,0,30,33,30,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,32,25,32,32,25,25,31,25,25,1,32,32,32,32,1,0,1,1,1,1,1,0,1,0,1,25,25,1,1,31,0,25,25,0,32,32,32,25,0,32,32,25,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,13,13,13,9,9,9,9,9,9,9,9,9,37,9,9,9,9,9,9,0,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,8,8,8,4,8,6,6,8,6,7,4,8,5,5,5,5,29,29,29,21,21,21,21,21,21,21,21,21,21,21,21,21,30,30,30,30,30,33,30,33,0,0,30,30,30,30,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,32,32,25,25,25,25,25,1,32,1,32,32,32,32,32,32,32,32,1,1,1,1,1,31,31,0,0,25,0,0,0,32,32,25,25,32,32,32,0,0,25,25,25,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,9,9,9,9,37,9,9,9,9,9,9,9,9,9,9,9,9,9,0,25,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,8,8,4,8,4,4,4,4,4,7,4,4,8,5,5,5,29,29,21,21,21,21,21,21,21,21,21,21,21,21,21,0,30,30,30,30,33,33,33,33,33,30,1,30,30,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,25,25,25,32,32,32,32,32,32,32,32,32,25,25,32,32,1,32,31,1,1,31,0,25,25,25,0,0,32,32,0,32,32,0,32,32,38,0,25,25,36,36,25,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,13,13,9,9,9,9,9,37,37,9,9,9,9,13,9,1,3,3,3,1,1,9,9,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,8,4,8,4,8,4,4,4,8,7,7,7,5,8,5,5,29,29,21,21,21,21,21,21,21,21,21,21,21,21,21,0,30,0,33,30,30,0,33,33,33,33,30,30,30,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,38,38,38,1,25,32,32,32,1,1,1,32,32,32,32,32,32,32,32,1,31,1,32,25,0,32,25,0,0,32,32,32,25,32,32,0,38,38,0,25,25,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,3,3,3,1,1,9,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,8,8,4,6,6,8,4,7,5,5,8,5,5,29,0,21,21,21,21,21,21,21,21,21,21,21,21,1,30,30,33,33,1,30,33,33,33,33,0,30,30,30,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,31,1,1,38,38,1,25,25,32,32,32,32,32,1,1,32,32,32,25,32,1,1,1,32,32,32,32,0,0,0,0,0,32,0,0,0,32,0,38,0,0,25,39,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,20,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,8,6,6,8,7,7,5,5,5,5,29,29,1,21,21,21,21,21,21,21,21,21,21,21,21,21,30,30,33,33,30,33,0,30,33,30,1,30,30,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,31,1,1,38,38,38,1,1,1,1,1,25,25,1,32,32,25,25,1,1,31,31,1,32,32,32,25,31,0,0,31,0,32,32,0,0,32,32,38,0,0,25,36,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,20,1,3,3,3,3,3,3,3,3,20,3,3,3,3,3,3,3,3,3,3,3,9,9,9,9,37,9,9,13,13,9,9,9,37,9,9,9,9,9,9,9,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,8,4,4,6,6,6,7,7,5,5,5,5,5,5,29,29,21,21,21,21,21,21,21,21,21,21,21,21,1,30,30,33,33,0,30,1,30,30,1,1,30,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,31,31,1,1,38,38,38,25,25,25,25,25,25,1,32,32,1,1,1,1,1,1,1,1,32,1,1,35,25,25,0,0,0,0,32,0,0,0,32,0,0,0,25,36,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,3,3,3,3,3,3,3,3,20,20,1,3,3,3,3,3,1,20,20,3,3,3,3,3,3,3,3,3,3,3,3,13,9,9,37,9,37,9,13,13,9,9,9,37,37,9,9,9,9,9,9,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,8,4,4,4,7,5,4,4,4,4,5,5,29,29,0,21,21,21,21,21,21,21,21,21,21,21,1,30,30,30,30,30,0,1,0,30,30,0,30,30,2,2,2,2,2,2,3,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,31,31,31,31,1,25,25,1,1,25,25,25,1,1,32,32,32,32,32,1,1,1,1,1,1,1,35,1,41,25,25,0,0,0,0,0,32,0,0,38,0,0,0,25,36,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,20,20,0,3,3,3,3,3,3,3,20,20,20,0,3,3,3,20,20,20,0,3,3,3,3,3,3,3,3,3,3,3,3,13,9,9,9,9,9,9,9,13,13,13,13,9,9,9,9,9,9,9,9,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,8,4,4,5,5,4,4,8,4,4,4,29,29,29,29,29,1,21,21,21,21,21,21,21,21,21,21,1,30,30,1,30,30,30,30,30,33,30,0,30,30,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,31,31,31,31,1,1,1,1,1,1,1,1,1,32,32,32,32,32,32,1,31,1,1,1,42,42,1,1,1,1,31,31,0,0,0,0,0,38,32,0,0,0,0,1,36,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,20,20,20,0,0,3,3,3,3,3,20,20,1,20,20,20,20,20,20,20,1,3,3,3,3,3,3,3,3,0,1,20,1,3,13,13,9,9,9,9,9,9,3,13,13,9,9,9,9,9,9,9,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,8,4,5,5,4,4,4,5,5,8,5,5,29,29,29,29,0,21,21,21,21,21,21,21,21,21,21,30,30,30,0,1,30,30,30,33,33,30,33,33,30,30,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,31,31,31,31,31,31,1,32,32,25,32,1,1,1,31,31,1,1,1,32,32,1,1,1,1,42,36,42,35,1,1,31,1,1,31,31,0,0,0,38,0,32,32,0,0,25,36,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,3,3,3,3,3,3,3,3,3,3,3,3,20,20,20,20,0,1,3,3,3,1,20,13,0,1,13,1,13,13,20,20,20,1,3,3,3,3,3,3,1,20,20,20,0,3,0,13,9,9,9,9,9,0,3,3,3,1,0,9,9,9,9,9,9,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,4,8,4,8,8,8,43,5,5,5,8,4,5,5,4,8,5,5,29,29,29,29,21,21,21,21,21,21,21,21,21,21,21,25,30,30,30,0,1,30,30,30,33,33,30,30,30,30,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,0,31,31,31,31,31,31,1,1,32,32,32,1,1,1,1,31,1,1,1,1,32,1,1,1,42,36,36,36,36,42,1,1,1,1,1,1,31,0,31,38,0,0,32,0,0,0,36,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,14,1,1,3,3,3,3,3,3,3,3,3,3,3,3,20,20,20,20,20,0,1,3,3,25,13,13,13,13,13,13,14,14,20,20,20,3,3,3,3,3,3,3,20,20,13,0,0,0,1,25,13,9,9,0,1,3,3,3,3,3,3,3,1,0,9,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,8,8,4,4,5,5,8,8,5,4,4,4,4,29,5,5,5,29,1,21,21,21,21,21,21,21,21,21,21,21,1,1,30,30,30,30,30,30,33,33,33,33,30,33,30,30,2,2,2,2,2,2,2,2,2,2,3,3,1,1,1,35,35,31,31,1,1,1,32,32,32,25,1,1,31,1,1,1,1,1,32,32,1,1,42,42,36,36,36,42,1,1,1,1,31,1,0,0,0,38,38,32,0,0,0,0,25,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,14,14,14,1,0,3,3,3,3,3,3,3,3,3,3,3,0,20,20,20,20,20,0,3,0,1,13,13,13,0,1,13,13,14,14,20,0,0,0,1,0,0,1,20,20,0,13,0,13,13,13,13,1,1,20,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,4,8,8,8,8,4,4,5,5,5,5,5,4,4,4,4,4,5,29,29,29,21,21,21,21,21,21,21,21,21,21,21,21,21,0,0,30,30,30,21,0,30,30,33,33,33,30,30,30,30,30,2,2,2,2,2,2,2,3,3,36,36,36,35,35,35,35,1,1,32,32,32,32,25,25,1,1,1,1,1,31,1,1,31,1,1,1,42,36,36,36,36,42,1,1,1,1,1,0,0,0,38,38,32,0,0,0,0,25,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,26,26,14,0,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,20,20,20,0,3,1,1,20,13,13,0,16,13,13,13,14,16,20,20,20,20,20,20,20,20,1,13,13,13,13,0,0,20,20,20,20,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,5,5,4,5,5,5,4,4,4,4,5,29,29,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,30,1,30,30,0,30,30,30,33,30,30,30,30,30,2,2,2,2,31,31,36,36,36,44,45,35,35,31,32,32,31,1,25,25,25,25,25,31,31,1,46,1,1,1,1,1,1,36,36,36,36,36,42,42,35,1,1,1,1,0,38,38,38,0,32,0,0,0,0,36,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,26,26,0,14,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,20,18,25,3,3,1,20,1,16,16,14,14,14,13,14,16,16,16,18,18,18,18,16,16,1,13,13,13,0,20,20,20,20,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,40,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,5,5,5,4,4,5,5,4,4,4,5,5,29,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,30,1,0,30,30,30,30,0,33,1,30,30,30,2,2,2,2,2,31,31,36,36,36,36,0,35,35,35,35,1,1,1,1,25,25,25,25,25,31,46,46,31,1,1,41,1,1,0,36,36,36,36,36,42,1,1,1,1,1,31,0,0,38,0,38,38,38,0,25,36,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,25,14,1,14,14,14,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,18,20,1,20,0,20,16,16,16,18,16,18,16,13,13,28,28,28,13,13,13,16,18,16,16,1,0,0,20,20,20,20,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,40,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,8,4,4,5,5,5,5,5,4,4,4,29,5,29,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,0,30,21,21,1,1,30,30,30,30,30,25,25,2,2,2,2,2,3,3,31,47,36,36,36,45,0,35,35,35,1,46,46,1,25,31,25,25,25,25,46,46,1,1,1,1,1,1,1,47,36,36,36,36,42,42,1,1,1,1,1,31,0,0,0,38,0,38,0,1,25,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,14,1,14,14,14,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,18,20,16,20,20,20,16,20,18,16,16,16,28,28,13,13,13,13,16,13,16,16,14,16,16,16,0,20,20,20,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,40,40,40,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,4,8,4,4,4,4,4,5,5,5,5,5,4,4,5,5,29,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,1,1,21,30,30,30,30,30,30,21,30,21,25,2,2,2,2,3,3,3,3,36,36,36,45,45,35,35,46,46,46,1,1,25,31,25,25,31,0,0,46,1,1,31,31,1,1,1,25,36,36,36,36,36,36,0,1,1,31,1,1,31,0,0,38,38,38,38,1,0,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,14,14,14,1,14,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,18,16,20,18,20,20,16,16,16,16,16,16,13,13,13,13,13,16,13,18,14,14,14,18,16,16,20,20,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,40,40,40,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,8,4,4,4,8,5,5,4,4,4,4,5,5,29,29,1,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,30,21,21,21,21,21,21,21,21,2,2,2,2,3,3,3,36,36,36,36,45,45,1,46,46,1,1,46,1,31,25,25,0,0,0,0,1,1,31,31,1,1,1,1,1,36,36,36,36,36,1,1,1,1,1,1,1,0,0,38,38,38,38,25,25,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,26,26,14,14,14,14,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,20,20,26,20,16,16,16,16,16,14,14,18,16,18,13,16,0,18,16,16,14,0,18,18,20,20,20,20,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,40,40,40,40,40,40,40,40,8,40,8,8,8,40,8,8,8,8,8,8,8,8,8,8,4,4,8,8,8,4,4,4,4,5,4,4,4,5,4,1,5,5,29,1,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,30,30,21,21,21,21,21,21,2,2,2,2,2,2,3,3,3,36,36,36,36,45,45,31,46,31,1,46,1,31,25,25,0,0,31,46,46,31,31,31,31,41,41,1,1,36,36,36,36,36,36,0,42,1,1,31,1,1,32,32,38,38,38,25,25,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,26,26,14,14,14,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,20,18,26,18,18,14,16,14,14,16,14,18,18,16,18,18,18,18,16,14,14,14,20,20,20,20,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,40,40,40,40,40,40,40,40,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,4,4,4,8,8,4,8,8,4,4,4,4,4,4,5,4,4,5,29,29,1,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,30,21,21,21,21,21,21,21,2,2,2,2,3,3,3,3,36,36,36,36,45,45,31,46,31,0,0,1,1,25,25,0,0,46,46,31,31,31,48,31,31,31,41,1,41,36,36,36,36,36,47,42,42,1,1,31,1,32,38,38,38,25,25,25,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,26,26,16,14,14,14,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,20,18,26,16,18,14,14,18,14,16,16,18,18,16,28,18,18,16,16,14,18,14,1,20,20,20,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,40,8,40,8,40,40,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,4,4,8,4,4,4,8,8,8,8,8,4,4,5,4,5,4,4,1,29,29,1,21,21,21,21,21,21,21,21,21,5,5,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,2,2,2,2,2,3,3,3,3,3,36,36,36,36,45,31,46,49,49,49,46,1,48,25,0,31,46,46,46,46,46,48,31,31,31,31,41,41,41,36,36,36,36,36,0,42,1,1,1,1,0,38,38,25,25,1,1,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,14,14,16,14,14,14,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,20,20,18,16,18,20,20,18,14,16,16,18,28,28,16,18,16,16,16,18,18,18,20,20,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,40,40,8,8,8,8,8,8,4,4,4,8,4,4,8,8,8,8,8,4,4,4,4,4,5,4,4,4,29,4,4,4,21,21,21,21,21,21,21,4,5,5,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,2,2,2,2,2,3,3,3,3,3,36,36,36,36,45,31,46,49,49,49,46,46,48,48,31,31,31,31,46,46,46,48,48,48,48,46,46,46,46,41,25,36,36,36,36,42,1,1,1,1,0,0,38,38,0,1,1,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,14,14,16,16,14,14,14,1,25,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,20,18,16,18,18,18,18,18,18,16,20,28,18,16,16,16,16,18,14,0,20,20,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,40,40,8,8,8,8,8,8,8,8,8,8,4,4,4,4,8,4,8,8,4,4,4,4,4,4,4,5,4,4,29,4,21,21,21,21,21,21,21,5,5,5,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,2,2,2,2,2,3,3,3,3,3,3,36,36,36,45,31,46,31,49,49,49,46,48,48,48,31,31,46,31,46,46,31,46,46,48,31,46,46,46,46,46,35,36,36,36,42,1,1,1,31,0,0,38,38,0,1,25,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,14,14,14,16,50,50,14,14,1,1,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,20,18,16,16,16,18,18,0,18,18,16,28,18,0,14,14,16,1,14,20,20,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,51,51,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,4,8,4,4,8,4,4,8,8,4,4,4,4,4,4,4,4,4,4,29,21,21,21,21,21,21,21,5,5,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,2,2,2,2,2,2,3,3,3,3,36,36,0,49,49,31,46,49,49,49,49,31,31,48,46,31,46,31,49,49,49,46,46,46,46,46,31,31,46,46,46,35,35,35,35,1,31,38,1,0,0,38,38,0,0,25,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,14,14,14,14,14,50,50,14,14,14,1,0,3,1,1,0,14,14,3,3,3,3,3,3,3,3,3,3,20,20,28,28,18,18,28,28,14,18,16,28,16,14,16,14,18,1,14,20,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,40,8,8,8,8,8,8,8,8,8,8,8,4,8,4,4,4,8,4,4,8,8,4,4,4,4,4,4,4,4,4,4,29,21,21,21,21,21,21,4,5,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,2,2,2,2,2,2,2,3,3,3,36,36,49,49,49,31,46,46,0,46,49,46,31,31,46,46,46,49,49,31,49,49,46,46,46,46,46,31,46,35,46,35,35,35,35,35,38,38,1,0,0,38,0,31,0,0,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,14,14,14,14,14,14,14,50,50,14,14,14,14,26,26,14,14,14,14,0,3,3,3,3,3,3,3,3,3,3,18,20,28,28,13,26,13,28,28,28,18,15,16,16,16,14,0,20,20,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,4,4,8,4,8,4,8,4,4,4,8,8,8,4,4,4,4,4,4,4,4,29,0,21,21,21,21,21,5,5,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,2,2,2,2,2,2,2,2,3,3,3,36,36,36,45,45,31,31,46,46,46,31,46,31,31,46,49,49,46,46,46,49,49,49,31,46,46,46,46,46,31,31,31,31,31,31,35,38,38,1,31,31,0,31,31,1,25,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,14,14,1,14,14,14,14,50,50,14,14,14,14,14,26,26,14,14,14,1,1,3,3,3,3,3,3,3,3,3,3,0,20,16,28,28,13,13,13,28,28,15,16,1,14,14,20,20,20,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,4,8,8,8,4,4,8,8,8,4,8,4,8,8,8,4,4,4,4,4,4,1,29,0,21,21,21,21,5,5,5,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,2,2,2,2,2,2,2,2,3,3,3,36,36,36,45,45,31,31,31,31,49,49,46,31,31,49,31,49,46,46,46,49,31,49,31,46,46,31,46,48,48,31,31,31,31,31,0,38,38,1,31,31,31,31,31,1,36,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,14,14,14,14,14,50,50,50,14,14,14,14,14,14,14,14,14,0,0,1,0,3,3,3,3,3,3,3,3,3,3,3,20,16,16,18,13,13,28,28,15,15,16,14,14,1,20,20,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,51,51,51,3,3,3,51,51,51,51,51,51,51,51,51,51,51,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,4,8,8,4,4,4,8,8,4,8,4,4,4,4,4,29,29,29,29,29,29,5,5,5,5,5,21,21,21,21,21,21,21,21,21,21,21,21,21,2,2,2,2,2,2,2,2,3,3,3,36,36,36,52,45,45,31,31,49,49,46,46,31,31,49,46,46,49,49,49,49,49,31,31,46,31,31,31,48,48,46,46,46,31,31,31,0,38,31,1,31,31,1,31,25,36,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,0,14,14,14,1,3,3,3,3,3,3,3,3,3,3,3,20,16,16,14,13,13,28,15,15,18,16,14,16,20,20,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,3,51,51,51,51,51,51,3,3,3,51,51,51,51,51,51,51,51,51,51,51,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,8,8,4,4,4,8,8,8,4,4,4,4,4,4,4,4,29,29,29,29,5,5,21,4,5,21,21,21,21,21,21,21,21,21,21,21,21,21,2,2,2,2,2,2,2,2,3,3,3,36,36,36,1,49,49,0,49,46,46,46,31,31,48,49,46,46,49,49,49,49,49,31,31,46,31,31,48,31,31,31,31,46,46,31,31,0,0,31,1,31,1,1,31,1,36,36,36,36,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,16,16,16,14,14,14,14,14,14,16,14,14,14,14,14,14,14,14,14,14,14,0,14,14,3,3,3,3,3,3,3,3,3,3,1,20,20,18,13,13,28,1,16,18,18,16,16,18,20,20,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,51,51,51,51,51,51,51,51,51,51,51,51,51,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,8,8,8,8,4,4,8,8,8,8,4,4,4,4,4,4,4,4,29,29,29,29,5,5,5,5,1,30,30,30,1,21,21,21,21,21,21,21,21,2,2,2,2,2,2,2,2,3,3,3,36,36,36,36,25,49,49,49,31,46,46,48,31,48,49,46,46,49,49,49,35,45,31,31,46,31,31,48,48,48,48,31,31,46,46,31,31,31,31,31,31,1,31,31,0,36,36,36,36,31,31,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,16,16,16,16,16,14,14,14,14,14,14,16,14,14,14,14,14,14,14,1,14,14,14,26,26,26,3,3,3,3,3,3,3,3,3,3,3,0,20,20,13,13,20,26,0,1,18,18,18,1,0,20,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,3,53,51,53,53,53,53,0,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,4,8,8,8,8,8,4,8,8,4,4,8,4,4,4,4,4,4,4,4,7,29,29,29,5,5,5,5,5,30,30,30,21,21,21,21,21,21,21,21,2,2,2,2,2,2,2,2,3,3,3,36,36,36,36,36,25,49,49,31,46,46,48,48,31,46,45,46,31,31,31,46,31,46,46,46,31,48,31,48,48,48,31,31,46,0,0,46,46,31,31,31,31,31,31,31,36,36,36,36,31,31,54,54,25,25,25,25,25,25,3,3,3,3,3,16,16,16,16,16,26,26,1,14,14,14,14,16,16,16,14,14,14,14,14,14,14,14,0,14,14,26,26,26,26,26,3,3,3,3,3,3,3,3,3,3,18,20,13,13,3,0,20,20,20,20,1,20,20,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,1,53,53,53,53,53,53,53,53,55,53,53,0,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,4,4,8,4,4,4,4,4,4,4,4,7,7,29,29,5,5,5,4,5,30,1,1,1,1,21,21,21,21,21,21,2,2,2,2,2,2,2,2,2,3,3,3,36,36,36,36,36,1,49,31,31,46,46,31,48,46,46,46,46,31,31,31,31,46,31,31,31,48,48,49,48,48,31,31,0,0,49,46,46,46,46,31,48,31,48,31,36,36,36,36,31,31,1,1,1,14,14,0,16,50,50,50,50,0,16,16,16,16,16,26,26,0,26,14,14,14,16,16,16,16,16,16,14,14,14,14,14,14,28,28,14,28,28,28,28,26,1,1,3,3,3,3,3,3,3,3,3,0,1,3,3,3,3,3,1,20,20,20,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,3,53,53,53,53,53,53,53,55,55,55,55,55,55,55,53,53,55,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,8,4,4,4,8,4,4,4,4,4,4,7,5,5,5,5,5,5,5,4,1,0,30,30,30,21,21,21,21,21,2,2,2,2,2,2,2,2,2,3,3,3,3,36,36,36,36,36,0,45,45,31,46,31,48,48,46,46,46,31,46,46,46,31,31,31,31,31,45,48,48,48,48,0,0,46,49,49,46,46,46,31,48,1,1,31,36,36,36,36,36,31,31,1,14,14,14,0,50,50,50,50,50,14,16,22,16,16,16,22,26,26,26,19,14,14,16,16,16,16,16,16,16,14,14,14,14,14,14,28,0,28,28,28,28,28,14,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,53,53,53,53,53,53,56,56,55,55,55,55,55,57,57,57,55,55,53,53,55,55,53,53,25,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,8,4,4,4,4,8,4,4,4,4,4,7,5,5,5,5,5,5,5,5,5,30,30,30,30,30,21,21,21,21,2,2,2,2,2,2,2,2,2,3,3,3,3,36,36,36,36,36,36,36,45,45,46,46,46,31,46,46,46,46,31,46,46,46,31,31,31,31,31,31,48,48,48,48,48,0,0,49,48,46,46,45,48,1,1,31,36,36,36,36,36,31,31,1,14,14,14,0,50,50,50,14,0,14,14,22,22,22,22,22,26,26,26,19,19,19,14,16,16,16,16,16,14,14,14,14,14,14,14,14,14,1,1,28,28,28,14,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,53,53,53,53,53,53,53,55,55,55,55,55,57,57,57,57,57,57,55,55,55,55,55,55,53,53,25,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,4,4,8,4,4,8,8,0,4,4,4,4,4,4,7,7,5,5,5,4,5,30,30,30,30,30,21,21,21,21,2,2,2,2,2,2,2,2,2,2,3,3,3,3,36,36,36,36,36,36,36,0,46,46,46,46,46,46,46,46,46,46,46,46,31,31,31,31,31,31,31,31,48,48,48,48,48,48,48,48,48,48,48,48,1,31,36,39,36,36,36,31,1,1,13,0,0,16,16,0,0,0,0,26,14,14,22,22,22,22,22,22,26,26,19,19,14,16,16,16,14,14,14,14,14,14,14,28,14,14,14,14,14,14,0,14,14,14,14,14,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,53,53,53,53,53,53,53,55,55,55,55,55,57,57,57,57,57,57,55,55,55,55,58,55,55,55,55,53,53,53,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,4,4,8,8,8,1,4,4,4,4,7,4,7,5,5,5,5,0,30,30,30,30,30,30,21,21,21,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,36,36,36,36,36,36,36,46,46,46,46,31,31,46,31,46,35,35,35,35,35,31,31,31,31,31,31,48,48,48,48,48,48,48,48,48,48,48,31,31,36,36,36,36,36,36,31,31,1,1,14,0,0,26,0,0,0,16,22,22,14,22,22,16,16,22,22,22,19,19,19,0,16,16,0,14,14,14,14,14,14,28,28,28,14,14,14,14,14,14,1,14,14,0,0,14,14,14,1,1,0,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,53,53,53,53,55,55,55,55,55,55,55,59,59,56,55,55,55,55,55,55,57,57,57,57,57,58,58,55,55,55,55,55,53,1,51,51,51,51,3,3,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,8,8,8,4,4,4,4,7,7,7,5,5,5,5,5,30,30,30,30,0,30,30,21,21,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,36,36,36,36,36,36,1,46,46,46,0,46,46,46,46,46,46,46,46,46,46,46,31,31,0,31,32,32,0,0,49,48,48,45,48,48,31,31,36,36,36,36,36,36,31,31,31,1,50,0,0,19,0,0,16,16,16,22,22,22,22,22,22,22,22,14,14,14,14,19,16,0,1,1,14,14,28,28,28,14,14,14,14,14,14,14,14,14,14,14,1,1,1,14,14,14,14,14,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,53,53,53,53,53,55,55,55,55,55,55,56,59,56,59,59,55,55,59,59,55,55,55,55,55,55,58,58,58,58,55,55,55,53,53,53,51,51,51,51,51,3,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,4,7,7,5,5,5,5,5,30,30,30,30,30,30,30,21,21,21,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,36,36,36,36,36,36,47,1,46,46,46,46,46,46,46,46,46,46,46,46,46,0,0,35,32,35,32,0,31,31,0,0,45,48,48,31,31,36,36,36,36,36,36,31,31,1,1,14,50,16,50,0,19,19,16,16,16,22,22,16,16,0,22,22,14,14,14,14,14,14,14,1,1,14,14,28,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,1,14,14,14,14,14,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,0,53,55,55,55,55,55,55,59,59,59,55,56,59,56,59,59,59,59,59,59,59,55,55,55,55,55,55,55,58,58,55,55,55,55,53,53,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,4,4,7,1,5,5,5,5,5,30,30,30,30,30,30,21,21,21,21,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,36,36,36,36,36,36,1,47,47,36,36,36,36,36,36,36,36,36,36,0,25,25,0,0,32,0,31,38,0,48,48,48,48,31,31,36,36,36,36,36,36,31,31,1,14,14,14,50,50,50,50,19,16,25,16,16,22,26,16,25,22,22,14,14,14,28,14,14,14,14,0,14,14,14,14,14,14,14,14,14,14,14,14,14,14,17,17,14,14,14,14,14,0,14,14,14,14,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,53,53,53,55,55,59,55,55,59,59,59,59,59,59,59,56,59,59,59,59,59,59,59,59,55,55,55,55,55,55,55,58,58,55,55,55,53,55,51,51,55,55,53,1,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,40,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,4,4,7,6,6,5,5,5,5,5,5,30,30,30,30,30,1,21,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,1,0,0,0,0,0,38,38,0,35,48,48,31,31,36,36,39,36,36,36,36,31,31,1,31,14,14,14,50,14,50,14,16,16,18,16,26,26,16,16,1,22,16,14,14,14,25,14,28,0,1,14,14,14,14,14,16,14,14,14,14,14,14,14,17,17,17,14,14,14,14,14,14,14,14,14,14,14,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,53,53,55,55,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,55,55,55,55,55,55,55,55,58,55,55,55,53,53,51,51,55,53,53,53,53,53,53,53,53,0,51,51,51,51,51,53,51,51,51,51,51,51,51,51,51,51,51,51,51,3,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,4,7,7,7,6,5,7,5,5,5,5,5,30,30,30,30,30,30,21,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,1,0,1,0,1,38,1,35,48,48,31,31,36,36,39,36,36,36,36,31,31,1,1,14,0,14,0,0,14,14,14,18,16,25,16,26,16,16,16,25,16,14,14,14,14,14,0,0,14,14,14,14,14,16,16,16,14,14,17,17,17,17,17,17,17,14,14,14,14,14,14,1,14,14,14,14,14,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,53,25,55,55,55,56,59,59,59,59,59,59,59,59,55,59,59,59,55,59,59,59,59,59,59,59,59,59,59,55,55,55,55,55,55,55,55,55,53,53,53,53,53,55,53,53,53,53,53,55,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,51,3,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,40,40,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,4,7,7,6,6,6,5,5,7,5,5,5,30,30,30,30,30,30,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,36,36,36,36,36,3,3,3,3,3,36,36,36,36,36,36,36,36,0,0,1,0,1,1,48,48,31,36,36,36,39,36,36,36,36,31,60,31,1,1,0,0,50,0,50,14,14,14,14,14,15,16,15,16,0,16,25,14,14,50,14,14,28,28,28,14,14,14,16,16,16,16,14,14,14,14,14,14,17,14,14,14,14,14,14,14,16,14,14,14,1,1,14,14,14,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,53,55,55,55,56,59,59,55,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,53,55,55,53,55,53,55,55,55,55,55,55,55,55,55,53,53,53,25,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,40,40,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,8,8,7,7,6,6,6,5,5,7,5,5,5,5,30,30,30,30,30,30,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,36,36,36,3,3,3,3,3,3,3,3,36,36,36,36,36,36,36,1,1,25,0,48,48,31,31,36,36,36,36,36,36,36,36,31,31,1,1,1,50,14,14,50,50,19,14,14,14,14,14,15,16,16,16,25,16,14,14,50,50,28,28,28,14,14,14,16,14,16,16,16,16,16,16,14,14,14,17,14,14,14,14,14,14,16,16,16,16,14,14,1,16,16,14,14,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,53,55,55,55,59,56,59,59,59,55,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,55,55,59,59,55,55,55,59,55,59,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,53,1,25,8,8,8,8,8,8,8,8,40,40,8,8,40,40,40,8,8,8,8,8,8,40,40,8,8,8,8,8,8,40,40,8,8,8,8,40,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,4,7,7,7,6,5,5,5,5,5,5,5,5,1,30,30,30,30,30,30,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,36,36,36,36,36,36,36,36,0,0,31,31,31,36,36,36,36,36,36,36,36,31,48,1,1,1,50,14,14,14,50,50,19,14,14,14,19,19,15,15,16,18,1,1,16,14,50,50,50,28,14,14,14,14,14,16,16,16,16,16,16,16,14,14,17,14,14,14,14,14,14,14,16,16,16,16,16,1,0,16,16,14,14,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,53,25,55,55,55,59,59,59,59,59,59,59,59,59,59,55,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,55,55,55,55,59,59,59,59,59,59,59,55,59,59,59,59,59,55,55,55,55,55,55,55,55,55,25,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,8,8,8,8,40,40,8,8,40,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,4,4,4,4,8,7,7,7,7,4,5,5,7,5,5,5,5,0,1,30,30,30,30,30,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,36,36,36,36,36,36,36,1,0,31,36,36,36,36,36,39,36,36,36,31,0,0,1,1,50,14,14,14,14,14,14,14,19,19,19,19,19,15,16,16,18,0,1,1,14,50,14,14,14,14,14,14,14,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,16,16,16,16,16,14,1,16,16,14,14,14,14,14,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,53,53,55,55,55,55,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,55,55,55,55,55,55,55,55,25,8,8,8,8,8,8,8,40,40,40,40,40,40,40,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,4,4,4,7,7,7,7,7,7,5,4,7,7,5,5,5,5,1,30,30,30,30,30,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,36,36,36,36,0,36,36,36,36,36,36,39,36,36,36,36,31,1,1,1,1,50,14,14,50,50,14,14,19,19,19,19,19,19,18,18,18,18,18,1,14,14,14,14,14,14,14,14,14,14,14,14,14,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,16,16,16,16,16,16,16,0,16,16,16,14,14,14,14,14,14,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,53,53,55,55,55,55,55,59,55,55,59,59,59,59,59,59,59,59,59,59,55,55,55,56,56,59,59,59,59,59,55,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,55,59,59,59,59,59,59,59,55,55,55,55,55,55,55,1,8,8,8,8,8,8,8,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,40,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,4,8,4,8,7,8,7,7,7,4,4,4,5,7,5,5,5,5,5,30,30,30,30,1,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,36,36,36,0,36,36,36,36,36,36,36,36,36,36,36,31,1,0,0,1,1,1,1,50,19,50,19,19,19,19,19,19,19,19,18,18,18,18,0,14,14,14,14,14,14,14,14,14,16,14,16,16,16,14,16,16,14,14,14,14,14,14,14,14,14,16,16,14,14,16,16,16,16,0,16,16,16,16,0,16,16,16,1,14,14,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,53,53,55,55,55,55,55,55,56,56,59,59,59,55,55,56,55,59,55,55,56,56,55,55,55,55,59,59,55,55,55,55,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,55,55,55,55,55,55,55,55,8,8,8,8,8,8,8,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,7,7,7,8,7,7,4,4,4,5,5,7,5,5,5,5,30,30,30,30,30,21,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,36,36,36,39,39,36,36,36,36,36,36,36,36,36,36,1,1,0,1,1,1,1,50,50,50,50,19,19,19,18,19,19,18,18,25,18,18,18,14,14,14,14,14,14,14,14,14,16,16,14,14,16,16,16,16,14,14,14,14,14,14,14,14,14,14,16,16,14,14,16,16,16,16,16,16,16,0,14,14,16,16,14,14,14,3,3,3,1,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,53,53,53,53,25,55,55,55,55,55,55,55,55,55,56,56,56,55,55,55,55,61,61,55,61,61,61,61,61,61,61,55,55,55,55,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,55,55,55,55,55,55,55,55,8,8,8,40,8,8,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,40,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,7,7,7,8,4,4,4,4,5,5,4,5,5,5,5,30,30,30,30,30,21,21,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,36,36,36,36,39,36,36,36,36,36,36,36,36,36,62,62,1,1,1,1,1,1,19,50,50,50,19,0,19,19,19,19,19,19,19,18,18,18,18,0,14,14,17,17,14,14,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,16,16,14,14,14,16,16,16,16,16,16,16,16,14,14,1,14,0,14,14,3,3,1,14,14,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,25,53,53,53,25,55,55,55,55,55,55,55,55,55,55,55,55,55,55,61,61,61,61,61,61,61,61,55,61,55,55,55,55,55,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,55,55,59,59,59,55,55,55,55,55,55,55,8,8,40,40,40,40,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,8,7,7,8,4,4,4,4,5,5,4,5,5,5,5,30,30,30,30,30,21,21,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,63,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,36,36,36,36,36,36,36,36,36,36,36,36,36,62,62,62,1,1,0,1,1,1,19,19,50,19,19,19,19,19,19,19,19,19,19,19,19,18,18,0,1,17,17,17,14,14,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,16,16,14,14,14,16,16,16,16,14,1,16,16,14,14,14,14,1,14,3,1,0,14,0,14,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,53,53,55,55,55,55,55,55,55,61,61,61,61,55,55,55,55,61,61,61,61,61,61,55,56,56,65,65,55,55,55,55,59,59,59,59,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,59,55,55,55,55,55,55,55,55,8,8,40,40,40,40,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,40,40,40,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,8,8,7,7,8,8,8,8,4,4,5,5,5,5,5,5,5,30,30,30,30,21,21,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,66,63,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,64,36,36,36,36,36,36,36,36,36,36,36,62,62,62,62,62,0,0,0,1,1,0,0,19,19,19,19,19,19,19,18,19,19,19,18,19,19,19,14,14,14,17,14,17,17,17,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,16,16,16,16,14,14,14,16,16,16,16,16,16,1,22,22,14,14,14,14,14,14,14,14,0,1,14,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,0,14,25,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,53,53,55,55,55,55,61,61,61,61,67,67,61,61,55,55,61,61,55,55,55,55,55,56,55,65,65,65,65,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,59,59,55,55,55,55,55,55,55,55,55,55,8,8,40,40,40,40,40,8,8,40,40,40,40,40,8,8,8,8,8,8,40,40,40,40,8,8,8,8,40,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,7,8,7,7,4,8,4,4,4,4,4,5,5,5,5,5,30,30,30,21,1,21,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,63,63,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,64,36,36,36,36,36,36,36,36,36,68,62,62,62,60,62,0,0,0,0,0,0,0,19,19,22,19,19,19,22,19,19,19,19,19,19,18,19,14,14,14,14,17,14,17,17,14,14,14,14,14,14,14,17,17,14,14,14,14,14,14,14,14,16,16,16,16,16,16,14,14,14,16,16,16,16,22,22,22,22,14,14,14,14,14,14,14,14,14,14,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,0,3,3,14,14,25,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,53,53,1,55,55,55,67,67,67,61,61,61,61,55,55,55,61,55,55,56,56,56,56,56,55,55,55,65,65,65,55,55,55,55,55,55,55,55,61,61,61,61,61,61,56,56,55,55,59,55,55,55,55,55,59,55,55,55,55,55,8,40,40,40,8,40,8,8,8,8,40,40,40,40,40,40,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,8,8,7,7,7,4,4,8,4,4,4,4,4,5,5,5,5,30,30,30,30,30,0,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,64,36,36,36,36,36,36,36,68,49,49,62,62,62,62,62,62,62,0,0,0,0,13,19,19,19,19,22,22,22,19,19,19,19,18,18,19,14,14,14,14,14,17,17,14,14,14,14,14,14,14,14,17,14,17,17,17,14,14,14,17,17,17,17,17,17,17,17,14,14,14,14,16,16,16,16,22,22,22,1,14,14,14,14,14,14,14,1,14,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,0,0,0,0,14,1,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,53,53,53,55,55,55,55,55,61,61,55,61,61,55,61,61,55,55,55,56,56,56,56,56,65,65,65,55,65,65,55,55,55,55,61,61,61,61,61,61,61,61,56,56,56,59,59,55,55,61,61,55,59,59,59,55,55,55,25,8,8,40,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,8,8,7,7,4,4,4,8,4,4,4,4,4,5,5,5,5,30,30,30,30,1,21,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,64,36,36,36,36,36,25,49,49,49,49,62,62,62,62,25,62,62,1,62,13,13,13,13,13,13,13,13,13,13,13,19,19,0,18,19,14,14,14,14,16,16,14,14,14,14,14,14,14,14,14,17,17,17,17,17,17,17,1,1,25,17,0,25,25,17,17,17,14,14,28,16,16,16,16,16,16,22,22,0,14,14,14,14,22,1,0,14,14,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,14,14,14,1,0,14,14,0,14,14,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,53,53,55,55,55,55,55,55,61,61,55,55,61,55,61,55,55,55,55,55,55,55,55,56,56,55,65,65,55,65,65,55,55,55,61,61,61,61,61,61,61,55,56,56,59,59,56,55,55,61,55,55,59,59,59,59,55,55,25,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,8,4,4,4,4,4,4,8,4,4,4,4,5,5,5,5,1,30,30,30,30,0,21,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,64,36,36,36,36,64,64,64,64,64,64,49,62,62,25,62,62,62,25,62,13,13,13,13,13,13,13,13,19,19,13,19,0,19,19,14,14,16,16,16,16,16,14,14,14,14,14,14,14,14,14,17,17,17,14,17,17,17,17,17,17,14,14,14,14,14,14,14,14,14,28,28,16,16,16,16,22,22,14,14,22,22,22,14,14,14,1,14,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,0,14,14,0,14,14,14,0,1,14,14,0,0,0,14,14,0,1,3,3,3,3,3,3,3,51,51,53,53,53,53,55,55,55,65,61,61,61,55,55,55,61,61,61,61,55,57,57,55,55,56,56,56,56,55,55,55,65,55,65,65,55,65,65,55,55,55,55,55,55,59,59,59,55,55,56,61,61,61,55,55,59,59,59,59,55,55,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,40,40,40,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,8,4,4,4,8,4,4,4,4,4,4,4,5,5,5,5,1,30,30,30,30,1,30,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,63,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,64,64,64,64,64,3,3,3,3,3,64,64,49,62,25,62,62,62,62,62,62,62,62,19,19,25,25,1,19,13,19,19,19,0,14,14,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,17,17,17,14,17,17,14,17,14,14,14,14,14,14,14,14,14,14,14,28,16,16,16,16,16,1,0,22,22,22,22,22,0,14,1,14,14,0,1,3,3,3,3,3,3,3,3,3,3,3,0,14,0,14,14,14,14,14,14,14,14,14,0,0,0,0,14,14,3,3,3,3,3,3,3,51,51,53,53,53,53,56,56,55,55,65,61,65,55,55,55,61,53,53,55,55,55,57,57,55,55,55,56,55,55,55,53,53,55,65,65,65,65,65,65,65,65,55,55,55,55,56,59,56,55,55,61,61,61,61,55,55,55,59,59,59,55,55,55,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,8,8,8,8,8,8,4,8,8,4,4,4,5,5,5,5,0,1,30,30,30,30,0,30,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,63,66,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,49,49,49,1,62,62,25,62,62,25,62,62,62,19,19,19,13,13,13,25,19,19,1,14,16,16,16,16,13,16,14,13,14,14,14,14,14,14,14,14,14,17,14,14,16,14,14,14,14,14,14,14,14,14,14,14,14,14,16,28,28,16,16,26,26,22,22,22,22,22,22,14,14,14,1,14,14,0,3,3,3,3,3,3,3,3,1,1,0,14,14,14,14,14,1,14,14,14,0,14,14,14,14,14,14,14,3,3,3,3,3,3,3,51,51,53,53,53,56,56,56,55,55,55,55,55,55,55,55,55,61,57,53,53,53,53,53,53,57,55,55,55,55,55,55,53,53,53,55,65,65,65,65,65,65,65,65,55,55,55,55,56,55,55,55,61,55,61,55,55,55,55,59,59,59,59,55,55,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,40,40,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,8,8,4,4,4,8,8,4,4,4,4,5,5,5,5,5,5,30,30,30,30,30,30,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,69,63,63,63,63,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,49,49,49,62,62,62,62,62,62,62,25,19,13,25,13,13,19,19,19,19,19,1,14,16,16,16,16,13,14,13,13,14,14,14,14,16,22,22,16,16,22,22,26,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,16,28,28,26,26,26,26,26,22,22,22,1,14,14,14,14,14,14,14,3,3,3,3,3,0,3,3,0,14,14,14,1,0,14,14,14,14,1,14,1,14,0,1,1,3,3,3,3,3,3,3,3,3,51,51,53,53,53,53,53,55,55,61,61,55,55,55,56,56,56,56,56,61,57,55,57,57,55,57,53,57,55,55,55,55,53,53,55,55,65,65,65,65,65,55,55,55,65,55,55,55,55,55,55,61,61,61,61,61,55,55,55,55,55,59,59,55,55,55,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,8,8,8,8,8,8,40,40,8,8,40,40,40,40,8,40,8,40,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,4,4,4,4,8,8,4,7,4,4,5,5,5,5,5,5,0,30,30,30,30,1,30,21,21,21,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,63,66,63,63,63,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,49,49,49,62,62,62,25,25,19,13,13,13,13,19,19,19,19,19,13,0,19,0,0,16,16,16,14,13,13,13,13,14,14,14,14,16,16,22,22,16,16,22,26,26,16,16,16,16,14,14,14,14,14,14,14,14,14,14,16,28,28,26,22,26,26,26,22,22,22,1,14,14,14,14,14,14,1,14,14,14,3,1,1,0,0,0,14,14,0,0,0,1,0,1,25,14,14,14,0,0,3,3,3,3,3,3,3,3,3,3,51,51,53,53,53,53,53,55,55,55,61,61,55,56,56,56,56,56,56,55,55,61,53,53,65,53,53,53,53,61,61,55,55,55,65,55,65,65,55,55,55,55,55,55,55,55,55,55,55,55,55,55,61,61,55,55,55,55,55,55,55,55,55,55,55,55,55,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,40,8,40,40,40,40,40,8,8,40,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,4,4,4,4,8,8,4,7,7,5,5,5,5,5,5,5,1,30,30,30,30,1,30,21,21,21,2,2,2,2,2,3,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,63,63,63,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,49,25,62,62,62,62,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,16,16,16,16,13,13,13,13,13,13,14,14,16,16,16,16,16,22,22,22,22,22,26,16,16,16,25,14,14,14,14,14,14,14,14,14,14,28,0,26,22,22,22,22,22,22,22,0,14,1,14,14,14,14,14,14,14,14,14,0,0,14,0,0,0,0,25,0,0,0,3,3,3,0,3,25,0,0,3,3,3,3,3,3,3,3,3,51,3,53,53,53,56,61,55,55,55,55,55,55,55,56,56,56,56,56,56,61,61,55,61,57,65,65,61,61,61,61,55,61,61,61,65,55,55,58,58,55,58,58,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,40,40,8,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,8,4,4,8,4,4,4,8,8,4,7,4,7,5,7,5,5,5,5,5,1,30,30,30,30,30,30,21,21,21,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,49,0,62,1,62,62,19,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,1,16,16,16,16,13,13,13,16,14,14,14,14,16,17,17,17,17,17,17,17,16,16,16,16,16,25,16,16,22,22,22,22,14,14,14,14,28,25,22,22,22,22,22,22,22,22,0,14,14,1,0,1,0,14,14,14,0,0,14,14,14,14,1,0,0,1,3,1,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,53,53,53,53,56,56,55,55,56,55,61,61,55,55,56,56,56,56,56,55,61,61,61,61,61,61,61,61,61,57,55,61,55,55,58,58,58,58,58,58,58,58,58,58,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,4,4,8,4,8,8,4,4,7,5,7,5,5,5,5,5,5,0,30,30,30,30,30,30,21,21,21,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,49,1,62,0,62,62,62,62,62,62,62,62,62,62,62,0,19,19,13,13,13,13,13,13,13,13,16,16,13,16,16,16,14,14,14,17,13,25,17,17,26,26,0,16,16,16,16,16,16,16,16,22,22,22,22,14,14,14,14,22,28,22,22,22,22,22,22,22,22,22,1,14,14,14,14,14,14,1,1,0,14,1,14,14,0,0,1,3,3,3,14,14,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,3,53,53,53,56,56,56,56,56,56,61,61,61,65,55,55,56,56,56,61,55,55,55,61,65,65,65,65,65,61,65,65,65,65,58,58,65,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,25,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,8,4,4,4,8,8,8,8,4,4,7,5,5,5,5,5,5,5,5,0,30,30,30,30,30,21,21,21,21,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,63,69,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,49,0,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,25,19,19,62,0,25,13,13,13,13,13,13,16,16,17,17,17,16,13,13,13,13,13,0,26,26,1,16,16,16,16,1,22,22,22,22,22,14,14,22,14,14,22,22,22,22,22,22,22,22,22,22,22,22,16,16,16,16,16,14,14,14,14,0,0,14,1,0,3,3,3,3,3,14,14,3,3,3,51,3,3,3,3,3,3,3,3,3,3,51,51,53,53,53,53,61,55,61,61,55,56,65,65,65,65,55,55,56,61,61,61,55,65,61,65,65,65,61,61,55,55,65,55,55,58,58,65,55,25,53,53,53,53,53,25,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,25,25,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,4,4,4,4,8,8,8,4,4,7,7,5,5,5,5,5,5,5,30,30,30,30,30,30,30,30,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,69,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,49,1,62,62,62,62,62,62,62,62,62,62,1,70,70,70,62,62,62,62,62,62,62,1,25,13,13,13,13,13,1,17,17,17,13,13,13,13,13,13,25,1,26,26,16,16,16,16,22,22,22,28,22,22,14,22,22,22,25,22,22,22,22,22,22,22,22,22,22,22,16,16,16,16,16,14,14,14,14,0,1,14,1,25,0,3,3,3,3,3,0,3,3,51,51,51,51,51,3,3,3,3,3,3,3,51,51,53,53,53,55,56,55,61,61,56,55,55,58,58,58,58,58,55,56,56,55,55,55,55,55,55,61,55,55,55,56,56,55,55,55,55,55,55,55,53,53,53,53,53,53,53,53,53,53,53,53,53,55,55,55,55,55,55,55,55,55,55,55,55,25,53,53,53,53,53,25,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,4,4,4,8,8,8,4,4,5,7,5,5,5,5,5,1,1,30,30,30,30,30,30,30,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,49,0,62,62,62,62,25,62,25,1,25,70,70,70,70,70,70,70,70,62,62,62,62,62,62,0,0,25,13,13,17,17,17,17,17,13,16,13,13,13,17,17,0,26,16,16,22,22,22,22,22,28,28,22,14,22,22,22,26,26,22,22,26,22,22,26,22,22,22,22,22,22,22,1,14,16,14,14,0,14,14,14,0,25,1,3,3,3,3,3,3,3,51,51,1,53,53,51,3,3,3,3,3,3,3,51,0,53,53,55,55,56,61,61,61,55,58,58,58,55,65,55,65,55,56,56,55,55,55,55,55,61,55,55,55,55,55,56,55,55,55,55,55,55,53,53,53,53,51,51,51,51,51,51,51,51,53,53,53,53,55,55,55,55,55,55,55,55,55,53,53,53,53,51,51,51,25,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,8,4,4,4,8,4,4,4,7,5,5,5,5,5,1,1,30,30,30,30,30,30,30,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,49,62,62,62,62,1,62,62,0,61,70,70,70,70,70,70,70,71,56,70,70,70,70,62,62,62,62,3,1,13,13,25,17,17,17,17,17,17,17,17,17,17,17,17,26,16,22,22,22,22,28,28,22,14,14,22,22,22,26,22,26,26,22,22,22,22,22,22,22,22,22,22,22,22,0,25,14,16,16,1,1,14,14,1,0,3,3,3,3,51,3,51,0,53,53,53,53,51,51,3,3,3,3,3,51,51,53,53,55,55,55,61,61,55,55,55,55,58,58,55,55,55,65,65,56,56,56,55,55,55,56,61,61,61,55,56,56,55,55,55,55,55,53,53,53,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,53,53,53,55,55,55,55,53,53,53,51,51,51,51,51,51,51,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,4,4,4,4,4,7,5,5,5,5,5,1,30,30,30,30,30,30,30,30,1,21,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,0,62,62,62,62,62,62,0,70,70,71,70,70,59,59,59,70,70,70,71,70,59,70,70,62,62,62,62,13,13,13,17,17,17,17,17,17,17,1,17,25,25,0,0,17,17,22,22,22,22,22,22,22,22,28,22,22,22,26,26,22,22,22,22,22,22,22,22,22,22,22,22,22,22,16,16,16,16,14,28,0,14,1,3,3,3,3,3,3,51,3,51,53,53,53,53,53,53,51,51,51,51,51,51,51,25,53,25,55,55,61,61,55,55,55,55,57,57,57,55,55,55,55,53,53,56,55,55,55,55,56,56,61,61,56,56,55,55,55,25,53,53,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,53,53,53,53,53,53,53,51,51,51,51,51,51,51,3,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,40,72,72,72,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,40,8,8,8,8,8,8,4,4,8,8,4,4,4,4,4,5,7,5,5,5,5,1,30,30,30,30,30,30,30,30,1,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,49,49,0,62,25,62,62,61,70,70,70,70,73,73,73,59,59,59,59,59,59,59,59,59,70,70,70,62,62,1,13,13,17,17,17,16,17,17,17,16,13,13,17,17,22,17,22,22,26,26,22,22,22,22,22,28,28,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,16,22,25,28,28,14,0,1,3,3,3,3,3,3,3,3,3,25,53,53,53,53,53,53,53,53,53,53,53,53,53,25,55,55,61,61,55,55,53,53,53,53,61,61,61,55,53,53,53,53,55,55,55,55,61,61,61,56,61,55,55,55,55,25,53,53,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,8,8,8,40,40,40,8,8,8,8,8,8,8,8,40,40,40,40,8,8,40,40,40,40,40,40,72,72,72,40,40,40,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,40,8,8,8,8,8,8,4,4,4,8,8,4,4,4,4,4,7,5,5,5,5,0,30,30,30,30,30,30,30,30,0,30,21,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,49,49,62,62,62,62,61,61,61,25,71,56,61,59,59,59,59,59,59,59,59,59,59,59,70,70,70,70,62,62,25,13,13,25,25,16,16,13,13,13,13,13,13,22,25,22,17,17,22,26,13,22,22,22,22,22,28,28,28,28,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,14,14,14,1,3,3,3,3,3,3,3,51,3,3,51,51,51,51,53,53,53,53,53,53,53,53,53,55,61,61,61,55,55,55,53,53,55,61,61,57,57,57,57,57,53,53,53,55,55,55,61,55,61,61,61,55,55,55,55,53,53,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,3,3,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,8,8,8,8,40,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,40,40,40,40,40,72,72,72,72,40,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,4,4,8,4,4,4,4,4,4,5,5,5,5,5,0,1,30,30,30,30,1,0,30,0,30,21,21,21,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,49,62,62,62,62,59,56,59,73,73,73,59,59,59,56,59,59,59,59,59,59,59,59,59,59,70,70,70,62,62,25,13,13,17,16,16,16,13,16,25,17,17,22,13,22,17,22,17,22,13,26,22,22,22,14,16,16,16,16,14,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,28,28,14,14,25,14,3,3,3,3,3,3,3,51,3,3,51,51,51,53,53,56,53,53,53,61,61,61,61,61,61,56,55,55,55,53,61,61,61,55,55,55,55,57,53,53,55,55,61,61,61,61,61,61,61,55,55,55,55,25,53,51,51,51,51,51,51,51,51,51,51,51,51,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,8,8,8,40,40,40,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,40,40,40,8,72,72,72,72,8,8,8,8,8,8,8,8,8,40,8,8,8,8,40,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,4,8,4,4,8,4,8,8,8,5,5,5,5,5,1,30,30,30,30,1,1,30,1,30,21,21,21,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,64,64,64,25,61,56,59,59,59,73,59,59,59,59,59,59,56,59,59,59,73,73,59,59,59,59,59,59,70,70,62,17,13,25,17,16,13,13,17,13,17,0,17,13,13,22,13,13,13,13,26,26,26,22,14,16,14,16,16,16,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,22,28,0,14,1,25,14,1,3,3,3,3,3,3,0,51,51,51,51,53,53,56,56,56,61,61,61,61,61,61,56,56,56,56,56,53,55,55,61,61,61,55,61,61,61,61,61,61,61,55,55,55,55,61,55,55,55,55,55,53,51,51,51,51,51,51,51,51,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,40,40,8,40,40,40,40,40,40,40,8,8,72,72,72,72,8,8,8,8,8,8,8,8,40,8,8,8,8,8,40,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,8,8,8,8,8,5,5,5,5,1,0,30,30,30,30,1,1,30,30,21,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,64,64,70,70,59,59,59,73,59,59,70,70,70,70,70,70,70,74,73,73,73,59,59,59,59,59,59,70,62,62,16,13,25,13,13,13,13,13,17,17,0,13,13,13,13,13,13,17,22,26,26,26,22,14,16,16,28,28,16,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,28,0,14,25,0,14,0,3,3,3,3,3,3,3,51,51,51,53,53,56,56,61,61,61,61,61,61,61,55,55,55,55,56,56,55,55,55,55,61,61,61,61,61,55,55,55,55,55,55,55,55,61,55,55,55,55,55,53,51,51,51,51,51,51,51,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,8,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,40,8,8,8,8,72,72,8,8,8,8,8,8,8,8,8,8,8,40,8,8,40,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,5,5,5,5,1,1,30,30,30,30,30,30,30,30,21,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,64,64,70,56,59,59,59,59,56,25,1,61,1,56,70,56,70,52,59,75,59,59,59,59,59,59,70,76,62,16,13,13,25,13,13,13,13,13,13,0,25,13,13,16,0,17,17,22,26,26,22,26,22,14,14,16,16,14,14,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,16,28,28,28,28,1,0,14,0,3,3,3,3,3,3,51,51,51,53,53,53,53,61,61,61,61,61,61,61,55,55,55,55,55,55,55,55,55,55,61,61,61,61,55,55,55,55,55,55,55,55,55,55,55,55,55,55,53,53,51,51,51,51,51,51,51,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,40,40,40,8,8,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,5,5,5,5,5,5,30,30,30,30,30,30,30,30,30,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,64,70,59,59,59,59,1,56,42,42,42,42,42,42,70,59,59,59,59,59,59,59,59,59,70,70,70,77,16,13,13,25,13,13,16,17,17,25,25,22,16,16,16,0,1,22,22,26,22,22,26,26,22,22,16,16,22,22,22,22,22,22,22,22,22,22,26,22,22,22,22,22,22,22,16,16,16,14,28,16,0,14,0,3,3,3,3,3,3,3,51,51,0,53,53,53,53,61,61,61,61,61,61,55,55,55,55,55,55,55,55,61,61,61,61,61,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,53,51,51,51,51,51,51,51,3,3,3,3,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,5,5,5,5,5,5,1,30,30,30,30,30,30,30,30,21,21,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,64,70,56,59,59,0,42,42,1,42,42,1,42,42,1,59,56,59,59,59,59,59,59,59,70,70,76,62,62,13,13,25,13,13,13,17,0,14,14,16,17,16,16,22,22,22,22,22,22,22,22,26,22,28,28,28,28,28,22,22,26,26,26,22,22,26,22,22,22,22,22,22,22,22,16,16,28,28,16,16,14,0,0,3,3,3,3,3,3,51,51,51,53,53,53,53,53,61,61,61,61,55,55,61,61,61,55,61,61,61,61,61,55,55,53,53,53,53,53,53,53,53,55,55,55,55,55,55,55,0,53,51,51,51,51,51,51,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,51,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,3,25,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,40,8,8,8,8,40,40,40,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,4,8,8,5,5,4,5,5,5,5,0,30,30,30,30,30,30,30,30,30,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,78,3,64,64,59,59,56,62,1,1,1,1,42,79,42,42,42,42,56,56,59,59,59,59,59,59,59,71,71,76,62,62,13,13,16,13,13,13,17,14,14,14,16,16,16,22,22,22,22,22,22,22,22,22,22,22,28,28,22,22,22,22,26,26,22,26,22,22,22,22,22,22,22,22,22,22,28,28,28,28,16,14,14,14,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,53,53,55,55,55,55,55,61,61,61,61,55,55,55,53,53,53,51,51,51,51,51,25,53,53,53,55,55,55,55,53,53,53,51,51,51,51,51,51,51,3,3,3,3,51,51,51,51,51,51,51,51,51,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,25,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,8,8,40,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,4,8,4,4,4,4,5,5,5,5,1,30,30,30,30,30,30,30,30,30,21,21,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,64,25,74,62,1,62,1,1,1,79,79,1,42,42,61,25,56,59,59,59,59,59,59,71,56,80,77,62,3,13,16,16,13,13,13,17,17,22,22,16,16,22,22,22,22,22,22,22,22,22,22,22,28,28,28,22,22,22,22,22,22,22,26,26,22,22,22,22,22,22,22,22,28,28,28,16,14,14,0,1,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,53,53,55,55,55,55,55,55,55,53,53,53,53,53,51,51,51,51,51,51,51,51,51,3,53,53,53,53,53,53,51,51,51,51,51,51,51,51,51,51,3,3,51,51,51,51,51,51,51,51,25,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,25,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,4,4,5,4,4,4,5,5,5,5,1,30,30,30,30,30,30,30,30,30,30,21,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,64,64,74,74,74,74,74,1,1,31,0,1,42,0,61,81,59,59,59,59,59,59,59,56,56,71,62,62,13,13,13,16,16,13,13,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,28,22,22,22,22,22,22,22,26,26,22,22,22,22,22,22,20,20,28,16,1,16,14,14,0,0,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,53,53,55,55,55,55,53,53,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,53,53,53,25,55,55,55,55,55,53,53,53,53,55,55,55,55,55,55,55,55,25,25,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,40,8,8,8,8,8,8,8,8,4,8,5,4,5,5,5,5,5,5,1,30,30,30,30,30,30,30,30,30,30,21,21,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,64,74,74,74,74,1,1,46,62,62,1,42,25,81,56,59,59,59,59,59,59,70,59,70,77,62,62,13,13,17,0,17,13,26,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,28,22,22,22,22,22,26,26,22,22,22,22,22,22,20,20,28,28,16,16,16,14,14,14,0,3,3,3,3,3,3,3,3,3,0,51,51,51,51,51,51,51,51,51,53,53,53,53,53,53,53,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,53,53,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,25,8,8,8,40,40,40,8,8,8,4,4,40,8,8,8,40,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,4,4,8,4,4,5,5,5,5,5,1,30,30,30,30,30,30,30,30,30,30,30,21,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,64,74,74,74,46,46,62,0,62,79,77,56,81,70,59,59,59,59,59,59,70,70,39,70,62,62,62,1,13,17,17,13,13,26,26,13,13,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,28,22,16,16,14,14,25,14,3,3,3,3,3,3,3,3,3,3,1,3,3,51,51,51,51,51,51,51,51,53,53,53,53,53,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,53,53,55,55,55,55,55,55,55,55,55,55,56,56,55,61,61,61,55,55,55,55,55,61,61,8,8,8,8,40,8,8,8,8,4,4,4,4,4,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,7,5,5,5,5,5,0,21,30,30,30,30,30,30,30,30,30,30,30,21,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,74,74,82,0,1,62,46,0,77,77,56,81,61,59,59,59,59,59,59,39,70,70,70,70,70,62,62,13,1,17,13,13,22,26,13,14,16,16,16,22,22,22,26,22,22,26,26,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,14,14,25,14,14,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,53,53,61,61,55,55,55,55,55,58,55,56,56,56,56,55,55,55,55,61,61,61,61,61,61,61,61,8,8,8,8,8,8,8,8,40,4,40,4,40,4,4,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,7,5,5,5,5,5,21,21,0,30,30,30,30,30,30,30,30,30,30,21,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,78,3,3,3,64,74,82,82,82,1,62,62,1,77,77,56,56,70,59,59,59,59,59,59,59,70,59,59,70,70,1,62,62,13,17,0,13,13,13,16,14,14,16,16,16,22,22,26,26,26,26,22,22,22,22,22,22,22,22,22,22,22,22,22,25,22,22,22,22,22,22,22,22,22,22,22,14,1,25,14,14,1,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,3,3,51,51,51,51,3,51,51,51,51,51,51,51,51,51,51,51,51,51,51,53,53,61,61,61,61,61,58,58,55,58,56,56,61,61,61,61,61,55,55,61,61,61,61,61,61,61,61,8,8,8,8,8,8,8,8,40,40,4,40,4,40,4,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,7,5,5,5,5,5,21,21,1,0,30,30,30,30,30,30,30,30,30,21,21,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,82,82,82,82,25,46,62,49,77,77,56,71,56,59,59,59,59,59,59,59,59,59,56,70,70,70,77,62,13,13,17,13,13,13,22,14,14,16,16,16,22,22,22,26,22,26,26,22,22,22,22,22,22,22,22,22,22,22,22,1,22,22,22,22,22,22,22,22,22,22,22,14,14,1,25,14,14,1,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,51,53,53,25,61,56,56,56,56,58,58,58,58,58,56,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,8,8,8,8,8,8,8,8,40,40,4,4,4,4,4,8,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,7,7,5,5,5,5,1,21,21,0,30,30,30,30,30,30,30,30,30,30,21,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,42,42,42,1,3,3,3,3,3,3,3,3,3,3,3,3,64,74,82,36,82,0,46,62,62,77,77,76,56,70,59,70,59,59,59,59,73,73,59,59,59,70,70,62,62,76,13,17,17,13,13,13,16,14,16,22,22,22,22,22,26,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,14,14,14,22,22,22,22,22,22,22,22,22,14,14,14,14,14,14,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,53,53,3,61,61,56,56,56,56,56,55,55,55,55,55,56,55,55,61,61,61,61,55,55,61,61,61,61,61,61,8,8,8,8,8,8,8,8,8,40,40,4,4,4,4,4,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,7,7,5,5,5,5,5,21,21,0,30,30,30,30,30,30,30,30,30,30,21,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,42,42,49,82,42,42,3,3,3,3,3,3,3,3,3,3,64,64,82,36,36,82,25,0,62,49,77,79,77,56,71,25,70,59,59,59,59,73,73,59,59,59,59,70,70,62,13,13,13,22,13,13,13,13,14,16,22,22,22,26,26,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,14,14,14,14,14,14,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,25,53,53,55,55,55,55,55,56,55,55,55,55,55,55,57,55,55,55,55,55,61,61,55,56,56,61,61,61,61,55,8,8,8,8,8,8,8,8,8,8,40,4,40,4,4,4,4,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,40,40,40,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,7,5,5,5,5,5,21,21,25,30,30,30,30,30,30,30,30,30,30,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,79,77,77,79,3,3,3,3,3,3,3,42,42,75,52,42,42,42,3,3,3,3,3,3,3,3,3,3,64,82,82,82,36,25,0,0,62,49,62,79,77,56,25,56,71,59,59,59,59,59,73,73,59,59,59,70,70,70,13,13,13,13,13,13,22,22,14,16,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,16,22,22,22,22,22,22,22,22,22,22,22,16,16,16,14,14,14,14,25,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,53,53,53,53,56,56,55,55,55,55,61,61,61,53,55,57,55,57,55,55,55,55,55,55,55,56,56,55,56,55,55,8,8,8,8,8,8,8,8,8,8,8,8,4,4,40,4,4,8,40,40,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,40,8,8,8,8,8,8,8,8,8,40,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,4,4,4,5,5,5,5,5,5,21,21,0,30,30,30,30,30,30,30,30,30,30,21,21,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,79,77,74,74,77,77,74,3,3,3,3,0,42,42,42,42,82,42,42,25,3,3,3,3,3,3,3,3,3,3,64,82,82,36,82,1,1,49,62,62,62,77,77,76,77,61,56,56,59,59,59,59,59,73,59,59,59,1,70,70,70,13,0,13,1,13,22,14,14,14,16,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,16,22,22,22,22,16,22,22,22,22,22,22,22,22,22,22,25,14,16,16,0,14,14,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,53,53,53,55,61,55,55,55,55,61,61,61,61,53,53,53,53,57,55,57,55,55,55,55,55,55,56,56,56,56,56,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,40,4,4,40,40,40,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,8,8,8,8,8,8,8,40,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,4,4,5,5,5,5,5,5,21,21,0,30,30,30,30,30,30,30,30,30,30,21,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,79,1,79,76,79,77,74,74,82,74,74,74,74,3,3,0,0,25,25,25,1,25,25,3,3,3,3,3,3,3,3,3,3,64,64,82,82,36,82,0,0,62,62,62,62,0,77,77,77,77,25,77,56,56,59,59,73,73,73,59,59,59,70,70,70,13,13,25,13,13,13,14,14,14,16,16,22,22,22,22,22,22,22,22,22,22,22,22,20,22,22,22,22,22,14,14,16,16,22,22,22,22,22,22,22,22,22,22,22,22,22,14,16,0,22,16,16,14,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,53,53,53,55,61,61,61,61,61,58,58,58,61,61,61,53,53,53,53,57,57,55,57,55,55,55,55,56,56,56,56,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,4,40,40,40,40,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,40,40,40,8,8,8,40,40,40,40,40,40,40,40,8,40,40,40,40,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,4,4,5,5,5,5,5,21,21,0,30,30,30,30,30,30,30,30,30,30,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,79,79,77,79,79,76,74,74,82,82,82,49,49,74,74,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,64,74,82,82,36,82,0,25,0,62,62,62,79,77,77,42,42,70,59,59,59,59,59,73,73,73,59,59,59,70,70,25,70,13,13,13,13,13,14,14,14,14,16,16,22,22,22,22,22,22,22,22,22,22,20,20,22,22,22,22,22,22,14,22,22,16,16,22,22,22,22,22,22,22,22,22,22,22,16,16,14,22,14,16,16,14,14,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,53,53,53,55,55,61,55,55,55,58,58,58,58,61,61,61,61,53,53,53,55,57,57,55,57,55,61,61,55,56,55,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,40,40,40,40,40,8,8,8,8,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,4,5,5,5,5,5,0,21,0,30,30,30,30,30,30,30,30,30,30,30,21,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,0,79,77,74,76,74,74,74,82,0,74,74,74,74,74,74,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,74,74,74,82,82,82,1,0,49,49,49,62,0,79,76,79,70,70,59,59,59,59,59,73,73,73,73,59,59,59,70,70,70,70,13,1,13,13,13,14,14,14,16,16,16,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,14,14,16,22,16,22,22,22,22,22,22,22,22,22,22,16,22,22,22,22,14,14,16,25,14,14,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,53,53,53,55,55,55,61,61,56,61,58,55,58,61,53,53,61,61,55,55,55,55,55,55,57,57,55,55,61,56,55,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,40,40,40,40,8,8,8,8,8,40,40,40,40,40,40,8,40,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,4,0,5,5,5,5,5,21,1,30,30,30,30,30,30,30,30,30,30,30,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,25,79,74,74,74,76,82,74,74,74,74,1,74,74,74,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,25,74,74,74,82,82,1,1,0,62,49,49,42,1,79,77,79,42,70,59,59,59,59,73,73,73,73,73,59,59,59,59,70,70,70,13,13,13,13,16,16,16,14,14,20,16,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,14,14,22,22,22,16,20,22,20,22,22,22,22,22,22,22,16,22,22,16,16,16,16,25,25,25,14,14,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,25,53,53,25,55,55,55,55,56,61,58,58,58,53,53,53,53,55,55,55,55,55,55,55,55,55,57,61,61,61,55,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,8,8,8,8,8,8,8,8,40,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,40,40,40,40,72,40,40,8,8,8,8,8,8,8,8,8,4,5,5,5,5,5,1,21,1,30,30,30,30,30,30,30,30,30,30,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,79,77,76,74,74,82,74,74,0,82,74,74,74,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,25,0,1,25,74,74,25,25,1,25,49,62,49,49,0,62,62,79,77,77,76,76,25,56,25,73,59,59,73,73,73,59,59,59,70,70,70,70,13,25,13,13,13,16,16,26,14,14,22,16,22,22,22,22,22,22,22,22,22,22,16,22,22,22,14,22,22,22,22,20,20,22,20,22,22,22,22,22,22,22,22,22,16,22,1,16,16,16,1,0,25,14,25,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,51,51,51,51,51,51,51,51,51,51,51,53,53,25,55,55,55,61,61,58,58,58,58,53,55,55,55,55,55,55,55,55,55,55,55,61,61,61,61,61,8,8,8,8,8,8,40,8,8,8,40,40,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,40,40,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,40,40,40,40,72,72,40,8,8,8,8,8,8,8,72,8,8,4,4,5,5,5,5,5,21,1,30,30,30,30,30,30,30,30,30,30,30,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,79,77,74,74,74,25,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,25,25,0,0,0,0,76,76,49,49,49,62,62,62,62,0,62,62,0,77,77,77,76,76,56,56,59,59,59,59,73,73,59,59,59,59,70,70,70,70,13,13,13,13,22,16,16,14,14,16,22,22,22,22,22,22,22,20,22,22,16,16,16,22,22,22,22,22,22,22,20,22,20,20,22,22,22,22,22,22,22,22,22,22,16,16,25,16,16,16,0,25,14,0,25,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,51,37,37,51,37,37,37,51,51,51,51,51,51,51,51,51,53,53,53,55,55,61,55,61,58,58,58,53,56,56,56,55,55,55,55,55,55,55,55,55,55,61,55,55,8,8,8,8,8,40,8,8,8,40,40,8,40,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,40,40,40,8,40,8,72,8,8,8,8,8,8,72,72,8,8,7,4,5,5,5,5,5,21,21,0,1,30,30,30,30,30,30,30,30,30,21,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,1,0,79,79,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,25,1,25,62,62,62,76,76,76,49,25,42,42,49,49,0,62,0,0,1,0,0,77,77,77,76,76,70,70,59,73,73,73,73,59,59,59,59,70,70,70,13,25,13,13,13,13,16,14,14,16,16,16,16,22,22,22,20,20,22,16,16,22,22,22,22,22,22,22,22,22,20,20,20,16,22,22,22,22,14,14,14,22,22,22,22,22,16,16,16,16,25,25,14,1,0,25,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,3,51,37,37,37,37,37,37,37,51,51,51,51,51,51,51,51,51,51,0,53,53,55,55,57,61,61,61,55,56,56,61,56,56,56,56,56,55,55,55,55,61,61,55,55,55,8,8,8,8,8,40,8,40,40,8,8,8,8,40,8,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,40,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,40,40,72,40,40,8,72,8,8,8,8,72,8,8,8,8,4,4,5,5,5,5,5,0,21,21,0,0,30,30,30,30,30,30,30,30,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,25,0,62,1,62,0,0,62,62,62,42,42,46,62,62,62,1,0,3,3,3,1,77,77,76,76,56,70,70,70,71,73,73,73,59,59,59,61,70,70,13,13,0,13,13,13,14,14,14,14,14,22,16,16,22,22,20,20,20,16,16,22,22,22,22,22,22,22,22,22,20,20,22,22,16,16,22,22,14,22,14,22,22,22,22,22,22,16,16,16,16,0,14,14,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,51,3,51,37,37,14,14,14,14,14,37,37,51,51,51,51,51,51,51,51,51,25,53,53,55,57,57,57,61,61,55,61,56,56,56,56,56,56,56,56,55,61,61,55,55,55,55,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,72,8,8,8,8,8,4,4,7,5,5,5,5,5,0,21,21,1,0,30,30,30,30,30,30,30,30,21,2,21,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,62,62,62,62,76,76,76,62,62,62,62,42,1,1,0,1,1,3,3,3,3,0,0,77,76,76,0,56,71,71,73,73,73,73,59,59,59,70,70,61,62,13,0,13,13,13,14,14,14,14,22,22,22,22,16,16,22,20,20,16,16,22,22,22,22,22,22,22,22,20,22,22,22,22,22,22,22,22,14,22,22,22,22,22,22,22,22,14,16,16,16,0,1,14,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,25,25,3,3,3,3,51,3,37,37,83,14,16,14,14,37,51,51,51,51,51,51,51,51,51,51,51,51,53,53,53,53,57,57,57,61,61,55,56,56,56,56,56,56,56,55,55,55,61,55,55,55,8,8,8,8,8,8,40,40,40,8,8,8,8,8,40,40,40,40,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,72,40,40,40,8,8,72,8,8,72,8,8,8,8,8,8,7,7,7,5,5,5,5,5,30,25,21,0,0,0,30,30,30,30,30,30,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,62,62,62,76,0,62,62,62,62,25,1,0,1,3,3,3,3,3,3,3,3,3,1,0,1,76,76,25,73,70,73,73,73,73,73,59,59,59,70,25,62,62,62,13,13,13,22,14,50,16,14,22,22,22,22,22,16,22,20,22,22,16,22,22,22,22,22,22,22,20,20,22,22,22,22,22,22,22,22,14,22,22,16,16,16,22,22,16,16,14,14,14,0,14,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,14,16,14,14,14,14,14,14,3,3,3,51,3,3,3,37,37,14,16,14,14,14,25,51,51,51,51,51,51,51,51,51,51,51,51,1,53,53,55,57,61,57,55,55,55,55,55,56,56,56,56,55,55,61,61,55,55,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,40,40,8,8,8,8,72,72,8,8,8,8,8,8,8,7,5,5,5,5,5,5,5,30,30,1,0,30,30,30,30,30,30,30,30,30,30,21,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,62,76,76,76,76,62,62,0,62,25,0,0,1,3,3,3,3,3,3,3,3,3,3,3,76,76,76,1,73,73,73,70,56,73,73,73,59,59,59,70,56,25,62,62,1,13,22,13,14,14,50,16,16,22,22,22,22,22,22,22,22,22,16,16,22,22,22,22,22,22,22,20,22,22,22,22,22,22,22,22,14,14,14,22,16,22,16,16,16,25,14,14,14,14,14,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,25,25,14,14,16,14,16,25,14,25,25,3,3,3,3,3,3,3,3,3,37,14,26,14,14,14,25,51,51,51,51,51,51,51,51,51,51,51,51,25,53,53,53,61,61,61,61,61,61,55,55,55,55,55,55,55,61,61,55,55,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,40,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,40,40,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,8,8,8,8,8,8,8,8,72,8,8,8,8,8,8,0,7,5,5,5,5,5,5,5,1,30,30,30,30,30,0,0,30,30,0,1,30,30,0,21,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,62,77,76,76,76,76,62,32,62,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,76,76,25,56,70,73,56,70,70,70,73,73,59,59,73,70,25,62,62,62,13,25,22,16,16,16,16,16,16,22,22,22,22,22,22,22,22,22,16,22,22,22,22,22,22,20,22,22,20,22,22,22,22,22,22,22,14,14,14,22,14,14,14,22,22,14,1,0,14,14,1,3,3,3,3,1,25,3,3,3,3,3,3,3,3,25,25,14,14,16,16,16,16,16,16,16,0,3,3,3,3,3,3,3,3,3,25,14,16,16,14,14,0,14,25,1,51,51,51,51,51,51,51,51,51,51,51,51,53,53,53,61,61,53,53,55,55,55,55,55,55,55,55,61,61,55,55,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,5,5,5,5,5,5,5,5,5,1,30,30,30,0,25,1,30,30,30,30,30,30,25,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,25,1,77,77,76,0,76,0,62,32,0,62,1,1,3,3,3,3,3,3,3,3,3,3,3,3,84,84,1,76,59,70,70,25,56,70,56,70,70,70,70,70,56,25,13,25,62,13,25,22,13,13,16,16,16,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,22,22,22,22,22,22,22,22,22,22,22,22,22,14,14,14,14,14,22,14,14,14,14,14,14,14,1,0,3,3,0,0,3,3,3,3,3,3,3,1,1,14,14,16,16,20,20,20,20,20,14,25,3,3,3,3,3,3,3,3,3,0,14,1,16,14,14,0,1,14,14,25,51,51,51,51,51,51,51,51,51,51,51,51,25,53,53,53,53,53,53,25,55,55,55,55,55,55,55,55,55,55,8,8,8,8,8,8,8,8,8,8,40,8,40,40,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,8,8,8,8,8,8,8,72,8,8,8,8,8,8,1,40,40,5,5,5,5,5,5,5,5,5,5,1,30,30,30,30,30,30,30,30,30,30,30,0,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,62,1,25,77,77,25,1,1,1,62,62,62,62,1,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,52,85,85,73,73,73,56,56,70,56,59,70,70,70,70,70,13,13,62,13,13,13,13,13,14,14,16,22,22,22,22,22,22,22,22,14,22,22,22,22,22,22,22,20,22,20,22,22,20,22,16,22,22,22,14,22,22,22,22,14,22,22,22,22,1,14,14,14,1,25,25,1,0,0,25,1,0,3,1,3,3,3,14,14,14,14,16,16,20,20,20,14,25,20,14,14,3,3,3,3,3,3,3,3,3,14,14,25,16,0,14,0,16,16,14,25,51,51,51,51,51,51,51,51,51,51,51,51,51,53,53,53,53,53,53,53,53,3,55,55,55,55,55,55,55,55,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,8,8,8,8,8,8,72,8,8,8,8,8,8,1,40,40,40,40,5,5,5,5,5,5,5,5,5,5,1,1,1,30,30,30,30,30,1,1,30,30,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,62,77,77,77,1,82,1,36,25,62,62,1,0,0,3,3,3,3,3,3,3,3,3,3,3,84,84,84,84,52,85,85,25,73,25,56,25,70,59,70,70,70,70,56,70,62,13,25,62,13,13,13,13,14,14,16,22,22,22,22,22,22,22,14,14,14,22,22,22,22,28,28,22,20,20,22,22,22,20,20,16,22,14,14,22,22,22,22,14,22,22,22,22,0,14,14,14,14,1,14,14,14,14,14,14,0,3,3,14,14,14,14,14,16,16,16,25,16,16,20,20,0,25,14,14,3,3,3,3,3,3,3,3,14,14,25,16,16,16,25,14,1,16,16,14,0,51,51,51,51,51,51,51,51,51,51,51,51,53,53,53,53,53,53,53,53,53,53,53,53,55,55,55,55,55,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,40,8,40,8,8,40,8,8,8,8,8,40,40,40,40,40,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,40,8,8,8,8,72,72,8,8,8,8,8,0,40,40,40,40,40,5,5,5,5,5,5,5,5,5,5,5,5,5,1,0,1,1,30,1,1,0,0,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,77,77,82,82,1,82,36,36,25,62,0,0,1,0,3,3,3,3,3,3,3,3,3,3,84,84,84,84,52,52,85,85,25,61,56,56,76,77,77,70,56,70,70,70,61,61,13,62,62,62,13,13,0,14,14,22,22,14,22,22,22,22,22,14,14,22,22,22,22,22,22,28,28,22,22,20,22,22,16,22,16,22,14,14,22,22,22,14,14,22,22,22,22,22,16,16,16,16,14,14,0,25,1,14,14,14,1,0,14,14,14,14,16,16,14,16,16,16,14,1,0,14,25,1,14,3,3,3,3,3,3,3,25,14,16,16,16,16,16,16,1,14,25,16,16,14,51,51,51,51,51,51,51,51,51,51,51,51,51,53,53,53,53,53,53,53,53,53,53,53,53,53,55,55,55,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,40,8,40,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,40,40,40,8,8,8,8,8,8,8,8,8,1,40,40,40,40,40,40,40,5,5,5,5,5,5,5,5,5,5,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,82,82,0,82,82,36,36,82,36,25,25,0,1,0,0,3,3,3,3,3,3,3,3,3,3,3,84,84,84,84,52,85,85,25,25,25,61,76,76,76,70,70,56,70,70,25,61,25,13,62,62,13,13,13,0,14,14,14,14,14,0,22,22,14,22,22,22,22,22,22,22,22,22,22,28,22,22,20,20,14,22,16,16,14,14,14,16,16,14,14,16,22,22,22,22,22,22,0,25,25,16,16,14,14,1,14,0,14,14,14,14,14,0,16,16,16,16,20,16,25,14,14,16,16,14,1,1,1,3,3,3,3,25,14,14,16,16,14,16,16,16,1,16,14,14,50,50,16,25,51,51,51,51,51,51,51,51,51,51,51,51,53,53,53,53,53,53,53,51,51,51,51,53,53,53,25,25,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,40,8,40,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,40,40,40,40,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,5,5,5,5,5,5,5,5,5,5,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,82,1,82,82,36,36,82,36,36,25,25,0,1,0,0,3,3,3,3,3,3,3,3,86,3,3,84,84,84,84,85,85,25,25,76,76,76,76,62,76,70,70,70,70,70,77,13,62,62,62,62,13,13,25,1,14,14,14,14,14,14,14,14,14,1,22,22,22,22,22,22,22,22,22,22,22,22,22,14,14,22,22,14,14,22,22,14,14,14,22,16,22,22,22,22,22,22,22,22,22,22,16,16,1,14,14,14,14,14,14,14,0,14,16,16,20,20,20,16,14,16,16,14,14,14,14,14,14,25,25,3,14,14,16,16,16,0,25,16,14,16,16,26,16,14,50,50,50,25,25,51,51,51,51,51,51,51,51,51,51,51,53,53,53,53,53,53,51,51,51,51,51,51,53,53,53,25,8,8,8,8,8,8,8,8,8,8,8,40,4,4,4,4,8,8,40,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,40,40,40,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,2,2,2,2,2,2,5,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,82,82,82,82,82,82,82,36,36,36,25,82,0,1,1,3,3,3,3,3,3,3,3,3,86,86,86,86,84,84,85,85,25,76,76,76,25,25,76,25,25,77,77,76,76,76,77,13,62,62,62,62,13,13,0,0,14,14,14,14,14,14,14,14,0,22,22,22,22,22,22,22,22,22,22,22,22,22,14,14,14,22,22,14,22,22,22,14,14,22,16,22,22,22,22,22,22,22,22,22,22,22,22,16,16,22,0,16,16,16,14,16,16,16,16,16,20,20,1,14,16,16,14,16,16,16,16,16,16,16,16,16,16,16,16,14,1,1,16,16,14,14,16,26,0,50,50,50,50,50,1,0,51,51,51,51,51,51,51,51,51,53,53,53,53,53,53,51,51,51,51,51,51,51,53,53,25,1,8,8,8,8,8,8,8,8,8,8,8,40,4,4,4,40,8,40,40,40,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,72,72,8,8,8,8,8,8,40,40,40,40,40,40,72,40,40,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,82,82,82,82,82,82,82,82,36,36,75,82,25,0,0,3,3,3,3,3,3,3,3,3,3,86,86,86,86,84,84,52,25,76,76,76,1,76,76,76,25,76,76,1,25,76,76,25,62,62,62,62,62,0,13,16,16,14,14,14,14,14,14,14,14,1,14,14,14,22,22,22,22,22,22,22,26,26,26,14,14,22,22,22,16,22,22,22,22,22,22,16,16,22,22,22,22,22,22,22,22,26,22,22,22,22,16,16,22,0,25,14,14,16,16,16,14,20,20,16,14,16,14,16,14,1,14,14,14,14,16,14,25,0,25,14,14,14,16,16,14,14,14,26,26,14,50,16,50,14,50,50,25,1,56,51,51,51,51,51,51,51,51,53,53,53,53,25,51,51,51,51,51,51,51,51,53,53,25,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,4,8,8,40,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,72,8,8,8,8,8,40,40,40,40,40,40,40,72,40,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,82,82,82,82,82,82,82,36,36,74,84,82,1,0,3,3,3,3,3,3,3,3,3,3,86,86,86,86,3,84,52,25,76,76,62,76,25,25,76,25,76,76,76,76,62,25,62,62,62,62,1,25,1,25,25,16,14,14,14,14,14,14,14,14,54,22,14,14,14,14,14,1,14,14,22,22,26,22,22,14,22,26,22,22,16,22,22,22,22,22,22,16,22,16,22,22,22,22,22,22,22,22,26,22,22,22,22,22,22,22,16,16,16,16,14,16,14,16,16,1,16,16,16,14,14,16,16,14,16,16,16,16,16,16,16,16,14,14,16,16,16,14,14,26,26,14,50,50,50,50,14,50,14,14,56,56,56,56,51,51,51,51,51,53,53,53,53,51,51,51,51,51,51,51,51,51,53,25,25,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,40,40,40,40,40,8,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,82,82,82,82,82,36,82,36,36,52,82,0,0,3,3,3,3,3,3,3,3,3,3,86,86,86,3,84,84,52,0,76,76,62,38,38,38,38,76,76,62,62,62,62,62,62,62,62,25,62,0,38,38,38,16,16,14,14,14,1,14,14,14,14,16,22,14,0,22,22,14,14,14,14,14,14,26,26,22,22,26,26,22,22,16,16,22,22,22,22,22,22,22,22,22,22,22,22,26,26,26,22,22,22,22,22,22,22,22,22,22,22,22,22,14,14,14,16,16,16,16,14,16,14,14,14,14,14,14,16,25,16,14,16,14,16,0,16,16,16,16,16,26,26,26,14,13,15,15,15,15,14,56,56,56,56,56,56,13,51,51,51,51,51,53,53,53,51,51,51,51,51,51,51,51,51,53,25,25,8,8,8,8,8,8,8,8,8,8,8,40,4,4,4,40,40,40,40,8,8,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,40,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,72,8,8,8,8,8,8,8,40,40,40,40,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,82,82,82,82,36,82,82,36,74,82,82,0,3,3,3,3,3,3,3,3,3,3,3,86,86,86,84,84,84,25,76,76,0,62,49,38,38,38,1,25,62,62,62,62,62,0,25,1,25,0,0,25,1,38,14,14,14,14,87,14,14,14,14,14,22,14,16,16,16,16,16,14,14,22,14,22,20,26,22,22,22,22,22,22,22,16,16,16,22,22,22,22,22,22,20,22,22,22,16,26,22,26,26,22,26,22,22,22,22,22,22,22,22,22,22,22,16,16,16,16,16,16,16,16,16,14,14,14,14,16,14,14,14,16,14,16,14,14,14,14,25,14,26,26,26,15,15,15,15,15,15,50,14,56,50,50,50,61,87,87,13,51,51,51,56,25,51,51,51,51,51,51,51,51,51,51,53,25,25,8,8,8,8,8,8,8,8,8,8,40,40,40,4,4,40,40,40,40,40,8,40,40,40,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,8,40,72,40,8,8,8,8,8,0,40,40,40,1,72,72,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,82,82,82,82,82,36,36,82,0,0,3,3,3,3,3,3,3,3,3,3,3,3,86,3,84,84,84,25,76,76,25,1,76,49,38,38,76,76,62,62,62,32,32,32,32,0,1,0,1,0,38,38,38,14,87,14,1,14,14,14,14,22,14,14,16,16,25,25,25,16,16,0,22,22,22,20,22,26,26,22,22,22,22,22,16,22,22,22,22,22,22,22,22,22,20,20,20,16,22,16,22,22,26,26,26,22,22,22,22,22,22,22,22,16,16,16,22,16,16,16,16,14,16,16,16,14,14,14,14,14,14,14,14,16,16,14,14,16,14,16,16,26,26,26,15,15,15,15,15,44,44,54,54,50,50,87,61,61,88,87,87,1,56,53,56,51,51,51,51,51,51,51,51,51,51,53,25,25,8,8,8,8,8,8,8,8,8,40,40,40,40,4,4,8,8,8,40,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,40,40,40,8,8,8,8,8,40,40,8,8,8,8,40,8,8,8,8,8,8,8,8,8,40,40,40,40,40,72,8,40,72,40,8,8,8,8,8,40,40,40,1,72,72,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,36,82,82,84,36,36,75,82,1,3,3,3,3,3,3,3,3,3,3,3,3,86,86,86,84,52,52,76,76,76,1,76,49,76,49,38,38,1,32,32,32,32,32,32,76,32,1,25,1,38,38,38,38,87,87,22,22,22,22,14,44,16,16,16,16,16,13,13,13,16,16,16,0,22,22,20,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,22,20,20,16,22,22,22,22,22,26,22,22,22,22,22,22,22,22,22,16,20,20,20,22,22,22,22,16,16,14,16,16,16,16,14,16,16,16,16,14,16,26,16,26,16,16,16,88,88,15,15,15,54,54,44,44,54,54,44,56,56,61,61,61,88,88,14,56,53,25,51,51,51,51,51,51,51,51,51,53,53,25,56,8,8,8,8,8,8,8,8,40,40,40,40,40,4,40,40,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,40,8,40,40,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,40,40,40,40,40,40,72,8,8,40,8,8,8,8,8,1,40,40,40,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,36,82,82,82,0,36,36,36,82,1,3,3,3,3,3,3,3,3,3,3,3,86,86,86,64,52,52,0,76,76,76,76,76,49,62,49,49,32,32,32,32,32,32,32,32,76,32,1,1,1,0,38,38,38,38,87,22,22,14,14,14,14,16,16,13,13,83,83,13,25,16,16,16,16,16,22,22,20,20,20,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,20,20,16,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,20,20,20,22,22,22,22,14,14,14,14,14,14,14,14,16,16,16,16,26,26,16,16,14,26,16,26,26,15,15,15,14,54,50,54,61,61,56,56,61,61,56,61,61,56,56,56,53,3,53,51,51,51,51,51,51,51,53,53,25,56,56,8,8,8,40,40,8,8,40,40,40,40,40,40,4,40,40,40,8,8,8,8,8,8,8,8,8,40,40,40,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,40,40,40,40,40,40,40,72,8,8,72,8,8,8,8,0,40,40,40,40,72,72,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,82,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,82,82,82,82,82,36,36,82,1,3,3,3,3,3,3,3,3,3,3,3,86,86,86,86,64,52,52,1,76,25,76,1,49,49,62,49,49,32,32,32,32,32,32,32,32,76,76,25,25,1,25,38,38,38,38,38,22,0,14,22,22,14,13,16,13,83,37,83,47,25,25,16,25,16,16,1,22,22,20,20,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,22,22,22,22,16,22,22,22,22,22,22,22,22,22,22,22,22,22,16,22,22,20,22,20,20,26,26,26,26,26,16,26,26,26,26,26,26,26,26,26,26,26,14,16,16,26,14,14,14,15,15,44,44,44,54,44,44,44,56,61,61,61,61,56,56,56,56,14,56,53,53,51,51,51,51,51,51,53,53,56,56,25,25,8,8,40,40,40,40,40,40,40,8,8,8,40,4,4,40,8,8,8,8,8,8,8,8,8,40,40,40,40,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,40,40,40,40,72,40,72,72,8,8,72,8,8,8,8,40,40,72,40,8,72,72,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,82,82,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,82,82,82,82,82,82,36,82,82,0,3,3,3,3,3,3,3,3,3,3,3,86,86,86,86,84,52,52,76,76,25,76,62,49,49,62,1,32,32,32,32,32,0,32,76,76,76,76,76,38,38,38,38,38,38,0,87,22,87,1,22,14,13,16,16,83,83,47,47,47,47,25,25,16,16,16,16,1,22,22,22,22,22,22,22,22,14,22,22,22,22,22,16,16,22,22,22,22,22,22,22,16,22,22,22,22,22,22,22,22,22,22,22,22,16,16,20,26,22,26,20,26,20,20,14,16,16,16,16,16,14,14,16,16,14,14,14,14,14,14,14,16,14,14,14,14,15,15,15,44,50,54,54,44,44,61,61,44,44,61,61,56,56,56,56,56,53,53,53,25,3,3,53,53,56,56,56,56,25,25,8,8,8,40,40,40,40,40,40,8,40,4,4,4,4,40,40,8,8,8,8,8,8,8,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,40,40,40,8,40,8,72,72,8,8,72,8,8,8,1,40,40,72,72,8,72,72,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,82,82,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,82,82,82,82,82,36,36,82,1,0,3,3,3,3,3,3,3,3,3,3,3,86,86,84,84,0,52,52,25,76,76,25,49,49,76,49,49,49,32,32,32,32,32,32,32,32,32,32,32,76,38,38,38,89,89,90,90,22,87,0,14,13,13,16,13,37,47,47,47,47,47,47,47,0,16,16,16,16,16,22,22,22,22,22,14,14,14,14,14,14,14,16,22,14,22,16,16,16,22,22,22,22,14,22,22,22,22,22,22,22,22,22,22,22,22,16,16,16,20,20,20,16,26,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,16,14,14,14,15,15,15,16,54,54,54,61,61,61,61,44,50,56,56,56,56,56,56,56,56,25,53,53,56,56,53,25,56,56,56,25,25,0,8,8,40,40,40,40,40,40,40,40,40,4,4,40,40,40,8,8,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,40,40,40,40,72,8,72,8,72,72,8,72,8,8,8,40,40,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,82,82,82,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,82,82,82,36,36,36,36,36,82,0,0,3,3,3,3,3,3,3,3,3,3,3,86,86,84,84,52,52,25,76,76,62,62,49,25,76,62,49,49,32,32,32,32,32,32,32,32,32,32,38,38,38,88,88,38,88,89,89,22,87,87,14,13,13,54,13,83,47,9,9,47,47,47,47,25,16,16,16,16,16,16,22,22,22,14,14,14,14,14,14,22,22,22,14,14,16,22,22,16,16,22,22,14,14,22,22,22,22,22,22,22,22,22,22,26,26,16,16,16,16,16,26,20,26,20,20,14,14,14,14,14,14,14,16,14,14,14,14,14,14,14,16,16,14,16,16,88,87,15,15,54,54,54,61,61,61,61,44,44,54,54,56,56,56,56,56,56,56,56,56,56,56,56,56,56,25,56,56,57,57,57,8,8,8,40,40,40,40,40,8,8,4,4,4,4,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,40,40,40,72,40,72,72,40,72,8,72,8,8,72,72,72,72,40,72,72,72,72,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,82,82,82,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,82,82,36,36,36,36,36,36,82,1,0,3,3,3,3,3,3,3,3,3,3,3,86,86,3,84,52,1,76,76,76,62,62,76,76,1,62,49,62,62,62,62,62,32,38,38,32,32,88,88,38,88,38,38,88,14,89,22,87,90,14,22,13,13,13,13,47,47,9,9,9,47,47,47,25,25,16,16,16,16,16,16,22,22,14,14,22,14,14,16,22,22,16,14,14,14,22,22,22,22,16,22,14,22,22,22,22,22,22,14,14,14,14,26,26,26,26,26,26,14,16,26,26,26,26,14,14,14,14,14,26,14,26,14,16,16,16,14,16,16,16,16,16,16,16,16,16,16,15,15,54,54,54,61,61,44,44,44,44,54,54,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,57,57,57,57,8,8,40,40,40,40,40,40,8,40,4,4,4,4,8,8,8,8,8,8,8,40,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,40,40,40,8,40,40,40,8,40,8,72,72,8,8,72,72,72,40,72,72,72,72,72,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,82,82,82,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,82,36,36,36,36,36,36,0,82,0,3,3,3,3,3,3,3,3,3,3,3,86,86,86,86,84,52,1,76,76,76,62,62,76,76,1,62,62,62,62,62,62,32,32,38,38,38,32,38,38,32,32,38,14,14,14,14,22,87,90,14,22,13,13,13,13,83,47,47,9,81,81,81,47,47,25,1,16,25,16,16,16,1,22,22,22,22,16,22,16,22,16,22,14,22,14,22,22,22,22,14,14,22,22,22,14,22,22,14,22,22,22,16,14,14,26,26,14,26,26,26,26,14,14,14,26,26,26,26,26,16,14,14,14,14,14,16,88,16,88,88,16,16,16,1,25,1,50,50,15,54,54,54,61,61,44,44,44,56,83,56,91,57,57,56,54,54,56,56,56,57,57,57,57,56,56,57,57,57,57,57,8,8,8,40,40,40,40,40,4,4,4,4,4,4,4,8,40,40,8,40,8,8,40,40,40,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,40,40,40,40,8,8,8,8,40,40,40,40,40,40,40,72,40,40,8,72,8,8,72,72,72,72,72,72,8,72,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,36,82,82,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,82,82,36,92,36,36,36,36,82,82,0,3,3,3,3,3,3,3,3,3,3,3,86,86,86,3,84,52,76,76,76,62,62,0,76,32,62,62,62,62,62,62,32,32,32,32,38,38,38,38,32,32,32,14,14,93,14,22,87,22,22,14,22,22,13,13,13,83,83,61,9,81,81,9,81,47,25,25,25,16,16,16,16,16,16,22,22,16,22,22,22,16,16,22,14,14,22,22,14,22,14,14,22,22,22,14,14,22,14,14,14,22,26,26,26,26,26,16,14,14,14,14,14,14,14,14,14,14,14,14,16,14,16,16,16,88,88,88,88,88,25,16,16,16,16,25,16,16,50,50,15,15,44,61,61,61,61,44,44,56,83,91,57,57,57,57,91,54,56,56,57,57,57,57,57,56,61,57,57,57,57,57,8,8,40,40,40,40,40,40,4,4,4,4,4,40,4,4,8,8,8,8,8,8,8,40,40,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,8,8,8,8,40,40,40,72,40,40,8,40,40,40,8,8,8,72,72,72,40,72,72,72,72,72,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,82,82,82,36,82,82,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,82,82,82,36,36,36,36,36,36,0,0,0,3,3,3,3,3,3,3,3,3,3,3,86,86,86,64,84,84,0,76,0,62,76,76,32,32,32,32,0,62,32,32,32,32,32,1,1,32,32,38,38,88,14,14,93,14,14,22,22,87,22,14,32,32,22,13,49,49,83,83,9,9,9,9,9,47,47,25,25,16,16,16,16,16,0,22,16,16,22,26,22,22,22,22,22,22,22,22,14,22,14,22,22,22,14,14,14,14,14,14,14,14,26,16,16,16,14,14,16,14,26,26,26,26,26,26,16,16,16,16,16,16,16,16,16,88,88,25,1,25,25,16,16,25,16,16,16,16,50,87,87,15,44,61,61,61,61,44,44,44,58,58,58,57,57,57,57,57,57,57,57,57,57,56,44,61,57,57,57,57,57,25,8,8,40,40,40,8,40,8,4,4,8,4,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,8,8,8,8,40,40,8,40,8,40,40,40,40,40,72,72,72,72,40,72,40,8,8,72,72,72,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,82,82,36,82,36,42,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,82,82,36,36,36,36,36,25,36,36,0,1,3,3,3,3,3,3,3,3,3,3,3,3,86,3,86,64,84,84,0,76,1,76,76,32,32,32,38,32,32,32,32,32,32,32,32,32,88,88,88,88,38,93,14,94,93,14,14,87,87,0,22,14,22,32,32,22,13,49,49,83,83,9,9,9,9,47,47,47,25,25,16,16,16,16,16,16,14,22,22,26,22,22,22,22,20,20,22,14,22,14,14,22,22,28,14,20,20,16,14,14,16,14,26,26,14,14,16,14,26,26,26,16,16,16,16,16,16,16,14,14,88,88,95,1,1,1,0,3,25,3,25,25,25,25,25,16,16,0,50,44,87,50,15,44,44,61,61,44,44,44,58,58,58,58,57,57,57,57,57,57,57,57,57,71,57,57,57,57,57,61,61,25,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,8,8,8,40,40,40,40,40,8,40,40,40,40,40,72,72,72,8,40,72,72,72,8,72,72,72,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,82,36,82,82,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,82,82,36,36,36,36,25,49,49,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,86,86,86,64,84,52,76,76,38,0,76,38,32,38,38,38,32,32,32,32,62,62,62,32,32,32,88,88,38,93,90,94,14,14,93,14,14,14,14,14,14,14,13,22,13,49,49,49,83,61,9,47,9,9,47,47,25,0,16,16,16,16,16,14,14,22,22,26,22,22,22,20,20,22,22,14,22,14,22,22,14,28,28,16,20,20,20,14,26,26,26,16,16,26,26,26,14,14,14,14,14,14,14,14,14,14,14,95,95,95,95,95,1,0,0,25,25,3,25,25,25,25,25,25,16,0,50,44,44,83,15,44,44,44,44,44,44,44,44,58,58,58,57,91,57,58,58,57,25,57,57,71,57,57,57,57,57,57,96,61,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,40,40,40,40,40,40,40,8,40,40,40,40,40,72,72,8,40,40,72,72,72,72,72,72,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,82,36,82,36,97,36,36,36,3,3,3,3,3,3,3,3,3,3,3,3,3,3,82,82,36,84,36,25,82,82,49,49,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,86,86,3,84,84,52,76,76,38,38,38,38,38,38,38,38,38,32,32,0,32,62,62,32,62,62,32,32,38,93,93,94,14,94,94,93,93,14,14,22,14,14,13,13,22,49,49,98,83,37,9,25,47,9,9,47,25,25,0,16,16,16,16,14,14,22,26,20,22,22,20,20,22,22,14,14,14,22,22,14,28,28,28,28,16,20,20,14,26,14,26,26,26,14,14,14,14,14,14,14,14,14,14,14,14,95,95,95,95,95,95,95,0,0,25,25,25,25,25,25,25,25,25,25,25,0,50,54,54,15,15,44,44,44,54,54,54,44,44,61,44,44,44,61,54,58,58,58,58,61,57,57,57,57,57,57,57,57,99,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,40,40,40,40,40,72,40,72,72,40,40,72,40,8,72,8,40,0,72,72,72,72,72,72,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,82,82,82,36,97,92,100,36,36,3,3,3,3,3,3,3,3,3,3,3,3,82,82,36,36,52,1,82,82,49,49,49,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,86,84,84,84,84,52,76,25,76,76,76,0,32,32,38,25,1,32,32,32,32,32,62,62,62,62,62,89,38,38,93,93,14,94,101,101,101,101,14,22,14,14,13,13,22,13,49,49,83,83,61,9,25,47,81,81,47,25,1,16,0,16,16,14,14,14,20,20,20,20,20,22,22,14,14,14,14,22,22,14,14,28,28,28,16,20,20,26,14,14,26,14,14,14,14,14,14,14,14,14,14,14,14,14,102,95,95,95,95,95,95,95,0,103,95,95,95,95,95,95,95,95,95,95,95,95,50,87,54,44,87,15,54,54,54,54,54,44,44,61,44,44,44,44,44,58,58,58,58,61,57,57,57,57,57,57,57,57,61,25,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,40,8,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,8,72,8,72,72,40,8,8,8,8,72,72,72,72,72,72,72,1,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,82,82,82,82,82,36,36,97,36,36,3,3,3,3,3,3,3,3,3,3,3,3,82,36,36,36,82,82,82,82,46,49,49,49,0,3,3,3,3,3,3,3,3,3,3,3,3,86,86,84,84,84,52,0,76,25,76,76,76,0,25,32,25,0,32,32,32,32,32,32,62,62,62,62,76,76,38,38,38,94,94,101,101,101,101,101,14,93,14,14,22,13,22,22,13,49,49,83,37,37,9,9,81,9,47,25,0,25,16,16,14,14,16,14,22,22,20,22,22,22,14,14,14,14,14,22,22,22,22,16,28,16,16,20,20,26,14,14,26,14,14,14,14,14,14,14,14,14,14,14,102,102,102,102,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,87,54,95,95,95,54,54,54,54,54,44,44,56,61,44,44,44,44,58,58,58,58,61,44,57,57,57,57,57,57,57,57,25,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,40,40,40,40,40,40,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,40,40,40,40,40,40,8,8,8,8,72,72,72,72,72,72,72,72,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,82,82,82,0,1,36,36,36,97,36,25,3,3,3,3,3,3,3,3,3,3,82,36,36,52,82,82,82,104,104,31,49,49,49,0,3,3,3,3,3,3,3,3,3,3,3,3,86,3,84,84,52,52,76,76,76,76,76,76,32,32,32,32,32,32,62,62,32,32,38,38,32,32,0,32,76,93,93,38,101,101,101,93,93,101,101,14,14,14,14,32,13,13,22,22,13,49,37,37,37,37,9,9,81,47,25,25,25,25,14,14,14,16,14,14,20,22,22,14,14,22,14,14,22,14,14,22,22,22,16,22,16,14,16,16,26,26,26,26,14,14,14,14,14,14,14,14,14,102,102,102,102,102,102,102,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,15,15,44,44,54,44,61,56,61,61,61,61,44,44,44,44,44,44,44,44,57,57,57,57,57,57,57,99,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,40,40,40,40,40,40,40,40,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,72,40,40,40,8,40,72,40,40,8,8,8,8,8,8,72,72,72,72,72,72,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,0,0,0,3,3,36,3,3,1,0,25,3,3,3,3,3,3,3,82,82,36,36,36,82,82,82,1,46,46,46,49,49,49,0,3,3,3,3,3,3,3,3,3,3,3,86,86,86,84,84,52,1,76,76,62,76,76,32,32,32,32,32,32,62,62,32,25,38,38,32,38,32,32,0,105,93,38,101,101,106,93,14,93,14,14,14,14,14,14,32,13,13,13,22,49,49,98,83,37,9,9,9,9,47,25,25,14,25,16,14,14,16,14,22,22,22,14,14,22,14,14,22,22,14,14,14,22,22,22,16,16,14,14,16,26,26,16,14,14,14,14,14,14,14,14,102,102,102,102,102,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,15,15,50,44,54,44,44,44,61,61,61,61,61,61,61,61,56,56,56,56,56,58,58,58,57,57,57,57,54,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,40,40,40,40,4,4,4,40,40,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,8,72,40,72,40,40,8,8,8,8,8,8,8,8,72,72,72,72,72,72,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,38,38,3,3,3,3,82,82,36,36,36,36,82,82,1,0,1,31,31,31,49,49,0,3,3,3,3,3,3,3,3,3,3,3,86,86,86,84,84,52,76,76,1,62,76,76,62,32,32,32,32,32,62,32,32,32,38,38,32,76,38,76,76,93,93,101,101,38,93,93,14,14,14,14,14,101,101,13,32,13,13,13,13,13,13,98,83,37,37,71,9,9,47,25,25,14,14,16,14,16,14,14,14,16,14,22,22,22,14,22,22,14,22,14,14,14,22,16,16,14,14,14,16,14,14,14,14,14,14,14,14,14,87,102,102,102,102,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,87,50,54,54,54,44,61,61,54,54,54,54,61,61,56,56,61,61,56,56,56,56,56,58,58,58,57,57,57,57,54,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,4,4,4,4,4,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,72,8,40,40,8,8,8,8,8,8,8,8,8,72,72,72,72,72,72,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,32,32,77,38,38,82,82,36,36,36,36,36,3,3,3,3,3,3,3,31,31,49,1,3,3,3,3,3,3,3,3,3,3,3,86,86,3,64,84,52,76,76,62,62,76,77,62,62,32,32,32,32,32,62,62,32,38,38,32,76,76,76,38,93,101,101,38,89,14,14,14,14,14,14,14,14,101,14,14,14,22,22,13,13,13,98,98,83,37,71,9,9,47,47,25,25,14,16,16,16,14,16,14,14,14,22,14,14,22,14,14,14,14,14,14,14,22,16,14,14,16,16,14,14,14,14,14,95,95,14,14,87,87,87,87,87,95,95,95,95,95,95,102,95,95,95,95,95,95,95,95,95,95,102,95,95,95,95,95,95,95,95,95,95,87,87,87,15,54,54,54,61,61,54,54,54,54,61,61,56,61,61,54,54,54,54,54,54,44,58,58,58,58,57,57,95,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,40,8,72,8,8,40,40,8,8,8,8,8,8,8,72,72,72,72,72,72,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,38,38,76,32,32,76,82,36,36,36,25,74,1,3,3,3,3,3,3,3,3,31,31,1,3,3,3,3,3,3,3,3,3,3,3,86,86,64,84,84,0,76,1,62,62,38,77,0,62,62,32,32,32,32,32,62,93,93,38,76,76,76,76,93,93,101,89,38,87,14,14,14,14,14,94,14,101,101,14,32,32,14,14,13,13,13,49,98,83,9,9,71,9,47,47,25,25,14,16,16,14,14,14,14,16,14,14,14,14,14,14,22,14,14,14,14,14,14,16,14,16,14,14,14,14,14,95,95,95,95,14,88,102,87,87,87,95,95,95,95,95,95,102,102,102,102,102,95,102,95,95,95,102,102,102,102,95,95,95,95,95,95,95,95,95,87,87,87,15,87,54,54,54,44,54,54,54,54,54,61,61,56,56,54,54,54,54,44,61,44,44,44,58,58,58,58,57,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,4,8,4,4,4,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,8,72,8,8,8,8,40,8,8,8,8,8,8,72,72,72,72,72,72,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,38,25,25,25,38,82,0,74,84,25,1,3,3,3,3,3,3,3,3,31,31,3,3,3,3,3,3,3,3,3,3,3,3,86,86,84,84,52,76,76,76,62,38,25,62,25,62,62,62,32,32,62,62,62,93,93,76,76,32,93,93,101,101,101,87,38,89,14,14,101,87,107,14,107,101,107,13,14,14,22,14,22,13,13,49,49,83,96,9,9,9,47,47,25,25,14,16,16,14,14,14,14,16,16,22,22,14,14,14,14,14,20,20,22,14,14,14,14,14,14,14,14,14,95,95,95,95,14,102,88,88,87,88,87,95,95,95,95,95,95,102,95,102,102,95,95,102,102,102,102,95,95,95,102,95,95,95,95,95,95,95,95,95,95,87,87,87,95,15,44,54,44,108,54,54,54,54,54,54,54,54,54,54,61,61,71,61,54,54,54,54,58,58,58,57,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,8,40,40,40,40,8,8,8,8,40,8,8,8,8,72,72,72,72,72,72,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,82,82,82,82,82,3,3,3,3,3,3,3,3,3,31,0,3,3,3,3,3,3,3,3,3,3,3,3,86,86,84,84,1,76,76,76,76,25,77,25,25,77,62,62,32,62,62,32,93,93,76,32,32,76,93,101,101,101,88,38,94,94,94,89,101,101,101,13,101,101,101,101,13,14,14,22,22,22,49,49,49,83,96,9,9,9,9,47,47,25,14,16,16,14,14,16,16,16,1,16,22,14,14,22,22,22,20,20,14,14,14,14,16,14,14,14,14,14,95,95,95,95,102,102,88,88,88,87,87,95,95,95,95,95,95,102,102,95,102,102,102,102,95,95,95,95,95,95,95,102,95,95,95,95,95,95,95,95,95,95,87,87,50,15,15,15,108,108,108,108,54,54,54,54,54,54,54,54,61,61,61,44,44,54,54,54,54,44,58,58,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,4,8,8,8,8,8,8,8,8,4,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,8,40,40,40,40,8,8,40,8,40,8,8,8,8,72,40,72,40,72,72,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,31,1,3,3,3,3,3,3,3,3,3,3,3,3,86,3,84,84,52,76,76,76,76,25,25,25,62,62,32,32,32,32,0,32,93,32,76,88,76,76,101,101,101,99,38,94,88,94,94,101,101,101,101,101,101,13,96,101,13,13,14,23,22,22,22,49,49,49,49,9,9,9,9,47,47,0,14,16,14,14,14,14,16,16,0,16,22,22,22,20,20,20,20,20,14,14,14,14,16,14,14,14,14,14,14,14,95,95,102,102,88,95,88,88,88,87,95,95,95,95,95,103,103,102,95,102,102,102,109,109,109,109,109,109,109,109,102,109,109,109,109,109,109,109,109,95,95,95,87,87,87,95,108,108,108,108,108,54,54,54,61,61,61,61,61,61,44,44,44,54,44,54,54,54,58,58,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,40,40,40,8,40,40,40,40,8,8,72,72,72,40,72,72,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,31,3,3,3,3,3,3,3,3,3,3,3,3,3,86,3,84,84,52,76,76,76,76,62,62,62,62,32,32,32,32,32,32,32,76,76,76,32,76,76,87,38,38,38,93,94,13,94,101,101,101,101,37,37,37,13,13,13,13,13,14,13,22,22,22,13,49,83,49,9,9,9,9,47,0,1,14,14,14,14,26,14,14,93,16,16,22,22,22,20,20,20,20,14,22,14,14,14,14,16,14,14,14,14,14,95,95,102,102,95,95,88,88,88,88,95,87,87,87,95,103,103,109,109,109,109,109,109,109,109,109,109,109,109,109,109,102,109,109,109,109,109,109,109,109,109,109,95,95,95,87,50,108,108,108,44,44,54,54,54,54,61,61,61,44,44,44,61,61,44,54,61,44,54,58,58,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,4,4,4,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,8,8,8,72,72,72,72,72,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,31,31,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,52,76,76,76,76,62,25,62,62,32,32,38,38,32,32,32,38,76,76,76,76,76,76,38,38,94,94,13,90,101,101,32,98,37,37,37,37,9,13,96,13,13,14,32,32,22,22,13,49,49,49,9,9,9,47,25,25,14,16,14,0,14,26,26,110,110,14,16,22,14,22,20,20,20,14,14,14,14,14,14,14,16,14,14,14,14,14,95,95,102,95,95,95,95,88,88,95,95,87,87,87,95,95,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,95,108,108,109,44,54,54,44,54,54,56,61,61,61,61,61,61,61,61,61,44,61,61,54,95,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,4,4,4,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,40,40,40,40,40,40,72,8,8,72,8,72,72,72,72,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,31,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,52,76,76,38,38,62,77,62,0,62,32,38,38,38,38,38,38,76,76,76,76,76,76,38,76,49,87,13,13,13,13,49,49,49,37,37,9,9,9,83,13,13,14,32,32,13,13,13,49,83,83,9,9,9,25,25,25,16,16,14,0,14,14,93,110,93,16,14,22,14,14,50,50,14,14,22,14,14,14,14,14,14,14,14,14,109,109,109,109,95,95,95,95,95,95,95,95,95,87,95,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,44,44,54,54,44,44,54,54,44,56,61,61,61,61,61,61,61,61,44,44,44,61,95,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,4,4,4,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,40,40,40,40,40,40,40,40,40,40,40,40,40,40,72,72,72,72,72,72,72,72,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,52,52,1,76,76,1,77,76,76,62,62,32,32,32,38,38,38,76,88,76,76,76,76,76,76,77,49,49,49,49,49,49,13,49,49,37,9,9,9,9,83,96,13,14,13,13,13,49,49,49,83,83,9,9,9,25,25,14,16,16,1,0,93,93,110,93,93,16,1,14,50,50,14,14,14,22,14,14,14,14,14,14,14,14,14,14,109,109,109,95,95,95,95,95,95,95,95,95,87,87,87,109,109,109,109,109,109,109,109,109,109,109,103,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,44,54,54,54,95,44,44,95,95,44,44,56,61,61,61,61,61,61,61,61,44,44,61,95,8,8,8,8,8,8,8,8,8,40,8,8,40,40,8,8,8,4,4,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,40,40,40,40,40,40,40,40,40,40,40,40,40,72,72,72,72,72,72,72,1,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,52,52,52,1,76,76,76,0,77,77,76,32,32,32,32,38,38,38,76,76,76,76,76,88,76,77,77,77,77,101,49,49,9,83,37,13,37,37,9,9,9,81,9,96,98,14,13,13,13,49,98,83,83,9,81,9,9,25,25,14,14,14,25,14,93,110,110,93,26,26,26,14,14,22,22,14,14,14,14,14,14,14,14,14,14,14,14,14,109,109,95,95,95,95,95,95,95,95,95,95,109,109,87,109,109,109,109,109,109,109,109,103,103,103,103,103,103,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,103,109,54,54,54,44,44,109,109,109,109,109,109,44,44,56,56,56,61,61,61,61,61,61,61,61,61,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,4,4,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,40,40,40,8,8,40,40,40,40,40,40,40,40,40,40,40,40,8,8,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,86,86,86,64,52,52,52,52,52,0,1,76,76,25,25,76,1,32,32,32,32,32,93,38,38,76,76,101,101,76,76,76,77,77,101,101,49,49,9,9,9,83,13,13,37,9,9,9,47,9,13,13,14,13,22,49,49,83,83,98,9,47,81,47,25,25,25,0,14,0,14,93,16,110,93,26,26,26,26,26,26,26,14,14,14,14,14,14,14,14,14,14,14,14,14,14,109,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,109,109,109,109,103,103,103,103,103,103,103,103,109,109,109,109,109,109,109,109,109,109,109,109,109,109,103,103,103,44,54,109,54,54,54,109,109,109,44,44,44,44,56,56,56,61,61,61,61,61,61,61,61,61,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,4,4,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,40,8,8,8,40,40,40,40,40,40,40,40,40,40,40,8,8,8,8,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,86,86,86,86,52,52,52,52,52,52,76,74,76,76,76,76,76,1,76,76,32,32,32,32,32,93,93,76,76,76,101,101,76,76,101,101,101,101,101,39,9,111,9,9,9,9,83,83,9,81,9,83,47,83,13,14,22,13,49,83,83,98,83,9,81,39,9,25,25,1,14,0,14,14,93,110,110,93,0,1,26,26,26,26,26,0,88,14,14,101,101,101,101,101,14,14,14,14,14,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,103,103,103,103,103,103,103,109,109,109,103,103,109,109,109,109,109,103,103,103,109,109,109,109,54,54,54,109,109,109,54,54,54,44,44,44,56,61,61,61,61,61,61,61,61,61,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,8,8,8,8,8,8,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,86,86,86,52,52,52,52,52,52,52,52,52,76,76,76,76,76,76,76,76,76,76,76,32,25,32,32,32,32,76,101,101,101,101,101,101,101,101,101,101,101,112,9,111,112,9,9,9,83,9,9,9,9,83,83,83,13,14,22,13,49,83,83,83,9,81,47,9,25,25,25,1,14,0,14,93,110,110,93,1,0,1,1,1,1,1,0,88,14,14,101,93,101,101,93,101,14,14,14,14,95,95,95,95,87,87,87,95,95,95,109,109,109,109,109,109,109,109,109,109,102,102,109,109,109,113,113,113,103,103,103,103,103,103,103,103,109,103,103,103,109,103,103,103,103,109,109,109,109,109,109,109,44,109,109,109,109,54,54,54,54,44,44,44,56,61,61,61,61,61,61,61,61,8,8,8,8,8,8,8,8,8,40,8,8,8,4,4,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,8,8,8,8,8,0,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,86,64,52,52,52,52,52,52,52,52,52,52,52,0,76,76,76,38,38,25,76,1,76,76,1,32,76,76,76,76,76,101,101,101,101,101,101,87,101,88,101,101,112,9,81,9,47,111,9,9,9,9,83,9,83,13,13,14,14,22,13,49,83,83,83,9,81,39,9,25,25,25,1,93,14,16,16,110,110,0,25,0,0,1,0,0,1,88,88,14,101,110,101,101,93,101,101,14,14,14,14,87,95,95,95,87,87,95,95,109,109,109,109,109,109,109,102,102,102,109,109,103,102,103,103,113,113,103,103,103,103,103,103,103,103,103,103,103,103,109,103,103,103,103,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,44,54,54,44,109,44,56,109,61,61,61,61,61,61,61,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,40,8,8,8,8,8,40,40,40,40,40,40,8,8,8,8,8,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,86,86,52,52,52,52,52,52,52,52,52,52,25,1,76,76,76,76,38,38,76,62,1,0,77,77,77,76,101,101,101,101,101,114,101,101,101,38,38,101,101,101,101,49,9,9,9,9,111,112,111,9,9,83,83,13,13,13,14,13,22,13,49,83,96,9,47,47,9,9,25,25,25,25,93,0,16,110,110,0,1,1,1,1,1,1,0,1,88,14,101,110,110,110,14,101,101,101,101,14,14,95,87,95,95,95,87,87,95,109,109,109,109,109,109,109,109,109,102,109,109,103,102,102,103,103,113,113,113,103,103,103,103,103,103,103,103,103,103,103,103,103,103,109,103,109,95,95,95,109,109,109,109,109,109,109,109,109,109,109,54,54,44,44,109,44,44,56,109,61,61,61,61,61,61,8,8,8,8,8,8,8,8,8,8,8,4,8,4,8,8,8,8,8,8,40,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,8,8,8,8,40,40,40,8,8,8,8,40,40,40,40,40,40,8,8,8,8,8,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,86,86,52,52,52,52,52,52,52,52,52,52,76,76,76,76,76,76,76,62,62,0,62,62,25,77,77,77,101,49,101,101,101,101,101,93,101,101,38,38,94,101,101,101,49,49,9,9,9,9,9,81,81,9,13,13,13,14,14,14,22,13,98,83,83,83,9,70,81,9,9,25,25,0,93,93,1,110,110,1,101,101,1,0,0,1,1,1,88,14,101,101,14,14,14,101,101,14,14,14,14,14,95,87,95,95,95,95,95,95,109,109,109,109,109,109,109,109,109,109,102,102,102,102,102,103,113,113,113,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,109,109,109,109,95,95,95,95,95,95,102,95,95,109,54,54,54,44,44,44,109,109,44,44,56,61,61,61,61,61,61,8,8,8,8,8,8,8,8,8,8,4,4,4,4,8,8,8,8,8,40,40,40,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,8,8,8,8,8,8,40,8,8,8,8,8,40,40,40,40,40,40,8,8,8,8,8,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,3,52,52,52,52,52,52,52,76,52,76,76,76,76,76,76,25,25,25,62,62,62,62,32,77,77,77,101,62,101,32,32,101,0,101,101,101,38,38,94,101,101,101,101,49,49,9,9,81,81,81,81,83,13,13,13,14,14,14,22,13,83,83,83,9,47,39,47,9,25,25,25,93,93,1,0,101,101,101,101,1,0,1,0,1,0,0,88,14,101,101,14,14,14,14,14,14,14,14,14,14,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,109,109,109,109,103,102,102,103,113,113,103,103,103,103,103,103,102,103,103,103,103,103,103,103,103,103,103,103,109,109,109,109,109,109,109,109,109,102,102,95,95,54,54,44,95,109,109,109,109,109,44,44,56,61,61,61,61,61,8,8,8,8,8,8,8,8,8,4,8,4,4,8,8,8,8,40,40,40,40,40,8,40,8,40,40,8,40,8,8,8,8,8,8,8,40,40,40,40,40,40,40,8,8,8,40,8,8,8,40,8,8,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,72,72,72,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,64,52,52,52,52,52,52,52,77,77,76,76,3,76,76,76,0,25,25,25,1,32,32,32,32,77,77,101,32,101,62,32,101,101,101,93,101,38,38,94,94,98,98,49,49,49,49,49,9,81,9,112,47,83,83,13,13,13,13,13,13,83,83,37,37,9,47,47,47,9,25,0,0,93,1,0,0,101,1,101,1,101,1,1,1,0,1,110,101,101,14,14,14,14,14,14,14,14,14,14,14,14,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,109,109,109,109,103,103,102,103,103,103,103,103,103,103,103,103,102,103,103,103,103,103,103,103,103,103,103,103,103,103,103,109,109,109,109,109,109,102,109,102,109,95,95,95,95,95,95,95,109,109,109,44,44,61,61,61,61,61,8,8,8,8,8,8,8,8,8,4,4,8,8,8,8,40,40,40,40,40,40,40,40,8,40,40,40,8,8,40,8,8,8,8,8,40,40,40,40,40,40,8,8,8,8,40,40,40,40,40,40,40,8,8,8,8,8,40,40,40,40,40,40,8,8,72,72,8,72,72,72,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,86,0,52,52,52,52,52,52,77,77,77,76,25,77,77,76,62,0,25,76,25,32,32,32,32,32,77,101,49,49,101,62,101,101,101,101,0,93,93,101,93,94,110,110,0,0,101,98,49,111,9,81,81,9,83,83,13,13,13,13,13,37,83,98,37,9,9,9,47,9,9,25,1,93,0,0,1,101,101,1,1,110,101,0,1,1,1,110,110,101,110,14,14,14,14,14,14,14,95,95,95,95,14,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,109,109,109,109,103,103,103,103,103,103,103,103,103,103,103,103,103,102,103,103,103,103,103,103,103,103,103,103,103,103,103,103,109,109,109,109,109,102,102,109,109,109,109,109,109,109,109,109,109,109,109,95,44,54,61,61,61,61,8,8,8,8,8,8,8,8,8,4,8,8,8,8,40,40,40,40,8,8,40,40,8,8,40,8,8,8,40,40,8,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,8,40,40,40,40,40,40,8,8,72,72,8,72,72,72,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,86,3,52,52,52,52,52,52,52,77,77,1,77,38,38,38,1,76,62,25,76,76,32,32,32,32,32,77,32,101,101,101,1,38,101,101,101,101,107,93,93,93,93,110,110,110,98,98,101,98,49,9,9,9,9,9,83,83,49,49,13,49,37,83,83,47,9,9,47,9,9,25,25,93,93,110,101,101,101,101,0,110,110,101,0,25,1,0,0,110,110,110,110,110,14,14,14,14,14,95,95,95,14,95,95,95,95,95,95,87,87,87,87,109,109,109,109,109,109,109,109,109,109,109,103,103,103,103,103,103,103,109,109,103,103,103,103,103,103,103,103,113,103,103,103,103,103,103,103,103,103,103,103,103,103,103,109,102,102,109,109,109,109,109,109,109,109,109,109,109,109,109,109,54,54,61,61,61,8,8,8,8,8,8,8,8,8,40,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,40,40,40,40,40,40,8,8,72,8,8,72,72,72,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,86,86,52,52,52,52,52,52,52,76,77,77,1,38,38,77,77,38,76,0,76,76,76,32,32,38,38,32,101,101,25,25,25,25,77,101,101,101,101,101,38,101,101,93,93,110,101,101,101,101,101,49,49,111,9,81,83,83,83,83,49,49,49,37,37,47,47,9,9,9,9,25,25,25,93,0,1,101,101,0,0,1,110,0,101,1,0,1,1,0,1,0,14,14,110,14,14,14,14,14,14,95,95,95,95,95,95,95,95,95,87,87,87,109,87,87,109,109,109,109,109,109,103,103,103,103,109,103,103,103,103,103,109,109,103,103,103,103,103,103,103,113,113,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,109,109,109,109,109,109,109,103,109,109,109,44,54,54,54,54,61,61,109,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,40,40,40,40,40,8,8,72,8,8,72,72,72,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,64,52,52,52,52,52,52,76,76,52,52,77,25,25,1,77,77,76,76,0,76,1,77,62,32,32,38,38,101,32,101,25,25,77,77,25,25,101,38,38,38,107,93,94,94,101,101,0,0,94,101,94,49,9,9,9,81,83,47,47,96,83,83,83,47,47,9,9,9,9,25,25,25,93,93,1,101,101,110,110,93,93,110,110,101,101,0,0,1,0,1,0,14,14,14,16,14,14,14,14,14,95,14,95,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,103,103,109,109,103,103,103,103,103,103,103,103,109,109,103,103,103,103,103,113,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,109,109,103,103,103,103,103,103,44,44,54,54,54,54,54,44,56,109,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,8,8,72,8,1,72,72,72,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,52,52,52,52,52,52,76,77,77,77,77,25,25,77,77,1,1,76,77,77,77,77,77,32,32,32,38,101,38,38,38,115,77,77,0,115,0,107,38,38,101,93,93,101,101,101,101,98,98,94,0,49,49,111,9,81,9,47,47,47,83,83,83,47,47,9,9,39,25,25,94,93,93,93,101,101,101,93,93,110,110,1,110,110,101,101,1,0,1,0,1,14,14,16,16,16,14,14,14,14,14,14,14,95,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,109,109,109,109,109,109,103,109,103,103,103,103,103,103,103,103,103,103,113,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,109,109,109,109,103,44,109,54,54,54,54,54,54,44,44,109,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,40,40,40,40,72,72,72,8,72,72,72,72,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,77,52,52,52,52,52,76,76,25,77,77,25,25,77,77,52,52,76,77,77,77,77,77,77,32,32,32,38,38,38,38,38,115,101,77,77,0,0,115,101,115,1,115,110,94,93,93,94,94,115,115,0,98,49,49,111,81,81,81,9,83,83,83,47,39,9,9,39,25,25,94,1,93,94,101,101,101,93,93,94,94,110,110,110,110,1,101,101,0,1,0,1,88,14,16,16,16,14,14,14,14,14,14,14,14,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,103,103,103,103,103,103,113,113,113,113,103,103,103,103,103,109,109,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,44,54,54,54,54,54,109,44,44,109,109,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,40,40,40,40,40,8,72,72,8,72,72,72,72,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,77,1,77,77,52,52,52,52,76,76,76,25,77,77,25,77,77,52,52,52,1,77,77,77,77,77,77,77,77,77,1,25,0,25,38,38,101,115,0,0,115,115,110,115,115,110,115,115,115,94,93,101,115,115,98,0,98,49,9,9,81,9,9,9,9,9,9,9,9,47,25,25,25,94,94,94,101,101,101,93,94,94,94,94,94,94,110,93,94,0,101,101,101,101,25,110,110,16,16,16,14,14,14,14,14,14,14,14,14,88,88,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,102,102,109,103,103,103,103,103,113,113,103,103,103,103,103,103,109,109,109,109,109,103,103,103,103,103,103,103,103,103,113,103,103,103,103,103,103,44,54,54,54,54,54,54,56,56,44,56,109,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,40,40,40,40,8,8,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,77,62,62,52,52,52,52,75,76,76,76,25,25,77,77,77,77,77,52,52,52,52,77,77,77,77,38,38,77,77,77,77,1,25,1,38,101,101,110,115,115,115,115,110,115,115,115,115,94,94,94,93,115,0,115,98,0,101,49,49,9,9,9,9,9,9,9,9,9,47,25,0,1,1,1,94,94,101,101,94,94,94,94,94,94,94,94,93,93,94,94,101,101,101,101,101,101,14,110,16,110,16,14,14,14,14,14,14,14,88,87,88,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,102,102,109,103,103,103,103,103,103,103,103,103,103,103,103,103,109,109,109,103,109,109,109,103,103,103,103,113,113,113,113,103,103,103,103,103,103,54,54,54,103,54,54,56,56,56,56,109,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,4,8,8,8,8,8,8,8,8,8,8,8,72,72,8,8,40,40,40,8,8,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,77,62,52,52,52,52,52,76,76,77,77,25,52,77,77,77,77,52,52,52,52,52,1,77,77,77,38,38,38,77,77,77,77,82,25,101,101,76,76,110,110,0,0,0,115,0,0,115,115,94,94,110,115,101,115,98,0,101,98,49,49,111,9,9,9,9,81,9,25,25,25,1,93,93,93,94,101,101,101,94,94,94,93,93,93,93,93,93,94,94,94,94,94,1,0,101,101,101,101,101,16,16,16,14,14,14,14,14,14,14,87,87,87,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,109,109,109,109,109,109,102,102,102,109,109,103,103,103,103,103,103,103,103,103,103,103,103,103,103,109,109,103,103,109,103,103,103,103,113,113,103,103,113,113,103,103,103,103,103,103,103,44,54,54,54,44,56,56,109,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,4,4,4,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,40,40,40,8,8,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,77,52,52,52,52,52,76,52,77,77,77,77,25,77,77,77,52,52,0,52,52,52,52,32,77,77,77,77,77,25,101,77,77,0,25,76,101,76,76,77,77,110,0,0,93,115,115,115,115,115,110,115,94,1,98,0,101,101,98,49,9,9,9,9,81,39,25,96,96,25,0,25,1,94,94,101,101,94,94,101,101,110,93,93,94,94,93,93,93,94,94,94,94,94,94,1,101,101,14,16,16,16,16,14,14,14,14,14,14,87,87,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,88,88,109,109,109,102,102,109,109,109,99,99,99,99,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,113,113,113,113,113,113,113,113,113,103,103,103,103,103,44,44,44,54,54,54,56,103,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,40,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,4,40,4,40,8,8,8,8,8,8,8,8,8,72,40,40,40,8,40,40,40,8,8,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,77,52,52,52,52,76,76,77,77,77,77,76,76,77,52,52,52,0,3,52,52,52,52,52,32,77,77,77,77,25,101,25,77,75,25,25,110,76,76,76,77,77,25,0,110,0,115,93,93,115,115,94,94,94,98,98,98,101,101,101,101,9,9,9,9,9,101,101,101,25,25,0,110,101,101,101,101,101,101,101,94,110,110,110,94,94,93,93,93,93,94,94,94,94,94,94,94,1,14,16,16,16,16,16,14,14,14,14,14,14,87,87,95,95,95,95,95,95,95,95,95,109,109,109,88,88,88,88,88,88,109,102,102,109,109,99,99,99,99,99,99,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,113,103,103,103,113,113,113,113,113,103,103,103,103,103,103,44,54,54,103,54,103,103,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,40,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,4,4,40,8,8,8,8,8,8,8,8,40,40,40,8,40,40,40,8,8,8,72,72,72,72,0,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,42,42,75,3,3,1,52,52,52,75,76,52,77,77,77,76,76,76,52,52,52,3,3,3,52,52,52,52,52,52,0,77,77,77,38,101,101,25,25,25,25,110,25,101,76,110,77,110,0,0,0,0,115,93,93,93,0,1,94,1,94,0,101,25,0,25,101,101,101,101,101,101,25,25,0,0,0,94,94,101,101,101,101,101,110,94,110,110,94,94,93,93,93,93,94,94,94,94,94,94,93,93,14,1,14,16,16,16,16,14,14,14,14,14,14,14,14,88,1,95,95,95,95,95,95,95,95,95,88,88,88,87,87,87,87,87,99,99,99,99,109,109,99,99,109,99,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,113,103,103,103,103,103,103,113,103,103,103,103,103,103,103,103,103,44,44,44,54,103,103,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,40,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,4,4,4,4,4,4,4,4,8,8,8,8,8,8,72,40,40,40,40,8,8,8,8,8,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,42,75,75,0,3,3,1,52,52,52,76,76,52,52,77,52,52,52,52,52,3,3,3,3,52,52,52,52,52,52,52,77,77,77,38,38,101,101,101,101,101,110,110,101,101,101,101,0,0,101,1,1,110,0,93,1,1,1,110,110,0,110,94,25,101,101,101,101,25,0,25,0,25,0,1,1,94,94,94,94,110,110,110,94,94,94,110,110,94,94,93,94,94,94,94,94,94,94,94,93,93,14,14,93,16,16,16,16,16,14,14,14,28,14,14,16,16,14,88,0,95,95,95,95,95,95,95,88,95,95,87,87,87,95,87,87,99,99,109,109,109,109,109,109,99,99,109,103,103,102,103,103,103,103,103,103,103,103,103,103,103,103,113,113,113,103,103,103,103,103,103,113,103,103,109,103,103,103,103,103,103,44,44,44,44,103,103,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,40,8,40,8,8,8,40,8,8,8,8,8,8,40,40,40,40,40,4,4,4,4,4,4,4,4,8,8,8,8,8,8,72,40,40,40,40,8,8,8,8,8,8,72,72,72,72,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,42,42,75,75,75,75,3,3,52,52,52,52,52,52,52,52,52,52,52,52,3,3,3,3,3,1,52,52,52,52,52,0,77,77,77,38,38,25,77,77,0,101,101,25,110,101,101,101,101,101,101,0,1,1,110,93,93,110,94,94,94,110,110,94,101,101,101,101,101,1,0,1,1,1,101,110,110,93,93,94,94,110,110,110,94,94,101,101,101,94,94,93,93,93,93,93,93,94,94,94,93,14,14,14,16,16,16,14,16,14,14,14,28,28,28,14,14,16,14,14,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,87,87,87,109,109,109,109,109,109,109,109,109,109,103,102,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,109,109,103,103,103,103,103,103,44,44,103,103,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,40,40,40,40,40,40,4,4,4,4,4,8,8,8,8,8,8,8,8,8,72,40,40,40,40,40,40,8,72,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,42,42,75,75,75,75,75,42,3,52,52,74,52,52,52,52,52,52,52,25,3,3,3,3,3,3,1,1,52,52,52,52,52,52,77,77,77,38,25,25,77,77,0,101,101,25,110,110,101,110,101,110,101,1,0,0,45,110,110,94,94,110,94,94,1,94,101,101,94,94,101,101,101,101,94,94,93,93,93,93,94,94,94,110,94,94,94,101,101,101,101,101,101,94,94,94,94,94,94,94,93,14,14,14,14,16,16,14,16,16,14,28,28,28,28,28,14,14,16,14,14,14,95,88,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,109,102,109,102,102,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,109,103,103,103,103,103,103,44,103,103,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,40,8,40,8,8,8,8,8,40,40,40,40,40,40,4,4,4,4,4,4,8,8,8,8,8,8,8,8,72,72,40,40,40,40,40,8,72,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,42,42,75,75,75,75,75,75,42,3,52,52,52,52,52,52,52,52,3,1,3,3,3,3,3,3,3,0,1,1,25,52,52,52,52,52,52,52,77,77,77,77,77,77,77,101,25,25,110,101,101,101,101,101,0,110,0,93,93,45,45,101,45,0,94,94,94,101,94,1,1,94,93,94,101,94,94,94,93,94,94,94,101,93,110,94,94,94,101,101,110,110,101,101,101,101,94,94,94,94,93,93,14,14,14,16,16,16,94,16,94,28,28,28,28,28,28,14,14,16,16,14,95,95,95,95,95,95,95,99,95,95,95,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,102,102,102,109,103,103,103,109,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,109,109,109,103,103,103,103,103,103,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,40,8,8,8,8,4,4,8,4,8,8,8,8,8,8,8,8,8,72,8,8,40,40,40,40,40,8,72,8,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,42,42,42,75,75,75,75,75,75,42,3,52,52,52,77,77,77,52,52,3,3,3,3,3,3,3,3,3,3,3,25,25,3,52,52,52,52,52,52,52,77,77,77,77,77,77,77,101,25,110,1,101,101,110,110,101,110,110,93,45,45,35,101,101,101,101,101,94,0,93,93,94,93,93,101,101,94,94,110,110,110,94,94,101,94,94,94,94,94,101,94,94,94,101,94,110,101,101,94,94,93,93,14,14,14,16,16,16,94,14,94,14,14,28,28,28,28,14,14,14,14,16,14,14,14,14,14,95,99,99,99,99,99,99,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,109,109,109,109,109,103,103,109,109,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,109,109,103,103,95,109,109,103,103,103,103,103,103,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,8,40,40,40,40,40,8,72,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,42,42,75,75,75,75,75,75,75,42,3,3,77,77,77,38,77,77,3,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,25,52,52,52,52,77,77,77,77,77,77,77,101,25,25,110,25,101,25,101,110,1,110,101,101,101,45,35,45,101,101,101,101,1,93,93,94,94,94,94,101,94,101,101,94,101,101,101,101,94,94,94,94,101,101,94,94,94,110,110,110,101,101,94,94,93,94,14,14,16,16,110,110,14,14,14,14,14,110,28,14,14,14,16,16,16,14,14,14,16,16,14,14,88,99,99,87,95,99,95,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,103,103,103,103,103,103,103,109,103,103,103,103,103,103,103,103,103,103,109,109,109,103,103,103,103,95,103,103,103,103,103,103,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,40,40,40,40,40,40,8,8,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,42,42,75,75,75,75,75,75,75,42,3,3,77,77,38,38,62,77,77,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,52,52,52,77,77,77,77,77,0,101,25,110,110,25,101,101,101,101,25,45,101,101,101,45,25,41,94,101,101,101,94,94,94,94,94,94,101,101,101,101,101,101,101,94,94,94,93,93,93,94,101,101,94,94,94,110,110,94,110,94,94,93,14,14,14,14,16,93,93,93,93,93,110,110,110,110,94,94,14,88,88,88,16,16,16,14,16,14,16,16,14,87,87,87,87,87,87,95,95,95,95,95,95,95,103,103,103,109,109,109,109,109,109,109,109,109,109,109,109,103,103,103,103,103,103,103,103,103,109,103,103,103,103,103,103,103,103,103,103,109,103,103,109,103,103,103,103,103,103,103,103,103,103,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,72,40,40,40,40,40,40,40,8,8,72,72,72,72,72,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,75,75,75,75,75,1,42,75,75,42,3,3,77,38,38,38,62,77,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,52,52,52,52,25,77,77,77,77,101,25,25,110,110,25,110,110,25,25,1,1,101,101,101,0,35,101,1,94,94,94,93,93,94,94,94,94,93,94,94,94,94,93,93,94,93,93,93,94,94,101,101,94,94,94,110,94,110,94,94,94,93,93,94,14,14,93,93,110,110,110,110,14,93,93,93,93,110,110,110,88,88,16,16,16,16,16,14,14,16,14,14,14,1,25,95,87,87,95,95,95,95,103,103,103,103,103,103,109,109,109,109,109,109,109,109,109,109,109,109,103,103,103,103,103,103,103,103,109,109,103,103,103,103,103,103,103,103,103,109,103,103,109,103,103,103,103,103,103,103,103,103,103,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,40,40,8,40,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,72,40,40,40,40,40,40,40,40,72,72,72,72,72,72,72,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,42,75,75,52,75,42,3,42,75,42,3,3,77,38,38,38,62,77,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,52,52,52,52,0,77,77,77,101,25,93,110,110,25,101,110,110,110,110,110,110,110,101,101,101,101,94,94,94,94,93,94,110,110,94,94,93,94,94,94,94,94,93,93,93,93,94,94,94,101,94,94,94,94,110,110,110,94,94,94,93,93,93,93,93,93,93,94,94,110,93,93,93,93,93,93,93,110,87,87,88,16,16,16,16,16,16,16,16,14,14,14,14,14,0,95,95,95,95,95,103,103,103,103,103,103,103,103,103,109,109,109,109,109,109,109,109,109,109,109,103,103,103,103,103,103,103,109,109,103,103,103,103,103,103,103,103,109,109,109,103,109,103,103,103,103,103,103,103,103,103,103,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,40,40,40,40,40,40,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,72,40,40,40,40,40,40,40,40,8,72,72,72,72,72,72,72,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,42,75,75,75,75,3,3,42,42,42,3,77,62,38,38,62,62,77,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,52,52,52,52,77,77,77,77,101,101,93,93,110,110,101,110,110,25,1,0,1,94,94,94,94,94,94,94,94,94,110,110,94,94,94,93,93,94,94,93,93,93,93,93,1,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,93,93,93,93,94,94,94,94,94,93,93,93,14,14,14,93,93,93,93,87,88,16,16,16,16,14,16,14,14,14,14,14,14,14,14,14,95,95,95,95,95,103,103,103,103,103,103,103,103,103,109,109,109,109,109,109,109,103,103,103,109,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,109,109,103,103,103,103,103,103,103,103,103,103,8,8,8,8,8,8,8,8,8,40,40,40,40,8,40,40,40,40,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,40,40,40,40,40,40,40,40,8,72,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,42,75,42,3,3,3,3,3,3,3,3,77,38,38,38,77,77,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,52,52,52,0,77,77,77,77,101,101,110,25,110,25,101,94,94,45,94,94,93,93,94,94,1,0,94,1,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,110,110,101,101,94,94,94,94,94,93,14,14,14,14,14,87,87,87,87,87,16,16,14,16,16,16,14,14,14,14,14,14,95,95,95,14,95,95,95,95,95,95,95,95,103,95,103,103,103,109,109,109,109,109,109,109,109,95,109,103,109,109,103,103,103,103,103,103,103,103,103,103,109,109,103,103,103,103,103,103,103,109,103,103,103,103,103,103,103,103,103,103,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,40,40,8,40,40,40,40,40,40,40,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,40,40,40,40,40,40,40,40,8,8,72,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,77,85,62,77,77,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,52,52,52,77,77,77,77,101,101,110,94,94,94,101,101,94,94,94,94,94,94,94,0,0,0,94,1,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,116,116,117,117,117,117,117,117,117,117,94,94,94,94,94,94,94,94,110,101,101,94,94,94,94,94,93,93,14,14,14,14,87,87,28,16,16,16,16,16,16,16,16,14,87,14,87,14,95,14,14,14,95,95,95,95,95,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,109,103,103,109,109,103,103,103,103,103,103,103,103,103,103,103,103,109,103,103,103,103,103,103,103,103,103,103,103,103,103,103,109,103,103,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,40,40,40,40,40,40,40,40,8,8,72,72,72,72,72,72,72,72,2,2,2,2,2,2,2,2,1,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,77,77,77,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,52,25,77,77,77,77,101,101,25,94,25,94,94,101,101,101,101,101,101,0,0,0,1,1,94,1,0,0,94,117,117,117,117,117,117,117,117,117,117,116,116,116,116,116,116,116,116,116,117,117,117,117,117,116,116,116,94,94,94,110,110,110,101,94,94,94,94,94,93,93,14,14,14,28,28,28,16,16,16,16,16,87,87,87,14,87,87,95,95,95,95,95,95,14,14,95,95,95,95,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,103,103,103,103,103,103,103,103,103,103,103,103,113,113,113,103,103,109,103,103,103,103,103,103,103,103,103,103,103,103,103,109,103,103,8,8,8,8,8,8,8,8,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,40,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,40,40,40,40,40,40,8,8,72,72,72,72,72,72,72,72,72,0,2,2,2,2,1,72,72,72,72,72,72,72,72,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,101,1,77,77,101,101,101,101,25,94,25,94,101,101,110,117,117,117,117,117,117,117,117,1,1,0,116,117,117,117,117,117,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,94,94,110,110,110,101,101,94,94,94,94,93,94,14,14,14,28,28,28,28,94,16,16,16,87,87,14,14,87,87,14,14,14,14,14,95,14,14,14,95,14,95,95,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,109,109,109,103,113,113,103,103,103,103,103,113,113,113,113,103,103,109,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,8,8,8,8,8,8,8,8,40,40,40,8,40,8,8,8,40,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,40,40,40,40,40,40,40,8,8,8,72,8,8,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,101,101,101,101,101,101,25,25,101,94,94,94,101,101,110,117,117,116,116,116,116,116,116,116,116,116,116,116,117,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,94,94,93,110,110,110,101,101,94,94,94,94,94,14,14,14,14,28,28,28,16,16,16,87,94,14,87,14,14,14,14,14,95,95,95,95,88,88,88,14,95,14,95,95,87,87,87,87,95,95,95,95,95,109,109,109,109,109,109,109,109,109,103,109,113,113,113,103,103,103,103,103,113,113,113,103,103,103,109,103,103,103,103,103,103,109,109,103,109,103,103,103,103,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,8,40,40,40,40,40,40,8,8,8,72,72,72,8,8,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,4,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,101,25,25,101,101,101,101,101,94,94,94,101,101,110,110,117,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,94,94,110,110,110,101,107,101,101,94,94,94,94,110,14,14,14,14,14,94,16,16,16,94,94,14,87,14,14,14,14,14,95,95,87,88,88,87,87,87,87,14,14,87,87,87,87,87,87,87,95,95,95,95,109,109,109,109,109,109,109,109,109,109,113,113,109,103,103,103,103,103,103,103,103,103,103,103,103,109,103,103,103,109,109,103,109,109,109,103,103,103,103,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,40,40,72,8,72,8,8,8,8,72,72,72,72,72,72,72,72,72,72,72,72,72,72,4,4,4,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,94,101,101,25,25,94,94,101,101,94,101,101,110,117,117,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,94,94,94,110,110,101,101,101,101,101,94,94,94,110,93,93,14,14,14,14,14,14,14,94,94,14,14,14,14,14,14,14,14,95,87,87,87,87,95,14,87,87,87,87,87,87,95,95,87,87,87,95,95,95,109,109,109,109,109,109,109,109,109,113,113,113,113,109,103,103,103,103,103,103,103,103,103,103,103,103,109,109,109,109,109,103,109,109,109,109,103,103,103,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,40,8,72,8,8,8,8,8,8,72,72,72,72,8,8,8,72,72,8,72,72,8,4,4,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,25,84,84,84,25,0,3,3,94,94,25,25,94,94,101,101,101,94,101,101,117,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,94,94,94,110,101,101,101,101,101,101,94,94,94,94,93,93,14,14,14,14,14,14,14,94,94,94,14,14,14,14,14,14,14,14,88,95,95,14,95,95,14,14,87,87,87,87,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,109,109,113,113,113,109,103,103,103,103,103,103,103,103,103,103,103,103,109,109,109,109,103,109,109,109,109,103,103,103,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,40,72,72,8,72,72,8,8,8,72,72,8,8,8,8,8,8,72,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,84,84,84,84,0,0,3,1,94,94,93,94,94,94,94,94,94,1,1,110,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,94,94,94,94,94,101,101,101,101,101,94,94,94,93,93,110,110,110,14,14,14,94,94,94,14,14,14,14,14,16,14,14,14,1,14,88,95,95,95,95,14,14,14,14,14,87,87,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,109,109,95,95,109,103,103,103,103,103,103,103,103,103,103,103,103,103,109,103,103,109,103,109,109,103,103,103,103,8,8,4,4,4,4,4,4,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,40,8,8,40,40,40,40,40,40,40,40,72,72,8,8,72,8,8,72,72,8,72,72,8,8,8,8,72,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,42,86,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,84,84,84,84,0,0,25,3,3,3,1,1,1,94,94,93,94,94,94,94,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,94,94,94,94,94,94,101,101,101,101,94,94,94,93,93,94,94,110,110,110,94,94,94,14,14,14,14,94,16,16,16,14,14,16,14,88,14,95,95,95,95,14,14,14,14,14,87,95,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,109,109,95,95,109,103,103,103,103,103,103,103,103,103,103,103,103,109,103,103,109,109,109,109,103,103,103,109,8,8,4,4,8,40,40,40,4,4,4,40,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,8,8,8,8,72,8,40,40,40,8,8,8,8,8,72,8,72,8,8,8,72,8,8,8,8,72,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,86,86,86,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,84,1,84,74,0,0,1,0,116,116,116,116,116,0,93,93,94,94,94,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,118,116,116,116,116,116,116,116,116,116,116,116,116,116,94,94,94,94,94,94,94,101,101,101,94,94,94,94,93,94,94,94,94,94,94,94,14,14,14,14,14,93,16,16,16,14,14,16,16,16,14,14,14,95,95,95,95,95,95,14,14,95,95,95,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,109,95,95,109,109,103,103,103,103,103,103,103,103,103,103,109,109,103,109,109,109,109,103,99,103,109,8,8,4,4,4,40,4,4,4,4,4,4,40,40,40,8,40,40,40,40,8,40,40,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,40,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,72,72,72,72,72,72,8,8,8,72,8,8,8,8,8,8,8,72,72,8,8,8,72,8,8,8,8,8,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,86,86,86,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,85,101,101,1,1,0,0,116,116,116,116,116,116,0,94,94,94,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,118,118,118,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,117,94,94,94,94,94,94,94,110,101,101,101,94,110,110,110,94,94,94,94,94,94,110,14,14,14,110,93,16,16,16,16,14,14,14,14,16,16,14,14,14,14,95,95,95,95,95,14,95,95,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,109,103,95,103,103,103,103,103,103,103,103,103,103,103,103,103,109,109,109,109,109,99,109,99,103,103,8,8,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,40,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,72,8,72,72,8,8,8,72,8,8,8,8,8,8,8,8,72,72,8,8,8,72,72,8,8,8,8,8,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,86,42,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,85,101,101,101,101,0,1,116,116,116,116,116,116,116,0,94,94,116,116,116,116,116,116,116,116,116,116,116,116,116,118,116,116,116,116,116,116,116,116,116,116,116,116,118,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,117,117,94,94,94,94,94,94,94,94,94,110,94,94,94,110,110,94,94,94,94,94,110,110,110,110,110,93,94,16,16,16,16,14,14,14,14,16,16,14,14,14,14,14,14,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,103,103,109,103,95,103,103,103,103,103,103,103,103,103,103,103,103,109,103,109,109,99,99,99,99,99,99,8,8,8,8,4,4,4,4,4,8,4,4,4,4,4,4,4,4,4,4,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,72,72,72,72,72,8,8,8,8,8,8,8,72,72,72,8,8,72,72,72,72,8,8,8,8,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,42,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,85,85,101,101,1,101,101,1,25,116,116,116,116,116,116,116,116,0,25,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,117,117,117,116,116,116,116,117,0,0,0,94,94,94,94,94,94,94,101,101,101,94,110,110,94,94,94,94,94,94,94,94,94,93,14,94,16,16,16,16,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,95,95,95,95,95,95,95,95,95,95,95,95,95,109,109,109,109,103,103,103,103,103,103,103,109,103,103,103,103,103,103,103,103,103,103,109,109,99,99,99,99,109,103,103,8,8,8,8,4,4,4,4,4,4,4,4,4,4,4,4,4,8,8,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,40,40,8,40,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,8,8,72,72,72,72,72,72,72,8,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,42,42,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,84,3,84,84,84,85,101,101,101,74,101,101,101,0,1,0,116,116,116,116,116,116,116,3,1,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,117,117,117,117,117,117,117,117,1,1,1,1,94,94,94,94,94,94,101,101,101,101,101,110,110,94,94,94,94,94,94,94,94,93,93,14,14,16,93,16,14,16,16,16,16,16,16,14,14,14,14,14,14,95,14,14,95,95,95,95,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,103,103,109,109,109,103,103,103,103,103,103,103,103,103,109,109,109,99,109,99,99,103,103,8,8,8,8,8,8,4,4,4,4,4,4,4,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,40,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,72,72,8,8,72,8,72,8,8,72,8,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,42,42,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,84,84,84,84,84,84,84,0,0,101,101,101,74,101,101,0,1,101,0,0,1,116,116,116,116,116,116,0,0,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,117,117,1,101,101,1,117,3,3,1,3,0,1,94,94,94,94,94,110,101,101,101,101,101,101,94,94,94,94,94,94,93,93,94,93,14,93,93,93,14,14,14,16,16,14,14,14,14,14,14,14,14,14,95,95,14,14,95,95,95,95,95,95,95,95,95,95,95,95,109,109,109,109,103,103,103,103,95,95,103,103,103,103,103,103,103,103,103,103,103,103,109,109,109,103,99,99,103,103,8,8,8,8,8,40,40,40,4,4,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,8,72,8,72,72,72,8,8,8,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,42,42,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,1,1,101,85,101,101,101,94,94,101,101,101,101,101,101,1,1,25,116,116,116,116,116,116,1,0,116,116,116,116,116,116,116,116,116,116,116,116,118,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,101,101,101,101,1,101,101,0,3,1,0,0,94,94,94,93,93,93,93,93,94,110,101,101,94,94,94,94,94,110,93,110,93,14,93,93,16,16,16,16,14,16,16,14,14,14,14,14,14,14,14,14,14,95,14,14,95,95,95,95,95,95,95,95,95,95,95,95,109,109,109,109,103,103,103,103,103,103,103,109,103,103,103,103,103,103,103,103,103,109,109,109,109,103,103,103,103,8,8,8,8,8,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,40,8,8,8,72,72,8,8,72,72,8,8,8,8,8,72,8,72,72,72,72,72,72,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,42,42,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,84,0,101,85,85,101,45,45,101,101,94,94,1,101,0,101,0,25,0,1,0,1,116,116,116,116,116,0,0,116,116,116,116,116,116,116,116,116,116,116,116,118,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,117,1,101,101,94,101,101,101,101,3,116,116,1,1,94,94,94,94,93,93,93,93,110,110,94,94,94,94,94,94,94,94,110,93,93,93,16,16,16,16,16,16,16,14,16,16,14,14,14,14,14,14,14,14,14,95,14,14,95,95,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,109,109,95,95,103,103,109,103,103,103,103,103,103,103,103,109,109,103,109,109,103,103,103,8,8,8,8,8,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,40,40,40,40,40,8,8,8,8,8,8,40,8,40,8,8,8,72,8,8,8,72,8,8,72,72,8,8,72,72,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,0,101,101,101,101,45,45,45,101,101,0,0,0,101,0,0,25,1,0,3,1,25,25,116,116,116,0,1,1,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,117,3,101,101,101,94,101,101,0,117,116,116,116,116,116,94,94,94,94,94,94,93,93,110,94,94,94,94,93,94,94,94,110,110,14,93,14,94,16,16,16,16,16,16,16,16,14,14,14,14,14,14,14,95,95,95,95,95,95,95,95,95,95,103,103,95,95,95,95,95,109,109,109,109,109,109,109,109,103,103,103,109,109,103,103,103,103,103,103,103,103,103,103,109,103,103,103,103,8,8,8,8,8,40,40,40,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,40,8,72,8,8,8,8,8,8,72,8,8,8,8,72,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,84,84,1,101,101,101,101,101,45,45,94,101,101,0,1,101,101,1,1,25,0,84,0,1,0,25,1,0,1,1,25,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,117,101,45,45,94,101,101,0,0,116,117,116,116,116,116,116,116,94,94,94,94,94,93,93,93,94,94,94,93,93,93,93,94,110,93,93,94,14,14,16,16,16,16,14,16,16,14,14,14,14,14,14,95,95,95,95,95,95,95,95,95,95,103,103,103,103,95,95,95,95,95,109,109,109,109,109,109,103,103,95,103,109,109,103,103,103,103,103,103,103,103,103,109,109,103,103,103,103,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,40,40,40,8,8,8,8,8,8,8,40,8,8,8,8,72,8,8,8,8,8,8,72,72,8,8,8,8,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,84,25,85,101,101,107,101,45,41,41,94,101,101,101,101,101,1,0,1,1,25,25,36,1,25,1,0,0,1,25,0,25,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,117,117,1,101,101,101,94,94,101,0,1,116,117,116,116,116,116,116,116,116,116,94,94,94,94,94,93,93,93,93,94,94,101,93,93,94,94,110,110,94,14,94,16,16,16,14,14,16,14,14,14,99,14,14,88,88,88,95,95,95,95,95,95,103,103,103,103,95,95,95,95,95,95,109,109,109,109,109,109,103,103,103,103,109,109,109,103,103,103,103,103,103,103,103,103,109,109,103,103,103,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,40,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,8,8,8,8,8,8,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,84,84,84,0,85,101,101,101,41,45,45,45,115,101,101,101,101,101,41,25,25,94,94,0,25,74,0,0,25,3,0,25,0,101,101,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,117,117,1,101,101,101,101,94,94,101,0,0,117,117,116,116,116,116,116,116,116,116,116,116,94,94,94,94,94,94,94,94,94,101,101,93,94,94,94,110,110,110,110,101,101,101,14,14,14,14,14,14,99,99,99,99,88,88,95,95,95,103,95,103,103,103,103,95,95,95,95,95,95,95,109,109,109,109,109,109,103,109,103,103,95,109,109,103,103,103,103,103,103,103,103,103,103,109,103,103,103,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,0,85,101,101,101,94,45,45,0,115,115,0,101,1,0,101,41,41,1,94,41,94,0,25,0,1,0,0,1,45,45,101,101,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,117,1,101,101,101,94,101,94,101,101,101,1,117,116,116,116,116,116,116,116,116,116,116,116,116,116,94,94,94,94,94,94,94,101,101,101,101,101,101,94,94,101,101,101,101,14,14,14,14,14,14,14,14,87,99,87,88,95,95,95,103,103,103,103,103,103,109,95,95,95,95,95,95,95,95,109,109,109,109,109,109,103,109,109,95,95,109,103,103,103,103,103,103,103,103,103,103,109,109,103,103,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,85,101,101,101,93,94,45,45,115,115,115,0,101,1,1,101,41,41,41,41,41,94,1,25,1,101,101,1,25,0,45,45,101,101,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,117,25,1,101,101,101,101,101,101,101,0,0,117,116,116,116,116,116,116,116,116,116,116,116,116,116,116,0,0,94,94,94,94,101,101,101,101,101,101,101,101,101,94,94,110,110,110,94,14,14,14,14,14,87,87,87,87,95,88,95,95,103,95,103,103,109,109,109,95,109,109,95,95,95,95,95,95,109,109,109,109,103,103,109,109,95,109,109,103,103,103,103,103,103,103,103,103,103,103,103,103,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,40,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,40,8,40,40,8,8,8,8,8,72,8,8,8,8,8,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,84,25,101,85,41,45,93,45,45,93,101,115,115,115,94,94,45,45,41,41,45,45,94,101,101,25,94,101,101,25,45,45,45,101,25,101,70,3,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,3,116,116,116,116,116,116,116,116,117,25,25,1,0,1,101,0,1,116,117,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,1,0,0,0,101,101,101,93,93,94,101,101,101,101,94,93,110,110,110,110,110,14,14,14,14,14,88,88,88,95,95,95,95,95,95,109,109,109,109,109,109,109,95,95,95,95,95,109,109,109,109,103,103,109,109,95,109,109,109,103,103,103,103,103,103,103,103,103,103,103,103,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,72,8,8,8,8,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,85,101,0,41,41,41,45,45,45,45,1,0,115,115,115,94,45,45,45,45,0,94,101,101,101,101,94,101,1,45,45,45,45,101,101,70,70,3,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,117,117,117,0,25,25,1,117,117,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,0,1,0,94,94,94,93,101,101,101,101,101,94,94,110,110,110,110,110,14,14,14,14,88,88,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,95,95,95,95,95,109,109,109,103,109,109,109,109,109,109,109,103,103,103,103,103,103,103,103,103,103,103,103,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,72,72,8,8,8,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,36,84,101,101,41,41,94,94,45,101,45,1,115,94,115,94,110,110,45,45,45,45,94,94,101,101,101,101,101,101,1,25,1,45,45,101,70,70,1,3,3,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,117,117,117,117,117,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,1,0,0,0,94,94,93,93,93,94,101,101,94,94,110,110,14,14,14,14,14,88,88,88,88,95,95,95,95,95,95,95,95,95,95,109,109,109,109,95,95,95,95,95,95,109,109,103,103,103,103,109,109,109,109,103,109,103,103,103,103,103,103,103,103,103,103,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,40,8,8,8,8,8,8,72,72,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,101,101,101,41,101,101,45,45,45,115,115,94,115,115,110,110,110,94,41,41,94,115,94,94,94,1,94,101,101,0,101,101,0,25,101,70,70,70,70,70,0,3,3,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,0,0,1,1,94,94,94,94,94,94,101,101,94,110,110,94,14,14,14,14,99,99,99,88,88,95,95,95,95,95,95,95,95,95,109,109,109,95,95,95,95,95,95,95,95,109,109,103,103,103,103,103,103,109,103,109,109,103,103,103,103,103,103,103,103,103,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,8,8,8,72,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,25,101,101,101,94,101,0,0,1,45,115,115,115,115,41,41,110,41,94,41,41,115,115,94,0,94,94,94,25,101,101,25,101,101,101,25,36,74,70,70,70,70,70,70,70,70,3,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,1,1,94,94,94,94,101,101,94,94,94,110,110,93,14,14,14,99,99,99,99,88,88,95,95,95,95,95,95,95,95,95,109,109,109,95,95,95,95,95,95,95,109,109,109,103,103,103,109,103,103,103,103,109,103,103,103,103,103,103,103,103,103,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,40,40,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,8,8,8,72,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,74,101,101,101,101,101,1,1,1,0,115,115,1,115,41,41,41,41,41,41,41,101,101,101,101,101,94,94,94,94,101,101,101,101,101,101,1,25,25,25,82,70,70,70,70,70,70,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,94,94,94,94,94,94,94,94,94,94,94,93,93,14,14,99,87,87,95,95,88,95,95,95,95,95,95,103,103,103,103,103,103,103,103,103,103,95,95,103,95,95,109,109,109,109,103,103,103,109,103,103,103,103,103,103,103,103,103,103,103,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,8,72,8,8,8,8,72,8,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,74,101,101,101,41,41,0,41,0,115,115,94,115,115,94,41,41,101,101,94,1,94,101,115,115,94,101,101,94,25,94,94,101,101,101,101,101,101,25,25,25,25,25,52,70,70,70,70,70,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,1,0,3,116,116,116,116,116,116,1,94,94,93,94,94,94,94,94,94,94,93,93,94,14,87,87,87,87,87,95,95,95,95,95,95,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,95,95,109,109,109,109,109,109,109,109,103,103,103,103,103,103,103,103,103,103,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,72,72,72,72,72,8,8,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,74,101,101,101,41,41,41,41,41,41,1,1,45,115,0,115,41,41,41,101,94,94,1,94,1,94,0,101,94,94,0,94,0,101,1,101,101,101,101,25,25,25,25,25,25,1,70,70,70,70,70,70,3,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,0,0,0,25,0,0,1,3,1,1,0,110,110,94,93,93,94,94,94,94,94,93,93,110,87,87,95,87,95,95,95,95,95,95,95,95,103,103,103,103,103,103,103,103,103,103,95,103,103,103,95,95,109,109,109,109,109,109,109,109,109,103,103,109,103,103,103,103,103,103,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,40,40,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,8,72,72,72,8,8,8,8,8,8,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,0,101,101,41,41,101,101,101,101,41,41,1,0,45,115,115,101,101,41,41,94,94,94,35,35,35,94,1,94,94,94,94,94,101,101,0,101,101,101,101,25,25,25,1,0,1,0,0,70,70,70,70,70,3,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,25,1,0,0,0,25,0,1,0,0,0,110,93,93,93,94,94,94,94,110,110,110,110,99,95,95,95,95,88,88,109,95,95,95,109,95,95,103,103,103,103,95,103,95,95,95,95,103,103,103,95,95,95,95,109,109,109,109,109,109,109,109,103,103,109,103,103,103,103,103,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,8,8,8,8,8,8,8,8,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,74,101,101,101,101,101,74,101,101,101,41,41,101,45,115,115,94,41,41,101,41,94,115,35,35,35,35,35,94,110,94,94,0,94,101,101,101,101,101,25,101,101,25,25,25,0,1,1,25,70,70,70,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,1,116,116,116,116,116,116,116,3,25,1,3,0,1,1,1,1,0,0,0,1,1,93,110,110,93,93,93,93,94,94,110,110,110,99,99,99,87,95,95,95,88,88,88,109,109,109,109,109,95,95,103,95,95,103,103,103,95,103,103,95,103,103,95,95,95,95,95,109,109,109,109,109,109,109,109,103,109,103,109,103,0,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,8,8,8,8,8,8,8,8,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,84,84,84,1,101,74,74,74,101,101,74,74,101,101,41,41,101,45,0,1,41,94,41,41,41,115,115,115,94,94,35,35,94,110,110,94,94,94,101,101,101,101,101,101,101,101,25,25,25,25,25,25,25,1,70,70,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,1,1,0,3,1,0,0,25,1,93,94,94,94,94,94,93,93,93,93,94,94,110,110,110,110,94,94,94,94,94,94,94,110,99,99,110,87,87,95,95,95,109,109,88,109,109,109,109,109,95,95,95,95,95,103,103,103,103,103,103,103,103,103,103,95,95,95,95,95,95,109,109,109,109,109,109,103,103,103,109,109,109,95,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,40,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,8,8,8,8,8,8,8,8,72,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,52,84,84,74,74,74,74,74,74,74,74,74,101,101,41,45,101,45,45,110,110,115,115,115,94,115,115,115,115,94,35,110,110,110,110,94,94,94,101,101,1,101,25,101,101,101,101,25,25,25,25,0,0,0,70,70,70,3,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,1,25,1,1,0,0,0,0,93,93,93,94,94,93,93,93,94,94,93,93,93,93,94,94,110,110,110,110,93,93,94,94,99,110,87,87,87,95,95,95,109,109,109,109,109,109,109,109,109,95,95,95,95,95,95,103,103,95,103,103,95,103,103,95,95,95,95,109,109,109,95,109,109,109,109,109,109,103,109,109,103,109,95,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,8,8,8,8,8,8,8,8,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,84,84,74,74,74,74,74,74,74,74,74,101,101,101,45,45,101,101,45,45,110,35,110,115,0,115,115,94,35,35,35,94,110,110,94,94,94,94,101,101,0,101,101,101,101,101,101,25,25,0,1,1,1,84,70,70,70,3,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,0,25,0,0,1,1,94,93,93,93,93,93,93,94,94,94,94,94,94,93,93,94,93,93,93,110,110,93,87,94,94,110,110,87,87,95,95,95,95,95,109,109,109,109,95,109,109,109,95,95,95,95,109,95,95,95,95,95,95,95,95,95,95,95,95,109,109,109,109,109,95,95,109,109,109,109,109,103,103,109,103,109,95,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,40,40,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,8,8,8,8,8,8,8,8,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,25,84,84,84,84,84,1,74,74,74,74,74,74,74,101,101,25,45,45,1,101,45,45,45,94,35,110,94,0,115,35,35,1,94,115,115,115,1,94,94,94,1,101,101,1,1,25,101,101,101,25,1,25,25,0,0,0,70,70,70,70,3,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,1,25,3,25,93,93,93,94,93,93,94,93,94,94,94,94,93,93,93,93,101,93,93,94,110,93,87,87,87,94,87,87,87,95,95,95,95,95,109,109,109,109,109,109,95,95,95,95,95,95,109,109,109,95,95,95,95,95,95,95,95,109,109,95,109,109,109,109,109,95,95,95,109,109,109,109,103,103,109,109,109,95,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,8,8,8,8,8,8,8,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,84,52,84,84,84,84,82,84,84,1,74,74,101,101,25,45,45,45,45,45,115,101,101,35,35,35,35,35,35,35,35,101,115,94,115,115,94,94,45,94,1,101,101,101,1,0,0,25,25,25,25,25,25,25,25,25,70,70,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,25,25,1,1,94,94,94,93,94,101,101,93,94,94,107,93,93,93,101,101,101,93,94,94,93,87,87,99,99,87,87,87,95,95,95,95,95,109,109,109,109,109,109,95,95,95,95,95,95,95,109,109,109,109,109,95,95,95,95,95,95,109,109,95,109,109,95,95,95,95,95,95,95,109,109,109,103,103,109,103,109,95,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,40,40,8,40,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,72,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,36,84,84,84,84,84,74,74,101,1,1,45,45,0,0,115,115,0,101,35,101,94,0,35,35,94,101,1,115,115,45,45,94,45,45,94,94,1,101,101,101,0,1,101,101,101,25,1,25,25,25,25,70,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,25,25,0,0,94,94,94,93,94,101,101,101,93,107,107,93,93,101,101,93,94,94,94,94,94,87,94,99,99,99,95,87,87,95,95,109,109,109,109,109,109,109,109,95,95,95,95,95,95,95,95,109,109,109,109,109,95,95,95,95,95,109,109,109,109,109,95,95,95,95,95,95,95,95,109,109,109,103,109,103,109,109,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,40,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,8,8,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,84,84,84,25,74,101,101,25,45,45,101,101,101,115,1,101,101,35,1,94,94,115,115,115,101,115,115,94,45,45,45,45,45,1,94,1,101,101,0,101,101,101,101,101,25,25,25,1,0,70,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,25,25,25,1,94,94,94,94,93,93,101,101,107,107,107,94,101,101,93,93,94,94,94,94,94,94,94,99,87,87,95,87,87,95,109,109,109,109,95,95,109,109,109,109,95,95,95,95,95,95,95,95,95,109,109,109,109,95,95,95,95,109,109,109,109,95,95,95,95,95,95,95,95,95,95,109,109,109,103,103,103,109,8,8,8,8,8,8,8,8,8,8,40,40,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,8,40,40,40,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,8,8,8,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,84,84,84,74,101,101,101,45,45,45,101,101,115,115,0,0,101,35,35,115,115,1,101,101,101,94,94,94,45,45,45,45,45,45,45,0,101,101,101,101,101,101,101,25,0,25,1,0,25,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,25,25,25,25,0,93,93,94,93,93,93,107,107,107,101,101,101,101,93,93,93,93,93,93,93,94,110,110,87,95,95,95,87,87,87,87,109,95,95,95,109,109,109,109,95,95,103,95,95,95,95,95,95,95,109,109,109,109,95,95,95,109,109,109,109,109,95,95,103,103,103,103,95,95,95,109,109,109,109,103,103,109,8,8,8,8,8,8,8,8,8,40,40,40,40,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,8,40,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,8,8,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,82,74,101,101,101,101,101,101,101,115,101,115,1,115,115,35,35,94,101,35,101,115,115,45,45,45,45,94,45,45,45,45,45,94,0,101,101,101,101,101,101,101,101,25,25,25,1,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,25,25,25,25,25,93,94,107,93,94,107,93,107,93,101,101,101,101,93,93,93,93,110,110,93,93,110,110,110,95,95,95,95,87,87,87,87,95,95,95,95,109,109,95,95,103,103,103,95,95,95,95,95,95,95,109,109,109,95,95,95,109,109,109,109,109,95,103,103,103,103,103,103,95,95,95,109,109,109,109,109,109,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,72,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,8,8,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,74,101,101,101,45,45,45,115,101,101,101,115,0,115,35,35,101,101,35,35,115,115,115,45,45,94,45,45,45,45,45,41,45,0,0,101,101,101,101,101,101,101,101,1,25,0,70,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,25,25,25,25,93,94,107,107,107,107,107,107,93,101,101,101,101,93,94,110,110,110,110,110,110,110,110,110,95,95,95,95,95,109,109,109,95,95,95,95,95,95,95,95,103,103,103,103,95,95,95,95,95,95,109,109,109,109,95,95,95,109,109,109,109,95,103,103,103,103,103,103,95,95,95,95,95,109,109,109,109,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,8,72,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,8,8,8,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,74,74,101,101,0,101,45,115,115,115,101,101,101,115,101,115,35,35,35,94,94,45,45,94,94,45,45,94,45,1,45,94,41,41,0,1,101,0,101,101,101,101,101,101,1,1,25,70,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,25,25,25,1,94,93,94,107,107,107,107,94,93,93,101,101,101,94,93,110,94,93,93,94,110,94,94,87,95,95,95,95,95,95,109,95,95,95,95,95,95,95,95,95,95,103,103,103,95,109,109,109,109,109,109,109,109,95,109,109,109,103,103,95,95,95,103,103,103,103,103,103,103,95,95,95,95,95,109,109,109,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,40,8,40,40,8,8,8,72,72,72,8,8,8,8,8,8,8,8,8,72,72,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,8,8,8,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,101,101,74,101,0,101,45,115,115,0,0,101,115,115,115,101,35,101,101,3,45,45,45,45,94,45,45,94,1,45,41,41,101,94,0,101,1,101,101,101,101,101,101,1,1,1,70,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,25,25,25,25,25,93,93,107,107,93,93,93,94,93,101,101,94,93,94,94,93,93,94,94,110,110,94,87,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,103,103,103,103,109,109,109,109,109,95,14,109,109,109,103,103,103,103,95,95,95,103,95,95,103,103,95,95,95,95,95,95,95,109,109,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,40,40,8,40,40,8,8,72,8,72,72,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,8,72,8,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,101,101,0,101,45,45,45,45,115,115,115,1,101,115,115,0,35,35,101,101,1,1,45,45,94,45,45,45,94,45,101,101,101,94,94,101,101,101,101,101,101,101,101,1,1,25,0,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,3,25,71,25,25,1,25,93,93,107,93,94,93,93,93,94,101,93,93,94,94,93,93,94,94,110,94,99,94,95,95,95,95,95,95,103,103,103,103,103,95,95,95,95,95,95,95,14,103,103,103,103,109,109,109,95,95,95,95,109,109,103,103,103,103,95,95,95,95,95,95,95,95,95,95,95,99,99,99,99,1,109,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,40,40,8,72,72,72,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,8,8,72,8,72,72,72,72,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,72,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,74,101,74,74,101,101,101,45,101,115,115,115,115,115,101,1,0,101,35,101,101,101,1,0,45,45,45,45,94,94,94,101,101,41,94,1,94,101,101,101,101,101,101,101,0,0,1,1,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,119,71,71,0,25,25,25,25,93,93,93,94,107,94,93,93,101,93,94,93,93,93,93,93,110,110,94,99,95,95,95,95,95,95,103,103,103,103,103,103,103,109,109,109,95,95,95,109,109,103,103,109,95,95,95,95,95,95,109,109,103,103,103,103,103,103,95,95,95,95,95,95,95,95,95,99,99,99,99,95,0,109,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,40,72,72,72,72,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,72,8,8,72,8,72,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,30,30,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,75,101,74,74,0,101,101,45,45,45,115,1,1,45,45,101,0,3,101,0,101,101,1,94,45,45,45,45,45,45,41,41,45,45,1,1,94,101,94,101,101,101,101,101,0,1,25,0,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,70,70,61,61,25,25,25,25,25,94,93,107,101,101,101,101,101,94,93,93,94,94,94,93,94,99,99,99,95,95,95,95,95,109,109,103,103,103,103,103,103,103,109,109,109,109,109,109,109,109,109,109,95,95,95,95,109,95,95,109,95,103,103,103,103,103,103,95,95,109,95,95,95,95,95,95,99,99,99,109,109,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,72,40,72,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,72,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,4,4,30,30,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,82,101,101,101,74,101,101,101,1,45,45,45,1,1,45,45,101,101,1,101,1,0,1,94,101,101,101,45,41,45,41,94,45,45,94,1,101,101,94,101,101,101,101,101,1,1,0,25,70,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,70,70,56,61,25,25,25,25,25,25,93,94,101,101,101,101,93,93,93,93,94,94,93,93,99,99,99,95,87,87,87,95,109,109,109,109,103,103,109,109,103,109,109,109,109,109,109,109,95,109,109,95,109,95,109,109,109,109,95,95,95,95,95,103,103,103,103,103,95,109,95,95,95,95,95,95,99,99,99,109,109,0,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,72,72,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,4,30,30,30,30,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,74,101,101,101,101,101,101,101,101,0,0,45,45,0,45,45,1,101,1,101,101,0,0,94,45,101,101,45,41,45,41,45,1,45,45,94,1,101,101,101,101,101,101,101,1,1,0,1,47,70,70,0,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,119,70,56,56,56,56,25,25,25,25,1,93,93,93,101,107,93,93,94,93,93,94,94,93,94,99,99,99,99,99,99,87,87,87,109,109,95,95,95,95,109,95,95,95,95,109,109,109,95,95,95,109,109,109,109,109,109,109,95,95,95,95,95,95,95,109,103,103,103,109,109,109,95,95,95,95,95,95,99,109,109,109,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,4,4,30,30,30,30,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,74,101,101,74,101,74,101,101,74,101,101,101,101,101,101,1,0,1,1,101,1,101,1,1,45,101,101,41,41,41,41,41,94,94,1,1,101,101,0,101,94,94,101,101,101,25,25,1,1,25,70,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,70,61,61,56,56,56,25,25,0,25,1,0,93,93,93,93,93,93,94,93,94,94,93,93,95,95,95,95,95,95,99,95,87,109,109,110,110,95,109,95,95,95,95,95,95,95,95,95,95,109,109,109,109,109,109,95,95,95,95,95,95,95,95,95,109,109,103,109,109,109,109,109,109,95,95,95,95,99,99,109,109,0,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,8,4,30,30,30,30,30,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,52,84,74,0,74,74,74,74,74,74,74,1,101,101,101,101,0,0,0,101,101,0,0,45,45,0,41,41,41,41,45,45,45,45,101,101,1,101,101,101,94,101,101,0,25,1,0,25,0,0,70,70,1,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,70,61,61,61,73,56,56,25,1,25,25,0,1,94,94,93,93,94,94,93,93,93,93,93,95,95,87,87,87,95,99,87,87,109,110,110,109,109,109,109,95,95,95,95,95,95,95,95,109,109,109,109,109,95,95,95,95,95,95,95,95,95,95,95,109,109,95,95,95,95,109,109,109,95,95,95,95,109,99,109,109,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,8,8,4,30,30,33,33,30,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,84,84,75,74,74,74,84,74,84,74,101,101,101,101,101,101,101,101,101,101,101,0,101,101,0,45,45,94,45,41,41,45,45,45,45,101,101,101,101,101,101,94,101,101,0,0,25,0,25,0,25,74,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,70,70,84,73,73,73,61,61,25,0,25,0,0,1,93,93,93,94,107,93,93,93,94,93,93,95,87,95,87,87,87,87,110,110,110,110,109,109,109,109,95,95,95,95,95,95,95,109,109,109,109,95,95,95,95,95,95,95,95,95,95,95,95,95,109,109,109,95,95,95,95,95,95,95,95,95,95,103,103,109,109,0,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,4,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,8,8,4,8,30,30,33,33,33,30,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,84,84,84,1,74,84,84,84,84,84,74,101,101,101,101,101,74,101,101,101,101,1,101,101,0,0,45,45,45,45,45,0,0,101,101,101,1,101,101,101,94,101,101,0,1,25,1,0,1,1,1,70,70,25,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,70,59,59,73,73,73,52,25,61,25,25,1,1,0,93,93,93,107,107,93,93,93,93,93,94,95,87,87,95,87,87,95,110,110,110,110,95,109,109,95,95,95,95,95,95,95,95,95,109,109,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,109,109,109,95,95,95,95,95,103,103,95,103,103,103,103,109,0,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,4,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,8,4,4,30,1,33,33,1,33,33,33,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,63,63,63,63,3,3,3,3,3,3,3,3,3,3,84,84,84,84,84,84,84,84,84,84,84,84,74,74,101,101,101,101,101,0,101,101,101,101,94,94,94,1,0,1,1,0,0,101,101,101,101,101,94,94,94,101,101,1,1,25,25,1,1,0,70,70,70,3,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,51,59,59,56,73,73,0,82,61,25,0,0,1,0,0,93,93,107,107,93,93,93,94,93,93,94,94,87,87,87,94,95,110,110,93,110,95,95,95,95,99,99,87,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,109,109,109,95,95,95,95,103,103,103,103,103,103,103,103,109,109,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,8,72,72,72,72,72,72,72,72,72,72,72,72,72,4,30,30,30,33,33,33,33,33,33,33,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,63,1,63,66,63,63,63,3,3,3,3,3,3,3,3,3,84,84,84,84,84,84,84,84,84,74,84,84,84,1,0,0,1,101,1,0,1,101,101,101,0,1,1,0,1,0,1,101,0,101,101,0,101,101,94,94,101,101,101,1,0,25,25,1,1,1,70,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,3,59,59,73,73,73,73,61,71,0,0,1,1,0,25,1,107,107,93,94,94,93,94,93,93,94,94,87,87,94,110,110,93,93,95,95,95,95,99,99,87,87,87,95,87,87,87,87,87,95,95,95,95,95,95,95,95,95,95,95,95,95,109,109,95,95,95,95,95,95,95,95,103,103,103,103,103,103,103,109,109,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,8,8,72,72,72,72,72,72,8,72,72,72,72,72,72,8,4,30,30,30,33,33,33,33,30,33,1,33,33,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,63,63,63,63,63,63,66,63,3,3,3,3,3,3,3,3,3,3,3,1,84,84,84,84,52,84,84,84,84,84,84,0,84,52,84,1,1,0,101,101,101,101,101,0,101,101,0,0,0,101,101,101,101,94,94,101,101,101,101,94,101,101,25,1,25,82,70,70,70,0,3,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,51,51,59,59,61,73,73,73,73,71,61,25,1,0,0,1,0,94,107,94,93,94,93,93,94,93,93,93,94,94,94,110,93,93,95,95,95,95,99,99,99,99,95,87,87,87,87,87,87,87,87,87,95,95,95,95,95,95,95,95,95,95,109,109,95,95,95,95,95,95,95,95,95,95,95,95,103,103,103,103,109,109,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,8,72,72,8,8,8,72,72,72,72,8,8,72,72,72,8,72,8,4,30,30,33,33,0,0,33,33,33,33,33,33,33,33,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,63,63,69,66,63,69,63,63,63,3,3,3,3,3,3,3,3,3,3,3,3,0,84,84,84,84,84,84,84,84,84,84,84,74,1,0,0,101,101,101,101,101,101,101,1,1,0,0,101,0,101,101,94,94,94,101,101,101,94,94,101,101,94,94,94,71,71,70,70,0,3,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,51,51,70,70,61,59,73,73,73,59,61,56,56,0,1,0,1,107,107,107,94,93,94,93,94,93,93,94,93,93,93,93,110,110,93,95,95,110,110,110,110,110,110,94,94,87,94,99,99,99,0,87,14,95,95,95,95,95,95,95,95,95,109,95,95,95,95,95,95,95,95,95,95,109,109,95,109,103,103,109,109,109,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,8,8,40,8,8,8,8,8,8,8,40,8,8,8,8,8,8,40,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,72,8,8,8,72,8,8,8,72,72,8,8,8,8,72,8,8,8,8,4,30,30,33,30,33,33,33,33,33,33,33,33,33,33,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,63,63,63,69,63,69,63,63,63,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,84,84,84,84,84,84,84,25,25,0,25,101,101,101,101,101,101,101,101,101,101,101,101,101,0,101,101,101,101,101,101,101,94,101,101,94,94,94,1,71,70,70,70,70,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,3,51,119,25,59,59,59,73,73,73,25,59,56,56,56,1,1,0,107,107,107,93,93,93,94,93,93,93,93,93,93,93,93,93,93,110,110,110,110,110,110,110,110,110,110,99,99,99,99,99,99,1,14,14,14,109,95,95,14,95,95,95,109,95,87,95,95,95,95,95,95,109,109,109,109,109,95,95,95,95,95,95,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,8,8,40,40,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,0,72,8,72,72,72,8,8,72,72,72,8,8,8,8,72,8,8,8,8,8,8,8,8,8,4,30,1,30,30,33,33,33,33,30,33,33,33,33,33,33,1,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,63,63,63,63,63,66,63,63,63,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,84,84,84,84,84,84,84,84,84,84,25,25,1,1,25,101,101,101,101,101,101,101,101,101,101,101,1,101,101,101,101,101,101,101,101,101,101,1,1,61,61,61,71,71,70,70,70,0,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,51,54,54,59,59,59,59,73,73,59,59,59,59,0,61,0,0,1,0,107,107,94,93,94,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,110,0,1,1,0,1,99,99,14,94,94,109,109,95,87,87,95,95,95,95,87,95,95,95,95,95,95,109,109,109,109,109,109,109,95,95,95,95,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,72,8,40,8,8,8,8,8,40,8,8,40,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,8,8,8,72,8,8,8,8,8,8,8,8,8,8,72,72,72,8,8,8,8,8,8,8,8,4,30,30,30,33,33,33,33,33,33,33,33,30,33,33,30,30,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,63,63,63,1,0,63,63,63,3,3,63,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,84,84,84,84,84,84,84,84,1,25,25,0,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,25,1,1,61,61,56,71,71,70,70,70,70,0,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,54,54,74,59,59,59,59,73,59,59,59,59,59,61,0,0,1,0,0,94,93,93,94,93,107,107,107,93,93,93,93,94,94,93,93,93,93,110,110,110,93,93,93,1,0,0,1,1,0,1,94,94,109,109,109,95,87,87,95,95,87,87,95,95,109,95,99,99,99,99,95,95,95,95,95,109,95,95,95,95,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,8,72,8,8,8,8,8,8,8,8,8,8,72,72,72,72,8,8,8,8,8,8,8,8,4,30,30,30,33,30,33,30,30,33,33,33,33,33,33,33,30,1,1,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,63,63,63,63,3,3,3,3,63,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,84,84,84,84,84,84,84,0,0,25,25,1,101,101,101,101,101,101,94,94,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,1,94,56,56,61,61,61,70,70,70,70,3,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,25,54,54,44,56,59,59,59,59,59,59,59,59,59,56,1,0,1,0,0,1,93,93,93,93,93,107,107,107,107,107,107,107,107,107,107,93,93,110,110,110,110,93,0,0,0,1,94,94,94,94,94,109,109,109,109,95,0,87,87,87,87,95,95,109,109,95,99,99,99,87,87,87,95,95,95,95,95,95,95,0,8,8,8,8,8,8,8,8,8,40,40,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,40,72,72,8,40,8,8,8,40,40,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,8,72,8,8,8,8,8,8,8,8,8,8,72,72,72,72,72,8,8,8,72,72,8,8,8,4,30,30,30,33,33,33,33,33,33,33,33,30,30,30,33,33,30,30,30,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,84,84,84,84,84,84,101,0,1,1,101,101,94,94,101,94,94,94,94,101,101,101,101,101,94,94,94,94,94,94,94,94,101,101,101,101,94,94,61,61,61,61,25,70,70,70,1,3,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,0,54,54,44,56,71,56,59,73,59,73,59,59,59,59,56,0,1,1,0,1,1,93,94,93,93,93,107,107,107,107,93,94,94,93,93,93,93,110,110,110,110,0,1,94,94,94,94,94,94,109,109,109,109,109,109,95,95,1,95,95,1,95,109,109,109,109,109,87,87,87,87,87,95,95,95,95,95,95,95,95,8,8,8,8,8,8,8,8,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,8,8,8,72,72,72,8,8,8,4,30,30,30,33,33,30,33,33,33,33,33,30,33,33,33,33,1,30,30,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,84,84,84,84,84,84,29,0,101,25,101,101,101,94,94,94,94,101,94,94,94,94,101,101,101,101,101,101,101,101,94,101,94,101,101,101,101,1,94,61,61,61,61,61,61,61,70,70,1,3,116,116,116,116,116,116,116,116,116,116,116,116,116,116,25,25,54,87,54,54,56,56,59,59,73,73,73,59,59,59,56,0,0,0,1,0,0,93,94,93,93,93,93,107,107,107,107,107,107,107,107,107,107,1,110,110,110,110,94,94,94,94,94,94,116,94,94,109,109,109,109,109,95,95,95,95,95,94,94,109,109,109,109,109,109,109,109,109,109,109,109,109,95,95,95,95,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,8,8,8,72,8,8,8,8,8,8,8,72,8,8,8,8,8,72,72,8,8,8,4,30,30,33,33,33,33,30,33,33,30,33,33,1,0,33,33,33,33,33,30,1,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,84,30,29,0,25,101,101,101,101,101,94,101,101,101,101,94,94,94,101,101,101,101,101,101,101,101,94,94,101,101,101,101,101,54,54,54,54,94,0,61,61,61,70,70,70,70,25,116,116,116,116,116,116,116,116,116,116,116,116,3,25,54,54,54,54,54,54,59,59,59,59,73,73,59,59,59,56,25,1,1,1,1,0,0,93,94,93,94,93,93,107,107,93,93,93,93,107,94,94,0,0,94,110,110,94,94,117,117,116,116,116,116,116,94,109,109,109,109,94,94,116,116,116,116,116,116,116,116,117,117,117,117,116,116,116,116,94,109,109,109,95,95,8,8,8,8,8,40,40,40,40,8,8,40,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,8,8,8,8,8,72,8,8,8,8,8,72,72,8,72,4,30,30,33,33,33,33,33,30,33,33,33,30,30,33,33,33,33,33,33,30,30,30,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,84,25,30,30,0,29,101,101,101,101,41,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,54,54,61,94,1,0,61,0,71,71,81,70,70,70,0,70,3,70,116,116,116,116,116,116,3,0,25,54,54,54,54,54,54,61,61,59,73,73,73,59,59,59,56,56,0,1,1,1,1,0,93,93,93,93,93,93,94,107,107,93,93,93,93,93,94,1,94,94,94,116,117,117,117,117,3,3,3,94,116,116,116,117,117,117,117,117,116,116,116,116,116,116,116,116,116,117,117,117,117,116,116,116,116,94,94,109,1,0,8,8,8,8,8,8,40,40,8,40,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,8,72,72,8,8,8,72,8,8,8,8,8,8,8,8,72,72,0,30,30,33,33,33,33,33,33,33,33,1,0,33,33,33,33,30,30,33,33,0,30,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,120,120,120,120,120,120,121,121,30,121,0,29,101,29,101,101,41,41,41,101,101,101,101,101,101,101,101,101,101,101,101,41,41,41,41,41,101,101,101,101,101,54,54,54,61,44,94,94,94,61,61,61,81,81,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,1,0,1,54,54,54,61,25,59,59,73,59,59,59,59,56,25,1,0,1,1,0,1,93,93,94,93,93,93,93,93,93,93,93,94,94,0,1,94,116,116,116,117,0,3,3,3,3,3,3,3,3,116,116,117,117,117,117,116,116,116,116,116,116,116,116,116,116,3,3,3,3,3,116,116,117,117,94,109,0,8,8,8,8,8,8,8,40,40,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,72,8,72,72,72,72,72,8,8,8,8,8,8,8,8,8,4,4,30,30,33,33,33,33,30,33,33,33,33,33,33,33,30,30,33,33,33,30,33,33,30,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,120,120,120,120,121,121,121,30,30,30,30,121,1,29,101,101,101,101,101,41,41,41,41,41,101,101,101,101,101,101,45,45,101,101,101,41,41,41,94,101,101,101,54,54,0,61,44,61,94,94,94,54,54,54,44,1,61,61,61,70,70,70,70,70,70,70,70,70,70,70,81,81,81,81,1,0,44,1,61,61,59,59,59,73,59,59,59,59,0,25,0,0,0,0,1,1,93,93,94,93,93,93,93,93,107,94,94,1,0,116,116,116,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,3,3,3,3,3,116,116,3,3,3,3,3,116,116,116,3,3,3,3,116,116,117,0,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,72,72,8,72,72,72,72,8,8,8,8,8,8,8,8,8,4,4,30,30,30,33,33,33,33,33,30,33,33,33,33,33,33,33,33,33,30,33,33,33,33,30,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,1,120,120,120,120,120,121,121,121,121,121,30,101,30,121,29,29,101,101,101,101,101,101,41,41,41,101,101,101,101,101,101,101,45,45,101,101,101,101,41,41,41,101,101,54,101,101,101,44,44,44,101,94,44,54,54,54,61,61,61,61,61,61,61,61,70,70,70,70,70,70,70,81,81,75,81,81,81,81,81,1,0,61,59,59,73,73,73,59,59,59,61,61,1,1,1,1,0,1,0,93,93,94,93,93,93,93,93,93,94,1,116,116,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,1,0,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,8,8,8,72,72,72,72,72,72,72,8,72,72,72,8,8,8,8,8,8,8,8,8,72,4,30,30,30,30,33,33,33,1,1,33,33,33,33,33,33,33,33,33,33,33,33,33,30,33,30,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,120,120,120,120,121,121,121,121,121,30,101,121,121,121,121,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,45,101,101,101,101,101,101,101,101,101,54,54,101,101,101,101,44,44,101,94,54,54,44,44,61,94,94,44,44,44,94,61,61,61,70,56,56,56,81,81,81,81,81,84,75,81,0,25,1,25,59,59,59,59,73,73,59,36,59,61,61,0,25,1,1,1,1,25,1,93,94,93,93,93,93,93,94,1,116,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,0,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,72,72,72,72,72,72,8,8,72,72,72,72,72,72,72,8,8,8,8,8,8,8,72,72,30,30,30,0,0,0,33,33,33,33,33,30,30,30,30,30,30,1,1,1,1,0,0,1,30,30,30,30,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,120,120,120,0,121,0,0,30,30,101,101,101,101,29,101,29,101,101,101,101,101,101,29,0,101,94,94,94,94,94,101,101,101,101,101,101,101,101,101,101,101,101,101,101,54,54,54,101,101,101,101,101,101,101,94,101,101,44,44,61,94,94,54,44,44,44,44,44,61,56,56,56,81,81,81,81,81,81,25,52,0,25,25,54,54,59,59,59,59,73,73,59,59,59,71,61,25,0,25,1,0,0,1,93,93,93,93,94,93,94,94,0,116,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,40,8,40,40,40,8,40,8,40,40,40,8,8,8,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,0,72,72,72,72,72,72,72,72,72,72,8,8,72,72,72,72,72,72,8,8,8,8,8,8,8,4,4,30,30,30,30,30,1,30,30,1,1,30,30,30,30,0,1,0,30,30,30,30,30,30,1,0,1,30,30,30,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,120,120,120,120,1,0,0,30,30,30,30,30,30,101,101,101,41,41,45,29,101,101,29,29,29,101,101,94,94,94,94,94,94,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,54,101,101,101,101,101,101,101,101,44,101,101,44,61,61,61,61,54,54,54,44,44,44,56,1,81,81,81,81,81,81,81,81,81,81,0,1,44,44,1,56,59,59,59,73,73,59,59,59,59,61,61,0,0,1,1,1,0,93,93,93,93,93,94,94,0,116,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,8,8,40,40,8,8,40,40,40,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,72,72,72,72,72,72,8,8,8,72,72,72,72,72,72,8,8,8,8,4,8,30,30,30,30,30,30,30,1,0,0,1,0,1,30,30,30,30,1,75,21,21,21,21,21,21,30,30,1,30,30,30,30,30,122,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,120,120,120,120,21,1,1,30,30,30,1,30,30,29,101,101,101,41,41,45,45,35,35,101,29,101,101,101,101,101,101,101,101,94,94,94,101,101,101,101,101,101,101,101,101,101,101,101,101,101,54,101,101,101,101,101,101,110,44,44,44,94,101,101,61,61,61,61,54,54,54,94,44,44,56,0,56,81,61,61,81,81,81,81,81,25,1,54,54,44,56,56,59,59,59,73,59,59,59,59,59,71,61,0,1,1,25,25,1,94,94,94,94,94,1,0,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,72,72,72,72,72,72,8,8,8,8,8,8,8,72,72,72,72,72,8,8,8,4,4,4,30,33,33,33,30,30,29,29,4,0,1,1,5,1,0,1,0,0,21,21,21,2,2,21,1,21,1,30,1,1,5,5,30,30,122,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,120,120,120,120,120,120,120,120,120,120,36,0,0,30,30,1,30,1,101,29,30,101,29,123,29,101,101,101,101,101,101,29,101,101,101,29,29,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,110,54,54,44,44,94,94,101,101,94,94,94,44,44,44,54,54,54,1,56,56,81,81,81,61,61,81,81,81,81,81,25,25,1,54,0,56,59,59,59,59,73,59,59,59,56,61,61,61,25,1,1,1,0,1,0,1,0,1,1,116,117,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,116,116,116,116,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,72,72,8,8,8,8,8,8,8,72,72,72,72,1,8,8,8,4,4,30,30,1,33,30,0,29,4,4,4,4,4,5,5,0,4,4,1,21,21,21,21,2,2,2,21,21,21,5,5,5,5,5,5,30,30,30,122,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,120,120,120,120,120,120,120,120,120,120,120,120,120,1,1,0,30,30,30,30,30,30,121,29,29,30,29,29,101,101,101,29,41,41,41,41,29,101,101,101,29,29,29,101,101,101,101,101,101,101,101,101,101,101,101,101,35,101,101,101,101,101,35,101,101,54,54,54,54,110,110,44,44,94,94,94,94,94,94,44,44,61,54,54,54,61,56,56,56,81,81,81,81,81,81,81,81,81,1,1,1,44,44,0,61,0,59,59,59,73,73,59,73,56,71,61,61,61,25,0,1,0,0,1,1,0,0,117,25,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,3,3,116,116,116,116,116,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,8,1,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,8,8,8,8,8,8,72,72,72,72,8,8,8,8,4,4,0,1,30,30,30,29,4,4,4,4,4,4,4,5,4,4,4,84,21,21,21,2,2,2,2,21,21,21,5,5,5,5,5,5,5,5,5,30,30,30,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,21,120,120,120,120,120,120,120,120,120,120,120,30,21,21,21,0,1,0,0,121,30,0,30,30,121,121,121,121,29,30,30,101,101,29,101,101,41,41,29,101,5,101,29,101,101,29,101,101,101,101,0,0,101,101,101,101,101,101,101,101,35,35,101,101,35,35,35,101,54,54,101,110,110,110,110,44,44,94,45,45,45,44,44,44,44,61,54,54,54,61,44,0,56,81,81,81,81,81,81,81,81,81,81,81,0,44,44,0,25,61,1,56,59,59,73,73,73,73,73,73,73,61,25,25,0,0,25,1,0,1,116,117,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,116,116,3,3,3,3,3,3,3,116,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,72,8,8,8,8,8,8,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,8,8,8,72,72,72,72,72,0,8,8,8,8,30,0,30,30,0,29,4,4,4,29,29,4,4,5,5,5,4,4,21,21,21,21,2,2,2,3,21,21,21,0,5,5,5,5,5,5,5,124,124,124,30,30,30,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,21,30,21,120,120,120,120,120,120,21,21,1,30,30,30,30,30,0,1,0,30,30,30,1,1,30,30,1,29,29,29,29,29,30,30,30,5,29,29,101,101,35,29,101,101,5,29,101,101,101,101,101,101,101,1,1,0,101,101,101,101,101,101,101,101,35,101,101,35,101,101,101,101,101,101,101,110,110,101,45,44,94,45,94,44,44,94,44,44,44,54,61,61,61,61,0,56,56,81,81,81,81,81,81,81,81,81,0,1,1,44,25,54,25,61,56,56,59,3,73,59,73,73,73,73,56,56,25,25,1,0,0,1,0,117,117,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,116,116,116,116,3,3,116,116,3,116,116,116,3,3,3,3,3,3,3,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,8,72,72,72,8,8,8,72,72,72,72,72,8,8,4,4,4,0,30,30,29,29,4,4,4,29,29,29,29,4,4,5,4,5,5,21,21,21,21,2,2,2,3,21,21,21,21,5,5,5,5,5,5,5,5,5,5,124,124,122,30,30,0,2,2,2,2,2,2,2,2,2,2,21,21,21,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,0,1,1,1,1,1,30,30,30,0,121,30,30,121,29,29,29,29,29,29,29,30,30,5,29,29,29,29,29,101,101,5,5,29,29,29,101,101,101,101,29,101,1,0,1,101,101,101,101,45,45,101,45,35,35,101,101,101,101,101,101,101,94,94,101,101,45,101,101,101,94,94,94,94,54,44,94,94,94,94,61,61,0,56,56,81,81,81,81,81,81,81,81,81,81,0,0,44,44,25,25,25,61,59,59,59,59,59,59,73,73,73,59,56,84,1,0,1,1,1,116,117,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,3,116,116,116,116,116,116,116,116,116,3,116,116,3,3,8,8,8,8,8,8,8,8,8,8,8,8,40,40,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,8,8,72,72,72,72,72,8,8,8,72,72,72,72,8,8,8,4,4,30,30,33,33,29,4,4,4,5,29,29,29,5,5,5,5,5,5,5,1,21,21,21,2,2,2,3,3,21,21,21,5,5,124,124,5,5,5,5,5,5,122,5,1,1,1,0,30,30,21,21,21,0,21,21,21,21,21,30,30,30,30,30,30,30,30,30,30,30,30,0,30,30,0,30,30,121,121,121,121,30,30,30,30,1,1,121,30,30,1,29,29,29,29,29,29,30,30,29,5,5,29,29,29,29,101,101,4,4,4,29,29,35,41,35,101,101,101,101,1,0,1,0,101,101,101,45,45,45,45,45,35,101,101,101,101,101,101,101,44,94,45,45,101,101,94,101,101,110,94,94,44,44,94,44,94,44,94,61,61,0,81,81,81,81,81,81,81,81,81,81,81,0,1,54,44,54,54,25,1,59,59,59,59,59,73,73,73,59,59,59,73,61,61,1,0,116,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,1,0,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,72,72,72,72,8,8,8,8,72,72,72,8,8,8,72,30,30,30,33,33,29,4,4,5,5,29,29,124,5,5,5,5,5,4,5,1,21,21,21,2,2,2,2,21,21,21,21,5,5,124,124,124,5,5,5,5,5,5,5,5,1,1,30,30,30,0,21,21,21,21,21,21,21,21,30,30,30,30,0,30,30,30,30,30,30,30,0,30,30,30,30,30,121,121,0,30,30,30,30,1,30,30,121,30,30,0,29,29,29,29,29,29,29,29,5,5,5,29,5,29,29,29,101,101,4,4,4,29,35,41,41,35,29,29,101,101,101,0,0,0,101,101,101,45,94,94,94,94,45,101,101,101,101,101,101,101,94,94,94,44,93,94,94,44,94,94,110,110,44,94,44,44,94,44,54,54,61,61,81,81,81,81,81,81,61,81,81,81,81,0,1,44,44,54,1,0,0,0,71,59,59,59,59,73,73,59,59,59,73,73,61,0,0,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,40,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,8,72,72,8,8,8,8,8,8,8,8,8,8,8,72,33,33,30,5,5,4,4,29,29,29,29,124,124,4,5,5,5,5,5,1,21,21,21,21,2,2,3,21,21,21,21,5,5,124,124,124,124,5,5,5,5,5,5,5,124,122,30,30,0,30,1,21,21,21,21,21,21,21,21,1,1,1,30,30,30,30,30,30,30,30,30,30,30,30,4,1,0,0,30,30,30,30,30,30,30,30,1,30,30,29,29,29,29,29,29,29,29,29,5,5,5,5,29,5,5,5,29,29,5,4,4,4,29,29,41,41,35,35,29,29,101,29,101,1,1,1,101,101,101,45,94,101,101,94,94,101,101,101,101,101,101,94,94,94,44,44,93,93,110,44,94,54,110,110,94,44,94,94,44,54,54,54,61,81,81,81,81,81,81,61,61,81,81,81,0,1,54,44,44,54,54,1,0,59,59,59,59,73,73,73,73,59,73,73,73,61,0,0,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,116,116,116,116,117,116,45,35,116,35,35,116,116,116,116,116,116,116,116,116,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,72,40,40,40,40,40,40,40,40,40,40,40,8,8,8,8,8,8,8,8,8,8,8,72,8,8,8,8,8,8,72,72,8,72,72,8,8,8,8,8,8,8,8,4,4,4,30,30,30,5,5,4,4,4,29,29,5,5,5,124,124,4,4,5,5,5,1,21,21,21,21,2,2,3,21,21,21,21,30,5,124,124,124,5,5,5,5,5,5,5,124,124,5,5,5,5,5,5,21,21,21,21,21,21,1,1,30,30,30,30,30,30,30,30,30,1,1,1,0,30,30,4,4,30,30,30,0,0,30,1,30,0,30,1,30,30,0,1,29,29,29,29,29,29,29,5,5,5,5,29,29,29,5,29,29,41,41,41,4,4,29,29,41,41,41,29,5,5,29,101,101,101,1,0,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,94,94,44,44,44,110,93,93,44,44,44,44,101,101,94,44,44,44,1,44,54,61,61,56,81,81,81,81,61,61,81,81,81,1,0,54,54,44,54,54,0,1,1,59,59,59,59,73,73,73,56,73,73,1,61,61,116,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,116,116,116,116,116,117,35,35,35,35,35,35,35,1,116,116,116,116,116,116,116,116,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,72,40,40,40,40,40,40,40,40,40,40,40,72,72,72,40,8,8,8,8,8,8,8,72,8,8,8,8,8,72,72,8,8,8,72,8,8,8,8,8,8,8,8,4,0,30,30,30,5,5,4,4,29,29,29,5,5,5,5,5,5,4,4,5,5,0,21,21,21,21,21,2,3,21,21,21,21,21,5,124,124,124,5,5,5,5,5,5,5,5,124,5,5,125,5,5,5,5,5,5,21,21,0,0,1,30,30,30,30,30,0,0,1,25,30,30,30,30,30,30,30,4,4,29,30,30,30,30,30,30,30,0,30,30,30,29,29,29,29,29,29,29,29,29,29,5,5,5,29,29,29,29,29,41,41,41,5,29,29,5,5,5,41,41,29,29,29,5,29,29,101,0,101,1,1,101,101,101,101,101,101,101,101,1,101,101,101,101,101,101,1,44,110,110,44,44,110,44,110,110,94,101,101,44,44,94,94,0,1,54,44,0,56,56,81,81,81,81,61,81,81,81,81,1,54,44,44,44,54,44,0,25,0,59,59,73,73,73,59,59,59,0,61,61,74,116,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,116,116,116,116,45,45,35,35,35,35,35,35,35,35,115,0,116,117,1,116,116,116,1,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,8,72,72,8,72,40,4,8,8,40,40,40,40,40,40,40,72,40,72,8,8,72,72,8,8,8,8,72,72,8,8,8,8,8,8,8,72,72,72,72,8,8,8,8,8,72,72,30,33,33,0,5,5,4,4,5,5,29,5,4,124,124,124,124,4,4,5,5,5,21,21,21,21,21,2,2,21,21,21,21,21,21,124,124,124,5,5,5,5,5,5,5,5,5,5,5,5,125,125,125,21,21,21,21,30,30,30,30,30,30,30,30,0,0,0,30,30,30,30,0,1,29,29,4,5,29,29,29,29,4,4,30,30,30,30,126,126,30,126,29,29,29,29,29,29,29,29,29,29,30,5,29,29,29,29,29,5,41,29,5,4,4,29,29,5,5,5,29,29,29,29,101,29,101,101,29,101,101,1,101,101,101,101,101,101,0,0,1,101,101,101,101,101,101,101,101,101,101,110,44,44,110,45,45,45,45,101,44,44,94,94,94,1,44,54,54,54,56,81,81,81,81,81,81,81,81,81,1,1,44,44,44,44,44,44,0,0,56,71,73,73,73,59,59,59,59,0,61,0,116,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,116,116,115,115,45,45,45,45,45,35,35,41,41,115,35,35,0,117,117,117,117,117,117,3,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,8,72,72,72,72,72,8,72,72,4,4,8,40,40,40,40,40,40,72,72,8,8,8,8,72,72,8,72,8,72,8,72,72,8,72,8,8,72,72,8,72,72,72,8,8,8,8,8,72,30,30,33,30,5,5,5,5,5,4,5,5,29,5,124,124,124,4,4,5,5,1,21,21,21,21,21,2,2,3,21,21,21,21,124,124,124,124,5,5,5,5,5,5,5,5,5,5,125,122,125,21,21,21,21,21,125,30,30,21,21,21,21,21,1,1,30,30,30,30,1,1,29,29,29,29,4,5,29,29,126,126,5,29,4,4,4,4,4,4,126,126,126,126,126,126,29,29,29,29,29,29,29,29,5,29,29,29,29,29,41,41,29,4,29,4,4,5,5,5,5,29,29,29,29,101,29,101,101,29,29,101,0,101,101,101,101,101,101,101,1,0,101,101,101,101,101,101,101,101,110,101,101,44,110,45,45,45,45,44,101,101,44,44,44,94,1,0,44,54,54,61,81,81,81,81,81,81,81,81,81,81,0,0,44,44,44,44,44,54,1,56,59,59,73,73,73,59,59,56,61,61,1,116,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,3,116,117,117,115,115,45,45,45,45,45,45,35,41,41,41,35,35,35,35,35,35,35,35,0,0,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,40,8,72,8,8,8,8,72,72,72,8,8,40,40,4,4,8,8,8,8,8,40,72,72,8,8,8,8,8,8,8,8,72,8,8,8,8,72,8,72,8,8,72,72,72,72,8,8,8,8,8,4,4,30,30,30,5,5,5,5,124,124,4,4,5,5,5,5,124,124,4,5,5,5,21,21,21,21,21,21,2,3,21,21,21,21,21,124,5,5,5,5,5,21,21,21,21,21,21,21,21,21,21,21,21,125,125,125,21,21,21,21,21,21,21,21,21,30,30,30,1,4,29,29,29,29,29,126,4,4,4,29,29,29,29,29,29,5,126,126,126,126,126,126,126,126,126,126,126,126,29,29,29,29,29,29,29,5,5,5,29,29,29,5,5,29,4,29,29,5,5,5,5,29,29,30,29,29,101,101,101,29,101,101,101,101,101,101,101,101,101,101,101,1,0,101,101,101,101,101,101,101,101,101,101,101,101,94,45,110,45,45,45,101,101,44,44,44,44,44,44,1,44,44,61,81,81,81,81,81,81,81,81,36,81,1,0,44,44,44,44,44,54,54,56,59,84,73,73,73,59,59,56,61,0,0,117,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,116,35,35,45,45,45,45,45,45,45,41,41,41,115,115,115,35,35,35,35,35,35,35,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,4,8,8,72,72,72,4,4,4,40,4,72,8,8,8,8,8,40,40,40,40,40,40,8,8,8,8,8,72,72,8,72,72,8,72,72,72,72,72,72,8,8,8,8,8,8,4,30,33,30,30,30,5,5,5,5,5,124,4,4,5,5,5,5,5,4,4,5,5,21,21,21,21,21,3,2,2,3,21,21,21,21,21,5,21,21,21,21,21,21,21,21,21,21,21,21,21,125,125,125,125,30,30,21,21,21,21,21,21,21,123,123,123,30,4,4,4,4,29,29,29,126,126,126,126,4,4,5,5,126,126,29,29,29,29,126,126,126,126,126,126,126,126,126,126,126,126,29,29,29,126,126,29,29,29,29,29,29,29,29,5,29,4,29,5,5,29,5,29,29,29,30,30,30,101,101,29,29,101,101,29,101,101,101,101,101,101,101,101,45,45,45,101,101,101,101,101,101,101,101,101,101,101,94,94,45,45,45,45,101,94,94,94,54,54,54,44,0,44,61,81,81,81,81,81,61,3,81,81,81,81,81,0,1,44,44,54,44,54,54,61,52,59,73,73,73,59,59,59,61,71,0,117,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,35,35,35,45,45,45,45,45,45,45,45,41,41,115,115,115,115,115,115,115,115,115,35,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,72,4,8,8,4,4,72,72,4,40,40,40,40,72,4,4,4,8,8,8,4,4,4,8,8,8,8,8,72,72,72,72,72,72,8,8,72,72,72,8,72,8,8,8,4,4,4,30,30,33,30,30,4,5,5,4,5,5,4,4,5,5,5,5,4,4,4,5,5,21,21,21,21,21,3,2,2,2,2,21,21,21,21,21,21,21,21,21,21,21,2,2,2,2,21,21,21,21,21,125,21,21,21,21,21,21,21,123,123,123,123,123,123,123,4,4,29,29,29,29,126,126,126,126,126,126,126,5,5,5,5,126,126,29,29,29,29,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,29,29,4,29,29,29,29,29,29,29,35,29,29,29,29,29,29,29,29,30,29,29,101,101,101,101,101,101,101,101,101,101,101,101,101,45,45,45,101,101,101,101,101,101,101,0,101,101,101,44,94,94,94,45,44,44,94,94,94,44,94,44,44,44,44,61,81,81,81,81,81,61,61,81,81,81,56,81,25,1,44,44,54,44,44,0,61,56,59,59,59,73,73,59,25,84,61,1,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,35,35,35,45,45,45,45,45,45,45,45,45,45,35,115,115,115,115,115,115,115,115,35,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,4,4,8,8,8,4,4,4,40,40,40,4,40,4,4,4,4,4,4,4,4,8,4,4,8,8,8,8,8,72,72,72,72,72,72,8,8,8,8,8,8,8,8,4,4,4,0,30,33,33,30,30,4,4,5,4,4,5,5,4,5,5,5,5,5,4,5,5,0,21,21,21,21,1,3,2,2,2,2,2,21,21,21,21,21,21,21,21,2,2,2,2,2,2,21,21,21,21,21,21,21,21,21,21,30,124,124,123,123,123,123,123,123,123,29,29,29,126,29,126,126,126,126,126,126,126,126,126,126,126,5,4,4,126,4,4,126,29,126,126,126,5,5,126,126,126,126,126,126,126,126,126,126,126,126,126,29,29,4,4,4,29,29,29,29,29,29,35,29,29,29,29,29,29,29,30,29,41,41,101,101,29,29,101,101,101,101,101,101,101,101,101,101,45,45,101,101,101,101,101,101,101,101,110,44,44,44,94,94,94,94,94,94,94,44,44,94,94,44,44,44,61,56,81,81,81,81,61,61,81,81,81,56,81,81,1,44,54,54,44,44,1,61,56,59,59,59,59,59,59,1,56,61,1,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,117,35,35,45,45,45,45,45,45,45,45,35,45,35,35,35,115,115,115,115,115,35,35,8,8,8,8,8,8,8,8,8,8,8,8,4,8,4,4,30,4,8,8,8,8,40,40,40,40,4,4,40,4,4,4,4,30,30,30,30,30,30,30,4,4,4,8,8,8,8,72,72,72,72,72,8,8,8,8,8,8,72,72,4,1,0,30,33,30,30,4,4,5,5,4,4,5,5,5,4,5,5,5,4,5,5,5,1,21,21,21,21,21,3,2,2,2,2,2,2,2,21,21,1,2,2,2,2,21,21,21,21,21,21,21,21,21,21,21,124,124,122,122,125,124,124,123,123,29,123,4,29,29,4,4,4,126,126,126,126,126,126,126,126,126,125,126,126,126,126,126,5,4,4,4,4,4,126,126,126,126,5,5,5,126,126,126,126,126,126,126,126,29,29,29,4,4,29,4,29,127,127,29,29,29,29,29,29,29,29,29,29,29,29,5,5,41,41,41,101,101,29,29,29,1,101,101,101,101,101,101,101,101,101,45,45,101,101,101,101,0,0,110,44,110,44,44,44,44,94,94,94,44,44,44,44,94,44,44,44,44,61,54,56,81,81,81,81,81,81,81,81,56,81,81,0,44,54,44,54,44,44,0,56,59,82,59,59,59,59,56,0,61,0,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,115,45,45,115,115,45,45,45,45,45,45,35,35,35,35,115,115,110,115,115,35,35,8,8,8,8,8,8,8,8,4,4,4,8,8,8,8,4,8,8,8,8,40,40,5,40,40,40,40,40,40,4,30,30,30,30,33,33,33,33,33,33,33,30,30,4,8,8,8,8,72,72,72,8,8,8,4,72,72,72,4,0,0,0,30,30,30,30,4,4,4,5,4,4,4,29,5,5,4,4,5,5,5,5,5,5,21,21,21,21,21,21,21,2,2,2,2,2,2,2,2,3,3,2,21,21,21,21,21,21,21,21,21,21,21,21,124,124,124,124,5,122,5,124,5,5,4,4,29,29,29,4,4,0,126,126,126,126,126,5,5,5,126,125,125,125,126,126,126,29,29,126,126,4,126,4,4,126,126,126,126,5,5,5,126,29,126,126,126,126,126,29,126,29,4,4,4,4,4,127,29,127,29,29,5,127,29,29,29,29,29,29,29,5,5,5,41,41,101,101,29,29,29,0,0,101,101,101,101,101,101,101,101,101,45,101,101,101,101,0,1,110,110,110,44,44,44,94,94,93,44,44,44,44,44,94,44,44,44,54,61,56,56,81,81,81,81,81,81,81,81,56,56,81,0,54,54,54,54,44,44,0,61,0,52,59,84,59,59,59,1,61,1,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,3,35,35,35,115,115,45,45,45,45,45,45,45,35,35,115,115,110,110,110,35,35,0,8,8,8,8,8,4,8,8,4,8,8,33,4,8,8,8,8,40,40,4,4,40,40,40,4,4,4,4,30,30,30,1,1,1,1,30,30,30,30,30,30,30,30,4,4,8,8,8,72,72,8,4,4,4,72,4,0,1,30,30,33,30,30,30,4,4,4,4,4,5,124,29,29,5,4,4,5,5,5,5,5,5,21,21,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,2,21,21,21,21,21,21,21,128,124,124,124,124,124,124,124,5,5,5,5,124,124,5,5,5,5,1,4,4,1,126,5,5,126,126,126,126,126,5,5,126,125,125,125,126,126,29,126,126,126,126,126,126,4,4,126,126,126,126,5,5,29,29,126,126,126,126,126,29,29,4,4,4,29,4,4,29,127,29,5,5,5,5,29,29,29,29,29,29,29,29,29,5,5,29,29,101,101,5,29,29,1,101,101,101,101,101,101,101,101,101,45,101,101,101,101,1,0,44,110,110,44,44,101,94,101,93,93,44,44,54,54,94,44,44,54,61,61,81,81,81,81,81,81,81,81,81,81,81,56,56,1,54,54,54,54,44,44,1,61,61,59,59,59,59,59,59,59,71,1,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,35,35,35,35,41,115,45,45,45,45,45,45,45,35,115,115,115,115,115,115,35,1,8,8,8,8,72,4,8,4,30,4,4,4,8,8,29,5,4,40,4,4,4,40,4,4,4,4,30,30,4,4,4,4,4,1,0,0,1,1,1,33,1,30,30,30,30,4,4,72,72,72,4,4,1,30,30,30,30,33,30,30,30,30,4,5,5,5,5,4,4,4,124,124,29,5,5,124,124,124,5,5,5,21,21,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,21,21,21,21,21,21,21,5,124,124,0,5,124,124,5,1,5,5,5,124,124,124,29,29,29,4,4,4,5,5,5,5,5,126,126,126,126,126,5,5,5,5,5,126,29,126,126,126,126,126,126,126,126,126,126,126,126,126,5,29,29,126,126,126,126,126,126,126,126,126,4,29,29,29,129,129,29,29,29,29,29,4,4,5,29,29,29,29,29,29,5,5,5,121,29,29,5,101,101,29,29,101,101,101,101,101,101,101,101,101,45,45,101,101,101,1,0,110,101,110,44,44,101,101,101,101,93,93,44,54,44,94,54,54,54,61,54,81,81,81,81,81,81,81,81,61,81,81,81,56,1,54,54,44,44,44,44,0,0,0,61,59,59,59,59,59,25,61,0,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,0,35,35,35,41,41,41,45,45,45,45,45,45,45,45,115,115,115,115,115,0,1,8,8,8,72,72,8,8,8,4,4,8,8,40,40,4,40,40,8,8,8,8,4,4,30,30,30,8,5,4,4,4,4,4,4,4,29,29,0,1,1,0,0,0,0,30,30,0,4,4,4,4,0,30,33,33,33,33,30,30,30,4,4,4,4,5,4,5,4,4,4,124,124,124,5,5,124,5,5,5,5,5,21,21,1,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,21,21,21,21,21,21,21,5,5,5,5,5,5,5,5,5,5,5,5,4,4,124,4,126,126,4,4,5,5,5,5,5,5,123,123,126,126,126,126,5,5,5,29,29,126,126,126,126,126,126,126,126,126,126,126,126,126,126,29,5,5,5,126,126,126,126,126,126,126,126,126,29,29,29,129,129,129,129,29,29,4,4,4,4,29,29,29,29,29,29,101,29,5,5,5,5,5,29,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,1,44,101,101,101,44,101,44,101,101,101,44,54,54,44,94,94,44,44,61,54,81,81,81,81,61,81,81,81,81,81,81,81,56,1,54,54,44,44,44,44,54,54,0,61,71,59,59,59,0,56,61,0,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,115,35,35,41,45,45,115,45,45,45,45,45,45,45,45,41,35,35,35,1,30,30,4,4,72,4,8,72,72,8,8,4,5,40,40,40,40,8,8,8,4,4,30,30,8,8,8,4,4,72,72,72,4,4,4,4,4,4,4,4,4,4,1,1,1,1,30,30,30,30,30,0,1,30,33,30,30,30,30,4,4,4,4,5,4,5,5,5,4,5,5,4,124,5,5,5,5,5,5,5,21,21,21,0,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,21,21,21,21,21,21,130,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,126,126,126,126,126,5,5,5,126,5,126,123,123,123,126,5,5,5,29,126,126,126,126,126,5,5,126,126,126,126,126,126,126,126,126,126,5,29,29,126,126,29,29,126,126,126,126,126,126,126,29,29,29,129,129,29,29,29,4,4,4,4,29,29,29,29,29,29,29,29,5,5,5,5,29,101,101,101,101,0,101,0,101,101,101,101,101,101,101,45,45,101,101,1,44,44,101,101,101,101,44,101,101,101,44,44,54,94,94,94,94,44,44,61,81,81,81,81,81,81,81,81,81,81,81,56,0,44,1,44,44,44,44,44,44,44,54,61,61,59,75,1,56,56,61,1,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,0,115,41,41,45,45,45,45,45,45,45,45,45,45,45,41,35,35,35,0,0,4,4,4,4,4,72,4,72,72,72,72,72,72,72,8,8,72,4,4,4,30,30,8,8,8,4,4,8,72,72,8,8,8,4,4,5,4,4,4,4,4,4,0,0,0,33,33,33,30,30,30,30,30,30,30,30,4,4,8,8,5,4,4,5,5,4,29,5,5,5,5,5,5,5,5,5,5,5,21,21,21,1,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,21,21,21,21,5,124,5,5,5,5,5,5,4,5,5,5,5,4,4,5,5,4,4,4,126,126,126,126,126,126,126,126,126,126,126,123,123,126,126,126,126,29,29,126,126,126,126,126,5,5,126,126,126,126,126,29,29,126,126,126,126,126,126,29,29,29,29,29,126,126,126,126,29,29,29,29,29,29,29,127,29,29,4,4,29,29,29,29,29,29,29,29,29,29,115,5,5,121,5,101,101,101,101,101,101,101,101,35,35,101,101,0,101,101,101,101,101,101,44,94,44,101,44,44,101,101,93,44,44,54,54,54,45,94,94,44,44,61,61,81,81,81,81,36,81,81,81,81,56,56,44,44,1,44,44,44,44,44,44,44,44,0,61,61,61,56,56,71,61,117,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,115,115,45,45,45,45,45,45,45,45,45,45,45,45,115,35,35,35,1,1,4,4,72,4,72,8,4,4,4,4,72,72,72,72,72,40,4,4,4,30,30,30,8,4,4,8,8,8,8,8,8,72,8,8,4,4,4,4,4,4,4,4,4,0,0,1,30,33,33,30,30,30,1,4,4,4,5,8,8,40,4,4,4,5,5,29,29,29,5,5,5,5,5,5,5,5,5,21,21,21,21,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,21,21,21,21,21,124,5,5,5,5,5,4,4,5,5,5,4,4,5,5,0,4,126,126,126,126,126,126,126,126,126,126,126,126,126,126,5,5,126,126,126,126,126,126,126,126,126,126,126,5,5,5,126,29,29,126,126,126,126,125,125,126,126,126,126,29,29,29,29,126,126,126,126,126,29,29,29,126,126,29,29,29,29,29,35,29,4,4,29,29,29,29,29,29,29,121,121,121,5,5,101,101,101,29,101,101,101,101,35,35,101,101,101,101,101,101,101,101,36,94,94,94,44,44,101,101,93,93,54,44,45,54,45,94,94,44,44,44,61,56,56,84,75,56,56,56,56,56,0,1,44,44,0,44,44,44,94,44,44,44,44,54,54,1,61,61,0,61,61,117,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,116,115,115,45,45,45,45,45,45,115,115,115,115,45,45,115,35,35,110,110,1,72,72,72,72,72,8,4,8,72,8,72,72,72,72,4,40,40,4,4,72,30,4,4,8,8,8,8,8,72,8,8,8,8,8,5,4,4,5,4,4,4,4,4,4,1,0,0,0,1,30,30,0,4,4,40,40,8,8,40,4,4,4,5,4,29,29,4,4,5,5,5,5,5,5,5,5,21,21,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,21,21,21,21,21,21,124,5,5,5,5,5,5,5,4,4,5,4,4,5,5,126,4,126,126,126,126,5,126,126,126,126,126,126,126,4,4,126,126,126,126,126,126,126,126,29,29,126,126,126,5,5,5,29,29,126,126,126,126,126,125,125,125,125,125,125,126,126,29,126,126,126,126,126,29,29,29,29,126,126,126,29,29,29,29,29,29,29,4,29,4,4,29,29,29,29,29,121,121,121,101,29,5,29,29,101,0,101,101,35,101,101,101,0,101,101,101,101,101,101,44,94,94,44,44,44,101,93,93,54,54,54,54,44,44,54,44,54,44,61,61,61,61,1,1,54,54,1,0,44,44,44,1,0,54,44,44,94,44,44,44,44,54,54,44,1,61,61,61,0,117,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,116,116,115,115,115,115,94,45,45,45,45,35,35,35,35,35,115,115,115,115,110,4,72,72,4,4,8,8,8,72,72,72,72,72,72,4,40,40,40,4,72,4,30,4,8,8,8,8,40,8,40,40,8,8,8,8,8,8,4,4,4,4,5,4,4,4,4,4,4,0,0,4,4,4,40,72,8,8,8,8,8,4,4,5,5,29,29,29,5,29,29,5,5,5,5,5,5,21,21,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,21,21,21,21,21,21,5,5,5,5,29,29,1,5,5,5,5,5,4,4,5,5,126,126,126,126,126,126,5,126,126,126,126,126,126,126,4,126,4,29,29,126,126,126,126,126,29,29,29,126,126,126,29,29,5,5,5,4,4,126,126,126,126,125,126,126,126,125,125,125,125,126,126,126,126,29,29,126,126,126,126,126,126,126,29,29,29,29,29,29,29,4,29,29,29,29,29,29,29,121,121,101,101,101,29,29,29,29,101,101,35,35,101,101,101,101,101,101,101,101,101,44,94,94,44,44,44,44,44,54,54,54,54,54,54,44,54,44,54,54,61,44,44,54,54,54,54,54,54,44,44,44,44,44,54,54,94,94,94,44,44,44,44,54,54,54,44,61,0,1,1,116,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,116,116,115,115,115,115,115,115,45,45,45,45,45,35,35,35,35,115,115,115,115,110,4,4,72,4,4,8,29,8,72,8,72,72,72,40,40,4,4,4,8,4,30,30,8,8,8,40,40,8,8,8,40,8,8,8,8,8,8,8,5,72,72,72,72,4,4,4,4,4,4,4,4,5,40,72,72,8,8,8,8,4,4,5,4,29,29,29,5,5,29,29,5,7,5,5,5,21,21,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,21,21,21,21,21,21,5,5,5,5,4,4,4,5,5,5,5,4,4,4,126,126,5,126,126,126,126,126,5,5,5,126,126,126,126,126,4,4,29,29,126,126,126,126,126,126,126,29,29,29,126,29,29,126,5,5,4,126,4,4,126,126,126,126,126,126,126,126,29,125,125,126,126,126,126,126,29,126,126,126,126,126,126,126,29,41,29,29,29,29,4,4,29,29,29,29,29,4,29,121,121,121,101,29,29,29,29,29,1,101,35,35,101,101,101,101,101,101,101,101,101,101,94,94,94,94,44,94,44,44,44,54,54,54,44,44,44,44,44,54,54,54,54,54,54,54,54,54,54,44,44,94,94,0,54,54,94,94,54,54,44,44,44,44,44,54,54,1,1,54,54,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,116,117,0,115,115,115,115,115,115,45,45,45,45,45,115,115,115,115,115,110,110,110,110,4,4,72,4,4,8,8,8,4,8,8,8,4,4,4,4,4,72,4,30,30,8,8,8,8,40,8,8,40,40,8,8,8,8,8,8,8,8,8,4,72,72,72,72,4,4,4,4,8,5,40,40,72,72,72,8,8,5,4,4,5,4,4,29,29,29,5,5,5,7,7,5,5,5,21,21,21,21,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,21,21,21,21,21,21,21,21,5,5,5,5,5,5,4,5,5,5,5,5,5,126,5,5,5,126,126,126,126,5,5,5,126,126,126,126,126,29,29,29,126,126,126,126,126,126,126,126,126,126,126,29,29,126,126,126,5,4,4,4,4,4,29,29,29,126,126,126,4,4,126,126,126,126,126,126,126,126,126,126,126,126,126,29,29,29,29,29,29,29,29,4,4,29,29,29,29,29,4,29,121,121,121,101,29,121,29,29,29,101,101,101,101,101,101,101,101,101,101,101,101,101,101,94,101,94,44,44,94,94,94,94,44,44,44,44,44,44,44,44,44,54,44,44,44,54,54,54,54,94,94,94,94,44,0,54,54,94,94,54,44,44,44,44,44,44,44,54,54,54,54,54,116,116,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,117,117,115,115,115,115,115,115,115,115,94,45,45,45,35,35,115,115,115,110,110,110,0,0,4,4,4,8,8,4,8,4,4,4,4,4,72,30,30,72,30,30,30,72,72,8,8,40,40,8,8,8,8,40,8,8,8,8,8,8,8,72,72,72,4,40,4,4,4,4,4,8,40,40,40,72,72,8,8,8,4,4,5,5,4,29,29,124,5,5,5,5,7,5,5,0,21,21,21,21,21,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,21,21,21,21,21,21,21,21,21,4,5,5,5,5,4,5,5,5,5,5,5,5,126,5,5,5,126,126,126,126,5,5,5,126,126,126,126,126,126,126,126,126,126,126,5,126,126,126,126,126,29,29,29,126,126,126,126,4,4,4,4,4,29,29,29,126,126,126,126,126,126,4,126,126,126,126,126,126,126,126,126,126,126,126,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,4,41,29,29,29,121,101,121,5,5,5,101,1,101,101,101,101,101,101,45,45,101,101,101,101,101,101,101,101,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,54,54,54,44,44,94,94,44,54,54,0,0,44,44,44,44,44,44,44,44,44,44,44,116,117,117,117,116,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,116,116,116,116,116,1,115,115,115,115,115,115,35,35,115,115,115,115,110,110,110,110,0,0,0,4,4,8,4,40,4,4,4,4,4,4,30,30,30,30,4,8,8,8,72,72,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,72,8,8,72,40,4,4,8,4,4,8,40,40,40,8,8,8,5,4,4,5,5,5,5,5,5,29,29,5,5,7,7,5,1,21,21,21,21,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,21,21,21,21,21,21,21,21,21,21,4,4,5,5,5,4,5,5,5,5,5,126,126,126,5,5,5,126,126,126,126,126,5,126,126,126,126,126,126,126,126,5,126,5,5,5,126,126,126,126,126,29,29,126,126,126,126,126,126,4,126,126,4,29,126,29,29,29,29,29,29,4,126,4,126,126,126,126,126,126,29,29,126,126,126,29,126,29,126,126,29,29,29,29,101,29,29,29,29,4,4,41,5,5,5,121,121,121,121,5,5,101,101,101,101,101,101,101,45,45,101,101,101,101,44,101,101,94,94,41,41,44,44,44,44,44,44,44,54,54,101,44,44,54,44,54,61,94,81,81,61,54,44,44,61,54,54,1,54,44,44,44,44,44,44,44,44,44,54,116,116,116,116,116,116,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,116,116,116,116,116,116,0,115,115,115,115,115,115,115,115,115,115,110,110,110,110,0,0,8,4,4,40,40,40,4,4,4,4,4,30,30,8,8,4,4,72,8,8,72,72,72,72,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,40,40,4,8,8,8,8,4,8,8,4,4,8,8,8,4,5,5,5,5,5,4,29,5,29,29,5,5,5,5,5,21,21,21,21,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,21,21,21,21,21,21,21,21,21,5,5,4,4,5,5,4,5,5,5,5,5,126,126,126,126,5,5,5,5,126,126,5,5,5,126,126,126,5,126,126,126,126,5,5,5,5,126,126,123,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,29,29,126,126,126,29,29,29,29,126,29,29,29,126,126,29,126,29,29,29,29,126,126,126,126,126,126,29,29,29,29,29,29,4,4,4,29,29,29,5,5,121,121,121,101,29,101,101,101,101,101,101,101,45,45,101,101,101,101,44,44,101,101,44,41,41,41,44,44,44,54,54,54,54,54,44,44,44,44,44,61,61,94,44,81,81,81,54,81,81,54,0,0,54,54,54,44,44,44,54,54,54,54,116,116,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,116,116,116,116,116,116,116,116,116,115,115,35,115,115,115,115,115,110,110,110,110,110,110,110,4,8,8,4,40,29,4,4,4,4,4,4,30,8,4,4,4,72,72,72,8,8,8,72,72,72,8,8,72,72,72,8,8,8,8,8,40,40,40,8,8,8,8,72,8,8,8,8,8,4,8,8,40,8,4,4,5,124,5,29,29,29,29,29,29,5,5,5,5,0,21,21,21,21,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,21,21,21,21,21,21,21,21,21,21,4,4,4,4,5,5,4,5,5,5,5,126,126,126,4,4,29,126,5,5,5,126,126,126,126,5,5,5,5,126,126,126,126,5,126,126,126,126,126,123,123,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,29,126,126,126,126,126,126,126,126,126,29,29,126,126,29,29,29,126,126,126,126,126,126,126,5,5,29,29,29,29,29,4,29,29,29,29,29,5,5,29,101,5,101,29,101,101,0,101,101,101,101,101,101,101,101,101,101,0,44,101,101,101,41,41,44,41,44,44,101,101,54,54,54,54,54,54,44,44,61,61,54,54,54,61,61,81,81,44,44,44,0,0,54,54,54,54,54,54,116,116,116,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,116,116,116,116,116,116,116,116,115,35,35,35,35,115,115,115,110,110,110,110,110,110,110,4,4,8,4,40,40,40,4,4,4,4,30,4,8,4,4,8,8,72,8,8,8,4,8,72,72,72,8,8,8,72,72,8,8,8,8,8,40,40,8,8,8,8,4,72,72,8,4,4,8,8,8,8,40,4,5,5,124,4,4,29,5,5,5,5,5,5,5,1,21,21,21,21,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,21,21,21,21,21,21,21,21,21,5,4,4,4,4,5,5,4,5,5,5,5,5,126,126,126,4,29,29,126,126,5,126,126,126,126,5,5,126,5,5,5,126,126,126,126,126,126,126,5,5,123,123,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,5,126,126,126,126,126,126,126,126,126,126,126,126,126,126,29,126,126,126,126,126,126,126,126,126,5,5,29,29,29,29,41,29,29,29,29,29,29,29,121,101,101,29,101,101,101,0,101,101,101,101,101,101,101,101,101,101,101,1,44,101,41,101,101,101,101,101,101,101,44,54,54,54,54,44,101,44,44,61,101,81,81,81,81,81,81,81,61,44,47,47,0,54,54,54,116,117,117,117,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,116,116,115,35,35,35,35,35,115,115,41,41,110,110,110,110,110,4,4,8,8,40,29,29,4,4,30,30,30,4,4,4,8,8,8,8,8,8,8,8,8,8,8,8,72,8,8,8,8,8,8,8,8,8,8,40,8,8,8,8,4,4,8,8,4,40,4,8,40,40,4,4,4,4,5,4,4,29,5,5,5,5,5,0,21,21,21,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,21,21,21,21,21,21,21,21,21,124,5,4,5,4,5,5,5,5,5,5,5,5,5,126,126,126,4,126,29,126,126,126,126,126,126,126,126,126,126,5,126,5,5,5,126,126,126,126,126,126,5,123,123,123,126,126,126,126,126,126,126,126,126,126,126,126,4,5,126,126,5,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,5,5,29,29,29,29,29,29,29,29,29,29,29,29,121,101,101,29,101,101,101,101,1,101,101,101,101,101,101,101,101,101,101,0,1,101,101,94,101,101,101,101,101,101,101,44,44,54,54,54,44,44,61,61,61,81,44,61,61,61,81,61,61,44,47,47,47,116,116,116,116,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,115,115,41,41,41,35,35,35,115,115,45,45,45,115,1,4,4,8,8,8,8,4,4,4,30,30,30,4,4,4,8,8,8,8,8,8,8,8,40,8,40,40,72,8,8,72,72,72,8,8,8,8,8,8,8,8,8,8,4,4,4,4,4,40,4,40,40,5,4,5,4,4,5,4,4,5,5,5,5,5,21,21,21,21,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,21,21,21,21,21,21,21,21,21,124,124,4,4,4,4,4,4,5,5,5,5,126,5,126,126,126,126,4,126,4,29,126,126,126,126,126,126,126,126,126,5,5,5,5,5,126,126,126,126,126,126,5,126,123,126,126,126,126,126,126,126,126,126,126,126,4,4,4,5,5,5,5,5,126,126,126,126,126,126,125,125,125,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,29,29,29,29,29,29,29,29,29,29,29,29,29,29,101,101,101,101,29,101,101,101,0,101,101,101,101,101,101,101,101,0,1,101,101,94,45,101,44,44,44,101,44,44,44,54,54,94,44,44,61,61,44,81,61,61,54,44,44,61,61,44,47,47,1,116,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,116,116,116,115,115,41,41,35,35,35,45,115,115,45,45,45,115,0,4,8,8,8,8,8,4,4,4,4,30,30,4,4,5,8,8,72,8,8,8,8,8,8,40,40,40,40,72,8,8,72,72,72,8,8,8,8,8,8,8,8,8,4,4,4,4,4,40,40,40,5,4,4,5,4,5,29,4,5,5,5,5,21,21,21,21,21,21,21,21,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,21,21,21,21,21,21,5,5,5,124,5,4,4,4,4,5,5,5,5,5,5,126,5,126,126,126,126,126,4,4,4,4,29,126,126,126,126,126,126,126,126,126,29,126,5,5,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,4,4,4,5,5,5,5,5,126,126,126,126,126,126,125,126,126,125,125,125,125,126,126,126,126,126,126,126,126,126,126,126,126,29,29,29,29,29,29,29,29,29,29,29,5,5,29,101,101,101,101,101,101,0,1,101,101,101,101,101,101,94,94,94,1,101,101,94,101,45,101,101,101,44,44,44,44,54,54,94,44,44,94,61,44,81,81,61,61,61,44,44,44,47,47,47,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,116,116,116,116,115,41,41,35,35,45,45,45,45,45,45,45,45,45,4,8,8,8,4,29,4,4,4,30,30,30,8,4,4,8,8,72,8,4,8,8,8,8,8,8,8,72,72,72,72,72,72,72,8,8,8,8,8,8,8,8,8,4,4,4,4,4,40,40,40,5,4,5,29,29,29,29,5,5,5,21,21,21,21,21,21,21,21,21,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,21,21,21,21,21,1,5,5,5,7,7,4,4,4,4,4,4,4,4,4,126,5,5,5,5,126,126,126,126,4,4,4,4,29,4,126,126,126,126,126,126,29,29,29,29,29,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,4,4,4,126,5,4,4,4,4,126,126,126,126,29,125,125,125,125,126,126,126,126,126,125,126,126,126,126,126,126,126,126,126,29,29,29,29,29,29,5,29,29,5,5,5,5,5,101,101,101,29,101,101,101,1,101,101,101,101,101,101,94,94,1,94,94,94,94,45,101,101,44,101,101,101,101,44,44,54,94,44,44,54,61,44,44,81,81,61,61,44,44,47,47,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,116,116,116,116,115,35,35,35,35,45,45,45,41,45,45,45,45,45,4,8,4,29,4,30,33,33,30,30,8,8,4,4,4,8,8,72,8,8,8,8,8,8,8,8,8,72,72,72,72,8,8,8,8,8,8,8,4,4,8,8,8,4,4,4,4,40,40,40,5,5,5,29,29,29,5,131,131,5,21,21,21,21,21,21,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,1,21,21,21,21,21,5,5,5,5,7,7,4,4,4,4,4,4,4,4,4,126,126,126,126,126,126,126,126,126,126,126,4,4,126,4,126,126,126,126,126,126,29,29,29,29,29,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,4,4,4,4,4,4,4,4,126,4,4,126,29,29,29,29,29,125,125,29,29,29,126,29,126,126,125,125,125,126,126,126,126,126,29,29,29,29,5,5,5,5,29,5,5,5,5,101,101,101,101,101,101,0,101,1,0,101,101,101,101,94,94,94,94,94,44,94,94,44,101,101,101,44,44,101,101,44,44,54,44,44,44,44,61,61,61,44,81,81,81,36,47,47,47,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,1,0,1,1,3,3,3,3,3,3,3,3,116,116,116,115,35,35,35,35,45,45,41,45,45,45,45,45,45,4,4,4,29,30,33,33,30,8,8,8,4,4,5,8,8,72,72,8,8,8,8,8,8,8,4,5,72,72,72,72,8,8,8,8,8,8,8,4,4,4,4,4,4,4,4,4,4,40,4,5,5,29,29,4,5,5,5,5,21,21,21,21,21,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,1,21,21,21,21,1,5,5,0,5,5,4,4,0,5,4,4,4,1,4,4,4,126,126,126,126,126,126,126,126,126,126,4,4,126,4,126,126,126,126,126,1,29,29,29,29,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,4,4,4,4,4,126,29,29,29,1,126,126,126,126,126,125,125,126,125,125,125,125,125,126,126,126,126,126,126,29,29,5,29,5,5,29,5,5,5,5,5,29,29,29,29,101,29,0,101,0,0,1,101,101,94,94,101,101,94,0,44,94,44,44,44,44,101,101,101,44,44,44,44,44,44,44,44,44,61,61,61,44,0,0,82,47,47,47,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,3,0,3,0,3,1,1,3,3,3,3,3,3,116,116,116,0,35,35,35,115,41,41,45,45,45,45,45,115,0,1,0,29,29,8,8,8,8,8,8,29,29,5,5,8,8,8,8,8,8,8,8,8,8,4,4,5,5,72,72,72,72,72,8,8,5,5,5,5,5,5,5,5,5,5,5,0,4,4,4,0,29,0,29,4,5,0,0,0,0,21,21,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,2,3,0,3,0,0,0,0,0,0,1,0,1,0,5,1,1,0,1,1,0,0,0,0,1,1,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,0,29,29,1,0,29,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,4,126,126,0,0,1,1,0,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,29,29,29,29,29,29,29,29,5,5,29,29,29,29,29,29,29,1,1,1,0,0,0,0,101,94,101,101,1,1,0,0,94,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,61,1,1,75,82,25,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,0,3,3,3,1,0,1,1,3,3,3,3,0,3,3,116,0,1,35,35,0,115,115,115,45,45,45,45,115,115,0,];
}

function getTilePallet()
{
	return ["medit_grass_field_a","medit_grass_field_b","desert_sand_wet","medit_river_rocks_wet","dirtc","desert_dirt_rocks_3","desert_dirt_rocks_1","desert_dirt_rocks_2","desert_rough","temp_cliff_c","temp_sea_weed","temp_grass_wet","temp_sea_rocks","temp_dirt_gravel_plants","temp_grass_mossy","temp_grass_clovers","temp_grass_d","temp_grass_clovers_2","temp_grass_3","temp_mud_plants","temp_grass_long_b","desert_cliff_egypt_2","temp_grass_plants","temp_grass_long","temp_grass_2","medit_grass_field","temp_grass","temp_grass_4","temp_grass_c","desert_dirt_rough","desert_grass_a_sand","medit_grass_field_dry","medit_grass_shrubs","desert_grass_a","temp_plants_bog","steppe_dirt_b","medit_cliff_italia","temp_dirt_gravel_b","medit_shrubs","alpine_cliff_a","desert_sahara","steppe_dirt_rocks_a","medit_rocks_grass","sand_dune_a","alpine_dirt","steppe_dirt_a","medit_grass_field_brown","alpine_cliff_c","medit_shrubs_golden","medit_grass_wild_2","temp_grass_b","alpine_shore_rocks","medit_cliff_greek_2","alpine_shore_rocks_icy","alpine_dirt_grass_50","polar_snow_glacial","alpine_grass_snow_50","polar_ice_snow","polar_tundra_snow","polar_cliff_snow","medit_grass_flowers","alpine_dirt_snow","medit_grass_wild","beach_scrub_50_","beach_cliff_a_50","polar_snow_a","grass_underwater_b","ice_dirt","medit_forestfloor_a","beach_scrub_75","alpine_cliff_b","alpine_forrestfloor_snow","sand","alpine_snow_rocky","medit_cliff_grass","medit_cliff_greek","medit_rocks_shrubs","medit_rocks_grass_shrubs","sand_d","medit_plants_dirt","alpine_grass_rocky","alpine_cliff_snow","medit_cliff_italia_grass","temp_dirt_gravel","medit_cliff_aegean","medit_cliff_aegean_shrubs","beach_cliff_a_75","alpine_grass_c","alpine_grass_b","new_alpine_grass_b","new_alpine_grass_e","polar_ice_cracked","LavaTest05","steppe_grass_c","steppe_grass_a","temp_grass_c_aut","alpine_forrestfloor","rock_metamorphic","temp_forestfloor_pine","alpine_grass_d","LavaTest06","steppe_grass_dirt_33","temp_grass_plants_aut","temp_grass_aut","medit_shrubs_dry","alpine_grass","alpine_grass_a","steppe_grass_b","temp_grass_d_aut","temp_grass_b_aut","steppe_grass_d","temp_cliff_a","temp_cliff_b","temp_grass_long_b_aut","steppe_grass_green_a","steppe_grass_dirt_66","steppe_river_rocks","steppe_river_rocks_dirt","steppe_river_rocks_wet","alpine_shore_rocks_grass_50","desert_cliff_persia_crumbling","desert_grass_a_stones","desert_sand_scrub","desert_dirt_rocks_3_scrub","desert_dirt_persia_rocks","desert_lakebed_dry","desert_sand_stones","desert_sand_dunes_rocks","desert_pebbles_rough","desert_sand_dunes_stones","desert_pebbles_rough_wet","desert_dirt_persia_2",];
}
