#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
set -o errexit

###
# Strange Horticulture
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220329.1

# Set game-specific variables

GAME_ID='strange-horticulture'
GAME_NAME='Strange Horticulture'

ARCHIVE_BASE_2='setup_strange_horticulture_1.1.9.1_(64bit)_(54071).exe'
ARCHIVE_BASE_2_MD5='3f4294de0f17a31ea936052e8e820059'
ARCHIVE_BASE_2_TYPE='innosetup'
ARCHIVE_BASE_2_SIZE='920000'
ARCHIVE_BASE_2_VERSION='1.1.9.1-gog54071'
ARCHIVE_BASE_2_URL='https://www.gog.com/game/strange_horticulture'

ARCHIVE_BASE_1='setup_strange_horticulture_1.0.4_(64bit)_(53097).exe'
ARCHIVE_BASE_1_MD5='6217dd2e77993a5af36954bc19e453c3'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='850000'
ARCHIVE_BASE_1_VERSION='1.0.4-gog53097'

ARCHIVE_BASE_0='setup_strange_horticulture_1.0.3_(64bit)_(53030).exe'
ARCHIVE_BASE_0_MD5='56551c39d923f593b161a5b56d28c904'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='850000'
ARCHIVE_BASE_0_VERSION='1.0.3-gog53030'

UNITY3D_NAME='strange horticulture'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_GAME_BIN_FILES="
strange?horticulture.exe
strange?horticulture_data/plugins
unityplayer.dll
monobleedingedge
unitycrashhandler64.exe"

ARCHIVE_GAME_DATA_FILES="
strange?horticulture_data"

APP_MAIN_TYPE='wine'
APP_MAIN_EXE="${UNITY3D_NAME}.exe"
APP_MAIN_ICON="${UNITY3D_NAME}.exe"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Use persistent storage for user data

APP_WINE_LINK_DIRS='
userdata:users/${USER}/AppData/LocalLow/BadVikingLtd/Strange Horticulture'
DATA_FILES='userdata/Autosave_*.gd'

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
