/*###############################################################################
# Linux Management Providers (LMP), IP provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_IP2GATEWAYACCESS_H_
#define OPENDRIM_IP2GATEWAYACCESS_H_

#include "IP_Common.h"

#include "OpenDRIM_IP2Gateway.h"
#include "assocOpenDRIM_IP2Gateway.h"

int IP_OpenDRIM_IP2Gateway_load(const CMPIBroker* broker, string& errorMessage);

int IP_OpenDRIM_IP2Gateway_unload(string& errorMessage);

int IP_OpenDRIM_IP2Gateway_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_IP2Gateway>& instances, const char** properties, string& errorMessage, const string& discriminant);

int IP_OpenDRIM_IP2Gateway_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_IP2Gateway& instance, const char** properties, string& errorMessage);

int IP_OpenDRIM_IP2Gateway_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_IP2Gateway& newInstance, const OpenDRIM_IP2Gateway& oldInstance, const char** properties, string& errorMessage);

int IP_OpenDRIM_IP2Gateway_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_IP2Gateway& instance, string& errorMessage);

int IP_OpenDRIM_IP2Gateway_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_IP2Gateway& instance, string& errorMessage);

int IP_OpenDRIM_IP2Gateway_associatorAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const char** properties, vector<Instance>& Dependent_associatedInstances, string& errorMessage, const string& discriminant);

int IP_OpenDRIM_IP2Gateway_associatorDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const char** properties, vector<Instance>& Antecedent_associatedInstances, string& errorMessage, const string& discriminant);

int IP_OpenDRIM_IP2Gateway_referenceAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const vector<Instance>& Dependent_instances, vector<OpenDRIM_IP2Gateway>& OpenDRIM_IP2Gateway_instances, const char** properties, string& errorMessage, const string& discriminant);

int IP_OpenDRIM_IP2Gateway_referenceDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const vector<Instance>& Antecedent_instances, vector<OpenDRIM_IP2Gateway>& OpenDRIM_IP2Gateway_instances, const char** properties, string& errorMessage, const string& discriminant);

int IP_OpenDRIM_IP2Gateway_populate(OpenDRIM_IP2Gateway& instance, string& errorMessage);

#endif /*OPENDRIM_IP2GATEWAYACCESS_H_*/
