/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.io.WriterBase;
import java.io.IOException;
import java.io.Writer;

public class UTFTextWriter
extends WriterBase {
    private final boolean mEscapeCR;
    private boolean mJustWroteBracket = false;

    public UTFTextWriter(Writer out, String enc, boolean escapeCR) {
        super(out);
        this.mEscapeCR = escapeCR;
    }

    public void write(int c) throws IOException {
        if (c <= 62) {
            switch (c) {
                case 60: {
                    this.out.write("&lt;");
                    break;
                }
                case 38: {
                    this.out.write("&amp;");
                    break;
                }
                case 62: {
                    if (this.mJustWroteBracket) {
                        this.out.write("&gt;");
                        break;
                    }
                    this.out.write(c);
                    break;
                }
                case 13: {
                    if (this.mEscapeCR) {
                        this.out.write("&#13;");
                        break;
                    }
                    this.out.write(c);
                    break;
                }
                default: {
                    this.out.write(c);
                }
            }
            this.mJustWroteBracket = false;
        } else {
            this.out.write(c);
            this.mJustWroteBracket = c == 93;
        }
    }

    public void write(char[] cbuf, int offset, int len) throws IOException {
        if (len < 2) {
            if (len == 1) {
                this.write(cbuf[offset]);
            }
            return;
        }
        char c = '\u0000';
        len += offset;
        if (this.mJustWroteBracket && (c = cbuf[offset]) == '>') {
            this.out.write("&gt;");
            ++offset;
        }
        do {
            int outLen;
            int start = offset;
            String ent = null;
            while (offset < len) {
                c = cbuf[offset];
                if (c <= '>') {
                    if (c == '<') {
                        ent = "&lt;";
                        break;
                    }
                    if (c == '&') {
                        ent = "&amp;";
                        break;
                    }
                    if (c == '\r') {
                        if (this.mEscapeCR) {
                            ent = "&#13;";
                            break;
                        }
                    } else if (c == '>' && offset > start && cbuf[offset - 1] == ']') {
                        ent = "&gt;";
                        break;
                    }
                }
                ++offset;
            }
            if ((outLen = offset - start) > 0) {
                this.out.write(cbuf, start, outLen);
            }
            if (ent == null) continue;
            this.out.write(ent);
            ent = null;
        } while (++offset < len);
        this.mJustWroteBracket = c == ']';
    }

    public void write(String str, int offset, int len) throws IOException {
        if (len < 2) {
            if (len == 1) {
                this.write(str.charAt(offset));
            }
            return;
        }
        char c = '\u0000';
        len += offset;
        if (this.mJustWroteBracket && (c = str.charAt(offset)) == '>') {
            this.out.write("&gt;");
            ++offset;
        }
        do {
            int outLen;
            int start = offset;
            String ent = null;
            while (offset < len) {
                c = str.charAt(offset);
                if (c <= '>') {
                    if (c == '<') {
                        ent = "&lt;";
                        break;
                    }
                    if (c == '&') {
                        ent = "&amp;";
                        break;
                    }
                    if (c == '\r') {
                        if (this.mEscapeCR) {
                            ent = "&#13;";
                            break;
                        }
                    } else if (c == '>' && offset > start && str.charAt(offset - 1) == ']') {
                        ent = "&gt;";
                        break;
                    }
                }
                ++offset;
            }
            if ((outLen = offset - start) > 0) {
                this.out.write(str, start, outLen);
            }
            if (ent == null) continue;
            this.out.write(ent);
            ent = null;
        } while (++offset < len);
        this.mJustWroteBracket = c == ']';
    }
}

