/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Strings;
import java.io.IOException;
import java.io.RandomAccessFile;

public class NumberListBox
extends JP2Box {
    private Property[] propArray;

    public NumberListBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    @Override
    public boolean readBox() throws IOException {
        this.initBytesRead();
        int n = (int)this._boxHeader.getDataLength() / 4;
        if (n > 0) {
            this.propArray = new Property[n];
            for (int i = 0; i < n; ++i) {
                long l = this._module.readUnsignedInt(this._dstrm);
                int n2 = (int)((l & 0xFF000000L) >> 24);
                int n3 = (int)(l & 0xFFFFFFL);
                App app = this._module.getApp();
                Property[] propertyArray = new Property[]{this._module.addIntegerProperty("Type", n2, JP2Strings.numberListTypeStr), new Property("Value", PropertyType.INTEGER, (Object)new Integer(n3))};
                this.propArray[i] = new Property("Number", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propertyArray);
            }
        }
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected Property getSelfPropDesc() {
        if (this.propArray != null) {
            return new Property("Description", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)this.propArray);
        }
        return null;
    }

    @Override
    protected String getSelfPropName() {
        return "Number List Box";
    }
}

