/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import java.util.Vector;

public final class Destination {
    private boolean _indirect;
    private PdfSimpleObject _indirectDest;
    private PdfDictionary _pageDest;

    public Destination(PdfObject pdfObject, PdfModule pdfModule, boolean bl) throws PdfException {
        block5: {
            try {
                if (!bl && pdfObject instanceof PdfSimpleObject) {
                    this._indirect = true;
                    this._indirectDest = (PdfSimpleObject)pdfObject;
                    break block5;
                }
                if (pdfObject instanceof PdfArray) {
                    this._indirect = false;
                    Vector vector = ((PdfArray)pdfObject).getContent();
                    this._pageDest = (PdfDictionary)pdfModule.resolveIndirectObject((PdfObject)vector.elementAt(0));
                    break block5;
                }
                if (bl && pdfObject instanceof PdfDictionary) {
                    PdfArray pdfArray = (PdfArray)((PdfDictionary)pdfObject).get("D");
                    this._indirect = false;
                    Vector vector = pdfArray.getContent();
                    this._pageDest = (PdfDictionary)pdfModule.resolveIndirectObject((PdfObject)vector.elementAt(0));
                    break block5;
                }
                throw new Exception("");
            }
            catch (Exception exception) {
                throw new PdfInvalidException("Invalid destination object");
            }
        }
    }

    public boolean isIndirect() {
        return this._indirect;
    }

    public PdfSimpleObject getIndirectDest() {
        return this._indirectDest;
    }

    public PdfDictionary getPageDest() {
        return this._pageDest;
    }

    public int getPageDestObjNumber() throws NullPointerException {
        return this._pageDest.getObjNumber();
    }
}

