/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import java.io.IOException;
import java.io.InputStream;

public class XMLWrapperStream
extends InputStream {
    private String xmlDecl;
    private String rootStart;
    private String rootEnd;
    private int strIndex;
    private int state;
    private static final int DECL = 0;
    private static final int ROOT_START = 1;
    private static final int CONTENT = 2;
    private static final int ROOT_END = 3;
    private InputStream _wrappedStream;

    public XMLWrapperStream(InputStream inputStream, String string, String string2, String string3, String string4) {
        this._wrappedStream = inputStream;
        this.xmlDecl = "<?xml version='";
        this.xmlDecl = string2 == null ? this.xmlDecl + "1.0'" : this.xmlDecl + string2 + "'";
        if (string3 != null) {
            this.xmlDecl = this.xmlDecl + " encoding='" + string3 + "' ";
        }
        if (string4 != null) {
            this.xmlDecl = this.xmlDecl + " standalone='" + string4 + "' ";
        }
        this.xmlDecl = this.xmlDecl + "?>";
        this.state = 0;
        this.strIndex = 0;
        if (string != null) {
            this.rootStart = "<" + string + ">";
            this.rootEnd = "</" + string + ">";
        } else {
            this.rootStart = "";
            this.rootEnd = "";
        }
    }

    public XMLWrapperStream(InputStream inputStream) {
        this(inputStream, null, null, null, null);
    }

    public XMLWrapperStream(InputStream inputStream, String string) {
        this(inputStream, string, null, null, null);
    }

    @Override
    public int read() throws IOException {
        if (this.state == 0) {
            if (this.strIndex >= this.xmlDecl.length()) {
                this.state = 1;
                this.strIndex = 0;
            } else {
                return this.xmlDecl.charAt(this.strIndex++);
            }
        }
        if (this.state == 1) {
            if (this.strIndex >= this.rootStart.length()) {
                this.state = 2;
            } else {
                return this.rootStart.charAt(this.strIndex++);
            }
        }
        if (this.state == 2) {
            int n = this._wrappedStream.read();
            if (n == -1) {
                this.state = 3;
                this.strIndex = 0;
            } else {
                return n;
            }
        }
        if (this.strIndex >= this.rootEnd.length()) {
            return -1;
        }
        return this.rootEnd.charAt(this.strIndex++);
    }
}

