/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.reader;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.encoding.reader.AbstractReader;
import htsjdk.samtools.cram.encoding.reader.DataReader;
import htsjdk.samtools.cram.encoding.readfeatures.BaseQualityScore;
import htsjdk.samtools.cram.encoding.readfeatures.Bases;
import htsjdk.samtools.cram.encoding.readfeatures.Deletion;
import htsjdk.samtools.cram.encoding.readfeatures.HardClip;
import htsjdk.samtools.cram.encoding.readfeatures.InsertBase;
import htsjdk.samtools.cram.encoding.readfeatures.Insertion;
import htsjdk.samtools.cram.encoding.readfeatures.Padding;
import htsjdk.samtools.cram.encoding.readfeatures.ReadBase;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.RefSkip;
import htsjdk.samtools.cram.encoding.readfeatures.Scores;
import htsjdk.samtools.cram.encoding.readfeatures.SoftClip;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.structure.AlignmentSpan;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.ReadTag;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class RefSeqIdReader
extends AbstractReader {
    private final int globalReferenceSequenceId;
    private int alignmentStart;
    private ValidationStringency validationStringency;
    private int recordCounter = 0;
    private final CramCompressionRecord cramRecord = new CramCompressionRecord();
    private final Map<Integer, AlignmentSpan> spans = new HashMap<Integer, AlignmentSpan>();

    public RefSeqIdReader(int seqId, int alignmentStart, ValidationStringency validationStringency) {
        this.globalReferenceSequenceId = seqId;
        this.alignmentStart = alignmentStart;
        this.validationStringency = validationStringency;
    }

    public Map<Integer, AlignmentSpan> getReferenceSpans() {
        return this.spans;
    }

    public void read() {
        this.cramRecord.sequenceId = this.globalReferenceSequenceId;
        try {
            int i;
            this.cramRecord.flags = (Integer)this.bitFlagsCodec.readData();
            this.cramRecord.compressionFlags = ((Byte)this.compressionBitFlagsCodec.readData()).byteValue();
            this.cramRecord.sequenceId = this.refId == -2 ? (Integer)this.refIdCodec.readData() : this.refId;
            this.cramRecord.readLength = (Integer)this.readLengthCodec.readData();
            if (this.APDelta) {
                this.cramRecord.alignmentDelta = (Integer)this.alignmentStartCodec.readData();
                this.alignmentStart += this.cramRecord.alignmentDelta;
            } else {
                this.alignmentStart = this.cramRecord.alignmentStart = ((Integer)this.alignmentStartCodec.readData()).intValue();
            }
            this.cramRecord.readGroupID = (Integer)this.readGroupCodec.readData();
            if (this.captureReadNames) {
                this.cramRecord.readName = new String((byte[])this.readNameCodec.readData(), this.charset);
            }
            if (this.cramRecord.isDetached()) {
                this.cramRecord.mateFlags = ((Byte)this.mateBitFlagCodec.readData()).byteValue();
                if (!this.captureReadNames) {
                    this.cramRecord.readName = new String((byte[])this.readNameCodec.readData(), this.charset);
                }
                this.cramRecord.mateSequenceID = (Integer)this.mateReferenceIdCodec.readData();
                this.cramRecord.mateAlignmentStart = (Integer)this.mateAlignmentStartCodec.readData();
                this.cramRecord.templateSize = (Integer)this.insertSizeCodec.readData();
                ++detachedCount;
            } else if (this.cramRecord.isHasMateDownStream()) {
                this.cramRecord.recordsToNextFragment = (Integer)this.distanceToNextFragmentCodec.readData();
            }
            Integer tagIdList = (Integer)this.tagIdListCodec.readData();
            byte[][] ids = this.tagIdDictionary[tagIdList];
            if (ids.length > 0) {
                int tagCount = ids.length;
                this.cramRecord.tags = new ReadTag[tagCount];
                for (i = 0; i < ids.length; ++i) {
                    ReadTag tag;
                    int id = ReadTag.name3BytesToInt(ids[i]);
                    DataReader dataReader = (DataReader)this.tagValueCodecs.get(id);
                    this.cramRecord.tags[i] = tag = new ReadTag(id, (byte[])dataReader.readData(), this.validationStringency);
                }
            }
            if (!this.cramRecord.isSegmentUnmapped()) {
                int size = (Integer)this.numberOfReadFeaturesCodec.readData();
                int prevPos = 0;
                LinkedList<ReadFeature> readFeatures = new LinkedList<ReadFeature>();
                this.cramRecord.readFeatures = readFeatures;
                block17: for (int i2 = 0; i2 < size; ++i2) {
                    int pos;
                    Byte operator = (Byte)this.readFeatureCodeCodec.readData();
                    prevPos = pos = prevPos + (Integer)this.readFeaturePositionCodec.readData();
                    switch (operator) {
                        case 66: {
                            ReadBase readBase = new ReadBase(pos, (Byte)this.baseCodec.readData(), (Byte)this.qualityScoreCodec.readData());
                            readFeatures.add(readBase);
                            continue block17;
                        }
                        case 88: {
                            Substitution substitution = new Substitution();
                            substitution.setPosition(pos);
                            byte code = (Byte)this.baseSubstitutionCodec.readData();
                            substitution.setCode(code);
                            readFeatures.add(substitution);
                            continue block17;
                        }
                        case 73: {
                            Insertion insertion = new Insertion(pos, (byte[])this.insertionCodec.readData());
                            readFeatures.add(insertion);
                            continue block17;
                        }
                        case 83: {
                            SoftClip softClip = new SoftClip(pos, (byte[])this.softClipCodec.readData());
                            readFeatures.add(softClip);
                            continue block17;
                        }
                        case 72: {
                            HardClip hardCLip = new HardClip(pos, (Integer)this.hardClipCodec.readData());
                            readFeatures.add(hardCLip);
                            continue block17;
                        }
                        case 80: {
                            Padding padding = new Padding(pos, (Integer)this.paddingCodec.readData());
                            readFeatures.add(padding);
                            continue block17;
                        }
                        case 68: {
                            Deletion deletion = new Deletion(pos, (Integer)this.deletionLengthCodec.readData());
                            readFeatures.add(deletion);
                            continue block17;
                        }
                        case 78: {
                            RefSkip refSkip = new RefSkip(pos, (Integer)this.refSkipCodec.readData());
                            readFeatures.add(refSkip);
                            continue block17;
                        }
                        case 105: {
                            InsertBase insertBase = new InsertBase(pos, (Byte)this.baseCodec.readData());
                            readFeatures.add(insertBase);
                            continue block17;
                        }
                        case 81: {
                            BaseQualityScore baseQualityScore = new BaseQualityScore(pos, (Byte)this.qualityScoreCodec.readData());
                            readFeatures.add(baseQualityScore);
                            continue block17;
                        }
                        case 98: {
                            Bases bases = new Bases(pos, (byte[])this.basesCodec.readData());
                            readFeatures.add(bases);
                            continue block17;
                        }
                        case 113: {
                            Scores scores = new Scores(pos, (byte[])this.scoresCodec.readData());
                            readFeatures.add(scores);
                            continue block17;
                        }
                        default: {
                            throw new RuntimeException("Unknown read feature operator: " + operator);
                        }
                    }
                }
                this.cramRecord.mappingQuality = (Integer)this.mappingScoreCodec.readData();
                if (this.cramRecord.isForcePreserveQualityScores()) {
                    this.cramRecord.qualityScores = (byte[])this.qualityScoresCodec.readDataArray(this.cramRecord.readLength);
                }
            } else if (this.cramRecord.isUnknownBases()) {
                this.cramRecord.readBases = SAMRecord.NULL_SEQUENCE;
                this.cramRecord.qualityScores = SAMRecord.NULL_QUALS;
            } else {
                byte[] bases = new byte[this.cramRecord.readLength];
                for (i = 0; i < bases.length; ++i) {
                    bases[i] = (Byte)this.baseCodec.readData();
                }
                this.cramRecord.readBases = bases;
                if (this.cramRecord.isForcePreserveQualityScores()) {
                    this.cramRecord.qualityScores = (byte[])this.qualityScoresCodec.readDataArray(this.cramRecord.readLength);
                }
            }
            ++this.recordCounter;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        if (!this.spans.containsKey(this.cramRecord.sequenceId)) {
            this.spans.put(this.cramRecord.sequenceId, new AlignmentSpan(this.alignmentStart, this.cramRecord.readLength));
        } else {
            this.spans.get(this.cramRecord.sequenceId).addSingle(this.alignmentStart, this.cramRecord.readLength);
        }
    }
}

