/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.activity.shared;

import com.google.gwt.activity.shared.AbstractActivity;
import com.google.gwt.activity.shared.Activity;
import com.google.gwt.activity.shared.ActivityMapper;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.ResettableEventBus;
import com.google.gwt.event.shared.UmbrellaException;
import com.google.gwt.place.shared.PlaceChangeEvent;
import com.google.gwt.place.shared.PlaceChangeRequestEvent;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.LinkedHashSet;

public class ActivityManager
implements PlaceChangeEvent.Handler,
PlaceChangeRequestEvent.Handler {
    private static final Activity NULL_ACTIVITY = new AbstractActivity(){

        public void start(AcceptsOneWidget panel, EventBus eventBus) {
        }
    };
    private final ActivityMapper mapper;
    private final EventBus eventBus;
    private final ResettableEventBus stopperedEventBus;
    private Activity currentActivity = NULL_ACTIVITY;
    private AcceptsOneWidget display;
    private boolean startingNext = false;
    private HandlerRegistration handlerRegistration;

    public ActivityManager(ActivityMapper mapper, EventBus eventBus) {
        this.mapper = mapper;
        this.eventBus = eventBus;
        this.stopperedEventBus = new ResettableEventBus(eventBus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPlaceChange(PlaceChangeEvent event) {
        Activity nextActivity = this.getNextActivity(event);
        Throwable caughtOnStop = null;
        Throwable caughtOnStart = null;
        if (nextActivity == null) {
            nextActivity = NULL_ACTIVITY;
        }
        if (this.currentActivity.equals(nextActivity)) {
            return;
        }
        if (this.startingNext) {
            this.currentActivity.onCancel();
            this.currentActivity = NULL_ACTIVITY;
            this.startingNext = false;
        } else if (!this.currentActivity.equals(NULL_ACTIVITY)) {
            this.showWidget(null);
            this.stopperedEventBus.removeHandlers();
            try {
                this.currentActivity.onStop();
            }
            catch (Throwable t) {
                caughtOnStop = t;
            }
            finally {
                this.stopperedEventBus.removeHandlers();
            }
        }
        this.currentActivity = nextActivity;
        if (this.currentActivity.equals(NULL_ACTIVITY)) {
            this.showWidget(null);
            return;
        }
        this.startingNext = true;
        try {
            this.currentActivity.start(new ProtectedDisplay(this.currentActivity), this.stopperedEventBus);
        }
        catch (Throwable t) {
            caughtOnStart = t;
        }
        if (caughtOnStart != null || caughtOnStop != null) {
            LinkedHashSet<Throwable> causes = new LinkedHashSet<Throwable>();
            if (caughtOnStop != null) {
                causes.add(caughtOnStop);
            }
            if (caughtOnStart != null) {
                causes.add(caughtOnStart);
            }
            throw new UmbrellaException(causes);
        }
    }

    public void onPlaceChangeRequest(PlaceChangeRequestEvent event) {
        if (!this.currentActivity.equals(NULL_ACTIVITY)) {
            event.setWarning(this.currentActivity.mayStop());
        }
    }

    public void setDisplay(AcceptsOneWidget display) {
        boolean wasActive = null != this.display;
        boolean willBeActive = null != display;
        this.display = display;
        if (wasActive != willBeActive) {
            this.updateHandlers(willBeActive);
        }
    }

    private Activity getNextActivity(PlaceChangeEvent event) {
        if (this.display == null) {
            return null;
        }
        return this.mapper.getActivity(event.getNewPlace());
    }

    private void showWidget(IsWidget view) {
        if (this.display != null) {
            this.display.setWidget(view);
        }
    }

    private void updateHandlers(boolean activate) {
        if (activate) {
            final HandlerRegistration placeReg = this.eventBus.addHandler(PlaceChangeEvent.TYPE, this);
            final HandlerRegistration placeRequestReg = this.eventBus.addHandler(PlaceChangeRequestEvent.TYPE, this);
            this.handlerRegistration = new HandlerRegistration(){

                public void removeHandler() {
                    placeReg.removeHandler();
                    placeRequestReg.removeHandler();
                }
            };
        } else if (this.handlerRegistration != null) {
            this.handlerRegistration.removeHandler();
            this.handlerRegistration = null;
        }
    }

    private class ProtectedDisplay
    implements AcceptsOneWidget {
        private final Activity activity;

        ProtectedDisplay(Activity activity) {
            this.activity = activity;
        }

        public void setWidget(IsWidget view) {
            if (this.activity == ActivityManager.this.currentActivity) {
                ActivityManager.this.startingNext = false;
                ActivityManager.this.showWidget(view);
            }
        }
    }
}

