RabbitMQ `3.11.23` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).
This release series [goes out of community support on Dec 31, 2023](https://rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25 and supports Erlang versions up to `25.3.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).


### Core Server

#### Bug Fixes

 * High consumer churn with reused consumer tag on quorum queues could result in some messages not being delivered
   after a period of time.

   This did not affect environments where consumer churn does not exist or where it does but consumer tags vary.

   GitHub issue: [#9164](https://github.com/rabbitmq/rabbitmq-server/pull/9164)

 * Three environment variables, `LOG_BASE`, `MNESIA_BASE`, `CONFIG_FILE`, were not picked up when set in
   `rabbitmq-env-conf.bat` on Windows.

   GitHub issue: [#9308](https://github.com/rabbitmq/rabbitmq-server/pull/9308)

 * Avoids a potential exception when autoheal partition handling process was initiated.

   GitHub issue: [#9223](https://github.com/rabbitmq/rabbitmq-server/pull/9223)


## Dependency Upgrades

 * `osiris` was upgraded to [`1.6.4`](https://github.com/rabbitmq/osiris/tags)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.23.tar.xz`
instead of the source tarball produced by GitHub.
