## RabbitMQ 3.5.8

RabbitMQ `3.5.8` fixes a security vulnerability ([CVE-2016-9877](https://pivotal.io/security/cve-2016-9877)) in the MQTT plugin.

### Server

#### Security

 * `rabbit_diagnostics:maybe_stuck/0` no longer prints process' dictionary
   because it may contain PRNG seed values and other sensitive information.
   
### MQTT Plugin

#### Security

 * Authentication with correct username but omitted password succeeded when TLS/x509 certificate
   wasn't provided by the client. CVE allocation for this vulnerability is pending.

   GitHub issue: [rabbitmq-mqtt#96](https://github.com/rabbitmq/rabbitmq-mqtt/issues/96)

## Upgrading

To upgrade a non-clustered RabbitMQ simply install the new version. All configuration and persistent message data are retained.

To upgrade a RabbitMQ cluster, follow the instructions [in RabbitMQ documentation](https://www.rabbitmq.com/clustering.html#upgrading).

## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker, not the plugins or the client libraries.
Please download the archive named `rabbitmq-3.5.8.tar.gz`.
