/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.text;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.RootGraphicsNode;
import org.apache.batik.gvt.Selectable;
import org.apache.batik.gvt.Selector;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.event.GraphicsNodeChangeEvent;
import org.apache.batik.gvt.event.GraphicsNodeEvent;
import org.apache.batik.gvt.event.GraphicsNodeKeyEvent;
import org.apache.batik.gvt.event.GraphicsNodeMouseEvent;
import org.apache.batik.gvt.event.SelectionEvent;
import org.apache.batik.gvt.event.SelectionListener;
import org.apache.batik.gvt.text.Mark;

public class ConcreteTextSelector
implements Selector {
    private ArrayList listeners;
    private GraphicsNode selectionNode;
    private RootGraphicsNode selectionNodeRoot;

    public void mouseClicked(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
        this.checkSelectGesture(graphicsNodeMouseEvent);
    }

    public void mouseDragged(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
        this.checkSelectGesture(graphicsNodeMouseEvent);
    }

    public void mouseEntered(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
        this.checkSelectGesture(graphicsNodeMouseEvent);
    }

    public void mouseExited(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
        this.checkSelectGesture(graphicsNodeMouseEvent);
    }

    public void mouseMoved(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
    }

    public void mousePressed(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
        this.checkSelectGesture(graphicsNodeMouseEvent);
    }

    public void mouseReleased(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
        this.checkSelectGesture(graphicsNodeMouseEvent);
    }

    public void keyPressed(GraphicsNodeKeyEvent graphicsNodeKeyEvent) {
        this.report(graphicsNodeKeyEvent, "keyPressed");
    }

    public void keyReleased(GraphicsNodeKeyEvent graphicsNodeKeyEvent) {
        this.report(graphicsNodeKeyEvent, "keyReleased");
    }

    public void keyTyped(GraphicsNodeKeyEvent graphicsNodeKeyEvent) {
        this.report(graphicsNodeKeyEvent, "keyTyped");
    }

    public void changeStarted(GraphicsNodeChangeEvent graphicsNodeChangeEvent) {
    }

    public void changeCompleted(GraphicsNodeChangeEvent graphicsNodeChangeEvent) {
        if (this.selectionNode == null) {
            return;
        }
        Shape shape = ((Selectable)((Object)this.selectionNode)).getHighlightShape();
        this.dispatchSelectionEvent(new SelectionEvent(this.getSelection(), 1, shape));
    }

    public void setSelection(Mark mark, Mark mark2) {
        TextNode textNode = mark.getTextNode();
        if (textNode != mark2.getTextNode()) {
            throw new Error("Markers not from same TextNode");
        }
        textNode.setSelection(mark, mark2);
        this.selectionNode = textNode;
        this.selectionNodeRoot = textNode.getRoot();
        Object object = this.getSelection();
        Shape shape = textNode.getHighlightShape();
        this.dispatchSelectionEvent(new SelectionEvent(object, 2, shape));
    }

    public void clearSelection() {
        if (this.selectionNode == null) {
            return;
        }
        this.dispatchSelectionEvent(new SelectionEvent(null, 3, null));
        this.selectionNode = null;
        this.selectionNodeRoot = null;
    }

    protected void checkSelectGesture(GraphicsNodeEvent graphicsNodeEvent) {
        GraphicsNodeMouseEvent graphicsNodeMouseEvent = null;
        if (graphicsNodeEvent instanceof GraphicsNodeMouseEvent) {
            graphicsNodeMouseEvent = (GraphicsNodeMouseEvent)graphicsNodeEvent;
        }
        GraphicsNode graphicsNode = graphicsNodeEvent.getGraphicsNode();
        if (this.isDeselectGesture(graphicsNodeEvent)) {
            if (this.selectionNode != null) {
                this.selectionNodeRoot.removeTreeGraphicsNodeChangeListener(this);
            }
            this.clearSelection();
        } else if (graphicsNodeMouseEvent != null) {
            Point2D point2D = new Point2D.Double(graphicsNodeMouseEvent.getX(), graphicsNodeMouseEvent.getY());
            AffineTransform affineTransform = graphicsNode.getGlobalTransform();
            if (affineTransform == null) {
                affineTransform = new AffineTransform();
            } else {
                try {
                    affineTransform = affineTransform.createInverse();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
            point2D = affineTransform.transform(point2D, null);
            if (graphicsNode instanceof Selectable && this.isSelectStartGesture(graphicsNodeEvent)) {
                if (this.selectionNode != graphicsNode) {
                    if (this.selectionNode != null) {
                        this.selectionNodeRoot.removeTreeGraphicsNodeChangeListener(this);
                    }
                    this.selectionNode = graphicsNode;
                    if (graphicsNode != null) {
                        this.selectionNodeRoot = graphicsNode.getRoot();
                        this.selectionNodeRoot.addTreeGraphicsNodeChangeListener(this);
                    }
                }
                ((Selectable)((Object)graphicsNode)).selectAt(point2D.getX(), point2D.getY());
                this.dispatchSelectionEvent(new SelectionEvent(null, 4, null));
            } else if (this.isSelectEndGesture(graphicsNodeEvent)) {
                if (this.selectionNode == graphicsNode) {
                    ((Selectable)((Object)graphicsNode)).selectTo(point2D.getX(), point2D.getY());
                }
                Object object = this.getSelection();
                if (this.selectionNode != null) {
                    Shape shape = ((Selectable)((Object)this.selectionNode)).getHighlightShape();
                    this.dispatchSelectionEvent(new SelectionEvent(object, 2, shape));
                }
            } else if (this.isSelectContinueGesture(graphicsNodeEvent)) {
                boolean bl;
                if (this.selectionNode == graphicsNode && (bl = ((Selectable)((Object)graphicsNode)).selectTo(point2D.getX(), point2D.getY()))) {
                    Shape shape = ((Selectable)((Object)this.selectionNode)).getHighlightShape();
                    this.dispatchSelectionEvent(new SelectionEvent(null, 1, shape));
                }
            } else if (graphicsNode instanceof Selectable && this.isSelectAllGesture(graphicsNodeEvent)) {
                if (this.selectionNode != graphicsNode) {
                    if (this.selectionNode != null) {
                        this.selectionNodeRoot.removeTreeGraphicsNodeChangeListener(this);
                    }
                    this.selectionNode = graphicsNode;
                    if (graphicsNode != null) {
                        this.selectionNodeRoot = graphicsNode.getRoot();
                        this.selectionNodeRoot.addTreeGraphicsNodeChangeListener(this);
                    }
                }
                ((Selectable)((Object)graphicsNode)).selectAll(point2D.getX(), point2D.getY());
                Object object = this.getSelection();
                Shape shape = ((Selectable)((Object)graphicsNode)).getHighlightShape();
                this.dispatchSelectionEvent(new SelectionEvent(object, 2, shape));
            }
        }
    }

    private boolean isDeselectGesture(GraphicsNodeEvent graphicsNodeEvent) {
        return graphicsNodeEvent.getID() == 500 && ((GraphicsNodeMouseEvent)graphicsNodeEvent).getClickCount() == 1;
    }

    private boolean isSelectStartGesture(GraphicsNodeEvent graphicsNodeEvent) {
        return graphicsNodeEvent.getID() == 501;
    }

    private boolean isSelectEndGesture(GraphicsNodeEvent graphicsNodeEvent) {
        return graphicsNodeEvent.getID() == 502;
    }

    private boolean isSelectContinueGesture(GraphicsNodeEvent graphicsNodeEvent) {
        return graphicsNodeEvent.getID() == 506;
    }

    private boolean isSelectAllGesture(GraphicsNodeEvent graphicsNodeEvent) {
        return graphicsNodeEvent.getID() == 500 && ((GraphicsNodeMouseEvent)graphicsNodeEvent).getClickCount() == 2;
    }

    public Object getSelection() {
        Object object = null;
        if (this.selectionNode instanceof Selectable) {
            object = ((Selectable)((Object)this.selectionNode)).getSelection();
        }
        return object;
    }

    public boolean isEmpty() {
        return this.getSelection() == null;
    }

    public void dispatchSelectionEvent(SelectionEvent selectionEvent) {
        if (this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            switch (selectionEvent.getID()) {
                case 2: {
                    while (iterator.hasNext()) {
                        ((SelectionListener)iterator.next()).selectionDone(selectionEvent);
                    }
                    break;
                }
                case 1: {
                    while (iterator.hasNext()) {
                        ((SelectionListener)iterator.next()).selectionChanged(selectionEvent);
                    }
                    break;
                }
                case 3: {
                    while (iterator.hasNext()) {
                        ((SelectionListener)iterator.next()).selectionCleared(selectionEvent);
                    }
                    break;
                }
                case 4: {
                    while (iterator.hasNext()) {
                        ((SelectionListener)iterator.next()).selectionStarted(selectionEvent);
                    }
                    break;
                }
            }
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        if (this.listeners != null) {
            this.listeners.remove(selectionListener);
        }
    }

    private void report(GraphicsNodeEvent graphicsNodeEvent, String string) {
        GraphicsNode graphicsNode = graphicsNodeEvent.getGraphicsNode();
        String string2 = "(non-text node)";
        if (graphicsNode instanceof TextNode) {
            AttributedCharacterIterator attributedCharacterIterator = ((TextNode)graphicsNode).getAttributedCharacterIterator();
            char[] cArray = new char[attributedCharacterIterator.getEndIndex()];
            if (cArray.length > 0) {
                cArray[0] = attributedCharacterIterator.first();
            }
            for (int i = 1; i < cArray.length; ++i) {
                cArray[i] = attributedCharacterIterator.next();
            }
            string2 = new String(cArray);
        }
        System.out.println("Mouse " + string + " in " + string2);
    }
}

