// ライセンス: GPL2

//
// 画像クラスのベースクラス
//

#ifndef _IMAGEAREABASE_H
#define _IMAGEAREABASE_H

#include <gtkmm.h>

#include "skeleton/dispatchable.h"

#include "jdlib/constptr.h"
#include "jdlib/jdthread.h"

namespace DBIMG
{
    class Img;
}


namespace IMAGE
{
    class ImageAreaBase : public Gtk::Image, public SKELETON::Dispatchable
    {
        std::string m_url;
        JDLIB::ConstPtr< DBIMG::Img > m_img;
        Glib::RefPtr< Gdk::PixbufLoader > m_imgloader;
        Gdk::InterpType m_interptype;

        std::string m_errmsg; // エラーメッセージ

        bool m_ready; // 画像がsetされた

        int m_width;
        int m_height;

        // スレッド用変数
        JDLIB::Thread m_thread;
        bool m_stop;

      public:

        // interptype :
        // 0 -> INTERP_NEAREST
        // 1 -> INTERP_BILINEAR
        // 3 -> INTERP_HYPER
        ImageAreaBase( const std::string& url, const int interptype );
        virtual ~ImageAreaBase();

        void stop();
        void wait();

        const std::string& get_url() const{ return m_url;}
        const std::string& get_errmsg() const{ return m_errmsg;}        

        const bool is_ready() const { return m_ready; }
        const bool is_loading(){ return m_thread.is_running(); }

        const int get_width() const { return m_width; }
        const int get_height() const { return m_height; }

        virtual void show_image() = 0;

        void set_fit_in_win( bool fit );

        virtual void load_image_thread();

      protected:

        JDLIB::ConstPtr< DBIMG::Img >& get_img(){ return  m_img; }
        void set_errmsg( const std::string& errmsg ){ m_errmsg = errmsg; }
        void set_ready( bool ready ){ m_ready = ready; }

        void set_width( const int width );
        void set_height( const int height );

        void load_image();

        bool create_imgloader( bool pixbufonly, std::string& errmsg );
        Glib::RefPtr< Gdk::PixbufLoader > get_imgloader(){ return m_imgloader; }

      private:

        virtual void callback_dispatch();
        virtual void set_image();
        void set_mosaic( Glib::RefPtr< Gdk::Pixbuf > pixbuf );
    };
}

#endif
