; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=ve -mattr=+vpu | FileCheck %s


; <256 x i32>

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_sgt_vv_v256i32(<256 x i32> %x, <256 x i32> %y) {
; CHECK-LABEL: icmp_sgt_vv_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vcmps.w.zx %v0, %v0, %v1
; CHECK-NEXT:    vfmk.w.gt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = icmp sgt <256 x i32> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_sgt_sv_v256i32(i32 %x, <256 x i32> %y) {
; CHECK-LABEL: icmp_sgt_sv_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmps.w.zx %v0, %v1, %v0
; CHECK-NEXT:    vfmk.w.gt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x i32> undef, i32 %x, i32 0
  %vx = shufflevector <256 x i32> %xins, <256 x i32> undef, <256 x i32> zeroinitializer
  %z = icmp sgt <256 x i32> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_sgt_vs_v256i32(<256 x i32> %x, i32 %y) {
; CHECK-LABEL: icmp_sgt_vs_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmps.w.zx %v0, %v0, %v1
; CHECK-NEXT:    vfmk.w.gt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x i32> undef, i32 %y, i32 0
  %vy = shufflevector <256 x i32> %yins, <256 x i32> undef, <256 x i32> zeroinitializer
  %z = icmp sgt <256 x i32> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_sge_vv_v256i32(<256 x i32> %x, <256 x i32> %y) {
; CHECK-LABEL: icmp_sge_vv_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vcmps.w.zx %v0, %v0, %v1
; CHECK-NEXT:    vfmk.w.ge %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = icmp sge <256 x i32> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_sge_sv_v256i32(i32 %x, <256 x i32> %y) {
; CHECK-LABEL: icmp_sge_sv_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmps.w.zx %v0, %v1, %v0
; CHECK-NEXT:    vfmk.w.ge %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x i32> undef, i32 %x, i32 0
  %vx = shufflevector <256 x i32> %xins, <256 x i32> undef, <256 x i32> zeroinitializer
  %z = icmp sge <256 x i32> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_sge_vs_v256i32(<256 x i32> %x, i32 %y) {
; CHECK-LABEL: icmp_sge_vs_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmps.w.zx %v0, %v0, %v1
; CHECK-NEXT:    vfmk.w.ge %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x i32> undef, i32 %y, i32 0
  %vy = shufflevector <256 x i32> %yins, <256 x i32> undef, <256 x i32> zeroinitializer
  %z = icmp sge <256 x i32> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_eq_vv_v256i32(<256 x i32> %x, <256 x i32> %y) {
; CHECK-LABEL: icmp_eq_vv_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vcmpu.w %v0, %v0, %v1
; CHECK-NEXT:    vfmk.w.eq %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = icmp eq <256 x i32> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_eq_sv_v256i32(i32 %x, <256 x i32> %y) {
; CHECK-LABEL: icmp_eq_sv_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.w %v0, %v1, %v0
; CHECK-NEXT:    vfmk.w.eq %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x i32> undef, i32 %x, i32 0
  %vx = shufflevector <256 x i32> %xins, <256 x i32> undef, <256 x i32> zeroinitializer
  %z = icmp eq <256 x i32> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_eq_vs_v256i32(<256 x i32> %x, i32 %y) {
; CHECK-LABEL: icmp_eq_vs_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.w %v0, %v0, %v1
; CHECK-NEXT:    vfmk.w.eq %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x i32> undef, i32 %y, i32 0
  %vy = shufflevector <256 x i32> %yins, <256 x i32> undef, <256 x i32> zeroinitializer
  %z = icmp eq <256 x i32> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ne_vv_v256i32(<256 x i32> %x, <256 x i32> %y) {
; CHECK-LABEL: icmp_ne_vv_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vcmpu.w %v0, %v0, %v1
; CHECK-NEXT:    vfmk.w.ne %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = icmp ne <256 x i32> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ne_sv_v256i32(i32 %x, <256 x i32> %y) {
; CHECK-LABEL: icmp_ne_sv_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.w %v0, %v1, %v0
; CHECK-NEXT:    vfmk.w.ne %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x i32> undef, i32 %x, i32 0
  %vx = shufflevector <256 x i32> %xins, <256 x i32> undef, <256 x i32> zeroinitializer
  %z = icmp ne <256 x i32> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ne_vs_v256i32(<256 x i32> %x, i32 %y) {
; CHECK-LABEL: icmp_ne_vs_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.w %v0, %v0, %v1
; CHECK-NEXT:    vfmk.w.ne %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x i32> undef, i32 %y, i32 0
  %vy = shufflevector <256 x i32> %yins, <256 x i32> undef, <256 x i32> zeroinitializer
  %z = icmp ne <256 x i32> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_sle_vv_v256i32(<256 x i32> %x, <256 x i32> %y) {
; CHECK-LABEL: icmp_sle_vv_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vcmps.w.zx %v0, %v0, %v1
; CHECK-NEXT:    vfmk.w.le %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = icmp sle <256 x i32> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_sle_sv_v256i32(i32 %x, <256 x i32> %y) {
; CHECK-LABEL: icmp_sle_sv_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmps.w.zx %v0, %v1, %v0
; CHECK-NEXT:    vfmk.w.le %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x i32> undef, i32 %x, i32 0
  %vx = shufflevector <256 x i32> %xins, <256 x i32> undef, <256 x i32> zeroinitializer
  %z = icmp sle <256 x i32> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_sle_vs_v256i32(<256 x i32> %x, i32 %y) {
; CHECK-LABEL: icmp_sle_vs_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmps.w.zx %v0, %v0, %v1
; CHECK-NEXT:    vfmk.w.le %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x i32> undef, i32 %y, i32 0
  %vy = shufflevector <256 x i32> %yins, <256 x i32> undef, <256 x i32> zeroinitializer
  %z = icmp sle <256 x i32> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_slt_vv_v256i32(<256 x i32> %x, <256 x i32> %y) {
; CHECK-LABEL: icmp_slt_vv_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vcmps.w.zx %v0, %v0, %v1
; CHECK-NEXT:    vfmk.w.lt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = icmp slt <256 x i32> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_slt_sv_v256i32(i32 %x, <256 x i32> %y) {
; CHECK-LABEL: icmp_slt_sv_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmps.w.zx %v0, %v1, %v0
; CHECK-NEXT:    vfmk.w.lt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x i32> undef, i32 %x, i32 0
  %vx = shufflevector <256 x i32> %xins, <256 x i32> undef, <256 x i32> zeroinitializer
  %z = icmp slt <256 x i32> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_slt_vs_v256i32(<256 x i32> %x, i32 %y) {
; CHECK-LABEL: icmp_slt_vs_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmps.w.zx %v0, %v0, %v1
; CHECK-NEXT:    vfmk.w.lt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x i32> undef, i32 %y, i32 0
  %vy = shufflevector <256 x i32> %yins, <256 x i32> undef, <256 x i32> zeroinitializer
  %z = icmp slt <256 x i32> %x, %vy
  ret <256 x i1> %z
}




; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ugt_vv_v256i32(<256 x i32> %x, <256 x i32> %y) {
; CHECK-LABEL: icmp_ugt_vv_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vcmpu.w %v0, %v0, %v1
; CHECK-NEXT:    vfmk.w.gt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = icmp ugt <256 x i32> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ugt_sv_v256i32(i32 %x, <256 x i32> %y) {
; CHECK-LABEL: icmp_ugt_sv_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.w %v0, %v1, %v0
; CHECK-NEXT:    vfmk.w.gt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x i32> undef, i32 %x, i32 0
  %vx = shufflevector <256 x i32> %xins, <256 x i32> undef, <256 x i32> zeroinitializer
  %z = icmp ugt <256 x i32> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ugt_vs_v256i32(<256 x i32> %x, i32 %y) {
; CHECK-LABEL: icmp_ugt_vs_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.w %v0, %v0, %v1
; CHECK-NEXT:    vfmk.w.gt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x i32> undef, i32 %y, i32 0
  %vy = shufflevector <256 x i32> %yins, <256 x i32> undef, <256 x i32> zeroinitializer
  %z = icmp ugt <256 x i32> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_uge_vv_v256i32(<256 x i32> %x, <256 x i32> %y) {
; CHECK-LABEL: icmp_uge_vv_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vcmpu.w %v0, %v0, %v1
; CHECK-NEXT:    vfmk.w.ge %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = icmp uge <256 x i32> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_uge_sv_v256i32(i32 %x, <256 x i32> %y) {
; CHECK-LABEL: icmp_uge_sv_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.w %v0, %v1, %v0
; CHECK-NEXT:    vfmk.w.ge %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x i32> undef, i32 %x, i32 0
  %vx = shufflevector <256 x i32> %xins, <256 x i32> undef, <256 x i32> zeroinitializer
  %z = icmp uge <256 x i32> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_uge_vs_v256i32(<256 x i32> %x, i32 %y) {
; CHECK-LABEL: icmp_uge_vs_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.w %v0, %v0, %v1
; CHECK-NEXT:    vfmk.w.ge %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x i32> undef, i32 %y, i32 0
  %vy = shufflevector <256 x i32> %yins, <256 x i32> undef, <256 x i32> zeroinitializer
  %z = icmp uge <256 x i32> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ule_vv_v256i32(<256 x i32> %x, <256 x i32> %y) {
; CHECK-LABEL: icmp_ule_vv_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vcmpu.w %v0, %v0, %v1
; CHECK-NEXT:    vfmk.w.le %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = icmp ule <256 x i32> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ule_sv_v256i32(i32 %x, <256 x i32> %y) {
; CHECK-LABEL: icmp_ule_sv_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.w %v0, %v1, %v0
; CHECK-NEXT:    vfmk.w.le %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x i32> undef, i32 %x, i32 0
  %vx = shufflevector <256 x i32> %xins, <256 x i32> undef, <256 x i32> zeroinitializer
  %z = icmp ule <256 x i32> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ule_vs_v256i32(<256 x i32> %x, i32 %y) {
; CHECK-LABEL: icmp_ule_vs_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.w %v0, %v0, %v1
; CHECK-NEXT:    vfmk.w.le %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x i32> undef, i32 %y, i32 0
  %vy = shufflevector <256 x i32> %yins, <256 x i32> undef, <256 x i32> zeroinitializer
  %z = icmp ule <256 x i32> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ult_vv_v256i32(<256 x i32> %x, <256 x i32> %y) {
; CHECK-LABEL: icmp_ult_vv_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vcmpu.w %v0, %v0, %v1
; CHECK-NEXT:    vfmk.w.lt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = icmp ult <256 x i32> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ult_sv_v256i32(i32 %x, <256 x i32> %y) {
; CHECK-LABEL: icmp_ult_sv_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.w %v0, %v1, %v0
; CHECK-NEXT:    vfmk.w.lt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x i32> undef, i32 %x, i32 0
  %vx = shufflevector <256 x i32> %xins, <256 x i32> undef, <256 x i32> zeroinitializer
  %z = icmp ult <256 x i32> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ult_vs_v256i32(<256 x i32> %x, i32 %y) {
; CHECK-LABEL: icmp_ult_vs_v256i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.w %v0, %v0, %v1
; CHECK-NEXT:    vfmk.w.lt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x i32> undef, i32 %y, i32 0
  %vy = shufflevector <256 x i32> %yins, <256 x i32> undef, <256 x i32> zeroinitializer
  %z = icmp ult <256 x i32> %x, %vy
  ret <256 x i1> %z
}



; <256 x i64>

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_sgt_vv_v256i64(<256 x i64> %x, <256 x i64> %y) {
; CHECK-LABEL: icmp_sgt_vv_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vcmps.l %v0, %v0, %v1
; CHECK-NEXT:    vfmk.l.gt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = icmp sgt <256 x i64> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_sgt_sv_v256i64(i64 %x, <256 x i64> %y) {
; CHECK-LABEL: icmp_sgt_sv_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmps.l %v0, %v1, %v0
; CHECK-NEXT:    vfmk.l.gt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x i64> undef, i64 %x, i32 0
  %vx = shufflevector <256 x i64> %xins, <256 x i64> undef, <256 x i32> zeroinitializer
  %z = icmp sgt <256 x i64> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_sgt_vs_v256i64(<256 x i64> %x, i64 %y) {
; CHECK-LABEL: icmp_sgt_vs_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmps.l %v0, %v0, %v1
; CHECK-NEXT:    vfmk.l.gt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x i64> undef, i64 %y, i32 0
  %vy = shufflevector <256 x i64> %yins, <256 x i64> undef, <256 x i32> zeroinitializer
  %z = icmp sgt <256 x i64> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_sge_vv_v256i64(<256 x i64> %x, <256 x i64> %y) {
; CHECK-LABEL: icmp_sge_vv_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vcmps.l %v0, %v0, %v1
; CHECK-NEXT:    vfmk.l.ge %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = icmp sge <256 x i64> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_sge_sv_v256i64(i64 %x, <256 x i64> %y) {
; CHECK-LABEL: icmp_sge_sv_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmps.l %v0, %v1, %v0
; CHECK-NEXT:    vfmk.l.ge %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x i64> undef, i64 %x, i32 0
  %vx = shufflevector <256 x i64> %xins, <256 x i64> undef, <256 x i32> zeroinitializer
  %z = icmp sge <256 x i64> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_sge_vs_v256i64(<256 x i64> %x, i64 %y) {
; CHECK-LABEL: icmp_sge_vs_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmps.l %v0, %v0, %v1
; CHECK-NEXT:    vfmk.l.ge %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x i64> undef, i64 %y, i32 0
  %vy = shufflevector <256 x i64> %yins, <256 x i64> undef, <256 x i32> zeroinitializer
  %z = icmp sge <256 x i64> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_eq_vv_v256i64(<256 x i64> %x, <256 x i64> %y) {
; CHECK-LABEL: icmp_eq_vv_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vcmpu.l %v0, %v0, %v1
; CHECK-NEXT:    vfmk.l.eq %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = icmp eq <256 x i64> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_eq_sv_v256i64(i64 %x, <256 x i64> %y) {
; CHECK-LABEL: icmp_eq_sv_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.l %v0, %v1, %v0
; CHECK-NEXT:    vfmk.l.eq %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x i64> undef, i64 %x, i32 0
  %vx = shufflevector <256 x i64> %xins, <256 x i64> undef, <256 x i32> zeroinitializer
  %z = icmp eq <256 x i64> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_eq_vs_v256i64(<256 x i64> %x, i64 %y) {
; CHECK-LABEL: icmp_eq_vs_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.l %v0, %v0, %v1
; CHECK-NEXT:    vfmk.l.eq %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x i64> undef, i64 %y, i32 0
  %vy = shufflevector <256 x i64> %yins, <256 x i64> undef, <256 x i32> zeroinitializer
  %z = icmp eq <256 x i64> %x, %vy
  ret <256 x i1> %z
}

define fastcc <256 x i1> @icmp_ne_vv_v256i64(<256 x i64> %x, <256 x i64> %y) {
; CHECK-LABEL: icmp_ne_vv_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vcmpu.l %v0, %v0, %v1
; CHECK-NEXT:    vfmk.l.ne %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = icmp ne <256 x i64> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ne_sv_v256i64(i64 %x, <256 x i64> %y) {
; CHECK-LABEL: icmp_ne_sv_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.l %v0, %v1, %v0
; CHECK-NEXT:    vfmk.l.ne %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x i64> undef, i64 %x, i32 0
  %vx = shufflevector <256 x i64> %xins, <256 x i64> undef, <256 x i32> zeroinitializer
  %z = icmp ne <256 x i64> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ne_vs_v256i64(<256 x i64> %x, i64 %y) {
; CHECK-LABEL: icmp_ne_vs_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.l %v0, %v0, %v1
; CHECK-NEXT:    vfmk.l.ne %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x i64> undef, i64 %y, i32 0
  %vy = shufflevector <256 x i64> %yins, <256 x i64> undef, <256 x i32> zeroinitializer
  %z = icmp ne <256 x i64> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_sle_vv_v256i64(<256 x i64> %x, <256 x i64> %y) {
; CHECK-LABEL: icmp_sle_vv_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vcmps.l %v0, %v0, %v1
; CHECK-NEXT:    vfmk.l.le %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = icmp sle <256 x i64> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_sle_sv_v256i64(i64 %x, <256 x i64> %y) {
; CHECK-LABEL: icmp_sle_sv_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmps.l %v0, %v1, %v0
; CHECK-NEXT:    vfmk.l.le %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x i64> undef, i64 %x, i32 0
  %vx = shufflevector <256 x i64> %xins, <256 x i64> undef, <256 x i32> zeroinitializer
  %z = icmp sle <256 x i64> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_sle_vs_v256i64(<256 x i64> %x, i64 %y) {
; CHECK-LABEL: icmp_sle_vs_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmps.l %v0, %v0, %v1
; CHECK-NEXT:    vfmk.l.le %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x i64> undef, i64 %y, i32 0
  %vy = shufflevector <256 x i64> %yins, <256 x i64> undef, <256 x i32> zeroinitializer
  %z = icmp sle <256 x i64> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_slt_vv_v256i64(<256 x i64> %x, <256 x i64> %y) {
; CHECK-LABEL: icmp_slt_vv_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vcmps.l %v0, %v0, %v1
; CHECK-NEXT:    vfmk.l.lt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = icmp slt <256 x i64> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_slt_sv_v256i64(i64 %x, <256 x i64> %y) {
; CHECK-LABEL: icmp_slt_sv_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmps.l %v0, %v1, %v0
; CHECK-NEXT:    vfmk.l.lt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x i64> undef, i64 %x, i32 0
  %vx = shufflevector <256 x i64> %xins, <256 x i64> undef, <256 x i32> zeroinitializer
  %z = icmp slt <256 x i64> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_slt_vs_v256i64(<256 x i64> %x, i64 %y) {
; CHECK-LABEL: icmp_slt_vs_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmps.l %v0, %v0, %v1
; CHECK-NEXT:    vfmk.l.lt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x i64> undef, i64 %y, i32 0
  %vy = shufflevector <256 x i64> %yins, <256 x i64> undef, <256 x i32> zeroinitializer
  %z = icmp slt <256 x i64> %x, %vy
  ret <256 x i1> %z
}




; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ugt_vv_v256i64(<256 x i64> %x, <256 x i64> %y) {
; CHECK-LABEL: icmp_ugt_vv_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vcmpu.l %v0, %v0, %v1
; CHECK-NEXT:    vfmk.l.gt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = icmp ugt <256 x i64> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ugt_sv_v256i64(i64 %x, <256 x i64> %y) {
; CHECK-LABEL: icmp_ugt_sv_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.l %v0, %v1, %v0
; CHECK-NEXT:    vfmk.l.gt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x i64> undef, i64 %x, i32 0
  %vx = shufflevector <256 x i64> %xins, <256 x i64> undef, <256 x i32> zeroinitializer
  %z = icmp ugt <256 x i64> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ugt_vs_v256i64(<256 x i64> %x, i64 %y) {
; CHECK-LABEL: icmp_ugt_vs_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.l %v0, %v0, %v1
; CHECK-NEXT:    vfmk.l.gt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x i64> undef, i64 %y, i32 0
  %vy = shufflevector <256 x i64> %yins, <256 x i64> undef, <256 x i32> zeroinitializer
  %z = icmp ugt <256 x i64> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_uge_vv_v256i64(<256 x i64> %x, <256 x i64> %y) {
; CHECK-LABEL: icmp_uge_vv_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vcmpu.l %v0, %v0, %v1
; CHECK-NEXT:    vfmk.l.ge %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = icmp uge <256 x i64> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_uge_sv_v256i64(i64 %x, <256 x i64> %y) {
; CHECK-LABEL: icmp_uge_sv_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.l %v0, %v1, %v0
; CHECK-NEXT:    vfmk.l.ge %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x i64> undef, i64 %x, i32 0
  %vx = shufflevector <256 x i64> %xins, <256 x i64> undef, <256 x i32> zeroinitializer
  %z = icmp uge <256 x i64> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_uge_vs_v256i64(<256 x i64> %x, i64 %y) {
; CHECK-LABEL: icmp_uge_vs_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.l %v0, %v0, %v1
; CHECK-NEXT:    vfmk.l.ge %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x i64> undef, i64 %y, i32 0
  %vy = shufflevector <256 x i64> %yins, <256 x i64> undef, <256 x i32> zeroinitializer
  %z = icmp uge <256 x i64> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ule_vv_v256i64(<256 x i64> %x, <256 x i64> %y) {
; CHECK-LABEL: icmp_ule_vv_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vcmpu.l %v0, %v0, %v1
; CHECK-NEXT:    vfmk.l.le %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = icmp ule <256 x i64> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ule_sv_v256i64(i64 %x, <256 x i64> %y) {
; CHECK-LABEL: icmp_ule_sv_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.l %v0, %v1, %v0
; CHECK-NEXT:    vfmk.l.le %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x i64> undef, i64 %x, i32 0
  %vx = shufflevector <256 x i64> %xins, <256 x i64> undef, <256 x i32> zeroinitializer
  %z = icmp ule <256 x i64> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ule_vs_v256i64(<256 x i64> %x, i64 %y) {
; CHECK-LABEL: icmp_ule_vs_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.l %v0, %v0, %v1
; CHECK-NEXT:    vfmk.l.le %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x i64> undef, i64 %y, i32 0
  %vy = shufflevector <256 x i64> %yins, <256 x i64> undef, <256 x i32> zeroinitializer
  %z = icmp ule <256 x i64> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ult_vv_v256i64(<256 x i64> %x, <256 x i64> %y) {
; CHECK-LABEL: icmp_ult_vv_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vcmpu.l %v0, %v0, %v1
; CHECK-NEXT:    vfmk.l.lt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = icmp ult <256 x i64> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ult_sv_v256i64(i64 %x, <256 x i64> %y) {
; CHECK-LABEL: icmp_ult_sv_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.l %v0, %v1, %v0
; CHECK-NEXT:    vfmk.l.lt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x i64> undef, i64 %x, i32 0
  %vx = shufflevector <256 x i64> %xins, <256 x i64> undef, <256 x i32> zeroinitializer
  %z = icmp ult <256 x i64> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @icmp_ult_vs_v256i64(<256 x i64> %x, i64 %y) {
; CHECK-LABEL: icmp_ult_vs_v256i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vcmpu.l %v0, %v0, %v1
; CHECK-NEXT:    vfmk.l.lt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x i64> undef, i64 %y, i32 0
  %vy = shufflevector <256 x i64> %yins, <256 x i64> undef, <256 x i32> zeroinitializer
  %z = icmp ult <256 x i64> %x, %vy
  ret <256 x i1> %z
}
