/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.pilotlink;

import org.gnu.pilotlink.Record;

public abstract class AppInfo {
    protected byte[] buffer;
    protected String[] categories = new String[16];
    protected boolean[] isCatRenamed = new boolean[16];
    protected int catCount = 0;
    protected int dataOffset = 0;
    protected int bits;
    protected long[] id;
    protected int lastUniqueID;

    public AppInfo() {
        this.buffer = new byte[65535];
    }

    public AppInfo(AppInfo appInfo) {
        this.setBuffer(appInfo.getBuffer());
    }

    public abstract void setBuffer(byte[] var1);

    public void parseCategories() {
        int n;
        this.bits = this.buffer[0] * 256 + this.buffer[1];
        this.id = new long[4];
        this.catCount = 0;
        for (n = 0; n < 16; ++n) {
            if (this.buffer[2 + n * 16] != 0) {
                this.categories[n] = AppInfo.getStringAt(this.buffer, 2 + n * 16);
                ++this.catCount;
            } else {
                this.categories[n] = null;
            }
            this.isCatRenamed[n] = (this.bits & 1 << n) != 0;
        }
        this.dataOffset = 258;
        for (n = 0; n < 4; ++n) {
            this.id[n] = Record.getLongAt(this.buffer, this.dataOffset);
            this.dataOffset += 4;
        }
        this.lastUniqueID = this.buffer[this.dataOffset];
        this.dataOffset += 4;
    }

    public void createDefaultBuffer() {
        int n;
        for (n = 0; n < this.buffer.length; ++n) {
            this.buffer[n] = 0;
        }
        this.bits = 0;
        for (n = 0; n < 16; ++n) {
            if (this.isCatRenamed[n]) {
                this.bits |= 1 << n;
            }
            if (this.categories[n] == null) continue;
            for (int i = 0; i < 16 && i < this.categories[n].length(); ++i) {
                char c = this.categories[n].charAt(i);
                this.buffer[2 + n * 16 + i] = (byte)c;
            }
        }
        this.buffer[0] = (byte)(this.bits >> 256);
        this.buffer[1] = (byte)(this.bits & 0x100);
    }

    public abstract byte[] getBuffer();

    public boolean isCatRenamed(int n) {
        return this.isCatRenamed[n];
    }

    public void setCatRenamed(int n, boolean bl) {
        this.isCatRenamed[n] = bl;
    }

    public String getCatName(int n) {
        return this.categories[n];
    }

    public void setCatName(int n, String string) {
        if (string.length() > 16) {
            string = string.substring(0, 16);
        }
        this.categories[n] = string;
    }

    public static String getStringAt(byte[] byArray, int n) {
        String string = "";
        while (n < byArray.length && string.length() < 16 && byArray[n] != 0) {
            string = string + (char)byArray[n];
            ++n;
        }
        return string;
    }

    public int getCatCount() {
        return this.catCount;
    }

    public String toString() {
        String string = "Kategories";
        for (int i = 0; i < 16; ++i) {
            string = string + " " + this.categories[i];
            if (!this.isCatRenamed(i)) continue;
            string = string + "(ren)";
        }
        return string;
    }
}

