.\" Automatically generated from an mdoc input file.  Do not edit.
.\" zip_dir_add.mdoc -- add directory to zip archive
.\" Copyright (C) 2006-2020 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <info@libzip.org>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIP_DIR_ADD" "3" "September 20, 2020" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_dir_add\fR
\- add directory to zip archive
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIzip_int64_t\fR
.br
.PD 0
.HP 4n
\fBzip_dir_add\fR(\fIzip_t\ *archive\fR, \fIconst\ char\ *name\fR, \fIzip_flags_t\ flags\fR);
.PD
.SH "DESCRIPTION"
The function
\fBzip_dir_add\fR()
adds a directory to a zip archive.
The argument
\fIarchive\fR
specifies the zip archive to which the directory should be added.
\fIname\fR
is the directory's name in the zip archive.
.PP
This function adds an entry to the archive.
It does not check whether a directory with that name exists in the
file system, nor does it add its contents if it does.
The
\fIflags\fR
argument can be any of:
.TP 22n
\fRZIP_FL_ENC_GUESS\fR
Guess encoding of
\fIname\fR
(default).
(Only CP-437 and UTF-8 are recognized.)
.TP 22n
\fRZIP_FL_ENC_UTF_8\fR
Interpret
\fIname\fR
as UTF-8.
.TP 22n
\fRZIP_FL_ENC_CP437\fR
Interpret
\fIname\fR
as code page 437 (CP-437).
.SH "RETURN VALUES"
Upon successful completion, the index of the new entry in the archive
is returned.
Otherwise, \-1 is returned and the error code in
\fIarchive\fR
is set to indicate the error.
.SH "ERRORS"
\fBzip_dir_add\fR()
fails if:
.TP 19n
[\fRZIP_ER_EXISTS\fR]
There is already an entry called
\fIname\fR
in the archive.
.TP 19n
[\fRZIP_ER_INVAL\fR]
\fIarchive\fR
or
\fIname\fR
are
\fRNULL\fR,
or invalid UTF-8 encoded file names.
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.SH "SEE ALSO"
libzip(3),
zip_file_add(3)
.SH "HISTORY"
\fBzip_dir_add\fR()
was added in libzip 0.11.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
