---
title: Users
...

# List of projects using Meson

If you have a project that uses Meson that you want to add to this
list, please [file a
pull-request](https://github.com/mesonbuild/meson/edit/master/docs/markdown/Users.md)
for it. All the software on this list is tested for regressions before
release, so it's highly recommended that projects add themselves
here. Some additional projects are listed in the [`meson` GitHub
topic](https://github.com/topics/meson).

 - [2048.cpp](https://github.com/plibither8/2048.cpp), a fully featured terminal version of the game "2048" written in C++
 - [aawordsearch](https://github.com/theimpossibleastronaut/aawordsearch), generate wordsearch puzzles using random words in different languages
 - [Adwaita Manager](https://github.com/AdwCustomizerTeam/AdwCustomizer), change the look of Adwaita, with ease
 - [Aravis](https://github.com/AravisProject/aravis), a glib/gobject based library for video acquisition using Genicam cameras
 - [Akira](https://github.com/akiraux/Akira), a native Linux app for UI and UX design built in Vala and Gtk
 - [AQEMU](https://github.com/tobimensch/aqemu), a Qt GUI for QEMU virtual machines, since version 0.9.3
 - [Arduino sample project](https://github.com/jpakkane/mesonarduino)
 - [Asteria](https://github.com/lhmouse/asteria), another scripting language
 - [Audacious](https://github.com/audacious-media-player), a lightweight and versatile audio player
 - [bolt](https://gitlab.freedesktop.org/bolt/bolt), userspace daemon to enable security levels for Thunderbolt™ 3 on Linux
 - [bsdutils](https://github.com/dcantrell/bsdutils), alternative to GNU coreutils using software from FreeBSD
 - [Bubblewrap](https://github.com/containers/bubblewrap), unprivileged sandboxing tool
 - [Budgie Desktop](https://github.com/budgie-desktop/budgie-desktop), a desktop environment built on GNOME technologies
 - [Bzip2](https://gitlab.com/federicomenaquintero/bzip2), the bzip2 compressor/decompressor
 - [Cage](https://github.com/Hjdskes/cage), a Wayland kiosk
 - [canfigger](https://github.com/andy5995/canfigger), simple configuration file parser library
 - [casync](https://github.com/systemd/casync), Content-Addressable Data Synchronization Tool
 - [cglm](https://github.com/recp/cglm), a highly optimized graphics math library for C
 - [cinnamon-desktop](https://github.com/linuxmint/cinnamon-desktop), the cinnamon desktop library
 - [Cozy](https://github.com/geigi/cozy), a modern audio book player for Linux and macOS using GTK+ 3
 - [Criterion](https://github.com/Snaipe/Criterion), extensible cross-platform C and C++ unit testing framework
 - [dav1d](https://code.videolan.org/videolan/dav1d), an AV1 decoder
 - [dbus-broker](https://github.com/bus1/dbus-broker), Linux D-Bus Message Broker
 - [DOSBox Staging](https://github.com/dosbox-staging/dosbox-staging), DOS/x86 emulator
 - [DPDK](http://dpdk.org/browse/dpdk), Data Plane Development Kit, a set of libraries and drivers for fast packet processing
 - [DXVK](https://github.com/doitsujin/dxvk), a Vulkan-based Direct3D 11 implementation for Linux using Wine
 - [EFL](https://www.enlightenment.org/about-efl), multiplatform set of libraries, used by the Enlightenment windows manager and other projects
 - [Enlightenment](https://www.enlightenment.org/), windows manager, compositor and minimal desktop for Linux
 - [elementary OS](https://github.com/elementary/), Linux desktop oriented distribution
 - [Emeus](https://github.com/ebassi/emeus), constraint based layout manager for GTK+
 - [Entangle](https://entangle-photo.org/), tethered camera control and capture desktop application
 - [ESP8266 Arduino sample project](https://github.com/trilader/arduino-esp8266-meson), sample project for using the ESP8266 Arduino port with Meson
 - [FeedReader](https://github.com/jangernert/FeedReader), a modern desktop application designed to complement existing web-based RSS accounts
 - [Flecs](https://github.com/SanderMertens/flecs), a Fast and Lightweight ECS (Entity Component System) C library
 - [Foliate](https://github.com/johnfactotum/foliate), a simple and modern GTK eBook reader, built with GJS and Epub.js
 - [Fractal](https://wiki.gnome.org/Apps/Fractal/), a Matrix messaging client for GNOME
 - [Frida](https://github.com/frida/frida-core), a dynamic binary instrumentation toolkit
 - [fwupd](https://github.com/hughsie/fwupd), a simple daemon to allow session software to update firmware
 - [GameMode](https://github.com/FeralInteractive/gamemode), a daemon/lib combo for Linux that allows games to request a set of optimisations be temporarily applied to the host OS
 - [Geary](https://wiki.gnome.org/Apps/Geary), an email application built around conversations, for the GNOME 3 desktop.
 - [GIMP](https://gitlab.gnome.org/GNOME/gimp), an image manipulation program (experimental replacing autoconf)
 - [GLib](https://gitlab.gnome.org/GNOME/glib), cross-platform C library used by GTK+ and GStreamer
 - [Glorytun](https://github.com/angt/glorytun), a multipath UDP tunnel
 - [GNOME Boxes](https://gitlab.gnome.org/GNOME/gnome-boxes), a GNOME hypervisor
 - [GNOME Builder](https://gitlab.gnome.org/GNOME/gnome-builder), an IDE for the GNOME platform
 - [GNOME MPV](https://github.com/gnome-mpv/gnome-mpv), GNOME frontend to the mpv video player
 - [GNOME Recipes](https://gitlab.gnome.org/GNOME/recipes), application for cooking recipes
 - [GNOME Software](https://gitlab.gnome.org/GNOME/gnome-software), an app store for GNOME
 - [GNOME Twitch](https://github.com/vinszent/gnome-twitch), an app for viewing Twitch streams on GNOME desktop
 - [GNOME Usage](https://gitlab.gnome.org/GNOME/gnome-usage), a GNOME application for visualizing system resources
 - [GNU FriBidi](https://github.com/fribidi/fribidi), the open source implementation of the Unicode Bidirectional Algorithm
 - [Graphene](https://ebassi.github.io/graphene/), a thin type library for graphics
 - [Grilo](https://git.gnome.org/browse/grilo) and [Grilo plugins](https://git.gnome.org/browse/grilo-plugins), the Grilo multimedia framework
 - [GStreamer](https://gitlab.freedesktop.org/gstreamer/gstreamer), multimedia framework
 - [GTK+](https://gitlab.gnome.org/GNOME/gtk), the multi-platform toolkit used by GNOME
 - [GtkDApp](https://gitlab.com/csoriano/GtkDApp), an application template for developing Flatpak apps with Gtk+ and D
 - [GVfs](https://git.gnome.org/browse/gvfs/), a userspace virtual filesystem designed to work with the I/O abstraction of GIO
 - [Hardcode-Tray](https://github.com/bil-elmoussaoui/Hardcode-Tray), fixes hardcoded tray icons in Linux
 - [HarfBuzz](https://github.com/harfbuzz/harfbuzz), a text shaping engine
 - [HelenOS](http://helenos.org), a portable microkernel-based multiserver operating system
 - [HexChat](https://github.com/hexchat/hexchat), a cross-platform IRC client in C
 - [IGT](https://gitlab.freedesktop.org/drm/igt-gpu-tools), Linux kernel graphics driver test suite
 - [i3](https://i3wm.org), improved tiling window manager
 - [inih](https://github.com/benhoyt/inih) (INI Not Invented Here), a small and simple .INI file parser written in C
 - [Irssi](https://github.com/irssi/irssi), a terminal chat client in C
 - [iSH](https://github.com/tbodt/ish), Linux shell for iOS
 - [Janet](https://github.com/janet-lang/janet), a functional and imperative programming language and bytecode interpreter
 - [json](https://github.com/nlohmann/json), JSON for Modern C++
 - [JsonCpp](https://github.com/open-source-parsers/jsoncpp), a C++ library for interacting with JSON
 - [Json-glib](https://gitlab.gnome.org/GNOME/json-glib), GLib-based JSON manipulation library
 - [Kiwix libraries](https://github.com/kiwix/kiwix-lib)
 - [Knot Resolver](https://gitlab.labs.nic.cz/knot/knot-resolver), Full caching DNS resolver implementation
 - [Ksh](https://github.com/att/ast), a Korn Shell
 - [Lc0](https://github.com/LeelaChessZero/lc0), LeelaChessZero is a UCI-compliant chess engine designed to play chess via neural network
 - [Le](https://github.com/kirushyk/le), machine learning framework
 - [libcamera](https://git.linuxtv.org/libcamera.git/), a library to handle complex cameras on Linux, ChromeOS and Android
 - [Libdrm](https://gitlab.freedesktop.org/mesa/drm), a library for abstracting DRM kernel interfaces
 - [libdwarf](https://www.prevanders.net/dwarf.html), a multiplatform DWARF parser library
 - [libeconf](https://github.com/openSUSE/libeconf), Enhanced config file parsing library, which merges config files placed in several locations into one
 - [Libepoxy](https://github.com/anholt/libepoxy/), a library for handling OpenGL function pointer management
 - [libfuse](https://github.com/libfuse/libfuse), the reference implementation of the Linux FUSE (Filesystem in Userspace) interface
 - [Libgit2-glib](https://git.gnome.org/browse/libgit2-glib), a GLib wrapper for libgit2
 - [libglvnd](https://gitlab.freedesktop.org/glvnd/libglvnd), Vendor neutral OpenGL dispatch library for Unix-like OSes
 - [Libhttpseverywhere](https://git.gnome.org/browse/libhttpseverywhere), a library to enable httpseverywhere on any desktop app
 - [libmodulemd](https://github.com/fedora-modularity/libmodulemd), a GObject Introspected library for managing [Fedora Project](https://getfedora.org/) module metadata.
 - [Libosmscout](https://github.com/Framstag/libosmscout), a C++ library for offline map rendering, routing and location
lookup based on OpenStreetMap data
 - [libratbag](https://github.com/libratbag/libratbag), provides a DBus daemon to configure input devices, mainly gaming mice.
 - [libspng](https://github.com/randy408/libspng), a C library for reading and writing Portable Network Graphics (PNG)
format files
 - [libSRTP](https://github.com/cisco/libsrtp) (from Cisco Systems), a library for SRTP (Secure Realtime Transport Protocol)
 - [libui](https://github.com/andlabs/libui), a simple and portable (but not inflexible) GUI library in C that uses the native GUI technologies of each platform it supports
 - [Libva](https://github.com/intel/libva), an implementation for the VA (VIdeo Acceleration) API
 - [libvips](https://github.com/libvips/libvips), a fast image processing library with low memory needs
 - [Libvirt](https://libvirt.org), a toolkit to manage virtualization platforms
 - [Libzim](https://github.com/openzim/libzim), the reference implementation for the ZIM file format
 - [LXC](https://github.com/lxc/lxc), Linux container runtime
 - [Marker](https://github.com/fabiocolacio/Marker), a GTK-3 markdown editor
 - [mcfgthread](https://github.com/lhmouse/mcfgthread), cornerstone library for C++11 threading on mingw-w64
 - [Mesa](https://mesa3d.org/), an open source graphics driver project
 - [Miniz](https://github.com/richgel999/miniz), a zlib replacement library
 - [MiracleCast](https://github.com/albfan/miraclecast), connect external monitors to your system via WiFi-Display specification aka Miracast
 - [mpv](https://github.com/mpv-player/mpv), a free, open source, and cross-platform media player
 - [mrsh](https://github.com/emersion/mrsh), a minimal POSIX shell
 - [Nautilus](https://gitlab.gnome.org/GNOME/nautilus), the GNOME file manager
 - [Nemo](https://github.com/linuxmint/nemo), the file manager for the Cinnamon desktop environment
 - [NetPanzer](https://github.com/netpanzer/netpanzer), a 2D online multiplayer tactical warfare game designed for fast action combat
 - [nvme-cli](https://github.com/linux-nvme/nvme-cli), NVMe management command line interface
 - [OcherBook](https://github.com/ccoffing/OcherBook), an open source book reader for Kobo devices
 - [oomd](https://github.com/facebookincubator/oomd), a userspace Out-Of-Memory (OOM) killer for Linux systems
 - [OpenH264](https://github.com/cisco/openh264), open source H.264 codec
 - [OpenHMD](https://github.com/OpenHMD/OpenHMD), a free and open source API and drivers for immersive technology, such as head mounted displays with built in head tracking
 - [OpenRC](https://github.com/OpenRC/openrc), an init system for Unix-like operating systems
 - [OpenTitan](https://github.com/lowRISC/opentitan), an open source silicon Root of Trust (RoT) project.
 - [Orc](https://gitlab.freedesktop.org/gstreamer/orc), the Optimized Inner Loop Runtime Compiler
 - [OTS](https://github.com/khaledhosny/ots), the OpenType Sanitizer, parses and serializes OpenType files (OTF, TTF) and WOFF and WOFF2 font files, validating and sanitizing them as it goes. Used by Chromium and Firefox
 - [Outlier](https://github.com/kerolasa/outlier), a small Hello World style Meson example project
 - [p11-kit](https://github.com/p11-glue/p11-kit), PKCS#11 module aggregator
 - [Pacman](https://gitlab.archlinux.org/pacman/pacman.git), a package manager for Arch Linux
 - [Pango](https://git.gnome.org/browse/pango/), an Internationalized text layout and rendering library
 - [Parzip](https://github.com/jpakkane/parzip), a multithreaded reimplementation of Zip
 - [Peek](https://github.com/phw/peek), simple animated GIF screen recorder with an easy to use interface
 - [PicoLibc](https://github.com/keith-packard/picolibc), a standard C library for small embedded systems with limited RAM
 - [PipeWire](https://github.com/PipeWire/pipewire), a framework for video and audio for containerized applications
 - [Paper Rock Scissors](https://github.com/michaelbrockus/paper_rock_scissors), a game with weapons themed at home paper rock scissors style.
 - [Pistache](https://github.com/pistacheio/pistache), a high performance REST toolkit written in C++
 - [Pithos](https://github.com/pithos/pithos), a Pandora Radio client
 - [Pitivi](https://github.com/pitivi/pitivi/), a nonlinear video editor
 - [Planner](https://github.com/alainm23/planner), task manager with Todoist support designed for GNU/Linux
 - [Playerctl](https://github.com/acrisci/playerctl), mpris command-line controller and library for spotify, vlc, audacious, bmp, cmus, and others
 - [Polari](https://gitlab.gnome.org/GNOME/polari), an IRC client
 - [PostgreSQL](https://www.postgresql.org/), an advanced open source relational database
 - [qboot](https://github.com/bonzini/qboot), a minimal x86 firmware for booting Linux kernels
 - [QEMU](https://qemu.org), a processor emulator and virtualizer
 - [radare2](https://github.com/radare/radare2), unix-like reverse engineering framework and commandline tools (not the default)
 - [refivar](https://github.com/nvinson/refivar), A reimplementation of efivar in Rust.
 - [Rizin](https://rizin.re), Free and Open Source Reverse Engineering Framework
 - [rmw](https://remove-to-waste.info), safe-remove utility for the command line
 - [RxDock](https://gitlab.com/rxdock/rxdock), a protein-ligand docking software designed for high throughput virtual screening (fork of rDock)
 - [SciPy](https://scipy.org/), an open-source software for mathematics, science, and engineering
 - [scrcpy](https://github.com/Genymobile/scrcpy), a cross platform application that provides display and control of Android devices connected on USB or over TCP/IP
 - [Sequeler](https://github.com/Alecaddd/sequeler), a friendly SQL client for Linux, built with Vala and Gtk
 - [Siril](https://gitlab.com/free-astro/siril), an image processing software for amateur astronomy
 - [slapt-get](https://github.com/jaos/slapt-get), an APT like system for Slackware package management
 - [Spot](https://github.com/xou816/spot), Rust based Spotify client for the GNOME desktop
 - [SSHFS](https://github.com/libfuse/sshfs), allows you to mount a remote filesystem using SFTP
 - [sway](https://github.com/swaywm/sway), i3-compatible Wayland compositor
 - [Sysprof](https://git.gnome.org/browse/sysprof), a profiling tool
 - [systemd](https://github.com/systemd/systemd), the init system
 - [szl](https://github.com/dimkr/szl), a lightweight, embeddable scripting language
 - [Taisei Project](https://taisei-project.org/), an open-source Touhou Project clone and fangame
 - [Terminology](https://github.com/billiob/terminology), a terminal emulator based on the Enlightenment Foundation Libraries
 - [ThorVG](https://www.thorvg.org/), vector-based scenes and animations library
 - [Tilix](https://github.com/gnunn1/tilix), a tiling terminal emulator for Linux using GTK+ 3
 - [Tizonia](https://github.com/tizonia/tizonia-openmax-il), a command-line cloud music player for Linux with support for Spotify, Google Play Music, YouTube, SoundCloud, TuneIn, Plex servers and Chromecast devices
 - [TSCL Xtest](https://github.com/trilobite-stdlib/tscl-xtest-c), a framework for testing C/C++ code
 - [TSCL Xmock](https://github.com/trilobite-stdlib/tscl-xtest-c), a framework for mocking C/C++ code
 - [TSCL Xmemory](https://github.com/trilobite-stdlib/tscl-xmemory-c), a library for low-level, memory and bitwise operations in C
 - [TSCL Xscience](https://github.com/trilobite-stdlib/tscl-xscience-c), a library for scientific calculations in C
 - [TSCL Xstring](https://github.com/trilobite-stdlib/tscl-xstring-c), a library for working with strings and ciphers in C
 - [TSCL Xdata](https://github.com/trilobite-stdlib/tscl-xdata-c), a library with data structures and algorithms in C
 - [TSCL Xutil](https://github.com/trilobite-stdlib/tscl-xutil-c), a library with utilities for the most tedious task in C
 - [TSCL Xmath](https://github.com/trilobite-stdlib/tscl-xmath-c), a library with mathematical components for projects in C
 - [TSCL Xcore](https://github.com/trilobite-stdlib/tscl-xcore-c), a core framework with essentials for any projects in C
 - [UFJF-MLTK](https://github.com/mateus558/UFJF-Machine-Learning-Toolkit), A C++ cross-platform framework for machine learning algorithms development and testing
 - [Vala Language Server](https://github.com/benwaffle/vala-language-server), code intelligence engine for the Vala and Genie programming languages
 - [Valum](https://github.com/valum-framework/valum), a micro web framework written in Vala
 - [Venom](https://github.com/naxuroqa/Venom), a modern Tox client for the GNU/Linux desktop
 - [vkQuake](https://github.com/Novum/vkQuake), a port of id Software's Quake using Vulkan instead of OpenGL for rendering
 - [VMAF](https://github.com/Netflix/vmaf) (by Netflix), a perceptual video quality assessment based on multi-method fusion
 - [Wayland](https://gitlab.freedesktop.org/wayland/wayland) and [Weston](https://gitlab.freedesktop.org/wayland/weston), a next generation display server
 - [wlroots](https://gitlab.freedesktop.org/wlroots/wlroots), a modular Wayland compositor library
 - [xi-gtk](https://github.com/eyelash/xi-gtk), a GTK+ front-end for the Xi editor
 - [Xorg](https://gitlab.freedesktop.org/xorg/xserver), the X.org display server (not the default yet)
 - [X Test Suite](https://gitlab.freedesktop.org/xorg/test/xts), The X.org test suite
 - [zathura](https://github.com/pwmt/zathura), a highly customizable and functional document viewer based on the
girara user interface library and several document libraries
 - [Zrythm](https://git.sr.ht/~alextee/zrythm), a cross-platform digital audio workstation written in C using GTK4
 - [ZStandard](https://github.com/facebook/zstd/commit/4dca56ed832c6a88108a2484a8f8ff63d8d76d91), a compression algorithm developed at Facebook (not used by default)

Note that a more up-to-date list of GNOME projects that use Meson can
be found
[here](https://wiki.gnome.org/Initiatives/GnomeGoals/MesonPorting).
