; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -instcombine-infinite-loop-threshold=3 -S | FileCheck %s

@var_7 = external global i8, align 1
@var_1 = external global i32, align 4
@var_0 = external global i16, align 2
@var_5 = external global i64, align 8
@arr_2 = external global [0 x i32], align 4
@arr_4 = external global [0 x i16], align 2
@arr_3 = external global [8 x i32], align 16

define void @_Z4testv() {
; CHECK-LABEL: @_Z4testv(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I:%.*]] = load i8, ptr @var_7, align 1
; CHECK-NEXT:    [[I1:%.*]] = icmp eq i8 [[I]], -1
; CHECK-NEXT:    [[I4:%.*]] = load i16, ptr @var_0, align 2
; CHECK-NEXT:    br i1 [[I1]], label [[BB10:%.*]], label [[BB9:%.*]]
; CHECK:       bb9:
; CHECK-NEXT:    br label [[BB12:%.*]]
; CHECK:       bb10:
; CHECK-NEXT:    [[I2:%.*]] = load i32, ptr @var_1, align 4
; CHECK-NEXT:    [[I3:%.*]] = icmp eq i32 [[I2]], 0
; CHECK-NEXT:    [[I6:%.*]] = load i64, ptr @var_5, align 8
; CHECK-NEXT:    [[I5:%.*]] = sext i16 [[I4]] to i64
; CHECK-NEXT:    [[I7:%.*]] = select i1 [[I3]], i64 [[I6]], i64 [[I5]]
; CHECK-NEXT:    [[I11:%.*]] = trunc i64 [[I7]] to i32
; CHECK-NEXT:    br label [[BB12]]
; CHECK:       bb12:
; CHECK-NEXT:    [[STOREMERGE1:%.*]] = phi i32 [ [[I11]], [[BB10]] ], [ 1, [[BB9]] ]
; CHECK-NEXT:    store i32 [[STOREMERGE1]], ptr @arr_2, align 4
; CHECK-NEXT:    store i16 [[I4]], ptr @arr_4, align 2
; CHECK-NEXT:    [[I8:%.*]] = sext i16 [[I4]] to i32
; CHECK-NEXT:    store i32 [[I8]], ptr @arr_3, align 16
; CHECK-NEXT:    store i32 [[STOREMERGE1]], ptr getelementptr inbounds ([0 x i32], ptr @arr_2, i64 0, i64 1), align 4
; CHECK-NEXT:    store i16 [[I4]], ptr getelementptr inbounds ([0 x i16], ptr @arr_4, i64 0, i64 1), align 2
; CHECK-NEXT:    store i32 [[I8]], ptr getelementptr inbounds ([8 x i32], ptr @arr_3, i64 0, i64 1), align 4
; CHECK-NEXT:    ret void
;
bb:
  %i = load i8, ptr @var_7, align 1
  %i1 = icmp eq i8 %i, -1
  %i2 = load i32, ptr @var_1, align 4
  %i3 = icmp eq i32 %i2, 0
  %i4 = load i16, ptr @var_0, align 2
  %i5 = sext i16 %i4 to i64
  %i6 = load i64, ptr @var_5, align 8
  %i7 = select i1 %i3, i64 %i6, i64 %i5
  %i8 = sext i16 %i4 to i32
  br i1 %i1, label %bb10, label %bb9

bb9:                                              ; preds = %bb
  store i32 1, ptr @arr_2, align 4
  store i16 %i4, ptr @arr_4, align 2
  store i32 %i8, ptr @arr_3, align 4
  store i32 1, ptr getelementptr inbounds ([0 x i32], ptr @arr_2, i64 0, i64 1), align 4
  store i16 %i4, ptr getelementptr inbounds ([0 x i16], ptr @arr_4, i64 0, i64 1), align 2
  store i32 %i8, ptr getelementptr inbounds ([8 x i32], ptr @arr_3, i64 0, i64 1), align 4
  br label %bb12

bb10:                                             ; preds = %bb
  %i11 = trunc i64 %i7 to i32
  store i32 %i11, ptr @arr_2, align 4
  store i16 %i4, ptr @arr_4, align 2
  store i32 %i8, ptr @arr_3, align 4
  store i32 %i11, ptr getelementptr inbounds ([0 x i32], ptr @arr_2, i64 0, i64 1), align 4
  store i16 %i4, ptr getelementptr inbounds ([0 x i16], ptr @arr_4, i64 0, i64 1), align 2
  store i32 %i8, ptr getelementptr inbounds ([8 x i32], ptr @arr_3, i64 0, i64 1), align 4
  br label %bb12

bb12:                                             ; preds = %bb10, %bb9
  ret void
}

define half @diff_types_same_width_merge(i1 %cond, half %a, i16 %b) {
; CHECK-LABEL: @diff_types_same_width_merge(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[BB0:%.*]], label [[BB1:%.*]]
; CHECK:       BB0:
; CHECK-NEXT:    br label [[SINK:%.*]]
; CHECK:       BB1:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast i16 [[B:%.*]] to half
; CHECK-NEXT:    br label [[SINK]]
; CHECK:       sink:
; CHECK-NEXT:    [[STOREMERGE:%.*]] = phi half [ [[TMP0]], [[BB1]] ], [ [[A:%.*]], [[BB0]] ]
; CHECK-NEXT:    ret half [[STOREMERGE]]
;
entry:
  %alloca = alloca half
  br i1 %cond, label %BB0, label %BB1
BB0:
  store half %a, ptr %alloca
  br label %sink
BB1:
  store i16 %b, ptr %alloca
  br label %sink
sink:
  %val = load half, ptr %alloca
  ret half %val
}

define i32 @diff_types_diff_width_no_merge(i1 %cond, i32 %a, i64 %b) {
; CHECK-LABEL: @diff_types_diff_width_no_merge(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ALLOCA:%.*]] = alloca i64, align 8
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[A:%.*]], label [[B:%.*]]
; CHECK:       A:
; CHECK-NEXT:    store i32 [[A:%.*]], ptr [[ALLOCA]], align 8
; CHECK-NEXT:    br label [[SINK:%.*]]
; CHECK:       B:
; CHECK-NEXT:    store i64 [[B:%.*]], ptr [[ALLOCA]], align 8
; CHECK-NEXT:    br label [[SINK]]
; CHECK:       sink:
; CHECK-NEXT:    [[VAL:%.*]] = load i32, ptr [[ALLOCA]], align 8
; CHECK-NEXT:    ret i32 [[VAL]]
;
entry:
  %alloca = alloca i64
  br i1 %cond, label %A, label %B
A:
  store i32 %a, ptr %alloca
  br label %sink
B:
  store i64 %b, ptr %alloca
  br label %sink
sink:
  %val = load i32, ptr %alloca
  ret i32 %val
}

define <4 x i32> @vec_no_merge(i1 %cond, <2 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: @vec_no_merge(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ALLOCA:%.*]] = alloca i64, align 16
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[A:%.*]], label [[B:%.*]]
; CHECK:       A:
; CHECK-NEXT:    store <2 x i32> [[A:%.*]], ptr [[ALLOCA]], align 16
; CHECK-NEXT:    br label [[SINK:%.*]]
; CHECK:       B:
; CHECK-NEXT:    store <4 x i32> [[B:%.*]], ptr [[ALLOCA]], align 16
; CHECK-NEXT:    br label [[SINK]]
; CHECK:       sink:
; CHECK-NEXT:    [[VAL:%.*]] = load <4 x i32>, ptr [[ALLOCA]], align 16
; CHECK-NEXT:    ret <4 x i32> [[VAL]]
;
entry:
  %alloca = alloca i64
  br i1 %cond, label %A, label %B
A:
  store <2 x i32> %a, ptr %alloca
  br label %sink
B:
  store <4 x i32> %b, ptr %alloca
  br label %sink
sink:
  %val = load <4 x i32>, ptr %alloca
  ret <4 x i32> %val
}

%struct.half = type { half };

define %struct.half @one_elem_struct_merge(i1 %cond, %struct.half %a, half %b) {
; CHECK-LABEL: @one_elem_struct_merge(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[BB0:%.*]], label [[BB1:%.*]]
; CHECK:       BB0:
; CHECK-NEXT:    [[TMP0:%.*]] = extractvalue [[STRUCT_HALF:%.*]] [[A:%.*]], 0
; CHECK-NEXT:    br label [[SINK:%.*]]
; CHECK:       BB1:
; CHECK-NEXT:    br label [[SINK]]
; CHECK:       sink:
; CHECK-NEXT:    [[STOREMERGE:%.*]] = phi half [ [[TMP0]], [[BB0]] ], [ [[B:%.*]], [[BB1]] ]
; CHECK-NEXT:    [[VAL1:%.*]] = insertvalue [[STRUCT_HALF]] poison, half [[STOREMERGE]], 0
; CHECK-NEXT:    ret [[STRUCT_HALF]] [[VAL1]]
;
entry:
  %alloca = alloca i64
  br i1 %cond, label %BB0, label %BB1
BB0:
  store %struct.half %a, ptr %alloca
  br label %sink
BB1:
  store half %b, ptr %alloca
  br label %sink
sink:
  %val = load %struct.half, ptr %alloca
  ret %struct.half %val
}

%struct.tup = type { half, i32 };

define %struct.tup @multi_elem_struct_no_merge(i1 %cond, %struct.tup %a, half %b) {
; CHECK-LABEL: @multi_elem_struct_no_merge(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ALLOCA:%.*]] = alloca i64, align 8
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[A:%.*]], label [[B:%.*]]
; CHECK:       A:
; CHECK-NEXT:    store [[STRUCT_TUP:%.*]] [[A:%.*]], ptr [[ALLOCA]], align 8
; CHECK-NEXT:    br label [[SINK:%.*]]
; CHECK:       B:
; CHECK-NEXT:    store half [[B:%.*]], ptr [[ALLOCA]], align 8
; CHECK-NEXT:    br label [[SINK]]
; CHECK:       sink:
; CHECK-NEXT:    [[VAL:%.*]] = load [[STRUCT_TUP]], ptr [[ALLOCA]], align 8
; CHECK-NEXT:    ret [[STRUCT_TUP]] [[VAL]]
;
entry:
  %alloca = alloca i64
  br i1 %cond, label %A, label %B
A:
  store %struct.tup %a, ptr %alloca
  br label %sink
B:
  store half %b, ptr %alloca
  br label %sink
sink:
  %val = load %struct.tup, ptr %alloca
  ret %struct.tup %val
}

define i16 @same_types_diff_align_no_merge(i1 %cond, i16 %a, i16 %b) {
; CHECK-LABEL: @same_types_diff_align_no_merge(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ALLOCA:%.*]] = alloca i16, align 4
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[BB0:%.*]], label [[BB1:%.*]]
; CHECK:       BB0:
; CHECK-NEXT:    store i16 [[A:%.*]], ptr [[ALLOCA]], align 8
; CHECK-NEXT:    br label [[SINK:%.*]]
; CHECK:       BB1:
; CHECK-NEXT:    store i16 [[B:%.*]], ptr [[ALLOCA]], align 4
; CHECK-NEXT:    br label [[SINK]]
; CHECK:       sink:
; CHECK-NEXT:    [[VAL:%.*]] = load i16, ptr [[ALLOCA]], align 4
; CHECK-NEXT:    ret i16 [[VAL]]
;
entry:
  %alloca = alloca i16, align 4
  br i1 %cond, label %BB0, label %BB1
BB0:
  store i16 %a, ptr %alloca, align 8
  br label %sink
BB1:
  store i16 %b, ptr %alloca, align 4
  br label %sink
sink:
  %val = load i16, ptr %alloca
  ret i16 %val
}

define i64 @ptrtoint_merge(i1 %cond, i64 %a, ptr %b) {
; CHECK-LABEL: @ptrtoint_merge(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[BB0:%.*]], label [[BB1:%.*]]
; CHECK:       BB0:
; CHECK-NEXT:    br label [[SINK:%.*]]
; CHECK:       BB1:
; CHECK-NEXT:    [[TMP0:%.*]] = ptrtoint ptr [[B:%.*]] to i64
; CHECK-NEXT:    br label [[SINK]]
; CHECK:       sink:
; CHECK-NEXT:    [[STOREMERGE:%.*]] = phi i64 [ [[A:%.*]], [[BB0]] ], [ [[TMP0]], [[BB1]] ]
; CHECK-NEXT:    ret i64 [[STOREMERGE]]
;
entry:
  %alloca = alloca ptr
  br i1 %cond, label %BB0, label %BB1
BB0:
  store i64 %a, ptr %alloca
  br label %sink
BB1:
  store ptr %b, ptr %alloca
  br label %sink
sink:
  %val = load i64, ptr %alloca
  ret i64 %val
}

define ptr @inttoptr_merge(i1 %cond, i64 %a, ptr %b) {
; CHECK-LABEL: define ptr @inttoptr_merge
; CHECK-SAME: (i1 [[COND:%.*]], i64 [[A:%.*]], ptr [[B:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND]], label [[BB0:%.*]], label [[BB1:%.*]]
; CHECK:       BB0:
; CHECK-NEXT:    [[TMP0:%.*]] = inttoptr i64 [[A]] to ptr
; CHECK-NEXT:    br label [[SINK:%.*]]
; CHECK:       BB1:
; CHECK-NEXT:    br label [[SINK]]
; CHECK:       sink:
; CHECK-NEXT:    [[STOREMERGE:%.*]] = phi ptr [ [[B]], [[BB1]] ], [ [[TMP0]], [[BB0]] ]
; CHECK-NEXT:    ret ptr [[STOREMERGE]]
;
entry:
  %alloca = alloca ptr
  br i1 %cond, label %BB0, label %BB1
BB0:
  store i64 %a, ptr %alloca, align 8
  br label %sink
BB1:
  store ptr %b, ptr %alloca, align 8
  br label %sink
sink:
  %val = load ptr, ptr %alloca
  ret ptr %val
}
